"""Test imports of python scripts by running -h"""

from pathlib import Path
from subprocess import run


def test_python_helps(install_root: Path):
    for path in install_root.iterdir():
        if not path.is_file():
            continue
        data = path.read_text('utf-8', errors='surrogateescape')
        first_line = data[: data.find('\n')]
        if not first_line.startswith('#!') or 'python3' not in first_line:
            continue
        if 'ArgumentParser(' not in data:
            continue
        run([str(path), '-h'], check=True)
