"""Pytest fixtures"""

import os
import shutil
import pytest
import rads

CONF = "/usr/local/cpanel/whostmgr/etc/imhapi/ra-metric.conf"

# pylint:disable=redefined-outer-name


@pytest.fixture
def allow_local():
    """Add 127.0.0.1 to /usr/local/cpanel/whostmgr/etc/imhapi/ra-metric.conf
    under authorized_ips"""
    shutil.copy(CONF, f"{CONF}.bak")
    with open(CONF, encoding='utf-8') as file:
        data = file.read().splitlines(keepends=True)
    with open(CONF, 'w', encoding='utf-8') as file:
        for line in data:
            if line.startswith('authorized_ips='):
                line = f"{line.rstrip()},127.0.0.1\n"
            file.write(line)
    yield
    os.rename(f"{CONF}.bak", CONF)


@pytest.fixture
def access_hash():
    """Read /root/.accesshash or raise IOError"""
    with open('/root/.accesshash', encoding='utf-8') as hash_file:
        hash_lines = hash_file.read().splitlines()
    return ''.join(hash_lines)


@pytest.fixture
def username():
    """Pick a username to run tests against"""
    return 'hubhost' if rads.IMH_CLASS == 'hub' else 'inmotion'
