"""Tests the WHM plugin by performing a request to it"""

import requests
import urllib3

# pylint:disable=unused-argument


def test_fetching_usage(access_hash, username, allow_local):
    """Tests the WHM plugin by performing a request to it"""
    req = _request(access_hash, username)
    assert req.status_code == 200
    assert req.json()['status'] == 0


def test_acl(access_hash, username):
    """Tests that the authorized_ips setting works by making a request from
    127.0.0.1 without allowing it"""
    req = _request(access_hash, username)
    assert req.status_code == 200
    # 2 means unauthorized IP
    assert req.json()['status'] == 2


def _request(access_hash, username):
    urllib3.disable_warnings()
    return requests.get(
        'https://127.0.0.1:2087/cgi/imhapi/ra-metric.cgi',
        headers={'Authorization': f'WHM root:{access_hash}'},
        params={'user': username},
        verify=False,
        timeout=10.0,
    )
