CREATE TABLE `frk_country` (
  `countryId` char(2) NOT NULL default '',
  `name` varchar(100) NOT NULL default '',
  PRIMARY KEY  (`countryId`)
) TYPE=MyISAM;
INSERT INTO `frk_country` VALUES ('AF', 'Afghanistan');
INSERT INTO `frk_country` VALUES ('AL', 'Albania');
INSERT INTO `frk_country` VALUES ('DZ', 'Algeria');
INSERT INTO `frk_country` VALUES ('AS', 'American samoa');
INSERT INTO `frk_country` VALUES ('AD', 'Andorra');
INSERT INTO `frk_country` VALUES ('AO', 'Angola');
INSERT INTO `frk_country` VALUES ('AI', 'Anguilla');
INSERT INTO `frk_country` VALUES ('AQ', 'Antarctica');
INSERT INTO `frk_country` VALUES ('AG', 'Antigua and barbuda');
INSERT INTO `frk_country` VALUES ('AR', 'Argentina');
INSERT INTO `frk_country` VALUES ('AM', 'Armenia');
INSERT INTO `frk_country` VALUES ('AW', 'Aruba');
INSERT INTO `frk_country` VALUES ('AU', 'Australia');
INSERT INTO `frk_country` VALUES ('AT', 'Austria');
INSERT INTO `frk_country` VALUES ('AZ', 'Azerbaijan');
INSERT INTO `frk_country` VALUES ('BS', 'Bahamas');
INSERT INTO `frk_country` VALUES ('BH', 'Bahrain');
INSERT INTO `frk_country` VALUES ('BD', 'Bangladesh');
INSERT INTO `frk_country` VALUES ('BB', 'Barbados');
INSERT INTO `frk_country` VALUES ('BY', 'Belarus');
INSERT INTO `frk_country` VALUES ('BE', 'Belgium');
INSERT INTO `frk_country` VALUES ('BZ', 'Belize');
INSERT INTO `frk_country` VALUES ('BJ', 'Benin');
INSERT INTO `frk_country` VALUES ('BM', 'Bermuda');
INSERT INTO `frk_country` VALUES ('BT', 'Bhutan');
INSERT INTO `frk_country` VALUES ('BO', 'Bolivia');
INSERT INTO `frk_country` VALUES ('BA', 'Bosnia and herzegovina');
INSERT INTO `frk_country` VALUES ('BW', 'Botswana');
INSERT INTO `frk_country` VALUES ('BV', 'Bouvet island');
INSERT INTO `frk_country` VALUES ('BR', 'Brazil');
INSERT INTO `frk_country` VALUES ('IO', 'British indian ocean territory');
INSERT INTO `frk_country` VALUES ('BN', 'Brunei darussalam');
INSERT INTO `frk_country` VALUES ('BG', 'Bulgaria');
INSERT INTO `frk_country` VALUES ('BF', 'Burkina faso');
INSERT INTO `frk_country` VALUES ('BI', 'Burundi');
INSERT INTO `frk_country` VALUES ('KH', 'Cambodia');
INSERT INTO `frk_country` VALUES ('CM', 'Cameroon');
INSERT INTO `frk_country` VALUES ('CA', 'Canada');
INSERT INTO `frk_country` VALUES ('CV', 'Cape verde');
INSERT INTO `frk_country` VALUES ('KY', 'Cayman islands');
INSERT INTO `frk_country` VALUES ('CF', 'Central african republic');
INSERT INTO `frk_country` VALUES ('TD', 'Chad');
INSERT INTO `frk_country` VALUES ('CL', 'Chile');
INSERT INTO `frk_country` VALUES ('CN', 'China');
INSERT INTO `frk_country` VALUES ('CX', 'Christmas island');
INSERT INTO `frk_country` VALUES ('CC', 'Cocos (keeling) islands');
INSERT INTO `frk_country` VALUES ('CO', 'Colombia');
INSERT INTO `frk_country` VALUES ('KM', 'Comoros');
INSERT INTO `frk_country` VALUES ('CG', 'Congo');
INSERT INTO `frk_country` VALUES ('CD', 'Congo');
INSERT INTO `frk_country` VALUES ('CK', 'Cook islands');
INSERT INTO `frk_country` VALUES ('CR', 'Costa rica');
INSERT INTO `frk_country` VALUES ('CI', 'Cote d''ivoire');
INSERT INTO `frk_country` VALUES ('HR', 'Croatia');
INSERT INTO `frk_country` VALUES ('CU', 'Cuba');
INSERT INTO `frk_country` VALUES ('CY', 'Cyprus');
INSERT INTO `frk_country` VALUES ('CZ', 'Czech republic');
INSERT INTO `frk_country` VALUES ('DK', 'Denmark');
INSERT INTO `frk_country` VALUES ('DJ', 'Djibouti');
INSERT INTO `frk_country` VALUES ('DM', 'Dominica');
INSERT INTO `frk_country` VALUES ('DO', 'Dominican republic');
INSERT INTO `frk_country` VALUES ('TP', 'East timor');
INSERT INTO `frk_country` VALUES ('EC', 'Ecuador');
INSERT INTO `frk_country` VALUES ('EG', 'Egypt');
INSERT INTO `frk_country` VALUES ('SV', 'El salvador');
INSERT INTO `frk_country` VALUES ('GQ', 'Equatorial guinea');
INSERT INTO `frk_country` VALUES ('ER', 'Eritrea');
INSERT INTO `frk_country` VALUES ('EE', 'Estonia');
INSERT INTO `frk_country` VALUES ('ET', 'Ethiopia');
INSERT INTO `frk_country` VALUES ('FK', 'Falkland islands (malvinas)');
INSERT INTO `frk_country` VALUES ('FO', 'Faroe islands');
INSERT INTO `frk_country` VALUES ('FJ', 'Fiji');
INSERT INTO `frk_country` VALUES ('FI', 'Finland');
INSERT INTO `frk_country` VALUES ('FR', 'France');
INSERT INTO `frk_country` VALUES ('GF', 'French guiana');
INSERT INTO `frk_country` VALUES ('PF', 'French polynesia');
INSERT INTO `frk_country` VALUES ('TF', 'French southern territories');
INSERT INTO `frk_country` VALUES ('GA', 'Gabon');
INSERT INTO `frk_country` VALUES ('GM', 'Gambia');
INSERT INTO `frk_country` VALUES ('GE', 'Georgia');
INSERT INTO `frk_country` VALUES ('DE', 'Germany');
INSERT INTO `frk_country` VALUES ('GH', 'Ghana');
INSERT INTO `frk_country` VALUES ('GI', 'Gibraltar');
INSERT INTO `frk_country` VALUES ('GR', 'Greece');
INSERT INTO `frk_country` VALUES ('GL', 'Greenland');
INSERT INTO `frk_country` VALUES ('GD', 'Grenada');
INSERT INTO `frk_country` VALUES ('GP', 'Guadeloupe');
INSERT INTO `frk_country` VALUES ('GU', 'Guam');
INSERT INTO `frk_country` VALUES ('GT', 'Guatemala');
INSERT INTO `frk_country` VALUES ('GN', 'Guinea');
INSERT INTO `frk_country` VALUES ('GW', 'Guinea-bissau');
INSERT INTO `frk_country` VALUES ('GY', 'Guyana');
INSERT INTO `frk_country` VALUES ('HT', 'Haiti');
INSERT INTO `frk_country` VALUES ('HM', 'Heard and mcdonald islands');
INSERT INTO `frk_country` VALUES ('VA', 'Holy see (vatican city state)');
INSERT INTO `frk_country` VALUES ('HN', 'Honduras');
INSERT INTO `frk_country` VALUES ('HK', 'Hong kong');
INSERT INTO `frk_country` VALUES ('HU', 'Hungary');
INSERT INTO `frk_country` VALUES ('IS', 'Iceland');
INSERT INTO `frk_country` VALUES ('IN', 'India');
INSERT INTO `frk_country` VALUES ('ID', 'Indonesia');
INSERT INTO `frk_country` VALUES ('IR', 'Iran, islamic republic of');
INSERT INTO `frk_country` VALUES ('IQ', 'Iraq');
INSERT INTO `frk_country` VALUES ('IE', 'Ireland');
INSERT INTO `frk_country` VALUES ('IL', 'Israel');
INSERT INTO `frk_country` VALUES ('IT', 'Italy');
INSERT INTO `frk_country` VALUES ('JM', 'Jamaica');
INSERT INTO `frk_country` VALUES ('JP', 'Japan');
INSERT INTO `frk_country` VALUES ('JO', 'Jordan');
INSERT INTO `frk_country` VALUES ('KZ', 'Kazakstan');
INSERT INTO `frk_country` VALUES ('KE', 'Kenya');
INSERT INTO `frk_country` VALUES ('KI', 'Kiribati');
INSERT INTO `frk_country` VALUES ('KP', 'Korea, democratic');
INSERT INTO `frk_country` VALUES ('KR', 'Korea, republic of');
INSERT INTO `frk_country` VALUES ('KW', 'Kuwait');
INSERT INTO `frk_country` VALUES ('KG', 'Kyrgyzstan');
INSERT INTO `frk_country` VALUES ('LA', 'Laos');
INSERT INTO `frk_country` VALUES ('LV', 'Latvia');
INSERT INTO `frk_country` VALUES ('LB', 'Lebanon');
INSERT INTO `frk_country` VALUES ('LS', 'Lesotho');
INSERT INTO `frk_country` VALUES ('LR', 'Liberia');
INSERT INTO `frk_country` VALUES ('LY', 'Libyan arab jamahiriya');
INSERT INTO `frk_country` VALUES ('LI', 'Liechtenstein');
INSERT INTO `frk_country` VALUES ('LT', 'Lithuania');
INSERT INTO `frk_country` VALUES ('LU', 'Luxembourg');
INSERT INTO `frk_country` VALUES ('MO', 'Macau');
INSERT INTO `frk_country` VALUES ('MK', 'Macedonia');
INSERT INTO `frk_country` VALUES ('MG', 'Madagascar');
INSERT INTO `frk_country` VALUES ('MW', 'Malawi');
INSERT INTO `frk_country` VALUES ('MY', 'Malaysia');
INSERT INTO `frk_country` VALUES ('MV', 'Maldives');
INSERT INTO `frk_country` VALUES ('ML', 'Mali');
INSERT INTO `frk_country` VALUES ('MT', 'Malta');
INSERT INTO `frk_country` VALUES ('MH', 'Marshall islands');
INSERT INTO `frk_country` VALUES ('MQ', 'Martinique');
INSERT INTO `frk_country` VALUES ('MR', 'Mauritania');
INSERT INTO `frk_country` VALUES ('MU', 'Mauritius');
INSERT INTO `frk_country` VALUES ('YT', 'Mayotte');
INSERT INTO `frk_country` VALUES ('MX', 'Mexico');
INSERT INTO `frk_country` VALUES ('FM', 'Micronesia');
INSERT INTO `frk_country` VALUES ('MD', 'Moldova, republic of');
INSERT INTO `frk_country` VALUES ('MC', 'Monaco');
INSERT INTO `frk_country` VALUES ('MN', 'Mongolia');
INSERT INTO `frk_country` VALUES ('MS', 'Montserrat');
INSERT INTO `frk_country` VALUES ('MA', 'Morocco');
INSERT INTO `frk_country` VALUES ('MZ', 'Mozambique');
INSERT INTO `frk_country` VALUES ('MM', 'Myanmar');
INSERT INTO `frk_country` VALUES ('NA', 'Namibia');
INSERT INTO `frk_country` VALUES ('NR', 'Nauru');
INSERT INTO `frk_country` VALUES ('NP', 'Nepal');
INSERT INTO `frk_country` VALUES ('NL', 'Netherlands');
INSERT INTO `frk_country` VALUES ('AN', 'Netherlands antilles');
INSERT INTO `frk_country` VALUES ('NC', 'New caledonia');
INSERT INTO `frk_country` VALUES ('NZ', 'New zealand');
INSERT INTO `frk_country` VALUES ('NI', 'Nicaragua');
INSERT INTO `frk_country` VALUES ('NE', 'Niger');
INSERT INTO `frk_country` VALUES ('NG', 'Nigeria');
INSERT INTO `frk_country` VALUES ('NU', 'Niue');
INSERT INTO `frk_country` VALUES ('NF', 'Norfolk island');
INSERT INTO `frk_country` VALUES ('MP', 'Northern mariana islands');
INSERT INTO `frk_country` VALUES ('NO', 'Norway');
INSERT INTO `frk_country` VALUES ('OM', 'Oman');
INSERT INTO `frk_country` VALUES ('PK', 'Pakistan');
INSERT INTO `frk_country` VALUES ('PW', 'Palau');
INSERT INTO `frk_country` VALUES ('PS', 'Palestinian territory');
INSERT INTO `frk_country` VALUES ('PA', 'Panama');
INSERT INTO `frk_country` VALUES ('PG', 'Papua new guinea');
INSERT INTO `frk_country` VALUES ('PY', 'Paraguay');
INSERT INTO `frk_country` VALUES ('PE', 'Peru');
INSERT INTO `frk_country` VALUES ('PH', 'Philippines');
INSERT INTO `frk_country` VALUES ('PN', 'Pitcairn');
INSERT INTO `frk_country` VALUES ('PL', 'Poland');
INSERT INTO `frk_country` VALUES ('PT', 'Portugal');
INSERT INTO `frk_country` VALUES ('PR', 'Puerto rico');
INSERT INTO `frk_country` VALUES ('QA', 'Qatar');
INSERT INTO `frk_country` VALUES ('RE', 'Reunion');
INSERT INTO `frk_country` VALUES ('RO', 'Romania');
INSERT INTO `frk_country` VALUES ('RU', 'Russian federation');
INSERT INTO `frk_country` VALUES ('RW', 'Rwanda');
INSERT INTO `frk_country` VALUES ('SH', 'Saint helena');
INSERT INTO `frk_country` VALUES ('KN', 'Saint kitts and nevis');
INSERT INTO `frk_country` VALUES ('LC', 'Saint lucia');
INSERT INTO `frk_country` VALUES ('PM', 'Saint pierre and miquelon');
INSERT INTO `frk_country` VALUES ('VC', 'Saint vincent and the grenadines');
INSERT INTO `frk_country` VALUES ('WS', 'Samoa');
INSERT INTO `frk_country` VALUES ('SM', 'San marino');
INSERT INTO `frk_country` VALUES ('ST', 'Sao tome and principe');
INSERT INTO `frk_country` VALUES ('SA', 'Saudi arabia');
INSERT INTO `frk_country` VALUES ('SN', 'Senegal');
INSERT INTO `frk_country` VALUES ('SC', 'Seychelles');
INSERT INTO `frk_country` VALUES ('SL', 'Sierra leone');
INSERT INTO `frk_country` VALUES ('SG', 'Singapore');
INSERT INTO `frk_country` VALUES ('SK', 'Slovakia');
INSERT INTO `frk_country` VALUES ('SI', 'Slovenia');
INSERT INTO `frk_country` VALUES ('SB', 'Solomon islands');
INSERT INTO `frk_country` VALUES ('SO', 'Somalia');
INSERT INTO `frk_country` VALUES ('ZA', 'South africa');
INSERT INTO `frk_country` VALUES ('GS', 'South georgia');
INSERT INTO `frk_country` VALUES ('ES', 'Spain');
INSERT INTO `frk_country` VALUES ('LK', 'Sri lanka');
INSERT INTO `frk_country` VALUES ('SD', 'Sudan');
INSERT INTO `frk_country` VALUES ('SR', 'Suriname');
INSERT INTO `frk_country` VALUES ('SJ', 'Svalbard and jan mayen');
INSERT INTO `frk_country` VALUES ('SZ', 'Swaziland');
INSERT INTO `frk_country` VALUES ('SE', 'Sweden');
INSERT INTO `frk_country` VALUES ('CH', 'Switzerland');
INSERT INTO `frk_country` VALUES ('SY', 'Syrian arab republic');
INSERT INTO `frk_country` VALUES ('TW', 'Taiwan, province of china');
INSERT INTO `frk_country` VALUES ('TJ', 'Tajikistan');
INSERT INTO `frk_country` VALUES ('TZ', 'Tanzania, united republic of');
INSERT INTO `frk_country` VALUES ('TH', 'Thailand');
INSERT INTO `frk_country` VALUES ('TG', 'Togo');
INSERT INTO `frk_country` VALUES ('TK', 'Tokelau');
INSERT INTO `frk_country` VALUES ('TO', 'Tonga');
INSERT INTO `frk_country` VALUES ('TT', 'Trinidad and tobago');
INSERT INTO `frk_country` VALUES ('TN', 'Tunisia');
INSERT INTO `frk_country` VALUES ('TR', 'Turkey');
INSERT INTO `frk_country` VALUES ('TM', 'Turkmenistan');
INSERT INTO `frk_country` VALUES ('TC', 'Turks and caicos islands');
INSERT INTO `frk_country` VALUES ('TV', 'Tuvalu');
INSERT INTO `frk_country` VALUES ('UG', 'Uganda');
INSERT INTO `frk_country` VALUES ('UA', 'Ukraine');
INSERT INTO `frk_country` VALUES ('AE', 'United Arab Emirates');
INSERT INTO `frk_country` VALUES ('GB', 'United Kingdom');
INSERT INTO `frk_country` VALUES ('US', 'United States');
INSERT INTO `frk_country` VALUES ('UM', 'United States minor islands');
INSERT INTO `frk_country` VALUES ('UY', 'Uruguay');
INSERT INTO `frk_country` VALUES ('UZ', 'Uzbekistan');
INSERT INTO `frk_country` VALUES ('VU', 'Vanuatu');
INSERT INTO `frk_country` VALUES ('VE', 'Venezuela');
INSERT INTO `frk_country` VALUES ('VN', 'Viet nam');
INSERT INTO `frk_country` VALUES ('VG', 'Virgin islands, british');
INSERT INTO `frk_country` VALUES ('VI', 'Virgin islands, u.s.');
INSERT INTO `frk_country` VALUES ('WF', 'Wallis and futuna');
INSERT INTO `frk_country` VALUES ('EH', 'Western sahara');
INSERT INTO `frk_country` VALUES ('YE', 'Yemen');
INSERT INTO `frk_country` VALUES ('YU', 'Yugoslavia');
INSERT INTO `frk_country` VALUES ('ZM', 'Zambia');
INSERT INTO `frk_country` VALUES ('ZW', 'Zimbabwe');

CREATE TABLE `frk_item` (
  `itemId` int(10) unsigned NOT NULL auto_increment,
  `projectId` mediumint(8) unsigned NOT NULL default '0',
  `itemParentId` int(10) unsigned NOT NULL default '0',
  `priority` tinyint(3) unsigned NOT NULL default '0',
  `context` varchar(80) NOT NULL default '',
  `title` varchar(255) NOT NULL default '',
  `description` text NOT NULL,
  `deadlineDate` date NOT NULL default '0000-00-00',
  `expectedDuration` smallint(5) unsigned NOT NULL default '0',
  `showInCalendar` tinyint(1) unsigned NOT NULL default '0',
  `showPrivate` tinyint(1) unsigned NOT NULL default '0',
  `memberId` mediumint(8) unsigned NOT NULL default '0',
  `authorId` mediumint(8) unsigned NOT NULL default '0',
  PRIMARY KEY  (`itemId`),
  KEY `projectId` (`projectId`),
  KEY `memberId` (`memberId`)
) TYPE=MyISAM;
INSERT INTO `frk_item` VALUES (1, 1, 0, 3, '1', 'Congratulations! This is your first task', 'First of all, read the README.txt if you haven''t done it yet.\r\n\r\nLots of informations in there.', '9999-00-00', 0, 0, 0, 1, 1);
INSERT INTO `frk_item` VALUES (2, 1, 0, 5, '1', 'How to create a user', 'To create a new user, go to menu <i>manage > users</i> \r\n\r\nthen click on the <img src="skins/redfreak/images/b_new.png" /> button.', '9999-00-00', 0, 0, 2, 1, 1);
INSERT INTO `frk_item` VALUES (3, 1, 0, 7, '4', 'Send some feedback', 'To send some feedback to the author, go to\r\n<a href="http://forum.taskfreak.com" target="_blank">http://forum.taskfreak.com</a>\r\n\r\nPlease remember you can donate by paypal on\r\n<a href="http://www.taskfreak.com" target="_blank">http://www.taskfreak.com</a>', '9999-00-00', 0, 0, 1, 1, 1);

CREATE TABLE `frk_itemComment` (
  `itemCommentId` bigint(20) unsigned NOT NULL auto_increment,
  `itemId` int(10) unsigned NOT NULL default '0',
  `memberId` mediumint(8) unsigned NOT NULL default '0',
  `postDate` datetime NOT NULL default '0000-00-00 00:00:00',
  `body` text NOT NULL,
  `lastChangeDate` datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (`itemCommentId`),
  KEY `taskId` (`itemId`)
) TYPE=MyISAM;

CREATE TABLE `frk_itemFile` (
  `itemFileId` bigint(20) unsigned NOT NULL auto_increment,
  `itemId` int(10) unsigned NOT NULL default '0',
  `memberId` mediumint(8) unsigned NOT NULL default '0',
  `fileTitle` varchar(200) NOT NULL default '',
  `filename` varchar(127) NOT NULL default '',
  `filetype` varchar(30) NOT NULL default '',
  `filesize` bigint(20) NOT NULL default '0',
  `postDate` datetime NOT NULL default '0000-00-00 00:00:00',
  `lastChangeDate` datetime NOT NULL default '0000-00-00 00:00:00',
  `fileTags` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`itemFileId`),
  KEY `taskId` (`itemId`)
) TYPE=MyISAM;

CREATE TABLE `frk_itemStatus` (
  `itemStatusId` bigint(20) unsigned NOT NULL auto_increment,
  `itemId` int(10) unsigned NOT NULL default '0',
  `statusDate` datetime NOT NULL default '0000-00-00 00:00:00',
  `statusKey` tinyint(3) unsigned NOT NULL default '0',
  `memberId` mediumint(8) unsigned NOT NULL default '0',
  PRIMARY KEY  (`itemStatusId`),
  KEY `itemId` (`itemId`)
) TYPE=MyISAM;
INSERT INTO `frk_itemStatus` VALUES (1, 1, '2006-06-01 00:00:00', 0, 1);
INSERT INTO `frk_itemStatus` VALUES (2, 2, '2006-06-01 00:00:00', 0, 1);
INSERT INTO `frk_itemStatus` VALUES (3, 3, '2006-06-01 00:00:00', 0, 1);

CREATE TABLE `frk_member` (
  `memberId` mediumint(8) unsigned NOT NULL auto_increment,
  `email` varchar(120) NOT NULL default '',
  `title` varchar(20) NOT NULL default '',
  `firstName` varchar(50) NOT NULL default '',
  `middleName` varchar(50) NOT NULL default '',
  `lastName` varchar(50) NOT NULL default '',
  `zipCode` varchar(20) NOT NULL default '',
  `city` varchar(60) NOT NULL default '',
  `stateCode` char(2) NOT NULL default '',
  `countryId` char(2) NOT NULL default '',
  `phone` varchar(30) NOT NULL default '',
  `mobile` varchar(30) NOT NULL default '',
  `fax` varchar(30) NOT NULL default '',
  `username` varchar(20) NOT NULL default '',
  `password` varchar(60) NOT NULL default '',
  `salt` varchar(8) NOT NULL default '',
  `autoLogin` tinyint(1) NOT NULL default '0',
  `timeZone` smallint(6) NOT NULL default '0',
  `expirationDate` datetime NOT NULL default '0000-00-00 00:00:00',
  `lastLoginDate` datetime NOT NULL default '0000-00-00 00:00:00',
  `lastLoginAddress` varchar(60) NOT NULL default '',
  `creationDate` datetime NOT NULL default '0000-00-00 00:00:00',
  `lastChangeDate` datetime NOT NULL default '0000-00-00 00:00:00',
  `visits` mediumint(8) unsigned NOT NULL default '0',
  `badAccess` tinyint(3) unsigned NOT NULL default '0',
  `level` tinyint(3) unsigned NOT NULL default '0',
  `activation` varchar(16) NOT NULL default '',
  `authorId` mediumint(8) unsigned NOT NULL default '0',
  `enabled` tinyint(1) unsigned NOT NULL default '0',
  PRIMARY KEY  (`memberId`),
  KEY `username` (`username`)
) TYPE=MyISAM;
INSERT INTO `frk_member` VALUES (1, 'admin@taskfreak.com', 'Mr', 'Admin', '', 'Istrator', '', '', '', 'FR', '', '', '', 'admin', '', '12345678', 0, 7200, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', '2006-06-01 00:00:00', '0000-00-00 00:00:00', 0, 0, 4, '', 1, 1);

CREATE TABLE `frk_memberProject` (
  `memberId` mediumint(8) unsigned NOT NULL default '0',
  `projectId` mediumint(8) unsigned NOT NULL default '0',
  `position` tinyint(3) unsigned NOT NULL default '0',
  PRIMARY KEY  (`memberId`,`projectId`)
) TYPE=MyISAM;
INSERT INTO `frk_memberProject` VALUES (1, 1, 5);

CREATE TABLE `frk_project` (
  `projectId` mediumint(8) unsigned NOT NULL auto_increment,
  `name` varchar(120) NOT NULL default '',
  `description` text NOT NULL,
  PRIMARY KEY  (`projectId`)
) TYPE=MyISAM;
INSERT INTO `frk_project` VALUES (1, 'Your first project', '');

CREATE TABLE `frk_projectStatus` (
  `projectStatusId` int(10) unsigned NOT NULL auto_increment,
  `projectId` mediumint(10) unsigned NOT NULL default '0',
  `statusDate` datetime NOT NULL default '0000-00-00 00:00:00',
  `statusKey` tinyint(3) unsigned NOT NULL default '0',
  `memberId` mediumint(8) unsigned NOT NULL default '0',
  PRIMARY KEY  (`projectStatusId`),
  KEY `projectId` (`projectId`)
) TYPE=MyISAM;
INSERT INTO `frk_projectStatus` VALUES (1, 1, '2006-06-01 00:00:00', 0, 1);
