<?php

/*
 * TangoBB Language Entity.
 * Language: Spanish.
 * Thanks to https://github.com/jennifer-c-leveke
 */

$LANG = array(
    //Main Forum
    'bb' => array(
        'forum' => 'Foro',
        'members' => 'Miembros',
        'search' => 'Búsqueda',
        'edit_post_in' => 'Editar post en:',
        'new_thread_in' => 'Nuevo hilo en:',
        'new_reply_in' => 'Nueva respuesta en:',
        'new_report' => 'Nuevo reporte',
        'new_thread_breadcrumb' => 'Nuevo hilo',
        'edit_post_breadcrumb' => 'Editar post',
        'new_reply_breadcrumb' => 'Nueva Respuesta',
        'already_watched_thread' => 'Ya estás siguiendo este hilo.',
        'already_unwatched_thread' => 'Ya no estás siguiendo este hilo.',
        'watch_thread' => 'Sigues este hilo.',
        'unwatch_thread' => 'Ya no sigues este hilo.',
        'error_watching' => 'Error al seguir el hilo.',
        'error_unwatching' => 'Error al dejar de seguir el hilo.',
        'none' => 'Ninguno',
        'form' => array(
            'edit_post' => 'Editar post',
            'report' => 'Reporte',
            'report_reason' => 'Motivo'
        ),
        'conversations' => array(
            'my_conversations' => 'Mis conversaciones', // added by N8boy
            'page_conversations' => 'Conversaciones',
            'page_new' => 'Iniciar conversación',
            'page_reply' => 'Responder conversación:',
            'starter' => 'Iniciado por',
            'reciever' => 'enviar a',
            'by' => 'By:', // not needed anymore | N8boy
            'for' => 'For:', // not needed anymore | N8boy
            'form_to' => 'Para <small>Separado con una ","</small>',
            'form_send' => 'Enviar',
            'form_title' => 'Título',
            'form_reply' => 'Respuesta',
            'no_conversations' => 'Sin conversaciones.',
            'user_not_exist' => 'El usuario <strong>%username%</strong> no existe',
            'message_sent' => 'Tu mensaje para <strong>%username%</strong> ha sido enviado',
            'error_sending' => 'Error al enviar mensaje a <strong>%username%</strong>.',
            'error_sending_alt' => 'Error al enviar mensaje.'
        ),
        'members' => array(
            'home' => 'Miembros',
            'activate_account' => 'Activar cuenta',
            'account_activated' => '¡Tu cuenta ha sido activada! <a href="' . SITE_URL . '/members.php/cmd/signin">Registrarse</a> ahora.',
            'birthday' => 'Fecha de nacimiento',
            'error_activating' => 'Error al activar la cuenta. Intenta más tarde.',
            'forgot_password' => '¿Olvidaste tu contraseña?',
            'reset_password' => 'Restablecer contraseña',
            'error_request_password_reset' => 'Error en la solicitud para restablecer contraseña.',
            'form_reset_password' => 'Restablecer contraseña',
            'form_email' => 'E-mail',
            'form_password' => 'Contraseña',
            'form_confirm_password' => 'Confirmar contraseña',
            'form_username' => 'Nombre de usuario',
            'form_register' => 'Registrar',
            'password_reset_link_sent' => 'Se ha enviado un link a tu correo para restablecer la contraseña. Por favor solicita un nuevo restablecimiento de contraseña.',
            'error_password_reset_token_expired' => 'El token para restablecer la contraseña ha caducado. Por favor solicite un nuevo restablecimiento de contraseña.',
            'error_password_reset_token_unknown' => 'Token para restablecimiento de contraseña desconocido. Por favor utilice la URL del correo.',
            'error_password_reset_token_missing' => 'Falta token para restablecimiento de contraseña en la URL. Por favor utilice la URL del correo.',
            'error_password_reset' => 'Error al restablecer contraseña.',
            'password_reset_successful' => 'Tu contraseña ha sido restablecida.',
            'register' => 'Registrar',
            'password_different' => 'Contraseña diferente',
            'username_taken' => '¡Este nombre de usuario ya está en uso!',
            'space_user' => 'No se permite usar espacios en el nombre de usuario',
            'error_register' => 'Error al registrarte. Por favor intenta más tarde.',
            'register_successful' => '¡Has sido registrado con éxito! Ahora iniciando sesión...',
            'register_successful_email' => '¡Has sido registrado con éxito! Se te ha enviado un correo para verificar.',
            'register_message' => 'Al hacer clic en "Registrar", estarás de acuerdo en respetar las reglas del foro establecidas <a href="' . SITE_URL . '/members.php/cmd/rules">aquí</a>.',
            'register_disabled' => 'No es posible registrarte en este momento.',
            'log_in' => 'Iniciar sesión',
            'invalid_login' => 'Datos no válidos!',
            'login_success' => '¡Inicio de sesión con éxito! Haz clic <a href="' . SITE_URL . '">aquí</a> si la página no te redirecciona.',
            'email_not_activated' => 'Tu correo aún no ha sido activado.',
            'banned' => 'En estos momentos estás baneado del foro. Contacta al equipo para más detalles.<br />Fecha de incorporación: <b>%unban_date%</b><br />Motivo de baneo: <b>%ban_reason%</b>',
            'rules' => 'Reglas del foro',
            'rules_message' => 'Todos los usuarios deben respetar las reglas del foro.<br />%rules%<br />Si no sigues las reglas puede que tu post sea removido o editado; si esto sucede en reiteradas ocasiones se te puede prohibir el acceso temporal o permanente al foro.',
            'profile_of' => 'Perfil de',
            'posted_thread' => 'Postear un nuevo hilo <a href="%url%">%title%</a> <small>(%date%)</small><hr size="1" />',
            'replied_to' => 'Responder al hilo <a href="%url%">%title%</a> <small>(%date%)</small><hr size="1" />'
        ),
        'profile' => array(
            'profile' => 'Perfil',
            'avatar' => 'Avatar',
            'change_avatar' => 'Cambiar avatar <small>Máximo 500x500 Pixeles</small>',
            'use_gravatar' => 'Utilizar Gravatar',
            'form_save' => 'Guardar cambios',
            'error_adding_gravatar' => 'Error al añadir Gravatar. Intenta más tarde.',
            'successful_adding_gravatar' => '¡Tu Gravatar ha sido guardado con éxito!',
            'error_upload_avatar' => 'Error al subir avatar. Intenta más tarde.',
            'about_you' => 'Acerca de ti',
            'successful_upload_avatar' => '¡Tu avatar se ha guardado con éxito!',
            'password' => 'Contraseña',
            'current_password' => 'Contrasela actual',
            'new_password' => 'Nueva contraseña',
            'error_updaing_password' => 'Error al actualizar contraseña.',
            'signature' => 'Firma',
            'timezone' => 'Zona horaria',
            'location' => 'Ubicación',
            'error_updating_signature' => 'Error al actualizar firma. Intenta más tarde.',
            'personal_details' => 'Detalles personales',
            'confirm_password' => 'Confirmar contraseña',
            'change_theme' => 'Cambiar tema',
            'theme_set' => 'El tema ha sido establecido.',
            'theme_error' => 'Error al establecer el tema.',
            'theme_not_exist' => 'El tema no existe.',
            'gender' => 'Género',
            'female' => 'Femenino',
            'male' => 'Masculino',
            'not_telling' => 'No mencionar'
        )
    ),
    //Error Pages
    'error_pages' => array(
        '404' => array(
            'header' => '404',
            'message' => 'Lo sentimos, el recurso que estás buscando no ha sido encontrado.'
        )
    ),
    'errors' => array(
        'thread_tracker_insert' => 'Ha ocurrido un error en la creación del rastreador del hilo.',
        'thread_tracker_update' => 'Ha ocurrido un error en la actualización del rastreador del hilo.'
    ),
    //Global Form Variables
    'global_form_process' => array(
        'all_fields_required' => '¡Se requieren todos los campos!',
        'enter_search_query' => 'Por favor introduce una consulta',
        'error_updating_post' => 'Error al actualizar post. Intenta más tarde.',
        'error_creating_thread' => 'Error al crear hilo. Intenta más tarde.',
        'error_replying_thread' => 'Error al responder al hilo. Intenta más tarde.',
        'error_submitting_report' => 'Error al presentar el reporte. Intenta más tarde.',
        'thread_create_success' => '¡El hilo ha sido creado con éxito! Redireccionando...',
        'report_create_success' => '¡El reporte ha sido presentado con éxito!',
        'search_no_result' => 'Sin resultados.',
        'search_no_user' => 'No buscas un usuario.',
        'search_by' => 'Por',
        'different_message_previous' => 'Por favor escribe un mensaje diferente al de tu post anterior.',
        'email_not_exist' => '¡Este correo no existe en nuestros registros!',
        'email_used' => 'Este correo ya se ha utilizado, por favor usa uno nuevo.',
        'invalid_email' => '¡El correo no es válido!',
        'invalid_file_format' => '¡El formato del documento no es válido!',
        'img_dimension_limit' => '¡La dimensión de la imagen es muy grande!',
        'save_success' => 'Guardado',
        'error_saving' => 'Error al guardar. Intenta más tarde.',
        'invalid_password' => '¡La contraseña actual no es válida!',
        'captcha_incorrect' => '¡Captcha incorrecto!'
    ),
    //Email Variables.
    'email' => array(
        'forgot_password' => array(
            'subject' => 'Restablecer contraseña',
            'content' => '<p> Has solicitado la restauración de tu contraseña en %site_name%.</p><p>Para establecer una nueva contraseña, por favor utiliza la siguiente URL: %token_url%</p>'
        ),
        'register' => array(
            'subject' => 'Activación de cuenta',
            'content' => '<p>Te has registrado en %site_name%</p><p>Haz clic <a href="%activate_url%">aquí</a> para activar tu cuenta.</p>'
        ),
        'notify' => array(
            'more_info' => '<br />Haz clic <a href="%url%">aquí</a> para más información.'
        )
    ),
    //Moderator Panel
    'mod' => array(
        'ban' => array(
            'ban' => 'Usuario baneado',
            'ban_success' => 'El usuario ha sido baneado. <a href="%url%">Volver al perfil del usuario</a>.',
            'ban_error' => 'Error al banear al usuario.',
            'already_banned' => 'Usuario ya baneado.',
            'unban' => 'Incorporar usuario',
            'unban_success' => 'El usuario ha sido incorporado. <a href="%url%">Volver al perfil del usuario</a>.',
            'unban_error' => 'Error al incorporar usuario.',
            'already_unbanned' => 'El usuario ya ha sido incorporado.',
        ),
        'close' => array(
            'close' => 'Hilo cerrado',
            'close_success' => 'El hilo ha sido cerrado. <a href="%url%">Volver al hilo</a>.',
            'close_error' => 'Error al cerrar el hilo.',
            'already_closed' => 'El hilo ya se ha cerrado.',
            'open' => 'Abrir hilo',
            'open_success' => 'El hilo se ha abierto. <a href="%url%">Volver al hilo</a>.',
            'open_error' => 'Error al abrir el hilo.',
            'already_opened' => 'El hilo ya se ha abierto.'
        ),
        'stick' => array(
            'stick' => 'Pegar hilo',
            'stick_success' => 'Se ha pegado el hilo. <a href="%url%">Back to thread</a>.',
            'stick_error' => 'Error al pegar el hilo.',
            'already_stuck' => 'El hilo ya se ha pegado.',
            'unstick' => 'Despegar hilo',
            'unstick_success' => 'El hilo se ha despegado. <a href="%url%">Volver al hilo</a>.',
            'unstick_error' => 'Error al despegar el hilo.',
            'already_unstuck' => 'El hilo ya se ha despegado.'
        ),
        'reports' => array(
            'reports' => 'Reportes',
            'thread' => 'Hilo:',
            'user' => 'Usuario:',
            'reason' => 'Motivo:',
            'reported_time' => 'Hora del reporte:',
            'no_reports' => 'Por el momento no hay reportes.',
            'delete' => 'El reporte ha sido borrado.'
        ),
        'delete' => array(
            'delete' => 'Borrar post',
            'thread_deleted' => 'El hilo ha sido borrado.',
            'error_deleting' => 'Error al borrar el post.',
            'post_deleted' => 'El post ha sido borrado.'
        ),
        'move' => array(
            'move' => 'Mover hilo',
            'thread_moved' => 'Se ha movido el hilo. <a href="%url%">Volver al hilo</a>.',
            'error_moving' => 'Error al mover el hilo.'
        ),
        'del_report' => array(
            'delete' => 'Borrar reporte',
            'report_deleted' => 'El reporte ha sido borrado. <a href="%url%">Back</a>.',
            'error_deleting' => 'Error al borrar el post. <a href="%url%">Back</a>.'
        )
    ),
    'notification' => array(
        'mention' => '%username% te ha mencionado en un post!',
        'reply' => '%username% ha respondido al hilo <strong>%thread_title%</strong>',
        'quoted' => '%username% citó tu post en <strong>%thread_title%</strong>'
    ),
    'flat' => array(
        'merge_post' => '----------'
    ),
    'time' => array(
        'hours_ago' => 'hace %time% horas',
        'hour_ago' => 'hace %time% hora',
        'minutes_ago' => 'hace %time% minuto',
        'minute_ago' => 'hace %time% minutos',
        'just_now' => 'Ahora'
    ),
    // ISO 3166-1 Country codes
    'location' => array(
        '--' => 'Sin selección',
        'AD' => 'Andorra',
        'AE' => 'Emiratos Árabes unidos',
        'AF' => 'Afganistán',
        'AG' => 'Antigua y Barbuda',
        'AI' => 'Anguila',
        'AL' => 'Albania',
        'AM' => 'Armenia',
        'AO' => 'Angola',
        'AQ' => 'Antártida',
        'AR' => 'Argentina',
        'AS' => 'Samoa americana',
        'AT' => 'Austria',
        'AU' => 'Australia',
        'AW' => 'Aruba',
        'AX' => 'Islas Åland',
        'AZ' => 'Azerbaiyán',
        'BA' => 'Bosnia y Herzegovina',
        'BB' => 'Barbados',
        'BD' => 'Bangladés',
        'BE' => 'Bélgica',
        'BF' => 'Burkina Faso',
        'BG' => 'Bulgaria',
        'BH' => 'Baréin',
        'BI' => 'Burundi',
        'BJ' => 'Benín',
        'BL' => 'San Bartolomé',
        'BM' => 'Bermuda',
        'BN' => 'Brunéi',
        'BO' => 'Bolivia',
        'BQ' => 'Bonaire',
        'BR' => 'Brasil',
        'BS' => 'Bahamas',
        'BT' => 'Bután',
        'BV' => 'Isla Bouvet',
        'BW' => 'Botsuana',
        'BY' => 'Bielorrusia',
        'BZ' => 'Belice',
        'CA' => 'Canadá',
        'CC' => 'Islas Cocos',
        'CD' => 'República Democrática del Congo',
        'CF' => 'República Centroafricana',
        'CG' => 'República del Congo',
        'CH' => 'Suiza',
        'CI' => 'Costa de Marfil',
        'CK' => 'Islas Cook',
        'CL' => 'Chile',
        'CM' => 'Camerún',
        'CN' => 'China',
        'CO' => 'Colombia',
        'CR' => 'Costa Rica',
        'CU' => 'Cuba',
        'CV' => 'Cabo Verde',
        'CW' => 'Curazao',
        'CX' => 'Isla Navidad',
        'CY' => 'Chipre',
        'CZ' => 'República Checa',
        'DE' => 'Alemania',
        'DJ' => 'Yibuti',
        'DK' => 'Dinamarca',
        'DM' => 'Dominica',
        'DO' => 'República Dominicana',
        'DZ' => 'Argelia',
        'EC' => 'Ecuador',
        'EE' => 'Estonia',
        'EG' => 'Egipto',
        'EH' => 'Sahara Occidental',
        'ER' => 'Eritrea',
        'ES' => 'España',
        'ET' => 'Etiopía',
        'FI' => 'Finlandia',
        'FJ' => 'Fiji',
        'FK' => 'Islas Malvinas',
        'FM' => 'Micronesia',
        'FO' => 'Islas Faroe',
        'FR' => 'Francia',
        'GA' => 'Gabón',
        'GB' => 'Reino Unido',
        'GD' => 'Grenada',
        'GE' => 'Georgia',
        'GF' => 'Guayana Francesa',
        'GG' => 'Guernsey',
        'GH' => 'Ghana',
        'GI' => 'Gibraltar',
        'GL' => 'Groenlandia',
        'GM' => 'Gambia',
        'GN' => 'Guinea',
        'GP' => 'Guadelupe',
        'GQ' => 'Guinea Ecuatorial',
        'GR' => 'Grecia',
        'GS' => 'Islas Georgias del Sur y Sandwich del Sur',
        'GT' => 'Guatemala',
        'GU' => 'Guam',
        'GW' => 'Guinea-Bisáu',
        'GY' => 'Guyana',
        'HK' => 'Hong Kong',
        'HM' => 'Islas Heard y McDonald',
        'HN' => 'Honduras',
        'HR' => 'Croacia',
        'HT' => 'Haití',
        'HU' => 'Hungría',
        'ID' => 'Indonesia',
        'IE' => 'Irlanda',
        'IL' => 'Israel',
        'IM' => 'Islas de Man',
        'IN' => 'India',
        'IO' => 'Territorio Británico del Océano Índico',
        'IQ' => 'Irak',
        'IR' => 'Irán',
        'IS' => 'Islandia',
        'IT' => 'Italia',
        'JE' => 'Jersey',
        'JM' => 'Jamaica',
        'JO' => 'Jordán',
        'JP' => 'Japón',
        'KE' => 'Kenia',
        'KG' => 'Kirguistán',
        'KH' => 'Camboya',
        'KI' => 'Kiribati',
        'KM' => 'Comoras',
        'KN' => 'San Cristóbal y Nieves',
        'KP' => 'Corea del Norte',
        'KR' => 'Corea del Sur',
        'KW' => 'Kuwait',
        'KY' => 'Islas Caimán',
        'KZ' => 'Kazajistán',
        'LA' => 'Laos',
        'LB' => 'Líbano',
        'LC' => 'Santa Lucía',
        'LI' => 'Liechtenstein',
        'LK' => 'Sri Lanka',
        'LR' => 'Liberia',
        'LS' => 'Lesoto',
        'LT' => 'Lituania',
        'LU' => 'Luxemburgo',
        'LV' => 'Letonia',
        'LY' => 'Libia',
        'MA' => 'Marruecos',
        'MC' => 'Mónaco',
        'MD' => 'Moldavia',
        'ME' => 'Montenegro',
        'MF' => 'San Martín',
        'MG' => 'Madagascar',
        'MH' => 'Islas Marshall',
        'MK' => 'Macedonia',
        'ML' => 'Malí',
        'MM' => 'Birmania',
        'MN' => 'Mongolia',
        'MO' => 'Macao',
        'MP' => 'Islas Marianas del Norte',
        'MQ' => 'Martinica',
        'MR' => 'Mauritania',
        'MS' => 'Montserrat',
        'MT' => 'Malta',
        'MU' => 'Mauricio',
        'MV' => 'Maldivas',
        'MW' => 'Malaui',
        'MX' => 'México',
        'MY' => 'Malasia',
        'MZ' => 'Mozambique',
        'NA' => 'Namibia',
        'NC' => 'Nueva Caledonia',
        'NE' => 'Níger',
        'NF' => 'Islas Norfolk',
        'NG' => 'Nigeria',
        'NI' => 'Nicaragua',
        'NL' => 'Países Bajos',
        'NO' => 'Noruega',
        'NP' => 'Nepal',
        'NR' => 'Nauru',
        'NU' => 'Niue',
        'NZ' => 'Nueva Zelandia',
        'OM' => 'Omán',
        'PA' => 'Panamá',
        'PE' => 'Perú',
        'PF' => 'Polinesia Francesa',
        'PG' => 'Papua Nueva Guinea',
        'PH' => 'Filipinas',
        'PK' => 'Pakistán',
        'PL' => 'Polonia',
        'PM' => 'San Pedro y Miquelón',
        'PN' => 'Islas Pitcairn',
        'PR' => 'Puerto Rico',
        'PS' => 'Palestina',
        'PT' => 'Portugal',
        'PW' => 'Palaos',
        'PY' => 'Paraguay',
        'QA' => 'Catar',
        'RE' => 'Reunión',
        'RO' => 'Rumania',
        'RS' => 'Serbia',
        'RU' => 'Rusia',
        'RW' => 'Ruanda',
        'SA' => 'Arabia Saudita',
        'SB' => 'Islas Salomón',
        'SC' => 'Seychelles',
        'SD' => 'Sudán',
        'SE' => 'Suecia',
        'SG' => 'Singapur',
        'SH' => 'Santa Helena, Ascensión y Tristán de Acuña',
        'SI' => 'Eslovenia',
        'SJ' => 'Svalbard y Jan Mayen',
        'SK' => 'Eslovaquia',
        'SL' => 'Sierra Leona',
        'SM' => 'San Marino',
        'SN' => 'Senegal',
        'SO' => 'Somalia',
        'SR' => 'Surinam',
        'SS' => 'Sudán del sur',
        'ST' => 'Santo Tomé y Príncipe',
        'SV' => 'El Salvador',
        'SX' => 'Sint Maarten',
        'SY' => 'Siria',
        'SZ' => 'Suazilandia',
        'TC' => 'Islas Turcas y Caicos',
        'TD' => 'Chad',
        'TF' => 'Tierras Australes y Antárticas Francesas',
        'TG' => 'Togo',
        'TH' => 'Tailandia',
        'TJ' => 'Tayikistán',
        'TK' => 'Tokelau',
        'TL' => 'Timor Oriental',
        'TM' => 'Turkmenistán',
        'TN' => 'Túnez',
        'TO' => 'Tonga',
        'TR' => 'Turquía',
        'TT' => 'Trinidad y Tobago',
        'TV' => 'Tuvalu',
        'TW' => 'Taiwán',
        'TZ' => 'Tanzania',
        'UA' => 'Ucrania',
        'UG' => 'Uganda',
        'UM' => 'Islas Ultramarinas Menores de Estados Unidos',
        'US' => 'Estados Unidos',
        'UY' => 'Uruguay',
        'UZ' => 'Uzbekistán',
        'VA' => 'Santa Sede',
        'VC' => 'Venezuela',
        'VG' => 'Islas Vírgenes Británicas',
        'VI' => 'Islas Vírgenes de los Estados Unidos',
        'VN' => 'Vietnam',
        'VU' => 'Vanuatu',
        'WF' => 'Wallis y Futuna',
        'WS' => 'Samoa',
        'YE' => 'Yemen',
        'YT' => 'Mayotte',
        'ZA' => 'Sudáfrica',
        'ZM' => 'Zambia',
        'ZW' => 'Zimbabue'
    ),
    'date' => array(
        'month_1' => 'Enero',
        'month_2' => 'Febrero',
        'month_3' => 'Marzo',
        'month_4' => 'Abril',
        'month_5' => 'Mayo',
        'month_6' => 'Junio',
        'month_7' => 'Julio',
        'month_8' => 'Agosto',
        'month_9' => 'Septiembre',
        'month_10' => 'Octubre',
        'month_11' => 'Noviembre',
        'month_12' => 'Diciembre',
        'day_1' => 'Lunes',
        'day_2' => 'Martes',
        'day_3' => 'Miércoles',
        'day_4' => 'Jueves',
        'day_5' => 'Viernes',
        'day_6' => 'Sábado',
        'day_7' => 'Domingo'
    )
);

?>
