

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `tangobb151`
--


-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]countries`
--

CREATE TABLE `[[dbprefix]]countries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `iso` varchar(2) NOT NULL,
  `language` varchar(255) NOT NULL DEFAULT 'english',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=250 ;

--
-- Dumping data for table `[[dbprefix]]countries`
--

INSERT INTO `[[dbprefix]]countries` VALUES
(1, 'AD', 'english'),
(2, 'AE', 'english'),
(3, 'AF', 'english'),
(4, 'AG', 'english'),
(5, 'AI', 'english'),
(6, 'AL', 'english'),
(7, 'AM', 'english'),
(8, 'AO', 'english'),
(9, 'AQ', 'english'),
(10, 'AR', 'english'),
(11, 'AS', 'english'),
(12, 'AT', 'german'),
(13, 'AU', 'english'),
(14, 'AW', 'english'),
(15, 'AX', 'english'),
(16, 'AZ', 'english'),
(17, 'BA', 'english'),
(18, 'BB', 'english'),
(19, 'BD', 'english'),
(20, 'BE', 'english'),
(21, 'BF', 'english'),
(22, 'BG', 'english'),
(23, 'BH', 'english'),
(24, 'BI', 'english'),
(25, 'BJ', 'english'),
(26, 'BL', 'english'),
(27, 'BM', 'english'),
(28, 'BN', 'english'),
(29, 'BO', 'english'),
(30, 'BQ', 'english'),
(31, 'BR', 'english'),
(32, 'BS', 'english'),
(33, 'BT', 'english'),
(34, 'BV', 'english'),
(35, 'BW', 'english'),
(36, 'BY', 'english'),
(37, 'BZ', 'english'),
(38, 'CA', 'english'),
(39, 'CC', 'english'),
(40, 'CD', 'english'),
(41, 'CF', 'english'),
(42, 'CG', 'english'),
(43, 'CH', 'english'),
(44, 'CI', 'english'),
(45, 'CK', 'english'),
(46, 'CL', 'english'),
(47, 'CM', 'english'),
(48, 'CN', 'english'),
(49, 'CO', 'english'),
(50, 'CR', 'english'),
(51, 'CU', 'english'),
(52, 'CV', 'english'),
(53, 'CW', 'english'),
(54, 'CX', 'english'),
(55, 'CY', 'english'),
(56, 'CZ', 'english'),
(57, 'DE', 'german'),
(58, 'DJ', 'english'),
(59, 'DK', 'english'),
(60, 'DM', 'english'),
(61, 'DO', 'english'),
(62, 'DZ', 'english'),
(63, 'EC', 'english'),
(64, 'EE', 'english'),
(65, 'EG', 'english'),
(66, 'EH', 'english'),
(67, 'ER', 'english'),
(68, 'ES', 'english'),
(69, 'ET', 'english'),
(70, 'FI', 'english'),
(71, 'FJ', 'english'),
(72, 'FK', 'english'),
(73, 'FM', 'english'),
(74, 'FO', 'english'),
(75, 'FR', 'english'),
(76, 'GA', 'english'),
(77, 'GB', 'english'),
(78, 'GD', 'english'),
(79, 'GE', 'english'),
(80, 'GF', 'english'),
(81, 'GG', 'english'),
(82, 'GH', 'english'),
(83, 'GI', 'english'),
(84, 'GL', 'english'),
(85, 'GM', 'english'),
(86, 'GN', 'english'),
(87, 'GP', 'english'),
(88, 'GQ', 'english'),
(89, 'GR', 'english'),
(90, 'GS', 'english'),
(91, 'GT', 'english'),
(92, 'GU', 'english'),
(93, 'GW', 'english'),
(94, 'GY', 'english'),
(95, 'HK', 'english'),
(96, 'HM', 'english'),
(97, 'HN', 'english'),
(98, 'HR', 'english'),
(99, 'HT', 'english'),
(100, 'HU', 'english'),
(101, 'ID', 'english'),
(102, 'IE', 'english'),
(103, 'IL', 'english'),
(104, 'IM', 'english'),
(105, 'IN', 'english'),
(106, 'IO', 'english'),
(107, 'IQ', 'english'),
(108, 'IR', 'english'),
(109, 'IS', 'english'),
(110, 'IT', 'english'),
(111, 'JE', 'english'),
(112, 'JM', 'english'),
(113, 'JO', 'english'),
(114, 'JP', 'english'),
(115, 'KE', 'english'),
(116, 'KG', 'english'),
(117, 'KH', 'english'),
(118, 'KI', 'english'),
(119, 'KM', 'english'),
(120, 'KN', 'english'),
(121, 'KP', 'english'),
(122, 'KR', 'english'),
(123, 'KW', 'english'),
(124, 'KY', 'english'),
(125, 'KZ', 'english'),
(126, 'LA', 'english'),
(127, 'LB', 'english'),
(128, 'LC', 'english'),
(129, 'LI', 'english'),
(130, 'LK', 'english'),
(131, 'LR', 'english'),
(132, 'LS', 'english'),
(133, 'LT', 'english'),
(134, 'LU', 'english'),
(135, 'LV', 'english'),
(136, 'LY', 'english'),
(137, 'MA', 'english'),
(138, 'MC', 'english'),
(139, 'MD', 'english'),
(140, 'ME', 'english'),
(141, 'MF', 'english'),
(142, 'MG', 'english'),
(143, 'MH', 'english'),
(144, 'MK', 'english'),
(145, 'ML', 'english'),
(146, 'MM', 'english'),
(147, 'MN', 'english'),
(148, 'MO', 'english'),
(149, 'MP', 'english'),
(150, 'MQ', 'english'),
(151, 'MR', 'english'),
(152, 'MS', 'english'),
(153, 'MT', 'english'),
(154, 'MU', 'english'),
(155, 'MV', 'english'),
(156, 'MW', 'english'),
(157, 'MX', 'english'),
(158, 'MY', 'english'),
(159, 'MZ', 'english'),
(160, 'NA', 'english'),
(161, 'NC', 'english'),
(162, 'NE', 'english'),
(163, 'NF', 'english'),
(164, 'NG', 'english'),
(165, 'NI', 'english'),
(166, 'NL', 'english'),
(167, 'NO', 'english'),
(168, 'NP', 'english'),
(169, 'NR', 'english'),
(170, 'NU', 'english'),
(171, 'NZ', 'english'),
(172, 'OM', 'english'),
(173, 'PA', 'english'),
(174, 'PE', 'english'),
(175, 'PF', 'english'),
(176, 'PG', 'english'),
(177, 'PH', 'english'),
(178, 'PK', 'english'),
(179, 'PL', 'english'),
(180, 'PM', 'english'),
(181, 'PN', 'english'),
(182, 'PR', 'english'),
(183, 'PS', 'english'),
(184, 'PT', 'english'),
(185, 'PW', 'english'),
(186, 'PY', 'english'),
(187, 'QA', 'english'),
(188, 'RE', 'english'),
(189, 'RO', 'english'),
(190, 'RS', 'english'),
(191, 'RU', 'english'),
(192, 'RW', 'english'),
(193, 'SA', 'english'),
(194, 'SB', 'english'),
(195, 'SC', 'english'),
(196, 'SD', 'english'),
(197, 'SE', 'english'),
(198, 'SG', 'english'),
(199, 'SH', 'english'),
(200, 'SI', 'english'),
(201, 'SJ', 'english'),
(202, 'SK', 'english'),
(203, 'SL', 'english'),
(204, 'SM', 'english'),
(205, 'SN', 'english'),
(206, 'SO', 'english'),
(207, 'SR', 'english'),
(208, 'SS', 'english'),
(209, 'ST', 'english'),
(210, 'SV', 'english'),
(211, 'SX', 'english'),
(212, 'SY', 'english'),
(213, 'SZ', 'english'),
(214, 'TC', 'english'),
(215, 'TD', 'english'),
(216, 'TF', 'english'),
(217, 'TG', 'english'),
(218, 'TH', 'english'),
(219, 'TJ', 'english'),
(220, 'TK', 'english'),
(221, 'TL', 'english'),
(222, 'TM', 'english'),
(223, 'TN', 'english'),
(224, 'TO', 'english'),
(225, 'TR', 'english'),
(226, 'TT', 'english'),
(227, 'TV', 'english'),
(228, 'TW', 'english'),
(229, 'TZ', 'english'),
(230, 'UA', 'english'),
(231, 'UG', 'english'),
(232, 'UM', 'english'),
(233, 'US', 'english'),
(234, 'UY', 'english'),
(235, 'UZ', 'english'),
(236, 'VA', 'english'),
(237, 'VC', 'english'),
(238, 'VE', 'english'),
(239, 'VG', 'english'),
(240, 'VI', 'english'),
(241, 'VN', 'english'),
(242, 'VU', 'english'),
(243, 'WF', 'english'),
(244, 'WS', 'english'),
(245, 'YE', 'english'),
(246, 'YT', 'english'),
(247, 'ZA', 'english'),
(248, 'ZM', 'english'),
(249, 'ZW', 'english');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]extensions`
--

CREATE TABLE `[[dbprefix]]extensions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `extension_name` varchar(255) NOT NULL,
  `extension_folder` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]forum_category`
--

CREATE TABLE `[[dbprefix]]forum_category` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_title` varchar(255) NOT NULL,
  `category_desc` varchar(255) NOT NULL,
  `category_place` int(11) NOT NULL DEFAULT '0',
  `allowed_usergroups` varchar(255) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]forum_category`
--

INSERT INTO `[[dbprefix]]forum_category` VALUES
(1, 'First Category', 'First category on this forum!', 0, '0,1,3,4');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]forum_node`
--

CREATE TABLE `[[dbprefix]]forum_node` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `node_name` varchar(255) NOT NULL,
  `name_friendly` varchar(255) NOT NULL,
  `node_desc` varchar(255) NOT NULL,
  `in_category` int(11) NOT NULL DEFAULT '0',
  `node_type` int(11) NOT NULL DEFAULT '1',
  `parent_node` int(11) NOT NULL DEFAULT '0',
  `node_locked` int(11) NOT NULL DEFAULT '0',
  `node_place` int(11) NOT NULL DEFAULT '0',
  `allowed_usergroups` varchar(255) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]forum_node`
--

INSERT INTO `[[dbprefix]]forum_node` VALUES
(1, 'First Node', 'first_node', 'The first node on this forum', 1, 1, 0, 0, 0, '0,1,3,4');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]forum_posts`
--

CREATE TABLE `[[dbprefix]]forum_posts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `post_title` varchar(255) NOT NULL DEFAULT '',
  `title_friendly` varchar(255) NOT NULL,
  `post_content` text NOT NULL,
  `post_tags` varchar(255) NOT NULL,
  `post_time` int(11) NOT NULL,
  `post_user` int(11) NOT NULL,
  `origin_thread` int(11) NOT NULL DEFAULT '0',
  `origin_node` int(11) NOT NULL DEFAULT '0',
  `post_type` int(11) NOT NULL,
  `post_sticky` int(11) NOT NULL DEFAULT '0',
  `post_locked` int(11) NOT NULL DEFAULT '0',
  `last_updated` int(11) NOT NULL DEFAULT '0',
  `watchers` text NOT NULL,
  `label` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]generic`
--

CREATE TABLE `[[dbprefix]]generic` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `site_rules` text NOT NULL,
  `site_name` varchar(255) NOT NULL,
  `site_theme` int(11) NOT NULL,
  `site_language` varchar(255) NOT NULL,
  `site_email` varchar(255) NOT NULL,
  `register_enable` int(11) NOT NULL DEFAULT '1',
  `register_email_activate` int(11) NOT NULL DEFAULT '0',
  `facebook_authenticate` int(11) NOT NULL DEFAULT '0',
  `facebook_app_id` varchar(255) NOT NULL DEFAULT '0',
  `facebook_app_secret` varchar(255) NOT NULL DEFAULT '0',
  `captcha_type` int(11) NOT NULL DEFAULT '1',
  `recaptcha_public_key` varchar(255) NOT NULL DEFAULT '0',
  `recaptcha_private_key` varchar(255) NOT NULL DEFAULT '0',
  `mail_type` int(11) NOT NULL DEFAULT '1',
  `smtp_address` varchar(255) NOT NULL DEFAULT '0',
  `smtp_port` int(11) NOT NULL DEFAULT '0',
  `smtp_username` varchar(255) NOT NULL DEFAULT '0',
  `smtp_password` varchar(255) NOT NULL DEFAULT '0',
  `post_merge` int(1) NOT NULL DEFAULT '1',
  `flat_ui_admin` int(11) NOT NULL DEFAULT '0',
  `number_subs` int(3) NOT NULL DEFAULT '3',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]generic`
--

INSERT INTO `[[dbprefix]]generic` VALUES
(1, '\n- No spamming.\n- No racist comments.\n- Do not start a political discussion unless permitted.\n- No illegal stuff are to be posted on anywhere in the forum.', '[[site_name]]', 1, 'english', '[[admin_email]]', 1, 0, 0, '0', '0', 1, '0', '0', 1, '0', 0, '0', '0', 1, 0, 3);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]labels`
--

CREATE TABLE `[[dbprefix]]labels` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `node_id` int(11) NOT NULL,
  `label` varchar(1000) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]messages`
--

CREATE TABLE `[[dbprefix]]messages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `message_title` varchar(255) NOT NULL,
  `message_content` text NOT NULL,
  `message_time` int(11) NOT NULL,
  `origin_message` int(11) NOT NULL DEFAULT '0',
  `message_sender` int(11) NOT NULL,
  `message_receiver` int(11) NOT NULL,
  `message_type` int(11) NOT NULL DEFAULT '1',
  `receiver_viewed` int(11) NOT NULL DEFAULT '0',
  `sender_deleted` tinyint(1) NOT NULL DEFAULT '0',
  `receiver_deleted` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]notifications`
--

CREATE TABLE `[[dbprefix]]notifications` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `notice_content` varchar(255) NOT NULL,
  `notice_link` varchar(255) NOT NULL DEFAULT '0',
  `user` int(11) NOT NULL DEFAULT '0',
  `time_received` int(11) NOT NULL DEFAULT '0',
  `viewed` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]password_reset_requests`
--

CREATE TABLE `[[dbprefix]]password_reset_requests` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user` int(11) NOT NULL,
  `reset_token` varchar(255) NOT NULL,
  `request_time` int(11) NOT NULL,
  `active` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `reset_token` (`reset_token`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]permissions`
--

CREATE TABLE `[[dbprefix]]permissions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `permission_name` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=6 ;

--
-- Dumping data for table `[[dbprefix]]permissions`
--

INSERT INTO `[[dbprefix]]permissions` VALUES
(1, 'view_forum'),
(2, 'create_thread'),
(3, 'reply_thread'),
(4, 'access_moderation'),
(5, 'access_administration');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]poll`
--

CREATE TABLE `[[dbprefix]]poll` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `question` varchar(255) NOT NULL,
  `thread_id` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]poll_answers`
--

CREATE TABLE `[[dbprefix]]poll_answers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `poll_id` int(11) NOT NULL,
  `answer` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]poll_votes`
--

CREATE TABLE `[[dbprefix]]poll_votes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `poll_id` int(11) NOT NULL,
  `answer_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]reports`
--

CREATE TABLE `[[dbprefix]]reports` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `report_reason` varchar(255) NOT NULL,
  `reported_by` int(11) NOT NULL,
  `reported_user` int(11) NOT NULL DEFAULT '0',
  `reported_post` int(11) NOT NULL DEFAULT '0',
  `reported_time` int(11) NOT NULL,
  `report_close` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]sessions`
--

CREATE TABLE `[[dbprefix]]sessions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `session_id` varchar(255) NOT NULL,
  `logged_user` int(11) NOT NULL,
  `session_type` int(11) NOT NULL DEFAULT '1',
  `session_time` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]terminal`
--

CREATE TABLE `[[dbprefix]]terminal` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `command_name` varchar(255) NOT NULL,
  `command_syntax` varchar(255) NOT NULL,
  `run_function` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=5 ;

--
-- Dumping data for table `[[dbprefix]]terminal`
--

INSERT INTO `[[dbprefix]]terminal` VALUES
(1, 'cugroup', 'cugroup %s %s', 'cugroup'),
(2, 'ban', 'ban %s', 'ban'),
(3, 'unban', 'unban %s', 'unban'),
(4, 'dugroup', 'dugroup %s %s', 'dugroup');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]themes`
--

CREATE TABLE `[[dbprefix]]themes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `theme_name` varchar(255) NOT NULL,
  `theme_version` varchar(255) NOT NULL DEFAULT '1',
  `theme_json_data` longtext NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;

--
-- Dumping data for table `[[dbprefix]]themes`
--

INSERT INTO `[[dbprefix]]themes` VALUES
(1, 'Sand', '1.0', '{\n    "templates": {\n        "forum": "<!DOCTYPE html>\\r\\n<html lang=\\"en\\">\\r\\n<head>\\r\\n    <meta charset=\\"utf-8\\">\\r\\n    <meta http-equiv=\\"X-UA-Compatible\\" content=\\"IE=edge\\">\\r\\n    <meta name=\\"viewport\\" content=\\"width=device-width, initial-scale=1\\">\\r\\n\\r\\n    <meta property=\\"og:title\\" content=\\"%site_name%\\"\\/>\\r\\n    <meta property=\\"og:url\\" content=\\"%site_url%\\"\\/>\\r\\n    <meta property=\\"og:site_name\\" content=\\"%site_name%\\"\\/>\\r\\n    <meta property=\\"og:description\\" content=\\"%description%\\"\\/>\\r\\n    <meta property=\\"og:image\\" content=\\"\\"\\/>\\r\\n\\r\\n    <title>%site_name%<\\/title>\\r\\n\\r\\n    <!-- Bootstrap -->\\r\\n    <link href=\\"%site_url%\\/public\\/themes\\/Sand\\/assets\\/css\\/sand.css\\" rel=\\"stylesheet\\">\\r\\n    %editor_settings%\\r\\n    <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->\\r\\n    <!-- WARNING: Respond.js doesn''t work if you view the page via file:\\/\\/ -->\\r\\n    <!--[if lt IE 9]>\\r\\n    <script src=\\"https:\\/\\/oss.maxcdn.com\\/html5shiv\\/3.7.2\\/html5shiv.min.js\\"><\\/script>\\r\\n    <script src=\\"https:\\/\\/oss.maxcdn.com\\/respond\\/1.4.2\\/respond.min.js\\"><\\/script>\\r\\n    <![endif]-->\\r\\n<\\/head>\\r\\n<body>\\r\\n\\r\\n@if ($TANGO->sess->isLogged)\\r\\n<nav class=\\"navbar navbar-inverse navbar-static-top\\" role=\\"navigation\\">\\r\\n    <div class=\\"container\\">\\r\\n        <div class=\\"navbar-header\\">\\r\\n            <button type=\\"button\\" class=\\"navbar-toggle collapsed\\" data-toggle=\\"collapse\\" data-target=\\"#user-nav\\">\\r\\n                <span class=\\"sr-only\\">Toggle navigation<\\/span>\\r\\n                <span class=\\"icon-bar\\"><\\/span>\\r\\n                <span class=\\"icon-bar\\"><\\/span>\\r\\n                <span class=\\"icon-bar\\"><\\/span>\\r\\n            <\\/button>\\r\\n        <\\/div>\\r\\n        <div class=\\"collapse navbar-collapse\\" id=\\"user-nav\\">\\r\\n            <ul class=\\"nav navbar-nav\\">\\r\\n                @if ($TANGO->perm->check(''access_moderation''))\\r\\n                <li><a href=\\"%site_url%\\/mod\\">Reports <span class=\\"label label-warning\\">%mod_report_integer%<\\/span><\\/a>\\r\\n                <\\/li>\\r\\n                @endif\\r\\n                @if ($TANGO->perm->check(''access_administration''))\\r\\n                <li><a href=\\"%site_url%\\/admin\\">Admin CP<\\/a><\\/li>\\r\\n                @endif\\r\\n            <\\/ul>\\r\\n            <ul class=\\"nav navbar-nav navbar-right\\">\\r\\n                <li class=\\"dropdown\\">\\r\\n                    <a href=\\"#\\" class=\\"dropdown-toggle\\" data-toggle=\\"dropdown\\"><i class=\\"glyphicon glyphicon-user\\"><\\/i>\\r\\n                        %username%<\\/a>\\r\\n                    <ul class=\\"dropdown-menu\\">\\r\\n                        @foreach ($TANGO->user->userLinks() as $name => $link)\\r\\n                        <li>\\r\\n                            <a href=\\"{{ $link }}\\">\\r\\n                                {{ $name }}\\r\\n                            <\\/a>\\r\\n                        <\\/li>\\r\\n                        @endforeach\\r\\n                    <\\/ul>\\r\\n                <\\/li>\\r\\n                <li class=\\"dropdown\\">\\r\\n                    <a href=\\"#\\" class=\\"dropdown-toggle\\" data-toggle=\\"dropdown\\">\\r\\n                        <i class=\\"glyphicon glyphicon-envelope\\"><\\/i> Conversations\\r\\n                        @if (count($TANGO->user->userMessages()) > 0)\\r\\n                        <span class=\\"label label-success\\">{{ count($TANGO->user->userMessages()) }}<\\/span>\\r\\n                        @endif\\r\\n                    <\\/a>\\r\\n                    <ul class=\\"dropdown-menu\\">\\r\\n                        @if (count($TANGO->user->userMessages()) > 0)\\r\\n                        @foreach ($TANGO->user->userMessages() as $msg)\\r\\n                        <li><a href=\\"{{ $msg[''view_url''] }}\\">\\r\\n                                <h4>\\r\\n                                    {{ $msg[''message_title''] }}\\r\\n                                <\\/h4>\\r\\n                                <small>By {{ $msg[''message_sender''] }} at\\r\\n                                    {{ date(''F j, Y'', $msg[''message_time'']) }}\\r\\n                                <\\/small>\\r\\n                            <\\/a>\\r\\n                        <\\/li>\\r\\n                        @endforeach\\r\\n                        @else\\r\\n                        <li role=\\"presentation\\" class=\\"disabled\\"><a role=\\"menuitem\\" tabindex=\\"-1\\" href=\\"#\\">No\\r\\n                                Messages<\\/a><\\/li>\\r\\n                        @endif\\r\\n                        <li><a href=\\"%site_url%\\/conversations.php\\">Conversations<\\/a><\\/li>\\r\\n                        <li><a href=\\"%site_url%\\/conversations.php\\/cmd\\/new\\">New Message<\\/a><\\/li>\\r\\n                    <\\/ul>\\r\\n                <\\/li>\\r\\n                <li class=\\"dropdown\\">\\r\\n                    <a href=\\"#\\" class=\\"dropdown-toggle\\" data-toggle=\\"dropdown\\" style=\\"overflow:auto;\\">\\r\\n                        <i class=\\"fa fa-bell\\"><\\/i>\\r\\n                        @if (count($TANGO->user->notifications()) > 0)\\r\\n                <span class=\\"badge\\">\\r\\n                  {{ count($TANGO->user->notifications()) }}\\r\\n                <\\/span>\\r\\n                        @endif\\r\\n                    <\\/a>\\r\\n                    <ul class=\\"dropdown-menu\\">\\r\\n                        @if (count($TANGO->user->notifications()) < 1)\\r\\n                        <li role=\\"presentation\\" class=\\"disabled\\"><a role=\\"menuitem\\" tabindex=\\"-1\\" href=\\"#\\">No new\\r\\n                                notifications yet.<\\/a><\\/li>\\r\\n                        @else\\r\\n                        @foreach ($TANGO->user->notifications() as $note)\\r\\n                        <li><a href=\\"{{ $note[''notice_link''] }}\\">\\r\\n                                {{ $note[''notice_content''] }}\\r\\n                                <small class=\\"text-muted\\">{{ date(''F j, Y'', $note[''time_received'']) }}<\\/small>\\r\\n                            <\\/a>\\r\\n                        <\\/li>\\r\\n                        @endforeach\\r\\n                        {{ $TANGO->user->clearNotification() }}\\r\\n                        @endif\\r\\n                    <\\/ul>\\r\\n                <\\/li>\\r\\n            <\\/ul>\\r\\n        <\\/div>\\r\\n    <\\/div>\\r\\n<\\/nav>\\r\\n@endif\\r\\n\\r\\n<div class=\\"container\\">\\r\\n\\r\\n    <div class=\\"row\\">\\r\\n        <div class=\\"col-md-10\\">\\r\\n            <h1>\\r\\n                <div class=\\"logo\\"><\\/div>\\r\\n            <\\/h1>\\r\\n        <\\/div>\\r\\n        <div class=\\"col-md-2\\">\\r\\n            @if( !$TANGO->sess->isLogged )\\r\\n            <div class=\\"btn-group login-bar\\">\\r\\n                <a href=\\"#\\" class=\\"btn btn-warning btn-block dropdown-toggle\\" data-toggle=\\"dropdown\\">Log In<\\/a>\\r\\n                <ul class=\\"dropdown-menu dropdown-menu-right\\" role=\\"menu\\">\\r\\n                    <li class=\\"login-form\\">\\r\\n                        <form action=\\"%site_url%\\/members.php\\/cmd\\/signin\\" method=\\"POST\\">\\r\\n                            <input type=\\"hidden\\" name=\\"current_url\\" value=\\"%current_url%\\" \\/>\\r\\n                            <input type=\\"text\\" name=\\"email\\" class=\\"form-control\\" id=\\"inputEmail3\\"\\r\\n                                   placeholder=\\"Username or Email\\">\\r\\n                            <input type=\\"password\\" name=\\"password\\" class=\\"form-control\\" id=\\"inputPassword3\\"\\r\\n                                   placeholder=\\"Password\\">\\r\\n                            <label>\\r\\n                                <input type=\\"checkbox\\" name=\\"remember\\"> Remember me\\r\\n                            <\\/label>\\r\\n                            <input type=\\"submit\\" class=\\"btn btn-primary btn-block\\" name=\\"signin\\" value=\\"Log In\\"\\/>\\r\\n                            @if ($TANGO->data[''facebook_authenticate''] == \\"1\\")\\r\\n                            <a href=\\"%facebook_login_url%\\" class=\\"btn btn-info btn-block\\"><span\\r\\n                                    class=\\"label label-primary\\"><i class=\\"fa fa-facebook\\"><\\/i><\\/span> Sign In<\\/a>\\r\\n                            @endif\\r\\n                        <\\/form>\\r\\n                    <\\/li>\\r\\n            <\\/div>\\r\\n            @endif\\r\\n        <\\/div>\\r\\n    <\\/div>\\r\\n    <div class=\\"well well-sm\\">\\r\\n        <ul class=\\"nav nav-pills\\">\\r\\n            <li class=\\"active\\"><a href=\\"%site_url%\\">Forum<\\/a><\\/li>\\r\\n            <li><a href=\\"%site_url%\\/members.php\\">Members<\\/a><\\/li>\\r\\n        <\\/ul>\\r\\n    <\\/div>\\r\\n\\r\\n    <div class=\\"row\\">\\r\\n\\r\\n        <div class=\\"col-md-9\\">\\r\\n            <h1 class=\\"title\\">%site_name%<\\/h1>\\r\\n            %forum_listings%\\r\\n\\r\\n            <div class=\\"well\\">\\r\\n                <strong>Users Online<\\/strong><br\\/>\\r\\n                %users_online%\\r\\n            <\\/div>\\r\\n\\r\\n            <div class=\\"row forum-legends\\">\\r\\n                <div class=\\"col-md-6\\">\\r\\n                    <i class=\\"fa fa-folder fa-3 node-read\\"><\\/i> <span class=\\"text-muted legend-desc\\">New Posts<\\/span>\\r\\n                <\\/div>\\r\\n                <div class=\\"col-md-6\\">\\r\\n                    <i class=\\"fa fa-folder-o fa-3 node-read\\"><\\/i> <span\\r\\n                        class=\\"text-muted legend-desc\\">No New Posts<\\/span>\\r\\n                <\\/div>\\r\\n            <\\/div>\\r\\n        <\\/div>\\r\\n\\r\\n        <div class=\\"col-md-3\\">\\r\\n            <form action=\\"%site_url%\\/search.php\\" method=\\"POST\\" class=\\"search\\">\\r\\n                <input name=\\"search_query\\" type=\\"text\\" class=\\"form-control tooltip_toggle\\" placeholder=\\"Search...\\">\\r\\n                <input type=\\"submit\\" name=\\"search_submit\\" style=\\"visibility:hidden;display:none;\\" value=\\"Search\\"\\/>\\r\\n            <\\/form>\\r\\n\\r\\n            <div class=\\"panel panel-default\\">\\r\\n                <div class=\\"panel-body\\">\\r\\n                    @if ($TANGO->sess->isLogged)\\r\\n                    <div class=\\"row\\" style=\\"width:100%;overflow:auto;margin:0 auto;\\">\\r\\n                        <div class=\\"col-md-5\\">\\r\\n                            <img src=\\"%user_avatar%\\" class=\\"img-thumbnail pull-left\\"\\r\\n                                 style=\\"max-width:100x;max-height:100px;\\">\\r\\n                        <\\/div>\\r\\n                        <div class=\\"col-md-7\\">\\r\\n                            <a href=\\"%site_url%\\/members.php\\/cmd\\/user\\">%username_style%<\\/a>\\r\\n\\r\\n                            <div class=\\"row\\">\\r\\n                                <div class=\\"col-md-6\\">\\r\\n                                    <small>Messages:<\\/small>\\r\\n                                <\\/div>\\r\\n                                <div class=\\"col-md-6\\" style=\\"text-align:right;\\">\\r\\n                                    %user_post_count%\\r\\n                                <\\/div>\\r\\n                            <\\/div>\\r\\n                        <\\/div>\\r\\n                    <\\/div>\\r\\n                    @else\\r\\n                    <a href=\\"%site_url%\\/members.php\\/cmd\\/register\\" class=\\"btn btn-success btn-block\\">Register<\\/a>\\r\\n                    @endif\\r\\n                <\\/div>\\r\\n            <\\/div>\\r\\n\\r\\n            <div class=\\"panel panel-warning\\">\\r\\n                <div class=\\"panel-heading\\"><b><i class=\\"glyphicon glyphicon-stats\\"><\\/i> Forum Statistics<\\/b><\\/div>\\r\\n                <div class=\\"panel-body\\">\\r\\n                    <div class=\\"row\\">\\r\\n                        <div class=\\"col-md-6 text-muted\\">\\r\\n                            <small>Threads:<\\/small>\\r\\n                        <\\/div>\\r\\n                        <div class=\\"col-md-6\\" style=\\"text-align:right;\\">\\r\\n                            <small>%bb_stat_threads%<\\/small>\\r\\n                        <\\/div>\\r\\n                        <div class=\\"col-md-6 text-muted\\">\\r\\n                            <small>Replies:<\\/small>\\r\\n                        <\\/div>\\r\\n                        <div class=\\"col-md-6\\" style=\\"text-align:right;\\">\\r\\n                            <small>%bb_stat_posts%<\\/small>\\r\\n                        <\\/div>\\r\\n                        <div class=\\"col-md-6 text-muted\\">\\r\\n                            <small>Users:<\\/small>\\r\\n                        <\\/div>\\r\\n                        <div class=\\"col-md-6\\" style=\\"text-align:right;\\">\\r\\n                            <small>%bb_stat_users%<\\/small>\\r\\n                        <\\/div>\\r\\n                    <\\/div>\\r\\n                <\\/div>\\r\\n            <\\/div>\\r\\n        <\\/div>\\r\\n\\r\\n    <\\/div>\\r\\n\\r\\n    <footer class=\\"footer\\">\\r\\n        <div class=\\"row\\">\\r\\n            <div class=\\"col-md-6\\">\\r\\n                <a href=\\"http:\\/\\/tangobb.com\\/\\">Powered by TangoBB<\\/a><br\\/>\\r\\n                <small class=\\"text-muted\\">Load Time: %elapsed_time% seconds | Memory: %memory_usage%<\\/small>\\r\\n            <\\/div>\\r\\n            <div class=\\"col-md-6 change_theme\\">\\r\\n                @if( $TANGO->sess->isLogged )\\r\\n                <div class=\\"btn-group dropup\\">\\r\\n                    <button type=\\"button\\" class=\\"btn btn-link dropdown-toggle\\" data-toggle=\\"dropdown\\">\\r\\n                        Change Theme <span class=\\"caret\\"><\\/span>\\r\\n                    <\\/button>\\r\\n                    <ul class=\\"dropdown-menu dropdown-menu-right\\" role=\\"menu\\">\\r\\n                        @foreach (listThemes() as $theme)\\r\\n                        @if ($theme[''id''] == $TANGO->sess->data[''chosen_theme''])\\r\\n                        <li class=\\"active\\"><a href=\\"{{ $theme[''change_link''] }}\\">\\r\\n                                {{ $theme[''theme_name''] }}\\r\\n                            <\\/a><\\/li>\\r\\n                        @else\\r\\n                        <li><a href=\\"{{ $theme[''change_link''] }}\\">\\r\\n                                {{ $theme[''theme_name''] }}\\r\\n                            <\\/a><\\/li>\\r\\n                        @endif\\r\\n                        @endforeach\\r\\n                    <\\/ul>\\r\\n                <\\/div>\\r\\n                @endif\\r\\n            <\\/div>\\r\\n        <\\/div>\\r\\n    <\\/footer>\\r\\n\\r\\n<\\/div>\\r\\n<!-- Include all compiled plugins (below), or include individual files as needed -->\\r\\n%highlighter_footer%\\r\\n<script src=\\"%site_url%\\/public\\/themes\\/Sand\\/assets\\/js\\/bootstrap.min.js\\"><\\/script>\\r\\n<script src=\\"%site_url%\\/public\\/themes\\/Sand\\/assets\\/js\\/sand.js\\"><\\/script>\\r\\n<\\/body>\\r\\n<\\/html>",\n        "members": "<!DOCTYPE html>\\r\\n<html lang=\\"en\\">\\r\\n<head>\\r\\n    <meta charset=\\"utf-8\\">\\r\\n    <meta http-equiv=\\"X-UA-Compatible\\" content=\\"IE=edge\\">\\r\\n    <meta name=\\"viewport\\" content=\\"width=device-width, initial-scale=1\\">\\r\\n\\r\\n    <meta property=\\"og:title\\" content=\\"%page_title% - %site_name%\\"\\/>\\r\\n    <meta property=\\"og:url\\" content=\\"%site_url%\\"\\/>\\r\\n    <meta property=\\"og:site_name\\" content=\\"%site_name%\\"\\/>\\r\\n    <meta property=\\"og:description\\" content=\\"%description%\\"\\/>\\r\\n    <meta property=\\"og:image\\" content=\\"\\"\\/>\\r\\n\\r\\n    <title>%page_title% | %site_name%<\\/title>\\r\\n\\r\\n    <!-- Bootstrap -->\\r\\n    <link href=\\"%site_url%\\/public\\/themes\\/Sand\\/assets\\/css\\/sand.css\\" rel=\\"stylesheet\\">\\r\\n    %editor_settings%\\r\\n    <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->\\r\\n    <!-- WARNING: Respond.js doesn''t work if you view the page via file:\\/\\/ -->\\r\\n    <!--[if lt IE 9]>\\r\\n    <script src=\\"https:\\/\\/oss.maxcdn.com\\/html5shiv\\/3.7.2\\/html5shiv.min.js\\"><\\/script>\\r\\n    <script src=\\"https:\\/\\/oss.maxcdn.com\\/respond\\/1.4.2\\/respond.min.js\\"><\\/script>\\r\\n    <![endif]-->\\r\\n<\\/head>\\r\\n<body>\\r\\n\\r\\n@if ($TANGO->sess->isLogged)\\r\\n<nav class=\\"navbar navbar-inverse navbar-static-top\\" role=\\"navigation\\">\\r\\n    <div class=\\"container\\">\\r\\n        <div class=\\"navbar-header\\">\\r\\n            <button type=\\"button\\" class=\\"navbar-toggle collapsed\\" data-toggle=\\"collapse\\" data-target=\\"#user-nav\\">\\r\\n                <span class=\\"sr-only\\">Toggle navigation<\\/span>\\r\\n                <span class=\\"icon-bar\\"><\\/span>\\r\\n                <span class=\\"icon-bar\\"><\\/span>\\r\\n                <span class=\\"icon-bar\\"><\\/span>\\r\\n            <\\/button>\\r\\n        <\\/div>\\r\\n        <div class=\\"collapse navbar-collapse\\" id=\\"user-nav\\">\\r\\n            <ul class=\\"nav navbar-nav\\">\\r\\n                @if ($TANGO->perm->check(''access_moderation''))\\r\\n                <li><a href=\\"%site_url%\\/mod\\">Reports <span class=\\"label label-warning\\">%mod_report_integer%<\\/span><\\/a>\\r\\n                <\\/li>\\r\\n                @endif\\r\\n                @if ($TANGO->perm->check(''access_administration''))\\r\\n                <li><a href=\\"%site_url%\\/admin\\">Admin CP<\\/a><\\/li>\\r\\n                @endif\\r\\n            <\\/ul>\\r\\n            <ul class=\\"nav navbar-nav navbar-right\\">\\r\\n                <li class=\\"dropdown\\">\\r\\n                    <a href=\\"#\\" class=\\"dropdown-toggle\\" data-toggle=\\"dropdown\\"><i class=\\"glyphicon glyphicon-user\\"><\\/i>\\r\\n                        %username%<\\/a>\\r\\n                    <ul class=\\"dropdown-menu\\">\\r\\n                        @foreach ($TANGO->user->userLinks() as $name => $link)\\r\\n                        <li>\\r\\n                            <a href=\\"{{ $link }}\\">\\r\\n                                {{ $name }}\\r\\n                            <\\/a>\\r\\n                        <\\/li>\\r\\n                        @endforeach\\r\\n                    <\\/ul>\\r\\n                <\\/li>\\r\\n                <li class=\\"dropdown\\">\\r\\n                    <a href=\\"#\\" class=\\"dropdown-toggle\\" data-toggle=\\"dropdown\\">\\r\\n                        <i class=\\"glyphicon glyphicon-envelope\\"><\\/i> Conversations\\r\\n                        @if (count($TANGO->user->userMessages()) > 0)\\r\\n                        <span class=\\"label label-success\\">{{ count($TANGO->user->userMessages()) }}<\\/span>\\r\\n                        @endif\\r\\n                    <\\/a>\\r\\n                    <ul class=\\"dropdown-menu\\">\\r\\n                        @if (count($TANGO->user->userMessages()) > 0)\\r\\n                        @foreach ($TANGO->user->userMessages() as $msg)\\r\\n                        <li><a href=\\"{{ $msg[''view_url''] }}\\">\\r\\n                                <h4>\\r\\n                                    {{ $msg[''message_title''] }}\\r\\n                                <\\/h4>\\r\\n                                <small>By {{ $msg[''message_sender''] }} at\\r\\n                                    {{ date(''F j, Y'', $msg[''message_time'']) }}\\r\\n                                <\\/small>\\r\\n                            <\\/a>\\r\\n                        <\\/li>\\r\\n                        @endforeach\\r\\n                        @else\\r\\n                        <li role=\\"presentation\\" class=\\"disabled\\"><a role=\\"menuitem\\" tabindex=\\"-1\\" href=\\"#\\">No\\r\\n                                Messages<\\/a><\\/li>\\r\\n                        @endif\\r\\n                        <li><a href=\\"%site_url%\\/conversations.php\\">Conversations<\\/a><\\/li>\\r\\n                        <li><a href=\\"%site_url%\\/conversations.php\\/cmd\\/new\\">New Message<\\/a><\\/li>\\r\\n                    <\\/ul>\\r\\n                <\\/li>\\r\\n                <li class=\\"dropdown\\">\\r\\n                    <a href=\\"#\\" class=\\"dropdown-toggle\\" data-toggle=\\"dropdown\\" style=\\"overflow:auto;\\">\\r\\n                        <i class=\\"fa fa-bell\\"><\\/i>\\r\\n                        @if (count($TANGO->user->notifications()) > 0)\\r\\n                <span class=\\"badge\\">\\r\\n                  {{ count($TANGO->user->notifications()) }}\\r\\n                <\\/span>\\r\\n                        @endif\\r\\n                    <\\/a>\\r\\n                    <ul class=\\"dropdown-menu\\">\\r\\n                        @if (count($TANGO->user->notifications()) < 1)\\r\\n                        <li role=\\"presentation\\" class=\\"disabled\\"><a role=\\"menuitem\\" tabindex=\\"-1\\" href=\\"#\\">No new\\r\\n                                notifications yet.<\\/a><\\/li>\\r\\n                        @else\\r\\n                        @foreach ($TANGO->user->notifications() as $note)\\r\\n                        <li><a href=\\"{{ $note[''notice_link''] }}\\">\\r\\n                                {{ $note[''notice_content''] }}\\r\\n                                <small class=\\"text-muted\\">{{ date(''F j, Y'', $note[''time_received'']) }}<\\/small>\\r\\n                            <\\/a>\\r\\n                        <\\/li>\\r\\n                        @endforeach\\r\\n                        {{ $TANGO->user->clearNotification() }}\\r\\n                        @endif\\r\\n                    <\\/ul>\\r\\n                <\\/li>\\r\\n            <\\/ul>\\r\\n        <\\/div>\\r\\n    <\\/div>\\r\\n<\\/nav>\\r\\n@endif\\r\\n\\r\\n<div class=\\"container\\">\\r\\n\\r\\n    <div class=\\"row\\">\\r\\n        <div class=\\"col-md-10\\">\\r\\n            <h1>\\r\\n                <div class=\\"logo\\"><\\/div>\\r\\n            <\\/h1>\\r\\n        <\\/div>\\r\\n        <div class=\\"col-md-2\\">\\r\\n            @if( !$TANGO->sess->isLogged )\\r\\n            <div class=\\"btn-group login-bar\\">\\r\\n                <a href=\\"#\\" class=\\"btn btn-warning btn-block dropdown-toggle\\" data-toggle=\\"dropdown\\">Log In<\\/a>\\r\\n                <ul class=\\"dropdown-menu dropdown-menu-right\\" role=\\"menu\\">\\r\\n                    <li class=\\"login-form\\">\\r\\n                        <form action=\\"%site_url%\\/members.php\\/cmd\\/signin\\" method=\\"POST\\">\\r\\n                            <input type=\\"hidden\\" name=\\"current_url\\" value=\\"%current_url%\\" \\/>\\r\\n                            <input type=\\"text\\" name=\\"email\\" class=\\"form-control\\" id=\\"inputEmail3\\"\\r\\n                                   placeholder=\\"Username or Email\\">\\r\\n                            <input type=\\"password\\" name=\\"password\\" class=\\"form-control\\" id=\\"inputPassword3\\"\\r\\n                                   placeholder=\\"Password\\">\\r\\n                            <label>\\r\\n                                <input type=\\"checkbox\\" name=\\"remember\\"> Remember me\\r\\n                            <\\/label>\\r\\n                            <input type=\\"submit\\" class=\\"btn btn-primary btn-block\\" name=\\"signin\\" value=\\"Log In\\"\\/>\\r\\n                            @if ($TANGO->data[''facebook_authenticate''] == \\"1\\")\\r\\n                            <a href=\\"%facebook_login_url%\\" class=\\"btn btn-info btn-block\\"><span\\r\\n                                    class=\\"label label-primary\\"><i class=\\"fa fa-facebook\\"><\\/i><\\/span> Sign In Sign\\r\\n                                In<\\/a>\\r\\n                            @endif\\r\\n                        <\\/form>\\r\\n                    <\\/li>\\r\\n            <\\/div>\\r\\n            @endif\\r\\n        <\\/div>\\r\\n    <\\/div>\\r\\n    <div class=\\"well well-sm\\">\\r\\n        <ul class=\\"nav nav-pills\\">\\r\\n            <li><a href=\\"%site_url%\\">Forum<\\/a><\\/li>\\r\\n            <li class=\\"active\\"><a href=\\"%site_url%\\/members.php\\">Members<\\/a><\\/li>\\r\\n        <\\/ul>\\r\\n    <\\/div>\\r\\n\\r\\n    <div class=\\"row\\">\\r\\n\\r\\n        <div class=\\"col-md-9\\">\\r\\n            <h1 class=\\"title\\">%page_title%<\\/h1>\\r\\n            %content%\\r\\n        <\\/div>\\r\\n\\r\\n        <div class=\\"col-md-3\\">\\r\\n            <form action=\\"%site_url%\\/search.php\\" method=\\"POST\\" class=\\"search\\">\\r\\n                <input name=\\"search_query\\" type=\\"text\\" class=\\"form-control tooltip_toggle\\" placeholder=\\"Search...\\">\\r\\n                <input type=\\"submit\\" name=\\"search_submit\\" style=\\"visibility:hidden;display:none;\\" value=\\"Search\\"\\/>\\r\\n            <\\/form>\\r\\n\\r\\n            <div class=\\"panel panel-default\\">\\r\\n                <div class=\\"panel-body\\">\\r\\n                    @if ($TANGO->sess->isLogged)\\r\\n                    <div class=\\"row\\" style=\\"width:100%;overflow:auto;margin:0 auto;\\">\\r\\n                        <div class=\\"col-md-5\\">\\r\\n                            <img src=\\"%user_avatar%\\" class=\\"img-thumbnail pull-left\\"\\r\\n                                 style=\\"max-width:100x;max-height:100px;\\">\\r\\n                        <\\/div>\\r\\n                        <div class=\\"col-md-7\\">\\r\\n                            <a href=\\"%site_url%\\/members.php\\/cmd\\/user\\">%username_style%<\\/a>\\r\\n\\r\\n                            <div class=\\"row\\">\\r\\n                                <div class=\\"col-md-6\\">\\r\\n                                    <small>Messages:<\\/small>\\r\\n                                <\\/div>\\r\\n                                <div class=\\"col-md-6\\" style=\\"text-align:right;\\">\\r\\n                                    %user_post_count%\\r\\n                                <\\/div>\\r\\n                            <\\/div>\\r\\n                        <\\/div>\\r\\n                    <\\/div>\\r\\n                    @else\\r\\n                    <a href=\\"%site_url%\\/members.php\\/cmd\\/register\\" class=\\"btn btn-success btn-block\\">Register<\\/a>\\r\\n                    @endif\\r\\n                <\\/div>\\r\\n            <\\/div>\\r\\n\\r\\n        <\\/div>\\r\\n\\r\\n    <\\/div>\\r\\n\\r\\n    <footer class=\\"footer\\">\\r\\n        <div class=\\"row\\">\\r\\n            <div class=\\"col-md-6\\">\\r\\n                <a href=\\"http:\\/\\/tangobb.com\\/\\">Powered by TangoBB<\\/a><br\\/>\\r\\n                <small class=\\"text-muted\\">Load Time: %elapsed_time% seconds | Memory: %memory_usage%<\\/small>\\r\\n            <\\/div>\\r\\n            <div class=\\"col-md-6 change_theme\\">\\r\\n                @if( $TANGO->sess->isLogged )\\r\\n                <div class=\\"btn-group dropup\\">\\r\\n                    <button type=\\"button\\" class=\\"btn btn-link dropdown-toggle\\" data-toggle=\\"dropdown\\">\\r\\n                        Change Theme <span class=\\"caret\\"><\\/span>\\r\\n                    <\\/button>\\r\\n                    <ul class=\\"dropdown-menu dropdown-menu-right\\" role=\\"menu\\">\\r\\n                        @foreach (listThemes() as $theme)\\r\\n                        @if ($theme[''id''] == $TANGO->sess->data[''chosen_theme''])\\r\\n                        <li class=\\"active\\"><a href=\\"{{ $theme[''change_link''] }}\\">\\r\\n                                {{ $theme[''theme_name''] }}\\r\\n                            <\\/a><\\/li>\\r\\n                        @else\\r\\n                        <li><a href=\\"{{ $theme[''change_link''] }}\\">\\r\\n                                {{ $theme[''theme_name''] }}\\r\\n                            <\\/a><\\/li>\\r\\n                        @endif\\r\\n                        @endforeach\\r\\n                    <\\/ul>\\r\\n                <\\/div>\\r\\n                @endif\\r\\n            <\\/div>\\r\\n        <\\/div>\\r\\n    <\\/footer>\\r\\n\\r\\n<\\/div>\\r\\n<!-- Include all compiled plugins (below), or include individual files as needed -->\\r\\n%highlighter_footer%\\r\\n<script src=\\"%site_url%\\/public\\/themes\\/Sand\\/assets\\/js\\/bootstrap.min.js\\"><\\/script>\\r\\n<script src=\\"%site_url%\\/public\\/themes\\/Sand\\/assets\\/js\\/sand.js\\"><\\/script>\\r\\n<\\/body>\\r\\n<\\/html>",\n        "page": "<!DOCTYPE html>\\r\\n<html lang=\\"en\\">\\r\\n<head>\\r\\n    <meta charset=\\"utf-8\\">\\r\\n    <meta http-equiv=\\"X-UA-Compatible\\" content=\\"IE=edge\\">\\r\\n    <meta name=\\"viewport\\" content=\\"width=device-width, initial-scale=1\\">\\r\\n\\r\\n    <meta property=\\"og:title\\" content=\\"%page_title% - %site_name%\\"\\/>\\r\\n    <meta property=\\"og:url\\" content=\\"%site_url%\\"\\/>\\r\\n    <meta property=\\"og:site_name\\" content=\\"%site_name%\\"\\/>\\r\\n    <meta property=\\"og:description\\" content=\\"%description%\\"\\/>\\r\\n    <meta property=\\"og:image\\" content=\\"\\"\\/>\\r\\n\\r\\n    <title>%page_title% | %site_name%<\\/title>\\r\\n\\r\\n    <!-- Bootstrap -->\\r\\n    <link href=\\"%site_url%\\/public\\/themes\\/Sand\\/assets\\/css\\/sand.css\\" rel=\\"stylesheet\\">\\r\\n    %editor_settings%\\r\\n    <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->\\r\\n    <!-- WARNING: Respond.js doesn''t work if you view the page via file:\\/\\/ -->\\r\\n    <!--[if lt IE 9]>\\r\\n    <script src=\\"https:\\/\\/oss.maxcdn.com\\/html5shiv\\/3.7.2\\/html5shiv.min.js\\"><\\/script>\\r\\n    <script src=\\"https:\\/\\/oss.maxcdn.com\\/respond\\/1.4.2\\/respond.min.js\\"><\\/script>\\r\\n    <![endif]-->\\r\\n<\\/head>\\r\\n<body>\\r\\n\\r\\n@if ($TANGO->sess->isLogged)\\r\\n<nav class=\\"navbar navbar-inverse navbar-static-top\\" role=\\"navigation\\">\\r\\n    <div class=\\"container\\">\\r\\n        <div class=\\"navbar-header\\">\\r\\n            <button type=\\"button\\" class=\\"navbar-toggle collapsed\\" data-toggle=\\"collapse\\" data-target=\\"#user-nav\\">\\r\\n                <span class=\\"sr-only\\">Toggle navigation<\\/span>\\r\\n                <span class=\\"icon-bar\\"><\\/span>\\r\\n                <span class=\\"icon-bar\\"><\\/span>\\r\\n                <span class=\\"icon-bar\\"><\\/span>\\r\\n            <\\/button>\\r\\n        <\\/div>\\r\\n        <div class=\\"collapse navbar-collapse\\" id=\\"user-nav\\">\\r\\n            <ul class=\\"nav navbar-nav\\">\\r\\n                @if ($TANGO->perm->check(''access_moderation''))\\r\\n                <li><a href=\\"%site_url%\\/mod\\">Reports <span class=\\"label label-warning\\">%mod_report_integer%<\\/span><\\/a>\\r\\n                <\\/li>\\r\\n                @endif\\r\\n                @if ($TANGO->perm->check(''access_administration''))\\r\\n                <li><a href=\\"%site_url%\\/admin\\">Admin CP<\\/a><\\/li>\\r\\n                @endif\\r\\n            <\\/ul>\\r\\n            <ul class=\\"nav navbar-nav navbar-right\\">\\r\\n                <li class=\\"dropdown\\">\\r\\n                    <a href=\\"#\\" class=\\"dropdown-toggle\\" data-toggle=\\"dropdown\\"><i class=\\"glyphicon glyphicon-user\\"><\\/i>\\r\\n                        %username%<\\/a>\\r\\n                    <ul class=\\"dropdown-menu\\">\\r\\n                        @foreach ($TANGO->user->userLinks() as $name => $link)\\r\\n                        <li>\\r\\n                            <a href=\\"{{ $link }}\\">\\r\\n                                {{ $name }}\\r\\n                            <\\/a>\\r\\n                        <\\/li>\\r\\n                        @endforeach\\r\\n                    <\\/ul>\\r\\n                <\\/li>\\r\\n                <li class=\\"dropdown\\">\\r\\n                    <a href=\\"#\\" class=\\"dropdown-toggle\\" data-toggle=\\"dropdown\\">\\r\\n                        <i class=\\"glyphicon glyphicon-envelope\\"><\\/i> Conversations\\r\\n                        @if (count($TANGO->user->userMessages()) > 0)\\r\\n                        <span class=\\"label label-success\\">{{ count($TANGO->user->userMessages()) }}<\\/span>\\r\\n                        @endif\\r\\n                    <\\/a>\\r\\n                    <ul class=\\"dropdown-menu\\">\\r\\n                        @if (count($TANGO->user->userMessages()) > 0)\\r\\n                        @foreach ($TANGO->user->userMessages() as $msg)\\r\\n                        <li><a href=\\"{{ $msg[''view_url''] }}\\">\\r\\n                                <h4>\\r\\n                                    {{ $msg[''message_title''] }}\\r\\n                                <\\/h4>\\r\\n                                <small>By {{ $msg[''message_sender''] }} at\\r\\n                                    {{ date(''F j, Y'', $msg[''message_time'']) }}\\r\\n                                <\\/small>\\r\\n                            <\\/a>\\r\\n                        <\\/li>\\r\\n                        @endforeach\\r\\n                        @else\\r\\n                        <li role=\\"presentation\\" class=\\"disabled\\"><a role=\\"menuitem\\" tabindex=\\"-1\\" href=\\"#\\">No\\r\\n                                Messages<\\/a><\\/li>\\r\\n                        @endif\\r\\n                        <li><a href=\\"%site_url%\\/conversations.php\\">Conversations<\\/a><\\/li>\\r\\n                        <li><a href=\\"%site_url%\\/conversations.php\\/cmd\\/new\\">New Message<\\/a><\\/li>\\r\\n                    <\\/ul>\\r\\n                <\\/li>\\r\\n                <li class=\\"dropdown\\">\\r\\n                    <a href=\\"#\\" class=\\"dropdown-toggle\\" data-toggle=\\"dropdown\\" style=\\"overflow:auto;\\">\\r\\n                        <i class=\\"fa fa-bell\\"><\\/i>\\r\\n                        @if (count($TANGO->user->notifications()) > 0)\\r\\n                <span class=\\"badge\\">\\r\\n                  {{ count($TANGO->user->notifications()) }}\\r\\n                <\\/span>\\r\\n                        @endif\\r\\n                    <\\/a>\\r\\n                    <ul class=\\"dropdown-menu\\">\\r\\n                        @if (count($TANGO->user->notifications()) < 1)\\r\\n                        <li role=\\"presentation\\" class=\\"disabled\\"><a role=\\"menuitem\\" tabindex=\\"-1\\" href=\\"#\\">No new\\r\\n                                notifications yet.<\\/a><\\/li>\\r\\n                        @else\\r\\n                        @foreach ($TANGO->user->notifications() as $note)\\r\\n                        <li><a href=\\"{{ $note[''notice_link''] }}\\">\\r\\n                                {{ $note[''notice_content''] }}\\r\\n                                <small class=\\"text-muted\\">{{ date(''F j, Y'', $note[''time_received'']) }}<\\/small>\\r\\n                            <\\/a>\\r\\n                        <\\/li>\\r\\n                        @endforeach\\r\\n                        {{ $TANGO->user->clearNotification() }}\\r\\n                        @endif\\r\\n                    <\\/ul>\\r\\n                <\\/li>\\r\\n            <\\/ul>\\r\\n        <\\/div>\\r\\n    <\\/div>\\r\\n<\\/nav>\\r\\n@endif\\r\\n\\r\\n<div class=\\"container\\">\\r\\n\\r\\n    <div class=\\"row\\">\\r\\n        <div class=\\"col-md-10\\">\\r\\n            <h1>\\r\\n                <div class=\\"logo\\"><\\/div>\\r\\n            <\\/h1>\\r\\n        <\\/div>\\r\\n        <div class=\\"col-md-2\\">\\r\\n            @if( !$TANGO->sess->isLogged )\\r\\n            <div class=\\"btn-group login-bar\\">\\r\\n                <a href=\\"#\\" class=\\"btn btn-warning btn-block dropdown-toggle\\" data-toggle=\\"dropdown\\">Log In<\\/a>\\r\\n                <ul class=\\"dropdown-menu dropdown-menu-right\\" role=\\"menu\\">\\r\\n                    <li class=\\"login-form\\">\\r\\n                        <form action=\\"%site_url%\\/members.php\\/cmd\\/signin\\" method=\\"POST\\">\\r\\n                            <input type=\\"hidden\\" name=\\"current_url\\" value=\\"%current_url%\\" \\/>\\r\\n                            <input type=\\"text\\" name=\\"email\\" class=\\"form-control\\" id=\\"inputEmail3\\"\\r\\n                                   placeholder=\\"Username or Email\\">\\r\\n                            <input type=\\"password\\" name=\\"password\\" class=\\"form-control\\" id=\\"inputPassword3\\"\\r\\n                                   placeholder=\\"Password\\">\\r\\n                            <label>\\r\\n                                <input type=\\"checkbox\\" name=\\"remember\\"> Remember me\\r\\n                            <\\/label>\\r\\n                            <input type=\\"submit\\" class=\\"btn btn-primary btn-block\\" name=\\"signin\\" value=\\"Log In\\"\\/>\\r\\n                            @if ($TANGO->data[''facebook_authenticate''] == \\"1\\")\\r\\n                            <a href=\\"%facebook_login_url%\\" class=\\"btn btn-info btn-block\\"><span\\r\\n                                    class=\\"label label-primary\\"><i class=\\"fa fa-facebook\\"><\\/i><\\/span> Sign In Sign\\r\\n                                In<\\/a>\\r\\n                            @endif\\r\\n                        <\\/form>\\r\\n                    <\\/li>\\r\\n            <\\/div>\\r\\n            @endif\\r\\n        <\\/div>\\r\\n    <\\/div>\\r\\n    <div class=\\"well well-sm\\">\\r\\n        <ul class=\\"nav nav-pills\\">\\r\\n            <li class=\\"active\\"><a href=\\"%site_url%\\">Forum<\\/a><\\/li>\\r\\n            <li><a href=\\"%site_url%\\/members.php\\">Members<\\/a><\\/li>\\r\\n        <\\/ul>\\r\\n    <\\/div>\\r\\n\\r\\n    <div class=\\"row\\">\\r\\n\\r\\n        <div class=\\"col-md-12\\">\\r\\n            <div class=\\"row\\">\\r\\n                <div class=\\"col-md-9\\">\\r\\n                    <h1 class=\\"title\\">%page_title%<\\/h1>\\r\\n                <\\/div>\\r\\n                <div class=\\"col-md-3\\">\\r\\n                    <form action=\\"%site_url%\\/search.php\\" method=\\"POST\\" class=\\"search\\">\\r\\n                        <input name=\\"search_query\\" type=\\"text\\" class=\\"form-control tooltip_toggle\\"\\r\\n                               placeholder=\\"Search...\\">\\r\\n                        <input type=\\"submit\\" name=\\"search_submit\\" style=\\"visibility:hidden;display:none;\\"\\r\\n                               value=\\"Search\\"\\/>\\r\\n\\r\\n                    <\\/form>\\r\\n                <\\/div>\\r\\n            <\\/div>\\r\\n            %content%\\r\\n        <\\/div>\\r\\n\\r\\n    <\\/div>\\r\\n\\r\\n    <footer class=\\"footer\\">\\r\\n        <div class=\\"row\\">\\r\\n            <div class=\\"col-md-6\\">\\r\\n                <a href=\\"http:\\/\\/tangobb.com\\/\\">Powered by TangoBB<\\/a><br\\/>\\r\\n                <small class=\\"text-muted\\">Load Time: %elapsed_time% seconds | Memory: %memory_usage%<\\/small>\\r\\n            <\\/div>\\r\\n            <div class=\\"col-md-6 change_theme\\">\\r\\n                @if( $TANGO->sess->isLogged )\\r\\n                <div class=\\"btn-group dropup\\">\\r\\n                    <button type=\\"button\\" class=\\"btn btn-link dropdown-toggle\\" data-toggle=\\"dropdown\\">\\r\\n                        Change Theme <span class=\\"caret\\"><\\/span>\\r\\n                    <\\/button>\\r\\n                    <ul class=\\"dropdown-menu dropdown-menu-right\\" role=\\"menu\\">\\r\\n                        @foreach (listThemes() as $theme)\\r\\n                        @if ($theme[''id''] == $TANGO->sess->data[''chosen_theme''])\\r\\n                        <li class=\\"active\\"><a href=\\"{{ $theme[''change_link''] }}\\">\\r\\n                                {{ $theme[''theme_name''] }}\\r\\n                            <\\/a><\\/li>\\r\\n                        @else\\r\\n                        <li><a href=\\"{{ $theme[''change_link''] }}\\">\\r\\n                                {{ $theme[''theme_name''] }}\\r\\n                            <\\/a><\\/li>\\r\\n                        @endif\\r\\n                        @endforeach\\r\\n                    <\\/ul>\\r\\n                <\\/div>\\r\\n                @endif\\r\\n            <\\/div>\\r\\n        <\\/div>\\r\\n    <\\/footer>\\r\\n\\r\\n<\\/div>\\r\\n<!-- Include all compiled plugins (below), or include individual files as needed -->\\r\\n%highlighter_footer%\\r\\n<script src=\\"%site_url%\\/public\\/themes\\/Sand\\/assets\\/js\\/bootstrap.min.js\\"><\\/script>\\r\\n<script src=\\"%site_url%\\/public\\/themes\\/Sand\\/assets\\/js\\/sand.js\\"><\\/script>\\r\\n<\\/body>\\r\\n<\\/html>"\n    },\n    "entities": {\n        "quote_post": "\\r\\n<blockquote>%quoted_post_content%\\r\\n    <small>%quoted_post_user%<\\/small>\\r\\n<\\/blockquote>\\r\\n",\n        "thread_closed": "\\r\\n<i class=\\"glyphicon glyphicon-lock pull-right\\" title=\\"Thread Closed\\" style=\\"margin-right:2px;margin-left:2px;\\"><\\/i>\\r\\n",\n        "thread_stickied": "\\r\\n<i class=\\"glyphicon glyphicon-tag pull-right\\" style=\\"margin-right:2px;margin-left:2px;\\" title=\\"Thread Stickied\\"><\\/i>\\r\\n",\n        "danger_notice": "\\r\\n<div class=\\"alert alert-danger\\">%content%<\\/div>\\r\\n",\n        "success_notice": "\\r\\n<div class=\\"alert alert-success\\">%content%<\\/div>\\r\\n",\n        "warning_notice": "\\r\\n<div class=\\"alert alert-warning\\">%content%<\\/div>\\r\\n",\n        "breadcrumbs": "\\r\\n<ol class=\\"breadcrumb\\">\\r\\n    %bread%\\r\\n<\\/ol>\\r\\n",\n        "breadcrumbs_before": "\\r\\n<li><a href=\\"%link%\\">%name%<\\/a><\\/li>\\r\\n",\n        "breadcrumbs_current": "\\r\\n<li class=\\"active\\">%name%<\\/li>\\r\\n",\n        "pagination": "\\r\\n<ul class=\\"pagination pull-right\\">\\r\\n    %pages%\\r\\n<\\/ul>\\r\\n",\n        "pagination_links": "\\r\\n<li><a href=\\"%url%\\">%page%<\\/a><\\/li>\\r\\n",\n        "pagination_link_current": "\\r\\n<li class=\\"active\\"><a href=\\"#\\">%page%<\\/a><\\/li>\\r\\n",\n        "members_page_head": "\\r\\n<div style=\\"height:auto;\\">\\r\\n    <div class=\\"btn-group\\">\\r\\n        <button type=\\"button\\" class=\\"btn btn-default dropdown-toggle\\" data-toggle=\\"dropdown\\">\\r\\n            <i class=\\"glyphicon glyphicon-sort\\"><\\/i>\\r\\n        <\\/button>\\r\\n        <ul class=\\"dropdown-menu\\" role=\\"menu\\">\\r\\n            <li><a href=\\"%sort_date_joined_asc%\\"><i class=\\"glyphicon glyphicon-sort-by-order\\"><\\/i> Date Joined Ascending<\\/a>\\r\\n            <\\/li>\\r\\n            <li><a href=\\"%sort_date_joined_desc%\\"><i class=\\"glyphicon glyphicon-sort-by-order-alt\\"><\\/i> Date Joined\\r\\n                    Descending<\\/a><\\/li>\\r\\n            <li><a href=\\"%sort_name_asc%\\"><i class=\\"glyphicon glyphicon-sort-by-alphabet\\"><\\/i> Username Ascending<\\/a>\\r\\n            <\\/li>\\r\\n            <li><a href=\\"%sort_name_desc%\\"><i class=\\"glyphicon glyphicon-sort-by-alphabet-alt\\"><\\/i> Username Descending<\\/a>\\r\\n            <\\/li>\\r\\n        <\\/ul>\\r\\n    <\\/div>\\r\\n<\\/div>\\r\\n%members%\\r\\n",\n        "members_page": "\\r\\n<div style=\\"padding:10px 0px 10px 0px;border-bottom:dashed 1px #ccc;overflow:auto;\\">\\r\\n    <img src=\\"%avatar%\\" style=\\"width:65px;height:65px;margin-right:5px;\\" class=\\"img-thumbnail pull-left\\"\\/>\\r\\n    <a href=\\"%profile_url%\\">%username%<\\/a><br\\/>\\r\\n    <small class=\\"text-muted\\">Joined:<\\/small>\\r\\n    <small>%date_joined%<\\/small>\\r\\n    <br\\/>\\r\\n    <small class=\\"text-muted\\">Messages:<\\/small>\\r\\n    <small>%postcount%<\\/small>\\r\\n<\\/div>\\r\\n",\n        "thread_starter": "\\r\\n%breadcrumbs%\\r\\n%thread_notice%\\r\\n<div style=\\"overflow:auto;\\">\\r\\n    <p class=\\"pull-left\\" style=\\"padding-top:15px;padding-bottom:0;margin:0;\\">\\r\\n        %watch_link%\\r\\n    <\\/p>\\r\\n\\r\\n    <p class=\\"pull-right\\">\\r\\n        %reply_button%\\r\\n    <\\/p>\\r\\n<\\/div>\\r\\n<div class=\\"panel panel-success\\">\\r\\n    <div class=\\"panel-body\\">\\r\\n        <div class=\\"user_details\\">\\r\\n            <div class=\\"pull-left\\">\\r\\n                <img src=\\"%user_avatar%\\" class=\\"img-thumbnail\\" style=\\"height:70px;width:70px;\\">\\r\\n            <\\/div>\\r\\n            <div class=\\"name\\">\\r\\n                <a href=\\"%profile_url%\\">%username%<\\/a><br\\/>\\r\\n                <small class=\\"text-muted\\">Joined:<\\/small>\\r\\n                <small>%date_joined%<\\/small>\\r\\n                <br\\/>\\r\\n                <small class=\\"text-muted\\">Messages:<\\/small>\\r\\n                <small>%postcount%<\\/small>\\r\\n            <\\/div>\\r\\n        <\\/div>\\r\\n        <div class=\\"thread_content\\">\\r\\n            %poll% %thread_content%\\r\\n        <\\/div>\\r\\n        <div class=\\"signature\\">\\r\\n            %user_signature%\\r\\n        <\\/div>\\r\\n        <div class=\\"tools\\">\\r\\n            <div class=\\"pull-left\\">\\r\\n                <small>Posted %post_time%<\\/small>\\r\\n                <br\\/>\\r\\n                %mod_tools%\\r\\n            <\\/div>\\r\\n            <div class=\\"pull-right\\">\\r\\n                %quote_post%\\r\\n                %edit_post%\\r\\n                %report_post%\\r\\n            <\\/div>\\r\\n        <\\/div>\\r\\n    <\\/div>\\r\\n<\\/div>\\r\\n",\n        "thread_top": "\\r\\n%breadcrumbs%\\r\\n%thread_notice%\\r\\n<div style=\\"overflow:auto;\\">\\r\\n    <p class=\\"pull-left\\" style=\\"padding-top:15px;padding-bottom:0;margin:0;\\">\\r\\n        %watch_link%\\r\\n    <\\/p>\\r\\n\\r\\n    <p class=\\"pull-right\\">\\r\\n        %reply_button%\\r\\n    <\\/p>\\r\\n<\\/div>\\r\\n",\n        "thread_reply": "\\r\\n<div id=\\"%post_id%\\">\\r\\n    <div class=\\"panel panel-default\\">\\r\\n        <div class=\\"panel-body\\">\\r\\n            <div class=\\"user_details\\">\\r\\n                <div class=\\"pull-left\\">\\r\\n                    <img src=\\"%user_avatar%\\" class=\\"img-thumbnail\\" style=\\"height:70px;width:70px;\\">\\r\\n                <\\/div>\\r\\n                <div class=\\"name\\">\\r\\n                    <a href=\\"%profile_url%\\">%username%<\\/a><br\\/>\\r\\n                    <small class=\\"text-muted\\">Joined:<\\/small>\\r\\n                    <small>%date_joined%<\\/small>\\r\\n                    <br\\/>\\r\\n                    <small class=\\"text-muted\\">Messages:<\\/small>\\r\\n                    <small>%postcount%<\\/small>\\r\\n                <\\/div>\\r\\n            <\\/div>\\r\\n            <div class=\\"thread_content\\">\\r\\n                %reply_content%\\r\\n            <\\/div>\\r\\n            <div class=\\"signature\\">\\r\\n                %user_signature%\\r\\n            <\\/div>\\r\\n            <div class=\\"tools\\">\\r\\n                <div class=\\"pull-left\\">\\r\\n                    <small>Posted %post_time%<\\/small>\\r\\n                    <br\\/>\\r\\n                    %mod_tools%\\r\\n                <\\/div>\\r\\n                <div class=\\"pull-right\\">\\r\\n                    %quote_post%\\r\\n                    %edit_post%\\r\\n                    %report_post%\\r\\n                <\\/div>\\r\\n            <\\/div>\\r\\n        <\\/div>\\r\\n    <\\/div>\\r\\n<\\/div>\\r\\n",\n        "reply_thread": "\\r\\n<div id=\\"reply\\" class=\\"panel-body\\">\\r\\n    <form id=\\"%form_id%\\" action=\\"%reply_form_action%\\" method=\\"POST\\">\\r\\n        %csrf_input%\\r\\n        <textarea id=\\"%editor_id%\\" style=\\"width:100%;height:150px;max-width:100%;min-width:100%;\\"\\r\\n                  name=\\"%textarea_name%\\"><\\/textarea>\\r\\n\\r\\n        <p class=\\"pull-right\\" style=\\"margin-top:5px;\\">\\r\\n            <input type=\\"submit\\" name=\\"%submit_name%\\" value=\\"Post Reply\\"\\/>\\r\\n        <\\/p>\\r\\n    <\\/form>\\r\\n<\\/div>\\r\\n",\n        "forum_listings_category": "\\r\\n<div class=\\"panel panel-success\\">\\r\\n    <div class=\\"panel-heading\\"><b>%category_name%<\\/b>\\r\\n        <small>%category_desc%<\\/small>\\r\\n    <\\/div>\\r\\n    <table class=\\"table table-striped\\">\\r\\n        <tbody>\\r\\n        %category_forums%\\r\\n        <\\/tbody>\\r\\n    <\\/table>\\r\\n<\\/div>\\r\\n",\n        "forum_listings_node": "\\r\\n<tr>\\r\\n    @if( ''%status%'' == ''read'')\\r\\n    <td><i class=\\"fa fa-folder-o fa-3 node-read\\"><\\/i><\\/td>\\r\\n    @else\\r\\n    <td><i class=\\"fa fa-folder fa-3 node-read\\"><\\/i><\\/td>\\r\\n    @endif\\r\\n    <td style=\\"width:70%;\\">\\r\\n        <span class=\\"tooltip_toggle\\" data-toggle=\\"tooltip\\" title=\\"%node_desc%\\" data-placement=\\"right\\">%node_name%<\\/span><br\\/>\\r\\n        <small>Sub-Forums: %sub_forums%<\\/small>\\r\\n    <\\/td>\\r\\n    <td style=\\"width:30%;\\">\\r\\n        %latest_post%\\r\\n    <\\/td>\\r\\n<\\/tr>\\r\\n",\n        "forum_listings_node_latest": "\\r\\n<img src=\\"%user_avatar%\\" class=\\"img-thumbnail pull-left\\" style=\\"width:42;height:42px;margin-right:5px;\\"\\/>\\r\\n%latest_post%<br\\/>\\r\\n<small>%post_user%, %post_time%<\\/small>\\r\\n",\n        "forum_listings_node_threads": "\\r\\n%breadcrumbs%\\r\\n%sub_forums%\\r\\n<div style=\\"height:auto;\\">\\r\\n    <p class=\\"pull-right\\">\\r\\n        %post_thread_button%\\r\\n    <\\/p>\\r\\n\\r\\n    <p class=\\"pull-left\\">\\r\\n\\r\\n    <div class=\\"btn-group\\">\\r\\n        <button type=\\"button\\" class=\\"btn btn-default dropdown-toggle\\" data-toggle=\\"dropdown\\">\\r\\n            <i class=\\"glyphicon glyphicon-sort\\"><\\/i>\\r\\n        <\\/button>\\r\\n        <ul class=\\"dropdown-menu\\" role=\\"menu\\">\\r\\n            <li><a href=\\"%sort_latest_created%\\"><i class=\\"glyphicon glyphicon-sort-by-order\\"><\\/i> By Latest Created<\\/a>\\r\\n            <\\/li>\\r\\n            <li><a href=\\"%sort_name_desc%\\"><i class=\\"glyphicon glyphicon-sort-by-alphabet-alt\\"><\\/i> By Name\\r\\n                    Descending<\\/a><\\/li>\\r\\n            <li><a href=\\"%sort_name_asc%\\"><i class=\\"glyphicon glyphicon-sort-by-alphabet\\"><\\/i> By Name Ascending<\\/a>\\r\\n            <\\/li>\\r\\n            <li><a href=\\"%sort_last_updated%\\"><i class=\\"glyphicon glyphicon-sort-by-attributes-alt\\"><\\/i> By Last Updated<\\/a>\\r\\n            <\\/li>\\r\\n        <\\/ul>\\r\\n    <\\/div>\\r\\n    <\\/p>\\r\\n<\\/div>\\r\\n<table class=\\"table table-hover\\">\\r\\n    <thead>\\r\\n    <tr>\\r\\n        <th style=\\"width:70%;\\">Thread<\\/th>\\r\\n        <th style=\\"width:30%;\\">Last Post<\\/th>\\r\\n    <\\/tr>\\r\\n    <\\/thead>\\r\\n    <tbody>\\r\\n    %threads%\\r\\n    <\\/tbody>\\r\\n<\\/table>\\r\\n",\n        "forum_listings_node_sub_forums": "\\r\\n<table class=\\"table table-hover\\">\\r\\n    <thead>\\r\\n    <tr>\\r\\n        <th style=\\"width:70%;\\"><\\/th>\\r\\n        <th style=\\"width:30%;\\"><\\/th>\\r\\n    <\\/tr>\\r\\n    <\\/thead>\\r\\n    <tbody>\\r\\n    %nodes%\\r\\n    <\\/tbody>\\r\\n<\\/table>\\r\\n",\n        "forum_listings_node_sub_forums_posts": "\\r\\n<tr>\\r\\n    <td>%node_name%<br\\/>\\r\\n        <small>%node_desc%<\\/small>\\r\\n    <\\/td>\\r\\n    <td>\\r\\n        %latest_post%\\r\\n    <\\/td>\\r\\n<\\/tr>\\r\\n",\n        "forum_listings_node_sub_forums_latest": "\\r\\n<img src=\\"%user_avatar%\\" class=\\"img-thumbnail pull-left\\" style=\\"width:42;height:42px;margin-right:5px;\\"\\/>\\r\\n<span class=\\"pull-right\\" style=\\"text-align:right;\\">\\r\\n    %latest_post%<br\\/>\\r\\n    <small>%post_user%, %post_time%<\\/small>\\r\\n<\\/span>\\r\\n",\n        "forum_listings_node_threads_posts": "\\r\\n<tr>\\r\\n    <td><img src=\\"%user_avatar%\\" class=\\"img-thumbnail pull-left\\" style=\\"width:42;height:42px;margin-right:5px;\\"\\/>%label% %thread_name%\\r\\n        <span class=\\"label label-info pull-right\\">%status%<\\/span><br\\/>\\r\\n        <small>%user%, %post_time%<\\/small>\\r\\n    <\\/td>\\r\\n    <td>\\r\\n        %latest_post%\\r\\n    <\\/td>\\r\\n<\\/tr>\\r\\n",\n        "forum_listings_node_threads_latestreply": "\\r\\n<img src=\\"%user_avatar%\\" class=\\"img-thumbnail pull-left\\" style=\\"width:42;height:42px;margin-right:5px;\\"\\/>\\r\\n<span class=\\"pull-right\\" style=\\"text-align:right;\\">\\r\\n    %post_user%<br\\/><small>%post_time%<\\/small>\\r\\n<\\/span>\\r\\n",\n        "create_thread": "%breadcrumbs%\\r\\n<form id=\\"%form_id%\\" action=\\"%create_thread_form_action%\\" method=\\"POST\\">\\r\\n    %csrf_input%\\r\\n    %labels%\\r\\n    <input type=\\"text\\" name=\\"%title_name%\\" placeholder=\\"Thread Title...\\" style=\\"width:%width%%;\\" class=\\"col-sm-9 form-control\\"\\/>\\r\\n    <div class=\\"clearfix\\"><\\/div>\\r\\n    <br\\/>\\r\\n    <textarea id=\\"%editor_id%\\" style=\\"width:100%;height:300px;max-width:100%;\\" name=\\"%textarea_name%\\"><\\/textarea>\\r\\n\\r\\n    <div class=\\"center-block\\" style=\\"margin-top:5px;\\">\\r\\n        <input type=\\"submit\\" name=\\"%submit_name%\\" value=\\"Create Thread\\"\\/>\\r\\n    <\\/div>",\n        "reply_thread_page": "\\r\\n%breadcrumbs%\\r\\n%quote_post%\\r\\n<form id=\\"%form_id%\\" action=\\"%create_thread_form_action%\\" method=\\"POST\\">\\r\\n    %csrf_input%\\r\\n    <textarea id=\\"%editor_id%\\" style=\\"width:100%;height:300px;max-width:100%;\\" name=\\"%textarea_name%\\"><\\/textarea>\\r\\n\\r\\n    <div class=\\"center-block\\" style=\\"margin-top:5px;\\">\\r\\n        <input type=\\"submit\\" name=\\"%submit_name%\\" value=\\"Reply Thread\\"\\/>\\r\\n        <a href=\\"%thread_url%\\">Return<\\/a>\\r\\n    <\\/div>\\r\\n<\\/form>\\r\\n",\n        "user_profile_page": "\\r\\n<div class=\\"well\\" style=\\"overflow:auto;\\">\\r\\n    <p class=\\"pull-left\\">\\r\\n        <font class=\\"lead\\">%username% %gender%<\\/font>\\r\\n        <br\\/>\\r\\n        (%usergroup%)<br\\/>\\r\\n        <b>Registered On:<\\/b> %registered_date% <br\\/>\\r\\n        <b>Location:<\\/b> %flag% %location%<br\\/>\\r\\n        <b>Age:<\\/b> %age%\\r\\n    <\\/p>\\r\\n\\r\\n    <p class=\\"pull-right\\">\\r\\n        <img src=\\"%user_avatar%\\" class=\\"img-thumbnail\\" style=\\"width:75px;height:75px;\\"\\/>\\r\\n    <\\/p>\\r\\n<\\/div>\\r\\n<ul class=\\"nav nav-tabs\\">\\r\\n    <li class=\\"active\\"><a href=\\"#profile_comments\\" data-toggle=\\"tab\\">Profile Comments<\\/a><\\/li>\\r\\n    <li><a href=\\"#profile_info\\" data-toggle=\\"tab\\">Information<\\/a><\\/li>\\r\\n    <li><a href=\\"#profile_activity\\" data-toggle=\\"tab\\">Recent Activity<\\/a><\\/li>\\r\\n<\\/ul>\\r\\n<div class=\\"tab-content\\">\\r\\n    <div class=\\"tab-pane active\\" id=\\"profile_comments\\">\\r\\n        <br\\/>\\r\\n        %comments%\\r\\n        %form%\\r\\n        <\\/div>\\r\\n    <div class=\\"tab-pane\\" id=\\"profile_info\\">\\r\\n        <strong>About User:<\\/strong><br\\/>\\r\\n\\r\\n        <div class=\\"well\\">\\r\\n            %about_user%\\r\\n        <\\/div>\\r\\n        <strong>Signature:<\\/strong><br\\/>\\r\\n\\r\\n        <div class=\\"well\\">\\r\\n            %user_signature%\\r\\n        <\\/div>\\r\\n        <strong>Recent Visitors:<\\/strong><br\\/>\\r\\n\\r\\n        <div class=\\"well\\">\\r\\n            %visitors%\\r\\n        <\\/div>\\r\\n        %mod_tools%\\r\\n    <\\/div>\\r\\n    <div class=\\"tab-pane\\" id=\\"profile_activity\\">\\r\\n        <br\\/>\\r\\n        %recent_activity%\\r\\n    <\\/div>\\r\\n<\\/div>\\r\\n",\n        "user_profile_comments": "<div>\\r\\n  <table>\\r\\n    <tr>\\r\\n   \\t\\t<td><a href=\\"%profile_url%\\"><img src=\\"%avatar%\\" width=\\"50px\\" height=\\"50px\\" \\/><\\/a><\\/td>\\r\\n      \\t<td style=\\"padding-left: 10px;\\"><a href=\\"%profile_url%\\">%writer%<\\/a> - %date%<br\\/>%comment%<\\/td>\\r\\n    <\\/tr>\\r\\n  <\\/table>\\r\\n  <hr\\/>\\r\\n<\\/div>",\n        "user_profile_comments_form": "\\r\\n<form action=\\"%comments_action%\\" method=\\"POST\\">\\r\\n    <textarea id=\\"\\" style=\\"width:100%;height:120px;max-width:100%;\\" name=\\"comment\\"><\\/textarea>\\r\\n\\r\\n    <div class=\\"center-block\\" style=\\"margin-top:5px;\\">\\r\\n        <input type=\\"submit\\" name=\\"comment_submit\\" value=\\"Post Comment\\"\\/>\\r\\n    <\\/div>\\r\\n<\\/form>\\r\\n",\n        "advanced_search": "<form action=\\"%site_url%\\/search.php\\" method=\\"POST\\">\\r\\n  <div class=''form-group''>\\r\\n    <label for=''search_field''>Search<\\/label>\\r\\n    <input placeholder=''Enter search query'' name=\\"search_query\\" type=''text'' id=''search_field''>\\r\\n  <\\/div>\\r\\n  <div class=''form-group''>\\r\\n  \\t<label for=\\"\\">Timeframe<\\/label>\\r\\n    <div class=\\"form-inline\\">\\r\\n      <input type=\\"text\\" style=\\"width: 200px; float: left;\\" name=\\"time_from\\" id=\\"time_from\\" placeholder=\\"from DD-MM-YYYY\\" \\/>\\r\\n      <span style=\\"padding-left: 5px; padding-right: 5px; font-size:20px; padding-top: 10px; float: left;\\">-<\\/span> \\r\\n      \\r\\n      <input type=\\"text\\" style=\\"width: 200px;\\" name=\\"time_to\\" id=\\"time_to\\" placeholder=\\"to DD-MM-YYYY\\" \\/>\\r\\n  <\\/div>\\r\\n    <\\/div>\\r\\n  <div class=''form-group clearfix''>\\r\\n    <label>Advanced parameter<\\/label>\\r\\n  <\\/div>\\r\\n  <div class=\\"checkbox\\">\\r\\n    <label class=''checkbox-inline'' for=\\"user_search\\">\\r\\n      <input type=''checkbox'' name=\\"user_search\\" id=\\"user_search\\" CHECKED> Search for users? \\r\\n    <\\/label>\\r\\n    <label class=''checkbox-inline'' for=\\"boolean_mode\\">\\r\\n      <input type=''checkbox'' name=\\"boolean_mode\\" id=\\"boolean_mode\\"> Boolean-Mode? \\r\\n    <\\/label>\\r\\n  <\\/div>\\r\\n      <input type=\\"hidden\\" value=\\"advanced\\" name=\\"search_type\\" \\/>\\r\\n      <input type=\\"submit\\" value=\\"Search\\" name=\\"search_submit\\" \\/>\\r\\n<\\/form>\\r\\n  ",\n        "search_page": "\\r\\n<br /></b7><ul class=\\"nav nav-tabs\\">\\r\\n    <li class=\\"active\\"><a href=\\"#search_threads\\" data-toggle=\\"tab\\">Threads<\\/a><\\/li>\\r\\n    <li><a href=\\"#search_users\\" data-toggle=\\"tab\\">Users<\\/a><\\/li>\\r\\n<\\/ul>\\r\\n<div class=\\"tab-content\\">\\r\\n    <div class=\\"tab-pane active\\" id=\\"search_threads\\">\\r\\n        <br\\/>\\r\\n        %searched_threads%\\r\\n    <\\/div>\\r\\n    <div class=\\"tab-pane\\" id=\\"search_users\\">\\r\\n        <br\\/>\\r\\n        %searched_users%\\r\\n    <\\/div>\\r\\n<\\/div>\\r\\n",\n        "mod_reports": "\\r\\n<ul class=\\"nav nav-tabs\\">\\r\\n    <li class=\\"active\\"><a href=\\"#mod_post_reports\\" data-toggle=\\"tab\\">Reported Posts<\\/a><\\/li>\\r\\n    <li><a href=\\"#mod_user_reports\\" data-toggle=\\"tab\\">Reported Users<\\/a><\\/li>\\r\\n<\\/ul>\\r\\n<div class=\\"tab-content\\">\\r\\n    <div class=\\"tab-pane active\\" id=\\"mod_post_reports\\">\\r\\n        <br\\/><br\\/>\\r\\n        %reported_posts%\\r\\n    <\\/div>\\r\\n    <div class=\\"tab-pane\\" id=\\"mod_user_reports\\">\\r\\n        <br\\/><br\\/>\\r\\n        %reported_users%\\r\\n    <\\/div>\\r\\n<\\/div>\\r\\n",\n        "content_box": "\\r\\n<div class=\\"panel panel-default\\">\\r\\n    <div class=\\"panel-heading\\">\\r\\n        <h3 class=\\"panel-title\\">%content_header%<\\/h3>\\r\\n    <\\/div>\\r\\n    <div class=\\"panel-body\\">\\r\\n        %content_body%\\r\\n    <\\/div>\\r\\n<\\/div>\\r\\n",\n        "register_form": "\\r\\n<form action=\\"\\" method=\\"POST\\">\\r\\n    %notice%\\r\\n    %csrf_field%\\r\\n    <label for=\\"username\\">Username<\\/label>\\r\\n    <input type=\\"text\\" name=\\"%username_field_name%\\" value=\\"%form_username_value%\\" id=\\"username\\" class=\\"form-control\\"\\/>\\r\\n    <label for=\\"password\\">Password<\\/label>\\r\\n    <input type=\\"password\\" name=\\"%password_field_name%\\" id=\\"password\\" class=\\"form-control\\"\\/>\\r\\n    <label for=\\"a_password\\">Confirm Password<\\/label>\\r\\n    <input type=\\"password\\" name=\\"%password_a_field_name%\\" id=\\"a_password\\" class=\\"form-control\\"\\/>\\r\\n    <label for=\\"email\\">Email<\\/label>\\r\\n    <input type=\\"text\\" name=\\"%email_field_name%\\" value=\\"%form_email_value%\\" id=\\"email\\" class=\\"form-control\\"\\/>\\r\\n    <label for=\\"tangobb_captcha\\">Are you a bot?<\\/label><br\\/>\\r\\n    %captcha%\\r\\n    <br\\/><br\\/>\\r\\n    <input type=\\"submit\\" name=\\"%submit_name%\\" value=\\"Register\\" class=\\"btn btn-default\\"\\/>\\r\\n    %register_notice%\\r\\n<\\/form>\\r\\n",\n        "login_form": "\\r\\n<form action=\\"\\" method=\\"POST\\">\\r\\n    <label for=\\"email\\">Username or Email<\\/label>\\r\\n    <input type=\\"text\\" name=\\"%email_field_name%\\" id=\\"email\\" class=\\"form-control\\"\\/>\\r\\n    <label for=\\"password\\">Password<\\/label>\\r\\n    <input type=\\"password\\" name=\\"%password_field_name%\\" id=\\"password\\" class=\\"form-control\\"\\/>\\r\\n    <br\\/>\\r\\n    <input type=\\"submit\\" name=\\"%submit_field_name%\\" value=\\"Sign In\\" class=\\"btn btn-default\\"\\/>\\r\\n    <input type=\\"checkbox\\" name=\\"%remember_field_name%\\"\\/> Remember Me\\r\\n    <a href=\\"%site_url%\\/members.php\\/cmd\\/forgotpassword\\" class=\\"btn btn-link\\">Forgot Password<\\/a>\\r\\n<\\/form>\\r\\n",\n        "forget_password_form": "\\r\\n<form action=\\"\\" method=\\"POST\\" id=\\"tango_form\\">\\r\\n    %csrf_field%\\r\\n    <label for=\\"email\\">Email<\\/label>\\r\\n    <input type=\\"text\\" name=\\"%email_field_name%\\" id=\\"email\\" class=\\"form-control\\"\\/>\\r\\n    <br\\/><br\\/>\\r\\n    <input type=\\"submit\\" name=\\"%submit_field_name%\\" value=\\"Send Email\\" class=\\"btn btn-default\\"\\/>\\r\\n<\\/form>\\r\\n",\n        "reset_password_form": "\\r\\n<form action=\\"\\" method=\\"POST\\" id=\\"tango_form\\">\\r\\n    %csrf_field%\\r\\n    <label for=\\"password\\">Password<\\/label>\\r\\n    <input type=\\"password\\" name=\\"%password_field_name%\\" id=\\"password\\" class=\\"form-control\\"\\/>\\r\\n    <label for=\\"a_password\\">Confirm Password<\\/label>\\r\\n    <input type=\\"password\\" name=\\"%password_a_field_name%\\" id=\\"a_password\\" class=\\"form-control\\"\\/>\\r\\n    <br\\/><br\\/>\\r\\n    <input type=\\"submit\\" name=\\"%submit_field_name%\\" value=\\"Reset Password\\" class=\\"btn btn-default\\"\\/>\\r\\n<\\/form>\\r\\n",\n        "conversation_read": "\\r\\n<span class=\\"pull-right\\"><i class=\\"glyphicon glyphicon-eye-open\\"><\\/i><\\/span>\\r\\n",\n        "conversation_unread": "\\r\\n<span class=\\"pull-right\\"><i class=\\"glyphicon glyphicon-eye-close\\"><\\/i><\\/span>\\r\\n",\n        "conversation_new_message": "\\r\\n<span class=\\"label label-success pull-right\\">New messages<\\/span>\\r\\n",\n        "conversation_delete": "\\r\\n<a href=\\"%link%\\"><i class=\\"glyphicon glyphicon-trash\\"><\\/i><\\/a>\\r\\n",\n        "conversation_overview": "\\r\\n<div class=\\"panel panel-default\\">\\r\\n    <div class=\\"panel-heading\\"><strong>%overview_header%<\\/strong><\\/div>\\r\\n    <div class=\\"panel-body\\">\\r\\n        %conversations%\\r\\n    <\\/div>\\r\\n<\\/div>\\r\\n",\n        "smiley_list": "\\r\\n<br\\/>\\r\\n<ul class=\\"nav nav-tabs\\">\\r\\n    <li class=\\"active\\"><a href=\\"#smilies\\" data-toggle=\\"tab\\">Smilies<\\/a><\\/li>\\r\\n    <li><a href=\\"#misc\\" data-toggle=\\"tab\\">Misc<\\/a><\\/li>\\r\\n    <li><a href=\\"#food\\" data-toggle=\\"tab\\">Food<\\/a><\\/li>\\r\\n    <li><a href=\\"#plants\\" data-toggle=\\"tab\\">Plants<\\/a><\\/li>\\r\\n    <li><a href=\\"#animals\\" data-toggle=\\"tab\\">Animals<\\/a><\\/li>\\r\\n<\\/ul>\\r\\n<div class=\\"tab-content\\">\\r\\n    <div class=\\"tab-pane active\\" id=\\"smilies\\">\\r\\n        %smilies%\\r\\n    <\\/div>\\r\\n    <div class=\\"tab-pane\\" id=\\"misc\\">\\r\\n        %misc%\\r\\n    <\\/div>\\r\\n    <div class=\\"tab-pane\\" id=\\"food\\">\\r\\n        %food%\\r\\n    <\\/div>\\r\\n    <div class=\\"tab-pane\\" id=\\"plants\\">\\r\\n        %plants%\\r\\n    <\\/div>\\r\\n    <div class=\\"tab-pane\\" id=\\"animals\\">\\r\\n        %animals%\\r\\n    <\\/div>\\r\\n<\\/div>\\r\\n",\n        "poll_list": "%answer%\\r\\n<div class=\\"progress\\">\\r\\n    <div class=\\"progress-bar progress-bar-success\\" role=\\"progressbar\\" aria-valuenow=\\"%now%\\" aria-valuemin=\\"0\\" aria-valuemax=\\"%total%\\" style=\\"width: %percentage%%;\\">\\r\\n    <\\/div>\\r\\n<\\/div>",\n        "poll_overview": "<div style=\\"border: 1px solid #F8F5F0; border-radius: 4px; padding: 15px;margin: 0 auto;float:none;\\" class=\\"col-md-10\\">\\r\\n<b>%question%<\\/b><br \\/>\\r\\n%poll_list%\\r\\n<\\/div>\\r\\n<div class=\\"clearfix\\"><\\/div>",\n        "poll_form": "<form action=\\"\\" method=\\"POST\\">\\r\\n%answers%\\r\\n<input type=\\"submit\\" name=\\"submit_form\\" value=\\"Vote now!\\"\\/>\\r\\n<\\/form>",\n        "thread_options": "<script>\\r\\nvar field = 3;\\r\\nvar counter = 1;\\r\\nvar i = 3;\\r\\nfunction plus() {\\r\\n  var content = new Array();\\r\\n    field++;\\r\\n    for (counter = 3; counter < (field-1); counter++) {\\r\\n        content[counter] = document.getElementById(\\"answer_\\" + counter).value;\\r\\n    }\\r\\n    document.getElementById(\\"dynamic\\").innerHTML = \\"\\";\\r\\n    for (i = 3; i < field; i++) {\\r\\n        if (typeof(content[i]) == \\"undefined\\")\\r\\n        {\\r\\n            content[i] =\\"\\";\\r\\n        }\\r\\n        document.getElementById(\\"dynamic\\").innerHTML +=\\r\\n   \\"<label for=''answer_\\" + i + \\"''>\\" + i + \\". Answer<\\/label><input type=''text'' value=''\\" + content[i] + \\"'' name=''answer_\\" + i + \\"'' id=''answer_\\" + i + \\"''  \\/>\\";\\r\\n    }\\r\\n}\\r\\n<\\/script>\\r\\n<br\\/>\\r\\n<ul class=\\"nav nav-tabs\\">\\r\\n    <li class=\\"active\\"><a href=\\"#polls\\" data-toggle=\\"tab\\">Polls<\\/a><\\/li>\\r\\n    <\\/ul>\\r\\n<div class=\\"tab-content\\">\\r\\n    <div class=\\"tab-pane active\\" id=\\"polls\\">\\r\\n         <div class=\\"col-md-6\\">\\r\\n             <label for=\\"question\\">Question<\\/label>\\r\\n             <input type=\\"text\\" name=\\"question\\" \\/>\\r\\n             <label for=\\"answer_1\\">1. Answer<\\/label>\\r\\n             <input type=\\"text\\" name=\\"answer_1\\" id=\\"answer_1\\" \\/>\\r\\n             <label for=\\"answer_2\\">2. Answer<\\/label>\\r\\n             <input type=\\"text\\" name=\\"answer_2\\" id=\\"answer_2\\" \\/>\\r\\n             <div id=\\"dynamic\\">\\r\\n             <\\/div>\\r\\n             <span href=\\"\\" onClick=\\"plus();\\"> Add an answer field <\\/span>\\r\\n         <\\/div>\\r\\n    <\\/div>\\r\\n  \\r\\n<\\/div>\\r\\n<\\/form>"\n    },\n    "buttons": {\n        "custom_button": "\\r\\n<a href=\\"%url%\\" class=\\"btn btn-primary\\">%name%<\\/a>\\r\\n",\n        "create_thread": "\\r\\n<a href=\\"%url%\\" class=\\"btn btn-primary\\"><i class=\\"fa fa-pencil\\"><\\/i> New Thread<\\/a>\\r\\n",\n        "reply_thread": "\\r\\n<a href=\\"#reply\\" class=\\"btn btn-primary btn-sm\\"><i class=\\"fa fa-reply\\"><\\/i> Reply<\\/a>\\r\\n",\n        "watch_thread": "\\r\\n<small><a href=\\"%url%\\">Watch Thread<\\/a><\\/small>\\r\\n",\n        "unwatch_thread": "\\r\\n<small><a href=\\"%url%\\">Unwatch Thread<\\/a><\\/small>\\r\\n",\n        "quote_post": "\\r\\n<a href=\\"%url%\\" class=\\"btn btn-primary btn-sm\\"><i class=\\"fa fa-quote-left\\"><\\/i> Quote<\\/a>\\r\\n",\n        "edit_post": "\\r\\n<a href=\\"%url%\\" class=\\"btn btn-primary btn-sm\\"><i class=\\"fa fa-pencil-square-o\\"><\\/i> Edit<\\/a>\\r\\n",\n        "report_post": "\\r\\n<a href=\\"%url%\\" class=\\"btn btn-primary btn-sm\\"><i class=\\"fa fa-exclamation-circle\\"><\\/i> Report<\\/a>\\r\\n",\n        "mod_tools": "\\r\\n<a href=\\"%stick_thread_url%\\">%stick_thread%<\\/a> | <a href=\\"%close_thread_url%\\">%close_thread%<\\/a> | <a\\r\\n    href=\\"%edit_post_url%\\">Edit Post<\\/a> | <a href=\\"%delete_post_url%\\">Delete Thread<\\/a>\\r\\n<br\\/>\\r\\n%move_thread_form%\\r\\n",\n        "mod_tools_posts": "\\r\\n<a href=\\"%edit_post_url%\\">Edit Post<\\/a> | <a href=\\"%delete_post_url%\\">Delete Post<\\/a>\\r\\n",\n        "mod_tools_profile": "\\r\\n<a href=\\"%ban_user_url%\\" class=\\"btn btn-primary\\">%ban_user%<\\/a>\\r\\n"\n    }\n}\n');
INSERT INTO `[[dbprefix]]themes` VALUES
(2, 'Blue', '1.0', '{\n    "templates": {\n        "forum": "<!DOCTYPE html>\\r\\n<html>\\r\\n<head>\\r\\n    <title>%site_name%<\\/title>\\r\\n    <meta name=\\"viewport\\" content=\\"width=device-width, initial-scale=1.0\\">\\r\\n    <meta name=\\"description\\" content=\\"%description%\\">\\r\\n\\r\\n    <meta property=\\"og:title\\" content=\\"%site_name%\\"\\/>\\r\\n    <meta property=\\"og:url\\" content=\\"%site_url%\\"\\/>\\r\\n    <meta property=\\"og:site_name\\" content=\\"%site_name%\\"\\/>\\r\\n    <meta property=\\"og:description\\" content=\\"%description%\\"\\/>\\r\\n    <meta property=\\"og:image\\" content=\\"\\"\\/>\\r\\n\\r\\n    <!-- Not supported tags:\\r\\n    <meta property=\\"fb:admins\\" content=\\"\\" \\/>\\r\\n    <meta property=\\"fb:page_id\\" content=\\"\\" \\/>\\r\\n    <meta property=\\"article:publisher\\" content=\\"\\" \\/>\\r\\n    <meta property=\\"article:author\\" content=\\"\\" \\/>\\r\\n    -->\\r\\n\\r\\n    <!-- Bootstrap -->\\r\\n    <link href=\\"%site_url%\\/public\\/themes\\/Blue\\/assets\\/css\\/bootstrap.min.css\\" rel=\\"stylesheet\\">\\r\\n    <link href=\\"%site_url%\\/public\\/themes\\/Blue\\/assets\\/css\\/bootstrap-theme.css\\" rel=\\"stylesheet\\">\\r\\n    <link href=\\"%site_url%\\/public\\/themes\\/Blue\\/assets\\/css\\/blue.css\\" rel=\\"stylesheet\\">\\r\\n    <link href=\\"\\/\\/netdna.bootstrapcdn.com\\/font-awesome\\/4.0.3\\/css\\/font-awesome.min.css\\" rel=\\"stylesheet\\">\\r\\n    <!-- Flags -->\\r\\n    <link href=\\"%site_url%\\/public\\/css\\/flag\\/css\\/flag-icon.css\\" rel=\\"stylesheet\\">\\r\\n\\r\\n    %editor_settings%\\r\\n    <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->\\r\\n    <!-- WARNING: Respond.js doesn''t work if you view the page via file:\\/\\/ -->\\r\\n    <!--[if lt IE 9]>\\r\\n    <script src=\\"https:\\/\\/oss.maxcdn.com\\/libs\\/html5shiv\\/3.7.0\\/html5shiv.js\\"><\\/script>\\r\\n    <script src=\\"https:\\/\\/oss.maxcdn.com\\/libs\\/respond.js\\/1.3.0\\/respond.min.js\\"><\\/script>\\r\\n    <![endif]-->\\r\\n<\\/head>\\r\\n<body>\\r\\n<div class=\\"container\\">\\r\\n    <a href=\\"#\\">\\r\\n        <div class=\\"logo pull-left\\"><\\/div>\\r\\n    <\\/a>\\r\\n\\r\\n    <div class=\\"search_box pull-right\\">\\r\\n        <form action=\\"%site_url%\\/search.php\\" method=\\"POST\\">\\r\\n            <div class=\\"left-inner-addon\\">\\r\\n                <i class=\\"glyphicon glyphicon-search\\"><\\/i>\\r\\n                <input name=\\"search_query\\" type=\\"text\\" class=\\"form-control tooltip_toggle\\" placeholder=\\"Search...\\"\\r\\n                       data-toggle=\\"tooltip\\" data-placement=\\"left\\" title=\\"Press Enter\\">\\r\\n                <input type=\\"submit\\" name=\\"search_submit\\" style=\\"visibility:hidden;display:none;\\" value=\\"Search\\"\\/>\\r\\n            <\\/div>\\r\\n        <\\/form>\\r\\n    <\\/div>\\r\\n<\\/div>\\r\\n\\r\\n<nav class=\\"navbar navbar-default\\" role=\\"navigation\\">\\r\\n    <div class=\\"container\\">\\r\\n        <div class=\\"navbar-header\\">\\r\\n            <button type=\\"button\\" class=\\"navbar-toggle\\" data-toggle=\\"collapse\\"\\r\\n                    data-target=\\"#bs-example-navbar-collapse-1\\">\\r\\n                <span class=\\"sr-only\\">Toggle navigation<\\/span>\\r\\n                <span class=\\"icon-bar\\"><\\/span>\\r\\n                <span class=\\"icon-bar\\"><\\/span>\\r\\n                <span class=\\"icon-bar\\"><\\/span>\\r\\n            <\\/button>\\r\\n        <\\/div>\\r\\n\\r\\n        <div class=\\"collapse navbar-collapse\\" id=\\"bs-example-navbar-collapse-1\\">\\r\\n            <ul class=\\"nav navbar-nav\\">\\r\\n                <li class=\\"active\\"><a href=\\"%site_url%\\">Forums<\\/a><\\/li>\\r\\n                <li><a href=\\"%site_url%\\/members.php\\">Members<\\/a><\\/li>\\r\\n            <\\/ul>\\r\\n            <ul class=\\"nav navbar-nav navbar-right\\">\\r\\n                @if ($TANGO->sess->isLogged)\\r\\n                <li class=\\"dropdown\\">\\r\\n                    <a href=\\"#\\" class=\\"dropdown-toggle\\" data-toggle=\\"dropdown\\"><i class=\\"glyphicon glyphicon-user\\"><\\/i>\\r\\n                        %username%<\\/a>\\r\\n                    <ul class=\\"dropdown-menu\\">\\r\\n                        @foreach ($TANGO->user->userLinks() as $name => $link)\\r\\n                        <li>\\r\\n                            <a href=\\"{{ $link }}\\">\\r\\n                                {{ $name }}\\r\\n                            <\\/a>\\r\\n                        <\\/li>\\r\\n                        @endforeach\\r\\n                    <\\/ul>\\r\\n                <\\/li>\\r\\n                <li class=\\"dropdown\\">\\r\\n                    <a href=\\"#\\" class=\\"dropdown-toggle\\" data-toggle=\\"dropdown\\">\\r\\n                        <i class=\\"glyphicon glyphicon-envelope\\"><\\/i> Conversations\\r\\n                        @if (count($TANGO->user->userMessages()) > 0)\\r\\n                        <span class=\\"label label-success\\">{{ count($TANGO->user->userMessages()) }}<\\/span>\\r\\n                        @endif\\r\\n                    <\\/a>\\r\\n                    <ul class=\\"dropdown-menu\\">\\r\\n                        @if (count($TANGO->user->userMessages()) > 0)\\r\\n                        @foreach ($TANGO->user->userMessages() as $msg)\\r\\n                        <li>\\r\\n                            <a href=\\"{{ $msg[''view_url''] }}\\">\\r\\n                                <h4>\\r\\n                                    {{ $msg[''message_title''] }}\\r\\n                                <\\/h4>\\r\\n                                <small>By {{ $msg[''message_sender''] }} at\\r\\n                                    {{ date(''F j, Y'', $msg[''message_time'']) }}\\r\\n                                <\\/small>\\r\\n                            <\\/a>\\r\\n                        <\\/li>\\r\\n                        @endforeach\\r\\n                        @else\\r\\n                        <li role=\\"presentation\\" class=\\"dropdown-header\\">No Messages<\\/li>\\r\\n                        @endif\\r\\n                        <li><a href=\\"%site_url%\\/conversations.php\\">Conversations<\\/a><\\/li>\\r\\n                        <li><a href=\\"%site_url%\\/conversations.php\\/cmd\\/new\\">New Message<\\/a><\\/li>\\r\\n                    <\\/ul>\\r\\n                <\\/li>\\r\\n                <li class=\\"dropdown\\">\\r\\n                    <a href=\\"#\\" class=\\"dropdown-toggle\\" data-toggle=\\"dropdown\\" style=\\"overflow:auto;\\">\\r\\n                        <i class=\\"fa fa-bell\\"><\\/i>\\r\\n                        @if (count($TANGO->user->notifications()) > 0)\\r\\n                                    <span class=\\"badge\\">\\r\\n                                        {{ count($TANGO->user->notifications()) }}\\r\\n                                    <\\/span>\\r\\n                        @endif\\r\\n                    <\\/a>\\r\\n                    <ul class=\\"dropdown-menu\\">\\r\\n                        @if (count($TANGO->user->notifications()) < 1)\\r\\n                        <li role=\\"presentation\\" class=\\"disabled\\"><a role=\\"menuitem\\" tabindex=\\"-1\\" href=\\"#\\">No new\\r\\n                                notifications yet.<\\/a><\\/li>\\r\\n                        @else\\r\\n                        @foreach ($TANGO->user->notifications() as $note)\\r\\n                        <li>\\r\\n                            <a href=\\"{{ $note[''notice_link''] }}\\">\\r\\n                                {{ $note[''notice_content''] }}\\r\\n                                <small class=\\"text-muted\\">{{ date(''F j, Y'', $note[''time_received'']) }}<\\/small>\\r\\n                            <\\/a>\\r\\n                        <\\/li>\\r\\n                        @endforeach\\r\\n                        {{ $TANGO->user->clearNotification() }}\\r\\n                        @endif\\r\\n                    <\\/ul>\\r\\n                <\\/li>\\r\\n                @else\\r\\n                <li><a href=\\"#\\" data-toggle=\\"modal\\" data-target=\\"#login_modal\\">Sign In<\\/a><\\/li>\\r\\n                @endif\\r\\n            <\\/ul>\\r\\n        <\\/div>\\r\\n    <\\/div>\\r\\n<\\/nav>\\r\\n\\r\\n<div id=\\"wrap\\" class=\\"container\\">\\r\\n    <div class=\\"row\\">\\r\\n\\r\\n        <div class=\\"col-md-9\\">\\r\\n            <h1>%site_name%<\\/h1>\\r\\n            %forum_listings%\\r\\n        <\\/div>\\r\\n\\r\\n        <div class=\\"col-md-3\\">\\r\\n            @if ($TANGO->perm->check(''access_moderation''))\\r\\n            <div style=\\"margin-bottom:10px;\\">\\r\\n                <a href=\\"%site_url%\\/mod\\" class=\\"btn btn-warning btn-lg btn-block\\">Reports <span\\r\\n                        class=\\"label label-warning\\">%mod_report_integer%<\\/span><\\/a>\\r\\n                @if ($TANGO->perm->check(''access_administration''))\\r\\n                <a href=\\"%site_url%\\/admin\\" class=\\"btn btn-danger btn-lg btn-block\\">Admin CP<\\/a>\\r\\n                @endif\\r\\n            <\\/div>\\r\\n            @endif\\r\\n            <div class=\\"panel panel-content\\">\\r\\n                <div class=\\"panel-body\\">\\r\\n                    @if ($TANGO->sess->isLogged)\\r\\n                    <div class=\\"row\\" style=\\"width:100%;overflow:auto;margin:0 auto;\\">\\r\\n                        <div class=\\"col-md-5\\">\\r\\n                            <img src=\\"%user_avatar%\\" class=\\"img-thumbnail pull-left\\"\\r\\n                                 style=\\"max-width:100x;max-height:100px;\\">\\r\\n                        <\\/div>\\r\\n                        <div class=\\"col-md-7\\">\\r\\n                            <a href=\\"%site_url%\\/members.php\\/cmd\\/user\\">%username_style%<\\/a>\\r\\n\\r\\n                            <div class=\\"row\\">\\r\\n                                <div class=\\"col-md-6\\">\\r\\n                                    <small>Messages:<\\/small>\\r\\n                                <\\/div>\\r\\n                                <div class=\\"col-md-6\\" style=\\"text-align:right;\\">\\r\\n                                    %user_post_count%\\r\\n                                <\\/div>\\r\\n                            <\\/div>\\r\\n                        <\\/div>\\r\\n                    <\\/div>\\r\\n                    @else\\r\\n                    <a href=\\"%site_url%\\/members.php\\/cmd\\/register\\" class=\\"btn btn-success btn-lg btn-block\\">Register<\\/a>\\r\\n                    @endif\\r\\n                <\\/div>\\r\\n            <\\/div>\\r\\n            <div class=\\"panel panel-content\\">\\r\\n                <div class=\\"panel-heading\\">\\r\\n                    <b><i class=\\"glyphicon glyphicon-stats\\"><\\/i> Forum Statistics<\\/b>\\r\\n                <\\/div>\\r\\n                <div class=\\"panel-body\\">\\r\\n                    <div class=\\"row\\">\\r\\n                        <div class=\\"col-md-6 text-muted\\">\\r\\n                            <small>Threads:<\\/small>\\r\\n                        <\\/div>\\r\\n                        <div class=\\"col-md-6\\" style=\\"text-align:right;\\">\\r\\n                            <small>%bb_stat_threads%<\\/small>\\r\\n                        <\\/div>\\r\\n                        <div class=\\"col-md-6 text-muted\\">\\r\\n                            <small>Replies:<\\/small>\\r\\n                        <\\/div>\\r\\n                        <div class=\\"col-md-6\\" style=\\"text-align:right;\\">\\r\\n                            <small>%bb_stat_posts%<\\/small>\\r\\n                        <\\/div>\\r\\n                        <div class=\\"col-md-6 text-muted\\">\\r\\n                            <small>Users:<\\/small>\\r\\n                        <\\/div>\\r\\n                        <div class=\\"col-md-6\\" style=\\"text-align:right;\\">\\r\\n                            <small>%bb_stat_users%<\\/small>\\r\\n                        <\\/div>\\r\\n                    <\\/div>\\r\\n                <\\/div>\\r\\n            <\\/div>\\r\\n            <div class=\\"panel panel-content\\">\\r\\n                <div class=\\"panel-heading\\">\\r\\n                    <b><i class=\\"glyphicon glyphicon-user\\"><\\/i> Users Online<\\/b>\\r\\n                <\\/div>\\r\\n                <div class=\\"panel-body\\">\\r\\n                    %users_online%\\r\\n                <\\/div>\\r\\n            <\\/div>\\r\\n        <\\/div>\\r\\n\\r\\n    <\\/div>\\r\\n    <footer>\\r\\n        <small class=\\"pull-left\\">\\r\\n            Powered by <a href=\\"http:\\/\\/tangobb.com\\/\\" target=\\"_blank\\">TangoBB<\\/a>\\r\\n        <\\/small>\\r\\n        @if ($TANGO->sess->isLogged)\\r\\n        <small class=\\"pull-right\\">\\r\\n            <span data-toggle=\\"tooltip\\" title=\\"Choose Themes\\" class=\\"tooltip_toggle\\">\\r\\n              <a href=\\"#\\" data-toggle=\\"modal\\" data-target=\\"#theme_modal\\">Change Theme<\\/a>\\r\\n            <\\/span>\\r\\n        <\\/small>\\r\\n        @endif\\r\\n    <\\/footer>\\r\\n<\\/div>\\r\\n\\r\\n<div class=\\"container statistics\\">\\r\\n    <small class=\\"text-muted\\">\\r\\n        Load Time: %elapsed_time% seconds |\\r\\n        Memory: %memory_usage%\\r\\n    <\\/small>\\r\\n<\\/div>\\r\\n\\r\\n@if (!$TANGO->sess->isLogged)\\r\\n<div class=\\"modal fade\\" id=\\"login_modal\\" tabindex=\\"-1\\" role=\\"dialog\\" aria-labelledby=\\"login_modal\\" aria-hidden=\\"true\\">\\r\\n    <div class=\\"modal-dialog\\">\\r\\n        <div class=\\"modal-content\\">\\r\\n            <div class=\\"modal-header\\">\\r\\n                <button type=\\"button\\" class=\\"close\\" data-dismiss=\\"modal\\" aria-hidden=\\"true\\">Ã—<\\/button>\\r\\n                <h4 class=\\"modal-title\\" id=\\"myModalLabel\\">Sign In<\\/h4>\\r\\n            <\\/div>\\r\\n            <div class=\\"modal-body\\">\\r\\n                <form action=\\"%site_url%\\/members.php\\/cmd\\/signin\\" method=\\"POST\\">\\r\\n                    <input type=\\"hidden\\" name=\\"current_url\\" value=\\"%current_url%\\" \\/>                    <input type=\\"text\\" name=\\"email\\" class=\\"form-control\\" id=\\"inputEmail3\\"\\r\\n                           placeholder=\\"Username or Email\\">\\r\\n                    <br\\/>\\r\\n                    <input type=\\"password\\" name=\\"password\\" class=\\"form-control\\" id=\\"inputPassword3\\"\\r\\n                           placeholder=\\"Password\\">\\r\\n                    <label>\\r\\n                        <input type=\\"checkbox\\" name=\\"remember\\"> Remember me\\r\\n                    <\\/label>\\r\\n                    <br\\/>\\r\\n                    <input type=\\"submit\\" class=\\"btn btn-primary\\" name=\\"signin\\" value=\\"Sign in\\"\\/>\\r\\n                    @if ($TANGO->data[''facebook_authenticate''] == \\"1\\")\\r\\n                    <a href=\\"%facebook_login_url%\\" class=\\"btn btn-info btn-sm\\"><i class=\\"fa fa-facebook\\"><\\/i> Sign In\\r\\n                        with Facebook<\\/a>\\r\\n                    @endif\\r\\n                    <br\\/>\\r\\n                    <a href=\\"%site_url%\\/members.php\\/cmd\\/forgotpassword\\">Forgot Password<\\/a>\\r\\n                <\\/form>\\r\\n            <\\/div>\\r\\n        <\\/div>\\r\\n    <\\/div>\\r\\n<\\/div>\\r\\n@endif\\r\\n\\r\\n@if ($TANGO->sess->isLogged)\\r\\n<div class=\\"modal fade\\" id=\\"theme_modal\\" tabindex=\\"-1\\" role=\\"dialog\\" aria-labelledby=\\"theme_modal\\" aria-hidden=\\"true\\">\\r\\n    <div class=\\"modal-dialog\\">\\r\\n        <div class=\\"modal-content\\">\\r\\n            <div class=\\"modal-header\\">\\r\\n                <button type=\\"button\\" class=\\"close\\" data-dismiss=\\"modal\\" aria-hidden=\\"true\\">Ã—<\\/button>\\r\\n                <h4 class=\\"modal-title\\" id=\\"myModalLabel\\">Choose Themes<\\/h4>\\r\\n            <\\/div>\\r\\n            <div class=\\"modal-body\\">\\r\\n                <div class=\\"list-group\\">\\r\\n                    @foreach (listThemes() as $theme)\\r\\n                    @if ($theme[''id''] == $TANGO->sess->data[''chosen_theme''])\\r\\n                    <a class=\\"list-group-item active\\" href=\\"{{ $theme[''change_link''] }}\\">\\r\\n                        <h4 class=\\"list-group-item-heading\\">{{ $theme[''theme_name''] }}<\\/h4>\\r\\n                    <\\/a>\\r\\n                    @else\\r\\n                    <a class=\\"list-group-item\\" href=\\"{{ $theme[''change_link''] }}\\">\\r\\n                        <h4>{{ $theme[''theme_name''] }}<\\/h4>\\r\\n                    <\\/a>\\r\\n                    @endif\\r\\n                    @endforeach\\r\\n                <\\/div>\\r\\n            <\\/div>\\r\\n        <\\/div>\\r\\n    <\\/div>\\r\\n<\\/div>\\r\\n@endif\\r\\n%highlighter_footer%\\r\\n<!-- Include all compiled plugins (below), or include individual files as needed -->\\r\\n<script src=\\"%site_url%\\/public\\/themes\\/Blue\\/assets\\/js\\/bootstrap.min.js\\"><\\/script>\\r\\n<script src=\\"%site_url%\\/public\\/themes\\/Blue\\/assets\\/js\\/blue.js\\"><\\/script>\\r\\n<\\/body>\\r\\n<\\/html>",\n        "members": "<!DOCTYPE html>\\r\\n<html>\\r\\n<head>\\r\\n    <title>%page_title% | %site_name%<\\/title>\\r\\n    <meta name=\\"viewport\\" content=\\"width=device-width, initial-scale=1.0\\">\\r\\n    <meta name=\\"description\\" content=\\"%description%\\">\\r\\n\\r\\n    <meta property=\\"og:title\\" content=\\"%page_title% - %site_name%\\"\\/>\\r\\n    <meta property=\\"og:url\\" content=\\"%site_url%\\"\\/>\\r\\n    <meta property=\\"og:site_name\\" content=\\"%site_name%\\"\\/>\\r\\n    <meta property=\\"og:description\\" content=\\"%description%\\"\\/>\\r\\n    <meta property=\\"og:image\\" content=\\"\\"\\/>\\r\\n\\r\\n    <!-- Not supported tags:\\r\\n    <meta property=\\"fb:admins\\" content=\\"\\" \\/>\\r\\n    <meta property=\\"fb:page_id\\" content=\\"\\" \\/>\\r\\n    <meta property=\\"article:publisher\\" content=\\"\\" \\/>\\r\\n    <meta property=\\"article:author\\" content=\\"\\" \\/>\\r\\n    -->\\r\\n\\r\\n    <!-- Bootstrap -->\\r\\n    <link href=\\"%site_url%\\/public\\/themes\\/Blue\\/assets\\/css\\/bootstrap.min.css\\" rel=\\"stylesheet\\">\\r\\n    <link href=\\"%site_url%\\/public\\/themes\\/Blue\\/assets\\/css\\/bootstrap-theme.css\\" rel=\\"stylesheet\\">\\r\\n    <link href=\\"%site_url%\\/public\\/themes\\/Blue\\/assets\\/css\\/blue.css\\" rel=\\"stylesheet\\">\\r\\n    <link href=\\"\\/\\/netdna.bootstrapcdn.com\\/font-awesome\\/4.0.3\\/css\\/font-awesome.min.css\\" rel=\\"stylesheet\\">\\r\\n    <!-- Flags -->\\r\\n    <link href=\\"%site_url%\\/public\\/css\\/flag\\/css\\/flag-icon.css\\" rel=\\"stylesheet\\">\\r\\n\\r\\n    %editor_settings%\\r\\n    <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->\\r\\n    <!-- WARNING: Respond.js doesn''t work if you view the page via file:\\/\\/ -->\\r\\n    <!--[if lt IE 9]>\\r\\n    <script src=\\"https:\\/\\/oss.maxcdn.com\\/libs\\/html5shiv\\/3.7.0\\/html5shiv.js\\"><\\/script>\\r\\n    <script src=\\"https:\\/\\/oss.maxcdn.com\\/libs\\/respond.js\\/1.3.0\\/respond.min.js\\"><\\/script>\\r\\n    <![endif]-->\\r\\n<\\/head>\\r\\n<body>\\r\\n<div class=\\"container\\">\\r\\n    <a href=\\"#\\">\\r\\n        <div class=\\"logo pull-left\\"><\\/div>\\r\\n    <\\/a>\\r\\n\\r\\n    <div class=\\"search_box pull-right\\">\\r\\n        <form action=\\"%site_url%\\/search.php\\" method=\\"POST\\">\\r\\n            <div class=\\"left-inner-addon\\">\\r\\n                <i class=\\"glyphicon glyphicon-search\\"><\\/i>\\r\\n                <input name=\\"search_query\\" type=\\"text\\" class=\\"form-control tooltip_toggle\\" placeholder=\\"Search...\\"\\r\\n                       data-toggle=\\"tooltip\\" data-placement=\\"left\\" title=\\"Press Enter\\">\\r\\n                <input type=\\"submit\\" name=\\"search_submit\\" style=\\"visibility:hidden;display:none;\\" value=\\"Search\\"\\/>\\r\\n            <\\/div>\\r\\n        <\\/form>\\r\\n    <\\/div>\\r\\n<\\/div>\\r\\n\\r\\n<nav class=\\"navbar navbar-default\\" role=\\"navigation\\">\\r\\n    <div class=\\"container\\">\\r\\n        <div class=\\"navbar-header\\">\\r\\n            <button type=\\"button\\" class=\\"navbar-toggle\\" data-toggle=\\"collapse\\"\\r\\n                    data-target=\\"#bs-example-navbar-collapse-1\\">\\r\\n                <span class=\\"sr-only\\">Toggle navigation<\\/span>\\r\\n                <span class=\\"icon-bar\\"><\\/span>\\r\\n                <span class=\\"icon-bar\\"><\\/span>\\r\\n                <span class=\\"icon-bar\\"><\\/span>\\r\\n            <\\/button>\\r\\n        <\\/div>\\r\\n\\r\\n        <div class=\\"collapse navbar-collapse\\" id=\\"bs-example-navbar-collapse-1\\">\\r\\n            <ul class=\\"nav navbar-nav\\">\\r\\n                <li class=\\"active\\"><a href=\\"%site_url%\\">Forums<\\/a><\\/li>\\r\\n                <li><a href=\\"%site_url%\\/members.php\\">Members<\\/a><\\/li>\\r\\n            <\\/ul>\\r\\n            <ul class=\\"nav navbar-nav navbar-right\\">\\r\\n                @if ($TANGO->sess->isLogged)\\r\\n                <li class=\\"dropdown\\">\\r\\n                    <a href=\\"#\\" class=\\"dropdown-toggle\\" data-toggle=\\"dropdown\\"><i class=\\"glyphicon glyphicon-user\\"><\\/i>\\r\\n                        %username%<\\/a>\\r\\n                    <ul class=\\"dropdown-menu\\">\\r\\n                        @foreach ($TANGO->user->userLinks() as $name => $link)\\r\\n                        <li>\\r\\n                            <a href=\\"{{ $link }}\\">\\r\\n                                {{ $name }}\\r\\n                            <\\/a>\\r\\n                        <\\/li>\\r\\n                        @endforeach\\r\\n                    <\\/ul>\\r\\n                <\\/li>\\r\\n                <li class=\\"dropdown\\">\\r\\n                    <a href=\\"#\\" class=\\"dropdown-toggle\\" data-toggle=\\"dropdown\\">\\r\\n                        <i class=\\"glyphicon glyphicon-envelope\\"><\\/i> Conversations\\r\\n                        @if (count($TANGO->user->userMessages()) > 0)\\r\\n                        <span class=\\"label label-success\\">{{ count($TANGO->user->userMessages()) }}<\\/span>\\r\\n                        @endif\\r\\n                    <\\/a>\\r\\n                    <ul class=\\"dropdown-menu\\">\\r\\n                        @if (count($TANGO->user->userMessages()) > 0)\\r\\n                        @foreach ($TANGO->user->userMessages() as $msg)\\r\\n                        <li>\\r\\n                            <a href=\\"{{ $msg[''view_url''] }}\\">\\r\\n                                <h4>\\r\\n                                    {{ $msg[''message_title''] }}\\r\\n                                <\\/h4>\\r\\n                                <small>By {{ $msg[''message_sender''] }} at\\r\\n                                    {{ date(''F j, Y'', $msg[''message_time'']) }}\\r\\n                                <\\/small>\\r\\n                            <\\/a>\\r\\n                        <\\/li>\\r\\n                        @endforeach\\r\\n                        @else\\r\\n                        <li role=\\"presentation\\" class=\\"dropdown-header\\">No Messages<\\/li>\\r\\n                        @endif\\r\\n                        <li><a href=\\"%site_url%\\/conversations.php\\">Conversations<\\/a><\\/li>\\r\\n                        <li><a href=\\"%site_url%\\/conversations.php\\/cmd\\/new\\">New Message<\\/a><\\/li>\\r\\n                    <\\/ul>\\r\\n                <\\/li>\\r\\n                <li class=\\"dropdown\\">\\r\\n                    <a href=\\"#\\" class=\\"dropdown-toggle\\" data-toggle=\\"dropdown\\" style=\\"overflow:auto;\\">\\r\\n                        <i class=\\"fa fa-bell\\"><\\/i>\\r\\n                        @if (count($TANGO->user->notifications()) > 0)\\r\\n                                    <span class=\\"badge\\">\\r\\n                                        {{ count($TANGO->user->notifications()) }}\\r\\n                                    <\\/span>\\r\\n                        @endif\\r\\n                    <\\/a>\\r\\n                    <ul class=\\"dropdown-menu\\">\\r\\n                        @if (count($TANGO->user->notifications()) < 1)\\r\\n                        <li role=\\"presentation\\" class=\\"disabled\\"><a role=\\"menuitem\\" tabindex=\\"-1\\" href=\\"#\\">No new\\r\\n                                notifications yet.<\\/a><\\/li>\\r\\n                        @else\\r\\n                        @foreach ($TANGO->user->notifications() as $note)\\r\\n                        <li>\\r\\n                            <a href=\\"{{ $note[''notice_link''] }}\\">\\r\\n                                {{ $note[''notice_content''] }}\\r\\n                                <small class=\\"text-muted\\">{{ date(''F j, Y'', $note[''time_received'']) }}<\\/small>\\r\\n                            <\\/a>\\r\\n                        <\\/li>\\r\\n                        @endforeach\\r\\n                        {{ $TANGO->user->clearNotification() }}\\r\\n                        @endif\\r\\n                    <\\/ul>\\r\\n                <\\/li>\\r\\n                @else\\r\\n                <li><a href=\\"#\\" data-toggle=\\"modal\\" data-target=\\"#login_modal\\">Sign In<\\/a><\\/li>\\r\\n                @endif\\r\\n            <\\/ul>\\r\\n        <\\/div>\\r\\n    <\\/div>\\r\\n<\\/nav>\\r\\n\\r\\n<div id=\\"wrap\\" class=\\"container\\">\\r\\n    <div class=\\"row\\">\\r\\n\\r\\n        <div class=\\"col-md-9\\">\\r\\n            <h1>%page_title%<\\/h1>\\r\\n            %content%\\r\\n        <\\/div>\\r\\n\\r\\n        <div class=\\"col-md-3\\">\\r\\n            @if ($TANGO->perm->check(''access_moderation''))\\r\\n            <div style=\\"margin-bottom:10px;\\">\\r\\n                <a href=\\"%site_url%\\/mod\\" class=\\"btn btn-warning btn-lg btn-block\\">Reports <span\\r\\n                        class=\\"label label-warning\\">%mod_report_integer%<\\/span><\\/a>\\r\\n                @if ($TANGO->perm->check(''access_administration''))\\r\\n                <a href=\\"%site_url%\\/admin\\" class=\\"btn btn-danger btn-lg btn-block\\">Admin CP<\\/a>\\r\\n                @endif\\r\\n            <\\/div>\\r\\n            @endif\\r\\n            <div class=\\"panel panel-content\\">\\r\\n                <div class=\\"panel-body\\">\\r\\n                    @if ($TANGO->sess->isLogged)\\r\\n                    <div class=\\"row\\" style=\\"width:100%;overflow:auto;margin:0 auto;\\">\\r\\n                        <div class=\\"col-md-5\\">\\r\\n                            <img src=\\"%user_avatar%\\" class=\\"img-thumbnail pull-left\\"\\r\\n                                 style=\\"max-width:100x;max-height:100px;\\">\\r\\n                        <\\/div>\\r\\n                        <div class=\\"col-md-7\\">\\r\\n                            <a href=\\"%site_url%\\/members.php\\/cmd\\/user\\">%username_style%<\\/a>\\r\\n\\r\\n                            <div class=\\"row\\">\\r\\n                                <div class=\\"col-md-6\\">\\r\\n                                    <small>Messages:<\\/small>\\r\\n                                <\\/div>\\r\\n                                <div class=\\"col-md-6\\" style=\\"text-align:right;\\">\\r\\n                                    %user_post_count%\\r\\n                                <\\/div>\\r\\n                            <\\/div>\\r\\n                        <\\/div>\\r\\n                    <\\/div>\\r\\n                    @else\\r\\n                    <a href=\\"%site_url%\\/members.php\\/cmd\\/register\\" class=\\"btn btn-success btn-lg btn-block\\">Register<\\/a>\\r\\n                    @endif\\r\\n                <\\/div>\\r\\n            <\\/div>\\r\\n            <div class=\\"panel panel-content\\">\\r\\n                <div class=\\"panel-heading\\">\\r\\n                    <b><i class=\\"glyphicon glyphicon-stats\\"><\\/i> Forum Statistics<\\/b>\\r\\n                <\\/div>\\r\\n                <div class=\\"panel-body\\">\\r\\n                    <div class=\\"row\\">\\r\\n                        <div class=\\"col-md-6 text-muted\\">\\r\\n                            <small>Threads:<\\/small>\\r\\n                        <\\/div>\\r\\n                        <div class=\\"col-md-6\\" style=\\"text-align:right;\\">\\r\\n                            <small>%bb_stat_threads%<\\/small>\\r\\n                        <\\/div>\\r\\n                        <div class=\\"col-md-6 text-muted\\">\\r\\n                            <small>Replies:<\\/small>\\r\\n                        <\\/div>\\r\\n                        <div class=\\"col-md-6\\" style=\\"text-align:right;\\">\\r\\n                            <small>%bb_stat_posts%<\\/small>\\r\\n                        <\\/div>\\r\\n                        <div class=\\"col-md-6 text-muted\\">\\r\\n                            <small>Users:<\\/small>\\r\\n                        <\\/div>\\r\\n                        <div class=\\"col-md-6\\" style=\\"text-align:right;\\">\\r\\n                            <small>%bb_stat_users%<\\/small>\\r\\n                        <\\/div>\\r\\n                    <\\/div>\\r\\n                <\\/div>\\r\\n            <\\/div>\\r\\n            <div class=\\"panel panel-content\\">\\r\\n                <div class=\\"panel-heading\\">\\r\\n                    <b><i class=\\"glyphicon glyphicon-user\\"><\\/i> Users Online<\\/b>\\r\\n                <\\/div>\\r\\n                <div class=\\"panel-body\\">\\r\\n                    %users_online%\\r\\n                <\\/div>\\r\\n            <\\/div>\\r\\n        <\\/div>\\r\\n\\r\\n    <\\/div>\\r\\n    <footer>\\r\\n        <small class=\\"pull-left\\">\\r\\n            Powered by <a href=\\"http:\\/\\/tangobb.com\\/\\" target=\\"_blank\\">TangoBB<\\/a>\\r\\n        <\\/small>\\r\\n        @if ($TANGO->sess->isLogged)\\r\\n        <small class=\\"pull-right\\">\\r\\n            <span data-toggle=\\"tooltip\\" title=\\"Choose Themes\\" class=\\"tooltip_toggle\\">\\r\\n              <a href=\\"#\\" data-toggle=\\"modal\\" data-target=\\"#theme_modal\\">Blue<\\/a>\\r\\n            <\\/span>\\r\\n        <\\/small>\\r\\n        @endif\\r\\n    <\\/footer>\\r\\n<\\/div>\\r\\n\\r\\n<div class=\\"container statistics\\">\\r\\n    <small class=\\"text-muted\\">\\r\\n        Load Time: %elapsed_time% seconds |\\r\\n        Memory: %memory_usage%\\r\\n    <\\/small>\\r\\n<\\/div>\\r\\n\\r\\n@if (!$TANGO->sess->isLogged)\\r\\n<div class=\\"modal fade\\" id=\\"login_modal\\" tabindex=\\"-1\\" role=\\"dialog\\" aria-labelledby=\\"login_modal\\" aria-hidden=\\"true\\">\\r\\n    <div class=\\"modal-dialog\\">\\r\\n        <div class=\\"modal-content\\">\\r\\n            <div class=\\"modal-header\\">\\r\\n                <button type=\\"button\\" class=\\"close\\" data-dismiss=\\"modal\\" aria-hidden=\\"true\\">Ã—<\\/button>\\r\\n                <h4 class=\\"modal-title\\" id=\\"myModalLabel\\">Sign In<\\/h4>\\r\\n            <\\/div>\\r\\n            <div class=\\"modal-body\\">\\r\\n                <form action=\\"%site_url%\\/members.php\\/cmd\\/signin\\" method=\\"POST\\">\\r\\n                    <input type=\\"hidden\\" name=\\"current_url\\" value=\\"%current_url%\\" \\/>                    <input type=\\"text\\" name=\\"email\\" class=\\"form-control\\" id=\\"inputEmail3\\"\\r\\n                           placeholder=\\"Username or Email\\">\\r\\n                    <br\\/>\\r\\n                    <input type=\\"password\\" name=\\"password\\" class=\\"form-control\\" id=\\"inputPassword3\\"\\r\\n                           placeholder=\\"Password\\">\\r\\n                    <label>\\r\\n                        <input type=\\"checkbox\\" name=\\"remember\\"> Remember me\\r\\n                    <\\/label>\\r\\n                    <br\\/>\\r\\n                    <input type=\\"submit\\" class=\\"btn btn-primary\\" name=\\"signin\\" value=\\"Sign in\\"\\/>\\r\\n                    @if ($TANGO->data[''facebook_authenticate''] == \\"1\\")\\r\\n                    <a href=\\"%facebook_login_url%\\" class=\\"btn btn-info btn-sm\\"><i class=\\"fa fa-facebook\\"><\\/i> Sign In\\r\\n                        with Facebook<\\/a>\\r\\n                    @endif\\r\\n                    <br\\/>\\r\\n                    <a href=\\"%site_url%\\/members.php\\/cmd\\/forgotpassword\\">Forgot Password<\\/a>\\r\\n                <\\/form>\\r\\n            <\\/div>\\r\\n        <\\/div>\\r\\n    <\\/div>\\r\\n<\\/div>\\r\\n@endif\\r\\n\\r\\n@if ($TANGO->sess->isLogged)\\r\\n<div class=\\"modal fade\\" id=\\"theme_modal\\" tabindex=\\"-1\\" role=\\"dialog\\" aria-labelledby=\\"theme_modal\\" aria-hidden=\\"true\\">\\r\\n    <div class=\\"modal-dialog\\">\\r\\n        <div class=\\"modal-content\\">\\r\\n            <div class=\\"modal-header\\">\\r\\n                <button type=\\"button\\" class=\\"close\\" data-dismiss=\\"modal\\" aria-hidden=\\"true\\">Ã—<\\/button>\\r\\n                <h4 class=\\"modal-title\\" id=\\"myModalLabel\\">Choose Themes<\\/h4>\\r\\n            <\\/div>\\r\\n            <div class=\\"modal-body\\">\\r\\n                <div class=\\"list-group\\">\\r\\n                    @foreach (listThemes() as $theme)\\r\\n                    @if ($theme[''id''] == $TANGO->sess->data[''chosen_theme''])\\r\\n                    <a class=\\"list-group-item active\\" href=\\"{{ $theme[''change_link''] }}\\">\\r\\n                        <h4 class=\\"list-group-item-heading\\">{{ $theme[''theme_name''] }}<\\/h4>\\r\\n                    <\\/a>\\r\\n                    @else\\r\\n                    <a class=\\"list-group-item\\" href=\\"{{ $theme[''change_link''] }}\\">\\r\\n                        <h4>{{ $theme[''theme_name''] }}<\\/h4>\\r\\n                    <\\/a>\\r\\n                    @endif\\r\\n                    @endforeach\\r\\n                <\\/div>\\r\\n            <\\/div>\\r\\n        <\\/div>\\r\\n    <\\/div>\\r\\n<\\/div>\\r\\n@endif\\r\\n%highlighter_footer%\\r\\n<!-- Include all compiled plugins (below), or include individual files as needed -->\\r\\n<script src=\\"%site_url%\\/public\\/themes\\/Blue\\/assets\\/js\\/bootstrap.min.js\\"><\\/script>\\r\\n<script src=\\"%site_url%\\/public\\/themes\\/Blue\\/assets\\/js\\/blue.js\\"><\\/script>\\r\\n<\\/body>\\r\\n<\\/html>",\n        "page": "<!DOCTYPE html>\\r\\n<html>\\r\\n<head>\\r\\n    <title>%page_title% | %site_name%<\\/title>\\r\\n    <meta name=\\"viewport\\" content=\\"width=device-width, initial-scale=1.0\\">\\r\\n    <meta name=\\"description\\" content=\\"%description%\\">\\r\\n\\r\\n    <meta property=\\"og:title\\" content=\\"%page_title% - %site_name%\\"\\/>\\r\\n    <meta property=\\"og:url\\" content=\\"%site_url%\\"\\/>\\r\\n    <meta property=\\"og:site_name\\" content=\\"%site_name%\\"\\/>\\r\\n    <meta property=\\"og:description\\" content=\\"%description%\\"\\/>\\r\\n    <meta property=\\"og:image\\" content=\\"\\"\\/>\\r\\n\\r\\n    <!-- Not supported tags:\\r\\n    <meta property=\\"fb:admins\\" content=\\"\\" \\/>\\r\\n    <meta property=\\"fb:page_id\\" content=\\"\\" \\/>\\r\\n    <meta property=\\"article:publisher\\" content=\\"\\" \\/>\\r\\n    <meta property=\\"article:author\\" content=\\"\\" \\/>\\r\\n    -->\\r\\n\\r\\n    <!-- Bootstrap -->\\r\\n    <link href=\\"%site_url%\\/public\\/themes\\/Blue\\/assets\\/css\\/bootstrap.min.css\\" rel=\\"stylesheet\\">\\r\\n    <link href=\\"%site_url%\\/public\\/themes\\/Blue\\/assets\\/css\\/bootstrap-theme.css\\" rel=\\"stylesheet\\">\\r\\n    <link href=\\"%site_url%\\/public\\/themes\\/Blue\\/assets\\/css\\/blue.css\\" rel=\\"stylesheet\\">\\r\\n    <link href=\\"\\/\\/netdna.bootstrapcdn.com\\/font-awesome\\/4.0.3\\/css\\/font-awesome.min.css\\" rel=\\"stylesheet\\">\\r\\n    <!-- Flags -->\\r\\n    <link href=\\"%site_url%\\/public\\/css\\/flag\\/css\\/flag-icon.css\\" rel=\\"stylesheet\\">\\r\\n\\r\\n    %editor_settings%\\r\\n    <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->\\r\\n    <!-- WARNING: Respond.js doesn''t work if you view the page via file:\\/\\/ -->\\r\\n    <!--[if lt IE 9]>\\r\\n    <script src=\\"https:\\/\\/oss.maxcdn.com\\/libs\\/html5shiv\\/3.7.0\\/html5shiv.js\\"><\\/script>\\r\\n    <script src=\\"https:\\/\\/oss.maxcdn.com\\/libs\\/respond.js\\/1.3.0\\/respond.min.js\\"><\\/script>\\r\\n    <![endif]-->\\r\\n<\\/head>\\r\\n<body>\\r\\n<div class=\\"container\\">\\r\\n    <a href=\\"#\\">\\r\\n        <div class=\\"logo pull-left\\"><\\/div>\\r\\n    <\\/a>\\r\\n\\r\\n    <div class=\\"search_box pull-right\\">\\r\\n        <form action=\\"%site_url%\\/search.php\\" method=\\"POST\\">\\r\\n            <div class=\\"left-inner-addon\\">\\r\\n                <i class=\\"glyphicon glyphicon-search\\"><\\/i>\\r\\n                <input name=\\"search_query\\" type=\\"text\\" class=\\"form-control tooltip_toggle\\" placeholder=\\"Search...\\"\\r\\n                       data-toggle=\\"tooltip\\" data-placement=\\"left\\" title=\\"Press Enter\\">\\r\\n                <input type=\\"submit\\" name=\\"search_submit\\" style=\\"visibility:hidden;display:none;\\" value=\\"Search\\"\\/>\\r\\n            <\\/div>\\r\\n        <\\/form>\\r\\n    <\\/div>\\r\\n<\\/div>\\r\\n\\r\\n<nav class=\\"navbar navbar-default\\" role=\\"navigation\\">\\r\\n    <div class=\\"container\\">\\r\\n        <div class=\\"navbar-header\\">\\r\\n            <button type=\\"button\\" class=\\"navbar-toggle\\" data-toggle=\\"collapse\\"\\r\\n                    data-target=\\"#bs-example-navbar-collapse-1\\">\\r\\n                <span class=\\"sr-only\\">Toggle navigation<\\/span>\\r\\n                <span class=\\"icon-bar\\"><\\/span>\\r\\n                <span class=\\"icon-bar\\"><\\/span>\\r\\n                <span class=\\"icon-bar\\"><\\/span>\\r\\n            <\\/button>\\r\\n        <\\/div>\\r\\n\\r\\n        <div class=\\"collapse navbar-collapse\\" id=\\"bs-example-navbar-collapse-1\\">\\r\\n            <ul class=\\"nav navbar-nav\\">\\r\\n                <li class=\\"active\\"><a href=\\"%site_url%\\">Forums<\\/a><\\/li>\\r\\n                <li><a href=\\"%site_url%\\/members.php\\">Members<\\/a><\\/li>\\r\\n            <\\/ul>\\r\\n            <ul class=\\"nav navbar-nav navbar-right\\">\\r\\n                @if ($TANGO->sess->isLogged)\\r\\n                <li class=\\"dropdown\\">\\r\\n                    <a href=\\"#\\" class=\\"dropdown-toggle\\" data-toggle=\\"dropdown\\"><i class=\\"glyphicon glyphicon-user\\"><\\/i>\\r\\n                        %username%<\\/a>\\r\\n                    <ul class=\\"dropdown-menu\\">\\r\\n                        @foreach ($TANGO->user->userLinks() as $name => $link)\\r\\n                        <li>\\r\\n                            <a href=\\"{{ $link }}\\">\\r\\n                                {{ $name }}\\r\\n                            <\\/a>\\r\\n                        <\\/li>\\r\\n                        @endforeach\\r\\n                    <\\/ul>\\r\\n                <\\/li>\\r\\n                <li class=\\"dropdown\\">\\r\\n                    <a href=\\"#\\" class=\\"dropdown-toggle\\" data-toggle=\\"dropdown\\">\\r\\n                        <i class=\\"glyphicon glyphicon-envelope\\"><\\/i> Conversations\\r\\n                        @if (count($TANGO->user->userMessages()) > 0)\\r\\n                        <span class=\\"label label-success\\">{{ count($TANGO->user->userMessages()) }}<\\/span>\\r\\n                        @endif\\r\\n                    <\\/a>\\r\\n                    <ul class=\\"dropdown-menu\\">\\r\\n                        @if (count($TANGO->user->userMessages()) > 0)\\r\\n                        @foreach ($TANGO->user->userMessages() as $msg)\\r\\n                        <li>\\r\\n                            <a href=\\"{{ $msg[''view_url''] }}\\">\\r\\n                                <h4>\\r\\n                                    {{ $msg[''message_title''] }}\\r\\n                                <\\/h4>\\r\\n                                <small>By {{ $msg[''message_sender''] }} at\\r\\n                                    {{ date(''F j, Y'', $msg[''message_time'']) }}\\r\\n                                <\\/small>\\r\\n                            <\\/a>\\r\\n                        <\\/li>\\r\\n                        @endforeach\\r\\n                        @else\\r\\n                        <li role=\\"presentation\\" class=\\"dropdown-header\\">No Messages<\\/li>\\r\\n                        @endif\\r\\n                        <li><a href=\\"%site_url%\\/conversations.php\\">Conversations<\\/a><\\/li>\\r\\n                        <li><a href=\\"%site_url%\\/conversations.php\\/cmd\\/new\\">New Message<\\/a><\\/li>\\r\\n                    <\\/ul>\\r\\n                <\\/li>\\r\\n                <li class=\\"dropdown\\">\\r\\n                    <a href=\\"#\\" class=\\"dropdown-toggle\\" data-toggle=\\"dropdown\\" style=\\"overflow:auto;\\">\\r\\n                        <i class=\\"fa fa-bell\\"><\\/i>\\r\\n                        @if (count($TANGO->user->notifications()) > 0)\\r\\n                                    <span class=\\"badge\\">\\r\\n                                        {{ count($TANGO->user->notifications()) }}\\r\\n                                    <\\/span>\\r\\n                        @endif\\r\\n                    <\\/a>\\r\\n                    <ul class=\\"dropdown-menu\\">\\r\\n                        @if (count($TANGO->user->notifications()) < 1)\\r\\n                        <li role=\\"presentation\\" class=\\"disabled\\"><a role=\\"menuitem\\" tabindex=\\"-1\\" href=\\"#\\">No new\\r\\n                                notifications yet.<\\/a><\\/li>\\r\\n                        @else\\r\\n                        @foreach ($TANGO->user->notifications() as $note)\\r\\n                        <li>\\r\\n                            <a href=\\"{{ $note[''notice_link''] }}\\">\\r\\n                                {{ $note[''notice_content''] }}\\r\\n                                <small class=\\"text-muted\\">{{ date(''F j, Y'', $note[''time_received'']) }}<\\/small>\\r\\n                            <\\/a>\\r\\n                        <\\/li>\\r\\n                        @endforeach\\r\\n                        {{ $TANGO->user->clearNotification() }}\\r\\n                        @endif\\r\\n                    <\\/ul>\\r\\n                <\\/li>\\r\\n                @else\\r\\n                <li><a href=\\"#\\" data-toggle=\\"modal\\" data-target=\\"#login_modal\\">Sign In<\\/a><\\/li>\\r\\n                @endif\\r\\n            <\\/ul>\\r\\n        <\\/div>\\r\\n    <\\/div>\\r\\n<\\/nav>\\r\\n\\r\\n<div id=\\"wrap\\" class=\\"container\\">\\r\\n    <div class=\\"row\\">\\r\\n\\r\\n        <div class=\\"col-md-12\\">\\r\\n            <h1>%page_title%<\\/h1>\\r\\n            %content%\\r\\n        <\\/div>\\r\\n\\r\\n    <\\/div>\\r\\n    <footer>\\r\\n        <small class=\\"pull-left\\">\\r\\n            Powered by <a href=\\"http:\\/\\/tangobb.com\\/\\" target=\\"_blank\\">TangoBB<\\/a>\\r\\n        <\\/small>\\r\\n        @if ($TANGO->sess->isLogged)\\r\\n        <small class=\\"pull-right\\">\\r\\n            <span data-toggle=\\"tooltip\\" title=\\"Choose Themes\\" class=\\"tooltip_toggle\\">\\r\\n              <a href=\\"#\\" data-toggle=\\"modal\\" data-target=\\"#theme_modal\\">Change Theme<\\/a>\\r\\n            <\\/span>\\r\\n        <\\/small>\\r\\n        @endif\\r\\n    <\\/footer>\\r\\n<\\/div>\\r\\n\\r\\n<div class=\\"container statistics\\">\\r\\n    <small class=\\"text-muted\\">\\r\\n        Load Time: %elapsed_time% seconds |\\r\\n        Memory: %memory_usage%\\r\\n    <\\/small>\\r\\n<\\/div>\\r\\n\\r\\n@if (!$TANGO->sess->isLogged)\\r\\n<div class=\\"modal fade\\" id=\\"login_modal\\" tabindex=\\"-1\\" role=\\"dialog\\" aria-labelledby=\\"login_modal\\" aria-hidden=\\"true\\">\\r\\n    <div class=\\"modal-dialog\\">\\r\\n        <div class=\\"modal-content\\">\\r\\n            <div class=\\"modal-header\\">\\r\\n                <button type=\\"button\\" class=\\"close\\" data-dismiss=\\"modal\\" aria-hidden=\\"true\\">Ã—<\\/button>\\r\\n                <h4 class=\\"modal-title\\" id=\\"myModalLabel\\">Sign In<\\/h4>\\r\\n            <\\/div>\\r\\n            <div class=\\"modal-body\\">\\r\\n                <form action=\\"%site_url%\\/members.php\\/cmd\\/signin\\" method=\\"POST\\">\\r\\n                    <input type=\\"hidden\\" name=\\"current_url\\" value=\\"%current_url%\\" \\/>                    <input type=\\"text\\" name=\\"email\\" class=\\"form-control\\" id=\\"inputEmail3\\"\\r\\n                           placeholder=\\"Username or Email\\">\\r\\n                    <br\\/>\\r\\n                    <input type=\\"password\\" name=\\"password\\" class=\\"form-control\\" id=\\"inputPassword3\\"\\r\\n                           placeholder=\\"Password\\">\\r\\n                    <label>\\r\\n                        <input type=\\"checkbox\\" name=\\"remember\\"> Remember me\\r\\n                    <\\/label>\\r\\n                    <br\\/>\\r\\n                    <input type=\\"submit\\" class=\\"btn btn-primary\\" name=\\"signin\\" value=\\"Sign in\\"\\/>\\r\\n                    @if ($TANGO->data[''facebook_authenticate''] == \\"1\\")\\r\\n                    <a href=\\"%facebook_login_url%\\" class=\\"btn btn-info btn-sm\\"><i class=\\"fa fa-facebook\\"><\\/i> Sign In\\r\\n                        with Facebook<\\/a>\\r\\n                    @endif\\r\\n                    <br\\/>\\r\\n                    <a href=\\"%site_url%\\/members.php\\/cmd\\/forgotpassword\\">Forgot Password<\\/a>\\r\\n                <\\/form>\\r\\n            <\\/div>\\r\\n        <\\/div>\\r\\n    <\\/div>\\r\\n<\\/div>\\r\\n@endif\\r\\n\\r\\n@if ($TANGO->sess->isLogged)\\r\\n<div class=\\"modal fade\\" id=\\"theme_modal\\" tabindex=\\"-1\\" role=\\"dialog\\" aria-labelledby=\\"theme_modal\\" aria-hidden=\\"true\\">\\r\\n    <div class=\\"modal-dialog\\">\\r\\n        <div class=\\"modal-content\\">\\r\\n            <div class=\\"modal-header\\">\\r\\n                <button type=\\"button\\" class=\\"close\\" data-dismiss=\\"modal\\" aria-hidden=\\"true\\">Ã—<\\/button>\\r\\n                <h4 class=\\"modal-title\\" id=\\"myModalLabel\\">Choose Themes<\\/h4>\\r\\n            <\\/div>\\r\\n            <div class=\\"modal-body\\">\\r\\n                <div class=\\"list-group\\">\\r\\n                    @foreach (listThemes() as $theme)\\r\\n                    @if ($theme[''id''] == $TANGO->sess->data[''chosen_theme''])\\r\\n                    <a class=\\"list-group-item active\\" href=\\"{{ $theme[''change_link''] }}\\">\\r\\n                        <h4 class=\\"list-group-item-heading\\">{{ $theme[''theme_name''] }}<\\/h4>\\r\\n                    <\\/a>\\r\\n                    @else\\r\\n                    <a class=\\"list-group-item\\" href=\\"{{ $theme[''change_link''] }}\\">\\r\\n                        <h4>{{ $theme[''theme_name''] }}<\\/h4>\\r\\n                    <\\/a>\\r\\n                    @endif\\r\\n                    @endforeach\\r\\n                <\\/div>\\r\\n            <\\/div>\\r\\n        <\\/div>\\r\\n    <\\/div>\\r\\n<\\/div>\\r\\n@endif\\r\\n%highlighter_footer%\\r\\n<!-- Include all compiled plugins (below), or include individual files as needed -->\\r\\n<script src=\\"%site_url%\\/public\\/themes\\/Blue\\/assets\\/js\\/bootstrap.min.js\\"><\\/script>\\r\\n<script src=\\"%site_url%\\/public\\/themes\\/Blue\\/assets\\/js\\/blue.js\\"><\\/script>\\r\\n<\\/body>\\r\\n<\\/html>"\n    },\n    "entities": {\n        "quote_post": "\\r\\n<blockquote>%quoted_post_content%\\r\\n    <small>%quoted_post_user%<\\/small>\\r\\n<\\/blockquote>\\r\\n",\n        "thread_closed": "\\r\\n<i class=\\"glyphicon glyphicon-lock pull-right\\" title=\\"Thread Closed\\" style=\\"margin-right:2px;margin-left:2px;\\"><\\/i>\\r\\n",\n        "thread_stickied": "\\r\\n<i class=\\"glyphicon glyphicon-tag pull-right\\" style=\\"margin-right:2px;margin-left:2px;\\" title=\\"Thread Stickied\\"><\\/i>\\r\\n",\n        "danger_notice": "\\r\\n<div class=\\"alert alert-danger\\">%content%<\\/div>\\r\\n",\n        "success_notice": "\\r\\n<div class=\\"alert alert-success\\">%content%<\\/div>\\r\\n",\n        "warning_notice": "\\r\\n<div class=\\"alert alert-warning\\">%content%<\\/div>\\r\\n",\n        "breadcrumbs": "\\r\\n<ol class=\\"breadcrumb\\">\\r\\n    %bread%\\r\\n<\\/ol>\\r\\n",\n        "breadcrumbs_before": "\\r\\n<li><a href=\\"%link%\\">%name%<\\/a><\\/li>\\r\\n",\n        "breadcrumbs_current": "\\r\\n<li class=\\"active\\">%name%<\\/li>\\r\\n",\n        "pagination": "\\r\\n<ul class=\\"pagination pull-right\\">\\r\\n    %pages%\\r\\n<\\/ul>\\r\\n",\n        "pagination_links": "\\r\\n<li><a href=\\"%url%\\">%page%<\\/a><\\/li>\\r\\n",\n        "pagination_link_current": "\\r\\n<li class=\\"active\\"><a href=\\"#\\">%page%<\\/a><\\/li>\\r\\n",\n        "members_page_head": "\\r\\n<div style=\\"height:auto;\\">\\r\\n    <div class=\\"btn-group\\">\\r\\n        <button type=\\"button\\" class=\\"btn btn-default dropdown-toggle\\" data-toggle=\\"dropdown\\">\\r\\n            <i class=\\"glyphicon glyphicon-sort\\"><\\/i>\\r\\n        <\\/button>\\r\\n        <ul class=\\"dropdown-menu\\" role=\\"menu\\">\\r\\n            <li><a href=\\"%sort_date_joined_asc%\\"><i class=\\"glyphicon glyphicon-sort-by-order\\"><\\/i> Date Joined Ascending<\\/a>\\r\\n            <\\/li>\\r\\n            <li><a href=\\"%sort_date_joined_desc%\\"><i class=\\"glyphicon glyphicon-sort-by-order-alt\\"><\\/i> Date Joined\\r\\n                    Descending<\\/a><\\/li>\\r\\n            <li><a href=\\"%sort_name_asc%\\"><i class=\\"glyphicon glyphicon-sort-by-alphabet\\"><\\/i> Username Ascending<\\/a>\\r\\n            <\\/li>\\r\\n            <li><a href=\\"%sort_name_desc%\\"><i class=\\"glyphicon glyphicon-sort-by-alphabet-alt\\"><\\/i> Username Descending<\\/a>\\r\\n            <\\/li>\\r\\n        <\\/ul>\\r\\n    <\\/div>\\r\\n<\\/div>\\r\\n%members%\\r\\n",\n        "members_page": "\\r\\n<div style=\\"padding:10px 0px 10px 0px;border-bottom:dashed 1px #ccc;overflow:auto;\\">\\r\\n    <img src=\\"%avatar%\\" style=\\"width:65px;height:65px;margin-right:5px;\\" class=\\"img-thumbnail pull-left\\"\\/>\\r\\n    <a href=\\"%profile_url%\\">%username%<\\/a><br\\/>\\r\\n    <small class=\\"text-muted\\">Joined:<\\/small>\\r\\n    <small>%date_joined%<\\/small>\\r\\n    <br\\/>\\r\\n    <small class=\\"text-muted\\">Messages:<\\/small>\\r\\n    <small>%postcount%<\\/small>\\r\\n<\\/div>\\r\\n",\n        "thread_starter": "\\r\\n%breadcrumbs%\\r\\n%thread_notice%\\r\\n<div style=\\"overflow:auto;\\">\\r\\n    <p class=\\"pull-left\\" style=\\"padding-top:15px;padding-bottom:0;margin:0;\\">\\r\\n        %watch_link%\\r\\n    <\\/p>\\r\\n\\r\\n    <p class=\\"pull-right\\">\\r\\n        %reply_button%\\r\\n    <\\/p>\\r\\n<\\/div>\\r\\n<div class=\\"panel panel-success\\">\\r\\n    <div class=\\"panel-body\\">\\r\\n        <div class=\\"user_details\\">\\r\\n            <div class=\\"pull-left\\">\\r\\n                <img src=\\"%user_avatar%\\" class=\\"img-thumbnail\\" style=\\"height:70px;width:70px;\\">\\r\\n            <\\/div>\\r\\n            <div class=\\"name\\">\\r\\n                <a href=\\"%profile_url%\\">%username%<\\/a><br\\/>\\r\\n                <small class=\\"text-muted\\">Joined:<\\/small>\\r\\n                <small>%date_joined%<\\/small>\\r\\n                <br\\/>\\r\\n                <small class=\\"text-muted\\">Messages:<\\/small>\\r\\n                <small>%postcount%<\\/small>\\r\\n            <\\/div>\\r\\n        <\\/div>\\r\\n        <div class=\\"thread_content\\">\\r\\n            %poll% %thread_content%\\r\\n        <\\/div>\\r\\n        <div class=\\"signature\\">\\r\\n            %user_signature%\\r\\n        <\\/div>\\r\\n        <div class=\\"tools\\">\\r\\n            <div class=\\"pull-left\\">\\r\\n                <small>Posted %post_time%<\\/small>\\r\\n                <br\\/>\\r\\n                %mod_tools%\\r\\n            <\\/div>\\r\\n            <div class=\\"pull-right\\">\\r\\n                %quote_post%\\r\\n                %edit_post%\\r\\n                %report_post%\\r\\n            <\\/div>\\r\\n        <\\/div>\\r\\n    <\\/div>\\r\\n<\\/div>\\r\\n",\n        "thread_top": "\\r\\n%breadcrumbs%\\r\\n%thread_notice%\\r\\n<div style=\\"overflow:auto;\\">\\r\\n    <p class=\\"pull-left\\" style=\\"padding-top:15px;padding-bottom:0;margin:0;\\">\\r\\n        %watch_link%\\r\\n    <\\/p>\\r\\n\\r\\n    <p class=\\"pull-right\\">\\r\\n        %reply_button%\\r\\n    <\\/p>\\r\\n<\\/div>\\r\\n",\n        "thread_reply": "\\r\\n<div id=\\"%post_id%\\">\\r\\n    <div class=\\"panel panel-default\\">\\r\\n        <div class=\\"panel-body\\">\\r\\n            <div class=\\"user_details\\">\\r\\n                <div class=\\"pull-left\\">\\r\\n                    <img src=\\"%user_avatar%\\" class=\\"img-thumbnail\\" style=\\"height:70px;width:70px;\\">\\r\\n                <\\/div>\\r\\n                <div class=\\"name\\">\\r\\n                    <a href=\\"%profile_url%\\">%username%<\\/a><br\\/>\\r\\n                    <small class=\\"text-muted\\">Joined:<\\/small>\\r\\n                    <small>%date_joined%<\\/small>\\r\\n                    <br\\/>\\r\\n                    <small class=\\"text-muted\\">Messages:<\\/small>\\r\\n                    <small>%postcount%<\\/small>\\r\\n                <\\/div>\\r\\n            <\\/div>\\r\\n            <div class=\\"thread_content\\">\\r\\n                %reply_content%\\r\\n            <\\/div>\\r\\n            <div class=\\"signature\\">\\r\\n                %user_signature%\\r\\n            <\\/div>\\r\\n            <div class=\\"tools\\">\\r\\n                <div class=\\"pull-left\\">\\r\\n                    <small>Posted %post_time%<\\/small>\\r\\n                    <br\\/>\\r\\n                    %mod_tools%\\r\\n                <\\/div>\\r\\n                <div class=\\"pull-right\\">\\r\\n                    %quote_post%\\r\\n                    %edit_post%\\r\\n                    %report_post%\\r\\n                <\\/div>\\r\\n            <\\/div>\\r\\n        <\\/div>\\r\\n    <\\/div>\\r\\n<\\/div>\\r\\n",\n        "reply_thread": "\\r\\n<div id=\\"reply\\" class=\\"panel-body\\">\\r\\n    <form id=\\"%form_id%\\" action=\\"%reply_form_action%\\" method=\\"POST\\">\\r\\n        %csrf_input%\\r\\n        <textarea id=\\"%editor_id%\\" style=\\"width:100%;height:150px;max-width:100%;min-width:100%;\\"\\r\\n                  name=\\"%textarea_name%\\"><\\/textarea>\\r\\n\\r\\n        <p class=\\"pull-right\\" style=\\"margin-top:5px;\\">\\r\\n            <input type=\\"submit\\" name=\\"%submit_name%\\" value=\\"Post Reply\\"\\/>\\r\\n        <\\/p>\\r\\n    <\\/form>\\r\\n<\\/div>\\r\\n",\n        "forum_listings_category": "\\r\\n<div class=\\"panel panel-success\\">\\r\\n    <div class=\\"panel-heading\\"><b>%category_name%<\\/b>\\r\\n        <small>%category_desc%<\\/small>\\r\\n    <\\/div>\\r\\n    <table class=\\"table table-striped\\">\\r\\n        <tbody>\\r\\n        %category_forums%\\r\\n        <\\/tbody>\\r\\n    <\\/table>\\r\\n<\\/div>\\r\\n",\n        "forum_listings_node": "\\r\\n<tr>\\r\\n    @if( ''%status%'' == ''read'')\\r\\n    <td><i class=\\"fa fa-folder-o fa-3 node-read\\"><\\/i><\\/td>\\r\\n    @else\\r\\n    <td><i class=\\"fa fa-folder fa-3 node-read\\"><\\/i><\\/td>\\r\\n    @endif\\r\\n    <td style=\\"width:70%;\\">\\r\\n        <span class=\\"tooltip_toggle\\" data-toggle=\\"tooltip\\" title=\\"%node_desc%\\" data-placement=\\"right\\">%node_name%<\\/span><br\\/>\\r\\n        <small>Sub-Forums: %sub_forums%<\\/small>\\r\\n    <\\/td>\\r\\n    <td style=\\"width:30%;\\">\\r\\n        %latest_post%\\r\\n    <\\/td>\\r\\n<\\/tr>\\r\\n",\n        "forum_listings_node_latest": "\\r\\n<img src=\\"%user_avatar%\\" class=\\"img-thumbnail pull-left\\" style=\\"width:42;height:42px;margin-right:5px;\\"\\/>\\r\\n%latest_post%<br\\/>\\r\\n<small>%post_user%, %post_time%<\\/small>\\r\\n",\n        "forum_listings_node_threads": "\\r\\n%breadcrumbs%\\r\\n%sub_forums%\\r\\n<div style=\\"height:auto;\\">\\r\\n    <p class=\\"pull-right\\">\\r\\n        %post_thread_button%\\r\\n    <\\/p>\\r\\n\\r\\n    <p class=\\"pull-left\\">\\r\\n\\r\\n    <div class=\\"btn-group\\">\\r\\n        <button type=\\"button\\" class=\\"btn btn-default dropdown-toggle\\" data-toggle=\\"dropdown\\">\\r\\n            <i class=\\"glyphicon glyphicon-sort\\"><\\/i>\\r\\n        <\\/button>\\r\\n        <ul class=\\"dropdown-menu\\" role=\\"menu\\">\\r\\n            <li><a href=\\"%sort_latest_created%\\"><i class=\\"glyphicon glyphicon-sort-by-order\\"><\\/i> By Latest Created<\\/a>\\r\\n            <\\/li>\\r\\n            <li><a href=\\"%sort_name_desc%\\"><i class=\\"glyphicon glyphicon-sort-by-alphabet-alt\\"><\\/i> By Name\\r\\n                    Descending<\\/a><\\/li>\\r\\n            <li><a href=\\"%sort_name_asc%\\"><i class=\\"glyphicon glyphicon-sort-by-alphabet\\"><\\/i> By Name Ascending<\\/a>\\r\\n            <\\/li>\\r\\n            <li><a href=\\"%sort_last_updated%\\"><i class=\\"glyphicon glyphicon-sort-by-attributes-alt\\"><\\/i> By Last Updated<\\/a>\\r\\n            <\\/li>\\r\\n        <\\/ul>\\r\\n    <\\/div>\\r\\n    <\\/p>\\r\\n<\\/div>\\r\\n<table class=\\"table table-hover\\">\\r\\n    <thead>\\r\\n    <tr>\\r\\n        <th style=\\"width:70%;\\">Thread<\\/th>\\r\\n        <th style=\\"width:30%;\\">Last Post<\\/th>\\r\\n    <\\/tr>\\r\\n    <\\/thead>\\r\\n    <tbody>\\r\\n    %threads%\\r\\n    <\\/tbody>\\r\\n<\\/table>\\r\\n",\n        "forum_listings_node_sub_forums": "\\r\\n<table class=\\"table table-hover\\">\\r\\n    <thead>\\r\\n    <tr>\\r\\n        <th style=\\"width:70%;\\"><\\/th>\\r\\n        <th style=\\"width:30%;\\"><\\/th>\\r\\n    <\\/tr>\\r\\n    <\\/thead>\\r\\n    <tbody>\\r\\n    %nodes%\\r\\n    <\\/tbody>\\r\\n<\\/table>\\r\\n",\n        "forum_listings_node_sub_forums_posts": "\\r\\n<tr>\\r\\n    <td>%node_name%<br\\/>\\r\\n        <small>%node_desc%<\\/small>\\r\\n    <\\/td>\\r\\n    <td>\\r\\n        %latest_post%\\r\\n    <\\/td>\\r\\n<\\/tr>\\r\\n",\n        "forum_listings_node_sub_forums_latest": "\\r\\n<img src=\\"%user_avatar%\\" class=\\"img-thumbnail pull-left\\" style=\\"width:42;height:42px;margin-right:5px;\\"\\/>\\r\\n<span class=\\"pull-right\\" style=\\"text-align:right;\\">\\r\\n    %latest_post%<br\\/>\\r\\n    <small>%post_user%, %post_time%<\\/small>\\r\\n<\\/span>\\r\\n",\n        "forum_listings_node_threads_posts": "\\r\\n<tr>\\r\\n    <td><img src=\\"%user_avatar%\\" class=\\"img-thumbnail pull-left\\" style=\\"width:42;height:42px;margin-right:5px;\\"\\/>%label% %thread_name%\\r\\n        <span class=\\"label label-info pull-right\\">%status%<\\/span><br\\/>\\r\\n        <small>%user%, %post_time%<\\/small>\\r\\n    <\\/td>\\r\\n    <td>\\r\\n        %latest_post%\\r\\n    <\\/td>\\r\\n<\\/tr>\\r\\n",\n        "forum_listings_node_threads_latestreply": "\\r\\n<img src=\\"%user_avatar%\\" class=\\"img-thumbnail pull-left\\" style=\\"width:42;height:42px;margin-right:5px;\\"\\/>\\r\\n<span class=\\"pull-right\\" style=\\"text-align:right;\\">\\r\\n    %post_user%<br\\/><small>%post_time%<\\/small>\\r\\n<\\/span>\\r\\n",\n        "create_thread": "%breadcrumbs%\\r\\n<form id=\\"%form_id%\\" action=\\"%create_thread_form_action%\\" method=\\"POST\\">\\r\\n    %csrf_input%\\r\\n    %labels%\\r\\n    <input type=\\"text\\" name=\\"%title_name%\\" placeholder=\\"Thread Title...\\" style=\\"width:%width%%;\\" class=\\"col-sm-9 form-control\\"\\/>\\r\\n    <div class=\\"clearfix\\"><\\/div>\\r\\n    <br\\/>\\r\\n    <textarea id=\\"%editor_id%\\" style=\\"width:100%;height:300px;max-width:100%;\\" name=\\"%textarea_name%\\"><\\/textarea>\\r\\n\\r\\n    <div class=\\"center-block\\" style=\\"margin-top:5px;\\">\\r\\n        <input type=\\"submit\\" name=\\"%submit_name%\\" value=\\"Create Thread\\"\\/>\\r\\n    <\\/div>",\n        "reply_thread_page": "\\r\\n%breadcrumbs%\\r\\n%quote_post%\\r\\n<form id=\\"%form_id%\\" action=\\"%create_thread_form_action%\\" method=\\"POST\\">\\r\\n    %csrf_input%\\r\\n    <textarea id=\\"%editor_id%\\" style=\\"width:100%;height:300px;max-width:100%;\\" name=\\"%textarea_name%\\"><\\/textarea>\\r\\n\\r\\n    <div class=\\"center-block\\" style=\\"margin-top:5px;\\">\\r\\n        <input type=\\"submit\\" name=\\"%submit_name%\\" value=\\"Reply Thread\\"\\/>\\r\\n        <a href=\\"%thread_url%\\">Return<\\/a>\\r\\n    <\\/div>\\r\\n<\\/form>\\r\\n",\n        "user_profile_page": "\\r\\n<div class=\\"well\\" style=\\"overflow:auto;\\">\\r\\n    <p class=\\"pull-left\\">\\r\\n        <font class=\\"lead\\">%username% %gender%<\\/font>\\r\\n        <br\\/>\\r\\n        (%usergroup%)<br\\/>\\r\\n        <b>Registered On:<\\/b> %registered_date% <br\\/>\\r\\n        <b>Location:<\\/b> %flag% %location%<br\\/>\\r\\n        <b>Age:<\\/b> %age%\\r\\n    <\\/p>\\r\\n\\r\\n    <p class=\\"pull-right\\">\\r\\n        <img src=\\"%user_avatar%\\" class=\\"img-thumbnail\\" style=\\"width:75px;height:75px;\\"\\/>\\r\\n    <\\/p>\\r\\n<\\/div>\\r\\n<ul class=\\"nav nav-tabs\\">\\r\\n    <li class=\\"active\\"><a href=\\"#profile_comments\\" data-toggle=\\"tab\\">Profile Comments<\\/a><\\/li>\\r\\n    <li><a href=\\"#profile_info\\" data-toggle=\\"tab\\">Information<\\/a><\\/li>\\r\\n    <li><a href=\\"#profile_activity\\" data-toggle=\\"tab\\">Recent Activity<\\/a><\\/li>\\r\\n<\\/ul>\\r\\n<div class=\\"tab-content\\">\\r\\n    <div class=\\"tab-pane active\\" id=\\"profile_comments\\">\\r\\n        <br\\/>\\r\\n        %comments%\\r\\n        %form%\\r\\n       <\\/div>\\r\\n    <div class=\\"tab-pane\\" id=\\"profile_info\\">\\r\\n        <strong>About User:<\\/strong><br\\/>\\r\\n\\r\\n        <div class=\\"well\\">\\r\\n            %about_user%\\r\\n        <\\/div>\\r\\n        <strong>Signature:<\\/strong><br\\/>\\r\\n\\r\\n        <div class=\\"well\\">\\r\\n            %user_signature%\\r\\n        <\\/div>\\r\\n        <strong>Recent Visitors:<\\/strong><br\\/>\\r\\n\\r\\n        <div class=\\"well\\">\\r\\n            %visitors%\\r\\n        <\\/div>\\r\\n        %mod_tools%\\r\\n    <\\/div>\\r\\n    <div class=\\"tab-pane\\" id=\\"profile_activity\\">\\r\\n        <br\\/>\\r\\n        %recent_activity%\\r\\n    <\\/div>\\r\\n<\\/div>\\r\\n",\n        "user_profile_comments": "<div>\\r\\n  <table>\\r\\n    <tr>\\r\\n   \\t\\t<td><a href=\\"%profile_url%\\"><img src=\\"%avatar%\\" width=\\"50px\\" height=\\"50px\\" \\/><\\/a><\\/td>\\r\\n      \\t<td style=\\"padding-left: 10px;\\"><a href=\\"%profile_url%\\">%writer%<\\/a> - %date%<br\\/>%comment%<\\/td>\\r\\n    <\\/tr>\\r\\n  <\\/table>\\r\\n  <hr\\/>\\r\\n<\\/div>",\n        "user_profile_comments_form": "\\r\\n<form action=\\"%comments_action%\\" method=\\"POST\\">\\r\\n    <textarea id=\\"\\" style=\\"width:100%;height:120px;max-width:100%;\\" name=\\"comment\\"><\\/textarea>\\r\\n\\r\\n    <div class=\\"center-block\\" style=\\"margin-top:5px;\\">\\r\\n        <input type=\\"submit\\" name=\\"comment_submit\\" value=\\"Post Comment\\"\\/>\\r\\n    <\\/div>\\r\\n<\\/form>\\r\\n",\n        "advanced_search": "<form action=\\"%site_url%\\/search.php\\" method=\\"POST\\">\\r\\n  <div class=''form-group''>\\r\\n    <label for=''search_field''>Search<\\/label>\\r\\n    <input placeholder=''Enter search query'' name=\\"search_query\\" type=''text'' id=''search_field''>\\r\\n  <\\/div>\\r\\n  <div class=''form-group''>\\r\\n  \\t<label for=\\"\\">Timeframe<\\/label>\\r\\n    <div class=\\"form-inline\\">\\r\\n      <input type=\\"text\\" style=\\"width: 200px; float: left;\\" name=\\"time_from\\" id=\\"time_from\\" placeholder=\\"from DD-MM-YYYY\\" \\/>\\r\\n      <span style=\\"padding-left: 5px; padding-right: 5px; font-size:20px; padding-top: 10px; float: left;\\">-<\\/span> \\r\\n      \\r\\n      <input type=\\"text\\" style=\\"width: 200px;\\" name=\\"time_to\\" id=\\"time_to\\" placeholder=\\"to DD-MM-YYYY\\" \\/>\\r\\n  <\\/div>\\r\\n    <\\/div>\\r\\n  <div class=''form-group clearfix''>\\r\\n    <label>Advanced parameter<\\/label>\\r\\n  <\\/div>\\r\\n  <div class=\\"checkbox\\">\\r\\n    <label class=''checkbox-inline'' for=\\"user_search\\">\\r\\n      <input type=''checkbox'' name=\\"user_search\\" id=\\"user_search\\" CHECKED> Search for users? \\r\\n    <\\/label>\\r\\n    <label class=''checkbox-inline'' for=\\"boolean_mode\\">\\r\\n      <input type=''checkbox'' name=\\"boolean_mode\\" id=\\"boolean_mode\\"> Boolean-Mode? \\r\\n    <\\/label>\\r\\n  <\\/div>\\r\\n      <input type=\\"hidden\\" value=\\"advanced\\" name=\\"search_type\\" \\/>\\r\\n      <input type=\\"submit\\" value=\\"Search\\" name=\\"search_submit\\" \\/>\\r\\n<\\/form>\\r\\n  ",\n        "search_page": "\\r\\n<br /><ul class=\\"nav nav-tabs\\">\\r\\n    <li class=\\"active\\"><a href=\\"#search_threads\\" data-toggle=\\"tab\\">Threads<\\/a><\\/li>\\r\\n    <li><a href=\\"#search_users\\" data-toggle=\\"tab\\">Users<\\/a><\\/li>\\r\\n<\\/ul>\\r\\n<div class=\\"tab-content\\">\\r\\n    <div class=\\"tab-pane active\\" id=\\"search_threads\\">\\r\\n        <br\\/>\\r\\n        %searched_threads%\\r\\n    <\\/div>\\r\\n    <div class=\\"tab-pane\\" id=\\"search_users\\">\\r\\n        <br\\/>\\r\\n        %searched_users%\\r\\n    <\\/div>\\r\\n<\\/div>\\r\\n",\n        "mod_reports": "\\r\\n<ul class=\\"nav nav-tabs\\">\\r\\n    <li class=\\"active\\"><a href=\\"#mod_post_reports\\" data-toggle=\\"tab\\">Reported Posts<\\/a><\\/li>\\r\\n    <li><a href=\\"#mod_user_reports\\" data-toggle=\\"tab\\">Reported Users<\\/a><\\/li>\\r\\n<\\/ul>\\r\\n<div class=\\"tab-content\\">\\r\\n    <div class=\\"tab-pane active\\" id=\\"mod_post_reports\\">\\r\\n        <br\\/><br\\/>\\r\\n        %reported_posts%\\r\\n    <\\/div>\\r\\n    <div class=\\"tab-pane\\" id=\\"mod_user_reports\\">\\r\\n        <br\\/><br\\/>\\r\\n        %reported_users%\\r\\n    <\\/div>\\r\\n<\\/div>\\r\\n",\n        "content_box": "\\r\\n<div class=\\"panel panel-default\\">\\r\\n    <div class=\\"panel-heading\\">\\r\\n        <h3 class=\\"panel-title\\">%content_header%<\\/h3>\\r\\n    <\\/div>\\r\\n    <div class=\\"panel-body\\">\\r\\n        %content_body%\\r\\n    <\\/div>\\r\\n<\\/div>\\r\\n",\n        "register_form": "\\r\\n<form action=\\"\\" method=\\"POST\\">\\r\\n    %notice%\\r\\n    %csrf_field%\\r\\n    <label for=\\"username\\">Username<\\/label>\\r\\n    <input type=\\"text\\" name=\\"%username_field_name%\\" value=\\"%form_username_value%\\" id=\\"username\\" class=\\"form-control\\"\\/>\\r\\n    <label for=\\"password\\">Password<\\/label>\\r\\n    <input type=\\"password\\" name=\\"%password_field_name%\\" id=\\"password\\" class=\\"form-control\\"\\/>\\r\\n    <label for=\\"a_password\\">Confirm Password<\\/label>\\r\\n    <input type=\\"password\\" name=\\"%password_a_field_name%\\" id=\\"a_password\\" class=\\"form-control\\"\\/>\\r\\n    <label for=\\"email\\">Email<\\/label>\\r\\n    <input type=\\"text\\" name=\\"%email_field_name%\\" value=\\"%form_email_value%\\" id=\\"email\\" class=\\"form-control\\"\\/>\\r\\n    <label for=\\"tangobb_captcha\\">Are you a bot?<\\/label><br\\/>\\r\\n    %captcha%\\r\\n    <br\\/><br\\/>\\r\\n    <input type=\\"submit\\" name=\\"%submit_name%\\" value=\\"Register\\" class=\\"btn btn-default\\"\\/>\\r\\n    %register_notice%\\r\\n<\\/form>\\r\\n",\n        "login_form": "\\r\\n<form action=\\"\\" method=\\"POST\\">\\r\\n    <label for=\\"email\\">Username or Email<\\/label>\\r\\n    <input type=\\"text\\" name=\\"%email_field_name%\\" id=\\"email\\" class=\\"form-control\\"\\/>\\r\\n    <label for=\\"password\\">Password<\\/label>\\r\\n    <input type=\\"password\\" name=\\"%password_field_name%\\" id=\\"password\\" class=\\"form-control\\"\\/>\\r\\n    <br\\/>\\r\\n    <input type=\\"submit\\" name=\\"%submit_field_name%\\" value=\\"Sign In\\" class=\\"btn btn-default\\"\\/>\\r\\n    <input type=\\"checkbox\\" name=\\"%remember_field_name%\\"\\/> Remember Me\\r\\n    <a href=\\"%site_url%\\/members.php\\/cmd\\/forgotpassword\\" class=\\"btn btn-link\\">Forgot Password<\\/a>\\r\\n<\\/form>\\r\\n",\n        "forget_password_form": "\\r\\n<form action=\\"\\" method=\\"POST\\" id=\\"tango_form\\">\\r\\n    %csrf_field%\\r\\n    <label for=\\"email\\">Email<\\/label>\\r\\n    <input type=\\"text\\" name=\\"%email_field_name%\\" id=\\"email\\" class=\\"form-control\\"\\/>\\r\\n    <br\\/><br\\/>\\r\\n    <input type=\\"submit\\" name=\\"%submit_field_name%\\" value=\\"Send Email\\" class=\\"btn btn-default\\"\\/>\\r\\n<\\/form>\\r\\n",\n        "reset_password_form": "\\r\\n<form action=\\"\\" method=\\"POST\\" id=\\"tango_form\\">\\r\\n    %csrf_field%\\r\\n    <label for=\\"password\\">Password<\\/label>\\r\\n    <input type=\\"password\\" name=\\"%password_field_name%\\" id=\\"password\\" class=\\"form-control\\"\\/>\\r\\n    <label for=\\"a_password\\">Confirm Password<\\/label>\\r\\n    <input type=\\"password\\" name=\\"%password_a_field_name%\\" id=\\"a_password\\" class=\\"form-control\\"\\/>\\r\\n    <br\\/><br\\/>\\r\\n    <input type=\\"submit\\" name=\\"%submit_field_name%\\" value=\\"Reset Password\\" class=\\"btn btn-default\\"\\/>\\r\\n<\\/form>\\r\\n",\n        "conversation_read": "\\r\\n<span class=\\"pull-right\\"><i class=\\"glyphicon glyphicon-eye-open\\"><\\/i><\\/span>\\r\\n",\n        "conversation_unread": "\\r\\n<span class=\\"pull-right\\"><i class=\\"glyphicon glyphicon-eye-close\\"><\\/i><\\/span>\\r\\n",\n        "conversation_new_message": "\\r\\n<span class=\\"label label-success pull-right\\">New messages<\\/span>\\r\\n",\n        "conversation_delete": "\\r\\n<a href=\\"%link%\\"><i class=\\"glyphicon glyphicon-trash\\"><\\/i><\\/a>\\r\\n",\n        "conversation_overview": "\\r\\n<div class=\\"panel panel-default\\">\\r\\n    <div class=\\"panel-heading\\"><strong>%overview_header%<\\/strong><\\/div>\\r\\n    <div class=\\"panel-body\\">\\r\\n        %conversations%\\r\\n    <\\/div>\\r\\n<\\/div>\\r\\n",\n        "smiley_list": "\\r\\n<br\\/>\\r\\n<ul class=\\"nav nav-tabs\\">\\r\\n    <li class=\\"active\\"><a href=\\"#smilies\\" data-toggle=\\"tab\\">Smilies<\\/a><\\/li>\\r\\n    <li><a href=\\"#misc\\" data-toggle=\\"tab\\">Misc<\\/a><\\/li>\\r\\n    <li><a href=\\"#food\\" data-toggle=\\"tab\\">Food<\\/a><\\/li>\\r\\n    <li><a href=\\"#plants\\" data-toggle=\\"tab\\">Plants<\\/a><\\/li>\\r\\n    <li><a href=\\"#animals\\" data-toggle=\\"tab\\">Animals<\\/a><\\/li>\\r\\n<\\/ul>\\r\\n<div class=\\"tab-content\\">\\r\\n    <div class=\\"tab-pane active\\" id=\\"smilies\\">\\r\\n        %smilies%\\r\\n    <\\/div>\\r\\n    <div class=\\"tab-pane\\" id=\\"misc\\">\\r\\n        %misc%\\r\\n    <\\/div>\\r\\n    <div class=\\"tab-pane\\" id=\\"food\\">\\r\\n        %food%\\r\\n    <\\/div>\\r\\n    <div class=\\"tab-pane\\" id=\\"plants\\">\\r\\n        %plants%\\r\\n    <\\/div>\\r\\n    <div class=\\"tab-pane\\" id=\\"animals\\">\\r\\n        %animals%\\r\\n    <\\/div>\\r\\n<\\/div>\\r\\n",\n        "poll_list": "%answer%\\r\\n<div class=\\"progress\\">\\r\\n    <div class=\\"progress-bar progress-bar-success\\" role=\\"progressbar\\" aria-valuenow=\\"%now%\\" aria-valuemin=\\"0\\" aria-valuemax=\\"%total%\\" style=\\"width: %percentage%%;\\">\\r\\n    <\\/div>\\r\\n<\\/div>",\n        "poll_overview": "<div style=\\"border: 1px solid #F8F5F0; border-radius: 4px; padding: 15px;margin: 0 auto;float:none;\\" class=\\"col-md-10\\">\\r\\n<b>%question%<\\/b><br \\/>\\r\\n%poll_list%\\r\\n<\\/div>\\r\\n<div class=\\"clearfix\\"><\\/div>",\n        "poll_form": "<form action=\\"\\" method=\\"POST\\">\\r\\n%answers%\\r\\n<input type=\\"submit\\" name=\\"submit_form\\" value=\\"Vote now!\\"\\/>\\r\\n<\\/form>",\n        "thread_options": "<script>\\r\\nvar field = 3;\\r\\nvar counter = 1;\\r\\nvar i = 3;\\r\\nfunction plus() {\\r\\n  var content = new Array();\\r\\n    field++;\\r\\n    for (counter = 3; counter < (field-1); counter++) {\\r\\n        content[counter] = document.getElementById(\\"answer_\\" + counter).value;\\r\\n    }\\r\\n    document.getElementById(\\"dynamic\\").innerHTML = \\"\\";\\r\\n    for (i = 3; i < field; i++) {\\r\\n        if (typeof(content[i]) == \\"undefined\\")\\r\\n        {\\r\\n            content[i] =\\"\\";\\r\\n        }\\r\\n        document.getElementById(\\"dynamic\\").innerHTML +=\\r\\n   \\"<label for=''answer_\\" + i + \\"''>\\" + i + \\". Answer<\\/label><input type=''text'' value=''\\" + content[i] + \\"'' name=''answer_\\" + i + \\"'' id=''answer_\\" + i + \\"''  \\/>\\";\\r\\n    }\\r\\n}\\r\\n<\\/script>\\r\\n<br\\/>\\r\\n<ul class=\\"nav nav-tabs\\">\\r\\n    <li class=\\"active\\"><a href=\\"#polls\\" data-toggle=\\"tab\\">Polls<\\/a><\\/li>\\r\\n    <\\/ul>\\r\\n<div class=\\"tab-content\\">\\r\\n    <div class=\\"tab-pane active\\" id=\\"polls\\">\\r\\n         <div class=\\"col-md-6\\">\\r\\n             <label for=\\"question\\">Question<\\/label>\\r\\n             <input type=\\"text\\" name=\\"question\\" \\/>\\r\\n             <label for=\\"answer_1\\">1. Answer<\\/label>\\r\\n             <input type=\\"text\\" name=\\"answer_1\\" id=\\"answer_1\\" \\/>\\r\\n             <label for=\\"answer_2\\">2. Answer<\\/label>\\r\\n             <input type=\\"text\\" name=\\"answer_2\\" id=\\"answer_2\\" \\/>\\r\\n             <div id=\\"dynamic\\">\\r\\n             <\\/div>\\r\\n             <span href=\\"\\" onClick=\\"plus();\\"> Add an answer field <\\/span>\\r\\n         <\\/div>\\r\\n    <\\/div>\\r\\n    \\r\\n<\\/div>\\r\\n<\\/form>"\n    },\n    "buttons": {\n        "custom_button": "\\r\\n<a href=\\"%url%\\" class=\\"btn btn-primary\\">%name%<\\/a>\\r\\n",\n        "create_thread": "\\r\\n<a href=\\"%url%\\" class=\\"btn btn-primary\\">New Thread<\\/a>\\r\\n",\n        "reply_thread": "\\r\\n<a href=\\"#reply\\" class=\\"btn btn-primary\\">Reply<\\/a>\\r\\n",\n        "watch_thread": "\\r\\n<small><a href=\\"%url%\\">Watch Thread<\\/a><\\/small>\\r\\n",\n        "unwatch_thread": "\\r\\n<small><a href=\\"%url%\\">Unwatch Thread<\\/a><\\/small>\\r\\n",\n        "quote_post": "\\r\\n<a href=\\"%url%\\" class=\\"btn btn-primary\\">Quote<\\/a>\\r\\n",\n        "edit_post": "\\r\\n<a href=\\"%url%\\" class=\\"btn btn-primary\\">Edit<\\/a>\\r\\n",\n        "report_post": "\\r\\n<a href=\\"%url%\\" class=\\"btn btn-primary\\">Report<\\/a>\\r\\n",\n        "mod_tools": "\\r\\n<a href=\\"%stick_thread_url%\\">%stick_thread%<\\/a> | <a href=\\"%close_thread_url%\\">%close_thread%<\\/a> | <a\\r\\n    href=\\"%edit_post_url%\\">Edit Post<\\/a> | <a href=\\"%delete_post_url%\\">Delete Thread<\\/a>\\r\\n<br\\/>\\r\\n%move_thread_form%\\r\\n",\n        "mod_tools_posts": "\\r\\n<a href=\\"%edit_post_url%\\">Edit Post<\\/a> | <a href=\\"%delete_post_url%\\">Delete Post<\\/a>\\r\\n",\n        "mod_tools_profile": "\\r\\n<a href=\\"%ban_user_url%\\" class=\\"btn btn-primary\\">%ban_user%<\\/a>\\r\\n"\n    }\n}\n');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]thread_tracking`
--

CREATE TABLE `[[dbprefix]]thread_tracking` (
  `user_id` int(11) NOT NULL,
  `thread_id` int(11) NOT NULL,
  `last_visit` int(11) NOT NULL,
  PRIMARY KEY (`user_id`,`thread_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]usergroups`
--

CREATE TABLE `[[dbprefix]]usergroups` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `group_name` varchar(255) NOT NULL,
  `group_style` varchar(255) NOT NULL DEFAULT '%username%',
  `group_permissions` varchar(255) NOT NULL DEFAULT '0',
  `is_staff` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=5 ;

--
-- Dumping data for table `[[dbprefix]]usergroups`
--

INSERT INTO `[[dbprefix]]usergroups` VALUES
(1, 'User', '<span>%username%</span>', '1,2,3', 0),
(2, 'Banned', '<span>%username% (Banned)</span>', '0', 0),
(3, 'Moderator', '<span style="color:#3a5892;"><strong>%username%</strong></span>', '1,2,3,4', 1),
(4, 'Administrator', '<span style="color:#762727;"><strong>%username%</strong></span>', '*', 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]users`
--

CREATE TABLE `[[dbprefix]]users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `username` varchar(255) NOT NULL,
  `user_password` varchar(255) NOT NULL,
  `user_email` varchar(255) NOT NULL,
  `user_message` varchar(255) NOT NULL DEFAULT 'User',
  `user_avatar` varchar(255) NOT NULL DEFAULT 'default.png',
  `avatar_type` int(11) NOT NULL DEFAULT '0',
  `user_signature` varchar(255) NOT NULL,
  `about_user` varchar(255) NOT NULL,
  `location` varchar(2) NOT NULL DEFAULT '--',
  `gender` int(1) DEFAULT '0',
  `date_joined` int(11) NOT NULL,
  `user_birthday` date NOT NULL,
  `additional_permissions` varchar(255) NOT NULL DEFAULT '0',
  `user_group` int(11) NOT NULL DEFAULT '1',
  `display_group` int(11) NOT NULL,
  `chosen_theme` int(11) NOT NULL DEFAULT '0',
  `set_timezone` varchar(255) NOT NULL DEFAULT 'US/Central',
  `user_disabled` int(11) NOT NULL DEFAULT '0',
  `is_banned` int(11) NOT NULL DEFAULT '0',
  `unban_time` int(11) NOT NULL,
  `ban_reason` varchar(255) NOT NULL DEFAULT 'None',
  `facebook_id` varchar(100) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]users`
--

INSERT INTO `[[dbprefix]]users` VALUES
(1, '[[admin_username]]', '[[admin_pass]]', '[[admin_email]]', 'User', 'default.png', 0, '', '', '--', 0, [[timestamp]], '0000-00-00', '0', 4, 0, 0, 'US/Central', 0, 0, 0, 'None', '0');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]user_comments`
--

CREATE TABLE `[[dbprefix]]user_comments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `profile_owner` int(11) NOT NULL,
  `writer` int(11) NOT NULL,
  `comment` text NOT NULL,
  `timestamp` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]user_visitors`
--

CREATE TABLE `[[dbprefix]]user_visitors` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `profile_owner` int(11) NOT NULL,
  `visitor` int(11) NOT NULL,
  `timestamp` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
