<?php
require_once(dirname(__FILE__).'/IRSS.php');
require_once(dirname(__FILE__).'/RSSBase.php');

abstract class RSS_V_abstract extends RSSBase implements IRSS 
{
	
	protected $rssdata;
	protected $xml;
	protected $filename;
	
	function __construct(RSSBuilder $rssdata) 
	{
		$this->rssdata = $rssdata;
	} // end constructor
	
	protected function getRSSData() {
		return $this->rssdata;
	} // end function
	
	protected function generateXML() {
		$this->xml = new DomDocument('1.0', $this->rssdata->getEncoding());
		//$this->xml->appendChild($this->xml->createComment('RSS generated by Flaimo.com RSS Builder [' .  date('Y-m-d H:i:s')  .']'));
	} // end function
	
	public function outputRSS($output = TRUE) {
		if (!isset($this->xml)) {
			$this->generateXML();
		} // end if
		header('content-type: text/xml');
		header('Content-Disposition: inline; filename=' . $this->rssdata->getFilename());
		echo $this->xml->saveXML();
	} // end function
	
	public function saveRSS($path = '') {
		if (!isset($this->xml)) {
			$this->generateXML();
		} // end if
		$this->xml->save($path . $this->rssdata->getFilename());
		return $path . $this->rssdata->getFilename();
	} // end function
	
	public function getRSSOutput() {
		if (!isset($this->xml)) {
			$this->generateXML();
		} // end if
		return $this->xml->saveXML();
	} // function
} // end class
?>