<?php

require_once('svnmanager/global/Security.php');

class GroupPrivilegesEditPage extends TPage
{
	public function setSelectedRepository($repos)
	{
		$this->setViewState('SelectedRepository', $repos, '');
	}
	
	public function getSelectedRepository()
	{
		return $this->getViewState('SelectedRepository', '');
	}
	
	public function onInit($param)
	{
		parent::onInit($param);
		
		$repositoryid = $_GET['RepositoryID'];	
		
		$results = $this->Module->Database->Execute("SELECT * FROM repositories WHERE id=" . makeSqlString($repositoryid));
		$fields = $results->fields;
		$ownerid = $fields['ownerid'];
		
		if(!$this->User->isAdmin() && $this->User->getId()!=$ownerid)
		{
			echo "Not enough rights to change this repository!";
			exit(-1);
		}
		
		$this->setSelectedRepository($repositoryid);
		
		$ownername = $this->Module->getUserName($ownerid);
		$repositoryname = $this->Module->getRepositoryname($repositoryid); 

		$this->RepositoryName->setText($repositoryname);
		$this->RepositoryOwner->setText($ownername);

		//Reproduce dynamic buttons for proper event handling (something is not completely right, Prado!)
		$sess = $this->Application->getSession();
		if($sess->has("linkbuttons"))
		{
			$linkbuttons = $sess->get("linkbuttons");			
			foreach($linkbuttons as $lb)
			{
				$this->PathHolder->addChild($lb);
				$this->PathHolder->addBody($lb);
			}
			$sess->clear("linkbuttons");
		}
		
		if($sess->has("listbox"))
		{
			$listbox = $sess->get("listbox");
			$this->PathHolder->addChild($listbox);
			$this->PathHolder->addBody($listbox);
			$sess->clear("listbox");
		}
	}
	
	public function onLoad($param)
	{
		parent::onLoad($param);
		
		//Catch postback of path change events and handle them!
		if($this->IsPostBack)		
		{
  			$sender=$this->Page->getPostBackTarget();  			  			
  			
  			if($sender!=null)
  				$sid=$sender->getId();  			  			
  			else
  				$sid="AddPath";  				  			
  			
  			$path=$this->getViewState('Path','');
  			
  			if($sid=="AddPath")  			
  			{
				$path[]=$this->PathHolder->AddPath->getSelectedItem()->getText();// Value();				
  			} else 
  			if(strlen($sid)>3 && substr($sid,0,3)=="lev" )
  			{
  				$nlevel=$sender->getCommandParameter();
  				$newpath=array();
  				$newpath[]="/";
  				if($nlevel>1)
  					for($i=1;$i<$nlevel;$i++)
  						$newpath[]=$path[$i];
  				$path=$newpath;
  			}
  			$this->setViewState('Path', $path);
		} 
			
		
		//Make list of granted rights
		$repositoryid = $_GET['RepositoryID'];	
		$results = $this->Module->Database->Execute("SELECT * FROM groupprivileges WHERE repositoryid=" . makeSqlString($repositoryid) . " ORDER BY path, groupid");
		if($results->RecordCount()>0)
		{
			$data = array();
			while(!$results->EOF)
			{
				$fields = $results->fields;
				 
				$id = $fields['id'];
				$groupname = $this->Module->getGroupname($fields['groupid']);
				$path = $fields['path'];

				/*
				 * Access:
				 * 0 = no access
				 * 1 = r 
				 * 2 = w 
				 * 3 = rw
	 			*/

				
				if($fields['access']==1 || $fields['access']==3 )
					$read="yes";
				else
					$read="no";
					
				if($fields['access']==2 || $fields['access']==3 )
					$write="yes";
				else
					$write="no";			
							
				$data[] = array(
					'id' => $id,
					'groupname' => $groupname,
					'path' => $path,
					'read' => $read,
					'write' => $write
				);				
				
				$results->MoveNext();				

			}
			$results->Close();
			$this->RightsTable->setDataSource($data);
			$this->RightsTable->dataBind();
		}

		//Make a list of groups (users that are created during right-management are NOT shown!!)
		if(!$this->isPostBack())
		{		
			$groupnames = array();
			$groupresults = $this->Module->Database->Execute("SELECT * FROM groups ORDER BY name");
		
			while(!$groupresults->EOF)
			{															
				$groupnames[] = $groupresults->fields['name'];
				$groupresults->MoveNext();
			}
			$groupresults->Close();

			$this->GroupSelector->setDataSource($groupnames);
			$this->GroupSelector->databind();
		}

		//Fill place holder
		$path = $this->getViewState('Path','');
		if(!isset($path)||$path=='') 
		{
			$path = array();
			$path[]="/";	
		}
		
		$this->setViewState('Path',$path);
		
		$this->PathHolder->removeBodies();
		$this->PathHolder->removeChildren();
		
		$sess = $this->Application->getSession();
		
		//Linkbuttons
		$linkbuttons = array();
		$level=0;
		foreach($path as $p)
		{
			$id="lev$level";
			$lb = $this->PathHolder->createComponent('TLinkButton',$id);
			$lb->setText($p);
			$lb->setCommandName("path");
			$lb->setCommandParameter($level);
			$linkbuttons[]=$lb; 
			if($level>1)$this->PathHolder->addBody("/");
			$this->PathHolder->addBody($lb);
			$level++;			
		}
		
		$sess->set("linkbuttons", $linkbuttons);
		
		//retrieve sub paths from repositoty
		require_once("VersionControl/SVN.php");
		require("config.php");
		$svnstack = &PEAR_ErrorStack::singleton('VersionControl_SVN');

		// 2006-02-15 PDurden Check to see if this is a Windows installation
		//if (isset($is_windows) && $is_windows)
		if(strtoupper(substr(PHP_OS, 0, 3)) === 'WIN')
		{
			$svn_cmd = getenv("COMSPEC")." /C ".$svn_cmd;
		}

		// Set up runtime options. 
		$options = array('fetchmode' => VERSIONCONTROL_SVN_FETCHMODE_ARRAY, 'svn_path' => $svn_cmd);
		//Request list class from factory
		$svn = VersionControl_SVN::factory('list', $options);

		// 2006-02-15 PDurden Check to see if this is a Windows installation
		//if (isset($is_windows) && $is_windows)
		if(strtoupper(substr(PHP_OS, 0, 3)) === 'WIN')		
		{
			$svn->use_escapeshellcmd = false;
		}
		
		$repositoryid = $_GET['RepositoryID'];
		$repositoryname = $this->Module->getRepositoryname($repositoryid);

		//if (isset($is_windows) && $is_windows)
		if(strtoupper(substr(PHP_OS, 0, 3)) === 'WIN')		
		{
			if (substr($svn_repos_loc, 0, 1) != '/') $svn_repos_loc = '/'.$svn_repos_loc;
			$svn_repos_loc = str_replace("\\", "/", $svn_repos_loc);  
		}

		$url = "file://$svn_repos_loc/$repositoryname";		

		if(sizeof($path)>1)
		{
			foreach($path as $p)$url.="/$p";
		}
		
		// 2006-02-16 PDurden - If there's a space in the URL, place it in quotes
		if (strstr($url, " "))
		{
			$url = "\"".$url."\"";
		}
		
		$switches = array();
		$switches = array('config_dir' => $svn_config_dir);
		 
		$args = array($url);
			
		$subfolders=array();		
		
		if($output = $svn->run($args, $switches))
		{
			$subfolders[]=" -choose- ";
			foreach($output as $entry)
			{				
				if($entry['type']=='D')$subfolders[]=$entry['name'];
			}
		} else {
			if (count($errs = $svnstack->getErrors())) 
			{ 
		   		foreach ($errs as $err) {
    	        	echo '<br />'.$err['message']."<br />\n";
            		echo "Command used: " . $err['params']['cmd'];
         		}
         		exit(-1);
			}
		}
		
		if(sizeof($subfolders)>1)
		{
			$listbox = $this->PathHolder->createComponent('TListBox','AddPath');
			$listbox->setDataSource($subfolders);
			$listbox->dataBind();
			$listbox->setRows(1);	
			$listbox->setAutoPostBack(true);				
			if($level>1)$this->PathHolder->addBody("/");
			$this->PathHolder->addBody($listbox);
			$sess->set("listbox", $listbox);
		} else {
			$sess->clear("listbox");
		}				

	}
	
	public function onPrerender($param)
	{
		parent::onPreRender($param);
		
		//If there's a listbox, select the first item (somehow this need to be done at onPrerender, Prado?)
		$sess=$this->Application->getSession();
		if($sess->has("listbox"))
			$this->PathHolder->AddPath->setSelectedIndex(0);
		
	}
	
	public function onRemovePrivileges($sender, $param)
	{
		$id = $param->parameter;
		
		//Check if user may remove this privileges
		if(!$this->User->isAdmin())
		{
			$priv = $this->Module->Database->Execute("SELECT * FROM groupprivileges WHERE id=" . makeSqlString($id));
			$reposid = $priv->fields['repositoryid'];
			$priv->Close();
			$repos = $this->Module->Database->Execute("SELECT * FROM repositories WHERE id=" . makeSqlString($reposid));
			$ownerid = $repos->fields['ownerid'];
			$repos->Close();
			if($this->User->getId()!=$ownerid)
			{
				echo "Not enough rights to change these privileges!";
				exit(-1);
			}
		}
			
		$this->Module->removeGroupPrivileges($id);
		$this->Application->transfer('Repository:GroupPrivilegesEditPage', array('RepositoryID' => $this->getSelectedRepository() ));				
				
	}

	public function onClickAddBtn($sender, $param)
	{
		$repositoryid = $this->getSelectedRepository();
		$groupname = $this->GroupSelector->getSelectedItem()->getText();
		$groupid = $this->Module->getGroupId($groupname);

		$path = "";
			
		//Create selected path string
		$patha = $this->getViewState('Path','');
		$i=0;
		foreach($patha as $p)
		{
			if($i>1)$path.="/";
			$path.=$p;
			$i++;
		}
		
		/*
		 * Access:
		 * 0 = no access
		 * 1 = r 
		 * 2 = w 
		 * 3 = rw
	 	*/
	 	
	 	$access=0;
	 	if($this->Read->isChecked())$access+=1;
	 	if($this->Write->isChecked())$access+=2;
		
		$this->Module->addGroupPrivileges($groupid, $repositoryid, $path, $access);
		$this->Application->transfer('Repository:GroupPrivilegesEditPage', array('RepositoryID' => $this->getSelectedRepository() ));
		
	}
	
	public function onClickDoneBtn($sender, $param)
	{
		$this->Application->transfer('Repository:AdminPage');
	}
		
}
?>
