
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `supercali110`
--

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]categories`
--

CREATE TABLE `[[dbprefix]]categories` (
  `category_id` int(6) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(40) NOT NULL DEFAULT '',
  `sub_of` int(6) unsigned NOT NULL DEFAULT '1',
  `sequence` int(2) unsigned NOT NULL DEFAULT '1',
  `restricted` int(1) unsigned NOT NULL DEFAULT '0',
  `description` text,
  `color` varchar(30) DEFAULT NULL,
  `background` varchar(255) DEFAULT '',
  PRIMARY KEY (`category_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]categories`
--

INSERT INTO `[[dbprefix]]categories` VALUES
(1, '[[site_name]]', 0, 1, 0, 'Top Level Category', NULL, '');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]dates`
--

CREATE TABLE `[[dbprefix]]dates` (
  `event_id` int(8) unsigned DEFAULT '0',
  `date` datetime DEFAULT NULL,
  `end_date` datetime DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]events`
--

CREATE TABLE `[[dbprefix]]events` (
  `event_id` int(8) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `venue_id` int(6) unsigned NOT NULL DEFAULT '1',
  `contact_id` int(6) unsigned NOT NULL DEFAULT '1',
  `description` text,
  `category_id` int(6) unsigned NOT NULL DEFAULT '1',
  `user_id` int(6) unsigned DEFAULT NULL,
  `group_id` int(6) unsigned NOT NULL DEFAULT '1',
  `status_id` int(1) unsigned NOT NULL DEFAULT '1',
  `stamp` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `quick_approve` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`event_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]groups`
--

CREATE TABLE `[[dbprefix]]groups` (
  `group_id` int(6) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(40) NOT NULL DEFAULT '',
  `sub_of` int(6) unsigned NOT NULL DEFAULT '1',
  `sequence` int(2) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`group_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]groups`
--

INSERT INTO `[[dbprefix]]groups` VALUES
(1, '[[site_name]]', 0, 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]links`
--

CREATE TABLE `[[dbprefix]]links` (
  `link_id` int(6) unsigned NOT NULL AUTO_INCREMENT,
  `company` varchar(50) DEFAULT NULL,
  `address1` varchar(40) DEFAULT NULL,
  `address2` varchar(40) DEFAULT NULL,
  `city` varchar(30) DEFAULT NULL,
  `state` char(2) DEFAULT NULL,
  `zip` varchar(10) DEFAULT NULL,
  `phone` varchar(15) DEFAULT NULL,
  `fax` varchar(15) DEFAULT NULL,
  `email` varchar(120) DEFAULT NULL,
  `url` varchar(120) DEFAULT NULL,
  `contact` varchar(50) DEFAULT NULL,
  `description` text,
  PRIMARY KEY (`link_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]links`
--

INSERT INTO `[[dbprefix]]links` VALUES
(1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]modules`
--

CREATE TABLE `[[dbprefix]]modules` (
  `module_id` int(6) unsigned NOT NULL AUTO_INCREMENT,
  `link_name` varchar(20) NOT NULL DEFAULT '',
  `name` varchar(60) NOT NULL DEFAULT '',
  `active` int(1) unsigned NOT NULL DEFAULT '0',
  `sequence` int(2) unsigned NOT NULL DEFAULT '1',
  `script` varchar(60) DEFAULT NULL,
  `year` int(2) unsigned DEFAULT NULL,
  `month` int(2) unsigned DEFAULT NULL,
  `week` int(2) unsigned DEFAULT NULL,
  `day` int(2) unsigned DEFAULT NULL,
  PRIMARY KEY (`module_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=5 ;

--
-- Dumping data for table `[[dbprefix]]modules`
--

INSERT INTO `[[dbprefix]]modules` VALUES
(1, 'Year', 'Year', 1, 1, 'year.php', 1, 2, 3, 4),
(2, 'Month', 'Month', 1, 2, 'grid.php', 1, 2, 3, 4),
(3, 'Week', 'Week', 1, 3, 'week.php', 1, 2, 3, 4),
(4, 'Day', 'Day', 1, 4, 'day.php', 1, 2, 3, 4);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]users`
--

CREATE TABLE `[[dbprefix]]users` (
  `user_id` int(6) unsigned NOT NULL AUTO_INCREMENT,
  `password` varchar(32) NOT NULL DEFAULT '',
  `temp_password` varchar(32) DEFAULT NULL,
  `email` varchar(80) NOT NULL DEFAULT '',
  `view` int(1) unsigned NOT NULL DEFAULT '0',
  `post` int(1) unsigned NOT NULL DEFAULT '0',
  `add_users` int(1) unsigned NOT NULL DEFAULT '0',
  `add_categories` int(1) unsigned NOT NULL DEFAULT '0',
  `add_groups` int(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`user_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;

--
-- Dumping data for table `[[dbprefix]]users`
--

INSERT INTO `[[dbprefix]]users` VALUES
(1, '', NULL, 'Public Access', 1, 0, 0, 0, 0),
(2, '[[admin_pass]]', NULL, '[[admin_email]]', 1, 1, 1, 1, 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]users_to_categories`
--

CREATE TABLE `[[dbprefix]]users_to_categories` (
  `user_id` int(6) unsigned NOT NULL DEFAULT '0',
  `category_id` int(6) unsigned NOT NULL DEFAULT '0',
  `moderate` int(1) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]users_to_categories`
--

INSERT INTO `[[dbprefix]]users_to_categories` VALUES
(1, 1, 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]users_to_groups`
--

CREATE TABLE `[[dbprefix]]users_to_groups` (
  `user_id` int(6) unsigned NOT NULL DEFAULT '0',
  `group_id` int(6) unsigned NOT NULL DEFAULT '0',
  `moderate` int(1) NOT NULL DEFAULT '0',
  `subscribe` int(1) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]users_to_groups`
--

INSERT INTO `[[dbprefix]]users_to_groups` VALUES
(1, 1, 1, 0);

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
