/*
 Copyright (c) 2010, Yahoo! Inc. All rights reserved.
 Code licensed under the BSD License:
 http://developer.yahoo.com/yui/license.html
 version: 3.3.0
 build: 3167
 */
YUI.add('dd-ddm-base',function(Y){var DDMBase=function(){DDMBase.superclass.constructor.apply(this,arguments);};DDMBase.NAME='ddm';DDMBase.ATTRS={dragCursor:{value:'move'},clickPixelThresh:{value:3},clickTimeThresh:{value:1000},throttleTime:{value:-1},dragMode:{value:'point',setter:function(mode){this._setDragMode(mode);return mode;}}};Y.extend(DDMBase,Y.Base,{_createPG:function(){},_active:null,_setDragMode:function(mode){if(mode===null){mode=Y.DD.DDM.get('dragMode');}
switch(mode){case 1:case'intersect':return 1;case 2:case'strict':return 2;case 0:case'point':return 0;}
return 0;},CSS_PREFIX:Y.ClassNameManager.getClassName('dd'),_activateTargets:function(){},_drags:[],activeDrag:false,_regDrag:function(d){if(this.getDrag(d.get('node'))){return false;}
if(!this._active){this._setupListeners();}
this._drags.push(d);return true;},_unregDrag:function(d){var tmp=[];Y.each(this._drags,function(n,i){if(n!==d){tmp[tmp.length]=n;}});this._drags=tmp;},_setupListeners:function(){this._createPG();this._active=true;var doc=Y.one(Y.config.doc);doc.on('mousemove',Y.throttle(Y.bind(this._move,this),this.get('throttleTime')));doc.on('mouseup',Y.bind(this._end,this));},_start:function(){this.fire('ddm:start');this._startDrag();},_startDrag:function(){},_endDrag:function(){},_dropMove:function(){},_end:function(){if(this.activeDrag){this._endDrag();this.fire('ddm:end');this.activeDrag.end.call(this.activeDrag);this.activeDrag=null;}},stopDrag:function(){if(this.activeDrag){this._end();}
return this;},_move:function(ev){if(this.activeDrag){this.activeDrag._move.call(this.activeDrag,ev);this._dropMove();}},cssSizestoObject:function(gutter){var x=gutter.split(' ');switch(x.length){case 1:x[1]=x[2]=x[3]=x[0];break;case 2:x[2]=x[0];x[3]=x[1];break;case 3:x[3]=x[1];break;}
return{top:parseInt(x[0],10),right:parseInt(x[1],10),bottom:parseInt(x[2],10),left:parseInt(x[3],10)};},getDrag:function(node){var drag=false,n=Y.one(node);if(n instanceof Y.Node){Y.each(this._drags,function(v,k){if(n.compareTo(v.get('node'))){drag=v;}});}
return drag;},swapPosition:function(n1,n2){n1=Y.DD.DDM.getNode(n1);n2=Y.DD.DDM.getNode(n2);var xy1=n1.getXY(),xy2=n2.getXY();n1.setXY(xy2);n2.setXY(xy1);return n1;},getNode:function(n){if(n&&n.get){if(Y.Widget&&(n instanceof Y.Widget)){n=n.get('boundingBox');}else{n=n.get('node');}}else{n=Y.one(n);}
return n;},swapNode:function(n1,n2){n1=Y.DD.DDM.getNode(n1);n2=Y.DD.DDM.getNode(n2);var p=n2.get('parentNode'),s=n2.get('nextSibling');if(s==n1){p.insertBefore(n1,n2);}else if(n2==n1.get('nextSibling')){p.insertBefore(n2,n1);}else{n1.get('parentNode').replaceChild(n2,n1);p.insertBefore(n1,s);}
return n1;}});Y.namespace('DD');Y.DD.DDM=new DDMBase();},'3.3.0',{requires:['node','base','yui-throttle','classnamemanager'],skinnable:false});YUI.add('dd-ddm',function(Y){Y.mix(Y.DD.DDM,{_pg:null,_debugShim:false,_activateTargets:function(){},_deactivateTargets:function(){},_startDrag:function(){if(this.activeDrag&&this.activeDrag.get('useShim')){this._pg_activate();this._activateTargets();}},_endDrag:function(){this._pg_deactivate();this._deactivateTargets();},_pg_deactivate:function(){this._pg.setStyle('display','none');},_pg_activate:function(){var ah=this.activeDrag.get('activeHandle'),cur='auto';if(ah){cur=ah.getStyle('cursor');}
if(cur=='auto'){cur=this.get('dragCursor');}
this._pg_size();this._pg.setStyles({top:0,left:0,display:'block',opacity:((this._debugShim)?'.5':'0'),cursor:cur});},_pg_size:function(){if(this.activeDrag){var b=Y.one('body'),h=b.get('docHeight'),w=b.get('docWidth');this._pg.setStyles({height:h+'px',width:w+'px'});}},_createPG:function(){var pg=Y.Node.create('<div></div>'),bd=Y.one('body'),win;pg.setStyles({top:'0',left:'0',position:'absolute',zIndex:'9999',overflow:'hidden',backgroundColor:'red',display:'none',height:'5px',width:'5px'});pg.set('id',Y.stamp(pg));pg.addClass(Y.DD.DDM.CSS_PREFIX+'-shim');bd.prepend(pg);this._pg=pg;this._pg.on('mousemove',Y.throttle(Y.bind(this._move,this),this.get('throttleTime')));this._pg.on('mouseup',Y.bind(this._end,this));win=Y.one('win');Y.on('window:resize',Y.bind(this._pg_size,this));win.on('scroll',Y.bind(this._pg_size,this));}},true);},'3.3.0',{requires:['dd-ddm-base','event-resize'],skinnable:false});YUI.add('dd-ddm-drop',function(Y){Y.mix(Y.DD.DDM,{_noShim:false,_activeShims:[],_hasActiveShim:function(){if(this._noShim){return true;}
return this._activeShims.length;},_addActiveShim:function(d){this._activeShims[this._activeShims.length]=d;},_removeActiveShim:function(d){var s=[];Y.each(this._activeShims,function(v,k){if(v._yuid!==d._yuid){s[s.length]=v;}});this._activeShims=s;},syncActiveShims:function(force){Y.later(0,this,function(force){var drops=((force)?this.targets:this._lookup());Y.each(drops,function(v,k){v.sizeShim.call(v);},this);},force);},mode:0,POINT:0,INTERSECT:1,STRICT:2,useHash:true,activeDrop:null,validDrops:[],otherDrops:{},targets:[],_addValid:function(drop){this.validDrops[this.validDrops.length]=drop;return this;},_removeValid:function(drop){var drops=[];Y.each(this.validDrops,function(v,k){if(v!==drop){drops[drops.length]=v;}});this.validDrops=drops;return this;},isOverTarget:function(drop){if(this.activeDrag&&drop){var xy=this.activeDrag.mouseXY,r,dMode=this.activeDrag.get('dragMode'),aRegion,node=drop.shim;if(xy&&this.activeDrag){aRegion=this.activeDrag.region;if(dMode==this.STRICT){return this.activeDrag.get('dragNode').inRegion(drop.region,true,aRegion);}else{if(drop&&drop.shim){if((dMode==this.INTERSECT)&&this._noShim){r=((aRegion)?aRegion:this.activeDrag.get('node'));return drop.get('node').intersect(r,drop.region).inRegion;}else{if(this._noShim){node=drop.get('node');}
return node.intersect({top:xy[1],bottom:xy[1],left:xy[0],right:xy[0]},drop.region).inRegion;}}else{return false;}}}else{return false;}}else{return false;}},clearCache:function(){this.validDrops=[];this.otherDrops={};this._activeShims=[];},_activateTargets:function(){this._noShim=true;this.clearCache();Y.each(this.targets,function(v,k){v._activateShim([]);if(v.get('noShim')==true){this._noShim=false;}},this);this._handleTargetOver();},getBestMatch:function(drops,all){var biggest=null,area=0,out;Y.each(drops,function(v,k){var inter=this.activeDrag.get('dragNode').intersect(v.get('node'));v.region.area=inter.area;if(inter.inRegion){if(inter.area>area){area=inter.area;biggest=v;}}},this);if(all){out=[];Y.each(drops,function(v,k){if(v!==biggest){out[out.length]=v;}},this);return[biggest,out];}else{return biggest;}},_deactivateTargets:function(){var other=[],tmp,activeDrag=this.activeDrag,activeDrop=this.activeDrop;if(activeDrag&&activeDrop&&this.otherDrops[activeDrop]){if(!activeDrag.get('dragMode')){other=this.otherDrops;delete other[activeDrop];}else{tmp=this.getBestMatch(this.otherDrops,true);activeDrop=tmp[0];other=tmp[1];}
activeDrag.get('node').removeClass(this.CSS_PREFIX+'-drag-over');if(activeDrop){activeDrop.fire('drop:hit',{drag:activeDrag,drop:activeDrop,others:other});activeDrag.fire('drag:drophit',{drag:activeDrag,drop:activeDrop,others:other});}}else if(activeDrag&&activeDrag.get('dragging')){activeDrag.get('node').removeClass(this.CSS_PREFIX+'-drag-over');activeDrag.fire('drag:dropmiss',{pageX:activeDrag.lastXY[0],pageY:activeDrag.lastXY[1]});}else{}
this.activeDrop=null;Y.each(this.targets,function(v,k){v._deactivateShim([]);},this);},_dropMove:function(){if(this._hasActiveShim()){this._handleTargetOver();}else{Y.each(this.otherDrops,function(v,k){v._handleOut.apply(v,[]);});}},_lookup:function(){if(!this.useHash||this._noShim){return this.validDrops;}
var drops=[];Y.each(this.validDrops,function(v,k){if(v.shim&&v.shim.inViewportRegion(false,v.region)){drops[drops.length]=v;}});return drops;},_handleTargetOver:function(){var drops=this._lookup();Y.each(drops,function(v,k){v._handleTargetOver.call(v);},this);},_regTarget:function(t){this.targets[this.targets.length]=t;},_unregTarget:function(drop){var targets=[],vdrops;Y.each(this.targets,function(v,k){if(v!=drop){targets[targets.length]=v;}},this);this.targets=targets;vdrops=[];Y.each(this.validDrops,function(v,k){if(v!==drop){vdrops[vdrops.length]=v;}});this.validDrops=vdrops;},getDrop:function(node){var drop=false,n=Y.one(node);if(n instanceof Y.Node){Y.each(this.targets,function(v,k){if(n.compareTo(v.get('node'))){drop=v;}});}
return drop;}},true);},'3.3.0',{requires:['dd-ddm'],skinnable:false});YUI.add('dd-drag',function(Y){var DDM=Y.DD.DDM,NODE='node',DRAGGING='dragging',DRAG_NODE='dragNode',OFFSET_HEIGHT='offsetHeight',OFFSET_WIDTH='offsetWidth',EV_MOUSE_DOWN='drag:mouseDown',EV_AFTER_MOUSE_DOWN='drag:afterMouseDown',EV_REMOVE_HANDLE='drag:removeHandle',EV_ADD_HANDLE='drag:addHandle',EV_REMOVE_INVALID='drag:removeInvalid',EV_ADD_INVALID='drag:addInvalid',EV_START='drag:start',EV_END='drag:end',EV_DRAG='drag:drag',EV_ALIGN='drag:align',Drag=function(o){this._lazyAddAttrs=false;Drag.superclass.constructor.apply(this,arguments);var valid=DDM._regDrag(this);if(!valid){Y.error('Failed to register node, already in use: '+o.node);}};Drag.NAME='drag';Drag.START_EVENT='mousedown';Drag.ATTRS={node:{setter:function(node){var n=Y.one(node);if(!n){Y.error('DD.Drag: Invalid Node Given: '+node);}
return n;}},dragNode:{setter:function(node){var n=Y.one(node);if(!n){Y.error('DD.Drag: Invalid dragNode Given: '+node);}
return n;}},offsetNode:{value:true},startCentered:{value:false},clickPixelThresh:{value:DDM.get('clickPixelThresh')},clickTimeThresh:{value:DDM.get('clickTimeThresh')},lock:{value:false,setter:function(lock){if(lock){this.get(NODE).addClass(DDM.CSS_PREFIX+'-locked');}else{this.get(NODE).removeClass(DDM.CSS_PREFIX+'-locked');}
return lock;}},data:{value:false},move:{value:true},useShim:{value:true},activeHandle:{value:false},primaryButtonOnly:{value:true},dragging:{value:false},parent:{value:false},target:{value:false,setter:function(config){this._handleTarget(config);return config;}},dragMode:{value:null,setter:function(mode){return DDM._setDragMode(mode);}},groups:{value:['default'],getter:function(){if(!this._groups){this._groups={};}
var ret=[];Y.each(this._groups,function(v,k){ret[ret.length]=k;});return ret;},setter:function(g){this._groups={};Y.each(g,function(v,k){this._groups[v]=true;},this);return g;}},handles:{value:null,setter:function(g){if(g){this._handles={};Y.each(g,function(v,k){var key=v;if(v instanceof Y.Node||v instanceof Y.NodeList){key=v._yuid;}
this._handles[key]=v;},this);}else{this._handles=null;}
return g;}},bubbles:{setter:function(t){this.addTarget(t);return t;}},haltDown:{value:true}};Y.extend(Drag,Y.Base,{_bubbleTargets:Y.DD.DDM,addToGroup:function(g){this._groups[g]=true;DDM._activateTargets();return this;},removeFromGroup:function(g){delete this._groups[g];DDM._activateTargets();return this;},target:null,_handleTarget:function(config){if(Y.DD.Drop){if(config===false){if(this.target){DDM._unregTarget(this.target);this.target=null;}
return false;}else{if(!Y.Lang.isObject(config)){config={};}
config.bubbleTargets=('bubbleTargets'in config)?config.bubbleTargets:Y.Object.values(this._yuievt.targets);config.node=this.get(NODE);config.groups=config.groups||this.get('groups');this.target=new Y.DD.Drop(config);}}else{return false;}},_groups:null,_createEvents:function(){this.publish(EV_MOUSE_DOWN,{defaultFn:this._defMouseDownFn,queuable:false,emitFacade:true,bubbles:true,prefix:'drag'});this.publish(EV_ALIGN,{defaultFn:this._defAlignFn,queuable:false,emitFacade:true,bubbles:true,prefix:'drag'});this.publish(EV_DRAG,{defaultFn:this._defDragFn,queuable:false,emitFacade:true,bubbles:true,prefix:'drag'});this.publish(EV_END,{defaultFn:this._defEndFn,preventedFn:this._prevEndFn,queuable:false,emitFacade:true,bubbles:true,prefix:'drag'});var ev=[EV_AFTER_MOUSE_DOWN,EV_REMOVE_HANDLE,EV_ADD_HANDLE,EV_REMOVE_INVALID,EV_ADD_INVALID,EV_START,'drag:drophit','drag:dropmiss','drag:over','drag:enter','drag:exit'];Y.each(ev,function(v,k){this.publish(v,{type:v,emitFacade:true,bubbles:true,preventable:false,queuable:false,prefix:'drag'});},this);},_ev_md:null,_startTime:null,_endTime:null,_handles:null,_invalids:null,_invalidsDefault:{'textarea':true,'input':true,'a':true,'button':true,'select':true},_dragThreshMet:null,_fromTimeout:null,_clickTimeout:null,deltaXY:null,startXY:null,nodeXY:null,lastXY:null,actXY:null,realXY:null,mouseXY:null,region:null,_handleMouseUp:function(ev){this.fire('drag:mouseup');this._fixIEMouseUp();if(DDM.activeDrag){DDM._end();}},_fixDragStart:function(e){e.preventDefault();},_ieSelectFix:function(){return false;},_ieSelectBack:null,_fixIEMouseDown:function(e){if(Y.UA.ie){this._ieSelectBack=Y.config.doc.body.onselectstart;Y.config.doc.body.onselectstart=this._ieSelectFix;}},_fixIEMouseUp:function(){if(Y.UA.ie){Y.config.doc.body.onselectstart=this._ieSelectBack;}},_handleMouseDownEvent:function(ev){this.fire(EV_MOUSE_DOWN,{ev:ev});},_defMouseDownFn:function(e){var ev=e.ev;this._dragThreshMet=false;this._ev_md=ev;if(this.get('primaryButtonOnly')&&ev.button>1){return false;}
if(this.validClick(ev)){this._fixIEMouseDown(ev);if(this.get('haltDown')){ev.halt();}else{ev.preventDefault();}
this._setStartPosition([ev.pageX,ev.pageY]);DDM.activeDrag=this;this._clickTimeout=Y.later(this.get('clickTimeThresh'),this,this._timeoutCheck);}
this.fire(EV_AFTER_MOUSE_DOWN,{ev:ev});},validClick:function(ev){var r=false,n=false,tar=ev.target,hTest=null,els=null,nlist=null,set=false;if(this._handles){Y.each(this._handles,function(i,n){if(i instanceof Y.Node||i instanceof Y.NodeList){if(!r){nlist=i;if(nlist instanceof Y.Node){nlist=new Y.NodeList(i._node);}
nlist.each(function(nl){if(nl.contains(tar)){r=true;}});}}else if(Y.Lang.isString(n)){if(tar.test(n+', '+n+' *')&&!hTest){hTest=n;r=true;}}});}else{n=this.get(NODE);if(n.contains(tar)||n.compareTo(tar)){r=true;}}
if(r){if(this._invalids){Y.each(this._invalids,function(i,n){if(Y.Lang.isString(n)){if(tar.test(n+', '+n+' *')){r=false;}}});}}
if(r){if(hTest){els=ev.currentTarget.all(hTest);set=false;els.each(function(n,i){if((n.contains(tar)||n.compareTo(tar))&&!set){set=true;this.set('activeHandle',n);}},this);}else{this.set('activeHandle',this.get(NODE));}}
return r;},_setStartPosition:function(xy){this.startXY=xy;this.nodeXY=this.lastXY=this.realXY=this.get(NODE).getXY();if(this.get('offsetNode')){this.deltaXY=[(this.startXY[0]-this.nodeXY[0]),(this.startXY[1]-this.nodeXY[1])];}else{this.deltaXY=[0,0];}},_timeoutCheck:function(){if(!this.get('lock')&&!this._dragThreshMet&&this._ev_md){this._fromTimeout=this._dragThreshMet=true;this.start();this._alignNode([this._ev_md.pageX,this._ev_md.pageY],true);}},removeHandle:function(str){var key=str;if(str instanceof Y.Node||str instanceof Y.NodeList){key=str._yuid;}
if(this._handles[key]){delete this._handles[key];this.fire(EV_REMOVE_HANDLE,{handle:str});}
return this;},addHandle:function(str){if(!this._handles){this._handles={};}
var key=str;if(str instanceof Y.Node||str instanceof Y.NodeList){key=str._yuid;}
this._handles[key]=str;this.fire(EV_ADD_HANDLE,{handle:str});return this;},removeInvalid:function(str){if(this._invalids[str]){this._invalids[str]=null;delete this._invalids[str];this.fire(EV_REMOVE_INVALID,{handle:str});}
return this;},addInvalid:function(str){if(Y.Lang.isString(str)){this._invalids[str]=true;this.fire(EV_ADD_INVALID,{handle:str});}
return this;},initializer:function(cfg){this.get(NODE).dd=this;if(!this.get(NODE).get('id')){var id=Y.stamp(this.get(NODE));this.get(NODE).set('id',id);}
this.actXY=[];this._invalids=Y.clone(this._invalidsDefault,true);this._createEvents();if(!this.get(DRAG_NODE)){this.set(DRAG_NODE,this.get(NODE));}
this.on('initializedChange',Y.bind(this._prep,this));this.set('groups',this.get('groups'));},_prep:function(){this._dragThreshMet=false;var node=this.get(NODE);node.addClass(DDM.CSS_PREFIX+'-draggable');node.on(Drag.START_EVENT,Y.bind(this._handleMouseDownEvent,this));node.on('mouseup',Y.bind(this._handleMouseUp,this));node.on('dragstart',Y.bind(this._fixDragStart,this));},_unprep:function(){var node=this.get(NODE);node.removeClass(DDM.CSS_PREFIX+'-draggable');node.detachAll();},start:function(){if(!this.get('lock')&&!this.get(DRAGGING)){var node=this.get(NODE),ow,oh,xy;this._startTime=(new Date()).getTime();DDM._start();node.addClass(DDM.CSS_PREFIX+'-dragging');this.fire(EV_START,{pageX:this.nodeXY[0],pageY:this.nodeXY[1],startTime:this._startTime});node=this.get(DRAG_NODE);xy=this.nodeXY;ow=node.get(OFFSET_WIDTH);oh=node.get(OFFSET_HEIGHT);if(this.get('startCentered')){this._setStartPosition([xy[0]+(ow / 2),xy[1]+(oh / 2)]);}
this.region={'0':xy[0],'1':xy[1],area:0,top:xy[1],right:xy[0]+ow,bottom:xy[1]+oh,left:xy[0]};this.set(DRAGGING,true);}
return this;},end:function(){this._endTime=(new Date()).getTime();if(this._clickTimeout){this._clickTimeout.cancel();}
this._dragThreshMet=this._fromTimeout=false;if(!this.get('lock')&&this.get(DRAGGING)){this.fire(EV_END,{pageX:this.lastXY[0],pageY:this.lastXY[1],startTime:this._startTime,endTime:this._endTime});}
this.get(NODE).removeClass(DDM.CSS_PREFIX+'-dragging');this.set(DRAGGING,false);this.deltaXY=[0,0];return this;},_defEndFn:function(e){this._fixIEMouseUp();this._ev_md=null;},_prevEndFn:function(e){this._fixIEMouseUp();this.get(DRAG_NODE).setXY(this.nodeXY);this._ev_md=null;this.region=null;},_align:function(xy){this.fire(EV_ALIGN,{pageX:xy[0],pageY:xy[1]});},_defAlignFn:function(e){this.actXY=[e.pageX-this.deltaXY[0],e.pageY-this.deltaXY[1]];},_alignNode:function(eXY){this._align(eXY);this._moveNode();},_moveNode:function(scroll){var diffXY=[],diffXY2=[],startXY=this.nodeXY,xy=this.actXY;diffXY[0]=(xy[0]-this.lastXY[0]);diffXY[1]=(xy[1]-this.lastXY[1]);diffXY2[0]=(xy[0]-this.nodeXY[0]);diffXY2[1]=(xy[1]-this.nodeXY[1]);this.region={'0':xy[0],'1':xy[1],area:0,top:xy[1],right:xy[0]+this.get(DRAG_NODE).get(OFFSET_WIDTH),bottom:xy[1]+this.get(DRAG_NODE).get(OFFSET_HEIGHT),left:xy[0]};this.fire(EV_DRAG,{pageX:xy[0],pageY:xy[1],scroll:scroll,info:{start:startXY,xy:xy,delta:diffXY,offset:diffXY2}});this.lastXY=xy;},_defDragFn:function(e){if(this.get('move')){if(e.scroll){e.scroll.node.set('scrollTop',e.scroll.top);e.scroll.node.set('scrollLeft',e.scroll.left);}
this.get(DRAG_NODE).setXY([e.pageX,e.pageY]);this.realXY=[e.pageX,e.pageY];}},_move:function(ev){if(this.get('lock')){return false;}else{this.mouseXY=[ev.pageX,ev.pageY];if(!this._dragThreshMet){var diffX=Math.abs(this.startXY[0]-ev.pageX),diffY=Math.abs(this.startXY[1]-ev.pageY);if(diffX>this.get('clickPixelThresh')||diffY>this.get('clickPixelThresh')){this._dragThreshMet=true;this.start();this._alignNode([ev.pageX,ev.pageY]);}}else{if(this._clickTimeout){this._clickTimeout.cancel();}
this._alignNode([ev.pageX,ev.pageY]);}}},stopDrag:function(){if(this.get(DRAGGING)){DDM._end();}
return this;},destructor:function(){this._unprep();this.detachAll();if(this.target){this.target.destroy();}
DDM._unregDrag(this);}});Y.namespace('DD');Y.DD.Drag=Drag;},'3.3.0',{requires:['dd-ddm-base'],skinnable:false});YUI.add('dd-proxy',function(Y){var DDM=Y.DD.DDM,NODE='node',DRAG_NODE='dragNode',HOST='host',TRUE=true,proto,P=function(config){P.superclass.constructor.apply(this,arguments);};P.NAME='DDProxy';P.NS='proxy';P.ATTRS={host:{},moveOnEnd:{value:TRUE},hideOnEnd:{value:TRUE},resizeFrame:{value:TRUE},positionProxy:{value:TRUE},borderStyle:{value:'1px solid #808080'},cloneNode:{value:false}};proto={_hands:null,_init:function(){if(!DDM._proxy){DDM._createFrame();Y.on('domready',Y.bind(this._init,this));return;}
if(!this._hands){this._hands=[];}
var h,h1,host=this.get(HOST),dnode=host.get(DRAG_NODE);if(dnode.compareTo(host.get(NODE))){if(DDM._proxy){host.set(DRAG_NODE,DDM._proxy);}}
Y.each(this._hands,function(v){v.detach();});h=DDM.on('ddm:start',Y.bind(function(){if(DDM.activeDrag===host){DDM._setFrame(host);}},this));h1=DDM.on('ddm:end',Y.bind(function(){if(host.get('dragging')){if(this.get('moveOnEnd')){host.get(NODE).setXY(host.lastXY);}
if(this.get('hideOnEnd')){host.get(DRAG_NODE).setStyle('display','none');}
if(this.get('cloneNode')){host.get(DRAG_NODE).remove();host.set(DRAG_NODE,DDM._proxy);}}},this));this._hands=[h,h1];},initializer:function(){this._init();},destructor:function(){var host=this.get(HOST);Y.each(this._hands,function(v){v.detach();});host.set(DRAG_NODE,host.get(NODE));},clone:function(){var host=this.get(HOST),n=host.get(NODE),c=n.cloneNode(true);delete c._yuid;c.setAttribute('id',Y.guid());c.setStyle('position','absolute');n.get('parentNode').appendChild(c);host.set(DRAG_NODE,c);return c;}};Y.namespace('Plugin');Y.extend(P,Y.Base,proto);Y.Plugin.DDProxy=P;Y.mix(DDM,{_createFrame:function(){if(!DDM._proxy){DDM._proxy=TRUE;var p=Y.Node.create('<div></div>'),b=Y.one('body');p.setStyles({position:'absolute',display:'none',zIndex:'999',top:'-999px',left:'-999px'});b.prepend(p);p.set('id',Y.guid());p.addClass(DDM.CSS_PREFIX+'-proxy');DDM._proxy=p;}},_setFrame:function(drag){var n=drag.get(NODE),d=drag.get(DRAG_NODE),ah,cur='auto';ah=DDM.activeDrag.get('activeHandle');if(ah){cur=ah.getStyle('cursor');}
if(cur=='auto'){cur=DDM.get('dragCursor');}
d.setStyles({visibility:'hidden',display:'block',cursor:cur,border:drag.proxy.get('borderStyle')});if(drag.proxy.get('cloneNode')){d=drag.proxy.clone();}
if(drag.proxy.get('resizeFrame')){d.setStyles({height:n.get('offsetHeight')+'px',width:n.get('offsetWidth')+'px'});}
if(drag.proxy.get('positionProxy')){d.setXY(drag.nodeXY);}
d.setStyle('visibility','visible');}});},'3.3.0',{requires:['dd-ddm','dd-drag'],skinnable:false});YUI.add('dd-constrain',function(Y){var DRAG_NODE='dragNode',OFFSET_HEIGHT='offsetHeight',OFFSET_WIDTH='offsetWidth',HOST='host',TICK_X_ARRAY='tickXArray',TICK_Y_ARRAY='tickYArray',DDM=Y.DD.DDM,TOP='top',RIGHT='right',BOTTOM='bottom',LEFT='left',VIEW='view',proto=null,EV_TICK_ALIGN_X='drag:tickAlignX',EV_TICK_ALIGN_Y='drag:tickAlignY',C=function(config){this._lazyAddAttrs=false;C.superclass.constructor.apply(this,arguments);};C.NAME='ddConstrained';C.NS='con';C.ATTRS={host:{},stickX:{value:false},stickY:{value:false},tickX:{value:false},tickY:{value:false},tickXArray:{value:false},tickYArray:{value:false},gutter:{value:'0',setter:function(gutter){return Y.DD.DDM.cssSizestoObject(gutter);}},constrain:{value:VIEW,setter:function(con){var node=Y.one(con);if(node){con=node;}
return con;}},constrain2region:{setter:function(r){return this.set('constrain',r);}},constrain2node:{setter:function(n){return this.set('constrain',Y.one(n));}},constrain2view:{setter:function(n){return this.set('constrain',VIEW);}},cacheRegion:{value:true}};proto={_lastTickXFired:null,_lastTickYFired:null,initializer:function(){this._createEvents();this.get(HOST).on('drag:end',Y.bind(this._handleEnd,this));this.get(HOST).on('drag:start',Y.bind(this._handleStart,this));this.get(HOST).after('drag:align',Y.bind(this.align,this));this.get(HOST).after('drag:drag',Y.bind(this.drag,this));},_createEvents:function(){var instance=this;var ev=[EV_TICK_ALIGN_X,EV_TICK_ALIGN_Y];Y.each(ev,function(v,k){this.publish(v,{type:v,emitFacade:true,bubbles:true,queuable:false,prefix:'drag'});},this);},_handleEnd:function(){this._lastTickYFired=null;this._lastTickXFired=null;},_handleStart:function(){this.resetCache();},_regionCache:null,_cacheRegion:function(){this._regionCache=this.get('constrain').get('region');},resetCache:function(){this._regionCache=null;},_getConstraint:function(){var con=this.get('constrain'),g=this.get('gutter'),region;if(con){if(con instanceof Y.Node){if(!this._regionCache){Y.on('resize',Y.bind(this._cacheRegion,this),Y.config.win);this._cacheRegion();}
region=Y.clone(this._regionCache);if(!this.get('cacheRegion')){this.resetCache();}}else if(Y.Lang.isObject(con)){region=Y.clone(con);}}
if(!con||!region){con=VIEW;}
if(con===VIEW){region=this.get(HOST).get(DRAG_NODE).get('viewportRegion');}
Y.each(g,function(i,n){if((n==RIGHT)||(n==BOTTOM)){region[n]-=i;}else{region[n]+=i;}});return region;},getRegion:function(inc){var r={},oh=null,ow=null,host=this.get(HOST);r=this._getConstraint();if(inc){oh=host.get(DRAG_NODE).get(OFFSET_HEIGHT);ow=host.get(DRAG_NODE).get(OFFSET_WIDTH);r[RIGHT]=r[RIGHT]-ow;r[BOTTOM]=r[BOTTOM]-oh;}
return r;},_checkRegion:function(_xy){var oxy=_xy,r=this.getRegion(),host=this.get(HOST),oh=host.get(DRAG_NODE).get(OFFSET_HEIGHT),ow=host.get(DRAG_NODE).get(OFFSET_WIDTH);if(oxy[1]>(r[BOTTOM]-oh)){_xy[1]=(r[BOTTOM]-oh);}
if(r[TOP]>oxy[1]){_xy[1]=r[TOP];}
if(oxy[0]>(r[RIGHT]-ow)){_xy[0]=(r[RIGHT]-ow);}
if(r[LEFT]>oxy[0]){_xy[0]=r[LEFT];}
return _xy;},inRegion:function(xy){xy=xy||this.get(HOST).get(DRAG_NODE).getXY();var _xy=this._checkRegion([xy[0],xy[1]]),inside=false;if((xy[0]===_xy[0])&&(xy[1]===_xy[1])){inside=true;}
return inside;},align:function(){var host=this.get(HOST),_xy=[host.actXY[0],host.actXY[1]],r=this.getRegion(true);if(this.get('stickX')){_xy[1]=(host.startXY[1]-host.deltaXY[1]);}
if(this.get('stickY')){_xy[0]=(host.startXY[0]-host.deltaXY[0]);}
if(r){_xy=this._checkRegion(_xy);}
_xy=this._checkTicks(_xy,r);host.actXY=_xy;},drag:function(event){var host=this.get(HOST),xt=this.get('tickX'),yt=this.get('tickY'),_xy=[host.actXY[0],host.actXY[1]];if((Y.Lang.isNumber(xt)||this.get(TICK_X_ARRAY))&&(this._lastTickXFired!==_xy[0])){this._tickAlignX();this._lastTickXFired=_xy[0];}
if((Y.Lang.isNumber(yt)||this.get(TICK_Y_ARRAY))&&(this._lastTickYFired!==_xy[1])){this._tickAlignY();this._lastTickYFired=_xy[1];}},_checkTicks:function(xy,r){var host=this.get(HOST),lx=(host.startXY[0]-host.deltaXY[0]),ly=(host.startXY[1]-host.deltaXY[1]),xt=this.get('tickX'),yt=this.get('tickY');if(xt&&!this.get(TICK_X_ARRAY)){xy[0]=DDM._calcTicks(xy[0],lx,xt,r[LEFT],r[RIGHT]);}
if(yt&&!this.get(TICK_Y_ARRAY)){xy[1]=DDM._calcTicks(xy[1],ly,yt,r[TOP],r[BOTTOM]);}
if(this.get(TICK_X_ARRAY)){xy[0]=DDM._calcTickArray(xy[0],this.get(TICK_X_ARRAY),r[LEFT],r[RIGHT]);}
if(this.get(TICK_Y_ARRAY)){xy[1]=DDM._calcTickArray(xy[1],this.get(TICK_Y_ARRAY),r[TOP],r[BOTTOM]);}
return xy;},_tickAlignX:function(){this.fire(EV_TICK_ALIGN_X);},_tickAlignY:function(){this.fire(EV_TICK_ALIGN_Y);}};Y.namespace('Plugin');Y.extend(C,Y.Base,proto);Y.Plugin.DDConstrained=C;Y.mix(DDM,{_calcTicks:function(pos,start,tick,off1,off2){var ix=((pos-start)/ tick),min=Math.floor(ix),max=Math.ceil(ix);if((min!==0)||(max!==0)){if((ix>=min)&&(ix<=max)){pos=(start+(tick*min));if(off1&&off2){if(pos<off1){pos=(start+(tick*(min+1)));}
if(pos>off2){pos=(start+(tick*(min-1)));}}}}
return pos;},_calcTickArray:function(pos,ticks,off1,off2){var i=0,len=ticks.length,next=0,diff1,diff2,ret;if(!ticks||(ticks.length===0)){return pos;}else if(ticks[0]>=pos){return ticks[0];}else{for(i=0;i<len;i++){next=(i+1);if(ticks[next]&&ticks[next]>=pos){diff1=pos-ticks[i];diff2=ticks[next]-pos;ret=(diff2>diff1)?ticks[i]:ticks[next];if(off1&&off2){if(ret>off2){if(ticks[i]){ret=ticks[i];}else{ret=ticks[len-1];}}}
return ret;}}
return ticks[ticks.length-1];}}});},'3.3.0',{requires:['dd-drag'],skinnable:false});YUI.add('dd-scroll',function(Y){var S=function(){S.superclass.constructor.apply(this,arguments);},WS,NS,HOST='host',BUFFER='buffer',PARENT_SCROLL='parentScroll',WINDOW_SCROLL='windowScroll',SCROLL_TOP='scrollTop',SCROLL_LEFT='scrollLeft',OFFSET_WIDTH='offsetWidth',OFFSET_HEIGHT='offsetHeight';S.ATTRS={parentScroll:{value:false,setter:function(node){if(node){return node;}
return false;}},buffer:{value:30,validator:Y.Lang.isNumber},scrollDelay:{value:235,validator:Y.Lang.isNumber},host:{value:null},windowScroll:{value:false,validator:Y.Lang.isBoolean},vertical:{value:true,validator:Y.Lang.isBoolean},horizontal:{value:true,validator:Y.Lang.isBoolean}};Y.extend(S,Y.Base,{_scrolling:null,_vpRegionCache:null,_dimCache:null,_scrollTimer:null,_getVPRegion:function(){var r={},n=this.get(PARENT_SCROLL),b=this.get(BUFFER),ws=this.get(WINDOW_SCROLL),xy=((ws)?[]:n.getXY()),w=((ws)?'winWidth':OFFSET_WIDTH),h=((ws)?'winHeight':OFFSET_HEIGHT),t=((ws)?n.get(SCROLL_TOP):xy[1]),l=((ws)?n.get(SCROLL_LEFT):xy[0]);r={top:t+b,right:(n.get(w)+l)-b,bottom:(n.get(h)+t)-b,left:l+b};this._vpRegionCache=r;return r;},initializer:function(){var h=this.get(HOST);h.after('drag:start',Y.bind(this.start,this));h.after('drag:end',Y.bind(this.end,this));h.on('drag:align',Y.bind(this.align,this));Y.one('win').on('scroll',Y.bind(function(){this._vpRegionCache=null;},this));},_checkWinScroll:function(move){var r=this._getVPRegion(),ho=this.get(HOST),ws=this.get(WINDOW_SCROLL),xy=ho.lastXY,scroll=false,b=this.get(BUFFER),win=this.get(PARENT_SCROLL),sTop=win.get(SCROLL_TOP),sLeft=win.get(SCROLL_LEFT),w=this._dimCache.w,h=this._dimCache.h,bottom=xy[1]+h,top=xy[1],right=xy[0]+w,left=xy[0],nt=top,nl=left,st=sTop,sl=sLeft;if(this.get('horizontal')){if(left<=r.left){scroll=true;nl=xy[0]-((ws)?b:0);sl=sLeft-b;}
if(right>=r.right){scroll=true;nl=xy[0]+((ws)?b:0);sl=sLeft+b;}}
if(this.get('vertical')){if(bottom>=r.bottom){scroll=true;nt=xy[1]+((ws)?b:0);st=sTop+b;}
if(top<=r.top){scroll=true;nt=xy[1]-((ws)?b:0);st=sTop-b;}}
if(st<0){st=0;nt=xy[1];}
if(sl<0){sl=0;nl=xy[0];}
if(nt<0){nt=xy[1];}
if(nl<0){nl=xy[0];}
if(move){ho.actXY=[nl,nt];ho._moveNode({node:win,top:st,left:sl});if(!st&&!sl){this._cancelScroll();}}else{if(scroll){this._initScroll();}else{this._cancelScroll();}}},_initScroll:function(){this._cancelScroll();this._scrollTimer=Y.Lang.later(this.get('scrollDelay'),this,this._checkWinScroll,[true],true);},_cancelScroll:function(){this._scrolling=false;if(this._scrollTimer){this._scrollTimer.cancel();delete this._scrollTimer;}},align:function(e){if(this._scrolling){this._cancelScroll();e.preventDefault();}
if(!this._scrolling){this._checkWinScroll();}},_setDimCache:function(){var node=this.get(HOST).get('dragNode');this._dimCache={h:node.get(OFFSET_HEIGHT),w:node.get(OFFSET_WIDTH)};},start:function(){this._setDimCache();},end:function(xy){this._dimCache=null;this._cancelScroll();},toString:function(){return S.NAME+' #'+this.get('node').get('id');}});Y.namespace('Plugin');WS=function(){WS.superclass.constructor.apply(this,arguments);};WS.ATTRS=Y.merge(S.ATTRS,{windowScroll:{value:true,setter:function(scroll){if(scroll){this.set(PARENT_SCROLL,Y.one('win'));}
return scroll;}}});Y.extend(WS,S,{initializer:function(){this.set('windowScroll',this.get('windowScroll'));}});WS.NAME=WS.NS='winscroll';Y.Plugin.DDWinScroll=WS;NS=function(){NS.superclass.constructor.apply(this,arguments);};NS.ATTRS=Y.merge(S.ATTRS,{node:{value:false,setter:function(node){var n=Y.one(node);if(!n){if(node!==false){Y.error('DDNodeScroll: Invalid Node Given: '+node);}}else{this.set(PARENT_SCROLL,n);}
return n;}}});Y.extend(NS,S,{initializer:function(){this.set('node',this.get('node'));}});NS.NAME=NS.NS='nodescroll';Y.Plugin.DDNodeScroll=NS;Y.DD.Scroll=S;},'3.3.0',{requires:['dd-drag'],skinnable:false,optional:['dd-proxy']});YUI.add('dd-drop',function(Y){var NODE='node',DDM=Y.DD.DDM,OFFSET_HEIGHT='offsetHeight',OFFSET_WIDTH='offsetWidth',EV_DROP_OVER='drop:over',EV_DROP_ENTER='drop:enter',EV_DROP_EXIT='drop:exit',Drop=function(){this._lazyAddAttrs=false;Drop.superclass.constructor.apply(this,arguments);Y.on('domready',Y.bind(function(){Y.later(100,this,this._createShim);},this));DDM._regTarget(this);};Drop.NAME='drop';Drop.ATTRS={node:{setter:function(node){var n=Y.one(node);if(!n){Y.error('DD.Drop: Invalid Node Given: '+node);}
return n;}},groups:{value:['default'],setter:function(g){this._groups={};Y.each(g,function(v,k){this._groups[v]=true;},this);return g;}},padding:{value:'0',setter:function(p){return DDM.cssSizestoObject(p);}},lock:{value:false,setter:function(lock){if(lock){this.get(NODE).addClass(DDM.CSS_PREFIX+'-drop-locked');}else{this.get(NODE).removeClass(DDM.CSS_PREFIX+'-drop-locked');}
return lock;}},bubbles:{setter:function(t){this.addTarget(t);return t;}},useShim:{value:true,setter:function(v){Y.DD.DDM._noShim=!v;return v;}}};Y.extend(Drop,Y.Base,{_bubbleTargets:Y.DD.DDM,addToGroup:function(g){this._groups[g]=true;return this;},removeFromGroup:function(g){delete this._groups[g];return this;},_createEvents:function(){var ev=[EV_DROP_OVER,EV_DROP_ENTER,EV_DROP_EXIT,'drop:hit'];Y.each(ev,function(v,k){this.publish(v,{type:v,emitFacade:true,preventable:false,bubbles:true,queuable:false,prefix:'drop'});},this);},_valid:null,_groups:null,shim:null,region:null,overTarget:null,inGroup:function(groups){this._valid=false;var ret=false;Y.each(groups,function(v,k){if(this._groups[v]){ret=true;this._valid=true;}},this);return ret;},initializer:function(cfg){Y.later(100,this,this._createEvents);var node=this.get(NODE),id;if(!node.get('id')){id=Y.stamp(node);node.set('id',id);}
node.addClass(DDM.CSS_PREFIX+'-drop');this.set('groups',this.get('groups'));},destructor:function(){DDM._unregTarget(this);if(this.shim&&(this.shim!==this.get(NODE))){this.shim.detachAll();this.shim.remove();this.shim=null;}
this.get(NODE).removeClass(DDM.CSS_PREFIX+'-drop');this.detachAll();},_deactivateShim:function(){if(!this.shim){return false;}
this.get(NODE).removeClass(DDM.CSS_PREFIX+'-drop-active-valid');this.get(NODE).removeClass(DDM.CSS_PREFIX+'-drop-active-invalid');this.get(NODE).removeClass(DDM.CSS_PREFIX+'-drop-over');if(this.get('useShim')){this.shim.setStyles({top:'-999px',left:'-999px',zIndex:'1'});}
this.overTarget=false;},_activateShim:function(){if(!DDM.activeDrag){return false;}
if(this.get(NODE)===DDM.activeDrag.get(NODE)){return false;}
if(this.get('lock')){return false;}
var node=this.get(NODE);if(this.inGroup(DDM.activeDrag.get('groups'))){node.removeClass(DDM.CSS_PREFIX+'-drop-active-invalid');node.addClass(DDM.CSS_PREFIX+'-drop-active-valid');DDM._addValid(this);this.overTarget=false;if(!this.get('useShim')){this.shim=this.get(NODE);}
this.sizeShim();}else{DDM._removeValid(this);node.removeClass(DDM.CSS_PREFIX+'-drop-active-valid');node.addClass(DDM.CSS_PREFIX+'-drop-active-invalid');}},sizeShim:function(){if(!DDM.activeDrag){return false;}
if(this.get(NODE)===DDM.activeDrag.get(NODE)){return false;}
if(this.get('lock')){return false;}
if(!this.shim){Y.later(100,this,this.sizeShim);return false;}
var node=this.get(NODE),nh=node.get(OFFSET_HEIGHT),nw=node.get(OFFSET_WIDTH),xy=node.getXY(),p=this.get('padding'),dd,dH,dW;nw=nw+p.left+p.right;nh=nh+p.top+p.bottom;xy[0]=xy[0]-p.left;xy[1]=xy[1]-p.top;if(DDM.activeDrag.get('dragMode')===DDM.INTERSECT){dd=DDM.activeDrag;dH=dd.get(NODE).get(OFFSET_HEIGHT);dW=dd.get(NODE).get(OFFSET_WIDTH);nh=(nh+dH);nw=(nw+dW);xy[0]=xy[0]-(dW-dd.deltaXY[0]);xy[1]=xy[1]-(dH-dd.deltaXY[1]);}
if(this.get('useShim')){this.shim.setStyles({height:nh+'px',width:nw+'px',top:xy[1]+'px',left:xy[0]+'px'});}
this.region={'0':xy[0],'1':xy[1],area:0,top:xy[1],right:xy[0]+nw,bottom:xy[1]+nh,left:xy[0]};},_createShim:function(){if(!DDM._pg){Y.later(10,this,this._createShim);return;}
if(this.shim){return;}
var s=this.get('node');if(this.get('useShim')){s=Y.Node.create('<div id="'+this.get(NODE).get('id')+'_shim"></div>');s.setStyles({height:this.get(NODE).get(OFFSET_HEIGHT)+'px',width:this.get(NODE).get(OFFSET_WIDTH)+'px',backgroundColor:'yellow',opacity:'.5',zIndex:'1',overflow:'hidden',top:'-900px',left:'-900px',position:'absolute'});DDM._pg.appendChild(s);s.on('mouseover',Y.bind(this._handleOverEvent,this));s.on('mouseout',Y.bind(this._handleOutEvent,this));}
this.shim=s;},_handleTargetOver:function(){if(DDM.isOverTarget(this)){this.get(NODE).addClass(DDM.CSS_PREFIX+'-drop-over');DDM.activeDrop=this;DDM.otherDrops[this]=this;if(this.overTarget){DDM.activeDrag.fire('drag:over',{drop:this,drag:DDM.activeDrag});this.fire(EV_DROP_OVER,{drop:this,drag:DDM.activeDrag});}else{if(DDM.activeDrag.get('dragging')){this.overTarget=true;this.fire(EV_DROP_ENTER,{drop:this,drag:DDM.activeDrag});DDM.activeDrag.fire('drag:enter',{drop:this,drag:DDM.activeDrag});DDM.activeDrag.get(NODE).addClass(DDM.CSS_PREFIX+'-drag-over');}}}else{this._handleOut();}},_handleOverEvent:function(){this.shim.setStyle('zIndex','999');DDM._addActiveShim(this);},_handleOutEvent:function(){this.shim.setStyle('zIndex','1');DDM._removeActiveShim(this);},_handleOut:function(force){if(!DDM.isOverTarget(this)||force){if(this.overTarget){this.overTarget=false;if(!force){DDM._removeActiveShim(this);}
if(DDM.activeDrag){this.get(NODE).removeClass(DDM.CSS_PREFIX+'-drop-over');DDM.activeDrag.get(NODE).removeClass(DDM.CSS_PREFIX+'-drag-over');this.fire(EV_DROP_EXIT);DDM.activeDrag.fire('drag:exit',{drop:this});delete DDM.otherDrops[this];}}}}});Y.DD.Drop=Drop;},'3.3.0',{requires:['dd-ddm-drop','dd-drag'],skinnable:false});YUI.add('dd-delegate',function(Y){var Delegate=function(o){Delegate.superclass.constructor.apply(this,arguments);},CONT='container',NODES='nodes',_tmpNode=Y.Node.create('<div>Temp Node</div>');Y.extend(Delegate,Y.Base,{_bubbleTargets:Y.DD.DDM,dd:null,_shimState:null,_handles:null,_onNodeChange:function(e){this.set('dragNode',e.newVal);},_afterDragEnd:function(e){Y.DD.DDM._noShim=this._shimState;this.set('lastNode',this.dd.get('node'));this.get('lastNode').removeClass(Y.DD.DDM.CSS_PREFIX+'-dragging');this.dd._unprep();this.dd.set('node',_tmpNode);},_delMouseDown:function(e){var tar=e.currentTarget,dd=this.dd;if(tar.test(this.get(NODES))&&!tar.test(this.get('invalid'))){this._shimState=Y.DD.DDM._noShim;Y.DD.DDM._noShim=true;this.set('currentNode',tar);dd.set('node',tar);if(dd.proxy){dd.set('dragNode',Y.DD.DDM._proxy);}else{dd.set('dragNode',tar);}
dd._prep();dd.fire('drag:mouseDown',{ev:e});}},_onMouseEnter:function(e){this._shimState=Y.DD.DDM._noShim;Y.DD.DDM._noShim=true;},_onMouseLeave:function(e){Y.DD.DDM._noShim=this._shimState;},initializer:function(cfg){this._handles=[];var conf=Y.clone(this.get('dragConfig')||{}),cont=this.get(CONT);conf.node=_tmpNode.cloneNode(true);conf.bubbleTargets=this;if(this.get('handles')){conf.handles=this.get('handles');}
this.dd=new Y.DD.Drag(conf);this.dd.after('drag:end',Y.bind(this._afterDragEnd,this));this.dd.on('dragNodeChange',Y.bind(this._onNodeChange,this));this.dd.after('drag:mouseup',function(){this._unprep();});this._handles.push(Y.delegate(Y.DD.Drag.START_EVENT,Y.bind(this._delMouseDown,this),cont,this.get(NODES)));this._handles.push(Y.on('mouseenter',Y.bind(this._onMouseEnter,this),cont));this._handles.push(Y.on('mouseleave',Y.bind(this._onMouseLeave,this),cont));Y.later(50,this,this.syncTargets);Y.DD.DDM.regDelegate(this);},syncTargets:function(){if(!Y.Plugin.Drop||this.get('destroyed')){return;}
var items,groups,config;if(this.get('target')){items=Y.one(this.get(CONT)).all(this.get(NODES));groups=this.dd.get('groups');config=this.get('dragConfig');if(config&&'groups'in config){groups=config.groups;}
items.each(function(i){this.createDrop(i,groups);},this);}
return this;},createDrop:function(node,groups){var config={useShim:false,bubbleTargets:this};if(!node.drop){node.plug(Y.Plugin.Drop,config);}
node.drop.set('groups',groups);return node;},destructor:function(){if(this.dd){this.dd.destroy();}
if(Y.Plugin.Drop){var targets=Y.one(this.get(CONT)).all(this.get(NODES));targets.unplug(Y.Plugin.Drop);}
Y.each(this._handles,function(v){v.detach();});}},{NAME:'delegate',ATTRS:{container:{value:'body'},nodes:{value:'.dd-draggable'},invalid:{value:'input, select, button, a, textarea'},lastNode:{value:_tmpNode},currentNode:{value:_tmpNode},dragNode:{value:_tmpNode},over:{value:false},target:{value:false},dragConfig:{value:null},handles:{value:null}}});Y.mix(Y.DD.DDM,{_delegates:[],regDelegate:function(del){this._delegates.push(del);},getDelegate:function(node){var del=null;node=Y.one(node);Y.each(this._delegates,function(v){if(node.test(v.get(CONT))){del=v;}},this);return del;}});Y.namespace('DD');Y.DD.Delegate=Delegate;},'3.3.0',{requires:['dd-drag','event-mouseenter'],skinnable:false,optional:['dd-drop-plugin']});YUI.add('dd',function(Y){},'3.3.0',{skinnable:false,use:['dd-ddm-base','dd-ddm','dd-ddm-drop','dd-drag','dd-proxy','dd-constrain','dd-drop','dd-scroll','dd-delegate']});