
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `subrion421`
--

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]acl_objects`
--

CREATE TABLE `[[dbprefix]]acl_objects` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `pre_object` char(40) NOT NULL,
  `object` char(30) NOT NULL,
  `action` char(15) NOT NULL DEFAULT 'read',
  `access` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `module` char(40) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=54 ;

--
-- Dumping data for table `[[dbprefix]]acl_objects`
--

INSERT INTO `[[dbprefix]]acl_objects` VALUES
(1, 'admin_access', 'admin_access', 'read', 0, ''),
(2, 'admin_page', 'blocks', 'smarty', 1, ''),
(3, 'admin_page', 'blocks', 'plain', 1, ''),
(4, 'admin_page', 'blocks', 'php', 1, ''),
(5, 'admin_page', 'blocks', 'html', 1, ''),
(6, 'admin_page', 'blocks', 'edit', 1, ''),
(7, 'admin_page', 'blocks', 'visual', 0, ''),
(8, 'admin_page', 'blocks', 'order', 0, ''),
(9, 'admin_page', 'configuration', 'edit', 0, ''),
(10, 'admin_page', 'currencies', 'add', 1, ''),
(11, 'admin_page', 'currencies', 'edit', 1, ''),
(12, 'admin_page', 'currencies', 'delete', 1, ''),
(13, 'admin_page', 'database', 'sql', 1, ''),
(14, 'admin_page', 'database', 'export', 0, ''),
(15, 'admin_page', 'database', 'import', 0, ''),
(16, 'admin_page', 'database', 'consistency', 1, ''),
(17, 'admin_page', 'database', 'reset', 1, ''),
(18, 'admin_page', 'fields', 'members', 0, ''),
(19, 'admin_page', 'index', 'cache', 1, ''),
(20, 'admin_page', 'index', 'debugmode', 0, ''),
(21, 'admin_page', 'index', 'phpinfo', 0, ''),
(22, 'admin_page', 'index', 'sitemap', 1, ''),
(23, 'admin_page', 'members', 'add', 1, ''),
(24, 'admin_page', 'members', 'edit', 0, ''),
(25, 'admin_page', 'members', 'password', 0, ''),
(26, 'admin_page', 'members', 'usergroup', 0, ''),
(27, 'admin_page', 'menus', 'add', 1, ''),
(28, 'admin_page', 'menus', 'edit', 1, ''),
(29, 'admin_page', 'packages', 'activate', 0, ''),
(30, 'admin_page', 'packages', 'set_default', 0, ''),
(31, 'admin_page', 'packages', 'uninstall', 0, ''),
(32, 'admin_page', 'packages', 'install', 0, ''),
(33, 'admin_page', 'packages', 'upgrade', 0, ''),
(34, 'admin_page', 'pages', 'add', 1, ''),
(35, 'admin_page', 'pages', 'edit', 1, ''),
(36, 'admin_page', 'pages', 'home', 0, ''),
(37, 'admin_page', 'permissions', 'read', 0, ''),
(38, 'admin_page', 'permissions', 'edit', 0, ''),
(39, 'admin_page', 'plans', 'add', 1, ''),
(40, 'admin_page', 'plans', 'edit', 1, ''),
(41, 'admin_page', 'plans', 'delete', 1, ''),
(42, 'admin_page', 'plugins', 'install', 1, ''),
(43, 'admin_page', 'plugins', 'uninstall', 0, ''),
(44, 'admin_page', 'plugins', 'reinstall', 0, ''),
(45, 'admin_page', 'plugins', 'update', 0, ''),
(46, 'admin_page', 'blog', 'read', 1, 'blog'),
(47, 'admin_page', 'blog', 'add', 1, 'blog'),
(48, 'admin_page', 'blog', 'edit', 1, 'blog'),
(49, 'admin_page', 'blog', 'delete', 1, 'blog'),
(50, 'page', 'blog', 'read', 1, 'blog'),
(51, 'page', 'blog', 'add', 1, 'blog'),
(52, 'page', 'blog', 'edit', 1, 'blog'),
(53, 'page', 'blog', 'delete', 1, 'blog');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]acl_privileges`
--

CREATE TABLE `[[dbprefix]]acl_privileges` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type` enum('user','group','plan') NOT NULL DEFAULT 'group',
  `type_id` mediumint(8) unsigned NOT NULL,
  `access` tinyint(1) unsigned NOT NULL,
  `action` varchar(15) NOT NULL DEFAULT 'read',
  `object` varchar(50) NOT NULL,
  `object_id` varchar(150) NOT NULL DEFAULT '0',
  `module` varchar(40) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQUE` (`type`,`type_id`,`action`,`object`,`object_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=5 ;

--
-- Dumping data for table `[[dbprefix]]acl_privileges`
--

INSERT INTO `[[dbprefix]]acl_privileges` VALUES
(1, 'group', 2, 1, 'read', 'admin_access', '0', ''),
(2, 'group', 4, 0, 'read', 'page', 'member_funds', ''),
(3, 'group', 4, 0, 'read', 'page', 'profile', ''),
(4, 'group', 8, 1, 'read', 'page', 'profile', '');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]admin_actions`
--

CREATE TABLE `[[dbprefix]]admin_actions` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(64) NOT NULL,
  `url` varchar(100) NOT NULL,
  `icon` varchar(50) DEFAULT NULL,
  `attributes` tinytext NOT NULL,
  `module` varchar(40) NOT NULL,
  `pages` tinytext NOT NULL,
  `text` varchar(50) DEFAULT NULL,
  `type` enum('regular','dashboard') DEFAULT 'regular',
  `order` smallint(5) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `TYPE` (`type`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=43 ;

--
-- Dumping data for table `[[dbprefix]]admin_actions`
--

INSERT INTO `[[dbprefix]]admin_actions` VALUES
(1, 'members', 'members/', 'list', '', '', 'members:add,members:edit,usergroups:read', '', 'regular', 1),
(2, 'add_member', 'members/add/', 'user', '', '', 'members:read,members:edit,usergroups', '', 'regular', 2),
(3, 'usergroups', 'usergroups/', 'grid', '', '', 'members,usergroups:add', '', 'regular', 3),
(4, 'add_usergroup', 'usergroups/add/', 'users', '', '', 'usergroups:read', '', 'regular', 4),
(5, 'fields', 'fields/members/', 'signup', '', '', 'members,usergroups', '', 'regular', 5),
(6, 'delete', 'javascript:;', 'remove', 'id="js-delete-block"', '', 'blocks:edit', '', 'regular', 1),
(7, 'blocks', 'blocks/', 'grid', '', '', 'blocks:add,blocks:edit', '', 'regular', 2),
(8, 'add_block', 'blocks/create/', 'plus-alt', '', '', 'blocks', '', 'regular', 3),
(9, 'sql_management', 'database/sql/', 'database', '', '', 'database', '', 'regular', 1),
(10, 'reset', 'database/reset/', 'loop', '', '', 'database', '', 'regular', 2),
(11, 'consistency', 'database/consistency/', 'spinner', '', '', 'database', '', 'regular', 3),
(12, 'export', 'database/export/', 'box-remove', '', '', 'database', '', 'regular', 5),
(13, 'import', 'database/import/', 'box-add', '', '', 'database', '', 'regular', 6),
(14, 'fields', 'fields/', 'list', '', '', 'fields:edit,member_fields', '', 'regular', 1),
(15, 'add_field', 'fields/add/', 'plus-alt', '', '', 'fields,member_fields', '', 'regular', 2),
(16, 'field_groups', 'fieldgroups/', 'list-2', '', '', 'fieldgroups,member_fields', '', 'regular', 3),
(17, 'add_fieldgroup', 'fieldgroups/add/', 'folder-plus', '', '', 'fieldgroups,member_fields', '', 'regular', 4),
(18, 'image_types', 'image-types/', 'list', '', '', 'imagetypes:edit', '', 'regular', 1),
(19, 'add_image_type', 'image-types/add/', 'plus-alt', '', '', 'imagetypes', '', 'regular', 2),
(20, 'add_invoice', 'invoices/add/', 'plus-alt', '', '', 'invoices,invoices:edit', '', 'regular', 1),
(21, 'languages', 'languages/', 'list', '', '', 'languages', '', 'regular', 1),
(22, 'new_language', 'languages/add/', 'copy', '', '', 'languages', '', 'regular', 2),
(23, 'download', 'languages/download/', 'box-remove', '', '', 'languages', '', 'regular', 3),
(24, 'add_phrase', 'phrases/add/', 'plus-alt', '', '', 'languages,phrases', '', 'regular', 4),
(25, 'languages_comparison', 'languages/comparison/', 'link-2', '', '', 'languages', '', 'regular', 5),
(26, 'menus', 'menus/', 'list', '', '', 'menus:add,menus:edit', '', 'regular', 3),
(27, 'add_menu', 'menus/add/', 'plus-alt', '', '', 'menus', '', 'regular', 4),
(28, 'delete', 'javascript:;', 'remove', 'id="js-delete-page"', '', 'pages:edit', '', 'regular', 1),
(29, 'pages', 'pages/', 'list', '', '', 'pages:add,pages:edit', '', 'regular', 2),
(30, 'add_page', 'pages/add/', 'plus-alt', '', '', 'pages', '', 'regular', 3),
(31, 'plans', 'plans/', 'list', '', '', 'plans:add,plans:edit', '', 'regular', 3),
(32, 'add_plan', 'plans/add/', 'plus-alt', '', '', 'plans', '', 'regular', 4),
(33, 'print_invoice', 'invoices/printable/:id/', 'file', 'target="_blank"', '', 'invoices:edit', '', 'regular', 2),
(34, 'add_transaction', 'javascript:;', 'plus', 'id="js-add-transaction-cmd"', '', 'transactions', '', 'regular', 1),
(35, 'tags', 'javascript:;', 'eye', 'id="js-view-tags"', '', 'email_templates', '', 'regular', 1),
(36, 'add_currency', 'currencies/add/', 'plus-alt', '', '', 'currencies', '', 'regular', 3),
(37, 'list_currencies', 'currencies/', 'list', '', '', 'currencies:add,currencies:edit', '', 'regular', 3),
(38, 'blocks', 'blocks/', 'grid', '', '', '', '', 'dashboard', 0),
(39, 'add_page', 'pages/add/', 'copy', '', '', '', '', 'dashboard', 0),
(40, 'blogposts', 'blog/', 'list', '', 'blog', 'blog:add,blog:edit', '', 'regular', 7),
(41, 'add_blog_entry', 'blog/add/', 'plus', '', 'blog', 'blog:read,blog:edit', '', 'regular', 8),
(42, 'dashboard_blogpost_add', 'blog/add/', 'quill', '', 'blog', '', '', 'dashboard', 9);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]admin_pages`
--

CREATE TABLE `[[dbprefix]]admin_pages` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `group` smallint(4) unsigned NOT NULL,
  `name` varchar(50) NOT NULL,
  `order` smallint(5) unsigned NOT NULL,
  `alias` varchar(150) NOT NULL,
  `module` varchar(40) NOT NULL,
  `filename` varchar(50) NOT NULL,
  `attr` varchar(150) DEFAULT NULL,
  `menus` set('menu','header') NOT NULL DEFAULT 'menu',
  `status` enum('active','inactive') NOT NULL DEFAULT 'active',
  `readonly` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `action` char(15) NOT NULL DEFAULT 'read',
  `parent` varchar(50) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `NAME` (`name`),
  KEY `ALIAS` (`alias`),
  KEY `GROUP` (`group`),
  KEY `MENUS` (`menus`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=46 ;

--
-- Dumping data for table `[[dbprefix]]admin_pages`
--

INSERT INTO `[[dbprefix]]admin_pages` VALUES
(1, 0, 'index', 0, '', '', 'index', NULL, 'menu', 'active', 0, 'read', ''),
(2, 0, 'actions', 0, 'actions/', '', 'actions', NULL, '', 'active', 1, 'read', ''),
(3, 0, '', 20, '', '', '', NULL, 'header', 'active', 0, '', ''),
(4, 0, 'adminer', 25, 'adminer/', '', 'adminer', NULL, 'header', 'active', 0, 'read', ''),
(5, 0, '', 30, '', '', '', NULL, 'header', 'active', 0, '', ''),
(6, 0, 'visual_mode', 0, 'visual-mode/', '', 'visual', 'target="_blank"', '', 'active', 1, 'visual', 'blocks'),
(7, 1, '', 0, '', '', '', 'sys_mgmt', 'menu', 'active', 0, '', ''),
(8, 1, 'configuration', 5, 'configuration/', '', 'configuration', NULL, 'header', 'active', 0, 'read', ''),
(9, 1, 'database', 10, 'database/', '', 'database', NULL, 'menu,header', 'active', 0, 'read', ''),
(10, 1, 'languages', 15, 'languages/', '', 'languages', NULL, 'menu', 'active', 0, 'read', ''),
(11, 1, 'hooks', 20, 'hooks/', '', 'hooks', NULL, 'menu', 'active', 0, 'read', ''),
(12, 1, 'scheduled_tasks', 22, 'scheduled-tasks/', '', 'scheduled-tasks', NULL, 'menu', 'active', 0, 'read', ''),
(13, 1, '', 25, '', '', '', 'sys_email', 'menu', 'active', 0, '', ''),
(14, 1, 'email_templates', 30, 'email-templates/', '', 'email-templates', NULL, 'menu', 'active', 0, 'read', ''),
(15, 1, '', 35, '', '', '', 'sys_extra', 'menu', 'active', 0, '', ''),
(16, 1, 'clear_cache', 37, 'clear/cache/', '', 'index', NULL, 'menu,header', 'active', 0, 'cache', 'index'),
(17, 1, 'phpinfo', 40, 'phpinfo/', '', 'index', NULL, 'menu,header', 'active', 0, 'phpinfo', 'index'),
(18, 1, 'debugmode', 41, 'debug-mode/', '', 'index', NULL, '', 'active', 0, 'debugmode', 'index'),
(19, 1, 'sitemap', 45, 'sitemap/', '', 'index', NULL, 'menu,header', 'active', 0, 'sitemap', 'index'),
(20, 2, 'pages', 5, 'pages/', '', 'pages', NULL, 'menu', 'active', 0, 'read', ''),
(21, 2, 'menus', 10, 'menus/', '', 'menus', NULL, 'menu', 'active', 0, 'read', ''),
(22, 2, 'blocks', 15, 'blocks/', '', 'blocks', NULL, 'menu', 'active', 0, 'read', ''),
(23, 2, 'phrases', 20, 'phrases/', '', 'phrases', NULL, 'menu', 'active', 0, 'read', ''),
(24, 2, 'uploads', 23, 'uploads/', '', 'uploads', NULL, 'menu', 'active', 0, 'read', ''),
(25, 2, '', 25, '', '', '', 'ctnt_ext', 'menu', 'active', 0, '', ''),
(26, 2, 'fieldgroups', 30, 'fieldgroups/', '', 'fieldgroups', NULL, 'menu', 'active', 0, 'read', ''),
(27, 2, 'fields', 35, 'fields/', '', 'fields', NULL, 'menu', 'active', 0, 'read', ''),
(28, 2, 'imagetypes', 40, 'image-types/', '', 'image-types', NULL, 'menu', 'active', 0, 'read', ''),
(29, 2, '', 45, '', '', '', 'ctnt_xtns', 'menu', 'active', 0, '', ''),
(30, 3, 'members', 5, 'members/', '', 'members', NULL, 'menu', 'active', 0, 'read', ''),
(31, 3, 'usergroups', 10, 'usergroups/', '', 'usergroups', NULL, 'menu,header', 'active', 0, 'read', ''),
(32, 3, '', 15, '', '', '', 'mbr_ext', 'menu', 'active', 0, '', ''),
(33, 3, 'permissions', 20, 'permissions/', '', 'permissions', NULL, 'menu', 'active', 0, 'read', ''),
(34, 3, 'member_fields', 25, 'fields/members/', '', 'fields', NULL, 'menu', 'active', 0, 'member', 'fields'),
(35, 4, 'currencies', 0, 'currencies/', '', 'currencies', NULL, 'menu', 'active', 0, 'read', ''),
(36, 4, '', 5, '', '', '', 'fin_mgmt', 'menu', 'active', 0, '', ''),
(37, 4, 'plans', 10, 'plans/', '', 'plans', NULL, 'menu', 'active', 0, 'read', ''),
(38, 4, 'subscriptions', 15, 'subscriptions/', '', 'subscriptions', NULL, 'menu', 'active', 0, 'read', ''),
(39, 4, 'transactions', 20, 'transactions/', '', 'transactions', NULL, 'menu', 'active', 0, 'read', ''),
(40, 4, 'invoices', 25, 'invoices/', '', 'invoices', NULL, 'menu', 'active', 0, 'read', ''),
(41, 5, 'templates', 5, 'modules/templates/', '', 'modules', NULL, 'menu', 'active', 0, 'read', ''),
(42, 5, 'plugins', 10, 'modules/plugins/', '', 'modules', NULL, 'menu', 'active', 0, 'read', ''),
(43, 5, 'packages', 15, 'modules/packages/', '', 'modules', NULL, 'menu', 'active', 0, 'read', ''),
(44, 5, '', 20, '', '', '', 'xtns_empt', 'menu', 'active', 0, '', ''),
(45, 2, 'blog', 50, 'blog/', 'blog', '', NULL, 'menu', 'active', 0, 'read', '');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]admin_pages_groups`
--

CREATE TABLE `[[dbprefix]]admin_pages_groups` (
  `id` smallint(4) unsigned NOT NULL AUTO_INCREMENT,
  `order` smallint(4) unsigned NOT NULL,
  `name` varchar(50) NOT NULL,
  `module` varchar(40) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=6 ;

--
-- Dumping data for table `[[dbprefix]]admin_pages_groups`
--

INSERT INTO `[[dbprefix]]admin_pages_groups` VALUES
(1, 0, 'system', ''),
(2, 0, 'content', ''),
(3, 0, 'members', ''),
(4, 0, 'financial', ''),
(5, 0, 'extensions', '');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]api_tokens`
--

CREATE TABLE `[[dbprefix]]api_tokens` (
  `key` char(32) NOT NULL,
  `member_id` int(11) unsigned DEFAULT NULL,
  `expires` datetime NOT NULL,
  `ip` bigint(12) NOT NULL,
  `session` char(32) NOT NULL,
  PRIMARY KEY (`key`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]blocks`
--

CREATE TABLE `[[dbprefix]]blocks` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `contents` text,
  `order` smallint(5) unsigned NOT NULL,
  `position` varchar(30) NOT NULL DEFAULT 'left',
  `type` enum('plain','smarty','php','html','menu') NOT NULL DEFAULT 'plain',
  `module` varchar(40) NOT NULL,
  `status` enum('active','inactive') NOT NULL DEFAULT 'active',
  `header` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `collapsible` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `collapsed` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `sticky` tinyint(1) unsigned NOT NULL,
  `rss` tinytext NOT NULL,
  `tpl` varchar(64) NOT NULL DEFAULT '',
  `external` tinyint(1) NOT NULL DEFAULT '0',
  `filename` text,
  `removable` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `subpages` text,
  `classname` varchar(50) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQUE` (`name`,`module`),
  KEY `STATUS` (`status`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=22 ;

--
-- Dumping data for table `[[dbprefix]]blocks`
--

INSERT INTO `[[dbprefix]]blocks` VALUES
(2, 'inventory', '', 0, 'inventory', 'menu', '', 'active', 0, 0, 0, 1, '', 'render-menu.tpl', 0, '', 0, '', ''),
(3, 'main', '', 0, 'mainmenu', 'menu', '', 'active', 0, 0, 0, 1, '', 'render-menu.tpl', 0, '', 0, '', ''),
(4, 'account', '', 0, 'account', 'menu', '', 'active', 0, 0, 0, 1, '', 'render-menu.tpl', 0, '', 0, '', ''),
(5, 'bottom', '', 0, 'copyright', 'menu', '', 'active', 0, 0, 0, 1, '', 'render-menu.tpl', 0, '', 0, '', ''),
(6, 'common_statistics', '', 1, 'right', 'smarty', '', 'active', 1, 0, 0, 0, '', '', 1, 'block.common-statistics.tpl', 0, '', 'box--border'),
(7, 'filters', '$iaView = &$iaCore->iaView;\r\n\r\nif (($itemName = $iaView->get(''filtersItemName''))\r\n	|| (($itemName = str_replace(''search_'', '''', $iaView->name())) && $itemName != $iaView->name()))\r\n{\r\n	$iaView->iaSmarty->assign(''filters'', $iaCore->factory(''search'', iaCore::FRONT)->getFilters($itemName));\r\n\r\n	echo $iaView->iaSmarty->fetch(''block.filters.tpl'');\r\n}', 1, 'left', 'php', '', 'active', 1, 1, 0, 1, '', '', 0, '', 1, '', 'box--border'),
(8, 'header', NULL, 2, 'teaser', 'html', 'kickstart', 'active', 0, 0, 0, 0, '', '', 0, '', 1, NULL, ''),
(9, 'landing_what_is_this', '<div class="row text-center m-t-md">\n    <div class="col-md-4">\n        <img src="{$img}browser.png" width="64" alt=""/>\n        <h4 class="m-t">Landing page</h4>\n        <p class="text-fade-75">This is a starting page for your website. You can change it (switch off) to display content and blocks. This can be done on Template configuration page.</p>\n    </div>\n    <div class="col-md-4">\n        <img src="{$img}computer.png" width="64" alt=""/>\n        <h4 class="m-t">Configuration options</h4>\n        <p class="text-fade-75"><b>Kickstart</b> template has many configuration options to play with. Go to admin panel and try to change, for example, background of header block.</p>\n    </div>\n    <div class="col-md-4">\n        <img src="{$img}computer2.png" width="64" alt=""/>\n        <h4 class="m-t">Blocks management</h4>\n        <p class="text-fade-75">Each section on this page can be changed in Admin Dashboard in Blocks section, as well as all other blocks on all pages. Go give it a try!</p>\n    </div>\n</div>\n<div class="text-center m-t-lg">\n    <a class="btn btn-primary text-uppercase" href="{$smarty.const.IA_ADMIN_URL}">Go to admin dashboard</a>\n</div>', 200, 'landing', 'smarty', 'kickstart', 'active', 1, 0, 0, 0, '', '', 0, '', 1, NULL, 'section section-what'),
(10, 'landing_features', NULL, 201, 'landing', 'html', 'kickstart', 'active', 1, 0, 0, 0, '', '', 0, '', 1, NULL, 'section section-features'),
(11, 'landing_mobile', '<div class="row">\n    <div class="col-md-6 col-md-offset-2">\n        <div class="section-mobile__text">\n            <h2>{$block.title}</h2>\n            <p class="lead">Lorem ipsum dolor sit amet, consectetur adipisicing elit. Fuga ipsa distinctio vel aspernatur, reiciendis excepturi.</p>\n            <p>Lorem ipsum dolor sit amet, consectetur adipisicing elit. At animi corporis laboriosam. Maiores voluptatibus dicta ea, quo repellendus eum officiis enim non? Porro aut harum pariatur sit adipisci accusantium rem!\n            </p>\n        </div>\n    </div>\n</div>', 202, 'landing', 'smarty', 'kickstart', 'active', 0, 0, 0, 0, '', '', 0, '', 1, NULL, 'section section-mobile'),
(12, 'top', NULL, 203, 'top', 'html', 'kickstart', 'active', 1, 1, 0, 0, '', '', 0, '', 1, NULL, ''),
(13, 'bottom_block', NULL, 204, 'bottom', 'html', 'kickstart', 'active', 1, 1, 0, 0, '', '', 0, '', 1, NULL, ''),
(14, 'html_block1', NULL, 99, 'left', 'html', 'kickstart', 'active', 1, 1, 0, 1, '', '', 0, '', 1, NULL, 'box--border'),
(15, 'footer1', NULL, 205, 'footer1', 'html', 'kickstart', 'active', 1, 0, 0, 1, '', '', 0, '', 1, NULL, ''),
(16, 'footer2', NULL, 206, 'footer2', 'html', 'kickstart', 'active', 1, 0, 0, 1, '', '', 0, '', 1, NULL, ''),
(17, 'footer3', NULL, 207, 'footer3', 'html', 'kickstart', 'active', 1, 0, 0, 1, '', '', 0, '', 1, NULL, ''),
(18, 'footer4', NULL, 208, 'footer4', 'html', 'kickstart', 'active', 1, 0, 0, 1, '', '', 0, '', 1, NULL, ''),
(19, 'blogroll', '', 1, 'verybottom', 'smarty', 'blog', 'active', 1, 0, 0, 0, '', '', 1, 'module:blog/block.blogroll.tpl', 1, NULL, ''),
(20, 'new_blog_posts', '', 5, 'left', 'smarty', 'blog', 'active', 1, 0, 0, 1, '', '', 1, 'module:blog/block.new-posts.tpl', 1, NULL, ''),
(21, 'blogs_archive', '', 5, 'left', 'smarty', 'blog', 'active', 1, 0, 0, 1, '', '', 1, 'module:blog/block.blogs-archive.tpl', 1, NULL, '');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]blog_entries`
--

CREATE TABLE `[[dbprefix]]blog_entries` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `member_id` int(11) unsigned NOT NULL,
  `title` tinytext NOT NULL,
  `alias` varchar(155) NOT NULL,
  `body` text NOT NULL,
  `date_added` datetime NOT NULL,
  `image` tinytext NOT NULL,
  `status` enum('inactive','active') NOT NULL DEFAULT 'inactive',
  `lang` char(2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `LANGUAGE` (`lang`),
  FULLTEXT KEY `SEARCH` (`title`,`body`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]blog_entries_tags`
--

CREATE TABLE `[[dbprefix]]blog_entries_tags` (
  `blog_id` mediumint(8) unsigned NOT NULL,
  `tag_id` mediumint(8) unsigned NOT NULL,
  UNIQUE KEY `UNIQUE` (`tag_id`,`blog_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]blog_tags`
--

CREATE TABLE `[[dbprefix]]blog_tags` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(50) NOT NULL,
  `alias` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]config`
--

CREATE TABLE `[[dbprefix]]config` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `config_group` varchar(50) NOT NULL,
  `name` varchar(64) NOT NULL,
  `value` text,
  `multiple_values` text,
  `type` enum('text','textarea','checkbox','radio','select','combo','divider','hidden','password','image','itemscheckbox','tpl','colorpicker') NOT NULL DEFAULT 'text',
  `order` smallint(5) unsigned NOT NULL,
  `module` varchar(40) NOT NULL,
  `private` tinyint(1) unsigned NOT NULL,
  `custom` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `options` text,
  PRIMARY KEY (`id`),
  KEY `TYPE` (`type`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=187 ;

--
-- Dumping data for table `[[dbprefix]]config`
--

INSERT INTO `[[dbprefix]]config` VALUES
(1, '', 'debug_pass', '', NULL, 'hidden', 0, '', 1, 0, NULL),
(2, '', 'tmpl', 'kickstart', NULL, 'hidden', 0, '', 0, 0, NULL),
(3, '', 'backup', 'backup/', NULL, 'hidden', 0, '', 1, 0, NULL),
(4, '', 'version', '4.2.1', NULL, 'hidden', 0, '', 1, 0, NULL),
(5, '', 'cron', '1', NULL, 'hidden', 0, '', 1, 0, NULL),
(6, '', 'admin_tmpl', 'default', NULL, 'hidden', 0, '', 1, 0, NULL),
(7, '', 'default_package', '', NULL, 'hidden', 0, '', 1, 0, NULL),
(8, '', 'home_page', 'index', NULL, 'hidden', 0, '', 1, 0, NULL),
(9, '', 'tmpl_rollback_data', '', NULL, 'hidden', 0, '', 1, 0, NULL),
(10, '', 'tmpl_layout_data', 'a:2:{s:7:"content";a:3:{s:4:"left";a:2:{s:5:"width";i:3;s:5:"fixed";b:1;}s:6:"center";a:2:{s:5:"width";i:6;s:5:"fixed";b:0;}s:5:"right";a:2:{s:5:"width";i:3;s:5:"fixed";b:1;}}s:13:"footer-blocks";a:4:{s:7:"footer1";a:2:{s:5:"width";i:3;s:5:"fixed";b:0;}s:7:"footer2";a:2:{s:5:"width";i:3;s:5:"fixed";b:0;}s:7:"footer3";a:2:{s:5:"width";i:3;s:5:"fixed";b:0;}s:7:"footer4";a:2:{s:5:"width";i:3;s:5:"fixed";b:0;}}}', NULL, 'hidden', 0, '', 1, 0, NULL),
(11, 'general', '', 'General', '1', 'divider', 0, '', 1, 1, ''),
(12, 'general', 'site', '{"en":"Subrion CMS"}', '1', 'text', 2, '', 0, 1, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":1}'),
(13, 'general', 'bc_home', '{"en":"Home"}', NULL, 'text', 3, '', 1, 1, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":1}'),
(14, 'general', 'suffix', '{"en":":: Powered by Subrion 4.2"}', '1', 'text', 9, '', 0, 1, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":1}'),
(15, 'general', 'site_logo', '', '', 'image', 12, '', 0, 0, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
(16, 'general', 'site_favicon', '', '', 'image', 13, '', 0, 0, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
(17, 'general', '', 'Regional', '1', 'divider', 20, '', 1, 1, ''),
(18, 'general', 'lang', 'en', '1', 'select', 33, '', 0, 1, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
(19, 'general', 'language_switch', '1', '''1'',''0''', 'radio', 36, '', 0, 1, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
(20, 'general', 'timezone', 'America/New_York', '', 'select', 45, '', 0, 0, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
(21, 'members', '', 'General', '1', 'divider', 1, '', 1, 0, ''),
(22, 'members', 'members_enabled', '1', '''1'',''0''', 'radio', 2, '', 1, 0, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
(23, 'members', 'members_autoapproval', '1', '''1'',''0''', 'radio', 3, '', 0, 0, '{"wysiwyg":0,"code_editor":0,"show":"members_enabled|1","multilingual":0}'),
(24, 'members', 'members_per_page', '20', '0', 'text', 4, '', 1, 0, '{"wysiwyg":0,"code_editor":0,"show":"members_enabled|1","multilingual":0}'),
(25, 'members', '', 'HybridAuth', '1', 'divider', 5, '', 1, 0, ''),
(26, 'members', 'hybrid_enabled', '0', '''1'',''0''', 'radio', 6, '', 1, 0, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
(27, 'members', 'hybrid_debug_mode', '0', '''1'',''0''', 'radio', 7, '', 1, 0, '{"wysiwyg":0,"code_editor":0,"show":"hybrid_enabled|1","multilingual":0}'),
(28, 'members', '', 'Gravatar', '1', 'divider', 10, '', 1, 0, ''),
(29, 'members', 'gravatar_enabled', '1', '''1'',''0''', 'radio', 11, '', 1, 0, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
(30, 'members', 'gravatar_size', '100', '1', 'text', 12, '', 1, 0, '{"wysiwyg":0,"code_editor":0,"show":"gravatar_enabled|1","multilingual":0}'),
(31, 'members', 'gravatar_type', 'mm', '''mm'',''identicon'',''monsterid'',''wavatar'',''retro''', 'select', 13, '', 1, 0, '{"wysiwyg":0,"code_editor":0,"show":"gravatar_enabled|1","multilingual":0}'),
(32, 'members', 'gravatar_rating', 'g', '''g'',''pg'',''r'',''x''', 'select', 14, '', 1, 0, '{"wysiwyg":0,"code_editor":0,"show":"gravatar_enabled|1","multilingual":0}'),
(33, 'members', 'gravatar_default_image', '', '', 'image', 16, '', 0, 0, '{"wysiwyg":0,"code_editor":0,"show":"gravatar_enabled|1","multilingual":0}'),
(34, 'mail', '', 'General', '1', 'divider', 1, '', 1, 0, ''),
(35, 'mail', 'site_from_name', '{"en":"Subrion CMS"}', '1', 'text', 5, '', 1, 0, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":1}'),
(36, 'mail', 'site_email', '[[admin_email]]', '1', 'text', 8, '', 1, 0, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
(37, 'mail', 'bcc_email', '', '1', 'text', 10, '', 1, 0, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
(38, 'mail', 'default_email_signature', '{"en":"<p>______________________________</p>\\r\\n<p>Thank you,<br>\\r\\n{%SITE_NAME%} Team<br>\\r\\n{%SITE_URL%}</p>","ru":"<p>______________________________</p>\\r\\n<p>Thank you,<br>\\r\\n{%SITE_NAME%} Team<br>\\r\\n{%SITE_URL%}</p>","kg":"<p>______________________________</p>\\r\\n<p>Thank you,<br>\\r\\n{%SITE_NAME%} Team<br>\\r\\n{%SITE_URL%}</p>"}', '1', 'textarea', 15, '', 1, 0, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":1}'),
(39, 'mail', 'mail_function', 'php mail', '''php mail'',''sendmail'',''smtp''', 'select', 18, '', 1, 0, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
(40, 'mail', 'mail_test', '', 'admin/templates/default/configuration-test-email-btn.tpl', 'tpl', 21, '', 1, 0, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
(41, 'mail', '', 'SMTP Settings', '', 'divider', 24, '', 9, 0, '{"wysiwyg":0,"code_editor":0,"show":"mail_function|smtp","multilingual":0}'),
(42, 'mail', 'smtp_debug', '0', '''1'',''0''', 'radio', 25, '', 1, 0, '{"wysiwyg":0,"code_editor":0,"show":"mail_function|smtp","multilingual":0}'),
(43, 'mail', 'smtp_debug_output', 'echo', '''echo'',''html'',''error_log''', 'select', 26, '', 1, 0, '{"wysiwyg":0,"code_editor":0,"show":"smtp_debug|1","multilingual":0}'),
(44, 'mail', 'smtp_auth', '1', '''1'',''0''', 'radio', 27, '', 1, 0, '{"wysiwyg":0,"code_editor":0,"show":"mail_function|smtp","multilingual":0}'),
(45, 'mail', 'smtp_server', 'smtp.example.org', '', 'text', 30, '', 1, 0, '{"wysiwyg":0,"code_editor":0,"show":"mail_function|smtp","multilingual":0}'),
(46, 'mail', 'smtp_port', '', '', 'text', 33, '', 1, 0, '{"wysiwyg":0,"code_editor":0,"show":"mail_function|smtp","multilingual":0}'),
(47, 'mail', 'smtp_secure', 'TLS', '''TLS'',''SSL''', 'select', 36, '', 1, 0, '{"wysiwyg":0,"code_editor":0,"show":"mail_function|smtp","multilingual":0}'),
(48, 'mail', 'smtp_user', '', '', 'text', 39, '', 1, 0, '{"wysiwyg":0,"code_editor":0,"show":"mail_function|smtp","multilingual":0}'),
(49, 'mail', 'smtp_password', '', '', 'password', 42, '', 1, 0, '{"wysiwyg":0,"code_editor":0,"show":"mail_function|smtp","multilingual":0}'),
(50, 'mail', '', 'Sendmail Settings', '', 'divider', 45, '', 1, 0, '{"wysiwyg":0,"code_editor":0,"show":"mail_function|sendmail","multilingual":0}'),
(51, 'mail', 'sendmail_path', '/usr/sbin/sendmail', '', 'text', 48, '', 1, 0, '{"wysiwyg":0,"code_editor":0,"show":"mail_function|sendmail","multilingual":0}'),
(52, 'mail', 'mimetype', '1', '''1'',''0''', 'radio', 51, '', 1, 0, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
(53, 'system', '', 'Setup', '1', 'divider', 0, '', 1, 0, ''),
(54, 'system', 'baseurl', '[[softurl]]/', NULL, 'text', 0, '', 0, 0, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
(55, 'system', 'admin_page', 'panel', NULL, 'text', 0, '', 1, 0, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
(56, 'system', 'https', '0', '''1'',''0''', 'radio', 1, '', 1, 1, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
(57, 'system', 'frontend', '1', '''1'',''0''', 'radio', 2, '', 1, 1, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
(58, 'system', 'underconstruction', 'We are sorry. Our site is under construction.', '', 'textarea', 3, '', 1, 1, '{"wysiwyg":1,"code_editor":0,"show":"frontend|0","multilingual":0}'),
(59, 'system', '', 'Admin Panel settings', '1', 'divider', 10, '', 1, 0, ''),
(60, 'system', 'display_feedbacks', '1', '''1'',''0''', 'radio', 11, '', 0, 0, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
(61, 'system', 'display_changelog', '1', '''1'',''0''', 'radio', 12, '', 0, 0, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
(62, 'system', 'display_twitter', '1', '''1'',''0''', 'hidden', 13, '', 0, 0, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
(63, 'system', 'check_for_updates', '1', '''1'',''0''', 'radio', 14, '', 0, 0, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
(64, 'system', 'auto_apply_critical_upgrades', '0', '''1'',''0''', 'radio', 15, '', 1, 0, '{"wysiwyg":0,"code_editor":0,"show":"check_for_updates|1","multilingual":0}'),
(65, 'system', 'allow_remote_templates', '1', '''1'',''0''', 'radio', 16, '', 0, 0, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
(66, 'system', 'sap_style', 'default', 'calmy,darkness,default,gebeus-waterfall,radiant-orchid,roseus', 'select', 17, '', 0, 1, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
(67, 'system', '', 'System configuration', '1', 'divider', 20, '', 1, 0, ''),
(68, 'system', 'alias_urlencode', '0', '''1'',''0''', 'radio', 21, '', 1, 0, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
(69, 'system', 'redirect_time', '4000', '', 'text', 22, '', 0, 0, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
(70, 'system', 'prevent_csrf', '1', '''1'',''0''', 'radio', 23, '', 1, 0, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
(71, 'system', 'caching', '0', '''1'',''0''', 'hidden', 24, '', 1, 0, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
(72, 'system', 'smarty_cache', '0', '''1'',''0''', 'radio', 25, '', 0, 0, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
(73, 'system', 'compress_html', '0', '''1'',''0''', 'radio', 26, '', 0, 0, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
(74, 'system', 'compress_js', '0', '''1'',''0''', 'radio', 27, '', 0, 0, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
(75, 'pictures', 'thumb_w', '150', '', 'hidden', 1, '', 1, 0, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
(76, 'pictures', 'thumb_h', '150', '', 'hidden', 2, '', 1, 0, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
(77, 'pictures', 'pictures_general', 'General', '', 'divider', 5, '', 1, 1, ''),
(78, 'pictures', 'image_quality', '75', '', 'text', 6, '', 1, 0, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
(79, 'pictures', 'allow_animated_gifs', '1', '''1'',''0''', 'radio', 7, '', 0, 0, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
(80, 'pictures', '', 'Watermark', '1', 'divider', 13, '', 1, 0, ''),
(81, 'pictures', 'watermark', '0', '''1'',''0''', 'radio', 14, '', 1, 0, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
(82, 'pictures', 'watermark_position', 'bottom_right', '''top_left'',''top_center'',''top_right'',''middle_left'',''middle_center'',''middle_right'',''bottom_left'',''bottom_center'',''bottom_right''', 'select', 15, '', 1, 0, '{"wysiwyg":0,"code_editor":0,"show":"watermark|1","multilingual":0}'),
(83, 'pictures', 'watermark_opacity', '75', '', 'text', 19, '', 1, 0, '{"wysiwyg":0,"code_editor":0,"show":"watermark|1","multilingual":0}'),
(84, 'pictures', 'watermark_type', 'text', '''text'',''image''', 'select', 16, '', 1, 0, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
(85, 'pictures', 'watermark_text', '@ Your Website', '', 'text', 17, '', 1, 0, '{"wysiwyg":0,"code_editor":0,"show":"watermark_type|text","multilingual":0}'),
(86, 'pictures', 'watermark_text_color', 'FFFFFF', '', 'text', 18, '', 1, 0, '{"wysiwyg":0,"code_editor":0,"show":"watermark_type|text","multilingual":0}'),
(87, 'pictures', 'watermark_text_size', '20', '', 'text', 19, '', 1, 0, '{"wysiwyg":0,"code_editor":0,"show":"watermark_type|text","multilingual":0}'),
(88, 'pictures', 'watermark_image', '', '', 'image', 20, '', 1, 0, '{"wysiwyg":0,"code_editor":0,"show":"watermark_type|image","multilingual":0}'),
(89, 'pictures', 'lightbox', 'Lightbox', '', 'divider', 23, '', 1, 1, ''),
(90, 'pictures', 'lightbox_name', 'fancybox', 'fancybox,fancybox,fancybox', 'select', 24, '', 0, 0, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
(91, 'miscellaneous', '', 'Frontend code integration', '', 'divider', 1, '', 1, 1, ''),
(92, 'miscellaneous', 'frontend_header_code', '', '', 'textarea', 2, '', 0, 1, '{"wysiwyg":0,"code_editor":0'),
(93, 'miscellaneous', 'frontend_footer_code', '', '', 'textarea', 3, '', 0, 1, '{"wysiwyg":0,"code_editor":0'),
(94, 'miscellaneous', '', 'Open Graph', '', 'divider', 4, '', 1, 1, ''),
(95, 'miscellaneous', 'opengraph_description', '{"en":""}', '', 'textarea', 5, '', 0, 1, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":1}'),
(96, 'miscellaneous', 'opengraph_image', '', '', 'image', 6, '', 0, 0, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
(97, 'miscellaneous', '', 'CKeditor', '', 'divider', 7, '', 1, 1, ''),
(98, 'miscellaneous', 'ckeditor_skin', 'moono-lisa', '''moono-lisa'',''moonocolor''', 'select', 8, '', 0, 1, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
(99, 'miscellaneous', '', 'Captcha', '', 'divider', 9, '', 1, 1, ''),
(100, 'miscellaneous', 'captcha', '1', '''1'',''0''', 'radio', 10, '', 0, 1, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
(101, 'miscellaneous', 'captcha_name', 'kcaptcha', 'kcaptcha,kcaptcha,kcaptcha', 'select', 11, '', 0, 0, '{"wysiwyg":0,"code_editor":0,"show":"captcha|1","multilingual":0}'),
(102, 'miscellaneous', 'captcha_preview', '', '', 'text', 12, '', 0, 0, '{"wysiwyg":0,"code_editor":0,"show":"captcha|1","multilingual":0}'),
(103, 'miscellaneous', '', 'Search', '', 'divider', 13, '', 1, 1, ''),
(104, 'miscellaneous', 'search_instant', '0', '''1'',''0''', 'radio', 14, '', 0, 1, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
(105, 'miscellaneous', '', 'Maps', '', 'divider', 15, '', 1, 1, ''),
(106, 'miscellaneous', 'maps_api_key', '', '', 'text', 16, '', 0, 0, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
(107, 'financial', '', 'General', '1', 'divider', 1, '', 1, 0, ''),
(108, 'financial', 'currency_switch', '0', '''1'',''0''', 'radio', 3, '', 0, 1, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
(109, 'financial', '', 'Internal Funds', '1', 'divider', 8, '', 1, 0, ''),
(110, 'financial', 'funds_min_deposit', '20', '', 'text', 9, '', 0, 1, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
(111, 'financial', 'funds_max_deposit', '300', '', 'text', 10, '', 0, 1, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
(112, 'financial', 'funds_max', '1000', '', 'text', 11, '', 0, 1, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
(113, 'api', '', 'General', '1', 'divider', 1, '', 1, 0, ''),
(114, 'api', 'api_enabled', '0', '''1'',''0''', 'radio', 1, '', 1, 1, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
(115, 'api', 'api_push_access_key', '', '', 'text', 2, '', 1, 0, '{"wysiwyg":0,"code_editor":0,"show":"api_enabled|1","multilingual":0}'),
(116, 'api', 'api_token', '', '', 'password', 3, '', 1, 0, '{"wysiwyg":0,"code_editor":0,"show":"api_enabled|1","multilingual":0}'),
(117, 'template_kickstart', '', 'General', '', 'divider', 52, 'kickstart', 1, 1, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
(118, 'template_kickstart', 'enable_landing', '1', '1,0', 'radio', 53, 'kickstart', 1, 1, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
(119, 'template_kickstart', 'custom_colors', '0', '1,0', 'radio', 54, 'kickstart', 1, 1, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
(120, 'template_kickstart', 'custom_color_body_bg', '#fff', '', 'colorpicker', 55, 'kickstart', 1, 1, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
(121, 'template_kickstart', 'custom_color_text', '#333333', '', 'colorpicker', 56, 'kickstart', 1, 1, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
(122, 'template_kickstart', 'custom_color_headings', '#333333', '', 'colorpicker', 57, 'kickstart', 1, 1, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
(123, 'template_kickstart', 'custom_color_link', '#38b7ea', '', 'colorpicker', 58, 'kickstart', 1, 1, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
(124, 'template_kickstart', 'custom_color_link_hover', '#1490c1', '', 'colorpicker', 59, 'kickstart', 1, 1, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
(125, 'template_kickstart', '', 'Inventory bar', '', 'divider', 60, 'kickstart', 1, 1, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
(126, 'template_kickstart', 'search_inventory', '0', '1,0', 'radio', 61, 'kickstart', 1, 1, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
(127, 'template_kickstart', 'custom_color_inventory_bg', '#323232', '', 'colorpicker', 62, 'kickstart', 1, 1, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
(128, 'template_kickstart', 'custom_color_inventory_link', 'rgba(255,255,255,0.45)', '', 'colorpicker', 63, 'kickstart', 1, 1, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
(129, 'template_kickstart', 'custom_color_inventory_link_hover', 'rgba(255,255,255,0.5)', '', 'colorpicker', 64, 'kickstart', 1, 1, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
(130, 'template_kickstart', 'custom_color_inventory_link_active', 'rgba(255,255,255,0.7)', '', 'colorpicker', 65, 'kickstart', 1, 1, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
(131, 'template_kickstart', '', 'Navbar / Mainmenu', '', 'divider', 66, 'kickstart', 1, 1, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
(132, 'template_kickstart', 'max_top_menu_items', '6', '', 'text', 67, 'kickstart', 1, 1, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
(133, 'template_kickstart', 'enable_text_logo', '0', '1,0', 'radio', 68, 'kickstart', 1, 1, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
(134, 'template_kickstart', 'logo_text', 'Kickstart', '', 'text', 69, 'kickstart', 1, 1, '{"wysiwyg":0,"code_editor":0,"show":"enable_text_logo|1","multilingual":0}'),
(135, 'template_kickstart', 'navbar_sticky', '1', '1,0', 'radio', 70, 'kickstart', 1, 1, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
(136, 'template_kickstart', 'search_navbar', '1', '1,0', 'radio', 71, 'kickstart', 1, 1, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
(137, 'template_kickstart', 'custom_color_navbar_bg', '#ffffff', '', 'colorpicker', 72, 'kickstart', 1, 1, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
(138, 'template_kickstart', 'custom_color_navbar_link', 'rgba(50,50,50,0.6)', '', 'colorpicker', 73, 'kickstart', 1, 1, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
(139, 'template_kickstart', 'custom_color_navbar_link_hover', 'rgba(50,50,50,0.8)', '', 'colorpicker', 74, 'kickstart', 1, 1, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
(140, 'template_kickstart', 'custom_color_navbar_link_active', '#38b7ea', '', 'colorpicker', 75, 'kickstart', 1, 1, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
(141, 'template_kickstart', '', 'Header / Teaser', '', 'divider', 76, 'kickstart', 1, 1, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
(142, 'template_kickstart', 'bg_header', '', '', 'image', 77, 'kickstart', 1, 1, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
(143, 'template_kickstart', 'bg_header_use_color', '0', '1,0', 'radio', 78, 'kickstart', 1, 1, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
(144, 'template_kickstart', 'bg_header_color', '#6b3561', '', 'colorpicker', 79, 'kickstart', 1, 1, '{"wysiwyg":0,"code_editor":0,"show":"bg_header_use_color|1","multilingual":0}'),
(145, 'template_kickstart', '', 'Features section', '', 'divider', 80, 'kickstart', 1, 1, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
(146, 'template_kickstart', 'bg_features', '', '', 'image', 81, 'kickstart', 1, 1, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
(147, 'template_kickstart', 'bg_features_use_color', '0', '1,0', 'radio', 82, 'kickstart', 1, 1, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
(148, 'template_kickstart', 'bg_features_color', '#6b3561', '', 'colorpicker', 83, 'kickstart', 1, 1, '{"wysiwyg":0,"code_editor":0,"show":"bg_features_use_color|1","multilingual":0}'),
(149, 'template_kickstart', '', 'Footer', '', 'divider', 84, 'kickstart', 1, 1, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
(150, 'template_kickstart', 'footer_bg', '#323232', '', 'colorpicker', 85, 'kickstart', 1, 1, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
(151, 'template_kickstart', 'footer_blocks_bg', '#444444', '', 'colorpicker', 86, 'kickstart', 1, 1, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
(152, 'template_kickstart', 'footer_link', 'rgba(255,255,255,0.45)', '', 'colorpicker', 87, 'kickstart', 1, 1, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
(153, 'template_kickstart', 'footer_link_hover', 'rgba(255,255,255,0.5)', '', 'colorpicker', 88, 'kickstart', 1, 1, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
(154, 'template_kickstart', 'footer_link_active', 'rgba(255,255,255,0.7)', '', 'colorpicker', 89, 'kickstart', 1, 1, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
(155, 'template_kickstart', '', 'Social links', '', 'divider', 90, 'kickstart', 1, 1, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
(156, 'template_kickstart', 'website_social', '1', '1,0', 'radio', 91, 'kickstart', 1, 1, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
(157, 'template_kickstart', 'website_social_t', '#', '', 'text', 92, 'kickstart', 1, 1, '{"wysiwyg":0,"code_editor":0,"show":"website_social|1","multilingual":0}'),
(158, 'template_kickstart', 'website_social_f', '#', '', 'text', 93, 'kickstart', 1, 1, '{"wysiwyg":0,"code_editor":0,"show":"website_social|1","multilingual":0}'),
(159, 'template_kickstart', 'website_social_g', '#', '', 'text', 94, 'kickstart', 1, 1, '{"wysiwyg":0,"code_editor":0,"show":"website_social|1","multilingual":0}'),
(160, 'template_kickstart', 'website_social_i', '#', '', 'text', 95, 'kickstart', 1, 1, '{"wysiwyg":0,"code_editor":0,"show":"website_social|1","multilingual":0}'),
(161, 'template_kickstart', 'ckeditor_css', 'ckeditor.css', '', 'hidden', 96, 'kickstart', 0, 1, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
(162, 'blog', 'blog_plugin', 'General', '', 'divider', 97, 'blog', 1, 1, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
(163, 'blog', 'blog_number_block', '4', '', 'text', 98, 'blog', 1, 1, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
(164, 'blog', 'blog_number_new_block', '3', '', 'text', 99, 'blog', 1, 1, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
(165, 'blog', 'blog_max_block', '200', '', 'text', 100, 'blog', 1, 1, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
(166, 'blog', 'blog_number', '5', '', 'text', 101, 'blog', 1, 1, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
(167, 'blog', 'blog_max', '500', '', 'text', 102, 'blog', 1, 1, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
(168, 'blog', 'blog_order', 'date', 'alphabetic,date', 'select', 103, 'blog', 1, 1, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
(169, 'blog', 'blog_tag_number', '10', '', 'text', 104, 'blog', 1, 1, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
(170, 'blog', 'blog_image_resize', 'crop', 'crop,fit', 'select', 105, 'blog', 1, 1, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
(171, 'blog', 'blog_image_width', '1280', '', 'text', 106, 'blog', 1, 1, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
(172, 'blog', 'blog_image_height', '720', '', 'text', 107, 'blog', 1, 1, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
(173, 'blog', 'blog_thumb_width', '250', '', 'text', 108, 'blog', 1, 1, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
(174, 'blog', 'blog_thumb_height', '250', '', 'text', 109, 'blog', 1, 1, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
(175, 'miscellaneous', 'kcaptcha_divider', 'KCAPTCHA', '', 'divider', 110, 'kcaptcha', 1, 1, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
(176, 'miscellaneous', 'kcaptcha_case_sensitive', '1', '1,0', 'radio', 111, 'kcaptcha', 1, 1, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
(177, 'miscellaneous', 'kcaptcha_num_chars', '5', '', 'text', 112, 'kcaptcha', 1, 1, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
(178, 'pictures', 'fancybox_divider', 'fancyBox', '', 'divider', 113, 'fancybox', 1, 1, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
(179, 'pictures', 'fancybox_slide_transition', 'elastic', 'elastic,fade', 'select', 114, 'fancybox', 0, 1, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
(180, 'pictures', 'fancybox_open_transition', 'fade', 'elastic,fade', 'select', 115, 'fancybox', 0, 1, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
(181, 'pictures', 'fancybox_slide_speed', 'fast', 'fast,slow,normal', 'select', 116, 'fancybox', 0, 1, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
(182, 'pictures', 'fancybox_open_speed', 'fast', 'fast,slow,normal', 'select', 117, 'fancybox', 0, 1, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
(183, 'pictures', 'fancybox_padding', '15', '', 'text', 118, 'fancybox', 0, 1, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
(184, 'pictures', 'fancybox_arrows', '1', '1,0', 'radio', 119, 'fancybox', 0, 1, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
(185, 'pictures', 'fancybox_closeBtn', '1', '1,0', 'radio', 120, 'fancybox', 0, 1, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
(186, 'pictures', 'fancybox_closeClick', '0', '1,0', 'radio', 121, 'fancybox', 0, 1, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]config_custom`
--

CREATE TABLE `[[dbprefix]]config_custom` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(64) NOT NULL,
  `value` text NOT NULL,
  `type` enum('user','group','plan') NOT NULL DEFAULT 'group',
  `type_id` mediumint(8) unsigned NOT NULL,
  `module` varchar(40) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `NAME` (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]config_groups`
--

CREATE TABLE `[[dbprefix]]config_groups` (
  `name` varchar(50) NOT NULL,
  `order` smallint(4) unsigned NOT NULL,
  `module` varchar(40) NOT NULL,
  PRIMARY KEY (`name`),
  KEY `EXTRAS` (`module`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

--
-- Dumping data for table `[[dbprefix]]config_groups`
--

INSERT INTO `[[dbprefix]]config_groups` VALUES
('general', 1, ''),
('members', 2, ''),
('mail', 3, ''),
('system', 4, ''),
('pictures', 5, ''),
('miscellaneous', 6, ''),
('financial', 7, ''),
('api', 8, ''),
('template_kickstart', 9, 'kickstart'),
('blog', 10, 'blog');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]cron`
--

CREATE TABLE `[[dbprefix]]cron` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(60) NOT NULL,
  `description` tinytext NOT NULL,
  `date_prev_launch` int(10) unsigned NOT NULL,
  `date_next_launch` int(10) unsigned NOT NULL,
  `data` tinytext NOT NULL,
  `active` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `module` varchar(40) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ACTIVE` (`active`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=5 ;

--
-- Dumping data for table `[[dbprefix]]cron`
--

INSERT INTO `[[dbprefix]]cron` VALUES
(1, 'Sitemap creation and update', 'Updates (or generates) the sitemap.xml file', [[timestamp]], [[timestamp]], '1 1,12 * * * includes/cron/sitemap.php', 1, ''),
(2, 'System cleanup', 'Cleans up temporary DB entries', [[timestamp]], [[timestamp_nextday]], '5 0 * * * includes/cron/cleanup.php', 1, ''),
(3, 'Check for expiration of sponsored items', 'Marks expired sponsored items', [[timestamp]], [[timestamp]], '20 * * * * includes/cron/sponsored-expiration.php', 1, ''),
(4, 'Check for expiration of featured items', 'Marks expired featured items', [[timestamp]], [[timestamp_nextday]], '0 0 * * * includes/cron/featured-expiration.php', 1, '');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]currencies`
--

CREATE TABLE `[[dbprefix]]currencies` (
  `code` char(3) NOT NULL,
  `status` enum('active','inactive') NOT NULL DEFAULT 'active',
  `title` varchar(30) NOT NULL,
  `rate` decimal(10,5) unsigned NOT NULL,
  `symbol` varchar(5) NOT NULL,
  `sym_pos` enum('pre','post') NOT NULL DEFAULT 'pre',
  `default` tinyint(1) unsigned NOT NULL,
  `order` tinyint(2) unsigned NOT NULL,
  `fmt_num_decimals` tinyint(2) unsigned NOT NULL DEFAULT '2',
  `fmt_dec_point` varchar(1) NOT NULL DEFAULT '.',
  `fmt_thousand_sep` varchar(1) NOT NULL DEFAULT ',',
  PRIMARY KEY (`code`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

--
-- Dumping data for table `[[dbprefix]]currencies`
--

INSERT INTO `[[dbprefix]]currencies` VALUES
('USD', 'active', 'US Dollar', 1.00000, '$', 'pre', 1, 1, 2, '.', ','),
('EUR', 'inactive', 'Euro', 0.87000, '€', 'post', 0, 2, 2, '.', ','),
('GBP', 'inactive', 'Pound Sterling', 0.78000, '£', 'pre', 0, 3, 2, '.', ',');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]email_templates`
--

CREATE TABLE `[[dbprefix]]email_templates` (
  `name` varchar(60) NOT NULL,
  `active` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `divider` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `order` smallint(5) unsigned NOT NULL,
  `module` varchar(40) NOT NULL,
  `variables` varchar(300) NOT NULL,
  `subject_en` varchar(255) NOT NULL,
  `body_en` text NOT NULL,
  PRIMARY KEY (`name`),
  KEY `ACTIVE` (`active`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

--
-- Dumping data for table `[[dbprefix]]email_templates`
--

INSERT INTO `[[dbprefix]]email_templates` VALUES
('member_templates', 1, 1, 10, '', '', '', ''),
('member_approved', 1, 0, 20, '', 'fullname|User', 'Member was approved at {$siteName}', '<p>Dear {$fullname},</p>\r\n<p>Your membership was approved in {$siteName}. Now you can log in.</p>'),
('member_disapproved', 1, 0, 30, '', 'fullname|User', 'Member was disapproved at {$siteName}', '<p>Dear {$fullname},</p>\r\n<p>Your membership was disapproved in {$siteName}.</p>'),
('member_registration', 1, 0, 40, '', 'fullname|User,email|Email,username|Username,password|Password,link|Confirmation link', 'Thanks for registration at {$siteName}', '<p>Dear {$fullname},</p> <p>Thanks for your registration at <a href="{$siteUrl}" target="_blank">{$siteUrl}</a>. Here is information you should use in order to login:</p> <p>Your username: {$username}<br /> Your password: {$password}</p> <p>To activate your account, please, <a href="{$link}" target="_blank">follow this link</a>. <br /> You may change your password later by editing your personal attributes in your member area.</p>'),
('member_registration_social', 1, 0, 50, '', 'fullname|User,email|Email,username|Username,password|Password,link|Confirmation link,provider|Social provider used to register', 'Thanks for registration at {$siteName}', '<p>Dear {$fullname},</p> <p>Thanks for your registration at <a href="{$siteUrl}" target="_blank">{$siteUrl}</a> via {$provider}. Here is information you should use in order to login:</p> <p>Your email: {$email}</p> <p>You may change your password later by editing your personal attributes in your member area.</p>'),
('member_registration_notification', 1, 0, 60, '', 'fullname|User,email|Email,password|Password', 'Member has been created {$siteName}', '<p>Greetings {$fullname},</p> <p>Administrator has just created an account for you at {$siteUrl}. Here is information you should use in order to login:</p> <p>Your email: <b>{$email}</b><br /> Your password: <b>{$password}</b></p>'),
('member_registration_admin', 1, 0, 70, '', 'id|ID,fullname|User,username|Username,email|User email', 'New member registered at {$siteName}', '<p>Greetings,</p><p>New member registered at {$siteUrl}. Detailed information is below:</p> <p>ID: <b>{$id}</b><br>Name: <b>{$fullname}</b> ({$username})<br>Email: <b>{$email}</b></p>'),
('member_removal', 1, 0, 80, '', 'fullname|User', 'Member deleted at {$siteName}', '<p>Dear {$fullname},</p>\r\n<p>Your membership was removed from {$siteUrl}.</p>'),
('password_restoration', 1, 0, 90, '', 'fullname|User,email|Email,code|Restoration code', 'Password restoration request at {$siteName}', '<p>Dear {$fullname},</p>\r\n<p>Please follow this link if you wish to change the password at {$siteName}:<br />\r\n<a href="{$url}">{$url}</a>\r\n</p>\r\n<p>\r\nOr use confirmation code on page: <a href="{$siteUrl}forgot/?code">{$siteUrl}forgot/?code</a><br />\r\nE-mail: {$email}<br />\r\nCode: {$code}\r\n</p>'),
('password_changement', 1, 0, 100, '', 'fullname|User,username|Username,password|New password', 'Password change request at {$siteName}', '<p>Dear {$fullname},</p>\r\n\r\n<p>You requested a password change in {$siteName}. Now you should use the following credentials to log in as member:</p>\r\n\r\n<p>Username: {$username}<br />\r\nPassword: {$password}</p>'),
('financial_templates', 1, 1, 110, '', '', '', ''),
('plan_activated', 1, 0, 120, '', 'plan|Plan name,cost|Plan''s cost,duration|Plan''s duration,unit|Duration unit,fullname|User,currency|Currency code', 'Plan activated at {$siteName}', '<p>Dear {$fullname},</p>\r\n<p>Your listing has been activated.</p>\r\n\r\n<ul>\r\n	<li><b>Plan:</b> {$plan}</li>\r\n	<li><b>Cost:</b> {$currency} {$cost}</li>\r\n	<li><b>Duration:</b> {$duration} {$unit}(s)</li>\r\n</ul>'),
('plan_expired', 1, 0, 130, '', 'plan|Plan name,cost|Plan''s cost,duration|Plan''s duration,unit|Duration unit,fullname|User,currency|Currency code', 'Plan expired at {$siteName}', '<p>Dear {$fullname},</p>\r\n<p>Your paid listing submission expired.</p>\r\n\r\n<ul>\r\n	<li><b>Plan:</b> {$plan}</li>\r\n	<li><b>Cost:</b> {$currency} {$cost}</li>\r\n	<li><b>Duration:</b> {$duration} {$unit}(s)</li>\r\n</ul>\r\n\r\n<p>It may always be renewed through the site.</p>'),
('transaction_paid', 1, 0, 140, '', 'email|Email,username|Username,fullname|Fullname,operation|Operation name,amount|Amount,reference_id|Reference ID,currency|Currency,item|Item,item_id|Item ID,date_created|Creation Date,date_paid|Payment Date', 'Payment received at {$siteName}', '<p>Dear {$fullname},</p>\r\n<p>Your payment has been successfully received.</p>\r\n\r\n<p>Order Number: <strong>{$reference_id}</strong></p>\r\n\r\n<p>Payment details are below:</p>\r\n\r\n<ul>\r\n	<li><b>Operation:</b> {$operation}</li>\r\n	<li><b>Amount:</b> {$currency} {$amount}</li>\r\n	<li><b>Item:</b> {$item} #{$item_id}</li>\r\n	<li><b>Date:</b> {$date_paid}</li>\r\n</ul>\r\n\r\n<p>All your transactions could always be seen on the <a href="{$siteUrl}profile/funds/" target="_blank">Funds</a> page.</p>'),
('transaction_paid_admin', 1, 0, 150, '', 'username|User,amount|Amount of transaction,operation|Operation name,currency|Currency', 'Payment completed at {$siteName}', '<p>Dear Administrator,</p>\r\n<p>A payment has been completed on your site. Here is the information on the payment:</p><ul><li><b>Username:</b> {$username}</li><li><b>Amount:</b>{$currency} {$amount}</li><li><b>Operation:</b> {$operation}</li></ul>'),
('invoice_created', 1, 0, 160, '', 'invoice|Invoice ID,gateway|Gateway,date|Invoice creation date,fullname|User,amount|Amount,currency|Currency', 'Customer Invoice', '<p>Dear {$fullname},</p>\r\n<p>This is a notice that an invoice has been generated on {$date}</p>\r\n\r\n<p>Your payment method is: {$gateway}</p>\r\n\r\n<p>Invoice #{$invoice},<br>\r\nAmount Due: {$currency} {$amount}\r\n</p>\r\n\r\n<p>All your invoices could always be seen on the <a href="{$siteUrl}profile/funds/" target="_blank">Funds</a> page.</p>');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]favorites`
--

CREATE TABLE `[[dbprefix]]favorites` (
  `id` int(10) unsigned NOT NULL,
  `member_id` int(11) unsigned NOT NULL,
  `item` varchar(50) NOT NULL,
  UNIQUE KEY `UNIQUE` (`id`,`member_id`,`item`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]fields`
--

CREATE TABLE `[[dbprefix]]fields` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `group` smallint(5) unsigned NOT NULL DEFAULT '1',
  `module` varchar(40) NOT NULL,
  `name` varchar(60) NOT NULL,
  `item` varchar(50) NOT NULL DEFAULT 'member',
  `fieldgroup_id` smallint(5) unsigned NOT NULL,
  `type` enum('text','url','number','date','textarea','combo','radio','checkbox','storage','image','pictures','currency','tree','iconpicker') NOT NULL DEFAULT 'text',
  `length` mediumint(7) unsigned NOT NULL,
  `values` text,
  `default` tinytext NOT NULL,
  `order` smallint(5) unsigned NOT NULL,
  `editable` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `multilingual` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `required` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `required_checks` text NOT NULL,
  `extra_actions` text NOT NULL,
  `adminonly` tinyint(1) unsigned NOT NULL,
  `searchable` tinyint(1) unsigned NOT NULL,
  `sort_order` enum('asc','desc') NOT NULL DEFAULT 'asc',
  `show_as` enum('combo','radio','checkbox') NOT NULL DEFAULT 'combo',
  `for_plan` tinyint(1) unsigned NOT NULL,
  `status` enum('active','inactive') NOT NULL DEFAULT 'active',
  `image_width` smallint(5) unsigned NOT NULL,
  `image_height` smallint(5) unsigned NOT NULL,
  `thumb_width` smallint(5) unsigned NOT NULL,
  `thumb_height` smallint(5) unsigned NOT NULL,
  `resize_mode` enum('crop','fit') NOT NULL DEFAULT 'crop',
  `file_prefix` varchar(50) NOT NULL,
  `file_types` text NOT NULL,
  `use_editor` tinyint(1) unsigned NOT NULL,
  `plans` varchar(250) NOT NULL,
  `timepicker` tinyint(1) unsigned NOT NULL,
  `url_nofollow` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `empty_field` tinytext NOT NULL,
  `relation` enum('regular','parent','dependent') NOT NULL DEFAULT 'regular',
  `allow_null` tinyint(1) unsigned NOT NULL,
  `folder_name` varchar(150) NOT NULL,
  `imagetype_primary` varchar(20) NOT NULL,
  `imagetype_thumbnail` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQUE` (`name`,`item`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=24 ;

--
-- Dumping data for table `[[dbprefix]]fields`
--

INSERT INTO `[[dbprefix]]fields` VALUES
(1, 1, '', 'username', 'member', 1, 'text', 50, NULL, '', 0, 0, 0, 1, '', 'if ($value && !iaValidate::isUsername($value))\r\n{\r\n	$errors[$fieldName] = iaLanguage::get(''username_incorrect'');\r\n}', 0, 1, 'asc', 'combo', 0, 'active', 0, 0, 0, 0, 'crop', '', '', 0, '', 0, 1, '', 'regular', 0, '', '', ''),
(2, 1, '', 'fullname', 'member', 1, 'text', 50, NULL, '', 5, 0, 0, 1, '', '', 0, 1, 'asc', 'combo', 0, 'active', 0, 0, 0, 0, 'crop', '', '', 0, '', 0, 1, '', 'regular', 0, '', '', ''),
(3, 1, '', 'email', 'member', 1, 'text', 250, NULL, '', 10, 0, 0, 1, '', 'if ($value)\r\n{\r\n	if (iaValidate::isEmail($value))\r\n	{\r\n		$value = strtolower($value);\r\n	}\r\n	else\r\n	{\r\n		$errors[$fieldName] = iaLanguage::get(''error_email_incorrect'');\r\n	}\r\n}', 0, 0, 'asc', 'combo', 0, 'active', 0, 0, 0, 0, 'crop', '', '', 0, '', 0, 1, '', 'regular', 0, '', '', ''),
(4, 1, '', 'avatar', 'member', 1, 'image', 1, NULL, '', 15, 1, 0, 0, '', '', 0, 1, 'asc', 'combo', 0, 'active', 300, 300, 200, 200, 'crop', 'avat_', '', 1, '', 0, 1, '', 'regular', 0, '', 'large', 'thumbnail'),
(5, 1, '', 'website', 'member', 1, 'text', 255, NULL, '', 20, 1, 0, 0, '', '', 0, 0, 'asc', 'combo', 0, 'active', 0, 0, 0, 0, 'crop', '', '', 0, '', 0, 1, '', 'regular', 0, '', '', ''),
(6, 1, '', 'phone', 'member', 1, 'text', 100, NULL, '', 25, 1, 0, 0, '', '', 0, 0, 'asc', 'combo', 0, 'active', 0, 0, 0, 0, 'crop', '', '', 0, '', 0, 1, '', 'regular', 0, '', '', ''),
(7, 1, '', 'biography', 'member', 1, 'textarea', 500, NULL, '', 30, 1, 0, 0, '', '', 0, 0, 'asc', 'combo', 0, 'active', 0, 0, 0, 0, 'crop', '', '', 0, '', 0, 1, '', 'regular', 0, '', '', ''),
(8, 1, '', 'facebook', 'member', 2, 'text', 150, NULL, '', 35, 1, 0, 0, '', '', 0, 0, 'asc', 'combo', 0, 'active', 0, 0, 0, 0, 'crop', '', '', 0, '', 0, 1, '', 'regular', 0, '', '', ''),
(9, 1, '', 'twitter', 'member', 2, 'text', 150, NULL, '', 40, 1, 0, 0, '', '', 0, 0, 'asc', 'combo', 0, 'active', 0, 0, 0, 0, 'crop', '', '', 0, '', 0, 1, '', 'regular', 0, '', '', ''),
(10, 1, '', 'gplus', 'member', 2, 'text', 150, NULL, '', 45, 1, 0, 0, '', '', 0, 0, 'asc', 'combo', 0, 'active', 0, 0, 0, 0, 'crop', '', '', 0, '', 0, 1, '', 'regular', 0, '', '', ''),
(11, 1, '', 'linkedin', 'member', 2, 'text', 150, NULL, '', 50, 1, 0, 0, '', '', 0, 0, 'asc', 'combo', 0, 'active', 0, 0, 0, 0, 'crop', '', '', 0, '', 0, 1, '', 'regular', 0, '', '', ''),
(12, 1, '', 'api_push_token', 'member', 3, 'textarea', 255, NULL, '', 55, 1, 0, 0, '', '', 1, 0, 'asc', 'combo', 0, 'active', 0, 0, 0, 0, 'crop', '', '', 0, '', 0, 1, '', 'regular', 0, '', '', ''),
(13, 1, '', 'api_push_receive', 'member', 3, 'radio', 0, 'yes,no', 'yes', 60, 1, 0, 0, '', '', 1, 0, 'asc', 'combo', 0, 'active', 0, 0, 0, 0, 'crop', '', '', 0, '', 0, 1, '', 'regular', 0, '', '', ''),
(14, 1, '', 'email_language', 'member', 0, 'text', 2, NULL, '', 65, 0, 0, 1, '', '', 0, 0, 'asc', 'combo', 0, 'active', 0, 0, 0, 0, 'crop', '', '', 0, '', 0, 1, '', 'regular', 0, '', '', ''),
(15, 1, '', 'member_id', 'transaction', 0, 'text', 100, NULL, '', 0, 1, 0, 0, '', '', 0, 0, 'asc', 'combo', 0, 'active', 0, 0, 0, 0, 'crop', '', '', 0, '', 0, 1, '', 'regular', 0, '', '', ''),
(16, 1, '', 'reference_id', 'transaction', 0, 'text', 100, NULL, '', 5, 1, 0, 0, '', '', 0, 0, 'asc', 'combo', 0, 'active', 0, 0, 0, 0, 'crop', '', '', 0, '', 0, 1, '', 'regular', 0, '', '', ''),
(17, 1, '', 'date_created', 'transaction', 0, 'date', 0, NULL, '', 10, 1, 0, 0, '', '', 0, 0, 'asc', 'combo', 0, 'active', 0, 0, 0, 0, 'crop', '', '', 0, '', 1, 1, '', 'regular', 0, '', '', ''),
(18, 1, '', 'date_paid', 'transaction', 0, 'date', 0, NULL, '', 15, 8, 0, 0, '', '', 0, 0, 'asc', 'combo', 0, 'active', 0, 0, 0, 0, 'crop', '', '', 0, '', 1, 1, '', 'regular', 0, '', '', ''),
(19, 1, '', 'amount', 'transaction', 0, 'number', 8, NULL, '', 20, 1, 0, 0, '', '', 0, 0, 'asc', 'combo', 0, 'active', 0, 0, 0, 0, 'crop', '', '', 0, '', 0, 1, '', 'regular', 0, '', '', ''),
(20, 1, '', 'operation', 'transaction', 0, 'text', 100, NULL, '', 25, 1, 0, 0, '', '', 0, 0, 'asc', 'combo', 0, 'active', 0, 0, 0, 0, 'crop', '', '', 0, '', 0, 1, '', 'regular', 0, '', '', ''),
(21, 1, '', 'gateway', 'transaction', 0, 'text', 100, NULL, '', 30, 1, 0, 0, '', '', 0, 0, 'asc', 'combo', 0, 'active', 0, 0, 0, 0, 'crop', '', '', 0, '', 0, 1, '', 'regular', 0, '', '', ''),
(22, 1, '', 'currency', 'transaction', 0, 'text', 10, NULL, '', 35, 1, 0, 0, '', '', 0, 0, 'asc', 'combo', 0, 'active', 0, 0, 0, 0, 'crop', '', '', 0, '', 0, 1, '', 'regular', 0, '', '', ''),
(23, 1, '', 'sec_key', 'transaction', 0, 'text', 250, NULL, '', 40, 1, 0, 0, '', '', 0, 0, 'asc', 'combo', 0, 'active', 0, 0, 0, 0, 'crop', '', '', 0, '', 0, 1, '', 'regular', 0, '', '', '');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]fields_groups`
--

CREATE TABLE `[[dbprefix]]fields_groups` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `item` varchar(50) NOT NULL DEFAULT 'member',
  `order` smallint(5) unsigned NOT NULL,
  `module` varchar(40) NOT NULL,
  `collapsible` tinyint(1) unsigned NOT NULL,
  `collapsed` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `tabview` tinyint(1) unsigned NOT NULL,
  `tabcontainer` varchar(60) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQUE` (`name`,`item`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=4 ;

--
-- Dumping data for table `[[dbprefix]]fields_groups`
--

INSERT INTO `[[dbprefix]]fields_groups` VALUES
(1, 'general', 'member', 1, 'core', 0, 0, 0, ''),
(2, 'social', 'member', 2, 'core', 0, 0, 0, ''),
(3, 'api', 'member', 3, 'core', 0, 0, 0, '');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]fields_image_types`
--

CREATE TABLE `[[dbprefix]]fields_image_types` (
  `field_id` smallint(5) unsigned NOT NULL,
  `image_type_id` int(9) unsigned NOT NULL,
  UNIQUE KEY `UNIQUE` (`field_id`,`image_type_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]fields_pages`
--

CREATE TABLE `[[dbprefix]]fields_pages` (
  `field_id` smallint(5) unsigned NOT NULL,
  `page_name` varchar(50) NOT NULL,
  UNIQUE KEY `UNIQUE` (`field_id`,`page_name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

--
-- Dumping data for table `[[dbprefix]]fields_pages`
--

INSERT INTO `[[dbprefix]]fields_pages` VALUES
(1, 'favorites'),
(1, 'members'),
(1, 'registration'),
(2, 'favorites'),
(2, 'members'),
(2, 'profile'),
(2, 'registration'),
(2, 'view_member'),
(3, 'profile'),
(3, 'registration'),
(4, 'favorites'),
(4, 'members'),
(4, 'profile'),
(4, 'view_member'),
(5, 'favorites'),
(5, 'members'),
(5, 'profile'),
(5, 'view_member'),
(6, 'favorites'),
(6, 'members'),
(6, 'profile'),
(6, 'view_member'),
(7, 'profile'),
(7, 'view_member'),
(8, 'favorites'),
(8, 'members'),
(8, 'profile'),
(8, 'view_member'),
(9, 'favorites'),
(9, 'members'),
(9, 'profile'),
(9, 'view_member'),
(10, 'favorites'),
(10, 'members'),
(10, 'profile'),
(10, 'view_member'),
(11, 'favorites'),
(11, 'members'),
(11, 'profile'),
(11, 'view_member'),
(14, 'profile');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]fields_relations`
--

CREATE TABLE `[[dbprefix]]fields_relations` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `field_id` smallint(5) unsigned NOT NULL,
  `element` varchar(50) NOT NULL,
  `child` varchar(50) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `FIELD` (`field_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]fields_tree_nodes`
--

CREATE TABLE `[[dbprefix]]fields_tree_nodes` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `field` varchar(50) NOT NULL,
  `item` varchar(30) NOT NULL,
  `module` varchar(40) NOT NULL,
  `node_id` varchar(30) NOT NULL,
  `parent_node_id` varchar(30) NOT NULL,
  `alias` varchar(150) NOT NULL,
  `num_listings` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ITEMNAME` (`item`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]file_types`
--

CREATE TABLE `[[dbprefix]]file_types` (
  `id` int(9) unsigned NOT NULL AUTO_INCREMENT,
  `extension` varchar(10) NOT NULL DEFAULT '',
  `maxsize` int(11) unsigned NOT NULL DEFAULT '0',
  `image` tinyint(1) unsigned DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `EXTENSION` (`extension`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=30 ;

--
-- Dumping data for table `[[dbprefix]]file_types`
--

INSERT INTO `[[dbprefix]]file_types` VALUES
(1, 'swf', 0, 0),
(2, 'wav', 0, 0),
(3, 'mov', 0, 0),
(5, 'mpeg', 0, 0),
(6, 'mpg', 0, 0),
(7, 'mp3', 0, 0),
(8, 'png', 0, 1),
(9, 'jpg', 0, 1),
(10, 'gif', 0, 1),
(11, 'jpeg', 0, 1),
(12, 'ico', 0, 0),
(13, 'htm', 0, 0),
(14, 'html', 0, 0),
(15, 'txt', 0, 0),
(16, 'pdf', 0, 0),
(17, 'rtf', 0, 0),
(18, 'zip', 0, 0),
(19, 'gz', 0, 0),
(20, 'tar', 0, 0),
(21, 'rar', 0, 0),
(22, 'bz', 0, 0),
(23, 'bz2', 0, 0),
(24, 'doc', 0, 0),
(25, 'docx', 0, 0),
(26, 'xls', 0, 0),
(27, 'xlsx', 0, 0),
(28, 'ppt', 0, 0),
(29, 'pptx', 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]hooks`
--

CREATE TABLE `[[dbprefix]]hooks` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `module` varchar(40) NOT NULL,
  `name` varchar(100) NOT NULL,
  `code` text,
  `status` enum('active','inactive') NOT NULL DEFAULT 'active',
  `order` smallint(5) unsigned NOT NULL,
  `pages` tinytext NOT NULL,
  `type` enum('php','html','smarty','plain') NOT NULL DEFAULT 'php',
  `page_type` enum('admin','front','both') NOT NULL DEFAULT 'both',
  `filename` tinytext NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQUE` (`name`,`module`),
  KEY `STATUS` (`status`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=10 ;

--
-- Dumping data for table `[[dbprefix]]hooks`
--

INSERT INTO `[[dbprefix]]hooks` VALUES
(1, '', 'smartyFrontAfterHeadSection', '', 'active', 1, '', 'smarty', 'front', 'templates/_common/hook.header-code.tpl'),
(2, '', 'smartyFrontFinalize', '{$core.config.frontend_footer_code}', 'active', 2, '', 'smarty', 'front', ''),
(3, '', 'editItemSetSystemDefaults', 'if (isset($item[''featured'']) && $item[''featured''])\r\n{\r\n	$item[''featured_end''] = date(iaDb::DATETIME_SHORT_FORMAT, strtotime($item[''featured_end'']));\r\n}\r\nelse\r\n{\r\n	$date = getdate();\r\n	$date = mktime($date[''hours''], $date[''minutes''] + 1,0,$date[''mon''] + 1,$date[''mday''], $date[''year'']);\r\n	$item[''featured_end''] = date(iaDb::DATETIME_SHORT_FORMAT, $date);\r\n}\r\n\r\nif (isset($item[''sponsored'']) && $item[''sponsored''])\r\n{\r\n	$item[''sponsored_end''] = date(iaDb::DATETIME_SHORT_FORMAT, strtotime($item[''sponsored_end'']));\r\n}\r\n\r\nif (isset($item[''member_id'']))\r\n{\r\n	$item[''owner''] = '''';\r\n	if ($item[''member_id''] > 0)\r\n	{\r\n		$iaUsers = $iaCore->factory(''users'');\r\n		if ($ownerInfo = $iaUsers->getInfo((int)$item[''member_id'']))\r\n		{\r\n			$item[''owner''] = $ownerInfo[''fullname''] . '' ('' . $ownerInfo[''email''] . '')'';\r\n		}\r\n	}\r\n}', 'active', 1, '', 'php', 'admin', ''),
(4, '', 'smartyFrontSearchSortingMembers', '', 'active', 1, '', 'smarty', 'front', 'search.members.sorting-header.tpl'),
(5, 'blog', 'phpCoreBeforePageDisplay', '', 'active', 0, '', 'php', 'front', 'modules/blog/includes/hook.blocks-load.php'),
(6, 'blog', 'adminDashboardStatistics', '$items[''blog''] = ''blog'';', 'active', 0, 'index', 'php', 'admin', ''),
(7, 'blog', 'sitemapGeneration', '$items[] = ''blog:blog'';', 'active', 0, 'index,sitemap', 'php', 'admin', ''),
(8, 'fancybox', 'smartyFrontAfterHeadSection', '{if ''fancybox'' == $core.config.lightbox_name}\n    {ia_add_media files=''css:_IA_URL_modules/fancybox/js/jquery.fancybox, js:_IA_URL_modules/fancybox/js/jquery.fancybox.pack''}\n    {ia_add_js}\n$(function()\n{\n    $(''a[rel^="ia_lightbox"]'').fancybox(\n    {\n        nextEffect: ''{$core.config.fancybox_slide_transition}'',\n        prevEffect: ''{$core.config.fancybox_slide_transition}'',\n        openEffect: ''{$core.config.fancybox_open_transition}'',\n        closeEffect: ''{$core.config.fancybox_open_transition}'',\n        nextSpeed: ''{$core.config.fancybox_slide_speed}'',\n        prevSpeed: ''{$core.config.fancybox_slide_speed}'',\n        openSpeed: ''{$core.config.fancybox_open_speed}'',\n        closeSpeed: ''{$core.config.fancybox_open_speed}'',\n        padding: {$core.config.fancybox_padding},\n        arrows: {$core.config.fancybox_arrows},\n        closeBtn: {$core.config.fancybox_closeBtn},\n        closeClick: {$core.config.fancybox_closeClick},\n        helpers: {\n            overlay: {\n                locked: false\n            }\n        }\n    });\n});\n    {/ia_add_js}\n{/if}', 'active', 0, '', 'smarty', 'both', ''),
(9, 'fancybox', 'smartyAdminAfterHeadSection', '{if ''fancybox'' == $core.config.lightbox_name}\n    {ia_add_media files=''css:_IA_URL_modules/fancybox/js/jquery.fancybox, js:_IA_URL_modules/fancybox/js/jquery.fancybox.pack''}\n    {ia_add_js}\n$(function()\n{\n    $(''a[rel^="ia_lightbox"]'').fancybox(\n    {\n        nextEffect: ''{$core.config.fancybox_slide_transition}'',\n        prevEffect: ''{$core.config.fancybox_slide_transition}'',\n        openEffect: ''{$core.config.fancybox_open_transition}'',\n        closeEffect: ''{$core.config.fancybox_open_transition}'',\n        nextSpeed: ''{$core.config.fancybox_slide_speed}'',\n        prevSpeed: ''{$core.config.fancybox_slide_speed}'',\n        openSpeed: ''{$core.config.fancybox_open_speed}'',\n        closeSpeed: ''{$core.config.fancybox_open_speed}'',\n        padding: {$core.config.fancybox_padding},\n        arrows: {$core.config.fancybox_arrows},\n        closeBtn: {$core.config.fancybox_closeBtn},\n        closeClick: {$core.config.fancybox_closeClick},\n        helpers: {\n            overlay: {\n                locked: false\n            }\n        }\n    });\n});\n    {/ia_add_js}\n{/if}', 'active', 0, '', 'smarty', 'both', '');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]image_types`
--

CREATE TABLE `[[dbprefix]]image_types` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `width` int(11) unsigned NOT NULL,
  `height` int(11) unsigned NOT NULL,
  `resize_mode` enum('crop','fit') NOT NULL DEFAULT 'crop',
  `cropper` tinyint(1) NOT NULL DEFAULT '0',
  `module` varchar(40) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]image_types_filetypes`
--

CREATE TABLE `[[dbprefix]]image_types_filetypes` (
  `image_type_id` smallint(5) unsigned NOT NULL,
  `file_type_id` int(9) unsigned NOT NULL,
  UNIQUE KEY `UNIQUE` (`image_type_id`,`file_type_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]invoices`
--

CREATE TABLE `[[dbprefix]]invoices` (
  `id` bigint(12) unsigned NOT NULL,
  `transaction_id` int(10) unsigned NOT NULL,
  `date_created` datetime NOT NULL,
  `date_due` datetime DEFAULT NULL,
  `fullname` varchar(200) NOT NULL,
  `member_id` int(11) unsigned NOT NULL,
  `address1` tinytext NOT NULL,
  `address2` tinytext NOT NULL,
  `zip` varchar(12) NOT NULL,
  `country` varchar(32) NOT NULL,
  `notes` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `TRANSACTION` (`transaction_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]invoices_items`
--

CREATE TABLE `[[dbprefix]]invoices_items` (
  `id` int(9) unsigned NOT NULL AUTO_INCREMENT,
  `invoice_id` bigint(12) unsigned NOT NULL,
  `title` tinytext NOT NULL,
  `price` decimal(11,2) unsigned NOT NULL,
  `quantity` smallint(5) unsigned NOT NULL,
  `tax` tinyint(3) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `INVOICE` (`invoice_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]items`
--

CREATE TABLE `[[dbprefix]]items` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `item` varchar(50) NOT NULL,
  `module` varchar(50) NOT NULL,
  `instantiable` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `payable` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `searchable` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `pages` tinytext NOT NULL,
  `table_name` varchar(50) NOT NULL,
  `class_name` varchar(50) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ITEM` (`item`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=3 ;

--
-- Dumping data for table `[[dbprefix]]items`
--

INSERT INTO `[[dbprefix]]items` VALUES
(1, 'member', 'core', 1, 1, 1, 'profile,view_member', '', ''),
(2, 'transaction', 'core', 1, 0, 0, '', 'payment_transactions', '');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]items_pages`
--

CREATE TABLE `[[dbprefix]]items_pages` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `page_name` varchar(50) NOT NULL,
  `item` varchar(30) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQUE` (`page_name`,`item`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=5 ;

--
-- Dumping data for table `[[dbprefix]]items_pages`
--

INSERT INTO `[[dbprefix]]items_pages` VALUES
(1, 'profile', 'member'),
(2, 'view_member', 'member'),
(3, 'favorites', 'member'),
(4, 'registration', 'member');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]language`
--

CREATE TABLE `[[dbprefix]]language` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(64) NOT NULL,
  `original` text NOT NULL,
  `value` text NOT NULL,
  `category` enum('admin','frontend','common','page','tooltip','api') NOT NULL DEFAULT 'frontend',
  `code` char(2) NOT NULL,
  `module` varchar(40) NOT NULL,
  `api` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQUE` (`key`,`category`,`code`,`module`),
  KEY `LANG` (`code`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1530 ;

--
-- Dumping data for table `[[dbprefix]]language`
--

INSERT INTO `[[dbprefix]]language` VALUES
(1, '_action_', '- Action -', '- Action -', 'admin', 'en', '', 0),
(2, '_do_not_change_', '&lt;Do not change&gt;', '&lt;Do not change&gt;', 'admin', 'en', '', 0),
(3, '_no_parent_page_', '- no parent page -', '- no parent page -', 'admin', 'en', '', 0),
(4, '_page_removed_', '-page removed-', '-page removed-', 'admin', 'en', '', 0),
(5, 'access_denied', 'Access denied', 'Access denied', 'admin', 'en', '', 0),
(6, 'actions', 'Actions', 'Actions', 'admin', 'en', '', 0),
(7, 'action-add', 'Add action on ":page"', 'Add action on ":page"', 'admin', 'en', '', 0),
(8, 'action-config', 'Configuration on ":page"', 'Configuration on ":page"', 'admin', 'en', '', 0),
(9, 'action-delete', 'Delete action on ":page"', 'Delete action on ":page"', 'admin', 'en', '', 0),
(10, 'action-edit', 'Edit action on ":page"', 'Edit action on ":page"', 'admin', 'en', '', 0),
(11, 'action-read', 'Allow to view ":page"', 'Allow to view ":page"', 'admin', 'en', '', 0),
(12, 'action_not_allowed_since_you_only_admin', 'This action is not allowed since currently you are the only active administrator.', 'This action is not allowed since currently you are the only active administrator.', 'admin', 'en', '', 0),
(13, 'activate', 'Activate', 'Activate', 'admin', 'en', '', 0),
(14, 'add_another_one', 'Add another one', 'Add another one', 'admin', 'en', '', 0),
(15, 'add_block', 'Add Block', 'Add Block', 'admin', 'en', '', 0),
(16, 'add_currency', 'Add Currency', 'Add Currency', 'admin', 'en', '', 0),
(17, 'add_drop_table', 'Add DROP TABLE', 'Add DROP TABLE', 'admin', 'en', '', 0),
(18, 'add_field', 'Add Field', 'Add Field', 'admin', 'en', '', 0),
(19, 'add_fieldgroup', 'Add Field Group', 'Add Field Group', 'admin', 'en', '', 0),
(20, 'add_image_type', 'Add Image Type', 'Add Image Type', 'admin', 'en', '', 0),
(21, 'add_invoice', 'Add Invoice', 'Add Invoice', 'admin', 'en', '', 0),
(22, 'add_item_value', 'Add Item Value', 'Add Item Value', 'admin', 'en', '', 0),
(23, 'add_line', 'Add line', 'Add line', 'admin', 'en', '', 0),
(24, 'add_member', 'Add Member', 'Add Member', 'admin', 'en', '', 0),
(25, 'add_menu', 'Add Menu', 'Add Menu', 'admin', 'en', '', 0),
(26, 'add_new_phrase', 'Add New Phrase', 'Add New Phrase', 'admin', 'en', '', 0),
(27, 'add_new_transaction', 'Do you want to add another transaction?', 'Do you want to add another transaction?', 'admin', 'en', '', 0),
(28, 'add_one_more_phrase', 'Do you want to add one more phrase?', 'Do you want to add one more phrase?', 'admin', 'en', '', 0),
(29, 'add_page', 'Add Page', 'Add Page', 'admin', 'en', '', 0),
(30, 'add_phrase', 'Add Phrase', 'Add Phrase', 'admin', 'en', '', 0),
(31, 'add_plan', 'Add Plan', 'Add Plan', 'admin', 'en', '', 0),
(32, 'add_transaction', 'Add Transaction', 'Add Transaction', 'admin', 'en', '', 0),
(33, 'add_usergroup', 'Add Usergroup', 'Add Usergroup', 'admin', 'en', '', 0),
(34, 'add_quick_link', 'Add quick link', 'Add quick link', 'admin', 'en', '', 0),
(35, 'added_date_is_incorrect', 'Added date is incorrect.', 'Added date is incorrect.', 'admin', 'en', '', 0),
(36, 'admin_check_new_password', 'Please check your email for a confirmation link.', 'Please check your email for a confirmation link.', 'admin', 'en', '', 0),
(37, 'admin_access--read', 'Allow Access to Admin Panel', 'Allow Access to Admin Panel', 'admin', 'en', '', 0),
(38, 'admin_pages', 'Admin Panel Pages', 'Admin Panel Pages', 'admin', 'en', '', 0),
(39, 'admin_page-adminer--read', 'Allow to access Adminer script', 'Allow to access Adminer script', 'admin', 'en', '', 0),
(40, 'admin_page-blocks--edit', 'Allow to edit blocks', 'Allow to edit blocks', 'admin', 'en', '', 0),
(41, 'admin_page-blocks--html', 'Allow to create HTML blocks', 'Allow to create HTML blocks', 'admin', 'en', '', 0),
(42, 'admin_page-blocks--order', 'Allow to change blocks order', 'Allow to change blocks order', 'admin', 'en', '', 0),
(43, 'admin_page-blocks--php', 'Allow to create PHP blocks', 'Allow to create PHP blocks', 'admin', 'en', '', 0),
(44, 'admin_page-blocks--plain', 'Allow to create plain text blocks', 'Allow to create plain text blocks', 'admin', 'en', '', 0),
(45, 'admin_page-blocks--smarty', 'Allow to create Smarty blocks', 'Allow to create Smarty blocks', 'admin', 'en', '', 0),
(46, 'admin_page-blocks--visual', 'Allow to use Visual Mode', 'Allow to use Visual Mode', 'admin', 'en', '', 0),
(47, 'admin_page-configuration--edit', 'Allow to modify configuration', 'Allow to modify configuration', 'admin', 'en', '', 0),
(48, 'admin_page-configuration--read', 'Allow access to Configuration page', 'Allow access to Configuration page', 'admin', 'en', '', 0),
(49, 'admin_page-database--consistency', 'Allow access to Consistency page', 'Allow access to Consistency page', 'admin', 'en', '', 0),
(50, 'admin_page-database--export', 'Allow to export SQL dump', 'Allow to export SQL dump', 'admin', 'en', '', 0),
(51, 'admin_page-database--import', 'Allow to import dumps', 'Allow to import dumps', 'admin', 'en', '', 0),
(52, 'admin_page-database--reset', 'Allow to reset site data', 'Allow to reset site data', 'admin', 'en', '', 0),
(53, 'admin_page-database--sql', 'Allow to run SQL queries', 'Allow to run SQL queries', 'admin', 'en', '', 0),
(54, 'admin_page-fields--members', 'Allow to manage member fields', 'Allow to manage member fields', 'admin', 'en', '', 0),
(55, 'admin_page-hooks--read', 'Allow to view hooks list', 'Allow to view hooks list', 'admin', 'en', '', 0),
(56, 'admin_page-hooks--edit', 'Allow to edit a hook', 'Allow to edit a hook', 'admin', 'en', '', 0),
(57, 'admin_page-hooks--delete', 'Allow to delete a hook', 'Allow to delete a hook', 'admin', 'en', '', 0),
(58, 'admin_page-index--cache', 'Allow to drop script''s cache files', 'Allow to drop script''s cache files', 'admin', 'en', '', 0),
(59, 'admin_page-index--debugmode', 'Allow to debugmode information', 'Allow to debugmode information', 'admin', 'en', '', 0),
(60, 'admin_page-index--phpinfo', 'Allow to view phpinfo() information', 'Allow to view phpinfo() information', 'admin', 'en', '', 0),
(61, 'admin_page-index--sitemap', 'Allow to rebuild sitemap.xml file', 'Allow to rebuild sitemap.xml file', 'admin', 'en', '', 0),
(62, 'admin_page-members--read', 'Allow to view members list', 'Allow to view members list', 'admin', 'en', '', 0),
(63, 'admin_page-members--add', 'Allow to add new members', 'Allow to add new members', 'admin', 'en', '', 0),
(64, 'admin_page-members--edit', 'Allow to edit existing members', 'Allow to edit existing members', 'admin', 'en', '', 0),
(65, 'admin_page-members--password', 'Allow to change member password', 'Allow to change member password', 'admin', 'en', '', 0),
(66, 'admin_page-members--usergroup', 'Allow to change member usergroup', 'Allow to change member usergroup', 'admin', 'en', '', 0),
(67, 'admin_page-menus--add', 'Allow to add new menus', 'Allow to add new menus', 'admin', 'en', '', 0),
(68, 'admin_page-menus--edit', 'Allow to edit existing menus', 'Allow to edit existing menus', 'admin', 'en', '', 0),
(69, 'admin_page-packages--activate', 'Allow to activate package', 'Allow to activate package', 'admin', 'en', '', 0),
(70, 'admin_page-packages--install', 'Allow to install package', 'Allow to install package', 'admin', 'en', '', 0),
(71, 'admin_page-packages--set_default', 'Allow to set/reset default package', 'Allow to set/reset default package', 'admin', 'en', '', 0),
(72, 'admin_page-packages--uninstall', 'Allow to uninstall package', 'Allow to uninstall package', 'admin', 'en', '', 0),
(73, 'admin_page-packages--upgrade', 'Allow to upgrade package', 'Allow to upgrade package', 'admin', 'en', '', 0),
(74, 'admin_page-pages--add', 'Allow to add new page', 'Allow to add new page', 'admin', 'en', '', 0),
(75, 'admin_page-pages--delete', 'Allow to delete a page', 'Allow to delete a page', 'admin', 'en', '', 0),
(76, 'admin_page-pages--edit', 'Allow to modify a page', 'Allow to modify a page', 'admin', 'en', '', 0),
(77, 'admin_page-pages--home', 'Allow to change the Home page', 'Allow to change the Home page', 'admin', 'en', '', 0),
(78, 'admin_page-pages--read', 'Allow to view pages list', 'Allow to view pages list', 'admin', 'en', '', 0),
(79, 'admin_page-permissions--read', 'Allow to view member/usergroup permissions', 'Allow to view member/usergroup permissions', 'admin', 'en', '', 0),
(80, 'admin_page-permissions--edit', 'Allow to manage permissions', 'Allow to manage permissions', 'admin', 'en', '', 0),
(81, 'admin_page-plans--add', 'Allow to add new plan', 'Allow to add new plan', 'admin', 'en', '', 0),
(82, 'admin_page-plans--delete', 'Allow to delete a plan', 'Allow to delete a plan', 'admin', 'en', '', 0),
(83, 'admin_page-plans--edit', 'Allow to modify a plan', 'Allow to modify a plan', 'admin', 'en', '', 0),
(84, 'admin_page-plans--read', 'Allow to view plans list', 'Allow to view plans list', 'admin', 'en', '', 0),
(85, 'admin_page-plugins--install', 'Allow to install plugin', 'Allow to install plugin', 'admin', 'en', '', 0),
(86, 'admin_page-plugins--reinstall', 'Allow to reinstall plugin', 'Allow to reinstall plugin', 'admin', 'en', '', 0),
(87, 'admin_page-plugins--uninstall', 'Allow to uninstall plugin', 'Allow to uninstall plugin', 'admin', 'en', '', 0),
(88, 'admin_page-plugins--update', 'Allow to update plugin', 'Allow to update plugin', 'admin', 'en', '', 0),
(89, 'administrator_added', 'New administrator member created.', 'New administrator member created.', 'admin', 'en', '', 0),
(90, 'add_plugin', 'Add plugin', 'Add plugin', 'admin', 'en', '', 0),
(91, 'all_members', 'All Members', 'All Members', 'admin', 'en', '', 0),
(92, 'allowed', 'Allowed', 'Allowed', 'admin', 'en', '', 0),
(93, 'allowed_file_types', 'Allowed file types', 'Allowed file types', 'admin', 'en', '', 0),
(94, 'already_home_page', 'This page has been set as your homepage. You may not turn it off.', 'This page has been set as your homepage. You may not turn it off.', 'admin', 'en', '', 0),
(95, 'and_then', 'And then', 'And then', 'admin', 'en', '', 0),
(96, 'are_you_sure_install_module', 'Are you sure you wish to install this module?', 'Are you sure you wish to install this module?', 'admin', 'en', '', 0),
(97, 'are_you_sure_install_template', 'Are you sure you wish to install this template? Current template data will be lost. Block changes will be reset.', 'Are you sure you wish to install this template? Current template data will be lost. Block changes will be reset.', 'admin', 'en', '', 0),
(98, 'are_you_sure_reinstall_module', 'Are you sure you wish to reinstall this module? All data will be lost. You need to start from the scratch.', 'Are you sure you wish to reinstall this module? All data will be lost. You need to start from the scratch.', 'admin', 'en', '', 0),
(99, 'are_you_sure_resend_registration_email', 'This will permanently reset the current password of this member. Are you sure you want to re-send registration email?', 'This will permanently reset the current password of this member. Are you sure you want to re-send registration email?', 'admin', 'en', '', 0),
(100, 'are_you_sure_to_delete_currency', 'Are you sure to delete this currency?', 'Are you sure to delete this currency?', 'admin', 'en', '', 0),
(101, 'are_you_sure_to_delete_field', 'Are you sure to delete current field? All added information for this field will be lost.', 'Are you sure to delete current field? All added information for this field will be lost.', 'admin', 'en', '', 0),
(102, 'are_you_sure_to_delete_fieldgroup', 'Are you sure to delete selected fields group?', 'Are you sure to delete selected fields group?', 'admin', 'en', '', 0),
(103, 'are_you_sure_to_delete_selected_items', 'Are you sure you want to delete selected items?', 'Are you sure you want to delete selected items?', 'admin', 'en', '', 0),
(104, 'are_you_sure_to_delete_selected_language', 'Are you sure you want to delete selected language? Note: All phrases will be permanently lost!', 'Are you sure you want to delete selected language? Note: All phrases will be permanently lost!', 'admin', 'en', '', 0),
(105, 'are_you_sure_to_delete_selected_members', 'Are you sure you want to delete selected members?', 'Are you sure you want to delete selected members?', 'admin', 'en', '', 0),
(106, 'are_you_sure_to_delete_selected_menus', 'Are you sure you want to delete selected menus?', 'Are you sure you want to delete selected menus?', 'admin', 'en', '', 0),
(107, 'are_you_sure_to_delete_selected_pages', 'Are you sure you want to delete selected pages?', 'Are you sure you want to delete selected pages?', 'admin', 'en', '', 0),
(108, 'are_you_sure_to_delete_selected_phrases', 'Are you sure you want to delete selected phrases?', 'Are you sure you want to delete selected phrases?', 'admin', 'en', '', 0),
(109, 'are_you_sure_to_delete_this_block', 'Are you sure you want to delete this block?', 'Are you sure you want to delete this block?', 'admin', 'en', '', 0),
(110, 'are_you_sure_to_delete_this_item', 'Are you sure you want to delete this item?', 'Are you sure you want to delete this item?', 'admin', 'en', '', 0),
(111, 'are_you_sure_to_delete_this_member', 'Are you sure you want to delete this member?', 'Are you sure you want to delete this member?', 'admin', 'en', '', 0),
(112, 'are_you_sure_to_delete_this_menu', 'Are you sure you want to delete this menu?', 'Are you sure you want to delete this menu?', 'admin', 'en', '', 0),
(113, 'are_you_sure_to_delete_this_page', 'Are you sure you want to delete this page?', 'Are you sure you want to delete this page?', 'admin', 'en', '', 0),
(114, 'are_you_sure_to_delete_this_plan', 'Are you sure you want to delete this plan?', 'Are you sure you want to delete this plan?', 'admin', 'en', '', 0),
(115, 'are_you_sure_to_delete_this_transaction', 'Are you sure you want to delete this transaction?', 'Are you sure you want to delete this transaction?', 'admin', 'en', '', 0),
(116, 'are_you_sure_to_delete_this_usergroup', 'Are you sure you want to delete this usergroup? All the users of this usergroup will be assigned to the Registered usergroup.', 'Are you sure you want to delete this usergroup? All the users of this usergroup will be assigned to the Registered usergroup.', 'admin', 'en', '', 0),
(117, 'are_you_sure_to_delete_transactions', 'Are you sure you want to delete transactions?', 'Are you sure you want to delete transactions?', 'admin', 'en', '', 0),
(118, 'are_you_sure_to_uninstall_selected_plugin', 'Are you sure you wish to uninstall this plugin? Please take a note that all plugin data will be lost. This action cannot be reverted.', 'Are you sure you wish to uninstall this plugin? Please take a note that all plugin data will be lost. This action cannot be reverted.', 'admin', 'en', '', 0),
(119, 'are_you_sure_to_uninstall_selected_package', 'Are you sure you wish to uninstall this package? Please take a note that all package data will be lost. This action cannot be reverted.', 'Are you sure you wish to uninstall this package? Please take a note that all package data will be lost. This action cannot be reverted.', 'admin', 'en', '', 0),
(120, 'ascii_required', 'Only alphanumeric characters are allowed', 'Only alphanumeric characters are allowed', 'admin', 'en', '', 0),
(121, 'assignable', 'Assignable', 'Assignable', 'admin', 'en', '', 0),
(122, 'at_least_one_item_should_be_checked', 'At least one item should be selected.', 'At least one item should be selected.', 'admin', 'en', '', 0),
(123, 'available_dump_files', 'Available Dump Files', 'Available Dump Files', 'admin', 'en', '', 0),
(124, 'available_patterns', 'Available patterns', 'Available patterns', 'admin', 'en', '', 0),
(125, 'available_plugins', 'Available Plugins', 'Available Plugins', 'admin', 'en', '', 0),
(126, 'back_to_homepage', 'Back to homepage', 'Back to homepage', 'admin', 'en', '', 0),
(127, 'bad_iso_code', 'Bad country-ISO code.', 'Bad country-ISO code.', 'admin', 'en', '', 0),
(128, 'banned', 'Banned', 'Banned', 'admin', 'en', '', 0),
(129, 'body', 'Body', 'Body', 'admin', 'en', '', 0),
(130, 'body_incorrect', 'Message body or subject is empty.', 'Message body or subject is empty.', 'admin', 'en', '', 0),
(131, 'block_contents', 'Contents', 'Contents', 'admin', 'en', '', 0),
(132, 'block_created', 'Block created.', 'Block created.', 'admin', 'en', '', 0),
(133, 'block_type_tip_html', 'HTML type is used for formatted HTML display. You can use WYSIWYG editor for your block content. This block can be also used for JavaScript code, but you <span style="color: red;">need to paste it in SOURCE mode</span>', 'HTML type is used for formatted HTML display. You can use WYSIWYG editor for your block content. This block can be also used for JavaScript code, but you <span style="color: red;">need to paste it in SOURCE mode</span>', 'admin', 'en', '', 0),
(134, 'block_type_tip_php', 'PHP is used to have php code in your block content.', 'PHP is used to have php code in your block content.', 'admin', 'en', '', 0),
(135, 'block_type_tip_plain', 'Plain type is used when you wish to display simple information. It will be displayed as is with escaping HTML tags.', 'Plain type is used when you wish to display simple information. It will be displayed as is with escaping HTML tags.', 'admin', 'en', '', 0),
(136, 'block_type_tip_smarty', 'Smarty type block is used for smarty code. You can get more information about Smarty template engine here: <a target="_blank" href="http://www.smarty.net">http://www.smarty.net</a>', 'Smarty type block is used for smarty code. You can get more information about Smarty template engine here: <a target="_blank" href="http://www.smarty.net">http://www.smarty.net</a>', 'admin', 'en', '', 0),
(137, 'block_visible_everywhere', 'Visible everywhere', 'Visible everywhere', 'admin', 'en', '', 0),
(138, 'block_visibility_exceptions_visible', 'Choose where block will be explicitly <b>visible</b>', 'Choose where block will be explicitly <b>visible</b>', 'admin', 'en', '', 0),
(139, 'block_visibility_exceptions_hidden', 'Choose where block will be explicitly <b>hidden</b>', 'Choose where block will be explicitly <b>hidden</b>', 'admin', 'en', '', 0),
(140, 'blocks', 'Blocks', 'Blocks', 'admin', 'en', '', 0),
(141, 'bug_report', 'Bug Report', 'Bug Report', 'admin', 'en', '', 0),
(142, 'buy', 'Buy', 'Buy', 'admin', 'en', '', 0),
(143, 'buy_before_install', 'You need to purchase this plugin in order to install it.', 'You need to purchase this plugin in order to install it.', 'admin', 'en', '', 0),
(144, 'cache_dropped', 'Cache has been dropped.', 'Cache has been dropped.', 'admin', 'en', '', 0),
(145, 'cant_open_incorrect_format', 'Could not open file with SQL instructions: :filename. Only .sql files are allowed.', 'Could not open file with SQL instructions: :filename. Only .sql files are allowed.', 'admin', 'en', '', 0),
(146, 'cant_open_sql', 'Could not open file with SQL instructions: :filename', 'Could not open file with SQL instructions: :filename', 'admin', 'en', '', 0),
(147, 'cant_write_sql', 'Could not write to file :filename.', 'Could not write to file :filename.', 'admin', 'en', '', 0),
(148, 'calendar_dow', 'S,M,T,W,T,F,S', 'S,M,T,W,T,F,S', 'admin', 'en', '', 0),
(149, 'calendar_ml', 'January,February,March,April,May,June,July,August,September,October,November,December', 'January,February,March,April,May,June,July,August,September,October,November,December', 'admin', 'en', '', 0),
(150, 'calendar_ms', 'Jan,Feb,Mar,Apr,May,Jun,Jul,Aug,Sep,Oct,Nov,Dec', 'Jan,Feb,Mar,Apr,May,Jun,Jul,Aug,Sep,Oct,Nov,Dec', 'admin', 'en', '', 0),
(151, 'change_status_to', 'On expiration change status to', 'On expiration change status to', 'admin', 'en', '', 0),
(152, 'change_usergroup_to', 'Change usergroup to ... after plan change', 'Change usergroup to ... after plan change', 'admin', 'en', '', 0),
(153, 'changelog', 'Changelog', 'Changelog', 'admin', 'en', '', 0),
(154, 'changelog_added', 'New Features', 'New Features', 'admin', 'en', '', 0),
(155, 'changelog_bugfixes', 'Bugfixes', 'Bugfixes', 'admin', 'en', '', 0),
(156, 'changelog_modified', 'Improvements', 'Improvements', 'admin', 'en', '', 0),
(157, 'changelog_other', 'Other Changes', 'Other Changes', 'admin', 'en', '', 0),
(158, 'chars_left', 'characters left', 'characters left', 'admin', 'en', '', 0),
(159, 'checkboxes', 'Checkboxes', 'Checkboxes', 'admin', 'en', '', 0),
(160, 'consistency', 'Consistency', 'Consistency', 'admin', 'en', '', 0),
(161, 'choose_import_file', 'Please choose a file to be imported.', 'Please choose a file to be imported.', 'admin', 'en', '', 0),
(162, 'choose_item', 'Choose item', 'Choose item', 'admin', 'en', '', 0),
(163, 'clear', 'Clear', 'Clear', 'admin', 'en', '', 0),
(164, 'clear_confirm', 'Are you sure you want to clear your form?', 'Are you sure you want to clear your form?', 'admin', 'en', '', 0),
(165, 'clear_default', 'Clear default value', 'Clear default value', 'admin', 'en', '', 0),
(166, 'clear_reset', 'Are you sure you wish to clear all your data? Note this operation is irreversible and all your items data will be lost.', 'Are you sure you wish to clear all your data? Note this operation is irreversible and all your items data will be lost.', 'admin', 'en', '', 0),
(167, 'closing_window_with_unsaved_changes', 'You are closing a window that has unsaved changes. Would you like to save your changes?', 'You are closing a window that has unsaved changes. Would you like to save your changes?', 'admin', 'en', '', 0),
(168, 'collapsible', 'Collapsible', 'Collapsible', 'admin', 'en', '', 0),
(169, 'config_debug_pass', 'Debug password', 'Debug password', 'admin', 'en', '', 0),
(170, 'config_tmpl', 'Frontend theme', 'Frontend theme', 'admin', 'en', '', 0),
(171, 'config_backup', 'Directory for database backups', 'Directory for database backups', 'admin', 'en', '', 0),
(172, 'config_cron', 'Cron', 'Cron', 'admin', 'en', '', 0),
(173, 'config_admin_tmpl', 'Admin Panel theme', 'Admin Panel theme', 'admin', 'en', '', 0),
(174, 'config_default_package', 'Default package', 'Default package', 'admin', 'en', '', 0),
(175, 'config_tmpl_rollback_data', 'Previous template restoration data', 'Previous template restoration data', 'admin', 'en', '', 0),
(176, 'config_tmpl_layout_data', 'Template layout information', 'Template layout information', 'admin', 'en', '', 0),
(177, 'config_site', 'Site title', 'Site title', 'admin', 'en', '', 0),
(178, 'config_bc_home', 'Breadcrumb first element', 'Breadcrumb first element', 'admin', 'en', '', 0),
(179, 'config_suffix', 'Suffix for page titles', 'Suffix for page titles', 'admin', 'en', '', 0),
(180, 'config_site_logo', 'Website logo', 'Website logo', 'admin', 'en', '', 0),
(181, 'config_site_favicon', 'Website favicon', 'Website favicon', 'admin', 'en', '', 0),
(182, 'config_lang', 'Default language', 'Default language', 'admin', 'en', '', 0),
(183, 'config_language_switch', 'Language switching', 'Language switching', 'admin', 'en', '', 0),
(184, 'config_timezone', 'Default timezone', 'Default timezone', 'admin', 'en', '', 0),
(185, 'config_members_enabled', 'Members functionality', 'Members functionality', 'admin', 'en', '', 0),
(186, 'config_members_autoapproval', 'Members auto-approval', 'Members auto-approval', 'admin', 'en', '', 0),
(187, 'config_members_per_page', 'Members per page', 'Members per page', 'admin', 'en', '', 0),
(188, 'config_hybrid_enabled', 'Enable HybridAuth', 'Enable HybridAuth', 'admin', 'en', '', 0),
(189, 'config_hybrid_debug_mode', 'Debug mode', 'Debug mode', 'admin', 'en', '', 0),
(190, 'config_gravatar_enabled', 'Enable Gravatars', 'Enable Gravatars', 'admin', 'en', '', 0),
(191, 'config_gravatar_size', 'Size', 'Size', 'admin', 'en', '', 0),
(192, 'config_gravatar_type', 'Image type', 'Image type', 'admin', 'en', '', 0),
(193, 'config_gravatar_rating', 'Rating', 'Rating', 'admin', 'en', '', 0),
(194, 'config_gravatar_default_image', 'Default image', 'Default image', 'admin', 'en', '', 0),
(195, 'config_site_email', 'Default site email', 'Default site email', 'admin', 'en', '', 0),
(196, 'config_bcc_email', 'BCC auto emails to', 'BCC auto emails to', 'admin', 'en', '', 0),
(197, 'config_site_from_name', 'Default mail name', 'Default mail name', 'admin', 'en', '', 0),
(198, 'config_default_email_signature', 'Default mail signature', 'Default mail signature', 'admin', 'en', '', 0),
(199, 'config_mail_function', 'Mail method', 'Mail method', 'admin', 'en', '', 0),
(200, 'config_mail_test', 'Send test email', 'Send test email', 'admin', 'en', '', 0),
(201, 'config_smtp_debug', 'SMTP Debug', 'SMTP Debug', 'admin', 'en', '', 0),
(202, 'config_smtp_debug_output', 'SMTP Debug Output', 'SMTP Debug Output', 'admin', 'en', '', 0),
(203, 'config_smtp_auth', 'SMTP Authentication', 'SMTP Authentication', 'admin', 'en', '', 0),
(204, 'config_smtp_server', 'SMTP Server', 'SMTP Server', 'admin', 'en', '', 0),
(205, 'config_smtp_port', 'SMTP Port', 'SMTP Port', 'admin', 'en', '', 0),
(206, 'config_smtp_secure', 'SMTP Secure', 'SMTP Secure', 'admin', 'en', '', 0),
(207, 'config_smtp_user', 'SMTP Server Username', 'SMTP Server Username', 'admin', 'en', '', 0),
(208, 'config_smtp_password', 'SMTP Server Password', 'SMTP Server Password', 'admin', 'en', '', 0),
(209, 'config_sendmail_path', 'Path to sendmail ', 'Path to sendmail ', 'admin', 'en', '', 0),
(210, 'config_mimetype', 'Send HTML mime-type emails instead of plain text', 'Send HTML mime-type emails instead of plain text', 'admin', 'en', '', 0),
(211, 'config_baseurl', 'Site URL', 'Site URL', 'admin', 'en', '', 0),
(212, 'config_admin_page', 'Admin Dashboard URL', 'Admin Dashboard URL', 'admin', 'en', '', 0),
(213, 'config_https', 'HTTPS', 'HTTPS', 'admin', 'en', '', 0),
(214, 'config_frontend', 'Display frontend', 'Display frontend', 'admin', 'en', '', 0),
(215, 'config_underconstruction', 'Under construction message', 'Under construction message', 'admin', 'en', '', 0),
(216, 'config_display_feedbacks', 'Feedbacks panel display', 'Feedbacks panel display', 'admin', 'en', '', 0),
(217, 'config_display_changelog', 'Changelog panel display', 'Changelog panel display', 'admin', 'en', '', 0),
(218, 'config_display_twitter', 'Twitter in Dashboard', 'Twitter in Dashboard', 'admin', 'en', '', 0),
(219, 'config_check_for_updates', 'Check for updates', 'Check for updates', 'admin', 'en', '', 0),
(220, 'config_auto_apply_critical_upgrades', 'Automatically apply critical upgrades', 'Automatically apply critical upgrades', 'admin', 'en', '', 0),
(221, 'config_allow_remote_templates', 'Allow remote templates', 'Allow remote templates', 'admin', 'en', '', 0),
(222, 'config_sap_style', 'Default colors scheme', 'Default colors scheme', 'admin', 'en', '', 0),
(223, 'config_alias_urlencode', 'Encode non-Latin symbols in URL', 'Encode non-Latin symbols in URL', 'admin', 'en', '', 0),
(224, 'config_redirect_time', 'Redirect time (ms)', 'Redirect time (ms)', 'admin', 'en', '', 0),
(225, 'config_prevent_csrf', 'Prevent CSRF attack', 'Prevent CSRF attack', 'admin', 'en', '', 0),
(226, 'config_caching', 'Caching', 'Caching', 'admin', 'en', '', 0),
(227, 'config_smarty_cache', 'Smarty force compile', 'Smarty force compile', 'admin', 'en', '', 0),
(228, 'config_compress_html', 'Compress HTML', 'Compress HTML', 'admin', 'en', '', 0),
(229, 'config_compress_js', 'Compress Javascript', 'Compress Javascript', 'admin', 'en', '', 0),
(230, 'config_thumb_w', 'Thumbnails default width', 'Thumbnails default width', 'admin', 'en', '', 0),
(231, 'config_thumb_h', 'Thumbnails default height', 'Thumbnails default height', 'admin', 'en', '', 0),
(232, 'config_watermark', 'Enable', 'Enable', 'admin', 'en', '', 0),
(233, 'config_watermark_position', 'Position', 'Position', 'admin', 'en', '', 0),
(234, 'config_watermark_opacity', 'Opacity', 'Opacity', 'admin', 'en', '', 0),
(235, 'config_watermark_type', 'Type', 'Type', 'admin', 'en', '', 0),
(236, 'config_watermark_text', 'Text', 'Text', 'admin', 'en', '', 0),
(237, 'config_watermark_text_color', 'Text RGB color', 'Text RGB color', 'admin', 'en', '', 0),
(238, 'config_watermark_text_size', 'Text size', 'Text size', 'admin', 'en', '', 0),
(239, 'config_watermark_image', 'Image', 'Image', 'admin', 'en', '', 0),
(240, 'config_pictures_general', 'General', 'General', 'admin', 'en', '', 0),
(241, 'config_image_quality', 'Image quality (%)', 'Image quality (%)', 'admin', 'en', '', 0),
(242, 'config_allow_animated_gifs', 'Allow animated GIF images', 'Allow animated GIF images', 'admin', 'en', '', 0),
(243, 'config_lightbox', 'Lightbox', 'Lightbox', 'admin', 'en', '', 0),
(244, 'config_lightbox_name', 'Lightbox name', 'Lightbox name', 'admin', 'en', '', 0),
(245, 'config_', 'Frontend code integration', 'Frontend code integration', 'admin', 'en', '', 0),
(246, 'config_frontend_header_code', 'Code before closing HEAD tag', 'Code before closing HEAD tag', 'admin', 'en', '', 0),
(247, 'config_frontend_footer_code', 'Code before closing BODY tag', 'Code before closing BODY tag', 'admin', 'en', '', 0),
(248, 'config_opengraph_description', 'OG default description', 'OG default description', 'admin', 'en', '', 0),
(249, 'config_opengraph_image', 'OG default image', 'OG default image', 'admin', 'en', '', 0),
(250, 'config_ckeditor_skin', 'Skin', 'Skin', 'admin', 'en', '', 0),
(251, 'config_captcha', 'Captcha', 'Captcha', 'admin', 'en', '', 0),
(252, 'config_captcha_name', 'Captcha name', 'Captcha name', 'admin', 'en', '', 0),
(253, 'config_captcha_preview', 'Captcha preview', 'Captcha preview', 'admin', 'en', '', 0),
(254, 'config_search_instant', 'Instant search', 'Instant search', 'admin', 'en', '', 0),
(255, 'config_maps_api_key', 'Maps API key', 'Maps API key', 'admin', 'en', '', 0),
(256, 'config_currency_switch', 'Currency switching', 'Currency switching', 'admin', 'en', '', 0),
(257, 'config_funds_min_deposit', 'Minimum deposit', 'Minimum deposit', 'admin', 'en', '', 0),
(258, 'config_funds_max_deposit', 'Maximum deposit', 'Maximum deposit', 'admin', 'en', '', 0),
(259, 'config_funds_max', 'Maximum balance', 'Maximum balance', 'admin', 'en', '', 0),
(260, 'config_api_enabled', 'API enabled', 'API enabled', 'admin', 'en', '', 0),
(261, 'config_api_push_access_key', 'GCM access key', 'GCM access key', 'admin', 'en', '', 0),
(262, 'config_api_token', 'Permanent API token', 'Permanent API token', 'admin', 'en', '', 0),
(263, 'config_empty_password', '-empty password-', '-empty password-', 'admin', 'en', '', 0),
(264, 'config_empty_value', '-empty value-', '-empty value-', 'admin', 'en', '', 0),
(265, 'config_groups', 'Configuration Groups', 'Configuration Groups', 'admin', 'en', '', 0),
(266, 'config_group_api', 'API', 'API', 'admin', 'en', '', 0),
(267, 'config_group_financial', 'Financial', 'Financial', 'admin', 'en', '', 0),
(268, 'config_group_general', 'General', 'General', 'admin', 'en', '', 0),
(269, 'config_group_mail', 'Mail', 'Mail', 'admin', 'en', '', 0),
(270, 'config_group_members', 'Members', 'Members', 'admin', 'en', '', 0),
(271, 'config_group_miscellaneous', 'Miscellaneous', 'Miscellaneous', 'admin', 'en', '', 0),
(272, 'config_group_pictures', 'Pictures', 'Pictures', 'admin', 'en', '', 0),
(273, 'config_group_system', 'System', 'System', 'admin', 'en', '', 0),
(274, 'config_set_custom', 'Set custom value', 'Set custom value', 'admin', 'en', '', 0),
(275, 'config_set_default', 'Set default value', 'Set default value', 'admin', 'en', '', 0),
(276, 'configuration', 'Configuration', 'Configuration', 'admin', 'en', '', 0),
(277, 'contents', 'Contents', 'Contents', 'admin', 'en', '', 0),
(278, 'compare', 'Compare', 'Compare', 'admin', 'en', '', 0),
(279, 'compatibility', 'Min core', 'Min core', 'admin', 'en', '', 0),
(280, 'complete_inserts', 'Complete Inserts', 'Complete Inserts', 'admin', 'en', '', 0),
(281, 'copy_master_language_to', 'Copy master language [<b>:lang</b>] to ', 'Copy master language [<b>:lang</b>] to ', 'admin', 'en', '', 0),
(282, 'copy_language', 'Copy Language', 'Copy Language', 'admin', 'en', '', 0),
(283, 'copy_privileges_from', 'Copy Privileges From', 'Copy Privileges From', 'admin', 'en', '', 0),
(284, 'core', 'Core', 'Core', 'admin', 'en', '', 0),
(285, 'core_and_db_versions_mismatch', 'DB and core files versions mismatch.', 'DB and core files versions mismatch.', 'admin', 'en', '', 0),
(286, 'cost', 'Cost', 'Cost', 'admin', 'en', '', 0),
(287, 'created', 'Created.', 'Created.', 'admin', 'en', '', 0),
(288, 'created_date', 'Created date', 'Created date', 'admin', 'en', '', 0),
(289, 'crop', 'Crop', 'Crop', 'admin', 'en', '', 0),
(290, 'crop_tip', 'The mod will attempt to fit the image inside the &quot;frame&quot; created by the width and height arguments.', 'The mod will attempt to fit the image inside the &quot;frame&quot; created by the width and height arguments.', 'admin', 'en', '', 0),
(291, 'css_class_name', 'CSS class name', 'CSS class name', 'admin', 'en', '', 0),
(292, 'csv_format', 'CSV format', 'CSV format', 'admin', 'en', '', 0),
(293, 'currency_symbol', 'Currency symbol', 'Currency symbol', 'admin', 'en', '', 0),
(294, 'currency_symbol_position_after', 'after the price', 'after the price', 'admin', 'en', '', 0),
(295, 'currency_symbol_position_before', 'before the price', 'before the price', 'admin', 'en', '', 0),
(296, 'current_home_page', 'Current homepage', 'Current homepage', 'admin', 'en', '', 0),
(297, 'custom', 'Custom', 'Custom', 'admin', 'en', '', 0),
(298, 'custom_configuration_title', ':settings configuration for :type ":title"', ':settings configuration for :type ":title"', 'admin', 'en', '', 0),
(299, 'custom_modification', 'Custom Modification', 'Custom Modification', 'admin', 'en', '', 0),
(300, 'custom_template', 'Use custom tpl', 'Use custom tpl', 'admin', 'en', '', 0),
(301, 'custom_template_filename', 'Template filename', 'Template filename', 'admin', 'en', '', 0),
(302, 'custom_perm', 'Custom Permissions', 'Custom Permissions', 'admin', 'en', '', 0),
(303, 'custom_url', 'Custom URL', 'Custom URL', 'admin', 'en', '', 0),
(304, 'customize', 'Customize', 'Customize', 'admin', 'en', '', 0),
(305, 'customization_mode_alert', 'You are in customization mode. Do not forget to save your changes.', 'You are in customization mode. Do not forget to save your changes.', 'admin', 'en', '', 0),
(306, 'cycles', 'cycles', 'cycles', 'admin', 'en', '', 0),
(307, 'dashboard', 'Dashboard', 'Dashboard', 'admin', 'en', '', 0),
(308, 'date_added', 'Date Added', 'Date Added', 'admin', 'en', '', 0),
(309, 'date_created', 'Date Created', 'Date Created', 'admin', 'en', '', 0),
(310, 'date_due', 'Date Due', 'Date Due', 'admin', 'en', '', 0),
(311, 'date_modified', 'Date Modified', 'Date Modified', 'admin', 'en', '', 0),
(312, 'day', 'day', 'day', 'admin', 'en', '', 0),
(313, 'days', 'days', 'days', 'admin', 'en', '', 0),
(314, 'days_ago', ':days days ago', ':days days ago', 'admin', 'en', '', 0),
(315, 'deactivate', 'Deactivate', 'Deactivate', 'admin', 'en', '', 0),
(316, 'deactivated', 'Deactivated', 'Deactivated', 'admin', 'en', '', 0),
(317, 'debug_mode', 'Debug Mode', 'Debug Mode', 'admin', 'en', '', 0),
(318, 'debug_mode_activated', 'Debug mode activated for you.', 'Debug mode activated for you.', 'admin', 'en', '', 0),
(319, 'decimal_point', 'Decimal point', 'Decimal point', 'admin', 'en', '', 0),
(320, 'default_language', 'Default Language', 'Default Language', 'admin', 'en', '', 0),
(321, 'digits_only', 'digits only (1-255), default is 255', 'digits only (1-255), default is 255', 'admin', 'en', '', 0),
(322, 'directory_not_writable', 'Directory ":directory" is not writable. You could not save to server.', 'Directory ":directory" is not writable. You could not save to server.', 'admin', 'en', '', 0),
(323, 'display', 'Display', 'Display', 'admin', 'en', '', 0),
(324, 'do', 'Do', 'Do', 'admin', 'en', '', 0),
(325, 'documentation', 'Documentation', 'Documentation', 'admin', 'en', '', 0),
(326, 'documentation_not_available', 'Data for this module is not available.', 'Data for this module is not available.', 'admin', 'en', '', 0),
(327, 'drag_to_reorder', 'Drag to re-order', 'Drag to re-order', 'admin', 'en', '', 0),
(328, 'dropdown', 'Dropdown', 'Dropdown', 'admin', 'en', '', 0),
(329, 'duration', 'Duration', 'Duration', 'admin', 'en', '', 0),
(330, 'editable', 'Editable', 'Editable', 'admin', 'en', '', 0),
(331, 'edit_block', 'Edit Block', 'Edit Block', 'admin', 'en', '', 0),
(332, 'edit_currency', 'Edit Currency ":currency"', 'Edit Currency ":currency"', 'admin', 'en', '', 0),
(333, 'edit_field', 'Edit Field ":field"', 'Edit Field ":field"', 'admin', 'en', '', 0),
(334, 'edit_fieldgroup', 'Edit Field Group', 'Edit Field Group', 'admin', 'en', '', 0),
(335, 'edit_image_type', 'Edit Image Type', 'Edit Image Type', 'admin', 'en', '', 0),
(336, 'edit_invoice', 'Edit Invoice', 'Edit Invoice', 'admin', 'en', '', 0),
(337, 'edit_language', 'Edit Language', 'Edit Language', 'admin', 'en', '', 0),
(338, 'edit_member', 'Edit Member', 'Edit Member', 'admin', 'en', '', 0),
(339, 'edit_menu', 'Edit Menu', 'Edit Menu', 'admin', 'en', '', 0),
(340, 'edit_page', 'Edit Page', 'Edit Page', 'admin', 'en', '', 0),
(341, 'edit_page_title', 'Edit page title', 'Edit page title', 'admin', 'en', '', 0),
(342, 'edit_plan', 'Edit Plan', 'Edit Plan', 'admin', 'en', '', 0),
(343, 'edit_phrase', 'Edit Phrase', 'Edit Phrase', 'admin', 'en', '', 0),
(344, 'edit_phrases', 'edit phrases', 'edit phrases', 'admin', 'en', '', 0),
(345, 'email_template_member_templates', 'Member templates', 'Member templates', 'admin', 'en', '', 0),
(346, 'email_template_member_approved', 'Member approval', 'Member approval', 'admin', 'en', '', 0),
(347, 'email_template_member_disapproved', 'Member cancellation', 'Member cancellation', 'admin', 'en', '', 0),
(348, 'email_template_member_registration', 'Member registration', 'Member registration', 'admin', 'en', '', 0),
(349, 'email_template_member_registration_social', 'Member registration via social login', 'Member registration via social login', 'admin', 'en', '', 0),
(350, 'email_template_member_registration_notification', 'Member created by admin', 'Member created by admin', 'admin', 'en', '', 0),
(351, 'email_template_member_registration_admin', 'Administrator''s notification on member registration', 'Administrator''s notification on member registration', 'admin', 'en', '', 0),
(352, 'email_template_member_removal', 'Member removal', 'Member removal', 'admin', 'en', '', 0),
(353, 'email_template_password_restoration', 'Member password restoration', 'Member password restoration', 'admin', 'en', '', 0),
(354, 'email_template_password_changement', 'Member password change', 'Member password change', 'admin', 'en', '', 0),
(355, 'email_template_financial_templates', 'Financial templates', 'Financial templates', 'admin', 'en', '', 0),
(356, 'email_template_plan_activated', 'Item paid and activated', 'Item paid and activated', 'admin', 'en', '', 0),
(357, 'email_template_plan_expired', 'Paid item expired', 'Paid item expired', 'admin', 'en', '', 0),
(358, 'email_template_transaction_paid', 'Transaction passed', 'Transaction passed', 'admin', 'en', '', 0),
(359, 'email_template_transaction_paid_admin', 'Administrator''s notification on payment completion', 'Administrator''s notification on payment completion', 'admin', 'en', '', 0),
(360, 'email_template_invoice_created', 'Invoice created', 'Invoice created', 'admin', 'en', '', 0),
(361, 'email_templates', 'Email Templates', 'Email Templates', 'admin', 'en', '', 0),
(362, 'email_templates_tags', 'Email Template Tags', 'Email Template Tags', 'admin', 'en', '', 0),
(363, 'email_templates_tags_info', 'You can use these tags in your email templates. They will be changed to real information while sending email templates.', 'You can use these tags in your email templates. They will be changed to real information while sending email templates.', 'admin', 'en', '', 0),
(364, 'empty', '-empty-', '-empty-', 'admin', 'en', '', 0),
(365, 'empty_field', 'Empty field text', 'Empty field text', 'admin', 'en', '', 0),
(366, 'enable_no_follow', 'Enable No-Follow', 'Enable No-Follow', 'admin', 'en', '', 0),
(367, 'enable_template_sending', 'Enable sending', 'Enable sending', 'admin', 'en', '', 0),
(368, 'enter_external_url', 'Enter External URL', 'Enter External URL', 'admin', 'en', '', 0),
(369, 'error_block_name', 'Please input correct block name. It should be alpha numeric.', 'Please input correct block name. It should be alpha numeric.', 'admin', 'en', '', 0),
(370, 'error_block_name_duplicate', 'Please change block name. There is a block with the same name in the database.', 'Please change block name. There is a block with the same name in the database.', 'admin', 'en', '', 0),
(371, 'error_compare_same_languages', 'No way to compare same languages.', 'No way to compare same languages.', 'admin', 'en', '', 0),
(372, 'error_contents', 'Content field is empty.', 'Content field is empty.', 'admin', 'en', '', 0),
(373, 'error_fieldgroup_duplicate', 'Please change name. There is a field group with the same name for the same item.', 'Please change name. There is a field group with the same name for the same item.', 'admin', 'en', '', 0),
(374, 'error_filename', 'Filename field is empty.', 'Filename field is empty.', 'admin', 'en', '', 0),
(375, 'error_incorrect_dimensions', 'Set correct image dimensions.', 'Set correct image dimensions.', 'admin', 'en', '', 0),
(376, 'error_incorrect_format_from_subrion', 'The module files are in the incorrect format. Please contact the Subrion team.', 'The module files are in the incorrect format. Please contact the Subrion team.', 'admin', 'en', '', 0),
(377, 'error_file_type', 'You need to set allowed file extensions.', 'You need to set allowed file extensions.', 'admin', 'en', '', 0),
(378, 'error_incorrect_response_from_subrion', 'No response from subrion.org website. Please try again later or contact the Subrion team.', 'No response from subrion.org website. Please try again later or contact the Subrion team.', 'admin', 'en', '', 0),
(379, 'error_install_plugin', 'There is a problem while installing :plugin plugin. Please contact support team.', 'There is a problem while installing :plugin plugin. Please contact support team.', 'admin', 'en', '', 0),
(380, 'error_lang_contents', 'Content is empty for ":lang" language. Please input correct content.', 'Content is empty for ":lang" language. Please input correct content.', 'admin', 'en', '', 0),
(381, 'error_lang_description', 'Description is empty for ":lang" language. Please input correct description.', 'Description is empty for ":lang" language. Please input correct description.', 'admin', 'en', '', 0),
(382, 'error_lang_title', 'Title is empty for ":lang" language. Please input correct title.', 'Title is empty for ":lang" language. Please input correct title.', 'admin', 'en', '', 0),
(383, 'error_plan_not_exists', 'Plan does not exist.', 'Plan does not exist.', 'admin', 'en', '', 0),
(384, 'error_plan_duration', 'Please set correct duration for this plan.', 'Please set correct duration for this plan.', 'admin', 'en', '', 0),
(385, 'error_usergroup_incorrect', 'Name is incorrect. Please input correct name for the usergroup.', 'Name is incorrect. Please input correct name for the usergroup.', 'admin', 'en', '', 0),
(386, 'error_usergroup_exists', 'This group already exists. Please input different usergroup title.', 'This group already exists. Please input different usergroup title.', 'admin', 'en', '', 0),
(387, 'error_while_doc_tabs', 'Unknown error while fetching documentation tabs.', 'Unknown error while fetching documentation tabs.', 'admin', 'en', '', 0),
(388, 'exchange_rate', 'Exchange rate', 'Exchange rate', 'admin', 'en', '', 0),
(389, 'external_url', 'External URL', 'External URL', 'admin', 'en', '', 0),
(390, 'export', 'Export', 'Export', 'admin', 'en', '', 0),
(391, 'external_file', 'External File', 'External File', 'admin', 'en', '', 0),
(392, 'export_language', 'Export Language', 'Export Language', 'admin', 'en', '', 0),
(393, 'export_not_checked', 'You have not chosen what to export.', 'You have not chosen what to export.', 'admin', 'en', '', 0),
(394, 'export_tables_incorrect', 'Incorrect export tables.', 'Incorrect export tables.', 'admin', 'en', '', 0),
(395, 'export_to_excel', 'Export to Excel', 'Export to Excel', 'admin', 'en', '', 0),
(396, 'extra_actions', 'Extra actions', 'Extra actions', 'admin', 'en', '', 0),
(397, 'feature_request', 'New Feature Request', 'New Feature Request', 'admin', 'en', '', 0),
(398, 'featured_end', 'Featured end', 'Featured end', 'admin', 'en', '', 0),
(399, 'fee_based', 'Fee based', 'Fee based', 'admin', 'en', '', 0),
(400, 'feedback_terms', 'If you have any ideas how to improve our software, found a bug or want to request custom modification you are welcome to use this feedback form. We will log all your requests in our database.', 'If you have any ideas how to improve our software, found a bug or want to request custom modification you are welcome to use this feedback form. We will log all your requests in our database.', 'admin', 'en', '', 0),
(401, 'field_added', 'Field added.', 'Field added.', 'admin', 'en', '', 0),
(402, 'field_tooltip', 'Field Tooltip', 'Field Tooltip', 'admin', 'en', '', 0),
(403, 'field_default', 'Field default value', 'Field default value', 'admin', 'en', '', 0),
(404, 'field_deleted', 'Field deleted.', 'Field deleted.', 'admin', 'en', '', 0),
(405, 'field_element_children', 'Configure item fields for this value', 'Configure item fields for this value', 'admin', 'en', '', 0),
(406, 'field_exists', 'Field already exists.', 'Field already exists.', 'admin', 'en', '', 0),
(407, 'field_length', 'Field length', 'Field length', 'admin', 'en', '', 0),
(408, 'field_name_exists', 'This name can not be chosen for selected item.', 'This name can not be chosen for selected item.', 'admin', 'en', '', 0),
(409, 'field_name_restricted', 'This name is reserved for system use. Please change it.', 'This name is reserved for system use. Please change it.', 'admin', 'en', '', 0),
(410, 'field_name_invalid', 'Field name should consist of letters and numbers only. Length 2-60.', 'Field name should consist of letters and numbers only. Length 2-60.', 'admin', 'en', '', 0),
(411, 'field_relation', 'Field relation', 'Field relation', 'admin', 'en', '', 0),
(412, 'field_relation_dependent', 'Dependent field', 'Dependent field', 'admin', 'en', '', 0),
(413, 'field_relation_parent', 'Parent field', 'Parent field', 'admin', 'en', '', 0),
(414, 'field_relation_regular', 'Regular field', 'Regular field', 'admin', 'en', '', 0),
(415, 'field_required', '<span class="text-danger">*</span>', '<span class="text-danger">*</span>', 'admin', 'en', '', 0),
(416, 'field_values', 'Field values', 'Field values', 'admin', 'en', '', 0),
(417, 'fieldgroup_added', 'Field group added.', 'Field group added.', 'admin', 'en', '', 0),
(418, 'fieldgroup_deleted', 'Field group deleted.', 'Field group deleted.', 'admin', 'en', '', 0),
(419, 'field_group', 'Field group', 'Field group', 'admin', 'en', '', 0),
(420, 'field_groups', 'Field Groups', 'Field Groups', 'admin', 'en', '', 0),
(421, 'field_type', 'Field type', 'Field type', 'admin', 'en', '', 0),
(422, 'field_type_checkbox', 'Checkboxes Set', 'Checkboxes Set', 'admin', 'en', '', 0),
(423, 'field_type_combo', 'Dropdown List', 'Dropdown List', 'admin', 'en', '', 0),
(424, 'field_type_currency', 'Currency', 'Currency', 'admin', 'en', '', 0),
(425, 'field_type_date', 'Date Input Field', 'Date Input Field', 'admin', 'en', '', 0),
(426, 'field_type_iconpicker', 'Iconpicker', 'Iconpicker', 'admin', 'en', '', 0),
(427, 'field_type_image', 'Single Image Upload', 'Single Image Upload', 'admin', 'en', '', 0),
(428, 'field_type_number', 'Number Input', 'Number Input', 'admin', 'en', '', 0),
(429, 'field_type_pictures', 'Multiple Images Upload', 'Multiple Images Upload', 'admin', 'en', '', 0),
(430, 'field_type_radio', 'Radio Buttons Set', 'Radio Buttons Set', 'admin', 'en', '', 0),
(431, 'field_type_storage', 'Upload Attachment', 'Upload Attachment', 'admin', 'en', '', 0),
(432, 'field_type_text', 'Single Line Text Input', 'Single Line Text Input', 'admin', 'en', '', 0),
(433, 'field_type_textarea', 'Multiline Textarea', 'Multiline Textarea', 'admin', 'en', '', 0),
(434, 'field_type_url', 'URL Text Input', 'URL Text Input', 'admin', 'en', '', 0),
(435, 'field_type_tree', 'Tree', 'Tree', 'admin', 'en', '', 0),
(436, 'field_type_tip_checkbox', 'This field allows multiple values selection.', 'This field allows multiple values selection.', 'admin', 'en', '', 0),
(437, 'field_type_tip_combo', 'This field will be displayed as dropdown select box.', 'This field will be displayed as dropdown select box.', 'admin', 'en', '', 0),
(438, 'field_type_tip_date', 'This field adds calendar control to set the date.', 'This field adds calendar control to set the date.', 'admin', 'en', '', 0),
(439, 'field_type_tip_iconpicker', 'Allows to assign icon from Font Awesome.', 'Allows to assign icon from Font Awesome.', 'admin', 'en', '', 0),
(440, 'field_type_tip_image', 'This field value will be displayed as an image.', 'This field value will be displayed as an image.', 'admin', 'en', '', 0),
(441, 'field_type_tip_number', 'This field can be searched by interval on Advanced Search page. Two inputs are created to set start and end values.', 'This field can be searched by interval on Advanced Search page. Two inputs are created to set start and end values.', 'admin', 'en', '', 0),
(442, 'field_type_tip_pictures', 'This field is displayed as a gallery of images. Lightbox display is used on View Item page.', 'This field is displayed as a gallery of images. Lightbox display is used on View Item page.', 'admin', 'en', '', 0),
(443, 'field_type_tip_radio', 'This field is displayed as multiple radio buttons.', 'This field is displayed as multiple radio buttons.', 'admin', 'en', '', 0),
(444, 'field_type_tip_storage', 'This field is displayed as upload input.', 'This field is displayed as upload input.', 'admin', 'en', '', 0),
(445, 'field_type_tip_text', 'This field is displayed as one line text field.', 'This field is displayed as one line text field.', 'admin', 'en', '', 0),
(446, 'field_type_tip_textarea', 'This field is displayed as multiline text box.', 'This field is displayed as multiline text box.', 'admin', 'en', '', 0),
(447, 'field_type_tip_url', 'This field value will be displayed as a hyperlink.', 'This field value will be displayed as a hyperlink.', 'admin', 'en', '', 0),
(448, 'field_type_invalid', 'Field type is invalid.', 'Field type is invalid.', 'admin', 'en', '', 0),
(449, 'fields', 'Fields', 'Fields', 'admin', 'en', '', 0),
(450, 'fields_for_plans', 'Fields for plans only', 'Fields for plans only', 'admin', 'en', '', 0),
(451, 'fields_item', 'Fields item', 'Fields item', 'admin', 'en', '', 0);
INSERT INTO `[[dbprefix]]language` VALUES
(452, 'fields_item_filter', 'Fields item filter', 'Fields item filter', 'admin', 'en', '', 0),
(453, 'fields_list', 'Fields List', 'Fields List', 'admin', 'en', '', 0),
(454, 'file_doesnt_exist', 'File does not exist.', 'File does not exist.', 'admin', 'en', '', 0),
(455, 'file_format', 'File format', 'File format', 'admin', 'en', '', 0),
(456, 'file_prefix', 'File Prefix', 'File Prefix', 'admin', 'en', '', 0),
(457, 'filename_notification', '<b>For templates:</b> type a name of your TPL file and place this file in your active template folder.<br />Example: <code>block.teaser.tpl</code><br><b>For plugins & packages:</b> TPL file should be placed in module''s templates folder.<br />Example: <code>module/module_name:block_file.tpl</code>', '<b>For templates:</b> type a name of your TPL file and place this file in your active template folder.<br />Example: <code>block.teaser.tpl</code><br><b>For plugins & packages:</b> TPL file should be placed in module''s templates folder.<br />Example: <code>module/module_name:block_file.tpl</code>', 'admin', 'en', '', 0),
(458, 'fit', 'Fit', 'Fit', 'admin', 'en', '', 0),
(459, 'fit_tip', 'This mode attempts to resize an image proportionally in case it does not fit inner frame dimensions set by the administrator. If it fits the dimensions, an image will not be resized at all.', 'This mode attempts to resize an image proportionally in case it does not fit inner frame dimensions set by the administrator. If it fits the dimensions, an image will not be resized at all.', 'admin', 'en', '', 0),
(460, 'for_plan_only', 'For plans only', 'For plans only', 'admin', 'en', '', 0),
(461, 'force_replacement', 'Force Replacement', 'Force Replacement', 'admin', 'en', '', 0),
(462, 'format_example', 'Format example', 'Format example', 'admin', 'en', '', 0),
(463, 'free_plan_added', 'Free plan added.', 'Free plan added.', 'admin', 'en', '', 0),
(464, 'future_date_specified_for_added_date', 'The date in future specified for &quot;Added Date&quot; field.', 'The date in future specified for &quot;Added Date&quot; field.', 'admin', 'en', '', 0),
(465, 'global', 'Global', 'Global', 'admin', 'en', '', 0),
(466, 'go_to_config', 'View settings', 'View settings', 'admin', 'en', '', 0),
(467, 'go_to_list', 'Go to list', 'Go to list', 'admin', 'en', '', 0),
(468, 'grid_of', 'of {0}', 'of {0}', 'admin', 'en', '', 0),
(469, 'hide', 'Hide', 'Hide', 'admin', 'en', '', 0),
(470, 'hour', 'hour', 'hour', 'admin', 'en', '', 0),
(471, 'hours_ago', ':hours hours ago', ':hours hours ago', 'admin', 'en', '', 0),
(472, 'host_fields', 'Host Fields', 'Host Fields', 'admin', 'en', '', 0),
(473, 'html', 'HTML', 'HTML', 'admin', 'en', '', 0),
(474, 'id', 'ID', 'ID', 'admin', 'en', '', 0),
(475, 'ie_update_warning', 'Warning! Your version of Internet Explorer is too old. It may cause malfunctions of the script. Please update the browser to the 8 or higher version.', 'Warning! Your version of Internet Explorer is too old. It may cause malfunctions of the script. Please update the browser to the 8 or higher version.', 'admin', 'en', '', 0),
(476, 'image_dimensions', 'Image dimensions', 'Image dimensions', 'admin', 'en', '', 0),
(477, 'image_height', 'Image Height', 'Image Height', 'admin', 'en', '', 0),
(478, 'image_types', 'Image types', 'Image types', 'admin', 'en', '', 0),
(479, 'import', 'Import', 'Import', 'admin', 'en', '', 0),
(480, 'import_from_pc', 'Import the language file from PC', 'Import the language file from PC', 'admin', 'en', '', 0),
(481, 'import_from_server', 'Import the language file from your server', 'Import the language file from your server', 'admin', 'en', '', 0),
(482, 'inactive', 'Inactive', 'Inactive', 'admin', 'en', '', 0),
(483, 'incompatible', 'Incompatible', 'Incompatible', 'admin', 'en', '', 0),
(484, 'incorrect_file_format', 'Incorrect file format.', 'Incorrect file format.', 'admin', 'en', '', 0),
(485, 'incorrect_item', 'Please, choose a valid item', 'Please, choose a valid item', 'admin', 'en', '', 0),
(486, 'incorrect_key', 'Phrase key is incorrect.', 'Phrase key is incorrect.', 'admin', 'en', '', 0),
(487, 'incorrect_menu_name', 'Incorrect menu name.', 'Incorrect menu name.', 'admin', 'en', '', 0),
(488, 'incorrect_name_url', 'Incorrect name. Please fill in the URL field.', 'Incorrect name. Please fill in the URL field.', 'admin', 'en', '', 0),
(489, 'incorrect_owner_specified', 'Incorrect owner specified.', 'Incorrect owner specified.', 'admin', 'en', '', 0),
(490, 'incorrect_text_field', 'Text field is incorrect.', 'Text field is incorrect.', 'admin', 'en', '', 0),
(491, 'incorrect_username', 'Incorrect username.', 'Incorrect username.', 'admin', 'en', '', 0),
(492, 'incorrect_value', 'Please enter the value of the key.', 'Please enter the value of the key.', 'admin', 'en', '', 0),
(493, 'image_uploaded', 'Image :name is successfully uploaded.', 'Image :name is successfully uploaded.', 'admin', 'en', '', 0),
(494, 'impossible_to_compare_single_language', 'You need to have two or more languages to start comparing them.', 'You need to have two or more languages to start comparing them.', 'admin', 'en', '', 0),
(495, 'input_title', 'Please input title', 'Please input title', 'admin', 'en', '', 0),
(496, 'insert', 'Insert', 'Insert', 'admin', 'en', '', 0),
(497, 'installed_plugins', 'Installed plugins', 'Installed plugins', 'admin', 'en', '', 0),
(498, 'install', 'Install', 'Install', 'admin', 'en', '', 0),
(499, 'installed', 'Installed', 'Installed', 'admin', 'en', '', 0),
(500, 'install_not_deleted', 'Warning! For safety purposes, please remove the file :file', 'Warning! For safety purposes, please remove the file :file', 'admin', 'en', '', 0),
(501, 'install_upgrade', 'Install or upgrade', 'Install or upgrade', 'admin', 'en', '', 0),
(502, 'installation_module_requirement_doesnot_exist', 'The currently installed :type &ldquo;:module&rdquo; is not compatible with the module.', 'The currently installed :type &ldquo;:module&rdquo; is not compatible with the module.', 'admin', 'en', '', 0),
(503, 'installation_module_requirement_exist', 'Requires the &ldquo;:module&rdquo; :type to be installed.', 'Requires the &ldquo;:module&rdquo; :type to be installed.', 'admin', 'en', '', 0),
(504, 'installation_module_requirement_incorrect', 'Invalid dependencies specified. Ignored.', 'Invalid dependencies specified. Ignored.', 'admin', 'en', '', 0),
(505, 'installation_impossible', 'Installation is currently impossible.', 'Installation is currently impossible.', 'admin', 'en', '', 0),
(506, 'interval', 'Interval', 'Interval', 'admin', 'en', '', 0),
(507, 'invalid_base_url', 'Invalid site URL. Ignored.', 'Invalid site URL. Ignored.', 'admin', 'en', '', 0),
(508, 'invalid_image_file', 'Unable to process image, invalid image file.', 'Unable to process image, invalid image file.', 'admin', 'en', '', 0),
(509, 'invalid_plugin_dependencies', 'Invalid plugin dependencies', 'Invalid plugin dependencies', 'admin', 'en', '', 0),
(510, 'invoice_id', 'Invoice ID', 'Invoice ID', 'admin', 'en', '', 0),
(511, 'items_fields', 'Fields', 'Fields', 'admin', 'en', '', 0),
(512, 'invert', 'Invert', 'Invert', 'admin', 'en', '', 0),
(513, 'iso_code', 'ISO Code', 'ISO Code', 'admin', 'en', '', 0),
(514, 'item_down', 'DOWN', 'DOWN', 'admin', 'en', '', 0),
(515, 'item_id', 'Item ID', 'Item ID', 'admin', 'en', '', 0),
(516, 'item_up', 'UP', 'UP', 'admin', 'en', '', 0),
(517, 'item_value', 'Item Value', 'Item Value', 'admin', 'en', '', 0),
(518, 'items_deleted', ':num items deleted.', ':num items deleted.', 'admin', 'en', '', 0),
(519, 'items_deleted_of', ':num of :total items deleted.', ':num of :total items deleted.', 'admin', 'en', '', 0),
(520, 'items_per_page', 'Items per page', 'Items per page', 'admin', 'en', '', 0),
(521, 'items_updated_of', ':num of :total items updated.', ':num of :total items updated.', 'admin', 'en', '', 0),
(522, 'just_now', 'just now', 'just now', 'admin', 'en', '', 0),
(523, 'key_not_valid', 'Key is invalid. Only alphanumeric and underscore characters allowed.', 'Key is invalid. Only alphanumeric and underscore characters allowed.', 'admin', 'en', '', 0),
(524, 'lang_incorrect', 'Please choose correct language.', 'Please choose correct language.', 'admin', 'en', '', 0),
(525, 'language_already_exists', 'Language already exists.', 'Language already exists.', 'admin', 'en', '', 0),
(526, 'language_copied', 'New language created (:count phrases copied).', 'New language created (:count phrases copied).', 'admin', 'en', '', 0),
(527, 'language_deleted', 'Selected language has been deleted.', 'Selected language has been deleted.', 'admin', 'en', '', 0),
(528, 'language_iso_code', 'Iso', 'Iso', 'admin', 'en', '', 0),
(529, 'language_date_format', 'Date format', 'Date format', 'admin', 'en', '', 0),
(530, 'language_date_format_incorrect', 'Date format is incorrect.', 'Date format is incorrect.', 'admin', 'en', '', 0),
(531, 'language_date_format_tooltip', 'Check all possible values for date formatting here: <a href="http://www.smarty.net/docs/en/language.modifier.date.format.tpl" target="_blank">http://www.smarty.net/docs/en/language.modifier.date.format.tpl</a>', 'Check all possible values for date formatting here: <a href="http://www.smarty.net/docs/en/language.modifier.date.format.tpl" target="_blank">http://www.smarty.net/docs/en/language.modifier.date.format.tpl</a>', 'admin', 'en', '', 0),
(532, 'language_direction', 'Direction', 'Direction', 'admin', 'en', '', 0),
(533, 'language_direction_ltr', 'Left to right (LTR)', 'Left to right (LTR)', 'admin', 'en', '', 0),
(534, 'language_direction_rtl', 'Right to left (RTL)', 'Right to left (RTL)', 'admin', 'en', '', 0),
(535, 'language_locale', 'Locale', 'Locale', 'admin', 'en', '', 0),
(536, 'language_locale_incorrect', 'Language locale is incorrect.', 'Language locale is incorrect.', 'admin', 'en', '', 0),
(537, 'language_time_format', 'Time format', 'Time format', 'admin', 'en', '', 0),
(538, 'language_time_format_tooltip', 'Be careful editing this value. Check the manual here: <a href="http://www.smarty.net/docs/en/language.modifier.date.format.tpl" target="_blank">http://www.smarty.net/docs/en/language.modifier.date.format.tpl</a>', 'Be careful editing this value. Check the manual here: <a href="http://www.smarty.net/docs/en/language.modifier.date.format.tpl" target="_blank">http://www.smarty.net/docs/en/language.modifier.date.format.tpl</a>', 'admin', 'en', '', 0),
(539, 'languages_comparison', 'Comparison', 'Comparison', 'admin', 'en', '', 0),
(540, 'last_updated', 'Last updated', 'Last updated', 'admin', 'en', '', 0),
(541, 'launch_manually', 'Launch manually', 'Launch manually', 'admin', 'en', '', 0),
(542, 'legend', 'Legend', 'Legend', 'admin', 'en', '', 0),
(543, 'list_currencies', 'List', 'List', 'admin', 'en', '', 0),
(544, 'listings_limit', 'Listings limit', 'Listings limit', 'admin', 'en', '', 0),
(545, 'loading_widgets', 'Loading widgets...', 'Loading widgets...', 'admin', 'en', '', 0),
(546, 'local', 'Local', 'Local', 'admin', 'en', '', 0),
(547, 'login_to_text', 'Enter the login name into "Login" and password into the "Password" fields.\r\nThen click "Login".', 'Enter the login name into "Login" and password into the "Password" fields.\r\nThen click "Login".', 'admin', 'en', '', 0),
(548, 'location_sql_file', 'Location of MySQL upgrade file', 'Location of MySQL upgrade file', 'admin', 'en', '', 0),
(549, 'mailer', 'Mailer', 'Mailer', 'admin', 'en', '', 0),
(550, 'manage', 'Manage', 'Manage', 'admin', 'en', '', 0),
(551, 'manage_entries', 'Manage entries', 'Manage entries', 'admin', 'en', '', 0),
(552, 'master', 'Master', 'Master', 'admin', 'en', '', 0),
(553, 'max_files', 'Max number of files', 'Max number of files', 'admin', 'en', '', 0),
(554, 'max_num_images', 'Max Images', 'Max Images', 'admin', 'en', '', 0),
(555, 'member_add', 'Add a Member', 'Add a Member', 'admin', 'en', '', 0),
(556, 'member_added', 'Member added.', 'Member added.', 'admin', 'en', '', 0),
(557, 'member_deleted', 'Member deleted.', 'Member deleted.', 'admin', 'en', '', 0),
(558, 'member_edit', 'Edit Member', 'Edit Member', 'admin', 'en', '', 0),
(559, 'members_with_custom_perms', 'Members <small>with custom permissions</small>', 'Members <small>with custom permissions</small>', 'admin', 'en', '', 0),
(560, 'menu_configuration', 'Menu configuration', 'Menu configuration', 'admin', 'en', '', 0),
(561, 'menu_doesnot_exists', 'Menu does not exist.', 'Menu does not exist.', 'admin', 'en', '', 0),
(562, 'menu_deleted', 'Menu removed.', 'Menu removed.', 'admin', 'en', '', 0),
(563, 'menu_exists', 'Menu with this name is already present. Please set another name.', 'Menu with this name is already present. Please set another name.', 'admin', 'en', '', 0),
(564, 'menu_visible_everywhere', 'Visible everywhere', 'Visible everywhere', 'admin', 'en', '', 0),
(565, 'menu_visibility_exceptions_visible', 'Choose where menu will be explicitly <b>visible</b>', 'Choose where menu will be explicitly <b>visible</b>', 'admin', 'en', '', 0),
(566, 'menu_visibility_exceptions_hidden', 'Choose where menu will be explicitly <b>hidden</b>', 'Choose where menu will be explicitly <b>hidden</b>', 'admin', 'en', '', 0),
(567, 'menus', 'Menus', 'Menus', 'admin', 'en', '', 0),
(568, 'menus_deleted', 'Menus deleted.', 'Menus deleted.', 'admin', 'en', '', 0),
(569, 'message_body', 'Message Body', 'Message Body', 'admin', 'en', '', 0),
(570, 'meta_description', 'Meta-description', 'Meta-description', 'admin', 'en', '', 0),
(571, 'meta_keywords', 'Meta-keywords', 'Meta-keywords', 'admin', 'en', '', 0),
(572, 'meta_title', 'Meta-title', 'Meta-title', 'admin', 'en', '', 0),
(573, 'migrations', 'Migrations', 'Migrations', 'admin', 'en', '', 0),
(574, 'migration_already_applied', 'Migration has been applied.', 'Migration has been applied.', 'admin', 'en', '', 0),
(575, 'migrations_not_applied', 'Non-applied migrations', 'Non-applied migrations', 'admin', 'en', '', 0),
(576, 'minutes_ago', ':minutes minutes ago', ':minutes minutes ago', 'admin', 'en', '', 0),
(577, 'mode', 'Mode', 'Mode', 'admin', 'en', '', 0),
(578, 'module_changelog', 'Changelog', 'Changelog', 'admin', 'en', '', 0),
(579, 'module_description', 'Description', 'Description', 'admin', 'en', '', 0),
(580, 'module_documentation', 'Documentation', 'Documentation', 'admin', 'en', '', 0),
(581, 'module_downloaded', '":name" downloaded.', '":name" downloaded.', 'admin', 'en', '', 0),
(582, 'module_installation', 'Installation', 'Installation', 'admin', 'en', '', 0),
(583, 'module_required', 'Module required', 'Module required', 'admin', 'en', '', 0),
(584, 'module_screenshots', 'Screenshots', 'Screenshots', 'admin', 'en', '', 0),
(585, 'moved', 'Moved.', 'Moved.', 'admin', 'en', '', 0),
(586, 'multilingual', 'Multilingual', 'Multilingual', 'admin', 'en', '', 0),
(587, 'multiple_selection', 'Multiple selection', 'Multiple selection', 'admin', 'en', '', 0),
(588, 'mysql_options', 'MySQL Options', 'MySQL Options', 'admin', 'en', '', 0),
(589, 'na', 'n/a', 'n/a', 'admin', 'en', '', 0),
(590, 'name', 'Name', 'Name', 'admin', 'en', '', 0),
(591, 'name_is_incorrect', 'Name is incorrect.', 'Name is incorrect.', 'admin', 'en', '', 0),
(592, 'new_language', 'New Language', 'New Language', 'admin', 'en', '', 0),
(593, 'new_password', 'New password', 'New password', 'admin', 'en', '', 0),
(594, 'next_launch', 'Next launch', 'Next launch', 'admin', 'en', '', 0),
(595, 'next_payment_date', 'Next payment date', 'Next payment date', 'admin', 'en', '', 0),
(596, 'no_blocks', 'There are no blocks.', 'There are no blocks.', 'admin', 'en', '', 0),
(597, 'no_captcha_preview', 'No captcha preview.', 'No captcha preview.', 'admin', 'en', '', 0),
(598, 'no_extension', 'No extension', 'No extension', 'admin', 'en', '', 0),
(599, 'no_follow_url', 'No Follow URL', 'No Follow URL', 'admin', 'en', '', 0),
(600, 'no_image_types', 'No image types added. Please, <a href=":url" target="_blank">add them</a> first.', 'No image types added. Please, <a href=":url" target="_blank">add them</a> first.', 'admin', 'en', '', 0),
(601, 'no_implemented_packages', 'No implemented packages.', 'No implemented packages.', 'admin', 'en', '', 0),
(602, 'no_members', '- no members -', '- no members -', 'admin', 'en', '', 0),
(603, 'no_migrations', 'No migration files available.', 'No migration files available.', 'admin', 'en', '', 0),
(604, 'no_modules', 'No modules. You can check <a href="https://subrion.org/" target="_blank">Subrion.org website</a> to get some modules for your website.', 'No modules. You can check <a href="https://subrion.org/" target="_blank">Subrion.org website</a> to get some modules for your website.', 'admin', 'en', '', 0),
(605, 'no_parent_fields', 'No main fields for this item', 'No main fields for this item', 'admin', 'en', '', 0),
(606, 'no_plans', 'No Plans', 'No Plans', 'admin', 'en', '', 0),
(607, 'no_upgrades', 'No patches, migrations, or upgrades available.', 'No patches, migrations, or upgrades available.', 'admin', 'en', '', 0),
(608, 'nodes', 'Nodes', 'Nodes', 'admin', 'en', '', 0),
(609, 'notes', 'Notes', 'Notes', 'admin', 'en', '', 0),
(610, 'not_allowed', 'Not allowed', 'Not allowed', 'admin', 'en', '', 0),
(611, 'not_required', 'not required', 'not required', 'admin', 'en', '', 0),
(612, 'nothing', 'Nothing', 'Nothing', 'admin', 'en', '', 0),
(613, 'notification_resolve--resolve', 'Resolve issue', 'Resolve issue', 'admin', 'en', '', 0),
(614, 'notification_resolve--working', 'Working...', 'Working...', 'admin', 'en', '', 0),
(615, 'notification_resolve--resolved', 'Resolved!', 'Resolved!', 'admin', 'en', '', 0),
(616, 'number_of_cycles', 'Number of cycles', 'Number of cycles', 'admin', 'en', '', 0),
(617, 'number_of_decimal_places', 'Number of decimal places', 'Number of decimal places', 'admin', 'en', '', 0),
(618, 'one_day_ago', 'one day ago', 'one day ago', 'admin', 'en', '', 0),
(619, 'one_hour_ago', 'one hour ago', 'one hour ago', 'admin', 'en', '', 0),
(620, 'one_value', 'You have to add at least one value.', 'You have to add at least one value.', 'admin', 'en', '', 0),
(621, 'optimize_complete', 'Tables optimizing complete.', 'Tables optimizing complete.', 'admin', 'en', '', 0),
(622, 'optimize_tables', 'Optimize tables', 'Optimize tables', 'admin', 'en', '', 0),
(623, 'optional', 'optional', 'optional', 'admin', 'en', '', 0),
(624, 'options', 'Options', 'Options', 'admin', 'en', '', 0),
(625, 'original', 'Original', 'Original', 'admin', 'en', '', 0),
(626, 'other_can', 'Other can', 'Other can', 'admin', 'en', '', 0),
(627, 'owner', 'Owner', 'Owner', 'admin', 'en', '', 0),
(628, 'owner_can', 'Owner can', 'Owner can', 'admin', 'en', '', 0),
(629, 'owner_is_not_specified', 'Owner is not specified.', 'Owner is not specified.', 'admin', 'en', '', 0),
(630, 'page_added', 'Page added.', 'Page added.', 'admin', 'en', '', 0),
(631, 'page_alias_exists', 'Page URL already exists.', 'Page URL already exists.', 'admin', 'en', '', 0),
(632, 'page_content', 'Page Content', 'Page Content', 'admin', 'en', '', 0),
(633, 'page_exists', 'Page with specified URL already exists. Please change URL.', 'Page with specified URL already exists. Please change URL.', 'admin', 'en', '', 0),
(634, 'page_external_url', 'Page External URL', 'Page External URL', 'admin', 'en', '', 0),
(635, 'page_incorrect_template_filename', 'Incorrect template name for page.', 'Incorrect template name for page.', 'admin', 'en', '', 0),
(636, 'page_name_exists', 'Page with specified name already exists.', 'Page with specified name already exists.', 'admin', 'en', '', 0),
(637, 'page_preview', 'Page in draft', 'Page in draft', 'admin', 'en', '', 0),
(638, 'page_title', 'Page Title', 'Page Title', 'admin', 'en', '', 0),
(639, 'page_title_incorrect', 'Please make sure you have added all page titles.', 'Please make sure you have added all page titles.', 'admin', 'en', '', 0),
(640, 'pages', 'Frontend Pages', 'Frontend Pages', 'admin', 'en', '', 0),
(641, 'pages_contains', 'Include pages', 'Include pages', 'admin', 'en', '', 0),
(642, 'pages_group_content', 'Content', 'Content', 'admin', 'en', '', 0),
(643, 'pages_group_extensions', 'Extensions', 'Extensions', 'admin', 'en', '', 0),
(644, 'pages_group_financial', 'Financial', 'Financial', 'admin', 'en', '', 0),
(645, 'pages_group_members', 'Members', 'Members', 'admin', 'en', '', 0),
(646, 'pages_group_system', 'System', 'System', 'admin', 'en', '', 0),
(647, 'package_activated', 'Package activated.', 'Package activated.', 'admin', 'en', '', 0),
(648, 'package_deactivated', 'Package deactivated.', 'Package deactivated.', 'admin', 'en', '', 0),
(649, 'package_error', 'You have to choose at least one package.', 'You have to choose at least one package.', 'admin', 'en', '', 0),
(650, 'package_updated', 'Package updated.', 'Package updated.', 'admin', 'en', '', 0),
(651, 'package_version', 'Package Version', 'Package Version', 'admin', 'en', '', 0),
(652, 'packages_avail', 'Available Packages', 'Available Packages', 'admin', 'en', '', 0),
(653, 'package_installed', 'Package installed.', 'Package installed.', 'admin', 'en', '', 0),
(654, 'package_uninstalled', 'Package uninstalled.', 'Package uninstalled.', 'admin', 'en', '', 0),
(655, 'password_restore_description', 'If you see this page that means that you have received an email with\r\n\r\nthis URL.\r\n\r\nThis page is intended to set a new password for your administration\r\n\r\naccount.\r\n\r\n<div style="color:red;padding:10px;border:1px solid gray"><p>It is assumed that you know your username (login)</p><p>There is only one attempt!!!</p><p>Otherwise you''ll have to request restoration again (in login page)</p></div>', 'If you see this page that means that you have received an email with\r\n\r\nthis URL.\r\n\r\nThis page is intended to set a new password for your administration\r\n\r\naccount.\r\n\r\n<div style="color:red;padding:10px;border:1px solid gray"><p>It is assumed that you know your username (login)</p><p>There is only one attempt!!!</p><p>Otherwise you''ll have to request restoration again (in login page)</p></div>', 'admin', 'en', '', 0),
(656, 'path', 'Path', 'Path', 'admin', 'en', '', 0),
(657, 'permissions', 'Permissions', 'Permissions', 'admin', 'en', '', 0),
(658, 'permissions_members', 'Member permissions :member', 'Member permissions :member', 'admin', 'en', '', 0),
(659, 'permissions_usergroups', 'Usergroup permissions :usergroup', 'Usergroup permissions :usergroup', 'admin', 'en', '', 0),
(660, 'phrase_added', 'Phrase added.', 'Phrase added.', 'admin', 'en', '', 0),
(661, 'phrase_exists', 'Phrase exists.', 'Phrase exists.', 'admin', 'en', '', 0),
(662, 'phrase_manager', 'Phrase Manager', 'Phrase Manager', 'admin', 'en', '', 0),
(663, 'phrase_text', 'Phrase Text', 'Phrase Text', 'admin', 'en', '', 0),
(664, 'place', 'Position in template', 'Position in template', 'admin', 'en', '', 0),
(665, 'plan', 'Plan', 'Plan', 'admin', 'en', '', 0),
(666, 'plan_add', 'Add Plan', 'Add Plan', 'admin', 'en', '', 0),
(667, 'plan_deleted', 'Plan deleted.', 'Plan deleted.', 'admin', 'en', '', 0),
(668, 'plan_edit', 'Edit Plan', 'Edit Plan', 'admin', 'en', '', 0),
(669, 'plans', 'Plans', 'Plans', 'admin', 'en', '', 0),
(670, 'plans_fields', 'Fields for plan', 'Fields for plan', 'admin', 'en', '', 0),
(671, 'plugin', 'Plugin', 'Plugin', 'admin', 'en', '', 0),
(672, 'plugin_files_physically_missed', 'Plugin files are missing. Probably folder name does not match plugin name.', 'Plugin files are missing. Probably folder name does not match plugin name.', 'admin', 'en', '', 0),
(673, 'plugin_installed', '":name" plugin installed.', '":name" plugin installed.', 'admin', 'en', '', 0),
(674, 'plugin_may_not_be_removed', 'Plugin may not be removed.', 'Plugin may not be removed.', 'admin', 'en', '', 0),
(675, 'plugin_reinstalled', '":name" plugin reinstalled.', '":name" plugin reinstalled.', 'admin', 'en', '', 0),
(676, 'plugin_status_may_not_be_changed', 'Status of this plugin may not be changed.', 'Status of this plugin may not be changed.', 'admin', 'en', '', 0),
(677, 'plugin_updated', 'Plugin updated.', 'Plugin updated.', 'admin', 'en', '', 0),
(678, 'plugin_uninstalled', 'Selected plugin uninstalled.', 'Selected plugin uninstalled.', 'admin', 'en', '', 0),
(679, 'plugins', 'Plugins', 'Plugins', 'admin', 'en', '', 0),
(680, 'plugins_left', ':count more plugins left to be installed.', ':count more plugins left to be installed.', 'admin', 'en', '', 0),
(681, 'preview', 'Preview', 'Preview', 'admin', 'en', '', 0),
(682, 'previous_launch', 'Previous launch', 'Previous launch', 'admin', 'en', '', 0),
(683, 'price', 'Price', 'Price', 'admin', 'en', '', 0),
(684, 'primary', 'Primary', 'Primary', 'admin', 'en', '', 0),
(685, 'product_items', 'Product Items', 'Product Items', 'admin', 'en', '', 0),
(686, 'quantity', 'Quantity', 'Quantity', 'admin', 'en', '', 0),
(687, 'query_history', 'Queries History', 'Queries History', 'admin', 'en', '', 0),
(688, 'quick_access', 'Quick Access', 'Quick Access', 'admin', 'en', '', 0),
(689, 'radios', 'Radios', 'Radios', 'admin', 'en', '', 0),
(690, 'rate', 'Rate', 'Rate', 'admin', 'en', '', 0),
(691, 'recent_activity', 'Recent activity', 'Recent activity', 'admin', 'en', '', 0),
(692, 'recent_package_activity', 'Recent :package activity', 'Recent :package activity', 'admin', 'en', '', 0),
(693, 'recount', 'recount', 'recount', 'admin', 'en', '', 0),
(694, 'recurring_options', 'Recurring Options', 'Recurring Options', 'admin', 'en', '', 0),
(695, 'registration_email_resent', 'Registration email has been re-sent.', 'Registration email has been re-sent.', 'admin', 'en', '', 0),
(696, 'regular_field', 'Regular field', 'Regular field', 'admin', 'en', '', 0),
(697, 'reinstall', 'Reinstall', 'Reinstall', 'admin', 'en', '', 0),
(698, 'reinstall_plugin', 'Reinstall plugin', 'Reinstall plugin', 'admin', 'en', '', 0),
(699, 'remote', 'Remote', 'Remote', 'admin', 'en', '', 0),
(700, 'removed', 'Removed.', 'Removed.', 'admin', 'en', '', 0),
(701, 'repair', 'repair', 'repair', 'admin', 'en', '', 0),
(702, 'repair_tables', 'Repair tables', 'Repair tables', 'admin', 'en', '', 0),
(703, 'repair_complete', 'Tables repairing complete.', 'Tables repairing complete.', 'admin', 'en', '', 0),
(704, 'resend_registration_email', 'Re-send registration email', 'Re-send registration email', 'admin', 'en', '', 0),
(705, 'reset_all', 'Reset all', 'Reset all', 'admin', 'en', '', 0),
(706, 'reset_backup_alert', 'Please backup your data before resetting your items.', 'Please backup your data before resetting your items.', 'admin', 'en', '', 0),
(707, 'reset_choose_table', 'Choose entries to reset.', 'Choose entries to reset.', 'admin', 'en', '', 0),
(708, 'reset_default', 'Reset default', 'Reset default', 'admin', 'en', '', 0),
(709, 'reset_default_package', 'Your package URLs will be reset. Please choose the URL that will be used to access your directory package.', 'Your package URLs will be reset. Please choose the URL that will be used to access your directory package.', 'admin', 'en', '', 0),
(710, 'reset_default_success', 'Your package URLs have been reset.', 'Your package URLs have been reset.', 'admin', 'en', '', 0),
(711, 'reset_previous_default_success', 'Your previous default value has been reset.', 'Your previous default value has been reset.', 'admin', 'en', '', 0),
(712, 'reset_success', 'Reset successfully completed.', 'Reset successfully completed.', 'admin', 'en', '', 0),
(713, 'resize_mode', 'Resize mode', 'Resize mode', 'admin', 'en', '', 0),
(714, 'restore_defaults', 'Restore defaults', 'Restore defaults', 'admin', 'en', '', 0),
(715, 'result', 'Result', 'Result', 'admin', 'en', '', 0),
(716, 'request_submitted', 'Thanks. Your request has been submitted.', 'Thanks. Your request has been submitted.', 'admin', 'en', '', 0),
(717, 'required_checks', 'Validation PHP code', 'Validation PHP code', 'admin', 'en', '', 0),
(718, 'required_module_error', 'The module you are trying to install requires the following :module to be installed: :name (:version)', 'The module you are trying to install requires the following :module to be installed: :name (:version)', 'admin', 'en', '', 0),
(719, 'required_field', 'Required field', 'Required field', 'admin', 'en', '', 0),
(720, 'required_fields', 'Required fields', 'Required fields', 'admin', 'en', '', 0),
(721, 'required_template_error', 'The template you are trying to install requires the following :module to be installed: :name (:version)', 'The template you are trying to install requires the following :module to be installed: :name (:version)', 'admin', 'en', '', 0),
(722, 'root_about', 'No additional prefixes will be added to package URL. This way is highly recommended for sites with one package installed. See more details in our <a href="https://subrion.org/forums/">User Forums</a>.', 'No additional prefixes will be added to package URL. This way is highly recommended for sites with one package installed. See more details in our <a href="https://subrion.org/forums/">User Forums</a>.', 'admin', 'en', '', 0),
(723, 'root_title', 'Script Root Installation', 'Script Root Installation', 'admin', 'en', '', 0),
(724, 'root_old', 'You currently have the ":name" package installed in your Script Root location. You can not have two packages installed in root simultaneously. If you still want to install in Root location please set the URL value for the ":name" package.', 'You currently have the ":name" package installed in your Script Root location. You can not have two packages installed in root simultaneously. If you still want to install in Root location please set the URL value for the ":name" package.', 'admin', 'en', '', 0),
(725, 'run', 'Run', 'Run', 'admin', 'en', '', 0),
(726, 'run_sql_queries', 'Run MySQL query/queries', 'Run MySQL query/queries', 'admin', 'en', '', 0),
(727, 'save_as_file', 'Save as file', 'Save as file', 'admin', 'en', '', 0),
(728, 'save_changes_to_send_test_email', 'Save your changes before sending a test email.', 'Save your changes before sending a test email.', 'admin', 'en', '', 0),
(729, 'save_to_pc', 'Save to PC', 'Save to PC', 'admin', 'en', '', 0),
(730, 'save_to_server', 'Save to server', 'Save to server', 'admin', 'en', '', 0),
(731, 'scheduled_task_ran', 'Task launched.', 'Task launched.', 'admin', 'en', '', 0),
(732, 'screenshot', 'Screenshot', 'Screenshot', 'admin', 'en', '', 0),
(733, 'script_upgraded', 'Your script has been automatically upgraded to version :version.', 'Your script has been automatically upgraded to version :version.', 'admin', 'en', '', 0),
(734, 'search_in_phrases', 'Search in Phrases', 'Search in Phrases', 'admin', 'en', '', 0),
(735, 'section', 'Search section', 'Search section', 'admin', 'en', '', 0),
(736, 'select_all', 'Select all', 'Select all', 'admin', 'en', '', 0),
(737, 'select_all_in_tab', 'Select all in this tab', 'Select all in this tab', 'admin', 'en', '', 0),
(738, 'select_none', 'Select None', 'Select None', 'admin', 'en', '', 0),
(739, 'send_confirm', 'Are you sure you wish to send this feedback to the Subrion Team?', 'Are you sure you wish to send this feedback to the Subrion Team?', 'admin', 'en', '', 0),
(740, 'send_test_email', 'Send test email', 'Send test email', 'admin', 'en', '', 0),
(741, 'send_test_email_note', 'Test message will be sent to your current profile email address.', 'Test message will be sent to your current profile email address.', 'admin', 'en', '', 0),
(742, 'sending', 'Sending', 'Sending', 'admin', 'en', '', 0),
(743, 'seo', 'SEO', 'SEO', 'admin', 'en', '', 0),
(744, 'server_info', 'Server Info', 'Server Info', 'admin', 'en', '', 0),
(745, 'set_as_default_value', 'Set as default value', 'Set as default value', 'admin', 'en', '', 0),
(746, 'set_as_default_package', 'Set as default package', 'Set as default package', 'admin', 'en', '', 0),
(747, 'set_as_default_template', 'Activate', 'Activate', 'admin', 'en', '', 0),
(748, 'set_as_primary', 'Set as primary', 'Set as primary', 'admin', 'en', '', 0),
(749, 'set_as_thumbnail', 'Set as thumbnail', 'Set as thumbnail', 'admin', 'en', '', 0),
(750, 'set_default', 'Set Default', 'Set Default', 'admin', 'en', '', 0),
(751, 'set_default_success', 'Changes saved. Your package is now available in root.', 'Changes saved. Your package is now available in root.', 'admin', 'en', '', 0),
(752, 'set_all_to', 'set all to', 'set all to', 'admin', 'en', '', 0),
(753, 'settings', 'Settings', 'Settings', 'admin', 'en', '', 0),
(754, 'show', 'Show', 'Show', 'admin', 'en', '', 0),
(755, 'show_header', 'Show header', 'Show header', 'admin', 'en', '', 0),
(756, 'show_in_search_as', 'Show in search as', 'Show in search as', 'admin', 'en', '', 0),
(757, 'show_menus', 'Show in Menus', 'Show in Menus', 'admin', 'en', '', 0),
(758, 'show_query_again', 'Show this query again', 'Show this query again', 'admin', 'en', '', 0),
(759, 'shown_on_pages', 'Shown on Pages', 'Shown on Pages', 'admin', 'en', '', 0),
(760, 'site_home', 'Site Home', 'Site Home', 'admin', 'en', '', 0),
(761, 'sitemap_error', 'Sitemap file creation error! The file was not saved.', 'Sitemap file creation error! The file was not saved.', 'admin', 'en', '', 0),
(762, 'sitemap_regenerated', 'Sitemap file has been regenerated and is available at the following URL: <a href=":url" target="_blank">:url</a>.', 'Sitemap file has been regenerated and is available at the following URL: <a href=":url" target="_blank">:url</a>.', 'admin', 'en', '', 0),
(763, 'slug', 'Slug', 'Slug', 'admin', 'en', '', 0),
(764, 'sponsored_end', 'Sponsored End', 'Sponsored End', 'admin', 'en', '', 0),
(765, 'sql_format', 'SQL format', 'SQL format', 'admin', 'en', '', 0),
(766, 'sql_management', 'SQL Tool', 'SQL Tool', 'admin', 'en', '', 0),
(767, 'stay_here', 'Stay here', 'Stay here', 'admin', 'en', '', 0),
(768, 'start', 'Start', 'Start', 'admin', 'en', '', 0),
(769, 'statistics', 'Statistics', 'Statistics', 'admin', 'en', '', 0),
(770, 'status_change_not_allowed', 'Status change of readonly field not allowed.', 'Status change of readonly field not allowed.', 'admin', 'en', '', 0),
(771, 'sticky', 'Sticky', 'Sticky', 'admin', 'en', '', 0),
(772, 'structure', 'Structure', 'Structure', 'admin', 'en', '', 0),
(773, 'subdirectory_about', 'Your package will be accessible in a subdirectory. We recommend to use this way on shared hostings when you have several packages installed. <br /> Ex.: domain.com/articles/, domain.com/links/, domain.com/autos/, etc.', 'Your package will be accessible in a subdirectory. We recommend to use this way on shared hostings when you have several packages installed. <br /> Ex.: domain.com/articles/, domain.com/links/, domain.com/autos/, etc.', 'admin', 'en', '', 0),
(774, 'subdirectory_title', 'Subdirectory Installation', 'Subdirectory Installation', 'admin', 'en', '', 0),
(775, 'subdomain_about', 'You can install the package as a subdomain. Note you should be able to modify your Apache config file to use package on a subdomain. More instructions can be found in our <a href="https://subrion.org/forums/">User Forums.</a><br /> Ex.: articles.domain.com, links.domain.com, autos.domain.com, etc.', 'You can install the package as a subdomain. Note you should be able to modify your Apache config file to use package on a subdomain. More instructions can be found in our <a href="https://subrion.org/forums/">User Forums.</a><br /> Ex.: articles.domain.com, links.domain.com, autos.domain.com, etc.', 'admin', 'en', '', 0),
(776, 'subdomain_title', 'Subdomain Installation', 'Subdomain Installation', 'admin', 'en', '', 0),
(777, 'submit_feedback', 'Submit Feedback to the Subrion Team', 'Submit Feedback to the Subrion Team', 'admin', 'en', '', 0),
(778, 'subtotal', 'Subtotal', 'Subtotal', 'admin', 'en', '', 0),
(779, 'sure_uninstall_package', 'Are you sure you want to uninstall this package? Please be informed that all your package data will be lost.', 'Are you sure you want to uninstall this package? Please be informed that all your package data will be lost.', 'admin', 'en', '', 0),
(780, 'sync_multilingual_fields', 'Sync multilingual fields', 'Sync multilingual fields', 'admin', 'en', '', 0),
(781, 'system_fields', 'System Fields', 'System Fields', 'admin', 'en', '', 0),
(782, 'system_notifications', 'System Notifications', 'System Notifications', 'admin', 'en', '', 0),
(783, 'tab_container', 'Tab container', 'Tab container', 'admin', 'en', '', 0),
(784, 'table_dumped', 'Table :table dumped into file ":filename".', 'Table :table dumped into file ":filename".', 'admin', 'en', '', 0),
(785, 'tables', 'Tables', 'Tables', 'admin', 'en', '', 0),
(786, 'tables_fields', 'Tables/Fields', 'Tables/Fields', 'admin', 'en', '', 0),
(787, 'tags', 'Tags', 'Tags', 'admin', 'en', '', 0),
(788, 'task', 'Task', 'Task', 'admin', 'en', '', 0),
(789, 'tax', 'Tax', 'Tax', 'admin', 'en', '', 0),
(790, 'template_name_empty', 'Template name is empty or incorrect.', 'Template name is empty or incorrect.', 'admin', 'en', '', 0),
(791, 'template_file_error', 'Template file cannot be found. Use this file: :file.', 'Template file cannot be found. Use this file: :file.', 'admin', 'en', '', 0),
(792, 'template_folder_error', 'Template folder is undefined or incorrect.', 'Template folder is undefined or incorrect.', 'admin', 'en', '', 0),
(793, 'template_installed', '":name" template installed.', '":name" template installed.', 'admin', 'en', '', 0),
(794, 'test_email_sent', 'Test email has been received for delivery to :email.', 'Test email has been received for delivery to :email.', 'admin', 'en', '', 0),
(795, 'text', 'Text', 'Text', 'admin', 'en', '', 0),
(796, 'this_fields_displayed_only_for_plans', 'These fields are displayed for sponsored plans only.', 'These fields are displayed for sponsored plans only.', 'admin', 'en', '', 0),
(797, 'thousand_separator', 'Thousand separator', 'Thousand separator', 'admin', 'en', '', 0),
(798, 'thumb_dimensions', 'Thumb dimensions', 'Thumb dimensions', 'admin', 'en', '', 0),
(799, 'thumb_width', 'Thumbnail width', 'Thumbnail width', 'admin', 'en', '', 0),
(800, 'thumb_height', 'Thumbnail height', 'Thumbnail height', 'admin', 'en', '', 0),
(801, 'thumbnail', 'Thumbnail', 'Thumbnail', 'admin', 'en', '', 0),
(802, 'timepicker', 'Enable time selection', 'Enable time selection', 'admin', 'en', '', 0),
(803, 'title_alias', 'Title Alias', 'Title Alias', 'admin', 'en', '', 0),
(804, 'total', 'Total', 'Total', 'admin', 'en', '', 0),
(805, 'total_income', 'total income', 'total income', 'admin', 'en', '', 0),
(806, 'total_members', 'total members', 'total members', 'admin', 'en', '', 0),
(807, 'tooltip', 'Tooltip', 'Tooltip', 'admin', 'en', '', 0),
(808, 'tpl', 'Template filename', 'Template filename', 'admin', 'en', '', 0),
(809, 'transaction_added', 'Transaction added.', 'Transaction added.', 'admin', 'en', '', 0),
(810, 'transaction_deleted', 'Transaction deleted.', 'Transaction deleted.', 'admin', 'en', '', 0),
(811, 'transaction_id', 'Transaction ID', 'Transaction ID', 'admin', 'en', '', 0),
(812, 'translate', 'Translate', 'Translate', 'admin', 'en', '', 0),
(813, 'twitter_news', 'Twitter News', 'Twitter News', 'admin', 'en', '', 0),
(814, 'type', 'Type', 'Type', 'admin', 'en', '', 0),
(815, 'type_here_to_search', 'Type here to search', 'Type here to search', 'admin', 'en', '', 0),
(816, 'type_of_field', 'Field type', 'Field type', 'admin', 'en', '', 0),
(817, 'unable_to_install', 'Unable to install', 'Unable to install', 'admin', 'en', '', 0),
(818, 'uninstall', 'Uninstall', 'Uninstall', 'admin', 'en', '', 0),
(819, 'unique_name', 'Name value should be unique. Only latin letters, underscores, and digits are allowed.', 'Name value should be unique. Only latin letters, underscores, and digits are allowed.', 'admin', 'en', '', 0),
(820, 'update_available', 'Update available', 'Update available', 'admin', 'en', '', 0),
(821, 'upgrade_completed', 'MySQL dump file has been imported.', 'MySQL dump file has been imported.', 'admin', 'en', '', 0),
(822, 'upload_module_error', ':module directory is not writable.', ':module directory is not writable.', 'admin', 'en', '', 0),
(823, 'upload_writable_permission', 'Upload folder has no writable permissions.', 'Upload folder has no writable permissions.', 'admin', 'en', '', 0),
(824, 'use_real_prefix', 'Use real tables prefix', 'Use real tables prefix', 'admin', 'en', '', 0),
(825, 'upgrade', 'Upgrade', 'Upgrade', 'admin', 'en', '', 0),
(826, 'upgrades', 'Upgrades', 'Upgrades', 'admin', 'en', '', 0),
(827, 'url_nofollow', 'Enable nofollow attribute', 'Enable nofollow attribute', 'admin', 'en', '', 0),
(828, 'use_as_home_page', 'Use as the homepage', 'Use as the homepage', 'admin', 'en', '', 0),
(829, 'use_custom_signature', 'Use custom signature', 'Use custom signature', 'admin', 'en', '', 0),
(830, 'use_editor', 'Use WYSIWYG editor', 'Use WYSIWYG editor', 'admin', 'en', '', 0),
(831, 'username_already_taken', 'Username already taken.', 'Username already taken.', 'admin', 'en', '', 0),
(832, 'usergroup_added', 'Usergroup added.', 'Usergroup added.', 'admin', 'en', '', 0),
(833, 'usergroup_deleted', 'Usergroup deleted.', 'Usergroup deleted.', 'admin', 'en', '', 0),
(834, 'usergroup_disabled', 'You must have at least one administrator member.', 'You must have at least one administrator member.', 'admin', 'en', '', 0),
(835, 'usergroup_management', 'Usergroup management', 'Usergroup management', 'admin', 'en', '', 0),
(836, 'usergroups', 'Usergroups', 'Usergroups', 'admin', 'en', '', 0),
(837, 'version', 'Version', 'Version', 'admin', 'en', '', 0),
(838, 'view_as_tab', 'View as tab', 'View as tab', 'admin', 'en', '', 0),
(839, 'view_roadmap', 'Development Roadmap', 'Development Roadmap', 'admin', 'en', '', 0),
(840, 'visible', 'Visible', 'Visible', 'admin', 'en', '', 0),
(841, 'visible_for_admin', 'Visible for admin only', 'Visible for admin only', 'admin', 'en', '', 0),
(842, 'visible_on_members', 'Visible on Members page', 'Visible on Members page', 'admin', 'en', '', 0),
(843, 'visual_mode', 'Visual Mode', 'Visual Mode', 'admin', 'en', '', 0),
(844, 'warning_fields_become_for_plan_only', 'Warning! If you check these fields they will be displayed for sponsored plans only.', 'Warning! If you check these fields they will be displayed for sponsored plans only.', 'admin', 'en', '', 0),
(845, 'week', 'week', 'week', 'admin', 'en', '', 0),
(846, 'welcome_to_admin_board', 'Welcome to your administration board, cap''n!', 'Welcome to your administration board, cap''n!', 'admin', 'en', '', 0),
(847, 'welcome_to_admin_panel', 'Welcome to<br>Subrion Admin Panel', 'Welcome to<br>Subrion Admin Panel', 'admin', 'en', '', 0),
(848, 'without_title', 'Without title', 'Without title', 'admin', 'en', '', 0),
(849, 'year', 'year', 'year', 'admin', 'en', '', 0),
(850, '_not_assigned_', '&lt;not assigned&gt;', '&lt;not assigned&gt;', 'common', 'en', '', 0),
(851, '_select_', '-- select --', '-- select --', 'common', 'en', '', 0),
(852, '_status_', '- Status -', '- Status -', 'common', 'en', '', 0),
(853, '401', 'You are not authorized to access this page.', 'You are not authorized to access this page.', 'common', 'en', '', 0),
(854, '403', 'Action is forbidden.', 'Action is forbidden.', 'common', 'en', '', 0),
(855, '404', 'Requested URL not found.', 'Requested URL not found.', 'common', 'en', '', 0),
(856, 'active', 'Active', 'Active', 'common', 'en', '', 0),
(857, 'add', 'Add', 'Add', 'common', 'en', '', 0),
(858, 'add_funds', 'Add Funds', 'Add Funds', 'common', 'en', '', 0),
(859, 'added', 'Added', 'Added', 'common', 'en', '', 0),
(860, 'address', 'Address', 'Address', 'common', 'en', '', 0),
(861, 'address_line', 'Address Line', 'Address Line', 'common', 'en', '', 0),
(862, 'admin_panel', 'Admin Panel', 'Admin Panel', 'common', 'en', '', 0),
(863, 'all', 'All', 'All', 'common', 'en', '', 0),
(864, 'amount', 'Amount', 'Amount', 'common', 'en', '', 0),
(865, 'any', 'Any', 'Any', 'common', 'en', '', 0),
(866, 'apply', 'apply', 'apply', 'common', 'en', '', 0),
(867, 'approval', 'Approval', 'Approval', 'common', 'en', '', 0),
(868, 'asc', 'Ascending', 'Ascending', 'common', 'en', '', 0),
(869, 'author', 'Author', 'Author', 'common', 'en', '', 0),
(870, 'avatar', 'Avatar', 'Avatar', 'common', 'en', '', 0),
(871, 'browse', 'Browse', 'Browse', 'common', 'en', '', 0),
(872, 'by', 'by', 'by', 'common', 'en', '', 0),
(873, 'cancel', 'Cancel', 'Cancel', 'common', 'en', '', 0),
(874, 'cancel_upload_confirmation', 'Are you sure you want to cancel this upload?', 'Are you sure you want to cancel this upload?', 'common', 'en', '', 0),
(875, 'category', 'Category', 'Category', 'common', 'en', '', 0),
(876, 'change', 'change', 'change', 'common', 'en', '', 0),
(877, 'change_password', 'Change Password', 'Change Password', 'common', 'en', '', 0),
(878, 'choose_file', 'and choose file on your computer.', 'and choose file on your computer.', 'common', 'en', '', 0),
(879, 'city', 'City', 'City', 'common', 'en', '', 0),
(880, 'click', 'Click', 'Click', 'common', 'en', '', 0),
(881, 'click_here', 'Click here', 'Click here', 'common', 'en', '', 0),
(882, 'click_here_to_upload', 'Click here to upload...', 'Click here to upload...', 'common', 'en', '', 0),
(883, 'close', 'Close', 'Close', 'common', 'en', '', 0),
(884, 'close_all', 'Close all', 'Close all', 'common', 'en', '', 0),
(885, 'create', 'Create', 'Create', 'common', 'en', '', 0),
(886, 'code', 'Code', 'Code', 'common', 'en', '', 0),
(887, 'collapsed', 'Collapsed', 'Collapsed', 'common', 'en', '', 0),
(888, 'collapse_all', 'Collapse All', 'Collapse All', 'common', 'en', '', 0),
(889, 'common', 'Common', 'Common', 'common', 'en', '', 0),
(890, 'confirm', 'Confirm', 'Confirm', 'common', 'en', '', 0),
(891, 'content', 'Content', 'Content', 'common', 'en', '', 0),
(892, 'contributor', 'Contributor', 'Contributor', 'common', 'en', '', 0),
(893, 'copy', 'Copy', 'Copy', 'common', 'en', '', 0),
(894, 'country', 'Country', 'Country', 'common', 'en', '', 0),
(895, 'currency', 'Currency', 'Currency', 'common', 'en', '', 0),
(896, 'current', 'Current', 'Current', 'common', 'en', '', 0),
(897, 'current_page', 'Current Page', 'Current Page', 'common', 'en', '', 0),
(898, 'day1', 'Monday', 'Monday', 'common', 'en', '', 0),
(899, 'day2', 'Tuesday', 'Tuesday', 'common', 'en', '', 0),
(900, 'day3', 'Wednesday', 'Wednesday', 'common', 'en', '', 0),
(901, 'day4', 'Thursday', 'Thursday', 'common', 'en', '', 0),
(902, 'day5', 'Friday', 'Friday', 'common', 'en', '', 0),
(903, 'day6', 'Saturday', 'Saturday', 'common', 'en', '', 0),
(904, 'day7', 'Sunday', 'Sunday', 'common', 'en', '', 0),
(905, 'date', 'Date', 'Date', 'common', 'en', '', 0),
(906, 'db_error', 'Database error.', 'Database error.', 'common', 'en', '', 0),
(907, 'delete', 'Delete', 'Delete', 'common', 'en', '', 0),
(908, 'deleted', 'Deleted.', 'Deleted.', 'common', 'en', '', 0),
(909, 'desc', 'Descending', 'Descending', 'common', 'en', '', 0),
(910, 'description', 'Description', 'Description', 'common', 'en', '', 0),
(911, 'default', 'Default', 'Default', 'common', 'en', '', 0),
(912, 'details', 'Details', 'Details', 'common', 'en', '', 0),
(913, 'disabled', 'Disabled', 'Disabled', 'common', 'en', '', 0),
(914, 'discard', 'Discard', 'Discard', 'common', 'en', '', 0),
(915, 'done', 'Done', 'Done', 'common', 'en', '', 0),
(916, 'download', 'Download', 'Download', 'common', 'en', '', 0),
(917, 'draft', 'Draft', 'Draft', 'common', 'en', '', 0),
(918, 'drop_files_here', 'Drop images here or click to choose...', 'Drop images here or click to choose...', 'common', 'en', '', 0),
(919, 'email', 'Email', 'Email', 'common', 'en', '', 0),
(920, 'edit', 'Edit', 'Edit', 'common', 'en', '', 0),
(921, 'edit_block', 'Edit block', 'Edit block', 'common', 'en', '', 0),
(922, 'edit_position', 'Edit position', 'Edit position', 'common', 'en', '', 0),
(923, 'enabled', 'Enabled', 'Enabled', 'common', 'en', '', 0),
(924, 'exit', 'Exit', 'Exit', 'common', 'en', '', 0),
(925, 'module', 'Module', 'Module', 'common', 'en', '', 0),
(926, 'empty_login', 'Either login or password is empty.', 'Either login or password is empty.', 'common', 'en', '', 0),
(927, 'err_message', 'Message cannot be empty.', 'Message cannot be empty.', 'common', 'en', '', 0),
(928, 'error', 'Error', 'Error', 'common', 'en', '', 0),
(929, 'error_directory_readonly', 'Upload directory is not writable.', 'Upload directory is not writable.', 'common', 'en', '', 0),
(930, 'error_duplicate_email', 'Email is already taken for another member. Please input a different email address.', 'Email is already taken for another member. Please input a different email address.', 'common', 'en', '', 0),
(931, 'error_email_incorrect', 'E-mail is incorrect.', 'E-mail is incorrect.', 'common', 'en', '', 0),
(932, 'error_login', 'Either login or password is invalid.', 'Either login or password is invalid.', 'common', 'en', '', 0),
(933, 'error_password_empty', 'Please input correct password.', 'Please input correct password.', 'common', 'en', '', 0),
(934, 'error_password_match', 'Password does not match.', 'Password does not match.', 'common', 'en', '', 0),
(935, 'error_phone_incorrect', 'Phone is incorrect.', 'Phone is incorrect.', 'common', 'en', '', 0),
(936, 'error_tmp_directory_readonly', 'Temp directory is readonly. Please make it writable.', 'Temp directory is readonly. Please make it writable.', 'common', 'en', '', 0),
(937, 'error_url', 'Site URL is incorrect.', 'Site URL is incorrect.', 'common', 'en', '', 0),
(938, 'failed', 'Failed', 'Failed', 'common', 'en', '', 0),
(939, 'featured', 'Featured', 'Featured', 'common', 'en', '', 0),
(940, 'featured_status_finished_date_is_empty', 'Listing has been marked as featured, but no finished date was specified.', 'Listing has been marked as featured, but no finished date was specified.', 'common', 'en', '', 0),
(941, 'filter', 'Filter', 'Filter', 'common', 'en', '', 0),
(942, 'forgot_password', 'Forgot your password?', 'Forgot your password?', 'common', 'en', '', 0),
(943, 'format', 'Format', 'Format', 'common', 'en', '', 0),
(944, 'from', 'from', 'from', 'common', 'en', '', 0),
(945, 'fullname', 'Full Name', 'Full Name', 'common', 'en', '', 0),
(946, 'funds', 'Funds', 'Funds', 'common', 'en', '', 0),
(947, 'field__tooltip', 'please upload only image files', 'please upload only image files', 'common', 'en', '', 0),
(948, 'field_member_api_push_token', 'Push Token of your phone', 'Push Token of your phone', 'common', 'en', '', 0),
(949, 'field_member_api_push_receive', 'Do you agree to receive push notifications to your phone?', 'Do you agree to receive push notifications to your phone?', 'common', 'en', '', 0),
(950, 'field_member_api_push_receive+yes', 'Yes', 'Yes', 'common', 'en', '', 0),
(951, 'field_member_api_push_receive+no', 'No', 'No', 'common', 'en', '', 0),
(952, 'field_member_avatar', 'Avatar', 'Avatar', 'common', 'en', '', 0),
(953, 'field_tooltip_member_avatar', 'Please upload image files only', 'Please upload image files only', 'common', 'en', '', 0);
INSERT INTO `[[dbprefix]]language` VALUES
(954, 'field_member_biography', 'Biography', 'Biography', 'common', 'en', '', 0),
(955, 'field_tooltip_member_category_id', 'Select a category from the list', 'Select a category from the list', 'common', 'en', '', 0),
(956, 'field_member_email', 'Email', 'Email', 'common', 'en', '', 0),
(957, 'field_member_email_language', 'Email receiving language', 'Email receiving language', 'common', 'en', '', 0),
(958, 'field_member_facebook', 'Facebook', 'Facebook', 'common', 'en', '', 0),
(959, 'field_tooltip_member_facebook', 'Full link to your profile page', 'Full link to your profile page', 'common', 'en', '', 0),
(960, 'field_member_fullname', 'Full Name', 'Full Name', 'common', 'en', '', 0),
(961, 'field_member_gplus', 'Google+', 'Google+', 'common', 'en', '', 0),
(962, 'field_tooltip_member_gplus', 'Full link to your profile page', 'Full link to your profile page', 'common', 'en', '', 0),
(963, 'field_member_linkedin', 'LinkedIn', 'LinkedIn', 'common', 'en', '', 0),
(964, 'field_tooltip_member_linkedin', 'Full link to your profile page', 'Full link to your profile page', 'common', 'en', '', 0),
(965, 'field_member_phone', 'Phone', 'Phone', 'common', 'en', '', 0),
(966, 'field_member_twitter', 'Twitter', 'Twitter', 'common', 'en', '', 0),
(967, 'field_tooltip_member_twitter', 'Full link to your profile page', 'Full link to your profile page', 'common', 'en', '', 0),
(968, 'field_member_username', 'Username', 'Username', 'common', 'en', '', 0),
(969, 'field_member_website', 'Website', 'Website', 'common', 'en', '', 0),
(970, 'field_description', 'Description', 'Description', 'common', 'en', '', 0),
(971, 'field_gallery', 'Pictures', 'Pictures', 'common', 'en', '', 0),
(972, 'field_is_empty', ':field is empty.', ':field is empty.', 'common', 'en', '', 0),
(973, 'field_is_not_selected', ':field is not selected.', ':field is not selected.', 'common', 'en', '', 0),
(974, 'field_item', 'Item', 'Item', 'common', 'en', '', 0),
(975, 'field_pictures', 'Pictures', 'Pictures', 'common', 'en', '', 0),
(976, 'field_transaction_amount', 'Amount', 'Amount', 'common', 'en', '', 0),
(977, 'field_transaction_currency', 'Currency code', 'Currency code', 'common', 'en', '', 0),
(978, 'field_transaction_date_created', 'Date created', 'Date created', 'common', 'en', '', 0),
(979, 'field_transaction_date_paid', 'Date paid', 'Date paid', 'common', 'en', '', 0),
(980, 'field_transaction_gateway', 'Gateway', 'Gateway', 'common', 'en', '', 0),
(981, 'field_transaction_member_id', 'Member username', 'Member username', 'common', 'en', '', 0),
(982, 'field_transaction_operation', 'Operation', 'Operation', 'common', 'en', '', 0),
(983, 'field_transaction_reference_id', 'Order number', 'Order number', 'common', 'en', '', 0),
(984, 'field_transaction_sec_key', 'Secret key', 'Secret key', 'common', 'en', '', 0),
(985, 'field_transaction_status', 'Status', 'Status', 'common', 'en', '', 0),
(986, 'field_transaction_total', 'Total', 'Total', 'common', 'en', '', 0),
(987, 'fieldgroup_member_api', 'API', 'API', 'common', 'en', '', 0),
(988, 'fieldgroup_member_general', 'General', 'General', 'common', 'en', '', 0),
(989, 'fieldgroup_member_social', 'Social', 'Social', 'common', 'en', '', 0),
(990, 'fieldgroup_description_member_api', 'Subrion API related data', 'Subrion API related data', 'common', 'en', '', 0),
(991, 'fieldgroup_description_member_general', '', '', 'common', 'en', '', 0),
(992, 'fieldgroup_description_member_social', '', '', 'common', 'en', '', 0),
(993, 'file_click_to_upload', 'Click Browse to upload file', 'Click Browse to upload file', 'common', 'en', '', 0),
(994, 'file_type_error', 'Files with ":extension" extension are only allowed.', 'Files with ":extension" extension are only allowed.', 'common', 'en', '', 0),
(995, 'file_types', 'Allowed file types (comma separated values (don''t include point), example: pdf, doc, odf, mov)', 'Allowed file types (comma separated values (don''t include point), example: pdf, doc, odf, mov)', 'common', 'en', '', 0),
(996, 'filename', 'Filename', 'Filename', 'common', 'en', '', 0),
(997, 'gateway', 'Gateway', 'Gateway', 'common', 'en', '', 0),
(998, 'general', 'General', 'General', 'common', 'en', '', 0),
(999, 'general_info', 'General Information', 'General Information', 'common', 'en', '', 0),
(1000, 'go', 'Go', 'Go', 'common', 'en', '', 0),
(1001, 'group', 'Group', 'Group', 'common', 'en', '', 0),
(1002, 'hours', 'hours', 'hours', 'common', 'en', '', 0),
(1003, 'hide_everywhere', 'Hide everywhere', 'Hide everywhere', 'common', 'en', '', 0),
(1004, 'image', 'Image', 'Image', 'common', 'en', '', 0),
(1005, 'image_click_to_upload', 'Click Browse to upload image', 'Click Browse to upload image', 'common', 'en', '', 0),
(1006, 'image_width', 'Image Width', 'Image Width', 'common', 'en', '', 0),
(1007, 'incorrect_fullname', 'Please input correct full name.', 'Please input correct full name.', 'common', 'en', '', 0),
(1008, 'invalid_parameters', 'Invalid parameters.', 'Invalid parameters.', 'common', 'en', '', 0),
(1009, 'ip_address', 'IP Address', 'IP Address', 'common', 'en', '', 0),
(1010, 'item', 'Item', 'Item', 'common', 'en', '', 0),
(1011, 'key', 'Key', 'Key', 'common', 'en', '', 0),
(1012, 'keywords', 'Keywords', 'Keywords', 'common', 'en', '', 0),
(1013, 'language', 'Language', 'Language', 'common', 'en', '', 0),
(1014, 'languages', 'Languages', 'Languages', 'common', 'en', '', 0),
(1015, 'last_login_date', 'Logged in', 'Logged in', 'common', 'en', '', 0),
(1016, 'listings', 'Listings', 'Listings', 'common', 'en', '', 0),
(1017, 'loading', 'Loading ...', 'Loading ...', 'common', 'en', '', 0),
(1018, 'locked', 'Locked', 'Locked', 'common', 'en', '', 0),
(1019, 'login', 'Login', 'Login', 'common', 'en', '', 0),
(1020, 'logout', 'Logout', 'Logout', 'common', 'en', '', 0),
(1021, 'main_page', 'Home', 'Home', 'common', 'en', '', 0),
(1022, 'mark_as', 'Mark As:', 'Mark As:', 'common', 'en', '', 0),
(1023, 'member', 'Member', 'Member', 'common', 'en', '', 0),
(1024, 'members', 'Members', 'Members', 'common', 'en', '', 0),
(1025, 'month', 'Month', 'Month', 'common', 'en', '', 0),
(1026, 'month1', 'January', 'January', 'common', 'en', '', 0),
(1027, 'month2', 'February', 'February', 'common', 'en', '', 0),
(1028, 'month3', 'March', 'March', 'common', 'en', '', 0),
(1029, 'month4', 'April', 'April', 'common', 'en', '', 0),
(1030, 'month5', 'May', 'May', 'common', 'en', '', 0),
(1031, 'month6', 'June', 'June', 'common', 'en', '', 0),
(1032, 'month7', 'July', 'July', 'common', 'en', '', 0),
(1033, 'month8', 'August', 'August', 'common', 'en', '', 0),
(1034, 'month9', 'September', 'September', 'common', 'en', '', 0),
(1035, 'month10', 'October', 'October', 'common', 'en', '', 0),
(1036, 'month11', 'November', 'November', 'common', 'en', '', 0),
(1037, 'month12', 'December', 'December', 'common', 'en', '', 0),
(1038, 'months', 'months', 'months', 'common', 'en', '', 0),
(1039, 'more', 'More', 'More', 'common', 'en', '', 0),
(1040, 'move', 'Move', 'Move', 'common', 'en', '', 0),
(1041, 'move_to', 'Move To:', 'Move To:', 'common', 'en', '', 0),
(1042, 'multilingual_field_is_empty', ':field is empty for :lang.', ':field is empty for :lang.', 'common', 'en', '', 0),
(1043, 'name', 'Name', 'Name', 'common', 'en', '', 0),
(1044, 'next', 'Next', 'Next', 'common', 'en', '', 0),
(1045, 'no', 'No', 'No', 'common', 'en', '', 0),
(1046, 'no_items', 'No items.', 'No items.', 'common', 'en', '', 0),
(1047, 'no_more_files', 'You can not upload more files. Limit exceeded.', 'You can not upload more files. Limit exceeded.', 'common', 'en', '', 0),
(1048, 'no_uploaded_files_processed', 'No uploaded files processed due to file extension restrictions.', 'No uploaded files processed due to file extension restrictions.', 'common', 'en', '', 0),
(1049, 'nothing_found', 'Nothing found.', 'Nothing found.', 'common', 'en', '', 0),
(1050, 'ok', 'Ok', 'Ok', 'common', 'en', '', 0),
(1051, 'on', 'on', 'on', 'common', 'en', '', 0),
(1052, 'online_members', 'Online Members', 'Online Members', 'common', 'en', '', 0),
(1053, 'operation', 'Operation', 'Operation', 'common', 'en', '', 0),
(1054, 'open_close', 'Show / Hide the tree', 'Show / Hide the tree', 'common', 'en', '', 0),
(1055, 'open_in_new_tab', 'Open in new tab', 'Open in new tab', 'common', 'en', '', 0),
(1056, 'order', 'Order', 'Order', 'common', 'en', '', 0),
(1057, 'other', 'Other', 'Other', 'common', 'en', '', 0),
(1058, 'page', 'Page', 'Page', 'common', 'en', '', 0),
(1059, 'page_url_will_be', 'Page URL will be', 'Page URL will be', 'common', 'en', '', 0),
(1060, 'pages', 'Pages', 'Pages', 'common', 'en', '', 0),
(1061, 'parent', 'Parent', 'Parent', 'common', 'en', '', 0),
(1062, 'passed', 'Passed', 'Passed', 'common', 'en', '', 0),
(1063, 'password', 'Password', 'Password', 'common', 'en', '', 0),
(1064, 'password_confirm', 'Password confirmation', 'Password confirmation', 'common', 'en', '', 0),
(1065, 'password_incorrect', 'Password is incorrect.', 'Password is incorrect.', 'common', 'en', '', 0),
(1066, 'payment_gateway', 'Payment gateway', 'Payment gateway', 'common', 'en', '', 0),
(1067, 'pending', 'Pending', 'Pending', 'common', 'en', '', 0),
(1068, 'phone', 'Phone', 'Phone', 'common', 'en', '', 0),
(1069, 'plan_added', 'Plan added.', 'Plan added.', 'common', 'en', '', 0),
(1070, 'plans', 'Plans', 'Plans', 'common', 'en', '', 0),
(1071, 'position', 'Position', 'Position', 'common', 'en', '', 0),
(1072, 'previous', 'Previous', 'Previous', 'common', 'en', '', 0),
(1073, 'print', 'Print', 'Print', 'common', 'en', '', 0),
(1074, 'print_invoice', 'Print invoice', 'Print invoice', 'common', 'en', '', 0),
(1075, 'profile', 'Profile', 'Profile', 'common', 'en', '', 0),
(1076, 'rank', 'Rank', 'Rank', 'common', 'en', '', 0),
(1077, 'read', 'Read', 'Read', 'common', 'en', '', 0),
(1078, 'recurring', 'Recurring', 'Recurring', 'common', 'en', '', 0),
(1079, 'reference_id', 'Reference ID', 'Reference ID', 'common', 'en', '', 0),
(1080, 'refresh', 'Refresh', 'Refresh', 'common', 'en', '', 0),
(1081, 'refunded', 'Refunded', 'Refunded', 'common', 'en', '', 0),
(1082, 'regular', 'Regular', 'Regular', 'common', 'en', '', 0),
(1083, 'remember_me', 'Remember me', 'Remember me', 'common', 'en', '', 0),
(1084, 'remove', 'Remove', 'Remove', 'common', 'en', '', 0),
(1085, 'reset', 'Reset', 'Reset', 'common', 'en', '', 0),
(1086, 'restore_password', 'Restore Password', 'Restore Password', 'common', 'en', '', 0),
(1087, 'rss', 'RSS', 'RSS', 'common', 'en', '', 0),
(1088, 'save', 'Save', 'Save', 'common', 'en', '', 0),
(1089, 'saved', 'Saved.', 'Saved.', 'common', 'en', '', 0),
(1090, 'save_changes', 'Save Changes', 'Save Changes', 'common', 'en', '', 0),
(1091, 'saving', 'Saving...', 'Saving...', 'common', 'en', '', 0),
(1092, 'search', 'Search', 'Search', 'common', 'en', '', 0),
(1093, 'searchable', 'Searchable', 'Searchable', 'common', 'en', '', 0),
(1094, 'select_category_from_list', 'Select a category from the list', 'Select a category from the list', 'common', 'en', '', 0),
(1095, 'send', 'Send', 'Send', 'common', 'en', '', 0),
(1096, 'show_everywhere', 'Show everywhere', 'Show everywhere', 'common', 'en', '', 0),
(1097, 'show_on_all_pages', 'Global visibility', 'Global visibility', 'common', 'en', '', 0),
(1098, 'show_on_this_page', 'Show on this page', 'Show on this page', 'common', 'en', '', 0),
(1099, 'sponsored', 'Sponsored', 'Sponsored', 'common', 'en', '', 0),
(1100, 'start_typing_to_filter', 'Start typing to filter items', 'Start typing to filter items', 'common', 'en', '', 0),
(1101, 'status', 'Status', 'Status', 'common', 'en', '', 0),
(1102, 'subject', 'Subject', 'Subject', 'common', 'en', '', 0),
(1103, 'submit', 'Submit', 'Submit', 'common', 'en', '', 0),
(1104, 'subscription', 'Subscription', 'Subscription', 'common', 'en', '', 0),
(1105, 'summary', 'Summary', 'Summary', 'common', 'en', '', 0),
(1106, 'sure_rm_file', 'Are you sure want to remove the file?', 'Are you sure want to remove the file?', 'common', 'en', '', 0),
(1107, 'suspended', 'Suspended', 'Suspended', 'common', 'en', '', 0),
(1108, 'title', 'Title', 'Title', 'common', 'en', '', 0),
(1109, 'title_incorrect', 'Title is incorrect.', 'Title is incorrect.', 'common', 'en', '', 0),
(1110, 'title_is_empty', 'Title is empty.', 'Title is empty.', 'common', 'en', '', 0),
(1111, 'templates', 'Templates', 'Templates', 'common', 'en', '', 0),
(1112, 'time', 'Time', 'Time', 'common', 'en', '', 0),
(1113, 'total', 'Total', 'Total', 'common', 'en', '', 0),
(1114, 'transaction', 'Transaction ', 'Transaction ', 'common', 'en', '', 0),
(1115, 'transactions', 'Transactions', 'Transactions', 'common', 'en', '', 0),
(1116, 'tree', 'Tree', 'Tree', 'common', 'en', '', 0),
(1117, 'type_email_here', 'Type your email here', 'Type your email here', 'common', 'en', '', 0),
(1118, 'url', 'URL', 'URL', 'common', 'en', '', 0),
(1119, 'unconfirmed', 'Unconfirmed', 'Unconfirmed', 'common', 'en', '', 0),
(1120, 'upload', 'Upload', 'Upload', 'common', 'en', '', 0),
(1121, 'upload_correct_permission', 'Couldn''t copy uploaded image to the destination folder. Please make sure that the script has write permissions.', 'Couldn''t copy uploaded image to the destination folder. Please make sure that the script has write permissions.', 'common', 'en', '', 0),
(1122, 'upload_pictures', 'Upload Picture(s)', 'Upload Picture(s)', 'common', 'en', '', 0),
(1123, 'upload_successful', 'Upload successfully completed', 'Upload successfully completed', 'common', 'en', '', 0),
(1124, 'uploading_please_wait', 'Uploading, please wait...', 'Uploading, please wait...', 'common', 'en', '', 0),
(1125, 'users', 'Users', 'Users', 'common', 'en', '', 0),
(1126, 'usergroup', 'Usergroup', 'Usergroup', 'common', 'en', '', 0),
(1127, 'username', 'Username', 'Username', 'common', 'en', '', 0),
(1128, 'username_incorrect', 'Username is incorrect.', 'Username is incorrect.', 'common', 'en', '', 0),
(1129, 'usergroup_administrators', 'Administrators', 'Administrators', 'common', 'en', '', 0),
(1130, 'usergroup_moderators', 'Moderators', 'Moderators', 'common', 'en', '', 0),
(1131, 'usergroup_guests', 'Guests', 'Guests', 'common', 'en', '', 0),
(1132, 'usergroup_registered', 'Registered', 'Registered', 'common', 'en', '', 0),
(1133, 'value', 'Value', 'Value', 'common', 'en', '', 0),
(1134, 'view', 'View', 'View', 'common', 'en', '', 0),
(1135, 'view_all', 'View All', 'View All', 'common', 'en', '', 0),
(1136, 'views', 'Views', 'Views', 'common', 'en', '', 0),
(1137, 'weeks', 'weeks', 'weeks', 'common', 'en', '', 0),
(1138, 'write', 'Write', 'Write', 'common', 'en', '', 0),
(1139, 'years', 'years', 'years', 'common', 'en', '', 0),
(1140, 'yes', 'Yes', 'Yes', 'common', 'en', '', 0),
(1141, 'zip', 'ZIP', 'ZIP', 'common', 'en', '', 0),
(1142, 'active_users', 'Active Users', 'Active Users', 'frontend', 'en', '', 0),
(1143, 'add_funds_text', 'Add funds to your account with us to avoid lots of small transactions and to automatically take care of any new invoices to generate.', 'Add funds to your account with us to avoid lots of small transactions and to automatically take care of any new invoices to generate.', 'frontend', 'en', '', 0),
(1144, 'advanced', 'Advanced', 'Advanced', 'frontend', 'en', '', 0),
(1145, 'alphabetical', 'Alphabetical', 'Alphabetical', 'frontend', 'en', '', 0),
(1146, 'all_groups', 'All groups', 'All groups', 'frontend', 'en', '', 0),
(1147, 'amount_incorrect', 'Please input correct amount. It should be within :min & :max :currency.', 'Please input correct amount. It should be within :min & :max :currency.', 'frontend', 'en', '', 0),
(1148, 'amount_to_add', 'Amount to add', 'Amount to add', 'frontend', 'en', '', 0),
(1149, 'min_deposit', 'Minimum deposit', 'Minimum deposit', 'frontend', 'en', '', 0),
(1150, 'max_deposit', 'Maximum deposit', 'Maximum deposit', 'frontend', 'en', '', 0),
(1151, 'max_balance', 'Maximum balance', 'Maximum balance', 'frontend', 'en', '', 0),
(1152, 'and_more', 'and more', 'and more', 'frontend', 'en', '', 0),
(1153, 'are_you_sure_to_cancel_invoice', 'Are you sure you want to cancel your invoice?', 'Are you sure you want to cancel your invoice?', 'frontend', 'en', '', 0),
(1154, 'author_contact_request', 'Contact request regarding ":title"', 'Contact request regarding ":title"', 'frontend', 'en', '', 0),
(1155, 'auto_generate_password', 'Auto generate password', 'Auto generate password', 'frontend', 'en', '', 0),
(1156, 'back_to_gateway_list', '{current_gateway} payment gateway, click <a href="javaScript:void(0);" onclick="backToPaymentGatewayList()">here</a> to choose another one', '{current_gateway} payment gateway, click <a href="javaScript:void(0);" onclick="backToPaymentGatewayList()">here</a> to choose another one', 'frontend', 'en', '', 0),
(1157, 'back_to_profile', 'Back to profile', 'Back to profile', 'frontend', 'en', '', 0),
(1158, 'billing_address', 'Billing Address', 'Billing Address', 'frontend', 'en', '', 0),
(1159, 'bots', 'Bots', 'Bots', 'frontend', 'en', '', 0),
(1160, 'bots_visits', 'Visits last 24h (bots)', 'Visits last 24h (bots)', 'frontend', 'en', '', 0),
(1161, 'by_fullname', 'full name', 'full name', 'frontend', 'en', '', 0),
(1162, 'by_username', 'username', 'username', 'frontend', 'en', '', 0),
(1163, 'by_name', 'By name', 'By name', 'frontend', 'en', '', 0),
(1164, 'by_registration_date', 'By registration date', 'By registration date', 'frontend', 'en', '', 0),
(1165, 'change_gateway', 'Change gateway', 'Change gateway', 'frontend', 'en', '', 0),
(1166, 'chars_left', 'Chars left', 'Chars left', 'frontend', 'en', '', 0),
(1167, 'choose_image_file', 'and choose image file on your computer.', 'and choose image file on your computer.', 'frontend', 'en', '', 0),
(1168, 'confirmation_code_incorrect', 'Captcha code is incorrect.', 'Captcha code is incorrect.', 'frontend', 'en', '', 0),
(1169, 'confirmation_key_incorrect', 'Confirmation key is incorrect.', 'Confirmation key is incorrect.', 'frontend', 'en', '', 0),
(1170, 'current_assets', 'Current Assets', 'Current Assets', 'frontend', 'en', '', 0),
(1171, 'current_password', 'Current Password', 'Current Password', 'frontend', 'en', '', 0),
(1172, 'date_added', 'Date', 'Date', 'frontend', 'en', '', 0),
(1173, 'delete_listing', 'Remove Listing', 'Remove Listing', 'frontend', 'en', '', 0),
(1174, 'do_authorize_to_save_search', 'Please, authorize to be able to save your searches.', 'Please, authorize to be able to save your searches.', 'frontend', 'en', '', 0),
(1175, 'dont_wait_redir', 'Click here if you do not want to wait.', 'Click here if you do not want to wait.', 'frontend', 'en', '', 0),
(1176, 'edit_listing', 'Edit Listing', 'Edit Listing', 'frontend', 'en', '', 0),
(1177, 'edit_subject', 'Edit subject', 'Edit subject', 'frontend', 'en', '', 0),
(1178, 'edited_by', '<i>Last edited by <a href="{%URL%}">{%USER%}</a></i>', '<i>Last edited by <a href="{%URL%}">{%USER%}</a></i>', 'frontend', 'en', '', 0),
(1179, 'empty_image_title', 'Empty', 'Empty', 'frontend', 'en', '', 0),
(1180, 'enter_confirmation_code', 'Please enter confirmation code below', 'Please enter confirmation code below', 'frontend', 'en', '', 0),
(1181, 'error_no_member_email', 'No members registered with this email.', 'No members registered with this email.', 'frontend', 'en', '', 0),
(1182, 'favorites', 'Favorites', 'Favorites', 'frontend', 'en', '', 0),
(1183, 'favorites_action_add', 'Add to favorites', 'Add to favorites', 'frontend', 'en', '', 0),
(1184, 'favorites_action_added', 'Listing has been added to favorites.', 'Listing has been added to favorites.', 'frontend', 'en', '', 0),
(1185, 'favorites_action_delete', 'Remove from favorites', 'Remove from favorites', 'frontend', 'en', '', 0),
(1186, 'favorites_action_deleted', 'Listing has been deleted from favorites.', 'Listing has been deleted from favorites.', 'frontend', 'en', '', 0),
(1187, 'field_required', '<span class="note">[Required]</span>', '<span class="note">[Required]</span>', 'frontend', 'en', '', 0),
(1188, 'first', 'First', 'First', 'frontend', 'en', '', 0),
(1189, 'forgot', 'Forgot password?', 'Forgot password?', 'frontend', 'en', '', 0),
(1190, 'forgot_tooltip', 'Don''t remember your login information? We all forget &mdash; no worries. Please enter your e-mail address below and we will send your login credentials.', 'Don''t remember your login information? We all forget &mdash; no worries. Please enter your e-mail address below and we will send your login credentials.', 'frontend', 'en', '', 0),
(1191, 'funds_in_your_account', 'You have :currency :sum in your account.', 'You have :currency :sum in your account.', 'frontend', 'en', '', 0),
(1192, 'group_filter', 'Group filter', 'Group filter', 'frontend', 'en', '', 0),
(1193, 'guest', 'Guest', 'Guest', 'frontend', 'en', '', 0),
(1194, 'guests', 'Guests', 'Guests', 'frontend', 'en', '', 0),
(1195, 'howmuch_funds', 'Please input the amount you want to add:', 'Please input the amount you want to add:', 'frontend', 'en', '', 0),
(1196, 'invalid_addressee', 'Invalid addressee specified.', 'Invalid addressee specified.', 'frontend', 'en', '', 0),
(1197, 'invoice_deleted', 'Invoice deleted.', 'Invoice deleted.', 'frontend', 'en', '', 0),
(1198, 'last', 'Last', 'Last', 'frontend', 'en', '', 0),
(1199, 'listing_successfully_removed', 'Listing data has been removed.', 'Listing data has been removed.', 'frontend', 'en', '', 0),
(1200, 'listing_successfully_submitted', 'Listing has been successfully submitted.', 'Listing has been successfully submitted.', 'frontend', 'en', '', 0),
(1201, 'listing_successfully_updated', 'Listing data has been successfully updated.', 'Listing data has been successfully updated.', 'frontend', 'en', '', 0),
(1202, 'live_visits', 'Visits last 24h (live)', 'Visits last 24h (live)', 'frontend', 'en', '', 0),
(1203, 'login_with_social_network', 'Login with social network', 'Login with social network', 'frontend', 'en', '', 0),
(1204, 'mail_sent', 'Email sent.', 'Email sent.', 'frontend', 'en', '', 0),
(1205, 'member_created', 'Member registered! Thank you!', 'Member registered! Thank you!', 'frontend', 'en', '', 0),
(1206, 'member_doesnt_exist', 'The member does not exist anymore.', 'The member does not exist anymore.', 'frontend', 'en', '', 0),
(1207, 'member_since', 'Member since', 'Member since', 'frontend', 'en', '', 0),
(1208, 'msg', 'Message', 'Message', 'frontend', 'en', '', 0),
(1209, 'my_saved_searches', 'My saved searches', 'My saved searches', 'frontend', 'en', '', 0),
(1210, 'my_searches', 'My searches', 'My searches', 'frontend', 'en', '', 0),
(1211, 'new_password', 'New Password', 'New Password', 'frontend', 'en', '', 0),
(1212, 'new_password2', 'New Password [confirm]', 'New Password [confirm]', 'frontend', 'en', '', 0),
(1213, 'new_password_sent', 'New password has been sent to your email.', 'New password has been sent to your email.', 'frontend', 'en', '', 0),
(1214, 'no_funds', 'You have not added funds to your account.', 'You have not added funds to your account.', 'frontend', 'en', '', 0),
(1215, 'no_favorites', 'You have not added any favorite items.', 'You have not added any favorite items.', 'frontend', 'en', '', 0),
(1216, 'no_gateway', 'You have not installed any payment gateway plugin.', 'You have not installed any payment gateway plugin.', 'frontend', 'en', '', 0),
(1217, 'no_members', 'No members found that match specified params.', 'No members found that match specified params.', 'frontend', 'en', '', 0),
(1218, 'no_transaction', 'Sorry, no such transaction.', 'Sorry, no such transaction.', 'frontend', 'en', '', 0),
(1219, 'no_transactions_records', 'You do not have any payment records in your history.', 'You do not have any payment records in your history.', 'frontend', 'en', '', 0),
(1220, 'num_results_found', 'Results found: <strong id="js-search-results-num">0</strong>', 'Results found: <strong id="js-search-results-num">0</strong>', 'frontend', 'en', '', 0),
(1221, 'online', 'Online', 'Online', 'frontend', 'en', '', 0),
(1222, 'page_preview', 'This is how your page will look like once you save it in admin panel.', 'This is how your page will look like once you save it in admin panel.', 'frontend', 'en', '', 0),
(1223, 'paid_subscription_will_cancel', 'In case you select this option, your already paid subscription will cancel.', 'In case you select this option, your already paid subscription will cancel.', 'frontend', 'en', '', 0),
(1224, 'password_changed', 'Password has been changed.', 'Password has been changed.', 'frontend', 'en', '', 0),
(1225, 'password_empty', 'You have not entered a new password.', 'You have not entered a new password.', 'frontend', 'en', '', 0),
(1226, 'password_protected_page', 'You must input a password to view this page.', 'You must input a password to view this page.', 'frontend', 'en', '', 0),
(1227, 'pay', 'Pay', 'Pay', 'frontend', 'en', '', 0),
(1228, 'pay_using_account_funds', 'Pay using the funds available in your account.', 'Pay using the funds available in your account.', 'frontend', 'en', '', 0),
(1229, 'pay_external', 'Pay via payment system.', 'Pay via payment system.', 'frontend', 'en', '', 0),
(1230, 'pay_via_payment_gateways', 'You can pay via payment gateways.', 'You can pay via payment gateways.', 'frontend', 'en', '', 0),
(1231, 'pay_reason', 'Reason', 'Reason', 'frontend', 'en', '', 0),
(1232, 'payer_name', 'Payer name', 'Payer name', 'frontend', 'en', '', 0),
(1233, 'payer_email', 'Payer email', 'Payer email', 'frontend', 'en', '', 0),
(1234, 'payment', 'Payment', 'Payment', 'frontend', 'en', '', 0),
(1235, 'payment_cancellation', 'Payment cancellation', 'Payment cancellation', 'frontend', 'en', '', 0),
(1236, 'payment_process_canceled', 'Payment process canceled.', 'Payment process canceled.', 'frontend', 'en', '', 0),
(1237, 'payment_details', 'Payment details', 'Payment details', 'frontend', 'en', '', 0),
(1238, 'payment_done', 'Thank you for your payment. Your transaction has been completed.', 'Thank you for your payment. Your transaction has been completed.', 'frontend', 'en', '', 0),
(1239, 'payment_date', 'Payment Date', 'Payment Date', 'frontend', 'en', '', 0),
(1240, 'payment_gateway_not_chosen', 'Please choose payment gateway', 'Please choose payment gateway', 'frontend', 'en', '', 0),
(1241, 'payment_redirect_message', 'You will be automatically redirected to the item''s page in :seconds. If you do not want to wait click the button below:', 'You will be automatically redirected to the item''s page in :seconds. If you do not want to wait click the button below:', 'frontend', 'en', '', 0),
(1242, 'payment_status', 'Payment status', 'Payment status', 'frontend', 'en', '', 0),
(1243, 'pictures', 'Pictures', 'Pictures', 'frontend', 'en', '', 0),
(1244, 'powered_by_subrion', 'Powered by <a href="https://subrion.org" title="Open Source CMS">Subrion CMS</a>', 'Powered by <a href="https://subrion.org" title="Open Source CMS">Subrion CMS</a>', 'frontend', 'en', '', 0),
(1245, 'print_preview', 'Print Page', 'Print Page', 'frontend', 'en', '', 0),
(1246, 'proceed_pay', 'Proceed to Payment', 'Proceed to Payment', 'frontend', 'en', '', 0),
(1247, 'protected_page', 'Protected page', 'Protected page', 'frontend', 'en', '', 0),
(1248, 'reg_confirm_adm_approve', 'Member confirmed. But it must be approved by administrator, usually it takes about 24 hours.', 'Member confirmed. But it must be approved by administrator, usually it takes about 24 hours.', 'frontend', 'en', '', 0),
(1249, 'reg_confirmation', 'Registration Confirmation', 'Registration Confirmation', 'frontend', 'en', '', 0),
(1250, 'reg_confirmed', 'Member confirmed. Please sign in.', 'Member confirmed. Please sign in.', 'frontend', 'en', '', 0),
(1251, 'registration', 'Registration', 'Registration', 'frontend', 'en', '', 0),
(1252, 'redirected_to_home', 'to be redirected to the home page.', 'to be redirected to the home page.', 'frontend', 'en', '', 0),
(1253, 'register_login', 'Please Login or Register', 'Please Login or Register', 'frontend', 'en', '', 0),
(1254, 'registration_tooltip', 'Registration is simple and takes just few seconds. Please fill in the form below.', 'Registration is simple and takes just few seconds. Please fill in the form below.', 'frontend', 'en', '', 0),
(1255, 'reset_filters', 'Reset filters', 'Reset filters', 'frontend', 'en', '', 0),
(1256, 'restore_pass_confirm', 'We have sent confirmation code to your email. Please check it and follow the instructions.', 'We have sent confirmation code to your email. Please check it and follow the instructions.', 'frontend', 'en', '', 0),
(1257, 'safety', 'Safety', 'Safety', 'frontend', 'en', '', 0),
(1258, 'save_this_search', 'Save this search', 'Save this search', 'frontend', 'en', '', 0),
(1259, 'search_for', 'Search for...', 'Search for...', 'frontend', 'en', '', 0),
(1260, 'send_email', 'Send email', 'Send email', 'frontend', 'en', '', 0),
(1261, 'send_message', 'Send message', 'Send message', 'frontend', 'en', '', 0),
(1262, 'show_all_num_results', 'Show all :num results', 'Show all :num results', 'frontend', 'en', '', 0),
(1263, 'slogan', 'Content Management Software', 'Content Management Software', 'frontend', 'en', '', 0),
(1264, 'sort_by', 'Sort by', 'Sort by', 'frontend', 'en', '', 0),
(1265, 'starts_with', 'starts with', 'starts with', 'frontend', 'en', '', 0),
(1266, 'thank_text', 'to get back to index page.', 'to get back to index page.', 'frontend', 'en', '', 0),
(1267, 'thanks', 'Thank you.', 'Thank you.', 'frontend', 'en', '', 0),
(1268, 'thankyou_head', '<p>Below is the information you submitted so far. You will be able to extend and edit this information via your member account.</p><p><span class="label label-danger">Important</span> Your account password has been sent to the following email address:</p>', '<p>Below is the information you submitted so far. You will be able to extend and edit this information via your member account.</p><p><span class="label label-danger">Important</span> Your account password has been sent to the following email address:</p>', 'frontend', 'en', '', 0),
(1269, 'thankyou_tail', '<p>Please read our letter with further instructions.</p>', '<p>Please read our letter with further instructions.</p>', 'frontend', 'en', '', 0),
(1270, 'this_transaction_already_passed', 'We already have this payment in our database. Transaction passed successfully.', 'We already have this payment in our database. Transaction passed successfully.', 'frontend', 'en', '', 0),
(1271, 'total_paid', 'Total Paid', 'Total Paid', 'frontend', 'en', '', 0),
(1272, 'tools', 'Tools', 'Tools', 'frontend', 'en', '', 0),
(1273, 'unable_to_send_email', 'Unable to send e-mail.', 'Unable to send e-mail.', 'frontend', 'en', '', 0),
(1274, 'untitled', 'Untitled', 'Untitled', 'frontend', 'en', '', 0),
(1275, 'usergroups', 'Usergroups', 'Usergroups', 'frontend', 'en', '', 0),
(1276, 'username_already_exists', 'Username already taken. Please input different username.', 'Username already taken. Please input different username.', 'frontend', 'en', '', 0),
(1277, 'username_empty', 'Make sure you have entered a valid username and your membership is active.', 'Make sure you have entered a valid username and your membership is active.', 'frontend', 'en', '', 0),
(1278, 'username_or_email', 'Username or E-mail', 'Username or E-mail', 'frontend', 'en', '', 0),
(1279, 'view_profile', 'View profile', 'View profile', 'frontend', 'en', '', 0),
(1280, 'wait_for_gateway_answer', 'The payment is currently being processed by payment gateway. Please check it later. <a href=":url">Click here</a> to change payment gateway for this transaction.', 'The payment is currently being processed by payment gateway. Please check it later. <a href=":url">Click here</a> to change payment gateway for this transaction.', 'frontend', 'en', '', 0),
(1281, 'wait_redirect', 'Please wait, you will be redirected shortly.', 'Please wait, you will be redirected shortly.', 'frontend', 'en', '', 0),
(1282, 'welcome', 'Welcome', 'Welcome', 'frontend', 'en', '', 0),
(1283, 'your_name', 'Your Full Name', 'Your Full Name', 'frontend', 'en', '', 0),
(1284, 'your_email', 'Your email', 'Your email', 'frontend', 'en', '', 0),
(1285, 'your_membership_is_inactive', 'Your membership is inactive. You may not use this feature.', 'Your membership is inactive. You may not use this feature.', 'frontend', 'en', '', 0),
(1286, 'your_password', 'Your password', 'Your password', 'frontend', 'en', '', 0),
(1287, 'your_password_confirm', 'Confirm your password', 'Confirm your password', 'frontend', 'en', '', 0),
(1288, 'your_title_for_this_search', 'Your title for this search (optional)', 'Your title for this search (optional)', 'frontend', 'en', '', 0),
(1289, 'your_username', 'Your username', 'Your username', 'frontend', 'en', '', 0),
(1290, 'youre_admin_browsing_disabled_front', 'Frontend is disabled for regular members. It''s only available for admin members.', 'Frontend is disabled for regular members. It''s only available for admin members.', 'frontend', 'en', '', 0),
(1291, 'youre_in_manage_mode', 'You are in manage mode. <a href="?manage_exit=y">Exit</a>', 'You are in manage mode. <a href="?manage_exit=y">Exit</a>', 'frontend', 'en', '', 0),
(1292, 'youre_in_preview_mode', 'You are in preview mode. <a href="?preview_exit=y">Exit</a>', 'You are in preview mode. <a href="?preview_exit=y">Exit</a>', 'frontend', 'en', '', 0),
(1293, 'block_title_2', 'Inventory Menu', 'Inventory Menu', 'frontend', 'en', '', 0),
(1294, 'block_title_3', 'Main Menu', 'Main Menu', 'frontend', 'en', '', 0),
(1295, 'block_title_4', 'Member Menu', 'Member Menu', 'frontend', 'en', '', 0),
(1296, 'block_title_5', 'Bottom Menu', 'Bottom Menu', 'frontend', 'en', '', 0),
(1297, 'block_title_6', 'Statistics', 'Statistics', 'frontend', 'en', '', 0),
(1298, 'block_title_7', 'Refine Search', 'Refine Search', 'frontend', 'en', '', 0),
(1299, 'page_title_adminer', 'DB Tools', 'DB Tools', 'admin', 'en', '', 0),
(1300, 'page_title_blocks', 'Blocks', 'Blocks', 'admin', 'en', '', 0),
(1301, 'page_title_clear_cache', 'Clear Cache', 'Clear Cache', 'admin', 'en', '', 0),
(1302, 'page_title_configuration', 'Settings', 'Settings', 'admin', 'en', '', 0),
(1303, 'page_title_currencies', 'Currencies', 'Currencies', 'admin', 'en', '', 0),
(1304, 'page_title_database', 'Database', 'Database', 'admin', 'en', '', 0),
(1305, 'page_title_debugmode', 'Debug Mode', 'Debug Mode', 'admin', 'en', '', 0),
(1306, 'page_title_email_templates', 'E-mail Templates', 'E-mail Templates', 'admin', 'en', '', 0),
(1307, 'page_title_fields', 'Fields', 'Fields', 'admin', 'en', '', 0),
(1308, 'page_title_fieldgroups', 'Field Groups', 'Field Groups', 'admin', 'en', '', 0),
(1309, 'page_title_imagetypes', 'Image Types', 'Image Types', 'admin', 'en', '', 0),
(1310, 'page_title_hooks', 'Hooks', 'Hooks', 'admin', 'en', '', 0),
(1311, 'page_title_index', 'Dashboard', 'Dashboard', 'admin', 'en', '', 0),
(1312, 'page_title_invoices', 'Invoices', 'Invoices', 'admin', 'en', '', 0),
(1313, 'page_title_languages', 'Languages', 'Languages', 'admin', 'en', '', 0),
(1314, 'page_title_members', 'Members', 'Members', 'admin', 'en', '', 0),
(1315, 'page_title_member_fields', 'Member Fields', 'Member Fields', 'admin', 'en', '', 0),
(1316, 'page_title_menus', 'Menus', 'Menus', 'admin', 'en', '', 0),
(1317, 'page_title_packages', 'Packages', 'Packages', 'admin', 'en', '', 0),
(1318, 'page_title_pages', 'Pages', 'Pages', 'admin', 'en', '', 0),
(1319, 'page_title_phpinfo', 'PHP Info', 'PHP Info', 'admin', 'en', '', 0),
(1320, 'page_title_phrases', 'Phrases', 'Phrases', 'admin', 'en', '', 0),
(1321, 'page_title_plans', 'Plans', 'Plans', 'admin', 'en', '', 0),
(1322, 'page_title_plugins', 'Plugins', 'Plugins', 'admin', 'en', '', 0),
(1323, 'page_title_scheduled_tasks', 'Scheduled Tasks', 'Scheduled Tasks', 'admin', 'en', '', 0),
(1324, 'page_title_sitemap', 'Generate Sitemap', 'Generate Sitemap', 'admin', 'en', '', 0),
(1325, 'page_title_subscriptions', 'Subscriptions', 'Subscriptions', 'admin', 'en', '', 0),
(1326, 'page_title_templates', 'Templates', 'Templates', 'admin', 'en', '', 0),
(1327, 'page_title_transactions', 'Transactions', 'Transactions', 'admin', 'en', '', 0),
(1328, 'page_title_uploads', 'Uploads', 'Uploads', 'admin', 'en', '', 0),
(1329, 'page_title_usergroups', 'Usergroups', 'Usergroups', 'admin', 'en', '', 0),
(1330, 'page_title_permissions', 'Permissions', 'Permissions', 'admin', 'en', '', 0),
(1331, 'page_title_sys_mgmt', 'Management', 'Management', 'admin', 'en', '', 0),
(1332, 'page_title_sys_email', 'E-mail', 'E-mail', 'admin', 'en', '', 0),
(1333, 'page_title_sys_extra', 'Extra', 'Extra', 'admin', 'en', '', 0),
(1334, 'page_title_ctnt_ext', 'Extended', 'Extended', 'admin', 'en', '', 0),
(1335, 'page_title_ctnt_xtns', 'Extensions', 'Extensions', 'admin', 'en', '', 0),
(1336, 'page_title_mbr_ext', 'Extended', 'Extended', 'admin', 'en', '', 0),
(1337, 'page_title_fin_mgmt', 'Management', 'Management', 'admin', 'en', '', 0),
(1338, 'page_title_xtns_empt', '', '', 'admin', 'en', '', 0),
(1339, 'page_content_about', '<p>Page ''About Us'' content goes here. You can edit it in Admin Panel ->  Content -> Pages.</p>', '<p>Page ''About Us'' content goes here. You can edit it in Admin Panel ->  Content -> Pages.</p>', 'page', 'en', '', 0),
(1340, 'page_content_help', '<p>Help page content goes here. You can edit it in Admin Panel ->  Content -> Pages.</p>', '<p>Help page content goes here. You can edit it in Admin Panel ->  Content -> Pages.</p>', 'page', 'en', '', 0),
(1341, 'page_content_index', '', '', 'page', 'en', '', 0),
(1342, 'page_content_policy', '<p>Page ''Privacy Policy'' content goes here. You can edit it in Admin Panel ->  Content -> Pages.</p>', '<p>Page ''Privacy Policy'' content goes here. You can edit it in Admin Panel ->  Content -> Pages.</p>', 'page', 'en', '', 0),
(1343, 'page_content_terms', '<p>Page ''Terms Of Use'' content goes here. You can edit it in Admin Panel ->  Content -> Pages.</p>', '<p>Page ''Terms Of Use'' content goes here. You can edit it in Admin Panel ->  Content -> Pages.</p>', 'page', 'en', '', 0),
(1344, 'page_title_about', 'About Us', 'About Us', 'page', 'en', '', 0),
(1345, 'page_title_members', 'Members', 'Members', 'page', 'en', '', 0),
(1346, 'page_title_member_password_forgot', 'Forgot Password', 'Forgot Password', 'page', 'en', '', 0),
(1347, 'page_title_favorites', 'Favorites', 'Favorites', 'page', 'en', '', 0),
(1348, 'page_title_index', 'Home', 'Home', 'page', 'en', '', 0),
(1349, 'page_title_help', 'Help', 'Help', 'page', 'en', '', 0),
(1350, 'page_title_login', 'Login', 'Login', 'page', 'en', '', 0),
(1351, 'page_title_member_funds', 'Funds', 'Funds', 'page', 'en', '', 0),
(1352, 'page_title_pay', 'Pay', 'Pay', 'page', 'en', '', 0),
(1353, 'page_title_policy', 'Privacy Policy', 'Privacy Policy', 'page', 'en', '', 0),
(1354, 'page_title_profile', 'My Profile', 'My Profile', 'page', 'en', '', 0),
(1355, 'page_title_registration', 'Registration', 'Registration', 'page', 'en', '', 0),
(1356, 'page_title_register_confirm', 'Registration Confirmation', 'Registration Confirmation', 'page', 'en', '', 0),
(1357, 'page_title_redirect', 'Redirecting', 'Redirecting', 'page', 'en', '', 0),
(1358, 'page_title_search', 'Search', 'Search', 'page', 'en', '', 0),
(1359, 'page_title_terms', 'Terms of Use', 'Terms of Use', 'page', 'en', '', 0),
(1360, 'page_title_view_member', 'Member Details', 'Member Details', 'page', 'en', '', 0),
(1361, 'alias_urlencode', 'Non-Latin (non-utf8) characters are encoded into special entities instead of being romanized.', 'Non-Latin (non-utf8) characters are encoded into special entities instead of being romanized.', 'tooltip', 'en', '', 0),
(1362, 'adminonly', 'The field will only be displayed in Admin Dashboard.', 'The field will only be displayed in Admin Dashboard.', 'tooltip', 'en', '', 0),
(1363, 'api_push_access_key', 'Google Cloud Messaging (GCM) is a free service that enables developers to send messages between servers and client apps. This includes downstream messages from servers to client apps, and upstream messages from client apps to servers.', 'Google Cloud Messaging (GCM) is a free service that enables developers to send messages between servers and client apps. This includes downstream messages from servers to client apps, and upstream messages from client apps to servers.', 'tooltip', 'en', '', 0),
(1364, 'backup', 'Folder name where your DB backups are saved.', 'Folder name where your DB backups are saved.', 'tooltip', 'en', '', 0),
(1365, 'bcc_email', 'Email addresses to BCC all the outgoing messaging. To configure multiple emails, separate them by comma.', 'Email addresses to BCC all the outgoing messaging. To configure multiple emails, separate them by comma.', 'tooltip', 'en', '', 0),
(1366, 'caching', 'If you use a slow shared hosting, this will cache your pages for faster loading.', 'If you use a slow shared hosting, this will cache your pages for faster loading.', 'tooltip', 'en', '', 0),
(1367, 'empty_field', 'This text will be displayed on view item page if this field has an empty value.', 'This text will be displayed on view item page if this field has an empty value.', 'tooltip', 'en', '', 0),
(1368, 'extra_actions', 'This code is executed every time on field change. It can be used for validation or any other operation.', 'This code is executed every time on field change. It can be used for validation or any other operation.', 'tooltip', 'en', '', 0),
(1369, 'for_plan_only', 'Specifies if the field should be available only when plan chosen.', 'Specifies if the field should be available only when plan chosen.', 'tooltip', 'en', '', 0),
(1370, 'frontend_header_code', 'This code is inserted before closing HEAD tag. HTML/JS code allowed. (For example Google Analytics code)', 'This code is inserted before closing HEAD tag. HTML/JS code allowed. (For example Google Analytics code)', 'tooltip', 'en', '', 0),
(1371, 'frontend_footer_code', 'Injected before closing BODY tag. HTML/JS code allowed.', 'Injected before closing BODY tag. HTML/JS code allowed.', 'tooltip', 'en', '', 0),
(1372, 'https', 'Use secure HTTPS protocol for your site. Before enabling this, please make sure you have properly configured your hosting account and/or webserver.', 'Use secure HTTPS protocol for your site. Before enabling this, please make sure you have properly configured your hosting account and/or webserver.', 'tooltip', 'en', '', 0),
(1373, 'hybrid_enabled', 'Implements social signin on your website. You should configure API keys in includes/hybridauth.inc.php file.', 'Implements social signin on your website. You should configure API keys in includes/hybridauth.inc.php file.', 'tooltip', 'en', '', 0),
(1374, 'lang', 'Select the preferred language of your site.', 'Select the preferred language of your site.', 'tooltip', 'en', '', 0),
(1375, 'language_iso_code', 'ISO 639-1 two-letter lowercase abbreviation of your language. It is used in page URLs.', 'ISO 639-1 two-letter lowercase abbreviation of your language. It is used in page URLs.', 'tooltip', 'en', '', 0),
(1376, 'language_iso_title', 'This title is used for language selection on your frontend.', 'This title is used for language selection on your frontend.', 'tooltip', 'en', '', 0),
(1377, 'language_locale', 'Locale is an identifier used to get language, culture, or regionally-specific behavior. Contact your hosting to get the proper locale for your server.', 'Locale is an identifier used to get language, culture, or regionally-specific behavior. Contact your hosting to get the proper locale for your server.', 'tooltip', 'en', '', 0),
(1378, 'language_switch', 'Allows users to choose a language on the frontend of your site.', 'Allows users to choose a language on the frontend of your site.', 'tooltip', 'en', '', 0),
(1379, 'mail_function', 'For better delivery, it''s highly recommended to configure sending via SMTP.', 'For better delivery, it''s highly recommended to configure sending via SMTP.', 'tooltip', 'en', '', 0),
(1380, 'members_enabled', 'Enables members functionality for your Subrion CMS based website.', 'Enables members functionality for your Subrion CMS based website.', 'tooltip', 'en', '', 0),
(1381, 'members_autoapproval', 'Members are activated automatically without administrator confirmation (email confirmation is still needed).', 'Members are activated automatically without administrator confirmation (email confirmation is still needed).', 'tooltip', 'en', '', 0),
(1382, 'multilingual_field', 'Allows to have field value in different languages.', 'Allows to have field value in different languages.', 'tooltip', 'en', '', 0),
(1383, 'multiple_selection', 'Allows to choose multiple nodes.', 'Allows to choose multiple nodes.', 'tooltip', 'en', '', 0),
(1384, 'plan_cycles', 'Number of billing cycles for payment period.', 'Number of billing cycles for payment period.', 'tooltip', 'en', '', 0),
(1385, 'plan_duration', 'Duration of plan (or each cycle if recurring)', 'Duration of plan (or each cycle if recurring)', 'tooltip', 'en', '', 0),
(1386, 'regular_field', 'Specifies if the field is a host or dependent field.', 'Specifies if the field is a host or dependent field.', 'tooltip', 'en', '', 0),
(1387, 'required_checks', 'This PHP code validates the field value when Required Field is ON. Please make sure you use correct code.', 'This PHP code validates the field value when Required Field is ON. Please make sure you use correct code.', 'tooltip', 'en', '', 0),
(1388, 'search_instant', 'If enabled, the search will begin immediately once an option clicked.', 'If enabled, the search will begin immediately once an option clicked.', 'tooltip', 'en', '', 0),
(1389, 'searchable', 'Specifies if the field is available to search by on Advanced Search page.', 'Specifies if the field is available to search by on Advanced Search page.', 'tooltip', 'en', '', 0),
(1390, 'site', 'This will be your site name.', 'This will be your site name.', 'tooltip', 'en', '', 0),
(1391, 'site_email', 'All system correspondence is sent from this email address.', 'All system correspondence is sent from this email address.', 'tooltip', 'en', '', 0),
(1392, 'site_from_name', 'All system emails are from this name.', 'All system emails are from this name.', 'tooltip', 'en', '', 0),
(1393, 'smarty_cache', 'Forces the template engine to rebuild the cache on every request. Increases the server load. It should only be used for debugging purposes.', 'Forces the template engine to rebuild the cache on every request. Increases the server load. It should only be used for debugging purposes.', 'tooltip', 'en', '', 0),
(1394, 'smtp_debug_output', '`echo` Output plain-text as-is, appropriate for CLI<br>`html` Output escaped, appropriate for browser output<br>`error_log` Output to error log as configured in php.ini', '`echo` Output plain-text as-is, appropriate for CLI<br>`html` Output escaped, appropriate for browser output<br>`error_log` Output to error log as configured in php.ini', 'tooltip', 'en', '', 0),
(1395, 'smtp_password', 'Password for the username above.', 'Password for the username above.', 'tooltip', 'en', '', 0),
(1396, 'smtp_server', 'That would be Ex. (smtp.yourdomain.com)', 'That would be Ex. (smtp.yourdomain.com)', 'tooltip', 'en', '', 0),
(1397, 'smtp_user', 'Username is usually specified with your email/hosting provider.', 'Username is usually specified with your email/hosting provider.', 'tooltip', 'en', '', 0),
(1398, 'suffix', 'This text is added to Title on every page.', 'This text is added to Title on every page.', 'tooltip', 'en', '', 0),
(1399, 'timezone', 'Select your server timezone.', 'Select your server timezone.', 'tooltip', 'en', '', 0),
(1400, 'slug_literal', 'It''s recommended to start your slug with letters.', 'It''s recommended to start your slug with letters.', 'tooltip', 'en', '', 0),
(1401, 'underconstruction', 'This message is shown in case &quot;Display Frontend&quot; option is disabled.', 'This message is shown in case &quot;Display Frontend&quot; option is disabled.', 'tooltip', 'en', '', 0),
(1402, 'upgrade_available', 'Upgrade patch to version :version is available. In order to upgrade please <a href=":url">follow this link</a>.', 'Upgrade patch to version :version is available. In order to upgrade please <a href=":url">follow this link</a>.', 'admin', 'en', '', 0),
(1403, 'usergroup_assignable', 'Members are allowed to choose this group manually.', 'Members are allowed to choose this group manually.', 'tooltip', 'en', '', 0),
(1404, 'usergroup_visible', 'Group members are displayed on Members page and filters.', 'Group members are displayed on Members page and filters.', 'tooltip', 'en', '', 0),
(1405, 'login', 'Log in', 'Log in', 'frontend', 'en', 'kickstart', 0),
(1406, 'register', 'Sign up', 'Sign up', 'frontend', 'en', 'kickstart', 0),
(1407, 'back_to_top', 'Back to top', 'Back to top', 'frontend', 'en', 'kickstart', 0),
(1408, 'admin_dashboard', 'Admin Dashboard', 'Admin Dashboard', 'frontend', 'en', 'kickstart', 0),
(1409, 'config_group_template_kickstart', 'Template', 'Template', 'admin', 'en', 'kickstart', 0),
(1410, 'config_', '', '', 'admin', 'en', 'kickstart', 0),
(1411, 'config_enable_landing', 'Enable landing page', 'Enable landing page', 'admin', 'en', 'kickstart', 0),
(1412, 'config_custom_colors', 'Enable custom colors and backgrounds', 'Enable custom colors and backgrounds', 'admin', 'en', 'kickstart', 0),
(1413, 'config_custom_color_body_bg', 'Body background', 'Body background', 'admin', 'en', 'kickstart', 0),
(1414, 'config_custom_color_text', 'Text color', 'Text color', 'admin', 'en', 'kickstart', 0),
(1415, 'config_custom_color_headings', 'Headings color', 'Headings color', 'admin', 'en', 'kickstart', 0),
(1416, 'config_custom_color_link', 'Link color', 'Link color', 'admin', 'en', 'kickstart', 0),
(1417, 'config_custom_color_link_hover', 'Link hover color', 'Link hover color', 'admin', 'en', 'kickstart', 0),
(1418, 'config_search_inventory', 'Show search in inventory', 'Show search in inventory', 'admin', 'en', 'kickstart', 0),
(1419, 'config_custom_color_inventory_bg', 'Background', 'Background', 'admin', 'en', 'kickstart', 0),
(1420, 'config_custom_color_inventory_link', 'Link color', 'Link color', 'admin', 'en', 'kickstart', 0),
(1421, 'config_custom_color_inventory_link_hover', 'Link hover color', 'Link hover color', 'admin', 'en', 'kickstart', 0),
(1422, 'config_custom_color_inventory_link_active', 'Link active color', 'Link active color', 'admin', 'en', 'kickstart', 0),
(1423, 'config_max_top_menu_items', 'Max number of items in Main Menu', 'Max number of items in Main Menu', 'admin', 'en', 'kickstart', 0),
(1424, 'config_enable_text_logo', 'Enable Logo text', 'Enable Logo text', 'admin', 'en', 'kickstart', 0),
(1425, 'config_logo_text', 'Logo text', 'Logo text', 'admin', 'en', 'kickstart', 0);
INSERT INTO `[[dbprefix]]language` VALUES
(1426, 'config_navbar_sticky', 'Sticky navbar', 'Sticky navbar', 'admin', 'en', 'kickstart', 0),
(1427, 'config_search_navbar', 'Show search in navbar', 'Show search in navbar', 'admin', 'en', 'kickstart', 0),
(1428, 'config_custom_color_navbar_bg', 'Background', 'Background', 'admin', 'en', 'kickstart', 0),
(1429, 'config_custom_color_navbar_link', 'Link color', 'Link color', 'admin', 'en', 'kickstart', 0),
(1430, 'config_custom_color_navbar_link_hover', 'Link hover color', 'Link hover color', 'admin', 'en', 'kickstart', 0),
(1431, 'config_custom_color_navbar_link_active', 'Link active color', 'Link active color', 'admin', 'en', 'kickstart', 0),
(1432, 'config_bg_header', 'Background image', 'Background image', 'admin', 'en', 'kickstart', 0),
(1433, 'config_bg_header_use_color', 'Use color instead image', 'Use color instead image', 'admin', 'en', 'kickstart', 0),
(1434, 'config_bg_header_color', 'Background color', 'Background color', 'admin', 'en', 'kickstart', 0),
(1435, 'config_bg_features', 'Background image', 'Background image', 'admin', 'en', 'kickstart', 0),
(1436, 'config_bg_features_use_color', 'Use color instead image', 'Use color instead image', 'admin', 'en', 'kickstart', 0),
(1437, 'config_bg_features_color', 'Background color', 'Background color', 'admin', 'en', 'kickstart', 0),
(1438, 'config_footer_bg', 'Background', 'Background', 'admin', 'en', 'kickstart', 0),
(1439, 'config_footer_blocks_bg', 'Background of footer blocks', 'Background of footer blocks', 'admin', 'en', 'kickstart', 0),
(1440, 'config_footer_link', 'Link color', 'Link color', 'admin', 'en', 'kickstart', 0),
(1441, 'config_footer_link_hover', 'Link hover color', 'Link hover color', 'admin', 'en', 'kickstart', 0),
(1442, 'config_footer_link_active', 'Link active color', 'Link active color', 'admin', 'en', 'kickstart', 0),
(1443, 'config_website_social', 'Show links', 'Show links', 'admin', 'en', 'kickstart', 0),
(1444, 'config_website_social_t', 'Twitter Link', 'Twitter Link', 'admin', 'en', 'kickstart', 0),
(1445, 'config_website_social_f', 'Facebook Link', 'Facebook Link', 'admin', 'en', 'kickstart', 0),
(1446, 'config_website_social_g', 'Google+ Link', 'Google+ Link', 'admin', 'en', 'kickstart', 0),
(1447, 'config_website_social_i', 'LinkedIn Link', 'LinkedIn Link', 'admin', 'en', 'kickstart', 0),
(1448, 'config_ckeditor_css', 'CKEditor CSS', 'CKEditor CSS', 'admin', 'en', 'kickstart', 0),
(1449, 'block_title_8', 'Teaser block', 'Teaser block', 'frontend', 'en', '', 0),
(1450, 'block_content_8', '<div class="teaser">\n    <div class="container">\n        <h1>The greatest place<br>to kickstart anything</h1>\n        <h2>You will love how easy<br>it is to manage your content</h2>\n    </div>\n</div>', '<div class="teaser">\n    <div class="container">\n        <h1>The greatest place<br>to kickstart anything</h1>\n        <h2>You will love how easy<br>it is to manage your content</h2>\n    </div>\n</div>', 'frontend', 'en', '', 0),
(1451, 'block_title_9', 'What this all about?', 'What this all about?', 'frontend', 'en', '', 0),
(1452, 'block_title_10', 'Features', 'Features', 'frontend', 'en', '', 0),
(1453, 'block_content_10', '<div class="row">\n    <div class="col-sm-6">\n        <div class="b-feature b-feature--right">\n            <div class="b-feature__img">\n                <span class="fa fa-hand-peace-o"></span>\n            </div>\n            <div class="b-feature__body">\n                <h3>Free & open source</h3>\n                <p class="text-fade-75">You don''t need to pay a single penny to start using Subrion CMS. It''s not encrypted in any way so you can customize it per your needs.</p>\n            </div>\n        </div>\n    </div>\n    <div class="col-sm-6">\n        <div class="b-feature">\n            <div class="b-feature__img">\n                <span class="fa fa-rocket"></span>\n            </div>\n            <div class="b-feature__body">\n                <h3>Extremely easy to extend</h3>\n                <p class="text-fade-75">Forget the hours of programming simple things. Use Subrion framework API to add extra stuff using hooks, plugins, & packages.</p>\n            </div>\n        </div>\n    </div>\n</div>\n<div class="row">\n    <div class="col-sm-6">\n        <div class="b-feature b-feature--right">\n            <div class="b-feature__img">\n                <span class="fa fa-cloud-download"></span>\n            </div>\n            <div class="b-feature__body">\n                <h3>Templates and plugins</h3>\n                <p class="text-fade-75">No need to search. Plugins and templates are available straight from your admin dashboard with one click installation process.</p>\n            </div>\n        </div>\n    </div>\n    <div class="col-sm-6">\n        <div class="b-feature">\n            <div class="b-feature__img">\n                <span class="fa fa-cogs"></span>\n            </div>\n            <div class="b-feature__body">\n                <h3>Powerful admin dashboard</h3>\n                <p class="text-fade-75">It''s done to focus on the content management process. Start it hassle-free within just a few minutes and take care of the content. It''s easy!</p>\n            </div>\n        </div>\n    </div>\n</div>\n<div class="row">\n    <div class="col-sm-6">\n        <div class="b-feature b-feature--right">\n            <div class="b-feature__img">\n                <span class="fa fa-edit"></span>\n            </div>\n            <div class="b-feature__body">\n                <h3>Blog in the box</h3>\n                <p class="text-fade-75">Bring your online presence to a whole new level with the extensive blog functionality that comes in the version by default.</p>\n            </div>\n        </div>\n    </div>\n    <div class="col-sm-6">\n        <div class="b-feature">\n            <div class="b-feature__img">\n                <span class="fa fa-flag"></span>\n            </div>\n            <div class="b-feature__body">\n                <h3>Multilingual CMS</h3>\n                <p class="text-fade-75">Use ready translation or translate the system into your language. It provides all the functionality to become a multilingual solution.</p>\n            </div>\n        </div>\n    </div>\n</div>', '<div class="row">\n    <div class="col-sm-6">\n        <div class="b-feature b-feature--right">\n            <div class="b-feature__img">\n                <span class="fa fa-hand-peace-o"></span>\n            </div>\n            <div class="b-feature__body">\n                <h3>Free & open source</h3>\n                <p class="text-fade-75">You don''t need to pay a single penny to start using Subrion CMS. It''s not encrypted in any way so you can customize it per your needs.</p>\n            </div>\n        </div>\n    </div>\n    <div class="col-sm-6">\n        <div class="b-feature">\n            <div class="b-feature__img">\n                <span class="fa fa-rocket"></span>\n            </div>\n            <div class="b-feature__body">\n                <h3>Extremely easy to extend</h3>\n                <p class="text-fade-75">Forget the hours of programming simple things. Use Subrion framework API to add extra stuff using hooks, plugins, & packages.</p>\n            </div>\n        </div>\n    </div>\n</div>\n<div class="row">\n    <div class="col-sm-6">\n        <div class="b-feature b-feature--right">\n            <div class="b-feature__img">\n                <span class="fa fa-cloud-download"></span>\n            </div>\n            <div class="b-feature__body">\n                <h3>Templates and plugins</h3>\n                <p class="text-fade-75">No need to search. Plugins and templates are available straight from your admin dashboard with one click installation process.</p>\n            </div>\n        </div>\n    </div>\n    <div class="col-sm-6">\n        <div class="b-feature">\n            <div class="b-feature__img">\n                <span class="fa fa-cogs"></span>\n            </div>\n            <div class="b-feature__body">\n                <h3>Powerful admin dashboard</h3>\n                <p class="text-fade-75">It''s done to focus on the content management process. Start it hassle-free within just a few minutes and take care of the content. It''s easy!</p>\n            </div>\n        </div>\n    </div>\n</div>\n<div class="row">\n    <div class="col-sm-6">\n        <div class="b-feature b-feature--right">\n            <div class="b-feature__img">\n                <span class="fa fa-edit"></span>\n            </div>\n            <div class="b-feature__body">\n                <h3>Blog in the box</h3>\n                <p class="text-fade-75">Bring your online presence to a whole new level with the extensive blog functionality that comes in the version by default.</p>\n            </div>\n        </div>\n    </div>\n    <div class="col-sm-6">\n        <div class="b-feature">\n            <div class="b-feature__img">\n                <span class="fa fa-flag"></span>\n            </div>\n            <div class="b-feature__body">\n                <h3>Multilingual CMS</h3>\n                <p class="text-fade-75">Use ready translation or translate the system into your language. It provides all the functionality to become a multilingual solution.</p>\n            </div>\n        </div>\n    </div>\n</div>', 'frontend', 'en', '', 0),
(1454, 'block_title_11', 'Ready for mobile devices', 'Ready for mobile devices', 'frontend', 'en', '', 0),
(1455, 'block_title_12', 'Top block position', 'Top block position', 'frontend', 'en', '', 0),
(1456, 'block_content_12', '<p>You can change this block in admin panel. Remember, if you change template, this block will be lost. We advise you to clone this block.</p>\n<p>Ne lorem percipit efficiantur mei, ius ut simul vidisse. An vel probatus explicari appellantur. Has et comprehensam interpretaris, quo no inimicus maluisset temporibus. Ea mea quod incorrupte, brute laoreet at pri, eam antiopam honestatis efficiantur ea. Velit atomorum voluptaria ad nam, hinc aperiam accumsan ne est, ut dictas dissentias his.</p>', '<p>You can change this block in admin panel. Remember, if you change template, this block will be lost. We advise you to clone this block.</p>\n<p>Ne lorem percipit efficiantur mei, ius ut simul vidisse. An vel probatus explicari appellantur. Has et comprehensam interpretaris, quo no inimicus maluisset temporibus. Ea mea quod incorrupte, brute laoreet at pri, eam antiopam honestatis efficiantur ea. Velit atomorum voluptaria ad nam, hinc aperiam accumsan ne est, ut dictas dissentias his.</p>', 'frontend', 'en', '', 0),
(1457, 'block_title_13', 'Bottom block position', 'Bottom block position', 'frontend', 'en', '', 0),
(1458, 'block_content_13', '<p>You can change this block in admin panel. Remember, if you change template, this block will be lost. We advise you to clone this block.</p>\n<p>Ne lorem percipit efficiantur mei, ius ut simul vidisse. An vel probatus explicari appellantur. Has et comprehensam interpretaris, quo no inimicus maluisset temporibus. Ea mea quod incorrupte, brute laoreet at pri, eam antiopam honestatis efficiantur ea. Velit atomorum voluptaria ad nam, hinc aperiam accumsan ne est, ut dictas dissentias his.</p>', '<p>You can change this block in admin panel. Remember, if you change template, this block will be lost. We advise you to clone this block.</p>\n<p>Ne lorem percipit efficiantur mei, ius ut simul vidisse. An vel probatus explicari appellantur. Has et comprehensam interpretaris, quo no inimicus maluisset temporibus. Ea mea quod incorrupte, brute laoreet at pri, eam antiopam honestatis efficiantur ea. Velit atomorum voluptaria ad nam, hinc aperiam accumsan ne est, ut dictas dissentias his.</p>', 'frontend', 'en', '', 0),
(1459, 'block_title_14', 'HTML block #1', 'HTML block #1', 'frontend', 'en', '', 0),
(1460, 'block_content_14', '<p>You can change this block in admin panel. Remember, if you change template, this block will be lost. We advise you to clone this block.</p>\n<p>Ne lorem percipit efficiantur mei, ius ut simul vidisse. An vel probatus explicari appellantur. Has et comprehensam interpretaris, quo no inimicus maluisset temporibus. Ea mea quod.</p>', '<p>You can change this block in admin panel. Remember, if you change template, this block will be lost. We advise you to clone this block.</p>\n<p>Ne lorem percipit efficiantur mei, ius ut simul vidisse. An vel probatus explicari appellantur. Has et comprehensam interpretaris, quo no inimicus maluisset temporibus. Ea mea quod.</p>', 'frontend', 'en', '', 0),
(1461, 'block_title_15', 'About CMS', 'About CMS', 'frontend', 'en', '', 0),
(1462, 'block_content_15', '<p>Subrion is a free open source content management system\nthat allows you to build websites for any purpose. Yes, from blog to corporate mega portal.</p>\n<ul class="list-unstyled hidden">\n    <li><span class="fa fa-phone"></span> 1-677-124-44227</li>\n    <li><span class="fa fa-map-pin"></span> 437 S Olive St, Los Angeles</li>\n    <li><span class="fa fa-clock-o"></span> Mon - Sat 8.00 - 18.00h</li>\n</ul>', '<p>Subrion is a free open source content management system\nthat allows you to build websites for any purpose. Yes, from blog to corporate mega portal.</p>\n<ul class="list-unstyled hidden">\n    <li><span class="fa fa-phone"></span> 1-677-124-44227</li>\n    <li><span class="fa fa-map-pin"></span> 437 S Olive St, Los Angeles</li>\n    <li><span class="fa fa-clock-o"></span> Mon - Sat 8.00 - 18.00h</li>\n</ul>', 'frontend', 'en', '', 0),
(1463, 'block_title_16', 'For users', 'For users', 'frontend', 'en', '', 0),
(1464, 'block_content_16', '<p>It''s done to focus on the content management process. Start it hassle-free within just a few minutes and take care of the content. It''s easy!</p>', '<p>It''s done to focus on the content management process. Start it hassle-free within just a few minutes and take care of the content. It''s easy!</p>', 'frontend', 'en', '', 0),
(1465, 'block_title_17', 'For developers', 'For developers', 'frontend', 'en', '', 0),
(1466, 'block_content_17', '<p>Forget the hours of programming simple things. Use Subrion framework API to add extra stuff using hooks, plugins, & packages.</p>', '<p>Forget the hours of programming simple things. Use Subrion framework API to add extra stuff using hooks, plugins, & packages.</p>', 'frontend', 'en', '', 0),
(1467, 'block_title_18', 'For designers', 'For designers', 'frontend', 'en', '', 0),
(1468, 'block_content_18', '<p>Simple templating engine and styles allows you to create any template you wish with just a few lines of code.</p>', '<p>Simple templating engine and styles allows you to create any template you wish with just a few lines of code.</p>', 'frontend', 'en', '', 0),
(1469, 'page_title_blog', 'Blog', 'Blog', 'admin', 'en', 'blog', 0),
(1470, 'dashboard_blogpost_add', 'Add Blog Entry', 'Add Blog Entry', 'admin', 'en', 'blog', 0),
(1471, 'add_blog_entry', 'Add Blog Entry', 'Add Blog Entry', 'common', 'en', 'blog', 0),
(1472, 'blog', 'Blog', 'Blog', 'common', 'en', 'blog', 0),
(1473, 'blogposts', 'Blogposts', 'Blogposts', 'common', 'en', 'blog', 0),
(1474, 'blog_entry_added', 'Blog entry added.', 'Blog entry added.', 'common', 'en', 'blog', 0),
(1475, 'blog_entry_deleted', 'Blog entry deleted.', 'Blog entry deleted.', 'common', 'en', 'blog', 0),
(1476, 'body', 'Body', 'Body', 'common', 'en', 'blog', 0),
(1477, 'edit_blog_entry', 'Edit Blog Entry', 'Edit Blog Entry', 'common', 'en', 'blog', 0),
(1478, 'separate_with_comma_or_enter', 'Use comma or press enter to separate tags', 'Use comma or press enter to separate tags', 'common', 'en', 'blog', 0),
(1479, 'tags', 'Tags', 'Tags', 'common', 'en', 'blog', 0),
(1480, 'title_alias', 'Title Alias', 'Title Alias', 'common', 'en', 'blog', 0),
(1481, 'blogroll', 'Blogroll', 'Blogroll', 'frontend', 'en', 'blog', 0),
(1482, 'no_blog_entries', 'No blogposts done yet. Be the first to post here.', 'No blogposts done yet. Be the first to post here.', 'frontend', 'en', 'blog', 0),
(1483, 'no_tags', 'No tags added.', 'No tags added.', 'frontend', 'en', 'blog', 0),
(1484, 'page_title_tag', 'Blog Tags', 'Blog Tags', 'frontend', 'en', 'blog', 0),
(1485, 'posted_on', 'Posted on', 'Posted on', 'frontend', 'en', 'blog', 0),
(1486, 'view_all_blog_entries', 'View all blog entries', 'View all blog entries', 'frontend', 'en', 'blog', 0),
(1487, 'blog_display_grid', 'This option allows you to display only images in Blogroll section. This display type suits best for portfolios.', 'This option allows you to display only images in Blogroll section. This display type suits best for portfolios.', 'tooltip', 'en', 'blog', 0),
(1488, 'config_group_blog', 'Blog', 'Blog', 'admin', 'en', 'blog', 0),
(1489, 'admin_page-blog--read', 'Allow to view blog entries', 'Allow to view blog entries', 'common', 'en', 'blog', 0),
(1490, 'admin_page-blog--add', 'Add blog entry', 'Add blog entry', 'common', 'en', 'blog', 0),
(1491, 'admin_page-blog--edit', 'Edit blog entry', 'Edit blog entry', 'common', 'en', 'blog', 0),
(1492, 'admin_page-blog--delete', 'Delete blog entry', 'Delete blog entry', 'common', 'en', 'blog', 0),
(1493, 'page-blog--read', 'View blog entries', 'View blog entries', 'common', 'en', 'blog', 0),
(1494, 'page-blog--add', 'Add blog entry', 'Add blog entry', 'common', 'en', 'blog', 0),
(1495, 'page-blog--edit', 'Edit blog entry', 'Edit blog entry', 'common', 'en', 'blog', 0),
(1496, 'page-blog--delete', 'Delete blog entry', 'Delete blog entry', 'common', 'en', 'blog', 0),
(1497, 'config_blog_plugin', '', '', 'admin', 'en', 'blog', 0),
(1498, 'config_blog_number_block', 'Number of displayed entries in Blogroll entries', 'Number of displayed entries in Blogroll entries', 'admin', 'en', 'blog', 0),
(1499, 'config_blog_number_new_block', 'Number of displayed entries in New Blog Posts block', 'Number of displayed entries in New Blog Posts block', 'admin', 'en', 'blog', 0),
(1500, 'config_blog_max_block', 'Number of chars in short description in Latest Blog entries', 'Number of chars in short description in Latest Blog entries', 'admin', 'en', 'blog', 0),
(1501, 'config_blog_number', 'Number of displayed entries', 'Number of displayed entries', 'admin', 'en', 'blog', 0),
(1502, 'config_blog_max', 'Number of chars in short description', 'Number of chars in short description', 'admin', 'en', 'blog', 0),
(1503, 'config_blog_order', 'Entries order by', 'Entries order by', 'admin', 'en', 'blog', 0),
(1504, 'config_blog_tag_number', 'Number of displayed tags', 'Number of displayed tags', 'admin', 'en', 'blog', 0),
(1505, 'config_blog_image_resize', 'Image/Thumbnail resize mod', 'Image/Thumbnail resize mod', 'admin', 'en', 'blog', 0),
(1506, 'config_blog_image_width', 'Image width', 'Image width', 'admin', 'en', 'blog', 0),
(1507, 'config_blog_image_height', 'Image height', 'Image height', 'admin', 'en', 'blog', 0),
(1508, 'config_blog_thumb_width', 'Thumbnail width', 'Thumbnail width', 'admin', 'en', 'blog', 0),
(1509, 'config_blog_thumb_height', 'Thumbnail height', 'Thumbnail height', 'admin', 'en', 'blog', 0),
(1510, 'page_title_blog', 'Blog', 'Blog', 'page', 'en', 'blog', 0),
(1511, 'page_title_tag', 'Tag', 'Tag', 'page', 'en', 'blog', 0),
(1512, 'page_title_blog_date', 'Blog Archive', 'Blog Archive', 'page', 'en', 'blog', 0),
(1513, 'block_title_19', 'Blogroll', 'Blogroll', 'frontend', 'en', '', 0),
(1514, 'block_title_20', 'New blog posts', 'New blog posts', 'frontend', 'en', '', 0),
(1515, 'block_title_21', 'Blogs Archive', 'Blogs Archive', 'frontend', 'en', '', 0),
(1516, 'click_to_redraw', 'Click here to redraw', 'Click here to redraw', 'frontend', 'en', 'kcaptcha', 0),
(1517, 'captcha_tooltip', 'Please input letters you see on the image.<br />Click on image to redraw.', 'Please input letters you see on the image.<br />Click on image to redraw.', 'frontend', 'en', 'kcaptcha', 0),
(1518, 'config_kcaptcha_divider', 'KCAPTCHA', 'KCAPTCHA', 'admin', 'en', 'kcaptcha', 0),
(1519, 'config_kcaptcha_case_sensitive', 'Case sensitive', 'Case sensitive', 'admin', 'en', 'kcaptcha', 0),
(1520, 'config_kcaptcha_num_chars', 'Number of characters', 'Number of characters', 'admin', 'en', 'kcaptcha', 0),
(1521, 'config_fancybox_divider', '', '', 'admin', 'en', 'fancybox', 0),
(1522, 'config_fancybox_slide_transition', 'fancyBox slide effect', 'fancyBox slide effect', 'admin', 'en', 'fancybox', 0),
(1523, 'config_fancybox_open_transition', 'fancyBox open/close effect', 'fancyBox open/close effect', 'admin', 'en', 'fancybox', 0),
(1524, 'config_fancybox_slide_speed', 'fancyBox slide speed', 'fancyBox slide speed', 'admin', 'en', 'fancybox', 0),
(1525, 'config_fancybox_open_speed', 'fancyBox open/close speed', 'fancyBox open/close speed', 'admin', 'en', 'fancybox', 0),
(1526, 'config_fancybox_padding', 'fancyBox inner padding', 'fancyBox inner padding', 'admin', 'en', 'fancybox', 0),
(1527, 'config_fancybox_arrows', 'Display navigation arrows', 'Display navigation arrows', 'admin', 'en', 'fancybox', 0),
(1528, 'config_fancybox_closeBtn', 'Display close button', 'Display close button', 'admin', 'en', 'fancybox', 0),
(1529, 'config_fancybox_closeClick', 'If set, fancyBox will be closed when user clicks the content', 'If set, fancyBox will be closed when user clicks the content', 'admin', 'en', 'fancybox', 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]languages`
--

CREATE TABLE `[[dbprefix]]languages` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `code` char(2) NOT NULL,
  `title` varchar(100) NOT NULL,
  `locale` varchar(30) NOT NULL,
  `date_format` varchar(50) NOT NULL,
  `time_format` varchar(50) NOT NULL,
  `author` varchar(100) NOT NULL,
  `direction` varchar(5) NOT NULL DEFAULT 'ltr',
  `master` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `default` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `order` smallint(5) unsigned NOT NULL DEFAULT '0',
  `status` enum('active','inactive') NOT NULL DEFAULT 'active',
  `flagicon` tinytext NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `CODE` (`code`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]languages`
--

INSERT INTO `[[dbprefix]]languages` VALUES
(1, 'en', 'English', 'en_US', '%e %B, %Y', '%H:%M', 'Intelliants LLC', 'ltr', 1, 1, 1, 'active', 'us.gif');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]logs`
--

CREATE TABLE `[[dbprefix]]logs` (
  `id` int(8) unsigned NOT NULL AUTO_INCREMENT,
  `date` datetime NOT NULL,
  `action` tinyint(3) unsigned NOT NULL,
  `user_id` int(11) unsigned DEFAULT NULL,
  `module` varchar(40) NOT NULL DEFAULT '',
  `params` text,
  PRIMARY KEY (`id`),
  KEY `PLUGIN` (`module`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `[[dbprefix]]logs`
--


-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]members`
--

CREATE TABLE `[[dbprefix]]members` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `usergroup_id` smallint(5) unsigned NOT NULL DEFAULT '8',
  `username` varchar(50) NOT NULL,
  `password` varchar(191) NOT NULL,
  `email` varchar(191) NOT NULL,
  `sec_key` varchar(32) NOT NULL,
  `status` enum('approval','active','unconfirmed','suspended') NOT NULL DEFAULT 'active',
  `date_reg` datetime NOT NULL,
  `date_update` datetime NOT NULL,
  `date_logged` datetime DEFAULT NULL,
  `views_num` mediumint(8) unsigned NOT NULL,
  `fullname` tinytext NOT NULL,
  `avatar` tinytext NOT NULL,
  `website` tinytext NOT NULL,
  `phone` tinytext NOT NULL,
  `biography` text NOT NULL,
  `facebook` tinytext NOT NULL,
  `twitter` tinytext NOT NULL,
  `gplus` tinytext NOT NULL,
  `linkedin` tinytext NOT NULL,
  `funds` decimal(12,2) unsigned NOT NULL,
  `disable_fields` tinyint(1) unsigned NOT NULL,
  `admin_columns` text NOT NULL,
  `featured` tinyint(1) unsigned NOT NULL,
  `featured_start` datetime DEFAULT NULL,
  `featured_end` datetime DEFAULT NULL,
  `sponsored` tinyint(1) unsigned NOT NULL,
  `sponsored_start` datetime DEFAULT NULL,
  `sponsored_end` datetime DEFAULT NULL,
  `sponsored_plan_id` smallint(5) unsigned NOT NULL,
  `api_push_token` tinytext NOT NULL,
  `api_push_receive` enum('yes','no') NOT NULL DEFAULT 'yes',
  `email_language` varchar(2) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `USERNAME` (`username`),
  UNIQUE KEY `EMAIL` (`email`),
  KEY `STATUS` (`status`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]members`
--

INSERT INTO `[[dbprefix]]members` VALUES
(1, 1, '[[admin_username]]', '[[admin_pass]]', '[[admin_email]]', '', 'active', '[[regtime]]', '[[regtime]]', NULL, 0, 'Administrator', '', '', '', '', '', '', '', '', 0.00, 0, '', 0, NULL, NULL, 0, NULL, NULL, 0, '', 'yes', 'en');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]members_auth_providers`
--

CREATE TABLE `[[dbprefix]]members_auth_providers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `member_id` int(11) NOT NULL,
  `name` varchar(50) NOT NULL,
  `value` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]menus`
--

CREATE TABLE `[[dbprefix]]menus` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `menu_id` smallint(5) unsigned NOT NULL,
  `parent_id` varchar(10) NOT NULL,
  `el_id` varchar(10) NOT NULL,
  `page_name` varchar(100) NOT NULL DEFAULT 'none',
  `level` smallint(4) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `MENU` (`menu_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=13 ;

--
-- Dumping data for table `[[dbprefix]]menus`
--

INSERT INTO `[[dbprefix]]menus` VALUES
(1, 2, '0', '1_001', 'index', 0),
(2, 3, '0', '1_002', 'index', 0),
(3, 3, '0', '9_003', 'members', 0),
(4, 4, '0', '13_004', 'profile', 0),
(5, 4, '0', '8_005', 'favorites', 0),
(6, 4, '0', '14_006', 'member_funds', 0),
(7, 5, '0', '19_007', 'about', 0),
(8, 5, '0', '20_008', 'policy', 0),
(9, 5, '0', '21_009', 'terms', 0),
(10, 5, '0', '22_011', 'help', 0),
(11, 3, '0', '24_5a81', 'blog', 0),
(12, 5, '0', '24_77bb', 'blog', 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]migrations`
--

CREATE TABLE `[[dbprefix]]migrations` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL DEFAULT '',
  `status` enum('incomplete','skipped','complete') NOT NULL DEFAULT 'complete',
  `data` text,
  `date` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]modules`
--

CREATE TABLE `[[dbprefix]]modules` (
  `id` smallint(4) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(40) NOT NULL,
  `type` enum('plugin','package','template','core') NOT NULL DEFAULT 'plugin',
  `author` varchar(75) NOT NULL,
  `contributor` varchar(75) NOT NULL,
  `title` varchar(150) NOT NULL,
  `items` text,
  `url` varchar(50) NOT NULL DEFAULT '',
  `status` enum('active','inactive') NOT NULL DEFAULT 'active',
  `date` datetime NOT NULL,
  `version` varchar(15) NOT NULL,
  `summary` text,
  `category` varchar(20) NOT NULL,
  `uninstall_code` text,
  `uninstall_sql` text,
  `removable` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `rollback_data` text NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQUE` (`name`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=5 ;

--
-- Dumping data for table `[[dbprefix]]modules`
--

INSERT INTO `[[dbprefix]]modules` VALUES
(1, 'kickstart', 'template', 'Gleb Surinov', 'Intelliants LLC', 'Kickstart', NULL, '', 'active', '[[regtime]]', '2.0.0', 'Bootstrap 3 developer template', '', NULL, NULL, 1, 'a:1:{s:6:"blocks";a:6:{s:7:"account";a:2:{s:8:"position";s:5:"right";s:6:"status";s:6:"active";}s:21:"new_portfolio_entries";b:0;s:12:"testimonials";b:0;s:8:"blogroll";b:0;s:17:"common_statistics";a:3:{s:6:"status";s:6:"active";s:9:"classname";s:0:"";s:8:"position";s:5:"right";}s:7:"filters";a:3:{s:6:"status";s:6:"active";s:9:"classname";s:0:"";s:8:"position";s:4:"left";}}}'),
(2, 'blog', 'plugin', 'Intelliants LLC', 'Intelliants LLC', 'Blog', NULL, '', 'active', '[[regtime]]', '4.1.0', 'Adds blog functionality to Subrion powered website', '', NULL, 'a:1:{i:0;a:2:{s:5:"query";s:94:"DROP TABLE IF EXISTS `{prefix}blog_entries`, `{prefix}blog_tags`, `{prefix}blog_entries_tags`;";s:8:"external";b:0;}}', 1, ''),
(3, 'kcaptcha', 'plugin', 'Intelliants LLC', 'Intelliants LLC', 'KCaptcha', NULL, '', 'active', '[[regtime]]', '4.1.0', 'Plugin adds the CAPTCHA to all pages where it is needed to prevents automatic bot form submission', 'captcha', NULL, NULL, 0, ''),
(4, 'fancybox', 'plugin', 'Intelliants LLC', 'Intelliants LLC', 'fancyBox', NULL, '', 'active', '[[regtime]]', '4.1.0', 'Plugin will add lightbox effect to images based on Fancybox javascript library', 'lightbox', NULL, NULL, 0, '');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]objects_pages`
--

CREATE TABLE `[[dbprefix]]objects_pages` (
  `object_type` varchar(50) NOT NULL,
  `page_name` varchar(50) NOT NULL,
  `object` varchar(100) NOT NULL,
  `access` tinyint(1) unsigned NOT NULL DEFAULT '1',
  UNIQUE KEY `unique` (`object_type`,`page_name`,`object`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

--
-- Dumping data for table `[[dbprefix]]objects_pages`
--

INSERT INTO `[[dbprefix]]objects_pages` VALUES
('blocks', '', '6', 0),
('blocks', 'index', '6', 1),
('blocks', '', '8', 0),
('blocks', 'index', '8', 1),
('blocks', '', '9', 0),
('blocks', 'index', '9', 1),
('blocks', '', '10', 0),
('blocks', 'index', '10', 1),
('blocks', '', '11', 0),
('blocks', 'index', '11', 1),
('blocks', '', '12', 0),
('blocks', 'index', '12', 1),
('blocks', '', '13', 0),
('blocks', 'index', '13', 1),
('blocks', '', '19', 0),
('blocks', 'index', '19', 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]online`
--

CREATE TABLE `[[dbprefix]]online` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `is_bot` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `session_id` char(32) NOT NULL,
  `date` datetime NOT NULL,
  `status` enum('active','expired') NOT NULL DEFAULT 'active',
  `username` varchar(50) NOT NULL DEFAULT '',
  `fullname` tinytext NOT NULL,
  `page` varchar(150) NOT NULL,
  `ip` bigint(12) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `SESSION` (`session_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]pages`
--

CREATE TABLE `[[dbprefix]]pages` (
  `id` mediumint(7) unsigned NOT NULL AUTO_INCREMENT,
  `group` smallint(5) unsigned NOT NULL DEFAULT '1',
  `name` varchar(50) NOT NULL,
  `service` tinyint(1) unsigned NOT NULL,
  `readonly` tinyint(1) unsigned NOT NULL,
  `status` enum('active','inactive','draft') NOT NULL DEFAULT 'draft',
  `last_updated` datetime NOT NULL,
  `order` mediumint(7) unsigned NOT NULL,
  `alias` varchar(150) NOT NULL,
  `nofollow` tinyint(1) unsigned NOT NULL,
  `new_window` tinyint(1) unsigned NOT NULL,
  `module` varchar(40) NOT NULL,
  `passw` char(32) NOT NULL DEFAULT '',
  `filename` varchar(50) NOT NULL,
  `custom_tpl` tinyint(1) NOT NULL,
  `template_filename` varchar(64) NOT NULL,
  `custom_url` tinytext NOT NULL,
  `menus` set('main','bottom','account','inventory') NOT NULL DEFAULT '',
  `action` varchar(10) NOT NULL DEFAULT 'read',
  `parent` varchar(50) NOT NULL,
  `suburl` varchar(150) NOT NULL,
  `fields_item` varchar(50) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `NAME` (`name`),
  KEY `ALIAS` (`alias`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=27 ;

--
-- Dumping data for table `[[dbprefix]]pages`
--

INSERT INTO `[[dbprefix]]pages` VALUES
(1, 2, 'index', 0, 0, 'active', '[[regtime]]', 0, '', 0, 0, '', '', 'page', 0, '', '', 'main,inventory', 'read', '', '', ''),
(2, 1, 'api', 1, 1, 'active', '[[regtime]]', 0, 'api/', 1, 0, '', '', 'api', 0, '', '', '', 'read', '', '', ''),
(3, 1, 'redirect', 1, 1, 'active', '[[regtime]]', 0, '', 0, 0, '', '', '', 0, '', '', '', 'read', '', '', ''),
(4, 1, 'search', 0, 1, 'active', '[[regtime]]', 0, 'search/', 1, 0, '', '', '', 0, '', '', 'main', 'read', '', '', ''),
(5, 1, 'captcha', 1, 1, 'active', '[[regtime]]', 0, 'captcha', 1, 0, '', '', '', 0, '', '', '', 'read', '', '', ''),
(6, 1, 'cron', 1, 1, 'active', '[[regtime]]', 0, '', 0, 0, '', '', '', 0, '', '', '', 'read', '', '', ''),
(7, 1, 'actions', 1, 1, 'active', '[[regtime]]', 0, '', 0, 0, '', '', '', 0, '', '', '', 'read', '', '', ''),
(8, 1, 'pay', 1, 1, 'active', '[[regtime]]', 0, 'pay/', 0, 0, '', '', '', 0, '', '', '', 'read', '', '', ''),
(9, 3, 'favorites', 0, 1, 'active', '[[regtime]]', 0, 'favorites/', 1, 0, '', '', '', 0, '', '', 'account', 'read', '', '', ''),
(10, 3, 'members', 0, 1, 'active', '[[regtime]]', 0, 'members/', 0, 0, '', '', '', 0, '', '', 'main', 'read', '', 'members', ''),
(11, 3, 'login', 0, 1, 'active', '[[regtime]]', 0, 'login/', 1, 0, '', '', '', 0, '', '', '', 'read', '', '', ''),
(12, 3, 'hybrid', 1, 1, 'active', '[[regtime]]', 0, 'hybrid/', 1, 0, '', '', 'login', 0, '', '', '', 'read', '', '', ''),
(13, 3, 'view_member', 0, 1, 'active', '[[regtime]]', 0, 'member/', 1, 0, '', '', '', 0, '', '', '', 'read', 'members', 'members', ''),
(14, 3, 'profile', 0, 1, 'active', '[[regtime]]', 0, 'profile/', 1, 0, '', '', '', 0, '', '', 'account', 'read', '', '', ''),
(15, 3, 'member_funds', 0, 1, 'active', '[[regtime]]', 0, 'profile/funds/', 1, 0, '', '', 'transactions', 0, '', '', 'account', 'read', 'profile', '', ''),
(16, 3, 'registration', 0, 1, 'active', '[[regtime]]', 0, 'registration/', 1, 0, '', '', 'registration', 0, '', '', '', 'read', '', '', ''),
(17, 3, 'register_confirm', 1, 1, 'active', '[[regtime]]', 0, 'confirm/', 1, 0, '', '', 'registration', 0, '', '', '', 'read', '', '', ''),
(18, 3, 'member_password_forgot', 1, 1, 'active', '[[regtime]]', 0, 'forgot/', 1, 0, '', '', 'registration', 0, '', '', '', 'read', '', '', ''),
(19, 2, 'page', 1, 1, 'active', '[[regtime]]', 0, '', 0, 0, '', '', 'page', 0, '', '', '', 'read', '', '', ''),
(20, 2, 'about', 0, 0, 'active', '[[regtime]]', 0, 'about/', 0, 0, '', '', 'page', 0, '', '', '', 'read', '', '', ''),
(21, 2, 'policy', 0, 0, 'active', '[[regtime]]', 0, 'policy/', 0, 0, '', '', 'page', 0, '', '', '', 'read', '', '', ''),
(22, 2, 'terms', 0, 0, 'active', '[[regtime]]', 0, 'terms/', 0, 0, '', '', 'page', 0, '', '', '', 'read', '', '', ''),
(23, 2, 'help', 0, 0, 'active', '[[regtime]]', 0, 'help/', 0, 0, '', '', 'page', 0, '', '', '', 'read', '', '', ''),
(24, 5, 'blog', 0, 1, 'active', '[[regtime]]', 1, 'blog/', 0, 0, 'blog', '', '', 0, '', '', '', 'read', '', '', ''),
(25, 5, 'tag', 0, 1, 'active', '[[regtime]]', 2, 'tag/', 0, 0, 'blog', '', 'tag', 0, '', '', '', 'read', '', '', ''),
(26, 5, 'blog_date', 0, 1, 'active', '[[regtime]]', 3, 'blog/date/', 0, 0, 'blog', '', 'date', 0, '', '', '', 'read', '', '', '');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]payment_gateways`
--

CREATE TABLE `[[dbprefix]]payment_gateways` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `title` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `NAME` (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]payment_gateways_ipn_log`
--

CREATE TABLE `[[dbprefix]]payment_gateways_ipn_log` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `date` datetime NOT NULL,
  `gateway` varchar(50) NOT NULL,
  `data` text,
  `result` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]payment_plans`
--

CREATE TABLE `[[dbprefix]]payment_plans` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `cost` decimal(10,2) unsigned NOT NULL,
  `item` varchar(50) DEFAULT NULL,
  `data` text,
  `duration` int(10) unsigned NOT NULL COMMENT 'Duration of cycle in units',
  `unit` enum('hour','day','week','month','year') DEFAULT NULL COMMENT 'Unit of measure',
  `order` tinyint(3) unsigned NOT NULL,
  `status` enum('inactive','active') NOT NULL DEFAULT 'inactive',
  `email` varchar(128) NOT NULL,
  `usergroup` smallint(5) unsigned NOT NULL,
  `recurring` tinyint(1) unsigned NOT NULL COMMENT 'Is this plan recurring?',
  `cycles` smallint(5) NOT NULL DEFAULT '0' COMMENT 'Number of recurring cycles',
  `expiration_status` varchar(15) NOT NULL COMMENT 'Status which will be applied on plan expiration',
  `type` enum('fee','subscription') NOT NULL DEFAULT 'subscription',
  `listings_limit` int(7) unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]payment_plans_options`
--

CREATE TABLE `[[dbprefix]]payment_plans_options` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `type` enum('bool','int','float','string') NOT NULL DEFAULT 'string',
  `chargeable` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `name` varchar(32) NOT NULL,
  `default_value` varchar(32) NOT NULL,
  `item` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]payment_plans_options_values`
--

CREATE TABLE `[[dbprefix]]payment_plans_options_values` (
  `plan_id` smallint(5) unsigned NOT NULL,
  `option_id` smallint(5) unsigned NOT NULL,
  `price` decimal(8,2) unsigned DEFAULT NULL,
  `value` varchar(96) NOT NULL,
  UNIQUE KEY `UNIQUE` (`plan_id`,`option_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]payment_subscriptions`
--

CREATE TABLE `[[dbprefix]]payment_subscriptions` (
  `id` int(9) unsigned NOT NULL AUTO_INCREMENT,
  `date_created` datetime DEFAULT NULL,
  `date_next_payment` datetime DEFAULT NULL,
  `reference_id` varchar(64) DEFAULT NULL,
  `member_id` int(11) unsigned NOT NULL,
  `plan_id` smallint(5) unsigned NOT NULL,
  `item` varchar(30) DEFAULT NULL,
  `item_id` int(11) unsigned DEFAULT NULL,
  `status` enum('active','pending','suspended','canceled','failed','completed') NOT NULL,
  PRIMARY KEY (`id`),
  KEY `REFERENCE` (`reference_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]payment_transactions`
--

CREATE TABLE `[[dbprefix]]payment_transactions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `member_id` int(11) unsigned NOT NULL,
  `subscription_id` int(9) unsigned DEFAULT NULL,
  `plan_id` smallint(5) unsigned NOT NULL,
  `reference_id` varchar(64) NOT NULL,
  `item` varchar(30) NOT NULL,
  `item_id` int(11) unsigned NOT NULL,
  `fullname` varchar(100) NOT NULL,
  `email` varchar(200) NOT NULL,
  `date_created` datetime DEFAULT NULL,
  `date_updated` datetime DEFAULT NULL,
  `date_paid` datetime DEFAULT NULL,
  `amount` decimal(10,2) unsigned NOT NULL,
  `currency` varchar(3) NOT NULL,
  `status` enum('pending','passed','failed','refunded') NOT NULL DEFAULT 'pending',
  `operation` varchar(100) NOT NULL,
  `gateway` varchar(50) NOT NULL,
  `sec_key` varchar(14) NOT NULL,
  `return_url` tinytext NOT NULL,
  `notes` tinytext,
  `demo` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]positions`
--

CREATE TABLE `[[dbprefix]]positions` (
  `name` varchar(100) NOT NULL,
  `menu` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `movable` tinyint(1) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

--
-- Dumping data for table `[[dbprefix]]positions`
--

INSERT INTO `[[dbprefix]]positions` VALUES
('account', 1, 0),
('mainmenu', 1, 0),
('inventory', 0, 1),
('teaser', 0, 1),
('verytop', 0, 1),
('top', 0, 1),
('bottom', 0, 1),
('verybottom', 0, 1),
('copyright', 0, 1),
('landing', 0, 1),
('left', 0, 1),
('center', 0, 1),
('right', 0, 1),
('footer1', 0, 1),
('footer2', 0, 1),
('footer3', 0, 1),
('footer4', 0, 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]search`
--

CREATE TABLE `[[dbprefix]]search` (
  `id` int(9) unsigned NOT NULL AUTO_INCREMENT,
  `member_id` int(11) unsigned NOT NULL,
  `date` datetime NOT NULL,
  `item` varchar(16) NOT NULL,
  `params` varchar(400) NOT NULL,
  `title` varchar(64) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `SEARCH` (`member_id`,`item`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]usergroups`
--

CREATE TABLE `[[dbprefix]]usergroups` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `module` varchar(40) NOT NULL,
  `system` tinyint(1) unsigned NOT NULL,
  `assignable` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `visible` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `order` smallint(5) unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=9 ;

--
-- Dumping data for table `[[dbprefix]]usergroups`
--

INSERT INTO `[[dbprefix]]usergroups` VALUES
(1, 'administrators', '', 1, 0, 0, 1),
(2, 'moderators', '', 1, 0, 0, 2),
(4, 'guests', '', 1, 0, 0, 3),
(8, 'registered', '', 1, 0, 1, 4);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]views_log`
--

CREATE TABLE `[[dbprefix]]views_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `item` char(16) NOT NULL,
  `item_id` int(11) unsigned NOT NULL,
  `ip` bigint(12) NOT NULL,
  `date` date NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQUE` (`item`,`item_id`,`ip`,`date`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

--
-- Triggers `[[dbprefix]]members`
--
DROP TRIGGER IF EXISTS `del_hybridauth_data`;
DELIMITER //
CREATE TRIGGER `del_hybridauth_data` AFTER DELETE ON `[[dbprefix]]members`
 FOR EACH ROW DELETE FROM `[[dbprefix]]members_auth_providers` WHERE `[[dbprefix]]members_auth_providers`.`member_id` = OLD.`id`
//
DELIMITER ;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
