SET @@session.sql_mode=''; # disabling the strict mode
SET FOREIGN_KEY_CHECKS=0;

{install:drop_tables}DROP TABLE IF EXISTS `{install:prefix}acl_objects`;
CREATE TABLE `{install:prefix}acl_objects` (
	`id` int(10) unsigned NOT NULL auto_increment,
	`pre_object` char(40) NOT NULL,
	`object` char(30) NOT NULL,
	`action` char(15) NOT NULL default 'read',
	`access` tinyint(1) unsigned NOT NULL default 1,
	`module` char(40) NOT NULL,
	PRIMARY KEY (`id`)
) {install:db_options};

{install:drop_tables}DROP TABLE IF EXISTS `{install:prefix}acl_privileges`;
CREATE TABLE `{install:prefix}acl_privileges` (
	`id` int(10) unsigned NOT NULL auto_increment,
	`type` enum('user','group','plan') NOT NULL default 'group',
	`type_id` mediumint(8) unsigned NOT NULL,
	`access` tinyint(1) unsigned NOT NULL,
	`action` varchar(15) NOT NULL default 'read',
	`object` varchar(50) NOT NULL,
	`object_id` varchar(150) NOT NULL default '0',
	`module` varchar(40) NOT NULL,
	PRIMARY KEY (`id`),
	UNIQUE KEY `UNIQUE` (`type`,`type_id`,`action`,`object`,`object_id`)
) {install:db_options};

{install:drop_tables}DROP TABLE IF EXISTS `{install:prefix}admin_actions`;
CREATE TABLE `{install:prefix}admin_actions` (
	`id` mediumint(8) unsigned NOT NULL auto_increment,
	`name` varchar(64) NOT NULL,
	`url` varchar(100) NOT NULL,
	`icon` varchar(50) default null,
	`attributes` tinytext NOT NULL,
	`module` varchar(40) NOT NULL,
	`pages` tinytext NOT NULL,
	`text` varchar(50) default null,
	`type` enum('regular','dashboard') default 'regular',
	`order` smallint(5) unsigned NOT NULL,
	PRIMARY KEY (`id`),
	KEY `TYPE` (`type`)
) {install:db_options};

{install:drop_tables}DROP TABLE IF EXISTS `{install:prefix}admin_pages`;
CREATE TABLE `{install:prefix}admin_pages` (
	`id` smallint(5) unsigned NOT NULL auto_increment,
	`group` smallint(4) unsigned NOT NULL,
	`name` varchar(50) NOT NULL,
	`order` smallint(5) unsigned NOT NULL,
	`alias` varchar(150) NOT NULL,
	`module` varchar(40) NOT NULL,
	`filename` varchar(50) NOT NULL,
	`attr` varchar(150) default null,
	`menus` set('menu','header') NOT NULL default 'menu',
	`status` enum('active','inactive') NOT NULL default 'active',
	`readonly` tinyint(1) unsigned NOT NULL default 0,
	`action` char(15) NOT NULL default 'read',
	`parent` varchar(50) NOT NULL,
	PRIMARY KEY (`id`),
	KEY `NAME` (`name`),
	KEY `ALIAS` (`alias`),
	KEY `GROUP` (`group`),
	KEY `MENUS` (`menus`)
) {install:db_options};

{install:drop_tables}DROP TABLE IF EXISTS `{install:prefix}admin_pages_groups`;
CREATE TABLE `{install:prefix}admin_pages_groups` (
	`id` smallint(4) unsigned NOT NULL auto_increment,
	`order` smallint(4) unsigned NOT NULL,
	`name` varchar(50) NOT NULL,
	`module` varchar(40) NOT NULL,
	PRIMARY KEY (`id`)
) {install:db_options};

{install:drop_tables}DROP TABLE IF EXISTS `{install:prefix}api_tokens`;
CREATE TABLE `{install:prefix}api_tokens` (
  `key` char(32) NOT NULL,
  `member_id` int(11) unsigned default NULL,
  `expires` datetime NOT NULL,
  `ip` bigint(12) NOT NULL,
  `session` char(32) NOT NULL,
  PRIMARY KEY (`key`)
) {install:db_options};

{install:drop_tables}DROP TABLE IF EXISTS `{install:prefix}blocks`;
CREATE TABLE `{install:prefix}blocks` (
	`id` smallint(5) unsigned NOT NULL auto_increment,
	`name` varchar(30) NOT NULL,
	`contents` text,
	`order` smallint(5) unsigned NOT NULL,
	`position` varchar(30) NOT NULL default 'left',
	`type` enum('plain','smarty','php','html','menu') NOT NULL default 'plain',
	`module` varchar(40) NOT NULL,
	`status` enum('active','inactive') NOT NULL default 'active',
	`header` tinyint(1) unsigned NOT NULL default 1,
	`collapsible` tinyint(1) unsigned NOT NULL default 1,
	`collapsed` tinyint(1) unsigned NOT NULL default 0,
	`sticky` tinyint(1) unsigned NOT NULL,
	`rss` tinytext NOT NULL,
	`tpl` varchar(64) NOT NULL default '',
	`external` tinyint(1) NOT NULL default 0,
	`filename` text,
	`removable` tinyint(1) unsigned NOT NULL default 1,
	`subpages` text,
	`classname` varchar(50) NOT NULL,
	PRIMARY KEY (`id`),
	UNIQUE KEY `UNIQUE` (`name`,`module`),
	KEY `STATUS` (`status`)
) {install:db_options};

{install:drop_tables}DROP TABLE IF EXISTS `{install:prefix}config`;
CREATE TABLE `{install:prefix}config` (
	`id` smallint(5) unsigned NOT NULL auto_increment,
	`config_group` varchar(50) NOT NULL,
	`name` varchar(64) NOT NULL,
	`value` text,
	`multiple_values` text,
	`type` enum('text','textarea','checkbox','radio','select','combo','divider','hidden','password','image','itemscheckbox','tpl','colorpicker') NOT NULL default 'text',
	`order` smallint(5) unsigned NOT NULL,
	`module` varchar(40) NOT NULL,
	`private` tinyint(1) unsigned NOT NULL,
	`custom` tinyint(1) unsigned NOT NULL default 0,
	`options` text,
	PRIMARY KEY (`id`),
	KEY `TYPE` (`type`)
) {install:db_options};

{install:drop_tables}DROP TABLE IF EXISTS `{install:prefix}config_custom`;
CREATE TABLE `{install:prefix}config_custom` (
	`id` smallint(5) unsigned NOT NULL auto_increment,
	`name` varchar(64) NOT NULL,
	`value` text NOT NULL,
	`type` enum('user','group','plan') NOT NULL default 'group',
	`type_id` mediumint(8) unsigned NOT NULL,
	`module` varchar(40) NOT NULL,
	PRIMARY KEY (`id`),
	KEY `NAME` (`name`)
) {install:db_options};

{install:drop_tables}DROP TABLE IF EXISTS `{install:prefix}config_groups`;
CREATE TABLE `{install:prefix}config_groups` (
	`name` varchar(50) NOT NULL,
	`order` smallint(4) unsigned NOT NULL,
	`module` varchar(40) NOT NULL,
	PRIMARY KEY (`name`),
	KEY `EXTRAS` (`module`)
) {install:db_options};

{install:drop_tables}DROP TABLE IF EXISTS `{install:prefix}cron`;
CREATE TABLE `{install:prefix}cron` (
	`id` smallint(5) unsigned NOT NULL auto_increment,
	`name` varchar(60) NOT NULL,
	`description` tinytext NOT NULL,
	`date_prev_launch` int(10) unsigned NOT NULL,
	`date_next_launch` int(10) unsigned NOT NULL,
	`data` tinytext NOT NULL,
	`active` tinyint(1) unsigned NOT NULL default 1,
	`module` varchar(40) NOT NULL,
	PRIMARY KEY (`id`),
	KEY `ACTIVE` (`active`)
) {install:db_options};

{install:drop_tables}DROP TABLE IF EXISTS `{install:prefix}currencies`;
CREATE TABLE `{install:prefix}currencies` (
	`code` char(3) NOT NULL,
	`status` enum('active', 'inactive') NOT NULL default 'active',
	`title` varchar(30) NOT NULL,
	`rate` decimal(10,5) unsigned NOT NULL,
	`symbol` varchar(5) NOT NULL,
	`sym_pos` enum('pre', 'post') NOT NULL default 'pre',
	`default` tinyint(1) unsigned NOT NULL,
	`order` tinyint(2) unsigned NOT NULL,
	`fmt_num_decimals` tinyint(2) unsigned NOT NULL default 2,
	`fmt_dec_point` varchar(1) NOT NULL default '.',
	`fmt_thousand_sep` varchar(1) NOT NULL default ',',
	PRIMARY KEY (`code`)
) {install:db_options};

{install:drop_tables}DROP TABLE IF EXISTS `{install:prefix}email_templates`;
CREATE TABLE `{install:prefix}email_templates` (
	`name` varchar(60) NOT NULL,
	`active` tinyint(1) unsigned NOT NULL default 1,
	`divider` tinyint(1) unsigned NOT NULL default 0,
	`order` smallint(5) unsigned NOT NULL,
	`module` varchar(40) NOT NULL,
	`variables` varchar(300) NOT NULL,
	`subject_en` varchar(255) NOT NULL,
	`body_en` text NOT NULL,
	PRIMARY KEY (`name`),
	KEY `ACTIVE` (`active`)
) {install:db_options};

{install:drop_tables}DROP TABLE IF EXISTS `{install:prefix}modules`;
CREATE TABLE `{install:prefix}modules` (
	`id` smallint(4) unsigned NOT NULL auto_increment,
	`name` varchar(40) NOT NULL,
	`type` enum('plugin','package','template','core') NOT NULL default 'plugin',
	`author` varchar(75) NOT NULL,
	`contributor` varchar(75) NOT NULL,
	`title` varchar(150) NOT NULL,
	`items` text,
	`url` varchar(50) NOT NULL default '',
	`status` enum('active','inactive') NOT NULL default 'active',
	`date` datetime NOT NULL,
	`version` varchar(15) NOT NULL,
	`summary` text,
  `category` varchar(20) NOT NULL,
	`uninstall_code` text,
	`uninstall_sql` text,
	`removable` tinyint(1) unsigned NOT NULL default 1,
	`rollback_data` text NOT NULL,
	PRIMARY KEY (`id`),
	UNIQUE KEY `UNIQUE` (`name`)
) {install:db_options};

{install:drop_tables}DROP TABLE IF EXISTS `{install:prefix}favorites`;
CREATE TABLE `{install:prefix}favorites` (
	`id` int(10) unsigned NOT NULL,
	`member_id` int(11) unsigned NOT NULL,
	`item` varchar(50) NOT NULL,
	UNIQUE KEY `UNIQUE` (`id`,`member_id`,`item`)
) {install:db_options};

{install:drop_tables}DROP TABLE IF EXISTS `{install:prefix}fields`;
CREATE TABLE `{install:prefix}fields` (
	`id` smallint(5) unsigned NOT NULL auto_increment,
	`group` smallint(5) unsigned NOT NULL default 1,
	`module` varchar(40) NOT NULL,
	`name` varchar(60) NOT NULL,
	`item` varchar(50) NOT NULL default 'member',
	`fieldgroup_id` smallint(5) unsigned NOT NULL,
	`type` enum('text','url','number','date','textarea','combo','radio','checkbox','storage','image','pictures','currency','tree','iconpicker') NOT NULL default 'text',
	`length` mediumint(7) unsigned NOT NULL,
	`values` text,
	`default` tinytext NOT NULL,
	`order` smallint(5) unsigned NOT NULL,
	`editable` tinyint(1) unsigned NOT NULL default 1,
  `multilingual` tinyint(1) unsigned NOT NULL default 0,
	`required` tinyint(1) unsigned NOT NULL default 0,
	`required_checks` text NOT NULL,
	`extra_actions` text NOT NULL,
	`adminonly` tinyint(1) unsigned NOT NULL,
	`searchable`tinyint(1) unsigned NOT NULL,
	`sort_order` enum('asc','desc') NOT NULL default 'asc',
	`show_as` enum('combo','radio','checkbox') NOT NULL default 'combo',
	`for_plan` tinyint(1) unsigned NOT NULL,
	`status` enum('active','inactive') NOT NULL default 'active',
	`image_width` smallint(5) unsigned NOT NULL,
	`image_height` smallint(5) unsigned NOT NULL,
	`thumb_width` smallint(5) unsigned NOT NULL,
	`thumb_height` smallint(5) unsigned NOT NULL,
	`resize_mode` enum('crop','fit') NOT NULL default 'crop',
	`file_prefix` varchar(50) NOT NULL,
	`file_types` text NOT NULL,
	`use_editor` tinyint(1) unsigned NOT NULL,
	`plans` varchar(250) NOT NULL,
	`timepicker` tinyint(1) unsigned NOT NULL,
	`url_nofollow` tinyint(1) unsigned NOT NULL default 1,
	`empty_field` tinytext NOT NULL,
	`relation` enum('regular','parent','dependent') NOT NULL default 'regular',
	`allow_null` tinyint(1) unsigned NOT NULL,
	`folder_name` varchar(150) NOT NULL,
  `imagetype_primary` varchar(20) NOT NULL,
  `imagetype_thumbnail` varchar(20) NOT NULL,
	PRIMARY KEY (`id`),
	UNIQUE KEY `UNIQUE` (`name`,`item`)
) {install:db_options};

{install:drop_tables}DROP TABLE IF EXISTS `{install:prefix}fields_groups`;
CREATE TABLE `{install:prefix}fields_groups` (
	`id` smallint(5) unsigned NOT NULL auto_increment,
	`name` varchar(50) NOT NULL,
	`item` varchar(50) NOT NULL default 'member',
	`order` smallint(5) unsigned NOT NULL,
	`module` varchar(40) NOT NULL,
	`collapsible` tinyint(1) unsigned NOT NULL,
	`collapsed` tinyint(1) unsigned NOT NULL default 1,
	`tabview` tinyint(1) unsigned NOT NULL,
	`tabcontainer` varchar(60) NOT NULL,
	PRIMARY KEY (`id`),
	UNIQUE KEY `UNIQUE` (`name`,`item`)
) {install:db_options};

{install:drop_tables}DROP TABLE IF EXISTS `{install:prefix}fields_image_types`;
CREATE TABLE `{install:prefix}fields_image_types` (
  `field_id` smallint(5) unsigned NOT NULL,
  `image_type_id` int(9) unsigned NOT NULL,
  UNIQUE KEY `UNIQUE` (`field_id`,`image_type_id`)
) {install:db_options};

{install:drop_tables}DROP TABLE IF EXISTS `{install:prefix}fields_pages`;
CREATE TABLE `{install:prefix}fields_pages` (
  `field_id` smallint(5) unsigned NOT NULL,
	`page_name` varchar(50) NOT NULL,
	UNIQUE KEY `UNIQUE` (`field_id`, `page_name`)
) {install:db_options};

{install:drop_tables}DROP TABLE IF EXISTS `{install:prefix}fields_relations`;
CREATE TABLE `{install:prefix}fields_relations` (
	`id` mediumint(8) unsigned NOT NULL auto_increment,
	`field_id` smallint(5) unsigned NOT NULL,
	`element` varchar(50) NOT NULL,
	`child` varchar(50) NOT NULL,
	PRIMARY KEY (`id`),
	KEY `FIELD` (`field_id`)
) {install:db_options};

{install:drop_tables}DROP TABLE IF EXISTS `{install:prefix}fields_tree_nodes`;
CREATE TABLE `{install:prefix}fields_tree_nodes` (
	`id` mediumint(8) unsigned NOT NULL auto_increment,
	`field` varchar(50) NOT NULL,
	`item` varchar(30) NOT NULL,
	`module` varchar(40) NOT NULL,
	`node_id` varchar(30) NOT NULL,
	`parent_node_id` varchar(30) NOT NULL,
	`alias` varchar(150) NOT NULL,
	`num_listings` int(11) NOT NULL,
	PRIMARY KEY (`id`),
	KEY `ITEMNAME` (`item`)
) {install:db_options};

{install:drop_tables}DROP TABLE IF EXISTS `{install:prefix}file_types`;
CREATE TABLE `{install:prefix}file_types` (
	`id` int(9) unsigned NOT NULL auto_increment,
	`extension` varchar(10) NOT NULL default '',
	`maxsize` int(11) unsigned NOT NULL default 0,
	`image` tinyint(1) unsigned default 0,
	PRIMARY KEY (`id`),
	KEY `EXTENSION` (`extension`)
) {install:db_options};

{install:drop_tables}DROP TABLE IF EXISTS `{install:prefix}hooks`;
CREATE TABLE `{install:prefix}hooks` (
	`id` smallint(5) unsigned NOT NULL auto_increment,
	`module` varchar(40) NOT NULL,
	`name` varchar(100) NOT NULL,
	`code` text,
	`status` enum('active','inactive') NOT NULL default 'active',
	`order` smallint(5) unsigned NOT NULL,
	`pages` tinytext NOT NULL,
	`type` enum('php','html','smarty','plain') NOT NULL default 'php',
	`page_type` enum('admin','front','both') NOT NULL default 'both',
	`filename` tinytext NOT NULL,
	PRIMARY KEY (`id`),
	UNIQUE KEY `UNIQUE` (`name`,`module`),
	KEY `STATUS` (`status`)
) {install:db_options};

{install:drop_tables}DROP TABLE IF EXISTS `{install:prefix}image_types`;
CREATE TABLE `{install:prefix}image_types` (
	`id` smallint(5) unsigned NOT NULL auto_increment,
	`name` varchar(50) NOT NULL,
	`width` int(11) unsigned NOT NULL,
	`height` int(11) unsigned NOT NULL,
	`resize_mode` enum('crop','fit') NOT NULL default 'crop',
	`cropper` tinyint(1) NOT NULL default 0,
  `module` varchar(40) NOT NULL default '',
	PRIMARY KEY (`id`)
) {install:db_options};

{install:drop_tables}DROP TABLE IF EXISTS `{install:prefix}image_types_filetypes`;
CREATE TABLE `{install:prefix}image_types_filetypes` (
  `image_type_id` smallint(5) unsigned NOT NULL,
  `file_type_id` int(9) unsigned NOT NULL,
  UNIQUE KEY `UNIQUE` (`image_type_id`,`file_type_id`)
) {install:db_options};

{install:drop_tables}DROP TABLE IF EXISTS `{install:prefix}invoices`;
CREATE TABLE `{install:prefix}invoices`(
  `id` bigint(12) unsigned NOT NULL,
  `transaction_id` int(10) unsigned NOT NULL,
  `date_created` datetime NOT NULL,
  `date_due` datetime default NULL,
  `fullname` varchar(200) NOT NULL,
  `member_id` int(11) unsigned NOT NULL,
  `address1` tinytext NOT NULL,
  `address2` tinytext NOT NULL,
  `zip` varchar(12) NOT NULL,
  `country` varchar(32) NOT NULL,
  `notes` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `TRANSACTION` (`transaction_id`)
) {install:db_options};

{install:drop_tables}DROP TABLE IF EXISTS `{install:prefix}invoices_items`;
CREATE TABLE `{install:prefix}invoices_items`(
  `id` int(9) unsigned NOT NULL auto_increment,
  `invoice_id` bigint(12) unsigned NOT NULL,
  `title` tinytext NOT NULL,
  `price` decimal(11,2) unsigned NOT NULL,
  `quantity` smallint(5) unsigned NOT NULL,
  `tax` tinyint(3) unsigned,
  PRIMARY KEY (`id`),
  KEY `INVOICE` (`invoice_id`)
) {install:db_options};

{install:drop_tables}DROP TABLE IF EXISTS `{install:prefix}items`;
CREATE TABLE `{install:prefix}items` (
  `id` smallint(5) unsigned NOT NULL auto_increment,
  `item` varchar(50) NOT NULL,
  `module` varchar(50) NOT NULL,
  `instantiable` tinyint(1) unsigned NOT NULL default 1,
  `payable` tinyint(1) unsigned NOT NULL default 1,
  `searchable` tinyint(1) unsigned NOT NULL default 0,
  `pages` tinytext NOT NULL,
  `table_name` varchar(50) NOT NULL,
  `class_name` varchar(50) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ITEM` (`item`)
) {install:db_options};

{install:drop_tables}DROP TABLE IF EXISTS `{install:prefix}items_pages`;
CREATE TABLE `{install:prefix}items_pages` (
	`id` mediumint(8) unsigned NOT NULL auto_increment,
	`page_name` varchar(50) NOT NULL,
	`item` varchar(30) NOT NULL,
	PRIMARY KEY (`id`),
	UNIQUE KEY `UNIQUE` (`page_name`,`item`)
) {install:db_options};

{install:drop_tables}DROP TABLE IF EXISTS `{install:prefix}languages`;
CREATE TABLE `{install:prefix}languages` (
	`id` smallint(5) unsigned NOT NULL auto_increment,
	`code` char(2) NOT NULL,
	`title` varchar(100) NOT NULL,
	`locale` varchar(30) NOT NULL,
	`date_format` varchar(50) NOT NULL,
	`time_format` varchar(50) NOT NULL,
	`author` varchar(100) NOT NULL,
	`direction` varchar(5) NOT NULL default 'ltr',
	`master` tinyint(1) unsigned NOT NULL default 0,
	`default` tinyint(1) unsigned NOT NULL default 0,
	`order` smallint(5) unsigned NOT NULL default 0,
	`status` enum('active','inactive') NOT NULL default 'active',
	`flagicon` tinytext NOT NULL,
	PRIMARY KEY (`id`),
	UNIQUE `CODE` (`code`)
) {install:db_options};

{install:drop_tables}DROP TABLE IF EXISTS `{install:prefix}language`;
CREATE TABLE `{install:prefix}language` (
	`id` int(10) unsigned NOT NULL auto_increment,
	`key` varchar(64) NOT NULL,
	`original` text NOT NULL,
	`value` text NOT NULL,
	`category` enum('admin','frontend','common','page','tooltip','api') NOT NULL default 'frontend',
	`code` char(2) NOT NULL,
	`module` varchar(40) NOT NULL,
	`api` tinyint(1) NOT NULL default 0,
	PRIMARY KEY (`id`),
	UNIQUE KEY `UNIQUE` (`key`,`category`,`code`,`module`),
	KEY `LANG` (`code`)
) {install:db_options};

{install:drop_tables}DROP TABLE IF EXISTS `{install:prefix}logs`;
CREATE TABLE `{install:prefix}logs` (
	`id` int(8) unsigned NOT NULL auto_increment,
	`date` datetime NOT NULL,
	`action` tinyint(3) unsigned NOT NULL,
	`user_id` int(11) unsigned default null,
	`module` varchar(40) NOT NULL default '',
	`params` text null,
	PRIMARY KEY (`id`),
	KEY `PLUGIN` (`module`)
) {install:db_options};

{install:drop_tables}DROP TABLE IF EXISTS `{install:prefix}members`;
CREATE TABLE `{install:prefix}members` (
	`id` int(11) unsigned NOT NULL auto_increment,
	`usergroup_id` smallint(5) unsigned NOT NULL default 8,
	`username` varchar(50) NOT NULL,
	`password` varchar(191) NOT NULL,
	`email` varchar(191) NOT NULL,
	`sec_key` varchar(32) NOT NULL,
	`status` enum('approval','active','unconfirmed','suspended') NOT NULL default 'active',
	`date_reg` datetime NOT NULL,
	`date_update` datetime NOT NULL,
	`date_logged` datetime null,
	`views_num` mediumint(8) unsigned NOT NULL,
	`fullname` tinytext NOT NULL,
	`avatar` tinytext NOT NULL,
	`website` tinytext NOT NULL,
	`phone` tinytext NOT NULL,
	`biography` text NOT NULL,
	`facebook` tinytext NOT NULL,
	`twitter` tinytext NOT NULL,
	`gplus` tinytext NOT NULL,
	`linkedin` tinytext NOT NULL,
	`funds` decimal(12,2) unsigned NOT NULL,
	`disable_fields` tinyint(1) unsigned NOT NULL,
	`admin_columns` text NOT NULL,
	`featured` tinyint(1) unsigned NOT NULL,
	`featured_start` datetime null,
	`featured_end` datetime null,
	`sponsored` tinyint(1) unsigned NOT NULL,
	`sponsored_start` datetime null,
	`sponsored_end` datetime null,
	`sponsored_plan_id` smallint(5) unsigned NOT NULL,
	`api_push_token` tinytext NOT NULL,
	`api_push_receive` enum('yes','no') NOT NULL default 'yes',
  `email_language` varchar(2) NOT NULL,
	PRIMARY KEY (`id`),
	UNIQUE KEY `USERNAME` (`username`),
	UNIQUE KEY `EMAIL` (`email`),
	KEY `STATUS` (`status`)
) {install:db_options};

{install:drop_tables}DROP TABLE IF EXISTS `{install:prefix}members_auth_providers`;
CREATE TABLE `{install:prefix}members_auth_providers` (
	`id` int(11) NOT NULL auto_increment,
	`member_id` int(11) NOT NULL,
	`name` varchar(50) NOT NULL,
	`value` varchar(100) NOT NULL,
	PRIMARY KEY (`id`)
) {install:db_options};

CREATE TRIGGER del_hybridauth_data AFTER DELETE ON `{install:prefix}members`
FOR EACH ROW DELETE FROM `{install:prefix}members_auth_providers` WHERE `{install:prefix}members_auth_providers`.`member_id` = OLD.`id`;

{install:drop_tables}DROP TABLE IF EXISTS `{install:prefix}menus`;
CREATE TABLE `{install:prefix}menus` (
	`id` smallint(5) unsigned NOT NULL auto_increment,
	`menu_id` smallint(5) unsigned NOT NULL,
	`parent_id` varchar(10) NOT NULL,
	`el_id` varchar(10) NOT NULL,
	`page_name` varchar(100) NOT NULL default 'none',
	`level` smallint(4) unsigned NOT NULL,
	PRIMARY KEY (`id`),
	KEY `MENU` (`menu_id`)
) {install:db_options};

{install:drop_tables}DROP TABLE IF EXISTS `{install:prefix}migrations`;
CREATE TABLE `{install:prefix}migrations` (
	`id` smallint(5) unsigned NOT NULL auto_increment,
	`name` varchar(100) NOT NULL default '',
	`status` enum('incomplete','skipped','complete') NOT NULL default 'complete',
	`data` text,
	`date` datetime null,
	PRIMARY KEY (`id`)
) {install:db_options};

#{install:drop_tables}DROP TABLE IF EXISTS `{install:prefix}oauth`;
#CREATE TABLE `{install:prefix}oauth` (
#  `key` varchar(40) NOT NULL,
#  `type` enum('access_token','authorization_code','refresh_token','client') NOT NULL,
#  `client_id` varchar(50) default NULL,
#  `user_id` int(11) default NULL,
#  `expires` datetime NOT NULL,
# `data` tinytext,
#  PRIMARY KEY (`key`,`type`)
#) {install:db_options};

{install:drop_tables}DROP TABLE IF EXISTS `{install:prefix}objects_pages`;
CREATE TABLE `{install:prefix}objects_pages` (
	`object_type` varchar(50) NOT NULL,
	`page_name` varchar(50) NOT NULL,
	`object` varchar(100) NOT NULL,
	`access` tinyint(1) unsigned NOT NULL default 1,
	UNIQUE KEY `unique` (`object_type`,`page_name`,`object`)
) {install:db_options};

{install:drop_tables}DROP TABLE IF EXISTS `{install:prefix}online`;
CREATE TABLE `{install:prefix}online` (
	`id` int(11) unsigned NOT NULL auto_increment,
	`is_bot` tinyint(1) unsigned NOT NULL default 0,
	`session_id` char(32) NOT NULL,
	`date` datetime NOT NULL,
	`status` enum('active','expired') NOT NULL default 'active',
	`username` varchar(50) NOT NULL default '',
	`fullname` tinytext NOT NULL,
	`page` varchar(150) NOT NULL,
	`ip` bigint(12) NOT NULL,
	PRIMARY KEY (`id`),
	UNIQUE `SESSION` (`session_id`)
) {install:db_options};

{install:drop_tables}DROP TABLE IF EXISTS `{install:prefix}pages`;
CREATE TABLE `{install:prefix}pages` (
	`id` mediumint(7) unsigned NOT NULL auto_increment,
	`group` smallint(5) unsigned NOT NULL default 1,
	`name` varchar(50) NOT NULL,
	`service` tinyint(1) unsigned NOT NULL,
	`readonly` tinyint(1) unsigned NOT NULL,
	`status` enum('active','inactive','draft') NOT NULL default 'draft',
	`last_updated` datetime NOT NULL,
	`order` mediumint(7) unsigned NOT NULL,
	`alias` varchar(150) NOT NULL,
	`nofollow` tinyint(1) unsigned NOT NULL,
	`new_window` tinyint(1) unsigned NOT NULL,
	`module` varchar(40) NOT NULL,
	`passw` char(32) NOT NULL default '',
	`filename` varchar(50) NOT NULL,
	`custom_tpl` tinyint(1) NOT NULL,
	`template_filename` varchar(64) NOT NULL,
	`custom_url` tinytext NOT NULL,
	`menus` set('main','bottom','account','inventory') NOT NULL default '',
	`action` varchar(10) NOT NULL default 'read',
	`parent` varchar(50) NOT NULL,
	`suburl` varchar(150) NOT NULL,
	`fields_item` varchar(50) NOT NULL,
	PRIMARY KEY (`id`),
	UNIQUE KEY `NAME` (`name`),
	KEY `ALIAS` (`alias`)
) {install:db_options};

{install:drop_tables}DROP TABLE IF EXISTS `{install:prefix}payment_gateways`;
CREATE TABLE `{install:prefix}payment_gateways` (
	`id` smallint(5) unsigned NOT NULL auto_increment,
	`name` varchar(50) NOT NULL,
	`title` varchar(100) NOT NULL,
	PRIMARY KEY (`id`),
	UNIQUE KEY `NAME` (`name`)
) {install:db_options};

{install:drop_tables}DROP TABLE IF EXISTS `{install:prefix}payment_gateways_ipn_log`;
CREATE TABLE `{install:prefix}payment_gateways_ipn_log` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `date` datetime NOT NULL,
  `gateway` varchar(50) NOT NULL,
  `data` text,
  `result` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) {install:db_options};

{install:drop_tables}DROP TABLE IF EXISTS `{install:prefix}payment_plans`;
CREATE TABLE IF NOT EXISTS `{install:prefix}payment_plans` (
  `id` smallint(5) unsigned NOT NULL auto_increment,
  `cost` decimal(10,2) unsigned NOT NULL,
  `item` varchar(50) default null,
  `data` text,
  `duration` int(10) unsigned NOT NULL comment 'Duration of cycle in units',
  `unit` enum('hour','day','week','month','year') comment 'Unit of measure',
  `order` tinyint(3) unsigned NOT NULL,
  `status` enum('inactive','active') NOT NULL default 'inactive',
  `email` varchar(128) NOT NULL,
  `usergroup` smallint(5) unsigned NOT NULL,
  `recurring` tinyint(1) unsigned NOT NULL comment 'Is this plan recurring?',
  `cycles` smallint(5) NOT NULL default 0 comment 'Number of recurring cycles',
  `expiration_status` varchar(15) NOT NULL comment 'Status which will be applied on plan expiration',
  `type` enum('fee', 'subscription') NOT NULL default 'subscription',
  `listings_limit` int(7) unsigned NOT NULL,
  PRIMARY KEY (`id`)
) {install:db_options};

{install:drop_tables}DROP TABLE IF EXISTS `{install:prefix}payment_plans_options`;
CREATE TABLE `{install:prefix}payment_plans_options` (
  `id` smallint(5) unsigned NOT NULL auto_increment,
  `type` enum('bool','int','float','string') NOT NULL default 'string',
  `chargeable` tinyint(1) unsigned NOT NULL default 0,
  `name` varchar(32) NOT NULL,
  `default_value` varchar(32) NOT NULL,
  `item` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) {install:db_options};

{install:drop_tables}DROP TABLE IF EXISTS `{install:prefix}payment_plans_options_values`;
CREATE TABLE `{install:prefix}payment_plans_options_values` (
  `plan_id` smallint(5) unsigned NOT NULL,
  `option_id` smallint(5) unsigned NOT NULL,
  `price` decimal(8,2) unsigned default NULL,
  `value` varchar(96) NOT NULL,
  UNIQUE KEY `UNIQUE` (`plan_id`,`option_id`)
) {install:db_options};

{install:drop_tables}DROP TABLE IF EXISTS `{install:prefix}payment_subscriptions`;
CREATE TABLE `{install:prefix}payment_subscriptions` (
  `id` int(9) unsigned NOT NULL auto_increment,
  `date_created` datetime,
  `date_next_payment` datetime,
  `reference_id` varchar(64) default NULL,
  `member_id` int(11) unsigned NOT NULL,
  `plan_id` smallint(5) unsigned NOT NULL,
  `item` varchar(30) default NULL,
  `item_id` int(11) unsigned default NULL,
  `status` enum('active','pending','suspended','canceled','failed','completed') NOT NULL,
  PRIMARY KEY (`id`),
  INDEX `REFERENCE` (`reference_id`)
) {install:db_options};

{install:drop_tables}DROP TABLE IF EXISTS `{install:prefix}payment_transactions`;
CREATE TABLE `{install:prefix}payment_transactions` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `member_id` int(11) unsigned NOT NULL,
  `subscription_id` int(9) unsigned default NULL,
  `plan_id` smallint(5) unsigned NOT NULL,
  `reference_id` varchar(64) NOT NULL,
  `item` varchar(30) NOT NULL,
  `item_id` int(11) unsigned NOT NULL,
  `fullname` varchar(100) NOT NULL,
  `email` varchar(200) NOT NULL,
  `date_created` datetime NULL,
  `date_updated` datetime NULL,
  `date_paid` datetime NULL,
  `amount` decimal(10,2) unsigned NOT NULL,
  `currency` varchar(3) NOT NULL,
  `status` enum('pending','passed','failed','refunded') NOT NULL default 'pending',
  `operation` varchar(100) NOT NULL,
  `gateway` varchar(50) NOT NULL,
  `sec_key` varchar(14) NOT NULL,
  `return_url` tinytext NOT NULL,
  `notes` tinytext default NULL,
  `demo` tinyint(1) unsigned NOT NULL default 0,
  PRIMARY KEY (`id`)
) {install:db_options};

{install:drop_tables}DROP TABLE IF EXISTS `{install:prefix}positions`;
CREATE TABLE `{install:prefix}positions` (
  `name` varchar(100) NOT NULL,
  `menu` tinyint(1) unsigned NOT NULL default 0,
  `movable` tinyint(1) unsigned NOT NULL default 1,
  PRIMARY KEY (`name`)
) {install:db_options};

{install:drop_tables}DROP TABLE IF EXISTS `{install:prefix}search`;
CREATE TABLE `{install:prefix}search` (
  `id` int(9) unsigned NOT NULL auto_increment,
  `member_id` int(11) unsigned NOT NULL,
  `date` datetime NOT NULL,
  `item` varchar(16) NOT NULL,
  `params` varchar(400) NOT NULL,
  `title` varchar(64) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `SEARCH` (`member_id`,`item`)
) {install:db_options};

{install:drop_tables}DROP TABLE IF EXISTS `{install:prefix}usergroups`;
CREATE TABLE `{install:prefix}usergroups` (
	`id` smallint(5) unsigned NOT NULL auto_increment,
	`name` varchar(100) NOT NULL,
	`module` varchar(40) NOT NULL,
	`system` tinyint(1) unsigned NOT NULL,
	`assignable` tinyint(1) unsigned NOT NULL default 0,
	`visible` tinyint(1) unsigned NOT NULL default 0,
	`order` smallint(5) unsigned NOT NULL,
	PRIMARY KEY (`id`)
) {install:db_options};

{install:drop_tables}DROP TABLE IF EXISTS `{install:prefix}views_log`;
CREATE TABLE `{install:prefix}views_log` (
	`id` int(10) unsigned NOT NULL auto_increment,
	`item` char(16) NOT NULL,
	`item_id` int(11) unsigned NOT NULL,
	`ip` bigint(12) NOT NULL,
	`date` date NOT NULL,
	PRIMARY KEY (`id`),
	UNIQUE KEY `UNIQUE` (`item`,`item_id`,`ip`,`date`)
) {install:db_options};

-- ----------------------------
-- Records
-- ----------------------------
INSERT INTO `{install:prefix}acl_privileges` (`type_id`,`access`,`object`,`object_id`) VALUES
(2,1,'admin_access','0'),
(4,0,'page','member_funds'),
(4,0,'page','profile'),
(8,1,'page','profile');

INSERT INTO `{install:prefix}acl_objects` (`pre_object`,`object`,`action`,`access`) VALUES
('admin_access','admin_access','read',0),
('admin_page','blocks','smarty',1),
('admin_page','blocks','plain',1),
('admin_page','blocks','php',1),
('admin_page','blocks','html',1),
('admin_page','blocks','edit',1),
('admin_page','blocks','visual',0),
('admin_page','blocks','order',0),
('admin_page','configuration','edit',0),
('admin_page','currencies','add',1),
('admin_page','currencies','edit',1),
('admin_page','currencies','delete',1),
('admin_page','database','sql',1),
('admin_page','database','export',0),
('admin_page','database','import',0),
('admin_page','database','consistency',1),
('admin_page','database','reset',1),
('admin_page','fields','members',0),
('admin_page','index','cache',1),
('admin_page','index','debugmode',0),
('admin_page','index','phpinfo',0),
('admin_page','index','sitemap',1),
('admin_page','members','add',1),
('admin_page','members','edit',0),
('admin_page','members','password',0),
('admin_page','members','usergroup',0),
('admin_page','menus','add',1),
('admin_page','menus','edit',1),
('admin_page','packages','activate',0),
('admin_page','packages','set_default',0),
('admin_page','packages','uninstall',0),
('admin_page','packages','install',0),
('admin_page','packages','upgrade',0),
('admin_page','pages','add',1),
('admin_page','pages','edit',1),
('admin_page','pages','home',0),
('admin_page','permissions','read',0),
('admin_page','permissions','edit',0),
('admin_page','plans','add',1),
('admin_page','plans','edit',1),
('admin_page','plans','delete',1),
('admin_page','plugins','install',1),
('admin_page','plugins','uninstall',0),
('admin_page','plugins','reinstall',0),
('admin_page','plugins','update',0);

INSERT INTO `{install:prefix}admin_actions` (`name`,`url`,`icon`,`attributes`,`pages`,`text`,`type`,`order`) VALUES
('members','members/','list','','members:add,members:edit,usergroups:read','','regular',1),
('add_member','members/add/','user','','members:read,members:edit,usergroups','','regular',2),
('usergroups','usergroups/','grid','','members,usergroups:add','','regular',3),
('add_usergroup','usergroups/add/','users','','usergroups:read','','regular',4),
('fields','fields/members/','signup','','members,usergroups','','regular',5),
('delete','javascript:;','remove','id="js-delete-block"','blocks:edit','','regular',1),
('blocks','blocks/','grid','','blocks:add,blocks:edit','','regular',2),
('add_block','blocks/create/','plus-alt','','blocks','','regular',3),
('sql_management','database/sql/','database','','database','','regular',1),
('reset','database/reset/','loop','','database','','regular',2),
('consistency','database/consistency/','spinner','','database','','regular',3),
('export','database/export/','box-remove','','database','','regular',5),
('import','database/import/','box-add','','database','','regular',6),
('fields','fields/','list','','fields:edit,member_fields','','regular',1),
('add_field','fields/add/','plus-alt','','fields,member_fields','','regular',2),
('field_groups','fieldgroups/','list-2','','fieldgroups,member_fields','','regular',3),
('add_fieldgroup','fieldgroups/add/','folder-plus','','fieldgroups,member_fields','','regular',4),
('image_types','image-types/','list','','imagetypes:edit','','regular',1),
('add_image_type','image-types/add/','plus-alt','','imagetypes','','regular',2),
('add_invoice','invoices/add/','plus-alt','','invoices,invoices:edit','','regular',1),
('languages','languages/','list','','languages','','regular',1),
('new_language','languages/add/','copy','','languages','','regular',2),
('download','languages/download/','box-remove','','languages','','regular',3),
('add_phrase','phrases/add/','plus-alt','','languages,phrases','','regular',4),
('languages_comparison','languages/comparison/','link-2','','languages','','regular',5),
('menus','menus/','list','','menus:add,menus:edit','','regular',3),
('add_menu','menus/add/','plus-alt','','menus','','regular',4),
('delete','javascript:;','remove','id="js-delete-page"','pages:edit','','regular',1),
('pages','pages/','list','','pages:add,pages:edit','','regular',2),
('add_page','pages/add/','plus-alt','','pages','','regular',3),
('plans','plans/','list','','plans:add,plans:edit','','regular',3),
('add_plan','plans/add/','plus-alt','','plans','','regular',4),
('print_invoice','invoices/printable/:id/','file','target="_blank"','invoices:edit','','regular',2),
('add_transaction','javascript:;','plus','id="js-add-transaction-cmd"','transactions','','regular',1),
('tags','javascript:;','eye','id="js-view-tags"','email_templates','','regular',1),
('add_currency','currencies/add/','plus-alt','','currencies','','regular',3),
('list_currencies','currencies/','list','','currencies:add,currencies:edit','','regular',3),

('blocks','blocks/','grid','','','','dashboard',0),
('add_page','pages/add/','copy','','','','dashboard',0);

INSERT INTO `{install:prefix}admin_pages` (`group`,`name`,`action`,`parent`,`filename`,`alias`,`menus`,`attr`,`order`) VALUES
(0,'index','read','','index','','menu',null,0),
(0,'actions','read','','actions','actions/',null,null,0),
(0,'','','','','','header',null,20),
(0,'adminer','read','','adminer','adminer/','header',null,25),
(0,'','','','','','header',null,30),
(0,'visual_mode','visual','blocks','visual','visual-mode/',null,'target=\"_blank\"',0),

-- SYSTEM
(1,'','','','','','menu','sys_mgmt',0),
(1,'configuration','read','','configuration','configuration/','header',null,5),
(1,'database','read','','database','database/','menu,header',null,10),
(1,'languages','read','','languages','languages/','menu',null,15),
(1,'hooks','read','','hooks','hooks/','menu',null,20),
(1,'scheduled_tasks','read','','scheduled-tasks','scheduled-tasks/','menu',null,22),
(1,'','','','','','menu','sys_email',25),
(1,'email_templates','read','','email-templates','email-templates/','menu',null,30),
(1,'','','','','','menu','sys_extra',35),
(1,'clear_cache','cache','index','index','clear/cache/','menu,header',null,37),
(1,'phpinfo','phpinfo','index','index','phpinfo/','menu,header',null,40),
(1,'debugmode','debugmode','index','index','debug-mode/','',null,41),
(1,'sitemap','sitemap','index','index','sitemap/','menu,header',null,45),

-- CONTENT
(2,'pages','read','','pages','pages/','menu',null,5),
(2,'menus','read','','menus','menus/','menu',null,10),
(2,'blocks','read','','blocks','blocks/','menu',null,15),
(2,'phrases','read','','phrases','phrases/','menu',null,20),
(2,'uploads','read','','uploads','uploads/','menu',null,23),
(2,'','','','','','menu','ctnt_ext',25),
(2,'fieldgroups','read','','fieldgroups','fieldgroups/','menu',null,30),
(2,'fields','read','','fields','fields/','menu',null,35),
(2,'imagetypes','read','','image-types','image-types/','menu',null,40),
(2,'','','','','','menu','ctnt_xtns',45),

-- MEMBERS
(3,'members','read','','members','members/','menu',null,5),
(3,'usergroups','read','','usergroups','usergroups/','menu,header',null,10),
(3,'','','','','','menu','mbr_ext',15),
(3,'permissions','read','','permissions','permissions/','menu',null,20),
(3,'member_fields','member','fields','fields','fields/members/','menu',null,25),

-- FINANCIAL
(4,'currencies','read','','currencies','currencies/','menu',null,0),
(4,'','','','','','menu','fin_mgmt',5),
(4,'plans','read','','plans','plans/','menu',null,10),
(4,'subscriptions','read','','subscriptions','subscriptions/','menu',null,15),
(4,'transactions','read','','transactions','transactions/','menu',null,20),
(4,'invoices','read','','invoices','invoices/','menu',null,25),

-- EXTENSIONS
(5,'templates','read','','modules','modules/templates/','menu',null,5),
(5,'plugins','read','','modules','modules/plugins/','menu',null,10),
(5,'packages','read','','modules','modules/packages/','menu',null,15),
(5,'','','','','','menu','xtns_empt',20);

UPDATE `{install:prefix}admin_pages` SET `readonly` = 1 WHERE `name` IN('actions','visual_mode');

INSERT INTO `{install:prefix}admin_pages_groups` (`name`) VALUES
('system'),
('content'),
('members'),
('financial'),
('extensions');

INSERT INTO `{install:prefix}blocks` VALUES
(2,'inventory','',0,'inventory','menu','','active',0,0,0,1,'','render-menu.tpl',0,'',0,'',''),
(3,'main','',0,'mainmenu','menu','','active',0,0,0,1,'','render-menu.tpl',0,'',0,'',''),
(4,'account','',0,'right','menu','','active',0,0,0,1,'','render-menu.tpl',0,'',0,'',''),
(5,'bottom','',0,'copyright','menu','','active',0,0,0,1,'','render-menu.tpl',0,'',0,'',''),
(6,'common_statistics','',1,'right','smarty','','active',1,0,0,0,'','',1,'block.common-statistics.tpl',0,'',''),
(7,'filters','$iaView = &$iaCore->iaView;\r\n\r\nif (($itemName = $iaView->get(''filtersItemName''))\r\n	|| (($itemName = str_replace(''search_'', '''', $iaView->name())) && $itemName != $iaView->name()))\r\n{\r\n	$iaView->iaSmarty->assign(''filters'', $iaCore->factory(''search'', iaCore::FRONT)->getFilters($itemName));\r\n\r\n	echo $iaView->iaSmarty->fetch(''block.filters.tpl'');\r\n}',1,'left','php','','active',1,1,0,1,'','',0,'',1,'','');

INSERT INTO `{install:prefix}config` (`name`,`value`,`type`,`private`) VALUES
('debug_pass','','hidden',1),
('tmpl','{install:tmpl}','hidden',0),
('backup','backup/','hidden',1),
('version','{install:version}','hidden',1),
('cron','1','hidden',1),
('admin_tmpl','default','hidden',1),
('default_package','','hidden',1),
('home_page','index','hidden',1),
('tmpl_rollback_data','','hidden',1),
('tmpl_layout_data','','hidden',1);

INSERT INTO `{install:prefix}config` (`config_group`, `name`, `value`, `multiple_values`, `type`, `order`, `private`, `custom`, `options`) VALUES
('general', '', 'General', '1', 'divider', 0, 1, 1,''),
('general', 'site', '{"en":"Subrion CMS"}', '1', 'text', 2, 0, 1, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":1}'),
('general', 'bc_home', '{"en":"Home"}', NULL, 'text', 3, 1, 1, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":1}'),
('general', 'suffix', '{"en":":: Powered by Subrion 4.2"}', '1', 'text', 9, 0, 1, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":1}'),
('general', 'site_logo', '', '', 'image', 12, 0, 0, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
('general', 'site_favicon', '', '', 'image', 13, 0, 0, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
('general', '', 'Regional', '1', 'divider', 20, 1, 1, ''),
('general', 'lang', 'en', '1', 'select', 33, 0, 1,'{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
('general', 'language_switch', '1', '\'1\',\'0\'', 'radio', 36, 0, 1,'{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
('general', 'timezone', 'America/New_York', '', 'select', 45, 0, 0, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),

('members', '', 'General', '1', 'divider', 1, 1, 0,''),
('members', 'members_enabled', '1', '\'1\',\'0\'', 'radio', 2, 1, 0, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
('members', 'members_autoapproval', '1', '\'1\',\'0\'', 'radio', 3, 0, 0, '{"wysiwyg":0,"code_editor":0,"show":"members_enabled|1","multilingual":0}'),
('members', 'members_per_page', '20', '0', 'text', 4, 1, 0, '{"wysiwyg":0,"code_editor":0,"show":"members_enabled|1","multilingual":0}'),
('members', '', 'HybridAuth', '1', 'divider', 5, 1, 0, ''),
('members', 'hybrid_enabled', '0', '\'1\',\'0\'', 'radio', 6, 1, 0, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
('members', 'hybrid_debug_mode', '0', '\'1\',\'0\'', 'radio', 7, 1, 0, '{"wysiwyg":0,"code_editor":0,"show":"hybrid_enabled|1","multilingual":0}'),
('members', '', 'Gravatar', '1', 'divider', 10, 1, 0, ''),
('members', 'gravatar_enabled', '1', '\'1\',\'0\'', 'radio', 11, 1, 0, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
('members', 'gravatar_size', '100', '1', 'text', 12, 1, 0, '{"wysiwyg":0,"code_editor":0,"show":"gravatar_enabled|1","multilingual":0}'),
('members', 'gravatar_type', 'mm', '\'mm\',\'identicon\',\'monsterid\',\'wavatar\',\'retro\'', 'select', 13, 1, 0, '{"wysiwyg":0,"code_editor":0,"show":"gravatar_enabled|1","multilingual":0}'),
('members', 'gravatar_rating', 'g', '\'g\',\'pg\',\'r\',\'x\'', 'select', 14, 1, 0, '{"wysiwyg":0,"code_editor":0,"show":"gravatar_enabled|1","multilingual":0}'),
('members', 'gravatar_default_image', '', '', 'image', 16, 0, 0, '{"wysiwyg":0,"code_editor":0,"show":"gravatar_enabled|1","multilingual":0}'),

('mail', '', 'General', '1', 'divider', 1, 1, 0,''),
('mail', 'site_from_name', '{"en":"Subrion CMS"}', '1', 'text', 5, 1, 0, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":1}'),
('mail', 'site_email', '{install:email}', '1', 'text', 8, 1, 0, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
('mail', 'bcc_email', '', '1', 'text', 10, 1, 0, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
('mail', 'default_email_signature', '{"en":"<p>______________________________</p>\\r\\n<p>Thank you,<br>\\r\\n{%SITE_NAME%} Team<br>\\r\\n{%SITE_URL%}</p>","ru":"<p>______________________________</p>\\r\\n<p>Thank you,<br>\\r\\n{%SITE_NAME%} Team<br>\\r\\n{%SITE_URL%}</p>","kg":"<p>______________________________</p>\\r\\n<p>Thank you,<br>\\r\\n{%SITE_NAME%} Team<br>\\r\\n{%SITE_URL%}</p>"}', '1', 'textarea', 15, 1, 0, '{"wysiwyg":0,"code_editor":0,\"show\":\"\","multilingual":1}'),
('mail', 'mail_function', 'php mail', '\'php mail\',\'sendmail\',\'smtp\'', 'select', 18, 1, 0, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
('mail', 'mail_test', '', 'admin/templates/default/configuration-test-email-btn.tpl', 'tpl', 21, 1, 0, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
('mail', '', 'SMTP Settings', '', 'divider', 24, 9, 0, '{"wysiwyg":0,"code_editor":0,"show":"mail_function|smtp","multilingual":0}'),
('mail', 'smtp_debug', '0', '\'1\',\'0\'', 'radio', 25, 1, 0, '{"wysiwyg":0,"code_editor":0,"show":"mail_function|smtp","multilingual":0}'),
('mail', 'smtp_debug_output', 'echo', '\'echo\',\'html\',\'error_log\'', 'select', 26, 1, 0, '{"wysiwyg":0,"code_editor":0,"show":"smtp_debug|1","multilingual":0}'),
('mail', 'smtp_auth', '1', '\'1\',\'0\'', 'radio', 27, 1, 0, '{"wysiwyg":0,"code_editor":0,"show":"mail_function|smtp","multilingual":0}'),
('mail', 'smtp_server', 'smtp.example.org', '', 'text', 30, 1, 0, '{"wysiwyg":0,"code_editor":0,"show":"mail_function|smtp","multilingual":0}'),
('mail', 'smtp_port', '', '', 'text', 33, 1, 0, '{"wysiwyg":0,"code_editor":0,"show":"mail_function|smtp","multilingual":0}'),
('mail', 'smtp_secure', 'TLS', '\'TLS\',\'SSL\'', 'select', 36, 1, 0, '{"wysiwyg":0,"code_editor":0,"show":"mail_function|smtp","multilingual":0}'),
('mail', 'smtp_user', '', '', 'text', 39, 1, 0, '{"wysiwyg":0,"code_editor":0,"show":"mail_function|smtp","multilingual":0}'),
('mail', 'smtp_password', '', '', 'password', 42, 1, 0, '{"wysiwyg":0,"code_editor":0,"show":"mail_function|smtp","multilingual":0}'),
('mail', '', 'Sendmail Settings', '', 'divider', 45, 1, 0, '{"wysiwyg":0,"code_editor":0,"show":"mail_function|sendmail","multilingual":0}'),
('mail', 'sendmail_path', '/usr/sbin/sendmail', '', 'text', 48, 1, 0, '{"wysiwyg":0,"code_editor":0,"show":"mail_function|sendmail","multilingual":0}'),
('mail', 'mimetype', '1', '\'1\',\'0\'', 'radio', 51, 1, 0, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),

('system', '', 'Setup', '1', 'divider', 0, 1, 0,''),
('system', 'baseurl', '{install:base_url}', NULL, 'text', 0, 0, 0, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
('system', 'admin_page', 'panel', NULL, 'text', 0, 1, 0, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
('system', 'https', '0', '\'1\',\'0\'', 'radio', 1, 1, 1,'{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
('system', 'frontend', '1', '\'1\',\'0\'', 'radio', 2, 1, 1,'{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
('system', 'underconstruction', 'We are sorry. Our site is under construction.', '', 'textarea', 3, 1, 1, '{"wysiwyg":1,"code_editor":0,"show":"frontend|0","multilingual":0}'),
('system', '', 'Admin Panel settings', '1', 'divider', 10, 1, 0, ''),
('system', 'display_feedbacks', '1', '\'1\',\'0\'', 'radio', 11, 0, 0, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
('system', 'display_changelog', '1', '\'1\',\'0\'', 'radio', 12, 0, 0, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
('system', 'display_twitter', '1', '\'1\',\'0\'', 'hidden', 13, 0, 0, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
('system', 'check_for_updates', '1', '\'1\',\'0\'', 'radio', 14, 0, 0, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
('system', 'auto_apply_critical_upgrades', '0', '\'1\',\'0\'', 'radio', 15, 1, 0, '{"wysiwyg":0,"code_editor":0,"show":"check_for_updates|1","multilingual":0}'),
('system', 'allow_remote_templates', '1', '\'1\',\'0\'', 'radio', 16, 0, 0, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
('system', 'sap_style', 'default', 'calmy,darkness,default,gebeus-waterfall,radiant-orchid,roseus', 'select', 17, 0, 1,'{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
('system', '', 'System configuration', '1', 'divider', 20, 1, 0, ''),
('system', 'alias_urlencode', '0', '\'1\',\'0\'', 'radio', 21, 1, 0, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
('system', 'redirect_time', '4000', '', 'text', 22, 0, 0, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
('system', 'prevent_csrf', '1', '\'1\',\'0\'', 'radio', 23, 1, 0, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
('system', 'caching', '0', '\'1\',\'0\'', 'hidden', 24, 1, 0, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
('system', 'smarty_cache', '0', '\'1\',\'0\'', 'radio', 25, 0, 0, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
('system', 'compress_html', '0', '\'1\',\'0\'', 'radio', 26, 0, 0, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
('system', 'compress_js', '0', '\'1\',\'0\'', 'radio', 27, 0, 0, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),

('pictures', 'thumb_w', '150', '', 'hidden', 1, 1, 0, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
('pictures', 'thumb_h', '150', '', 'hidden', 2, 1, 0, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
('pictures', 'pictures_general', 'General', '', 'divider', 5, 1, 1,''),
('pictures', 'image_quality', '75', '', 'text', 6, 1, 0, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
('pictures', 'allow_animated_gifs', '1', '\'1\',\'0\'', 'radio', 7, 0, 0, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
('pictures', '', 'Watermark', '1', 'divider', 13, 1, 0, ''),
('pictures', 'watermark', '0', '\'1\',\'0\'', 'radio', 14, 1, 0, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
('pictures', 'watermark_position', 'bottom_right', '\'top_left\',\'top_center\',\'top_right\',\'middle_left\',\'middle_center\',\'middle_right\',\'bottom_left\',\'bottom_center\',\'bottom_right\'', 'select', 15, 1, 0, '{"wysiwyg":0,"code_editor":0,"show":"watermark|1","multilingual":0}'),
('pictures', 'watermark_opacity', '75', '', 'text', 19, 1, 0, '{"wysiwyg":0,"code_editor":0,"show":"watermark|1","multilingual":0}'),
('pictures', 'watermark_type', 'text', '\'text\',\'image\'', 'select', 16, 1, 0, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
('pictures', 'watermark_text', '@ Your Website', '', 'text', 17, 1, 0, '{"wysiwyg":0,"code_editor":0,"show":"watermark_type|text","multilingual":0}'),
('pictures', 'watermark_text_color', 'FFFFFF', '', 'text', 18, 1, 0, '{"wysiwyg":0,"code_editor":0,"show":"watermark_type|text","multilingual":0}'),
('pictures', 'watermark_text_size', '20', '', 'text', 19, 1, 0, '{"wysiwyg":0,"code_editor":0,"show":"watermark_type|text","multilingual":0}'),
('pictures', 'watermark_image', '', '', 'image', 20, 1, 0, '{"wysiwyg":0,"code_editor":0,"show":"watermark_type|image","multilingual":0}'),
('pictures', 'lightbox', 'Lightbox', '', 'divider', 23, 1, 1, ''),
('pictures', 'lightbox_name', 'fancybox', 'fancybox,fancybox', 'select', 24, 0, 0, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),

('miscellaneous', '', 'Frontend code integration', '', 'divider', 1, 1, 1, ''),
('miscellaneous', 'frontend_header_code', '', '', 'textarea', 2, 0, 1, '{"wysiwyg":0,"code_editor":0'),
('miscellaneous', 'frontend_footer_code', '', '', 'textarea', 3, 0, 1, '{"wysiwyg":0,"code_editor":0'),
('miscellaneous', '', 'Open Graph', '', 'divider', 4, 1, 1, ''),
('miscellaneous', 'opengraph_description', '{"en":""}', '', 'textarea', 5, 0, 1, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":1}'),
('miscellaneous', 'opengraph_image', '', '', 'image', 6, 0, 0, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
('miscellaneous', '', 'CKeditor', '', 'divider', 7, 1, 1, ''),
('miscellaneous', 'ckeditor_skin', 'moono-lisa', '\'moono-lisa\',\'moonocolor\'', 'select', 8, 0, 1,'{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
('miscellaneous', '', 'Captcha', '', 'divider', 9, 1, 1, ''),
('miscellaneous', 'captcha', '1', '\'1\',\'0\'', 'radio', 10, 0, 1,'{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
('miscellaneous', 'captcha_name', 'kcaptcha', 'kcaptcha,kcaptcha', 'select', 11, 0, 0, '{"wysiwyg":0,"code_editor":0,"show":"captcha|1","multilingual":0}'),
('miscellaneous', 'captcha_preview', '', '', 'text', 12, 0, 0, '{"wysiwyg":0,"code_editor":0,"show":"captcha|1","multilingual":0}'),
('miscellaneous', '', 'Search', '', 'divider', 13, 1, 1, ''),
('miscellaneous', 'search_instant', '0', '\'1\',\'0\'', 'radio', 14, 0, 1,'{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
('miscellaneous', '', 'Maps', '', 'divider', 15, 1, 1, ''),
('miscellaneous', 'maps_api_key', '', '', 'text', 16, 0, 0, '{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),

('financial', '', 'General', '1', 'divider', 1, 1, 0, ''),
('financial', 'currency_switch', '0', '\'1\',\'0\'', 'radio', 3, 0, 1,'{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
('financial', '', 'Internal Funds', '1', 'divider', 8, 1, 0, ''),
('financial', 'funds_min_deposit', '20', '', 'text', 9, 0, 1,'{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
('financial', 'funds_max_deposit', '300', '', 'text', 10, 0, 1,'{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
('financial', 'funds_max', '1000', '', 'text', 11, 0, 1,'{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),

('api', '', 'General', '1', 'divider', 1, 1, 0, ''),
('api', 'api_enabled', '0', '\'1\',\'0\'', 'radio', 1, 1, 1,'{"wysiwyg":0,"code_editor":0,"show":"","multilingual":0}'),
('api', 'api_push_access_key', '', '', 'text', 2, 1, 0, '{"wysiwyg":0,"code_editor":0,"show":"api_enabled|1","multilingual":0}'),
('api', 'api_token', '', '', 'password', 3, 1, 0, '{"wysiwyg":0,"code_editor":0,"show":"api_enabled|1","multilingual":0}');

INSERT INTO `{install:prefix}config_groups` (`name`,`order`) VALUES
('general',1),
('members',2),
('mail',3),
('system',4),
('pictures',5),
('miscellaneous',6),
('financial',7),
('api',8);

INSERT INTO `{install:prefix}cron` (`data`,`name`,`description`) VALUES
('1 1,12 * * * includes/cron/sitemap.php', 'Sitemap creation and update','Updates (or generates) the sitemap.xml file'),
('5 0 * * * includes/cron/cleanup.php','System cleanup','Cleans up temporary DB entries'),
('20 * * * * includes/cron/sponsored-expiration.php','Check for expiration of sponsored items','Marks expired sponsored items'),
('0 0 * * * includes/cron/featured-expiration.php','Check for expiration of featured items','Marks expired featured items');

INSERT INTO `{install:prefix}currencies` VALUES
('USD', 'active', 'US Dollar', 1, '$', 'pre', 1, 1, 2, '.', ','),
('EUR', 'inactive', 'Euro', 0.87, '€', 'post', 0, 2, 2, '.', ','),
('GBP', 'inactive', 'Pound Sterling', 0.78, '£', 'pre', 0, 3, 2, '.', ',');

INSERT INTO `{install:prefix}email_templates` (`order`,`divider`,`name`,`subject_en`,`variables`,`body_en`) VALUES
(10,1,'member_templates','','',''),
(20,0,'member_approved','Member was approved at {$siteName}','fullname|User','<p>Dear {$fullname},</p>\r\n<p>Your membership was approved in {$siteName}. Now you can log in.</p>'),
(30,0,'member_disapproved','Member was disapproved at {$siteName}','fullname|User','<p>Dear {$fullname},</p>\r\n<p>Your membership was disapproved in {$siteName}.</p>'),
(40,0,'member_registration','Thanks for registration at {$siteName}','fullname|User,email|Email,username|Username,password|Password,link|Confirmation link','<p>Dear {$fullname},</p> <p>Thanks for your registration at <a href=\"{$siteUrl}\" target=\"_blank\">{$siteUrl}</a>. Here is information you should use in order to login:</p> <p>Your username: {$username}<br /> Your password: {$password}</p> <p>To activate your account, please, <a href=\"{$link}\" target=\"_blank\">follow this link</a>. <br /> You may change your password later by editing your personal attributes in your member area.</p>'),
(50,0,'member_registration_social','Thanks for registration at {$siteName}','fullname|User,email|Email,username|Username,password|Password,link|Confirmation link,provider|Social provider used to register','<p>Dear {$fullname},</p> <p>Thanks for your registration at <a href=\"{$siteUrl}\" target=\"_blank\">{$siteUrl}</a> via {$provider}. Here is information you should use in order to login:</p> <p>Your email: {$email}</p> <p>You may change your password later by editing your personal attributes in your member area.</p>'),
(60,0,'member_registration_notification','Member has been created {$siteName}','fullname|User,email|Email,password|Password','<p>Greetings {$fullname},</p> <p>Administrator has just created an account for you at {$siteUrl}. Here is information you should use in order to login:</p> <p>Your email: <b>{$email}</b><br /> Your password: <b>{$password}</b></p>'),
(70,0,'member_registration_admin','New member registered at {$siteName}','id|ID,fullname|User,username|Username,email|User email','<p>Greetings,</p><p>New member registered at {$siteUrl}. Detailed information is below:</p> <p>ID: <b>{$id}</b><br>Name: <b>{$fullname}</b> ({$username})<br>Email: <b>{$email}</b></p>'),
(80,0,'member_removal','Member deleted at {$siteName}','fullname|User','<p>Dear {$fullname},</p>\r\n<p>Your membership was removed from {$siteUrl}.</p>'),
(90,0,'password_restoration','Password restoration request at {$siteName}','fullname|User,email|Email,code|Restoration code','<p>Dear {$fullname},</p>\r\n<p>Please follow this link if you wish to change the password at {$siteName}:<br />\r\n<a href="{$url}">{$url}</a>\r\n</p>\r\n<p>\r\nOr use confirmation code on page: <a href=\"{$siteUrl}forgot/?code\">{$siteUrl}forgot/?code</a><br />\r\nE-mail: {$email}<br />\r\nCode: {$code}\r\n</p>'),
(100,0,'password_changement','Password change request at {$siteName}','fullname|User,username|Username,password|New password','<p>Dear {$fullname},</p>\r\n\r\n<p>You requested a password change in {$siteName}. Now you should use the following credentials to log in as member:</p>\r\n\r\n<p>Username: {$username}<br />\r\nPassword: {$password}</p>'),
(110,1,'financial_templates','','',''),
(120,0,'plan_activated','Plan activated at {$siteName}','plan|Plan name,cost|Plan\'s cost,duration|Plan\'s duration,unit|Duration unit,fullname|User,currency|Currency code','<p>Dear {$fullname},</p>\r\n<p>Your listing has been activated.</p>\r\n\r\n<ul>\r\n	<li><b>Plan:</b> {$plan}</li>\r\n	<li><b>Cost:</b> {$currency} {$cost}</li>\r\n	<li><b>Duration:</b> {$duration} {$unit}(s)</li>\r\n</ul>'),
(130,0,'plan_expired','Plan expired at {$siteName}','plan|Plan name,cost|Plan\'s cost,duration|Plan\'s duration,unit|Duration unit,fullname|User,currency|Currency code','<p>Dear {$fullname},</p>\r\n<p>Your paid listing submission expired.</p>\r\n\r\n<ul>\r\n	<li><b>Plan:</b> {$plan}</li>\r\n	<li><b>Cost:</b> {$currency} {$cost}</li>\r\n	<li><b>Duration:</b> {$duration} {$unit}(s)</li>\r\n</ul>\r\n\r\n<p>It may always be renewed through the site.</p>'),
(140,0,'transaction_paid','Payment received at {$siteName}','email|Email,username|Username,fullname|Fullname,operation|Operation name,amount|Amount,reference_id|Reference ID,currency|Currency,item|Item,item_id|Item ID,date_created|Creation Date,date_paid|Payment Date','<p>Dear {$fullname},</p>\r\n<p>Your payment has been successfully received.</p>\r\n\r\n<p>Order Number: <strong>{$reference_id}</strong></p>\r\n\r\n<p>Payment details are below:</p>\r\n\r\n<ul>\r\n	<li><b>Operation:</b> {$operation}</li>\r\n	<li><b>Amount:</b> {$currency} {$amount}</li>\r\n	<li><b>Item:</b> {$item} #{$item_id}</li>\r\n	<li><b>Date:</b> {$date_paid}</li>\r\n</ul>\r\n\r\n<p>All your transactions could always be seen on the <a href=\"{$siteUrl}profile/funds/\" target=\"_blank\">Funds</a> page.</p>'),
(150,0,'transaction_paid_admin','Payment completed at {$siteName}','username|User,amount|Amount of transaction,operation|Operation name,currency|Currency','<p>Dear Administrator,</p>\r\n<p>A payment has been completed on your site. Here is the information on the payment:</p><ul><li><b>Username:</b> {$username}</li><li><b>Amount:</b>{$currency} {$amount}</li><li><b>Operation:</b> {$operation}</li></ul>'),
(160,0,'invoice_created','Customer Invoice','invoice|Invoice ID,gateway|Gateway,date|Invoice creation date,fullname|User,amount|Amount,currency|Currency','<p>Dear {$fullname},</p>\r\n<p>This is a notice that an invoice has been generated on {$date}</p>\r\n\r\n<p>Your payment method is: {$gateway}</p>\r\n\r\n<p>Invoice #{$invoice},<br>\r\nAmount Due: {$currency} {$amount}\r\n</p>\r\n\r\n<p>All your invoices could always be seen on the <a href=\"{$siteUrl}profile/funds/\" target=\"_blank\">Funds</a> page.</p>');

INSERT INTO `{install:prefix}fields` (`name`,`item`,`fieldgroup_id`,`type`,`length`,`order`,`editable`,`required`,`extra_actions`,`searchable`) VALUES
('username','member',1,'text',50,0,0,1,'if ($value && !iaValidate::isUsername($value))\r\n{\r\n	$errors[$fieldName] = iaLanguage::get(\'username_incorrect\');\r\n}',1),
('fullname','member',1,'text',50,5,0,1,'',1),
('email','member',1,'text',250,10,0,1,'if ($value)\r\n{\r\n	if (iaValidate::isEmail($value))\r\n	{\r\n		$value = strtolower($value);\r\n	}\r\n	else\r\n	{\r\n		$errors[$fieldName] = iaLanguage::get(\'error_email_incorrect\');\r\n	}\r\n}',0),
('avatar','member',1,'image',1,15,1,0,'',1),
('website','member',1,'text',255,20,1,0,'',0),
('phone','member',1,'text',100,25,1,0,'',0),
('biography','member',1,'textarea',500,30,1,0,'',0),
('facebook','member',2,'text',150,35,1,0,'',0),
('twitter','member',2,'text',150,40,1,0,'',0),
('gplus','member',2,'text',150,45,1,0,'',0),
('linkedin','member',2,'text',150,50,1,0,'',0),
('api_push_token','member',3,'textarea',255,55,1,0,'',0),
('api_push_receive','member',3,'radio',0,60,1,0,'',0),
('email_language','member',0,'text',2,65,0,1,'',0),
('member_id','transaction',0,'text',100,0,1,0,'',0),
('reference_id','transaction',0,'text',100,5,1,0,'',0),
('date_created','transaction',0,'date',0,10,1,0,'',0),
('date_paid','transaction',0,'date',0,15,8,0,'',0),
('amount','transaction',0,'number',8,20,1,0,'',0),
('operation','transaction',0,'text',100,25,1,0,'',0),
('gateway','transaction',0,'text',100,30,1,0,'',0),
('currency','transaction',0,'text',10,35,1,0,'',0),
('sec_key','transaction',0,'text',250,40,1,0,'',0);
UPDATE `{install:prefix}fields` SET `relation`='regular';
UPDATE `{install:prefix}fields` SET `use_editor`=1,`thumb_height`=200,`file_prefix`='avat_',`image_width`=300,`image_height`=300,`thumb_width`=200,`imagetype_primary`='large',`imagetype_thumbnail`='thumbnail' WHERE `name`='avatar';
UPDATE `{install:prefix}fields` SET `adminonly`=1 WHERE `name`='api_push_token';
UPDATE `{install:prefix}fields` SET `adminonly`=1,`values`='yes,no',`default`='yes' WHERE `name`='api_push_receive';
UPDATE `{install:prefix}fields` SET `timepicker`=1 WHERE `name`IN('date_created','date_paid') AND `item`='transaction';

INSERT INTO `{install:prefix}fields_groups` (`name`,`item`,`order`,`module`,`collapsed`,`tabview`) VALUES
('general','member',1,'core',0,0),
('social','member',2,'core',0,0),
('api','member',3,'core',0,0);

INSERT INTO `{install:prefix}fields_pages` (`page_name`,`field_id`) VALUES
('members',1),
('members',2),
('members',4),
('members',5),
('members',6),
('members',8),
('members',9),
('members',10),
('members',11),
('profile',2),
('profile',3),
('profile',4),
('profile',5),
('profile',6),
('profile',7),
('profile',8),
('profile',9),
('profile',10),
('profile',11),
('profile',14),
('favorites',1),
('favorites',2),
('favorites',4),
('favorites',5),
('favorites',6),
('favorites',8),
('favorites',9),
('favorites',10),
('favorites',11),
('registration',1),
('registration',2),
('registration',3),
('view_member',2),
('view_member',4),
('view_member',5),
('view_member',6),
('view_member',7),
('view_member',8),
('view_member',9),
('view_member',10),
('view_member',11);

INSERT INTO `{install:prefix}file_types` (`id`, `extension`, `maxsize`, `image`) VALUES
(1, 'swf', 0, 0),
(2, 'wav', 0, 0),
(3, 'mov', 0, 0),
(5, 'mpeg', 0, 0),
(6, 'mpg', 0, 0),
(7, 'mp3', 0, 0),
(8, 'png', 0, 1),
(9, 'jpg', 0, 1),
(10, 'gif', 0, 1),
(11, 'jpeg', 0, 1),
(12, 'ico', 0, 0),
(13, 'htm', 0, 0),
(14, 'html', 0, 0),
(15, 'txt', 0, 0),
(16, 'pdf', 0, 0),
(17, 'rtf', 0, 0),
(18, 'zip', 0, 0),
(19, 'gz', 0, 0),
(20, 'tar', 0, 0),
(21, 'rar', 0, 0),
(22, 'bz', 0, 0),
(23, 'bz2', 0, 0),
(24, 'doc', 0, 0),
(25, 'docx', 0, 0),
(26, 'xls', 0, 0),
(27, 'xlsx', 0, 0),
(28, 'ppt', 0, 0),
(29, 'pptx', 0, 0);

INSERT INTO `{install:prefix}hooks` (`name`,`code`,`status`,`order`,`type`,`page_type`,`filename`, `module`) VALUES
('smartyFrontAfterHeadSection','','active',1,'smarty','front','templates/_common/hook.header-code.tpl',''),
('smartyFrontFinalize','{$core.config.frontend_footer_code}','active',2,'smarty','front','',''),
('editItemSetSystemDefaults','if (isset($item[''featured'']) && $item[''featured''])\r\n{\r\n	$item[''featured_end''] = date(iaDb::DATETIME_SHORT_FORMAT, strtotime($item[''featured_end'']));\r\n}\r\nelse\r\n{\r\n	$date = getdate();\r\n	$date = mktime($date[''hours''], $date[''minutes''] + 1,0,$date[''mon''] + 1,$date[''mday''], $date[''year'']);\r\n	$item[''featured_end''] = date(iaDb::DATETIME_SHORT_FORMAT, $date);\r\n}\r\n\r\nif (isset($item[''sponsored'']) && $item[''sponsored''])\r\n{\r\n	$item[''sponsored_end''] = date(iaDb::DATETIME_SHORT_FORMAT, strtotime($item[''sponsored_end'']));\r\n}\r\n\r\nif (isset($item[''member_id'']))\r\n{\r\n	$item[''owner''] = '''';\r\n	if ($item[''member_id''] > 0)\r\n	{\r\n		$iaUsers = $iaCore->factory(''users'');\r\n		if ($ownerInfo = $iaUsers->getInfo((int)$item[''member_id'']))\r\n		{\r\n			$item[''owner''] = $ownerInfo[''fullname''] . '' ('' . $ownerInfo[''email''] . '')'';\r\n		}\r\n	}\r\n}','active',1,'php','admin','',''),
('smartyFrontSearchSortingMembers','','active',1,'smarty','front','search.members.sorting-header.tpl','');

INSERT INTO `{install:prefix}items` (`item`,`module`,`payable`,`searchable`,`pages`, `table_name`) VALUES
('member','core',1,1,'profile,view_member',''),
('transaction','core',0,0,'','payment_transactions');

INSERT INTO `{install:prefix}items_pages` (`page_name`,`item`) VALUES
('profile','member'),
('view_member','member'),
('favorites','member'),
('registration','member');

INSERT INTO `{install:prefix}members` (`usergroup_id`,`username`,`email`,`date_reg`,`date_update`,`fullname`,`email_language`) VALUES
(1,'{install:admin_username}','{install:email}',NOW(),NOW(),'Administrator','en');

INSERT INTO `{install:prefix}menus` (`parent_id`,`menu_id`,`el_id`,`page_name`) VALUES
('0',2,'1_001','index'),
('0',3,'1_002','index'),
('0',3,'9_003','members'),
('0',4,'13_004','profile'),
('0',4,'8_005','favorites'),
('0',4,'14_006','member_funds'),
('0',5,'19_007','about'),
('0',5,'20_008','policy'),
('0',5,'21_009','terms'),
('0',5,'22_011','help');

INSERT INTO `{install:prefix}objects_pages` (`object_type`,`page_name`,`object`,`access`) VALUES
('blocks','',6,0),
('blocks','index',6,1);

INSERT INTO `{install:prefix}pages` (`group`,`name`,`service`,`readonly`,`alias`,`nofollow`,`filename`,`menus`,`parent`,`suburl`) VALUES
(2,'index',0,0,'',0,'page','main,inventory','',''),
(1,'api',1,1,'api/',1,'api','','',''),
(1,'redirect',1,1,'',0,'','','',''),
(1,'search',0,1,'search/',1,'','main','',''),
(1,'captcha',1,1,'captcha',1,'','','',''),
(1,'cron',1,1,'',0,'','','',''),
(1,'actions',1,1,'',0,'','','',''),
(1,'pay',1,1,'pay/',0,'','','',''),
(3,'favorites',0,1,'favorites/',1,'','account','',''),
(3,'members',0,1,'members/',0,'','main','','members'),
(3,'login',0,1,'login/',1,'','','',''),
(3,'hybrid',1,1,'hybrid/',1,'login','','',''),
(3,'view_member',0,1,'member/',1,'','','members','members'),
(3,'profile',0,1,'profile/',1,'','account','',''),
(3,'member_funds',0,1,'profile/funds/',1,'transactions','account','profile',''),
(3,'registration',0,1,'registration/',1,'registration','','',''),
(3,'register_confirm',1,1,'confirm/',1,'registration','','',''),
(3,'member_password_forgot',1,1,'forgot/',1,'registration','','',''),
(2,'page',1,1,'',0,'page','','',''),
(2,'about',0,0,'about/',0,'page','','',''),
(2,'policy',0,0,'policy/',0,'page','','',''),
(2,'terms',0,0,'terms/',0,'page','','',''),
(2,'help',0,0,'help/',0,'page','','','');
UPDATE `{install:prefix}pages` SET `status`='active',`last_updated`=NOW();

INSERT INTO `{install:prefix}usergroups` (`id`,`name`,`system`,`visible`, `order`) VALUES
(1,'administrators',1, 0, 1),
(2,'moderators',1, 0, 2),
(4,'guests',1, 0, 3),
(8,'registered',1, 1, 4);

INSERT INTO `{install:prefix}languages` VALUES
(null,'en','English','en_US','%e %B, %Y', '%H:%M', 'Intelliants LLC','ltr',1,1,1,'active','us.gif');

INSERT INTO `{install:prefix}language` (`key`,`value`,`category`) VALUES
('_action_','- Action -','admin'),
('_do_not_change_','&lt;Do not change&gt;','admin'),
('_no_parent_page_','- no parent page -','admin'),
('_page_removed_','-page removed-','admin'),

('access_denied','Access denied','admin'),
('actions','Actions','admin'),
('action-add','Add action on ":page"','admin'),
('action-config','Configuration on ":page"','admin'),
('action-delete','Delete action on ":page"','admin'),
('action-edit','Edit action on ":page"','admin'),
('action-read','Allow to view ":page"','admin'),
('action_not_allowed_since_you_only_admin','This action is not allowed since currently you are the only active administrator.','admin'),
('activate','Activate','admin'),
('add_another_one','Add another one','admin'),
('add_block','Add Block','admin'),
('add_currency','Add Currency','admin'),
('add_drop_table','Add DROP TABLE','admin'),
('add_field','Add Field','admin'),
('add_fieldgroup','Add Field Group','admin'),
('add_image_type','Add Image Type','admin'),
('add_invoice','Add Invoice','admin'),
('add_item_value','Add Item Value','admin'),
('add_line','Add line','admin'),
('add_member','Add Member','admin'),
('add_menu','Add Menu','admin'),
('add_new_phrase','Add New Phrase','admin'),
('add_new_transaction','Do you want to add another transaction?','admin'),
('add_one_more_phrase','Do you want to add one more phrase?','admin'),
('add_page','Add Page','admin'),
('add_phrase','Add Phrase','admin'),
('add_plan','Add Plan','admin'),
('add_transaction','Add Transaction','admin'),
('add_usergroup','Add Usergroup','admin'),
('add_quick_link','Add quick link','admin'),
('added_date_is_incorrect','Added date is incorrect.','admin'),
('admin_check_new_password','Please check your email for a confirmation link.','admin'),
('admin_access--read','Allow Access to Admin Panel','admin'),
('admin_pages','Admin Panel Pages','admin'),
('admin_page-adminer--read','Allow to access Adminer script','admin'),
('admin_page-blocks--edit','Allow to edit blocks','admin'),
('admin_page-blocks--html','Allow to create HTML blocks','admin'),
('admin_page-blocks--order','Allow to change blocks order','admin'),
('admin_page-blocks--php','Allow to create PHP blocks','admin'),
('admin_page-blocks--plain','Allow to create plain text blocks','admin'),
('admin_page-blocks--smarty','Allow to create Smarty blocks','admin'),
('admin_page-blocks--visual','Allow to use Visual Mode','admin'),
('admin_page-configuration--edit','Allow to modify configuration','admin'),
('admin_page-configuration--read','Allow access to Configuration page','admin'),
('admin_page-database--consistency','Allow access to Consistency page','admin'),
('admin_page-database--export','Allow to export SQL dump','admin'),
('admin_page-database--import','Allow to import dumps','admin'),
('admin_page-database--reset','Allow to reset site data','admin'),
('admin_page-database--sql','Allow to run SQL queries','admin'),
('admin_page-fields--members','Allow to manage member fields','admin'),
('admin_page-hooks--read','Allow to view hooks list','admin'),
('admin_page-hooks--edit','Allow to edit a hook','admin'),
('admin_page-hooks--delete','Allow to delete a hook','admin'),
('admin_page-index--cache','Allow to drop script\'s cache files','admin'),
('admin_page-index--debugmode','Allow to debugmode information','admin'),
('admin_page-index--phpinfo','Allow to view phpinfo() information','admin'),
('admin_page-index--sitemap','Allow to rebuild sitemap.xml file','admin'),
('admin_page-members--read','Allow to view members list','admin'),
('admin_page-members--add','Allow to add new members','admin'),
('admin_page-members--edit','Allow to edit existing members','admin'),
('admin_page-members--password','Allow to change member password','admin'),
('admin_page-members--usergroup','Allow to change member usergroup','admin'),
('admin_page-menus--add','Allow to add new menus','admin'),
('admin_page-menus--edit','Allow to edit existing menus','admin'),
('admin_page-packages--activate','Allow to activate package','admin'),
('admin_page-packages--install','Allow to install package','admin'),
('admin_page-packages--set_default','Allow to set/reset default package','admin'),
('admin_page-packages--uninstall','Allow to uninstall package','admin'),
('admin_page-packages--upgrade','Allow to upgrade package','admin'),
('admin_page-pages--add','Allow to add new page','admin'),
('admin_page-pages--delete','Allow to delete a page','admin'),
('admin_page-pages--edit','Allow to modify a page','admin'),
('admin_page-pages--home','Allow to change the Home page','admin'),
('admin_page-pages--read','Allow to view pages list','admin'),
('admin_page-permissions--read','Allow to view member/usergroup permissions','admin'),
('admin_page-permissions--edit','Allow to manage permissions','admin'),
('admin_page-plans--add','Allow to add new plan','admin'),
('admin_page-plans--delete','Allow to delete a plan','admin'),
('admin_page-plans--edit','Allow to modify a plan','admin'),
('admin_page-plans--read','Allow to view plans list','admin'),
('admin_page-plugins--install','Allow to install plugin','admin'),
('admin_page-plugins--reinstall','Allow to reinstall plugin','admin'),
('admin_page-plugins--uninstall','Allow to uninstall plugin','admin'),
('admin_page-plugins--update','Allow to update plugin','admin'),
('administrator_added','New administrator member created.','admin'),
('add_plugin','Add plugin','admin'),
('all_members','All Members','admin'),
('allowed','Allowed','admin'),
('allowed_file_types','Allowed file types','admin'),
('already_home_page','This page has been set as your homepage. You may not turn it off.','admin'),
('and_then','And then','admin'),
('are_you_sure_install_module','Are you sure you wish to install this module?','admin'),
('are_you_sure_install_template','Are you sure you wish to install this template? Current template data will be lost. Block changes will be reset.','admin'),
('are_you_sure_reinstall_module','Are you sure you wish to reinstall this module? All data will be lost. You need to start from the scratch.','admin'),
('are_you_sure_resend_registration_email','This will permanently reset the current password of this member. Are you sure you want to re-send registration email?','admin'),
('are_you_sure_to_delete_currency','Are you sure to delete this currency?','admin'),
('are_you_sure_to_delete_field','Are you sure to delete current field? All added information for this field will be lost.','admin'),
('are_you_sure_to_delete_fieldgroup','Are you sure to delete selected fields group?','admin'),
('are_you_sure_to_delete_selected_items','Are you sure you want to delete selected items?','admin'),
('are_you_sure_to_delete_selected_language','Are you sure you want to delete selected language? Note: All phrases will be permanently lost!','admin'),
('are_you_sure_to_delete_selected_members','Are you sure you want to delete selected members?','admin'),
('are_you_sure_to_delete_selected_menus','Are you sure you want to delete selected menus?','admin'),
('are_you_sure_to_delete_selected_pages','Are you sure you want to delete selected pages?','admin'),
('are_you_sure_to_delete_selected_phrases','Are you sure you want to delete selected phrases?','admin'),
('are_you_sure_to_delete_this_block','Are you sure you want to delete this block?','admin'),
('are_you_sure_to_delete_this_item','Are you sure you want to delete this item?','admin'),
('are_you_sure_to_delete_this_member','Are you sure you want to delete this member?','admin'),
('are_you_sure_to_delete_this_menu','Are you sure you want to delete this menu?','admin'),
('are_you_sure_to_delete_this_page','Are you sure you want to delete this page?','admin'),
('are_you_sure_to_delete_this_plan','Are you sure you want to delete this plan?','admin'),
('are_you_sure_to_delete_this_transaction','Are you sure you want to delete this transaction?','admin'),
('are_you_sure_to_delete_this_usergroup','Are you sure you want to delete this usergroup? All the users of this usergroup will be assigned to the Registered usergroup.','admin'),
('are_you_sure_to_delete_transactions','Are you sure you want to delete transactions?','admin'),
('are_you_sure_to_uninstall_selected_plugin','Are you sure you wish to uninstall this plugin? Please take a note that all plugin data will be lost. This action cannot be reverted.','admin'),
('are_you_sure_to_uninstall_selected_package','Are you sure you wish to uninstall this package? Please take a note that all package data will be lost. This action cannot be reverted.','admin'),
('ascii_required','Only alphanumeric characters are allowed','admin'),
('assignable','Assignable','admin'),
('at_least_one_item_should_be_checked','At least one item should be selected.','admin'),
('available_dump_files','Available Dump Files','admin'),
('available_patterns','Available patterns','admin'),
('available_plugins','Available Plugins','admin'),

('back_to_homepage','Back to homepage','admin'),
('bad_iso_code','Bad country-ISO code.','admin'),
('banned','Banned','admin'),
('body','Body','admin'),
('body_incorrect','Message body or subject is empty.','admin'),
('block_contents','Contents','admin'),
('block_created','Block created.','admin'),
('block_type_tip_html','HTML type is used for formatted HTML display. You can use WYSIWYG editor for your block content. This block can be also used for JavaScript code, but you <span style=\"color: red;\">need to paste it in SOURCE mode</span>','admin'),
('block_type_tip_php','PHP is used to have php code in your block content.','admin'),
('block_type_tip_plain','Plain type is used when you wish to display simple information. It will be displayed as is with escaping HTML tags.','admin'),
('block_type_tip_smarty','Smarty type block is used for smarty code. You can get more information about Smarty template engine here: <a target=\"_blank\" href=\"http://www.smarty.net\">http://www.smarty.net</a>','admin'),
('block_visible_everywhere','Visible everywhere','admin'),
('block_visibility_exceptions_visible','Choose where block will be explicitly <b>visible</b>','admin'),
('block_visibility_exceptions_hidden','Choose where block will be explicitly <b>hidden</b>','admin'),
('blocks','Blocks','admin'),
('bug_report','Bug Report','admin'),
('buy','Buy','admin'),
('buy_before_install','You need to purchase this plugin in order to install it.','admin'),

('cache_dropped','Cache has been dropped.','admin'),
('cant_open_incorrect_format','Could not open file with SQL instructions: :filename. Only .sql files are allowed.','admin'),
('cant_open_sql','Could not open file with SQL instructions: :filename','admin'),
('cant_write_sql','Could not write to file :filename.','admin'),
('calendar_dow','S,M,T,W,T,F,S','admin'),
('calendar_ml','January,February,March,April,May,June,July,August,September,October,November,December','admin'),
('calendar_ms','Jan,Feb,Mar,Apr,May,Jun,Jul,Aug,Sep,Oct,Nov,Dec','admin'),
('change_status_to','On expiration change status to','admin'),
('change_usergroup_to','Change usergroup to ... after plan change','admin'),
('changelog','Changelog','admin'),
('changelog_added','New Features','admin'),
('changelog_bugfixes','Bugfixes','admin'),
('changelog_modified','Improvements','admin'),
('changelog_other','Other Changes','admin'),
('chars_left','characters left','admin'),
('checkboxes','Checkboxes','admin'),
('consistency','Consistency','admin'),
('choose_import_file','Please choose a file to be imported.','admin'),
('choose_item','Choose item','admin'),
('clear','Clear','admin'),
('clear_confirm','Are you sure you want to clear your form?','admin'),
('clear_default','Clear default value','admin'),
('clear_reset','Are you sure you wish to clear all your data? Note this operation is irreversible and all your items data will be lost.','admin'),
('closing_window_with_unsaved_changes','You are closing a window that has unsaved changes. Would you like to save your changes?','admin'),
('collapsible','Collapsible','admin'),
('config_debug_pass', 'Debug password', 'admin'),
('config_tmpl', 'Frontend theme', 'admin'),
('config_backup', 'Directory for database backups', 'admin'),
('config_cron', 'Cron', 'admin'),
('config_admin_tmpl', 'Admin Panel theme', 'admin'),
('config_default_package', 'Default package', 'admin'),
('config_tmpl_rollback_data', 'Previous template restoration data', 'admin'),
('config_tmpl_layout_data', 'Template layout information', 'admin'),
('config_site', 'Site title', 'admin'),
('config_bc_home', 'Breadcrumb first element', 'admin'),
('config_suffix', 'Suffix for page titles', 'admin'),
('config_site_logo', 'Website logo', 'admin'),
('config_site_favicon', 'Website favicon', 'admin'),
('config_lang', 'Default language', 'admin'),
('config_language_switch', 'Language switching', 'admin'),
('config_timezone', 'Default timezone', 'admin'),
('config_members_enabled', 'Members functionality', 'admin'),
('config_members_autoapproval', 'Members auto-approval', 'admin'),
('config_members_per_page', 'Members per page', 'admin'),
('config_hybrid_enabled', 'Enable HybridAuth', 'admin'),
('config_hybrid_debug_mode', 'Debug mode', 'admin'),
('config_gravatar_enabled', 'Enable Gravatars', 'admin'),
('config_gravatar_size', 'Size', 'admin'),
('config_gravatar_type', 'Image type', 'admin'),
('config_gravatar_rating', 'Rating', 'admin'),
('config_gravatar_default_image', 'Default image', 'admin'),
('config_site_email', 'Default site email', 'admin'),
('config_bcc_email', 'BCC auto emails to', 'admin'),
('config_site_from_name', 'Default mail name', 'admin'),
('config_default_email_signature', 'Default mail signature', 'admin'),
('config_mail_function', 'Mail method', 'admin'),
('config_mail_test', 'Send test email', 'admin'),
('config_smtp_debug', 'SMTP Debug', 'admin'),
('config_smtp_debug_output', 'SMTP Debug Output', 'admin'),
('config_smtp_auth', 'SMTP Authentication', 'admin'),
('config_smtp_server', 'SMTP Server', 'admin'),
('config_smtp_port', 'SMTP Port', 'admin'),
('config_smtp_secure', 'SMTP Secure', 'admin'),
('config_smtp_user', 'SMTP Server Username', 'admin'),
('config_smtp_password', 'SMTP Server Password', 'admin'),
('config_sendmail_path', 'Path to sendmail ', 'admin'),
('config_mimetype', 'Send HTML mime-type emails instead of plain text', 'admin'),
('config_baseurl', 'Site URL', 'admin'),
('config_admin_page', 'Admin Dashboard URL', 'admin'),
('config_https', 'HTTPS', 'admin'),
('config_frontend', 'Display frontend', 'admin'),
('config_underconstruction', 'Under construction message', 'admin'),
('config_display_feedbacks', 'Feedbacks panel display', 'admin'),
('config_display_changelog', 'Changelog panel display', 'admin'),
('config_display_twitter', 'Twitter in Dashboard', 'admin'),
('config_check_for_updates', 'Check for updates', 'admin'),
('config_auto_apply_critical_upgrades', 'Automatically apply critical upgrades', 'admin'),
('config_allow_remote_templates', 'Allow remote templates', 'admin'),
('config_sap_style', 'Default colors scheme', 'admin'),
('config_alias_urlencode', 'Encode non-Latin symbols in URL', 'admin'),
('config_redirect_time', 'Redirect time (ms)', 'admin'),
('config_prevent_csrf', 'Prevent CSRF attack', 'admin'),
('config_caching', 'Caching', 'admin'),
('config_smarty_cache', 'Smarty force compile', 'admin'),
('config_compress_html', 'Compress HTML', 'admin'),
('config_compress_js', 'Compress Javascript', 'admin'),
('config_thumb_w', 'Thumbnails default width', 'admin'),
('config_thumb_h', 'Thumbnails default height', 'admin'),
('config_watermark', 'Enable', 'admin'),
('config_watermark_position', 'Position', 'admin'),
('config_watermark_opacity', 'Opacity', 'admin'),
('config_watermark_type', 'Type', 'admin'),
('config_watermark_text', 'Text', 'admin'),
('config_watermark_text_color', 'Text RGB color', 'admin'),
('config_watermark_text_size', 'Text size', 'admin'),
('config_watermark_image', 'Image', 'admin'),
('config_pictures_general', 'General','admin'),
('config_image_quality', 'Image quality (%)','admin'),
('config_allow_animated_gifs', 'Allow animated GIF images','admin'),
('config_lightbox', 'Lightbox', 'admin'),
('config_lightbox_name', 'Lightbox name', 'admin'),
('config_', 'Frontend code integration', 'admin'),
('config_frontend_header_code', 'Code before closing HEAD tag', 'admin'),
('config_frontend_footer_code', 'Code before closing BODY tag', 'admin'),
('config_opengraph_description', 'OG default description', 'admin'),
('config_opengraph_image', 'OG default image', 'admin'),
('config_ckeditor_skin', 'Skin', 'admin'),
('config_captcha', 'Captcha', 'admin'),
('config_captcha_name', 'Captcha name', 'admin'),
('config_captcha_preview', 'Captcha preview', 'admin'),
('config_search_instant', 'Instant search', 'admin'),
('config_maps_api_key', 'Maps API key', 'admin'),
('config_currency_switch', 'Currency switching', 'admin'),
('config_funds_min_deposit', 'Minimum deposit', 'admin'),
('config_funds_max_deposit', 'Maximum deposit', 'admin'),
('config_funds_max', 'Maximum balance', 'admin'),
('config_api_enabled', 'API enabled', 'admin'),
('config_api_push_access_key', 'GCM access key', 'admin'),
('config_api_token', 'Permanent API token', 'admin'),
('config_empty_password','-empty password-','admin'),
('config_empty_value','-empty value-','admin'),
('config_groups','Configuration Groups','admin'),
('config_group_api','API','admin'),
('config_group_financial','Financial','admin'),
('config_group_general','General','admin'),
('config_group_mail','Mail','admin'),
('config_group_members','Members','admin'),
('config_group_miscellaneous','Miscellaneous','admin'),
('config_group_pictures','Pictures','admin'),
('config_group_system','System','admin'),
('config_set_custom','Set custom value','admin'),
('config_set_default','Set default value','admin'),
('configuration','Configuration','admin'),
('contents','Contents','admin'),
('compare','Compare','admin'),
('compatibility','Min core','admin'),
('complete_inserts','Complete Inserts','admin'),
('copy_master_language_to','Copy master language [<b>:lang</b>] to ','admin'),
('copy_language','Copy Language','admin'),
('copy_privileges_from','Copy Privileges From','admin'),
('core','Core','admin'),
('core_and_db_versions_mismatch','DB and core files versions mismatch.','admin'),
('cost','Cost','admin'),
('created','Created.','admin'),
('created_date','Created date','admin'),
('crop','Crop','admin'),
('crop_tip','The mod will attempt to fit the image inside the &quot;frame&quot; created by the width and height arguments.','admin'),
('css_class_name','CSS class name','admin'),
('csv_format','CSV format','admin'),
('currency_symbol','Currency symbol','admin'),
('currency_symbol_position_after','after the price','admin'),
('currency_symbol_position_before','before the price','admin'),
('current_home_page','Current homepage','admin'),
('custom','Custom','admin'),
('custom_configuration_title',':settings configuration for :type ":title"','admin'),
('custom_modification','Custom Modification','admin'),
('custom_template','Use custom tpl','admin'),
('custom_template_filename','Template filename','admin'),
('custom_perm','Custom Permissions','admin'),
('custom_url','Custom URL','admin'),
('customize','Customize','admin'),
('customization_mode_alert','You are in customization mode. Do not forget to save your changes.','admin'),
('cycles','cycles','admin'),

('dashboard','Dashboard','admin'),
('date_added','Date Added','admin'),
('date_created','Date Created','admin'),
('date_due','Date Due','admin'),
('date_modified','Date Modified','admin'),
('day','day','admin'),
('days','days','admin'),
('days_ago',':days days ago','admin'),
('deactivate','Deactivate','admin'),
('deactivated','Deactivated','admin'),
('debug_mode','Debug Mode','admin'),
('debug_mode_activated','Debug mode activated for you.','admin'),
('decimal_point','Decimal point','admin'),
('default_language','Default Language','admin'),
('digits_only','digits only (1-255), default is 255','admin'),
('directory_not_writable','Directory ":directory" is not writable. You could not save to server.','admin'),
('display','Display','admin'),
('do','Do','admin'),
('documentation','Documentation','admin'),
('documentation_not_available','Data for this module is not available.','admin'),
('drag_to_reorder','Drag to re-order','admin'),
('dropdown','Dropdown','admin'),
('duration','Duration','admin'),

('editable','Editable','admin'),
('edit_block','Edit Block','admin'),
('edit_currency','Edit Currency ":currency"','admin'),
('edit_field','Edit Field ":field"','admin'),
('edit_fieldgroup','Edit Field Group','admin'),
('edit_image_type','Edit Image Type','admin'),
('edit_invoice','Edit Invoice','admin'),
('edit_language','Edit Language','admin'),
('edit_member','Edit Member','admin'),
('edit_menu','Edit Menu','admin'),
('edit_page','Edit Page','admin'),
('edit_page_title','Edit page title','admin'),
('edit_plan','Edit Plan','admin'),
('edit_phrase','Edit Phrase','admin'),
('edit_phrases','edit phrases','admin'),
('email_template_member_templates', 'Member templates', 'admin'),
('email_template_member_approved', 'Member approval', 'admin'),
('email_template_member_disapproved', 'Member cancellation', 'admin'),
('email_template_member_registration', 'Member registration', 'admin'),
('email_template_member_registration_social', 'Member registration via social login', 'admin'),
('email_template_member_registration_notification', 'Member created by admin', 'admin'),
('email_template_member_registration_admin', 'Administrator\'s notification on member registration', 'admin'),
('email_template_member_removal', 'Member removal', 'admin'),
('email_template_password_restoration', 'Member password restoration', 'admin'),
('email_template_password_changement', 'Member password change', 'admin'),
('email_template_financial_templates', 'Financial templates', 'admin'),
('email_template_plan_activated', 'Item paid and activated', 'admin'),
('email_template_plan_expired', 'Paid item expired', 'admin'),
('email_template_transaction_paid', 'Transaction passed', 'admin'),
('email_template_transaction_paid_admin', 'Administrator\'s notification on payment completion', 'admin'),
('email_template_invoice_created', 'Invoice created', 'admin'),
('email_templates','Email Templates','admin'),
('email_templates_tags','Email Template Tags','admin'),
('email_templates_tags_info','You can use these tags in your email templates. They will be changed to real information while sending email templates.','admin'),
('empty','-empty-','admin'),
('empty_field','Empty field text','admin'),
('enable_no_follow','Enable No-Follow','admin'),
('enable_template_sending','Enable sending','admin'),
('enter_external_url','Enter External URL','admin'),
('error_block_name','Please input correct block name. It should be alpha numeric.','admin'),
('error_block_name_duplicate','Please change block name. There is a block with the same name in the database.','admin'),
('error_compare_same_languages','No way to compare same languages.','admin'),
('error_contents','Content field is empty.','admin'),
('error_fieldgroup_duplicate','Please change name. There is a field group with the same name for the same item.','admin'),
('error_filename','Filename field is empty.','admin'),
('error_incorrect_dimensions','Set correct image dimensions.','admin'),
('error_incorrect_format_from_subrion','The module files are in the incorrect format. Please contact the Subrion team.','admin'),
('error_file_type','You need to set allowed file extensions.','admin'),
('error_incorrect_response_from_subrion','No response from subrion.org website. Please try again later or contact the Subrion team.','admin'),
('error_install_plugin','There is a problem while installing :plugin plugin. Please contact support team.','admin'),
('error_lang_contents','Content is empty for ":lang" language. Please input correct content.','admin'),
('error_lang_description','Description is empty for ":lang" language. Please input correct description.','admin'),
('error_lang_title','Title is empty for ":lang" language. Please input correct title.','admin'),
('error_plan_not_exists','Plan does not exist.','admin'),
('error_plan_duration','Please set correct duration for this plan.','admin'),
('error_usergroup_incorrect','Name is incorrect. Please input correct name for the usergroup.','admin'),
('error_usergroup_exists','This group already exists. Please input different usergroup title.','admin'),
('error_while_doc_tabs','Unknown error while fetching documentation tabs.','admin'),
('exchange_rate','Exchange rate','admin'),
('external_url','External URL','admin'),
('export','Export','admin'),
('external_file','External File','admin'),
('export_language','Export Language','admin'),
('export_not_checked','You have not chosen what to export.','admin'),
('export_tables_incorrect','Incorrect export tables.','admin'),
('export_to_excel','Export to Excel','admin'),
('extra_actions','Extra actions','admin'),

('feature_request','New Feature Request','admin'),
('featured_end','Featured end','admin'),
('fee_based','Fee based','admin'),
('feedback_terms','If you have any ideas how to improve our software, found a bug or want to request custom modification you are welcome to use this feedback form. We will log all your requests in our database.','admin'),
('field_added','Field added.','admin'),
('field_tooltip','Field Tooltip','admin'),
('field_default','Field default value','admin'),
('field_deleted','Field deleted.','admin'),
('field_element_children','Configure item fields for this value','admin'),
('field_exists','Field already exists.','admin'),
('field_length','Field length','admin'),
('field_name_exists','This name can not be chosen for selected item.','admin'),
('field_name_restricted','This name is reserved for system use. Please change it.','admin'),
('field_name_invalid','Field name should consist of letters and numbers only. Length 2-60.','admin'),
('field_relation','Field relation','admin'),
('field_relation_dependent','Dependent field','admin'),
('field_relation_parent','Parent field','admin'),
('field_relation_regular','Regular field','admin'),
('field_required','<span class="text-danger">*</span>','admin'),
('field_values','Field values','admin'),
('fieldgroup_added','Field group added.','admin'),
('fieldgroup_deleted','Field group deleted.','admin'),
('field_group','Field group','admin'),
('field_groups','Field Groups','admin'),
('field_type','Field type','admin'),
('field_type_checkbox','Checkboxes Set','admin'),
('field_type_combo','Dropdown List','admin'),
('field_type_currency','Currency','admin'),
('field_type_date','Date Input Field','admin'),
('field_type_iconpicker','Iconpicker','admin'),
('field_type_image','Single Image Upload','admin'),
('field_type_number','Number Input','admin'),
('field_type_pictures','Multiple Images Upload','admin'),
('field_type_radio','Radio Buttons Set','admin'),
('field_type_storage','Upload Attachment','admin'),
('field_type_text','Single Line Text Input','admin'),
('field_type_textarea','Multiline Textarea','admin'),
('field_type_url','URL Text Input','admin'),
('field_type_tree','Tree','admin'),
('field_type_tip_checkbox','This field allows multiple values selection.','admin'),
('field_type_tip_combo','This field will be displayed as dropdown select box.','admin'),
('field_type_tip_date','This field adds calendar control to set the date.','admin'),
('field_type_tip_iconpicker','Allows to assign icon from Font Awesome.','admin'),
('field_type_tip_image','This field value will be displayed as an image.','admin'),
('field_type_tip_number','This field can be searched by interval on Advanced Search page. Two inputs are created to set start and end values.','admin'),
('field_type_tip_pictures','This field is displayed as a gallery of images. Lightbox display is used on View Item page.','admin'),
('field_type_tip_radio','This field is displayed as multiple radio buttons.','admin'),
('field_type_tip_storage','This field is displayed as upload input.','admin'),
('field_type_tip_text','This field is displayed as one line text field.','admin'),
('field_type_tip_textarea','This field is displayed as multiline text box.','admin'),
('field_type_tip_url','This field value will be displayed as a hyperlink.','admin'),
('field_type_invalid','Field type is invalid.','admin'),
('fields','Fields','admin'),
('fields_for_plans','Fields for plans only','admin'),
('fields_item','Fields item','admin'),
('fields_item_filter','Fields item filter','admin'),
('fields_list','Fields List','admin'),
('file_doesnt_exist','File does not exist.','admin'),
('file_format','File format','admin'),
('file_prefix','File Prefix','admin'),
('filename_notification','<b>For templates:</b> type a name of your TPL file and place this file in your active template folder.<br />Example: <code>block.teaser.tpl</code><br><b>For plugins & packages:</b> TPL file should be placed in module\'s templates folder.<br />Example: <code>module/module_name:block_file.tpl</code>','admin'),
('fit','Fit','admin'),
('fit_tip','This mode attempts to resize an image proportionally in case it does not fit inner frame dimensions set by the administrator. If it fits the dimensions, an image will not be resized at all.','admin'),
('for_plan_only','For plans only','admin'),
('force_replacement', 'Force Replacement', 'admin'),
('format_example', 'Format example', 'admin'),
('free_plan_added','Free plan added.','admin'),
('future_date_specified_for_added_date','The date in future specified for &quot;Added Date&quot; field.','admin'),

('global','Global','admin'),
('go_to_config','View settings','admin'),
('go_to_list','Go to list','admin'),
('grid_of','of {0}','admin'),

('hide','Hide','admin'),
('hour','hour','admin'),
('hours_ago',':hours hours ago','admin'),
('host_fields','Host Fields','admin'),
('html','HTML','admin'),

('id','ID','admin'),
('ie_update_warning','Warning! Your version of Internet Explorer is too old. It may cause malfunctions of the script. Please update the browser to the 8 or higher version.','admin'),
('image_dimensions','Image dimensions','admin'),
('image_height','Image Height','admin'),
('image_types','Image types','admin'),
('import','Import','admin'),
('import_from_pc','Import the language file from PC','admin'),
('import_from_server','Import the language file from your server','admin'),
('inactive','Inactive','admin'),
('incompatible','Incompatible','admin'),
('incorrect_file_format','Incorrect file format.','admin'),
('incorrect_item','Please, choose a valid item','admin'),
('incorrect_key','Phrase key is incorrect.','admin'),
('incorrect_menu_name','Incorrect menu name.','admin'),
('incorrect_name_url','Incorrect name. Please fill in the URL field.','admin'),
('incorrect_owner_specified','Incorrect owner specified.','admin'),
('incorrect_text_field','Text field is incorrect.','admin'),
('incorrect_username','Incorrect username.','admin'),
('incorrect_value','Please enter the value of the key.','admin'),
('image_uploaded','Image :name is successfully uploaded.','admin'),
('impossible_to_compare_single_language','You need to have two or more languages to start comparing them.','admin'),
('input_title','Please input title','admin'),
('insert','Insert','admin'),
('installed_plugins','Installed plugins','admin'),
('install','Install','admin'),
('installed','Installed','admin'),
('install_not_deleted','Warning! For safety purposes, please remove the file :file','admin'),
('install_upgrade','Install or upgrade','admin'),
('installation_module_requirement_doesnot_exist','The currently installed :type &ldquo;:module&rdquo; is not compatible with the module.','admin'),
('installation_module_requirement_exist','Requires the &ldquo;:module&rdquo; :type to be installed.','admin'),
('installation_module_requirement_incorrect','Invalid dependencies specified. Ignored.','admin'),
('installation_impossible','Installation is currently impossible.','admin'),
('interval','Interval','admin'),
('invalid_base_url','Invalid site URL. Ignored.','admin'),
('invalid_image_file','Unable to process image, invalid image file.','admin'),
('invalid_plugin_dependencies','Invalid plugin dependencies','admin'),
('invoice_id','Invoice ID','admin'),
('items_fields','Fields','admin'),
('invert','Invert','admin'),
('iso_code','ISO Code','admin'),
('item_down','DOWN','admin'),
('item_id','Item ID','admin'),
('item_up','UP','admin'),
('item_value','Item Value','admin'),
('items_deleted',':num items deleted.','admin'),
('items_deleted_of',':num of :total items deleted.','admin'),
('items_per_page','Items per page','admin'),
('items_updated_of',':num of :total items updated.','admin'),

('just_now','just now','admin'),

('key_not_valid','Key is invalid. Only alphanumeric and underscore characters allowed.','admin'),

('lang_incorrect','Please choose correct language.','admin'),
('language_already_exists','Language already exists.','admin'),
('language_copied','New language created (:count phrases copied).','admin'),
('language_deleted','Selected language has been deleted.','admin'),
('language_iso_code','Iso','admin'),
('language_date_format','Date format','admin'),
('language_date_format_incorrect','Date format is incorrect.','admin'),
('language_date_format_tooltip','Check all possible values for date formatting here: <a href="http://www.smarty.net/docs/en/language.modifier.date.format.tpl" target="_blank">http://www.smarty.net/docs/en/language.modifier.date.format.tpl</a>','admin'),
('language_direction','Direction','admin'),
('language_direction_ltr','Left to right (LTR)','admin'),
('language_direction_rtl','Right to left (RTL)','admin'),
('language_locale','Locale','admin'),
('language_locale_incorrect','Language locale is incorrect.','admin'),
('language_time_format','Time format','admin'),
('language_time_format_tooltip','Be careful editing this value. Check the manual here: <a href="http://www.smarty.net/docs/en/language.modifier.date.format.tpl" target="_blank">http://www.smarty.net/docs/en/language.modifier.date.format.tpl</a>','admin'),
('languages_comparison','Comparison','admin'),
('last_updated','Last updated','admin'),
('launch_manually','Launch manually','admin'),
('legend','Legend','admin'),
('list_currencies','List','admin'),
('listings_limit','Listings limit','admin'),
('loading_widgets','Loading widgets...','admin'),
('local','Local','admin'),
('login_to_text','Enter the login name into "Login" and password into the "Password" fields.\r\nThen click "Login".','admin'),
('location_sql_file','Location of MySQL upgrade file','admin'),

('mailer','Mailer','admin'),
('manage','Manage','admin'),
('manage_entries','Manage entries','admin'),
('master','Master','admin'),
('max_files','Max number of files','admin'),
('max_num_images','Max Images','admin'),
('member_add','Add a Member','admin'),
('member_added','Member added.','admin'),
('member_deleted','Member deleted.','admin'),
('member_edit','Edit Member','admin'),
('members_with_custom_perms','Members <small>with custom permissions</small>','admin'),
('menu_configuration','Menu configuration','admin'),
('menu_doesnot_exists','Menu does not exist.','admin'),
('menu_deleted','Menu removed.','admin'),
('menu_exists','Menu with this name is already present. Please set another name.','admin'),
('menu_visible_everywhere','Visible everywhere','admin'),
('menu_visibility_exceptions_visible','Choose where menu will be explicitly <b>visible</b>','admin'),
('menu_visibility_exceptions_hidden','Choose where menu will be explicitly <b>hidden</b>','admin'),
('menus','Menus','admin'),
('menus_deleted','Menus deleted.','admin'),
('message_body','Message Body','admin'),
('meta_description','Meta-description','admin'),
('meta_keywords','Meta-keywords','admin'),
('meta_title','Meta-title','admin'),
('migrations','Migrations','admin'),
('migration_already_applied','Migration has been applied.','admin'),
('migrations_not_applied','Non-applied migrations','admin'),
('minutes_ago',':minutes minutes ago','admin'),
('mode','Mode','admin'),
('module_changelog','Changelog','admin'),
('module_description','Description','admin'),
('module_documentation','Documentation','admin'),
('module_downloaded','":name" downloaded.','admin'),
('module_installation','Installation','admin'),
('module_required','Module required','admin'),
('module_screenshots','Screenshots','admin'),
('moved','Moved.','admin'),
('multilingual','Multilingual','admin'),
('multiple_selection','Multiple selection','admin'),
('mysql_options','MySQL Options','admin');

INSERT INTO `{install:prefix}language` (`key`,`value`,`category`) VALUES
('na','n/a','admin'),
('name','Name','admin'),
('name_is_incorrect','Name is incorrect.','admin'),
('new_language','New Language','admin'),
('new_password','New password','admin'),
('next_launch','Next launch','admin'),
('next_payment_date','Next payment date','admin'),
('no_blocks','There are no blocks.','admin'),
('no_captcha_preview','No captcha preview.','admin'),
('no_extension','No extension','admin'),
('no_follow_url','No Follow URL','admin'),
('no_image_types','No image types added. Please, <a href=":url" target="_blank">add them</a> first.','admin'),
('no_implemented_packages','No implemented packages.','admin'),
('no_members','- no members -','admin'),
('no_migrations','No migration files available.','admin'),
('no_modules','No modules. You can check <a href="https://subrion.org/" target="_blank">Subrion.org website</a> to get some modules for your website.','admin'),
('no_parent_fields','No main fields for this item','admin'),
('no_plans','No Plans','admin'),
('no_upgrades','No patches, migrations, or upgrades available.','admin'),
('nodes','Nodes','admin'),
('notes','Notes','admin'),
('not_allowed','Not allowed','admin'),
('not_required','not required','admin'),
('nothing','Nothing','admin'),
('notification_resolve--resolve','Resolve issue','admin'),
('notification_resolve--working','Working...','admin'),
('notification_resolve--resolved','Resolved!','admin'),
('number_of_cycles','Number of cycles','admin'),
('number_of_decimal_places','Number of decimal places','admin'),

('one_day_ago','one day ago','admin'),
('one_hour_ago','one hour ago','admin'),
('one_value','You have to add at least one value.','admin'),
('optimize_complete','Tables optimizing complete.','admin'),
('optimize_tables','Optimize tables','admin'),
('optional','optional','admin'),
('options','Options','admin'),
('original','Original','admin'),
('other_can','Other can','admin'),
('owner','Owner','admin'),
('owner_can','Owner can','admin'),
('owner_is_not_specified','Owner is not specified.','admin'),

('page_added','Page added.','admin'),
('page_alias_exists','Page URL already exists.','admin'),
('page_content','Page Content','admin'),
('page_exists','Page with specified URL already exists. Please change URL.','admin'),
('page_external_url','Page External URL','admin'),
('page_incorrect_template_filename','Incorrect template name for page.','admin'),
('page_name_exists','Page with specified name already exists.','admin'),
('page_preview','Page in draft','admin'),
('page_title','Page Title','admin'),
('page_title_incorrect','Please make sure you have added all page titles.','admin'),
('pages','Frontend Pages','admin'),
('pages_contains','Include pages','admin'),
('pages_group_content','Content','admin'),
('pages_group_extensions','Extensions','admin'),
('pages_group_financial','Financial','admin'),
('pages_group_members','Members','admin'),
('pages_group_system','System','admin'),
('package_activated','Package activated.','admin'),
('package_deactivated','Package deactivated.','admin'),
('package_error','You have to choose at least one package.','admin'),
('package_updated','Package updated.','admin'),
('package_version','Package Version','admin'),
('packages_avail','Available Packages','admin'),
('package_installed','Package installed.','admin'),
('package_uninstalled','Package uninstalled.','admin'),
('password_restore_description',"If you see this page that means that you have received an email with\r\n\r\nthis URL.\r\n\r\nThis page is intended to set a new password for your administration\r\n\r\naccount.\r\n\r\n<div style=\"color:red;padding:10px;border:1px solid gray\"><p>It is assumed that you know your username (login)</p><p>There is only one attempt!!!</p><p>Otherwise you\'ll have to request restoration again (in login page)</p></div>",'admin'),
('path','Path','admin'),
('permissions','Permissions','admin'),
('permissions_members','Member permissions :member','admin'),
('permissions_usergroups','Usergroup permissions :usergroup','admin'),
('phrase_added','Phrase added.','admin'),
('phrase_exists','Phrase exists.','admin'),
('phrase_manager','Phrase Manager','admin'),
('phrase_text','Phrase Text','admin'),
('place','Position in template','admin'),
('plan','Plan','admin'),
('plan_add','Add Plan','admin'),
('plan_deleted','Plan deleted.','admin'),
('plan_edit','Edit Plan','admin'),
('plans','Plans','admin'),
('plans_fields','Fields for plan','admin'),
('plugin','Plugin','admin'),
('plugin_files_physically_missed','Plugin files are missing. Probably folder name does not match plugin name.','admin'),
('plugin_installed','":name" plugin installed.','admin'),
('plugin_may_not_be_removed','Plugin may not be removed.','admin'),
('plugin_reinstalled','":name" plugin reinstalled.','admin'),
('plugin_status_may_not_be_changed','Status of this plugin may not be changed.','admin'),
('plugin_updated','Plugin updated.','admin'),
('plugin_uninstalled','Selected plugin uninstalled.','admin'),
('plugins','Plugins','admin'),
('plugins_left',':count more plugins left to be installed.','admin'),
('preview','Preview','admin'),
('previous_launch','Previous launch','admin'),
('price','Price','admin'),
('primary','Primary','admin'),
('product_items','Product Items','admin'),

('quantity','Quantity','admin'),
('query_history','Queries History','admin'),
('quick_access','Quick Access','admin'),

('radios','Radios','admin'),
('rate','Rate','admin'),
('recent_activity','Recent activity','admin'),
('recent_package_activity','Recent :package activity','admin'),
('recount','recount','admin'),
('recurring_options','Recurring Options','admin'),
('registration_email_resent','Registration email has been re-sent.','admin'),
('regular_field','Regular field','admin'),
('reinstall','Reinstall','admin'),
('reinstall_plugin','Reinstall plugin','admin'),
('remote','Remote','admin'),
('removed','Removed.','admin'),
('repair','repair','admin'),
('repair_tables','Repair tables','admin'),
('repair_complete','Tables repairing complete.','admin'),
('resend_registration_email','Re-send registration email','admin'),
('reset_all','Reset all','admin'),
('reset_backup_alert','Please backup your data before resetting your items.','admin'),
('reset_choose_table','Choose entries to reset.','admin'),
('reset_default','Reset default','admin'),
('reset_default_package','Your package URLs will be reset. Please choose the URL that will be used to access your directory package.','admin'),
('reset_default_success','Your package URLs have been reset.','admin'),
('reset_previous_default_success','Your previous default value has been reset.','admin'),
('reset_success','Reset successfully completed.','admin'),
('resize_mode','Resize mode','admin'),
('restore_defaults','Restore defaults','admin'),
('result','Result','admin'),
('request_submitted','Thanks. Your request has been submitted.','admin'),
('required_checks','Validation PHP code','admin'),
('required_module_error','The module you are trying to install requires the following :module to be installed: :name (:version)','admin'),
('required_field','Required field','admin'),
('required_fields','Required fields','admin'),
('required_template_error','The template you are trying to install requires the following :module to be installed: :name (:version)','admin'),
('root_about','No additional prefixes will be added to package URL. This way is highly recommended for sites with one package installed. See more details in our <a href="https://subrion.org/forums/">User Forums</a>.','admin'),
('root_title','Script Root Installation','admin'),
('root_old','You currently have the ":name" package installed in your Script Root location. You can not have two packages installed in root simultaneously. If you still want to install in Root location please set the URL value for the ":name" package.','admin'),
('run','Run','admin'),
('run_sql_queries','Run MySQL query/queries','admin'),

('save_as_file','Save as file','admin'),
('save_changes_to_send_test_email','Save your changes before sending a test email.','admin'),
('save_to_pc','Save to PC','admin'),
('save_to_server','Save to server','admin'),
('scheduled_task_ran','Task launched.','admin'),
('screenshot','Screenshot','admin'),
('script_upgraded','Your script has been automatically upgraded to version :version.','admin'),
('search_in_phrases','Search in Phrases','admin'),
('section','Search section','admin'),
('select_all','Select all','admin'),
('select_all_in_tab','Select all in this tab','admin'),
('select_none','Select None','admin'),
('send_confirm','Are you sure you wish to send this feedback to the Subrion Team?','admin'),
('send_test_email','Send test email','admin'),
('send_test_email_note','Test message will be sent to your current profile email address.','admin'),
('sending','Sending','admin'),
('seo','SEO','admin'),
('server_info','Server Info','admin'),
('set_as_default_value','Set as default value','admin'),
('set_as_default_package','Set as default package','admin'),
('set_as_default_template','Activate','admin'),
('set_as_primary','Set as primary','admin'),
('set_as_thumbnail','Set as thumbnail','admin'),
('set_default','Set Default','admin'),
('set_default_success','Changes saved. Your package is now available in root.','admin'),
('set_all_to','set all to','admin'),
('settings','Settings','admin'),
('show','Show','admin'),
('show_header','Show header','admin'),
('show_in_search_as','Show in search as','admin'),
('show_menus','Show in Menus','admin'),
('show_query_again','Show this query again','admin'),
('shown_on_pages','Shown on Pages','admin'),
('site_home','Site Home','admin'),
('sitemap_error','Sitemap file creation error! The file was not saved.','admin'),
('sitemap_regenerated','Sitemap file has been regenerated and is available at the following URL: <a href=":url" target="_blank">:url</a>.','admin'),
('slug','Slug','admin'),
('sponsored_end','Sponsored End','admin'),
('sql_format','SQL format','admin'),
('sql_management','SQL Tool','admin'),
('stay_here','Stay here','admin'),
('start','Start','admin'),
('statistics','Statistics','admin'),
('status_change_not_allowed','Status change of readonly field not allowed.','admin'),
('sticky','Sticky','admin'),
('structure','Structure','admin'),
('subdirectory_about','Your package will be accessible in a subdirectory. We recommend to use this way on shared hostings when you have several packages installed. <br /> Ex.: domain.com/articles/, domain.com/links/, domain.com/autos/, etc.','admin'),
('subdirectory_title','Subdirectory Installation','admin'),
('subdomain_about','You can install the package as a subdomain. Note you should be able to modify your Apache config file to use package on a subdomain. More instructions can be found in our <a href="https://subrion.org/forums/">User Forums.</a><br /> Ex.: articles.domain.com, links.domain.com, autos.domain.com, etc.','admin'),
('subdomain_title','Subdomain Installation','admin'),
('submit_feedback','Submit Feedback to the Subrion Team','admin'),
('subtotal','Subtotal','admin'),
('sure_uninstall_package','Are you sure you want to uninstall this package? Please be informed that all your package data will be lost.','admin'),
('sync_multilingual_fields','Sync multilingual fields','admin'),
('system_fields','System Fields','admin'),
('system_notifications','System Notifications','admin'),

('tab_container','Tab container','admin'),
('table_dumped','Table :table dumped into file ":filename".','admin'),
('tables','Tables','admin'),
('tables_fields','Tables/Fields','admin'),
('tags','Tags','admin'),
('task','Task','admin'),
('tax','Tax','admin'),
('template_name_empty','Template name is empty or incorrect.','admin'),
('template_file_error','Template file cannot be found. Use this file: :file.','admin'),
('template_folder_error','Template folder is undefined or incorrect.','admin'),
('template_installed','":name" template installed.','admin'),
('test_email_sent','Test email has been received for delivery to :email.','admin'),
('text','Text','admin'),
('this_fields_displayed_only_for_plans','These fields are displayed for sponsored plans only.','admin'),
('thousand_separator','Thousand separator','admin'),
('thumb_dimensions','Thumb dimensions','admin'),
('thumb_width','Thumbnail width','admin'),
('thumb_height','Thumbnail height','admin'),
('thumbnail','Thumbnail','admin'),
('timepicker','Enable time selection','admin'),
('title_alias','Title Alias','admin'),
('total','Total','admin'),
('total_income','total income','admin'),
('total_members','total members','admin'),
('tooltip','Tooltip','admin'),
('tpl','Template filename','admin'),
('transaction_added','Transaction added.','admin'),
('transaction_deleted','Transaction deleted.','admin'),
('transaction_id','Transaction ID','admin'),
('translate','Translate','admin'),
('twitter_news','Twitter News','admin'),
('type','Type','admin'),
('type_here_to_search','Type here to search','admin'),
('type_of_field','Field type','admin'),

('unable_to_install','Unable to install','admin'),
('uninstall','Uninstall','admin'),
('unique_name','Name value should be unique. Only latin letters, underscores, and digits are allowed.','admin'),
('update_available','Update available','admin'),
('upgrade_completed','MySQL dump file has been imported.','admin'),
('upload_module_error',':module directory is not writable.','admin'),
('upload_writable_permission','Upload folder has no writable permissions.','admin'),
('use_real_prefix','Use real tables prefix','admin'),
('upgrade','Upgrade','admin'),
('upgrades','Upgrades','admin'),
('url_nofollow','Enable nofollow attribute','admin'),
('use_as_home_page','Use as the homepage','admin'),
('use_custom_signature','Use custom signature','admin'),
('use_editor','Use WYSIWYG editor','admin'),
('username_already_taken','Username already taken.','admin'),
('usergroup_added','Usergroup added.','admin'),
('usergroup_deleted','Usergroup deleted.','admin'),
('usergroup_disabled','You must have at least one administrator member.','admin'),
('usergroup_management','Usergroup management','admin'),
('usergroups','Usergroups','admin'),

('version','Version','admin'),
('view_as_tab','View as tab','admin'),
('view_roadmap','Development Roadmap','admin'),
('visible','Visible','admin'),
('visible_for_admin','Visible for admin only','admin'),
('visible_on_members','Visible on Members page','admin'),
('visual_mode','Visual Mode','admin'),

('warning_fields_become_for_plan_only','Warning! If you check these fields they will be displayed for sponsored plans only.','admin'),
('week','week','admin'),
('welcome_to_admin_board','Welcome to your administration board, cap''n!','admin'),
('welcome_to_admin_panel','Welcome to<br>Subrion Admin Panel','admin'),
('without_title','Without title','admin'),

('year','year','admin');

INSERT INTO `{install:prefix}language` (`key`,`value`,`category`) VALUES
('_not_assigned_','&lt;not assigned&gt;','common'),
('_select_','-- select --','common'),
('_status_','- Status -','common'),

('401','You are not authorized to access this page.','common'),
('403','Action is forbidden.','common'),
('404','Requested URL not found.','common'),

('active','Active','common'),
('add','Add','common'),
('add_funds','Add Funds','common'),
('added','Added','common'),
('address','Address','common'),
('address_line','Address Line','common'),
('admin_panel','Admin Panel','common'),
('all','All','common'),
('amount','Amount','common'),
('any','Any','common'),
('apply','apply','common'),
('approval','Approval','common'),
('asc','Ascending','common'),
('author','Author','common'),
('avatar','Avatar','common'),

('browse','Browse','common'),
('by','by','common'),

('cancel','Cancel','common'),
('cancel_upload_confirmation','Are you sure you want to cancel this upload?','common'),
('category','Category','common'),
('change','change','common'),
('change_password','Change Password','common'),
('choose_file','and choose file on your computer.','common'),
('city','City','common'),
('click','Click','common'),
('click_here','Click here','common'),
('click_here_to_upload','Click here to upload...','common'),
('close','Close','common'),
('close_all','Close all','common'),
('create','Create','common'),
('code','Code','common'),
('collapsed','Collapsed','common'),
('collapse_all','Collapse All','common'),
('common','Common','common'),
('confirm','Confirm','common'),
('content','Content','common'),
('contributor','Contributor','common'),
('copy','Copy','common'),
('country','Country','common'),
('currency','Currency','common'),
('current','Current','common'),
('current_page','Current Page','common'),

('day1','Monday','common'),
('day2','Tuesday','common'),
('day3','Wednesday','common'),
('day4','Thursday','common'),
('day5','Friday','common'),
('day6','Saturday','common'),
('day7','Sunday','common'),
('date','Date','common'),
('db_error','Database error.','common'),
('delete','Delete','common'),
('deleted','Deleted.','common'),
('desc','Descending','common'),
('description','Description','common'),
('default','Default','common'),
('details','Details','common'),
('disabled','Disabled','common'),
('discard','Discard','common'),
('done','Done','common'),
('download','Download','common'),
('draft','Draft','common'),
('drop_files_here','Drop images here or click to choose...','common'),

('email','Email','common'),
('edit','Edit','common'),
('edit_block','Edit block','common'),
('edit_position','Edit position','common'),
('enabled','Enabled','common'),
('exit','Exit','common'),
('module','Module','common'),
('empty_login','Either login or password is empty.','common'),
('err_message','Message cannot be empty.','common'),
('error','Error','common'),
('error_directory_readonly','Upload directory is not writable.','common'),
('error_duplicate_email','Email is already taken for another member. Please input a different email address.','common'),
('error_email_incorrect','E-mail is incorrect.','common'),
('error_login','Either login or password is invalid.','common'),
('error_password_empty','Please input correct password.','common'),
('error_password_match','Password does not match.','common'),
('error_phone_incorrect','Phone is incorrect.','common'),
('error_tmp_directory_readonly','Temp directory is readonly. Please make it writable.','common'),
('error_url','Site URL is incorrect.','common'),

('failed','Failed','common'),
('featured','Featured','common'),
('featured_status_finished_date_is_empty','Listing has been marked as featured, but no finished date was specified.','common'),
('filter','Filter','common'),
('forgot_password','Forgot your password?','common'),
('format','Format','common'),
('from','from','common'),
('fullname','Full Name','common'),
('funds','Funds','common'),

('field__tooltip','please upload only image files','common'),
('field_member_api_push_token','Push Token of your phone','common'),
('field_member_api_push_receive','Do you agree to receive push notifications to your phone?','common'),
('field_member_api_push_receive+yes','Yes','common'),
('field_member_api_push_receive+no','No','common'),
('field_member_avatar','Avatar','common'),
('field_tooltip_member_avatar','Please upload image files only','common'),
('field_member_biography','Biography','common'),
('field_tooltip_member_category_id','Select a category from the list','common'),
('field_member_email','Email','common'),
('field_member_email_language','Email receiving language','common'),
('field_member_facebook','Facebook','common'),
('field_tooltip_member_facebook','Full link to your profile page','common'),
('field_member_fullname','Full Name','common'),
('field_member_gplus','Google+','common'),
('field_tooltip_member_gplus','Full link to your profile page','common'),
('field_member_linkedin','LinkedIn','common'),
('field_tooltip_member_linkedin','Full link to your profile page','common'),
('field_member_phone','Phone','common'),
('field_member_twitter','Twitter','common'),
('field_tooltip_member_twitter','Full link to your profile page','common'),
('field_member_username','Username','common'),
('field_member_website','Website','common'),
('field_description','Description','common'),
('field_gallery','Pictures','common'),
('field_is_empty',':field is empty.','common'),
('field_is_not_selected',':field is not selected.','common'),
('field_item','Item','common'),
('field_pictures','Pictures','common'),
('field_transaction_amount','Amount','common'),
('field_transaction_currency','Currency code','common'),
('field_transaction_date_created','Date created','common'),
('field_transaction_date_paid','Date paid','common'),
('field_transaction_gateway','Gateway','common'),
('field_transaction_member_id','Member username','common'),
('field_transaction_operation','Operation','common'),
('field_transaction_reference_id','Order number','common'),
('field_transaction_sec_key','Secret key','common'),
('field_transaction_status','Status','common'),
('field_transaction_total','Total','common'),
('fieldgroup_member_api','API','common'),
('fieldgroup_member_general','General','common'),
('fieldgroup_member_social','Social','common'),
('fieldgroup_description_member_api','Subrion API related data','common'),
('fieldgroup_description_member_general','','common'),
('fieldgroup_description_member_social','','common'),
('file_click_to_upload','Click Browse to upload file','common'),
('file_type_error','Files with ":extension" extension are only allowed.','common'),
('file_types',"Allowed file types (comma separated values (don't include point), example: pdf, doc, odf, mov)",'common'),
('filename','Filename','common'),

('gateway','Gateway','common'),
('general','General','common'),
('general_info','General Information','common'),
('go','Go','common'),
('group','Group','common'),

('hours','hours','common'),
('hide_everywhere','Hide everywhere','common'),

('image','Image','common'),
('image_click_to_upload','Click Browse to upload image','common'),
('image_width','Image Width','common'),
('incorrect_fullname','Please input correct full name.','common'),
('invalid_parameters','Invalid parameters.','common'),
('ip_address','IP Address','common'),
('item','Item','common'),

('key','Key','common'),
('keywords','Keywords','common'),

('language','Language','common'),
('languages','Languages','common'),
('last_login_date','Logged in','common'),
('listings','Listings','common'),
('loading','Loading ...','common'),
('locked','Locked','common'),
('login','Login','common'),
('logout','Logout','common'),

('main_page','Home','common'),
('mark_as','Mark As:','common'),
('member','Member','common'),
('members','Members','common'),
('month','Month','common'),
('month1','January','common'),
('month2','February','common'),
('month3','March','common'),
('month4','April','common'),
('month5','May','common'),
('month6','June','common'),
('month7','July','common'),
('month8','August','common'),
('month9','September','common'),
('month10','October','common'),
('month11','November','common'),
('month12','December','common'),
('months','months','common'),
('more','More','common'),
('move','Move','common'),
('move_to','Move To:','common'),
('multilingual_field_is_empty',':field is empty for :lang.','common'),

('name','Name','common'),
('next','Next','common'),
('no','No','common'),
('no_items','No items.','common'),
('no_more_files','You can not upload more files. Limit exceeded.','common'),
('no_uploaded_files_processed','No uploaded files processed due to file extension restrictions.','common'),
('nothing_found','Nothing found.','common'),

('ok','Ok','common'),
('on','on','common'),
('online_members','Online Members','common'),
('operation','Operation','common'),
('open_close','Show / Hide the tree','common'),
('open_in_new_tab','Open in new tab','common'),
('order','Order','common'),
('other','Other','common'),

('page','Page','common'),
('page_url_will_be','Page URL will be','common'),
('pages','Pages','common'),
('parent','Parent','common'),
('passed','Passed','common'),
('password','Password','common'),
('password_confirm','Password confirmation','common'),
('password_incorrect','Password is incorrect.','common'),
('payment_gateway','Payment gateway','common'),
('pending','Pending','common'),
('phone','Phone','common'),
('plan_added','Plan added.','common'),
('plans','Plans','common'),
('position','Position','common'),
('previous','Previous','common'),
('print','Print','common'),
('print_invoice','Print invoice','common'),
('profile','Profile','common'),

('rank','Rank','common'),
('read','Read','common'),
('recurring','Recurring','common'),
('reference_id','Reference ID','common'),
('refresh','Refresh','common'),
('refunded','Refunded','common'),
('regular','Regular','common'),
('remember_me','Remember me','common'),
('remove','Remove','common'),
('reset','Reset','common'),
('restore_password','Restore Password','common'),
('rss','RSS','common'),

('save','Save','common'),
('saved','Saved.','common'),
('save_changes','Save Changes','common'),
('saving','Saving...','common'),
('search','Search','common'),
('searchable','Searchable','common'),
('select_category_from_list','Select a category from the list','common'),
('send','Send','common'),
('show_everywhere','Show everywhere','common'),
('show_on_all_pages','Global visibility','common'),
('show_on_this_page','Show on this page','common'),
('sponsored','Sponsored','common'),
('start_typing_to_filter','Start typing to filter items','common'),
('status','Status','common'),
('subject','Subject','common'),
('submit','Submit','common'),
('subscription','Subscription','common'),
('summary','Summary','common'),
('sure_rm_file','Are you sure want to remove the file?','common'),
('suspended','Suspended','common'),

('title','Title','common'),
('title_incorrect','Title is incorrect.','common'),
('title_is_empty','Title is empty.','common'),
('templates','Templates','common'),
('time','Time','common'),
('total','Total','common'),
('transaction','Transaction ','common'),
('transactions','Transactions','common'),
('tree','Tree','common'),
('type_email_here','Type your email here','common'),

('url','URL','common'),
('unconfirmed','Unconfirmed','common'),
('upload','Upload','common'),
('upload_correct_permission',"Couldn't copy uploaded image to the destination folder. Please make sure that the script has write permissions.",'common'),
('upload_pictures','Upload Picture(s)','common'),
('upload_successful','Upload successfully completed','common'),
('uploading_please_wait','Uploading, please wait...','common'),
('users','Users','common'),
('usergroup','Usergroup','common'),
('username','Username','common'),
('username_incorrect','Username is incorrect.','common'),
('usergroup_administrators','Administrators','common'),
('usergroup_moderators','Moderators','common'),
('usergroup_guests','Guests','common'),
('usergroup_registered','Registered','common'),

('value','Value','common'),
('view','View','common'),
('view_all','View All','common'),
('views','Views','common'),

('weeks','weeks','common'),
('write','Write','common'),

('years','years','common'),
('yes','Yes','common'),

('zip','ZIP','common');

INSERT INTO `{install:prefix}language` (`key`,`value`,`category`) VALUES
('active_users','Active Users','frontend'),
('add_funds_text','Add funds to your account with us to avoid lots of small transactions and to automatically take care of any new invoices to generate.','frontend'),
('advanced','Advanced','frontend'),
('alphabetical','Alphabetical','frontend'),
('all_groups','All groups','frontend'),
('amount_incorrect','Please input correct amount. It should be within :min & :max :currency.','frontend'),
('amount_to_add','Amount to add','frontend'),
('min_deposit','Minimum deposit','frontend'),
('max_deposit','Maximum deposit','frontend'),
('max_balance','Maximum balance','frontend'),
('and_more','and more','frontend'),
('are_you_sure_to_cancel_invoice','Are you sure you want to cancel your invoice?','frontend'),
('author_contact_request','Contact request regarding ":title"','frontend'),
('auto_generate_password','Auto generate password','frontend'),

('back_to_gateway_list','{current_gateway} payment gateway, click <a href=\"javaScript:void(0);\" onclick=\"backToPaymentGatewayList()\">here</a> to choose another one','frontend'),
('back_to_profile','Back to profile','frontend'),
('billing_address','Billing Address','frontend'),
('bots','Bots','frontend'),
('bots_visits','Visits last 24h (bots)','frontend'),
('by_fullname','full name','frontend'),
('by_username','username','frontend'),
('by_name','By name','frontend'),
('by_registration_date','By registration date','frontend'),

('change_gateway','Change gateway','frontend'),
('chars_left','Chars left','frontend'),
('choose_image_file','and choose image file on your computer.','frontend'),
('confirmation_code_incorrect','Captcha code is incorrect.','frontend'),
('confirmation_key_incorrect','Confirmation key is incorrect.','frontend'),
('current_assets','Current Assets','frontend'),
('current_password','Current Password','frontend'),

('date_added','Date','frontend'),
('delete_listing','Remove Listing','frontend'),
('do_authorize_to_save_search','Please, authorize to be able to save your searches.','frontend'),
('dont_wait_redir','Click here if you do not want to wait.','frontend'),

('edit_listing','Edit Listing','frontend'),
('edit_subject','Edit subject','frontend'),
('edited_by','<i>Last edited by <a href=\"{%URL%}\">{%USER%}</a></i>','frontend'),
('empty_image_title','Empty','frontend'),
('enter_confirmation_code','Please enter confirmation code below','frontend'),
('error_no_member_email','No members registered with this email.','frontend'),

('favorites','Favorites','frontend'),
('favorites_action_add','Add to favorites','frontend'),
('favorites_action_added','Listing has been added to favorites.','frontend'),
('favorites_action_delete','Remove from favorites','frontend'),
('favorites_action_deleted','Listing has been deleted from favorites.','frontend'),
('field_required','<span class=\"note\">[Required]</span>','frontend'),
('first','First','frontend'),
('forgot','Forgot password?','frontend'),
('forgot_tooltip',"Don't remember your login information? We all forget &mdash; no worries. Please enter your e-mail address below and we will send your login credentials.",'frontend'),
('funds_in_your_account','You have :currency :sum in your account.','frontend'),

('group_filter','Group filter','frontend'),
('guest','Guest','frontend'),
('guests','Guests','frontend'),

('howmuch_funds','Please input the amount you want to add:','frontend'),

('invalid_addressee','Invalid addressee specified.','frontend'),
('invoice_deleted','Invoice deleted.','frontend'),

('last','Last','frontend'),
('listing_successfully_removed','Listing data has been removed.','frontend'),
('listing_successfully_submitted','Listing has been successfully submitted.','frontend'),
('listing_successfully_updated','Listing data has been successfully updated.','frontend'),
('live_visits','Visits last 24h (live)','frontend'),
('login_with_social_network','Login with social network','frontend'),

('mail_sent','Email sent.','frontend'),
('member_created','Member registered! Thank you!','frontend'),
('member_doesnt_exist','The member does not exist anymore.','frontend'),
('member_since','Member since','frontend'),
('msg','Message','frontend'),
('my_saved_searches','My saved searches','frontend'),
('my_searches','My searches','frontend'),

('new_password','New Password','frontend'),
('new_password2','New Password [confirm]','frontend'),
('new_password_sent','New password has been sent to your email.','frontend'),
('no_funds','You have not added funds to your account.','frontend'),
('no_favorites','You have not added any favorite items.','frontend'),
('no_gateway','You have not installed any payment gateway plugin.','frontend'),
('no_members','No members found that match specified params.','frontend'),
('no_transaction','Sorry, no such transaction.','frontend'),
('no_transactions_records','You do not have any payment records in your history.','frontend'),
('num_results_found','Results found: <strong id="js-search-results-num">0</strong>','frontend'),

('online','Online','frontend'),

('page_preview','This is how your page will look like once you save it in admin panel.','frontend'),
('paid_subscription_will_cancel','In case you select this option, your already paid subscription will cancel.','frontend'),
('password_changed','Password has been changed.','frontend'),
('password_empty','You have not entered a new password.','frontend'),
('password_protected_page','You must input a password to view this page.','frontend'),
('pay','Pay','frontend'),
('pay_using_account_funds','Pay using the funds available in your account.','frontend'),
('pay_external','Pay via payment system.','frontend'),
('pay_via_payment_gateways','You can pay via payment gateways.','frontend'),
('pay_reason','Reason','frontend'),
('payer_name','Payer name','frontend'),
('payer_email','Payer email','frontend'),
('payment','Payment','frontend'),
('payment_cancellation','Payment cancellation','frontend'),
('payment_process_canceled','Payment process canceled.','frontend'),
('payment_details','Payment details','frontend'),
('payment_done','Thank you for your payment. Your transaction has been completed.','frontend'),
('payment_date','Payment Date','frontend'),
('payment_gateway_not_chosen','Please choose payment gateway','frontend'),
('payment_redirect_message',"You will be automatically redirected to the item's page in :seconds. If you do not want to wait click the button below:",'frontend'),
('payment_status','Payment status','frontend'),
('pictures','Pictures','frontend'),
('powered_by_subrion','Powered by <a href="https://subrion.org" title="Open Source CMS">Subrion CMS</a>','frontend'),
('print_preview','Print Page','frontend'),
('proceed_pay','Proceed to Payment','frontend'),
('protected_page','Protected page','frontend'),

('reg_confirm_adm_approve','Member confirmed. But it must be approved by administrator, usually it takes about 24 hours.','frontend'),
('reg_confirmation','Registration Confirmation','frontend'),
('reg_confirmed','Member confirmed. Please sign in.','frontend'),
('registration','Registration','frontend'),
('redirected_to_home','to be redirected to the home page.','frontend'),
('register_login','Please Login or Register','frontend'),
('registration_tooltip','Registration is simple and takes just few seconds. Please fill in the form below.','frontend'),
('reset_filters','Reset filters','frontend'),
('restore_pass_confirm','We have sent confirmation code to your email. Please check it and follow the instructions.','frontend'),

('safety','Safety','frontend'),
('save_this_search','Save this search','frontend'),
('search_for','Search for...','frontend'),
('send_email','Send email','frontend'),
('send_message','Send message','frontend'),
('show_all_num_results','Show all :num results','frontend'),
('slogan','Content Management Software','frontend'),
('sort_by','Sort by','frontend'),
('starts_with','starts with','frontend'),

('thank_text','to get back to index page.','frontend'),
('thanks','Thank you.','frontend'),
('thankyou_head','<p>Below is the information you submitted so far. You will be able to extend and edit this information via your member account.</p><p><span class=\"label label-danger\">Important</span> Your account password has been sent to the following email address:</p>','frontend'),
('thankyou_tail','<p>Please read our letter with further instructions.</p>','frontend'),
('this_transaction_already_passed','We already have this payment in our database. Transaction passed successfully.','frontend'),
('total_paid','Total Paid','frontend'),
('tools','Tools','frontend'),

('unable_to_send_email','Unable to send e-mail.','frontend'),
('untitled','Untitled','frontend'),
('usergroups','Usergroups','frontend'),
('username_already_exists','Username already taken. Please input different username.','frontend'),
('username_empty','Make sure you have entered a valid username and your membership is active.','frontend'),
('username_or_email','Username or E-mail','frontend'),

('view_profile','View profile','frontend'),

('wait_for_gateway_answer','The payment is currently being processed by payment gateway. Please check it later. <a href=":url">Click here</a> to change payment gateway for this transaction.','frontend'),
('wait_redirect','Please wait, you will be redirected shortly.','frontend'),
('welcome','Welcome','frontend'),

('your_name','Your Full Name','frontend'),
('your_email','Your email','frontend'),
('your_membership_is_inactive','Your membership is inactive. You may not use this feature.','frontend'),
('your_password','Your password','frontend'),
('your_password_confirm','Confirm your password','frontend'),
('your_title_for_this_search','Your title for this search (optional)','frontend'),
('your_username','Your username','frontend'),
('youre_admin_browsing_disabled_front','Frontend is disabled for regular members. It''s only available for admin members.','frontend'),
('youre_in_manage_mode','You are in manage mode. <a href="?manage_exit=y">Exit</a>','frontend'),
('youre_in_preview_mode','You are in preview mode. <a href="?preview_exit=y">Exit</a>','frontend');

INSERT INTO `{install:prefix}language` (`key`,`value`,`category`) VALUES
('block_title_2','Inventory Menu','frontend'),
('block_title_3','Main Menu','frontend'),
('block_title_4','Member Menu','frontend'),
('block_title_5','Bottom Menu','frontend'),
('block_title_6','Statistics','frontend'),
('block_title_7','Refine Search','frontend'),

('page_title_adminer','DB Tools','admin'),
('page_title_blocks','Blocks','admin'),
('page_title_clear_cache','Clear Cache','admin'),
('page_title_configuration','Settings','admin'),
('page_title_currencies','Currencies','admin'),
('page_title_database','Database','admin'),
('page_title_debugmode','Debug Mode','admin'),
('page_title_email_templates','E-mail Templates','admin'),
('page_title_fields','Fields','admin'),
('page_title_fieldgroups','Field Groups','admin'),
('page_title_imagetypes','Image Types','admin'),
('page_title_hooks','Hooks','admin'),
('page_title_index','Dashboard','admin'),
('page_title_invoices','Invoices','admin'),
('page_title_languages','Languages','admin'),
('page_title_members','Members','admin'),
('page_title_member_fields','Member Fields','admin'),
('page_title_menus','Menus','admin'),
('page_title_packages','Packages','admin'),
('page_title_pages','Pages','admin'),
('page_title_phpinfo','PHP Info','admin'),
('page_title_phrases','Phrases','admin'),
('page_title_plans','Plans','admin'),
('page_title_plugins','Plugins','admin'),
('page_title_scheduled_tasks','Scheduled Tasks','admin'),
('page_title_sitemap','Generate Sitemap','admin'),
('page_title_subscriptions','Subscriptions','admin'),
('page_title_templates','Templates','admin'),
('page_title_transactions','Transactions','admin'),
('page_title_uploads','Uploads','admin'),
('page_title_usergroups','Usergroups','admin'),
('page_title_permissions','Permissions','admin'),

('page_title_sys_mgmt','Management','admin'),
('page_title_sys_email','E-mail','admin'),
('page_title_sys_extra','Extra','admin'),
('page_title_ctnt_ext','Extended','admin'),
('page_title_ctnt_xtns','Extensions','admin'),
('page_title_mbr_ext','Extended','admin'),
('page_title_fin_mgmt','Management','admin'),
('page_title_xtns_empt','','admin'),

('page_content_about',"<p>Page 'About Us' content goes here. You can edit it in Admin Panel ->  Content -> Pages.</p>",'page'),
('page_content_help','<p>Help page content goes here. You can edit it in Admin Panel ->  Content -> Pages.</p>','page'),
('page_content_index','','page'),
('page_content_policy',"<p>Page 'Privacy Policy' content goes here. You can edit it in Admin Panel ->  Content -> Pages.</p>",'page'),
('page_content_terms',"<p>Page 'Terms Of Use' content goes here. You can edit it in Admin Panel ->  Content -> Pages.</p>",'page'),

('page_title_about','About Us','page'),
('page_title_members','Members','page'),
('page_title_member_password_forgot','Forgot Password','page'),
('page_title_favorites','Favorites','page'),
('page_title_index','Home','page'),
('page_title_help','Help','page'),
('page_title_login','Login','page'),
('page_title_member_funds','Funds','page'),
('page_title_pay','Pay','page'),
('page_title_policy','Privacy Policy','page'),
('page_title_profile','My Profile','page'),
('page_title_registration','Registration','page'),
('page_title_register_confirm','Registration Confirmation','page'),
('page_title_redirect','Redirecting','page'),
('page_title_search','Search','page'),
('page_title_terms','Terms of Use','page'),
('page_title_view_member','Member Details','page');

INSERT INTO `{install:prefix}language` (`key`,`value`,`category`) VALUES
('alias_urlencode','Non-Latin (non-utf8) characters are encoded into special entities instead of being romanized.','tooltip'),
('adminonly','The field will only be displayed in Admin Dashboard.','tooltip'),
('api_push_access_key','Google Cloud Messaging (GCM) is a free service that enables developers to send messages between servers and client apps. This includes downstream messages from servers to client apps, and upstream messages from client apps to servers.','tooltip'),

('backup','Folder name where your DB backups are saved.','tooltip'),
('bcc_email','Email addresses to BCC all the outgoing messaging. To configure multiple emails, separate them by comma.','tooltip'),

('caching','If you use a slow shared hosting, this will cache your pages for faster loading.','tooltip'),

('empty_field','This text will be displayed on view item page if this field has an empty value.','tooltip'),
('extra_actions','This code is executed every time on field change. It can be used for validation or any other operation.','tooltip'),

('for_plan_only','Specifies if the field should be available only when plan chosen.','tooltip'),
('frontend_header_code','This code is inserted before closing HEAD tag. HTML/JS code allowed. (For example Google Analytics code)','tooltip'),
('frontend_footer_code','Injected before closing BODY tag. HTML/JS code allowed.','tooltip'),

('https','Use secure HTTPS protocol for your site. Before enabling this, please make sure you have properly configured your hosting account and/or webserver.','tooltip'),
('hybrid_enabled','Implements social signin on your website. You should configure API keys in includes/hybridauth.inc.php file.','tooltip'),

('lang','Select the preferred language of your site.','tooltip'),
('language_iso_code','ISO 639-1 two-letter lowercase abbreviation of your language. It is used in page URLs.','tooltip'),
('language_iso_title','This title is used for language selection on your frontend.','tooltip'),
('language_locale','Locale is an identifier used to get language, culture, or regionally-specific behavior. Contact your hosting to get the proper locale for your server.','tooltip'),
('language_switch','Allows users to choose a language on the frontend of your site.','tooltip'),

('mail_function','For better delivery, it\'s highly recommended to configure sending via SMTP.','tooltip'),
('members_enabled','Enables members functionality for your Subrion CMS based website.','tooltip'),
('members_autoapproval','Members are activated automatically without administrator confirmation (email confirmation is still needed).','tooltip'),
('multilingual_field','Allows to have field value in different languages.','tooltip'),
('multiple_selection','Allows to choose multiple nodes.','tooltip'),

('plan_cycles','Number of billing cycles for payment period.','tooltip'),
('plan_duration','Duration of plan (or each cycle if recurring)','tooltip'),

('regular_field','Specifies if the field is a host or dependent field.','tooltip'),
('required_checks','This PHP code validates the field value when Required Field is ON. Please make sure you use correct code.','tooltip'),

('search_instant','If enabled, the search will begin immediately once an option clicked.','tooltip'),
('searchable','Specifies if the field is available to search by on Advanced Search page.','tooltip'),
('site','This will be your site name.','tooltip'),
('site_email','All system correspondence is sent from this email address.','tooltip'),
('site_from_name','All system emails are from this name.','tooltip'),
('smarty_cache','Forces the template engine to rebuild the cache on every request. Increases the server load. It should only be used for debugging purposes.','tooltip'),
('smtp_debug_output','`echo` Output plain-text as-is, appropriate for CLI<br>`html` Output escaped, appropriate for browser output<br>`error_log` Output to error log as configured in php.ini','tooltip'),
('smtp_password','Password for the username above.','tooltip'),
('smtp_server','That would be Ex. (smtp.yourdomain.com)','tooltip'),
('smtp_user','Username is usually specified with your email/hosting provider.','tooltip'),
('suffix','This text is added to Title on every page.','tooltip'),

('timezone','Select your server timezone.','tooltip'),
('slug_literal','It\'s recommended to start your slug with letters.','tooltip'),

('underconstruction','This message is shown in case &quot;Display Frontend&quot; option is disabled.','tooltip'),
('upgrade_available','Upgrade patch to version :version is available. In order to upgrade please <a href=":url">follow this link</a>.','admin'),
('usergroup_assignable','Members are allowed to choose this group manually.','tooltip'),
('usergroup_visible','Group members are displayed on Members page and filters.','tooltip');

UPDATE `{install:prefix}language` SET `code`='{install:lang}',`original`=`value`;