-- 
-- Database: `sharise`
-- 

-- --------------------------------------------------------

-- 
-- Table structure for table `srbase_block_news`
-- 

CREATE TABLE `srbase_block_news` (
  `news_id` int(11) unsigned NOT NULL auto_increment,
  `login_id` int(11) unsigned NOT NULL default '0',
  `login_name` varchar(128) NOT NULL default 'Anonymous',
  `timestamp` int(11) unsigned NOT NULL default '0',
  `title` blob NOT NULL,
  `text` text NOT NULL,
  `active` tinyint(1) unsigned NOT NULL default '0',
  UNIQUE KEY `news_id` (`news_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `srbase_block_news`
-- 


-- --------------------------------------------------------

-- 
-- Table structure for table `srbase_block_sitelinks`
-- 

CREATE TABLE `srbase_block_sitelinks` (
  `link_id` int(11) unsigned NOT NULL auto_increment,
  `name` varchar(32) NOT NULL default '',
  `href` varchar(64) NOT NULL default '',
  `category` varchar(32) NOT NULL default 'Other',
  UNIQUE KEY `link_id` (`link_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `srbase_block_sitelinks`
-- 

INSERT INTO `srbase_block_sitelinks` VALUES (1, 'Logout', 'logout.php', 'Other');

-- --------------------------------------------------------

-- 
-- Table structure for table `srbase_challenge_record`
-- 

CREATE TABLE `srbase_challenge_record` (
  `chal_id` int(11) NOT NULL auto_increment,
  `sessid` varchar(64) NOT NULL default '',
  `challenge` varchar(64) NOT NULL default '',
  `timestamp` int(11) NOT NULL default '0',
  PRIMARY KEY  (`chal_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `srbase_challenge_record`
-- 


-- --------------------------------------------------------

-- 
-- Table structure for table `srbase_cms_blocks`
-- 

CREATE TABLE `srbase_cms_blocks` (
  `block_id` int(11) unsigned NOT NULL auto_increment,
  `file` varchar(128) NOT NULL default '',
  `position` varchar(32) NOT NULL default '',
  `priority` tinyint(4) unsigned NOT NULL default '0',
  `description` varchar(64) NOT NULL default '',
  `template` varchar(64) NOT NULL default '',
  `title` varchar(64) NOT NULL default 'untitled',
  `user_level` tinyint(1) unsigned NOT NULL default '5',
  `active` tinyint(1) unsigned NOT NULL default '0',
  `use_tpl` smallint(1) unsigned NOT NULL default '0',
  `static_html` text NOT NULL,
  `showtitle` tinyint(1) unsigned NOT NULL default '1',
  UNIQUE KEY `block_id` (`block_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `srbase_cms_blocks`
-- 

INSERT INTO `srbase_cms_blocks` VALUES (1, 'news.blk.php', 'center', 2, 'Displays a list of server news', 'news.tpl.html', 'News', 6, 1, 1, '', 0);
INSERT INTO `srbase_cms_blocks` VALUES (2, 'sitelinks.blk.php', 'left', 1, 'A menu of all site links', 'sitelinks.tpl.html', 'Menu', 6, 1, 1, '', 0);
INSERT INTO `srbase_cms_blocks` VALUES (3, 'login.blk.php', 'right', 1, 'A basic login block for M-H', 'login.tpl.html', 'Account Login', 6, 1, 1, '', 1);
INSERT INTO `srbase_cms_blocks` VALUES (4, '', 'center', 1, 'SR Gen Intro', '', 'Introduction', 6, 1, 0, '<div>\r\nShadows Rising RPG Game Engine will allow users to add items, classes, quests, NPCs and locations to create a custom RPG powered by the core engine. Includes the default Shadows Rising Game Module. Written with PHP, Javascript, MySQL/PostgreSQL and XHTML.\r\n</div>', 1);

-- --------------------------------------------------------

-- 
-- Table structure for table `srbase_cms_categories`
-- 

CREATE TABLE `srbase_cms_categories` (
  `category_id` int(11) unsigned NOT NULL auto_increment,
  `title` varchar(32) NOT NULL default 'untitled',
  `active` tinyint(1) unsigned NOT NULL default '1',
  `priority` tinyint(4) unsigned NOT NULL default '1',
  `user_level` tinyint(1) unsigned NOT NULL default '6',
  UNIQUE KEY `category_id` (`category_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `srbase_cms_categories`
-- 

INSERT INTO `srbase_cms_categories` VALUES (1, 'Other', 1, 255, 6);
INSERT INTO `srbase_cms_categories` VALUES (2, 'Administration', 1, 2, 3);
INSERT INTO `srbase_cms_categories` VALUES (3, 'Navigation', 1, 1, 6);

-- --------------------------------------------------------

-- 
-- Table structure for table `srbase_cms_modules`
-- 

CREATE TABLE `srbase_cms_modules` (
  `module_id` int(11) unsigned NOT NULL auto_increment,
  `active` tinyint(1) unsigned NOT NULL default '0',
  `user_level` tinyint(1) unsigned NOT NULL default '3',
  `directory` varchar(64) NOT NULL default 'unknown',
  `title` varchar(64) NOT NULL default 'untitled',
  `addonmenu` tinyint(1) unsigned NOT NULL default '1',
  `category` varchar(32) NOT NULL default 'Other',
  `showtitle` tinyint(1) unsigned NOT NULL default '1',
  UNIQUE KEY `module_id` (`module_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `srbase_cms_modules`
-- 

INSERT INTO `srbase_cms_modules` VALUES (1, 1, 6, 'Game_Index', 'Game Index', 1, 'Navigation', 1);
INSERT INTO `srbase_cms_modules` VALUES (3, 1, 6, 'User_Signup', 'User Signup', 1, 'Navigation', 1);
INSERT INTO `srbase_cms_modules` VALUES (4, 1, 3, 'Admin_Submit_News', 'Submit News', 1, 'Administration', 1);
INSERT INTO `srbase_cms_modules` VALUES (5, 1, 6, 'Login_Process', 'Login Process', 0, 'Other', 1);

-- --------------------------------------------------------

-- 
-- Table structure for table `srbase_forum_categories`
-- 

CREATE TABLE `srbase_forum_categories` (
  `cat_id` int(11) unsigned NOT NULL auto_increment,
  `cat_title` varchar(25) NOT NULL default '',
  PRIMARY KEY  (`cat_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `srbase_forum_categories`
-- 

INSERT INTO `srbase_forum_categories` VALUES (1, 'Test Category');

-- --------------------------------------------------------

-- 
-- Table structure for table `srbase_forum_config`
-- 

CREATE TABLE `srbase_forum_config` (
  `configname` varchar(50) NOT NULL default '',
  `configvalue` varchar(50) NOT NULL default '',
  `ingame` tinyint(3) NOT NULL default '-1',
  KEY `configname` (`configname`),
  KEY `configvalue` (`configvalue`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `srbase_forum_config`
-- 


-- --------------------------------------------------------

-- 
-- Table structure for table `srbase_forum_forums`
-- 

CREATE TABLE `srbase_forum_forums` (
  `forum_id` int(11) unsigned NOT NULL auto_increment,
  `cat_id` int(11) NOT NULL default '0',
  `forum_name` varchar(25) NOT NULL default '',
  `forum_desc` varchar(255) NOT NULL default '',
  `forum_posts` int(11) unsigned NOT NULL default '0',
  `forum_order` tinyint(3) unsigned NOT NULL default '0',
  `forum_status` tinyint(4) unsigned NOT NULL default '0',
  `ingame` tinyint(3) NOT NULL default '0',
  `location` int(11) unsigned NOT NULL default '1',
  PRIMARY KEY  (`forum_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `srbase_forum_forums`
-- 

INSERT INTO `srbase_forum_forums` VALUES (1, 1, 'Test Forum', 'A test forum', 1, 0, 0, -1, 0);
INSERT INTO `srbase_forum_forums` VALUES (2, -1, 'Test INGAME Forum', 'A test INGAME forum', 1, 0, 0, 1, 1);

-- --------------------------------------------------------

-- 
-- Table structure for table `srbase_forum_group_users`
-- 

CREATE TABLE `srbase_forum_group_users` (
  `group_id` int(11) unsigned NOT NULL default '0',
  `user_id` int(11) unsigned NOT NULL default '0',
  `group_leader` tinyint(1) unsigned NOT NULL default '0',
  KEY `group_id` (`group_id`),
  KEY `user_id` (`user_id`),
  KEY `group_leader` (`group_leader`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `srbase_forum_group_users`
-- 

INSERT INTO `srbase_forum_group_users` VALUES (1, 1, 0);

-- --------------------------------------------------------

-- 
-- Table structure for table `srbase_forum_groups`
-- 

CREATE TABLE `srbase_forum_groups` (
  `group_id` int(11) unsigned NOT NULL auto_increment,
  `group_name` varchar(25) NOT NULL default '',
  `group_desc` varchar(255) NOT NULL default '',
  `ingame` tinyint(3) NOT NULL default '-1',
  PRIMARY KEY  (`group_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `srbase_forum_groups`
-- 

INSERT INTO `srbase_forum_groups` VALUES (1, 'Users', 'Default user group for new users. It is a superglobal group', 0);

-- --------------------------------------------------------

-- 
-- Table structure for table `srbase_forum_perm_groups`
-- 

CREATE TABLE `srbase_forum_perm_groups` (
  `group_id` mediumint(8) unsigned NOT NULL default '0',
  `forum_id` mediumint(8) unsigned NOT NULL default '0',
  `perm_option` varchar(15) NOT NULL default '0',
  `perm_setting` tinyint(4) NOT NULL default '0',
  KEY `user_id` (`group_id`),
  KEY `auth_option_id` (`perm_option`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `srbase_forum_perm_groups`
-- 

INSERT INTO `srbase_forum_perm_groups` VALUES (0, 0, 'VIEW', 1);
INSERT INTO `srbase_forum_perm_groups` VALUES (0, 0, 'READ', 1);
INSERT INTO `srbase_forum_perm_groups` VALUES (0, 0, 'POST', 1);
INSERT INTO `srbase_forum_perm_groups` VALUES (0, 0, 'REPLY', 1);
INSERT INTO `srbase_forum_perm_groups` VALUES (0, 0, 'DELETE_OWN', 1);
INSERT INTO `srbase_forum_perm_groups` VALUES (0, 0, 'DELETE', 0);
INSERT INTO `srbase_forum_perm_groups` VALUES (0, 0, 'EDIT_OWN', 1);
INSERT INTO `srbase_forum_perm_groups` VALUES (0, 0, 'EDIT', 0);

-- --------------------------------------------------------

-- 
-- Table structure for table `srbase_forum_perm_users`
-- 

CREATE TABLE `srbase_forum_perm_users` (
  `user_id` mediumint(8) unsigned NOT NULL default '0',
  `forum_id` mediumint(8) unsigned NOT NULL default '0',
  `perm_option` varchar(15) NOT NULL default '',
  `perm_setting` tinyint(2) NOT NULL default '0',
  KEY `user_id` (`user_id`),
  KEY `auth_option_id` (`perm_option`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `srbase_forum_perm_users`
-- 

INSERT INTO `srbase_forum_perm_users` VALUES (0, 0, 'VIEW', 1);
INSERT INTO `srbase_forum_perm_users` VALUES (0, 0, 'READ', 1);
INSERT INTO `srbase_forum_perm_users` VALUES (0, 0, 'POST', 1);
INSERT INTO `srbase_forum_perm_users` VALUES (0, 0, 'REPLY', 1);
INSERT INTO `srbase_forum_perm_users` VALUES (0, 0, 'DELETE_OWN', 1);
INSERT INTO `srbase_forum_perm_users` VALUES (0, 0, 'DELETE', 0);
INSERT INTO `srbase_forum_perm_users` VALUES (0, 0, 'EDIT_OWN', 1);
INSERT INTO `srbase_forum_perm_users` VALUES (0, 0, 'EDIT', 0);

-- --------------------------------------------------------

-- 
-- Table structure for table `srbase_forum_posts`
-- 

CREATE TABLE `srbase_forum_posts` (
  `post_id` int(11) unsigned NOT NULL auto_increment,
  `topic_id` int(11) unsigned NOT NULL default '0',
  `post_time` int(11) unsigned NOT NULL default '0',
  `post_poster` int(11) NOT NULL default '0',
  `post_title` varchar(25) NOT NULL default '',
  `post_message` text NOT NULL,
  `post_reported` tinyint(1) NOT NULL default '0',
  `post_poll` int(11) NOT NULL default '0',
  PRIMARY KEY  (`post_id`),
  KEY `post_poll` (`post_poll`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `srbase_forum_posts`
-- 

INSERT INTO `srbase_forum_posts` VALUES (1, 1, 555496413, 1, 'Test Post', 'Test Post', 0, 0);
INSERT INTO `srbase_forum_posts` VALUES (2, 2, 555496413, 1, 'Test ingame Post', 'This is a test ingame post', 0, 0);
INSERT INTO `srbase_forum_posts` VALUES (3, 2, 555496500, 1, 'Bump', 'This is a test ingame, reported bump', 1, 0);

-- --------------------------------------------------------

-- 
-- Table structure for table `srbase_forum_privmsgs`
-- 

CREATE TABLE `srbase_forum_privmsgs` (
  `privmsg_id` int(11) unsigned NOT NULL auto_increment,
  `privmsg_title` varchar(25) NOT NULL default '',
  `privmsg_text` text NOT NULL,
  `privmsg_time` int(11) NOT NULL default '0',
  `privmsg_read` tinyint(1) NOT NULL default '0',
  `privmsg_replied` tinyint(1) NOT NULL default '0',
  `privmsg_from` int(11) NOT NULL default '0',
  `privmsg_to` int(11) NOT NULL default '0',
  `ingame` tinyint(3) NOT NULL default '-1',
  PRIMARY KEY  (`privmsg_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `srbase_forum_privmsgs`
-- 


-- --------------------------------------------------------

-- 
-- Table structure for table `srbase_forum_topics`
-- 

CREATE TABLE `srbase_forum_topics` (
  `topic_id` int(11) unsigned NOT NULL auto_increment,
  `forum_id` int(11) unsigned NOT NULL default '0',
  `topic_title` varchar(25) NOT NULL default '',
  `topic_starter` int(11) NOT NULL default '0',
  `topic_views` int(11) NOT NULL default '0',
  `topic_posts` int(11) NOT NULL default '0',
  `topic_firstpost` int(11) NOT NULL default '0',
  `topic_lastpost` int(11) NOT NULL default '0',
  `topic_type` tinyint(2) NOT NULL default '0',
  PRIMARY KEY  (`topic_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `srbase_forum_topics`
-- 

INSERT INTO `srbase_forum_topics` VALUES (1, 1, 'A test topic', 1, 0, 1, 1, 1, 0);
INSERT INTO `srbase_forum_topics` VALUES (2, 2, 'Test INGAME Topic', 1, 0, 2, 2, 3, 0);

-- --------------------------------------------------------

-- 
-- Table structure for table `srbase_game_index`
-- 

CREATE TABLE `srbase_game_index` (
  `game_id` tinyint(4) unsigned NOT NULL auto_increment,
  `admin_list` text NOT NULL,
  `module_id` tinyint(4) unsigned NOT NULL default '0',
  `module` varchar(64) NOT NULL default '',
  `instance` varchar(32) NOT NULL default '',
  `hidden` tinyint(1) unsigned NOT NULL default '0',
  `paused` tinyint(1) unsigned NOT NULL default '1',
  `rejoin_delay` int(11) unsigned NOT NULL default '5000',
  `name` varchar(32) NOT NULL default '',
  `start_date` int(11) unsigned NOT NULL default '0',
  `description` text NOT NULL,
  `mp_name` varchar(128) NOT NULL default 'default',
  `gamestart` int(11) unsigned NOT NULL default '1',
  UNIQUE KEY `game_id` (`game_id`,`instance`,`name`),
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `srbase_game_index`
-- 

INSERT INTO `srbase_game_index` VALUES (1, '1', 1, 'srmodule', 'srrpg', 0, 1, 5000, 'Shadows Rising RPG', 0, 'This game utilies the default Shadows Rising RPG module. The Shadows Rising RPG is a fantasy epic where players explore a mysterious world. (In Testing!)', 'default', 1);

-- --------------------------------------------------------

-- 
-- Table structure for table `srbase_permissions`
-- 

CREATE TABLE `srbase_permissions` (
  `user_id` mediumint(8) unsigned NOT NULL default '0',
  `perm_option` varchar(15) NOT NULL default '',
  `perm_setting` tinyint(2) NOT NULL default '0',
  KEY `user_id` (`user_id`),
  KEY `auth_option_id` (`perm_option`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `srbase_permissions`
-- 


-- --------------------------------------------------------

-- 
-- Table structure for table `srbase_srmodule_classes`
-- 

CREATE TABLE `srbase_srmodule_classes` (
  `class_id` int(11) unsigned NOT NULL auto_increment,
  `name` varchar(64) NOT NULL default '',
  `description` text NOT NULL,
  `start_hp` int(11) unsigned NOT NULL default '0',
  `level_details` text NOT NULL,
  `hp_increment` tinyint(2) unsigned NOT NULL default '10',
  `skill_increment` tinyint(2) unsigned NOT NULL default '1',
  `firstlevel_skill_multiplier` tinyint(2) unsigned NOT NULL default '0',
  UNIQUE KEY `class_id` (`class_id`,`name`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `srbase_srmodule_classes`
-- 

INSERT INTO `srbase_srmodule_classes` VALUES (1, 'Fighter', 'Fighter live for one thing only - to fight. Whether in wars, mercenary jobs or bar brawls, these are the last people you ever want to encounter!', 20, 'a:20:{i:1;a:5:{s:17:"base_attack_bonus";s:1:"1";s:9:"fort_save";s:1:"2";s:8:"ref_save";s:1:"0";s:9:"will_save";s:1:"0";s:5:"feats";s:6:"true|2";}i:2;a:5:{s:17:"base_attack_bonus";s:1:"2";s:9:"fort_save";s:1:"3";s:8:"ref_save";s:1:"0";s:9:"will_save";s:1:"0";s:5:"feats";s:6:"true|2";}i:3;a:5:{s:17:"base_attack_bonus";s:1:"3";s:9:"fort_save";s:1:"3";s:8:"ref_save";s:1:"1";s:9:"will_save";s:1:"1";s:5:"feats";s:7:"false|0";}i:4;a:5:{s:17:"base_attack_bonus";s:1:"4";s:9:"fort_save";s:1:"4";s:8:"ref_save";s:1:"1";s:9:"will_save";s:1:"1";s:5:"feats";s:6:"true|2";}i:5;a:5:{s:17:"base_attack_bonus";s:1:"5";s:9:"fort_save";s:1:"4";s:8:"ref_save";s:1:"1";s:9:"will_save";s:1:"1";s:5:"feats";s:7:"false|0";}i:6;a:5:{s:17:"base_attack_bonus";s:1:"6";s:9:"fort_save";s:1:"5";s:8:"ref_save";s:1:"2";s:9:"will_save";s:1:"2";s:5:"feats";s:6:"true|2";}i:7;a:5:{s:17:"base_attack_bonus";s:1:"7";s:9:"fort_save";s:1:"5";s:8:"ref_save";s:1:"2";s:9:"will_save";s:1:"2";s:5:"feats";s:7:"false|0";}i:8;a:5:{s:17:"base_attack_bonus";s:1:"8";s:9:"fort_save";s:1:"6";s:8:"ref_save";s:1:"2";s:9:"will_save";s:1:"2";s:5:"feats";s:7:"false|0";}i:9;a:5:{s:17:"base_attack_bonus";s:1:"9";s:9:"fort_save";s:1:"6";s:8:"ref_save";s:1:"3";s:9:"will_save";s:1:"3";s:5:"feats";s:7:"false|0";}i:10;a:5:{s:17:"base_attack_bonus";s:2:"10";s:9:"fort_save";s:1:"7";s:8:"ref_save";s:1:"3";s:9:"will_save";s:1:"3";s:5:"feats";s:7:"false|0";}i:11;a:5:{s:17:"base_attack_bonus";s:2:"11";s:9:"fort_save";s:1:"7";s:8:"ref_save";s:1:"3";s:9:"will_save";s:1:"3";s:5:"feats";s:6:"true|2";}i:12;a:5:{s:17:"base_attack_bonus";s:2:"12";s:9:"fort_save";s:1:"8";s:8:"ref_save";s:1:"4";s:9:"will_save";s:1:"4";s:5:"feats";s:7:"false|0";}i:13;a:5:{s:17:"base_attack_bonus";s:2:"13";s:9:"fort_save";s:1:"8";s:8:"ref_save";s:1:"4";s:9:"will_save";s:1:"4";s:5:"feats";s:6:"true|2";}i:14;a:5:{s:17:"base_attack_bonus";s:2:"14";s:9:"fort_save";s:1:"9";s:8:"ref_save";s:1:"4";s:9:"will_save";s:1:"4";s:5:"feats";s:7:"false|0";}i:15;a:5:{s:17:"base_attack_bonus";s:2:"15";s:9:"fort_save";s:1:"9";s:8:"ref_save";s:1:"5";s:9:"will_save";s:1:"5";s:5:"feats";s:6:"true|2";}i:16;a:5:{s:17:"base_attack_bonus";s:2:"16";s:9:"fort_save";s:2:"10";s:8:"ref_save";s:1:"5";s:9:"will_save";s:1:"5";s:5:"feats";s:7:"false|0";}i:17;a:5:{s:17:"base_attack_bonus";s:2:"17";s:9:"fort_save";s:2:"10";s:8:"ref_save";s:1:"5";s:9:"will_save";s:1:"5";s:5:"feats";s:6:"true|2";}i:18;a:5:{s:17:"base_attack_bonus";s:2:"18";s:9:"fort_save";s:2:"11";s:8:"ref_save";s:1:"6";s:9:"will_save";s:1:"6";s:5:"feats";s:7:"false|0";}i:19;a:5:{s:17:"base_attack_bonus";s:2:"19";s:9:"fort_save";s:2:"11";s:8:"ref_save";s:1:"6";s:9:"will_save";s:1:"6";s:5:"feats";s:7:"false|0";}i:20;a:5:{s:17:"base_attack_bonus";s:2:"20";s:9:"fort_save";s:2:"12";s:8:"ref_save";s:1:"6";s:9:"will_save";s:1:"6";s:5:"feats";s:6:"true|2";}}', 10, 2, 4);
INSERT INTO `srbase_srmodule_classes` VALUES (2, 'Wizard', 'Wizards are masters of structured magic. Their powers are generated through often complex spells and enchanted items. Generally weaker than more muscle-bound classes, although Generals are rarely stupid enough to go to war without at least one.', 10, 'a:20:{i:1;a:5:{s:17:"base_attack_bonus";s:1:"0";s:9:"fort_save";s:1:"0";s:8:"ref_save";s:1:"0";s:9:"will_save";s:1:"2";s:5:"feats";s:7:"false|0";}i:2;a:5:{s:17:"base_attack_bonus";s:1:"1";s:9:"fort_save";s:1:"0";s:8:"ref_save";s:1:"0";s:9:"will_save";s:1:"3";s:5:"feats";s:7:"false|0";}i:3;a:5:{s:17:"base_attack_bonus";s:1:"1";s:9:"fort_save";s:1:"1";s:8:"ref_save";s:1:"1";s:9:"will_save";s:1:"3";s:5:"feats";s:7:"false|0";}i:4;a:5:{s:17:"base_attack_bonus";s:1:"2";s:9:"fort_save";s:1:"1";s:8:"ref_save";s:1:"1";s:9:"will_save";s:1:"4";s:5:"feats";s:7:"false|0";}i:5;a:5:{s:17:"base_attack_bonus";s:1:"2";s:9:"fort_save";s:1:"1";s:8:"ref_save";s:1:"1";s:9:"will_save";s:1:"4";s:5:"feats";s:6:"true|1";}i:6;a:5:{s:17:"base_attack_bonus";s:1:"3";s:9:"fort_save";s:1:"2";s:8:"ref_save";s:1:"2";s:9:"will_save";s:1:"5";s:5:"feats";s:7:"false|0";}i:7;a:5:{s:17:"base_attack_bonus";s:1:"3";s:9:"fort_save";s:1:"2";s:8:"ref_save";s:1:"2";s:9:"will_save";s:1:"5";s:5:"feats";s:7:"false|0";}i:8;a:5:{s:17:"base_attack_bonus";s:1:"4";s:9:"fort_save";s:1:"2";s:8:"ref_save";s:1:"2";s:9:"will_save";s:1:"6";s:5:"feats";s:7:"false|0";}i:9;a:5:{s:17:"base_attack_bonus";s:1:"4";s:9:"fort_save";s:1:"3";s:8:"ref_save";s:1:"3";s:9:"will_save";s:1:"6";s:5:"feats";s:7:"false|0";}i:10;a:5:{s:17:"base_attack_bonus";s:1:"5";s:9:"fort_save";s:1:"3";s:8:"ref_save";s:1:"3";s:9:"will_save";s:1:"7";s:5:"feats";s:6:"true|1";}i:11;a:5:{s:17:"base_attack_bonus";s:1:"5";s:9:"fort_save";s:1:"3";s:8:"ref_save";s:1:"3";s:9:"will_save";s:1:"7";s:5:"feats";s:7:"false|0";}i:12;a:5:{s:17:"base_attack_bonus";s:1:"6";s:9:"fort_save";s:1:"4";s:8:"ref_save";s:1:"4";s:9:"will_save";s:1:"8";s:5:"feats";s:7:"false|0";}i:13;a:5:{s:17:"base_attack_bonus";s:1:"6";s:9:"fort_save";s:1:"4";s:8:"ref_save";s:1:"4";s:9:"will_save";s:1:"8";s:5:"feats";s:7:"false|0";}i:14;a:5:{s:17:"base_attack_bonus";s:1:"7";s:9:"fort_save";s:1:"4";s:8:"ref_save";s:1:"4";s:9:"will_save";s:1:"9";s:5:"feats";s:7:"false|0";}i:15;a:5:{s:17:"base_attack_bonus";s:1:"7";s:9:"fort_save";s:1:"5";s:8:"ref_save";s:1:"5";s:9:"will_save";s:1:"9";s:5:"feats";s:6:"true|1";}i:16;a:5:{s:17:"base_attack_bonus";s:1:"8";s:9:"fort_save";s:1:"5";s:8:"ref_save";s:1:"5";s:9:"will_save";s:2:"10";s:5:"feats";s:7:"false|0";}i:17;a:5:{s:17:"base_attack_bonus";s:1:"8";s:9:"fort_save";s:1:"5";s:8:"ref_save";s:1:"5";s:9:"will_save";s:2:"10";s:5:"feats";s:7:"false|0";}i:18;a:5:{s:17:"base_attack_bonus";s:1:"9";s:9:"fort_save";s:1:"6";s:8:"ref_save";s:1:"6";s:9:"will_save";s:2:"11";s:5:"feats";s:7:"false|0";}i:19;a:5:{s:17:"base_attack_bonus";s:1:"9";s:9:"fort_save";s:1:"6";s:8:"ref_save";s:1:"6";s:9:"will_save";s:2:"11";s:5:"feats";s:7:"false|0";}i:20;a:5:{s:17:"base_attack_bonus";s:2:"10";s:9:"fort_save";s:1:"6";s:8:"ref_save";s:1:"6";s:9:"will_save";s:2:"12";s:5:"feats";s:6:"true|1";}}', 5, 2, 2);

-- --------------------------------------------------------

-- 
-- Table structure for table `srbase_srmodule_creatures`
-- 

CREATE TABLE `srbase_srmodule_creatures` (
  `creature_id` int(11) unsigned NOT NULL auto_increment,
  `access_flag` tinyint(1) unsigned NOT NULL default '1',
  `name` varchar(64) NOT NULL default 'Unidentified Menace',
  `description` text NOT NULL,
  `encounter_level` tinyint(2) unsigned NOT NULL default '1',
  `level` tinyint(2) unsigned NOT NULL default '1',
  `size` varchar(16) NOT NULL default 'Medium',
  `type` varchar(16) NOT NULL default 'Normal',
  `health` int(11) unsigned NOT NULL default '10',
  `armour_class` int(11) unsigned NOT NULL default '0',
  `weapon_id` int(11) unsigned NOT NULL default '0',
  `armour_id` int(11) unsigned NOT NULL default '0',
  `str` tinyint(3) unsigned NOT NULL default '0',
  `dex` tinyint(3) unsigned NOT NULL default '0',
  `con` tinyint(3) unsigned NOT NULL default '0',
  `intel` tinyint(3) unsigned NOT NULL default '0',
  `wis` tinyint(3) unsigned NOT NULL default '0',
  `cha` tinyint(3) unsigned NOT NULL default '0',
  UNIQUE KEY `creature_id` (`creature_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `srbase_srmodule_creatures`
-- 

INSERT INTO `srbase_srmodule_creatures` VALUES (1, 1, 'Giant Kangaroo', 'A fairly common irritation on the plains of Nemedia - approach carefully as these creatures use a mystical combat technique termed kickpunching...', 1, 1, 'Large', 'Normal', 25, 0, 0, 0, 10, 5, 5, 2, 2, 2);

-- --------------------------------------------------------

-- 
-- Table structure for table `srbase_srmodule_items`
-- 

CREATE TABLE `srbase_srmodule_items` (
  `item_id` int(11) unsigned NOT NULL default '0',
  `type` varchar(32) NOT NULL default 'miscellaneous',
  `name` varchar(64) NOT NULL default 'Unidentified',
  `description` text NOT NULL,
  `level` tinyint(4) unsigned NOT NULL default '1',
  `cost` int(11) unsigned NOT NULL default '10',
  `weight` tinyint(4) unsigned NOT NULL default '1',
  `class_special` tinyint(4) unsigned NOT NULL default '0',
  `alignment` varchar(7) NOT NULL default 'neutral',
  `equip_penalty` varchar(4) NOT NULL default 'none',
  `penalty_amount` tinyint(4) unsigned NOT NULL default '0',
  `max_damage` tinyint(4) unsigned NOT NULL default '0',
  `min_critical` tinyint(4) unsigned NOT NULL default '0',
  `max_critical` tinyint(4) unsigned NOT NULL default '0',
  `critical_multiplier` tinyint(4) unsigned NOT NULL default '0',
  `handle` varchar(32) NOT NULL default 'single',
  UNIQUE KEY `item_id` (`item_id`,`name`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `srbase_srmodule_items`
-- 

INSERT INTO `srbase_srmodule_items` VALUES (1, 'weapon', 'Ancient Rusty Dagger', 'Found buried in the thatch of a 90 year old Human''s hut, this Ancient Rusty Dagger has seen better days than today!', 1, 10, 1, 0, 'neutral', 'none', 0, 4, 19, 20, 2, 'single');
INSERT INTO `srbase_srmodule_items` VALUES (2, 'weapon', 'Cracked Wooden Staff', 'Looks like that 90 year-old Human kept a few ill-kept weapons in his thatch!', 1, 10, 1, 0, 'neutral', 'none', 0, 6, 19, 20, 3, 'double');

-- --------------------------------------------------------

-- 
-- Table structure for table `srbase_srmodule_items_belts`
-- 

CREATE TABLE `srbase_srmodule_items_belts` (
  `item_id` int(11) unsigned NOT NULL default '0',
  `type` varchar(32) NOT NULL default 'miscellaneous',
  `name` varchar(64) NOT NULL default 'Unidentified',
  `description` text NOT NULL,
  `level` tinyint(4) unsigned NOT NULL default '1',
  `cost` int(11) unsigned NOT NULL default '10',
  `weight` tinyint(4) unsigned NOT NULL default '1',
  `class_special` tinyint(4) unsigned NOT NULL default '0',
  `alignment` varchar(7) NOT NULL default 'neutral',
  `equip_penalty` varchar(4) NOT NULL default 'none',
  `penalty_amount` tinyint(4) unsigned NOT NULL default '0',
  `effect` varchar(32) NOT NULL default 'nothing',
  `effect_type` varchar(32) NOT NULL default 'none',
  `effect_amount` tinyint(2) unsigned NOT NULL default '0',
  UNIQUE KEY `item_id` (`item_id`,`name`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `srbase_srmodule_items_belts`
-- 

INSERT INTO `srbase_srmodule_items_belts` VALUES (1, 'belt', 'Old Mans Belt', 'Yet another artifact from everyones favourite human - his old leather belt!', 1, 15, 1, 0, 'neutral', 'none', 0, 'attribute', 'con', 1);

-- --------------------------------------------------------

-- 
-- Table structure for table `srbase_srmodule_items_bracers`
-- 

CREATE TABLE `srbase_srmodule_items_bracers` (
  `item_id` int(11) unsigned NOT NULL default '0',
  `type` varchar(32) NOT NULL default 'miscellaneous',
  `name` varchar(64) NOT NULL default 'Unidentified',
  `description` text NOT NULL,
  `level` tinyint(4) unsigned NOT NULL default '1',
  `cost` int(11) unsigned NOT NULL default '10',
  `weight` tinyint(4) unsigned NOT NULL default '1',
  `class_special` tinyint(4) unsigned NOT NULL default '0',
  `alignment` varchar(7) NOT NULL default 'neutral',
  `equip_penalty` varchar(4) NOT NULL default 'none',
  `penalty_amount` tinyint(4) unsigned NOT NULL default '0',
  `effect` varchar(32) NOT NULL default 'nothing',
  `effect_type` varchar(32) NOT NULL default 'none',
  `effect_amount` tinyint(2) unsigned NOT NULL default '0',
  UNIQUE KEY `item_id` (`item_id`,`name`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `srbase_srmodule_items_bracers`
-- 

INSERT INTO `srbase_srmodule_items_bracers` VALUES (1, 'bracer', 'Leather Bracers', 'Serviceable if not exactly polished new - these bracers offer some protection against damage to your forearms.', 1, 45, 1, 0, 'neutral', 'none', 0, 'armour', 'natural', 1);

-- --------------------------------------------------------

-- 
-- Table structure for table `srbase_srmodule_items_cloaks`
-- 

CREATE TABLE `srbase_srmodule_items_cloaks` (
  `item_id` int(11) unsigned NOT NULL default '0',
  `type` varchar(32) NOT NULL default 'miscellaneous',
  `name` varchar(64) NOT NULL default 'Unidentified',
  `description` text NOT NULL,
  `level` tinyint(4) unsigned NOT NULL default '1',
  `cost` int(11) unsigned NOT NULL default '10',
  `weight` tinyint(4) unsigned NOT NULL default '1',
  `class_special` tinyint(4) unsigned NOT NULL default '0',
  `alignment` varchar(7) NOT NULL default 'neutral',
  `equip_penalty` varchar(4) NOT NULL default 'none',
  `penalty_amount` tinyint(4) unsigned NOT NULL default '0',
  `effect` varchar(32) NOT NULL default 'nothing',
  `effect_type` varchar(32) NOT NULL default 'none',
  `effect_amount` tinyint(2) unsigned NOT NULL default '0',
  UNIQUE KEY `item_id` (`item_id`,`name`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `srbase_srmodule_items_cloaks`
-- 

INSERT INTO `srbase_srmodule_items_cloaks` VALUES (1, 'cloak', 'Cloak of the Acrobats', 'Purchased from a Bard who claimed he needed the gold to retire, he depended on this cloak to perform amazing acrobatic feats.', 1, 75, 1, 0, 'neutral', 'none', 0, 'attribute', 'dex', 1);

-- --------------------------------------------------------

-- 
-- Table structure for table `srbase_srmodule_items_drugs`
-- 

CREATE TABLE `srbase_srmodule_items_drugs` (
  `item_id` int(11) unsigned NOT NULL default '0',
  `type` varchar(32) NOT NULL default 'miscellaneous',
  `name` varchar(64) NOT NULL default 'Unidentified',
  `description` text NOT NULL,
  `level` tinyint(4) unsigned NOT NULL default '1',
  `cost` int(11) unsigned NOT NULL default '10',
  `weight` tinyint(4) unsigned NOT NULL default '1',
  `class_special` tinyint(4) unsigned NOT NULL default '0',
  `effect` varchar(32) NOT NULL default 'nothing',
  `effect_type` varchar(32) NOT NULL default 'none',
  `effect_amount` tinyint(2) NOT NULL default '0',
  `physical` varchar(32) NOT NULL default 'nothing',
  `physical_amount` tinyint(2) NOT NULL default '0',
  UNIQUE KEY `item_id` (`item_id`,`name`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `srbase_srmodule_items_drugs`
-- 

INSERT INTO `srbase_srmodule_items_drugs` VALUES (1, 'health', 'Lesser Healing Potion', 'The Lesser Healing Potion is a simple (and cheap) herbal remedy commonly used across Nemedia. The effect of the potion is to restore up to 10 health points.', 1, 12, 1, 0, 'nothing', 'none', 0, 'health', 10);

-- --------------------------------------------------------

-- 
-- Table structure for table `srbase_srmodule_items_gauntlets`
-- 

CREATE TABLE `srbase_srmodule_items_gauntlets` (
  `item_id` int(11) unsigned NOT NULL default '0',
  `type` varchar(32) NOT NULL default 'miscellaneous',
  `name` varchar(64) NOT NULL default 'Unidentified',
  `description` text NOT NULL,
  `level` tinyint(4) unsigned NOT NULL default '1',
  `cost` int(11) unsigned NOT NULL default '10',
  `weight` tinyint(4) unsigned NOT NULL default '1',
  `class_special` tinyint(4) unsigned NOT NULL default '0',
  `alignment` varchar(7) NOT NULL default 'neutral',
  `equip_penalty` varchar(4) NOT NULL default 'none',
  `penalty_amount` tinyint(4) unsigned NOT NULL default '0',
  `effect` varchar(32) NOT NULL default 'nothing',
  `effect_type` varchar(32) NOT NULL default 'none',
  `effect_amount` tinyint(2) unsigned NOT NULL default '0',
  UNIQUE KEY `item_id` (`item_id`,`name`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `srbase_srmodule_items_gauntlets`
-- 


-- --------------------------------------------------------

-- 
-- Table structure for table `srbase_srmodule_items_headgear`
-- 

CREATE TABLE `srbase_srmodule_items_headgear` (
  `item_id` int(11) unsigned NOT NULL default '0',
  `type` varchar(32) NOT NULL default 'miscellaneous',
  `name` varchar(64) NOT NULL default 'Unidentified',
  `description` text NOT NULL,
  `level` tinyint(4) unsigned NOT NULL default '1',
  `cost` int(11) unsigned NOT NULL default '10',
  `weight` tinyint(4) unsigned NOT NULL default '1',
  `class_special` tinyint(4) unsigned NOT NULL default '0',
  `alignment` varchar(7) NOT NULL default 'neutral',
  `equip_penalty` varchar(4) NOT NULL default 'none',
  `penalty_amount` tinyint(4) unsigned NOT NULL default '0',
  `effect` varchar(32) NOT NULL default 'nothing',
  `effect_type` varchar(32) NOT NULL default 'none',
  `effect_amount` tinyint(2) unsigned NOT NULL default '0',
  UNIQUE KEY `item_id` (`item_id`,`name`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `srbase_srmodule_items_headgear`
-- 


-- --------------------------------------------------------

-- 
-- Table structure for table `srbase_srmodule_items_neckwear`
-- 

CREATE TABLE `srbase_srmodule_items_neckwear` (
  `item_id` int(11) unsigned NOT NULL default '0',
  `type` varchar(32) NOT NULL default 'miscellaneous',
  `name` varchar(64) NOT NULL default 'Unidentified',
  `description` text NOT NULL,
  `level` tinyint(4) unsigned NOT NULL default '1',
  `cost` int(11) unsigned NOT NULL default '10',
  `weight` tinyint(4) unsigned NOT NULL default '1',
  `class_special` tinyint(4) unsigned NOT NULL default '0',
  `alignment` varchar(7) NOT NULL default 'neutral',
  `equip_penalty` varchar(4) NOT NULL default 'none',
  `penalty_amount` tinyint(4) unsigned NOT NULL default '0',
  `effect` varchar(32) NOT NULL default 'nothing',
  `effect_type` varchar(32) NOT NULL default 'none',
  `effect_amount` tinyint(2) unsigned NOT NULL default '0',
  UNIQUE KEY `item_id` (`item_id`,`name`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `srbase_srmodule_items_neckwear`
-- 


-- --------------------------------------------------------

-- 
-- Table structure for table `srbase_srmodule_items_rings`
-- 

CREATE TABLE `srbase_srmodule_items_rings` (
  `item_id` int(11) unsigned NOT NULL default '0',
  `type` varchar(32) NOT NULL default 'miscellaneous',
  `name` varchar(64) NOT NULL default 'Unidentified',
  `description` text NOT NULL,
  `level` tinyint(4) unsigned NOT NULL default '1',
  `cost` int(11) unsigned NOT NULL default '10',
  `weight` tinyint(4) unsigned NOT NULL default '1',
  `class_special` tinyint(4) unsigned NOT NULL default '0',
  `alignment` varchar(7) NOT NULL default 'neutral',
  `equip_penalty` varchar(4) NOT NULL default 'none',
  `penalty_amount` tinyint(4) unsigned NOT NULL default '0',
  `effect` varchar(32) NOT NULL default 'nothing',
  `effect_type` varchar(32) NOT NULL default 'none',
  `effect_amount` tinyint(2) unsigned NOT NULL default '0',
  UNIQUE KEY `item_id` (`item_id`,`name`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `srbase_srmodule_items_rings`
-- 

INSERT INTO `srbase_srmodule_items_rings` VALUES (1, 'ring', 'Ring of Strength', 'A common enough item employed by the Fighter Class in particular. This ring increases a character\\''s strength and therefore damage dealt by any weapon.', 1, 50, 1, 0, 'neutral', 'none', 0, 'attribute', 'str', 1);

-- --------------------------------------------------------

-- 
-- Table structure for table `srbase_srmodule_items_texts`
-- 

CREATE TABLE `srbase_srmodule_items_texts` (
  `item_id` int(11) unsigned NOT NULL default '0',
  `type` varchar(32) NOT NULL default 'miscellaneous',
  `name` varchar(64) NOT NULL default 'Unidentified',
  `description` text NOT NULL,
  `level` tinyint(4) unsigned NOT NULL default '1',
  `cost` int(11) unsigned NOT NULL default '10',
  `weight` tinyint(4) unsigned NOT NULL default '1',
  `class_special` tinyint(4) unsigned NOT NULL default '0',
  UNIQUE KEY `item_id` (`item_id`,`name`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `srbase_srmodule_items_texts`
-- 


-- --------------------------------------------------------

-- 
-- Table structure for table `srbase_srmodule_items_tools`
-- 

CREATE TABLE `srbase_srmodule_items_tools` (
  `item_id` int(11) unsigned NOT NULL default '0',
  `type` varchar(32) NOT NULL default 'miscellaneous',
  `name` varchar(64) NOT NULL default 'Unidentified',
  `description` text NOT NULL,
  `level` tinyint(4) unsigned NOT NULL default '1',
  `cost` int(11) unsigned NOT NULL default '10',
  `weight` tinyint(4) unsigned NOT NULL default '1',
  `class_special` tinyint(4) unsigned NOT NULL default '0',
  `skill_id` int(11) unsigned NOT NULL default '0',
  `skill_amount` tinyint(2) unsigned NOT NULL default '0',
  UNIQUE KEY `item_id` (`item_id`,`name`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `srbase_srmodule_items_tools`
-- 


-- --------------------------------------------------------

-- 
-- Table structure for table `srbase_srmodule_items_weapons`
-- 

CREATE TABLE `srbase_srmodule_items_weapons` (
  `item_id` int(11) unsigned NOT NULL default '0',
  `type` varchar(32) NOT NULL default 'miscellaneous',
  `name` varchar(64) NOT NULL default 'Unidentified',
  `description` text NOT NULL,
  `level` tinyint(4) unsigned NOT NULL default '1',
  `cost` int(11) unsigned NOT NULL default '10',
  `weight` tinyint(4) unsigned NOT NULL default '1',
  `class_special` tinyint(4) unsigned NOT NULL default '0',
  `alignment` varchar(7) NOT NULL default 'neutral',
  `equip_penalty` varchar(4) NOT NULL default 'none',
  `penalty_amount` tinyint(4) unsigned NOT NULL default '0',
  `max_damage` tinyint(4) unsigned NOT NULL default '0',
  `min_critical` tinyint(4) unsigned NOT NULL default '0',
  `max_critical` tinyint(4) unsigned NOT NULL default '0',
  `critical_multiplier` tinyint(4) unsigned NOT NULL default '0',
  `handle` varchar(32) NOT NULL default 'single',
  UNIQUE KEY `item_id` (`item_id`,`name`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `srbase_srmodule_items_weapons`
-- 

INSERT INTO `srbase_srmodule_items_weapons` VALUES (1, 'weapon', 'Ancient Rusty Dagger', 'Found buried in the thatch of a 90 year old Humans hut, this Ancient Rusty Dagger has seen better days than today!', 1, 10, 1, 0, 'neutral', 'none', 0, 4, 19, 20, 2, 'single');
INSERT INTO `srbase_srmodule_items_weapons` VALUES (2, 'weapon', 'Cracked Wooden Staff', 'Looks like that 90 year-old Human kept a few ill-kept weapons in his thatch!', 1, 10, 1, 0, 'neutral', 'none', 0, 6, 19, 20, 3, 'double');

-- --------------------------------------------------------

-- 
-- Table structure for table `srbase_srmodule_itemtypes`
-- 

CREATE TABLE `srbase_srmodule_itemtypes` (
  `type_id` int(11) unsigned NOT NULL auto_increment,
  `type` varchar(32) NOT NULL default '',
  `db_postfix` varchar(32) NOT NULL default 'misc',
  UNIQUE KEY `type_id` (`type_id`,`type`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `srbase_srmodule_itemtypes`
-- 

INSERT INTO `srbase_srmodule_itemtypes` VALUES (1, 'weapon', 'weapons');
INSERT INTO `srbase_srmodule_itemtypes` VALUES (2, 'amulet', 'neckwear');
INSERT INTO `srbase_srmodule_itemtypes` VALUES (3, 'belt', 'belts');
INSERT INTO `srbase_srmodule_itemtypes` VALUES (4, 'bracer', 'bracers');
INSERT INTO `srbase_srmodule_itemtypes` VALUES (5, 'cloak', 'cloaks');
INSERT INTO `srbase_srmodule_itemtypes` VALUES (6, 'gauntlet', 'gauntlets');
INSERT INTO `srbase_srmodule_itemtypes` VALUES (7, 'drug', 'drugs');
INSERT INTO `srbase_srmodule_itemtypes` VALUES (8, 'headgear', 'headgear');
INSERT INTO `srbase_srmodule_itemtypes` VALUES (9, 'ring', 'rings');
INSERT INTO `srbase_srmodule_itemtypes` VALUES (10, 'tool', 'tools');
INSERT INTO `srbase_srmodule_itemtypes` VALUES (11, 'text', 'texts');

-- --------------------------------------------------------

-- 
-- Table structure for table `srbase_srmodule_maps`
-- 

CREATE TABLE `srbase_srmodule_maps` (
  `map_id` int(11) unsigned NOT NULL auto_increment,
  `name` varchar(32) NOT NULL default 'unnamed',
  `height` tinyint(3) unsigned NOT NULL default '0',
  `width` tinyint(3) unsigned NOT NULL default '0',
  `num_tiles` int(11) unsigned NOT NULL default '0',
  UNIQUE KEY `map_id` (`map_id`,`name`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `srbase_srmodule_maps`
-- 


-- --------------------------------------------------------

-- 
-- Table structure for table `srbase_srmodule_maptiles`
-- 

CREATE TABLE `srbase_srmodule_maptiles` (
  `tile_id` int(11) unsigned NOT NULL auto_increment,
  `mp_name` varchar(32) NOT NULL default 'unnamed',
  `x_loc` tinyint(4) unsigned NOT NULL default '0',
  `y_loc` tinyint(4) unsigned NOT NULL default '0',
  `terrain_img` varchar(32) NOT NULL default 'no_terrain.gif',
  `nlink` varchar(16) NOT NULL default '',
  `elink` varchar(16) NOT NULL default '',
  `slink` varchar(16) NOT NULL default '',
  `wlink` varchar(16) NOT NULL default '',
  `linked` tinyint(1) unsigned NOT NULL default '0',
  `gamestart` tinyint(1) unsigned NOT NULL default '0',
  UNIQUE KEY `tile_id` (`tile_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `srbase_srmodule_maptiles`
-- 


-- --------------------------------------------------------

-- 
-- Table structure for table `srbase_srmodule_races`
-- 

CREATE TABLE `srbase_srmodule_races` (
  `race_id` int(11) unsigned NOT NULL auto_increment,
  `name` varchar(64) NOT NULL default '',
  `preferred_class` int(11) unsigned NOT NULL default '0',
  `description` text NOT NULL,
  `modifiers` text NOT NULL,
  `feats` text NOT NULL,
  UNIQUE KEY `race_id` (`race_id`,`name`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `srbase_srmodule_races`
-- 

INSERT INTO `srbase_srmodule_races` VALUES (1, 'Elaran', 0, 'The Elaran are renowned as a peaceful yet hardy race. Many races often look down on the Elaran, their predominantly round facial features, auburn or black hair and legendary adaptability seen as a throwback to the lesser Humans who roamed the Homeworld. To their credit however, the Elaran rule a vast territory and are considered fierce allies of the Tuatha''an. Many find such a solid alliance between the most mystical of races and the most practical impossible to explain. Rumours indicate that the Elaran who have their own fair share of mystics and magicians just might be the sole race capable of understanding Tuatha''an humour...', 'a:6:{s:3:"str";s:1:"0";s:3:"dex";s:1:"0";s:3:"con";s:1:"0";s:5:"intel";s:1:"0";s:3:"wis";s:1:"0";s:3:"cha";s:1:"0";}', 'a:2:{i:0;s:9:"adaptable";i:1;s:8:"stubborn";}');
INSERT INTO `srbase_srmodule_races` VALUES (2, 'Tuathaan', 0, 'The Tuathaan are an ancient mystical race rumoured to have migrated from the icy wastelands of the north on clouds. Tuatha''an Druids are among the foremost magic wielders in Nemedia with an unusual willingness to share their learning. The fair headed people of this race refuse to worship Gods, instead treating all deaties as equals (much to the dismay of all priests and shamans). The Tuathaan are a society composed of clans, ruled by a King or Queen who is voted into such a role by the annual gathering of Clan Chieftains. Unusually iron is anathema to the Tuathaan, to the extent that they use bronze for all their metalworking needs. For people with such a high value on honour, they are also among the most ruthless of gamblers. It is rumoured that the annual Druid Council is attended by Lugh, the God of Dice, in person.', 'a:6:{s:3:"str";s:2:"-1";s:3:"dex";s:1:"1";s:3:"con";s:2:"-1";s:5:"intel";s:1:"1";s:3:"wis";s:1:"0";s:3:"cha";s:1:"0";}', 'a:3:{i:0;s:9:"mysticism";i:1;s:8:"iceproof";i:2;s:12:"ironweakness";}');
INSERT INTO `srbase_srmodule_races` VALUES (3, 'Fomorian', 0, 'The Fomorians are as old as the Tuatha''an, but nowhere as civilised. A race of island dwelling giants, as much at home in the sea as on dry land, the Fomorians look nothing so much as giant savages in ragged clothing with a conspicuous set of gills on their necks. Little is known of their women, as only the men ever visit the mainland to trade. Although not an evil race, the Fomorians are the focus of most peoples'' suspicions given their history of war against their age-old rivals, the Tuatha''an. Unmatched for sheer strength in battle, the Fomorians disdain armour and are feared by every sea vessel for their ability to breathe underwater and their almost inevitable connection to every pirate group at sea. The Fomorii Islands, a desolate collection of shallow rocky isles, are protected by both an army of these giants and their overlords, the magic wielding Sea Masters. Perhaps the only group to match the Druids when it comes to elemental control over water, the Sea Masters are a force to be reckoned with, and their past wars have crippled the northern nations more than once. ', 'a:6:{s:3:"str";s:1:"2";s:3:"dex";s:1:"0";s:3:"con";s:1:"1";s:5:"intel";s:2:"-1";s:3:"wis";s:1:"0";s:3:"cha";s:2:"-2";}', 'a:2:{i:0;s:14:"waterbreathing";i:1;s:14:"naturalswimmer";}');

-- --------------------------------------------------------

-- 
-- Table structure for table `srbase_srmodule_skills`
-- 

CREATE TABLE `srbase_srmodule_skills` (
  `skill_id` int(11) unsigned NOT NULL auto_increment,
  `skill_name` varchar(32) NOT NULL default 'unknown',
  `skill_code` varchar(16) NOT NULL default '',
  `use_modifier` varchar(32) NOT NULL default 'intel',
  `description` text NOT NULL,
  `notimelimit` tinyint(1) unsigned NOT NULL default '0',
  `untrained` tinyint(1) unsigned NOT NULL default '0',
  UNIQUE KEY `skill_id` (`skill_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `srbase_srmodule_skills`
-- 

INSERT INTO `srbase_srmodule_skills` VALUES (1, 'Concentration', 'concentration', 'con', 'Concentration is required when performing any task in which you must not be distracted. A successful check means you successfully perform the action, otherwise the action will fail and be wasted.', 0, 1);
INSERT INTO `srbase_srmodule_skills` VALUES (2, 'Heal', 'heal', 'wis', 'Healing is always a useful skill, making the most of whatever limited healing supplies are available is not a skill to sneer at.', 1, 1);
INSERT INTO `srbase_srmodule_skills` VALUES (3, 'Lock Picking', 'picklock', 'dex', 'Whether it''s opening some noble''s strongbox, or gaining entry to a locked room - unless you have other means at your disposal you better know how to pick locks!', 0, 1);
INSERT INTO `srbase_srmodule_skills` VALUES (4, 'Search', 'search', 'intel', 'Searching is a skill useful for finding those items that others would prefer remain hidden. This could be a hidden entrance or alcove, a cleverly disguised trap, or even the tracks of someone you are seeking out.', 1, 1);

-- --------------------------------------------------------

-- 
-- Table structure for table `srbase_srmodule_skilltests`
-- 

CREATE TABLE `srbase_srmodule_skilltests` (
  `test_id` int(11) unsigned NOT NULL auto_increment,
  `test_name` varchar(32) NOT NULL default '',
  `type` varchar(32) NOT NULL default '',
  `skill_code` varchar(32) NOT NULL default '',
  `default_dc` tinyint(1) unsigned NOT NULL default '5',
  UNIQUE KEY `test_id` (`test_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `srbase_srmodule_skilltests`
-- 

INSERT INTO `srbase_srmodule_skilltests` VALUES (1, 'Lockpicking', 'picklock', 'picklock', 5);

-- --------------------------------------------------------

-- 
-- Table structure for table `srbase_srmodule_srrpg_backpack`
-- 

CREATE TABLE `srbase_srmodule_srrpg_backpack` (
  `pack_id` int(11) unsigned NOT NULL auto_increment,
  `login_id` int(11) unsigned NOT NULL default '0',
  `item_id` int(11) unsigned NOT NULL default '0',
  `item_name` varchar(64) NOT NULL default 'Unidentified',
  `type` varchar(32) NOT NULL default 'Unknown',
  `level` tinyint(4) unsigned NOT NULL default '0',
  `weight` tinyint(4) unsigned NOT NULL default '0',
  `handle` varchar(32) NOT NULL default 'single',
  `equipped` tinyint(4) unsigned NOT NULL default '0',
  `position` varchar(32) NOT NULL default 'backpack',
  `cost` int(11) unsigned NOT NULL default '0',
  UNIQUE KEY `pack_id` (`pack_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `srbase_srmodule_srrpg_backpack`
-- 


-- --------------------------------------------------------

-- 
-- Table structure for table `srbase_srmodule_srrpg_characters`
-- 

CREATE TABLE `srbase_srmodule_srrpg_characters` (
  `login_id` int(11) unsigned NOT NULL default '0',
  `login_name` varchar(64) NOT NULL default '',
  `name` varchar(64) NOT NULL default '',
  `race_id` int(3) unsigned NOT NULL default '0',
  `race_name` varchar(64) NOT NULL default 'human',
  `sex` varchar(6) NOT NULL default 'male',
  `class_id` int(3) unsigned NOT NULL default '0',
  `class_name` varchar(64) NOT NULL default '',
  `rank` int(11) unsigned NOT NULL default '0',
  `rank_name` varchar(32) NOT NULL default '',
  `skill_points` tinyint(3) unsigned NOT NULL default '0',
  `hp` int(11) unsigned NOT NULL default '10',
  `level` int(11) unsigned NOT NULL default '1',
  `exp` int(11) unsigned NOT NULL default '0',
  `gold` int(11) unsigned NOT NULL default '100',
  `gems` int(11) unsigned NOT NULL default '0',
  `str` int(3) unsigned NOT NULL default '10',
  `dex` int(3) unsigned NOT NULL default '10',
  `con` int(3) unsigned NOT NULL default '10',
  `intel` int(3) unsigned NOT NULL default '10',
  `wis` int(3) unsigned NOT NULL default '10',
  `cha` int(3) unsigned NOT NULL default '10',
  `char_check` tinyint(1) unsigned NOT NULL default '0',
  `location` int(11) unsigned NOT NULL default '0',
  `modifiers` text NOT NULL,
  `skills` text NOT NULL,
  `feats` text NOT NULL,
  `curr_template_page` varchar(128) NOT NULL default '',
  `curr_template_vars` text NOT NULL,
  `curr_request_uri` varchar(128) NOT NULL default '',
  `curr_allowed_navs` text NOT NULL,
  UNIQUE KEY `login_id` (`login_id`,`login_name`),
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `srbase_srmodule_srrpg_characters`
-- 


-- --------------------------------------------------------

-- 
-- Table structure for table `srbase_srmodule_srrpg_locations`
-- 

CREATE TABLE `srbase_srmodule_srrpg_locations` (
  `loc_id` int(11) unsigned NOT NULL auto_increment,
  `mp_name` varchar(32) NOT NULL default 'unnamed',
  `x_loc` tinyint(4) unsigned NOT NULL default '0',
  `y_loc` tinyint(4) unsigned NOT NULL default '0',
  `terrain_img` varchar(32) NOT NULL default 'no_terrain.gif',
  `nlink` varchar(16) NOT NULL default '',
  `elink` varchar(16) NOT NULL default '',
  `slink` varchar(16) NOT NULL default '',
  `wlink` varchar(16) NOT NULL default '',
  `linked` tinyint(1) unsigned NOT NULL default '0',
  `gamestart` tinyint(1) unsigned NOT NULL default '0',
  UNIQUE KEY `tile_id` (`loc_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `srbase_srmodule_srrpg_locations`
-- 

INSERT INTO `srbase_srmodule_srrpg_locations` VALUES (1, 'default', 1, 10, 'grass_0.gif', '', '', '', '', 1, 0);

-- --------------------------------------------------------

-- 
-- Table structure for table `srbase_srmodule_srrpg_merchants`
-- 

CREATE TABLE `srbase_srmodule_srrpg_merchants` (
  `shop_id` int(11) unsigned NOT NULL default '0',
  `location` int(11) unsigned NOT NULL default '0',
  `item_type` varchar(32) NOT NULL default 'weapon',
  `name` varchar(64) NOT NULL default 'Suspiciously Anonymous Shop',
  `max_level` tinyint(2) unsigned NOT NULL default '1',
  `item_types` text NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `srbase_srmodule_srrpg_merchants`
-- 

INSERT INTO `srbase_srmodule_srrpg_merchants` VALUES (1, 1, 'weapon', 'Maugrim''s Weaponry Superstore', 20, 'a:5:{i:0;s:6:"weapon";i:1;s:4:"belt";i:2;s:6:"bracer";i:3;s:5:"cloak";i:4;s:4:"ring";}');
INSERT INTO `srbase_srmodule_srrpg_merchants` VALUES (2, 1, 'drug', 'Sorcha''s Apothecary', 20, 'a:1:{i:0;s:4:"drug";}');

-- --------------------------------------------------------

-- 
-- Table structure for table `srbase_users_accounts`
-- 

CREATE TABLE `srbase_users_accounts` (
  `login_id` int(11) NOT NULL auto_increment,
  `login_name` varchar(30) NOT NULL default '',
  `passwd` varchar(45) NOT NULL default '',
  `auth` int(11) NOT NULL default '0',
  `first_name` varchar(30) NOT NULL default '',
  `last_name` varchar(30) NOT NULL default '',
  `email_address` varchar(40) NOT NULL default '',
  `icq` int(11) NOT NULL default '0',
  `aim` varchar(50) NOT NULL default '',
  `msn` varchar(50) NOT NULL default '',
  `yim` varchar(50) NOT NULL default '',
  `signed_up` int(11) NOT NULL default '0',
  `session_exp` int(11) NOT NULL default '0',
  `session_id` int(11) NOT NULL default '0',
  `last_login` int(11) NOT NULL default '0',
  `login_count` int(11) NOT NULL default '0',
  `last_ip` varchar(16) NOT NULL default '',
  `num_games_joined` int(11) NOT NULL default '0',
  `total_score` int(11) NOT NULL default '0',
  `con_speed` tinyint(4) NOT NULL default '2',
  `default_color_scheme` tinyint(4) NOT NULL default '1',
  `country` varchar(150) NOT NULL default '',
  `hear_from` varchar(150) NOT NULL default '',
  `e_list` tinyint(4) NOT NULL default '1',
  `birth_date` int(11) NOT NULL default '0',
  `sex` tinyint(4) NOT NULL default '0',
  `hint_question` text NOT NULL,
  `hint_answer` text NOT NULL,
  PRIMARY KEY  (`login_id`),
  UNIQUE KEY `login_name` (`login_name`),
  UNIQUE KEY `email_address` (`email_address`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `srbase_users_accounts`
-- 

INSERT INTO `srbase_users_accounts` VALUES (1, '[[admin_username]]', '[[admin_pass]]', 0, '[[admin_fname]]', '[[admin_lname]]', '[[admin_email]]', 0, '', '', '', 1084986985, 1091820346, 8672, 1091819104, 112, '127.0.0.1', 0, 0, 2, 1, 'ie', '', 1, 0, 0, '', '');

-- --------------------------------------------------------

-- 
-- Table structure for table `srbase_users_permissions`
-- 

CREATE TABLE `srbase_users_permissions` (
  `login_id` int(11) unsigned NOT NULL default '0',
  `login_name` varchar(32) NOT NULL default '',
  `admin` tinyint(1) unsigned NOT NULL default '0',
  `deity` tinyint(1) unsigned NOT NULL default '0',
  `developer` tinyint(1) unsigned NOT NULL default '0',
  `moderator` tinyint(1) unsigned NOT NULL default '0',
  PRIMARY KEY  (`login_id`),
  UNIQUE KEY `login_name` (`login_name`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `srbase_users_permissions`
-- 

INSERT INTO `srbase_users_permissions` VALUES (1, '[[admin_username]]', 1, 1, 0, 0);
