<?php

/*
	OUTLINE
	*Use default credentials, or the customer's own? Customer credentials get special rates automatically.
	*Split up cart session variables to get prikeys of cart items
	*Read product dimensions from cart_products
	*Build array of items, with dimensions for each
	*Make sure SSTATE is 2-digit code
	*Send request to SmartSend
		*Includes several working test values commented-out that are helpful to test with
	
	*If form with dropdown submitted, post hidden form to checkout STEP = 4
		*If no submission detected, show dropdown with hidden field
	
*/

$cartprefs = new userdata('cart');




# These can stay the same across customer accounts.
$test_webServiceURL  = 'http://smartsend-service.staging.emu.com.au/service.asmx?wsdl';
$webServiceURL = "http://developer.smartsend.com.au/service.asmx?wsdl";
$webServiceDeveloperID = "4B103C7D-6DA0-4607-9E50-25FE500A378E";
$webServiceResellerID = "dd16f313-a84e-4d58-a426-c8b4fe102d6f";

if ( $cartprefs->get('smartsend_username') == '' || $cartprefs->get('smartsend_password') == '' ) {
	# No custom VIP user/pass specified, use default dev account
	$webServiceUsername = "ania@emu.com.au";
	$webServicePassword = "emudesign";
} else {
	# Custom VIP user/pass specified, use them so it pulls their special rates
	$webServiceUsername = $cartprefs->get('smartsend_username');
	$webServicePassword = $cartprefs->get('smartsend_password');
}	


# Pull dimensions
$tmp_prikey = split(";", $CART_UNITPRICE);
$tmp_cnt = count($tmp_prikey);
$tmp_qty = split(";", $CART_QTY);
$cart_prikeyArr = explode(';', $CART_KEYID);
$cart_qryArr = explode(';', $CART_QTY);
$qry = 'select PROD_SHIPB, PROD_SHIPC from cart_products where';
foreach ( $cart_prikeyArr as $key=>$prikey ) {
  	if ( $prikey != '' ) {
  		$qry .= " PRIKEY = '".$prikey."' OR";
  	}
}
$qry = substr($qry, 0, -3); 
$dimResult = mysql_query($qry);


# Build multi-product item array
$itemArr = array();
while ( $getDim = mysql_fetch_assoc($dimResult) ) {
	$dimensions = explode(';', $getDim['PROD_SHIPC']);
	// lbs / 2.2 = kilograms  - convert to metric
	// inch x 2.54 = cm - convert to metric
//	$packageArr = array(		//// convert inches to  ()
//		'Description' => 'Carton',
//		'Depth' => ($dimensions[1]*2.54),
//		'Height' => ($dimensions[2]*2.54),
//		'Length' => ($dimensions[0]*2.54),
//		'Weight' => ($getDim['PROD_SHIPB']/ 2.2)
//	);
	$packageArr = array(
		'Description' => 'Carton',
		'Depth' => $dimensions[1],
		'Height' => $dimensions[2],
		'Length' => $dimensions[0],
		'Weight' => $getDim['PROD_SHIPB']
	);	
	array_push($itemArr, $packageArr);
   $prod_counter++;
}


# Convert full state name to sate code
if ( strlen($OPTIONS['BIZ_STATE']) > 3 ) {
	$aus_stateArr = array();
	$aus_state_dat = file_get_contents('aus_states.dat');
	$token = strtok($aus_state_dat, "\n");
	while ( $token != false ) {
		$tempArr = split(" - ", $token);
		$aus_stateArr[$tempArr[0]] = $tempArr[1];
		$token = strtok("\n");
	}
	
	$biz_state_code_temp = array_search(strtolower($OPTIONS['BIZ_STATE']), array_map('strtolower', $aus_stateArr));
	if ( $biz_state_code_temp != '' ) {
		$biz_state_code = $biz_state_code_temp;
	} else {
		$biz_state_code = $OPTIONS['BIZ_STATE'];
	}
}

$_SESSION['SHIPPING_TOTAL'] = '1.00';
$_SESSION['SHIPPING_INSTRUCTIONS'] = 'SmartSend';

$client = new SoapClient($webServiceURL);
define("NL", '');

//Gets a list of functions available from the webservice.
$functionList = $client->__getFunctions();

//Get list of locations.
$returnedLocations = $client->GetLocations();

//Get quote.
$params = 	array (
	'VIPUsername' => $webServiceUsername,		//string
	'VIPPassword' => $webServicePassword,		//string
	'DeveloperId' => $webServiceDeveloperID,	//string
	'ResellerId' => $webServiceResellerID,		//string
	
	'PostcodeFrom' => $OPTIONS['BIZ_POSTALCODE'],			// string
	// 'PostcodeFrom' => '4000',										// test
	
	'SuburbFrom' => ucwords(strtolower($OPTIONS['BIZ_CITY'])),		// string
	// 'SuburbFrom' => 'BRISBANE',												// test
	
	'StateFrom' => $biz_state_code,				// string
	// 'StateFrom' => 'QLD',						// test
	
	'PostcodeTo' => $_SESSION['SZIPCODE'],				// string
	// 'PostcodeTo' => '6000',								// test
	
	'SuburbTo' => ucwords(strtolower($_SESSION['SCITY'])),				// string
	//'SuburbTo' => 'PERTH',				// string
	
	'StateTo' => preg_replace('| .*|i', '', $_SESSION['SSTATE']),					// string
	// 'StateTo' => 'WA',					// TEST
	
	'UserType' => 'CASUAL',				// string EBAY, CORPORATE, PROMOTION, CASUAL, REFERRAL
	'OnlineSellerID' => '',				// string 
	'PromotionalCode' => '',			// string
	'ReceiptedDelivery' => 0,		// boolean
	'TailLift' => 'NONE',				// string NONE, PICKUP, DELIVERY, BOTH
	'TransportAssurance' => 0,			// int
	'Items' => $itemArr
);

//echo testArray($params); // Data SENT to SmartSend

$returnedResults = $client->ObtainQuote(array('request' => $params));

if ( $returnedResults->ObtainQuoteResult->StatusCode < 0 ) {
	//echo '<pre style="text-align: left;">';
	//print_r($returnedResults);
	//echo '</pre>';
	$error_msg = $returnedResults->ObtainQuoteResult->StatusMessages->string;
	if ( $error_msg != '' && is_string($error_msg) ) {
		echo '<strong>Sorry! We were unable to retrieve the shipping rates for the address you submitted. '.$error_msg.'</strong>';
	} elseif ( is_array($error_msg) ) {
		echo '<strong>Sorry! We were unable to retrieve the shipping rates for the address you submitted: '.testArray($error_msg).'</strong>';
	}
}


if($_POST['action_ship'] == "process"){
   
   $_SESSION['SHIPPING_SET'] = $_POST['PRESHIPPING'];
   $_SESSION['SHIPPING_INSTRUCTIONS'] = preg_replace('| - .*$|i', '', str_replace('_', ' ', $_POST['shipping_service']));
   
   $THIS_DISPLAY .= "<form name=\"send_shipping\" method=\"POST\" action=\"pgm-checkout.php\">\n";
   $THIS_DISPLAY .= "<INPUT TYPE=HIDDEN NAME=STEP VALUE=\"4\">\n";
   $THIS_DISPLAY .= "<INPUT TYPE=HIDDEN NAME=customer_active VALUE=\"Y\">\n";
   $THIS_DISPLAY .= "<INPUT TYPE=HIDDEN NAME=customernumber VALUE=\"".$_POST['customernumber']."\">\n";
   $THIS_DISPLAY .= "<input type=hidden name=\"SCOUNTRY\" VALUE=\"".$_SESSION['SCOUNTRY']."\">\n";
   $THIS_DISPLAY .= "<input type=\"hidden\" name=\"SHIPPING_TOTAL\" VALUE=\"".filter_var($_POST['SHIPPING_TOTAL'], FILTER_VALIDATE_FLOAT)."\"/>\n";
   $THIS_DISPLAY .= "</form>\n";
   
   $THIS_DISPLAY .= "<script language=\"javascript\">\n";
   $THIS_DISPLAY .= "document.send_shipping.submit();\n";
   $THIS_DISPLAY .= "</script>\n";
   
} else {
   
   # Make sure session vars are clear
   unset($_SESSION['SHIPPING_TOTAL'], $SHIPPING_TOTAL, $_SESSION['SHIPPING_BASE'], $SHIPPING_BASE);
   
   ob_start();
?>
<script language="javascript" type="text/javascript">
function update_shipping_total() {
	var service = document.getElementById('shipping_service').value;
	serviceArr = service.split('-');
	document.getElementById('SHIPPING_TOTAL').value = serviceArr[1].replace(/_\$/g, '');
	
}
</script>
<?php
	$THIS_DISPLAY .= ob_get_contents();
	ob_end_clean();  
   
   // ----------------------------------------------------------
   
   $THIS_DISPLAY .= "<form method=\"POST\" action=\"pgm-checkout.php\">\n";
   
   $THIS_DISPLAY .= "<INPUT TYPE=HIDDEN NAME=STEP VALUE=\"3\">\n";
   $THIS_DISPLAY .= "<INPUT TYPE=HIDDEN NAME=\"action_ship\" VALUE=\"process\">\n";
   $THIS_DISPLAY .= "<INPUT TYPE=HIDDEN NAME=customer_active VALUE=\"Y\">\n";
   $THIS_DISPLAY .= "<INPUT TYPE=HIDDEN NAME=customernumber VALUE=\"".$customernumber."\">\n";
   $THIS_DISPLAY .= "<INPUT TYPE=\"hidden\" id=\"SHIPPING_TOTAL\" NAME=\"SHIPPING_TOTAL\" VALUE=\"\$0.00\">\n";

	$THIS_DISPLAY .= '<select id="shipping_service" name="shipping_service" onchange="update_shipping_total()">';
	foreach ($returnedResults->ObtainQuoteResult->Quotes->Quote as $num => $quote) {
		$service_name = $quote->ServiceName.NL;
		$courier_name = $quote->CourierName.NL;
		$service_total_price = sprintf('%0.2f', filter_var($quote->TotalPrice.NL, FILTER_VALIDATE_FLOAT));
		$option_text = $courier_name.' '.$service_name.' - $'.$service_total_price;
		$option_value = str_replace(' ', '_', $option_text);
		$THIS_DISPLAY .= '<option value="'.$option_value.'">'.$option_text.'</option>';
	}
	$THIS_DISPLAY .= '</select>';

   $THIS_DISPLAY .= "<input type=\"submit\" value=\" Continue to Checkout \" />\n";
   $THIS_DISPLAY .= "</p></form>\n";
   
   $THIS_DISPLAY .= "<script language=\"javascript\" type=\"text/javascript\">\n";
   $THIS_DISPLAY .= 'update_shipping_total();';
   $THIS_DISPLAY .= '</script>';
}
?>