<?php
// Copyright 2009, FedEx Corporation. All rights reserved.
// Version 9.0.0
/* soho additions
-$fedex_service_typesArr
*/
//require_once('fedex-settings.php');
session_start();
//set_error_handler('my_error_handler');
//set_exception_handler('my_exception_handler');

function my_exception_handler($e) {
    exit('Error: '.$e);
}

function my_error_handler($no,$str,$file,$line) {
    $e = new ErrorException($str,$no,0,$file,$line);
    my_exception_handler($e);     /* Do not throw, simply call error handler with exception object */
}

class fedex {
	var $errors = array();
	var $request = array();
	var $account;
	var $meter;
	var $key;
	var $weight;
	var $password;
	var $wsdl_file;
	var $apimode;
	var $dropdownhtml;
	var $shipper;
	var $recipient;
	var $path_to_wsdl;
	
	function __construct($mode) {
		$this->apimode = ($mode == 'production' ? $mode : 'testmode');
      
      # Soho default fedex test info
//      if ( $this->apimode == 'testmode' ) {
      	$this->path_to_wsdl = $_SESSION['docroot_path'].'/sohoadmin/client_files/shopping_cart/fedex-v10-testmode.wsdl';
//      }
      $this->account = '510087542';
      $this->meter = '100122001';
      $this->key = 'xNzkb30CAc5DHSPu';
      $this->password = 'vjEeXR83PaXnDSuO0jYAYrgHb';
      
		# DEFAULTS
		if ( !$this->haserrors() ) {
			$this->request['TransactionDetail'] = array('CustomerTransactionId' => ' *** Rate Request v10 using PHP ***');
			$this->request['Version'] = array(
				'ServiceId' => 'crs', 
				'Major' => '10', 
				'Intermediate' => '0', 
				'Minor' => '0'
			);
			$this->request['WebAuthenticationDetail'] = array(
				'UserCredential' =>array(
					'Key' => $this->key, 
					'Password' => $this->password
				)
			); 		
			$this->request['ClientDetail'] = array(
				'AccountNumber' => $this->account, 
				'MeterNumber' => $this->meter
			);
			
			$this->request['RequestedShipment']['ShippingChargesPayment'] = array(
			   'PaymentType' => 'SENDER', // valid values RECIPIENT, SENDER and THIRD_PARTY
			   'Payor' => array(
			      'AccountNumber' => $this->account,
			      'CountryCode' => 'US')
			);
		} // End if not has errors
	} // End _construct()
	
	// Set account credentials
	function validate_account() {
		$accountgood = true();
		if ( $accountgood ) {
			return true;
		} else {
			$this->errors[] = 'There is problem with your fedex account details.';
		}
	}	
	
	function setaddress($to_or_from, $addrArr) {
		// Validate address
//		echo testArray($addrArr);
		$requiredVars = array('contactname' => 'Contact First and Last Name', 'phone' => 'Phone Number', 'addr1' => 'Address', 'city' => 'City', 'statecode' => 'State/Province', 'postalcode' => 'Postal/Zip Code', 'countrycode' => 'Country');
		foreach ( $requiredVars as $key=>$value ) {
			if ( trim($addrArr[$key]) == '' ) { $this->errors[] = '<strong>'.$value.'</strong> is missing in <strong>'.$to_or_from.'</strong> address</em>.'; }
		}
		
		if ( $addrArr['statecode'] != '' && strlen($addrArr['statecode']) > 2 ) {
			$this->errors[] = '<strong>State</strong> "'.$addrArr['statecode'].'" should be passed as 2-digit state code only. Please contact the webmaster. Sorry for the frustration.';
		}
		if ( $addrArr['countrycode'] != '' && strlen($addrArr['countrycode']) > 2 ) {
			$this->errors[] = '<strong>Country</strong> "'.$addrArr['countrycode'].'" should be passed as 2-digit state abbriviation only. Please contact us if you have trouble.';
		}
		if ( preg_match('/[^0-9\-]/', $addrArr['postalcode']) && $addrArr['countrycode'] == 'US' ) {
			$this->errors[] = '<strong>Postal Code</strong> "'.$addrArr['postalcode'].'" is being rejected as invalid.';
		}
		
		if ( !$this->haserrors() ) {
			if ( $to_or_from == 'from' ) {
				$this->shipper = array(
				   'Contact' => array(
				      'PersonName' => $addrArr['contactname'],
				      'CompanyName' => $addrArr['company'],
				      'PhoneNumber' => $addrArr['phone']),
				   'Address' => array(
				      'StreetLines' => array($addrArr['addr1'], $addrArr['addr2']),
				      'City' => $addrArr['city'],
				      'StateOrProvinceCode' => $addrArr['statecode'],
				      'PostalCode' => $addrArr['postalcode'],
				      'CountryCode' => $addrArr['countrycode'])
				);
			} else { // to address
				$this->recipient = array(
				   'Contact' => array(
				      'PersonName' => $addrArr['contactname'],
				      'CompanyName' => $addrArr['company'],
				      'PhoneNumber' => $addrArr['phone']),
				   'Address' => array(
				      'StreetLines' => array($addrArr['addr1']),
				      'City' => $addrArr['city'],
				      'StateOrProvinceCode' => $addrArr['statecode'],
				      'PostalCode' => $addrArr['postalcode'],
				      'CountryCode' => $addrArr['countrycode'],
				      'Residential' => false)
				);
			}		
		}
		
	}
	
	function setweight($weightInt) {
		$weightInt = preg_replace('/[^0-9\.]/', '', $weightInt);
		$this->weight = $weightInt;
		
      if ( $this->weight == '' || $this->weight == 0 ) {
			$this->errors[] = 'There is a problem with the way the weight of the item was calculated.';
		}
		
		if ( !$this->haserrors() ) {
	      $this->request['RequestedShipment']['RequestedPackageLineItems'] = array(
	         'SequenceNumber'=>1,
	         'GroupPackageCount'=>1,
	         'Weight' => array(
	            'Value' => $this->weight,
	            'Units' => 'LB'
	         ),
	         // Length & Width: May need to make this pull from db later
	         'Dimensions' => array(
	            'Length' => 108,
	            'Width' => 5,
	            'Height' => 5,
	            'Units' => 'IN'
	         )
	      );	
	   }
	}
	
	function sendrequest() {
		if ( !$this->haserrors() ) {
			$fedex_service_typesArr = array('FEDEX_GROUND', 'INTERNATIONAL_PRIORITY','INTERNATIONAL_ECONOMY',
				'INTERNATIONAL_FIRST','INTERNATIONAL_PRIORITY_FREIGHT','INTERNATIONAL_ECONOMY_FREIGHT',
				'STANDARD_OVERNIGHT', 'PRIORITY_OVERNIGHT', 'EUROPE_FIRST_INTERNATIONAL_PRIORITY');			
//			$fedex_service_typesArr = array('FEDEX_GROUND', 'INTERNATIONAL_PRIORITY');							
				
			
			foreach ( $fedex_service_typesArr as $key=>$servicename ) {
				$client = new SoapClient($this->path_to_wsdl, array('trace' => 1)); // Refer to http://us3.php.net/manual/en/ref.soap.php for more information
				
				$this->request['RequestedShipment']['DropoffType'] = 'REGULAR_PICKUP'; // valid values REGULAR_PICKUP, REQUEST_COURIER, ...
				$this->request['RequestedShipment']['ServiceType'] = $servicename; // valid values STANDARD_OVERNIGHT, PRIORITY_OVERNIGHT, FEDEX_GROUND, ...
				$this->request['RequestedShipment']['PackagingType'] = 'YOUR_PACKAGING'; // valid values FEDEX_BOX, FEDEX_PAK, FEDEX_TUBE, YOUR_PACKAGING, ...
				$this->request['RequestedShipment']['TotalInsuredValue'] = array('Ammount'=>100,'Currency'=>'USD');
				$this->request['RequestedShipment']['Shipper'] = $this->shipper;
				$this->request['RequestedShipment']['Recipient'] = $this->recipient;
				$this->request['RequestedShipment']['ShipTimestamp'] = date('c');
				$this->request['RequestedShipment']['RateRequestTypes'] = 'ACCOUNT'; 
				$this->request['RequestedShipment']['RateRequestTypes'] = 'LIST'; 
				$this->request['RequestedShipment']['PackageCount'] = '1';
				$this->request['ReturnTransitAndCommit'] = true;
				
//				echo '<pre style="background: #efefef;width: 800px;height: 500px;overflow: auto;font-family: Courier New, mono;">';
//				print_r($this->request);
//				echo '</pre>';
				
				try {
					$fedex_dropdown_options = '';
					$response = $client ->getRates($this->request);
				        
				    if ($response -> HighestSeverity != 'FAILURE' && $response -> HighestSeverity != 'ERROR') {  	
				    	$rateReply = $response->RateReplyDetails;
				    	$service_name = $rateReply -> ServiceType;
				      $service_price = number_format($rateReply->RatedShipmentDetails[0]->ShipmentRateDetail->TotalNetCharge->Amount,2,".",",");
				      
					$get_extra_ship_charge = mysql_query("select * from smt_userdata where plugin='cart' and fieldname='add_ship_charge' limit 1");
					if(mysql_num_rows($get_extra_ship_charge) > 0){
						$extra_charge=mysql_fetch_assoc($get_extra_ship_charge);
						$service_price=number_format($service_price+$extra_charge['data'],2,".",",");
					}
				      
				      $this->dropdownhtml .= '<option value="'.$service_name.':'.$service_price.'">'.ucwords(strtolower(str_replace('_', ' ', $service_name))).' - $'.$service_price.'</option>';
				      
				    } else {
//				    	# Error Details
//						echo '<pre style="text-align: left;background: #efefef;width: 800px;height: 500px;overflow: auto;font-family: Courier New, mono;">';
//						print_r($response);
//						echo '</pre>';			    	
						
						if ( is_int(key($response->Notifications)) ) {
					    	$max = count($response->Notifications);
					    	if ( $max > 0 ) {
					    		for ( $n = 0; $n < $max; $n++ ) {
					    			$fedexerror = $response->Notifications[$n]->LocalizedMessage;
					    			$fedexerrorcode = $response->Notifications[$n]->Code;
					    		}
					    	}
					   } else {
					   	$fedexerror = $response->Notifications->LocalizedMessage;
					   	$fedexerrorcode = $response->Notifications->Code;
					   }
	               if ( $fedexerror != '' ) {
	               	/* Do not show all errors.
	               	 You don't want an error stop when a service fails because of incompatible packaging, unless you are troubleshooting services.
	               	 Instead, address fedex errors specifically via code
	               	*/
	               	if ( $fedexerrorcode == '522' ) {
	                  	$this->errors[] = 'Destination coutnry code missing or invalid';
	                  	break;
	                  }
	               }				   
				    }
				
				} catch (SoapFault $exception) {
					echo '<strong>Error:</strong> '.$exception->faultstring;
				}		
			
			} // End foreach		
		} // End if no errors
	}
	
	function dropdownhtml() {
		// Returns <options>'s for all of fedex services
		
		$optionArr = array();
		$html = '';
		
		if ( $this->dropdownhtml == '' ) {
			$this->dropdownhtml = '<option value="all-services-return-errors">Problem retrieving rates. Please contact us!</option>';
		}
		return $this->dropdownhtml;		
	}
	
	function haserrors() {
		if ( count($this->errors) ) {
			return true;
		} else {
			return false;
		}
	}
	
	function errorlist() {
		$max = count($this->errors);
		$errorlist = '<ul class="errors">';
		for ( $e = 0; $e < $max; $e++ ) {
			$errorlist .= '	<li>'.$this->errors[$e].'</li>';
		}
		$errorlist .= '</ul>';
		return $errorlist;
	}
}


#-----------------------------------------------------------------------------
# FOR TESTING
# SHIPPER address (later pull from db)
//$shipArr = array();
//$shipArr['contactname'] = 'Sally Sender';
//$shipArr['company'] = 'Cogswell Cogs';
//$shipArr['phone'] = '555-345-1234';
//$shipArr['addr1'] = '2759 Delk Road';
//$shipArr['addr2'] = 'Suite 2425';
//$shipArr['city'] = 'Marietta';
//$shipArr['statecode'] = 'GA';
//$shipArr['postalcode'] = '30067';
//$shipArr['countrycode'] = 'US';
//$shiptoArr = array();
//$shiptoArr['contactname'] = 'Randy Recipient';
//$shiptoArr['company'] = 'Spacely Sprockets';
//$shiptoArr['phone'] = '555-345-1234';
//$shiptoArr['addr1'] = '1493 Colgate Ct.';
//$shiptoArr['city'] = 'Marietta';
//$shiptoArr['statecode'] = 'GA';
//$shiptoArr['postalcode'] = '30068';
//$shiptoArr['countrycode'] = 'US';
//$fedex = new fedex('testmode');
//$fedex->setaddress('from', $shipArr);
//$fedex->setaddress('to', $shiptoArr);
//$fedex->setweight('10');
//$fedex->sendrequest();
//echo '<select>';
//echo $fedex->dropdownhtml();
//echo '</select>';
?>