<?php
// Version: 2.1.5; Help

global $helptxt, $scripturl;

$txt['close_window'] = 'Sluit dit scherm';

$helptxt['manage_boards'] = '
	<strong>Boards bewerken</strong><br>
	In dit menu kun je boards aanmaken, rangschikken en verwijderen, en de categorieën
	erboven aanpassen. Als je bijvoorbeeld een brede site hebt
	die informatie biedt op het gebied van &quot;Sport&quot;, &quot;Auto\'s&quot; en &quot;Muziek&quot;, zouden
	deze je categorieën worden. In elk van deze
	categorieën zou je waarschijnlijk een hiërarchie van &quot;sub-categorieën willen maken,
	oftewel de &quot;boards&quot; voor de onderwerpen binnen die categorie. Het is een simpele hiërarchie, met deze structuur:<br>
	<ul class="normallist">
		<li>
			<strong>Sport</strong>
			&nbsp;- Een &quot;categorie&quot;
		</li>
		<ul class="normallist">
			<li>
				<strong>Basketbal</strong>
				&nbsp;- Een board in de categorie &quot;Sport&quot;
			</li>
			<ul class="normallist">
				<li>
					<strong>Uitslagen</strong>
					&nbsp;- Een sub-board in het board &quot;Basketbal&quot;
				</li>
			</ul>
			<li><strong>Voetbal</strong>
			&nbsp;- Een board onder de categorie &quot;Sport&quot;</li>
		</ul>
	</ul>
	Met categorieën kun je een forum in globale onderwerpen verdelen (&quot;Auto\'s,
	Sport&quot;), en de &quot;boards&quot; daarin zijn de eigenlijke onderwerpen waarin
	leden hun berichten kunnen plaatsen. Een gebruiker die geïnteresseerd is in Pintos
	zou een bericht kunnen plaatsen in &quot;Autos -> Pinto&quot;. Categorieën zorgen ervoor dat mensen
	snel kunnen vinden waarin ze geïnteresseerd zijn: in plaats van een &quot;Winkel&quot; heb je
	heb je een &quot;Doe-het-zelf-winkel&quot; en een &quot;Kledingswinkel&quot; waar je naar toe kunt gaan. Dit vereenvoudigt je
	zoektocht naar &quot;regenpijplijm&quot; omdat je dan direct naar de Doe-het-zelf gaat
	in plaats van de Kledingwinkel (waar het onwaarschijnlijk is
	om regenpijplijm te vinden).<br>
	Zoals hierboven al is opgemerkt, is een board een hoofdonderwerp in een bredere categorie.
	Als je wilt discussiëren over &quot;Pinto\'s&quot;, dan zou je naar de &quot;Auto\'s&quot; categorie gaan en
	dan naar het &quot;Pinto&quot; board gaan om daar je mening te plaatsen.<br>
	De beheerfuncties voor dit menu item zijn het aanmaken van nieuwe boards
	in elke categorie, het rangschikken van boards (plaats &quot;Pinto&quot; achter &quot;Chevy&quot;), of
	het verwijderen van een volledig board.';

$helptxt['edit_news'] = '
<ul class="normallist">
		<li>
			<strong>Nieuws</strong><br>
			Deze sectie stelt je in staat om de tekst van de nieuwsitems op de forumindexpagina te wijzigen.
			Je kunt al het nieuws wat je wil toevoegen (bijv. &quot;Vergeet de bijeenkomst komende dinsdag niet&quot;). Elk nieuwsitem moet in een apart invoervak ingevuld worden. De items worden in willekeurige volgorde getoond.
		</li>
		<li>
			<strong>Nieuwsbrieven</strong><br>
			Deze sectie stelt je in staat om nieuwsbrieven naar de leden van je forum te versturen. Eerst selecteer je de groepen die je de nieuwsbrief wilt sturen en eventueel ook de groepen die je beslist geen nieuwsbrief wilt sturen. Eventueel kun je ook extra leden en e-mailadressen opgeven waar een kopie van de nieuwsbrief naar toegestuurd moet worden. Ten slotte typ je de tekst voor de nieuwsbrief in en kies je of je de nieuwsbrief wilt versturen als een persoonlijk bericht in het forum of als een e-mail.
		</li>
		<li>
			<strong>Instellingen</strong><br>
			Deze sectie bevat een aantal instellingen met betrekking tot nieuws en nieuwsbrieven, waaronder een optie waarmee je kunt instellen welke groepen het nieuws kunnen aanpassen. Ook is er een instelling waarmee je nieuwsfeeds op je forum kunt inschakelen, met daarbij ook een instelling waarmee je de lengte (in weergegeven karakters) voor elk bericht in een nieuwsfeed kunt instellen.
		</li>
	</ul>';

$helptxt['view_members'] = '
	<ul class="normallist">
		<li>
			<strong>Bekijk alle leden</strong><br>
			Bekijk alle leden van het forum. Je krijgt een lijst met de links van ledennamen te zien. Je kunt op elk van de namen klikken on de details van de leden te bekijken (website, leeftijd, etc.), en als beheerder ben je in staat deze gegevens aan te passen. Je hebt volledige controle over de ledeninfo, inclusief de mogelijkheid leden te verwijderen van het forum.<br><br>
		</li>
		<li>
			<strong>Wachtend op goedkeuring</strong><br>
			Deze pagina wordt alleen getoond als je de beheerder goedkeuring hebt ingeschakeld voor alle nieuwe registraties. Iedereen die registreert op je forum wordt pas volledig lid na goedkeuring door een beheerder. Deze pagina toont alle leden die nog wachten op goedkeuring, met hun e-mail en IP adres. Je kunt ervoor kiezen de registratie te accepteren of af te wijzen (verwijderen) van elk lid op de lijst door de selectie naast de naam te maken en de gewenste actie te kiezen van de keuzelijst onderaan de pagina. Bij het afwijzen van een lid kun je ervoor kiezen dit te doen met of zonder e-mail notificatie.<br><br>
		</li>
		<li>
			<strong>Wachtend op activering</strong><br>
			Deze pagina wordt alleen getoond als je e-mail activatie hebt ingeschakeld voor alle nieuwe registraties. Deze pagina toont alle leden die hun account nog niet hebben geactiveerd. Je kunt ervoor kiezen de registratie te accepteren, af te wijzen of een herinnering te sturen aan leden met niet geactiveerde registraties. Zoals hiervoor beschreven kun je ervoor kiezen een e-mail notificatie te sturen betreffende de genomen actie.<br><br>
		</li>
	</ul>';

$helptxt['ban_members'] = '<strong>Leden verbannen</strong><br>
	SMF biedt de mogelijkheid om gebruikers te &quot;verbannen&quot;, zodat mensen die vertrouwen op het forum hebben geschonden
	door te spammen, mensen lastig te vallen, etc. worden geweerd. Als beheerder kun je,
	wanneer je berichten bekijkt, het IP-adres zien dat een lid gebruikte op het moment dat dat bericht geplaatst werd. In de banlijst
	typ je simpelweg dat IP-adres in, sla je de trigger op, en kunnen ze niet langer vanaf dat IP-adres berichten plaatsen.<br>Ook kun je
	mensen op gebruikersnaam, hostname en e-mailadres verbannen.';

$helptxt['featuresettings'] = '<strong>Features en opties bewerken</strong><br>
	Er zijn een aantal instellingen op deze pagina die naar jouw inzicht gewijzigd kunnen worden.';

$helptxt['modsettings'] = '<strong>Modificatie-instellingen</strong><br>
	Deze pagina zou alle instellingen moeten bevatten die de op jouw forum geïnstalleerde modificaties hebben toegevoegd.';

$helptxt['time_format'] = '<strong>Tijdsweergave</strong><br>
	Je kunt zelf de tijd- en datumweergave aanpassen. Er zijn een hoop mogelijkheden, maar het is vrij simpel.
	Gebruik de volgende codes (voor meer informatie kun je kijken op <a href="https://php.net/manual/function.strftime.php" target="_blank" rel="noopener">php.net</a>>).<br>
	<br>
	De volgende conversie specifiers worden herkend in de format string: <br>
	<span class="smalltext">
	&nbsp;&nbsp;%a - afgekorte weekdag naam<br>
	&nbsp;&nbsp;%A - volledige weekdag naam<br>
	&nbsp;&nbsp;%b - afgekorte maand naam<br>
	&nbsp;&nbsp;%B - volledige maand naam<br>
	&nbsp;&nbsp;%d - dag van de maand (01 tot 31) <br>
	&nbsp;&nbsp;%D<strong>*</strong> - hetzelfde als %m/%d/%y <br>
	&nbsp;&nbsp;%e<strong>*</strong> - dag van de maand (1 tot 31) <br>
	&nbsp;&nbsp;%H - uur gebruik makend van een 24 uurs klok (van 00 tot 23) <br>
	&nbsp;&nbsp;%I - uur gebruik makend van een 12 uurs klok (van 01 tot 12) <br>
	&nbsp;&nbsp;%m - maand als decimaal nummer (01 to 12) <br>
	&nbsp;&nbsp;%M - minuut als decimaal nummer <br>
	&nbsp;&nbsp;%p - &quot;am&quot; of &quot;pm&quot; afhankelijk van de huidige tijd<br>
	&nbsp;&nbsp;%R<strong>*</strong> - tijd gebruik makend van een 24 uurs klok <br>
	&nbsp;&nbsp;%S - seconde als decimaal nummer <br>
	&nbsp;&nbsp;%T<strong>*</strong> - huidige tijd, hetzelfde als %H:%M:%S <br>
	&nbsp;&nbsp;%y - 2-cijferige jaaraanduiding (00 to 99) <br>
	&nbsp;&nbsp;%Y - 4-cijferige jaaraanduiding<br>
	&nbsp;&nbsp;%% - een letterlijk \'%\' karakter <br>
	<br>
	<em>* Werkt niet op Windows gebaseerde servers.</em></span>';

$helptxt['live_news'] = '<strong>Live aankondigingen</strong><br>
	Deze box toont recente aankondigingen van <a href="https://www.simplemachines.org/" target="_blank" rel="noopener">www.simplemachines.org</a>.
	Je zou hier af en toe eens moeten langskomen voor updates, nieuwe releases en andere belangrijke informatie van Simple Machines.';

$helptxt['registrations'] = '<strong>Registratiebeheer</strong><br>
	Deze sectie bevat alle functies die nodig zouden kunnen zijn voor het beheer van nieuwe registraties op het forum. Het bevat tot vier secties
	die zichtbaar zijn, afhankelijk van je instellingen. Te weten:<br><br>
	<ul class="normallist">
		<li>
			<strong>Registreren nieuw lid</strong><br>
			Je kunt hier zelf leden registreren. Dit kan handig zijn bij forums waar het registreren van nieuwe leden dicht gezet is,
			of in gevallen waar de beheerder een test account wil aanmaken. Als de optie is geactiveerd dat het nieuwe lid een e-mail krijgt
			waarin een link is bijgesloten, dient men die te volgen om de account te activeren. Je kunt op deze manier ook leden een nieuw
			wachtwoord mailen indien daarom wordt verzocht.<br><br>
		</li>
		<li>
			<strong>Registratie-overeenkomst bewerken</strong><br>
			Hiermee kun je de tekst instellen die wordt getoond wanneer leden zich registreren op je forum.
			Je kunt de standaard registratie-overeenkomst, die wordt geleverd met SMF, naar believen aanpassen.
		</li>
		<li>
			<strong>Gereserveerde namen bewerken</strong><br>
			Middels deze interface kun je woorden of namen specificeren die niet gebruikt mogen worden in namen van leden.<br><br>
		</li>
		<li>
			<strong>Instellingen</strong><br>
			Deze sectie is alleen zichtbaar als je de \'Beheer forum en database\' permissie hebt. Vanaf dit scherm kun je instellen welke registratiemethode
			op je forum wordt gebruikt alsmede andere registratie-gerelateerde instellingen.
		</li>
	</ul>';

$helptxt['modlog'] = '<strong>Moderatielog</strong><br>
Deze sectie stelt leden van het moderatieteam in staat om alle moderatieacties te bekijken die de moderators van het forum hebben uitgevoerd. Om er zeker van te zijn dat deze verwijzingen naar activiteiten niet door de moderators worden gewist, kunnen de ingangen niet worden gewist tot 24 uur na de betreffende activiteit.';
$helptxt['adminlog'] = '<strong>Beheerlog</strong><br>
Deze sectie stelt leden van het beheerteam in staat tot om alle administratieve acties te bekijken die de beheerders van het forum hebben uitgevoerd. Om er zeker van te zijn dat beheerders deze verwijzingen naar activiteiten niet misbruiken, kunnen de ingangen niet worden gewist tot 24 uur na de betreffende activiteit.';
$helptxt['userlog'] = '<strong>Profiel Wijzigingslog</strong><br> Op deze pagina kunnen beheerder zien welke wijzigingen leden hebben gemaakt in hun profiel. Deze pagina is benaderbaar vanuit een gebruikers profiel.';
$helptxt['warning_enable'] = '<strong>Gebruiker-waarschuwingssysteem</strong><br>
	Deze feature stelt leden van het beheer- en moderatieteam in staat om waarschuwingen te geven aan gebruikers, en om aan de hand van de waarschuwingsstatus bepaalde
	functies op het forum voor hen uit te schakelen. Wanneer deze functie wordt ingeschakeld, zal er een extra permissie beschikbaar komen in het permissiesscherm om aan te geven
	welke groepen waarschuwingen mogen geven aan gebruikers. Waarschuwingsniveaus kunnen gewijzigd worden vanuit het profiel van een gebruiker. De volgende mogelijkheden zijn beschikbaar:
	<ul class="normallist">
		<li>
			<strong>Waarschuwingsniveau voor gebruikerstoezicht</strong><br>
			Deze instelling definieert het percentage waarschuwing dat de gebruiker dient te bereiken om automatisch onder toezicht gezet te worden.
			Elke gebruiker met deze status zal in het moderatiecentrum in de gaten worden gehouden.
		</li>
		<li>
			<strong>Waarschuwingsniveau voor berichtgoedkeuring</strong><br>
			Alle berichten geplaatst door gebruikers die dit percentage voorbij komen, zullen eerst goedgekeurd moeten worden door een beheerder of moderator van dit forum.
			Dit zal onafhankelijk werken van eventuele permissies die op een specifiek board van toepassing zijn.
		</li>
		<li>
			<strong>Waarschuwingsniveau voor gebruiker stillegging</strong><br>
			Als dit waarschuwingsniveau is bereikt, zal de gebruiker in kwestie geen berichten meer kunnen plaatsen voor een bepaalde tijd.
		</li>
		<li>
			<strong>Maximaal aantal waarschuwingspunten per dag</strong><br>
			Deze instelling limiteert het aantal punten dat een moderator dagelijks kan toevoegen of aftrekken van de waarschuwingsstatus van een willekeurige gebruiker. Dit
			kan gebruikt worden om een moderator te limiteren tot een bepaalde hoeveelheid acties gedurende een bepaalde tijd. Deze instelling kan ook uitgeschakeld worden door een waarde van nul op te geven. Merk op dat
			gebruikers met beheerderrechten geen hinder ondervinden van deze instelling.
		</li>
	</ul>';
$helptxt['warning_watch'] = 'Deze instelling bepaald welk percentage het waarschuwing niveau dat een deelnemer moet bereiken voordat er een automatische &quot;bewaking&quot; voor de deelnemer wordt ingesteld. Elke deelnemer die &quot;bewaakt&quot; wordt verschijnt in de lijst van bewaakte leden in het moderatie centrum.';
$helptxt['warning_moderate'] = 'Elke deelnemer die deze waarde passeert zal merken dat al zijn berichten eerst door een moderator moeten worden goedgekeurd voordat deze op het forum verschijnen. Dit heeft voorrang boven alle board gerelateerde instellingen voor bericht moderatie.';
$helptxt['warning_mute'] = 'Als deze waarde wordt gepasseerd zal de deelnemer merken dat hij verbannen is voor het plaatsen van berichten. Deze deelnemer verliest al zijn rechten om berichten te plaatsen.';
$helptxt['user_limit'] = 'This setting limits the amount of points a moderator may add/remove to any particular member in a twenty four hour period. This
			can be used to limit what a moderator can do in a small period of time. This can be disabled by setting it to a value of zero. Note that
			any members with administrator permissions are not affected by this value.';

$helptxt['error_log'] = '<strong>Foutenlog</strong><br>
	Het foutenlog toont alle fouten die het forum genereert. Het laat alle fouten zien, gesorteerd op datum. De volgorde kun je aanpassen door
	op het zwarte pijltje naast iedere datum. Je kunt ook nog de fouten filteren door op de afbeelding naast iedere foutmelding te klikken.
	Zo kun je bijvoorbeeld per lid filteren. Als een filter actief is, zie je alleen de resultaten die bij dat filter behoren.';
$helptxt['theme_settings'] = '<strong>Thema-instellingen</strong><br>
	Dit scherm laat je alle instellingen van een bepaald thema aanpassen. Je kunt hier bijvoorbeeld de thema directory en URL informatie
	wijzigen maar ook opties aanpassen die betrekking hebben op de lay-out van het forum. De meeste thema\'s hebben een aantal opties die kunnen worden
	geconfigureerd door leden om zo aan hun persoonlijke wensen tegemoet te komen.';
$helptxt['smileys'] = '<strong>Smileys en bericht iconen</strong><br>
	Hier kun je smileys en smiley sets toevoegen en verwijderen. Denk er aan dat je een smiley in alle sets laat voorkomen. Als je een smiley in een enkele set toevoegt, zou dit
	verwarrend kunnen worden voor leden die verschillende sets gebruiken.<br><br>

	Je kunt vanuit dit scherm ook de aangepaste berichticonen bewerken, indien je die hebt ingeschakeld op de instellingen-pagina.';
$helptxt['calendar'] = '<strong>Beheer kalender</strong><br>
	Hier kun je de huidige kalenderinstellingen bewerken en feestdagen onderhouden die op de kalender zichtbaar zijn.';
$helptxt['cal_export'] = 'Exporteert een tekst bestand in het iCal formaat voor importeren in andere kalender applicaties';
$helptxt['cal_highlight_events'] = 'Met deze instelling kun je evenementen laten markeren op de Mini Kalender, Hoofd Kalender, in allebei of het markeren van evenementen helemaal uitzetten.';
$helptxt['cal_highlight_holidays'] = 'Met deze instelling kun je feestdagen laten markeren op de Mini Kalender, Hoofd Kalender, in allebei of het markeren van feestdagen helemaal uitzetten.';
$helptxt['cal_highlight_birthdays'] = 'Met deze instelling kun je verjaardagen laten markeren op de Mini Kalender, Hoofd Kalender, in allebei of het markeren van verjaardagen helemaal uitzetten.';
$helptxt['cal_disable_prev_next'] = 'Met deze instelling is het mogelijk om de weergave van de drie maand blokken die links op de pagina getoond worden uit te zetten.';
$helptxt['cal_display_type'] = 'Deze instelling geeft je de mogelijkheid om de weergave van de kalender aan te passen.<br><br><strong>Comfortabel:</strong> maakt de weergave van de rijen in de kalender groot.<br><strong>Compact:</strong> maakt de weergave van de rijen in de kalender klein.';
$helptxt['cal_week_links'] = 'Als de optie is geselecteerd zullen er links worden getoond naast elke week in de kalender.';
$helptxt['cal_prev_next_links'] = 'Als deze optie is geselecteerd, worden boven elke maand links getoond om eenvoudig naar de volgende en vorige maand te gaan.';
// argument(s): $txt['months_short'][1], $txt['months_titles'][1]
$helptxt['cal_short_months'] = 'Als deze optie is geactiveerd worden de namen van maanden in de kalender afgekort.<br><br><strong>Ingeschakeld:</strong> 1 %1$s<br><strong>Uitgeschakeld:</strong> 1 %2$s';
// argument(s): $txt['days_short'][1], $txt['days'][1]
$helptxt['cal_short_days'] = 'Als deze optie is geactiveerd worden de namen van dagen in de kalender afgekort.<br><br><strong>Ingeschakeld:</strong> %1$s<br><strong>Uitgeschakeld:</strong> %2$s';

$helptxt['serversettings'] = '<strong>Serverinstellingen</strong><br>
	Hier kun je de basis configuratie van je forum instellen. Deze pagina bevat de database- en URL-instellingen, alsook andere
	belangrijke configuratie items zoals mailinstellingen en caching. Denk goed na wanneer je een instelling wil veranderen, want een fout
	zou het forum ontoegankelijk kunnen maken';
$helptxt['manage_files'] = '
	<ul class="normallist">
		<li>
			<strong>Bekijk bestanden</strong><br>
			Blader door alle bijlagen, avatars en miniatuurweergaven die opgeslagen zijn door SMF.<br><br>
		</li><li>
			<strong>Bijlage-instellingen</strong><br>
			Configureer waar bijlagen opgeslagen moeten worden en stel restricties voor de bijlagetypen in.<br><br>
		</li><li>
			<strong>Avatar-instellingen</strong><br>
			Configureer waar avatars opgeslagen worden en stel het aanpassen van avatars in.<br><br>
		</li><li>
			<strong>Bestandsonderhoud</strong><br>
			Controleer en repareer fouten in de bijlagenmap en verwijder beschadigde bijlagen.<br><br>
		</li>
	</ul>';

$helptxt['topicSummaryPosts'] = 'Hier geef je aan hoeveel berichten je wilt laten zien in de topic samenvatting die getoond wordt bij het reageren op een topic.';
$helptxt['enableAllMessages'] = 'Stel dit in op het <em>maximaal</em> aantal berichten dat een topic mag hebben voor het tonen van de \'allemaal\'-link. Als dit lager wordt ingesteld dan de &quot;Maximum aantal berichten vertonen op &eacute;&eacute;n pagina&quot;-instelling, zal de link simpelweg nooit getoond worden, terwijl een te hoge instelling het forum zou kunnen vertragen.';
$helptxt['allow_guestAccess'] = 'Als dit vak niet is aangevinkt, zullen gasten niets anders kunnen doen dan de primaire acties - inloggen, registreren, wachtwoordherinnering opvragen, etc. - op je forum. Dit is niet hetzelfde als gasten de toegang verhinderen tot de boards.';
$helptxt['userLanguage'] = 'Wanneer deze optie is ingeschakeld, krijgt de gebruiker de optie om zelf de taal te kiezen waarin het forum wordt weergegeven. De standaardtaal zal hetzelfde blijven.';
$helptxt['trackStats'] = 'Statistieken:<br>Dit zal leden in staat stellen om de meest recente en meest populaire topics van je forum te kunnen zien.
	Ook zullen diverse andere statistieken worden getoond, zoals het hoogste aantal bezoekers, nieuwe leden en nieuwe topics.<hr>
	Paginaweergaven:<br>Voegt een extra kolom toe aan de statistiekenpagina met daarin het aantal paginaweergaven van je forum.';
$helptxt['titlesEnable'] = 'Het activeren van extra titels geeft leden die daartoe de permissies hebben gekregen de mogelijkheid om zelf een extra titel onder hun gebruikersnaam te laten zien.<br><em>Bijvoorbeeld:</em><br>Jeff<br>Toffe gast';
$helptxt['onlineEnable'] = 'Deze optie toont een afbeelding waaraan je kunt zien of een lid online of offline is.';
$helptxt['todayMod'] = 'Dit zal, indien ingeschakeld, in de datum &quot;Vandaag&quot; of &quot;Gisteren&quot; weergeven.<br><br>
		<strong>Voorbeelden:</strong><br><br>
		<ul class="normallist"> 
			<li><strong>Uitgeschakeld</strong><br> 3 oktober 2009 om 12:59:18</li> 
			<li><strong>Alleen vandaag</strong><br> Vandaag om 12:59:18</li> 
			<li><strong>Vandaag en gisteren</strong><br> Gisteren om 21:36:55</li> 
		</ul>';
$helptxt['disableCustomPerPage'] = 'Vink deze optie aan om ervoor te zorgen dat gebruikers niet zelf in kunnen stellen hoeveel topics ze per pagina op de topicindex en hoeveel berichten ze per pagina in een topicweergave zien.';
$helptxt['enablePreviousNext'] = 'Hiermee worden links gegeven naar het volgende en vorige topic.';
$helptxt['pollMode'] = 'Deze functie is om leden toe te staan om polls te starten. Wanneer polls zijn uitgeschakeld, zullen bestaande polls worden verborgen in de topic lijsten. Je kunt er ook voor kiezen om de topics zonder hun polls te laten zien, door &quot;Toon polls als topics&quot; te kiezen.<br><br>Om te kunnen bepalen wie polls kan plaatsen, bekijken enz., kun je de betreffende permissies toestaan of ontzeggen. Onthoud dit voor als polls niet werken.';
$helptxt['enableCompressedOutput'] = 'Deze optie zal de uitvoer van het forum comprimeren om dataverkeerverbruik te besparen, maar het vereist wel dat
		zlib is ge&iuml;nstalleerd.';
$helptxt['httponlyCookies'] = 'Cookies zullen niet toegankelijk zijn voor script talen, zoals Javascript. Deze instelling kan helpen om diefstal van identiteiten door XSS aanvallen te voorkomen. Het kan problemen geven met scripts van derden, maar moet indien mogelijk ingeschakeld zijn.';
$helptxt['samesiteCookies'] = 'Het SameSite attribuut in de Set-Cookie HTTP response header geeft je de mogelijkheid om aan te geven of je cookie beperkt moet worden tot een \'eigen\' partij of \'same-site\' context. Meer informatie is te vinden op <a href="https://developer.mozilla.org/docs/Web/HTTP/Headers/Set-Cookie/SameSite">MDN</a>';
$helptxt['databaseSession_enable'] = 'Deze optie maakt gebruik van de database voor het opslaan van sessies - het werkt het best op load balanced servers, maar helpt tegen allerlei sessie-timeoutproblemen en kan het forum sneller maken.';
$helptxt['databaseSession_loose'] = 'Het aanzetten van deze optie bespaart dataverkeer van je forum, en zorgt ervoor dat het klikken op \'terug\' niet de pagina zal herladen - het nadeel is echter dat de (nieuw) iconen niet worden geactualiseerd, net als enkele andere dingen (tenzij je de pagina aanklikt in plaats van terug te gaan naar die pagina).';
$helptxt['databaseSession_lifetime'] = 'Dit is het aantal seconden dat een sessie blijft bestaan nadat deze voor het laatst is gebruikt. Als de sessie niet gebruikt wordt voor een te lange tijd, dan treedt er een \'timeout\' op. Een waarde hoger dan 2400 wordt aanbevolen.';
$helptxt['tfa_mode'] = 'Je kunt een extra veiligheidsmaatregel inschakelen door <a href="https://en.wikipedia.org/wiki/Two_factor_authentication">twee-factor-authenticatie</a> te activeren. TFA zorgt ervoor dat gebruikers een extra gegeneerde code moeten invullen na het inloggen. Zorg ervoor dat je TFA eerst voor jezelf instelt voordat je dit voor andere gebruikers verplicht kunt stellen!';
$helptxt['cache_enable'] = 'SMF kent caching op verschillende niveau\'s. Hoe hoger het niveau van cache, hoe meer CPU tijd er wordt gebruikt voor het ophalen van ge-cachete informatie. Als caching beschikbaar is op je machine wordt het aangeraden om eerst cache op niveau 1 te proberen.';
$helptxt['cache_memcached'] = 'Als je memcached gebruikt dien je de server details op te geven. Deze moeten opgegeven worden als een komma-gescheiden lijst zoals in onderstaand voorbeeld:<br><br>	&quot;server1,server2,server3:port,server4&quot;<br><br>Let op dat als er geen poort is opgegeven SMF poort 11211 zal gebruiken tenzij in de hostnaam een slash staat, dan zal worden aangenomen dat het een alternatieve server is en wordt poort 0 gebruikt. SMF zal proberen om een willekeurige load balancing over de opgegeven servers te doen.';
$helptxt['cache_cachedir'] = 'Deze instelling is alleen voor het smf bestands-gebaseerd cache systeem. Het bevat het pad naar de cache map. Het wordt aanbevolen deze in /tmp/ te plaatsen als je deze wilt gebruiken, maar het werkt ook met andere mappen';
$helptxt['cache_sqlite_cachedir'] = 'Deze instelling is alleen voor het SQLite database cache systeem. Het bepaalt het pad naar de cache map. Het wordt aanbevolen deze in de /tmp/ map te plaatsen als je het wilt gebruiken, maar het zal ook werken met een andere map';
$helptxt['enableErrorLogging'] = 'Dit zal alle fouten, zoals een mislukte inlogpoging, loggen, zodat je later kunt bekijken wat er fout is gegaan.';
$helptxt['enableErrorQueryLogging'] = 'Dit zal de volledige naar de server verzonden query opslaan wanneer er een databasefout ontstaat. Daarvoor dient fouten loggen wel aan te staan.<br><br><strong>Let op: dit zal ook de mogelijkheid om fouten te filteren aantasten.</strong>';
$helptxt['disallow_sendBody'] = 'Deze optie schakelt de optie uit om de teksten van reacties en bericht in de notificatie-mailtjes te ontvangen<br><br>Vaak reageren leden op de notificatie-e-mail wat in de meeste gevallen betekent dat de forumbeheerder de reactie ontvangt.';
$helptxt['enable_ajax_alerts'] = 'De optie stelt gebruikers in staat om AJAX notificaties te ontvangen. Hiermee hoeven gebruikers de pagina\'s niet te verversen om nieuwe notificaties te ontvangen.<br><strong>LET OP:</strong> Als er veel gebruikers online zijn kan dit een zware last op de server veroorzaken.';
$helptxt['alerts_auto_purge'] = 'Zodra een notificatie is gelezen, is deze zelden meer relevant. Vanwege performance redenen is het raadzaam deze periodiek te op te schonen.';
$helptxt['jquery_source'] = 'Dit zal de bron bepalen van waaruit de jQuery-bibliotheek wordt geladen. <em>Google CDN, jQuery CDN</em> en <em>Microsoft CDN</em> zullen de jQuery-bibliotheek laden vanuit die respectievelijke CDN netwerken. <em>Lokaal</em> zal enkel de lokale bron gebruiken. <em>Aangepast</em> stelt je in de mogelijkheid om een aangepaste URL te specifiëren voor de bibliotheek.';
$helptxt['compactTopicPagesEnable'] = 'Deze optie zorgt voor een selectieve weergave van het aantal pagina\'s.<br><em>Voorbeeld:</em><br>
	&quot;3&quot; resultaat: 1 ... 4 [5] 6 ... 9 <br>
	&quot;5&quot; resultaat: 1 ... 3 4 [5] 6 7 ... 9';
$helptxt['timeLoadPageEnable'] = 'Deze optie geeft onderaan de pagina in seconden weer hoelang SMF nodig had om de pagina op te bouwen.';
$helptxt['removeNestedQuotes'] = 'Deze optie zal citaten die al in een post aanwezig zijn verwijderen wanneer een bericht wordt geciteerd via een citaatknop.';
$helptxt['max_image_width'] = 'Deze optie stelt je in staat om een maximum formaat in te stellen voor geplaatste afbeeldingen. Afbeeldingen kleiner dan het maximum zullen niet worden uitgerekt.';
$helptxt['mail_type'] = 'Met deze instelling kun je kiezen of je de standaard PHP-instellingen wilt gebruiken of dat je deze wilt vervangen door SMTP-instellingen. PHP ondersteunt geen authenticatie voor SMTP (wat door veel servers wel vereist wordt), dus als je dat wel wilt, moet je SMTP selecteren. Denk erom dat SMTP langzamer kan werken en bovendien zullen sommige servers geen gebruikersnaam en wachtwoord accepteren.<br><br>Je hoeft geen SMTP-instellingen in te vullen als je de standaard PHP-instellingen gebruikt.';
$helptxt['attachment_manager_settings'] = 'Bijlagen zijn bestanden die leden kunnen uploaden, en kunnen bijvoegen aan een bericht. Je kunt hier de instellingen voor dit forum instellen.';
$helptxt['attachmentCheckExtensions'] = 'Hiermee kun je desgewenst de soorten bijlagen die gebruikers kunnen uploaden beperken door de extensie te controleren: b.v. myphoto.jpg heeft een jpg extensie.';
// References setting attachmentCheckExtensions
$helptxt['attachmentExtensions'] = 'Als de optie "controleer bijlage extensies" hierboven is geselecteerd staan hier de extensies die zijn toegestaan voor nieuwe bijlagen.';
$helptxt['attachmentUploadDir'] = 'Het pad naar de bijlagenmap op de server<br>(bijvoorbeeld: /home/sites/yoursite/www/forum/attachments)';
$helptxt['attachmentDirSizeLimit'] = 'Geef op hoe groot de bijlagenmap mag worden, inclusief alle bestanden erin.';
$helptxt['attachmentPostLimit'] = 'Geef op wat de maximale bestandsgrootte (in KB) mag zijn voor alle bijlagen in een bericht. Als deze lager is dan de de limiet per bijlage, dan wordt dat de limiet.';
$helptxt['attachmentSizeLimit'] = 'Geef op wat de maximale bestandsgrootte mag zijn per bijlage.';
$helptxt['attachmentNumPerPostLimit'] = 'Geef het aantal bijlagen op dat een deelnemer mag toevoegen per bericht.';
$helptxt['attachmentShowImages'] = 'Als het bijgevoegde bestand een afbeelding is zal deze worden getoond onder het bericht.';
$helptxt['attachmentThumbnails'] = 'Als deze instelling is gemaakt, zal er een extra (kleinere) bijlage als miniatuur gemaakt worden om bandbreedte te besparen.';
$helptxt['attachmentThumbWidth'] = 'Alleen relevant in combinatie met de &quot;Verklein afbeeldingen bij weergave onder bericht&quot; instelling. Dit is de maximale breedte voor het verkleinen van afbeeldingen. Deze zullen proportioneel verkleind worden.';
$helptxt['attachmentThumbHeight'] = 'Alleen relevant in combinatie met de &quot;Verklein afbeeldingen bij weergave onder bericht&quot; instelling. Dit is de maximale hoogte voor het verkleinen van afbeeldingen. Deze zullen proportioneel verkleind worden.';
$helptxt['attachmentDirFileLimit'] = 'Maximaal aantal bestanden per map';
$helptxt['attachmentEnable'] = 'This setting enables you to configure how attachments can be made.<br><br>
	<ul class="normallist">
		<li>
			<strong>Disable all attachments</strong><br>
			All attachments are disabled. Existing attachments are not deleted, but they are hidden from view (even administrators cannot see them). New attachments cannot be made either, regardless of permissions.<br><br>
		</li>
		<li>
			<strong>Enable all attachments</strong><br>
			Everything behaves as normal, users who are permitted to view attachments can do so, users who are permitted to upload can do so.<br><br>
		</li>
		<li>
			<strong>Disable new attachments</strong><br>
			Existing attachments are still accessible, but no new attachments can be added, regardless of permission.
		</li>
	</ul>';
$helptxt['attachment_image_paranoid'] = 'Het inschakelen van deze optie zal zeer stricte bveiligingscontroles op afbeeldingsbijlagen inschakelen. Waarschuwing! Deze uitgebreide controles kunnen ook falen op onschadelijke afbeeldingen. Het wordt sterk aanbevolen om deze optie alleen te gebruiken in combinatie met het herencoderen van afbeeldingen, zodat SMF afbeeldingen die niet door de controle komen herencodeert en daarmee opschoont. In het andere geval, als herencoderen van afbeeldingen niet ingeschakeld is, zullen alle bijlagen die de controles niet passeren worden verworpen.';
$helptxt['attachment_image_reencode'] = 'Het inschakelen van deze optie zal herencoderen van geüploade afbeeldingsbijlagen inschakelen. Herencoderen van afbeeldingen verhoogt de beveiliging, zal tevens het verdwijnen van eventuele animaties in afbeeldingen tot gevolg hebben. <br> Deze feature is enkel te gebruiken als de GD-module is geïnstalleerd op je server.';
$helptxt['attachment_thumb_memory'] = 'Hoe groter de originele afbeelding (bestandsgrootte & breedte x hoogte), hoe meer geheugen het kost om een miniatuur afbeelding te maken.<br>Op basis van deze instelling zal het systeem een inschatting maken van de noodzakelijke geheugenruimte en deze aanvragen. Alleen als deze ruimte beschikbaar is zal het proberen de miniatuur aan te maken.<br>Dit zal minder witte fout pagina\'s geven maar er zullen mogelijk ook minder miniaturen gemaakt worden. Als dit niet ingesteld wordt zal het systeem altijd proberen een miniatuur te maken (met een vaste geheugenruimte). Dit zal mogelijk meer witte fout pagina\'s geven.';
$helptxt['attachmentRecodeLineEndings'] = 'Het script zal regeleinden her-encoderen volgens de instellingen van je server.';
$helptxt['automanage_attachments'] = 'Met de standaard instelling zal SMF nieuwe bijlages in een enkele map plaatsen. Dit is geen probleem voor de meeste sites, maar als een site erg groot wordt kan het nuttig zijn om de bestanden over meerdere mappen te verdelen.<br><br>Met deze instelling kun je aangeven of je deze mappen zelf wilt beheren (dus dat je een extra map aanmaakt en deze gaat gebruiken als je er klaar voor bent) of dat je dit door SMF laat doen, gebaseerd or criteria, zoals wanneer de huidige map een bepaalde grootte bereikt, of door de mappen te verdelen naar jaren of zelf maanden (op erg drukke sites).';
$helptxt['dont_show_attach_under_post'] = 'Met deze instelling zullen de afbeeldingen die zijn ingevoegd in het bericht niet onder het bericht getoond worden. Ze kunnen nog steeds verwijderd worden.';
$helptxt['use_subdirectories_for_attachments'] = 'Maak nieuwe mappen aan.';
$helptxt['max_image_height'] = 'Zoals bij de maximale breedte, bepaalt deze instelling de maximale hoogte die een afbeelding kan hebben.';
$helptxt['avatar_paranoid'] = 'Inschakelen van deze optie zal zeer stricte bveiligingscontroles op avatars inschakelen. Waarschuwing! Deze uitgebreide controles kunnen ook falen op onschadelijke avatars. Het wordt sterk aanbevolen om deze optie alleen te gebruiken in combinatie met het herencoderen van avatars, zodat SMF avatars die niet door de controle komen herencodeert en daarmee opschoont. In het andere geval, als herencoderen van avatars niet ingeschakeld is, zullen alle avatars die de controles niet passeren worden verworpen';
$helptxt['avatar_reencode'] = 'Het inschakelen van deze optie zal herencoderen van geüploade avatars inschakelen. Herencoderen van avatars verhoogt de beveiliging, zal tevens het verdwijnen van eventuele animaties in avatars tot gevolg hebben. <br> Deze feature is enkel te gebruiken als de GD-module is geïnstalleerd op je server.';
$helptxt['cal_enabled'] = 'De kalender kan worden gebruikt om verjaardagen te tonen, of om belangrijke gebeurtenissen op het forum aan te geven. Deze instelling activeert de kalender functie in het forum.';
$helptxt['cal_link_postevent'] = 'Dit zal leden toestaan om gebeurtenissen voor een dag aan te maken als ze op die dag klikken';
$helptxt['cal_maxdays_advance'] = 'Als dit op 7 staat zal de volgende week aan gebeurtenissen worden weergegeven';
$helptxt['cal_allow_unlinkedevents'] = 'Sta leden toe om gebeurtenissen te plaatsen zonder te vereisen dat ze gekoppeld zijn aan een bericht in een board';
$helptxt['cal_min_year'] = 'Kies het &quot;eerste&quot; jaar op de kalenderlijst';
$helptxt['cal_max_year'] = 'Kies het &quot;laatste&quot; jaar op de kalenderlijst';
$helptxt['cal_maxevent_span'] = 'Kies het maximum aantal dagen dat een gebeurtenis kan omvatten';
$helptxt['localCookies'] = 'SMF gebruikt cookies om inlog informatie op te slaan op de computer van de gebruiker.
	Cookies kunnen globaal worden opgeslagen (mijndomein.nl) of lokaal (mijndomein.nl/pad/naar/forum).<br><br>
	Vink deze optie aan als je problemen ondervindt met gebruikers die automatisch uitgelogd worden.<hr>
	Globaal opgeslagen cookies zijn een stuk minder veilig indien er sprake is van een gedeelde webserver (zoals Tripod).<hr>
	Lokaal opgeslagen cookies werken niet buiten de forummap, dus wanneer je is opgeslagen op www.mijnsite.nl/forum, hebben pagina\'s als www.mijnsite.nl/index.php geen toegang tot de accountinformatie.<br><br>
	Zeker wanneer je gebruik maakt van SSI.php, worden globaal opgeslagen cookies aanbevolen.';
$helptxt['enableBBC'] = 'Deze optie biedt de leden de mogelijkheid om Bulletin Board Code (BBC) te gebruiken op het forum, waardoor ze afbeeldingen kunnen tonen en andere opmaak mogelijkheden krijgen.';
$helptxt['legacy_bbc'] = 'Oude BBCodes zijn gedateerde codes en kunnen niet gebruikt worden in nieuwe berichten. Ze zullen echter wel verwerkt en getoond worden in bestaande berichten als dit hier wordt ingesteld.<br><br>Het activeren van oude BBCodes is dan ook alleen nuttig als je forum is geüpgrade van een oude versie van SMF.<br><br>Zelfs als de codes hier worden geactiveerd zullen sommige oude BBCodes niet op dezelfde manier worden getoond als voorheen. De [flash] BBCode bijvoorbeeld zal simpelweg een link naar de Flash inhoud tonen en deze niet insluiten zoals voorheen.';
$helptxt['default_timezone'] = 'Dit is de standaard tijdzone die wordt gebruikt voor het weergeven van tijden in het forum.';
$helptxt['timezone_priority_countries'] = 'Deze instelling stelt je in staat om de tijdzone voor een land of voor landen bovenaan te plaatsen in de lijst van tijdzones die een gebruiker kan kiezen bij het instellen van zijn profiel, het aanmaken van gebeurtenissen in de kalender, enzovoort.<br><br>Als bijvoorbeeld veel leden van je forum uit Nieuw Zeeland of Fiji komen, dan kun je "NZ,FJ" invullen om het voor hen makkelijker te maken om de relevante tijdzone te vinden.<br><br>De complete lijst met ISO landcode is te vinden op het internet door te zoeken naar "<a href="https://www.google.com/search?q=iso+3166-1+alpha-2" target="_blank" rel="noopener">ISO 3166-1 alpha-2</a>".';
$helptxt['spamWaitTime'] = 'Hier kun je aangeven hoeveel tijd er dient te zitten tussen het plaatsen van berichten. Dit kan voorkomen dat mensen gaan &quot;spammen&quot; op het forum.';

$helptxt['enablePostHTML'] = 'Dit zal leden toestaan enkele basis HTML-tags te gebruiken:
	<ul class="normallist">
		<li>&lt;b&gt;, &lt;u&gt;, &lt;i&gt;, &lt;s&gt;, &lt;em&gt;, &lt;strong&gt;, &lt;ins&gt;, &lt;del&gt;</li>
		<li>&lt;a href=&quot;&quot;&gt;</li>
		<li>&lt;img src=&quot;&quot; alt=&quot;&quot; /&gt;</li>
		<li>&lt;br&gt;, &lt;hr&gt;</li>
		<li>&lt;pre&gt;, &lt;blockquote&gt;</li>
	</ul>';

$helptxt['themes_manage'] = 'Hier kunt u nieuwe thema\'s installeren en selecteren uit welke thema\'s gebruikers kunnen kiezen, het standaardthema dat nieuwe gebruikers en gasten zullen gebruiken, alsook andere instellingen voor themaselectie.';
$helptxt['theme_install'] = 'Je kunt hier nieuwe thema\'s installeren. Je kunt dit doen vanuit een reeds bestaande directory, door een archief voor het thema te uploaden, of door het standaard thema te kopieëren.<br><br>Let op dat het archief of de directory een <pre>theme_info.xml</pre> definitiebestand moet bevatten.';
$helptxt['xmlnews_enable'] = 'Staat gebruikers toe om te verwijzen naar <a href="%1$s?action=.xml;sa=news" target="_blank" rel="noopener">Actuele berichten</a> en soortgelijke gegevens. Het is aan te bevelen dat je de grootte van de (nieuws)berichten beperkt, omdat RSS-data in sommige clients wordt afgekapt na een aantal woorden.';
$helptxt['xmlnews_attachments'] = 'Laat links naar bijlagen ingesloten worden in je XML/RSS-feeds. Zet dit aan als je je forum wilt gebruiken voor podcasting, broadcatching of soortgelijke distributieplatforms.
	<br><br>
	De "bekijk bijlagen"-permissie beïnvloedt deze instelling. Leden en gasten zullen alleen de bijlagen van een bericht in de feed zien als ze ook de bijlage kunnen zien op de webpagina van het bericht. Merk op dat de meeste feedlezers je feeds zullen bezoeken als een gast.
	<br><br>
	Sommige feed-formaten staan maar één bijlage per bericht toe. Als een bericht meerdere bijlagen heeft zal SMF alleen de grootste insluiten in deze feeds.';
$helptxt['globalCookies'] = 'Maakt de forumcookies beschikbaar op subdomeinen. Bijvoorbeeld als...<br>
	Je website op https://www.simplemachines.org/ staat,<br>
	en je forum op https://forum.simplemachines.org/ staat,<br>
	dan stelt deze instelling je in staat om het forumcookie op je site te gebruiken. Schakel deze optie niet in als er andere subdomeinen zijn (zoals hacker.simplemachines.org) die niet door jou beheerd worden.<br><br>
	Deze instelling werkt niet als cookies lokaal worden opgeslagen.';
$helptxt['globalCookiesDomain'] = 'Als je subdomein onafhankelijke cookies (globale cookies) gebruikt, kun je hier opgeven welk domein gebruikt moet worden. Deze moet, natuurlijk, ingesteld worden op je hoofd domein: bijvoorbeeld, als je gebruik maakt van <em>forum.voorbeeld.com</em> en <em>www.voorbeeld.com</em>, dan moet het domein ingesteld worden op <em>voorbeeld.com</em>. Je hoeft geen <em>http://</em> of <em>https://</em> ervoor te plaatsen.';
$helptxt['secureCookies'] = 'Het inschakelen van deze optie zal ervoor zorgen dat nieuwe cookies altijd gemarkeerd zullen worden als veilig. Schakel deze optie alleen in als je het HTTPS-protocol gebruikt op je site, anders zullen cookies niet juist afgehandeld worden!';
$helptxt['securityDisable'] = 'Wanneer ingeschakeld zal dit de extra wachtwoordcontrole voor het beheergedeelte <em>uitschakelen</em>. Dit wordt niet aanbevolen!';
$helptxt['securityDisable_why'] = 'Dit is je huidige wachtwoord (hetzelfde dat je gebruikt om in te loggen).<br><br>Dit is een extra controle om te bepalen dat <strong>JIJ</strong> toegang hebt tot dit gedeelte.';
$helptxt['securityDisable_moderate'] = 'Wanneer ingeschakeld zal dit de extra wachtwoordcontrole voor het moderatiegedeelte <em>uitschakelen</em>. Deze instelling is standaard ingeschakeld.';
$helptxt['securityDisable_moderate_why'] = 'Dit is je huidige wachtwoord. (hetzelfde dat je gebruikt om in te loggen).<br><br>Het opgeven helpt om te controleren dat je zeker weet dat je de moderatie echt wilt uitvoeren, en dat <strong>JIJ</strong> het bent die het doet.';
$helptxt['allow_cors'] = 'Cross Origin Resource Sharing of CORS is een beleid voor moderne browsers om bronnen te vertrouwen die vanuit domeinen worden aangevraagd. Als dit is ingeschakeld, zal dit het CORS-beleid proberen op te lossen voor scripts die toegang hebben tot het forum vanuit verschillende domeinen. Als subdomein-onafhankelijke cookies (globale cookies) zijn ingeschakeld, wordt geprobeerd het juiste domein te bepalen. De extra CORS-domeinen kunnen worden opgegeven middels een komma-gescheiden lijst van domeinen. De indeling moet zijn {SCHEMA}://{DOMAIN}. Als er een jokerteken (*) is opgegeven in het domein, wordt geprobeerd om deze op te lossen. Als een jokerteken (*) wordt opgegeven als het enige extra domein, zijn alle domeinen toegestaan en dit kan een veiligheidsrisico vormen voor uw forum en zou niet moeten worden gebruikt, behalve in extreme gevallen. Extra koppen kunnen worden opgegeven in een komma-gescheiden lijst: deze zijn toegestaan tijdens verzoeken met deze headers en jokertekens (*) zijn toegestaan.';
$helptxt['frame_security'] = 'Moderne browsers ondersteunen een door servers gepresenteerde beveiligingsheader genaamd X-Frame-Options. Met deze instelling geef je aan op welke manier je wilt toestaan dat je website in een frameset of iframe geplaatst wordt. Door dit uit te zetten worden er geen headers gestuurd en dit is het meest onveilig, maar geeft wel de meeste vrijheid. Ontzeggen zal alle frames volledig blokkeren en is het meest beperkend en veilig. Door gelijke herkomst (Same Origin) toe te staan is het alleen op je eigen domein mogelijk om frames te gebruiken en geeft een middenweg van beide beide voorgaande opties.';
$helptxt['proxy_ip_header'] = 'Dit is de serverheader die door SMF vertrouwd wordt om de IP-adressen van bezoekers te bevatten. Het wijzigen van deze instelling kan onverwachte IP-resultaten voor leden veroorzaken. Controleer dit met je serverbeheerder, CDN-provider of proxybeheerder voordat je deze instellingen wijzigt. De meeste providers zullen dit begrijpen en gebruik maken van HTTP_X_FORWARDED_FOR. Je moet de lijst met servers onderhouden die de reverse proxy headers sturen om er zeker van te zijn dat deze van geldige bronnen komen.';
$helptxt['email_members'] = 'In this message you can use a few &quot;variables&quot;. These are:<br>
	{$board_url} - The URL to your forum.<br>
	{$current_time} - The current time.<br>
	{$member.email} - The current member\'s email.<br>
	{$member.link} - The current member\'s link.<br>
	{$member.id} - The current member\'s id.<br>
	{$member.name} - The current member\'s name. (for personalization).<br>
	{$latest_member.link} - The most recently registered member\'s link.<br>
	{$latest_member.id} - The most recently registered member\'s id.<br>
	{$latest_member.name} - The most recently registered member\'s name.';

$helptxt['failed_login_threshold'] = 'Stel het aantal pogingen in die een gebruiker kan wagen alvorens naar het scherm te worden gestuurd waar hij zijn wachtwoord kan laten opsturen.';
$helptxt['loginHistoryDays'] = 'Het aantal dagen dat de logingeschiedenis onder gebruikersprofiel-tracering wordt bewaard. De standaardwaarde is 30 dagen.';
$helptxt['oldTopicDays'] = 'Als deze optie is ingesteld, wordt er een waarschuwing getoond wanneer een lid probeert te reageren op een topic waarop al een (gespecificeerd) aantal dagen niet gereageerd is. Zet deze instelling op 0 om deze feature uit te schakelen.';
$helptxt['edit_wait_time'] = 'Aantal seconden na plaatsing waarin een bericht bewerkt kan worden zonder als bewerkt te worden gemarkeerd.';
$helptxt['edit_disable_time'] = 'Aantal minuten die mogen verstrijken, voordat een lid zijn bericht niet langer meer kan wijzigen. Stel op 0 in om deze feature uit te schakelen.<br><br><em>Let op: dit beïnvloedt niet gebruikers met de permissie om andermans bericht aan te passen.</em>';
$helptxt['preview_characters'] = 'Met deze instelling bepaal je het aantal beschikbare karakters dat wordt getoond in de het voorbeeld van het eerste en laatste topic.';
$helptxt['quote_expand'] = 'Met deze instelling is het mogelijke grote citaten in te klappen en de gebruikers de mogelijkheid te geven deze naar wens open te klappen tot de volledige weergave. Citaten die kleiner zijn dan deze instelling worden hierdoor niet geraakt.';
$helptxt['posts_require_captcha'] = 'Deze instelling zal van gebruikers eisen om eerst een anti-spambot verificatiecode over te typen, voor ze een bericht kunnen plaatsen. Alleen gebruikers met een beperkt aantal berichten zullen deze code in moeten voeren. Dit zou moeten helpen tegen spambots.';
$helptxt['disable_wysiwyg'] = 'Deze instelling zorgt ervoor dat geen enkele gebruiker de WYSIWYG-editor (&quot;What You See Is What You Get&quot;) kan gebruiken bij het plaatsen van berichten.';
$helptxt['lastActive'] = 'Stel hier het aantal minuten in dat leden nog actief worden weergegeven op het forum na hun laatste activiteit. Standaard is dit 15 minuten.';

$helptxt['customoptions'] = 'Deze sectie definieert de keuzes die een gebruiker kan kiezen uit een keuzelijst. Er zijn een aantal belangrijke dingen instelbaar:
	<ul class="normallist">
		<li><strong>Standaardkeuze:</strong> de keuze die met het keuzebolletje ernaast (&quot;radio button&quot;) geselecteert is, zal standaard ingesteld zijn bij de profielen van gebruikers.</li>
		<li><strong>Verwijder keuzes:</strong> om een keuze te verwijderen, wis je simpelweg de tekst van die keuze. Alle leden die voor die keuze gekozen hadden, zullen teruggezet worden naar de standaardkeuze.</li>
		<li><strong>Keuzes herordenen:</strong> je kunt de keuzes herordenen door de tekst in de tekstvakken te verwisselen. LET OP! Ben er zeker van dat je de exacte tekst uitwisselt, anders zullen de gebruikerkeuzes verloren gaan.</li>
	</ul>';

$helptxt['autoFixDatabase'] = 'Dit zal automatisch beschadigde tabellen repareren. Je zal een email krijgen zodra dit gebeurt.<br>Als je deze optie uitzet zal je forum down zijn totdat je het merkt en het probleem handmatig oplost.';
// argument(s): scripturl
$helptxt['pgFulltextSearch'] = 'Deze instelling definieert de taal die moet worden gebruikt voor het zoeken in volledige tekstindex van PostgreSQL. Kies de taal die het meest overeenkomt met de taal die je forum daadwerkelijk gebruikt. Als de taal van je forum niet in de lijst staat, of als je forum meertalig is, kies dan de optie "eenvoudig". <br>
Deze instelling is onafhankelijk van uw belangrijkste SMF-taalinstellingen en niet gerelateerd aan de geïnstalleerde taal voor SMF. <br>
Wanneer je deze instelling wijzigt, moet je <a href="%1$s?action=admin;area=managesearch;sa=method" target="_blank" rel="noopener">de volledige zoekindex opnieuw opbouwen</a>.<br>
Als je een taal nodig hebt die niet wordt vermeld, vraag dan je databasebeheerder om PostgreSQL-taalondersteuning voor die taal te installeren.';

$helptxt['enableParticipation'] = 'Dit laat een icoon zien bij de topics waar een gebruiker een bericht in geplaatst heeft.';

$helptxt['db_persist'] = 'Hierdoor wordt de verbinding actief gehouden voor een betere performance. Als je niet op een dedicated server wordt gehost, kan dit problemen met je host opleveren.<br>
Als deze instelling niet actief is dan kan het nodig zijn om de instellingen mysqli.allow_persistent of pgsql.allow_persistent in je php.ini bestand te activeren.';
$helptxt['ssi_db_user'] = 'Optionele instelling die je in staat stelt om een andere database-gebruiker en wachtwoord te gebruiken bij het gebruik van SSI.php.';

// argument(s): either $helptxt['queryless_urls_supported'] or $helptxt['queryless_urls_unsupported'], depending on whether the server uses a supported webserver
$helptxt['queryless_urls'] = 'Deze optie verandert de opmaak van de URLs een beetje, zodat zoekmachines er beter mee overweg kunnen. Ze zullen er uit zien als index.php/topic,1.0.html.<br><br>%1$s';
// is conditionally used as part of $helptxt['queryless_urls']
$helptxt['queryless_urls_supported'] = 'Deze functie zal werken op je server.';
// is conditionally used as part of $helptxt['queryless_urls']
$helptxt['queryless_urls_unsupported'] = 'Deze functie zal niet werken op je server.';
$helptxt['minimize_files'] = 'Met deze optie zullen de CSS- en JavaScript-bestanden die door je forum gebruikt worden automatisch verkleind worden, waardoor je forum sneller zal werken voor je gebruikers.<br><br>Deze instelling laat je normaal gesproken actief. Enige reden om deze tijdelijk uit te zetten kan zijn als je wijzigingen moet doorvoeren in de CSS- of JavaScript-bestanden (bijvoorbeeld tijdens het wijzigen van themabestanden of het ontwikkelen van een modificatie).';
$helptxt['boardindex_max_depth'] = 'Met deze instelling wordt bepaald hoe diep SMF in de sub-boards van een board zal zoeken naar nieuwe berichten. Deze bepaalt ook hoeveel boards er worden meegeteld als de instelling "tel berichten in sub-boards mee in totalen op board niveau" wordt geactiveerd.<br><br>Voorbeeld: als deze instelling op 1 wordt gezet, zal een sub-board alleen gemarkeerd worden als "nieuw" op de indexpagina als het sub-board zelf een nieuw bericht bevat. Als het wordt ingesteld op 2, dan wordt het board met "nieuw" gemarkeerd als er een nieuw bericht is in het sub-board of in het sub-sub-board. Als het is ingesteld op 10, dan wordt het board met "nieuw" gemarkeerd als er een nieuw bericht is in het sub-board, het sub-sub-board, etc... tot 10 niveaus diep.<br><br>Op grote, drukke forums is het raadzaam deze instelling niet te groot te maken om server resources te sparen.';
$helptxt['countChildPosts'] = 'Het selecteren van deze optie zorgt ervoor dat berichten en topics in de sub-boards meegeteld worden op de indexpagina.<br><br>Dit betekent dat een hoofdboard zonder berichten erin niet op \'0\' komt te staan als er wel berichten zijn in de sub-boards.';
$helptxt['allow_ignore_boards'] = 'Het inschakelen van deze optie heeft als gevolg dat gebruikers in kunnen stellen welke boards ze willen negeren.';
$helptxt['deny_boards_access'] = 'Deze instelling maakt het mogelijk om de toegang tot bepaalde boards te ontzeggen voor ledengroepen';

// argument(s): scripturl
$helptxt['who_enabled'] = 'Deze optie geeft je de mogelijkheid om de <a href="%1$s?action=who" target="_blank" rel="noopener">Wie is online</a> pagina aan of uit te zetten, welke toont wie er op het forum is en wat iedereen aan het doen is.';

$helptxt['recycle_enable'] = 'Het &quot;Recyclen&quot; van verwijderde topics en berichten naar het aangegeven board.';

$helptxt['enableReportPM'] = 'Deze optie zorgt ervoor dat je gebruikers persoonlijke berichten kunnen melden aan het beheerteam. Dit kan handig zijn om misbruik van persoonlijke berichten in de gaten te houden.';
$helptxt['max_pm_recipients'] = 'Deze optie stelt je in staat een maximum aantal ontvangers per persoonlijk bericht dat een forumlid stuurt in te stellen. Dit kan helpen om misbruik van het PM-systeem te voorkomen. Merk op dat leden die nieuwsbrieven kunnen versturen uitgezonderd zijn. Stel in op nul voor geen limiet.';
$helptxt['pm_posts_verification'] = 'Deze instelling zal gebruikers forceren een verificatiecode in te voeren wanneer ze een persoonlijk bericht willen versturen. Alleen gebruikers met een postteller onder het ingestelde aantal zullen de code moeten invoeren - dit zou automatische spammers tegen moeten werken.';
$helptxt['pm_posts_per_hour'] = 'Dit zal het aantal persoonlijke berichten dat een gebruiker per uur kan versturen limiteren. Dit heeft geen effect op beheerders of moderators.';

$helptxt['default_personal_text'] = 'Bepaalt de standaardtekst die een nieuwe gebruiker als &quot;persoonlijke tekst&quot; heeft.';

$helptxt['registration_method'] = 'Deze optie bepaalt welke registratie methode wordt gebruikt op het forum. Je kunt kiezen uit:<br><br>
	<ul class="normallist">
		<li>
			<strong>Registratie uitgeschakeld</strong><br>
				Blokkeert het registreren, wat inhoudt dat niemand zich kan registreren op het forum.<br>
		</li><li>
			<strong>Directe registratie</strong><br>
				Nieuwe leden kunnen direct inloggen en posten na registratie op het forum.<br>
		</li><li>
			<strong>Activatie via e-mail</strong><br>
				Leden die zich hebben geregistreerd krijgen een e-mail met een activatielink die ze dienen te volgen alvorens hun account wordt geactiveerd.<br>
		</li><li>
			<strong>Goedkeuring door beheerder</strong><br>
				Nieuwe leden dienen te worden goedgekeurd door een beheerder alvorens hun account wordt geactiveerd.
		</li>
	</ul>';

$helptxt['send_validation_onChange'] = 'Als deze optie is geactiveerd moeten de leden hun account opnieuw activeren aan de hand van een e-mailbericht dat ze krijgen op het nieuwe e-mailadres';
$helptxt['approveAccountDeletion'] = 'Met deze instelling, zal elke actie van gebruikers om de eigen account te verwijderen eerst moeten worden goedgekeurd door een beheerder';

$helptxt['send_welcomeEmail'] = 'Als deze optie is geactiveerd krijgen nieuwe leden een welkomst-e-mail bericht gestuurd';
$helptxt['password_strength'] = 'Deze instelling bepaalt de vereiste sterkte van wachtwoorden die gebruikt worden door je forumleden. Hoe &quot;sterker&quot; het wachtwoord, hoe moeilijker het is om iemands account te kraken.
	De mogelijke instellingen zijn:
	<ul class="normallist">
		<li><strong>Laag:</strong> Het wachtwoord moet minimaal vier karakters lang zijn.</li>
		<li><strong>Middel:</strong> Het wachtwoord moet minstens acht karakters lang zijn and mag niet bestaan uit een gebruikersnaam of een e-mailadres.</li>
		<li><strong>Hoog:</strong> Net zoals bij middel, behalve dat het wachtwoord ook een mix van hoofd- en kleine letters moet bevatten en tenminste &eacute;&eacute;n nummer.</li>
	</ul>';
$helptxt['enable_password_conversion'] = 'Met deze instelling zal SMF proberen wachtwoorden die in afwijkende formaten zijn opgeslagen te detecteren en deze converteren naar het formaat dat SMF gebruikt. Dit wordt veelal gebruikt voor forums die naar SMF zijn geconverteerd, maar kan ook andere toepassingen hebben. Zonder deze instellingen kunnen gebruikers niet inloggen met hun oude wachtwoord na een conversie en moeten zijn een nieuw wachtwoord aanvragen.';

$helptxt['coppaAge'] = 'The value specified in this box will determine the minimum age that new members must be in order to be granted immediate access to the forum.
	On registration they will be prompted to confirm whether they are over this age, and if not will either have their application rejected or suspended awaiting parental approval - dependent on the type of restriction chosen.
	If a value of 0 is chosen for this setting then all other age restriction settings shall be ignored.';
$helptxt['coppaType'] = 'Indien leeftijdsrestricties zijn ingesteld, bepaalt deze instelling wat er gebeurt als een lid onder de minimale leeftijd zich probeert te registreren op je forum. Er zijn twee mogelijke keuzes:
<ul class="normallist">
	<li>
	<strong>Verwerp de registratie:</strong><br>
De registratie van elk nieuw lid dat onder de minimum leeftijd is zal per direct worden verworpen.<br></li>
	<li>
	<strong>Vereis ouderlijke goedkeuring</strong><br>
Bij elk nieuw lid dat zich probeert te registreren en onder de minimaal toegestane leeftijd is, wordt de account gemarkeerd als in afwachting op goedkeuring en de aanmelder krijgt een formulier te zien waarin zijn of haar ouders toestemming kunnen geven om lid te worden van het forum. Ze krijgen ook de contactgegevens van het forum zoals ingesteld op de instellingen-pagina zien, zodat ze het formulier per e-mail naar de forumbeheerder kunnen sturen.
	</li>
</ul>';
$helptxt['coppaPost'] = 'De contactgegevens zijn verplicht, zodat formulieren die toestemming geven voor minderjarige registratie gestuurd kunnen worden naar de forumbeheerder. Deze gegevens zullen getoond worden aan alle nieuwe minderjarigen en zijn vereist voor goedkeuring van ouders of voogden. In ieder geval moet het postadres of het faxnummer ingevuld zijn.';

$helptxt['allow_hideOnline'] = 'Met deze instelling kunnen alle leden hun online status voor andere gebruikers (behalve beheerders) verbergen. Het uitschakelen van deze optie heeft geen gevolgen voor de status van leden: het voorkomt alleen dat ze zichzelf kunnen verbergen in de toekomst.';
$helptxt['meta_keywords'] = 'Deze sleutelwoorden worden toegevoegd aan de weergave van elke pagina, om zoekmachines (etc) de inhoud van je site te laten zien. Scheid meerdere woorden door middel van een komma. HTML is niet toegestaan.';

$helptxt['latest_themes'] = 'Hier zie je de laatste en meest populaire thema\'s van <a href="https://www.simplemachines.org/" target="_blank" rel="noopener">www.simplemachines.org</a>. Het kan zijn dat het niet verschijnt als je pc geen verbinding kan maken met <a href="https://www.simplemachines.org/" target="_blank" rel="noopener">www.simplemachines.org</a>.';

$helptxt['secret_why_blank'] = 'Voor de veiligheid is het antwoord op je vraag (en ook je wachtwoord) ge-encrypt zodat alleen SMF kan bepalen of het antwoord juist is, het kan je dus niet aangeven (en ook niet iemand anders!) wat het antwoord of je wachtwoord is.';
$helptxt['moderator_why_missing'] = 'Omdat modereren gedaan wordt op basis van boards, kun je leden alleen moderator maken via de <a href="%1$s?action=admin;area=manageboards" target="_blank" rel="noopener">boardbeheerpagina</a>.';

$helptxt['permissions'] = 'Permissies geven aan welke groepen wel of niet bepaalde rechten in bepaalde boards hebben.<br><br>Je kunt meerdere boards tegelijk bewerken of bij een specifieke groep kijken door te klikken op &quot;Bewerken&quot;.';
$helptxt['permissions_board'] = 'Als een board is ingesteld op \'Globaal,\' houdt dit in dat het board geen speciale permissies heeft.  \'Lokaal\' houdt in dat het board specifieke permissies heeft - apart van de Globale permissies.  Op deze manier kun je boards hebben die meer of minder permissies hebben dan een ander board, zonder dit voor ieder board apart in te moeten stellen.';
$helptxt['permissions_quickgroups'] = 'Deze stellen je in staat om &quot;standaard&quot; permissies te gebruiken - standaard betekent \'niets speciaals\', beperkt betekent \'als een gast\', moderator betekent \'wat een moderator heeft\', en \'onderhoud\' betekent permissies die erg dicht in de buurt liggen van een admin.';
$helptxt['permissions_deny'] = 'Het ontzeggen van permissies kan handig zijn wanneer je voor een zeker lid een permissie wilt wegnemen. Je kunt leden toevoegen aan een ledengroep met een \'ontzeg\'-permissie om hen die permissies te ontzeggen.<br><br>Gebruik het voorzichtig, een ontzegde permissie blijft ontzegd, ongeacht welke andere ledengroep het lid in zit.';
$helptxt['permissions_postgroups'] = 'Met permissies voor bericht-gerelateerde groepen, kun je permissies aan leden toekennen die een bepaald aantal berichten heeft geplaatst. De bericht-gerelateerde permissies worden <em>toegevoegd</em> aan de permissies van de reguliere ledengroepen.';
$helptxt['membergroup_guests'] = 'De gasten-ledengroep bestaat uit alle gebruikers die niet zijn ingelogd.';
$helptxt['membergroup_regular_members'] = 'De \'reguliere leden\' groep bestaat uit alle leden die ingelogd zijn, maar niet een primaire ledengroep zijn toegewezen.';
$helptxt['membergroup_administrator'] = 'De beheerder kan, per definitie, alles doen en alle boards zien. Er zijn geen permissie-instellingen voor de beheerder.';
$helptxt['membergroup_moderator'] = 'De moderator-ledengroep is een speciale ledengroep. Permissies en instellingen ingesteld voor deze groep, zijn van toepassing op board-moderators maar alleen <em>op de boards die zij modereren</em>. Buiten die boards zijn ze net als elk ander lid.';
$helptxt['membergroups'] = 'In SMF zijn er twee types ledengroepen waar je leden lid van kunnen zijn. Dit zijn:
	<ul class="normallist">
		<li><strong>Reguliere groepen:</strong> Een reguliere groep is een groep waar een lid niet automatisch in terecht komt. Om een lid toe te wijzen aan een groep, ga naar zijn profiel en klik &quot;Account Instellingen&quot;. Hier kun je een willekeurig aantal reguliere groepen toewijzen waarvan een lid deel zal zijn.</li>
		<li><strong>Bericht-gerelateerde groepen:</strong> In tegenstelling tot de reguliere groepen, kunnen bericht-gerelateerde groepen niet worden toegewezen. In plaats daarvan worden leden automatisch toegewezen aan een bericht-gerelateerde groep bij het bereiken van een minimaal aantal berichten, die benodigd is voor die groep.</li>
	</ul>';

$helptxt['calendar_how_edit'] = 'Je kunt deze events bewerken door op het rode sterretje naast de naam te klikken.';

$helptxt['maintenance_backup'] = 'Hier kun je een kopie maken van alle berichten, instellingen, leden en alle andere informatie uit de database in één groot bestand.<br><br>Doe dit regelmatig, bijvoorbeeld wekelijks, om altijd een goede back-up te hebben.';
$helptxt['maintenance_rot'] = 'Deze optie stelt je in staat om oude topics <strong>volledig</strong> en <strong>permanent</strong> te verwijderen van je forum. Het wordt aangeraden eerst een back-up te maken.<br><br><strong>Wees voorzichtig met het gebruik van deze optie.</strong>';
$helptxt['maintenance_members'] = 'Deze optie stelt je in staat om leden <strong>volledig</strong> en <strong>permanent</strong> te verwijderen van je forum. Het wordt <strong>sterk aangeraden</strong> van eerst een back-up te maken, voor het geval je iets doet dat je eigenlijk niet wilde doen.<br><br><strong>Wees voorzichtig met het gebruik van deze optie.</strong>';

$helptxt['avatar_server_stored'] = 'Dit staat je leden toe om een keuze te maken uit avatars die op de server zijn opgeslagen. Standaard zijn deze opgeslagen in de "avatars"-map.<br>Tip: je kunt submappen aanmaken in die map zodat je "categorieën" van avatars kan maken.';
$helptxt['avatar_external'] = 'Met deze optie actief kunnen leden een URL opgeven naar hun avatar.  Het nadeel hiervan is dat in sommige gevallen er avatars zullen worden gebruikt die erg groot zijn of niet op je forum kunnen in verband met wat de afbeelding voorstelt.';
$helptxt['avatar_download_external'] = 'Als deze instelling aan staat, zullen externe avatars worden gedownload van de door de leden opgegeven URL\'s. Indien succesvol zullen de avatars worden behandeld als geüploade avatars.';
$helptxt['avatar_action_too_large'] = 'Deze instelling stelt je in staat om afbeeldingen (van andere sites) te blokkeren als deze te groot zijn, of geeft de browser van de gebruiker opdracht deze te verkleinen, of te downloaden naar jouw server.<br><br>Als gebruikers erg grote afbeeldingen gebruiken als avatar en deze in de browser worden verkleind kan dit resulteren in het erg langzaam laden van afbeeldingen - de bestanden worden niet echt verkleind, maar alleen kleiner getoond. Een digitale foto wordt dan nog steeds in zijn geheel geladen en dat zal veel bandbreedte gebruiken.<br><br>De keerzijde is, dat het downloaden resulteert in meer ruimtegebruik op de server, maar hierdoor worden de afbeeldingen wel kleiner en werkt de weergave van het forum sneller voor de gebruikers. (Let op: voor downloaden en aanpassen is het noodzakelijk dat je gebruik maakt van GD library, of ImageMagick met de Imagick of MagickWand extensies)';
$helptxt['avatar_upload'] = 'Deze optie is vrijwel gelijk aan &quot;externe avatars&quot;, alleen heb je nu een betere controle over de avatars, gaat het aanpassen sneller en hoeven de leden hun avatar niet elders onder te brengen.<br><br>Het nadeel is dat het een hoop ruimte kan kosten op je server.';
$helptxt['avatar_download_png'] = 'PNG bestanden zijn groter, maar hebben een betere kwaliteit.  Als dit is uitgevinkt, zal er gebruik worden gemaakt van JPEG - vaak kleiner, maar ook een slechtere kwaliteit.';

$helptxt['disableHostnameLookup'] = 'Dit deactiveert de mogelijkheid om hostnamen te zoeken, wat op sommige servers erg traag kan zijn.  Let op dat het verbannen van leden ook minder effectief zal worden.';

$helptxt['smiley_sameall'] = 'Indien "Zelfde afbeelding voor alle sets" is aangevinkt, wordt dezelfde afbeelding aan alle smiley-sets toegevoegd. Als deze niet is aangevinkt, kan een andere afbeelding voor elke geïnstalleerde smiley-set worden geüpload. Merk op dat voor elke smiley-set een afbeelding moet worden opgegeven.';

$helptxt['search_weight_frequency'] = 'Gewichtsfactoren worden gebruikt om de relevantie van zoekresultaten te bepalen. Verander de gewichten zo dat ze overeenkomen met wat belangrijk is voor jouw forum. Bijvoorbeeld, een nieuws site zal een relatief hoge waarde hebben voor \'ouderdom van laatste overeenkomende bericht\'. Alle waardes zijn relatief ten opzichte van elkaar en zouden positieve gehele getallen moeten zijn.<br><br>Deze factor telt het aantal met de zoektermen overeenkomende berichten en deelt ze door het totaal aantal berichten in het topic.';
$helptxt['search_weight_age'] = 'Gewichtsfactoren worden gebruikt om de relevantie van zoekresultaten te bepalen. Verander de gewichten zo dat ze overeenkomen met wat belangrijk is voor jouw forum. Bijvoorbeeld, een nieuws site zal een relatief hoge waarde hebben voor \'ouderdom van laatste overeenkomende bericht\'. Alle waardes zijn relatief ten opzichte van elkaar en zouden positieve gehele getallen moeten zijn.<br><br>Deze factor bepaalt de ouderdom van het laatste overeenkomende bericht binnen een topic. Hoe recenter het bericht, hoe hoger de score.';
$helptxt['search_weight_length'] = 'Gewichtsfactoren worden gebruikt om de relevantie van zoekresultaten te bepalen. Verander de gewichten zo dat ze overeenkomen met wat belangrijk is voor jouw forum. Bijvoorbeeld, een nieuws site zal een relatief hoge waarde hebben voor \'ouderdom van laatste overeenkomende bericht\'. Alle waardes zijn relatief ten opzichte van elkaar en zouden positieve gehele getallen moeten zijn.<br><br>Deze factor is gebaseerd op de topicgrootte. Hoe meer berichten in het topic, hoe hoger de score.';
$helptxt['search_weight_subject'] = 'Gewichtsfactoren worden gebruikt om de relevantie van zoekresultaten te bepalen. Verander de gewichten zo dat ze overeenkomen met wat belangrijk is voor jouw forum. Bijvoorbeeld, een nieuws site zal een relatief hoge waarde hebben voor \'ouderdom van laatste overeenkomende bericht\'. Alle waardes zijn relatief ten opzichte van elkaar en zouden positieve gehele getallen moeten zijn.<br><br>Deze factor kijkt naar of een zoekterm in het onderwerp van het topic voorkomt.';
$helptxt['search_weight_first_message'] = 'Gewichtsfactoren worden gebruikt om de relevantie van zoekresultaten te bepalen. Verander de gewichten zo dat ze overeenkomen met wat belangrijk is voor jouw forum. Bijvoorbeeld, een nieuws site zal een relatief hoge waarde hebben voor \'ouderdom van laatste overeenkomende bericht\'. Alle waardes zijn relatief ten opzichte van elkaar en zouden positieve gehele getallen moeten zijn.<br><br>Deze factor kijkt naar of een zoekterm in het eerste bericht van het topic voorkomt.';
$helptxt['search_weight_sticky'] = 'Gewichtsfactoren worden gebruikt om de relevantie van zoekresultaten te bepalen. Verander de gewichten zo dat ze overeenkomen met wat belangrijk is voor jouw forum. Bijvoorbeeld, een nieuws site zal een relatief hoge waarde hebben voor \'ouderdom van laatste overeenkomende bericht\'. Alle waardes zijn relatief ten opzichte van elkaar en zouden positieve gehele getallen moeten zijn.<br><br>Deze factor kijkt naar of een topic sticky is en maakt de relevantie score hoger als dat het geval is.';
$helptxt['search'] = 'Pas hier alle instellingen voor de zoekfunctie aan.';
$helptxt['search_why_use_index'] = 'Een zoekindex kan de zoekprestaties van je forum aanzienlijk verbeteren. Met name wanneer het aantal berichten op je forum groeit, kan zoeken zonder indices lang duren en belasting van je database veroorzaken. Als je forum groter dan 50.000 berichten is, is het zeker te overwegen om een zoekindex aan te laten maken.<br><br>Let op dat zoekindices vrij veel ruimte innemen. Een fulltext-index is een standaardindex van MySQL en PostgreSQL. Het is relatief compact (ongeveer dezelfde grootte als de berichtentabel), maar veel woorden worden niet geïndexeerd en het kan sommige zoekopdrachten erg vertragen. De aangepaste indices zijn over het algemeen groter (afhankelijk van je configuratie kan het tot drie maal groter zijn dan de berichtentabel), maar zijn prestaties zijn zeker beter en komen de stabiliteit ook zeker ten goede.';

$helptxt['see_admin_ip'] = 'IP-adressen worden getoond aan beheerders en moderators om het modereren te vergemakkelijken en het eenvoudiger te maken om mensen met slechte bedoelingen te traceren. Bedenk wel dat IP-adressen niet altijd identificerend zijn en dat IP-adressen van mensen van tijd tot tijd kan veranderen. <br><br>Leden mogen ook hun eigen IP-adres zien.';
$helptxt['see_member_ip'] = 'Je IP-adres is zichtbaar voor jou en de moderators. Bedenk dat deze informatie je niet identificeert en dat de meeste IP-adressen af en toe veranderen.<br><br>Je kunt het IP-adres van andere leden niet zien en zij kunnen het jouwe niet zien.';
$helptxt['whytwoip'] = 'SMF gebruikt diverse methodes om het IP-adres van gebruikers te detecteren. Meestal resulteren deze twee methodes in hetzelfde IP-adres, maar in sommige gevallen kunnen er twee adressen worden gevonden. In zo\'n geval zal SMF beide adressen opslaan, en ze ook allebei gebruiken voor bancontroles, enz. Je kunt elk adres aanklikken en - indien gewenst - verbannen.';

$helptxt['ban_cannot_post'] = 'De "kan niet posten" restrictie zet het forum in een alleen-lezen-stand voor de verbannen gebruiker. De gebruiker kan geen nieuwe topics maken, niet reageren op bestaande topics, geen persoonlijke berichten versturen en niet stemmen in polls. Wel kan de verbannen gebruiker nog steeds persoonlijke berichten en topics lezen.<br><br>Er wordt een waarschuwingsbericht getoond aan de gebruikers die op deze manier zijn verbannen.';

$helptxt['posts_and_topics'] = '
	<ul class="normallist">
		<li>
			<strong>Berichteninstellingen</strong><br>
			Wijzig de instellingen die betrekking hebben op het plaatsen van berichten en de manier waarop de berichten worden weergegeven. Ook kun je hier de spellingscontrole aan zetten.
		</li><li>
			<strong>Bulletin Board Code</strong><br>
			Stel hier de code in waarmee forumberichten de juiste vormgeving kunnen krijgen. Stel in welke codes wel en welke codes niet gebruikt mogen worden.
		</li><li>
			<strong>Gecensureerde woorden</strong><br>
			Om het taalgebruik op het forum in toom te houden, kun je bepaalde woorden censureren. Deze functie stelt je in staat om verboden woorden om te zetten in onschuldige varianten.
		</li><li>
			<strong>Topicinstellingen</strong><br>
			Stel alles in met betrekking tot topics. Hoeveel er op een pagina gaan, of sticky topics ingeschakeld zijn, bij welk aantal berichten een topic \'hot\' is, etc.
		</li>
	</ul>';

$helptxt['spider_mode'] = 'Bepaalt het logboekregistratieniveau.<br>
Standaard - Minimale registratie van spider-activiteit.<br>
Gemiddeld - Geeft meer nauwkeurige statistieken.<br>
Agressief - Gelijk aan &quot;Gemiddeld&quot;, maar houdt data bij voor elke bezochte pagina.';

$helptxt['spider_group'] = 'Door een spider aan een groep te koppelen, krijgt een gast, wanneer deze als een zoekmachine-indexeerder wordt gedetecteerd, automatisch die groep toegewezen en krijgt de &quot;ontzeg&quot; permissies van die groep in aanvulling op de permissies van een gast. Je kunt dit zodanig toepassen dat een zoekmachine minder toegang heeft tot zaken dan een normale gast. Je zou bijvoorbeeld een nieuwe groep &quot;Spiders&quot; aan kunnen maken en die hier kunnen selecteren. Voor die groep zou je dan de permissie kunnen ontzeggen voor het bekijken van profielen van je leden, zodat spiders deze niet langer indexeren.<br>Let op: spiderdetectie is niet perfect en kan door gebruikers misleid worden. Er kan daarom niet worden gegarandeerd dat deze feature de inhoud alleen voor zoekmachines beperkt.';
$helptxt['show_spider_online'] = 'Deze instelling stelt je in staat om in te stellen of spiders moeten worden getoond in de &quot;Wie is online&quot;-lijst op de boardindex en op de &quot;Wie is online &quot;-pagina. Mogelijke waarden:
	<ul class="normallist">
		<li>
			<strong>Helemaal niet</strong><br>
			Spiders zullen als gasten worden getoond voor alle gebruikers.
		</li><li>
			<strong>Toon aantal spiders</strong><br>
			Op de boardindex zal het aantal spiders dat momenteel het forum bezoekt worden weergegeven.
		</li><li>
			<strong>Toon spidernamen</strong><br>
			De naam van elke spider zal worden getoond, zodat leden kunnen zien welke spiders momenteel het forum bezoeken. Dit heeft effect op zowel de boardindex als de &quot;Wie is online &quot;-pagina.
		</li><li>
			<strong>Toon spidernamen - alleen voor beheerders</strong><br>
			Hetzelfde als hierboven, maar dan zien enkel beheerders de spider statussen - alle andere gebruikers zien ze als gasten.
		</li>
	</ul>';

$helptxt['birthday_email'] = 'Kies hier tekst voor de verjaardags e-mail die je wilt verzenden. Er zal een voorbeeld verschijnen in de velden e-mailonderwerp en e-mailinhoud.<br><strong>Let op:</strong> het wijzigen van deze instelling activeert niet automatisch het verzenden van deze e-mails. Om het verzenden van de verjaardags e-mails in te schakelen ga je naar <a href="%1$s?action=admin;area=scheduledtasks;%3$s=%2$s" target="_blank" rel="noopener">Geplande taken</a>. Daar vind je de optie om het verzenden van de verjaardags emails te activeren.';
$helptxt['pm_bcc'] = 'Als je een persoonlijk bericht verstuurt, kun je ervoor kiezen om een ontvanger als BCC (&quot;Blind Carbon Copy&quot;) in te stellen. BCC-ontvangers zijn niet zichtbaar voor andere ontvangers van het bericht.';

$helptxt['move_topics_maintenance'] = 'Dit stelt je in staat om alle topics van een board naar een ander board te verplaatsen.';
$helptxt['maintain_reattribute_posts'] = 'Je kunt deze functie gebruiken om posts die door gasten zijn geplaatst, aan een lid toe te kennen. Dit is bijvoorbeeld handig als een lid zijn account heeft verwijderd, maar toch van gedachten veranderd is en daarom zijn oude posts aan een nieuw account gekoppeld zou willen hebben.';
$helptxt['chmod_flags'] = 'Je kunt zelf instellen welke permissies je voor de geselecteerde bestanden wilt toekennen. Om dit te bereiken, kun je zelf de chmod-waarde in de vorm van een numerieke (octet) waarde invullen. Opmerking: deze functie heeft geen effect op het besturingssysteem Microsoft Windows.';

$helptxt['postmod'] = 'Deze sectie staat leden van het moderatorteam (met de juiste permissies) toe om berichten en topics goed te keuren alvorens ze getoond worden.';

$helptxt['field_show_enclosed'] = 'Sluit de invoer van de gebruiker in tussen tekst en/of HTML. Dit stelt je in staat tot het toevoegen van meer instant messenger services, afbeeldingen, objecten, etcetera. Bijvoorbeeld:<br><br>
		&lt;a href="https://example.com/{INPUT}"&gt;&lt;img src="{DEFAULT_IMAGES_URL}/icon.png" alt="{INPUT}" /&gt;&lt;/a&gt;<br><br>
		Je kunt de volgende variabelen gebruiken:<br>
		<ul class="normallist">
			<li>{INPUT} - De invoer van de gebruiker.</li>
			<li>{SCRIPTURL} - Web adres van het forum.</li>
			<li>{IMAGES_URL} - URL naar afbeeldingenmap in het thema van de gebruiker.</li>
			<li>{DEFAULT_IMAGES_URL} - URL naar afbeeldingenmap in het standaard thema.</li>
			<li>{KEY} - Gebruikt als een veld meerdere opties bevat, is de unieke numerieke ID voor identificatie.</li>
		</ul>';

$helptxt['custom_mask'] = 'Invoermaskers zijn belangrijk voor de veiligheid van je forum. Het controleren van invoer van een gebruiker helpt voorkomen dat gegevens gebruikt worden op een ongewenste manier. Hieronder staan enkele <em>regular expressions</em> als tips.<br><br>
    Scheidingstekens aan het begin en einde van het patroon zijn noodzakelijk! Dit zijn tildes (~) in onderstaande voorbeelden.<br><br>
	<div class="smalltext" style="margin: 0 2em">
		&quot;~[A-Za-z]+~&quot; - Match all upper and lower case alphabet characters.<br>
		&quot;~[0-9]+~&quot; - Match all numeric characters.<br>
		&quot;~[A-Za-z0-9]{7}~&quot; - Match all upper and lower case alphabet and numeric characters seven times.<br>
		&quot;~[^0-9]?~&quot; - Forbid any number from being matched.<br>
		&quot;~^([A-Fa-f0-9]{3}|[A-Fa-f0-9]{6})$~&quot; - Only allow 3 or 6 character hexcodes.<br>
	</div><br><br>
	Additionally, special metacharacters ?+*^$ and {xx} can be defined.
	<div class="smalltext" style="margin: 0 2em">
		? - None or one match of previous expression.<br>
		+ - One or more of previous expression.<br>
		* - None or more of previous expression.<br>
		{xx} - An exact number from previous expression.<br>
		{xx,} - An exact number or more from previous expression.<br>
		{,xx} - An exact number or less from previous expression.<br>
		{xx,yy} - An exact match between the two numbers from previous expression.<br>
		^ - Start of string.<br>
		$ - End of string.<br>
		\\ - Escapes the next character.<br>
	</div><br><br>
	Meer informatie en geavanceerde technieken kun je op het internet vinden.';

$helptxt['topic_move_any'] = 'Met deze instelling zal het gebruikers toegestaan zijn om topics te verplaatsen naar elk board dat ze kunnen zien. Zoniet, dan kunnen ze deze alleen verplaatsen naar boards waar ze permissies hebben om nieuwe posts te plaatsen.';

$helptxt['alert_pm_new'] = 'Notificaties van persoonlijke berichten worden niet in het Notificaties-blok getoond, maar in de de "Mijn Berichten"-lijst.';
$helptxt['alert_event_new'] = 'Hierdoor zul je een notificatie of email ontvangen als er een nieuwe gebeurtenis aan de kalender wordt toegevoegd. Je zult geen extra notificatie krijgen als je het board volgt waarin het kalender topic wordt geplaatst - de notificatie voor het volgen van het board zal dit al doen.';

$helptxt['force_ssl'] = '<strong>Test SSL en HTTPS op jouw server voordat je deze instelling activeert, het kan je forum onbereikbaar maken.</strong> Activeer de Onderhoudsmodus als je na deze instelling het forum niet meer kunt bereiken.<br><br><strong>Door deze instelling wijzig je de URL van je forum en de URLs voor de thema bestanden, afbeeldingen, smileys en avatars. Deze worden op basis van je instelling gewijzigd in http: of https: afhankelijk van de gekozen instelling. Aangepaste URLs blijven ongewijzigd.</strong>';
$helptxt['image_proxy_enabled'] = 'Noodzakelijk voor het invoegen van externe afbeeldingen bij gebruik van volledige SSL';
$helptxt['image_proxy_secret'] = 'Houd deze geheim, hiermee is je forum beschermd tegen het hot-linken van afbeeldingen. Verander deze instelling om afbeeldingen die al gehotlinkt zijn onbruikbaar te maken';
$helptxt['image_proxy_maxsize'] = 'Maximale afbeeldingsgrootte die de SSL afbeelding proxy zal cachen: afbeeldingen die groter zijn worden niet in cache geplaatst. Ge-cachte afbeeldingen worden in de SMF cache map geplaatst, dus zorg ervoor dat je genoeg vrije ruimte hebt.';

$helptxt['enable_sm_stats'] = 'Indien actief zal dit Simple Machines in staat stellen om maandelijks basis statistieken van site op te halen. Hiermee is het voor ons mogelijk meer inzicht te krijgen welke inrichtingen gebruikt worden en 
waarvoor de software aangepast kan worden. Meer informatie kun je vinden op onze <a href="https://www.simplemachines.org/about/stats.php" target="_blank" rel="noopener">info pagina</a>.';

$helptxt['field_reg_require'] = 'Als dit veld verplicht is gesteld bij registratie zal het ook verplicht zijn bij het wijzigen van het profiel.';

$helptxt['translatable_fields'] = 'Indien u meertalige ondersteuning wilt aanbieden voor uw aangepaste profielvelden, kunt u vertaalbare tokens gebruiken voor zowel de naam- als de beschrijvingsvelden. <br><br>
Alles tussen haakjes <span class="monospace">{}</span> wordt beschouwd als een token en wordt vergeleken met een $txt-tekenreeks. Het token <span class="monospace">{gender}</span> wordt bijvoorbeeld vervangen door de waarde van $txt[\'gender\']<br><br>
Het is <strong>zeer belangrijk</strong> om de overeenkomende $txt-string toe te voegen aan <strong>ALLE</strong> momenteel geïnstalleerde talen. Ga hiervoor naar de <a href="%1$s?action=admin;area=languages;sa=edit;%3$s=%2$s" class="bbc_link" target="_blank" rel="noopener">Bewerk Talen</a>-pagina en voer de volgende stappen uit voor elke geïnstalleerde taal:
<ol class="bbc_list" style="list-style-type: decimal">
	<li>Klik op de knop "Bewerken" naast de taalnaam.</li>
	<li>Kies in het menu "Selecteer items om te bewerken" de optie "Modificaties".</li>
	<li>Scrol naar beneden en klik op de knop "Nog een item toevoegen".</li>
	<li>Volg de aanwijzingen om uw nieuwe tekenreeks toe te voegen.</li>
</ol>';

// argument(s): $boarddir, $boardurl
$helptxt['cron_is_real_cron'] = 'SMF voegt standaard aan elke pagina een klein stukje JavaScript toe dat ervoor zorgt dat de browser van de gebruiker SMF\'s cron.php in de achtergrond start. Hierdoor is het mogelijk dat SMF geplande taken met een vaste regelmaat uitvoert zonder dat de beheerder daarvoor extra configuratie hoeft te doen op de server. Sommige beheerders geven er de voorkeur aan om zelf de server in te richten zodat cron.php regelmatig wordt uitgevoerd. Als je dit gedaan hebt, is het mogelijk de JavaScript methode te deactiveren.<br><br><strong>Let op:</strong> Het op de server instellen van het automatisch starten van geplande taken kan niet vanuit SMF gedaan worden. Hiervoor moet je de configuratie software van je server zelf gebruiken. Veelgebruikte tools hiervoor zijn <code>cron</code> (voor Linux servers), <code>schtasks.exe</code> (voor Windows servers), en <code>launchd</code> (voor macOS servers). De meeste web hosts voorzien in een soort control panel interface voor hun klanten waarmee deze tools gebruikt kunnen worden.<br><br>Het pad en URL voor jouw forum\'s cron.php zijn::<br>Pad: %1$s/cron.php<br>URL: %2$s/cron.php';

$helptxt['languages_txt'] = 'Deze taalregels worden in SMF gebruikt om plaatselijke versies van teksten in verschillende talen vast te leggen.<br><br>Als je een code als <code>&#37;1$s</code> in een regel vindt, dan is dit een variabele die SMF bij het uitvoeren vult met een waarde. Zorg ervoor dat deze variabelen in je aangepaste tekstregel blijven staan.';
$helptxt['languages_helptxt'] = 'Deze taalregels worden gebruikt om de zwevende helptekst pop-up berichten te tonen (zoals deze).';
$helptxt['languages_editortxt'] = 'Deze taalregels worden gebruikt in onderdelen gebruikt in de berichten editor.';
$helptxt['languages_tztxt'] = 'Deze taalregels worden gebruikt om beschrijvingen van maken voor tijdzones.<br><br>Zo kan bijvoorbeeld de <code>Europe_Western</code> tekst gecombineerd worden met de <code>daylight_saving_time_false</code> tekst om de beschrijving "West Europese Standaardtijd" te vormen.<br><br>Let op: Als er geen omschrijving voor een tijdzone is opgegeven, dan zal SMF er één genereren op basis van een lijst van locaties in die tijdzone.';
$helptxt['languages_txt_for_timezones'] = 'Deze taalregels maken het volgende mogelijk:<br><ol class="bbc_list" style="list-style-type: decimal;"><li>
Aangepaste namen te definiëren voor specifieke locaties waar ze gebruikt kunnen worden in een context van tijdzones. Je kunt bijvoorbeeld SMF "Groenland" laten weergeven voor de locatie "Amerika/Godthab" in plaats van "Godthab".</li><li>Wijzig de namen van de verschillende landen. Dit is mogelijk door de relevante <code>iso3166[]</code> string te wijzigen.</li></ol>';
$helptxt['languages_txt_for_email_templates'] = 'Deze taalregels worden gebruikt om de e-mailberichten te maken die SMF naar je leden stuurt.';
$helptxt['languages_native_name'] = 'De naam van de taal in zichzelf, in het eigen schrift.';
$helptxt['languages_character_set'] = 'De tekencodering die gebruikt wordt voor deze taal. Sinds SMF 2.1 moet dit altijd "UTF-8" zijn.';
$helptxt['languages_locale'] = 'De landinstelling wordt gebruikt om verschillende opmaakconventies te bepalen, en andere dingen.<br><br>De landinstelling neemt normaal gesproken de vorm aan van een taalcode van twee tekens, en optioneel een laag streepje en een landcode van twee tekens. Zo kan <code>nl</code> staan voor Nederlands in het algemeen, terwijl <code>nl_BE</code> specifiek staat voor Belgisch-Nederlands.';
$helptxt['languages_rtl'] = 'Geef hier een "1" op als deze taal van rechts naar links geschreven wordt (bijvoorbeeld Hebreeuws of Arabisch).  Laat dit op "0" voor talen die van links naar rechts geschreven worden.';
$helptxt['languages_dictionary'] = 'Dit bepaalt het hoofdwoordenboek dat zal worden gebruikt door de <a href="https://php.net/function.pspell-new" target="_blank" rel="noopener">pSpell</a>-spellingscontrole (als het is geïnstalleerd).';
$helptxt['languages_recaptcha'] = 'De taalcode om te gebruiken voor de reCAPTCHA-verificatiewidget.<br><br>Zie de reCAPTCHA-documentatie van Google voor de <a href="https://developers.google.com/recaptcha/docs/language" target="_blank" rel="noopener" class="bbc_link">lijst met ondersteunde talen</a>.';
// The GDPR page of the EU exists in several languages; change the language code at the end of the url
$helptxt['requireAgreement'] = 'Deze instelling moet zijn ingeschakeld om te voldoen aan de regels van de <a href="https://ec.europa.eu/info/law/law-topic/data-protection/eu-data-protection-rules_nl" target="_blank" rel="noopener" class="bbc_link">AVG</a>.';
// The GDPR page of the EU exists in several languages; change the language code at the end of the url
$helptxt['requirePolicyAgreement'] = 'Deze instelling moet zijn ingeschakeld om te voldoen aan de regels van de <a href="https://ec.europa.eu/info/law/law-topic/data-protection/eu-data-protection-rules_nl" target="_blank" rel="noopener" class="bbc_link">AVG</a>.';
$helptxt['gravatar'] = 'Gravatar staat voor Globally Recognized Avatars. Registreer een account op <a href="https://www.gravatar.com" target="_blank" rel="noopener"> https://www.gravatar.com </a> om een ​​avatarafbeelding te selecteren. Deze avatar is dan beschikbaar op elke site die gravatars ondersteunt. Als je geen gravatar-account hebt, wordt een standaardafbeelding gebruikt.';

?>