<?php
// Version: 2.1.5; Help

global $helptxt, $scripturl;

$txt['close_window'] = '關閉視窗';

$helptxt['manage_boards'] = '
	<strong>編輯看板</strong><br />
	這個頁面可以讓你建立/排序/移除看板, 以及看板的類別。
	例如: 您的論壇資訊很廣泛, 包含 &quot;運動&quot;, &quot;汽車&quot; 和 &quot;音樂&quot;, 
	這些可以建立成最上層的類別, 底下您可以建立 &quot;子類別&quot; 或 &quot;看板&quot; 
	而文章是在看板裡面。下面是一個簡單的階層結構: <br />
	<ul class="normallist">
		<li>
			<strong>運動</strong>
			&nbsp;- &quot;類別&quot;
		</li>
		<ul class="normallist">
			<li>
				<strong>棒球</strong>
				&nbsp;- &quot;運動&quot 類別底下的看板;
			</li>
			<ul class="normallist">
				<li>
					<strong>統計</strong>
					&nbsp;- &quot;棒球&quot 底下的子看板;
				</li>
			</ul>
			<li><strong>足球</strong>
			&nbsp;- &quot;運動&quot; 底下的看板</li>
		</ul>
	</ul>
	類別可以讓您明顯地分類看板的主題 (&quot;汽車, 運動&quot;), 
	而底下的 &quot;看板&quot; 可以讓會員發表文章。
	會員如果對於 Pintos 有興趣, 他可以在 &quot;汽車->Pinto&quot; 發表文章。
	類別讓大家快速尋找自己想要的: 您可以去逛 &quot;硬體&quot; 和 &quot;服飾&quot; 店, 而不是只能去 &quot;商店&quot;。
	這樣可以簡化您搜尋 &quot;pipe joint compound&quot;, 因為您可以到硬體店 &quot;類別&quot; 而不需要去服飾店(您不可能在服飾店找到 pipe joint compound)。<br />
	如上所述, 看板是類別底下的主要議題。
	如果您要討論 &quot;Pintos&quot; 您要在 &quot;汽車&quot; 類別底下的 &quot;Pinto&quot; 看板發表您的意見。<br />
	這個選單項目的管理功能是建立看板, 排序看板 (讓 &quot;Pinto&quot; 在 &quot;Chevy&quot; 之後), 或刪除看板。';

$helptxt['edit_news'] = '
	<ul class="normallist">
		<li>
			<strong>最新消息</strong><br />
			這個讓您設定顯示在論壇首頁的最新消息項目。
			增加您要的項目 (例如: "不要忘記星期二的會議")。每個項目會隨機輪播。
		</li>
		<li>
			<strong>電子報</strong><br />
			這個讓您透過簡訊或 Email 傳送電子報給會員。首先, 選擇您想傳送的群組和您不想傳送的群組。您也可以另外增加傳送的會員或 Email。最後, 輸入電子報的內容並選擇用簡訊或 Email 傳送。
		</li>
		<li>
			<strong>設定</strong><br />
			這裡可以選擇最新消息和電子報的設定, 包含選擇可以編輯或傳送電子報的群組。這裡也可以設定是否啟用 feed, 並且設定 feed 中每篇文章顯示的長度。
		</li>
	</ul>';

$helptxt['view_members'] = '
	<ul class="normallist">
		<li>
			<strong>View all Members</strong><br>
			View all members of the forum. You are presented with a hyperlinked list of member names. You may click
			on any of the names to find details of the members (homepage, age, etc.), and as Administrator
			you are able to modify these parameters. You have complete control over members, including the
			ability to delete them from the forum.<br><br>
		</li>
		<li>
			<strong>Awaiting approval</strong><br>
			This page is only shown if you have enabled admin approval of all new registrations. Anyone who registers to join your
			forum will only become a full member once they have been approved by an admin. The page lists all those members who
			are still awaiting approval, along with their email and IP address. You can choose to either accept or reject (delete)
			any member on the list by checking the box next to the member and choosing the action from the drop-down box at the bottom
			of the page. When rejecting a member you can choose to delete the member either with or without notifying them of your decision.<br><br>
		</li>
		<li>
			<strong>Awaiting activation</strong><br>
			This page will only be visible if you have email activation of new member accounts enabled on the forum. This page will list all
			members who have still not activated their new accounts. From this page you can choose to either accept, reject or remind
			members with outstanding registrations. As above you can also choose to email the member to inform them of the
			action you have taken.<br><br>
		</li>
	</ul>';

$helptxt['ban_members'] = '<strong>阻擋會員</strong><br />
	SMF 可以讓你 &quot;禁用&quot; 會員, 如果他們違反了論壇的規定. 
	管理員可以禁止他們瀏覽論壇. 在會員發佈的文章裡你可以看到他們的 IP. 
	只要把 IP 輸入到這裡就可以禁止他們發佈任何文章.注意: 有些會員的 IP 會改變.<br />或輸入他們的電子郵件阻擋會員.';

$helptxt['featuresettings'] = '<strong>Edit Features and Options</strong><br />
	There are several features in this section that can be changed to your preference.';

$helptxt['modsettings'] = '<strong>修改特色及選項</strong><br />
	這裡可以任意修改論壇的特色. 外掛的選項通常也會在這裡出現.';

$helptxt['time_format'] = '<strong>時間格式</strong><br />
	你可以修改時間格式給你自己. 這裡用了很多簡寫, 但是非常簡單. PHP 的strftime函數用法如下 
	(詳細的用法可到 <a href="http://www.php.net/manual/function.strftime.php" target="_blank">php.net</a>).<br />
	<br />
	時間格式可用以下簡寫: <br />
	<span class="smalltext">
	&nbsp;&nbsp;%a - 週日簡稱<br />
	&nbsp;&nbsp;%A - 週日名稱<br />
	&nbsp;&nbsp;%b - 月份簡稱<br />
	&nbsp;&nbsp;%B - 月份名稱<br />
	&nbsp;&nbsp;%d - 日子 (01 to 31) <br />
	&nbsp;&nbsp;%D<strong>*</strong> - 如同 %m/%d/%y <br />
	&nbsp;&nbsp;%e<strong>*</strong> - 日子 (1 to 31) <br />
	&nbsp;&nbsp;%H - 24-hour 格式 (range 00 to 23) <br />
	&nbsp;&nbsp;%I - 12-hour 格式 (range 01 to 12) <br />
	&nbsp;&nbsp;%m - 數字月份 (01 to 12) <br />
	&nbsp;&nbsp;%M - 分鐘 <br />
	&nbsp;&nbsp;%p - 可用 &quot;am&quot; 或 &quot;pm&quot; 上午或下午<br />
	&nbsp;&nbsp;%R<strong>*</strong> - 時間以24小時標記 <br />
	&nbsp;&nbsp;%S - 秒數以小數計算 <br />
	&nbsp;&nbsp;%T<strong>*</strong> - 目前時間, 等於 %H:%M:%S <br />
	&nbsp;&nbsp;%y - 2 位數年份 (00 to 99) <br />
	&nbsp;&nbsp;%Y - 4 位數年份<br />
	&nbsp;&nbsp;%Z - 時區 <br />
	&nbsp;&nbsp;%% - \'%\' 符號 <br />
	<br />
	<i>* 無法用在 Windows-based 伺服器.</i></span>';

$helptxt['live_news'] = '<strong>Live 公告</strong><br />
	這裡會出現 <a href="http://www.simplemachines.org/">www.simplemachines.org 的最新注意事項</a>
	這裡會常出現更新檔, 新論壇下載, 或 Simple Machines Team 的重要事件.';

$helptxt['registrations'] = '<strong>註冊管理</strong><br />
	這裡可以讓你用各種功能管理會員註冊. 依據你論壇的設定, 你會看到不同的區塊及功能. 這些是:<br /><br />
	<ul>
		<li>
			<strong>註冊新會員</strong><br />
			這裡你可以註冊新的會員. 當你的論壇已不開放註冊或你需要新增測試會員時可以用這個功能. . 如果你要求新會員啟用帳號, 
			啟用郵件會寄到他們的信箱裡, 他們必須依照郵件的指示啟動帳號. 你也可以選擇寄密碼給會員.
		</li>
		<li>
			<strong>修改註冊同意條款</strong><br />
			當新會員註冊時會看到論壇的同意條款. 你可以完全改變, 移除, 或修改 SMF 原有的同意條款內容.<br /><br />
		</li>
		<li>
			<strong>保留帳號</strong><br />
			這裡你可以禁止會員使用某些帳號.<br /><br />
		</li>
		<li>
			<strong>設定</strong><br />
			這個頁面只有在可管理論壇的權限下出現。這裡個讓您改變註冊的設定，和其他相關的設定。
		</li>
	</ul>';

$helptxt['modlog'] = '<strong>管理紀錄</strong><br />
	任何版主的管理紀錄都會在這出現, 譬如說刪除文章及刪除會員. 任何紀錄一定會在這出現, 如果版主要刪除必須等24小時過後.
	版主的動作變數都會出現在 \'物件\' 欄裡.';
$helptxt['adminlog'] = '<strong>Administration Log</strong><br />
	This section allows members of the admin team to track some of the administrative actions that have occurred on the forum. To ensure that
	admins cannot remove references to the actions they have performed, entries may not be deleted until 24 hours after the action was taken.';
$helptxt['userlog'] = '<strong>Profile Edits Log</strong><br>
	This page allows members of the admin team to view changes users make to their profiles, and is available from inside a user\'s profile area.';
$helptxt['warning_enable'] = '<strong>User Warning System</strong><br />
	This feature enables members of the admin and moderation team to issue warnings to users - and to use a users warning level to determine the
	actions available to them on the forum. Upon enabling this feature a permission will be available within the permissions section to define
	which groups may assign warnings to users. Warning levels can be adjusted from a users profile. The following additional options are available:
	<ul>
		<li>
			<strong>Warning Level for User Watch</strong><br />
			This setting defines the percentage warning level a user must reach to automatically assign a &quot;watch&quot; to the user.
			Any user who is being &quot;watched&quot; will appear in the relevant area of the moderation center.
		</li>
		<li>
			<strong>Warning Level for Post Moderation</strong><br />
			Any user passing the value of this setting will find all their posts require moderator approval before they appear to the forum
			community. This will override any local board permissions which may exist related to post moderation.
		</li>
		<li>
			<strong>Warning Level for User Muting</strong><br />
			If this warning level is passed by a user they will find themselves under a post ban. The user will lose all posting rights.
		</li>
		<li>
			<strong>Maximum User Warning Point per Day</strong><br />
			This setting limits the amount of points a moderator may add/remove to any particular user in a twenty four hour period. This will
			can be used to limit what a moderator can do in a small period of time. This setting can be disabled by setting to a value of zero. Note that
			any users with administrator permissions are not affected by this value.
		</li>
	</ul>';
$helptxt['warning_watch'] = 'This setting defines the percentage warning level a member must reach to automatically assign a &quot;watch&quot; to the member. Any member who is being &quot;watched&quot; will appear in the watched members list in the moderation center.';
$helptxt['warning_moderate'] = 'Any member passing the value of this setting will find all their posts require moderator approval before they appear to the forum community. This will override any local board permissions which may exist related to post moderation.';
$helptxt['warning_mute'] = 'If this warning level is passed by a member they will find themselves under a post ban. The member will lose all posting rights.';
$helptxt['user_limit'] = 'This setting limits the amount of points a moderator may add/remove to any particular member in a twenty four hour period. This
			can be used to limit what a moderator can do in a small period of time. This can be disabled by setting it to a value of zero. Note that
			any members with administrator permissions are not affected by this value.';

$helptxt['error_log'] = '<strong>錯誤紀錄</strong><br />
	錯誤紀錄會紀錄所有會用使用論壇時而發生錯誤的紀錄. 所有錯誤是依照發生日期出現, 你也可以按日期旁邊的箭頭來進行類別. 
	此外你可以按錯誤旁的圖片來進行過濾. 譬如說過濾會員只會陳列你所過濾的會員.';
$helptxt['theme_settings'] = '<strong>佈景設定</strong><br />
	這裡可以讓你改變佈景的設定. 設定包括佈景的資料夾及 URL 的資料. 其他的選項可以讓你對佈景進行規劃. 
	有些佈景提供不同的選項任你規劃你所喜歡的論壇.';
$helptxt['smileys'] = '<strong>表情圖案中心</strong><br />
	在這裡您可以新增或移除表情圖案和圖案集. 注意如果一個表情圖案在一個圖案集裡面, 他必須也出現在每個圖案集.
	要不然會無法顯示.<br /><br />

	您也可以在這裡編輯文章的圖示，如果有開啟這個功能。';
$helptxt['calendar'] = '<strong>管理日曆</strong><br />
	這裡可以讓您修改目前的日曆設定，也可以新增或移除假期。';
$helptxt['cal_export'] = 'Exports a text file in the iCal format for importing into other calendar applications';
$helptxt['cal_highlight_events'] = 'This setting allows you to highlight events on the Mini Calendars, Main Calendar, both places, or disable event highlighting.';
$helptxt['cal_highlight_holidays'] = 'This setting allows you to highlight holidays on the Mini Calendars, Main Calendar, both places, or disable event highlighting.';
$helptxt['cal_highlight_birthdays'] = 'This setting allows you to highlight birthdays on the Mini Calendars, Main Calendar, both places, or disable event highlighting.';
$helptxt['cal_disable_prev_next'] = 'If this setting is checked, the three month blocks on the left hand side of the page will be disabled.';
$helptxt['cal_display_type'] = 'This setting allows you to change the display type of the calendar.<br><br><strong>Comfortable:</strong> makes the rows of the calendar big.<br><strong>Compact:</strong> makes the rows of the calendar small.';
$helptxt['cal_week_links'] = 'If this setting is checked, links will be added alongside each week in the calendar.';
$helptxt['cal_prev_next_links'] = 'If this setting is checked, previous month and next month links will be added to the top of each month for easy navigation.';
// argument(s): $txt['months_short'][1], $txt['months_titles'][1]
$helptxt['cal_short_months'] = 'If this setting is checked, month names within the calendar will be shortened.<br><br><strong>Enabled:</strong> %1$s 1<br><strong>Disabled:</strong> %2$s 1';
// argument(s): $txt['days_short'][1], $txt['days'][1]
$helptxt['cal_short_days'] = 'If this setting is checked, day names within the calendar will be shortened.<br><br><strong>Enabled:</strong> %1$s<br><strong>Disabled:</strong> %2$s';

$helptxt['serversettings'] = '<strong>Server Settings</strong><br>
	Here you can perform some core configuration for your forum. This page includes the database and URL settings, as well as other
	important configuration items such as mail settings and caching. Think carefully whenever editing these settings as an error may
	render the forum inaccessible';
$helptxt['manage_files'] = '
	<ul>
		<li>
			<strong>Browse Files</strong><br />
			Browse through all the attachments, avatars and thumbnails stored by SMF.<br /><br />
		</li><li>
			<strong>Attachment Settings</strong><br />
			Configure where attachments are stored and set restrictions on the types of attachments.<br /><br />
		</li><li>
			<strong>Avatar Settings</strong><br />
			Configure where avarars are stored and manage resizing of avatars.<br /><br />
		</li><li>
			<strong>File Maintenance</strong><br />
			Check and repair any error in the attachment directory and delete selected attachments.<br /><br />
		</li>
	</ul>';

$helptxt['topicSummaryPosts'] = '這裡可以讓你選擇出現在主題回覆時該出現的文章數.';
$helptxt['enableAllMessages'] = '這裡可以讓您設定顯示 全部 連結的 <em>最多</em> 文章數量。如果這個設定是小於 &quot;主題頁面顯示的文章數&quot; 表示永遠不會顯示 全部 的連結，如果設定太高可能會讓您的論壇變慢。';
$helptxt['allow_guestAccess'] = '不勾選這個欄位會讓訪客無法進行任何動作，除了使用登入，忘記密碼功能等等。這個跟禁止訪客進入看板的權限不同。';
$helptxt['userLanguage'] = '使用這個選項可以讓會員改變論壇語言, 但是不會改變預設值.';
$helptxt['trackStats'] = '統計:<br />這個可以讓會員瀏覽最新的文章或最受歡迎的文章. 其他的統計像最高線上人數, 最新註冊會員, 及最新文章也會出現.<hr />
		點閱數:<br />添加新的統計欄顯示論壇的點閱數.';
$helptxt['titlesEnable'] = '變更自訂頭銜是讓允許管理員為會員建立特殊的頭銜。自訂頭銜會顯示在暱稱下面。<br /><em>例如:</em><br />Jeff<br />Cool Guy';
$helptxt['onlineEnable'] = '這個選項會顯示會員在線或不在線的圖示';
$helptxt['todayMod'] = '顯示 &quot;今天&quot; 或 &quot;昨天&quot; 取代日期。<br /><br />
		<strong>例如:</strong><br /><br />
		<dt>
			<dt>停用</dt>
			<dd>十月 3, 2009 12:59:18 am</dd>
			<dt>只有今天</dt>
			<dd>今天 12:59:18 am</dd>
			<dt>今天 &amp; 昨天</dt>
			<dd>今天 09:36:55 pm</dd>
		</dt>';
$helptxt['disableCustomPerPage'] = 'Check this option to stop users from customizing the amount of messages and topics to display per page on the Message Index and Topic Display page respectively.';
$helptxt['enablePreviousNext'] = '顯示連結到下篇其上篇的文章.';
$helptxt['pollMode'] = '你可以選擇使用會禁止使用投票. 如果禁止使用投票, 任何現有的投票將會被隱藏. 你可以繼續顯示現有的主題如果你准許
		&quot;顯示現有投票為主題&quot;.<br /><br />權限選單可讓你選擇誰可以發表投票. 請記住這個選項如果投票功能出現問題.';
$helptxt['enableCompressedOutput'] = '這個選項可以讓你使用 zlib 來壓縮帶寬. 一定要安裝 zlib 才可使用.';
$helptxt['httponlyCookies'] = 'Cookies won\'t be accessible by scripting languages, such as JavaScript. This setting can help to reduce identity theft through XSS attacks. This can cause issues with third party scripts but should be on wherever possible.';
$helptxt['samesiteCookies'] = 'The SameSite attribute of the Set-Cookie HTTP response header allows you to declare if your cookie should be restricted to a first-party or same-site context. For further information, please refer to <a href="https://developer.mozilla.org/docs/Web/HTTP/Headers/Set-Cookie/SameSite">MDN</a>';
$helptxt['databaseSession_enable'] = '此項功能將使用資料庫來管理工作階段。最好使用在有負載平衡功能的主機，也可能讓您的論壇更快。';
$helptxt['databaseSession_loose'] = '啟用此項功能會減少您論壇使用的寬頻, 但是如果您按回上頁不過更新您的頁面.';
$helptxt['databaseSession_lifetime'] = '您可以選擇工作階段的時間 (已秒計算), 最好是高於2400.';
$helptxt['tfa_mode'] = 'You can add a second level of security to your forum by enabling <a href="https://en.wikipedia.org/wiki/Two_factor_authentication">Two Factor Authentication</a>. 2FA forces your users to add a enter a machine-generated code after the regular login. You need to configure 2FA to yourself before you are able to force it to other users!';
$helptxt['cache_enable'] = 'SMF performs caching at a variety of levels. The higher the level of caching enabled the more CPU time will be spent retrieving cached information. If caching is available on your machine it is recommended that you try caching at level 1 first.';
$helptxt['cache_memcached'] = 'If you are using memcached you need to provide the server details. This should be entered as a comma separated list as shown in the example below:<br><br>	&quot;server1,server2,server3:port,server4&quot;<br><br>Note that if no port is specified SMF will use port 11211 unless the host contains a slash, then it is assumed to be an alternative transport and the port will be set to 0. SMF will attempt to perform rough/random load balancing across the specified servers.';
$helptxt['cache_cachedir'] = 'This setting is only for the smf file-based cache system. It specifies the path to the cache directory. It is recommended that you place this in /tmp/ if you are going to use this, although it will work in any directory';
$helptxt['cache_sqlite_cachedir'] = 'This setting is only for the SQLite database cache system. It specifies the path to the cache directory. It is recommended that you place this in /tmp/ if you are going to use this, although it will work in any directory';
$helptxt['enableErrorLogging'] = '這個會紀錄任何錯誤, 譬如說無法登入等等.';
$helptxt['enableErrorQueryLogging'] = 'This will include the full query sent to the database in with any database error.  Requires error logging to be turned on.<br /><br /><strong>Note:  This will affect the ability to filter the error log by the error message.</strong>';
$helptxt['disallow_sendBody'] = '這個選項會在回覆的通知信件內移除文章內容。<br /><br />通常會員會直接回復通知信件，表示只有管理員才會收到回覆的訊息。';
$helptxt['enable_ajax_alerts'] = 'This option allows your members to receive AJAX notifications. This means that members don\'t need to refresh the page to get new notifications.<br><strong>DO NOTE:</strong> This option might cause a severe load at your server with many users online.';
$helptxt['alerts_auto_purge'] = 'Once an alert has been read, it is rarely needed again. For performance reasons, it is a good idea to automatically delete them after a while.';
$helptxt['jquery_source'] = 'This will determine the source used to load the jQuery Library. <em>Google CDN, jQuery CDN</em> and <em>Microsoft CDN</em> will load the jQuery library from those respective CDN networks. <em>Local</em> will only use the local source. <em>Custom</em> allows you to specify a custom URL for the library.';
$helptxt['compactTopicPagesEnable'] = '頁碼顯示的數量。<br /><em>例如:</em>
		&quot;3&quot; 顯示為: 1 ... 4 [5] 6 ... 9 <br />
		&quot;5&quot; 顯示為: 1 ... 3 4 [5] 6 7 ... 9';
$helptxt['timeLoadPageEnable'] = '在論壇的最下方顯示 SMF 開啟主頁所花的時間.';
$helptxt['removeNestedQuotes'] = '引用文章的時候, 這個功能會移除原文中的巢狀引言。';
$helptxt['max_image_width'] = '設定文章貼圖的最大值. 不會影響小於最大值的圖片.';
$helptxt['mail_type'] = '讓你選擇使用預設的 PHP 郵件軟體或你自己的郵件伺服器. 除了 sendmail 之外請輸入發出郵件的伺服器.';
$helptxt['attachment_manager_settings'] = 'Attachments are files that members can upload, and attach to a post.<br /><br />
		<strong>Check attachment extension</strong>:<br /> Do you want to check the extension of the files?<br />
		<strong>Allowed attachment extensions</strong>:<br /> You can set the allowed extensions of attached files.<br />
		<strong>Attachments directory</strong>:<br /> The path to your attachment folder<br />(example: /home/sites/yoursite/www/forum/attachments)<br />
		<strong>Max attachment folder space</strong> (in KB):<br /> Select how large the attachment folder can be, including all files within it.<br />
		<strong>Max attachment size per post</strong> (in KB):<br /> Select the maximum filesize of all attachments made per post.  If this is lower than the per-attachment limit, this will be the limit.<br />
		<strong>Max size per attachment</strong> (in KB):<br /> Select the maximum filesize of each separate attachment.<br />
		<strong>Max number of attachments per post</strong>:<br /> Select the number of attachments a person can make, per post.<br />
		<strong>Display attachment as picture in posts</strong>:<br /> If the uploaded file is a picture, this will show it underneath the post.<br />
		<strong>Resize images when showing under posts</strong>:<br /> If the above option is selected, this will save a separate (smaller) attachment for the thumbnail to decrease bandwidth.<br />
		<strong>Maximum width and height of thumbnails</strong>:<br /> Only used with the &quot;Resize images when showing under posts&quot; option, the maximum width and height to resize attachments down from.  They will be resized proportionally.';
$helptxt['attachmentCheckExtensions'] = 'For some communities, you may wish to limit the types of files that users can upload by checking the extension: e.g. myphoto.jpg has an extension of jpg.';
// References setting attachmentCheckExtensions
$helptxt['attachmentExtensions'] = 'If "check attachment\'s extension" above is enabled, these are the extensions that will be permitted for new attachments.';
$helptxt['attachmentUploadDir'] = 'The path to your attachment folder on the server<br>(example: /home/sites/yoursite/www/forum/attachments)';
$helptxt['attachmentDirSizeLimit'] = 'Select how large the attachment folder can be, including all files within it.';
$helptxt['attachmentPostLimit'] = 'Select the maximum filesize (in KB) of all attachments made per post. If this is lower than the per-attachment limit, this will be the limit.';
$helptxt['attachmentSizeLimit'] = 'Select the maximum filesize of each separate attachment.';
$helptxt['attachmentNumPerPostLimit'] = 'Select the number of attachments a person can make per post.';
$helptxt['attachmentShowImages'] = 'If the uploaded file is a picture, it will be displayed underneath the post.';
$helptxt['attachmentThumbnails'] = 'If the above setting is selected, this will save a separate (smaller) attachment for the thumbnail to decrease bandwidth.';
$helptxt['attachmentThumbWidth'] = 'Only used with the &quot;Resize images when showing under posts&quot; setting. This is the maximum width to resize attachments down to. They will be resized proportionally.';
$helptxt['attachmentThumbHeight'] = 'Only used with the &quot;Resize images when showing under posts&quot; setting. This is the maximum height to resize attachments down to. They will be resized proportionally.';
$helptxt['attachmentDirFileLimit'] = 'Max number of files per directory';
$helptxt['attachmentEnable'] = 'This setting enables you to configure how attachments can be made.<br><br>
	<ul class="normallist">
		<li>
			<strong>Disable all attachments</strong><br>
			All attachments are disabled. Existing attachments are not deleted, but they are hidden from view (even administrators cannot see them). New attachments cannot be made either, regardless of permissions.<br><br>
		</li>
		<li>
			<strong>Enable all attachments</strong><br>
			Everything behaves as normal, users who are permitted to view attachments can do so, users who are permitted to upload can do so.<br><br>
		</li>
		<li>
			<strong>Disable new attachments</strong><br>
			Existing attachments are still accessible, but no new attachments can be added, regardless of permission.
		</li>
	</ul>';
$helptxt['attachment_image_paranoid'] = 'Selecting this setting will enable very strict security checks on image attachments. <strong>Warning!</strong> These extensive checks can fail on valid images too. It is strongly recommended to only use this setting together with image re-encoding, in order to have SMF try to resample the images which fail the security checks: if successful, they will be sanitized and uploaded. Otherwise, if image re-encoding is not enabled, all attachments failing checks will be rejected.';
$helptxt['attachment_image_reencode'] = 'Selecting this setting will enable trying to re-encode the uploaded image attachments. Image re-encoding offers better security. Note however that image re-encoding also renders all animated images static. <br> This feature is only possible if the GD module is installed on your server.';
$helptxt['attachment_thumb_memory'] = 'The larger the source image (size & width x height), the higher the memory requirements are for the system to successfully create a thumbnail image.<br>Checking this setting, the system will estimate the required memory and will then request that amount. If successful, only then will it attempt to create the thumbnail.<br>This will result in fewer white page errors but may result in fewer thumbnails being created. Leaving this unchecked will always cause the system to try to create the thumbnail (with a fixed amount of memory). This may result in more white page errors.';
$helptxt['attachmentRecodeLineEndings'] = 'The script will re-code line endings according to your server.';
$helptxt['automanage_attachments'] = 'By default, SMF puts new attachments into a single folder. For most sites this is not a problem, but as a site grows it can be useful to have multiple folders to store attachments in.<br><br>This setting allows you to set whether you manage these folders yourself (e.g. creating a second folder and moving to it when you are ready) or whether you let SMF do it, based on criteria, such as when the current directory reaches a given size, or breaking down folders by years or even months on very busy sites.';
$helptxt['dont_show_attach_under_post'] = 'If enabled, the attachments embedded in the post won\'t appear under the post, but are still subject to be deleted.';
$helptxt['use_subdirectories_for_attachments'] = 'Create new directories.';
$helptxt['max_image_height'] = 'As with the maximum width, this setting indicates the maximum height a posted image can be.';
$helptxt['avatar_paranoid'] = 'Selecting this setting will enable very strict security checks on avatars. <strong>Warning!</strong> These extensive checks can fail on valid images too. It is strongly recommended to only use this setting together with avatar re-encoding, in order to have SMF try to resample the images which fail the security checks: if successful, they will be sanitized and uploaded. Otherwise, if re-encoding of avatars is not enabled, all avatars failing checks will be rejected.';
$helptxt['avatar_reencode'] = 'Selecting this setting will enable trying to re-encode the uploaded avatars. Image re-encoding offers better security. Note, however, that image re-encoding also renders all animated images static. <br> This feature is only possible if the GD module is installed on your server.';
$helptxt['cal_enabled'] = '日曆可以顯示會員的生日及重要的公告.<br /><br />
		<strong>顯示連結日期到 \'發表事件\'</strong>:<br />當會員點選日期時可以讓他們發佈事件.<br />
		<strong>顯示週數</strong>:<br />顯示第幾個禮拜.<br />
		<strong>論壇首頁顯示的天數</strong>:<br />如果您設定的是7, 那一週內的事件都會出現在論壇首頁.<br />
		<strong>主頁裡顯示假期</strong>:<br />主頁裡會顯示今天是什麼假期.<br />
		<strong>主頁裡顯示生日</strong>:<br />主頁裡會顯示今天是誰的生日.<br />
		<strong>主頁裡顯示事件</strong>:<br />主頁裡會顯示今天的事件.<br />
		<strong>事件將出現到的看板</strong>:<br />您想要發表的事件出現在哪個看板內?<br />
		<strong>允許事件不連到文章</strong>:<br />可以直接讓會員發佈事件，不需選擇出現在哪個文章內。<br />
		<strong>年份的最小值</strong>:<br />設定日曆的 &quot;第一年&quot;.<br />
		<strong>年份的最大值</strong>:<br />設定日曆的 &quot;最後一年&quot;.<br />
		<strong>生日顏色</strong>:<br />輸入生日的顏色<br />
		<strong>事件顏色</strong>:<br />輸入事件的顏色<br />
		<strong>假期顏色</strong>:<br />輸入假期的顏色<br />
		<strong>允許事件維持數日</strong>:<br />勾選如果你允許同樣的事件維持多天.<br />
		<strong>事件可維持日數</strong>:<br />選擇事件可以維持的日數.<br /><br />
		記得會員使用日曆的功能 (發佈事件, 瀏覽事件等等) 可以在權限選單裡面開啟.';
$helptxt['cal_link_postevent'] = 'This will allow members to post events for that day, when they click on that date';
$helptxt['cal_maxdays_advance'] = 'If this is set to 7, the next week\'s worth of events will be shown';
$helptxt['cal_allow_unlinkedevents'] = 'Allow members to post events without requiring them to be linked with a post in a board';
$helptxt['cal_min_year'] = 'Select the &quot;first&quot; year on the calendar list';
$helptxt['cal_max_year'] = 'Select the &quot;last&quot; year on the calendar list';
$helptxt['cal_maxevent_span'] = 'Select the maximum number of days that an event can span';
$helptxt['localCookies'] = 'SMF 使用 cookies 來儲存登入資料到會員的電腦裡.
	Cookies 可以用全區性的方式儲存 (myserver.com) 或以區域性的方式來儲存 (myserver.com/path/to/forum).<br />
	使用這個選項如果會員無法永久登入, 或自動登出.<hr />
	普遍式儲存比較不安全如果你使用分享的伺服器 (譬如 Kimo 的免費網址).<hr />
	地區式儲存無法到論壇的資料夾外使用, 如果你的論壇安裝在 www.myserver.com/forum, 網頁像 www.myserver.com/index.php 將無法使用帳戶的資料.
	如果使用 SSI.php, 建議您使用全區性來儲存.';
$helptxt['enableBBC'] = '使用這個選項可讓會員使用 Bulletin Board Code (BBCode 代碼). BBCode 代碼可讓會員改變文章內容的形式.';
$helptxt['legacy_bbc'] = 'Legacy BBCodes are obsolete and cannot be used in new posts. However, they will be parsed in existing posts if enabled here.<br><br>Enabling legacy BBCodes is only useful if your forum was upgraded from a previous version of SMF.<br><br>Also, even when they are enabled, some legacy BBCodes will not be rendered in the same way that they once were. For example, the [flash] BBCode will simply show a link to the Flash content instead of embedding it.';
$helptxt['default_timezone'] = 'This is the default timezone used for the display of times throughout the forum.';
$helptxt['timezone_priority_countries'] = 'This setting lets you push the time zones for a certain country or countries to the top of the list of selectable time zones that is shown when users are configuring their profiles, creating calendar events, etc.<br><br>For example, if many of your forum\'s members live in New Zealand or Fiji, you may enter "NZ,FJ" to make it easier for them to find the most relevant time zones quickly.<br><br>You can find the complete list of ISO country codes by searching the Internet for "<a href="https://www.google.com/search?q=iso+3166-1+alpha-2" target="_blank" rel="noopener">ISO 3166-1 alpha-2</a>".';
$helptxt['spamWaitTime'] = '你可以在這選擇會員發佈文章時該等的時間. 這個功能可以禁止會員灌水.';

$helptxt['enablePostHTML'] = '允許使用基本的 HTML:
	<ul style="margin-bottom: 0;">
		<li>&lt;b&gt;, &lt;u&gt;, &lt;i&gt;, &lt;s&gt;, &lt;em&gt;, &lt;ins&gt;, &lt;del&gt;</li>
		<li>&lt;a href=&quot;&quot;&gt;</li>
		<li>&lt;img src=&quot;&quot; alt=&quot;&quot; /&gt;</li>
		<li>&lt;br /&gt;, &lt;hr /&gt;</li>
		<li>&lt;pre&gt;, &lt;blockquote&gt;</li>
	</ul>';

$helptxt['themes_manage'] = 'Here you can install new themes and select which themes your users can choose from, the default theme that new users and guests will use, as well as other theme selection settings.';
$helptxt['theme_install'] = '這裡可以讓你安裝新的佈景. 你可以用已建的資料夾, 然後上傳你要的佈景, 或者複製預設的佈景.<br /><br />
	注意: 在佈景的資料夾裡必須要有 <tt>theme_info.xml</tt> 定義檔.';
$helptxt['xmlnews_enable'] = '允許會員連結 <a href="%1$s?action=.xml;sa=news">最新消息</a>
	及相關的資料。建議你限制最近公告及文章的使用值, 因為有些使用 RSS 數據的軟體會縮短公告的資料 (例如 Trillian)。';
$helptxt['xmlnews_attachments'] = 'Allows links to attachments to be enclosed within your XML/RSS feeds. Turn this on if you want to use your forum as a podcasting, broadcatching, or similar content distribution platform.
	<br><br>
	The "view attachments" permission affects this setting. Members and guests will only see a post\'s attachments in the feed if they can also see the attachments on the post\'s web page. Keep in mind that most feed readers will access your feeds as a guest.
	<br><br>
	Some feed formats only allow one enclosed attachment per post. If a post has multiple attachments, SMF will enclose the largest one in these feeds.';
$helptxt['globalCookies'] = '允許使用次級域名的 Cookies. 例如, 如果...<br />
	您的網址是 http://www.simplemachines.org/,<br />
	您的論壇在 http://forum.simplemachines.org/,<br />
	使用此項可以讓你使用論壇的 cookie 在您的網址裡。請勿使用這項功能如果次網域 (像 hacker.simplemachines.org 不是您所擁有)。';
$helptxt['globalCookiesDomain'] = 'When using subdomain independent cookies (global cookies), you can specify which domain should be used for them. This should, of course, be set to your main domain - for example, if you are using <em>forum.example.com</em> and <em>www.example.com</em>, the domain is <em>example.com</em> in this case. You should not put the <em>http://</em> or <em>https://</em> part in front of it.';
$helptxt['secureCookies'] = 'Enabling this option will force the cookies created for users on your forum to be marked as secure. Only enable this option if you are using HTTPS throughout your site as it will break cookie handling otherwise!';
$helptxt['securityDisable'] = 'When enabled, this <em>disables</em> the additional password check for the administration page. This is not recommended!';
$helptxt['securityDisable_why'] = 'Enter your current password. (The same one you use to login.)<br><br>The requirement to enter this helps ensure that you want to do whatever administration you are doing, and that it is <strong>you</strong> doing it.';
$helptxt['securityDisable_moderate'] = 'When enabled, this <em>disables</em> the additional password check for the moderation page. This setting is enabled by default.';
$helptxt['securityDisable_moderate_why'] = 'Enter your current password. (The same one you use to login.)<br><br>The requirement to enter this helps ensure that you want to do whatever moderation you are doing, and that it is <strong>you</strong> doing it.';
$helptxt['allow_cors'] = 'Cross Origin Resource Sharing or CORS is a policy for modern browsers to trust resources being requested across different domains.  If enabled, this will attempt to resolve CORS policy for scripts accessing the forum resources from different domains.  If subdomain independent cookies (global cookies) are enabled, attempts are made to determine the proper domain.  Supplying the Additional CORS domains with a comma separated list of domains allows for additional domains.  The format should be {SCHEMA}://{DOMAIN}.  If a wildcard (*) is supplied in the domain, attempts are made to resolve the wildcard.  If a wildcard (*) is supplied as the only additional domain, all domains are allowed and this may present a security risk to your forum and should not be used except in extreme cases.  Additional headers can be supplied in a comma separated list and will be allowed during requests containing these headers and wildcard (*) is allowed.';
$helptxt['frame_security'] = 'Modern browsers now understand a security header presented by servers called X-Frame-Options. By setting this option you specify how you want to allow your site to be framed inside a frameset or a iframe. Disable will not send any header and is the most unsecure, however allows the most freedom. Deny will prevent all frames completely and is the most restrictive and secure. Allowing the Same Origin will only allow your domain to issue any frames and provides a middle ground for the previous two options.';
$helptxt['proxy_ip_header'] = 'This is the server header that will be trusted by SMF for containing the actual users IP address. Changing this setting can cause unexpected IP results on members. Please check with your server administrator, CDN provider or proxy administrator prior to changing these settings. Most providers will understand and use HTTP_X_FORWARDED_FOR. You should fill out the list of Servers sending the reverse proxy headers for security to ensure these headers only come from valid sources.';
$helptxt['email_members'] = 'In this message you can use a few &quot;variables&quot;. These are:<br>
	{$board_url} - The URL to your forum.<br>
	{$current_time} - The current time.<br>
	{$member.email} - The current member\'s email.<br>
	{$member.link} - The current member\'s link.<br>
	{$member.id} - The current member\'s id.<br>
	{$member.name} - The current member\'s name. (for personalization).<br>
	{$latest_member.link} - The most recently registered member\'s link.<br>
	{$latest_member.id} - The most recently registered member\'s id.<br>
	{$latest_member.name} - The most recently registered member\'s name.';

$helptxt['failed_login_threshold'] = '設定錯誤登入的數量, 之後轉向到忘記密碼頁面.';
$helptxt['loginHistoryDays'] = 'The number of days to keep login history under user profile tracking. The default is 30 days.';
$helptxt['oldTopicDays'] = '如果使用這個功能，會員在回覆文章時會檢查主題的日期，如果主題已很久沒有回復，會員會收到警告的訊息。設為 0 表示關閉此功能。';
$helptxt['edit_wait_time'] = '如果會員在設定的時間內編輯文章，文章將不會顯示最後編輯時間的訊息。';
$helptxt['edit_disable_time'] = '設定會員在文章發表之後, 超過多少時間(分鐘)不能再修改文章。0=停用。<br /><br /><em>注意: 這不會影響有權限編輯別人文章的人。</em>';
$helptxt['preview_characters'] = 'This setting sets the number of available characters for the first and last message topic preview.';
$helptxt['quote_expand'] = 'This setting allows large quotes to be collapsed, giving the user the option to expand them to their full length. Quotes smaller than this setting won\'t be affected.';
$helptxt['posts_require_captcha'] = 'This setting will force users to enter a code shown on a verification image each time they make a post to the board. Only users with a post count below the number set will need to enter the code - this should help combat automated spamming scripts.';
$helptxt['disable_wysiwyg'] = 'This setting disallows all users from using the WYSIWYG (&quot;What You See Is What You Get&quot;) editor on the post page.';
$helptxt['lastActive'] = '顯示時間已內的在線會員. 預設值是15分鐘.';

$helptxt['customoptions'] = 'This section defines the options that a user may choose from a drop down list. There are a few key points to note in this section:
	<ul>
		<li><strong>Default Option:</strong> Whichever option box has the &quot;radio button&quot; next to it selected will be the default selection for the user when they enter their profile.</li>
		<li><strong>Removing Options:</strong> To remove an option simply empty the text box for that option - all users with that selected will have their option cleared.</li>
		<li><strong>Reordering Options:</strong> You can reorder the options by moving text around between the boxes. However - an important note - you must make sure you do <strong>not</strong> change the text when reordering options as otherwise user data will be lost.</li>
	</ul>';

$helptxt['autoFixDatabase'] = 'This will automatically fix broken tables and resume as if nothing happened. It does email you when this happens.<br>If you choose to disable this option, your forum will be down until you notice and manually fix the problem.';
// argument(s): scripturl
$helptxt['pgFulltextSearch'] = 'This setting defines the language to use for PostgreSQL\'s fulltext search. Choose the language that most closely matches the language your forum actually uses. If your forum\'s language is not listed, or if your forum is multi-lingual, choose the "simple" option. <br>
This setting is independent of your main SMF language settings and not related to the installed language for SMF. <br>
When you change this setting you need to <a href="%1$s?action=admin;area=managesearch;sa=method" target="_blank" rel="noopener">rebuild the fulltext search index</a>.<br>
If a language you need is not listed, ask your database admin to install PostgreSQL language support for that language.';

$helptxt['enableParticipation'] = '這個會顯示會員發表的主題圖示。';

$helptxt['db_persist'] = '延續線路使伺服器永遠在線. 通常會增加論壇速度但是有些主機會產生問題.';
$helptxt['ssi_db_user'] = 'Optional setting to use a different database user and password when you are using SSI.php.';

// argument(s): either $helptxt['queryless_urls_supported'] or $helptxt['queryless_urls_unsupported'], depending on whether the server uses a supported webserver
$helptxt['queryless_urls'] = 'This changes the format of URLs a little so search engines will like them better. They will look like index.php/topic,1.0.html.<br><br>%1$s';
// is conditionally used as part of $helptxt['queryless_urls']
$helptxt['queryless_urls_supported'] = 'This feature will work on your server.';
// is conditionally used as part of $helptxt['queryless_urls']
$helptxt['queryless_urls_unsupported'] = 'This feature will not work on your server.';
$helptxt['minimize_files'] = 'This option will minimize the CSS and JavaScript files used by your forum, reducing the request calls to your server and speeding up load times for your users.<br><br>You should normally leave this option enabled. The only time you might want to disable it temporarily is while you are in the process of altering the CSS or JavaScript files used on your site (for example, when editing your theme files or developing a modification).';
$helptxt['boardindex_max_depth'] = 'This setting controls how many sub-board levels SMF will check when looking for new posts in sub-boards. It also affects which boards are included when the "Count sub-board\'s posts in parent\'s totals" option is enabled.<br><br>For example, if this is set to 1, a sub-board will only be marked "new" on the index page if the sub-board itself contains a new post. If it is set to 2, the sub-board will be marked "new" if there is a new post in the sub-board or in a sub-sub-board. If it is set to 10, the sub-board will be marked "new" if there is a new post in the sub-board, a sub-sub-board, a sub-sub-sub-board, etc., up to 10 levels deep.<br><br>Large, active forums may want to set this value to a low number in order to conserve server resources.';
$helptxt['countChildPosts'] = '勾選這個功能表示子看板內的文章也會計算在論壇首頁顯示的文章數。<br /><br />這會讓論壇變慢，同時也表示沒有文章的母看板不會顯示 0 篇文章。';
$helptxt['allow_ignore_boards'] = '勾選這個功能會允許會員選擇他們想忽視的看板。';
$helptxt['deny_boards_access'] = 'Checking this setting will allow you to deny access to certain boards based on membergroup access';

// argument(s): scripturl
$helptxt['who_enabled'] = 'This setting allows you to turn on or off the <a href="%1$s?action=who" target="_blank" rel="noopener">Who\'s Online</a> page, which shows who is browsing the forum and what they are doing.';

$helptxt['recycle_enable'] = ' 將 &quot;回收文章&quot; 移到到選擇的看板.';

$helptxt['enableReportPM'] = '這可以讓您的會員檢舉不當的私人訊息。';
$helptxt['max_pm_recipients'] = '這個選項可以讓您設定每個會員最多一次能夠寄件給多少會員。這是為了避免私人訊息的系統被濫用。記得如果會員能夠寄送新聞信件，他們不會被這個設定限制。設定 0 如果不限制收件者的上限。';
$helptxt['pm_posts_verification'] = '這個設定會強制會員在傳送私人訊息時輸入驗證碼。只有文章少於某數量的會員需要輸入驗證碼 - 這可以用來防止自動的垃圾攻擊。';
$helptxt['pm_posts_per_hour'] = '這個設定會限制會員在一個小時內傳送的私人訊息數量，但不限於管理員和版主。';

$helptxt['default_personal_text'] = '設定新會員預設的 &quot;個人訊息&quot;。';

$helptxt['registration_method'] = '您可以設定哪種會員註冊的方法, 您可以選擇:<br /><br />
	<ul>
		<li>
			<strong>禁止註冊:</strong><br />
				禁止新會員註冊.<br />
		</li><li>
			<strong>馬上註冊</strong><br />
				新註冊會員可馬上發佈文章.<br />
		</li><li>
			<strong>啟用帳號</strong><br />
				新註冊用戶會收到論壇的啟用郵件, 用戶必須啟用帳號才可成為會員.<br />
		</li><li>
			<strong>核准帳號</strong><br />
				新註冊用戶必須等管理員核准才可成為會員.
		</li>
	</ul>';

$helptxt['send_validation_onChange'] = '當使用這項功能時, 改變電子郵件的會員必須重新啟用帳號';
$helptxt['approveAccountDeletion'] = 'When this setting is checked, any user request to delete his own account has to be approved by an administrator';

$helptxt['send_welcomeEmail'] = '當使用這項功能時, 新註冊會員會收到歡迎信件';
$helptxt['password_strength'] = '這個設定可以讓您使用不同的密碼困難度。越困難的密碼表示越難被駭。
	可用的設定是：
	<ul>
		<li><strong>低：</strong> 密碼必須多於 4 個字元。</li>
		<li><strong>中：</strong> 密碼必須多於 8 個字元，不能包括會員名稱和電子郵件。</li>
		<li><strong>高：</strong> 跟中相同，但是密碼必須有大小寫的字母和至少一個數字。</li>
	</ul>';
$helptxt['enable_password_conversion'] = 'By enabling this setting, SMF will attempt to detect passwords stored in other formats and convert them to the format SMF uses. Typically this is used for forums converted to SMF, but may have other uses as well. Disabling this prevents a user from logging in using their password after a conversion and they would need to reset their password.';

$helptxt['coppaAge'] = 'The value specified in this box will determine the minimum age that new members must be in order to be granted immediate access to the forum.
	On registration they will be prompted to confirm whether they are over this age, and if not will either have their application rejected or suspended awaiting parental approval - dependent on the type of restriction chosen.
	If a value of 0 is chosen for this setting then all other age restriction settings shall be ignored.';
$helptxt['coppaType'] = '如果使用年齡限制的功能，這裡的設定可以讓您選擇對年齡過小的會員所進行的動作，有兩個選擇：
	<ul>
		<li>
			<strong>馬上拒絕註冊：</strong><br />
				年齡太小會馬上被拒絕註冊。<br />
		</li><li>
			<strong>需要監護人認可</strong><br />
				任何年齡太小的會員需要監護人的認可才能註冊，註冊會標示為等待認可。之後論壇會顯示認可的表單。
				會員必須請監護人認可後將表單寄回或傳真給管理員。
		</li>
	</ul>';
$helptxt['coppaPost'] = '這裡的欄位必須填寫如果論壇有限制會員的年齡。資料會顯示給年齡過小的會員，會員必須要監護人的認可才能註冊完成。至少需要提供地址或傳真號碼的資料。';

$helptxt['allow_hideOnline'] = '允許使用此項功能可讓會員隱藏自己, 只有管理員才能看到他們. 如果不允許, 只有版主才能隱藏上線資料.';
$helptxt['meta_keywords'] = 'These keywords are sent in the output of every page to indicate to search engines (etc) the key content of your site. They should be a comma separated list of words, and should not use HTML.';

$helptxt['latest_themes'] = '這裡會顯示 <a href="http://www.simplemachines.org/" target="_blank">www.simplemachines.org</a> 的最新及最受歡迎的佈景. 如果未顯示任何東西表示您無法連接到 <a href="http://www.simplemachines.org/" target="_blank">www.simplemachines.org</a>.';

$helptxt['secret_why_blank'] = '因為安全問題, 您問題的答案 (以及密碼) 都是用 SMF 的方法來加密. SMF 有辦法確認您的身分如果您提供正確的答案, 但是從不會顯示您的答案或密碼.';
$helptxt['moderator_why_missing'] = '您必須在 <a href="javascript:window.open(\'%1$s?action=manageboards\'); self.close();">看板管理介面</a> 選擇板主。';

$helptxt['permissions'] = '權限頁面允許你設定組群所能做的事.<br /><br />你可以從選單來更改權限, 然後套用到看板.';
$helptxt['permissions_board'] = '如果看板的設定值是 \'全區性,\' 表示這個看板無特別的權限.  \'區域性\' 表示看板有自己的權限 - 跟全區性不同. 如果有些看板的權限跟別區不同, 您可以用區域性設定, 這樣您就不用一個看板一個看板設定.';
$helptxt['permissions_quickgroups'] = '您可以用 &quot;預設&quot; 權限 - 普通表示 \'無特別權限\', 限制表示 \'訪客的權限\', 版主表示 \'版主的權限\', 及 \'維修權限\' 表示跟版主接近的權限.';
$helptxt['permissions_deny'] = '停用的權限會讓會員無法使用某種功能。您可以新增一個群組，給它停用的權限，然後把將會員加入到那個群組。<br /><br />記住，停用的權限會完全禁止會員使用某種功能，不管會員是不是屬於其它的群組。';
$helptxt['permissions_postgroups'] = '開啟依文章數的群組可以讓您依照會員的文章數來改變會員的權限。文章數的權限會 <em>加在</em> 特殊群組的權限內。';
$helptxt['membergroup_guests'] = '訪客的群組是任何未登入的使用者。';
$helptxt['membergroup_regular_members'] = '普通會員是已登入的會員，但是不屬於任何特殊群組。';
$helptxt['membergroup_administrator'] = '管理員可以管理任何看板和任何設定。您不能改變管理員的權限。';
$helptxt['membergroup_moderator'] = '版主的群組是特殊群組。它的權限只有在<em>版主可管理的看板才有效</em>。在其他看板就跟其他會員相同。';
$helptxt['membergroups'] = 'In SMF there are two types of groups that your members can be part of. These are:
	<ul class="normallist">
		<li><strong>Regular Groups:</strong> A regular group is a group in which members are not automatically placed. To assign a member to be in a group simply go to their profile and click &quot;Account Settings&quot;. From here you can assign them any number of regular groups to which they will be part.</li>
		<li><strong>Post Groups:</strong> Unlike regular groups post based groups cannot be assigned. Instead, members are automatically assigned to a post based group when they reach the minimum number of posts required to be in that group.</li>
	</ul>';

$helptxt['calendar_how_edit'] = '您可以點名稱旁的紅色 (*) 來修改事件.';

$helptxt['maintenance_backup'] = '這裡您可以備份文章, 設定, 會員資料, 及其他消息.<br /><br />建議您作好防禦措施, 要時常備份以免無法修復論壇的錯誤.';
$helptxt['maintenance_rot'] = '這個功能會<strong>完全地</strong>並且<strong>無法回復地</strong>移除舊的主題。強烈建議您執行之前先備份, 以防止您移除您想保留的文章。<br /><br />使用這個功能必須謹慎小心。';
$helptxt['maintenance_members'] = 'This allows you to <strong>completely</strong> and <strong>irrevocably</strong> remove member accounts from your forum.  It is <strong>highly</strong> recommended that you try to make a backup first, just in case you remove something you didn\'t mean to.<br /><br />Use this option with care.';

$helptxt['avatar_server_stored'] = 'This allows your members to pick from avatars stored on your server itself. By default they are stored in the "avatars" directory.<br>As a tip, if you create directories in that folder, you can make "categories" of avatars.';
$helptxt['avatar_external'] = 'With this enabled, your members can type in a URL to their own avatar.  The downside of this is that, in some cases, they may use avatars that are overly large or portray images you don\'t want on your forum.';
$helptxt['avatar_download_external'] = 'With this setting enabled, external avatars will be downloaded from the URLs given by the users. On success, the avatars will be treated like uploaded avatars.';
$helptxt['avatar_action_too_large'] = 'This setting lets you reject images (from other sites) that are too big, or tells the user\'s browser to resize them, or to download them to your server.<br><br>If users put in very large images as their avatars and resize in the browser, it could cause very slow loading for your users - it does not actually resize the file, it just displays it smaller. So a digital photo, for example, would still be loaded in full and then resized only when displayed - so for users this could get quite slow and use a lot of bandwidth.<br><br>On the other hand, downloading them means using your bandwidth and server space, but you also ensure that images are smaller, so it should be faster for users. (Note: downloading and resizing requires either the GD library, or ImageMagick using either the Imagick or MagickWand extensions)';
$helptxt['avatar_upload'] = 'This setting is much like &quot;external avatars&quot;, except that you have better control over the avatars, a better time resizing them, and your members do not have to have somewhere to put avatars.<br><br>However, the downside is that it can take a lot of space on your server.';
$helptxt['avatar_download_png'] = 'PNGs 檔通常較大, 但是壓縮品質較好. 如果您不允許 PNG 檔, 圖檔會使用 JPEG. JPEG 檔較小但是品質較差.';

$helptxt['disableHostnameLookup'] = '這項禁止使用搜索主機名稱, 但是有些伺服器會變慢. 可能會讓您禁止用戶的方法較無作用.';

$helptxt['smiley_sameall'] = 'If checking "Same image for all sets", the same image will be added to all your smiley sets. If you uncheck the box, a different image can be uploaded for every installed smiley set. Note that an image needs to be provided for every smiley set.';

$helptxt['search_weight_frequency'] = '搜尋重量是用來決定適當的搜尋結果。您可以對符合論壇的重要性來改變這些重量。例如一個新聞的論壇，較高的 \'最後一篇文章的日期\' 的數值會比較好。全部的數值必須是正數。<br /><br />這個重量會計算符合的文章的數量，然後除於主題內的文章數。';
$helptxt['search_weight_age'] = '搜尋重量是用來決定適當的搜尋結果。您可以對符合論壇的重要性來改變這些重量。例如一個新聞的論壇，較高的 \'最後一篇文章的日期\' 的數值會比較好。全部的數值必須是正數。<br /><br />這個重量會找主題內最後一篇文章的日期。越新的日期，分數越高。';
$helptxt['search_weight_length'] = '搜尋重量是用來決定適當的搜尋結果。您可以對符合論壇的重要性來改變這些重量。例如一個新聞的論壇，較高的 \'最後一篇文章的日期\' 的數值會比較好。全部的數值必須是正數。<br /><br />這個重量會計算主題的文章數量。越多文章的主題，分數越高。';
$helptxt['search_weight_subject'] = '搜尋重量是用來決定適當的搜尋結果。您可以對符合論壇的重要性來改變這些重量。例如一個新聞的論壇，較高的 \'最後一篇文章的日期\' 的數值會比較好。全部的數值必須是正數。<br /><br />這個重量會在主題的標題內找搜尋字。';
$helptxt['search_weight_first_message'] = '搜尋重量是用來決定適當的搜尋結果。您可以對符合論壇的重要性來改變這些重量。例如一個新聞的論壇，較高的 \'最後一篇文章的日期\' 的數值會比較好。全部的數值必須是正數。<br /><br />這個重量會在主題內的第一篇文章內找搜尋字。';
$helptxt['search_weight_sticky'] = '搜尋重量是用來決定適當的搜尋結果。您可以對符合論壇的重要性來改變這些重量。例如一個新聞的論壇，較高的 \'最後一篇文章的日期\' 的數值會比較好。全部的數值必須是正數。<br /><br />這個重量會看主題是不是頂置主題，如果是，它的分數越高。';
$helptxt['search'] = '這裡可以改變搜尋功能的設定。';
$helptxt['search_why_use_index'] = 'A search index can greatly improve the performance of searches on your forum. Especially when the number of messages on a forum grows bigger, searching without an index can take a long time and increase the pressure on your database. If your forum is bigger than 50.000 messages, you might want to consider creating a search index to assure peak performance of your forum.<br><br>Note that a search index can take up quite some space. A fulltext index is a built-in index of MySQL and PostgreSQL. It\'s relatively compact (approximately the same size as the message table), but a lot of words aren\'t indexed and it can, in some search queries, turn out to be very slow. The custom index is often bigger (depending on your configuration it can be up to 3 times the size of the messages table) but it\'s performance is better than fulltext and relatively stable.';

$helptxt['see_admin_ip'] = 'IP位址可讓版主追蹤會員的動作, 但是有些IP經常改變. 會員也可以看到自己的IP.';
$helptxt['see_member_ip'] = '只有會員自己和版主可以看到IP. 其他的會員無法看到您的IP, 您也不能看到其他會員的IP, 除非您是管理員.';
$helptxt['whytwoip'] = 'SMF uses various methods to detect user IP addresses. Usually these two methods result in the same address but in some cases more than one address may be detected. In this case SMF logs the two most recent addresses, and uses them both for ban checks (etc). You can click on either address to track that IP and ban if necessary.';

$helptxt['ban_cannot_post'] = '\'不能發佈\' 的限制會禁止被阻擋的會員進行發言。他們將不能發佈主題，回覆文章，寄送私人訊息或參與投票。不過他們還是可以閱讀私人訊息和文章。<br /><br />論壇會顯示警告訊息給這些會員。';

$helptxt['posts_and_topics'] = '
	<ul>
		<li>
			<strong>文章設定</strong><br />
			改變發佈文章和顯示文章的設定。這裡也可以讓您開啟拼字功能。
		</li><li>
			<strong>Bulletin Board Code</strong><br />
			開啟 BBC 的功能。也可以選擇允許和不允許的 BBC。
		</li><li>
			<strong>封鎖的字元</strong>
			為了避免論壇出現不正當的發言，您可以將某些字封鎖不讓會員使用。這個功能可以讓您將封鎖的字改成其它的顯示方法。
		</li><li>
			<strong>主題設定</strong>
			改變主題的設定。您可以改變每頁顯示的主題數，使用頂至主題，或是熱門主題的數量等等。
		</li>
	</ul>';

$helptxt['spider_mode'] = 'Sets the logging level.<br>
Standard - Logs minimal spider activity.<br>
Moderate - Provides more accurate statistics.<br>
Aggressive - Same as &quot;Moderate&quot;, but logs data about each page visited.';

$helptxt['spider_group'] = 'By selecting a restrictive group, when a guest is detected as a search crawler it will automatically be assigned any &quot;deny&quot; permissions of this group in addition to the normal permissions of a guest. You can use this to provide lesser access to a search engine than you would a normal guest. You might for example wish to create a new group called &quot;Spiders&quot; and select that here. You could then deny permission for that group to view profiles to stop spiders indexing your members profiles.<br>Note: Spider detection is not perfect and can be simulated by users so this feature is not guaranteed to restrict content only to those search engines you have added.';
$helptxt['show_spider_online'] = 'This setting allows you to select whether spiders should be listed in the who\'s online list on the board index and &quot;Who\'s Online&quot; page. Options are:
	<ul class="normallist">
		<li>
			<strong>Not at All</strong><br />
			Spiders will simply appear as guests to all users.
		</li><li>
			<strong>Show Spider Quantity</strong><br />
			The Board Index will display the number of spiders currently visiting the forum.
		</li><li>
			<strong>Show Spider Names</strong><br />
			Each spider name will be revealed, so users can see how many of each spider is currently visiting the forum - this takes effect in both the Board Index and Who\'s Online page.
		</li><li>
			<strong>Show Spider Names - Admin Only</strong><br />
			As above except only Administrators can see spider status - to all other users spiders appear as guests.
		</li>
	</ul>';

$helptxt['birthday_email'] = 'Choose the index of the birthday email message to use. A preview will be shown in the Email Subject and Email Body fields.<br /><strong>Note:</strong> Setting this option does not automatically enable birthday emails. To enable birthday emails use the <a href="%1$s?action=admin;area=scheduledtasks;%3$s=%2$s" target="_blank" class="new_win">Scheduled Tasks</a> page and enable the birthday email task.';
$helptxt['pm_bcc'] = 'When sending a personal message you can choose to add a recipient as BCC or &quot;Blind Carbon Copy&quot;. BCC recipients do not have their identities revealed to other recipients of the message.';

$helptxt['move_topics_maintenance'] = 'This will allow you to move all the posts from one board to another board.';
$helptxt['maintain_reattribute_posts'] = 'You can use this function to attribute guest posts on your board to a registered member. This is useful if, for example, a user deleted their account and changed their mind and wished to have their old posts associated with their account.';
$helptxt['chmod_flags'] = 'You can manually set the permissions you wish to set the selected files to. To do this enter the chmod value as a numeric (octet) value. Note - these flags will have no effect on Microsoft Windows operating systems.';

$helptxt['postmod'] = 'This section allows members of the moderation team (with sufficient permissions) to approve any posts and topics before they are shown.';

$helptxt['field_show_enclosed'] = 'Encloses the user input between some text or html. This will allow you to add more instant message providers, images or an embed etc. For example:<br><br>
		&lt;a href="https://example.com/{INPUT}"&gt;&lt;img src="{DEFAULT_IMAGES_URL}/icon.png" alt="{INPUT}" /&gt;&lt;/a&gt;<br><br>
		Note that you can use the following variables:<br>
		<ul class="normallist">
			<li>{INPUT} - The input specified by the user.</li>
			<li>{SCRIPTURL} - Web address of forum.</li>
			<li>{IMAGES_URL} - URL to images directory in the users current theme.</li>
			<li>{DEFAULT_IMAGES_URL} - URL to the images directory in the default theme.</li>
			<li>{KEY} - Used when a field has multiple options, is the unique numeric ID used to identify it.</li>
		</ul>';

$helptxt['custom_mask'] = '輸入遮罩對於論壇的安全性很重要。驗證會員輸入的內容, 以確保是合法字串。下面是正規表式的簡單說明。<br /><br />
	<div class="smalltext" style="margin: 0 2em">
		&quot;[A-Za-z]+&quot; - Match all upper and lower case alphabet characters.<br />
		&quot;[0-9]+&quot; - Match all numeric characters.<br />
		&quot;[A-Za-z0-9]{7}&quot; - Match all upper and lower case alphabet and numeric characters seven times.<br />
		&quot;[^0-9]?&quot; - Forbid any number from being matched.<br />
		&quot;^([A-Fa-f0-9]{3}|[A-Fa-f0-9]{6})$&quot; - Only allow 3 or 6 character hexcodes.<br />
	</div><br /><br />
	Additionally, special metacharacters ?+*^$ and {xx} can be defined.
	<div class="smalltext" style="margin: 0 2em">
		? - None or one match of previous expression.<br />
		+ - One or more of previous expression.<br />
		* - None or more of previous expression.<br />
		{xx} - An exact number from previous expression.<br />
		{xx,} - An exact number or more from previous expression.<br />
		{,xx} - An exact number or less from previous expression.<br />
		{xx,yy} - An exact match between the two numbers from previous expression.<br />
		^ - Start of string.<br />
		$ - End of string.<br />
		\\\\ - Escapes the next character.<br />
	</div><br /><br />
	更多資訊和技巧可以在網路上找得到。';

$helptxt['topic_move_any'] = 'If checked, users will be allowed to move topics to any board they can see. Otherwise, they will only be able to move them to boards where they can post new topics.';

$helptxt['alert_pm_new'] = 'Notifications of new personal messages do not appear in the Alerts pane, but appear in the "My Messages" list instead.';
$helptxt['alert_event_new'] = 'This will send out an alert or email as requested if there is a new calendar event added. However, if that event is posted and a topic is added, you will not get an alert for the event if you\'re already following that board - the alert from following the board would cover this.';

$helptxt['force_ssl'] = '<strong>Test SSL and HTTPS on your server properly before enabling this, it may cause your forum to become inaccessible.</strong> Enable maintenance mode if you are unable to access the forum after enabling this.<br><br><strong>Changing this setting will update your forum\'s primary URL, as well as the URLs for your theme files and images, smileys, and avatars, setting them to either http: or https: based on your selection. Customized URLs will not be affected.</strong>';
$helptxt['image_proxy_enabled'] = 'Required for embedding external images when in full SSL';
$helptxt['image_proxy_secret'] = 'Keep this a secret, protects your forum from hotlinking images. Change it in order to render current hotlinked images useless';
$helptxt['image_proxy_maxsize'] = 'Maximum image size that the SSL image proxy will cache: bigger images will be not be cached. Cached images are stored in your SMF cache folder, so make sure you have enough free space.';

$helptxt['enable_sm_stats'] = 'If enabled, this will allow Simple Machines to visit your site once a month to collect basic statistics. This will help us make decisions as to which configurations to optimize the software for. For more information please visit our <a href="https://www.simplemachines.org/about/stats.php" target="_blank" rel="noopener">info page</a>.';

$helptxt['field_reg_require'] = 'If this field is required during registration, it will also be required on profile changes.';

$helptxt['translatable_fields'] = 'If you wish to provide multi-language support for your custom profile fields you can use translatable tokens on both the name and description fields.<br><br>
Anything enclosed with braces <span class="monospace">{}</span> will be considered as a token and will be matched against a $txt string. For example, the token <span class="monospace">{gender}</span> will be replaced by the value of $txt[\'gender\']<br><br>
It is <strong>very important</strong> to add the matched $txt string to <strong>ALL</strong> currently installed languages. To do this, go to the <a href="%1$s?action=admin;area=languages;sa=edit;%3$s=%2$s" class="bbc_link" target="_blank" rel="noopener">Edit Languages</a> page and complete the following steps for each installed language:
<ol class="bbc_list" style="list-style-type: decimal">
	<li>Click the "Edit" button next to the language name.</li>
	<li>In the "Select entries to edit" menu, choose "Modifications".</li>
	<li>Scroll to bottom and click the "Add Another Item" button.</li>
	<li>Follow the prompts to add your new string.</li>
</ol>';

// argument(s): $boarddir, $boardurl
$helptxt['cron_is_real_cron'] = 'By default, SMF adds to every page a small bit of JavaScript that prompts the user\'s browser to trigger SMF\'s cron.php in the background. This approach allows SMF to execute its scheduled tasks on a regular basis without requiring the admin to do any extra server configuration. However, some admins might prefer to configure their servers to directly execute cron.php on a regular basis. If you have done this, you can disable the JavaScript method.<br><br><strong>Note:</strong> Configuring your server to run scheduled tasks this way cannot be done from within SMF. You will need to use your server configuration software to do so. Typical tools for this purpose include <code>cron</code> (for Linux servers), <code>schtasks.exe</code> (for Windows servers), and <code>launchd</code> (for macOS servers). Most web hosting companies provide some sort of control panel interface to allow their customers to access these tools.<br><br>The path and URL for your forum\'s cron.php are:<br>Path: %1$s/cron.php<br>URL: %2$s/cron.php';

$helptxt['languages_txt'] = 'These language entries are used throughout SMF to define localized versions of text for different languages.<br><br>If you see a value like <code>&#37;1$s</code> in an entry, it is a placeholder that SMF fills in with a real value at runtime. Make sure to keep such placeholders in your customized text.';
$helptxt['languages_helptxt'] = 'These language entries are used to show floating help text popups (like this one).';
$helptxt['languages_editortxt'] = 'These language entries are used for user interface elements in the post editor.';
$helptxt['languages_tztxt'] = 'These language entries are used to build descriptions for time zones.<br><br>For example, the <code>Europe_Western</code> string may be combined with the <code>daylight_saving_time_false</code> string to produce "Western European Standard Time".<br><br>Note: If no description is provided for a given time zone, SMF will generate a description using a list of locations within that time zone.';
$helptxt['languages_txt_for_timezones'] = 'These language entries allow you to do the following:<br><ol class="bbc_list" style="list-style-type: decimal;"><li>Edit the names shown for individual locations anywhere they might be used in a context related to time zones. For example, you can tell SMF to show "Qaanaaq" for the location "America/Thule" instead of "Thule".</li><li>Edit the names shown for different countries. This can be done by editing the relevant <code>iso3166[]</code> string.</li></ol>';
$helptxt['languages_txt_for_email_templates'] = 'These language entries are used to create the email messages that SMF sends to your members.';
$helptxt['languages_native_name'] = 'The language\'s name for itself, represented in its own script.';
$helptxt['languages_character_set'] = 'The character encoding used for this language. As of SMF 2.1, this should always be "UTF-8".';
$helptxt['languages_locale'] = 'The locale code is used to determine various formatting conventions, etc.<br><br>The locale code typically takes the form of a two character language code, optionally followed by an underscore and a two character country code. For example, <code>en</code> would identify generic English, while <code>en_AU</code> would identify Australian English in particular.';
$helptxt['languages_rtl'] = 'Enter a "1" here if this language reads from right to left (e.g. Hebrew, Arabic).  Leave it "0" for left to right languages.';
$helptxt['languages_dictionary'] = 'This defines the main language dictionary that will be used by the <a href="https://php.net/function.pspell-new" target="_blank" rel="noopener">pSpell</a> spellchecker (if installed).';
$helptxt['languages_recaptcha'] = 'The language code to use for the reCAPTCHA verification widget.<br><br>See Google\'s reCAPTCHA documentation for its <a href="https://developers.google.com/recaptcha/docs/language" target="_blank" rel="noopener" class="bbc_link">list of supported languages</a>.';
// The GDPR page of the EU exists in several languages; change the language code at the end of the url
$helptxt['requireAgreement'] = 'This setting is recommended to be enabled in order to comply with the rules of the <a href="https://ec.europa.eu/info/law/law-topic/data-protection/eu-data-protection-rules_en" target="_blank" rel="noopener" class="bbc_link">GDPR</a>.';
// The GDPR page of the EU exists in several languages; change the language code at the end of the url
$helptxt['requirePolicyAgreement'] = 'This setting is recommended to be enabled in order to comply with the rules of the <a href="https://ec.europa.eu/info/law/law-topic/data-protection/eu-data-protection-rules_en" target="_blank" rel="noopener" class="bbc_link">GDPR</a>.';
$helptxt['gravatar'] = 'Gravatar is Globally Recognized Avatars. Register an account at <a href="https://www.gravatar.com" target="_blank" rel="noopener">https://www.gravatar.com</a> to select an avatar image. This avatar is then available at every site that supports gravatars. If you don\'t have a gravatar account, a default image will be used.';

?>