<?php
// Version: 2.1.0; EmailTemplates

// Since all of these strings are being used in emails, numeric entities should be used.

// Do not translate anything that is between {}, they are used as replacement variables and MUST remain exactly how they are.
//   Additionally, do not translate the @additional_params: line or the variable names in the lines that follow it. You may
//   translate the description of the variable. Do not translate @description:, however you may translate the rest of that line.

// Do not use block comments in this file, they will have special meaning.

global $txtBirthdayEmails;

/**
	@additional_params: resend_activate_message
		REALNAME: The display name for the member receiving the email.
		USERNAME:  The user name for the member receiving the email.
		ACTIVATIONLINK:  The URL link to activate the member's account.
		ACTIVATIONCODE:  The code needed to activate the member's account.
		ACTIVATIONLINKWITHOUTCODE: The URL to the page where the activation code can be entered.
		FORGOTPASSWORDLINK: The URL to the "forgot password" page.
	@description:
*/
$txt['resend_activate_message_subject'] = 'Velkommen til {FORUMNAME} ';
$txt['resend_activate_message_body'] = 'Du er nå registrert som medlem på {FORUMNAME}. Brukernavnet ditt er {USERNAME}. Dersom du glemmer passordet, kan du tilbakestille det ved å gå til {FORGOTPASSWORDLINK}. Før du kan logge inn må du aktivere ditt medlemskap. For å gjøre dette, vennligst følg denne lenken: {ACTIVATIONLINK} Skulle du få problemer med aktiveringen, kan du gå til {ACTIVATIONLINKWITHOUTCODE} og tast inn koden "{ACTIVATIONCODE}". {REGARDS} ';

/**
	@additional_params: resend_pending_message
		REALNAME: The display name for the member receiving the email.
		USERNAME:  The user name for the member receiving the email.
	@description:
*/
$txt['resend_pending_message_subject'] = 'Velkommen til {FORUMNAME} ';
$txt['resend_pending_message_body'] = 'Hei{REALNAME}, Din forespørsel om å bli medlem på {FORUMNAME} er mottatt. Brukernavnet du registrerte deg med var {USERNAME}. Før du kan logge inn og begynne å bruke forumet, vil din forespørsel sjekkes og godkjennes manuelt. Når dette skjer vil du motta en ny e-post fra denne adressen. {REGARDS} ';

/**
	@additional_params: mc_group_approve
		USERNAME: The user name for the member receiving the email.
		GROUPNAME: The name of the membergroup that the user was accepted into.
	@description: The request to join a particular membergroup has been accepted.
*/
$txt['mc_group_approve_subject'] = 'Gruppemedlemskap godkjent';
$txt['mc_group_approve_body'] = '{USERNAME}, Din forespørsel om å delta i gruppen "{GROUPNAME}" på {FORUMNAME} har blitt akseptert, og din konto har blitt oppdatert til å inkludere denne nye gruppen. {REGARDS} ';

/**
	@additional_params: mc_group_reject
		USERNAME: The user name for the member receiving the email.
		GROUPNAME: The name of the membergroup that the user was rejected from.
	@description: The request to join a particular membergroup has been rejected.
*/
$txt['mc_group_reject_subject'] = 'Gruppemedlemskap avvist';
$txt['mc_group_reject_body'] = '{USERNAME}, Din forespørsel om å delta i gruppen "{GROUPNAME}" på {FORUMNAME} har blitt avvist. {REGARDS} ';

/**
	@additional_params: mc_group_reject_reason
		USERNAME: The user name for the member receiving the email.
		GROUPNAME: The name of the membergroup that the user was rejected from.
		REASON: Reason for the rejection.
	@description: The request to join a particular membergroup has been rejected with a reason given.
*/
$txt['mc_group_reject_reason_subject'] = 'Gruppemedlemskap avvist';
$txt['mc_group_reject_reason_body'] = '{USERNAME}, Din forespørsel om å delta i gruppen "{GROUPNAME}" på {FORUMNAME} har blitt avvist. Dette skyldes følgende grunn: {REASON} {REGARDS} ';

/**
	@additional_params: admin_approve_accept
		NAME: The display name of the member.
		USERNAME: The user name for the member receiving the email.
		PROFILELINK: The URL of the profile page.
		FORGOTPASSWORDLINK: The URL of the "forgot password" page.
	@description:
*/
$txt['admin_approve_accept_subject'] = 'Velkommen til {FORUMNAME}';
$txt['admin_approve_accept_body'] = 'Velkommen, {NAME} Din medlemskonto er blitt aktivert manuelt av administrator. Du kan nå logge inn og skrive innlegg. Brukernavnet ditt er: {USERNAME}. Dersom du glemmer passordet, kan du tilbakestille det ved å gå til {FORGOTPASSWORDLINK}. {REGARDS} ';

/**
	@additional_params: admin_approve_activation
		USERNAME: The user name for the member receiving the email.
		ACTIVATIONLINK:  The URL link to activate the member's account.
		ACTIVATIONLINKWITHOUTCODE: The URL to the page where the activation code can be entered.
		ACTIVATIONCODE: The activation code.
	@description:
*/
$txt['admin_approve_activation_subject'] = 'Velkommen til {FORUMNAME}';
$txt['admin_approve_activation_body'] = 'Velkommen, {USERNAME}! Din medlemskonto på {FORUMNAME} er blitt godkjent av administrator på forumet. Før du kan logge inn, må du aktivere kontoen ved å klikke på følgende lenke: {ACTIVATIONLINK} Skulle du få problemer med aktiveringen, kan du gå til {ACTIVATIONLINKWITHOUTCODE} og tast inn koden "{ACTIVATIONCODE}". {REGARDS} ';

/**
	@additional_params: admin_approve_reject
		USERNAME: The user name for the member receiving the email.
	@description:
*/
$txt['admin_approve_reject_subject'] = 'Registrering avvist';
$txt['admin_approve_reject_body'] = '{USERNAME}, Din forespørsel om medlemskap på {FORUMNAME} er blitt avvist. {REGARDS} ';

/**
	@additional_params: admin_approve_delete
		USERNAME: The user name for the member receiving the email.
	@description:
*/
$txt['admin_approve_delete_subject'] = 'Konto slettet';
$txt['admin_approve_delete_body'] = '{USERNAME}, Din medlemskonto på {FORUMNAME} har blitt slettet. Dette kan være fordi du aldri har aktivert kontoen din, i så fall kan du registrere deg på nytt. {REGARDS} ';

/**
	@additional_params: admin_approve_remind
		USERNAME: The user name for the member receiving the email.
		ACTIVATIONLINK:  The URL link to activate the member's account.
		ACTIVATIONLINKWITHOUTCODE: The URL to the page where the activation code can be entered.
		ACTIVATIONCODE: The activation code.
	@description:
*/
$txt['admin_approve_remind_subject'] = 'Påminnelse om registrering';
$txt['admin_approve_remind_body'] = '{USERNAME}, Du har fremdeles ikke aktivert din medlemskonto på {FORUMNAME}. Vennligst klikk på lenken nedenfor for å aktivere medlemskontoen: {ACTIVATIONLINK} Skulle du få problemer med aktiveringen, kan du gå til {ACTIVATIONLINKWITHOUTCODE} og tast inn koden "{ACTIVATIONCODE}". {REGARDS} ';

/**
	@additional_params:
		USERNAME: The user name for the member receiving the email.
		ACTIVATIONLINK:  The URL link to activate the member's account.
		ACTIVATIONLINKWITHOUTCODE: The URL to the page where the activation code can be entered.
		ACTIVATIONCODE: The activation code.
	@description:
*/
$txt['admin_register_activate_subject'] = 'Velkommen til {FORUMNAME}';
$txt['admin_register_activate_body'] = 'Takk for at du har registrert deg på {FORUMNAME}. Ditt brukernavn er {USERNAME} og passordet ditt er: {PASSWORD}. Før du kan logge inn, må du aktivere kontoen ved å klikke på følgende lenke: {ACTIVATIONLINK} Skulle du få problemer med aktiveringen, kan du gå til {ACTIVATIONLINKWITHOUTCODE} og tast inn koden "{ACTIVATIONCODE}". {REGARDS} ';

$txt['admin_register_immediate_subject'] = 'Velkommen til {FORUMNAME}';
$txt['admin_register_immediate_body'] = 'Takk for at du har registrert deg på {FORUMNAME}. Ditt brukernavn er: {USERNAME}, passordet ditt er: {PASSWORD}, og forum URL er:{SCRIPTURL}. {REGARDS} ';

/**
	@additional_params: new_announcement
		TOPICSUBJECT: The subject of the topic being announced.
		MESSAGE: The message body of the first post of the announced topic.
		TOPICLINK: A link to the topic being announced.
		UNSUBSCRIBELINK: Link to unsubscribe from announcements.
	@description:
*/
$txt['new_announcement_subject'] = 'Nytt emne: {TOPICSUBJECT}';
$txt['new_announcement_body'] = '{MESSAGE} Hvis du ikke ønsker å motta slike kunngjøringer, logg inn på forumet og fjern avkryssingen ved "Motta kunngjøringer og viktige meldinger på e-post." i din profil. Du kan lese hele kunngjøringen ved å følge denne lenken: {TOPICLINK} {REGARDS} ';

/**
	@additional_params: notify_boards_once_body
		TOPICSUBJECT: The subject of the topic causing the notification
		TOPICLINK: A link to the topic.
		MESSAGE: This is the body of the message.
		UNSUBSCRIBELINK: Link to unsubscribe from notifications.
	@description:
*/
$txt['notify_boards_once_body_subject'] = 'Nytt emne: {TOPICSUBJECT}';
$txt['notify_boards_once_body_body'] = 'Et nytt innlegg, \'{TOPICSUBJECT}\', er kommet i en seksjon du har på din varslingsliste. Du kan se det på {TOPICLINK} Flere emner kan bli lagt inn, men du vil ikke motta flere e-postvarslinger før du har lest innlegget. Teksten i emnet er gjengitt nedenfor: {MESSAGE} Avslutt varsling av nye emner fra dette forumet ved å klikke på denne lenken: {UNSUBSCRIBELINK} {REGARDS} ';

/**
	@additional_params: notify_boards_once
		TOPICSUBJECT: The subject of the topic causing the notification
		TOPICLINK: A link to the topic.
		UNSUBSCRIBELINK: Link to unsubscribe from notifications.
	@description:
*/
$txt['notify_boards_once_subject'] = 'Nytt emne: {TOPICSUBJECT} ';
$txt['notify_boards_once_body'] = 'Et nytt innlegg, \'{TOPICSUBJECT}\', er kommet i en seksjon du har på din varslingsliste. Du kan se det på {TOPICLINK} Flere emner kan bli lagt inn, men du vil ikke motta flere e-postvarslinger før du har lest innlegget. Teksten i emnet er vist nedenfor. Avslutt varsling av nye emner fra dette forumet ved å klikke på denne lenken: {UNSUBSCRIBELINK} {REGARDS} ';

/**
	@additional_params: notify_boards_body
		TOPICSUBJECT: The subject of the topic causing the notification
		TOPICLINK: A link to the topic.
		MESSAGE: This is the body of the message.
		UNSUBSCRIBELINK: Link to unsubscribe from notifications.
	@description:
*/
$txt['notify_boards_body_subject'] = 'Nytt emne: {TOPICSUBJECT} ';
$txt['notify_boards_body_body'] = 'Et nytt innlegg, \'{TOPICSUBJECT}\', er kommet i en seksjon du har på din varslingsliste. Du kan se det påt {TOPICLINK} Teksten i emnet er gjengitt nedenfor: {MESSAGE} Avslutt varsling av nye emner fra dette forumet ved å klikke på denne lenken: {UNSUBSCRIBELINK} {REGARDS} ';

/**
	@additional_params: notify_boards
		TOPICSUBJECT: The subject of the topic causing the notification
		TOPICLINK: A link to the topic.
		UNSUBSCRIBELINK: Link to unsubscribe from notifications.
	@description:
*/
$txt['notify_boards_subject'] = 'Nytt emne: {TOPICSUBJECT} ';
$txt['notify_boards_body'] = 'Et nytt innlegg, \'{TOPICSUBJECT}\', er kommet i en seksjon du har på din varslingsliste. Du kan se det på {TOPICLINK} Avslutt varsling av nye emner fra dette forumet ved å klikke på denne lenken: {UNSUBSCRIBELINK} {REGARDS} ';

/**
	@additional_params: alert_unapproved_reply
		SUBJECT: The subject of the topic causing the notification
		LINK: A link to the topic.
	@description:
*/
$txt['alert_unapproved_reply_subject'] = 'Emnesvar: {SUBJECT}';
$txt['alert_unapproved_reply_body'] = 'Et svar har blitt postet i emne \'{SUBJECT}\' fra {POSTERNAME}. 
Du kan lese det på {LINK} {REGARDS}';

/**
	@additional_params: unapproved_attachment
		SUBJECT: The subject of the topic causing the notification
		LINK: A link to the message with the attachment.
	@description:
*/
$txt['unapproved_attachment_subject'] = 'Nytt vedlegg må godkjennes i : {SUBJECT}';
$txt['unapproved_attachment_body'] = 'Et nytt vedlegg har blitt opprettet i \'{SUBJECT}\' som må godkjennes
Du kan godkjenne eller avvise vedlegget fra lenken nedenfor, som vil ta deg til meldingen vedlegget er en del av:
{LINK} 

{REGARDS}';

/**
	@additional_params: alert_unapproved_post
		SUBJECT: The subject of the topic causing the notification
		LINK: A link to the topic.
	@description:
*/
$txt['alert_unapproved_post_subject'] = 'Nytt innlegg for godkjenning: {SUBJECT}';
$txt['alert_unapproved_post_body'] = 'Et nytt innlegg er opprettet som må godkjennes : \'{SUBJECT}\' 
Du kan godkjenne eller avvise innlegget ved å gå til lenken nedenfor:
{LINK} 

{REGARDS}';

/**
	@additional_params: alert_unapproved_topic
		SUBJECT: The subject of the topic causing the notification
		LINK: A link to the topic.
	@description:
*/
$txt['alert_unapproved_topic_subject'] = 'Nytt emne for godkjenning: {SUBJECT}';
$txt['alert_unapproved_topic_body'] = 'Et nytt emne har blitt opprettet som må godkjenes: \'{SUBJECT}\' 
Du kan godkjenne eller avvise temaet ved å bruke lenken nedenfor: 
{LINK} 

{REGARDS}';

/**
	@additional_params: request_membership
		RECPNAME: The name of the person receiving the email
		APPLYNAME: The name of the person applying for group membership
		GROUPNAME: The name of the group being applied to.
		REASON: The reason given by the applicant for wanting to join the group.
		MODLINK: Link to the group moderation page.
	@description:
*/
$txt['request_membership_subject'] = 'Medlemskap i ny gruppe?';
$txt['request_membership_body'] = '{RECPNAME}, {APPYNAME} har bedt om medlemskap i gruppen "{GROUPNAME}". Brukeren har gitt følgende grunn: {REASON} Du kan godkjenne eller avvise denne søknaden ved å klikke på lenken nedenfor: {MODLINK} {REGARDS}';

/**
	@additional_params: paid_subscription
		REALNAME: The real (display) name of the person receiving the email.
		PROFILE_LINK: Link to profile of member receiving email where can renew.
		SUBSCRIPTION: Name of the subscription.
		END_DATE: Date it expires.
	@description:
*/
$txt['paid_subscription_reminder_subject'] = 'Abonnement i ferd med å utløpe på {FORUMNAME} ';
$txt['paid_subscription_reminder_body'] = '{REALNAME}, 

Ditt abbonnement på {FORUMNAME} er i ferd med å utløpe. Dersom du tidligere valgte automatisk fornyelse trenger du ikke gjør noe - ellers kan du vurdere å abonnere igjen. Detaljer er vist under:

Abonnement navn: {SUBSCRIPTION} 
Utløper: {END_DATE} 

Om du vil redigere dine abonnement gå til nettadressen: 
{PROFILE_LINK} 

{REGARDS}';

/**
	@additional_params: activate_reactivate
		ACTIVATIONLINK:  The URL link to reactivate the member's account.
		ACTIVATIONCODE:  The code needed to reactivate the member's account.
		ACTIVATIONLINKWITHOUTCODE: The URL to the page where the activation code can be entered.
	@description:
*/
$txt['activate_reactivate_subject'] = 'Velkommen tilbake til {FORUMNAME} ';
$txt['activate_reactivate_body'] = 'For å godkjenne din e-postadresse på nytt, har din konto blitt deaktivert. Klikk følgende lenke for å aktivere den igjen: {ACTIVATIONLINK} Skulle du få problemer med aktiveringen, kan du gå til {ACTIVATIONLINKWITHOUTCODE} og tast inn koden "{ACTIVATIONCODE}". {REGARDS} ';

/**
	@additional_params: forgot_password
		REALNAME: The real (display) name of the person receiving the reminder.
		REMINDLINK: The link to reset the password.
		IP: The IP address of the requester.
		MEMBERNAME:
	@description:
*/
$txt['forgot_password_subject'] = 'Nytt passord på {FORUMNAME} ';
$txt['forgot_password_body'] = 'Hei {REALNAME}, Denne e-posten ble sendt fordi funksjonen \'Glemt passordet\' ble benyttet for din medlemskonto. For å endre passord, klikk på denne lenken: {REMINDLINK} IP: {IP} Brukernavn: {MEMBERNAME} {REGARDS} ';

/**
	@additional_params: send_email
		EMAILSUBJECT: The subject the user wants to email.
		EMAILBODY: The body the user wants to email.
		SENDERNAME: The name of the member sending the email.
		RECPNAME: The name of the person receiving the email.
	@description:
*/
$txt['send_email_subject'] = '{EMAILSUBJECT} ';
$txt['send_email_body'] = '{EMAILBODY}';

/**
	@additional_params: report_to_moderator
		TOPICSUBJECT: The subject of the reported post.
		POSTERNAME: The reported post's author's name.
		REPORTERNAME: The name of the person reporting the post.
		TOPICLINK: The URL of the post that is being reported.
		REPORTLINK: The URL of the moderation center report.
		COMMENT: The comment left by the reporter, hopefully to explain why they are reporting the post.
	@description: When a user reports a post this email is sent out to moderators and admins of that board.
*/
$txt['report_to_moderator_subject'] = 'Rapportert innlegg: {TOPICSUBJECT} av {POSTERNAME} ';
$txt['report_to_moderator_body'] = 'Følgende innlegg, "{TOPICSUBJECT}" av {POSTERNAME} har blitt rapportert av {REPORTERNAME} på et forum hvor du er modererator: Emnet: {TOPICLINK} Modereringssenter: {REPORTLINK} Reporteren har gjort følgende kommentar: {COMMENT} {REGARDS} ';

/**
	@additional_params: report_to_moderator
		TOPICSUBJECT: The subject of the reported post.
		POSTERNAME: The reported post's author's name.
		COMMENTERNAME: The name of the person who replied to the report.
		TOPICLINK: The URL of the post that is being reported.
		REPORTLINK: The URL of the moderation center report.
	@description: When a moderator replies to a moderation report, this can be sent to the other moderators who previously replied.
*/
$txt['reply_to_moderator_subject'] = 'Oppfølging til rapportert innlegget: {TOPICSUBJECT} av {POSTERNAME} ';
$txt['reply_to_moderator_body'] = 'Tidligere, "{TOPICSUBJECT}" ble rapportert til moderatorene. Siden da, {COMMENTERNAME} har lagt en kommentar til rapporten. Mer informasjon finner du i forumet. Emne: {TOPICLINK} Moderasjonsenter: {REPORTLINK} {REGARDS} ';

/**
	@additional_params: report_user_profile
		MEMBERNAME: The display name of the reported user
		REPORTERNAME: The name of the person reporting the profile
		PROFILELINK: The link to the profile that was reported
		COMMENT: The comment left by the reporter.
 	@description: When a user's profile is reported
*/
$txt['report_member_profile_subject'] = 'Rapportert profil: {MEMBERNAME}';
$txt['report_member_profile_body'] = 'Profilen til "{MEMBERNAME}" har blitt rapportert av {REPORTERNAME}. Profilen: {PROFILELINK} Moderasjonssenter: {REPORTLINK} Følgende kommentar er gjort: {COMMENT} {REGARDS} ';

/**
	@additional_params: report_user_profile
		MEMBERNAME: The display name of the reported user
		COMMENTERNAME: The name of the person who added the comment
		PROFILELINK: The link to the profile that was reported
 	@description: When someone replies to a report about a profile, this can be sent to others who replied
*/
$txt['reply_to_member_report_subject'] = 'Oppfølging av rapportert profil: {MEMBERNAME} ';
$txt['reply_to_member_report_body'] = 'Tidligere ble profilen til {MEMBERNAME} rapportert. Siden da har, {COMMENTERNAME} lagt til en kommentar til rapporten. Mer informasjon finner du i forumet. Profilen: {PROFILELINK} Moderasjonssenter: {REPORTLINK} {REGARDS} ';

/**
	@additional_params: change_password
		USERNAME: The user name for the member receiving the email.
		PASSWORD: The password for the member.
	@description:
*/
$txt['change_password_subject'] = 'Nytt passord';
$txt['change_password_body'] = 'Hei, {USERNAME} Dine innloggingsdata på {FORUMNAME} er forandret og ditt passord er blitt endret. Nedenfor er dine nye innloggingsdata. Brukernavnet ditt er "{USERNAME}" og passordet ditt er "{PASSWORD}". Du må gjerne endre det etter at du er logget inn ved å gå til profilen din, eller ved å gå til denne siden når du er innlogget: {SCRIPTURL}?action=profile {REGARDS} ';

/**
	@additional_params: register_activate
		REALNAME: The display name for the member receiving the email.
		USERNAME: The user name for the member receiving the email.
		PASSWORD: The password for the member.
		ACTIVATIONLINK:  The URL link to reactivate the member's account.
		ACTIVATIONLINKWITHOUTCODE: The URL to the page where the activation code can be entered.
		ACTIVATIONCODE:  The code needed to reactivate the member's account.
		FORGOTPASSWORDLINK: The URL to the "forgot password" page.
	@description:
*/
$txt['register_activate_subject'] = 'Velkommen til {FORUMNAME}';
$txt['register_activate_body'] = 'Du er nå registrert som bruker på {FORUMNAME}. Brukernavnet ditt er {USERNAME}. Hvis du har glemt passordet, kan du tilbakestille det ved å gå til {FORGOTPASSWORDLINK}. Før du kan logge inn må du aktivere ditt medlemskap. For å gjøre dette, vennligst følg denne lenken: {ACTIVATIONLINK} Skulle du få problemer med aktiveringen, kan du gå til {ACTIVATIONLINKWITHOUTCODE} og tast inn koden "{ACTIVATIONCODE}". {REGARDS}';

/**
	@additional_params: register_coppa
		REALNAME: The display name for the member receiving the email.
		USERNAME: The user name for the member receiving the email.
		PASSWORD: The password for the member.
		COPPALINK:  The URL link to the coppa form.
		FORGOTPASSWORDLINK: The URL to the "forgot password" page.
	@description:
*/
$txt['register_coppa_subject'] = 'Velkommen til {FORUMNAME}';
$txt['register_coppa_body'] = 'Du er nå registrert som bruker på {FORUMNAME}. Brukernavnet ditt er {USERNAME}. Hvis du har glemt passordet, kan du tilbakestille det ved å gå til {FORGOTPASSWORDLINK} Før du kan logge inn, kreves tillatelse fra dine foreldre/foresatte. Du kan få mer informasjon på lenken nedenfor: {COPPALINK} {REGARDS} ';

/**
	@additional_params: register_immediate
		REALNAME: The display name for the member receiving the email.
		USERNAME: The user name for the member receiving the email.
		PASSWORD: The password for the member.
		FORGOTPASSWORDLINK: The URL to the "forgot password" page.
	@description:
*/
$txt['register_immediate_subject'] = 'Velkommen til {FORUMNAME}';
$txt['register_immediate_body'] = 'Du er nå registrert som bruker på {FORUMNAME}. Brukernavnet ditt er {USERNAME}. Dersom du har glemt passordet, kan du tilbakestille det ved å gå til {FORGOTPASSWORDLINK}. {REGARDS} ';

/**
	@additional_params: register_pending
		REALNAME: The display name for the member receiving the email.
		USERNAME: The user name for the member receiving the email.
		PASSWORD: The password for the member.
		FORGOTPASSWORDLINK: The URL to the "forgot password" page.
	@description:
*/
$txt['register_pending_subject'] = 'Velkommen til {FORUMNAME}';
$txt['register_pending_body'] = 'Hei {REALNAME}, din registreringsforespørsel på {FORUMNAME} er mottatt. Brukernavnet du registrerte deg med er {USERNAME}. Dersom du har glemt passordet, kan du endre det på {FORGOTPASSWORDLINK}.  Før du kan logge inn og begynne å bruke forumet, vil din forespørsel sjekkes og godkjennes manuelt.  Når dette er gjort vil du motta en ny e-post fra denne adressen. {REGARDS} ';

/**
	@additional_params: notification_reply
		TOPICSUBJECT:
		POSTERNAME:
		TOPICLINK:
		UNSUBSCRIBELINK:
	@description:
*/
$txt['notification_reply_subject'] = 'Svar på emne: {TOPICSUBJECT}';
$txt['notification_reply_body'] = 'Et emne du overvåker har fått et nytt innlegg , skrevet av {POSTERNAME}. Se innlegget her: {TOPICLINK} Stopp varsling til dette emnet ved å bruke lenken: {UNSUBSCRIBELINK} {REGARDS} ';

/**
	@additional_params: notification_reply_body
		TOPICSUBJECT:
		POSTERNAME:
		TOPICLINK:
		UNSUBSCRIBELINK:
		MESSAGE:
	@description:
*/
$txt['notification_reply_body_subject'] = 'Svar på emne: {TOPICSUBJECT} ';
$txt['notification_reply_body_body'] = 'Et emne du overvåker har fått et nytt innlegg , skrevet av {POSTERNAME}. Se innlegget her: {TOPICLINK} Stopp varsling til dette emnet ved å bruke lenken: {UNSUBSCRIBELINK} Teksten i svaret er gjengitt nedenfor: {MESSAGE} {REGARDS} ';

/**
	@additional_params: notification_reply_once
		TOPICSUBJECT:
		POSTERNAME:
		TOPICLINK:
		UNSUBSCRIBELINK:
	@description:
*/
$txt['notification_reply_once_subject'] = 'Svar på emne: {TOPICSUBJECT} ';
$txt['notification_reply_once_body'] = 'Et emne du overvåker har fått et nytt innlegg , skrevet av {POSTERNAME}. Se innlegget her: {TOPICLINK} Stopp varsling til dette emnet ved å bruke lenken: {UNSUBSCRIBELINK} Flere svar kan komme, men du vil ikke få varsling om flere svar før du har lest emnet. {REGARDS} ';

/**
	@additional_params: notification_reply_body_once
		TOPICSUBJECT:
		POSTERNAME:
		TOPICLINK:
		UNSUBSCRIBELINK:
		MESSAGE:
	@description:
*/
$txt['notification_reply_body_once_subject'] = 'Svar på emne: {TOPICSUBJECT} ';
$txt['notification_reply_body_once_body'] = 'Et emne du overvåker har fått et nytt innlegg , skrevet av {POSTERNAME}. Se innlegget her: {TOPICLINK} Stopp varsling til dette emnet ved å bruke lenken: {UNSUBSCRIBELINK} Teksten i svaret er gjengitt nedenfor: {MESSAGE} Flere svar kan komme, men du vil ikke få varsling om flere svar før du har lest emnet. {REGARDS} ';

/**
	@additional_params: notification_sticky
	@description:
*/
$txt['notification_sticky_subject'] = 'Emne satt som prioritert: {TOPICSUBJECT}';
$txt['notification_sticky_body'] = 'Et emne du overvåker er blitt satt som festet emne (prioritert) av {POSTERNAME}. Se emnet her: {TOPICLINK} Stopp varsling om dette emnet ved å bruke lenken: {UNSUBSCRIBELINK} {REGARDS} ';

/**
	@additional_params: notification_lock
	@description:
*/
$txt['notification_lock_subject'] = 'Emne stengt: {TOPICSUBJECT} ';
$txt['notification_lock_body'] = 'Et emne du overvåker er blitt stengt av {POSTERNAME}. Se emnet her: {TOPICLINK} Stopp varsling om dette emnet ved å bruke lenken: {UNSUBSCRIBELINK} {REGARDS} ';

/**
	@additional_params: notification_unlock
	@description:
*/
$txt['notification_unlock_subject'] = 'Emne åpnet: {TOPICSUBJECT} ';
$txt['notification_unlock_body'] = 'Et emne du overvåker er blitt åpnet av {POSTERNAME}. Se emnet her: {TOPICLINK} Stopp varsling om dette emnet ved å bruke lenken: {UNSUBSCRIBELINK} {REGARDS} ';

/**
	@additional_params: notification_remove
	@description:
*/
$txt['notification_remove_subject'] = 'Emne fjernet: {TOPICSUBJECT} ';
$txt['notification_remove_body'] = 'Et emne du overvåker er blitt fjernet av {POSTERNAME}. {REGARDS} ';

/**
	@additional_params: notification_move
	@description:
*/
$txt['notification_move_subject'] = 'Emne flyttet: {TOPICSUBJECT} ';
$txt['notification_move_body'] = 'Et emne du overvåker er blitt flyttet til en annet forum. Se emnet her: {TOPICLINK} Stopp varsling om dette emnet ved å bruke lenken: {UNSUBSCRIBELINK} {REGARDS} ';

/**
	@additional_params: notification_merged
	@description:
*/
$txt['notification_merge_subject'] = 'Emne slått sammen: {TOPICSUBJECT} ';
$txt['notification_merge_body'] = 'Et emne du overvåker er slått sammen med et annet emne. Se det nye sammenslåtte emnet her: {TOPICLINK} Stopp varsling om dette emnet ved å bruke lenken: {UNSUBSCRIBELINK} {REGARDS} ';

/**
	@additional_params: notification_split
	@description:
*/
$txt['notification_split_subject'] = 'Emne delt opp: {TOPICSUBJECT}';
$txt['notification_split_body'] = 'Et emne du overvåker er blitt delt opp i 2 eller flere nye emner. Se det gjenstående emnet her: {TOPICLINK} Stopp varsling om dette emnet ved å bruke lenken: {UNSUBSCRIBELINK} {REGARDS} ';

/**
	@additional_params: admin_notify
		USERNAME:
		PROFILELINK:
	@description:
*/
$txt['admin_notify_subject'] = 'Et nytt medlem har registrert seg';
$txt['admin_notify_body'] = '{USERNAME} har akkurat registrert seg som et nytt medlem på ditt forum. Klikk lenken nedenunder for å se profilen til dette medlemmet. {PROFILELINK} {REGARDS} ';

/**
	@additional_params: admin_notify_approval
		USERNAME:
		PROFILELINK:
		APPROVALLINK:
	@description:
*/
$txt['admin_notify_approval_subject'] = 'Et nytt medlem har registrert seg';
$txt['admin_notify_approval_body'] = '{USERNAME} har akkurat registrert seg som et nytt medlem på ditt forum. Klikk linken nedenunder for å se profilen til dette medlemmet. {PROFILELINK} Før dette medlemmet kan starte å skrive innlegg, må medlemmets konto være godkjent. Klikk linken nedenunder for å gå til godkjenning av medlemmer. {APPROVALLINK} {REGARDS}';

/**
	@additional_params: admin_attachments_full
		REALNAME:
	@description:
*/
$txt['admin_attachments_full_subject'] = 'Haster! Vedleggsmappen er nesten full';
$txt['admin_attachments_full_body'] = '{REALNAME}, Vedleggsmappen på {FORUMNAME} er nesten full. Gå til forumet for å løse dette problemet. Når vedleggsmappen er full vil ikke brukerne kunne fortsette å legge til vedlegg eller laste opp egne avatarer (Dersom aktivert). {REGARDS} ';

/**
	@additional_params: paid_subscription_refund
		NAME: Subscription title.
		REALNAME: Recipients name
		REFUNDUSER: Username who took out the subscription.
		REFUNDNAME: User's display name who took out the subscription.
		DATE: Today's date.
		PROFILELINK: Link to members profile.
	@description:
*/
$txt['paid_subscription_refund_subject'] = 'Refundert betalt abonnement';
$txt['paid_subscription_refund_body'] = '{REALNAME}, Et medlem har mottatt en refusjon på et betalt abonnement. Nedenfor er detaljene i dette abonnement: Abonnement: {NAME} Brukernavn: {REFUNDNAME} ({REFUNDUSER}) Dato: {DATE} Du kan se dette medlemmets profil ved å klikke på lenken nedenfor: {PROFILELINK} {REGARDS} ';

/**
	@additional_params: paid_subscription_new
		NAME: Subscription title.
		REALNAME: Recipients name
		SUBEMAIL: Email address of the user who took out the subscription
		SUBUSER: Username who took out the subscription.
		SUBNAME: User's display name who took out the subscription.
		DATE: Today's date.
		PROFILELINK: Link to members profile.
	@description:
*/
$txt['paid_subscription_new_subject'] = 'Nytt betalt abonnement';
$txt['paid_subscription_new_body'] = '{REALNAME}, Et medlem har kjøpt ett nytt abonnement. Nedenfor er detaljene for dette abonnementet: Abonnement: {NAME} Brukernavn: {SUBNAME} ({SUBUSER}) E-postadresse: {SUBEMAIL} Pris: {PRICE} Dato: {DATE} Du kan se dette medlemmets profil ved å klikke på lenken nedenfor: {PROFILELINK} {REGARDS} ';

/**
	@additional_params: paid_subscription_error
		ERROR: Error message.
		REALNAME: Recipients name
	@description:
*/
$txt['paid_subscription_error_subject'] = 'Betalt abonnement, en feil har oppstått';
$txt['paid_subscription_error_body'] = 'Hei, {REALNAME}, Følgende feil oppstod ved behandling av et betalt abonnement --------------------------------------------------------------- {ERROR} {REGARDS} ';

/**
	@additional_params: new_pm
		SUBJECT: The personal message subject.
		SENDER:  The user name for the member sending the personal message.
		READLINK:  The link to directly access the read page.
		REPLYLINK:  The link to directly access the reply page.
	@description: A notification email sent to the receivers of a personal message
*/
$txt['new_pm_subject'] = 'Ny personlig melding: {SUBJECT} ';
$txt['new_pm_body'] = 'Du har nettopp mottatt en personlig melding fra {SENDER} på {FORUMNAME} VIKTIG: Husk, dette er bare et varsel. Ikke svar på denne e-posten. Les denne personlige meldingen her: {READLINK} Svar på denne personlige meldingen her: {REPLYLINK} . {REGARDS}';

/**
	@additional_params: new_pm_body
		SUBJECT: The personal message subject.
		SENDER:  The user name for the member sending the personal message.
		MESSAGE:  The text of the personal message.
		REPLYLINK:  The link to directly access the reply page.
	@description: A notification email sent to the receivers of a personal message
*/
$txt['new_pm_body_subject'] = 'Ny personlig melding: {SUBJECT} ';
$txt['new_pm_body_body'] = ' Du har nettopp mottatt en personlig melding fra {SENDER} på {FORUMNAME} VIKTIG: Husk, dette er bare et varsel. Ikke svar på denne e-posten. Les denne personlige meldingen her: {MESSAGE} Svar på denne personlige meldingen her: {REPLYLINK}  {REGARDS}';

/**
	@additional_params: new_pm_tolist
		SUBJECT: The personal message subject.
		SENDER:  The user name for the member sending the personal message.
		READLINK:  The link to directly access the read page.
		REPLYLINK:  The link to directly access the reply page.
		TOLIST:  The list of users that will receive the personal message.
	@description: A notification email sent to the receivers of a personal message
*/
$txt['new_pm_tolist_subject'] = 'Ny personlig melding: {SUBJECT} ';
$txt['new_pm_tolist_body'] = 'Du og {TOLIST} har nettopp mottatt en personlig melding fra {SENDER} på {FORUMNAME} VIKTIG: Husk, dette er bare et varsel. Ikke svar på denne e-posten. Les denne personlige meldingen her: {READLINK} Svar på denne personlige meldingen (kun til avsender) her: {REPLYLINK} . {REGARDS}';

/**
	@additional_params: new_pm_body_tolist
		SUBJECT: The personal message subject.
		SENDER:  The user name for the member sending the personal message.
		MESSAGE:  The text of the personal message.
		REPLYLINK:  The link to directly access the reply page.
		TOLIST:  The list of users that will receive the personal message.
	@description: A notification email sent to the receivers of a personal message
*/
$txt['new_pm_body_tolist_subject'] = 'Ny personlig melding: {SUBJECT} ';
$txt['new_pm_body_tolist_body'] = 'Du og {TOLIST} har nettopp mottatt en personlig melding fra {SENDER} på {FORUMNAME} VIKTIG: Husk, dette er bare et varsel. Ikke svar på denne e-posten. Meldingen de sendte deg var: {MESSAGE} Svar på denne personlige meldingen (kun til avsender) her: {REPLYLINK} . {REGARDS}';

/**
	@additional_params: msg_quote
		CONTENTSUBJECT: The post subject.
		QUOTENAME:  The user name for the member creating the quote
		MEMBERNAME:  The user name for the member being quoted
		CONTENTLINK:  The post's link
	@description: A notification email sent to the members who've been quoted in a post
 */
$txt['msg_quote_subject'] = 'Du har blitt sitèrt i innlegget:  {CONTENTSUBJECT}';
$txt['msg_quote_body'] = 'Hei {MEMBERNAME}, 

Du har blitt sitert i emnet med tittel "{CONTENTSUBJECT}" av {QUOTENAME}, Du kan lese innlegget her: {CONTENTLINK} 

{REGARDS}';

/**
	@additional_params: msg_mention
		CONTENTSUBJECT: The post subject.
		MENTIONNAME:  The user name for the member creating the mention
		MEMBERNAME:  The user name for the member being mentioned
		CONTENTLINK:  The post's link
	@description: A notification email sent to the members who've been mentioned in a post
 */
$txt['msg_mention_subject'] = 'Du har blitt nevnt i posten: {CONTENTSUBJECT} ';
$txt['msg_mention_body'] = 'Hei {MEMBERNAME}, Du har blitt nevnt i innlegg med tittelen "{CONTENTSUBJECT}}" av {MENTIONNAME}. Du kan se innlegget her: {CONTENTLINK} {REGARDS} ';

/**
	@additional_params: happy_birthday
		REALNAME: The real (display) name of the person receiving the birthday message.
	@description: A message sent to members on their birthday.
*/
$txtBirthdayEmails['happy_birthday_subject'] = 'Gratulerer med dagen fra {FORUMNAME}. ';
$txtBirthdayEmails['happy_birthday_body'] = 'Kjære {REALNAME}, Vi på {FORUMNAME} ønsker å gratulere deg med dagen. Må denne dagen og det kommende år bli fylt av glede. {REGARDS} ';
$txtBirthdayEmails['happy_birthday_author'] = '<a href="https://www.simplemachines.org/community/?action=profile;u=2676">Thantos</a> ';

$txtBirthdayEmails['karlbenson1_subject'] = 'På bursdagen din...';
$txtBirthdayEmails['karlbenson1_body'] = 'Vi kunne ha sendt deg et bursdagskort. Vi kunne ha sendt deg noen blomster eller en kake. Men det gjør vi ikke. Vi kunne også sendt deg en av de automatisk genererte meldinger for å gratulere deg med dagen, hvor vi ikke ngang hadde behøvd å manuelt endre SETT INN NAVN!. Men det gjør vi ikke. Vi skrev i stedet denne bursdagshilsenen bare for deg. Vi vil gjerne ønske deg en unikt fantastisk bursdag. {REGARDS} //:: Denne meldingen ble automatisk generert ::// ';
$txtBirthdayEmails['karlbenson1_author'] = '<a href="https://www.simplemachines.org/community/?action=profile;u=63186">karlbenson</a> ';

$txtBirthdayEmails['nite0859_subject'] = 'Gratulerer med dagen!';
$txtBirthdayEmails['nite0859_body'] = 'Dine venner på {FORUMNAME} ønsker å gratulere deg meg dagen, {REALNAME}. Hvis du ikke har gjort det nylig, vennligst besøk vår Forum sa de andre får muligheten til å ønske deg lykke til med dagen. Selv om det er bursdagen din i dag, {REALNAME}, vi vil gjerne minne deg på at ditt nærvær på Forumet har vært den beste gaven til oss så langt. De alle beste ønsker, Dine venner på {FORUMNAME} ';
$txtBirthdayEmails['nite0859_author'] = '<a href="https://www.simplemachines.org/community/?action=profile;u=46625">nite0859</a>';

$txtBirthdayEmails['zwaldowski_subject'] = 'Gratulerer med dagen {REALNAME}';
$txtBirthdayEmails['zwaldowski_body'] = 'Kjære {REALNAME}, Nok et år i ditt liv har passert. Vi på {FORUMNAME} håper det har vært fylt med glede, og ønsker deg lykke til i året som kommer. {REGARDS} ';
$txtBirthdayEmails['zwaldowski_author'] = '<a href="https://www.simplemachines.org/community/?action=profile;u=72038">zwaldowski</a>';

$txtBirthdayEmails['geezmo_subject'] = 'Gratulerer med dagen, {REALNAME}!';
$txtBirthdayEmails['geezmo_body'] = 'Vet du hvem som har bursdag i dag, {REALNAME}? Vi vet ... DEG! Gratulerer med dagen! Du er nå ett år eldre, men vi håper du er mye lykkeligere enn i fjor. Nyt dagen din i dag, {REALNAME}! - Fra dine venner på {FORUMNAME}';
$txtBirthdayEmails['geezmo_author'] = '<a href="https://www.simplemachines.org/community/?action=profile;u=48671">geezmo</a> ';

$txtBirthdayEmails['karlbenson2_subject'] = 'Gratulerer med dagen';
$txtBirthdayEmails['karlbenson2_body'] = 'Vi håper at bursdagen din er den beste noensinne skyet, sol eller uansett vær. HSpis bursdagskake og ha det moro, og fortell oss hva du har gjort. Vi håper denne meldingen har gitt deg glede, og at den varer, til samme tid samme sted neste år. {REGARDS} ';
$txtBirthdayEmails['karlbenson2_author'] = '<a href="https://www.simplemachines.org/community/?action=profile;u=63186">karlbenson</a> ';

?>