<?php
// Version: 2.1.3; Install

// These should be the same as those in index.language.php.
$txt['lang_character_set'] = 'UTF-8';
$txt['lang_rtl'] = '0';

$txt['install_step_welcome'] = 'Bienvenue';
$txt['install_step_writable'] = 'Test en Écriture';
$txt['install_step_forum'] = 'Paramètres du Forum';
$txt['install_step_databaseset'] = 'Paramètres de la Base de Données';
$txt['install_step_databasechange'] = 'Remplissage de la Base de Données';
$txt['install_step_admin'] = 'Compte Administrateur';
$txt['install_step_delete'] = 'Finalisation de l\'Installation';

$txt['smf_installer'] = 'Installateur SMF';
$txt['installer_language'] = 'Langue';
$txt['installer_language_set'] = 'Régler';
$txt['congratulations'] = 'Félicitations, le processus d\'installation est terminé&nbsp;!';
$txt['congratulations_help'] = 'Si, à tout moment, vous avez besoin de support, ou bien si SMF ne fonctionne pas correctement, rappelez-vous que <a href="https://www.simplemachines.org/community/index.php" target="_blank" rel="noopener">l\'aide an anglais est disponible</a> (en français aussi, dans <a href="https://www.simplemachines.org/community/index.php?board=14.0" target="_blank" rel="noopener">la section dédiée au support francophone chez Simple Machines</a>).';
$txt['still_writable'] = 'Votre dossier d\'installation est toujours ouvert en écriture.  Ça serait une bonne idée de changer ses droits d\'accès (chmod) afin de le fermer en écriture, pour des raisons de sécurité.';
$txt['delete_installer'] = 'Cliquez ici pour effacer cet installateur maintenant.';
$txt['delete_installer_maybe'] = '<em>(ne fonctionne pas sur tous les serveurs)</em>';
$txt['go_to_your_forum'] = 'Maintenant, vous pouvez aller voir <a href="%1$s">votre tout nouveau forum</a> et commencer à l\'utiliser.  Vous devrez d\'abord vous connecter, pour ensuite pouvoir accéder au Centre d\'administration.';
$txt['good_luck'] = 'Bonne chance!<br>L\'équipe Simple Machines';

$txt['install_welcome'] = 'Bienvenue';
$txt['install_welcome_desc'] = 'Bienvenue sur SMF. Ce script vous aidera à installer %1$s. Nous allons vous demander des détails sur votre forum dans les pages à venir, et il sera prêt à être utilisé en quelques minutes à peine.';
$txt['install_no_https'] = 'Votre environnement ne supporte pas les flux https. Certaines fonctions par exemple comme recevoir des mises à jour de SimpleMachines.org ne fonctionneront pas.';
$txt['install_no_mbstring'] = 'Votre environnement ne supporte pas la librairie mbstring requise. Veuillez activer mbstring et réessayer.';
$txt['install_no_fileinfo'] = 'Votre environnement ne supporte pas la librairie fileinfo requise. Veuillez activer fileinfo et réessayer.';
$txt['install_all_lovely'] = 'Nous avons terminé les tests préliminaires sur votre serveur, et tout semble être en ordre. Cliquez sur le bouton &quot;Continuer&quot; ci-dessous pour commencer.';

$txt['user_refresh_install'] = 'Forum Rafraîchi';
$txt['user_refresh_install_desc'] = 'Lors de l\'installation, SMF a trouvé, en utilisant les détails que vous avez fournis, qu\'au moins une des tables que l\'installateur doit créer existent déjà.<br>Toutes les tables manquantes de votre installation ont été recréées avec les données par défaut, mais aucune donnée n\'a été supprimée des tables existantes.';

$txt['default_topic_subject'] = 'Bienvenue dans SMF&nbsp;!';
$txt['default_topic_message'] = 'Bienvenue dans l\'installateur du Forum Simple Machines&nbsp;!<br><br>
Nous espérons que vous apprécierez votre nouveau forum. Si vous éprouvez des problèmes, n\'hésitez pas à [url=https://www.simplemachines.org/community/index.php]nous contacter[/url] pour obtenir de l\'assistance (en français dans [url=https://www.simplemachines.org/community/index.php?board=14.0]la section dédiée sur Simple Machines[/url]).<br><br>Merci&nbsp;!<br>Simple Machines';
$txt['default_board_name'] = 'Discussions Générales';
$txt['default_board_description'] = 'Une section pour discuter librement de tout et de rien.';
$txt['default_category_name'] = 'Catégorie Générale';
$txt['default_time_format'] = '%d %B %Y à %H:%M:%S';
$txt['default_news'] = 'Nouveau forum SMF installé&nbsp;!';
$txt['default_reserved_names'] = 'Admin\nWebmaster\n\nWebmestre\nInvite\nInvité\nGuest\nroot\nadministrateur\nsuperutilisateur';
$txt['default_fugue_smileyset_name'] = 'Jeu d\'émôticônes Fugue';
$txt['default_alienine_smileyset_name'] = 'Jeu de Smileys Alienine\'s';
$txt['default_aaron_smileyset_name'] = 'Par Aaron';
$txt['default_akyhne_smileyset_name'] = 'Par Akyhne';
$txt['default_legacy_smileyset_name'] = '2.0 par Défaut';
$txt['default_theme_name'] = 'Thème par défaut de SMF - Curve2';

$txt['default_administrator_group'] = 'Administrateur';
$txt['default_global_moderator_group'] = 'Modérateur Global';
$txt['default_moderator_group'] = 'Modérateur';
$txt['default_newbie_group'] = 'Néophyte';
$txt['default_junior_group'] = 'Membre Junior';
$txt['default_full_group'] = 'Membre Complet';
$txt['default_senior_group'] = 'Membre Senior';
$txt['default_hero_group'] = 'Membre Héroïque';

$txt['default_smiley_smiley'] = 'Sourire';
$txt['default_wink_smiley'] = 'Clin d\'oeil';
$txt['default_cheesy_smiley'] = 'Très souriant';
$txt['default_grin_smiley'] = 'Grimaçant';
$txt['default_angry_smiley'] = 'Fâché';
$txt['default_sad_smiley'] = 'Triste';
$txt['default_shocked_smiley'] = 'Choqué';
$txt['default_cool_smiley'] = 'Cool';
$txt['default_huh_smiley'] = 'Hein ?';
$txt['default_roll_eyes_smiley'] = 'Roulement d\'yeux';
$txt['default_tongue_smiley'] = 'Tire la langue';
$txt['default_embarrassed_smiley'] = 'Embarrassé';
$txt['default_lips_sealed_smiley'] = 'Lèvres scellées';
$txt['default_undecided_smiley'] = 'Indécis';
$txt['default_kiss_smiley'] = 'Bisous';
$txt['default_cry_smiley'] = 'Pleurs';
$txt['default_evil_smiley'] = 'Diabolique';
$txt['default_azn_smiley'] = 'Prétentieux';
$txt['default_afro_smiley'] = 'Afro';
$txt['default_laugh_smiley'] = 'Rire';
$txt['default_police_smiley'] = 'Police';
$txt['default_angel_smiley'] = 'Ange';

$txt['error_message_click'] = 'Cliquez ici';
$txt['error_message_try_again'] = 'pour réessayer une nouvelle fois cette étape.';
$txt['error_message_bad_try_again'] = 'pour malgré tout tenter l\'installation, mais notez que ceci est <em>fortement</em> déconseillé.';

$txt['install_settings'] = 'Options de base';
$txt['install_settings_info'] = 'Quelques trucs pour vous pour l\'installation.';
$txt['install_settings_name'] = 'Nom du forum';
$txt['install_settings_name_info'] = 'C\'est le nom que portera votre forum, ex&nbsp;: &quot;Forum du site&quot;.';
$txt['install_settings_name_default'] = 'Ma Communauté';
$txt['install_settings_url'] = 'URL du forum';
$txt['install_settings_url_info'] = 'Ceci est l\'URL de votre forum <strong>sans la barre oblique \'/\' finale&nbsp;!</strong>.<br>Dans la plupart des cas, vous pouvez laisser ainsi les valeurs par défaut - elles sont généralement correctes.';
$txt['install_settings_reg_mode'] = 'Mode d\'inscription';
$txt['install_settings_reg_modes'] = 'Modes d\'inscription';
$txt['install_settings_reg_immediate'] = 'Inscription immédiate';
$txt['install_settings_reg_email'] = 'Activation par e-mail';
$txt['install_settings_reg_admin'] = 'Approbation par admin';
$txt['install_settings_reg_disabled'] = 'Inscription désactivée';
$txt['install_settings_reg_mode_info'] = 'Ce champ vous permet de changer le mode d\'inscription à l\'installation pour empêcher les inscriptions non désirées.';
$txt['install_settings_compress'] = 'Compression Gzip';
$txt['install_settings_compress_title'] = 'Compresse les données envoyées afin d\'économiser la bande passante.';
// In this string, you can translate the word "PASS" to change what it says when the test passes.
$txt['install_settings_compress_info'] = 'Cette fonction ne fonctionne pas sur tous les serveurs, mais peut contribuer à économiser énormément la bande passante.<br>Cliquez <a href="install.php?obgz=1&amp;pass_string=REUSSI" onclick="return reqWin(this.href, 200, 60);" target="_blank" rel="noopener">ici</a> pour tester. (ça devrait seulement vous dire "REUSSI".)';
$txt['install_settings_dbsession'] = 'Stocker les sessions dans la base de données';
$txt['install_settings_dbsession_title'] = 'Utilisez la base de données pour stocker les sessions plutôt que d\'utiliser des fichiers.';
$txt['install_settings_dbsession_info1'] = 'Cette fonction est une bonne solution la plupart du temps, rendant ainsi les sessions plus dépendantes du forum.';
$txt['install_settings_dbsession_info2'] = 'Cette fonction est généralement une bonne idée, mais peut ne pas fonctionner sur ce serveur.';
$txt['install_settings_stats'] = 'Autoriser la collecte de statistiques';
$txt['install_settings_stats_title'] = 'Autorise Simple Machines à collecter les statistiques basiques mensuelles';
$txt['install_settings_stats_info'] = 'Si activé, cela autorise Simple Machines à visiter votre site pour collecter les statistiques basiques mensuelles. Cela nous aidera à faire des choix pour optimiser le script. Pour plus d\'informations veuillez visiter nos <a href="https://www.simplemachines.org/about/stats.php" target="_blank" rel="noopener">Pages d\'informations</a>.';
$txt['install_settings_proceed'] = 'Procéder';

$txt['db_settings'] = 'Paramètres du Serveur de Base de données';
$txt['db_settings_info'] = 'Ce sont les paramètres à utiliser pour votre serveur de base de données. Si vous n\'en connaissez pas les valeurs, essayez de les demander à votre hébergeur.';
$txt['db_settings_type'] = 'Type de base de données';
$txt['db_settings_type_info'] = 'Plusieurs types de bases de données supportées ont été détectées - laquelle voudriez-vous utiliser. Veuillez noter qu\'utiliser les versions avant SMF 2.0 RC3 cote à cote avec de nouvelles versions d\'SMF sur la même base PostgreSQL n\'est pas supporté. Vous devez dans ce cas mettre à jour vos anciennes installations.';
$txt['db_settings_server'] = 'Nom du serveur';
$txt['db_settings_server_info'] = 'C\'est pratiquement toujours localhost - donc si vous ne savez pas, essayez localhost.';
$txt['db_settings_username'] = 'Nom d\'utilisateur';
$txt['db_settings_username_info'] = 'Insérez ici le nom d\'utilisateur nécessaire à la connexion à votre base de données.<br>Si vous ne le connaissez pas, essayez le nom d\'utilisateur de votre compte FTP, la plupart du temps ils sont identiques.';
$txt['db_settings_password'] = 'Mot de passe';
$txt['db_settings_password_info'] = 'Ici, mettez le mot de passe nécessaire à la connexion à votre base de données.<br>Si vous ne le connaissez pas, essayez le mot de passe de votre compte FTP.';
$txt['db_settings_database'] = 'Nom de la base de données';
$txt['db_settings_database_info'] = 'Indiquez le nom de la base de données que vous voulez utiliser pour stocker des données d\'SMF.';
$txt['db_settings_database_info_note'] = 'Si cette base de données n\'existe pas, cet installateur essaiera de la créer.';
$txt['db_settings_port'] = 'Port de la base de donnée';
$txt['db_settings_port_info'] = 'Laisser vide pour utiliser celui par défaut';
$txt['db_settings_prefix'] = 'Préfixe de Table';
$txt['db_settings_prefix_info'] = 'Le préfixe pour chaque table de la base de données. <strong>Ne pas installer deux forums avec le même préfixe&nbsp;!</strong><br>Cette valeur permet d\'avoir plusieurs installations différentes sur une seule base de données.';
$txt['db_populate'] = 'Base de Données remplie';
$txt['db_populate_info'] = 'Vos paramètres ont été sauvegardés, et les données requises au bon fonctionnement du forum ont été insérées dans la base de données. Résumé du remplissage&nbsp;:';
$txt['db_populate_info2'] = 'Cliquez &quot;Continuer&quot; pour accéder au processus de création du compte administrateur.';
$txt['db_populate_inserts'] = '%1$d rangées insérées.';
$txt['db_populate_tables'] = '%1$d tables créées.';
$txt['db_populate_insert_dups'] = '%1$d insertions superflues ignorées.';
$txt['db_populate_table_dups'] = '%1$d tables superflues ignorées.';

$txt['user_settings'] = 'Créez votre compte';
$txt['user_settings_info'] = 'L\'installateur créera maintenant un nouveau compte administrateur pour vous.';
$txt['user_settings_username'] = 'Votre identifiant';
$txt['user_settings_username_info'] = 'Choisissez le nom d\'utilisateur avec lequel vous désirez vous connecter.<br>Ce nom pourra être changé plus tard.';
$txt['user_settings_password'] = 'Mot de passe';
$txt['user_settings_password_info'] = 'Choisissez votre mot de passe ici, et souvenez-vous-en bien !';
$txt['user_settings_again'] = 'Mot de passe';
$txt['user_settings_again_info'] = '(juste pour vérifier).';
$txt['user_settings_admin_email'] = 'Adresse e-mail de l\'administrateur';
$txt['user_settings_admin_email_info'] = 'Entrez votre adresse email. Ceci doit être une adresse email valide!';
$txt['user_settings_server_email'] = 'Adresse e-mail du webmaster';
$txt['user_settings_server_email_info'] = 'Entrer <strong>l\'adresse email que SMF utilisera pour envoyer des emails</strong>. Ceci doit être une adresse valide!';
$txt['user_settings_database'] = 'Mot de passe de la base de données';
$txt['user_settings_database_info'] = 'Pour des raisons de sécurité, le programme d\'installation vous demande de fournir le mot de passe de la base de données pour créer un compte administrateur.';
$txt['user_settings_skip'] = 'Ignorer';
$txt['user_settings_skip_sure'] = 'Etes vous sûr de vouloir éviter la création d\'un compte administrateur&nbsp;?';
$txt['user_settings_proceed'] = 'Terminer';

$txt['ftp_checking_writable'] = 'Vérifie si les fichiers sont inscriptibles';
$txt['ftp_setup'] = 'Informations sur la connexion FTP';
$txt['ftp_setup_info'] = 'Cet installateur peut se connecter par FTP afin de spécifier les bons droits d\'accès aux fichiers du forum. Si la procédure ne fonctionne pas, vous devrez modifier manuellement les droits d\'accès des fichiers. Veuillez noter que cette fonction ne supporte actuellement pas le SSL.';
$txt['ftp_setup_why'] = 'En quoi cette étape est-elle utile&nbsp;?';
$txt['ftp_setup_why_info'] = 'Certains fichiers nécessitent d\'être accessibles en écriture par SMF pour que votre forum fonctionne correctement. Cette étape permet à l\'installateur de régler ces propriétés pour vous. Toutefois, dans certains cas, ça ne fonctionnera pas - auquel cas veuillez faire un chmod 777 (écriture possible, 755 chez certains hébergeurs) sur les fichiers suivants :';
$txt['ftp_setup_again'] = 'pour vérifier si les fichiers sont de nouveaux accessibles en écriture.';

$txt['error_missing_files'] = 'Incapable de trouver les fichiers nécessaires à l\'installation dans le répertoire de ce script&nbsp;!<br><br>Veuillez vous assurer d\'avoir transféré la totalité des fichiers de l\'archive d\'installation, incluant le fichier SQL, et réessayez plus tard.';
$txt['error_session_save_path'] = 'Veuillez informer votre hébergeur que le <strong>session.save_path spécifié dans php.ini</strong> est invalide !  Il a besoin d\'être changé vers un répertoire <strong>existant</strong> et <strong>accessible en écriture</strong> par l\'utilisateur sur lequel fonctionne PHP.<br>';
$txt['error_windows_chmod'] = 'Vous êtes sous un serveur Windows, et quelques fichiers cruciaux ne sont pas accessibles en écriture. Veuillez contacter votre hébergeur afin qu\'il donne des <strong>permissions d\'écritures</strong> à l\'utilisateur sur lequel PHP fonctionne pour les fichiers de votre installation de SMF. Les fichiers ou dossiers suivants doivent être accessibles en écriture :';
$txt['settings_error'] = 'Vos paramètres n\'ont pas pu être enregistrés dans Settings.php.';
$txt['error_ftp_no_connect'] = 'Impossible de se connecter au serveur FTP avec ces renseignements.';
$txt['error_db_file'] = 'Impossible de trouver le script source de la base de données&nbsp;! Veuillez vérifier que le fichier %1$s est dans le répertoire source de votre forum.';
$txt['error_db_connect'] = 'Impossible de se connecter au serveur de base de données avec les informations fournies.<br><br>Si vous n\'êtes pas sûr de ces informations, veuillez contacter votre hébergeur.';
$txt['error_db_connect_settings'] = 'Impossible de se connecter au serveur de base de données.<br><br>Veuillez vérifier que les informations de la base de données sont correctes dans le Settings.php.';
$txt['error_db_database'] = 'L\'installateur a été incapable d\'accéder à la base de données &quot;<em>%1$s</em>&quot;. Avec certains hébergeurs, vous devez créer la base de données dans votre panneau administrateur avant qu\'SMF ne puisse l\'utiliser. Certains aussi ajoutent des préfixes - comme votre nom d\'utilisateur - aux noms de vos bases de données.';
$txt['error_db_queries'] = 'Certaines requêtes n\'ont pu été exécutées normalement. C\'est peut-être dû à une version trop ancienne ou trop récente de votre base de données.<br><br>Informations techniques sur les requêtes&nbsp;:';
$txt['error_db_queries_line'] = 'Ligne #';
$txt['error_db_missing'] = 'L\'installateur a n\'a pas pu détecter de support pour les bases de données dans PHP. Veuillez demander à votre hébergeur de s\'assurer que PHP a été compilé avec les bases de données désirées, ou que l\'extension associée a bien été chargée.';
$txt['error_db_script_missing'] = 'L\'installateur n\'a pas trouvé de fichier de script pour la base de données demandée. Vérifiez que vous avez mis en ligne tous les fichiers nécessaires, par exemple &quot;%1$s&quot;';
$txt['error_session_missing'] = 'L\'installateur a été incapable de détecter le support des sessions dans la version de PHP installé sur votre serveur.  Veuillez demander à votre hébergeur de vérifier que PHP a été compilé avec le support des sessions (en fait, ça doit être explicitement spécifié compilé sans cela.)';
$txt['error_user_settings_again_match'] = 'Vous avez tapé deux mots de passe différents&nbsp;!';
$txt['error_user_settings_no_password'] = 'Votre mot de passe doit avoir au moins quatre caractères.';
$txt['error_user_settings_taken'] = 'Désolé, un utilisateur est déjà inscrit sous ce nom et/ou mot de passe.<br><br>Le nouveau compte n\'a pas été créé.';
$txt['error_user_settings_query'] = 'Une erreur de base de données s\'est produite lors de la création d\'un administrateur.  L\'erreur était&nbsp;:';
$txt['error_sourcefile_missing'] = 'Impossible de trouver les fichiers Sources/%1$s. Assurez-vous qu\'ils aient été téléchargé correctement, puis réessayez.';
$txt['error_db_alter_priv'] = 'Le compte de base de données que vous avez spécifié n\'a pas la permission de modifier ALTER, créer CREATE et/ou supprimer DROP les tables de la base de données. Ces fonctions sont nécessaires au bon fonctionnement de SMF.';
$txt['error_versions_do_not_match'] = 'L\'installateur a détecté une autre version de SMF déjà installée avec ces informations spécifiques. Si vous essayez de lancer la mise à jour, vous devez utiliser l\'upgradeur et non pas l\'installateur.<br><br>Ou alors, vous pouvez désirer utiliser des informations différentes, ou alors vous effectuez une sauvegarde puis vous supprimez les données actuellement dans la base de donnée.';
$txt['error_mod_security'] = 'L\'installateur a détecté que le module <em>mod_security</em> est installé sur votre serveur web. <em>mod_security</em> bloquera les formulaires transmis avant même qu\'SMF ne puisse faire quoi que ce soit. SMF inclut de base un scanner de sécurité plus efficace que mod_security et qui ne bloque pas les formulaires transmis.<br><br><a href="https://www.simplemachines.org/redirect/mod_security">Plus d\'informations sur la désactivation de mod_security</a>';
$txt['error_mod_security_no_write'] = 'L\'installateur a détecté que le module <em>mod_security</em> est installé sur votre serveur web. <em>mod_security</em> bloquera les formulaires transmis avant même qu\'SMF ne puisse faire quoi que ce soit. SMF inclut de base un scanner de sécurité plus efficace que mod_security et qui ne bloque pas les formulaires transmis.<br><br><a href="https://www.simplemachines.org/redirect/mod_security">Plus d\'informations sur la désactivation de mod_security</a><br><br>Alternativement, vous pouvez aussi utiliser votre client FTP pour faire un chmod (777) sur le fichier .htaccess de votre répertoire du forum afin de le rendre inscriptible, et ensuite rafraîchir cette page.';
$txt['error_utf8_version'] = 'La version actuelle de votre base de données ne supporte pas l\'utilisation du jeu de caractères UTF-8. Vous pouvez tout de même installer SMF sans problème, mais seulement avec le support de l\'UTF-8 non coché. Si vous voulez basculer à l\'UTF-8 dans le futur (par ex. après une mise à jour du serveur de base de données de votre forum à la version &gt;= %1$s), vous pourrez convertir votre forum à l\'UTF-8 via le Centre d\'Administration.';
$txt['error_valid_admin_email_needed'] = 'Vous n\'avez pas entré une adresse email valide pour votre compte d\'administrateur';
$txt['error_valid_server_email_needed'] = 'Vous n\'avez pas entré une adresse email de webmaster valide.';
$txt['error_already_installed'] = 'L\'installateur a détecté que SMF est déjà installé. Il est fortement recommandé de ne <strong>pas</strong> essayer d\'écraser une installation existante - continuer l\'installation <strong>peut provoquer la perte ou la corruption des données existantes</strong>.<br><br>Si vous voulez effectuer une mise à jour, veuillez visiter le <a href="https://www.simplemachines.org">Site Web de Simple Machines</a> et télécharger le dernier paquet de <em>mise à jour</em>.<br><br>Si vous voulez écraser votre installation existante, y compris toutes ses données, il est recommandé d\'effacer manuellement les tables de la base de données, de remplacer le fichier Settings.php et de réessayer.';
$txt['error_warning_notice'] = 'Attention&nbsp;!';
$txt['error_script_outdated'] = 'Ce script d\'installation n\'est pas à jour ! La version actuelle d\'SMF est %1$s mais le script d\'installation est pour %2$s.<br><br>
Nous vous recommandons de visiter le site de <a href="https://www.simplemachines.org">Simple Machines</a> pour vous assurer que vous installez bien la dernière version.';
$txt['error_db_prefix_numeric'] = 'Le type de base de données choisi ne supporte pas l\'utilisation de nombres en tant que préfixe.';
$txt['error_pg_scs'] = 'PostgreSQL n\'est pas configuré correctement. Veuillez activer le paramètre de configuration standard_conforming_strings.';
$txt['error_invalid_characters_username'] = 'Un caractère invalide a été utilisé dans le Nom d\'utilisateur.';
$txt['error_username_too_long'] = 'Le Nom d\'utilisateur doit faire moins de 25 caractères.';
$txt['error_username_left_empty'] = 'Vous n\'avez pas rempli le champ Nom d\'utilisateur.';
$txt['error_db_prefix_reserved'] = 'Le préfixe que vous avez entré est un préfixe réservé. Veuillez en choisir un nouveau.';
$txt['error_utf8_support'] = 'La base de données que vous essayez d\'utiliser n\'utilise pas le jeu de caractères UTF8';

$txt['ftp_login'] = 'Vos informations de connexion FTP';
$txt['ftp_login_info'] = 'L\'installateur web a besoin de vos informations FTP pour pouvoir automatiser l\'installation pour vous. Veuillez noter qu\'aucune de ces informations ne sont sauvegardées dans votre installation, elles ne sont utilisées que pour mettre en place SMF.';
$txt['ftp_server'] = 'Serveur';
$txt['ftp_server_info'] = 'Ceci devrait être l\'adresse (souvent localhost) et le port de votre serveur FTP.';
$txt['ftp_port'] = 'Port';
$txt['ftp_username'] = 'Identifiant FTP';
$txt['ftp_username_info'] = 'L\'identifiant de votre compte FTP. <em>L\'information ne sera enregistrée nulle part.</em>';
$txt['ftp_password'] = 'Mot de passe FTP';
$txt['ftp_password_info'] = 'Le mot de passe de votre compte FTP. <em>L\'information ne sera enregistrée nulle part.</em>';
$txt['ftp_path'] = 'Chemin d\'installation';
$txt['ftp_path_info'] = 'C\'est le chemin <em>relatif</em> que vous utilisez pour votre client FTP. ';
$txt['ftp_path_found_info'] = 'Le chemin dans le champ précédent a été détecté automatiquement..';
$txt['ftp_path_help'] = 'Votre chemin FTP est le chemin que vous voyez lorsque vous vous connectez avec votre client FTP. Il démarre généralement avec &quot;<pre>www</pre>&quot;, &quot;<pre>public_html</pre>&quot;, ou &quot;<pre>httpdocs</pre>&quot; - mais il doit aussi inclure le dossier dans lequel SMF est , tel que &quot;/public_html/forum&quot;. C\'est différent du chemin de l\'adresse URL.<br><br>Les fichiers dans ce chemin pourraient être écrasés alors assurez vous qu\'il est correct.';
$txt['ftp_path_help_close'] = 'Fermer';
$txt['ftp_connect'] = 'Connexion';

$txt['force_ssl'] = 'Activer SSL';
$txt['force_ssl_label'] = 'Forcer SSL sur l\'ensemble du forum';
$txt['force_ssl_info'] = 'Assurez vous que SSL et HTTPS sont supportés sur l\'ensemble du forum ou votre forum pourrait ne plus être accessible.';

$txt['chmod_linux_info'] = 'Si vous avez un compte shell, la commande ci-dessous peut corriger les permissions de ces fichiers automatiquement';

// The upgrader needs text strings too!
$txt['upgrade_step_login'] = 'Connexion';
$txt['upgrade_step_options'] = 'Options de mise à jour';
$txt['upgrade_step_backup'] = 'Sauvegarde';
$txt['upgrade_step_database'] = 'Modifications dans la base de données';
$txt['upgrade_step_convertutf'] = 'Conversion en UTF-8';
$txt['upgrade_step_convertjson'] = 'Convertir les chaînes sérialisées en chaînes JSON';
$txt['upgrade_step_delete'] = 'Supprimer les fichiers Upgrade.php';

$txt['upgrade_upgrade_utility'] = 'Utilitaire de mise à jour de SMF';
$txt['upgrade_warning'] = 'Attention&nbsp;!';
$txt['upgrade_critical_error'] = 'Erreur Critique&nbsp;!';
$txt['upgrade_continue'] = 'Continuer';
$txt['upgrade_skip'] = 'Ignorer';
$txt['upgrade_note'] = 'Note&nbsp;!';
$txt['upgrade_step'] = 'Étape';
$txt['upgrade_steps'] = 'Étapes';
$txt['upgrade_progress'] = 'Avancement';
$txt['upgrade_overall_progress'] = 'Avancement Général';
$txt['upgrade_step_progress'] = 'Avancement de l\'Étape';
$txt['upgrade_time_elapsed'] = 'Temps Écoulé';
$txt['upgrade_time_mins'] = 'mins';
$txt['upgrade_time_secs'] = 'secondes';
$txt['upgrade_username'] = 'Identifiant&nbsp;:';
$txt['upgrade_wrong_username'] = 'Identifiant Incorrect';
$txt['upgrade_password'] = 'Mot de Passe&nbsp;:';
$txt['upgrade_wrong_password'] = 'Mot de Passe Incorrect';
$txt['upgrade_script_timeout_minutes'] = 'Ce script de mise à niveau ne peut pas être exécuté tant que %1$s n\\’a pas été inactif pendant au moins %2$d minutes';
$txt['upgrade_script_timeout_seconds'] = 'Ce script de mise à niveau ne peut pas être exécuté tant que %1$s n\\’a pas été inactif pendant au moins %2$d secondes ';

$txt['upgrade_wait'] = 'Veuillez patienter pendant la création d\'une sauvegarde. Pour les grands forums, le processus peut prendre beaucoup de temps&nbsp;!';
$txt['upgrade_wait2'] = 'Veuillez patienter pendant que votre base de données est convertie en UTF-8. Pour les grands forums, le processus peut prendre beaucoup de temps&nbsp;!';
$txt['upgrade_sec_login'] = 'Pour des raisons de sécurité, veuillez vous connecter avec votre compte administrateur pour procéder à la mise à jour.';
$txt['upgrade_incomplete'] = 'Incomplet';
$txt['upgrade_not_quite_done'] = 'Une seconde, ce n\'est pas fini&nbsp;!';
$txt['upgrade_paused_overload'] = 'La mise à jour a été mise en pause afin d\'éviter de surcharger votre serveur. Ne vous inquiétez pas, aucun souci, cliquez simplement sur le bouton <label for="contbutt">Continuer</label> ci-dessous pour continuer.';
$txt['upgrade_continue_step'] = 'Continuer à partir de la dernière étape atteinte lors de la dernière exécution du script de mise à jour.';
$txt['upgrade_bypass'] = '<strong><Remarque :</strong> Si nécessaire, le contrôle de sécurité ci-dessus peut être contourné pour les utilisateurs qui peuvent administrer un serveur mais n\'ont pas les droits d\'administrateur sur le forum. Pour contourner le contrôle ci-dessus, ouvrez simplement &quot;upgrade.php&quot; dans un éditeur de texte et remplacez &quot;$disable_security = false;&quot ; par &quot;$disable_security = true;&quot ; et actualisez cette page.';
$txt['upgrade_areyouready'] = 'Avant de procéder à la mise à jour, veuillez vérifier les options ci-dessous - et cliquez sur &quot;Continuer&quot; lorsque vous êtes prêt à commencer.';
$txt['upgrade_backup_table'] = 'Sauvegarde des tables de votre base de données avec le préfixe';
$txt['upgrade_backup_complete'] = 'Sauvegarde terminée! Cliquez sur Continuer pour continuer.';
$txt['upgrade_recommended'] = 'recommandé&nbsp;!';
$txt['upgrade_maintenance'] = 'Mettre le forum en mode maintenance pendant la mise à jour.';
$txt['upgrade_maintenance_title'] = 'Titre à afficher pendant la Maintenance&nbsp;:';
$txt['upgrade_maintenance_message'] = 'Message à afficher pendant la Maintenance&nbsp;:';
$txt['upgrade_customize'] = 'Personnaliser';
$txt['upgrade_debug_info'] = 'Sortie d\'informations de débogage supplémentaires.';
$txt['upgrade_empty_errorlog'] = 'Vider le journal d\'erreurs avant la mise à jour.';
$txt['upgrade_delete_karma'] = 'Supprimer tous les paramètres et les informations liées au karma dans la Base de Données';
$txt['upgrade_reprocess_attachments'] = 'Refaire la conversion des pièces jointes';
$txt['upgrade_stats_collection'] = 'Permettre à Simple Machines de collecter les statistiques de base mensuellement.';
$txt['upgrade_stats_info'] = 'Si cette option est activée, cela permettra à Simple Machines de visiter votre site une fois par mois pour collecter des statistiques de base. Cela nous aidera à prendre des décisions quant aux configurations pour lesquelles optimiser le logiciel. Pour plus d\'informations, veuillez visiter nos <a href="%1$s" target="_blank" rel="noopener">pages d\'information</a>.';
$txt['upgrade_migrate_settings_file'] = 'Migrer vers le nouveau fichier de configuration (Settings).';
$txt['upgrade_db_changes'] = 'Exécution des modifications dans la base de données';
$txt['upgrade_db_patient'] = 'S\'il vous plaît soyez patient - Pour les grands forums, le processus peut prendre beaucoup de temps. Le temps écoulé depuis le serveur indique la progression des tâches qui sont en cours.';
$txt['upgrade_db_complete'] = '1 Mise à Jour de la Base de Données est Terminée&nbsp;! Cliquez sur Continuer pour Poursuivre.';
$txt['upgrade_db_complete2'] = 'Mises à Jour de la Base de Données Terminée&nbsp;! Cliquez sur Continuer pour Poursuivre.';
$txt['upgrade_script'] = 'Exécution du script de mise à jour';
$txt['upgrade_error'] = 'Erreur&nbsp;!';
$txt['upgrade_unknown_error'] = 'Erreur Inconnue&nbsp;!';
/* Same sentence, 3 different strings */
$txt['upgrade_completed'] = 'Effectué';
$txt['upgrade_outof'] = 'sur';
$txt['upgrade_tables'] = 'tables.';

$txt['upgrade_run_script'] = 'Nous vous recommandons de ne pas exécuter ce script à moins d\'être sûr que';
$txt['upgrade_run_script2'] = 'a terminé sa mise à jour.';
$txt['upgrade_run'] = 'Vous pouvez choisir d\'exécuter de nouveau la mise à jour depuis le début - ou bien de continuer depuis la dernière étape atteinte lors de la dernière mise à jour.';

$txt['upgrade_completed_table'] = 'Table Effectuée&nbsp;:';
$txt['upgrade_current_table'] = 'Table Courante&nbsp;:';
$txt['upgrade_fulltext'] = 'Veuillez noter que votre index en texte intégral a été supprimé pour faciliter la conversion et devra être recréé dans la zone d\'administration une fois la mise à jour terminée.';
$txt['upgrade_conversion_proceed'] = 'Conversion Terminée ! Cliquez sur Continuer pour Poursuivre.';
$txt['upgrade_convert_datajson'] = 'Conversion de données de sérialisation en JSON...';
$txt['upgrade_json_completed'] = 'Conversion vers JSON Complete ! Cliquez sur Continuer pour Poursuivre.';
$txt['upgrade_executing'] = 'Exécuter&nbsp;:';
$txt['upgrade_of'] = 'de';
$txt['upgrade_admin_login'] = 'Connexion Administrateur&nbsp;:';
$txt['upgrade_admin_disabled'] = '(DESACTIVE)';
$txt['upgrade_done'] = 'Mise à niveau terminée. Vous êtes maintenant prêt à utiliser <a href="%1$s/index.php">votre installation de SMF</a>. J\'espère que vous l\'apprécierez !';

$txt['upgrade_delete_now'] = 'Supprimer upgrade.php et ses fichiers annexes maintenant';
$txt['upgrade_delete_server'] = '(ne fonctionne pas sur tous les serveurs).';
$txt['upgrade_problems'] = 'Si vous avez eu des problèmes avec cette mise à jour, ou si vous avez des problèmes avec SMF, n\'hésitez pas à <a href="%1$s">nous consulter pour avoir une assistance</a>.';
$txt['upgrade_luck'] = 'Bonne chance à vous,';

$txt['upgrade_ftp_login'] = 'Vos informations pour votre connexion FTP';
$txt['upgrade_ftp_perms'] = 'L\'outil de mise à jour peut résoudre tous les problèmes de permissions de fichiers pour rendre la mise à jour aussi simple que possible. Entrez simplement vos informations de connexion ci-dessous ou cliquez sur <a href="#" onclick="warning_popup() ;">ici</a> pour voir la liste des fichiers qui doivent être modifiés.';
$txt['upgrade_ftp_warning'] = 'Attention';
$txt['upgrade_ftp_files'] = 'Les fichiers suivants doivent être rendus inscriptibles pour continuer :';
$txt['upgrade_ftp_shell'] = 'Si vous avez un compte shell, la commande ci-dessous peut corriger les permissions de ces fichiers automatiquement';
$txt['upgrade_ftp_error'] = 'L\'erreur suivante s\'est produite lors de la tentative de connexion&nbsp;:';

$txt['upgrade_ready_proceed'] = 'Merci d\'avoir choisi de mettre à jour SMF en version %1$s. Tous les fichiers semblent être où il faut, on commence quand vous voulez.';
$txt['upgrade_error_script_js'] = 'Le script de mise à jour n\'a pas trouvé le fichier script.js, ou il n\'est pas à jour. Assurez-vous que les chemins vers les thèmes sont correctement renseignés. Vous pouvez vous procurer sur le <a href="%1$s">Site Web de Simple Machines</a> un outil de vérification';
$txt['upgrade_warning_lots_data'] = 'Le script de mise à jour a détecté de nombreux fichiers nécessitant une mise à jour. Ce processus peut éventuellement prendre du temps, en fonction de la puissance du serveur et de la taille du forum, et jusqu\'à plusieurs heures pour des forums conséquents (300,000 messages et plus).';
$txt['upgrade_warning_out_of_date'] = 'Ce script de mise à jour n\'est pas... à jour ! La version actuelle de SMF est <em id="smfVersion" style="white-space: nowrap;">??</em> mais ce script est pour la version <em id="yourVersion" style="white-space: nowrap;">%1$s</em>.<br><br>Nous vous recommandons de vous rendre sur le site de <a href="%2$s">Simple Machines</a> pour vous assurer que vous mettez à jour vers la dernière version en date.';

$txt['upgrade_forumdir_settings'] = 'Il semble que les paramètres du répertoire de votre forum <em>soient</em> incorrects. Le répertoire de votre forum est actuellement &quot;%1$s&quot; mais devrait probablement être &quot;%2$s&quot;. Settings.php liste actuellement vos répertoires comme suit :';
$txt['upgrade_forumdir'] = 'Dossier racine du forum :';
$txt['upgrade_sourcedir'] = 'Répertoire des fichiers Sources&nbsp;:';
$txt['upgrade_cachedir'] = 'Répertoitre du Cache&nbsp;:';
$txt['upgrade_incorrect_settings'] = 'Si ceux-ci semblent incorrects, veuillez ouvrir le fichier Settings.php dans un éditeur de texte avant de procéder à cette mise à jour. Si elles sont incorrectes suite au déplacement de votre forum vers un nouvel emplacement, veuillez télécharger l\'outil <a href="https://download.simplemachines.org/?tools">Repair Settings</a> depuis le site Simple Machines et l\'exécuter avant de continuer.';

$txt['upgrade_fulltext_error'] = 'Votre index de recherche plein texte a été supprimé pour faciliter la conversion. Vous devrez le recréer.';
$txt['upgrade_writable_files'] = 'Les fichiers suivants doivent être inscriptibles pour continuer la mise à jour. Veuillez vous assurer que les permissions Windows sont correctement paramétrées pour le permettre&nbsp;:';
$txt['upgrade_time_user'] = '&quot;%1$s&quot; exécute le script de mise à jour.';

// We represent the time here in backwards variables, as it makes the code easier.
$txt['upgrade_time_hms'] = 'Le script de mise à niveau est exécuté depuis les %3$d dernières heures, %2$d minutes et %1$d secondes.';
$txt['upgrade_time_ms'] = 'Le script de mise à niveau est en cours d\\’exécution depuis les %2$d dernières minutes et %1$d secondes.';
$txt['upgrade_time_s'] = 'Le script de mise à niveau est en cours d\\’exécution depuis les %1$d dernières secondes.';
$txt['upgrade_time_updated_hms'] = 'Le script de mise à jour a été actualisé pour la dernière fois il y a %3$d heures, %2$d minutes et %1$d secondes.';
$txt['upgrade_time_updated_hm'] = 'Le script de mise à jour a été actualisé pour la dernière fois il y a %2$d minutes et %1$d secondes.';
$txt['upgrade_time_updated_s'] = 'Le script de mise à jour a été actualisé pour la dernière fois il y a %1$d secondes.';
$txt['upgrade_completed_time_hms'] = 'Mise à jour effectuée en %3$d heures, %2$s minutes et %1$s secondes';
$txt['upgrade_completed_time_ms'] = 'Mise à jour effectuée en %2$s minutes et %1$s secondes';
$txt['upgrade_completed_time_s'] = 'Mise à jour effectuée en %1$s secondes';
$txt['upgrade_success_time_db'] = 'Félicitations&nbsp;! Mises à jour de la Base de Données effectuées en %3$d heures, %2$d minutes et %1$d secondes.';

$txt['upgrade_unsuccessful'] = 'Echec de la mise à jour&nbsp;!';
$txt['upgrade_thisquery'] = 'Cette requête&nbsp;:';
$txt['upgrade_causerror'] = 'Erreur Causée&nbsp;:';
$txt['upgrade_completedtables_outof'] = 'Effectué <span id="tab_done">%1$d</span> sur %2$d tables.';
$txt['upgrade_success'] = 'Réussi&nbsp;!';
$txt['upgrade_loop'] = 'Le script de mise à jour est en cours d\'exécution - étape&nbsp;:';
$txt['upgrade_respondtime'] = 'Le serveur n\\\'a pas répondu pendant %1$d secondes. Cela vaut peut-être la peine d\\\'attendre un peu plus longtemps avant de réessayer.';
$txt['upgrade_respondtime_clickhere'] = 'Cliquez ici pour réessayer.';
$txt['mtitle'] = 'Mise à jour du forum...';
$txt['mmessage'] = 'Ne vous inquiétez pas, votre forum sera mis à jour sous peu. Cela ne prendra qu\'une minute ;).';

// Upgrader error messages
// argument(s): template name (if applicable)
$txt['error_unexpected_template_call'] = 'Erreur : Appel inattendu pour utiliser le modèle %1$s. Veuillez copier et coller tout le texte ci-dessus et visiter le forum de support SMF pour faire savoir aux développeurs qu\'il y a un bogue afin qu\'ils puissent le corriger et vous aider à le faire fonctionner à nouveau.';
$txt['error_invalid_template'] = 'Mise à jour annulée&nbsp;! Modèle invalide&nbsp;: template_%1$s';
$txt['error_lang_index_missing'] = 'L\'outil de mise à jour n\'a pas pu trouver les fichiers de langage pour la langue sélectionnée, %1$s.<br>SMF ne fonctionnera pas dans cette langue sans les fichiers de langue installés.<br><br>Veuillez les installer, ou <a href="%2$s?step=0;lang=english">Essayez la version Anglaise</a>.';
$txt['error_upgrade_files_missing'] = 'L\'outil de mise à jour n\'a pas pu trouver certains fichiers cruciaux.<br><br>Veuillez vous assurer d\'avoir téléchargé tous les fichiers inclus dans le paquet, y compris les répertoires Themes, Sources, et autres.';
$txt['error_upgrade_old_files'] = 'L\'outil de mise à jour a trouvé des fichiers anciens ou obsolètes.<br><br>Veuillez vous assurer d\'avoir téléchargé les nouvelles versions de tous les fichiers inclus dans le paquet.';
$txt['error_upgrade_old_lang_files'] = 'L\'outil de mise à jour a trouvé des fichiers de langage anciens ou obsolètes pour la langue sélectionnée, %1$s.<br><br>Veuillez vous assurer de télécharger les nouvelles versions de tous les fichiers inclus dans le paquet, même les fichiers du thème par défaut.<br>&nbsp;&nbsp;&nbsp ;[<a href="%2$s?skiplang">IGNORER</a>] [<a href="%2$s?lang=english">Essayez en Anglais</a>]';
$txt['error_php_too_low'] = 'Attention&nbsp;! Il semblerait que votre serveur ne contienne pas une version de PHP compatible avec <strong>les exigeances minimales requises</strong> de SMF.<br><br>Vous devrez demander à votre hébergeur d\'effectuer une mise à jour.';
$txt['error_db_too_low'] = 'La version %1$s de votre serveur de base de données est très ancienne, et ne répond pas aux besoins d\'SMF.<br><br>Veuillez contacter votre hébergeur pour qu\'il le mette à jour ou vous en fournisse un nouveau, et s\'il ne veut pas, essayez chez un autre hébergeur.';
$txt['error_db_privileges'] = 'L\'utilisateur %1$s que vous avez défini dans Settings.php n\'a pas les privilèges appropriés.<br><br>Veuillez demander à votre hôte de lui donner les privilèges ALTER, CREATE, et DROP.';
$txt['error_dir_not_writable'] = 'Le répertoire&nbsp;: %1$s doit être accessible en écriture pour continuer la mise à jour. Veuillez vous assurer que les permissions sont correctement paramétrées pour que cela soit permis.';
$txt['error_cache_not_found'] = 'Le répertoire cache n\'a pas pu être trouvé.<br><br>Veuillez vous assurer que vous avez un répertoire appelé &quot;cache&quot ; dans le répertoire de votre forum avant de continuer.';
$txt['error_agreement_not_writable'] = 'Si vous utilisez un serveur Linux ou Unix, veuillez vous assurer que le fichier agreement.txt a un chmod de 777, ou s\'il n\'existe pas que le répertoire dans lequel se trouve l\'outil de mise à jour a un chmod de 777.<br>Si votre serveur est sous Windows, veuillez vous assurer que le compte invité Internet a bien les permissions appropriées sur ce fichier ou sur son répertoire.';
$txt['error_not_admin'] = 'Vous devez être un administrateur pour effectuer une mise à jour&nbsp;!';

$txt['warning_lang_old'] = 'Les fichiers de langage pour la langue sélectionnée, %1$s, n\'ont pas été mis à jour vers la dernière version. La mise à jour se poursuivra avec le langage par défaut du forum, %2$s.';
$txt['warning_lang_missing'] = 'L\'outil de mise à jour n\'a pas pu trouver le fichier &quot;Install&quot; pour la langue sélectionnée, %1$s. La mise à jour se poursuivra avec la langue par défaut du forum, %2$s.';

// Attachment & Avatar folder checks
$txt['warning_av_missing'] = 'Attention ! Répertoire des Avatars non trouvé. Continuer peut être dangereux. Veuillez confirmer les réglages du dossier avant de continuer.';
$txt['warning_custom_av_missing'] = 'Attention ! Répertoire personnalisé des Avatars non trouvé. Continuer peut être dangereux. Veuillez confirmer les réglages du dossier avant de continuer.';
$txt['warning_att_dir_missing'] = 'Attention ! Un ou plusieurs répertoires pièce jointe non trouvés. Continuer peut être dangereux. Veuillez confirmer les réglages du dossier avant de continuer.';

// Page titles
$txt['updating_smf_installation'] = 'Mise à Jour de Votre Installation SMF&nbsp;!';
$txt['upgrade_options'] = 'Options de Mise à Jour';
$txt['backup_database'] = 'Sauvegarde de la Base de Données';
$txt['database_changes'] = 'Modifications de la Base de Données';
$txt['upgrade_complete'] = 'Mise à Jour Effectuée';
$txt['converting_utf8'] = 'Conversion en UTF8';
$txt['converting_json'] = 'Conversion en JSON';

?>