<?php
// Version: 2.1.5; index

global $forum_copyright, $webmaster_email, $scripturl, $context, $boardurl;

// Native name, please use full HTML entities to write your language's name.
$txt['native_name'] = 'Português Europeu';

// Locale (strftime, basename). For more information see:
//   - https://php.net/function.setlocale
$txt['lang_locale'] = 'pt_PT';
$txt['lang_dictionary'] = 'pt';
//https://developers.google.com/recaptcha/docs/language
$txt['lang_recaptcha'] = 'pt';

// Ensure you remember to use uppercase for character set strings.
$txt['lang_character_set'] = 'UTF-8';
// Character set right to left?  0 = ltr; 1 = rtl
$txt['lang_rtl'] = '0';
// Number format.
$txt['number_format'] = '1.234,00';

$txt['days_title'] = 'Dias';
$txt['days'] = array('Domingo', 'Segunda-feira', 'Terça-feira', 'Quarta-feira', 'Quinta-feira', 'Sexta-feira', 'Sábado');
$txt['days_short'] = array('Dom', 'Seg', 'Ter', 'Qua', 'Qui', 'Sex', 'Sáb');
// Months must start with 1 => 'January'. (or translated, of course.)
$txt['months_title'] = 'Meses';
$txt['months'] = array(1 => 'Janeiro', 2 => 'Fevereiro', 3 => 'Março', 4 => 'Abril', 5 => 'Maio', 6 => 'Junho', 7 => 'Julho', 8 => 'Agosto', 9 => 'Setembro', 10 => 'Outubro', 11 => 'Novembro', 12 => 'Dezembro');
$txt['months_titles'] = array(1 => 'Janeiro', 2 => 'Fevereiro', 3 => 'Março', 4 => 'Abril', 5 => 'Maio', 6 => 'Junho', 7 => 'Julho', 8 => 'Agosto', 9 => 'Setembro', 10 => 'Outubro', 11 => 'Novembro', 12 => 'Dezembro');
$txt['months_short'] = array(1 => 'Mar', 2 => 'Fevb', 3 => 'Mar', 4 => 'Abr', 5 => 'Mai', 6 => 'Jun', 7 => 'Jul', 8 => 'Ago', 9 => 'Set', 10 => 'Out', 11 => 'Nov', 12 => 'Dez');
$txt['prev_month'] = 'Mês anterior';
$txt['next_month'] = 'Mês seguinte';
$txt['start'] = 'Começo';
$txt['end'] = 'Final';
$txt['starts'] = 'Começa';
$txt['ends'] = 'Acaba';
$txt['none'] = 'Nada';

$txt['minutes_label'] = 'Minutos';
$txt['hours_label'] = 'Horas';
$txt['years_title'] = 'Anos';

$txt['time_am'] = 'am';
$txt['time_pm'] = 'pm';

// Short form of minutes
$txt['minutes_short'] = 'mins';
// Short form of hour
$txt['hour_short'] = 'hr';
// Short form of hours
$txt['hours_short'] = 'hrs';
// Decimal sign
$txt['decimal_sign'] = ',';

$txt['admin'] = 'Administração';
$txt['moderate'] = 'Moderação';

$txt['save'] = 'Guardar';
$txt['reset'] = 'Redefinir';
$txt['upload'] = 'Enviar';
$txt['upload_all'] = 'Enviar tudo';
$txt['processing'] = 'A processar...';

$txt['modify'] = 'Modificar';
$txt['forum_index'] = '%1$s - Índice';
$txt['members'] = 'Membros';
$txt['board_name'] = 'Nome do quadro';
$txt['posts'] = 'Mensagens';

$txt['member_postcount'] = 'Mensagens';
$txt['no_subject'] = '(Sem assunto)';
$txt['view_profile'] = 'Ver perfil';
$txt['guest_title'] = 'Visitante';
$txt['author'] = 'Autor';
$txt['on'] = 'em';
$txt['remove'] = 'Remover';
$txt['start_new_topic'] = 'Começar novo tópico';

$txt['login'] = 'Entrar';
// Use numeric entities in the below string.
$txt['username'] = 'Nome de utilizador';
$txt['password'] = 'Palavra-passe';

$txt['username_no_exist'] = 'Esse nome de utilizador não existe.';
$txt['no_user_with_email'] = 'Não existem nomes de utilizador associados a esse email.';

$txt['board_moderator'] = 'Moderador do quadro';
$txt['remove_topic'] = 'Remover tópico';
$txt['topics'] = 'Tópicos';
$txt['modify_msg'] = 'Modificar mensagem';
$txt['name'] = 'Nome';
$txt['email'] = 'email';
$txt['user_email_address'] = 'Endereço de email';
$txt['subject'] = 'Assunto';
$txt['message'] = 'Mensagem';
$txt['redirects'] = 'Redirecionamentos';
$txt['quick_modify'] = 'Modificar em linha';
$txt['quick_modify_message'] = 'Modificou esta mensagem com sucesso.';
$txt['reason_for_edit'] = 'Motivo para a edição';

$txt['choose_pass'] = 'Escolher senha';
$txt['verify_pass'] = 'Verificar a senha';
$txt['notify_announcements'] = 'Permite aos administradores enviar-me notícias importantes por e-mail';

$txt['position'] = 'Posição';

// argument(s): username
$txt['view_profile_of_username'] = 'A ver o perfil de %1$s';
$txt['total'] = 'Total';
$txt['website'] = 'Site';
$txt['register'] = 'Registe-se';
$txt['warning_status'] = 'Estado de advertência';
$txt['user_warn_watch'] = 'O utilizador está na lista de observação dos moderadores';
$txt['user_warn_moderate'] = 'As mensagens do utilizador juntam-se à lista de aprovação';
$txt['user_warn_mute'] = 'O utilizador está impedido de colocar mensagens';
$txt['warn_watch'] = 'Observado';
$txt['warn_moderate'] = 'Moderado';
$txt['warn_mute'] = 'Silenciado';

$txt['message_index'] = 'Índice de mensagens';
$txt['news'] = 'Editar as notícias';
$txt['home'] = 'Início';
$txt['page'] = 'Página';
$txt['prev'] = 'Página anterior';
$txt['next'] = 'Página seguinte';

$txt['lock_unlock'] = 'Trancar/Destrancar tópico';
$txt['post'] = 'Enviar Mensagem';
$txt['error_occured'] = 'Ocorreu um erro';
$txt['at'] = 'em';
$txt['by'] = 'por';
$txt['logout'] = 'Desconectar';
$txt['started_by'] = 'Iniciado por';
$txt['topic_started_by'] = 'Iniciado por <strong>%1$s</strong> em <em>%2$s</em>';
$txt['replies'] = 'Respostas';
$txt['last_post'] = 'Última Mensagem';
$txt['first_post'] = 'Primeira mensagem';
$txt['last_poster'] = 'Última mensagem por';
$txt['last_post_message'] = '<strong>Última mensagem: </strong>%3$s <span class="postby">%2$s por %1$s</span>';
$txt['last_post_topic'] = '%1$s<br>por %2$s';
$txt['post_by_member'] = '<strong>%1$s</strong> por <strong>%2$s</strong><br>';
$txt['boardindex_total_posts'] = '%1$s mensagens em %2$s Tópicos por %3$s membros';
$txt['show'] = 'Mostrar';
$txt['hide'] = 'Esconder';

$txt['admin_login'] = 'Login da administração';
// Use numeric entities in the below string.
$txt['topic'] = 'Tópico';
$txt['help'] = 'Ajuda';
$txt['terms_and_rules'] = 'Termos e regras';
$txt['watch_board'] = 'Vigiar este quadro';
$txt['unwatch_board'] = 'Parar de vigiar este quadro';
$txt['watch_topic'] = 'Vigiar este tópico';
$txt['unwatch_topic'] = 'Parar de vigiar este este tópico';
$txt['watching_topic'] = 'Tópico que está a vigiar';
$txt['watching_this_topic'] = 'Está a vigiar este tópico e irá receber notificações.';
$txt['notify'] = 'Notificar';
$txt['unnotify'] = 'Não notificar';

// Use numeric entities in the below string.
// argument(s): forum name
$txt['regards_team'] = 'Cumprimentos,
A equipa %1$s.';

$txt['notify_replies'] = 'Notificar de respostas';
$txt['move_topic'] = 'Mover tópico';
$txt['move_to'] = 'Mover para';
$txt['pages'] = 'Páginas';
$txt['users_active'] = 'Utilizadores ativos nos últimos %1$d minutos';
$txt['personal_messages'] = 'Mensagens Pessoais';
$txt['reply_quote'] = 'Responder com citação';
$txt['reply'] = 'Responder';
$txt['reply_noun'] = 'Responder';
$txt['reply_number'] = 'Responder #%1$s%2$s';
$txt['approve'] = 'Aprovar';
$txt['unapprove'] = 'Rejeitar';
$txt['approve_all'] = 'aprovar tudo';
$txt['issue_warning'] = 'Dar advertência';
$txt['awaiting_approval'] = 'À espera de aprovação';
$txt['attach_awaiting_approve'] = 'Anexos à espera de aprovação';
$txt['post_awaiting_approval'] = 'Esta mensagem está à espera de aprovação por parte de um moderador.';
$txt['there_are_unapproved_topics'] = 'Há %1$s tópicos e %2$s mensagens À espera de aprovação neste quadro. Clique <a href="%3$s">aqui</a> para ver tudo.';
$txt['send_message'] = 'Enviar mensagem';

$txt['msg_alert_no_messages'] = 'Não tem nenhuma mensagem';
$txt['msg_alert_one_message'] = 'tem <a href="%1$s">1 mensagem</a>';
$txt['msg_alert_many_message'] = 'tem <a href="%1$s">%2$d mensagens</a>';
$txt['msg_alert_one_new'] = '1 é nova';
$txt['msg_alert_many_new'] = '%1$d são novas';
$txt['new_alert'] = 'Novo alerta';
$txt['remove_message'] = 'Remover esta mensagem';
$txt['remove_message_question'] = 'Remove esta mensagem?';

$txt['topic_alert_none'] = 'Sem mensagens...';
$txt['pm_alert_none'] = 'Sem mensagens...';
$txt['no_messages'] = 'Sem mensagens';

$txt['online_users'] = 'Utilizadores online';
$txt['jump_to'] = 'Saltar para';
$txt['go'] = 'Ir';
$txt['are_sure_remove_topic'] = 'Tem certeza de que quer remover este tópico?';
$txt['yes'] = 'Sim';
$txt['no'] = 'Não';

$txt['search_end_results'] = 'Fim dos resultados';
$txt['search_on'] = 'em';

$txt['search'] = 'Pesquisar';
$txt['all'] = 'Tudo';
$txt['search_entireforum'] = 'O fórum inteiro';
$txt['search_thisboard'] = 'Este quadro';
$txt['search_thistopic'] = 'Este tópico';
$txt['search_members'] = 'Membros';

$txt['back'] = 'Voltar';
$txt['continue'] = 'Continuar';
$txt['password_reminder'] = 'Lembrar senha';
$txt['topic_started'] = 'Tópico começado por';
$txt['title'] = 'Título';
$txt['post_by'] = 'Mensagem de';
$txt['memberlist_searchable'] = 'Lista pesquisável de todos os membros registados.';
$txt['welcome_newest_member'] = 'Por favor, dEEm as boas vindas a %1$s, o nosso membro mais recente.';
$txt['admin_center'] = 'Centro de Administração';
$txt['last_edit_by'] = '<span class="lastedit">Última edição</span>: %1$s por %2$s';
$txt['last_edit_reason'] = '<span id="reason" class="lastedit">Motivo</span>: %1$s';
$txt['notify_deactivate'] = 'Quer desativar as notificações neste tópico?';
$txt['modified_time'] = 'Última edição';
$txt['modified_by'] = 'Editado por';

$txt['recent_posts'] = 'Mensagens recentes';

$txt['location'] = 'Localização';
$txt['location_desc'] = 'localização geográfica.';
$txt['gender'] = 'Género';
$txt['gender_0'] = 'Nenhum';
$txt['gender_1'] = 'Masculino';
$txt['gender_2'] = 'Feminino';
$txt['gender_desc'] = 'O seu género.';
$txt['icq'] = 'ICQ';
$txt['icq_desc'] = 'O seu número do ICQ.';
$txt['skype'] = 'Skype';
$txt['skype_desc'] = 'O seu nome de utilizador no Skype';
$txt['personal_text'] = 'Texto pessoal';
$txt['date_registered'] = 'Datea de registo';

$txt['recent_view'] = 'A ver as mensagens mais recentes do fórum.';
$txt['recent_updated'] = 'é o tópico atualizado mais recentemente';
$txt['is_recent_updated'] = '%1$s é o tópico atualizado mais recentemente';

$txt['male'] = 'Masculino';
$txt['female'] = 'Feminino';

$txt['error_invalid_characters_username'] = 'Caractere inválido usado no nome de utilizador.';

// argument(s): forum name, login URL, login JavaScript snippet
$txt['welcome_guest'] = 'Bem-vindo ao <strong>%1$s</strong>. Por favor, <a href="%2$s" onclick="%3$s">faça o login</a>.';

// argument(s): forum name, login URL, login JavaScript snippet, signup URL
$txt['welcome_guest_register'] = 'Bem-vindo ao <strong>%1$s</strong>. Por favor,  <a href="%2$s" onclick="%3$s">faça o login</a> ou <a href="%4$s">registe-se</a>.';

// argument(s): $scripturl
$txt['welcome_guest_activate'] = '<a href="%1$s?action=activate">Perdeu o seu e-mail de ativação?</a>';

// argument(s): $scripturl
$txt['register_prompt'] = 'Não tem uma conta? <a href="%1$s?action=signup">Registe-se</a>.';

// argument(s): forum name
$txt['welcome_to_forum'] = 'Bem-vindo ao <strong>%1$s</strong>.';

// @todo the following to sprintf
$txt['hello_member'] = 'Olá';
// Use numeric entities in the below string.
$txt['hello_guest'] = 'Bem-vindo,';
$txt['select_destination'] = 'Por favor, selecione um destino';

// Escape any single quotes in here twice.. 'it\'s' -> 'it\\\'s'.
$txt['posted_by'] = 'Colocado por';

$txt['icon_smiley'] = 'Sorridente';
$txt['icon_angry'] = 'Zangado';
$txt['icon_cheesy'] = 'Contente';
$txt['icon_laugh'] = 'Riso';
$txt['icon_sad'] = 'Triste';
$txt['icon_wink'] = 'Piscar';
$txt['icon_grin'] = 'Sorriso';
$txt['icon_shocked'] = 'Chocado';
$txt['icon_cool'] = 'Fixe';
$txt['icon_huh'] = 'Hein';
$txt['icon_rolleyes'] = 'Rolar os olhos';
$txt['icon_tongue'] = 'Língua';
$txt['icon_embarrassed'] = 'Embaraçado';
$txt['icon_lips'] = 'Lábios selados';
$txt['icon_undecided'] = 'Indeciso';
$txt['icon_kiss'] = 'Beijo';
$txt['icon_cry'] = 'Chorar';

$txt['moderator'] = 'Moderador';
$txt['moderators'] = 'Moderadores';

$txt['views'] = 'Visualizações';
$txt['new'] = 'Novo';

$txt['view_all_members'] = 'Ver todos os membros';
$txt['view'] = 'Ver';

$txt['viewing_members'] = 'A ver os membros de %1$s a %2$s';
$txt['of_total_members'] = 'de um total de %1$s membros';

$txt['forgot_your_password'] = 'Esqueceu a sua senha?';

$txt['date'] = 'Data';
// Use numeric entities in the below string.
$txt['from'] = 'De';
$txt['check_new_messages'] = 'Verificar novas mensagens';
$txt['to'] = 'A';

$txt['board_topics'] = 'Tópicos';
$txt['members_title'] = 'Membros';
$txt['members_list'] = 'Lista de membros';
$txt['new_posts'] = 'Novas mensagens';
$txt['old_posts'] = 'Sem novas mensagens';
$txt['redirect_board'] = 'Quadro de redireccionamento';

$txt['sendtopic_send'] = 'Enviar';
$txt['report_sent'] = 'O seu relatório foi enviado com sucesso.';
$txt['post_becomes_unapproved'] = 'A sua mensagem não foi aprovada porque foi colocada num tópico não aprovado. Uma vez que o tópico seja aprovado, a sua mensagem também será aprovada.';

$txt['time_offset'] = 'Horas';
$txt['or'] = 'ou';

$txt['no_matches'] = 'Desculpe, nenhuma correspondência foi encontrada';

$txt['notification'] = 'Notificação';

$txt['your_ban'] = 'Desculpa %1$s, mas foi banido de usar este fórum!';
$txt['your_ban_expires'] = 'Este banimento expira em %1$s.';
$txt['your_ban_expires_never'] = 'Este banimento não tem expiração.';
$txt['ban_continue_browse'] = 'Pode continuar a navegar no fórum como visitante.';

$txt['mark_as_read'] = 'Marcar TODAS as mensagens como lidas';

$txt['locked_topic'] = 'Tópico trancado';
$txt['normal_topic'] = 'Tópico normal';
$txt['participation_caption'] = 'Tópicos em que participou';
$txt['moved_topic'] = 'Tópico movido';

$txt['go_caps'] = 'IR';

$txt['print'] = 'Imprimir';
$txt['profile'] = 'Perfil';
$txt['topic_summary'] = 'Sumário de tópicos';
$txt['not_applicable'] = 'N/D';
$txt['name_in_use'] = 'Este nome já está a ser usado por outro membro.';

$txt['total_members'] = 'Total de membros';
$txt['total_posts'] = 'Total de mensagens';
$txt['total_topics'] = 'Total de tópicos';

$txt['time_logged_in'] = 'Tempo para ficar conectado';

$txt['preview'] = 'Prever';
$txt['always_logged_in'] = 'Sempre';

$txt['logged'] = 'Registado';
$txt['show_ip'] = 'Mostrar endereço IP';
// Use numeric entities in the below string.
$txt['ip'] = 'IP';
$txt['url'] = 'URL';
$txt['www'] = 'WWW';

$txt['hours'] = 'horas';
$txt['minutes'] = 'minutos';
$txt['seconds'] = 'segundos';

// Used upper case in Paid subscriptions management
$txt['hour'] = 'Hora';
$txt['days_word'] = 'dias';

$txt['search_for'] = 'Procurar por';
$txt['search_match'] = 'Correspondência';

$txt['forum_in_maintenance'] = 'O seu fórum está em modo de manutenção. Apenas administradores podem fazer login';
$txt['maintenance_page'] = 'Pode desligar o modo de manutenção através da área de <a href="%1$s">Configuração do servidor</a>.';

$txt['read_one_time'] = 'Lido 1 vez';
$txt['read_many_times'] = 'Lido %1$d vezes';

$txt['forum_stats'] = 'Estatísticas do fórum';
$txt['latest_member'] = 'Último membro';
$txt['total_cats'] = 'Número de categorias';
$txt['latest_post'] = 'Última mensagem';

$txt['total_boards'] = 'Número de Quadros';

$txt['print_page'] = 'Imprimir página';
$txt['print_page_text'] = 'Apenas texto';
$txt['print_page_images'] = 'Texto com imagens';

$txt['valid_email'] = 'Tem de ser um endereço de email válido.';

$txt['geek'] = 'Sou um geek!!';
$txt['info_center_title'] = '%1$s - Centro de Informação';

$txt['watch'] = 'Observar';
$txt['unwatch'] = 'Parar de observar';

$txt['check_all'] = 'Selecionar tudo';

// Use numeric entities in the below string.
$txt['database_error'] = 'Erro da base de dados';
$txt['try_again'] = 'Por favor, tente novamente. Se voltar a ver este erro, informe o administrador.';
$txt['file'] = 'Ficheiro';
$txt['line'] = 'Linha';
// Use numeric entities in the below string.
$txt['tried_to_repair'] = 'O SMF detetou e tentou automaticamente reparar um erro na sua base de dados. Se continuar a ter problemas, ou continuar a receber estes emails, por favor contacte o seu servidor de hospedagem.';
$txt['database_error_versions'] = '<strong>Nota:</strong> Parece que a sua base de dados <em>pode</em> precisar de uma atualização. Os ficheiros do seu fórum estão atualmente na versão %1$s, enquanto a sua base de dados está na versão %2$s. O erro abaixo pode ser possível de fazer desaparecer se executar a última versão do upgrade.php.';
$txt['template_parse_error'] = 'Erro de template!';
$txt['template_parse_error_message'] = 'Parece que algo se passou no fórum com o sistema de templates. O problema deve ser temporário, por isso volte mais tarde e tente novamente. Se continuar a ver esta mensagem, por favor contate o administrador.<br><br>Também pode tentar <a href="javascript:location.reload();">atualizar esta página</a>.';
// argument(s): filename, $boardurl, $scripturl
$txt['template_parse_error_details'] = 'Houve um problema a carregar a template <pre><strong>%1$s</strong></pre> ou o ficheiro de idioma. Por favor, verifique a sintaxe e tente novamente - lembre-se, apóstrofes (<pre>\'</pre>) muitas vezes têm de ser comentadas com uma barra(<pre>\\</pre>). Para ver mais sobre o erro específico informado pelo PHP, tente <a href="%2$s%1$s">aceder diretamente ao ficheiro</a>.<br><br>Também pode tentar <a href="javascript:location.reload();">atualizar esta página</a> ou mudar para o <a href="%3$s?theme=1">tema padrão</a>.';
$txt['template_parse_errmsg'] = 'Infelizmente não existe mais informação disponível sobre o que está errado neste momento.';

$txt['today'] = '<strong>Hoje</strong> at ';
$txt['yesterday'] = '<strong>Ontem</strong> às ';
$txt['new_poll'] = 'Nova sondagem';
$txt['poll_question'] = 'Questão';
$txt['poll_vote'] = 'Submeter voto';
$txt['poll_total_voters'] = 'Número de membros que votaram';
$txt['poll_results'] = 'Ver resultados';
$txt['poll_lock'] = 'Trancar votação';
$txt['poll_unlock'] = 'Destrancar votação';
$txt['poll_edit'] = 'Editar votação';
$txt['poll'] = 'Votação';
$txt['one_hour'] = '1 Hora';
$txt['one_day'] = '1 Dia';
$txt['one_week'] = '1 Semana';
$txt['two_weeks'] = '2 Semanas';
$txt['one_month'] = '1 Mês';
$txt['two_months'] = '2 Meses';
$txt['forever'] = 'Sempre';
$txt['moved'] = 'MOVIDO';
$txt['move_why'] = 'Por favor, coloque uma pequena descrição para <br>a razão deste tópico ter sido movido.';
$txt['board'] = 'Quadro';
$txt['in'] = 'em';
$txt['sticky_topic'] = 'Tópico fixo';

$txt['delete'] = 'Apagar';
$txt['no_change'] = 'Sem mudança';

$txt['your_pms'] = 'As suas mensagesn pessoais';

$txt['kilobyte'] = 'Kb';
$txt['megabyte'] = 'MB';

$txt['more_stats'] = '[MAis estatísticas]';

// Use numeric entities in the below three strings.
$txt['code'] = 'Código';
$txt['code_select'] = 'Selecionar';
$txt['code_expand'] = 'Expandir';
$txt['code_shrink'] = 'Encolher';
$txt['quote_from'] = 'Citação de';
$txt['quote'] = 'Citação';
$txt['quote_action'] = 'Citação';
$txt['quote_selected_action'] = 'Citar o texto selecionado';
$txt['fulledit'] = 'Edição&nbsp;completa';
$txt['edit'] = 'Editar';
$txt['quick_edit'] = 'Edição rápida';
$txt['post_options'] = 'Mais...';

$txt['merge_to_topic_id'] = 'ID do tópico alvo';
$txt['split'] = 'Dividir tópico';
$txt['merge'] = 'Unir tópicos';
$txt['target_id'] = 'Selecionar o alvo pelo ID do tópico';
$txt['target_below'] = 'Selecionar o alvo pela lista abaixo';
$txt['subject_new_topic'] = 'Assunto para o novo tópico';
$txt['split_this_post'] = 'Dividir apenas esta mensagem.';
$txt['split_after_and_this_post'] = 'Dividir o tópico a seguir incluindo esta mensagem.';
$txt['select_split_posts'] = 'Selecionar mensagens a dividir.';
$txt['new_topic'] = 'Novo tópico';
$txt['split_successful'] = 'Tópico dividido com sucesso.';
$txt['origin_topic'] = 'Tópico original';
$txt['please_select_split'] = 'Por favor, selecione as mensagens que quer dividir.';
$txt['merge_successful'] = 'Tópicos unidos com sucesso.';
$txt['new_merged_topic'] = 'Novo tópico unido';
$txt['topic_to_merge'] = 'Tópico a ser unido';
$txt['target_board'] = 'Quadro alvo';
$txt['target_topic'] = 'Tópico alvo';
$txt['merge_desc'] = 'Esta função irá unir as mensagens dos dois tópico num único tópico. As mensagens serão dispostas consoante a hora em que foram feitas. Portanto, a mensagem mais recente será a primeira mensagem do tópico.';

$txt['set_sticky'] = 'Fixar tópico';
$txt['set_nonsticky'] = 'Desafixar tópico';
$txt['set_lock'] = 'Trancar tópico';
$txt['set_unlock'] = 'Destrancar tópico';

$txt['search_advanced'] = 'Pesquisa avançada';

$txt['security_risk'] = 'RISCO DE SEGURANÇA:';
$txt['not_removed'] = 'Não removeu o ';
$txt['not_removed_extra'] = '%1$s é uma cópia de segurança de %2$s que não foi gerada pelo SMF. Pode ser acedida diretamente e usada para ganhar acesso não autorizado ao seu fórum. Deve eliminar o ficheiro imediatamente.';
$txt['generic_warning'] = 'Aviso';
$txt['agreement_missing'] = 'Está a exigir que os novos utilizadores aceitem um acordo de registo, contudo o ficheiro (agreement.txt) não existe.';
$txt['policy_agreement_missing'] = 'Está a exigir que os novos utilizadores aceitem a política de privacidade. Contudo, a política de privacidade está vazia.';
$txt['auth_secret_missing'] = 'Incapaz de definir o segredo de autenticação no Settings.php. Isto enfraquece a segurança do seu fórum e coloca-o em risco de ataques. Verifique as permissões de ficheiros no Settings.php para ter a certeza de que o SMF pode alterar o ficheiro.';

$txt['cache_writable'] = 'O diretório da cache não tem permissão de escrita - isto irá afetar adversamente o desempenho do seu fórum.';

$txt['page_created_full'] = 'Página criada em %1$.3f segundos com %2$d solicitações.';

$txt['report_to_mod_func'] = 'Use esta função para informar os moderadores e administradores de mensagens problemáticas ou abusivas.';
$txt['report_profile_func'] = 'Use esta função para informar administradores de conteúdo abusivo no perfil, como spam ou umagens inapropriadas.';

$txt['online'] = 'Online';
$txt['member_is_online'] = '%1$s está online';
$txt['offline'] = 'Offline';
$txt['member_is_offline'] = '%1$s está offline';
$txt['pm_online'] = 'Mesagem pessoal (Online)';
$txt['pm_offline'] = 'Mesagem pessoal (Offline)';
$txt['status'] = 'EStado';

$txt['go_up'] = 'Ir para o topo';
$txt['go_down'] = 'Ir para o fundo';

// argument(s): SMF_FULL_VERSION, SMF_SOFTWARE_YEAR, $scripturl
$forum_copyright = '<a href="%3$s?action=credits" title="Licença" target="_blank" rel="noopener">%1$s &copy; %2$s</a>, <a href="https://www.simplemachines.org" title="Simple Machines" target="_blank" rel="noopener">Simple Machines</a>';

$txt['birthdays'] = 'Aniversários:';
$txt['events'] = 'Eventos:';
$txt['birthdays_upcoming'] = 'Próximos aniversários:';
$txt['events_upcoming'] = 'Próximos eventos:';
// Prompt for holidays in the calendar, leave blank to just display the holiday's name.
$txt['calendar_prompt'] = 'Feriados:';
$txt['calendar_month'] = 'Mês';
$txt['calendar_year'] = 'Ano';
$txt['calendar_day'] = 'Dia';
$txt['calendar_event_title'] = 'Título do evento';
$txt['calendar_event_options'] = 'Opções do evento';
$txt['calendar_post_in'] = 'Colocar em';
$txt['calendar_edit'] = 'Editar evento';
$txt['calendar_export'] = 'Exportar evento';
$txt['calendar_view_week'] = 'Ver semana';
$txt['event_delete_confirm'] = 'Apagar este evento?';
$txt['event_delete'] = 'Apagar evento';
$txt['calendar_post_event'] = 'Colocar evento';
$txt['calendar'] = 'Calendário';
$txt['calendar_link'] = 'Ligação para o calendário';
$txt['calendar_upcoming'] = 'Próximo calendário';
$txt['calendar_today'] = 'Calendário de hoje';
$txt['calendar_week'] = 'Semana';
$txt['calendar_week_title'] = 'Semana %1$d de %2$d ';
// %1$s is the month, %2$s is the day, %3$s is the year. Change to suit your language.
$txt['calendar_week_beginning'] = 'Semana começa a %1$s %2$s, %3$s';
$txt['calendar_numb_days'] = 'Número de dias';
$txt['calendar_how_edit'] = 'como edita estes eventos?';
$txt['calendar_link_event'] = 'Ligar evento a mensagem';
$txt['calendar_confirm_delete'] = 'Tem a certeza de que quer apagar este evento?';
$txt['calendar_linked_events'] = 'Eventos ligados';
$txt['calendar_click_all'] = 'clique para ver todos %1$s';
$txt['calendar_allday'] = 'Todo o dia';
$txt['calendar_timezone'] = 'Fuso horário';
$txt['calendar_list'] = 'Lista';
$txt['calendar_empty'] = 'Não há eventos para mostrar.';

$txt['movetopic_change_subject'] = 'Mudar o assunto do tópico';
$txt['movetopic_new_subject'] = 'Novo assunto';
$txt['movetopic_change_all_subjects'] = 'Mudar o assunto de todas as mensagens';
$txt['move_topic_unapproved_js'] = 'Atenção! Este tópico ainda não foi aprovado.\n\nNão é recomendado que crie um tópico de redireccionamento a não ser que tenha intenção de aprovar imediatamente após movê-lo.';
$txt['movetopic_auto_board'] = '[QUADRO]';
$txt['movetopic_auto_topic'] = '[TÓPICO]';

// argument(s): $txt['movetopic_auto_board'], $txt['movetopic_auto_topic']
$txt['movetopic_default'] = 'Este tópico foi movido para %1$s.

%2$s';

$txt['movetopic_redirect'] = 'Redirecionar para o novo tópico';

$txt['post_redirection'] = 'Criar um tópico de redireccionamento';
$txt['redirect_topic_expires'] = 'Remover atomaticamente o tópico de redireccionamento';
$txt['mergetopic_redirect'] = 'Redirecionar para o tópico unido';
$txt['merge_topic_unapproved_js'] = 'Atenção! Este tópico ainda não foi aprovado.\n\nNão é recomendado que crie um tópico de redireccionamento a não ser que tenha intenção de aprovar imediatamente após a união.';

$txt['theme_template_error'] = 'Incapaz de carregar a template \'%1$s\'.';
$txt['theme_language_error'] = 'Incapaz de carregar o ficheiro de idioma \'%1$s\'';

$txt['sub_boards'] = 'Sub-quadros';
$txt['restricted_board'] = 'Quadro restrito';

$txt['smtp_no_connect'] = 'Não se consegue ligar ao servidor SMTP';
$txt['smtp_port_ssl'] = 'A porta SMTP definida está incorreta. Deve ser 465 para servidor com SSL. O servidor pode precisar do prefixo ssl://.';
$txt['smtp_bad_response'] = 'Não consegue receber os códigos de resposta do servidor de e-mail';
$txt['smtp_error'] = 'Teve um problema ao enviar e-mail. Erro: ';
$txt['mail_send_unable'] = 'Não foi capaz de enviar email para o endereço \'%1$s\'';

$txt['mlist_search'] = 'Pesquisar por membros';
$txt['mlist_search_again'] = 'Pesquisar outra vez';
$txt['mlist_search_filter'] = 'Opções de pesquisa';
$txt['mlist_search_email'] = 'Pesquisar por endereço de e-mail';
$txt['mlist_search_messenger'] = 'Pesquisar por nickname do messenger';
$txt['mlist_search_group'] = 'Pesquisar por posição';
$txt['mlist_search_name'] = 'Pesquisar por nome';
$txt['mlist_search_website'] = 'Pesquisar por website';
$txt['mlist_search_results'] = 'Resultados da pesquisa por';
$txt['mlist_search_by'] = 'Pesquisa por %1$s';
$txt['mlist_menu_view'] = 'Ver a lista de membros';

$txt['attach_downloaded'] = 'descarregado %1$d vezes';
$txt['attach_viewed'] = 'visto %1$d vezes';

$txt['settings'] = 'Configurações';
$txt['never'] = 'Nunca';
$txt['more'] = 'mais';
$txt['etc'] = 'etc.';

$txt['hostname'] = 'Nome do servidor';
$txt['you_are_post_banned'] = 'Desculpe %1$s, mas foi banido de colocar mensagens e enviar mensagens pessoais neste fórum.';
$txt['ban_reason'] = 'Razão';
$txt['select_item_check'] = 'Por favor, selecione pelo menos um item da lista';

$txt['tables_optimized'] = 'Tabelas da base de dados otimizadas';

$txt['add_poll'] = 'Adicionar sondagem';
$txt['poll_options_limit'] = 'Só pode selecionar %1$s opções.';
$txt['poll_remove'] = 'Remover sondagem';
$txt['poll_remove_warn'] = 'Tem certeza de que quer remover esta sondagem do tópico?';
$txt['poll_results_expire'] = 'Os resultados serão mostrados quando a sondagem estiver fechada';
$txt['poll_expires_on'] = 'Sondagem fecha';
$txt['poll_expired_on'] = 'Sondagem fechada';
$txt['poll_change_vote'] = 'Removee voto';
$txt['poll_return_vote'] = 'Opções de voto';
$txt['poll_cannot_see'] = 'Não pode ver os resultado da sondagem neste momento.';

$txt['quick_mod_approve'] = 'Aprovar selecionados';
$txt['quick_mod_remove'] = 'Apagar os selecionados';
$txt['quick_mod_lock'] = 'Trancar/Destrancar selecionados';
$txt['quick_mod_sticky'] = 'Fixar/Desafixar selecionados';
$txt['quick_mod_move'] = 'Mover selecionados para';
$txt['quick_mod_merge'] = 'Unir selecionados';
$txt['quick_mod_markread'] = 'Marcar os selecionados como lidos';
$txt['quick_mod_markunread'] = 'Marcar os selecionados como não lidos';
$txt['quick_mod_selected'] = 'Com as opções selecionadas';
$txt['quick_mod_go'] = 'Ir';
$txt['quickmod_confirm'] = 'Tem certeza de que quer fazer isto?';

$txt['spell_check'] = 'Verificação ortográfica';

$txt['quick_reply'] = 'Resposta rápida';
$txt['quick_reply_warning'] = 'Atenção! Este tópico está atualmente trancado, apenas administradores e moderadores podem responder.';
$txt['quick_reply_verification'] = 'Depois de submeter a sua mensagem será direcionado para a pagina regular de mensagem para verificar a sua mensagem %1$s.';
$txt['quick_reply_verification_guests'] = '(obrigatório para todos os visitantes)';
$txt['quick_reply_verification_posts'] = '(obrigatório para todos os utilizadores com menos de %1$d mensagens)';
$txt['wait_for_approval'] = 'Nota: esta mensagem não será mostrada até que seja aprovada por um administrador.';

$txt['notification_enable_board'] = 'Tem certeza de que deseja ligar as notificações para novos tópicos neste quadro?';
$txt['notification_disable_board'] = 'Tem certeza de que deseja desligar as notificações para novos tópicos neste quadro?';
$txt['notification_enable_topic'] = 'Tem certeza de que deseja ligar as notificações para novas respostas a este tópico?';
$txt['notification_disable_topic'] = 'Tem certeza de que deseja desligar as notificações para novas respostas a este tópico?';

// Mentions
$txt['mentions'] = 'Menções';

// Likes
$txt['likes'] = 'Gostos';
$txt['like'] = 'Gosto';
$txt['unlike'] = 'Desgosto';
$txt['like_success'] = 'O seu conteúdo foi gostado com sucesso.';
$txt['like_delete'] = 'O seu conteúdo foi apagado com sucesso.';
$txt['like_insert'] = 'O seu conteúdo foi inserido com sucesso.';
$txt['like_error'] = 'Há um erro com o seu pedido.';
$txt['like_disable'] = 'Os gostos estão desligados.';
$txt['not_valid_like_type'] = 'O tipo de gosto não é um tipo válido.';
// Translators, if you need to make more strings to suit your language, e.g. $txt['likes_2'] = 'Two people like this', please do so.
$txt['likes_1'] = '<a href="%1$s">%2$s pessoa</a> gosta disto.';
$txt['likes_n'] = '<a href="%1$s">%2$s pessoas</a> gostam disto.';
$txt['you_likes_0'] = 'Você gosta disto.';
$txt['you_likes_1'] = 'Você e <a href="%1$s">%2$s outra pessoa</a> gosta disto.';
$txt['you_likes_n'] = 'Você e <a href="%1$s">%2$s outras pessoas</a> gostam disto.';

$txt['report_to_mod'] = 'Denunciar ao moderador';
$txt['report_profile'] = 'Denunciar o perfil de %1$s';

$txt['unread_topics_visit'] = 'Tópicos recentes não lidos';
// argument(s): scripturl
$txt['unread_topics_visit_none'] = 'Não foram encontrados tópicos desde a sua última visita. <a href="%1$s?action=unread;all">Clique aqui para ver todos os tópicos desde a sua última visita</a>.';
$txt['updated_topics_visit_none'] = 'Nenhum tópico foi atualizado desde a sua última visita.';
$txt['unread_topics_all'] = 'Todos os tópicos não lidos';
$txt['unread_replies'] = 'Tópicos atualizados';

$txt['who_title'] = 'Quem está online';
$txt['who_and'] = ' e ';
$txt['who_viewing_topic'] = ' estão a ver este tópico.';
$txt['who_viewing_board'] = ' estão a ver este quadro.';
$txt['who_member'] = 'Membro';

// No longer used by default theme, but for backwards compat
$txt['powered_by_php'] = 'Desenvolvido por PHP';
$txt['powered_by_mysql'] = 'Desenvolvido por MySQL';
$txt['valid_css'] = 'CSS válido';

$txt['rss'] = 'RSS';
$txt['atom'] = 'Atom';
$txt['html'] = 'HTML';

$txt['guest'] = 'Visitante';
$txt['guests'] = 'Visitantes';
$txt['user'] = 'Utilizador';
$txt['users'] = 'Utilizadores';
$txt['hidden'] = 'Escondido';

// Plural form of hidden for languages other than English
$txt['hidden_s'] = 'Escondido';
$txt['buddy'] = 'Amigo';
$txt['buddies'] = 'Amigos';
$txt['most_online_ever'] = 'Mais online';
$txt['most_online_today'] = 'Mais online hoje';

$txt['merge_select_target_board'] = 'Selecione o quadro alvo para o tópico unido';
$txt['merge_select_poll'] = 'Selecione que sondagem o tópico unido deve ter';
$txt['merge_topic_list'] = 'Selecione os tópicos a serem unidos';
$txt['merge_select_subject'] = 'Selecione o assunto do tópico novo';
$txt['merge_custom_subject'] = 'Assunto personalizado';
$txt['merge_include_notifications'] = 'Incluir notificações?';
$txt['merge_check'] = 'Unir?';
$txt['merge_no_poll'] = 'Sem sondagem';
$txt['merge_why'] = 'Por favor, coloque uma pequena descrição para a razão destes tópicos terem sido unidos.';
$txt['merged_subject'] = '[UNIDO] %1$s';
// argument(s): $txt['movetopic_auto_topic']
$txt['mergetopic_default'] = 'Este tópico foi unido com %2$s.';

$txt['response_prefix'] = 'Re: ';
$txt['current_icon'] = 'Ícone atual';
$txt['message_icon'] = 'Ícone da mensagem';

$txt['smileys_current'] = 'Conjunto de Smilies atual';
$txt['smileys_none'] = 'Sem Smilies';
$txt['smileys_forum_board_default'] = 'Padrão do fórum/quadro';

$txt['search_results'] = 'Resultados da Pesquisa';
$txt['search_no_results'] = 'Não foram encontrados nenhuns resultados para a sua pesquisa';

$txt['total_time_logged_days'] = ' dias, ';
$txt['total_time_logged_hours'] = ' horas e ';
$txt['total_time_logged_minutes'] = ' minutos';
$txt['total_time_logged_d'] = 'd ';
$txt['total_time_logged_h'] = 'h ';
$txt['total_time_logged_m'] = 'm';

$txt['approve_members_waiting'] = 'Aprovação de membros';

$txt['activate_code'] = 'O seu código de ativação é';

$txt['find_members'] = 'Encontrar membros';
$txt['find_username'] = 'Nome, nome de utilizador ou endereço de e-mail';
$txt['find_buddies'] = 'Mostrar apenas os amigos?';
$txt['find_wildcards'] = 'Wildcards permitidos: *, ?';
$txt['find_no_results'] = 'Nenhum resultado encontrado';
$txt['find_results'] = 'Resultados';
$txt['find_close'] = 'Fehcar';

$txt['unread_since_visit'] = 'Mostrar mensagens não lidas desde a última visita.';
$txt['show_unread_replies'] = 'Mostrar novas repostas às minhas mensagens.';

$txt['change_color'] = 'Mudar a cor';

$txt['quickmod_delete_selected'] = 'Remover selecionados';
$txt['quickmod_split_selected'] = 'Dividir selecionados';

$txt['show_personal_messages_heading'] = 'Novas mensagens';
$txt['show_personal_messages'] = 'Tem <strong>%1$s</strong> mensagem pessoal não lida na sua caixa de entrada.<br><br><a href="%2$s">Ir para a sua caixa de entrada</a>';

$txt['help_popup'] = 'Um pouco perdido? Deixe-me explicar:';

$txt['previous_next_back'] = 'Tópico anterior';
$txt['previous_next_forward'] = 'Tópico seguinte';

$txt['mark_unread'] = 'Marcar como não lido';

$txt['ssi_not_direct'] = 'Por favor, não aceda o SSI.php diretamente; pode querer usar o caminho (%1$s) ou adicionar ?ssi_function=alumacoisa.';
$txt['ssi_session_broken'] = 'O SSI.php foi incapaz de carregar a sessão! Isto pode causar problemas ao desconectar e com outras funções - por favor, certifique-se de que o SSI.php está incluído antes de *tudo* em todos os seus scripts!';

// Escape any single quotes in here twice.. 'it\'s' -> 'it\\\'s'.
$txt['preview_title'] = 'Pré-visualizar a mensagem';
$txt['preview_fetch'] = 'A carregar...';
$txt['preview_new'] = 'Nova mensagem';
$txt['pm_error_while_submitting'] = 'O seguinte erro ou erros ocorreram enquanto estava a enviar esta mensagem pessoal:';
$txt['error_while_submitting'] = 'A mensagem tem o seguinte erro ou erros que têm de ser corrigidos antes de continuar:';
$txt['error_old_topic'] = 'Atenção! Este tópico não tem respostas à pelo menos %1$d dias.<br>A não ser que tenha a certeza de que quer responder, por favor considere começar um novo tópico.';

$txt['split_selected_posts'] = 'Mensagens selecionadas';
$txt['split_selected_posts_desc'] = 'Estas mensagens irão formar um novo tópico depois da divisão.';
$txt['split_reset_selection'] = 'redefinir a seleção';

$txt['modify_cancel'] = 'Cancelar';
$txt['modify_cancel_all'] = 'Cancelar tudo';
$txt['mark_read_short'] = 'Marcar como lido';

$txt['alerts'] = 'Alertas';

$txt['pm_short'] = 'Minhas mensagens';
$txt['pm_menu_read'] = 'Ler as suas mensagens';
$txt['pm_menu_send'] = 'Enviar uma mensagem';

$txt['unapproved_posts'] = 'Mensagens por aprovar (Tópicos: %1$d, Mensagens: %2$d)';

$txt['ajax_in_progress'] = 'A carregar...';

$txt['mod_reports_waiting'] = 'Mensagens denunciadas';

$txt['view_unread_category'] = 'Mensagens não lidas';
$txt['new_posts_in_category'] = 'Clique para ver novas mensagens em %1$s';
$txt['verification'] = 'Verificação';
$txt['visual_verification_hidden'] = 'Por favor, deixe este espaço em branco';
$txt['visual_verification_description'] = 'Escreva as letras que são mostradas na imagem';
$txt['visual_verification_sound'] = 'Ouvir as letras';
$txt['visual_verification_request_new'] = 'Pedir outra imagem';

// Sub menu labels
$txt['summary'] = 'Sumário';
$txt['account'] = 'Configurações de conta';
$txt['theme'] = 'Visual e esquema';
$txt['forumprofile'] = 'Perfil do fórum';
$txt['activate_changed_email_title'] = 'Endereço de e-mail mudado';
$txt['activate_changed_email_desc'] = 'Mudou o seu endereço de e-mail. Para validar este endereço, irá receber um e-mail. Clique na ligação desse e-mail para reativar a sua conta.';
$txt['modSettings_title'] = 'Características e opções';
$txt['package'] = 'Gestor de pacotes';
$txt['errorlog'] = 'Registo de erros';
$txt['edit_permissions'] = 'Permissões';
$txt['mc_unapproved_attachments'] = 'Anexos não aprovados';
$txt['mc_unapproved_poststopics'] = 'Tópicos e mensagens não aprovados';
$txt['mc_reported_posts'] = 'Mensagens denunciadas';
$txt['mc_reported_members'] = 'Membros denunciados';
$txt['modlog_view'] = 'Registo de moderação';
$txt['calendar_menu'] = 'Ver calendário';

// @todo Send email strings - should move?
$txt['send_email'] = 'Enviar e-mail';

$txt['ignoring_user'] = 'Está a ignorar este utilizador.';
$txt['show_ignore_user_post'] = 'Mostrar a mensagem.';

$txt['spider'] = 'Mecanismo de pesquisa';
$txt['spiders'] = 'Mecanismos de pesquisa';

$txt['downloads'] = 'Descargas';
$txt['filesize'] = 'Tamanho do ficheiro';

// Restore topic
$txt['restore_topic'] = 'Restaurar tópico';
$txt['restore_message'] = 'Restaurar';
$txt['quick_mod_restore'] = 'Restaurar selecionados';

// Editor prompt.
$txt['prompt_text_email'] = 'Por favor, coloque o endereço de e-mail';
$txt['prompt_text_ftp'] = 'Por favor, coloque o endereço FTP.';
$txt['prompt_text_url'] = 'Por favor, coloque o endereço a URL para onde deseja fazer a ligação.';
$txt['prompt_text_img'] = 'Colocar a localização da imagen';

// Escape any single quotes in here twice.. 'it\'s' -> 'it\\\'s'.
$txt['autosuggest_delete_item'] = 'Apagar item';

// Debug related - when $db_show_debug is true.
$txt['debug_templates'] = 'Templates:';
$txt['debug_subtemplates'] = 'Sub-templates: ';
$txt['debug_language_files'] = 'Ficheiros de linguagem:';
$txt['debug_stylesheets'] = 'Folhas de estilo: ';
$txt['debug_files_included'] = 'Ficheiros incluídos:';
$txt['debug_memory_use'] = 'Memória usada:';
$txt['debug_kb'] = 'Kb.';
$txt['debug_show'] = 'mostrar';
$txt['debug_cache_hits'] = 'Acertos da cache: ';
$txt['debug_cache_misses'] = 'Falhas da cache: ';
$txt['debug_cache_seconds_bytes'] = '%1$ss - %2$s bytes ';
$txt['debug_cache_seconds_bytes_total'] = '%1$ss por %2$s bytes';
$txt['debug_queries_used'] = 'Solicitações usadas: %1$d.';
$txt['debug_queries_used_and_warnings'] = 'Solicitações usadas: %1$d, %2$d avisos.';
$txt['debug_query_in_line'] = 'em <em>%1$s</em> linha <em>%2$s</em>, ';
$txt['debug_query_which_took'] = 'que levou %1$s segundos.';
$txt['debug_query_which_took_at'] = 'que levou %1$s segundos a %2$s na requisição.';
$txt['debug_show_queries'] = '[Mostrar solicitações]';
$txt['debug_hide_queries'] = '[Esconder solicitações]';
$txt['debug_tokens'] = 'Tokens:';
$txt['debug_browser'] = 'ID do navegador:';
$txt['debug_hooks'] = 'Chamadas de integração pedidas: ';
$txt['debug_instances'] = 'Instâncias criadas';
$txt['are_sure_mark_read'] = 'Tem certeza de que quer marcar as mensagens como lidas?';

// Inline attachments messages.
$txt['attachments_not_enable'] = 'Os anexos estão desligados';
$txt['attachments_no_data_loaded'] = 'Não é um ID de anexo válido.';
$txt['attachments_not_allowed_to_see'] = 'Não pode ver este anexo.';
$txt['attachments_no_msg_associated'] = 'Nenhuma mensagem está associada a este anexo.';
$txt['attachments_unapproved'] = 'Anexo à espera de aprovação.';

// Accessibility
$txt['hide_category'] = 'Esconder categoria';
$txt['show_category'] = 'Mostrar categoria';
$txt['hide_infocenter'] = 'Esconder o centro de informações';
$txt['show_infocenter'] = 'Mostrar o centro de informações';

// Notification post control
$txt['notify_topic_0'] = 'Não seguir';
$txt['notify_topic_1'] = 'Nenhum alerta nem e-mail';
$txt['notify_topic_2'] = 'Receber alertas';
$txt['notify_topic_3'] = 'Receber alertas e e-mails';
$txt['notify_topic_0_desc'] = 'Não irá receber nenhum e-mail ou alerta neste tópico e também não irá ser mostrado na sua lista de tópicos e respostas não lidas. Ainda irá receber menções para este tópico.';
$txt['notify_topic_1_desc'] = 'Não irá receber nenhum e-mail ou alerta mas apenas menções de outros membros.';
$txt['notify_topic_2_desc'] = 'Irá receber alertas para este tópico.';
$txt['notify_topic_3_desc'] = 'Irá receber alertas e e-mails para este tópico.';
$txt['notify_board_1'] = 'Sem alertas nem e-mails';
$txt['notify_board_2'] = 'Receber alertas';
$txt['notify_board_3'] = 'Receber alertas e e-mails';
$txt['notify_board_1_desc'] = 'Não irá receber nenhum email ou alerta para novos tópicos';
$txt['notify_board_2_desc'] = 'Irá receber alertas para este quadro.';
$txt['notify_board_3_desc'] = 'Irá receber alertas e e-mails para este quadro.';

$txt['notify_board_prompt'] = 'Quer receber um alerta de notificação quando alguém criar um tópico neste quadro?';
$txt['notify_board_subscribed'] = '%1$s fez uma subscrição para notificações de novos tópicos neste quadro.';
$txt['notify_board_unsubscribed'] = '%1$s retirou a subscrição de novos tópicos neste quadro.';

$txt['notify_topic_prompt'] = 'Quer um e-mail de notificação se alguém responder a este tópico?';
$txt['notify_topic_subscribed'] = '%1$s subscreveu as notificações para novas respostas a este tópico.';
$txt['notify_topic_unsubscribed'] = '%1$s retirou a subscrição para novas respostas a este tópico.';

$txt['notify_announcements_prompt'] = 'Quer receber boletins informativos, anúncios e notificações importantes por e-mail?';
$txt['notify_announcements_subscribed'] = '%1$s subscreveu os boletins informativos, anúncios e notificações importantes.';
$txt['notify_announcements_unsubscribed'] = '%1$s retirou a subscrição de boletins informativos, anúncios e notificações importantes.';

$txt['unsubscribe_announcements_plain'] = 'Para retirar a subscrição dos boletins informativos, anúncios e notificações importantes, siga esta ligação: %1$s';
$txt['unsubscribe_announcements_html'] = '<span style="font-size:small"><a href="%1$s">Retirar subscrição</a> dos boletins informativos, anúncios e notificações importantes.</span>';
$txt['unsubscribe_announcements_manual'] = 'Para retirar a subscrição dos boletins informativos, anúncios e notificações importantes, contacte-nos em %1$s com o seu pedido.';

// Mobile Actions
$txt['mobile_action'] = 'Ações do utilizador';
$txt['mobile_moderation'] = 'Moderação';
$txt['mobile_user_menu'] = 'Menu principal';
$txt['mobile_generic_menu'] = 'Menu %1$s';

// Formats for lists in a sentence (e.g. "Alice, Bob, and Charlie")
// Examples:
// 	$txt['sentence_list_format'][2] specifies a format for a list with two items
// 	$txt['sentence_list_format']['n'] specifies the default format
// Notes on placeholders:
// 	{1} = first item in the list, {2} = second item, etc.
// 	{-1} = last item in the list, {-2} = second last item, etc.
// 	{series} = concatenated string of the rest of the items in the list
$txt['sentence_list_format'][1] = '{1}';
$txt['sentence_list_format'][2] = '{1} e {-1}';
$txt['sentence_list_format'][3] = '{series}, e {-1}';
$txt['sentence_list_format'][4] = '{series}, e {-1}';
$txt['sentence_list_format'][5] = '{series}, e {-1}';
$txt['sentence_list_format']['n'] = '{series}, e {-1}';
// Separators used to build lists in a sentence
$txt['sentence_list_separator'] = ',';
$txt['sentence_list_separator_alt'] = ';';

?>