<?php
// Version: 2.1.0; EmailTemplates

// Since all of these strings are being used in emails, numeric entities should be used.

// Do not translate anything that is between {}, they are used as replacement variables and MUST remain exactly how they are.
//   Additionally, do not translate the @additional_params: line or the variable names in the lines that follow it. You may
//   translate the description of the variable. Do not translate @description:, however you may translate the rest of that line.

// Do not use block comments in this file, they will have special meaning.

global $txtBirthdayEmails;

/**
	@additional_params: resend_activate_message
		REALNAME: The display name for the member receiving the email.
		USERNAME:  The user name for the member receiving the email.
		ACTIVATIONLINK:  The URL link to activate the member's account.
		ACTIVATIONCODE:  The code needed to activate the member's account.
		ACTIVATIONLINKWITHOUTCODE: The URL to the page where the activation code can be entered.
		FORGOTPASSWORDLINK: The URL to the "forgot password" page.
	@description:
*/
$txt['resend_activate_message_subject'] = 'Velkommen til {FORUMNAME}';
$txt['resend_activate_message_body'] = 'Tak for din tilmelding til {FORUMNAME}. Dit brugernavn er {USERNAME}. Hvis du glemmer din adgangskode, kan du nulstille den ved at besøge {FORGOTPASSWORDLINK}.

Før du kan logge ind, skal du først aktivere din konto ved at klikke på følgende link:

{ACTIVATIONLINK}

Hvis du har problemer med aktiveringen, kan du besøge {ACTIVATIONLINKWITHOUTCODE} og indtaste koden "{ACTIVATIONCODE}".

{REGARDS}';

/**
	@additional_params: resend_pending_message
		REALNAME: The display name for the member receiving the email.
		USERNAME:  The user name for the member receiving the email.
	@description:
*/
$txt['resend_pending_message_subject'] = 'Velkommen til {FORUMNAME}';
$txt['resend_pending_message_body'] = 'Hej {REALNAME}, din registreringsanmodning hos {FORUMNAME} er modtaget.

Det brugernavn, du registrerede dig med, var {USERNAME}.

Før du kan logge ind og begynde at bruge forummet, vil din anmodning blive gennemgået og godkendt.

{REGARDS}';

/**
	@additional_params: mc_group_approve
		USERNAME: The user name for the member receiving the email.
		GROUPNAME: The name of the membergroup that the user was accepted into.
	@description: The request to join a particular membergroup has been accepted.
*/
$txt['mc_group_approve_subject'] = 'Godkendelse af gruppemedlemskab';
$txt['mc_group_approve_body'] = 'Hej {USERNAME}
Vi er glade for at kunne meddele dig, at din ansøgning om at blive medlem af gruppen "{GROUPNAME}" på {FORUMNAME} er blevet accepteret, og din konto er blevet opdateret til at inkludere denne nye medlemsgruppe.

{REGARDS}';

/**
	@additional_params: mc_group_reject
		USERNAME: The user name for the member receiving the email.
		GROUPNAME: The name of the membergroup that the user was rejected from.
	@description: The request to join a particular membergroup has been rejected.
*/
$txt['mc_group_reject_subject'] = 'Afvisning af gruppemedlemskab';
$txt['mc_group_reject_body'] = 'Hej {USERNAME}
Vi beklager at måtte meddele dig, at din anmodning om at blive medlem af gruppen "{GROUPNAME}" på {FORUMNAME} er blevet afvist.

{REGARDS}';

/**
	@additional_params: mc_group_reject_reason
		USERNAME: The user name for the member receiving the email.
		GROUPNAME: The name of the membergroup that the user was rejected from.
		REASON: Reason for the rejection.
	@description: The request to join a particular membergroup has been rejected with a reason given.
*/
$txt['mc_group_reject_reason_subject'] = 'Afvisning af gruppemedlemskab';
$txt['mc_group_reject_reason_body'] = 'Hej {USERNAME}
Vi beklager at måtte meddele dig, at din anmodning om at blive medlem af gruppen "{GROUPNAME}" på {FORUMNAME} er blevet afvist.

Årsag: {REASON}

{REGARDS}';

/**
	@additional_params: admin_approve_accept
		NAME: The display name of the member.
		USERNAME: The user name for the member receiving the email.
		PROFILELINK: The URL of the profile page.
		FORGOTPASSWORDLINK: The URL of the "forgot password" page.
	@description:
*/
$txt['admin_approve_accept_subject'] = 'Velkommen til {FORUMNAME}';
$txt['admin_approve_accept_body'] = 'Velkommen {NAME}

Din konto er blevet aktiveret manuelt af administratoren, og du kan nu logge ind og skrive indlæg i forummet. Dit brugernavn er: {USERNAME}. Hvis du glemmer din adgangskode, kan du ændre den på {FORGOTPASSWORDLINK}.

{REGARDS}';

/**
	@additional_params: admin_approve_activation
		USERNAME: The user name for the member receiving the email.
		ACTIVATIONLINK:  The URL link to activate the member's account.
		ACTIVATIONLINKWITHOUTCODE: The URL to the page where the activation code can be entered.
		ACTIVATIONCODE: The activation code.
	@description:
*/
$txt['admin_approve_activation_subject'] = 'Velkommen til {FORUMNAME}';
$txt['admin_approve_activation_body'] = 'Velkommen {USERNAME}!

Din konto på {FORUMNAME} er blevet godkendt af forumadministratoren. Før du kan logge ind, skal du først aktivere din konto ved at klikke på følgende link:

{ACTIVATIONLINK}

Hvis du har problemer med aktiveringen, kan du besøge {ACTIVATIONLINKWITHOUTCODE} og indtaste koden "{ACTIVATIONCODE}".

{REGARDS}';

/**
	@additional_params: admin_approve_reject
		USERNAME: The user name for the member receiving the email.
	@description:
*/
$txt['admin_approve_reject_subject'] = 'Tilmelding afvist';
$txt['admin_approve_reject_body'] = 'Hej {USERNAME}

Din ansøgning om at blive medlem af {FORUMNAME} er desværre blevet afvist.

{REGARDS}';

/**
	@additional_params: admin_approve_delete
		USERNAME: The user name for the member receiving the email.
	@description:
*/
$txt['admin_approve_delete_subject'] = 'Konto slettet';
$txt['admin_approve_delete_body'] = 'Hej {USERNAME}

Din konto på {FORUMNAME} er blevet slettet. Det kan skyldes, at du aldrig har aktiveret din konto, og i så fald burde du kunne registrere dig igen.

{REGARDS}';

/**
	@additional_params: admin_approve_remind
		USERNAME: The user name for the member receiving the email.
		ACTIVATIONLINK:  The URL link to activate the member's account.
		ACTIVATIONLINKWITHOUTCODE: The URL to the page where the activation code can be entered.
		ACTIVATIONCODE: The activation code.
	@description:
*/
$txt['admin_approve_remind_subject'] = 'Påmindelse om registrering';
$txt['admin_approve_remind_body'] = 'Hej {USERNAME}
Du har stadig ikke aktiveret din konto hos {FORUMNAME}.

Brug venligst linket nedenfor for at aktivere din konto:
{ACTIVATIONLINK}

Hvis du har problemer med aktiveringen, kan du besøge {ACTIVATIONLINKWITHOUTCODE} og indtaste koden "{ACTIVATIONCODE}".

{REGARDS}';

/**
	@additional_params:
		USERNAME: The user name for the member receiving the email.
		ACTIVATIONLINK:  The URL link to activate the member's account.
		ACTIVATIONLINKWITHOUTCODE: The URL to the page where the activation code can be entered.
		ACTIVATIONCODE: The activation code.
	@description:
*/
$txt['admin_register_activate_subject'] = 'Velkommen til {FORUMNAME}';
$txt['admin_register_activate_body'] = 'Tak fordi du tilmeldte dig hos {FORUMNAME}. Dit brugernavn er {USERNAME} og din adgangskode er {PASSWORD}.

Før du kan logge ind, skal du først aktivere din konto ved at klikke på følgende link:

{ACTIVATIONLINK}

Hvis du har problemer med aktiveringen, kan du besøge {ACTIVATIONLINKWITHOUTCODE} og indtaste koden "{ACTIVATIONCODE}".

{REGARDS}';

$txt['admin_register_immediate_subject'] = 'Velkommen til {FORUMNAME}';
$txt['admin_register_immediate_body'] = 'Tak fordi du tilmeldte dig hos {FORUMNAME}. Dit brugernavn er {USERNAME}, din adgangskode er {PASSWORD} og forummets webadresse er: {SCRIPTURL}.

{REGARDS}';

/**
	@additional_params: new_announcement
		TOPICSUBJECT: The subject of the topic being announced.
		MESSAGE: The message body of the first post of the announced topic.
		TOPICLINK: A link to the topic being announced.
		UNSUBSCRIBELINK: Link to unsubscribe from announcements.
	@description:
*/
$txt['new_announcement_subject'] = 'Ny meddelelse: {TOPICSUBJECT}';
$txt['new_announcement_body'] = '{MESSAGE}

Du kan se hele meddelelsen ved at følge dette link:
{TOPICLINK}

Følg dette link for at afmelde disse meddelelser:
{UNSUBSCRIBELINK}

For mere kontrol over de email meddelelser, du modtager, kan du logge ind i forummet og gå til meddelelsesområdet i din profil.

{REGARDS}';

/**
	@additional_params: notify_boards_once_body
		TOPICSUBJECT: The subject of the topic causing the notification
		TOPICLINK: A link to the topic.
		MESSAGE: This is the body of the message.
		UNSUBSCRIBELINK: Link to unsubscribe from notifications.
	@description:
*/
$txt['notify_boards_once_body_subject'] = 'Nyt emne: {TOPICSUBJECT}';
$txt['notify_boards_once_body_body'] = 'Et nyt emne, \'{TOPICSUBJECT}\', er blevet lavet i en kategori, du følger.

Du kan se det her:
{TOPICLINK}

Flere emner kan blive postet, men du vil ikke modtage flere email beskeder om denne kategori, før du vender tilbage til kategorien og læser nogle af dem.

Teksten til emnet er vist nedenfor:
{MESSAGE}

Afmeld nye emner fra denne kategori ved at bruge dette link:
{UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notify_boards_once
		TOPICSUBJECT: The subject of the topic causing the notification
		TOPICLINK: A link to the topic.
		UNSUBSCRIBELINK: Link to unsubscribe from notifications.
	@description:
*/
$txt['notify_boards_once_subject'] = 'Nyt emne: {TOPICSUBJECT}';
$txt['notify_boards_once_body'] = 'Et nyt emne, \'{TOPICSUBJECT}\', er blevet oprettet i en kategori, du følger.

Du kan se det her:
{TOPICLINK}

Flere emner kan blive postet, men du vil ikke modtage flere email beskeder om denne kategori, før du vender tilbage til kategorien og læser nogle af dem.

Afmeld nye emner fra denne kategori ved at bruge dette link:
{UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notify_boards_body
		TOPICSUBJECT: The subject of the topic causing the notification
		TOPICLINK: A link to the topic.
		MESSAGE: This is the body of the message.
		UNSUBSCRIBELINK: Link to unsubscribe from notifications.
	@description:
*/
$txt['notify_boards_body_subject'] = 'Nyt emne: {TOPICSUBJECT}';
$txt['notify_boards_body_body'] = 'Et nyt emne, \'{TOPICSUBJECT}\', er blevet oprettet i en kategori, du følger.

Du kan se det her:
{TOPICLINK}

Teksten til emnet er vist nedenfor:
{MESSAGE}

Afmeld nye emner fra denne kategori ved at følge dette link:
{UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notify_boards
		TOPICSUBJECT: The subject of the topic causing the notification
		TOPICLINK: A link to the topic.
		UNSUBSCRIBELINK: Link to unsubscribe from notifications.
	@description:
*/
$txt['notify_boards_subject'] = 'Nyt emne: {TOPICSUBJECT}';
$txt['notify_boards_body'] = 'Et nyt emne, \'{TOPICSUBJECT}\', er blevet oprettet i en kategori, du følger.

Du kan se det her:
{TOPICLINK}

Afmeld nye emner fra denne kategori ved at følge dette link:
{UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: alert_unapproved_reply
		SUBJECT: The subject of the topic causing the notification
		LINK: A link to the topic.
	@description:
*/
$txt['alert_unapproved_reply_subject'] = 'Emnesvar: {SUBJECT}';
$txt['alert_unapproved_reply_body'] = 'Et indlæg er blevet skrevet i \'{SUBJECT}\' af {POSTERNAME}.

Du kan se det her:
{LINK}

{REGARDS}';

/**
	@additional_params: unapproved_attachment
		SUBJECT: The subject of the topic causing the notification
		LINK: A link to the message with the attachment.
	@description:
*/
$txt['unapproved_attachment_subject'] = 'Ny ikke-godkendt vedhæftet fil i: {SUBJECT}';
$txt['unapproved_attachment_body'] = 'Der er tilføjet en ny vedhæftet fil i \'{SUBJECT}\', som skal godkendes.

Du kan godkende eller afvise denne vedhæftede fil fra linket nedenfor, som fører dig til det indlæg, den er en del af.

{LINK}

{REGARDS}';

/**
	@additional_params: alert_unapproved_post
		SUBJECT: The subject of the topic causing the notification
		LINK: A link to the topic.
	@description:
*/
$txt['alert_unapproved_post_subject'] = 'Nyt ikke-godkendt indlæg: {SUBJECT}';
$txt['alert_unapproved_post_body'] = 'Der er oprettet et nyt indlæg, som skal godkendes: \'{SUBJECT}\'

Du kan godkende eller afvise dette indlæg ved at bruge linket nedenfor:
{LINK}

{REGARDS}';

/**
	@additional_params: alert_unapproved_topic
		SUBJECT: The subject of the topic causing the notification
		LINK: A link to the topic.
	@description:
*/
$txt['alert_unapproved_topic_subject'] = 'Nyt ikke-godkendt emne: {SUBJECT}';
$txt['alert_unapproved_topic_body'] = 'Der er oprettet et nyt emne, som skal godkendes: \'{SUBJECT}\'

Du kan godkende eller afvise dette emne ved at bruge linket nedenfor:
{LINK}

{REGARDS}';

/**
	@additional_params: request_membership
		RECPNAME: The name of the person receiving the email
		APPLYNAME: The name of the person applying for group membership
		GROUPNAME: The name of the group being applied to.
		REASON: The reason given by the applicant for wanting to join the group.
		MODLINK: Link to the group moderation page.
	@description:
*/
$txt['request_membership_subject'] = 'Ny gruppeanmodning';
$txt['request_membership_body'] = '{RECPNAME}

{APPLYNAME} har anmodet om medlemskab af gruppen "{GROUPNAME}". Brugeren har givet følgende årsag:

{REASON}

Du kan godkende eller afvise denne anmodning ved at bruge nedenstående link:
{MODLINK}

{REGARDS}';

/**
	@additional_params: paid_subscription
		REALNAME: The real (display) name of the person receiving the email.
		PROFILE_LINK: Link to profile of member receiving email where can renew.
		SUBSCRIPTION: Name of the subscription.
		END_DATE: Date it expires.
	@description:
*/
$txt['paid_subscription_reminder_subject'] = 'Abonnement ved at udløbe hos {FORUMNAME}';
$txt['paid_subscription_reminder_body'] = '{REALNAME}

Dit abonnement hos {FORUMNAME} er ved at udløbe. Hvis du har valgt at forny automatisk, behøver du ikke foretage dig noget ellers kan du overveje at abonnere igen. Detaljer er nedenfor:

Abonnementsnavn: {SUBSCRIPTION}
Udløber: {END_DATE}

Besøg følgende URL for at redigere dine abonnementer:
{PROFILE_LINK}

{REGARDS}';

/**
	@additional_params: activate_reactivate
		ACTIVATIONLINK:  The URL link to reactivate the member's account.
		ACTIVATIONCODE:  The code needed to reactivate the member's account.
		ACTIVATIONLINKWITHOUTCODE: The URL to the page where the activation code can be entered.
	@description:
*/
$txt['activate_reactivate_subject'] = 'Velkommen tilbage til {FORUMNAME}';
$txt['activate_reactivate_body'] = 'For at godkende din email adresse igen, er din konto blevet deaktiveret. Klik på følgende link for at aktivere den igen:
{ACTIVATIONLINK}

Hvis du har problemer med aktiveringen, kan du besøge {ACTIVATIONLINKWITHOUTCODE} og bruge koden "{ACTIVATIONCODE}".

{REGARDS}';

/**
	@additional_params: forgot_password
		REALNAME: The real (display) name of the person receiving the reminder.
		REMINDLINK: The link to reset the password.
		IP: The IP address of the requester.
		MEMBERNAME:
	@description:
*/
$txt['forgot_password_subject'] = 'Ny adgangskode til {FORUMNAME}';
$txt['forgot_password_body'] = 'Hej {REALNAME}
Denne mail blev sendt, fordi funktionen \'glemt adgangskode\' er blevet anvendt på din konto. For at indstille en ny adgangskode skal du klikke på følgende link:
{REMINDLINK}

IP: {IP}
Brugernavn: {MEMBERNAME}

{REGARDS}';

/**
	@additional_params: send_email
		EMAILSUBJECT: The subject the user wants to email.
		EMAILBODY: The body the user wants to email.
		SENDERNAME: The name of the member sending the email.
		RECPNAME: The name of the person receiving the email.
	@description:
*/
$txt['send_email_subject'] = '{EMAILSUBJECT}';
$txt['send_email_body'] = '{EMAILBODY}';

/**
	@additional_params: report_to_moderator
		TOPICSUBJECT: The subject of the reported post.
		POSTERNAME: The reported post's author's name.
		REPORTERNAME: The name of the person reporting the post.
		TOPICLINK: The URL of the post that is being reported.
		REPORTLINK: The URL of the moderation center report.
		COMMENT: The comment left by the reporter, hopefully to explain why they are reporting the post.
	@description: When a user reports a post this email is sent out to moderators and admins of that board.
*/
$txt['report_to_moderator_subject'] = 'Rapporteret indlæg: {TOPICSUBJECT} af {POSTERNAME}';
$txt['report_to_moderator_body'] = 'Følgende indlæg, "{TOPICSUBJECT}" af {POSTERNAME} er blevet rapporteret af {REPORTERNAME} i en kategori, du modererer:

Emnet: {TOPICLINK}
Modereringscenter: {REPORTLINK}

Anmelderen har følgende kommentar:
{COMMENT}

{REGARDS}';

/**
	@additional_params: report_to_moderator
		TOPICSUBJECT: The subject of the reported post.
		POSTERNAME: The reported post's author's name.
		COMMENTERNAME: The name of the person who replied to the report.
		TOPICLINK: The URL of the post that is being reported.
		REPORTLINK: The URL of the moderation center report.
	@description: When a moderator replies to a moderation report, this can be sent to the other moderators who previously replied.
*/
$txt['reply_to_moderator_subject'] = 'Opfølgning på rapporteret indlæg: {TOPICSUBJECT} af {POSTERNAME}';
$txt['reply_to_moderator_body'] = 'Tidligere blev "{TOPICSUBJECT}" rapporteret til moderator.

Siden da har {COMMENTERNAME} tilføjet en kommentar til rapporten. Mere information kan findes på forummet.

Emnet: {TOPICLINK}
Modereringscenter: {REPORTLINK}

{REGARDS}';

/**
	@additional_params: report_user_profile
		MEMBERNAME: The display name of the reported user
		REPORTERNAME: The name of the person reporting the profile
		PROFILELINK: The link to the profile that was reported
		COMMENT: The comment left by the reporter.
 	@description: When a user's profile is reported
*/
$txt['report_member_profile_subject'] = 'Rapporteret profil: {MEMBERNAME}';
$txt['report_member_profile_body'] = 'Profilen for "{MEMBERNAME}" er blevet rapporteret af {REPORTERNAME}.

Profilen: {PROFILELINK}
Modereringscenter: {REPORTLINK}

Anmelderen har følgende kommentar:
{COMMENT}

{REGARDS}';

/**
	@additional_params: report_user_profile
		MEMBERNAME: The display name of the reported user
		COMMENTERNAME: The name of the person who added the comment
		PROFILELINK: The link to the profile that was reported
 	@description: When someone replies to a report about a profile, this can be sent to others who replied
*/
$txt['reply_to_member_report_subject'] = 'Opfølgning på rapporteret profil: {MEMBERNAME}';
$txt['reply_to_member_report_body'] = 'Tidligere blev profilen for {MEMBERNAME} rapporteret.

Siden da har {COMMENTERNAME} tilføjet en kommentar til rapporten. Mere information kan findes i forummet.

Profilen: {PROFILELINK}
Modereringscenter: {REPORTLINK}

{REGARDS}';

/**
	@additional_params: change_password
		USERNAME: The user name for the member receiving the email.
		PASSWORD: The password for the member.
	@description:
*/
$txt['change_password_subject'] = 'Nye adgangskode detaljer';
$txt['change_password_body'] = 'Hej {USERNAME}

Dine loginoplysninger på {FORUMNAME} er blevet ændret, og din adgangskode er nulstillet. Nedenfor er dine nye loginoplysninger.

Dit brugernavn er "{USERNAME}", og din adgangskode er "{PASSWORD}".

Du kan ændre det, efter du har logget ind, ved at gå til profilsiden, eller ved at følge nedenstående link, efter du har logget ind:
{SCRIPTURL}?action=profil

{REGARDS}';

/**
	@additional_params: register_activate
		REALNAME: The display name for the member receiving the email.
		USERNAME: The user name for the member receiving the email.
		PASSWORD: The password for the member.
		ACTIVATIONLINK:  The URL link to reactivate the member's account.
		ACTIVATIONLINKWITHOUTCODE: The URL to the page where the activation code can be entered.
		ACTIVATIONCODE:  The code needed to reactivate the member's account.
		FORGOTPASSWORDLINK: The URL to the "forgot password" page.
	@description:
*/
$txt['register_activate_subject'] = 'Velkommen til {FORUMNAME}';
$txt['register_activate_body'] = 'Tak, fordi du tilmeldte dig hos {FORUMNAME}. Dit brugernavn er {USERNAME}. Hvis du glemmer din adgangskode, kan du nulstille den ved at besøge {FORGOTPASSWORDLINK}.

Før du kan logge ind, skal du først aktivere din konto. Følg nedenstående link for at gøre det:
{ACTIVATIONLINK}

Hvis du har problemer med aktiveringen, kan du besøge {ACTIVATIONLINKWITHOUTCODE} og bruge koden "{ACTIVATIONCODE}".

{REGARDS}';

/**
	@additional_params: register_coppa
		REALNAME: The display name for the member receiving the email.
		USERNAME: The user name for the member receiving the email.
		PASSWORD: The password for the member.
		COPPALINK:  The URL link to the coppa form.
		FORGOTPASSWORDLINK: The URL to the "forgot password" page.
	@description:
*/
$txt['register_coppa_subject'] = 'Velkommen til {FORUMNAME}';
$txt['register_coppa_body'] = 'Tak fordi du tilmeldte dig hos {FORUMNAME}. Dit brugernavn er {USERNAME}. Hvis du glemmer din adgangskode, kan du ændre den på {FORGOTPASSWORDLINK}

Før du kan logge ind, kræver administratoren samtykke fra din forælder/værge, for at du kan deltage i fællesskabet. Du kan få mere information på nedenstående link:
{COPPALINK}

{REGARDS}';

/**
	@additional_params: register_immediate
		REALNAME: The display name for the member receiving the email.
		USERNAME: The user name for the member receiving the email.
		PASSWORD: The password for the member.
		FORGOTPASSWORDLINK: The URL to the "forgot password" page.
	@description:
*/
$txt['register_immediate_subject'] = 'Velkommen til {FORUMNAME}';
$txt['register_immediate_body'] = 'Tak, fordi du tilmeldte dig hos {FORUMNAME}. Dit brugernavn er {USERNAME}. Hvis du glemmer din adgangskode, kan du ændre den på {FORGOTPASSWORDLINK}.

{REGARDS}';

/**
	@additional_params: register_pending
		REALNAME: The display name for the member receiving the email.
		USERNAME: The user name for the member receiving the email.
		PASSWORD: The password for the member.
		FORGOTPASSWORDLINK: The URL to the "forgot password" page.
	@description:
*/
$txt['register_pending_subject'] = 'Velkommen til {FORUMNAME}';
$txt['register_pending_body'] = 'Hej {REALNAME}, din registreringsanmodning hos {FORUMNAME} er modtaget.

Det brugernavn, du vil registrere dig med, er {USERNAME}. Hvis du glemmer din adgangskode, kan du ændre den på {FORGOTPASSWORDLINK}.

Før du kan logge ind og begynde at bruge forummet, vil din anmodning blive gennemgået og godkendt.

{REGARDS}';

/**
	@additional_params: notification_reply
		TOPICSUBJECT:
		POSTERNAME:
		TOPICLINK:
		UNSUBSCRIBELINK:
	@description:
*/
$txt['notification_reply_subject'] = 'Emnesvar: {TOPICSUBJECT}';
$txt['notification_reply_body'] = 'I et emne, du følger, er der blevet skrevet et nyt indlæg af {POSTERNAME}.

Se svaret på: {TOPICLINK}

Afmeld dette emne ved at bruge dette link: {UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notification_reply_body
		TOPICSUBJECT:
		POSTERNAME:
		TOPICLINK:
		UNSUBSCRIBELINK:
		MESSAGE:
	@description:
*/
$txt['notification_reply_body_subject'] = 'Emnesvar: {TOPICSUBJECT}';
$txt['notification_reply_body_body'] = 'I et emne, du følger, er der blevet skrevet et nyt indlæg af {POSTERNAME}.

Se svaret på: {TOPICLINK}

Afmeld dette emne, ved at bruge dette link: {UNSUBSCRIBELINK}

Teksten fra indlægget er vist nedenfor:
{MESSAGE}

{REGARDS}';

/**
	@additional_params: notification_reply_once
		TOPICSUBJECT:
		POSTERNAME:
		TOPICLINK:
		UNSUBSCRIBELINK:
	@description:
*/
$txt['notification_reply_once_subject'] = 'Emnesvar: {TOPICSUBJECT}';
$txt['notification_reply_once_body'] = 'I et emne, du følger, er der skrevet et nyt indlæg af {POSTERNAME}.

Se svaret på: {TOPICLINK}

Afmeld dette emne, ved at bruge dette link: {UNSUBSCRIBELINK}

Flere svar kan blive sendt, men du vil ikke modtage flere meddelelser om dette emne, før du besøger det i forummet.

{REGARDS}';

/**
	@additional_params: notification_reply_body_once
		TOPICSUBJECT:
		POSTERNAME:
		TOPICLINK:
		UNSUBSCRIBELINK:
		MESSAGE:
	@description:
*/
$txt['notification_reply_body_once_subject'] = 'Emnesvar: {TOPICSUBJECT}';
$txt['notification_reply_body_once_body'] = 'I et emne, du følger, er der skrevet et indlæg af {POSTERNAME}.

Se svaret på: {TOPICLINK}

Afmeld dette emne, ved at bruge dette link: {UNSUBSCRIBELINK}

Teksten i indlægget er vist nedenfor:
{MESSAGE}

Flere indlæg kan blive skrevet, men du vil ikke modtage flere meddelelser om dette emne, før du besøger det i forummet.

{REGARDS}';

/**
	@additional_params: notification_sticky
	@description:
*/
$txt['notification_sticky_subject'] = 'Fastgjort emne: {TOPICSUBJECT}';
$txt['notification_sticky_body'] = 'Et emne, du følger, er blevet fastgjort.

Se emnet på: {TOPICLINK}

Afmeld dette emne, ved at bruge dette link: {UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notification_lock
	@description:
*/
$txt['notification_lock_subject'] = 'Emne låst: {TOPICSUBJECT}';
$txt['notification_lock_body'] = 'Et emne, du følger, er blevet låst.

Se emnet på: {TOPICLINK}

Afmeld dette emne, ved at bruge dette link: {UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notification_unlock
	@description:
*/
$txt['notification_unlock_subject'] = 'Emne låst op: {TOPICSUBJECT}';
$txt['notification_unlock_body'] = 'Et emne, du følger, er blevet låst op.

Se emnet på: {TOPICLINK}

Afmeld dette emne, ved at bruge dette link: {UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notification_remove
	@description:
*/
$txt['notification_remove_subject'] = 'Emne fjernet: {TOPICSUBJECT}';
$txt['notification_remove_body'] = 'Et emne, du følger, er blevet fjernet.

{REGARDS}';

/**
	@additional_params: notification_move
	@description:
*/
$txt['notification_move_subject'] = 'Emne flyttet: {TOPICSUBJECT}';
$txt['notification_move_body'] = 'Et emne, du følger, er blevet flyttet til en anden kategori.

Se emnet på: {TOPICLINK}

Afmeld dette emne, ved at bruge dette link: {UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notification_merged
	@description:
*/
$txt['notification_merge_subject'] = 'Emne flettet sammen: {TOPICSUBJECT}';
$txt['notification_merge_body'] = 'Et emne, du følger, er blevet flettet sammen med et andet emne.

Se det flettede emne på: {TOPICLINK}

Afmeld dette emne, ved at bruge dette link: {UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notification_split
	@description:
*/
$txt['notification_split_subject'] = 'Emne opdelt: {TOPICSUBJECT}';
$txt['notification_split_body'] = 'Et emne, du følger, er blevet opdelt i to eller flere emner.

Se hvad der er tilbage af dette emne på: {TOPICLINK}

Afmeld dette emne, ved at bruge dette link: {UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: admin_notify
		USERNAME:
		PROFILELINK:
	@description:
*/
$txt['admin_notify_subject'] = 'En ny bruger har tilmeldt sig';
$txt['admin_notify_body'] = '{USERNAME} har lige tilmeldt sig som ny bruger af forummet. Klik på linket nedenfor for at se brugerens profil.
{PROFILELINK}

{REGARDS}';

/**
	@additional_params: admin_notify_approval
		USERNAME:
		PROFILELINK:
		APPROVALLINK:
	@description:
*/
$txt['admin_notify_approval_subject'] = 'En ny bruger har tilmeldt sig';
$txt['admin_notify_approval_body'] = '{USERNAME} har lige tilmeldt sig som ny bruger af forummet. Klik på linket nedenfor for at se brugerens profil.
{PROFILELINK}

Før denne bruger kan skrive indlæg i forummet, skal brugerkontoen godkendes. Klik på linket nedenfor for at gå til godkendelsessiden.
{APPROVALLINK}

{REGARDS}';

/**
	@additional_params: admin_attachments_full
		REALNAME:
	@description:
*/
$txt['admin_attachments_full_subject'] = 'Vigtigt! Mappen til vedhæftede filer er næsten fuld';
$txt['admin_attachments_full_body'] = 'Hej {REALNAME}

Mappen til vedhæftede filer på {FORUMNAME} er næsten fuld. Besøg forummet for at løse dette problem.

Når mappen med vedhæftede filer når sin maksimalt tilladte størrelse, vil brugere ikke være i stand til at vedhæfte filer eller uploade egne avatarer (hvis dette er aktiveret).

{REGARDS}';

/**
	@additional_params: paid_subscription_refund
		NAME: Subscription title.
		REALNAME: Recipients name
		REFUNDUSER: Username who took out the subscription.
		REFUNDNAME: User's display name who took out the subscription.
		DATE: Today's date.
		PROFILELINK: Link to members profile.
	@description:
*/
$txt['paid_subscription_refund_subject'] = 'Refunderet betalt abonnement';
$txt['paid_subscription_refund_body'] = 'Hej {REALNAME}

En bruger har fået refunderet et betalt abonnement. Nedenfor er detaljerne for dette abonnement:

Abonnement: {NAME}
Brugernavn: {REFUNDNAME} ({REFUNDUSER})
Dato: {DATE}

Du kan se denne brugers profil, ved at klikke på nedenstående link:
{PROFILELINK}

{REGARDS}';

/**
	@additional_params: paid_subscription_new
		NAME: Subscription title.
		REALNAME: Recipients name
		SUBEMAIL: Email address of the user who took out the subscription
		SUBUSER: Username who took out the subscription.
		SUBNAME: User's display name who took out the subscription.
		DATE: Today's date.
		PROFILELINK: Link to members profile.
	@description:
*/
$txt['paid_subscription_new_subject'] = 'Nyt betalt abonnement';
$txt['paid_subscription_new_body'] = '{REALNAME}

En bruger har tegnet et nyt betalt abonnement. Nedenfor er detaljerne for dette abonnement:

Abonnement: {NAME}
Brugernavn: {SUBNAME} ({SUBUSER})
Bruger email: {SUBEMAIL}
Pris: {PRICE}
Dato: {DATE}

Du kan se denne brugers profil, ved at klikke på nedenstående link:
{PROFILELINK}

{REGARDS}';

/**
	@additional_params: paid_subscription_error
		ERROR: Error message.
		REALNAME: Recipients name
	@description:
*/
$txt['paid_subscription_error_subject'] = 'Der opstod en fejl med et betalt abonnement';
$txt['paid_subscription_error_body'] = 'Hej {REALNAME}

Følgende fejl opstod under behandling af et betalt abonnement
-------------------------------------------------- -------------
{ERROR}

{REGARDS}';

/**
	@additional_params: new_pm
		SUBJECT: The personal message subject.
		SENDER:  The user name for the member sending the personal message.
		READLINK:  The link to directly access the read page.
		REPLYLINK:  The link to directly access the reply page.
	@description: A notification email sent to the receivers of a personal message
*/
$txt['new_pm_subject'] = 'Ny personlig besked: {SUBJECT}';
$txt['new_pm_body'] = 'Du har lige modtaget en personlig besked fra {SENDER} på {FORUMNAME}.

VIGTIGT: Husk at dette er kun til information. Svar venligst ikke på denne email.

Læs den personlige besked her: {READLINK}

Svar på den personlige besked her: {REPLYLINK}

{REGARDS}';

/**
	@additional_params: new_pm_body
		SUBJECT: The personal message subject.
		SENDER:  The user name for the member sending the personal message.
		MESSAGE:  The text of the personal message.
		REPLYLINK:  The link to directly access the reply page.
	@description: A notification email sent to the receivers of a personal message
*/
$txt['new_pm_body_subject'] = 'Ny personlig besked: {SUBJECT}';
$txt['new_pm_body_body'] = 'Du har lige modtaget en personlig besked fra {SENDER} på {FORUMNAME}.

VIGTIGT: Husk at dette er kun til information. Svar venligst ikke på denne email.

Beskeden du har modtaget:

{MESSAGE}

Svar på den personlige besked her: {REPLYLINK}

{REGARDS}';

/**
	@additional_params: new_pm_tolist
		SUBJECT: The personal message subject.
		SENDER:  The user name for the member sending the personal message.
		READLINK:  The link to directly access the read page.
		REPLYLINK:  The link to directly access the reply page.
		TOLIST:  The list of users that will receive the personal message.
	@description: A notification email sent to the receivers of a personal message
*/
$txt['new_pm_tolist_subject'] = 'Ny personlig besked: {SUBJECT}';
$txt['new_pm_tolist_body'] = 'Du og {TOLIST} har netop modtaget en personlig besked fra {SENDER} på {FORUMNAME}.

VIGTIGT: Husk at dette er kun til information. Svar venligst ikke på denne email.

Læs den personlige besked her: {READLINK}

Besvar den personlige besked (kun til afsenderen) her: {REPLYLINK}

{REGARDS}';

/**
	@additional_params: new_pm_body_tolist
		SUBJECT: The personal message subject.
		SENDER:  The user name for the member sending the personal message.
		MESSAGE:  The text of the personal message.
		REPLYLINK:  The link to directly access the reply page.
		TOLIST:  The list of users that will receive the personal message.
	@description: A notification email sent to the receivers of a personal message
*/
$txt['new_pm_body_tolist_subject'] = 'Ny personlig besked: {SUBJECT}';
$txt['new_pm_body_tolist_body'] = 'Du og {TOLIST} har netop modtaget en personlig besked fra {SENDER} på {FORUMNAME}.

VIGTIGT: Husk at dette er kun til information. Svar venligst ikke på denne email.

Beskeden du har modtaget:

{MESSAGE}

Besvar den personlige besked (kun til afsenderen) her: {REPLYLINK}

{REGARDS}';

/**
	@additional_params: msg_quote
		CONTENTSUBJECT: The post subject.
		QUOTENAME:  The user name for the member creating the quote
		MEMBERNAME:  The user name for the member being quoted
		CONTENTLINK:  The post's link
	@description: A notification email sent to the members who've been quoted in a post
 */
$txt['msg_quote_subject'] = 'Du er blevet citeret i indlægget: {CONTENTSUBJECT}';
$txt['msg_quote_body'] = 'Hej {MEMBERNAME}

Du er blevet citeret i indlægget med titlen "{CONTENTSUBJECT}" af {QUOTENAME}. Du kan se indlægget her:
{CONTENTLINK}

{REGARDS}';

/**
	@additional_params: msg_mention
		CONTENTSUBJECT: The post subject.
		MENTIONNAME:  The user name for the member creating the mention
		MEMBERNAME:  The user name for the member being mentioned
		CONTENTLINK:  The post's link
	@description: A notification email sent to the members who've been mentioned in a post
 */
$txt['msg_mention_subject'] = 'Du er blevet nævnt i indlægget: {CONTENTSUBJECT}';
$txt['msg_mention_body'] = 'Hej {MEMBERNAME}

Du er blevet nævnt i indlægget med titlen "{CONTENTSUBJECT}" af {MENTIONNAME}. Du kan se indlægget her:
{CONTENTLINK}

{REGARDS}';

/**
	@additional_params: happy_birthday
		REALNAME: The real (display) name of the person receiving the birthday message.
	@description: A message sent to members on their birthday.
*/
$txtBirthdayEmails['happy_birthday_subject'] = 'Tillykke med fødselsdagen fra {FORUMNAME}.';
$txtBirthdayEmails['happy_birthday_body'] = 'Kære {REALNAME}

Vi her på {FORUMNAME} vil gerne ønske dig tillykke med fødselsdagen. Må denne dag og det kommende år være fuld af glæde.

{REGARDS}';
$txtBirthdayEmails['happy_birthday_author'] = '<a href="https://www.simplemachines.org/community/?action=profile;u=2676">Thantos</a>';

$txtBirthdayEmails['karlbenson1_subject'] = 'På din fødselsdag...';
$txtBirthdayEmails['karlbenson1_body'] = 'Vi kunne have sendt dig et fødselsdagskort. Vi kunne have sendt dig nogle blomster eller en kage.

Men det gjorde vi ikke.

Vi kunne endda have sendt dig en af de automatisk genererede beskeder for at ønske dig tillykke med fødselsdagen, hvor vi ikke engang behøver at erstatte INDSÆT NAVN.

Men det gjorde vi ikke.

Vi skrev denne fødselsdagshilsen kun til dig.

Vi vil gerne ønske dig en helt særlig fødselsdag.

{REGARDS}

//:: Denne besked blev automatisk genereret:://';
$txtBirthdayEmails['karlbenson1_author'] = '<a href="https://www.simplemachines.org/community/?action=profile;u=63186">karlbenson</a>';

$txtBirthdayEmails['nite0859_subject'] = 'Tillykke med fødselsdagen!';
$txtBirthdayEmails['nite0859_body'] = 'Dine venner hos {FORUMNAME} vil gerne bruge et øjeblik på at ønske dig tillykke med fødselsdagen, {REALNAME}. Hvis du ikke har gjort det for nylig, så besøg vores fællesskab, så andre får mulighed for at give deres varme hilsener videre.

Selvom det er din fødselsdag i dag, {REALNAME}, vil vi gerne minde dig om, at dit medlemskab i vores fællesskab har været den bedste gave til os indtil videre.

Bedste ønsker,
Teamet bag {FORUMNAME}';
$txtBirthdayEmails['nite0859_author'] = '<a href="https://www.simplemachines.org/community/?action=profile;u=46625">nite0859</a>';

$txtBirthdayEmails['zwaldowski_subject'] = 'Fødselsdagshilsner til {REALNAME}';
$txtBirthdayEmails['zwaldowski_body'] = 'Kære {REALNAME}

Endnu et år i dit liv er gået. Vi på {FORUMNAME} håber, at det har været fyldt med lykke, og ønsker dig held og lykke i det kommende år.

{REGARDS}';
$txtBirthdayEmails['zwaldowski_author'] = '<a href="https://www.simplemachines.org/community/?action=profile;u=72038">zwaldowski</a>';

$txtBirthdayEmails['geezmo_subject'] = 'Tillykke med fødselsdagen {REALNAME}!';
$txtBirthdayEmails['geezmo_body'] = 'Ved du, hvem der har fødselsdag i dag, {REALNAME}?

Vi kender... DIG!

Tillykke med fødselsdagen!

Du er nu et år ældre, men vi håber, du er meget gladere end sidste år.

Nyd din dag i dag, {REALNAME}!

- Fra din {FORUMNAME}-familie';
$txtBirthdayEmails['geezmo_author'] = '<a href="https://www.simplemachines.org/community/?action=profile;u=48671">geezmo</a>';

$txtBirthdayEmails['karlbenson2_subject'] = 'Din fødselsdagshilsen';
$txtBirthdayEmails['karlbenson2_body'] = 'Vi håber din fødselsdag er den bedste nogensinde; overskyet, solrigt eller uanset vejret.
Hav en masse fødselsdagskage og sjov, og fortæl os, hvad du har lavet.

Vi håber, at denne besked bragte dig munterhed og får den til at vare indtil samme tid samme sted, næste år.

{REGARDS}';
$txtBirthdayEmails['karlbenson2_author'] = '<a href="https://www.simplemachines.org/community/?action=profile;u=63186">karlbenson</a>';

?>