<?php
// Version: 2.1.5; Help

global $helptxt, $scripturl;

$txt['close_window'] = 'Fechar esta janela';

$helptxt['manage_boards'] = '<strong>Editar fóruns</strong><br>
	Neste menu pode criar/ordenar/apagar fóruns, e as categorias
	acima deles. Por exemplo, se tiver um site abrangente
	que ofereça informação sobre &quot;esportes&quot;, &quot;Automóveis&quot; e &quot;Música&quot;, estas
	seriam as Categorias de nível superior que teria de criar. Dentro de cada uma destas categorias
	poderia criar &quot;sub-categorias&quot; hierárquicas,
	ou &quot;Fóruns&quot; dentro de cada uma delas. é uma hierarquia simples, com esta estrutura: <br>
	<ul>
		<li>
			<strong>Esportes</strong>
			&nbsp;- A &quot;categoria&quot;
		</li>
		<ul>
			<li>
				<strong>Futebol</strong>
				&nbsp;- Um fórum dentro da categoria de &quot;esportes&quot;
			</li>
			<ul>
				<li>
					<strong>Estatísticas</strong>
					&nbsp;- Um sub-fórum dentro do fórum de &quot;Futebol&quot;
				</li>
			</ul>
			<li><strong>Basquetebol</strong>
			&nbsp;- Um fórum dentro da categoria de &quot;esportes&quot;</li>
		</ul>
	</ul>
	As Categorias permitem separar o Fórum em vários assuntos (&quot;Automóveis,
	esportes&quot;), e os &quot;Fóruns&quot; dentro delas contêm os tópicos dentro dos quais
	os membros podem enviar mensagens. Um usuário interessado em Ferraris
	irá enviar uma mensagem em &quot;Automóveis->Ferraris&quot;. As Categorias permitem que as pessoas
	encontrem rapidamente aquilo que lhes interessa.<br>
	Assim sendo, um Fórum é um objecto chave dentro de cada Categoria.
	Se quer enviar mensagens sobre &quot;Ferraris&quot; vai à categoria &quot;Automóveis&quot; e
	entra no fórum &quot;Ferraris&quot; para enviar a sua mensagem.<br>
	As funções administrativas neste menu são as de criar novos fóruns
	dentro de cada categoria, de ordená-los (colocar &quot;Ferraris&quot; à frente de &quot;Porsches&quot;), ou
	apagar os fóruns.';

$helptxt['edit_news'] = ' <ul class="normallist"> <li> <strong>Novidades</strong><br> Esta seção permite você editar as noticias que serão mostradas na página inicial do fórum,. Adicione qualquer item que desejar (e.g., &quot;Não perca a conferencia nesta quinta&quot;). Cada noticia é mostrada randomicamente e deve estar em uma caixa separada. </li> <li> <strong>Noticias</strong><br> Esta seção permite você de enviar noticias a seus membros via email ou mensagem pessoas. Primeiro selecione os grupos que você quer que recebam a noticia. Se você quiser, pode adicionar emails ou nomes de usuários separadamente para receber as noticias. Finalmente, coloque a mensagem que você quer que seja enviada, e selecione se é via email ou mensagem pessoas. </li> <li> <strong>Configurações</strong><br> Esta seção inclui algumas configurações sobre as novidades e as noticias, incluindo selecionar grupos que podem editar as novidades e grupos para enviar noticias aos membros. Existe também a opção de habilitar um feed de novidades para o seu forum, também a opção de escolher quantos caracteres serão enviados no feed de novidades. </li> </ul>';

$helptxt['view_members'] = '
	<ul class="normallist">
		<li>
			<strong>Ver todos os membros</strong><br>
			Veja todos os membros do fórum. Você verá uma lista com os nomes dos membros. Clique em qualquer um dos nomes para encontrar detalhes dos membros (página inicial, idade, etc.), e como Administrador, pode modificar estes parâmetros. Você tem controle total sobre os membros, incluindo a capacidade de excluí-los do fórum.<br><br>
		</li>
		<li>
			<strong>Aguardando aprovação</strong><br>
			Esta página só será exibida se você tiver habilitado a aprovação do administrador para todos os novos registros. Qualquer pessoa que se registrar para participar do seu fórum só se tornará membro pleno depois de ser aprovado por um administrador. A página lista todos os membros que ainda aguardam aprovação, juntamente com seu e-mail e endereço de IP. Você pode optar por aceitar ou rejeitar (excluir) qualquer membro da lista marcando a caixa ao lado do membro e escolhendo a ação na caixa suspensa na parte inferior da página. Ao rejeitar um membro, você pode optar por excluí-lo notificando ou não sua decisão.<br><br>
		</li>
		<li>
			<strong>Aguardando ativação</strong><br>
			Esta página só estará visível se tiver ativado a ativação por e-mail de novas contas de membros no fórum. Esta página listará todos os membros que ainda não ativaram suas novas contas. Nesta página você pode optar por aceitar, rejeitar ou lembrar os membros com inscrições pendentes e também pode optar por enviar um e-mail ao membro para informá-lo sobre a ação que você tomou.<br><br>
		</li>
	</ul>';

$helptxt['ban_members'] = '<strong>Banir membros</strong><br>
	O SMF fornece a possibilidade de &quot;banir&quot; usuários, de modo a prevenir que pessoas violem as regras
	do fórum com spam, mensagens obscenas, etc, voltem a fazer o mesmo. Como administrador,
	quando vê as mensagens, pode ver o endereço de IP de cada usuário. Na lista de banimento, 
	basta inserir esse mesmo IP, gravar, e eles já não podem enviar nenhuma mensagem desse local.<br>Também é possível
	banir pessoas através de seus endereços de e-mail.';

$helptxt['featuresettings'] = '<strong>Editar Recursos e Opções</strong><br> Existem diversos recursos nesta seção que podem ser mudados de acordo com a sua preferência.';

$helptxt['modsettings'] = '<strong>Editar Configurações e Opções</strong><br>
	Existem várias funcionalidades nesta secção que podem ser alteradas de acordo com a sua preferência.
        As opções para os pacotes instalados normalmente também aparecem aqui.';

$helptxt['time_format'] = '<strong>Formato da Hora</strong><br>
		Você tem o poder de ajustar a forma como a data e a hora aparecem no site. Existem muitas letrinhas, mas é muito simples.
	As convenções seguem a função \'strftime\' do PHP e estão descritas abaixo (você pode encontrar mais informações em <a href="https://php.net/manual/function.strftime.php" target="_blank" rel="noopener">php.net</a>).<br>
	<br>
	Os seguintes caracteres são reconhecidos da seguinte maneira: <br>
	<span class="smalltext">
	&nbsp;&nbsp;%a - nome abreviado da semana <br>
	&nbsp;&nbsp;%A - nome da semana<br>
	&nbsp;&nbsp;%b - nome abreviado do mês <br>
	&nbsp;&nbsp;%B - nome do mês<br>
	&nbsp;&nbsp;%d - dia do mês (01 a 31) <br>
	&nbsp;&nbsp;%D<strong>*</strong> - o mesmo que %m/%d/%y <br>
	&nbsp;&nbsp;%e<strong>*</strong> - dia do mês (1 a 31) <br>
	&nbsp;&nbsp;%H - relógio com 24 horas (de 00 a 23) <br>
	&nbsp;&nbsp;%I - relógio com 12 horas (de 01 a 12) <br>
	&nbsp;&nbsp;%m - mês como número (01 a 12) <br>
	&nbsp;&nbsp;%M - minutos<br>
	&nbsp;&nbsp;%p - ou &quot;am&quot; ou &quot;pm&quot; consoante a hora do dia<br>
	&nbsp;&nbsp;%R<strong>*</strong> - hora na notação 24 horas<br>
	&nbsp;&nbsp;%S - segundos<br>
	&nbsp;&nbsp;%T<strong>*</strong> - hora atual, igual a %H:%M:%S <br>
	&nbsp;&nbsp;%y - ano com 2 dígitos (00 a 99) <br>
	&nbsp;&nbsp;%Y - ano com 4 dígitos<br>
	&nbsp;&nbsp;%% - literalmente, um caracter \'%\'<br>
	<br>
	<em>* Não funciona em servidores Windows.</em></span>';

$helptxt['live_news'] = '<strong>Anúncios ao vivo</strong><br>
Esta caixa mostra anúncios atualizados recentemente de <a href="https://www.simplemachines.org/" target="_blank" rel="noopener">www.simplemachines.org</a>.
Você deve verificar aqui de vez em quando se há atualizações, novos lançamentos e informações importantes do Simple Machines.';

$helptxt['registrations'] = '<strong>Gestão de registros</strong><br>
	Esta seção contém todas as funções necessárias para gerenciar os novos registros no fórum. Existem até quatro
	zonas visíveis dependendo da configuração do seu Fórum. Elas são:<br><br>
	<ul>
		<li>
			<strong>Registrar novo membro</strong><br>
			A partir desta secção pode efetuar o registro de novos membros. Isto pode ser útil nos fóruns que tenham a opção de
			registro de novos membros desativada, ou em casos em que o administrador quer criar uma conta de teste.
			Se a opção de ativar o registro estiver ativada no fórum, será enviado um email ao novo membro com um link de
			ativação da sua conta. Do mesmo modo, pode escolher enviar um email aos membros com uma nova senha.<br><br>
		</li>
		<li>
			<strong>Editar o acordo de registro</strong><br>
			Esta zona permite definir o texto para o acordo de registro que é exibido quando membros se registram no seu fórum.
			Pode adicionar ou remover o que quiser da versão original incluida no SMF.<br><br>
		</li>
		<li>
			<strong>Editar os nomes reservados</strong><br>
			Isto permite adicionar palavras ou frases que não quer que as pessoas usem como nome de usuário ou nome
 visível.<br><br>
		</li>
		<li>
			<strong>Definições</strong><br>
			Esta seção só será visível se você tiver
 permissão de administrador do fórum. Desta janela pode decidir sobre o método de registro
			usado no fórum, assim como outras definições de registro.
		</li>
	</ul>';

$helptxt['modlog'] = '<strong>Log de moderação</strong><br>
	Esta página permite que os membros da equipe de moderação acompanhem todas as ações de moderação que os moderadores do fórum realizaram.
	Observe que a limpeza do log será registrada para evitar abusos.';
$helptxt['adminlog'] = '<strong>Log da Administração</strong><br> Esta seção permite que membros da Administração vejam ações administrativas que foram feitas no fórum. Para garantir que os Administradores não poderão remover suas ações deste log, registros não podem ser deletados antes de 24 horas após a ação.';
$helptxt['userlog'] = '<strong>Log de edições de perfil</strong><br>
	Esta página permite que os membros da equipe administrativa visualizem as alterações feitas pelos usuários em seus perfis, ficando disponível na área de perfil do usuário.';
$helptxt['warning_enable'] = '<strong>Sistema de alerta do usuário</strong><br> Esta funcionalidade habilita membros da staff à emitirem alertas para os usuários - e a usar o nível de alerta dos usuários para determinar as ações disponíveis para eles no fórum. Ao ativar esta funcionalidade uma permissão estará disponível dentro da seção permissões para definir quais grupos poderão emitir alertas para os usuários. O level de alerta pode ser ajustado no perfil do usuário. As seguintes opções adicionais estarão disponíveis: <ul class="normallist"> <li> <strong>Nível de alerta para o usuário ser observado</strong><br> Esta configuração define o percentual de alerta que usuário deve atingir para ser colocado automaticamente um &quot;Observado&quot; no usuário. Qualquer usuário que estiver sendo &quot;Observado&quot; aparecerá na área respectiva do centro da moderação. </li> <li> <strong>Nível de alerta para o usuário ser moderado</strong><br> Qualquer usuário que passar o valor configurado nesta opção, será adicionado na lista de moderação, onde todos os seus posts devem ser aprovados por um moderador antes de aparecerem efetivamente para a comundade. Isto irá sobrepor qualquer permissões locais que possam existir relacionadas com a lista de moderação. </li> <li> <strong>Nível de alerta para o usuário ser silenciado</strong><br> Se este nível de alerta for ultrapassado, o usuário perderá todo o seu direito de postar. </li> <li> <strong>Máximo de pontos de aviso por dia</strong><br> Esta opção limita a quantidade de pontos de alerta que um moderador pode adicionar ou remover a qualquer usuário em um período de vinte e quatro horas. Isto pode ser usado para limitar o que um moderador pode fazer em um pequeno período de tempo. Esta definição pode ser desativada através da digitação de um valor de zero. Note que quaisquer usuários com permissões de administrador não são afetados por esse valor. </li> </ul>';
$helptxt['warning_watch'] = 'Esta configuração define o nível percentual de aviso que um membro deve atingir para atribuir automaticamente uma função de &quot;vigilância&quot;. para o membro. Qualquer membro que esteja sendo &quot;observado&quot; aparecerá na lista de membros monitorados no centro de moderação.';
$helptxt['warning_moderate'] = 'Qualquer membro que estiver passando o valor desta configuração verá que todas as suas postagens exigirão a aprovação do moderador antes de aparecerem na comunidade do fórum. Isso substituirá quaisquer permissões do fórum local que possam existir relacionadas à pós-moderação.';
$helptxt['warning_mute'] = 'Se este nível de aviso for aprovado por um membro, ele ficará sob a proibição de publicações. O membro perderá todos os direitos de postagem.';
$helptxt['user_limit'] = 'Esta configuração limita a quantidade de pontos que um moderador pode adicionar/remover a qualquer membro específico em um período de 24 horas. Isto pode ser usado para limitar o que um moderador pode fazer num pequeno período de tempo. Isto pode ser desligado definindo o valor como zero. Note que qualquer membro com permissões de administrador não é afetado por este valor.';

$helptxt['error_log'] = '<strong>Log de Erros</strong><br>
	O log de erros registra todos os erros graves encontrados pelos usuários no fórum. É listado todos estes erros por ordem cronológica
	e podem ser reordenados clicando na seta preta junto da data. Pode ainda filtrar os erros clicando na imagem junto de cada ítem do erro.
	 Isto permite filtrar, por exemplo, todos os erros de um determinado membro. Quando existe um filtro ativo, os únicos registros que aparecem serão os que forem iguais a esse filtro.';
$helptxt['theme_settings'] = '<strong>Configurações do Tema</strong><br>
	Esta página de configurações permite alterar as configurações específicas de cada tema. Estas configurações incluem opções tais como a pasta, a URL dos temas e também
	opções que afetam o layout de cada tema no fórum. A maior parte dos temas tem uma variedade de opções configuráveis,
	permitindo adaptá-los conforme as suas necessidades.';
$helptxt['smileys'] = '<strong>Centro de Smileys</strong><br>
	Aqui é possível adicionar ou remover smileys e conjuntos de smileys. Nota importante: Se um smiley existe num conjunto, tem de existir em todos - caso contrário, pode tornar-se
	confuso para os usuários que usem conjuntos de smileys diferentes.<br><br>

	Você também pode editar ícones da mensagem aqui, se tiver permissões para tal.';
$helptxt['calendar'] = '<strong>Gerenciar o Calendário</strong><br>
	Aqui pode modificar as definições atuais do calendário, assim como adicionar ou remover feriados, ou eventos.';
$helptxt['cal_export'] = 'Exporta um arquivo de texto no formato iCal para importar para outros aplicativos da agenda';
$helptxt['cal_highlight_events'] = 'Esta configuração permite destacar eventos no calendário de mini, na agenda principal, ambos os lugares ou desativar destaque de eventos.';
$helptxt['cal_highlight_holidays'] = 'Esta configuração permite destacar feriados na agenda mini, na agenda principal, ambos os lugares ou desativar destaque do evento.';
$helptxt['cal_highlight_birthdays'] = 'Esta configuração permite destacar aniversários nos Mini Calendários, no Calendário Principal, em ambos os locais ou desativar o destaque de eventos.';
$helptxt['cal_disable_prev_next'] = 'Se esta configuração estiver marcada, os blocos de três meses no lado esquerdo da página serão desabilitados.';
$helptxt['cal_display_type'] = 'Essa configuração permite alterar o tipo de exibição do calendário.<br><br><strong>Confortável:</strong> torna as linhas do calendário grandes.<br><strong>Compacto:</strong> torna o linhas do calendário pequenas.';
$helptxt['cal_week_links'] = 'Se essa configuração estiver marcada, links serão adicionados ao lado de cada semana no calendário.';
$helptxt['cal_prev_next_links'] = 'Se esta configuração estiver marcada, os links para o mês anterior e o próximo mês serão adicionados ao topo de cada mês para facilitar a navegação.';
// argument(s): $txt['months_short'][1], $txt['months_titles'][1]
$helptxt['cal_short_months'] = 'Se esta configuração estiver marcada, os nomes dos meses no calendário serão abreviados.<br><br><strong>Ativado:</strong> %1$s 1<br><strong>Desativado:</strong> %2$s 1';
// argument(s): $txt['days_short'][1], $txt['days'][1]
$helptxt['cal_short_days'] = 'Se esta configuração estiver marcada, os nomes dos dias no calendário serão abreviados.<br><br><strong>Ativado:</strong> %1$s<br><strong>Desativado:</strong> %2$s';

$helptxt['serversettings'] = '<strong>Configurações do Servidor</strong><br>
	Aqui é possível executar a configuração central do seu fórum. Esta seção inclui as configurações da base de dados e URL, bem como outras
	importantes configurações tais como as de e-mail e as de cache. Tenha cuidado sempre que editar alguma destas configurações, já que basta um erro para que o fórum fique inacessível';
$helptxt['manage_files'] = '
	<ul class="normallist">
		<li>
			<strong>Ver arquivos</strong><br>
			Veja todos os anexos, avatares e miniaturas armazenados pelo SMF.<br><br>
		</li><li>
			<strong>Configurações de anexos</strong><br>
			Configure onde os anexos são armazenados e define as restrições no tipo de anexos.<br><br>
		</li><li>
			<strong>Configurações de avatares</strong><br>
			Configure onde os avatares são armazenados e faça o gerenciamento do redimensionamento dos avatares.<br><br>
		</li><li>
			<strong>Manutenção de arquivos</strong><br>
			Verifique e repare qualquer erro no diretório de anexos e exclui os anexos selecionados.<br><br>
		</li>
	</ul>';

$helptxt['topicSummaryPosts'] = 'Isso permite que você defina o número de postagens anteriores mostradas no resumo do tópico na página de resposta.';
$helptxt['enableAllMessages'] = 'Defina isto para o número <em>máximo</em> de mensagens que um tópico pode ter para mostrar o link "todas". Ao definir isto para um valor mais baixo do que o &quot;Número máximo de mensagens para mostrar na página do tópico&quot; significa que o link nunca será mostrado. Se definir para um valor superior pode tornar o fórum muito lento.';
$helptxt['allow_guestAccess'] = 'Desmarcar esta caixa impedirá que os visitantes realizem apenas ações muito básicas em seu fórum - login, registro, lembrete de senha, etc. Isso não é o mesmo que proibir o acesso de visitantes às seções.';
$helptxt['userLanguage'] = 'Ativar essa configuração permitirá que os usuários selecionem o arquivo de idioma que usarão.
		Isso não afetará a seleção padrão.';
$helptxt['trackStats'] = 'Estatísticas<br>Isto irá permitir que os usuários possam ver as últimas mensagens e os tópicos mais populares do Fórum.
		Irá também mostrar várias estatísticas, tal como o maior número de membros online, novos membros e novos tópicos.<hr />
		Vistas de página:<br>Adiciona outra coluna às estatísticas com o número de Hits no Fórum.';
$helptxt['titlesEnable'] = 'Ativar os Títulos Personalizados permitirá que membros com permissão criem um título especial para si próprios.
		Isso será mostrado abaixo do nome.<br><em>Por exemplo:</em><br>Jeff<br>Cara Legal';
$helptxt['onlineEnable'] = 'Isto irá mostrar uma imagem a indicar se o membro está online ou offline';
$helptxt['todayMod'] = 'Isto irá mostrar &quot;Hoje&quot; ou &quot;Ontem&quot; em vez da data.<br><br>
		<strong>Exemplos:</strong><br><br>
		<ul class="normallist">
			<li>
			<strong>Desligado</strong><br>
			3 de Outubro de 2009 às 12:59:18</li>
			<li><strong>Apenas hoje</strong><br>
			Hoje às 12:59:18</li>
			<li><strong>Hoje &amp; Ontem</strong><br>
			Ontem às 21:36:55</li>
		</ul>';
$helptxt['disableCustomPerPage'] = 'Marque esta opção para bloquear os usuários de personalizarem a quantidade de mensagens e tópicos para serem exibidos por página no índice de mensagens e nas páginas dos tópicos respectivamente.';
$helptxt['enablePreviousNext'] = 'Isto irá mostrar um link para o tópico seguinte e para o tópico anterior.';
$helptxt['pollMode'] = 'Isto permite definir se as enquetes estão ativadas ou não. Se as enquetes estiverem desativadas, todas as enquetes existentes serão escondidas
		da lista de tópicos. Pode escolher continuar a mostrar os tópicos com enquetes selecionando a opção
		&quot;mostrar enquetes como Tópicos&quot;.<br><br>Para escolher quem pode iniciar novas enquetes, ver as enquetes, etc,
		basta editar as permissões necessárias. Lembre-se disto se as enquetes não estiverem a funcionar por alguma razão.';
$helptxt['enableCompressedOutput'] = 'Esta opção irá comprimir os dados de modo a poupar largura de banda, 
		no entanto é necessário ter o zlib instalado no seu servidor.';
$helptxt['httponlyCookies'] = 'Cookies não serão acessíveis por linguagens de script, como JavaScript. Esta configuração pode ajudar a reduzir o roubo de identidade através de ataques XSS. Isso pode causar problemas com scripts de terceiros, mas deve estar ativo sempre que possível.';
$helptxt['samesiteCookies'] = 'O SameSite atribui à resposta HTTP que define o cookie se o seu cookie deve ser restrito a um contexto primário ou do mesmo site. Para obter mais informações, consulte <a href="https://developer.mozilla.org/docs/Web/HTTP/Headers/Set-Cookie/SameSite">MDN</a>';
$helptxt['databaseSession_enable'] = 'Esta opção usa a base de dados para o armazenamento das sessões - ajuda nos problemas de expiração da sessão e pode tornar o fórum mais rápido.';
$helptxt['databaseSession_loose'] = 'Ativar esta opção diminuirá a largura de banda que seu fórum usa e fará com que clicar novamente não recarregue a página - a desvantagem é que os (novos) ícones não serão atualizados, entre outras coisas (a menos que você clique nessa página em vez de voltar).';
$helptxt['databaseSession_lifetime'] = 'Este é o número de segundos que as sessões duram depois de não terem sido acessadas. Se uma sessão não for acessada por muito tempo, diz-se que ela &quot;expirou o tempo limite&quot;. Qualquer valor superior a 2400 é recomendado.';
$helptxt['tfa_mode'] = 'Você pode adicionar um segundo nível de segurança ao seu fórum ativando a <a href="https://en.wikipedia.org/wiki/Two_factor_authentication">Autenticação de dois fatores</a>. A A2F força seus usuários a adicionar um código gerado por máquina após o login normal. É necessário configurar a A2F para si mesmo antes de poder forçá-la para outros usuários!';
$helptxt['cache_enable'] = 'O SMF executa o cache em uma variedade de níveis. Quanto mais alto o nível de cache habilitado, mais tempo de CPU será gasto recuperando informações armazenadas em cache. Se o cache estiver disponível em sua máquina, é recomendado que você tente fazer cache no nível 1 primeiro.';
$helptxt['cache_memcached'] = 'Se você estiver usando o memcached, precisará fornecer os detalhes do servidor. Isso deve ser inserido como uma lista separada por vírgulas, conforme mostrado no exemplo abaixo:<br><br> &quot;server1,server2,server3:port,server4&quot;<br><br>Observe que se nenhuma porta for especificada, o SMF usará porta 11211, a menos que o host contenha uma barra, será considerado um transporte alternativo e a porta será definida como 0. O SMF tentará executar o balanceamento de carga aproximado/aleatório nos servidores especificados.';
$helptxt['cache_cachedir'] = 'Esta configuração é apenas para o sistema de cache baseado em arquivos smf. Ele especifica o caminho para o diretório de cache. É recomendável que você coloque isso em /tmp/ se você vai usar isso, embora ele funcionará em qualquer diretório';
$helptxt['cache_sqlite_cachedir'] = 'Esta configuração é apenas para o sistema de cache do banco de dados SQLite. Ele especifica o caminho para o diretório de cache. É recomendado colocar isso em /tmp/ se for usar, embora funcione em qualquer diretório';
$helptxt['enableErrorLogging'] = 'Isso irá registrar qualquer erro, como falha no login, para poder ver o que deu errado.';
$helptxt['enableErrorQueryLogging'] = 'Isso incluirá a consulta completa enviado para o banco de dados no log de erro. Erro requer registro ligado.<br><br><strong> Nota: Isto vai afetar a capacidade de filtrar o log de erro com a mensagem de erro.</strong>';
$helptxt['disallow_sendBody'] = 'Essa configuração remove a opção de receber o texto de respostas, postagens e mensagens pessoais em e-mails de notificação.<br><br>Frequentemente, os membros responderão ao e-mail de notificação, o que na maioria dos casos significa que o webmaster receberá a resposta.';
$helptxt['enable_ajax_alerts'] = 'Esta opção permite que seus membros recebam notificações AJAX. Isso significa que os membros não precisam atualizar a página para receber novas notificações.<br><strong>OBSERVAÇÃO:</strong> esta opção pode causar uma carga severa em seu servidor com muitos usuários online.';
$helptxt['alerts_auto_purge'] = 'Depois que um alerta for lido, ele raramente será necessário novamente. Por motivos de desempenho, é bom excluí-los automaticamente depois de um tempo.';
$helptxt['jquery_source'] = 'Isso determinará a fonte usada para carregar a biblioteca jQuery. <em>Google CDN, jQuery CDN</em> e <em>Microsoft CDN</em> carregarão a biblioteca jQuery dessas respectivas redes CDN. <em>Local</em> usará apenas a fonte local. <em>Personalizado</em> permite especificar uma URL personalizada para a biblioteca.';
$helptxt['compactTopicPagesEnable'] = 'Isto simplesmente mostra a o número de páginas.<br><i>Exemplo:</i>
		&quot;3&quot; para mostrar: 1 ... 4 [5] 6 ... 9 <br>
		&quot;5&quot; para mostrar: 1 ... 3 4 [5] 6 7 ... 9';
$helptxt['timeLoadPageEnable'] = 'Isso mostrará o tempo em segundos que o SMF levou para criar a página na parte inferior do fórum.';
$helptxt['removeNestedQuotes'] = 'Isso removerá as citações aninhadas de uma postagem ao citar a postagem em questão por meio de um link de citação.';
$helptxt['max_image_width'] = 'Isso permite que você defina um tamanho máximo para as fotos postadas. Imagens menores que o máximo não serão afetadas. Isso também determina como as imagens anexadas serão exibidas quando uma miniatura for clicada.';
$helptxt['mail_type'] = 'Esta configuração permite que você escolha as configurações padrão do PHP ou substitua essas configurações pelo SMTP. O PHP não suporta o uso de autenticação com SMTP (que muitos hosts exigem agora), então se você quiser, você deve selecionar o SMTP. Observe que o SMTP pode ser mais lento e alguns servidores não aceitam nomes de usuário e senhas.<br><br>Você não precisa preencher as configurações de SMTP se estiver definido como o padrão do PHP.';
$helptxt['attachment_manager_settings'] = 'Anexos são arquivos que os membros podem carregar e anexar a uma postagem. Sites diferentes podem usá-los de maneiras diferentes, que você pode configurar aqui.';
$helptxt['attachmentCheckExtensions'] = 'Para algumas comunidades, você pode querer limitar os tipos de arquivos que os usuários podem enviar, verificando a extensão: por exemplo. minhafoto.jpg tem uma extensão jpg.';
// References setting attachmentCheckExtensions
$helptxt['attachmentExtensions'] = 'Se a opção "verificar extensão do anexo" acima estiver habilitada, estas são as extensões que serão permitidas para novos anexos.';
$helptxt['attachmentUploadDir'] = 'O caminho para a pasta de anexos no servidor<br>(exemplo: /home/sites/yoursite/www/forum/anexos)';
$helptxt['attachmentDirSizeLimit'] = 'Selecione o tamanho da pasta de anexos, incluindo todos os arquivos dentro dela.';
$helptxt['attachmentPostLimit'] = 'Selecione o tamanho máximo de arquivo (em KB) de todos os anexos feitos por postagem. Se for menor que o limite por anexo, esse será o limite.';
$helptxt['attachmentSizeLimit'] = 'Selecione o tamanho máximo de arquivos em cada anexo separado.';
$helptxt['attachmentNumPerPostLimit'] = 'Selecione o número de anexos que uma pessoa pode fazer por postagem.';
$helptxt['attachmentShowImages'] = 'Se o arquivo enviado for uma imagem, ela será exibida abaixo da postagem.';
$helptxt['attachmentThumbnails'] = 'Se a configuração acima for selecionada, isso salvará um anexo separado (menor) para a miniatura, para diminuir a largura de banda.';
$helptxt['attachmentThumbWidth'] = 'Usado apenas com a opção &quot;Redimensionar imagens ao mostrar nas postagens&quot;. Esta é a largura máxima para redimensionar anexos. Eles serão redimensionados proporcionalmente.';
$helptxt['attachmentThumbHeight'] = 'Usado apenas com a opção &quot;Redimensionar imagens ao mostrar nas postagens&quot;. Esta é a altura máxima para redimensionar anexos. Eles serão redimensionados proporcionalmente.';
$helptxt['attachmentDirFileLimit'] = 'Número máximo de arquivos por diretório';
$helptxt['attachmentEnable'] = 'Esta opção permite configurar como os anexos são feitos.<br><br>
	<ul class="normallist">
		<li>
			<strong>Desativar anexos</strong><br>
			Todos os anexos são desativados. Os anexos existentes não são excluídos, mas ficaram escondidos (nem mesmo os administradores podem ver). Novos anexos não podem ser feitos, independentemente das permissões.<br><br>
		</li>
		<li>
			<strong>Permitir todos os anexos</strong><br>
			Se tudo funcionar normalmente, os usuários com permissão para visualizar anexos podem fazê-lo e os usuários com permissão para fazer envios também podem fazê-lo.<br><br>
		</li>
		<li>
			<strong>Desativar novos anexos</strong><br>
			Os anexos existentes ainda são acessíveis, mas nenhum novo anexo pode ser adicionado, independentemente das permissões.
		</li>
	</ul>';
$helptxt['attachment_image_paranoid'] = 'Selecionar esta configuração permitirá verificações de segurança muito rigorosas em anexos de imagens. <strong>Atenção!</strong> Essas verificações extensivas também podem falhar em imagens válidas. É altamente recomendável usar esta configuração apenas junto com a recodificação da imagem, para que o SMF tente reamostrar as imagens que falham nas verificações de segurança: se forem bem-sucedidas, elas serão limpas e carregadas. Caso contrário, se a recodificação de imagem não estiver habilitada, todos os anexos que falharem na verificação serão rejeitados.';
$helptxt['attachment_image_reencode'] = 'Selecionar esta opção permitirá tentar re-codificar os anexos de imagens carregadas. Re-codificação de imagem oferece uma melhor segurança. Note, porém, que a imagem re-codificação também processa todas imagens animadas estáticas. <br> Este recurso só é possível se o módulo GD estiver instalado no seu servidor.';
$helptxt['attachment_thumb_memory'] = 'Quanto maior a imagem de origem (tamanho e largura x altura), maiores serão os requisitos de memória para o sistema criar uma imagem em miniatura com sucesso.<br>Marcando esta opção, o sistema estimará a memória necessária e então solicitará essa quantidade. Se for bem-sucedido, ele tentará criar a miniatura.<br>Isso resultará em menos erros de página em branco, mas poderá resultar na criação de menos miniaturas. Deixar esta opção desmarcada sempre fará com que o sistema tente criar a miniatura (com uma quantidade fixa de memória). Isso pode resultar em mais erros de página em branco.';
$helptxt['attachmentRecodeLineEndings'] = 'O script recodificará os delimitadores de acordo com seu servidor.';
$helptxt['automanage_attachments'] = 'Por padrão, o SMF coloca novos anexos em uma única pasta. Para a maioria dos sites isso não é um problema, mas à medida que um site cresce pode ser útil ter várias pastas para armazenar anexos.<br><br>Essa configuração permite que você configure se você gerencia essas pastas você mesmo (e. criar uma segunda pasta e movê-la quando estiver pronto) ou se deixar que a SMF o faça, com base nos critérios, como quando o diretório atual atinge um determinado tamanho, ou quando as pastas são divididas por anos ou mesmo meses em sites muito ocupados.';
$helptxt['dont_show_attach_under_post'] = 'Se ativado, os anexos incorporados na postagem não aparecerão na postagem, mas ainda poderão ser excluídos.';
$helptxt['use_subdirectories_for_attachments'] = 'Crie novos diretórios.';
$helptxt['max_image_height'] = 'Como a largura máxima, esta configuração indica a altura máxima que uma imagem postada pode ser.';
$helptxt['avatar_paranoid'] = 'Selecionar esta configuração permitirá verificações de segurança muito rigorosas nos avatares. <strong>Atenção!</strong> Essas verificações extensivas também podem falhar em imagens válidas. É altamente recomendável usar esta configuração apenas junto com a recodificação do avatar, para que o SMF tente reamostrar as imagens que falham nas verificações de segurança: se forem bem-sucedidas, elas serão limpas e carregadas. Caso contrário, se a recodificação de avatares não estiver habilitada, todos os avatares que falharem na verificação serão rejeitados.';
$helptxt['avatar_reencode'] = 'Selecionar esta opção permitirá tentar re-codificar os avatares carregados. Re-codificação de imagem oferece uma melhor segurança. Note, porém, que a imagem re-codificada também processa todas imagens animada estáticas. <br>Este recurso só é possível se o módulo GD está instalado no seu servidor.';
$helptxt['cal_enabled'] = 'O calendário pode ser usado para mostrar aniversários ou eventos importantes que acontecem em sua comunidade. Esta configuração ativa o calendário e todos os seus recursos.';
$helptxt['cal_link_postevent'] = 'Isso permitirá que os membros postem eventos para aquele dia, quando clicarem nessa data';
$helptxt['cal_maxdays_advance'] = 'Se estiver definido para 7, os eventos da próxima semana serão mostrados';
$helptxt['cal_allow_unlinkedevents'] = 'Permitir que os membros postem eventos sem exigir que eles estejam vinculados a uma postagem em um fórum';
$helptxt['cal_min_year'] = 'Selecione o &quot;primeiro&quot; ano na lista do calendário';
$helptxt['cal_max_year'] = 'Selecione o &quot;último&quot; ano na lista do calendário';
$helptxt['cal_maxevent_span'] = 'Selecione o número máximo de dias que um evento pode durar';
$helptxt['localCookies'] = 'O SMF usa cookies para guardar informações sobre o login dos membros nos seus computadores.
	Os cookies podem ser armazenadas globalmente (meuservidor.com) ou localmente (meuservidor.com/caminho/para/forum).<br><br>
	Tente esta configuração se estiver tendo problemas com usuários sendo desconectados automaticamente<hr>
	Os cookies armazenadas globalmente são menos seguros quando são usadas num servidor compartilhado (como o Tripod).<hr>
	Os cookies locais não funcionam fora do diretório do fórum, portanto, se o seu fórum estiver armazenado em www.myserver.com/forum, páginas como www.myserver.com/index.php não poderão acessar as informações da conta.<br><br>
	Cookies globais são especialmente recomendados ao usar o SSI.php, mas funcionam bem para a maioria dos sites em seu próprio domínio.';
$helptxt['enableBBC'] = 'Selecionar esta configuração permitirá que seus membros usem o Bulletin Board Code (BBC) em todo o fórum, permitindo que os usuários formatem suas postagens com imagens, tipo de formatação e muito mais.';
$helptxt['legacy_bbc'] = 'BBCodes legados são obsoletos e não podem ser usados em novas postagens. Porém, eles serão analisados em postagens existentes se ativados aqui.<br><br>Ativar BBCodes legados só será útil se o seu fórum tiver sido atualizado a partir de uma versão anterior do SMF.<br><br>Além disso, mesmo quando eles estiverem ativados, alguns deles não serão renderizados da mesma forma como eram antes. Por exemplo, o BBCode [flash] simplesmente mostrará um link para o conteúdo Flash em vez de incorporá-lo.';
$helptxt['default_timezone'] = 'Este é o fuso horário padrão usado para exibição dos horários em todo o fórum.';
$helptxt['timezone_priority_countries'] = 'Essa configuração permite colocar os fusos horários de um determinado país ou países no topo da lista de fusos horários selecionáveis que é mostrada quando os usuários estão configurando seus perfis, criando eventos de calendário, etc.<br><br>Por exemplo, se muitos dos membros do seu fórum moram na Nova Zelândia ou Fiji, você pode inserir "NZ,FJ" para facilitar a localização rápida dos fusos horários mais relevantes.<br><br>Você pode encontrar a lista completa de código ISO dos países pesquisando na Internet por "<a href="https://www.google.com/search?q=iso+3166-1+alpha-2" target="_blank" rel="noopener">ISO 3166- 1 alfa-2</a>".';
$helptxt['spamWaitTime'] = 'Aqui você pode selecionar a quantidade de tempo que deve passar entre as postagens. Isso pode ser usado para impedir que as pessoas façam "spam" em seu fórum, limitando a frequência com que elas podem postar.';

$helptxt['enablePostHTML'] = 'Isso permitirá inserir algumas tags básicas de HTML:
	<ul class="normallist">
		<li>&lt;b&gt;, &lt;u&gt;, &lt;i&gt;, &lt;s&gt;, &lt;em&gt;, &lt;strong&gt;, &lt;ins&gt;, &lt;del&gt;</li>
		<li>&lt;a href=&quot;&quot;&gt;</li>
		<li>&lt;img src=&quot;&quot; alt=&quot;&quot; /&gt;</li>
		<li>&lt;br&gt;, &lt;hr&gt;</li>
		<li>&lt;pre&gt;, &lt;blockquote&gt;</li>
	</ul>';

$helptxt['themes_manage'] = 'Aqui você pode instalar novos temas e selecionar quais temas seus usuários podem escolher, o tema padrão que novos usuários e visitantes usarão, bem como outras configurações de seleção de temas.';
$helptxt['theme_install'] = 'Isso permite que você instale novos temas. Você pode fazer isso a partir de um diretório existente, carregando um arquivo para o tema ou copiando o tema padrão.<br><br>Observe que o arquivo ou diretório deve ter um arquivo de definição <pre>theme_info.xml</pre>.';
$helptxt['xmlnews_enable'] = 'Permite que as pessoas acessem as <a href="%1$s?action=.xml;sa=news" target="_blank" rel="noopener">Notícias recentes</a>
	e dados semelhantes. Também é recomendado que você limite o tamanho das postagens/notícias recentes porque alguns clientes esperam que os dados RSS sejam truncados para exibição.';
$helptxt['xmlnews_attachments'] = 'Permite que links para anexos sejam incluídos em seus feeds XML/RSS. Ative esta opção se quiser usar seu fórum como uma plataforma de podcasting, transmissão ou distribuição de conteúdo semelhante.
	<br><br>
	A permissão "ver anexos" afeta esta configuração. Membros e visitantes só verão os anexos de uma postagem no feed se também puderem ver os anexos na página do site da postagem. Lembre-se de que a maioria dos leitores de feed acessará seus feeds como visitante.
	<br><br>
	Alguns formatos de feed permitem apenas um anexo incluído por postagem. Se uma postagem tiver vários anexos, o SMF incluirá o maior deles nesses feeds.';
$helptxt['globalCookies'] = 'Disponibiliza cookies de login em subdomínios. Por exemplo, se...<br>
	seu site é https://www.exemplo.com/,<br>
	e seu fórum é https://forum.exemplo.com/,<br>
	usar esta configuração permitirá que você acesse o cookie do fórum em seu site. Não ative esta opção se houver outros subdomínios (como hacker.exemplo.com) que não sejam controlados por você.<br><br>
	Esta configuração não funciona quando os cookies locais estão ativados.';
$helptxt['globalCookiesDomain'] = 'Ao usar cookies independentes de subdomínio (cookies globais), é possível especificar qual domínio deve ser usado para eles. É claro que isso deve ser definido para seu domínio principal - por exemplo, se estiver usando <em>forum.example.com</em> e <em>www.example.com</em>, o domínio é <em>example.com</em> neste caso. Você não deve colocar <em>http://</em> ou <em>https://</em> antes do domínio.';
$helptxt['secureCookies'] = 'Ativar esta configuração forçará os cookies criados para os usuários do seu fórum a serem marcados como seguros. Habilite esta configuração apenas se você estiver usando HTTPS em todo o seu site, caso contrário, ninguém conseguirá fazer o login corretamente!';
$helptxt['securityDisable'] = 'Quando ativado, <em>desativa</em> a verificação de senha adicional para a página de administração. Isso não é recomendado!';
$helptxt['securityDisable_why'] = 'Digite sua senha atual. (A mesma que você usa para fazer login.)<br><br>O requisito para inserir isso ajuda a garantir de que é <strong>você mesmo</strong> que está fazendo essas alterações.';
$helptxt['securityDisable_moderate'] = 'Quando ativado, <em>desativa</em> a verificação de senha adicional para a página de moderação. Esta configuração está habilitada por padrão.';
$helptxt['securityDisable_moderate_why'] = 'Digite sua senha atual. (A mesm que usa para fazer login.)<br><br>O requisito para inserir isso ajuda a garantir que você deseja fazer qualquer ação de moderação que estiver fazendo e que é <strong>você mesmo</strong> que está fazendo isso.';
$helptxt['allow_cors'] = 'Cross Origin Resource Sharing ou CORS é uma política para navegadores modernos confiarem nos recursos solicitados em diferentes domínios. Se ativado, ele tentará resolver a política CORS para scripts que acessam os recursos do fórum de diferentes domínios. Se os cookies independentes de subdomínio (cookies globais) estiverem ativados, serão feitas tentativas para determinar o domínio adequado. Fornecer aos domínios CORS adicionais uma lista de domínios separados por vírgula permite domínios adicionais. O formato deve ser {SCHEMA}://{DOMAIN}. Se um curinga (*) for fornecido no domínio, serão feitas tentativas para resolver o curinga. Se um curinga (*) for fornecido como único domínio adicional, todos os domínios serão permitidos e isso pode representar um risco de segurança para o seu fórum e não deve ser usado exceto em casos extremos. Cabeçalhos adicionais podem ser fornecidos em uma lista separada por vírgulas e serão permitidos durante solicitações contendo esses cabeçalhos e caracteres curinga (*) são permitidos.';
$helptxt['frame_security'] = 'Os navegadores modernos agora entendem um cabeçalho de segurança apresentado por servidores chamado X-Frame-Options. Ao definir esta opção você especifica como deseja permitir que seu site seja enquadrado dentro de um conjunto de quadros ou iframe. Desabilitar não enviará nenhum cabeçalho e é bem mais inseguro, porém permite mais liberdade. Negar impedirá completamente todos os frames e é o mais restritivo e seguro. Permitir a mesma origem permitirá apenas que seu domínio emita frames e fornecerá um meio-termo para as duas opções anteriores.';
$helptxt['proxy_ip_header'] = 'Este é o cabeçalho do servidor que será confiável pelo SMF para conter o endereço de IP real dos usuários. Alterar esta configuração pode causar resultados de IP inesperados aos membros. Verifique com o administrador do servidor, provedor de CDN ou administrador de proxy antes de alterar essas configurações. A maioria dos provedores entenderá e usará HTTP_X_FORWARDED_FOR. Você deve preencher a lista de servidores que enviam os cabeçalhos do proxy reverso por segurança para garantir que esses cabeçalhos venham apenas de fontes válidas.';
$helptxt['email_members'] = 'Nesta mensagem, você pode usar algumas &quot;variáveis&quot;. São elas:<br>
	{$board_url} - A URL do seu fórum.<br>
	{$current_time} - A hora atual.<br>
	{$member.email} - O e-mail atual do membro.<br>
	{$member.link} - O link atual do membro.<br>
	{$member.id} - O ID atual do membro.<br>
	{$member.name} - O nome atual do membro. (para personalização).<br>
	{$latest_member.link} - O link para o membro registrado mais recentemente.<br>
	{$latest_member.id} - O ID do membro registrado mais recentemente.<br>
	{$latest_member.name} - O nome do membro registrado mais recentemente.';

$helptxt['failed_login_threshold'] = 'Defina o número de tentativas de login malsucedidas antes de direcionar o usuário para a página de lembrete de senha.';
$helptxt['loginHistoryDays'] = 'O número de dias para manter o histórico de login no monitoramento do perfil do usuário. O padrão é 30 dias.';
$helptxt['oldTopicDays'] = 'Se esta configuração estiver habilitada, um aviso será exibido ao usuário ao tentar responder a um tópico que não recebeu novas respostas durante o período de tempo, em dias, especificado por esta configuração. Defina esta configuração como 0 para desativar o recurso.';
$helptxt['edit_wait_time'] = 'O número de segundos permitidos para uma postagem ser editada antes de registrar a data da última edição.';
$helptxt['edit_disable_time'] = 'O número de minutos permitidos antes que um usuário não possa mais editar uma postagem que fez. Defina como 0 para desabilitar. <br><br><em>Nota: Isso não afetará nenhum usuário que tenha permissão para editar as postagens de outras pessoas.</em>';
$helptxt['preview_characters'] = 'Esta configuração define o número de caracteres disponíveis para a primeira e a última visualização do tópico da mensagem.';
$helptxt['quote_expand'] = 'Essa configuração permite que citações grandes sejam recolhidas, dando ao usuário a opção de expandi-las em todo o seu comprimento. Citações menores que esta configuração não serão afetadas.';
$helptxt['posts_require_captcha'] = 'Essa configuração forçará os usuários a passarem na verificação do bot anti-spam sempre que fizerem uma postagem em uma seção. Somente usuários com contagem de postagens abaixo do número definido precisarão inserir o código – isso deve ajudar a combater scripts de spam automatizados.';
$helptxt['disable_wysiwyg'] = 'Esta configuração impede que todos os usuários usem o editor WYSIWYG (&quot;What You See Is What You Get&quot;) na página de postagem.';
$helptxt['lastActive'] = 'Defina o número de minutos para mostrar os usuários ativos nesse período de tempo no índice do fórum. O tempo padrão é de 15 minutos.';

$helptxt['customoptions'] = 'Esta seção define as opções que o usuário pode escolher em uma lista suspensa. Existem alguns pontos-chave a serem observados nesta página:
	<ul>
		<li><strong>Configuração padrão:</strong> qualquer caixa de seleção que tenha o &quot;botão&quot; próximo a ele será a opção padrão para o usuário quando ele entrar em seu perfil.</li>
		<li><strong>Removendo opções:</strong> para remover uma opção, basta esvaziar a caixa de texto dessa opção - todos os usuários com essa opção selecionada terão sua opção desmarcada.</li>
		<li><strong>Opções de reordenação:</strong> você pode reordenar as opções movendo o texto entre as caixas. No entanto - uma observação importante - você <strong>não</strong> deve alterar o texto ao reordenar as opções, caso contrário os dados do usuário serão perdidos.</li>
	</ul>';

$helptxt['autoFixDatabase'] = 'Isso corrigirá automaticamente as tabelas quebradas e continuará como se nada tivesse acontecido. Você receberá um e-mail se isso acontecer.<br>Se optar por desativar esta opção, seu fórum ficará inativo até que você perceba e corrija manualmente o problema.';
// argument(s): scripturl
$helptxt['pgFulltextSearch'] = 'Esta configuração define o idioma a ser usado para a pesquisa de texto completo do PostgreSQL. Escolha o idioma que mais se aproxima do idioma que seu fórum realmente usa. Se o idioma do seu fórum não estiver listado ou se o seu fórum for multilíngue, escolha a opção “simples”. <br>
Essa configuração é independente das configurações principais de idioma do SMF e não está relacionada ao idioma instalado para o SMF. <br>
Ao alterar essa configuração, você precisa <a href="%1$s?action=admin;area=managesearch;sa=method" target="_blank" rel="noopener">reconstruir o índice de pesquisa de texto completo</a>.<br>
Se um idioma que você precisa não estiver listado, peça ao administrador do banco de dados para instalar o suporte ao idioma PostgreSQL para esse idioma.';

$helptxt['enableParticipation'] = 'Isso mostra um pequeno ícone nos tópicos em que o usuário postou.';

$helptxt['db_persist'] = 'Isso mantém a conexão ativa para aumentar o desempenho. Se você não estiver em um servidor dedicado, isso poderá causar problemas com seu host.<br>
Se esta opção estiver desabilitada, pode ser necessário habilitar a configuração mysqli.allow_persistent ou pgsql.allow_persistent em seu arquivo php.ini.';
$helptxt['ssi_db_user'] = 'Configuração opcional para usar um banco de dados usuário e senha diferentes quando você estiver usando SSI.php.';

// argument(s): either $helptxt['queryless_urls_supported'] or $helptxt['queryless_urls_unsupported'], depending on whether the server uses a supported webserver
$helptxt['queryless_urls'] = 'Isso muda um pouco o formato das URLs para ficarem mais compatíveis com os motores de pesquisa. Elas ficarão parecidas com index.php/topic,1.0.html.<br><br>%1$s';
// is conditionally used as part of $helptxt['queryless_urls']
$helptxt['queryless_urls_supported'] = 'Este recurso funcionará no seu servidor.';
// is conditionally used as part of $helptxt['queryless_urls']
$helptxt['queryless_urls_unsupported'] = 'Este recurso não funcionará no seu servidor.';
$helptxt['minimize_files'] = 'Esta opção minimizará os arquivos CSS e JavaScript usados pelo seu fórum, reduzindo as chamadas de solicitação ao seu servidor e acelerando o tempo de carregamento para seus usuários.<br><br>Normalmente você deve deixar esta opção habilitada. A única ocasião em que você pode querer desativá-la temporariamente é durante o processo de alteração dos arquivos CSS ou JavaScript usados em seu site (por exemplo, ao editar seus arquivos de tema ou desenvolver uma modificação).';
$helptxt['boardindex_max_depth'] = 'Esta configuração controla quantos níveis de subseções o SMF verificará ao procurar novas postagens em subseções. Também afeta quais seções serão incluídas quando a opção "Contar posts em subseções no total da seção mãe" estiver ativada.<br><br>Por exemplo, se for definido como 1, uma subseção só será marcada como "nova" na página de índice se a própria subseção contiver uma nova postagem. Se estiver definido como 2, a subseção será marcada como "nova" se houver uma nova postagem na subseção ou em outra subseção e assim vai até 10 níveis.<br><br>Fóruns grandes e ativos podem querer definir esse valor como um número baixo para conservar os recursos do servidor.';
$helptxt['countChildPosts'] = 'Marcar essa configuração significa que as postagens e os tópicos na subseção de uma seção serão contabilizados no total da página de índice.<br><br>Isso significa que uma seção mãe sem postagens não mostrará \'0\' se houver postagens em suas subseções.';
$helptxt['allow_ignore_boards'] = 'Marcar esta configuração permitirá que os usuários selecionem as seções que desejam ignorar.';
$helptxt['deny_boards_access'] = 'Marcar esta configuração permitirá que você negue acesso a determinadas seções com base no acesso do grupo de membros';

// argument(s): scripturl
$helptxt['who_enabled'] = 'Esta configuração permite ativar ou desativar a página <a href="%1$s?action=who" target="_blank" rel="noopener">Quem está online</a>, que mostra quem está navegando no fórum e o que eles estão fazendo.';

$helptxt['recycle_enable'] = '&quot;Recicla&quot; tópicos e postagens excluídas na seção especificada.';

$helptxt['enableReportPM'] = 'Essa configuração permite que seus usuários relatem mensagens pessoais recebidas à equipe de administração. Isto pode ser útil para ajudar a detectar qualquer abuso do sistema de mensagens pessoais.';
$helptxt['max_pm_recipients'] = 'Esta opção permite definir o número máximo de recipientes permitidos numa mensagem pessoal enviada por um membro do fórum. Isto pode ser usado para evitar o envio de spam através das MP. Note que os membros com permissões para enviar newsletters estão isentos deste limite. Defina para zero para não ter limite.';
$helptxt['pm_posts_verification'] = 'Esta definição irá forçar os usuários a inserir o código mostrado numa imagem de verificação de cada vez que enviam uma mensagem pessoal. Apenas os usuários com um número de mensagens abaixo do número definido terão que inserir este código - isto deve ajudar a combater o spam no seu fórum.';
$helptxt['pm_posts_per_hour'] = 'Isto limitará o número de mensagens pessoais que podem ser enviadas por um usuário no período de uma hora. Isso não afeta administradores ou moderadores.';

$helptxt['default_personal_text'] = 'Define o texto padrão que um novo usuário terá como &quot;texto pessoal&quot;. Esta configuração não está disponível quando o texto pessoal está desativado ou quando os usuários podem definir o texto pessoal na parte de registro.';

$helptxt['registration_method'] = 'Esta opção determina qual o método de registro usado quando alguém se regista no fórum. Pode escolher entre:<br><br>
	<ul class="normallist">
		<li>
			<strong>Registro desativado:</strong><br>
				Desativa o processo de registro, o que significa que não será possível registrar novos membros no fórum.<br>
		</li><li>
			<strong>Registro imediato:</strong><br>
				Os novos membros podem entrar e enviar mensagens imediatamente após o registro.<br>
		</li><li>
			<strong>Ativação por e-mail:</strong><br>
				Quando esta opção está ativada, qualquer membro que se registre no fórum terá de ativar sua conta através de um link que lhe é enviado por email. Enquanto a conta não for ativada, o usuário não pode entrar no fórum.<br>
		</li><li>
			<strong>Aprovação do administrador:</strong><br>
				Esta opção fará com que cada novo membro que se registre no fórum tenha que ser aprovado pelo administrador antes de poder entrar.
		</li>
	</ul>';

$helptxt['send_validation_onChange'] = 'Quando esta opção está ativada, todos os membros que alterem o seu endereço de email no perfil terão de reativar a sua conta através de um email enviado para o endereço indicado.';
$helptxt['approveAccountDeletion'] = 'Quando essa configuração estiver marcada, qualquer solicitação de usuário para excluir sua própria conta deve ser aprovada por um administrador';

$helptxt['send_welcomeEmail'] = 'Quando esta opção está ativada, todos os novos membros receberão um email de boas-vindas ao Fórum.';
$helptxt['password_strength'] = 'Determina o tamanho mínimo da senha. Quanto maior, menos possibilidade de ser violada, logo é mais segura.
	Opções disponíveis:
	<ul class="normallist">
		<li><strong>Baixa:</strong> A senha tem de ter pelo menos 4 caracteres.</li>
		<li><strong>Média:</strong> A senha tem que ter pelo menos oito caracteres e não pode conter o nome ou e-mail do usuário.</li>
		<li><strong>Alta:</strong> Similar a média, exceto que a senha também deve conter uma mistura de letras maiúsculas e minúsculas e pelo menos um número.</li>
	</ul>';
$helptxt['enable_password_conversion'] = 'Ao permitir essa configuração, SMF tentará detectar senhas armazenadas em outros formatos e convertê-las para o formato usado pelo SMF. Normalmente, isso é usado para fóruns convertidos para SMF, mas pode ter outras utilizações. Desabilitar isto impede que um usuário faça o login usando sua senha após uma conversão e seria preciso redefinir sua senha.';

$helptxt['coppaAge'] = 'The value specified in this box will determine the minimum age that new members must be in order to be granted immediate access to the forum.
	On registration they will be prompted to confirm whether they are over this age, and if not will either have their application rejected or suspended awaiting parental approval - dependent on the type of restriction chosen.
	If a value of 0 is chosen for this setting then all other age restriction settings shall be ignored.';
$helptxt['coppaType'] = 'Se as restrições de idade estiverem ativas, estas serão as definições do que acontecerá se o usuário tiver idade inferior. Existem duas hipóteses:
	<ul class="normallist">
		<li>
			<strong>Rejeitar o registro:</strong><br>
				Qualquer membro que viole a idade mínima terá seu registro imediatamente rejeitado.<br>
		</li><li>
			<strong>Requerer aprovação paternal:</strong><br>
				Qualquer membro que tente registrar-se e viole a idade mínima verá a sua conta marcada como "Aguardando aprovação dos pais/responsáveis". Só depois tem acesso ao fórum.
				Podem acessar aos contatos de forma a enviar o formulário de aprovação aos administradores por e-mail ou fax.
		</li>
	</ul>';
$helptxt['coppaPost'] = 'As caixas de contato são necessárias para que os formulários de autorização de inscrição de menores possam ser enviados ao administrador do fórum. Esses detalhes serão mostrados a todos os novos menores de idade e são necessários para aprovação dos pais/responsáveis. Deve ser fornecido pelo menos um endereço postal ou número de fax.';

$helptxt['allow_hideOnline'] = 'Com esta configuração ativada, todos os membros poderão ocultar seu estado online de outros usuários (exceto administradores). Observe que desabilitar esta configuração não alterará o estado de nenhum membro existente - apenas impedirá que eles se escondam no futuro.';
$helptxt['meta_keywords'] = 'Essas palavras-chave são enviadas no resultado de cada página para indicar aos mecanismos de busca (etc) o conteúdo principal do seu site. Eles devem ser uma lista de palavras separadas por vírgulas e não devem usar HTML.';

$helptxt['latest_themes'] = 'Esta área mostra alguns dos temas mais recentes e populares do <a href="https://www.simplemachines.org/" target="_blank" rel="noopener">www.simplemachines.org</a>. Porém, podem não exibir corretamente se o seu computador não conseguir acessar o <a href="https://www.simplemachines.org/" target="_blank" rel="noopener">www.simplemachines.org</a>.';

$helptxt['secret_why_blank'] = 'Para sua segurança, sua senha e a resposta à sua pergunta secreta são criptografadas para que o programa do SMF nunca diga a você ou a qualquer outra pessoa qual é.';
$helptxt['moderator_why_missing'] = 'Como a moderação é feita por cada seção, você deve tornar os membros moderadores da <a href="%1$s?action=admin;area=manageboards" target="_blank" rel="noopener"> interface de gerenciamento de seções</a>.';

$helptxt['permissions'] = 'As permissões são a forma como você permite ou proíbe que grupos façam coisas específicas.<br><br>É possível modificar vários painéis de uma vez com as caixas de seleção ou verificar as permissões de um grupo específico clicando em "Modificar"';
$helptxt['permissions_board'] = 'Se um fórum está definido para \'Global,\' significa que o fórum não tem nenhumas permissões especiais. \'Local\' significa que o fórum tem permissões específicas - separadas das permissões globais. Isto permite ter um fórum com mais ou menos permissões do que outro, sem ser necessário defini-las para cada fórum individualmente.';
$helptxt['permissions_quickgroups'] = 'Esta opção permite usar as configurações &quot;padrão&quot; de permissões -  <em>padrão</em> significa \'nada especial\', <em>restritivo</em> significa \'como um visitante\', <em>moderador</em> significa \'o que um moderador tem\', e por último <em>manutenção</em>, que significa \'permissões muito próximas das de um administrador\'.';
$helptxt['permissions_deny'] = 'Negar permissões pode ser útil quando você deseja retirar permissão de determinados membros. Você pode adicionar um grupo de membros com permissão \'negar\' aos membros aos quais deseja negar uma permissão.<br><br><strong>Use com cuidado</strong>, uma permissão negada permanecerá negada, não importa quais outros grupos de membros o membro percence.';
$helptxt['permissions_postgroups'] = 'Ativar permissões para grupos com base na contagem de postagens permitirá que você atribua permissões a membros que postaram uma determinada quantidade de mensagens. As permissões dos grupos baseados na contagem de postagens são <em>adicionadas</em> às permissões dos grupos de membros regulares.';
$helptxt['membergroup_guests'] = 'O grupo de membros Visitantes é para todos os usuários que não estão logados.';
$helptxt['membergroup_regular_members'] = 'Os membros regulares são todos os membros que estão logados, mas que não pertencem a nenhum grupo de membros.';
$helptxt['membergroup_administrator'] = 'O administrador pode, por padrão, fazer qualquer coisa e ver todas as seções. Não há configurações de permissão para o administrador.';
$helptxt['membergroup_moderator'] = 'O grupo de membros moderadores é um grupo especial. As permissões e configurações atribuídas a este grupo se aplicam aos moderadores, mas apenas <em>nas seções que eles moderam</em>. Fora destas seções, eles são como qualquer outro membro. Observe que as permissões para este grupo também se aplicam a qualquer grupo designado para moderar uma seção.';
$helptxt['membergroups'] = 'No SMF há dois tipos de grupos de que os membros podem fazer parte. Estes são:
	<ul class="normallist">
		<li><strong>Grupos normais:</strong> é um grupo em que os membros não são automaticamente inscritos. Para incluir um usuário neste tipo de grupos, é necessário ir ao Perfil e clicar em &quot;Configurações da Conta&quot;. A partir daqui pode incluí-lo em qualquer grupo normal.</li>
		<li><strong>Grupos de postagens:</strong> Ao contrário dos grupos normais, os grupos baseados em postagens não podem ser atribuídos. Em vez disso, os membros são atribuídos automaticamente a um grupo baseado em postagens quando atingem o número mínimo de postagens necessárias para estar nesse grupo.</li>
	</ul>';

$helptxt['calendar_how_edit'] = 'Você pode editar esses eventos clicando no asterisco vermelho (*) ao lado de seus nomes.';

$helptxt['maintenance_backup'] = 'Esta área permite que você salve uma cópia de todas as postagens, configurações, membros e outras informações do seu fórum em um arquivo muito grande.<br><br>Recomenda-se que você faça isso com frequência, talvez semanalmente, para segurança e proteção.';
$helptxt['maintenance_rot'] = 'Isso permite que você remova <strong>completamente</strong> os tópicos antigos. É recomendável que você tente fazer um backup primeiro, caso você remova algo que não pretendia.<br><br><strong>Use esta configuração com cuidado.</strong>';
$helptxt['maintenance_members'] = 'Isso permite que você remova <strong>completamente</strong> e <strong>irrevogavelmente</strong> as contas de membros do seu fórum. É <strong>fortemente</strong> recomendado tentar fazer um backup primeiro, caso você remova algo que não pretendia.<br><br><strong>Use esta configuração com cuidado.</strong>';

$helptxt['avatar_server_stored'] = 'Isso permite que seus membros escolham avatares armazenados no próprio servidor. Por padrão eles são armazenados no diretório "avatares".<br>Como dica, se você criar diretórios nessa pasta, poderá criar "categorias" de avatares.';
$helptxt['avatar_external'] = 'Com isso ativado, seus membros podem digitar uma URL para seus próprios avatares. A desvantagem disso é que, em alguns casos, eles podem usar avatares muito grandes ou imagens que você não deseja em seu fórum.';
$helptxt['avatar_download_external'] = 'Com esta configuração ativada, os avatares externos serão baixados das URLs fornecidas pelos usuários. Caso seja bem-sucedido, os avatares serão tratados como avatares carregados.';
$helptxt['avatar_action_too_large'] = 'Essa configuração permite rejeitar imagens (de outros sites) que sejam muito grandes ou instrui o navegador do usuário a redimensioná-las ou baixá-las para seu servidor.<br><br>Se os usuários colocarem imagens muito grandes como seus avatares e redimensionar no navegador, isso pode causar um carregamento muito lento para seus usuários - na verdade, ele não redimensiona o arquivo, apenas o exibe em tamanho menor. Assim, uma foto digital, por exemplo, ainda seria carregada por completo e depois redimensionada somente quando exibida. Portanto, para os usuários, isso poderia ficar bastante lento e consumir muita largura de banda.<br><br>Por outro lado, baixá-los significa usar sua largura de banda e espaço no servidor, mas também garante que as imagens sejam menores, por isso deve ser mais rápido para os usuários. (Nota: baixar e redimensionar requer a biblioteca GD ou ImageMagick usando as extensões Imagick ou MagickWand)';
$helptxt['avatar_upload'] = 'Essa configuração é semelhante à &quot;avatares externos&quot;, só que você terá mais controle sobre os avatares, como quando redimensionar, e seus usuários não precisarão ter um local para hospedá-los.<br><br>A A desvantagem é que esses avatares podem ocupar muito espaço no seu servidor.';
$helptxt['avatar_download_png'] = 'PNGs são maiores, mas oferecem compactação de melhor qualidade. Se esta opção estiver desmarcada, será usado JPEG no lugar - que geralmente é menor, mas também de qualidade inferior ou desfocada.';

$helptxt['disableHostnameLookup'] = 'Isto desativa a verificação do hostname, o que, em alguns servidores, pode ser muito lento. Note que isto irá tornar o bloqueio menos eficiente.';

$helptxt['smiley_sameall'] = 'Se marcar "Mesma imagem para todos os conjuntos", a mesma imagem será adicionada a todos os seus conjuntos de smileys. Se você desmarcar a caixa, uma imagem diferente poderá ser carregada para cada conjunto de smileys instalado. Observe que uma imagem precisa ser fornecida para cada conjunto de smileys.';

$helptxt['search_weight_frequency'] = 'Os fatores de Peso são usados para determinar a relevância dos resultados da busca. Altere estes fatores para aqueles que acha serem mais adequados para o seu Fórum. Por exemplo, um Fórum de um site de notícias, poderá querer uma maior relevância para o fator \'idade da última mensagem\'. Todos os valores são relativos em relação aos outros e têm de ser valores positivos.<br><br>Este fator conta a quantidade de mensagens coincidentes e divide-as pelo número total de mensagens de cada tópico.';
$helptxt['search_weight_age'] = 'Os fatores de Peso são usados para determinar a relevância dos resultados da busca. Altere estes fatores para aqueles que acha serem mais adequados para o seu Fórum. Por exemplo, um Fórum de um site de notícias, poderá querer uma maior relevância para o fator \'idade da última mensagem\'. Todos os valores são relativos em relação aos outros e têm de ser valores positivos.<br><br>Este fator dá um valor à idade da última mensagem de um tópico. Quanto mais recente for a mensagem, mais alto será o seu valor.';
$helptxt['search_weight_length'] = 'Os fatores de Peso são usados para determinar a relevância dos resultados da busca. Altere estes fatores para aqueles que acha serem mais adequados para o seu Fórum. Por exemplo, um Fórum de um site de notícias, poderá querer uma maior relevância para o fator \'idade da última mensagem\'. Todos os valores são relativos em relação aos outros e têm de ser valores positivos.<br><br>Este fator baseia-se no tamanho do tópico. Quantas mais mensagens tiver um tópico, mais alto será o seu valor.';
$helptxt['search_weight_subject'] = 'Os fatores de Peso são usados para determinar a relevância dos resultados da busca. Altere estes fatores para aqueles que acha serem mais adequados para o seu Fórum. Por exemplo, um Fórum de um site de notícias, poderá querer uma maior relevância para o fator \'idade da última mensagem\'. Todos os valores são relativos em relação aos outros e têm de ser valores positivos.<br><br>Este fator verifica se o termo da busca pode ser encontrado no assunto do tópico.';
$helptxt['search_weight_first_message'] = 'Os fatores de Peso são usados para determinar a relevância dos resultados da busca. Altere estes fatores para aqueles que acha serem mais adequados para o seu Fórum. Por exemplo, um Fórum de um site de notícias, poderá querer uma maior relevância para o fator \'idade da última mensagem\'. Todos os valores são relativos em relação aos outros e têm de ser valores positivos.<br><br>Este fator verifica se o termo da busca pode ser encontrado na primeira mensagem do tópico.';
$helptxt['search_weight_sticky'] = 'Fatores de peso são usados para determinar a relevância de um resultado de pesquisa. Altere esses fatores de peso para corresponder às coisas que são especificamente importantes para o seu fórum. Por exemplo, um fórum de um site de notícias poderá querer um valor relativamente alto para o \'tempo da última mensagem\'. Todos os valores são relativos em relação aos outros e devem ser números positivos.<br><br>Este fator verifica se um tópico é ativo e aumenta a relevância dos resultados.';
$helptxt['search'] = 'Ajuste todas as configurações da função de pesquisa aqui.';
$helptxt['search_why_use_index'] = 'Um índice pode aumentar bastante a velocidade das busca no fórum. Especialmente quando o número de mensagens no fórum vai crescendo, a busca sem um índice pode demorar muito tempo e aumentar a carga no servidor e na base de dados. Se o seu fórum tem mais de 50.000 mensagens, recomendamos a criação de um índice para melhorar o desempenho do seu fórum.<br><br>Note que um índice pode ocupar bastante espaço no servidor. Um índice de texto completo é uma funcionalidade do MySQL. é relativamente compacto (aproximadamente do mesmo tamanho que a tabela de mensagens), mas muitas palavras não são indexadas e pode fazer com que algumas busca se tornem muito lentas. O índice customizado é geralmente maior (dependendo da sua configuração pode ser até 3 vezes o tamanho da tabela de mensagens) mas o seu desempenho é melhor e mais estável do que um índice de texto completo.';

$helptxt['see_admin_ip'] = 'Os endereços de IP são mostrados aos administradores e moderadores para facilitar a moderação e para facilitar o rastreamento de pessoas que são problemáticas. Lembre-se de que os endereços de IP nem sempre são identificáveis e o IP da maioria das pessoas mudam periodicamente.<br><br>Os membros também podem ver seus próprios IPs.';
$helptxt['see_member_ip'] = 'O seu endereço de IP é mostrado apenas a si e aos moderadores. Esta informação não permite identificá-lo, e a maioria dos IPs mudam periodicamente.<br><br>Você não pode ver os IPs dos outros usuários, da mesma forma que eles também não podem ver o seu.';
$helptxt['whytwoip'] = 'O SMF usa vários métodos para detectar endereços IP de usuários. Geralmente estes dois métodos resultam no mesmo endereço, mas em alguns casos mais de um endereço pode ser detectado. Neste caso, o SMF registra os dois endereços mais recentes e usa ambos para verificações de banimento (etc). Você pode clicar em qualquer endereço para rastrear esse IP e bani-lo, se necessário.';

$helptxt['ban_cannot_post'] = 'A restrição \'não é possível postar\' deixa o fórum em modo somente leitura para o usuário banido. Ele não pode criar novos tópicos, nem responder aos já existentes, enviar mensagens pessoais ou votar em enquetes. O usuário banido ainda pode ler mensagens e tópicos pessoais.<br><br>Uma mensagem de aviso é mostrada aos usuários que são banidos desta forma.';

$helptxt['posts_and_topics'] = '
	<ul class="normallist">
		<li>
			<strong>Configurações de postagem</strong><br>
			Modifique as configurações relacionadas à postagem de mensagens e à forma como as mensagens são mostradas. Você também pode ativar a verificação ortográfica aqui.
		</li><li>
			<strong>Bulletin Board Code</strong><br>
			Habilite o código que mostra as mensagens do fórum no layout correto. Ajuste também quais códigos são permitidos e quais não são.
		</li><li>
			<strong>Palavras censuradas</strong>
			Para manter seu fórum sob controle, você pode censurar certas palavras. Esta função permite converter palavras proibidas em versões normais.
		</li><li>
			<strong>Configurações do tópico</strong>
			Modifique as configurações relacionadas aos tópicos. O número de tópicos por página, se a visualização da página impressa está habilitada, etc.
		</li>
	</ul>';

$helptxt['spider_mode'] = 'Define o nível de registro.<br>
Padrão - Registra atividade mínima dos mecanismos de pesquisa.<br>
Moderado - Fornece estatísticas mais precisas.<br>
Agressivo - O mesmo que &quot;Moderado&quot;, mas registra dados sobre cada página visitada.';

$helptxt['spider_group'] = 'Ao selecionar um grupo restritivo, quando um visitante for detectado como um rastreador de pesquisa, ele receberá automaticamente qualquer permissão &quot;negada&quot; deste grupo além das permissões normais de um visitante. Você pode usar isso para fornecer menos acesso a um mecanismo de pesquisa do que faria com um visitante normal. Você pode, por exemplo, criar um novo grupo chamado &quot;Mecanismo de pesquisa&quot; e selecioná-lo aqui. Você pode então negar a permissão para esse grupo visualizar perfis para impedir que esses mecanismos indexem os perfis de seus membros.<br>Nota: a detecção dos mecanismos não é perfeita e pode ser simulada pelos usuários, portanto, esse recurso não garante a restrição de conteúdo apenas aos mecanismos de pesquisa que você adicionou.';
$helptxt['show_spider_online'] = 'Esta configuração permite que você selecione se os mecanismos de pesquisa devem ser listados na seção &quot;Quem está online&quot; no índice da seção e na página &quot;Quem está online&quot;. As opções são:
	<ul class="normallist">
		<li>
			<strong>De jeito nenhum</strong><br>
			Os mecanismos simplesmente aparecerão como visitantes para todos os usuários.
		</li><li>
			<strong>Exibir a quantidade de mecanismos</strong><br>
			O Índice do fórum exibirá o número de mecanismos que visitam o fórum atualmente.
		</li><li>
			<strong>Mostrar o nome dos mecanismos</strong><br>
			O nome de cada mecanismo será revelado, para que os usuários possam ver quantos de cada um estão visitando o fórum no momento - isso tem efeito tanto no Índice do fórum quanto na página quem está online.
		</li><li>
			<strong>Mostrar o nome dos mecanismos - somente administrador</strong><br>
			Como na opção acima, exceto que apenas os administradores podem ver o estado dos mecanismos - para todos os outros usuários eles aparecem como visitantes.
		</li>
	</ul>';

$helptxt['birthday_email'] = 'Escolha o índice da mensagem de e-mail de aniversário a ser usada. Uma visualização será mostrada nos campos assunto e corpo do e-mail.<br><strong>Nota:</strong> a seleção desta configuração não ativa automaticamente os e-mails de aniversário. Para ativá-los, use a página de <a href="%1$s?action=admin;area=scheduledtasks;%3$s=%2$s" target="_blank" rel="noopener">tarefas agendadas</a> e habilite a tarefa.';
$helptxt['pm_bcc'] = 'Ao enviar uma mensagem pessoal, você pode optar por adicionar um destinatário como BCC (Blind Carbon Copy). Os destinatários BCC não têm suas identidades reveladas aos demais destinatários da mensagem.';

$helptxt['move_topics_maintenance'] = 'Isso permitirá mover todas as postagens de uma seção para outra.';
$helptxt['maintain_reattribute_posts'] = 'Você pode usar esta função para atribuir postagens de visitantes em seu fórum a um membro registrado. Isto é útil se, por exemplo, um usuário excluiu sua conta e mudou de ideia e desejou ter suas postagens antigas associadas à sua conta.';
$helptxt['chmod_flags'] = 'Você pode definir manualmente as permissões que deseja definir os arquivos selecionados. Para fazer isso, digite o valor do chmod como um valor numérico (octet). Nota - esses sinalizadores não terão efeito nos sistemas operacionais Microsoft Windows.';

$helptxt['postmod'] = 'Esta seção permite que membros da equipe de moderação (com permissões suficientes) possam aprovar qualquer postagens e tópicos antes de serem mostrados.';

$helptxt['field_show_enclosed'] = 'Inclui a entrada do usuário entre algum texto ou HTML. Isso permitirá que você adicione mais provedores de mensagens instantâneas, imagens ou incorporações, etc. Por exemplo:<br><br>
		&lt;a href="https://example.com/{INPUT}"&gt;&lt;img src="{DEFAULT_IMAGES_URL}/icon.png" alt="{INPUT}" /&gt;&lt;/a&gt;<br><br>
		Observe que você pode usar as seguintes variáveis:<br>
		<ul class="normallist">
			<li>{INPUT} - A entrada especificada pelo usuário.</li>
			<li>{SCRIPTURL} - Endereço do fórum na internet.</li>
			<li>{IMAGES_URL} - URL para o diretório de imagens no tema atual do usuário.</li>
			<li>{DEFAULT_IMAGES_URL} - URL para o diretório de imagens no tema padrão.</li>
			<li>{KEY} - Usado quando um campo tem múltiplas opções, é o ID numérico exclusivo usado para identificá-lo..</li>
		</ul>';

$helptxt['custom_mask'] = 'A máscara de entrada é importante para a segurança do seu fórum. Validar a entrada de um usuário pode ajudar a garantir que os dados não sejam usados de uma forma inesperada. Fornecemos algumas expressões regulares simples como dicas.<br><br>
     São obrigatórios delimitadores marcando o início e o fim do padrão! Nos exemplos abaixo, eles são tils (~).<br><br>
	<div class="smalltext" style="margin: 0 2em">
		&quot;~[A-Za-z]+~&quot; - Combina todos os caracteres alfabéticos maiúsculos e minúsculos.<br>
		&quot;~[0-9]+~&quot; - Combina todos os caracteres numéricos.<br>
		&quot;~[A-Za-z0-9]{7}~&quot; - Combina todos os caracteres alfabéticos e numéricos maiúsculos e minúsculos sete vezes.<br>
		&quot;~[^0-9]?~&quot; - Proibe a correspondência de qualquer número.<br>
		&quot;~^([A-Fa-f0-9]{3}|[A-Fa-f0-9]{6})$~&quot; - Permite apenas códigos hexadecimais de 3 ou 6 caracteres.<br>
	</div><br><br>
	Além disso, metacaracteres especiais ?+*^$ and {xx} podem ser definidos.
	<div class="smalltext" style="margin: 0 2em">
		? -Nenhuma ou uma correspondência da expressão anterior.<br>
		+ - Uma ou mais das expressões anteriores.<br>
		* - Nenhuma ou mais das expressões anteriores.<br>
		{xx} - Um número exato da expressão anterior.<br>
		{xx,} - Um número exato ou maior da expressão anterior.<br>
		{,xx} - Um número exato ou menor da expressão anterior.<br>
		{xx,yy} - Uma correspondência exata entre os dois números da expressão anterior.<br>
		^ - Início da string.<br>
		$ - Fim da string.<br>
		\\ - Pula para o próximo caractere.<br>
	</div><br><br>
	Mais informações e técnicas avançadas podem ser encontradas na Internet.';

$helptxt['topic_move_any'] = 'Se marcada, os usuários poderão mover tópicos para qualquer seção que possam ver. Caso contrário, eles só poderão movê-los para as seções onde poderão postar novos tópicos.';

$helptxt['alert_pm_new'] = 'As notificações de novas mensagens pessoais não aparecem no painel alertas, mas sim na lista "Minhas mensagens".';
$helptxt['alert_event_new'] = 'Isso enviará um alerta ou e-mail conforme solicitado se houver um novo evento de calendário adicionado. No entanto, se esse evento for postado e um tópico for adicionado, você não receberá um alerta para o evento se já estiver seguindo essa seção - o alerta da seção irá substituir este.';

$helptxt['force_ssl'] = '<strong>Teste o SSL e o HTTPS em seu servidor antes de ativar esta opção, pois isso pode fazer com que seu fórum fique inacessível.</strong> Ative o modo de manutenção se você não conseguir acessar o fórum depois de ativar.<br><br><strong>Alterar esta configuração atualizará a URL principal do seu fórum, bem como as URLs dos arquivos e imagens do seu tema, smileys e avatares, configurando-os como http: ou https: com base na sua seleção. URLs personalizadas não serão afetadas.</strong>';
$helptxt['image_proxy_enabled'] = 'Obrigatório para incorporar imagens externas quando estiver em SSL completo';
$helptxt['image_proxy_secret'] = 'Mantenha isso em segredo, proteja seu fórum contra hotlinks de imagens. Altere-o para tornar inacessível as imagens com hotlinks atuais';
$helptxt['image_proxy_maxsize'] = 'Tamanho máximo da imagem que o proxy de imagem SSL armazenará em cache: imagens maiores não serão armazenadas em cache. As imagens armazenadas em cache são armazenadas na pasta de cache do SMF, portanto, certifique-se de ter espaço livre suficiente.';

$helptxt['enable_sm_stats'] = 'Se ativado, isso permitirá que o Simple Machines visite seu site uma vez por mês para coletar estatísticas básicas. Isso nos ajudará a tomar decisões sobre quais configurações otimizar o programa. Para obter mais informações, visite nossa <a href="https://www.simplemachines.org/about/stats.php" target="_blank" rel="noopener">página de informações</a>.';

$helptxt['field_reg_require'] = 'Se este campo for obrigatório durante o cadastro, também será obrigatório nas alterações de perfil.';

$helptxt['translatable_fields'] = 'Se quiser fornecer suporte multilíngue para seus campos de perfil personalizados, você poderá usar tokens traduzíveis nos campos de nome e descrição.<br><br>
Qualquer coisa entre chaves <span class="monospace">{}</span> será considerado um token e será comparada com uma string $txt. Por exemplo, o token <span class="monospace">{gender}</span> será substituído pelo valor de $txt[\'gender\']<br><br>
É <strong>muito importante</strong> adicionar a string $txt correspondente a <strong>TODOS</strong> idiomas atualmente instalados. Para fazer isso, vá para <a href="%1$s?action=admin;area=languages;sa=edit;%3$s=%2$s" class="bbc_link" target="_blank" rel="noopener">Editar idiomas</a> e conclua as etapas a seguir para cada idioma instalado:
<ol class="bbc_list" style="list-style-type: decimal">
	<li>Clique no botão "Editar" ao lado do nome do idioma.</li>
	<li>No menu "Selecionar entradas para editar" escolha "Modificações".</li>
	<li>Role até o final e clique no botão "Adicionar outro item"</li>
	<li>Siga as instruções para adicionar sua nova string.</li>
</ol>';

// argument(s): $boarddir, $boardurl
$helptxt['cron_is_real_cron'] = 'Por padrão, o SMF adiciona a cada página um pequeno trecho de JavaScript que solicita ao navegador do usuário que acione o cron.php do SMF em segundo plano. Essa abordagem permite que o SMF execute suas tarefas agendadas regularmente sem exigir que o administrador faça qualquer configuração extra do servidor. Porém, alguns administradores podem preferir configurar seus servidores para executar diretamente o cron.php regularmente. Se você tiver feito isso, poderá desativar o método JavaScript.<br><br><strong>Nota:</strong> configurar seu servidor para executar tarefas agendadas dessa maneira não pode ser feito no SMF. Você precisará usar o programa de configuração do servidor para fazer isso. Ferramentas típicas para essa finalidade incluem <code>cron</code> (para servidores Linux), <code>schtasks.exe</code> (para servidores Windows) e <code>launchd</code> (para servidores macOS). A maioria das empresas de hospedagem de sites fornecem algum tipo de interface de painel de controle para permitir que seus clientes acessem essas ferramentas.<br><br>O caminho e a URL do cron.php do seu fórum são:<br>Caminho: %1$s/cron. php<br>URL: %2$s/cron.php';

$helptxt['languages_txt'] = 'Essas entradas de idioma são usadas em todo o SMF para definir versões localizadas de texto para diferentes idiomas.<br><br>Se você ver um valor como <code>&#37;1$s</code> em uma entrada, é um espaço reservado que o SMF preenche com um valor real em tempo de execução. Certifique-se de manter esses espaços reservados em seu texto personalizado.';
$helptxt['languages_helptxt'] = 'Essas entradas de idioma são usadas para mostrar pop-ups flutuantes de texto de ajuda (como este).';
$helptxt['languages_editortxt'] = 'Essas entradas de idioma são usadas para elementos da interface do usuário no editor de postagem.';
$helptxt['languages_tztxt'] = 'Essas entradas de idioma são usadas para criar descrições para fusos horários.<br><br>Por exemplo, a string <code>Europe_Western</code> pode ser combinada com a string <code>daylight_ saving_time_false</code> para produzir "Europa Ocidental". Horário padrão".<br><br>Nota: se nenhuma descrição for fornecida para um determinado fuso horário, o SMF gerará uma descrição usando uma lista de locais dentro desse fuso horário.';
$helptxt['languages_txt_for_timezones'] = 'Essas entradas de idioma permitem que você faça o seguinte:<br><ol class="bbc_list" style="list-style-type: decimal;"><li>Edite os nomes mostrados para locais individuais em qualquer lugar onde possam ser usados em um contexto relacionado aos fusos horários. Por exemplo, você pode dizer ao SMF para mostrar "Qaanaaq" para o local "America/Thule" em vez de "Thule".</li><li>Edite os nomes mostrados para diferentes países. Isso pode ser feito editando a string <code>iso3166[]</code> relevante.</li></ol>';
$helptxt['languages_txt_for_email_templates'] = 'Essas entradas de idioma são usadas para criar as mensagens de e-mail que o SMF envia aos seus membros.';
$helptxt['languages_native_name'] = 'O próprio nome do idioma, representado em sua própria escrita.';
$helptxt['languages_character_set'] = 'A codificação de caracteres usada para este idioma. A partir do SMF 2.1, deve ser sempre "UTF-8".';
$helptxt['languages_locale'] = 'O código de localidade é usado para determinar diversas convenções de formatação, etc.<br><br>O código de localidade normalmente assume a forma de um código de idioma de dois caracteres, opcionalmente seguido por um sublinhado e um código de país de dois caracteres. Por exemplo, <code>en</code> identificaria o inglês genérico, enquanto <code>en_AU</code> identificaria o inglês australiano em particular.';
$helptxt['languages_rtl'] = 'Digite “1” aqui se este idioma for lido da direita para a esquerda (por exemplo, hebraico, árabe). Deixe "0" para idiomas lidos da esquerda para a direita.';
$helptxt['languages_dictionary'] = 'Isso define o dicionário do idioma principal que será usado pelo corretor ortográfico <a href="https://php.net/function.pspell-new" target="_blank" rel="noopener">pSpell</a> (se instalado).';
$helptxt['languages_recaptcha'] = 'O código de idioma a ser usado para o widget de verificação reCAPTCHA.<br><br>Consulte a documentação do reCAPTCHA do Google para ver a <a href="https://developers.google.com/recaptcha/docs/language" target="_blank" rel="noopener" class="bbc_link">lista de idiomas suportados</a>.';
// The GDPR page of the EU exists in several languages; change the language code at the end of the url
$helptxt['requireAgreement'] = 'Recomenda-se que esta configuração seja habilitada para cumprir as regras <a href="https://ec.europa.eu/info/law/law-topic/data-protection/eu-data-protection-rules_en" target="_blank" rel="noopener" class="bbc_link">GDPR</a>.';
// The GDPR page of the EU exists in several languages; change the language code at the end of the url
$helptxt['requirePolicyAgreement'] = 'Recomenda-se que esta configuração seja habilitada para cumprir as regras <a href="https://ec.europa.eu/info/law/law-topic/data-protection/eu-data-protection-rules_en" target="_blank" rel="noopener" class="bbc_link">GDPR</a>.';
$helptxt['gravatar'] = 'Gravatar são avatares reconhecidos globalmente. Registre uma conta em <a href="https://www.gravatar.com" target="_blank" rel="noopener">https://www.gravatar.com</a> para selecionar uma imagem de avatar. Este avatar estará disponível em todos os sites que suportam gravatars. Se você não tiver uma conta gravatar, uma imagem padrão será usada.';

?>