<?php
// Version: 2.1.0; EmailTemplates

// Since all of these strings are being used in emails, numeric entities should be used.

// Do not translate anything that is between {}, they are used as replacement variables and MUST remain exactly how they are.
//   Additionally, do not translate the @additional_params: line or the variable names in the lines that follow it. You may
//   translate the description of the variable. Do not translate @description:, however you may translate the rest of that line.

// Do not use block comments in this file, they will have special meaning.

global $txtBirthdayEmails;

/**
	@additional_params: resend_activate_message
		REALNAME: The display name for the member receiving the email.
		USERNAME:  The user name for the member receiving the email.
		ACTIVATIONLINK:  The URL link to activate the member's account.
		ACTIVATIONCODE:  The code needed to activate the member's account.
		ACTIVATIONLINKWITHOUTCODE: The URL to the page where the activation code can be entered.
		FORGOTPASSWORDLINK: The URL to the "forgot password" page.
	@description:
*/
$txt['resend_activate_message_subject'] = 'Välkommen till {FORUMNAME}';
$txt['resend_activate_message_body'] = 'Tack för att du registrerat dig på {FORUMNAME}. Ditt användarnamn är {USERNAME}. Om du glömmer bort ditt lösenord kan du återställa det genom att besöka {FORGOTPASSWORDLINK}.

Innan du kan logga in behöver du först aktivera ditt konto genom att besöka följande länk:

{ACTIVATIONLINK}

Om du skulle ha några problem med att aktivera ditt konto kan du besöka {ACTIVATIONLINKWITHOUTCODE} och ange koden "{ACTIVATIONCODE}".

{REGARDS}';

/**
	@additional_params: resend_pending_message
		REALNAME: The display name for the member receiving the email.
		USERNAME:  The user name for the member receiving the email.
	@description:
*/
$txt['resend_pending_message_subject'] = 'Välkommen till {FORUMNAME}';
$txt['resend_pending_message_body'] = 'Hej {REALNAME}, din registreringsförfrågan till {FORUMNAME} har tagits emot.

Användarnamnet som du registrerade var {USERNAME}.

Innan du kan logga in och börja använda forumet behöver din ansökan granskas och godkännas. När detta sker kommer du att få ett nytt e-postmeddelande från denna adress.

{REGARDS}';

/**
	@additional_params: mc_group_approve
		USERNAME: The user name for the member receiving the email.
		GROUPNAME: The name of the membergroup that the user was accepted into.
	@description: The request to join a particular membergroup has been accepted.
*/
$txt['mc_group_approve_subject'] = 'Gruppmedlemskap godkänt';
$txt['mc_group_approve_body'] = 'Hej {USERNAME}

Din ansökan om att gå med i gruppen "{GROUPNAME}" på {FORUMNAME} har blivit godkänd, och ditt konto har blivit uppdaterat för att inkludera denna nya medlemsgrupp.

{REGARDS}';

/**
	@additional_params: mc_group_reject
		USERNAME: The user name for the member receiving the email.
		GROUPNAME: The name of the membergroup that the user was rejected from.
	@description: The request to join a particular membergroup has been rejected.
*/
$txt['mc_group_reject_subject'] = 'Gruppmedlemskap nekat';
$txt['mc_group_reject_body'] = 'Hej {USERNAME}

Din ansökan om att gå med i gruppen "{GROUPNAME}" på {FORUMNAME} har nekats.

{REGARDS}';

/**
	@additional_params: mc_group_reject_reason
		USERNAME: The user name for the member receiving the email.
		GROUPNAME: The name of the membergroup that the user was rejected from.
		REASON: Reason for the rejection.
	@description: The request to join a particular membergroup has been rejected with a reason given.
*/
$txt['mc_group_reject_reason_subject'] = 'Gruppmedlemskap nekat';
$txt['mc_group_reject_reason_body'] = 'Hej {USERNAME}

Din ansökan om att gå med i gruppen "{GROUPNAME}" på {FORUMNAME}
har nekats på grund av följande anledning: {REASON}

{REGARDS}';

/**
	@additional_params: admin_approve_accept
		NAME: The display name of the member.
		USERNAME: The user name for the member receiving the email.
		PROFILELINK: The URL of the profile page.
		FORGOTPASSWORDLINK: The URL of the "forgot password" page.
	@description:
*/
$txt['admin_approve_accept_subject'] = 'Välkommen till {FORUMNAME}';
$txt['admin_approve_accept_body'] = 'Välkommen {NAME}

Ditt konto har aktiverats manuellt av en administratör och du kan nu logga in och skriva inlägg. Ditt användarnamn är: {USERNAME}. Om du glömmer bort ditt lösenord kan du ändra det på {FORGOTPASSWORDLINK}.

{REGARDS}';

/**
	@additional_params: admin_approve_activation
		USERNAME: The user name for the member receiving the email.
		ACTIVATIONLINK:  The URL link to activate the member's account.
		ACTIVATIONLINKWITHOUTCODE: The URL to the page where the activation code can be entered.
		ACTIVATIONCODE: The activation code.
	@description:
*/
$txt['admin_approve_activation_subject'] = 'Välkommen till {FORUMNAME}';
$txt['admin_approve_activation_body'] = 'Välkommen {USERNAME}!

Ditt konto på {FORUMNAME} har godkänts av en administratör. Innan du kan logga in behöver du först aktivera ditt konto genom följande länk:

{ACTIVATIONLINK}

Om du skulle ha några problem med aktiveringen kan du besöka {ACTIVATIONLINKWITHOUTCODE} och ange följande kod "{ACTIVATIONCODE}".

{REGARDS}';

/**
	@additional_params: admin_approve_reject
		USERNAME: The user name for the member receiving the email.
	@description:
*/
$txt['admin_approve_reject_subject'] = 'Registrering nekad';
$txt['admin_approve_reject_body'] = 'Hej {USERNAME}

Din ansökan om att gå med i {FORUMNAME} har nekats.

{REGARDS}';

/**
	@additional_params: admin_approve_delete
		USERNAME: The user name for the member receiving the email.
	@description:
*/
$txt['admin_approve_delete_subject'] = 'Konto raderat';
$txt['admin_approve_delete_body'] = 'Hej {USERNAME}

Ditt konto på {FORUMNAME} har raderats. Detta kan bero på att du aldrig aktiverade ditt konto. Om så är fallet kan du registrera kontot igen.

{REGARDS}';

/**
	@additional_params: admin_approve_remind
		USERNAME: The user name for the member receiving the email.
		ACTIVATIONLINK:  The URL link to activate the member's account.
		ACTIVATIONLINKWITHOUTCODE: The URL to the page where the activation code can be entered.
		ACTIVATIONCODE: The activation code.
	@description:
*/
$txt['admin_approve_remind_subject'] = 'Registreringspåminnelse';
$txt['admin_approve_remind_body'] = 'Hej {USERNAME}

Du har inte aktiverat ditt konto på {FORUMNAME}.

Använd följande länk för att aktivera ditt konto:
{ACTIVATIONLINK}

Skulle du ha några problem med aktiveringen kan du besöka {ACTIVATIONLINKWITHOUTCODE} och ange följande kod "{ACTIVATIONCODE}".

{REGARDS}';

/**
	@additional_params:
		USERNAME: The user name for the member receiving the email.
		ACTIVATIONLINK:  The URL link to activate the member's account.
		ACTIVATIONLINKWITHOUTCODE: The URL to the page where the activation code can be entered.
		ACTIVATIONCODE: The activation code.
	@description:
*/
$txt['admin_register_activate_subject'] = 'Välkommen till {FORUMNAME}';
$txt['admin_register_activate_body'] = 'Tack för att du registrerat dig hos {FORUMNAME}. Ditt användarnamn är {USERNAME} och ditt lösenord är {PASSWORD}.
Innan du kan logga in behöver du aktivera ditt konto genom att klicka på följande länk:

{ACTIVATIONLINK}

Skulle du få problem med aktiveringen, vänligen klicka på {ACTIVATIONLINKWITHOUTCODE} och ange följande kod "{ACTIVATIONCODE}".

{REGARDS}';

$txt['admin_register_immediate_subject'] = 'Välkommen till {FORUMNAME}';
$txt['admin_register_immediate_body'] = 'Tack för att du registrerat dig på {FORUMNAME}. Ditt användarnamn är {USERNAME}, ditt lösenord är {PASSWORD} och adressen till forumet är:
{SCRIPTURL}.

{REGARDS}';

/**
	@additional_params: new_announcement
		TOPICSUBJECT: The subject of the topic being announced.
		MESSAGE: The message body of the first post of the announced topic.
		TOPICLINK: A link to the topic being announced.
		UNSUBSCRIBELINK: Link to unsubscribe from announcements.
	@description:
*/
$txt['new_announcement_subject'] = 'Nytt tillkännagivande: {TOPICSUBJECT}';
$txt['new_announcement_body'] = '{MESSAGE}

För att avsluta prenumerationen på dessa tillkännagivanden, loggar du in på forumet och klickar ur "Ta emot nyhetsbrev, tillkännagivande och viktiga meddelanden via e-post." i din profil.

Du kan se hela tillkännagivandet på följande länk:
{TOPICLINK}

{REGARDS}';

/**
	@additional_params: notify_boards_once_body
		TOPICSUBJECT: The subject of the topic causing the notification
		TOPICLINK: A link to the topic.
		MESSAGE: This is the body of the message.
		UNSUBSCRIBELINK: Link to unsubscribe from notifications.
	@description:
*/
$txt['notify_boards_once_body_subject'] = 'Nytt ämne: {TOPICSUBJECT}';
$txt['notify_boards_once_body_body'] = 'Ett nytt ämne, \'{TOPICSUBJECT}\', har skapats på en tavla som du bevakar.

Du kan se det på
{TOPICLINK}

Fler ämnen kan skapas, men du kommer inte att bli underrättad via e-post innan du har besökt tavlan igen.

Inlägget i ämnet ser du nedan:
{MESSAGE}

Avsluta prenumerationen på nya ämnen för denna tavla genom följande länk:
{UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notify_boards_once
		TOPICSUBJECT: The subject of the topic causing the notification
		TOPICLINK: A link to the topic.
		UNSUBSCRIBELINK: Link to unsubscribe from notifications.
	@description:
*/
$txt['notify_boards_once_subject'] = 'Nytt ämne: {TOPICSUBJECT}';
$txt['notify_boards_once_body'] = 'Ett nytt ämne, \'{TOPICSUBJECT}\', har startats på en tavla du bevakar.

Du kan läsa det på
{TOPICLINK}

Fler ämnen kan ha startats men du får inga fler mail om detta innan du besökt tavlan och läst några av dessa nya ämnena.

Innehållet i ämnet:
{MESSAGE}

Avsluta prenumerationen på nya ämnen på denna tavla genom att klicka här:
{UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notify_boards_body
		TOPICSUBJECT: The subject of the topic causing the notification
		TOPICLINK: A link to the topic.
		MESSAGE: This is the body of the message.
		UNSUBSCRIBELINK: Link to unsubscribe from notifications.
	@description:
*/
$txt['notify_boards_body_subject'] = 'Nytt ämne: {TOPICSUBJECT}';
$txt['notify_boards_body_body'] = 'Ett nytt ämne \'{TOPICSUBJECT}\' har startats på en tavla som du bevakar.

Du kan läsa det på
{TOPICLINK}

Texten i det nya ämnet är:
{MESSAGE}

Avsluta prenumerationen på nya ämnen på denna tavla genom att klicka här:
{UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notify_boards
		TOPICSUBJECT: The subject of the topic causing the notification
		TOPICLINK: A link to the topic.
		UNSUBSCRIBELINK: Link to unsubscribe from notifications.
	@description:
*/
$txt['notify_boards_subject'] = 'Nytt ämne: {TOPICSUBJECT}';
$txt['notify_boards_body'] = 'Ett nytt ämne, \'{TOPICSUBJECT}\', har skapats på en tavla som du bevakar.

Du kan se det på
{TOPICLINK}

Avsluta prenumerationen på nya ämnen på denna tavla genom att klicka här:
{UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: alert_unapproved_reply
		SUBJECT: The subject of the topic causing the notification
		LINK: A link to the topic.
	@description:
*/
$txt['alert_unapproved_reply_subject'] = 'Ämnessvar: {SUBJECT}';
$txt['alert_unapproved_reply_body'] = 'Ett svar har skrivits i \'{SUBJECT}\' av {POSTERNAME}.

Du kan se det på
{LINK}

{REGARDS}';

/**
	@additional_params: unapproved_attachment
		SUBJECT: The subject of the topic causing the notification
		LINK: A link to the message with the attachment.
	@description:
*/
$txt['unapproved_attachment_subject'] = 'Ny bilaga att granska i: {SUBJECT}';
$txt['unapproved_attachment_body'] = 'En ny bilaga har lagts till i \'{SUBJECT}\' och behöver granskas.

Du kan godkänna eller neka bilagan från länken nedan, vilken kommer att ta dig till inlägget som bilagan tillhör.

{LINK}

{REGARDS}';

/**
	@additional_params: alert_unapproved_post
		SUBJECT: The subject of the topic causing the notification
		LINK: A link to the topic.
	@description:
*/
$txt['alert_unapproved_post_subject'] = 'Nytt inlägg att granska: {SUBJECT}';
$txt['alert_unapproved_post_body'] = 'Ett nytt inlägg som behöver granskas har gjorts: \'{SUBJECT}\'

Du kan godkänna eller neka inlägget via länken nedan:
{LINK}

{REGARDS}';

/**
	@additional_params: alert_unapproved_topic
		SUBJECT: The subject of the topic causing the notification
		LINK: A link to the topic.
	@description:
*/
$txt['alert_unapproved_topic_subject'] = 'Nytt ogranskat ämne: {SUBJECT}';
$txt['alert_unapproved_topic_body'] = 'Ett nytt ämne har skapats och behöver granskas: \'{SUBJECT}\'

Du kan godkänna eller neka ämnet från länken nedan:
{LINK}

{REGARDS}';

/**
	@additional_params: request_membership
		RECPNAME: The name of the person receiving the email
		APPLYNAME: The name of the person applying for group membership
		GROUPNAME: The name of the group being applied to.
		REASON: The reason given by the applicant for wanting to join the group.
		MODLINK: Link to the group moderation page.
	@description:
*/
$txt['request_membership_subject'] = 'Ny gruppförfrågan';
$txt['request_membership_body'] = '{RECPNAME},

{APPYNAME} har sökt medlemskap i gruppen "{GROUPNAME}". Användaren har lämnat följande skäl:

{REASON}

Du kan godkänna eller avslå ansökan genom att klicka på följande länk:

{MODLINK}

{REGARDS}';

/**
	@additional_params: paid_subscription
		REALNAME: The real (display) name of the person receiving the email.
		PROFILE_LINK: Link to profile of member receiving email where can renew.
		SUBSCRIPTION: Name of the subscription.
		END_DATE: Date it expires.
	@description:
*/
$txt['paid_subscription_reminder_subject'] = 'Din prenumeration på {FORUMNAME} håller på att gå ut';
$txt['paid_subscription_reminder_body'] = 'Hej {REALNAME}

Din prenumeration hos {FORUMNAME} håller på att löpa ut. Om du har valt automatisk förnyelse behöver du inte göra någonting. Annars behöver du förnya din prenumeration för att fortsätta prenumerera.

Prenumerationsnamn: {SUBSCRIPTION}
Utgångsdatum: {END_DATE}

För att redigera din prenumeration besöker du följande adress:
{PROFILE_LINK}

{REGARDS}';

/**
	@additional_params: activate_reactivate
		ACTIVATIONLINK:  The URL link to reactivate the member's account.
		ACTIVATIONCODE:  The code needed to reactivate the member's account.
		ACTIVATIONLINKWITHOUTCODE: The URL to the page where the activation code can be entered.
	@description:
*/
$txt['activate_reactivate_subject'] = 'Välkommen tillbaka till {FORUMNAME}';
$txt['activate_reactivate_body'] = 'För att återvalidera din e-postadress har ditt konto avaktiverats. Klicka på följande länk för att aktivera det igen:
{ACTIVATIONLINK}


Skulle du få problem med aktiveringen, vänligen klicka på {ACTIVATIONLINKWITHOUTCODE} och ange koden "{ACTIVATIONCODE}".

{REGARDS}';

/**
	@additional_params: forgot_password
		REALNAME: The real (display) name of the person receiving the reminder.
		REMINDLINK: The link to reset the password.
		IP: The IP address of the requester.
		MEMBERNAME:
	@description:
*/
$txt['forgot_password_subject'] = 'Nytt lösenord för {FORUMNAME}';
$txt['forgot_password_body'] = 'Hej {REALNAME}
Detta e-postmeddelande har skickats därför att \'Glömt lösenord\'-funktionen har begärts för ditt konto. För att välja ett nytt lösenord, följ denna länk:
{REMINDLINK}

IP-adress: {IP}
Användarnamn: {MEMBERNAME}

{REGARDS}';

/**
	@additional_params: send_email
		EMAILSUBJECT: The subject the user wants to email.
		EMAILBODY: The body the user wants to email.
		SENDERNAME: The name of the member sending the email.
		RECPNAME: The name of the person receiving the email.
	@description:
*/
$txt['send_email_subject'] = '{EMAILSUBJECT}';
$txt['send_email_body'] = '{EMAILBODY}';

/**
	@additional_params: report_to_moderator
		TOPICSUBJECT: The subject of the reported post.
		POSTERNAME: The reported post's author's name.
		REPORTERNAME: The name of the person reporting the post.
		TOPICLINK: The URL of the post that is being reported.
		REPORTLINK: The URL of the moderation center report.
		COMMENT: The comment left by the reporter, hopefully to explain why they are reporting the post.
	@description: When a user reports a post this email is sent out to moderators and admins of that board.
*/
$txt['report_to_moderator_subject'] = 'Anmält inlägg: {TOPICSUBJECT} av {POSTERNAME}';
$txt['report_to_moderator_body'] = 'Följande inlägg, "{TOPICSUBJECT}" av {POSTERNAME} har anmälts av {REPORTERNAME} för en tavla du modererar:

Ämnet: {TOPICLINK}
Moderationscenter: {REPORTLINK}

Anmälaren har lämnat följande kommentar:
{COMMENT}

{REGARDS}';

/**
	@additional_params: report_to_moderator
		TOPICSUBJECT: The subject of the reported post.
		POSTERNAME: The reported post's author's name.
		COMMENTERNAME: The name of the person who replied to the report.
		TOPICLINK: The URL of the post that is being reported.
		REPORTLINK: The URL of the moderation center report.
	@description: When a moderator replies to a moderation report, this can be sent to the other moderators who previously replied.
*/
$txt['reply_to_moderator_subject'] = 'Uppföljning till anmält inlägg: {TOPICSUBJECT} av {POSTERNAME}';
$txt['reply_to_moderator_body'] = 'Tidigare har "{TOPICSUBJECT}" anmälts till moderatorerna.

Sedan dess har {COMMENTERNAME} lagt till en kommentar till anmälan. Mer information kan hittas i forumet.

Ämnet: {TOPICLINK}
Moderationcenter: {REPORTLINK}

{REGARDS}';

/**
	@additional_params: report_user_profile
		MEMBERNAME: The display name of the reported user
		REPORTERNAME: The name of the person reporting the profile
		PROFILELINK: The link to the profile that was reported
		COMMENT: The comment left by the reporter.
 	@description: When a user's profile is reported
*/
$txt['report_member_profile_subject'] = 'Anmäld profil: {MEMBERNAME}';
$txt['report_member_profile_body'] = 'Profilen för "{MEMBERNAME}" har anmälts av {REPORTERNAME}.

Profilen: {PROFILELINK}
Moderationscenter: {REPORTLINK}

Anmälaren har lämnat följande kommentar:
{COMMENT}

{REGARDS}';

/**
	@additional_params: report_user_profile
		MEMBERNAME: The display name of the reported user
		COMMENTERNAME: The name of the person who added the comment
		PROFILELINK: The link to the profile that was reported
 	@description: When someone replies to a report about a profile, this can be sent to others who replied
*/
$txt['reply_to_member_report_subject'] = 'Uppföljning av anmäld profil: {MEMBERNAME}';
$txt['reply_to_member_report_body'] = 'Tidigare har profilen för {MEMBERNAME} anmälts.

Sedan dess har {COMMENTERNAME} lagt till en kommentar till anmälan. Mer information kan hittas på forumet.

Profilen: {PROFILELINK}
Moderationscenter: {REPORTLINK}

{REGARDS}';

/**
	@additional_params: change_password
		USERNAME: The user name for the member receiving the email.
		PASSWORD: The password for the member.
	@description:
*/
$txt['change_password_subject'] = 'Nytt lösenord';
$txt['change_password_body'] = 'Hej {USERNAME}

Dina användaruppgifter på {FORUMNAME} har ändrats och ditt lösenord har återställts. Nedan hittar du de nya uppgifterna.

Ditt användarnamn är "{USERNAME}" och ditt lösenord är "{PASSWORD}".

Du kan ändra ditt lösenord i din profil eller genom att gå till följande sida efter du loggat in:
{SCRIPTURL}?action=profile

{REGARDS}';

/**
	@additional_params: register_activate
		REALNAME: The display name for the member receiving the email.
		USERNAME: The user name for the member receiving the email.
		PASSWORD: The password for the member.
		ACTIVATIONLINK:  The URL link to reactivate the member's account.
		ACTIVATIONLINKWITHOUTCODE: The URL to the page where the activation code can be entered.
		ACTIVATIONCODE:  The code needed to reactivate the member's account.
		FORGOTPASSWORDLINK: The URL to the "forgot password" page.
	@description:
*/
$txt['register_activate_subject'] = 'Välkommen till {FORUMNAME}';
$txt['register_activate_body'] = 'Tack för att du registrerat dig på {FORUMNAME}. Ditt användarnamn är {USERNAME}. Om du glömmer ditt lösenord kan du återställa det här: {FORGOTPASSWORDLINK}.

Innan du loggar in måste du aktivera ditt konto. För att göra det klickar du på denna länk:

{ACTIVATIONLINK}

Skulle du få problem med aktiveringen, vänligen klicka på {ACTIVATIONLINKWITHOUTCODE} och ange koden "{ACTIVATIONCODE}".

{REGARDS}';

/**
	@additional_params: register_coppa
		REALNAME: The display name for the member receiving the email.
		USERNAME: The user name for the member receiving the email.
		PASSWORD: The password for the member.
		COPPALINK:  The URL link to the coppa form.
		FORGOTPASSWORDLINK: The URL to the "forgot password" page.
	@description:
*/
$txt['register_coppa_subject'] = 'Välkommen till {FORUMNAME}';
$txt['register_coppa_body'] = 'Tack för att du registrerat dig på {FORUMNAME}. Ditt användarnamn är {USERNAME}. Om du glömmer ditt lösenord kan du ändra det på {FORGOTPASSWORDLINK}

Innan du kan logga in krävs medgivande av din vårdnadshavare så att du kan delta i forumet. Du kan få mer information om du klickar på följande länk:

{COPPALINK}

{REGARDS}';

/**
	@additional_params: register_immediate
		REALNAME: The display name for the member receiving the email.
		USERNAME: The user name for the member receiving the email.
		PASSWORD: The password for the member.
		FORGOTPASSWORDLINK: The URL to the "forgot password" page.
	@description:
*/
$txt['register_immediate_subject'] = 'Välkommen till {FORUMNAME}';
$txt['register_immediate_body'] = 'Tack för att du registrerat dig på {FORUMNAME}. Ditt användarnamn är {USERNAME}. Om du glömmer bort ditt lösenord kan du ändra det på {FORGOTPASSWORDLINK}.

{REGARDS}';

/**
	@additional_params: register_pending
		REALNAME: The display name for the member receiving the email.
		USERNAME: The user name for the member receiving the email.
		PASSWORD: The password for the member.
		FORGOTPASSWORDLINK: The URL to the "forgot password" page.
	@description:
*/
$txt['register_pending_subject'] = 'Välkommen till {FORUMNAME}';
$txt['register_pending_body'] = 'Hej {REALNAME}
Din registrering på {FORUMNAME} har mottagits.

Det användarnamn du valde var {USERNAME}. Om du glömmer ditt lösenord kan du ändra det under {FORGOTPASSWORDLINK}.

Innan du kan logga in och börja använda forumet kommer din ansökan att granskas och godkännas. När det skett kommer du få ännu ett mail från denna adress.

{REGARDS}';

/**
	@additional_params: notification_reply
		TOPICSUBJECT:
		POSTERNAME:
		TOPICLINK:
		UNSUBSCRIBELINK:
	@description:
*/
$txt['notification_reply_subject'] = 'Ämnessvar: {TOPICSUBJECT}';
$txt['notification_reply_body'] = 'Ett svar av {POSTERNAME} har postats i ett ämne som du bevakar.

Läs svaret här: {TOPICLINK}

Sluta bevaka detta ämne genom att klicka här: {UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notification_reply_body
		TOPICSUBJECT:
		POSTERNAME:
		TOPICLINK:
		UNSUBSCRIBELINK:
		MESSAGE:
	@description:
*/
$txt['notification_reply_body_subject'] = 'Ämnessvar: {TOPICSUBJECT}';
$txt['notification_reply_body_body'] = 'Ett svar har postats av {POSTERNAME} i ett ämne som du bevakar.

Läs svaret här: {TOPICLINK}

Sluta bevaka detta ämne genom att klicka här: {UNSUBSCRIBELINK}

Texten i inlägget visas nedan:
{MESSAGE}

{REGARDS}';

/**
	@additional_params: notification_reply_once
		TOPICSUBJECT:
		POSTERNAME:
		TOPICLINK:
		UNSUBSCRIBELINK:
	@description:
*/
$txt['notification_reply_once_subject'] = 'Ämnessvar: {TOPICSUBJECT}';
$txt['notification_reply_once_body'] = 'Ett svar har postats av {POSTERNAME} i ett ämne som du bevakar.

Läs svaret här: {TOPICLINK}

Sluta bevaka detta ämne genom att klicka här: {UNSUBSCRIBELINK}

Fler svar kan ha postats men du kommer inte få fler meddelanden om detta innan du läst ämnet.

{REGARDS}';

/**
	@additional_params: notification_reply_body_once
		TOPICSUBJECT:
		POSTERNAME:
		TOPICLINK:
		UNSUBSCRIBELINK:
		MESSAGE:
	@description:
*/
$txt['notification_reply_body_once_subject'] = 'Ämnessvar: {TOPICSUBJECT}';
$txt['notification_reply_body_once_body'] = '{POSTERNAME} har svarat på ett ämne som du bevakar.

Läs svaret här: {TOPICLINK}

Sluta bevaka detta ämne genom att klicka här: {UNSUBSCRIBELINK}

Svaret visas här under:
{MESSAGE}

Fler svar kan ha postats men du kommer inte få fler e-post om detta innan du läst ämnet.

{REGARDS}';

/**
	@additional_params: notification_sticky
	@description:
*/
$txt['notification_sticky_subject'] = 'Ämne fastklistrat: {TOPICSUBJECT}';
$txt['notification_sticky_body'] = 'Ett ämne du bevakar har klistrats fast.

Visa ämnet här: {TOPICLINK}

Avsluta bevakning på detta ämne genom att klicka på: {UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notification_lock
	@description:
*/
$txt['notification_lock_subject'] = 'Ämne låst: {TOPICSUBJECT}';
$txt['notification_lock_body'] = 'Ett ämne du bevakar har blivit låst.

Se ämnet på: {TOPICLINK}

Avsluta bevakning på detta ämne genom att klicka på: {UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notification_unlock
	@description:
*/
$txt['notification_unlock_subject'] = 'Ämne upplåst: {TOPICSUBJECT}';
$txt['notification_unlock_body'] = 'Ett ämne du bevakar har låsts upp.

Läs ämnet här: {TOPICLINK}

Sluta bevaka detta ämne genom att klicka på: {UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notification_remove
	@description:
*/
$txt['notification_remove_subject'] = 'Ämne borttaget: {TOPICSUBJECT}';
$txt['notification_remove_body'] = 'Ett ämne du bevakar har tagits bort.

{REGARDS}';

/**
	@additional_params: notification_move
	@description:
*/
$txt['notification_move_subject'] = 'Ämne flyttat; {TOPICSUBJECT}';
$txt['notification_move_body'] = 'Ett ämne du bevakar har flyttats till en annan tavla.

Läs ämnet här: {TOPICLINK}

Sluta bevaka detta ämne genom att klicka på: {UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notification_merged
	@description:
*/
$txt['notification_merge_subject'] = 'Ämne ihopslaget: {TOPICSUBJECT}';
$txt['notification_merge_body'] = 'Ett ämne du bevakar har slagits ihop med ett annat ämne.

Läs det nya sammanslagna ämnet: {TOPICLINK}

Sluta bevaka detta ämne genom att klicka på: {UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notification_split
	@description:
*/
$txt['notification_split_subject'] = 'Ämne uppdelat: {TOPICSUBJECT}';
$txt['notification_split_body'] = 'Ett ämne du bevakar har delats upp i två eller flera ämnen.

Se vad som finns kvar av ämnet här: {TOPICLINK}

Sluta bevaka detta ämne genom att klicka på: {UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: admin_notify
		USERNAME:
		PROFILELINK:
	@description:
*/
$txt['admin_notify_subject'] = 'En ny medlem har registrerat sig';
$txt['admin_notify_body'] = '{USERNAME} har just registrerat sig som ny medlem på ditt forum. Klicka nedan för att visa dennes profil.

{PROFILELINK}

{REGARDS}';

/**
	@additional_params: admin_notify_approval
		USERNAME:
		PROFILELINK:
		APPROVALLINK:
	@description:
*/
$txt['admin_notify_approval_subject'] = 'En ny medlem har gått med';
$txt['admin_notify_approval_body'] = '{USERNAME} har just registrerat sig som ny medlem på ditt forum. Klicka nedan för att läsa dennes profil.

{PROFILELINK}

Innan den nye medlemmen kan börja posta så måste kontot godkännas. Klicka här nedan för att komma till godkännandesidan.
{APPROVALLINK}

{REGARDS}';

/**
	@additional_params: admin_attachments_full
		REALNAME:
	@description:
*/
$txt['admin_attachments_full_subject'] = 'Viktigt! Katalogen för bilagor är nästan full';
$txt['admin_attachments_full_body'] = 'Hej {REALNAME}

Katalogen för bilagor på {FORUMNAME} är nästan full. Vänligen logga in på forumet för att lösa problemet.

Så fort katalogen har uppnått maximalt tillåtna storlek, kommer inte användare längre att kunna bifoga filer i sina inlägg eller ladda upp profilbilder (om det tillåts).

{REGARDS}';

/**
	@additional_params: paid_subscription_refund
		NAME: Subscription title.
		REALNAME: Recipients name
		REFUNDUSER: Username who took out the subscription.
		REFUNDNAME: User's display name who took out the subscription.
		DATE: Today's date.
		PROFILELINK: Link to members profile.
	@description:
*/
$txt['paid_subscription_refund_subject'] = 'Återbetald prenumeration';
$txt['paid_subscription_refund_body'] = 'Hej {REALNAME}

En medlem har fått en återbetalning på en betald prenumeration. Nedan ser du detaljer om prenumerationen:

Prenumeration: {NAME}

Användarnamn: {REFUNDNAME} ({REFUNDUSER})

Datum: {DATE}

Du kan läsa den här medlemmens profil genom att klicka på länken nedan:
{PROFILELINK}

{REGARDS}';

/**
	@additional_params: paid_subscription_new
		NAME: Subscription title.
		REALNAME: Recipients name
		SUBEMAIL: Email address of the user who took out the subscription
		SUBUSER: Username who took out the subscription.
		SUBNAME: User's display name who took out the subscription.
		DATE: Today's date.
		PROFILELINK: Link to members profile.
	@description:
*/
$txt['paid_subscription_new_subject'] = 'Ny betald prenumeration';
$txt['paid_subscription_new_body'] = 'Hej {REALNAME}

En medlem har tagit en ny betald prenumeration. Nedan finns information om denna prenumeration:

Prenumeration: {NAME}

Användarnamn: {SUBNAME} ({SUBUSER})

Användarens mail: {SUBEMAIL}

Pris: {PRICE}

Datum: {DATE}

Du kan se den här medlemmens profil genom att klicka på länken nedan:
{PROFILELINK}

{REGARDS}';

/**
	@additional_params: paid_subscription_error
		ERROR: Error message.
		REALNAME: Recipients name
	@description:
*/
$txt['paid_subscription_error_subject'] = 'Ett fel inträffade med en betald prenumeration';
$txt['paid_subscription_error_body'] = 'Hej {REALNAME}

Följande fel inträffade när en betald prenumeration behandlades
---------------------------------------------------------------
{ERROR}

{REGARDS}';

/**
	@additional_params: new_pm
		SUBJECT: The personal message subject.
		SENDER:  The user name for the member sending the personal message.
		READLINK:  The link to directly access the read page.
		REPLYLINK:  The link to directly access the reply page.
	@description: A notification email sent to the receivers of a personal message
*/
$txt['new_pm_subject'] = 'Nytt personligt meddelande: {SUBJECT}';
$txt['new_pm_body'] = 'Du har fått ett personligt meddelande från {SENDER} på {FORUMNAME}.

OBS! Kom ihåg att detta bara är en underrättelse. Vänligen svara inte på detta e-postmeddelande.

Läs meddelandet här: {READLINK}

Svara på meddelandet här: {REPLYLINK}

{REGARDS}';

/**
	@additional_params: new_pm_body
		SUBJECT: The personal message subject.
		SENDER:  The user name for the member sending the personal message.
		MESSAGE:  The text of the personal message.
		REPLYLINK:  The link to directly access the reply page.
	@description: A notification email sent to the receivers of a personal message
*/
$txt['new_pm_body_subject'] = 'Nytt personligt meddelande: {SUBJECT}';
$txt['new_pm_body_body'] = 'Du har fått ett personligt meddelande från {SENDER} på {FORUMNAME}.

OBS! Kom ihåg att detta bara är en underrättelse. Vänligen svara inte på detta e-postmeddelande.

Meddelandet hen skickade var:
{MESSAGE}

Svara på detta meddelande här: {REPLYLINK}

{REGARDS}';

/**
	@additional_params: new_pm_tolist
		SUBJECT: The personal message subject.
		SENDER:  The user name for the member sending the personal message.
		READLINK:  The link to directly access the read page.
		REPLYLINK:  The link to directly access the reply page.
		TOLIST:  The list of users that will receive the personal message.
	@description: A notification email sent to the receivers of a personal message
*/
$txt['new_pm_tolist_subject'] = 'Nytt personligt meddelande: {SUBJECT}';
$txt['new_pm_tolist_body'] = 'Du och {TOLIST} har precis fått ett personligt meddelande från {SENDER} på {FORUMNAME}.

OBS! Kom ihåg att detta bara är en underrättelse. Vänligen svara inte på detta e-postmeddelande.

Läs detta personliga meddelande här: {READLINK}

Svara på detta personliga meddelande (endast till avsändaren) här: {REPLYLINK}

{REGARDS}';

/**
	@additional_params: new_pm_body_tolist
		SUBJECT: The personal message subject.
		SENDER:  The user name for the member sending the personal message.
		MESSAGE:  The text of the personal message.
		REPLYLINK:  The link to directly access the reply page.
		TOLIST:  The list of users that will receive the personal message.
	@description: A notification email sent to the receivers of a personal message
*/
$txt['new_pm_body_tolist_subject'] = 'Nytt personligt meddelande: {SUBJECT}';
$txt['new_pm_body_tolist_body'] = 'Du och {TOLIST} har precis fått ett personligt meddelande från {SENDER} på {FORUMNAME}.

OBS! Kom ihåg att detta bara är en underrättelse. Vänligen svara inte på detta e-postmeddelande.

Meddelandet som skickades var:

{MESSAGE}

Svara på detta personliga meddelande (endast till avsändaren) här: {REPLYLINK}

{REGARDS}';

/**
	@additional_params: msg_quote
		CONTENTSUBJECT: The post subject.
		QUOTENAME:  The user name for the member creating the quote
		MEMBERNAME:  The user name for the member being quoted
		CONTENTLINK:  The post's link
	@description: A notification email sent to the members who've been quoted in a post
 */
$txt['msg_quote_subject'] = 'Du har blivit citerad i inlägget: {CONTENTSUBJECT}';
$txt['msg_quote_body'] = 'Hej {MEMBERNAME}

Du har blivit citerad i inlägget med rubriken "{CONTENTSUBJECT}"  av {QUOTENAME}. Du kan läsa inlägget här:
{CONTENTLINK}

{REGARDS}';

/**
	@additional_params: msg_mention
		CONTENTSUBJECT: The post subject.
		MENTIONNAME:  The user name for the member creating the mention
		MEMBERNAME:  The user name for the member being mentioned
		CONTENTLINK:  The post's link
	@description: A notification email sent to the members who've been mentioned in a post
 */
$txt['msg_mention_subject'] = 'Du har blivit taggad i inlägget: {CONTENTSUBJECT}';
$txt['msg_mention_body'] = 'Hej {MEMBERNAME}

Du har blivit taggad i inlägget med rubriken "{CONTENTSUBJECT}" av {MENTIONNAME}. Du kan läsa inlägget här:
{CONTENTLINK}

{REGARDS}';

/**
	@additional_params: happy_birthday
		REALNAME: The real (display) name of the person receiving the birthday message.
	@description: A message sent to members on their birthday.
*/
$txtBirthdayEmails['happy_birthday_subject'] = 'Grattis på födelsedagen önskar {FORUMNAME}.';
$txtBirthdayEmails['happy_birthday_body'] = 'Grattis {REALNAME}

Vi på {FORUMNAME} vill önska dig en lycklig födelsedag och hoppas att denna dag och året som följer blir fullt av glädje.

{REGARDS}';
$txtBirthdayEmails['happy_birthday_author'] = '<a href="https://www.simplemachines.org/community/?action=profile;u=2676">Thantos</a>';

$txtBirthdayEmails['karlbenson1_subject'] = 'På din födelsedag...';
$txtBirthdayEmails['karlbenson1_body'] = 'Vi hade kunnat skicka ett grattiskort. Vi hade kunnat skicka dig blommor eller en tårta.

Men det gjorde vi inte.

Vi hade även kunnat skicka dig ett av våra automatiskt genererade meddelanden med lyckönskningar, där vi inte ens behöver byta ut INFOGA NAMN.

Men det gjorde vi inte.

Vi skrev denna hälsning just för dig.

Vi vill önska dig en väldigt speciell födelsedag.

{REGARDS}

//:: Detta meddelande genererades automatiskt :://';
$txtBirthdayEmails['karlbenson1_author'] = '<a href="https://www.simplemachines.org/community/?action=profile;u=63186">karlbenson</a>';

$txtBirthdayEmails['nite0859_subject'] = 'Grattis på födelsedagen!';
$txtBirthdayEmails['nite0859_body'] = '{REALNAME}, dina vänner på {FORUMNAME} vill ta tillfället i akt och önska dig en trevlig födelsedag. Om du inte har gjort så nyligen, besök vår community för att ge fler tillfälle att sända sina hälsningar.

Även om det är din födelsedag, {REALNAME}, vill vi påminna dig om att ditt medlemskap i vårt forum är den bästa gåvan för oss.

Bästa lyckönskningar,
Teamet bakom {FORUMNAME}';
$txtBirthdayEmails['nite0859_author'] = '<a href="https://www.simplemachines.org/community/?action=profile;u=46625">nite0859</a>';

$txtBirthdayEmails['zwaldowski_subject'] = 'Födelsedagshälsningar till {REALNAME}';
$txtBirthdayEmails['zwaldowski_body'] = 'Kära {REALNAME}

Ännu ett år har passerat i ditt liv. Vi på {FORUMNAME} hoppas att det varit fyllt med lycka och önskar detsamma detta kommande år.

{REGARDS}';
$txtBirthdayEmails['zwaldowski_author'] = '<a href="https://www.simplemachines.org/community/?action=profile;u=72038">zwaldowski</a>';

$txtBirthdayEmails['geezmo_subject'] = 'Grattis på födelsedagen, {REALNAME}!';
$txtBirthdayEmails['geezmo_body'] = 'Vet du vems födelsedag det är idag, {REALNAME}?

Vi vet... DIN!!!

Grattis på födelsedagen!

Du har nu blivit ett år äldre men vi hoppas du är mycket lyckligare än förra året.

Njut av din dag idag, {REALNAME}!

- Från din {FORUMNAME}-familj';
$txtBirthdayEmails['geezmo_author'] = '<a href="https://www.simplemachines.org/community/?action=profile;u=48671">geezmo</a>';

$txtBirthdayEmails['karlbenson2_subject'] = 'Dina födelsedagshälsningar';
$txtBirthdayEmails['karlbenson2_body'] = 'Vi hoppas att din födelsedag är den bästa någonsin, molnigt eller soligt spelar ingen roll
Ha en trevlig födelsedag, ät mycket tårta och ha kul. Berätta sedan vad du gjorde.

Vi hoppas detta meddelande förde glädje med sig och må det hålla i sig tills nästa år den här tiden.

{REGARDS}';
$txtBirthdayEmails['karlbenson2_author'] = '<a href="https://www.simplemachines.org/community/?action=profile;u=63186">karlbenson</a>';

?>