<?php
// Version: 2.1.0; EmailTemplates

// Since all of these strings are being used in emails, numeric entities should be used.

// Do not translate anything that is between {}, they are used as replacement variables and MUST remain exactly how they are.
//   Additionally, do not translate the @additional_params: line or the variable names in the lines that follow it. You may
//   translate the description of the variable. Do not translate @description:, however you may translate the rest of that line.

// Do not use block comments in this file, they will have special meaning.

global $txtBirthdayEmails;

/**
	@additional_params: resend_activate_message
		REALNAME: The display name for the member receiving the email.
		USERNAME:  The user name for the member receiving the email.
		ACTIVATIONLINK:  The URL link to activate the member's account.
		ACTIVATIONCODE:  The code needed to activate the member's account.
		ACTIVATIONLINKWITHOUTCODE: The URL to the page where the activation code can be entered.
		FORGOTPASSWORDLINK: The URL to the "forgot password" page.
	@description:
*/
$txt['resend_activate_message_subject'] = 'Witaj na {FORUMNAME}';
$txt['resend_activate_message_body'] = 'Dziękujemy za rejestrację na {FORUMNAME}. Twoja nazwa użytkownika to {USERNAME}. Jeżeli nie pamiętasz hasła, możesz je zresetować odwiedzając {FORGOTPASSWORDLINK}.

Zanim możesz się zalogować, wymagana jest aktywacja konta poprzez poniższy link:

{ACTIVATIONLINK}

W razie problemów z aktywacją konta, odwiedź {ACTIVATIONLINKWITHOUTCODE} i wpisz kod "{ACTIVATIONCODE}".

{REGARDS}';

/**
	@additional_params: resend_pending_message
		REALNAME: The display name for the member receiving the email.
		USERNAME:  The user name for the member receiving the email.
	@description:
*/
$txt['resend_pending_message_subject'] = 'Witaj na {FORUMNAME}';
$txt['resend_pending_message_body'] = 'Witaj {REALNAME}, Twoja rejestracja na {FORUMNAME} została przyjęta.

Twoja nazwa użytkownika użyta podczas rejestracji to {USERNAME}.

Zanim możesz się zalogować i zacząć używać forum, Twoje żądanie musi zostać przejrzane i zatwierdzone.

{REGARDS}';

/**
	@additional_params: mc_group_approve
		USERNAME: The user name for the member receiving the email.
		GROUPNAME: The name of the membergroup that the user was accepted into.
	@description: The request to join a particular membergroup has been accepted.
*/
$txt['mc_group_approve_subject'] = 'Zaakceptowano członkostwo w grupie';
$txt['mc_group_approve_body'] = '{USERNAME},

We\'re pleased to notify you that your application to join the "{GROUPNAME}" group at {FORUMNAME} has been accepted, and your account has been updated to include this new membergroup.

{REGARDS}';

/**
	@additional_params: mc_group_reject
		USERNAME: The user name for the member receiving the email.
		GROUPNAME: The name of the membergroup that the user was rejected from.
	@description: The request to join a particular membergroup has been rejected.
*/
$txt['mc_group_reject_subject'] = 'Odrzucono członkostwo w grupie';
$txt['mc_group_reject_body'] = '{USERNAME},

We\'re sorry to notify you that your application to join the "{GROUPNAME}" group at {FORUMNAME} has been rejected.

{REGARDS}';

/**
	@additional_params: mc_group_reject_reason
		USERNAME: The user name for the member receiving the email.
		GROUPNAME: The name of the membergroup that the user was rejected from.
		REASON: Reason for the rejection.
	@description: The request to join a particular membergroup has been rejected with a reason given.
*/
$txt['mc_group_reject_reason_subject'] = 'Odrzucono członkostwo w grupie';
$txt['mc_group_reject_reason_body'] = '{USERNAME},

We\'re sorry to notify you that your application to join the "{GROUPNAME}" group at {FORUMNAME} has been rejected.

This is due to the following reason: {REASON}

{REGARDS}';

/**
	@additional_params: admin_approve_accept
		NAME: The display name of the member.
		USERNAME: The user name for the member receiving the email.
		PROFILELINK: The URL of the profile page.
		FORGOTPASSWORDLINK: The URL of the "forgot password" page.
	@description:
*/
$txt['admin_approve_accept_subject'] = 'Witaj na {FORUMNAME}';
$txt['admin_approve_accept_body'] = 'Witaj, {NAME}

Twoje konto zostało manualnie aktywowane przez administratora, możesz się zalogować i zacząć pisać. Twoja nazwa użytkownika to: {USERNAME}. Jeżeli nie pamiętam hasła, możesz je zresetować odwiedzając {FORGOTPASSWORDLINK}.

{REGARDS}';

/**
	@additional_params: admin_approve_activation
		USERNAME: The user name for the member receiving the email.
		ACTIVATIONLINK:  The URL link to activate the member's account.
		ACTIVATIONLINKWITHOUTCODE: The URL to the page where the activation code can be entered.
		ACTIVATIONCODE: The activation code.
	@description:
*/
$txt['admin_approve_activation_subject'] = 'Witaj na {FORUMNAME}';
$txt['admin_approve_activation_body'] = 'Witaj, {USERNAME}!

Twoje konto na {FORUMNAME} zostało zatwierdzone przez administratora forum. Zanim będziesz mógł się zalogować, wymagana jest aktywacja konta poprzez poniższy link:

{ACTIVATIONLINK}

W razie problemów, proszę odwiedź {ACTIVATIONLINKWITHOUTCODE} i wpisz kod "{ACTIVATIONCODE}".

{REGARDS}';

/**
	@additional_params: admin_approve_reject
		USERNAME: The user name for the member receiving the email.
	@description:
*/
$txt['admin_approve_reject_subject'] = 'Rejestracja odrzucona';
$txt['admin_approve_reject_body'] = '{USERNAME},

Regrettably, your application to join {FORUMNAME} has been rejected.

{REGARDS}';

/**
	@additional_params: admin_approve_delete
		USERNAME: The user name for the member receiving the email.
	@description:
*/
$txt['admin_approve_delete_subject'] = 'Konto zostało usunięte';
$txt['admin_approve_delete_body'] = '{USERNAME},

Your account on {FORUMNAME} has been deleted. This may be because you never activated your account, in which case you should be able to register again.

{REGARDS}';

/**
	@additional_params: admin_approve_remind
		USERNAME: The user name for the member receiving the email.
		ACTIVATIONLINK:  The URL link to activate the member's account.
		ACTIVATIONLINKWITHOUTCODE: The URL to the page where the activation code can be entered.
		ACTIVATIONCODE: The activation code.
	@description:
*/
$txt['admin_approve_remind_subject'] = 'Przypomnienie o rejestracji';
$txt['admin_approve_remind_body'] = '{USERNAME},
You still have not activated your account at {FORUMNAME}.

Please use the link below to activate your account:
{ACTIVATIONLINK}

Should you have any problems with the activation, please visit {ACTIVATIONLINKWITHOUTCODE} and enter the code "{ACTIVATIONCODE}".

{REGARDS}';

/**
	@additional_params:
		USERNAME: The user name for the member receiving the email.
		ACTIVATIONLINK:  The URL link to activate the member's account.
		ACTIVATIONLINKWITHOUTCODE: The URL to the page where the activation code can be entered.
		ACTIVATIONCODE: The activation code.
	@description:
*/
$txt['admin_register_activate_subject'] = 'Witaj na {FORUMNAME}';
$txt['admin_register_activate_body'] = 'Dziękujęmy za rejestrację {FORUMNAME}. Twoja nazwa uzytkownik to {USERNAME}, a hasło to {PASSWORD}.

Zanim będziesz mógł się zalogować, wymagana jest aktywacja konta poprzez poniższy link:

{ACTIVATIONLINK}

W razie problemów, proszę odwiedź {ACTIVATIONLINKWITHOUTCODE} i wpisz kod "{ACTIVATIONCODE}".

{REGARDS}';

$txt['admin_register_immediate_subject'] = 'Witaj na {FORUMNAME}';
$txt['admin_register_immediate_body'] = 'Dziękujęmy za rejestrację {FORUMNAME}. Twoja nazwa uzytkownik to {USERNAME}, a hasło to {PASSWORD}. Link do forum: {SCRIPTURL}.

{REGARDS}';

/**
	@additional_params: new_announcement
		TOPICSUBJECT: The subject of the topic being announced.
		MESSAGE: The message body of the first post of the announced topic.
		TOPICLINK: A link to the topic being announced.
		UNSUBSCRIBELINK: Link to unsubscribe from announcements.
	@description:
*/
$txt['new_announcement_subject'] = 'Nowe ogłoszenie: {TOPICSUBJECT}';
$txt['new_announcement_body'] = '{MESSAGE}

Możesz zobaczyć pełną treść ogłoszenia odwiedzając poniższy link:
{TOPICLINK}

Odwiedź poniższe link, jeżeli nie chcesz dostawać ogłoszeń:
{UNSUBSCRIBELINK}

Jeżeli chcesz większą kontrolę nad powiadomieniami e-mail jakie otrzymujesz, zaloguj się na forum i idź do sekcji Powiadomień w Twoim profilu.

{REGARDS}';

/**
	@additional_params: notify_boards_once_body
		TOPICSUBJECT: The subject of the topic causing the notification
		TOPICLINK: A link to the topic.
		MESSAGE: This is the body of the message.
		UNSUBSCRIBELINK: Link to unsubscribe from notifications.
	@description:
*/
$txt['notify_boards_once_body_subject'] = 'Nowy wątek: {TOPICSUBJECT}';
$txt['notify_boards_once_body_body'] = 'Nowy wątek, \'{TOPICSUBJECT}\', został założony w dziale który obserwujesz.

Zobacz więcej
{TOPICLINK}

Mogło zostać założonych więcej wątków, ale nie otrzymasz więcej powiadomień email dla tego działu dopóki nie powrócisz do działu i przeczytasz niektóre z nich.

Treść wątku:
{MESSAGE}

Usuń subskrypcję dla nowych wątkow w tym dziale używając poniższego linku:
{UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notify_boards_once
		TOPICSUBJECT: The subject of the topic causing the notification
		TOPICLINK: A link to the topic.
		UNSUBSCRIBELINK: Link to unsubscribe from notifications.
	@description:
*/
$txt['notify_boards_once_subject'] = 'Nowy wątek: {TOPICSUBJECT}';
$txt['notify_boards_once_body'] = 'Nowy wątek, \'{TOPICSUBJECT}\', został założony w dziale który obserwujesz.

Zobacz więcej
{TOPICLINK}

Mogło zostać założonych więcej wątków, ale nie otrzymasz więcej powiadomień email dla tego działu dopóki nie powrócisz do działu i przeczytasz niektóre z nich.

Usuń subskrypcję dla nowych wątkow w tym dziale używając poniższego linku:
{UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notify_boards_body
		TOPICSUBJECT: The subject of the topic causing the notification
		TOPICLINK: A link to the topic.
		MESSAGE: This is the body of the message.
		UNSUBSCRIBELINK: Link to unsubscribe from notifications.
	@description:
*/
$txt['notify_boards_body_subject'] = 'Nowy wątek: {TOPICSUBJECT}';
$txt['notify_boards_body_body'] = 'Nowy wątek, \'{TOPICSUBJECT}\', został założony w dziale który obserwujesz.

Zobacz więcej
{TOPICLINK}

Treść wątku:
{MESSAGE}

Usuń subskrypcję dla nowych wątkow w tym dziale używając poniższego linku:
{UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notify_boards
		TOPICSUBJECT: The subject of the topic causing the notification
		TOPICLINK: A link to the topic.
		UNSUBSCRIBELINK: Link to unsubscribe from notifications.
	@description:
*/
$txt['notify_boards_subject'] = 'Nowy wątek: {TOPICSUBJECT}';
$txt['notify_boards_body'] = 'Nowy wątek, \'{TOPICSUBJECT}\', został założony w dziale który obserwujesz.

Zobacz więcej
{TOPICLINK}

Usuń subskrypcję dla nowych wątkow w tym dziale używając poniższego linku:
{UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: alert_unapproved_reply
		SUBJECT: The subject of the topic causing the notification
		LINK: A link to the topic.
	@description:
*/
$txt['alert_unapproved_reply_subject'] = 'Odpowiedź w wątku: {SUBJECT}';
$txt['alert_unapproved_reply_body'] = 'Pojawiła się nowa odpowiedź w \'{SUBJECT}\' przez {POSTERNAME}.

Możesz ją zobaczyć klikając w link
{LINK}

{REGARDS}';

/**
	@additional_params: unapproved_attachment
		SUBJECT: The subject of the topic causing the notification
		LINK: A link to the message with the attachment.
	@description:
*/
$txt['unapproved_attachment_subject'] = 'Nowy niezatwierdzony załącznik w: {SUBJECT}';
$txt['unapproved_attachment_body'] = 'A new attachment has been made in \'{SUBJECT}\' which needs to be approved.

You can approve or reject this attachment from the link below which will take you to the message that it is a part of.

{LINK}

{REGARDS}';

/**
	@additional_params: alert_unapproved_post
		SUBJECT: The subject of the topic causing the notification
		LINK: A link to the topic.
	@description:
*/
$txt['alert_unapproved_post_subject'] = 'Nowa niezaakceptowana wiadomość: {SUBJECT}';
$txt['alert_unapproved_post_body'] = 'A new post has been made which needs to be approved: \'{SUBJECT}\'

You can approve or reject this post by using the link below:
{LINK}

{REGARDS}';

/**
	@additional_params: alert_unapproved_topic
		SUBJECT: The subject of the topic causing the notification
		LINK: A link to the topic.
	@description:
*/
$txt['alert_unapproved_topic_subject'] = 'Nowy niezaakceptowany wątek: {SUBJECT}';
$txt['alert_unapproved_topic_body'] = 'A new topic has been made which needs to be approved: \'{SUBJECT}\'

You can approve or reject this topic by using the link below:
{LINK}

{REGARDS}';

/**
	@additional_params: request_membership
		RECPNAME: The name of the person receiving the email
		APPLYNAME: The name of the person applying for group membership
		GROUPNAME: The name of the group being applied to.
		REASON: The reason given by the applicant for wanting to join the group.
		MODLINK: Link to the group moderation page.
	@description:
*/
$txt['request_membership_subject'] = 'Nowe żądanie grupy użytkowników';
$txt['request_membership_body'] = '{RECPNAME},

{APPLYNAME} zażądał przynależność do grupy użytkowników "{GROUPNAME}". Użytkownik podał następujący powód:

{REASON}

Możesz zaakceptować lub odrzucić to żądanie używając linku:

{MODLINK}

{REGARDS}';

/**
	@additional_params: paid_subscription
		REALNAME: The real (display) name of the person receiving the email.
		PROFILE_LINK: Link to profile of member receiving email where can renew.
		SUBSCRIPTION: Name of the subscription.
		END_DATE: Date it expires.
	@description:
*/
$txt['paid_subscription_reminder_subject'] = 'Subskrypcja niedługo wygasa na {FORUMNAME}';
$txt['paid_subscription_reminder_body'] = 'Twoja subskrypcja na {FORUMNAME} wkrótce wygaśnie. Jeśli wybrałeś opcję automatycznego odnawiania, nie musisz podejmować żadnych działań; w przeciwnym razie możesz rozważyć ponowną subskrypcję. Szczegóły znajdują się poniżej:
Nazwa subskrypcji: {SUBSCRIPTION}
Wygasa: {END_DATE}
Aby edytować swoje subskrypcje, odwiedź następujący adres URL:
{PROFILE_LINK}

{REGARDS}';

/**
	@additional_params: activate_reactivate
		ACTIVATIONLINK:  The URL link to reactivate the member's account.
		ACTIVATIONCODE:  The code needed to reactivate the member's account.
		ACTIVATIONLINKWITHOUTCODE: The URL to the page where the activation code can be entered.
	@description:
*/
$txt['activate_reactivate_subject'] = 'Witaj ponownie na {FORUMNAME}';
$txt['activate_reactivate_body'] = 'In order to re-validate your email address, your account has been deactivated. Click the following link to activate it again:
{ACTIVATIONLINK}

Should you have any problems with activation, please visit {ACTIVATIONLINKWITHOUTCODE} and use the code "{ACTIVATIONCODE}".

{REGARDS}';

/**
	@additional_params: forgot_password
		REALNAME: The real (display) name of the person receiving the reminder.
		REMINDLINK: The link to reset the password.
		IP: The IP address of the requester.
		MEMBERNAME:
	@description:
*/
$txt['forgot_password_subject'] = 'Nowe hasło na {FORUMNAME}';
$txt['forgot_password_body'] = 'Dear {REALNAME},
This mail was sent because the \'forgot password\' function has been applied to your account. To set a new password, click the following link:
{REMINDLINK}

IP: {IP}
Username: {MEMBERNAME}

{REGARDS}';

/**
	@additional_params: send_email
		EMAILSUBJECT: The subject the user wants to email.
		EMAILBODY: The body the user wants to email.
		SENDERNAME: The name of the member sending the email.
		RECPNAME: The name of the person receiving the email.
	@description:
*/
$txt['send_email_subject'] = '{EMAILSUBJECT}';
$txt['send_email_body'] = '{EMAILBODY}';

/**
	@additional_params: report_to_moderator
		TOPICSUBJECT: The subject of the reported post.
		POSTERNAME: The reported post's author's name.
		REPORTERNAME: The name of the person reporting the post.
		TOPICLINK: The URL of the post that is being reported.
		REPORTLINK: The URL of the moderation center report.
		COMMENT: The comment left by the reporter, hopefully to explain why they are reporting the post.
	@description: When a user reports a post this email is sent out to moderators and admins of that board.
*/
$txt['report_to_moderator_subject'] = 'Raportowana wiadomość: {TOPICSUBJECT} przez {POSTERNAME}';
$txt['report_to_moderator_body'] = 'The following post, "{TOPICSUBJECT}" by {POSTERNAME} has been reported by {REPORTERNAME} on a board you moderate:

The topic: {TOPICLINK}
Moderation center: {REPORTLINK}

The reporter has made the following comment:
{COMMENT}

{REGARDS}';

/**
	@additional_params: report_to_moderator
		TOPICSUBJECT: The subject of the reported post.
		POSTERNAME: The reported post's author's name.
		COMMENTERNAME: The name of the person who replied to the report.
		TOPICLINK: The URL of the post that is being reported.
		REPORTLINK: The URL of the moderation center report.
	@description: When a moderator replies to a moderation report, this can be sent to the other moderators who previously replied.
*/
$txt['reply_to_moderator_subject'] = 'Odpowiedz na zgłoszoną wiadomość: {TOPICSUBJECT} przez {POSTERNAME}';
$txt['reply_to_moderator_body'] = 'Poprzednio, "{TOPICSUBJECT}" został zgłoszony do moderatorów.

Od tego czasu, {COMMENTERNAME} dodał komentarz do zgłoszenia. Więcej informacji znajduje się na forum.

Wątek: {TOPICLINK}
Centrum moderacji: {REPORTLINK}

{REGARDS}';

/**
	@additional_params: report_user_profile
		MEMBERNAME: The display name of the reported user
		REPORTERNAME: The name of the person reporting the profile
		PROFILELINK: The link to the profile that was reported
		COMMENT: The comment left by the reporter.
 	@description: When a user's profile is reported
*/
$txt['report_member_profile_subject'] = 'Zgłoszony profil użytkownika: {MEMBERNAME}';
$txt['report_member_profile_body'] = 'The profile of "{MEMBERNAME}" has been reported by {REPORTERNAME}.

The profile: {PROFILELINK}
Moderation center: {REPORTLINK}

The reporter has made the following comment:
{COMMENT}

{REGARDS}';

/**
	@additional_params: report_user_profile
		MEMBERNAME: The display name of the reported user
		COMMENTERNAME: The name of the person who added the comment
		PROFILELINK: The link to the profile that was reported
 	@description: When someone replies to a report about a profile, this can be sent to others who replied
*/
$txt['reply_to_member_report_subject'] = 'Odpowiedz na zgłoszenie profilu użytkownika: {MEMBERNAME}';
$txt['reply_to_member_report_body'] = 'Previously, the profile of {MEMBERNAME} was reported.

Since then, {COMMENTERNAME} has added a comment to the report. More information can be found in the forum.

The profile: {PROFILELINK}
Moderation center: {REPORTLINK}

{REGARDS}';

/**
	@additional_params: change_password
		USERNAME: The user name for the member receiving the email.
		PASSWORD: The password for the member.
	@description:
*/
$txt['change_password_subject'] = 'Szczegóły nowego hasła';
$txt['change_password_body'] = 'Drogi {USERNAME},

Twoje dane dotyczące logowania na {FORUMNAME} zostały zmienione i Twoje hasło zostało zresetowane. Poniżej znajdują się nowe dane do logowania.

Nazwa użytkownika "{USERNAME}", hasło "{PASSWORD}".

Możesz dokonać zmian po zalogowaniu i przejściu do profilu użytkownika, lub odwiedzając po zalogowaniu: {SCRIPTURL}?action=profile

{REGARDS}';

/**
	@additional_params: register_activate
		REALNAME: The display name for the member receiving the email.
		USERNAME: The user name for the member receiving the email.
		PASSWORD: The password for the member.
		ACTIVATIONLINK:  The URL link to reactivate the member's account.
		ACTIVATIONLINKWITHOUTCODE: The URL to the page where the activation code can be entered.
		ACTIVATIONCODE:  The code needed to reactivate the member's account.
		FORGOTPASSWORDLINK: The URL to the "forgot password" page.
	@description:
*/
$txt['register_activate_subject'] = 'Witaj na {FORUMNAME}';
$txt['register_activate_body'] = 'Dziękujemy za rejestrację na {FORUMNAME}. Twoja nazwa użytkownika to {USERNAME}. Jeżeli zapomnisz swoje hasło, możesz je zresetować odwiedzając {FORGOTPASSWORDLINK}.

Zanim możesz się zalogować, wymagana jest aktywacja konta poprzez poniższy link:

{ACTIVATIONLINK}

W razie problemów z aktywacją konta, odwiedź {ACTIVATIONLINKWITHOUTCODE} i wpisz kod "{ACTIVATIONCODE}".

{REGARDS}';

/**
	@additional_params: register_coppa
		REALNAME: The display name for the member receiving the email.
		USERNAME: The user name for the member receiving the email.
		PASSWORD: The password for the member.
		COPPALINK:  The URL link to the coppa form.
		FORGOTPASSWORDLINK: The URL to the "forgot password" page.
	@description:
*/
$txt['register_coppa_subject'] = 'Witaj na {FORUMNAME}';
$txt['register_coppa_body'] = 'Dziękujemy za rejestrację na {FORUMNAME}. Twoja nazwa użytkownika to {USERNAME}. Jeżeli zapomnisz swoje hasło, możesz je zmienić odwiedzając {FORGOTPASSWORDLINK}

Administrator wymaga zgody Twojego rodzica/opiekuna na dołączenie do społeczności, zanim będziesz mógł się zalogować. Możesz uzyskać więcej informacji pod poniższym linkiem:

{COPPALINK}

{REGARDS}';

/**
	@additional_params: register_immediate
		REALNAME: The display name for the member receiving the email.
		USERNAME: The user name for the member receiving the email.
		PASSWORD: The password for the member.
		FORGOTPASSWORDLINK: The URL to the "forgot password" page.
	@description:
*/
$txt['register_immediate_subject'] = 'Witaj na {FORUMNAME}';
$txt['register_immediate_body'] = 'Thank you for registering at {FORUMNAME}. Your username is {USERNAME}. If you forget your password, you may change it at {FORGOTPASSWORDLINK}.

{REGARDS}';

/**
	@additional_params: register_pending
		REALNAME: The display name for the member receiving the email.
		USERNAME: The user name for the member receiving the email.
		PASSWORD: The password for the member.
		FORGOTPASSWORDLINK: The URL to the "forgot password" page.
	@description:
*/
$txt['register_pending_subject'] = 'Witaj na {FORUMNAME}';
$txt['register_pending_body'] = 'Witaj {REALNAME}, Twoja rejestracja na {FORUMNAME} została przyjęta.

Twoja nazwa użytkownika użyta podczas rejestracji to {USERNAME}. Jeżeli zapomnisz swoje hasło, możesz je zmienić odwiedzając {FORGOTPASSWORDLINK}.

Zanim możesz się zalogować i zacząć używać forum, Twoje żądanie musi zostać przejrzane i zatwierdzone.

{REGARDS}';

/**
	@additional_params: notification_reply
		TOPICSUBJECT:
		POSTERNAME:
		TOPICLINK:
		UNSUBSCRIBELINK:
	@description:
*/
$txt['notification_reply_subject'] = 'Odpowiedź w wątku: {TOPICSUBJECT}';
$txt['notification_reply_body'] = 'Nowa wiadomość w wątku którym obserwujesz, wysłana przez {POSTERNAME}.

Zobacz odpowiedź: {TOPICLINK}

Odsubskrybuj ten wątek używając ten odnośnik: {UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notification_reply_body
		TOPICSUBJECT:
		POSTERNAME:
		TOPICLINK:
		UNSUBSCRIBELINK:
		MESSAGE:
	@description:
*/
$txt['notification_reply_body_subject'] = 'Odpowiedź w wątku: {TOPICSUBJECT}';
$txt['notification_reply_body_body'] = 'Nowa wiadomość w wątku którym obserwujesz, wysłana przez {POSTERNAME}.

Zobacz odpowiedź: {TOPICLINK}

Odsubskrybuj ten wątek używając ten odnośnik: {UNSUBSCRIBELINK}

Treść wiadomości:
{MESSAGE}

{REGARDS}';

/**
	@additional_params: notification_reply_once
		TOPICSUBJECT:
		POSTERNAME:
		TOPICLINK:
		UNSUBSCRIBELINK:
	@description:
*/
$txt['notification_reply_once_subject'] = 'Odpowiedź w wątku: {TOPICSUBJECT}';
$txt['notification_reply_once_body'] = 'Nowa wiadomość w wątku którym obserwujesz, wysłana przez {POSTERNAME}.

Zobacz odpowiedź: {TOPICLINK}

Odsubskrybuj ten wątek używając ten odnośnik: {UNSUBSCRIBELINK}

Więcej odpowiedzi mogło zostać napisanych, ale nie otrzymasz więcej powiadomień dotyczących tego wątku, dopóki go nie otworzysz.

{REGARDS}';

/**
	@additional_params: notification_reply_body_once
		TOPICSUBJECT:
		POSTERNAME:
		TOPICLINK:
		UNSUBSCRIBELINK:
		MESSAGE:
	@description:
*/
$txt['notification_reply_body_once_subject'] = 'Odpowiedź w wątku: {TOPICSUBJECT}';
$txt['notification_reply_body_once_body'] = 'Nowa wiadomość w wątku którym obserwujesz, wysłana przez {POSTERNAME}.

Zobacz odpowiedź: {TOPICLINK}

Odsubskrybuj ten wątek używając odnośnik: {UNSUBSCRIBELINK}

Treść wątku:
{MESSAGE}

Więcej odpowiedzi mogło zostać napisanych, ale nie otrzymasz więcej powiadomień dotyczących tego wątku, dopóki go nie otworzysz.

{REGARDS}';

/**
	@additional_params: notification_sticky
	@description:
*/
$txt['notification_sticky_subject'] = 'Przyklejono wątek: {TOPICSUBJECT}';
$txt['notification_sticky_body'] = 'Wątek, który obserwujesz został przyklejony.

Zobacz wątek na: {TOPICLINK}

Odsubskrybuj ten wątek używając ten odnośnik: {UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notification_lock
	@description:
*/
$txt['notification_lock_subject'] = 'Zamknięto wątek: {TOPICSUBJECT}';
$txt['notification_lock_body'] = 'Wątek, który obserwujesz został zamknięty.

Zobacz wątek na: {TOPICLINK}

Odsubskrybuj ten wątek używając ten odnośnik: {UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notification_unlock
	@description:
*/
$txt['notification_unlock_subject'] = 'Odblokowano wątek: {TOPICSUBJECT}';
$txt['notification_unlock_body'] = 'Wątek, który obserwujesz został otworzony.

Zobacz wątek na: {TOPICLINK}

Odsubskrybuj ten wątek używając ten odnośnik: {UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notification_remove
	@description:
*/
$txt['notification_remove_subject'] = 'Usunięto wątek: {TOPICSUBJECT}';
$txt['notification_remove_body'] = 'A topic you are watching has been removed.

{REGARDS}';

/**
	@additional_params: notification_move
	@description:
*/
$txt['notification_move_subject'] = 'Przeniesiono wątek: {TOPICSUBJECT}';
$txt['notification_move_body'] = 'Wątek, który obserwujesz został przeniesiony do innego działu.

Zobacz wątek na: {TOPICLINK}

Odsubskrybuj ten wątek używając ten odnośnik: {UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notification_merged
	@description:
*/
$txt['notification_merge_subject'] = 'Scalono wątek: {TOPICSUBJECT}';
$txt['notification_merge_body'] = 'Wątek, który obserwujesz został scalony z innym wątkiem.

Zobacz nowo scalony wątek na: {TOPICLINK}

Odsubskrybuj ten wątek używając ten odnośnik: {UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notification_split
	@description:
*/
$txt['notification_split_subject'] = 'Podzielono wątek: {TOPICSUBJECT}';
$txt['notification_split_body'] = 'Wątek, który obserwujesz został podzielony na dwa lub więcej wątków.

Zobacz pozostałości wątku na: {TOPICLINK}

Odsubskrybuj ten wątek używając ten odnośnik: {UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: admin_notify
		USERNAME:
		PROFILELINK:
	@description:
*/
$txt['admin_notify_subject'] = 'Dołączył nowy użytkownik';
$txt['admin_notify_body'] = '{USERNAME} has just signed up as a new member of your forum. Click the link below to view their profile.
{PROFILELINK}

{REGARDS}';

/**
	@additional_params: admin_notify_approval
		USERNAME:
		PROFILELINK:
		APPROVALLINK:
	@description:
*/
$txt['admin_notify_approval_subject'] = 'Dołączył nowy użytkownik';
$txt['admin_notify_approval_body'] = '{USERNAME} has just signed up as a new member of your forum. Click the link below to view their profile.
{PROFILELINK}

Before this member can begin posting they must first have their account approved. Click the link below to go to the approval screen.
{APPROVALLINK}

{REGARDS}';

/**
	@additional_params: admin_attachments_full
		REALNAME:
	@description:
*/
$txt['admin_attachments_full_subject'] = 'Pilne! Katalog z załącznikami jest prawie zapełniony';
$txt['admin_attachments_full_body'] = '{REALNAME},

Katalog z załącznikami na {FORUMNAME} jest prawie pełny. Odwiedź forum w celu rozwiązania tego problemu.

Gdy katalog załączników osiągnie pełny dozwolony rozmiar, to użytkownicy przestaną mieć możliwość dodawania załączników lub awatarów (jeżeli włączone).';

/**
	@additional_params: paid_subscription_refund
		NAME: Subscription title.
		REALNAME: Recipients name
		REFUNDUSER: Username who took out the subscription.
		REFUNDNAME: User's display name who took out the subscription.
		DATE: Today's date.
		PROFILELINK: Link to members profile.
	@description:
*/
$txt['paid_subscription_refund_subject'] = 'Zwrot płatnej subskrypcji';
$txt['paid_subscription_refund_body'] = '{REALNAME},

A member has received a refund on a paid subscription. Below are the details of this subscription:

	Subscription: {NAME}
	User Name: {REFUNDNAME} ({REFUNDUSER})
	Date: {DATE}

You can view this member\'s profile by clicking the link below:
{PROFILELINK}

{REGARDS}';

/**
	@additional_params: paid_subscription_new
		NAME: Subscription title.
		REALNAME: Recipients name
		SUBEMAIL: Email address of the user who took out the subscription
		SUBUSER: Username who took out the subscription.
		SUBNAME: User's display name who took out the subscription.
		DATE: Today's date.
		PROFILELINK: Link to members profile.
	@description:
*/
$txt['paid_subscription_new_subject'] = 'Nowa płatna subskrypcja';
$txt['paid_subscription_new_body'] = '{REALNAME},

A member has taken out a new paid subscription. Below are the details of this subscription:

	Subscription: {NAME}
	User Name: {SUBNAME} ({SUBUSER})
	User Email: {SUBEMAIL}
	Price: {PRICE}
	Date: {DATE}

You can view this member\'s profile by clicking the link below:
{PROFILELINK}

{REGARDS}';

/**
	@additional_params: paid_subscription_error
		ERROR: Error message.
		REALNAME: Recipients name
	@description:
*/
$txt['paid_subscription_error_subject'] = 'Wystąpił błąd w płatnej subskrypcji';
$txt['paid_subscription_error_body'] = 'Dear {REALNAME},

The following error occurred when processing a paid subscription
---------------------------------------------------------------
{ERROR}

{REGARDS}';

/**
	@additional_params: new_pm
		SUBJECT: The personal message subject.
		SENDER:  The user name for the member sending the personal message.
		READLINK:  The link to directly access the read page.
		REPLYLINK:  The link to directly access the reply page.
	@description: A notification email sent to the receivers of a personal message
*/
$txt['new_pm_subject'] = 'Nowa prywatna wiadomość: {SUBJECT}';
$txt['new_pm_body'] = 'Otrzymano prywatną wiadomość od {SENDER} na {FORUMNAME}.

WAŻNE: Pamiętaj, to jest tylko powiadomienie. Nie odpisuj bezpośrednio na ten email.

Przeczytaj prywatną wiadomość tutaj: {READLINK}

Odpowiedź na tą prywatną wiadomość tutaj: {REPLYLINK}

{REGARDS}';

/**
	@additional_params: new_pm_body
		SUBJECT: The personal message subject.
		SENDER:  The user name for the member sending the personal message.
		MESSAGE:  The text of the personal message.
		REPLYLINK:  The link to directly access the reply page.
	@description: A notification email sent to the receivers of a personal message
*/
$txt['new_pm_body_subject'] = 'Nowa prywatna wiadomość: {SUBJECT}';
$txt['new_pm_body_body'] = 'Otrzymano prywatną wiadomość od {SENDER} na {FORUMNAME}.

WAŻNE: Pamiętaj, to jest tylko powiadomienie. Nie odpisuj bezpośrednio na ten email.

Treść otrzymanej wiadomości:

{MESSAGE}

Odpowiedź na tą prywatną wiadomość tutaj: {REPLYLINK}

{REGARDS}';

/**
	@additional_params: new_pm_tolist
		SUBJECT: The personal message subject.
		SENDER:  The user name for the member sending the personal message.
		READLINK:  The link to directly access the read page.
		REPLYLINK:  The link to directly access the reply page.
		TOLIST:  The list of users that will receive the personal message.
	@description: A notification email sent to the receivers of a personal message
*/
$txt['new_pm_tolist_subject'] = 'Nowa prywatna wiadomość: {SUBJECT}';
$txt['new_pm_tolist_body'] = 'Ty i {TOLIST} otrzymaliście prywatną wiadomość wysłaną przez {SENDER} na {FORUMNAME}.

WAŻNE: Pamiętaj, to jest tylko powiadomienie. Nie odpowiadaj na tego maila.

Przeczytaj prywatną wiadomość tutaj: {READLINK}

Odpowiedź na prywatną wiadomość (tylko do autora) tutaj: {REPLYLINK}

{REGARDS}';

/**
	@additional_params: new_pm_body_tolist
		SUBJECT: The personal message subject.
		SENDER:  The user name for the member sending the personal message.
		MESSAGE:  The text of the personal message.
		REPLYLINK:  The link to directly access the reply page.
		TOLIST:  The list of users that will receive the personal message.
	@description: A notification email sent to the receivers of a personal message
*/
$txt['new_pm_body_tolist_subject'] = 'Nowa prywatna wiadomość: {SUBJECT}';
$txt['new_pm_body_tolist_body'] = 'Ty i {TOLIST} otrzymaliście prywatną wiadomość wysłaną przez {SENDER} na {FORUMNAME}.

WAŻNE: Pamiętaj, to jest tylko powiadomienie. Nie odpowiadaj na tego maila.

Treść wiadomości:

{MESSAGE}

Odpowiedź na prywatną wiadomość (tylko do autora) tutaj: {REPLYLINK}

{REGARDS}';

/**
	@additional_params: msg_quote
		CONTENTSUBJECT: The post subject.
		QUOTENAME:  The user name for the member creating the quote
		MEMBERNAME:  The user name for the member being quoted
		CONTENTLINK:  The post's link
	@description: A notification email sent to the members who've been quoted in a post
 */
$txt['msg_quote_subject'] = 'Twoja wiadomość została zacytowana: {CONTENTSUBJECT}';
$txt['msg_quote_body'] = 'Hello {MEMBERNAME},

You have been quoted in the post titled "{CONTENTSUBJECT}" by {QUOTENAME}, you can see the post here:
{CONTENTLINK}

{REGARDS}';

/**
	@additional_params: msg_mention
		CONTENTSUBJECT: The post subject.
		MENTIONNAME:  The user name for the member creating the mention
		MEMBERNAME:  The user name for the member being mentioned
		CONTENTLINK:  The post's link
	@description: A notification email sent to the members who've been mentioned in a post
 */
$txt['msg_mention_subject'] = 'Zostałeś wspomniany w poście: {CONTENTSUBJECT}';
$txt['msg_mention_body'] = 'Cześć {MEMBERNAME},

Zostałeś wspomniany w poście "{CONTENTSUBJECT}" przez {MENTIONNAME}, możesz zobaczyć ten post tutaj:
{CONTENTLINK}

{REGARDS}';

/**
	@additional_params: happy_birthday
		REALNAME: The real (display) name of the person receiving the birthday message.
	@description: A message sent to members on their birthday.
*/
$txtBirthdayEmails['happy_birthday_subject'] = 'Wszystkiego najlepszego od {FORUMNAME}.';
$txtBirthdayEmails['happy_birthday_body'] = 'Dear {REALNAME},

We here at {FORUMNAME} would like to wish you a happy birthday. May this day and the year to follow be full of joy.

{REGARDS}';
$txtBirthdayEmails['happy_birthday_author'] = '<a href="https://www.simplemachines.org/community/?action=profile;u=2676">Thantos</a>';

$txtBirthdayEmails['karlbenson1_subject'] = 'W Twoje urodziny...';
$txtBirthdayEmails['karlbenson1_body'] = 'Mogliśmy wysłać urodzinową kartkę z życzeniami. Mogliśmy wysłać kwiaty lub ciasto.

Ale tego nie zrobiliśmy.

Mogliśmy nawet wysłać jedną z tych automatycznie generowanych wiadomości z życzeniami urodzinowymi, gdzie zapomnimy podmienić TWOJĘ IMIĘ TUTAJ.

Ale tego nie zrobiliśmy.

Napisaliśmy te życzenia specjalnie dla Ciebie.

Życzymy wszystkiego najlepszego.

{REGARDS}

//:: Ta wiadomość została wygenerowana automatycznie :://';
$txtBirthdayEmails['karlbenson1_author'] = '<a href="https://www.simplemachines.org/community/?action=profile;u=63186">karlbenson</a>';

$txtBirthdayEmails['nite0859_subject'] = 'Wszystkiego najlepszego z okazji urodzin!';
$txtBirthdayEmails['nite0859_body'] = 'Your friends at {FORUMNAME} would like to take a moment of your time to wish you a happy birthday, {REALNAME}. If you have not done so recently, please visit our community in order for others to have the opportunity to pass along their warm regards.

Even though today is your birthday, {REALNAME}, we would like to remind you that your membership in our community has been the best gift to us thus far.

Best Wishes,
The Staff of {FORUMNAME}';
$txtBirthdayEmails['nite0859_author'] = '<a href="https://www.simplemachines.org/community/?action=profile;u=46625">nite0859</a>';

$txtBirthdayEmails['zwaldowski_subject'] = 'Życzenia urodzinowe dla {REALNAME}';
$txtBirthdayEmails['zwaldowski_body'] = 'Dear {REALNAME},

Another year in your life has passed. We at {FORUMNAME} hope it has been filled with happiness, and wish you luck in the coming one.

{REGARDS}';
$txtBirthdayEmails['zwaldowski_author'] = '<a href="https://www.simplemachines.org/community/?action=profile;u=72038">zwaldowski</a>';

$txtBirthdayEmails['geezmo_subject'] = 'Wszystkiego najlepszego, {REALNAME}!';
$txtBirthdayEmails['geezmo_body'] = 'Do you know who\'s having a birthday today, {REALNAME}?

We know... YOU!

Happy birthday!

You\'re now a year older but we hope you\'re a lot happier than last year.

Enjoy your day today, {REALNAME}!

- From your {FORUMNAME} family';
$txtBirthdayEmails['geezmo_author'] = '<a href="https://www.simplemachines.org/community/?action=profile;u=48671">geezmo</a>';

$txtBirthdayEmails['karlbenson2_subject'] = 'Twoje życzenia urodzinowe';
$txtBirthdayEmails['karlbenson2_body'] = 'Mamy nadzieję, że Twoje urodziny są najlepsze, jakie mogą być; czy są w dzień pochmurny, czy słoneczny - nieważne jaka jest pogoda.
Miej dużo tortu i zabawy, a po wszystkim opowiedz nam o tym.

Mamy nadzieje, że ta wiadomość przyniosła uśmiech na twarzy, niech zostanie aż do kolejnych urodzin.

{REGARDS}';
$txtBirthdayEmails['karlbenson2_author'] = '<a href="https://www.simplemachines.org/community/?action=profile;u=63186">karlbenson</a>';

?>