<?php
// Version: 2.1.5; index

global $forum_copyright, $webmaster_email, $scripturl, $context, $boardurl;

// Native name, please use full HTML entities to write your language's name.
$txt['native_name'] = 'Deutsch („Sie“)';

// Locale (strftime, basename). For more information see:
//   - https://php.net/function.setlocale
$txt['lang_locale'] = 'de_DE';
$txt['lang_dictionary'] = 'de';
//https://developers.google.com/recaptcha/docs/language
$txt['lang_recaptcha'] = 'de';

// Ensure you remember to use uppercase for character set strings.
$txt['lang_character_set'] = 'UTF-8';
// Character set right to left?  0 = ltr; 1 = rtl
$txt['lang_rtl'] = '0';
// Number format.
$txt['number_format'] = '1.234,00';

$txt['days_title'] = 'Tage';
$txt['days'] = array('Sonntag', 'Montag', 'Dienstag', 'Mittwoch', 'Donnerstag', 'Freitag', 'Samstag');
$txt['days_short'] = array('So', 'Mo', 'Di', 'Mi', 'Do', 'Fr', 'Sa');
// Months must start with 1 => 'January'. (or translated, of course.)
$txt['months_title'] = 'Monate';
$txt['months'] = array(1 => 'Januar', 2 => 'Februar', 3 => 'März', 4 => 'April', 5 => 'Mai', 6 => 'Juni', 7 => 'Juli', 8 => 'August', 9 => 'September', 10 => 'Oktober', 11 => 'November', 12 => 'Dezember');
$txt['months_titles'] = array(1 => 'Januar', 2 => 'Februar', 3 => 'März', 4 => 'April', 5 => 'Mai', 6 => 'Juni', 7 => 'Juli', 8 => 'August', 9 => 'September', 10 => 'Oktober', 11 => 'November', 12 => 'Dezember');
$txt['months_short'] = array(1 => 'Jan', 2 => 'Feb', 3 => 'Mär', 4 => 'Apr', 5 => 'Mai', 6 => 'Jun', 7 => 'Jul', 8 => 'Aug', 9 => 'Sep', 10 => 'Okt', 11 => 'Nov', 12 => 'Dez');
$txt['prev_month'] = 'Vorheriger Monat';
$txt['next_month'] = 'Nächster Monat';
$txt['start'] = 'Anfang';
$txt['end'] = 'Ende';
$txt['starts'] = 'Beginnt';
$txt['ends'] = 'Endet';
$txt['none'] = 'Kein';

$txt['minutes_label'] = 'Minuten';
$txt['hours_label'] = 'Stunden';
$txt['years_title'] = 'Jahre';

$txt['time_am'] = 'Vormittag';
$txt['time_pm'] = 'nachmittags';

// Short form of minutes
$txt['minutes_short'] = 'Min.';
// Short form of hour
$txt['hour_short'] = 'Std';
// Short form of hours
$txt['hours_short'] = 'Std';
// Decimal sign
$txt['decimal_sign'] = ',';

$txt['admin'] = 'Administration';
$txt['moderate'] = 'Moderieren';

$txt['save'] = 'Speichern';
$txt['reset'] = 'Zurücksetzen';
$txt['upload'] = 'Hochladen';
$txt['upload_all'] = 'Alle hochladen';
$txt['processing'] = 'Verarbeite…';

$txt['modify'] = 'Bearbeiten';
$txt['forum_index'] = '%1$s – Index';
$txt['members'] = 'Mitglieder';
$txt['board_name'] = 'Boardname';
$txt['posts'] = 'Beiträge';

$txt['member_postcount'] = 'Beiträge';
$txt['no_subject'] = '(Kein Betreff)';
$txt['view_profile'] = 'Profil anzeigen';
$txt['guest_title'] = 'Gast';
$txt['author'] = 'Autor';
$txt['on'] = 'am';
$txt['remove'] = 'Entfernen';
$txt['start_new_topic'] = 'Neues Thema starten';

$txt['login'] = 'Einloggen';
// Use numeric entities in the below string.
$txt['username'] = 'Benutzername';
$txt['password'] = 'Passwort';

$txt['username_no_exist'] = 'Dieser Benutzername existiert nicht.';
$txt['no_user_with_email'] = 'Es sind keine Benutzernamen mit dieser E-Mail verknüpft.';

$txt['board_moderator'] = 'Moderator';
$txt['remove_topic'] = 'Thema entfernen';
$txt['topics'] = 'Themen';
$txt['modify_msg'] = 'Beitrag bearbeiten';
$txt['name'] = 'Name';
$txt['email'] = 'E-Mail';
$txt['user_email_address'] = 'E-Mail-Adresse';
$txt['subject'] = 'Betreff';
$txt['message'] = 'Nachricht';
$txt['redirects'] = 'Umleitungen';
$txt['quick_modify'] = 'Sofortiges Bearbeiten';
$txt['quick_modify_message'] = 'Sie haben diese Nachricht erfolgreich bearbeitet.';
$txt['reason_for_edit'] = 'Grund für die Bearbeitung';

$txt['choose_pass'] = 'Passwort wählen';
$txt['verify_pass'] = 'Passwort überprüfen';
$txt['notify_announcements'] = 'Den Administratoren erlauben, mir wichtige Neuigkeiten per E-Mail zu schicken';

$txt['position'] = 'Position';

// argument(s): username
$txt['view_profile_of_username'] = 'Profil von %1$s ansehen';
$txt['total'] = 'Gesamt';
$txt['website'] = 'Webseite';
$txt['register'] = 'Registrieren';
$txt['warning_status'] = 'Verwarnungsstatus';
$txt['user_warn_watch'] = 'Benutzer ist auf der Beobachtungsliste der Moderatoren';
$txt['user_warn_moderate'] = 'Beiträge des Benutzers werden moderiert';
$txt['user_warn_mute'] = 'Benutzer kann nicht schreiben';
$txt['warn_watch'] = 'Beobachtet';
$txt['warn_moderate'] = 'Moderiert';
$txt['warn_mute'] = 'Stumm geschaltet';

$txt['message_index'] = 'Mitteilungs-Index';
$txt['news'] = 'Neuigkeiten';
$txt['home'] = 'Übersicht';
$txt['page'] = 'Seite';
$txt['prev'] = 'Vorherige Seite';
$txt['next'] = 'Nächste Seite';

$txt['lock_unlock'] = 'Thema sperren/entsperren';
$txt['post'] = 'Abschicken';
$txt['error_occured'] = 'Es ist ein Fehler aufgetreten';
$txt['at'] = 'um';
$txt['by'] = 'von';
$txt['logout'] = 'Ausloggen';
$txt['started_by'] = 'Begonnen von';
$txt['topic_started_by'] = 'Gestartet von <strong>%1$s</strong> in <em>%2$s</em>';
$txt['replies'] = 'Antworten';
$txt['last_post'] = 'Letzter Beitrag';
$txt['first_post'] = 'Erster Beitrag';
$txt['last_poster'] = 'Letzter Beitrag von';
$txt['last_post_message'] = '<strong>Letzter Beitrag: </strong>%3$s <span class="postby">%2$s von %1$s</span>';
$txt['last_post_topic'] = '%1$s<br>von %2$s';
$txt['post_by_member'] = '<strong>%1$s</strong> von <strong>%2$s</strong><br>';
$txt['boardindex_total_posts'] = '%1$s Beiträge in %2$s Themen von %3$s Mitgliedern';
$txt['show'] = 'Zeige';
$txt['hide'] = 'Verstecken';

$txt['admin_login'] = 'Administrator-Login';
// Use numeric entities in the below string.
$txt['topic'] = 'Thema';
$txt['help'] = 'Hilfe';
$txt['terms_and_rules'] = 'Nutzungsbedingungen und Regeln';
$txt['watch_board'] = 'Dieses Board beobachten';
$txt['unwatch_board'] = 'Board nicht mehr beobachten';
$txt['watch_topic'] = 'Dieses Thema beobachten';
$txt['unwatch_topic'] = 'Thema nicht mehr beobachten';
$txt['watching_topic'] = 'Thema, das Sie beobachten';
$txt['watching_this_topic'] = 'Sie beobachten dieses Thema und werden über Aktivitäten benachrichtigt werden.';
$txt['notify'] = 'Benachrichtigen';
$txt['unnotify'] = 'Nicht benachrichtigen';

// Use numeric entities in the below string.
// argument(s): forum name
$txt['regards_team'] = 'Grüße,
Das Team von „%1$s“.';

$txt['notify_replies'] = 'Benachrichtigen';
$txt['move_topic'] = 'Thema verschieben';
$txt['move_to'] = 'Verschieben nach';
$txt['pages'] = 'Seiten';
$txt['users_active'] = 'Aktive Benutzer in den letzten %1$d Minuten';
$txt['personal_messages'] = 'Persönliche Mitteilungen';
$txt['reply_quote'] = 'Mit Zitat anworten';
$txt['reply'] = 'Antworten';
$txt['reply_noun'] = 'Antwort';
$txt['reply_number'] = 'Antwort #%1$s%2$s';
$txt['approve'] = 'Stimme zu';
$txt['unapprove'] = 'Genehmigung entziehen';
$txt['approve_all'] = 'Alle genehmigen';
$txt['issue_warning'] = 'Verwarnung aussprechen';
$txt['awaiting_approval'] = 'Wartet auf Genehmigung';
$txt['attach_awaiting_approve'] = 'Anhänge, die auf Genehmigung warten';
$txt['post_awaiting_approval'] = 'Dieser Beitrag wartet auf Genehmigung eines Moderators.';
$txt['there_are_unapproved_topics'] = 'In diesem Board benötigen %1$s Themen und %2$s Beiträge eine Genehmigung. Klicken Sie <a href="%3$s">hier</a>, um alle anzuzeigen.';
$txt['send_message'] = 'Sende die Nachricht';

$txt['msg_alert_no_messages'] = 'Sie haben keine Mitteilungen';
$txt['msg_alert_one_message'] = 'Sie haben <a href="%1$s">eine Nachricht</a>';
$txt['msg_alert_many_message'] = 'Sie haben <a href="%1$s">%2$d Nachrichten</a>';
$txt['msg_alert_one_new'] = 'einer ist neu';
$txt['msg_alert_many_new'] = '%1$d sind neu';
$txt['new_alert'] = 'Neuer Alarm';
$txt['remove_message'] = 'Diesen Beitrag entfernen';
$txt['remove_message_question'] = 'Diesen Beitrag entfernen?';

$txt['topic_alert_none'] = 'Keine Beiträge…';
$txt['pm_alert_none'] = 'Keine persönlichen Mitteilungen…';
$txt['no_messages'] = 'Keine Nachrichten';

$txt['online_users'] = 'Benutzer online';
$txt['jump_to'] = 'Springe zu';
$txt['go'] = 'Los';
$txt['are_sure_remove_topic'] = 'Sind Sie sicher, dass Sie dieses Thema entfernen möchten?';
$txt['yes'] = 'Ja';
$txt['no'] = 'Nein';

$txt['search_end_results'] = 'Ende der Ergebnisse';
$txt['search_on'] = 'in';

$txt['search'] = 'Suche';
$txt['all'] = 'Alle';
$txt['search_entireforum'] = 'Gesamtes Forum';
$txt['search_thisboard'] = 'Dieses Board';
$txt['search_thistopic'] = 'Dieses Thema';
$txt['search_members'] = 'Mitglieder';

$txt['back'] = 'Zurück';
$txt['continue'] = 'Weiter';
$txt['password_reminder'] = 'Passworterinnerung';
$txt['topic_started'] = 'Thema gestartet von';
$txt['title'] = 'Titel';
$txt['post_by'] = 'Beitrag von';
$txt['memberlist_searchable'] = 'Durchsuchbare Liste aller registrierten Mitglieder.';
$txt['welcome_newest_member'] = 'Bitte begrüßen Sie %1$s, unser neuestes Mitglied.';
$txt['admin_center'] = 'Administrationszentrum';
$txt['last_edit_by'] = '<span class="lastedit">Letzte Bearbeitung</span>: %1$s von %2$s';
$txt['last_edit_reason'] = '<span id="reason" class="lastedit">Grund</span>: %1$s';
$txt['notify_deactivate'] = 'Möchten Sie die E-Mail-Benachrichtigung zu diesem Thema deaktivieren?';
$txt['modified_time'] = 'Zuletzt bearbeitet';
$txt['modified_by'] = 'Bearbeitet von';

$txt['recent_posts'] = 'Neueste Beiträge';

$txt['location'] = 'Ort';
$txt['location_desc'] = 'Geografischer Standort.';
$txt['gender'] = 'Geschlecht';
$txt['gender_0'] = 'Keins / Keine Angabe';
$txt['gender_1'] = 'Männlich';
$txt['gender_2'] = 'Weiblich';
$txt['gender_desc'] = 'Ihr Geschlecht.';
$txt['icq'] = 'ICQ';
$txt['icq_desc'] = 'Das ist Ihre ICQ-Nummer.';
$txt['skype'] = 'Skype';
$txt['skype_desc'] = 'Ihr Skype-Benutzername';
$txt['personal_text'] = 'Persönlicher Text';
$txt['date_registered'] = 'Registriert';

$txt['recent_view'] = 'Anzeigen der neuesten Beiträge';
$txt['recent_updated'] = 'ist das zuletzt geänderte Thema';
$txt['is_recent_updated'] = '%1$s ist das zuletzt geänderte Thema';

$txt['male'] = 'Männlich';
$txt['female'] = 'Weiblich';

$txt['error_invalid_characters_username'] = 'Ungültiges Zeichen im Benutzernamen verwendet.';

// argument(s): forum name, login URL, login JavaScript snippet
$txt['welcome_guest'] = 'Willkommen im Forum „<strong>%1$s</strong>“. Bitte <a href="%2$s" onclick="%3$s">loggen Sie sich ein</a>.';

// argument(s): forum name, login URL, login JavaScript snippet, signup URL
$txt['welcome_guest_register'] = 'Willkommen im Forum „<strong>%1$s</strong>“. Bitte <a href="%2$s" onclick="%3$s">loggen Sie sich ein</a> oder <a href="%4$s">registrieren Sie sich</a>.';

// argument(s): $scripturl
$txt['welcome_guest_activate'] = '<a href="%1$s?action=activate">Haben Sie Ihre Aktivierungs-E-Mail verpasst?</a>';

// argument(s): $scripturl
$txt['register_prompt'] = 'Haben Sie keinen Account? <a href="%1$s?action=signup">Registrieren Sie sich</a>.';

// argument(s): forum name
$txt['welcome_to_forum'] = 'Willkommen im Forum „<strong>%1$s</strong>“.';

// @todo the following to sprintf
$txt['hello_member'] = 'Hallo,';
// Use numeric entities in the below string.
$txt['hello_guest'] = 'Willkommen,';
$txt['select_destination'] = 'Bitte wählen Sie ein Ziel';

// Escape any single quotes in here twice.. 'it\'s' -> 'it\\\'s'.
$txt['posted_by'] = 'Autor';

$txt['icon_smiley'] = 'Smiley';
$txt['icon_angry'] = 'Wütend';
$txt['icon_cheesy'] = 'Lächeln';
$txt['icon_laugh'] = 'Lach';
$txt['icon_sad'] = 'Traurig';
$txt['icon_wink'] = 'Zwinker';
$txt['icon_grin'] = 'Grins';
$txt['icon_shocked'] = 'Schockiert';
$txt['icon_cool'] = 'Cool';
$txt['icon_huh'] = 'Hä';
$txt['icon_rolleyes'] = 'Augenrollen';
$txt['icon_tongue'] = 'Zunge';
$txt['icon_embarrassed'] = 'Verlegen';
$txt['icon_lips'] = 'Schweigend';
$txt['icon_undecided'] = 'Unentschlossen';
$txt['icon_kiss'] = 'Kuss';
$txt['icon_cry'] = 'Heul';

$txt['moderator'] = 'Moderator';
$txt['moderators'] = 'Moderatoren';

$txt['views'] = 'Aufrufe';
$txt['new'] = 'Neu';

$txt['view_all_members'] = 'Mitglieder anzeigen';
$txt['view'] = 'Ansehen';

$txt['viewing_members'] = 'Mitglieder %1$s bis %2$s anzeigen';
$txt['of_total_members'] = 'von %1$s Mitgliedern';

$txt['forgot_your_password'] = 'Passwort vergessen?';

$txt['date'] = 'Datum';
// Use numeric entities in the below string.
$txt['from'] = 'Von';
$txt['check_new_messages'] = 'Auf neue Nachrichten prüfen';
$txt['to'] = 'An';

$txt['board_topics'] = 'Themen';
$txt['members_title'] = 'Mitglieder';
$txt['members_list'] = 'Mitgliederliste';
$txt['new_posts'] = 'Neue Beiträge';
$txt['old_posts'] = 'Keine neuen Beiträge';
$txt['redirect_board'] = 'Weiterleitungs-Board';

$txt['sendtopic_send'] = 'Senden';
$txt['report_sent'] = 'Ihr Report wurde erfolgreich gesendet.';
$txt['post_becomes_unapproved'] = 'Ihre Nachricht wurde nicht genehmigt, da sie in einem nicht genehmigten Thema geschrieben wurde. Sobald das Thema genehmigt wird, wird Ihre Nachricht ebenfalls genehmigt.';

$txt['time_offset'] = 'Zeitverschiebung';
$txt['or'] = 'oder';

$txt['no_matches'] = 'Keine Übereinstimmungen gefunden';

$txt['notification'] = 'Benachrichtigung';

$txt['your_ban'] = '%1$s, Sie sind aus diesem Forum verbannt!';
$txt['your_ban_expires'] = 'Dieser Bann läuft am %1$s aus.';
$txt['your_ban_expires_never'] = 'Dieser Bann hat kein Ablaufdatum.';
$txt['ban_continue_browse'] = 'Sie können das Forum weiterhin als Gast durchstöbern.';

$txt['mark_as_read'] = 'ALLE Beiträge als gelesen markieren';

$txt['locked_topic'] = 'Thema geschlossen';
$txt['normal_topic'] = 'Normales Thema';
$txt['participation_caption'] = 'Themen, auf die Sie geantwortet haben';
$txt['moved_topic'] = 'Verschobenes Thema';

$txt['go_caps'] = 'Los';

$txt['print'] = 'Drucken';
$txt['profile'] = 'Profil';
$txt['topic_summary'] = 'Zusammenfassung';
$txt['not_applicable'] = 'k.A.';
$txt['name_in_use'] = 'Dieser Name ist bereits in Verwendung.';

$txt['total_members'] = 'Mitglieder insgesamt';
$txt['total_posts'] = 'Gesamtzahl der Beiträge';
$txt['total_topics'] = 'Themen insgesamt';

$txt['time_logged_in'] = 'Wie lang möchten Sie eingeloggt bleiben?';

$txt['preview'] = 'Vorschau';
$txt['always_logged_in'] = 'Immer';

$txt['logged'] = 'Gespeichert';
$txt['show_ip'] = 'IP-Adresse anzeigen';
// Use numeric entities in the below string.
$txt['ip'] = 'IP-Adresse';
$txt['url'] = 'URL';
$txt['www'] = 'WWW';

$txt['hours'] = 'Stunden';
$txt['minutes'] = 'Minuten';
$txt['seconds'] = 'Sekunden';

// Used upper case in Paid subscriptions management
$txt['hour'] = 'Stunde';
$txt['days_word'] = 'Tagen';

$txt['search_for'] = 'Suche nach';
$txt['search_match'] = 'Übereinstimmung';

$txt['forum_in_maintenance'] = 'Ihr Forum ist im Wartungsmodus. Nur Administratoren können sich momentan einloggen.';
$txt['maintenance_page'] = 'Sie können den Wartungsmodus in den <a href="%1$s">Server-Einstellungen</a> abschalten.';

$txt['read_one_time'] = 'Einmal gelesen';
$txt['read_many_times'] = '%1$d-mal gelesen';

$txt['forum_stats'] = 'Forumstatistiken';
$txt['latest_member'] = 'Neuestes Mitglied';
$txt['total_cats'] = 'Kategorien insgesamt';
$txt['latest_post'] = 'Letzter Beitrag';

$txt['total_boards'] = 'Boards insgesamt';

$txt['print_page'] = 'Seite drucken';
$txt['print_page_text'] = 'Nur Text';
$txt['print_page_images'] = 'Text mit Bildern';

$txt['valid_email'] = 'Es muss eine gültige E-Mail-Adresse sein.';

$txt['geek'] = 'Ich bin ein Freak!';
$txt['info_center_title'] = '%1$s – Infozentrum';

$txt['watch'] = 'Beobachten';
$txt['unwatch'] = 'Nicht mehr beobachten';

$txt['check_all'] = 'Alle auswählen';

// Use numeric entities in the below string.
$txt['database_error'] = 'Datenbankfehler';
$txt['try_again'] = 'Bitte versuchen Sie es nochmal. Sollte der Fehler wieder auftreten, informieren Sie bitte den Administrator.';
$txt['file'] = 'Datei';
$txt['line'] = 'Zeile';
// Use numeric entities in the below string.
$txt['tried_to_repair'] = 'SMF hat einen Datenbankfehler entdeckt und versucht ihn automatisch zu reparieren. Wenn Sie erneut Probleme haben sollten oder weiterhin diese E-Mails erhalten, kontaktieren Sie bitte Ihren Serveranbieter.';
$txt['database_error_versions'] = '<strong>Hinweis:</strong> Ihre Datenbank <em>scheint</em> veraltet zu sein. Ihre Dateien haben die Version %1$s, wogegen die Datenbank die Version %2$s hat. Es wird empfohlen, die neueste Version der upgrade.php auszuführen.';
$txt['template_parse_error'] = 'Vorlagen-Analyse-Fehler!';
$txt['template_parse_error_message'] = 'Im Vorlagensystem des Forums ist ein Fehler aufgetreten. Dieses Problem sollte nur temporär auftreten, bitte versuchen Sie es daher später nochmal. Sollten Sie die Fehlermeldung weiterhin erhalten, kontaktieren Sie bitte den Administrator.<br><br>Sie können versuchen, die Seite zu <a href="javascript:location.reload();">aktualisieren</a>.';
// argument(s): filename, $boardurl, $scripturl
$txt['template_parse_error_details'] = 'Es gab ein Problem beim Laden der Vorlage oder der Sprachdatei „<pre><strong>%1$s</strong></pre>“. Bitte überprüfen Sie die Syntax und versuchen Sie es erneut – beachten Sie, dass es oft notwendig ist, einfache Anführungszeichen (<pre>\'</pre>) mit einem Backslash (<pre>\\</pre>) zu maskieren. Um genauere Fehlerinformationen von PHP zu sehen, <a href="%2$s%1$s">greifen Sie direkt auf die Datei zu</a>.<br><br>Sie können außerdem versuchen, <a href="javascript:location.reload();">diese Seite neu zu laden</a> oder <a href="%3$s?theme=1">das Standard-Theme zu nutzen</a>.';
$txt['template_parse_errmsg'] = 'Leider stehen momentan keine weiteren Informationen zur Verfügung, was genau das Problem ist.';

$txt['today'] = '<strong>Heute</strong> um ';
$txt['yesterday'] = '<strong>Gestern</strong> um ';
$txt['new_poll'] = 'Neue Umfrage';
$txt['poll_question'] = 'Frage';
$txt['poll_vote'] = 'Abstimmen';
$txt['poll_total_voters'] = 'Stimmen insgesamt';
$txt['poll_results'] = 'Ergebnisse anzeigen';
$txt['poll_lock'] = 'Umfrage schließen';
$txt['poll_unlock'] = 'Umfrage öffnen';
$txt['poll_edit'] = 'Umfrage bearbeiten';
$txt['poll'] = 'Umfrage';
$txt['one_hour'] = '1 Stunde';
$txt['one_day'] = '1 Tag';
$txt['one_week'] = '1 Woche';
$txt['two_weeks'] = '2 Wochen';
$txt['one_month'] = '1 Monat';
$txt['two_months'] = '2 Monate';
$txt['forever'] = 'Immer eingeloggt bleiben';
$txt['moved'] = 'VERSCHOBEN';
$txt['move_why'] = 'Bitte geben Sie eine kurze Beschreibung an,<br>warum dieses Thema verschoben wird.';
$txt['board'] = 'Board';
$txt['in'] = 'in';
$txt['sticky_topic'] = 'Angeheftetes Thema';

$txt['delete'] = 'Löschen';
$txt['no_change'] = 'Kein Wechsel';

$txt['your_pms'] = 'Ihre persönlichen Mitteilungen';

$txt['kilobyte'] = 'KB';
$txt['megabyte'] = 'MB';

$txt['more_stats'] = '[Weitere Statistiken]';

// Use numeric entities in the below three strings.
$txt['code'] = 'Code';
$txt['code_select'] = 'Auswählen';
$txt['code_expand'] = 'Erweitern';
$txt['code_shrink'] = 'Verringern';
$txt['quote_from'] = 'Zitat von';
$txt['quote'] = 'Zitat';
$txt['quote_action'] = 'Zitieren';
$txt['quote_selected_action'] = 'Ausgewählten Text zitieren';
$txt['fulledit'] = 'Vollständig&nbsp;bearbeiten';
$txt['edit'] = 'Bearbeiten';
$txt['quick_edit'] = 'Schnell bearbeiten';
$txt['post_options'] = 'Mehr…';

$txt['merge_to_topic_id'] = 'ID des Ziel-Themas';
$txt['split'] = 'Thema teilen';
$txt['merge'] = 'Themen zusammenführen';
$txt['target_id'] = 'Wählen Sie das Ziel anhand der Themen-ID aus';
$txt['target_below'] = 'Wählen Sie das Ziel aus der Liste unterhalb aus';
$txt['subject_new_topic'] = 'Betreff für das neue Thema';
$txt['split_this_post'] = 'Nur diesen Beitrag trennen.';
$txt['split_after_and_this_post'] = 'Thema ab und inkl. diesem Beitrag aufteilen.';
$txt['select_split_posts'] = 'Beiträge auswählen, die geteilt werden sollen.';
$txt['new_topic'] = 'Neues Thema';
$txt['split_successful'] = 'Thema erfolgreich in zwei Themen aufgeteilt.';
$txt['origin_topic'] = 'Ursprüngliches Thema';
$txt['please_select_split'] = 'Bitte wählen Sie die Beiträge aus, die Sie trennen möchten.';
$txt['merge_successful'] = 'Themen erfolgreich zusammengeführt.';
$txt['new_merged_topic'] = 'Neu zusammengeführtes Thema';
$txt['topic_to_merge'] = 'Thema, das zusammengeführt werden soll';
$txt['target_board'] = 'Zielboard';
$txt['target_topic'] = 'Zielthema';
$txt['merge_desc'] = 'Diese Funktion wird die Beiträge von zwei Themen zu einem Thema zusammenführen. Die Beiträge werden zeitlich sortiert sein, d.h. der älteste Beitrag wird der erste im zusammengeführten Thema sein.';

$txt['set_sticky'] = 'Thema anheften';
$txt['set_nonsticky'] = 'Anheftung des Themas entfernen';
$txt['set_lock'] = 'Thema schließen';
$txt['set_unlock'] = 'Thema öffnen';

$txt['search_advanced'] = 'Erweiterte Suche';

$txt['security_risk'] = 'GROSSES SICHERHEITSRISIKO:';
$txt['not_removed'] = 'Sie haben folgende Datei(en) nicht gelöscht: ';
$txt['not_removed_extra'] = '%1$s ist ein Backup von %2$s, das nicht von SMF erzeugt wurde. Es ist direkt zugreifbar und kann verwendet werden, um nicht autorisierten Zugang zum Forum zu bekommen. Sie sollten es sofort entfernen.';
$txt['generic_warning'] = 'Warnung';
$txt['agreement_missing'] = 'Sie verlangen von neuen Benutzern, die Registrierungsvereinbarung zu akzeptieren, aber die dazugehörige Datei (agreement.txt) existiert nicht.';
$txt['policy_agreement_missing'] = 'Sie verlangen von neuen Benutzern, die Datenschutzrichtlinien zu akzeptieren, aber diese sind leer.';
$txt['auth_secret_missing'] = 'Das Authentifizierungs-Geheimnis konnte nicht in Settings.php gespeichert werden. Dies schwächt die Sicherheit Ihres Forums und setzt Ihr System einem Angriffsrisiko aus. Überprüfen Sie die Dateiberechtigungen von Settings.php um sicherzustellen, dass SMF in diese Datei schreiben kann.';

$txt['cache_writable'] = 'Das Cache-Verzeichnis ist nicht beschreibbar – das hat große Auswirkungen auf die Geschwindigkeit ihres Forums.';

$txt['page_created_full'] = 'Seite erstellt in %1$.3f Sekunden mit %2$d Abfragen.';

$txt['report_to_mod_func'] = 'Benutzen Sie diese Funktion, um Moderatoren und Administratoren über einen missbräuchlichen oder problematischen Beitrag zu informieren.';
$txt['report_profile_func'] = 'Benutzen Sie diese Funktion, um Administratoren über missbräuchliche Benutzerprofil-Inhalte wie Spam oder unangemessene Bilder zu informieren.';

$txt['online'] = 'Online';
$txt['member_is_online'] = '%1$s ist online';
$txt['offline'] = 'Offline';
$txt['member_is_offline'] = '%1$s ist offline';
$txt['pm_online'] = 'Persönliche Mitteilung (online)';
$txt['pm_offline'] = 'Persönliche Mitteilung (offline)';
$txt['status'] = 'Status';

$txt['go_up'] = 'Nach oben';
$txt['go_down'] = 'Nach unten';

// argument(s): SMF_FULL_VERSION, SMF_SOFTWARE_YEAR, $scripturl
$forum_copyright = '<a href="%3$s?action=credits" title="Lizenz" target="_blank" rel="noopener">%1$s &copy; %2$s</a>, <a href="https://www.simplemachines.org" title="Simple Machines" target="_blank" rel="noopener">Simple Machines</a>';

$txt['birthdays'] = 'Geburtstage:';
$txt['events'] = 'Ereignisse:';
$txt['birthdays_upcoming'] = 'Bevorstehende Geburtstage:';
$txt['events_upcoming'] = 'Bevorstehende Ereignisse:';
// Prompt for holidays in the calendar, leave blank to just display the holiday's name.
$txt['calendar_prompt'] = 'Feiertage:';
$txt['calendar_month'] = 'Monat';
$txt['calendar_year'] = 'Jahr';
$txt['calendar_day'] = 'Tag';
$txt['calendar_event_title'] = 'Ereignis-Titel';
$txt['calendar_event_options'] = 'Ereignis-Optionen';
$txt['calendar_post_in'] = 'Erstellen in';
$txt['calendar_edit'] = 'Ereignis bearbeiten';
$txt['calendar_export'] = 'Ereignis exportieren';
$txt['calendar_view_week'] = 'Woche ansehen';
$txt['event_delete_confirm'] = 'Dieses Ereignis löschen?';
$txt['event_delete'] = 'Ereignis löschen';
$txt['calendar_post_event'] = 'Ereignis erstellen';
$txt['calendar'] = 'Kalender';
$txt['calendar_link'] = 'Link zum Kalender';
$txt['calendar_upcoming'] = 'Bevorstehende Kalender-Ereignisse';
$txt['calendar_today'] = 'Heutige Kalender-Ereignisse';
$txt['calendar_week'] = 'Woche';
$txt['calendar_week_title'] = 'Woche %1$d von %2$d';
// %1$s is the month, %2$s is the day, %3$s is the year. Change to suit your language.
$txt['calendar_week_beginning'] = 'Woche beginnend am %2$s.%1$s.%3$s';
$txt['calendar_numb_days'] = 'Anzahl der Tage';
$txt['calendar_how_edit'] = 'Wie ändert man diese Ereignisse?';
$txt['calendar_link_event'] = 'Ereignis mit einem Beitrag verknüpfen';
$txt['calendar_confirm_delete'] = 'Sind Sie sicher, dass Sie dieses Ereignis löschen möchten?';
$txt['calendar_linked_events'] = 'Verlinkte Ereignisse';
$txt['calendar_click_all'] = 'Alle %1$s anzeigen';
$txt['calendar_allday'] = 'Ganztägig';
$txt['calendar_timezone'] = 'Zeitzone';
$txt['calendar_list'] = 'Liste';
$txt['calendar_empty'] = 'Keine Ereignisse vorhanden.';

$txt['movetopic_change_subject'] = 'Überschrift des Themas ändern';
$txt['movetopic_new_subject'] = 'Neuer Betreff';
$txt['movetopic_change_all_subjects'] = 'Überschrift jeder Nachricht ändern';
$txt['move_topic_unapproved_js'] = 'Achtung! Dieses Thema wurde noch nicht genehmigt.\n\nEs ist nicht empfehlenswert, ein Weiterleitungs-Thema zu erstellen, es sei denn, Sie wollen den Beitrag direkt nach dem Verschieben genehmigen.';
$txt['movetopic_auto_board'] = '[BOARD]';
$txt['movetopic_auto_topic'] = '[THEMEN-LINK]';

// argument(s): $txt['movetopic_auto_board'], $txt['movetopic_auto_topic']
$txt['movetopic_default'] = 'Dieses Thema wurde verschoben nach %1$s.

%2$s';

$txt['movetopic_redirect'] = 'In das verschobene Thema umleiten';

$txt['post_redirection'] = 'Ein Weiterleitungs-Thema veröffentlichen';
$txt['redirect_topic_expires'] = 'Das Weiterleitungs-Thema automatisch entfernen';
$txt['mergetopic_redirect'] = 'In das zusammengefasste Thema weiterleiten';
$txt['merge_topic_unapproved_js'] = 'Achtung! Dieses Thema wurde noch nicht genehmigt.\n\nEs ist nicht empfehlenswert, ein Weiterleitungs-Thema zu erstellen, es sei denn, Sie wollen den Beitrag direkt nach dem Zusammenfassen genehmigen.';

$txt['theme_template_error'] = 'Kann die „%1$s“-Vorlage nicht laden.';
$txt['theme_language_error'] = 'Kann die "%1$s"-Sprachdatei nicht laden.';

$txt['sub_boards'] = 'Unter-Boards';
$txt['restricted_board'] = 'Eingeschränktes Board';

$txt['smtp_no_connect'] = 'Konnte nicht mit SMTP-Server verbinden';
$txt['smtp_port_ssl'] = 'SMTP-Port-Einstellung ist nicht korrekt; für SSL-Server sollte 465 korrekt sein. Gegebenenfalls benötigt der Hostname ein "ssl://"-Präfix';
$txt['smtp_bad_response'] = 'Konnte Antwortcodes des E-Mail-Servers nicht empfangen';
$txt['smtp_error'] = 'Probleme beim Versenden der E-Mail. Fehler: ';
$txt['mail_send_unable'] = 'Die E-Mail konnte nicht an "%1$s" versendet werden.';

$txt['mlist_search'] = 'Mitglieder suchen';
$txt['mlist_search_again'] = 'Erneut suchen';
$txt['mlist_search_filter'] = 'Suchoptionen';
$txt['mlist_search_email'] = 'Nach E-Mail-Adresse suchen';
$txt['mlist_search_messenger'] = 'Nach Messenger-Spitzname suchen';
$txt['mlist_search_group'] = 'Nach Position suchen';
$txt['mlist_search_name'] = 'Nach Namen suchen';
$txt['mlist_search_website'] = 'Nach Webseite suchen';
$txt['mlist_search_results'] = 'Suchergebnisse für';
$txt['mlist_search_by'] = 'Suchen nach %1$s';
$txt['mlist_menu_view'] = 'Mitgliederliste ansehen';

$txt['attach_downloaded'] = '%1$d-mal runtergeladen';
$txt['attach_viewed'] = '%1$d-mal angeschaut';

$txt['settings'] = 'Einstellungen';
$txt['never'] = 'Nie';
$txt['more'] = 'mehr';
$txt['etc'] = 'etc.';

$txt['hostname'] = 'Hostname';
$txt['you_are_post_banned'] = '%1$s, Ihnen ist das Schreiben von Beiträgen und das Versenden von persönlichen Mitteilungen in diesem Forum untersagt.';
$txt['ban_reason'] = 'Grund';
$txt['select_item_check'] = 'Bitte wählen Sie mindestens einen Eintrag in der Liste';

$txt['tables_optimized'] = 'Tabellen der Datenbank optimiert';

$txt['add_poll'] = 'Umfrage hinzufügen';
$txt['poll_options_limit'] = 'Sie können nur bis zu %1$s Optionen auswählen.';
$txt['poll_remove'] = 'Umfrage entfernen';
$txt['poll_remove_warn'] = 'Sind Sie sicher, dass Sie die Umfrage vom Thema entfernen möchten?';
$txt['poll_results_expire'] = 'Die Resultate werden angezeigt, wenn die Umfrage geschlossen wird';
$txt['poll_expires_on'] = 'Umfrage schließt';
$txt['poll_expired_on'] = 'Umfrage geschlossen';
$txt['poll_change_vote'] = 'Stimme(n) entfernen';
$txt['poll_return_vote'] = 'Abstimmungsoptionen';
$txt['poll_cannot_see'] = 'Sie können das Ergebnis der Umfrage momentan nicht einsehen.';

$txt['quick_mod_approve'] = 'Ausgewählte genehmigen';
$txt['quick_mod_remove'] = 'Ausgewählte entfernen';
$txt['quick_mod_lock'] = 'Ausgewählte schließen/öffnen';
$txt['quick_mod_sticky'] = 'Ausgewählte anheften/loslösen';
$txt['quick_mod_move'] = 'Ausgewählte verschieben';
$txt['quick_mod_merge'] = 'Ausgewählte zusammenführen';
$txt['quick_mod_markread'] = 'Ausgewählte als gelesen markieren';
$txt['quick_mod_markunread'] = 'Ausgewählte als ungelesen markieren';
$txt['quick_mod_selected'] = 'Mit den ausgewählten Optionen folgendes tun';
$txt['quick_mod_go'] = 'Los';
$txt['quickmod_confirm'] = 'Sind Sie sicher, dass Sie das tun möchten?';

$txt['spell_check'] = 'Rechtschreibprüfung';

$txt['quick_reply'] = 'Schnellantwort';
$txt['quick_reply_warning'] = 'Warnung: Dieses Thema ist momentan geschlossen! Nur Administratoren und Moderatoren können antworten.';
$txt['quick_reply_verification'] = 'Nach dem Senden Ihres Beitrags werden Sie zur normalen Beitragsseite weitergeleitet, um ihren Beitrag zu überprüfen %1$s.';
$txt['quick_reply_verification_guests'] = '(für alle Gäste benötigt)';
$txt['quick_reply_verification_posts'] = '(notwendig für alle Benutzer mit weniger als %1$d Beiträgen)';
$txt['wait_for_approval'] = 'Achtung: Dieser Beitrag wird erst angezeigt, wenn er von einem Moderator genehmigt wurde.';

$txt['notification_enable_board'] = 'Sind Sie sicher, dass Sie Benachrichtigungen über neue Themen in diesem Board aktivieren möchten?';
$txt['notification_disable_board'] = 'Sind Sie sicher, dass Sie Benachrichtigungen über neue Themen in diesem Board deaktivieren möchten?';
$txt['notification_enable_topic'] = 'Sind Sie sicher, dass Sie Benachrichtigungen über neue Beiträge in diesem Thema aktivieren möchten?';
$txt['notification_disable_topic'] = 'Sind Sie sicher, dass Sie Benachrichtigungen über neue Beiträge in diesem Thema deaktivieren möchten?';

// Mentions
$txt['mentions'] = 'Erwähnungen (Mentions)';

// Likes
$txt['likes'] = 'Gefällt mir (Likes)';
$txt['like'] = 'Gefällt mir';
$txt['unlike'] = 'Gefällt mir nicht';
$txt['like_success'] = 'Ihr Inhalt wurde erfolgreich gelikt.';
$txt['like_delete'] = 'Ihr Inhalt wurde erfolgreich gelöscht.';
$txt['like_insert'] = 'Ihr Inhalt wurde erfolgreich eingefügt.';
$txt['like_error'] = 'Es gab ein Problem mit Ihrer Anfrage.';
$txt['like_disable'] = 'Das „Gefällt mir“-Feature ist deaktiviert.';
$txt['not_valid_like_type'] = 'Der "Gefällt mir"-Typ ist ungültig.';
// Translators, if you need to make more strings to suit your language, e.g. $txt['likes_2'] = 'Two people like this', please do so.
$txt['likes_1'] = '<a href="%1$s">Einer Person</a> gefällt das.';
$txt['likes_n'] = '<a href="%1$s">%2$s Personen</a> gefällt das.';
$txt['you_likes_0'] = 'Ihnen gefällt das.';
$txt['you_likes_1'] = 'Sie und <a href="%1$s">einer anderen Person</a> gefällt das.';
$txt['you_likes_n'] = 'Ihnen und <a href="%1$s">%2$s anderen Personen</a> gefällt das.';

$txt['report_to_mod'] = 'Moderator informieren';
$txt['report_profile'] = 'Profil von %1$s melden';

$txt['unread_topics_visit'] = 'Neue ungelesene Themen';
// argument(s): scripturl
$txt['unread_topics_visit_none'] = 'Keine ungelesenen Themen seit Ihrem letzten Besuch. <a href="%1$s?action=unread;all">Klicken Sie hier, um alle ungelesenen Themen anzuzeigen</a>.';
$txt['updated_topics_visit_none'] = 'Keine aktualisierten Themen seit Ihrem letzten Besuch gefunden.';
$txt['unread_topics_all'] = 'Alle ungelesenen Themen';
$txt['unread_replies'] = 'Aktualisierte Themen';

$txt['who_title'] = 'Wer ist online';
$txt['who_and'] = ' und ';
$txt['who_viewing_topic'] = ' betrachten dieses Thema.';
$txt['who_viewing_board'] = ' betrachten dieses Board.';
$txt['who_member'] = 'Mitglied';

// No longer used by default theme, but for backwards compat
$txt['powered_by_php'] = 'Ermöglicht durch PHP';
$txt['powered_by_mysql'] = 'Ermöglicht durch MySQL';
$txt['valid_css'] = 'Gültiges CSS';

$txt['rss'] = 'RSS';
$txt['atom'] = 'Atom';
$txt['html'] = 'HTML';

$txt['guest'] = 'Gast';
$txt['guests'] = 'Gäste';
$txt['user'] = 'Mitglied';
$txt['users'] = 'Mitglieder';
$txt['hidden'] = 'Versteckt';

// Plural form of hidden for languages other than English
$txt['hidden_s'] = 'Versteckt';
$txt['buddy'] = 'Freund';
$txt['buddies'] = 'Freunde';
$txt['most_online_ever'] = 'Am meisten online (gesamt)';
$txt['most_online_today'] = 'Am meisten online (heute)';

$txt['merge_select_target_board'] = 'Wählen Sie das Ziel-Board des zusammengeführten Themas';
$txt['merge_select_poll'] = 'Wählen Sie, welche Umfrage das zusammengeführte Thema haben soll';
$txt['merge_topic_list'] = 'Wählen Sie die Themen, die zusammengeführt werden sollen';
$txt['merge_select_subject'] = 'Wählen Sie den Titel des zusammengeführten Themas';
$txt['merge_custom_subject'] = 'Neuer Titel';
$txt['merge_include_notifications'] = 'Inklusive Benachrichtigungen?';
$txt['merge_check'] = 'Zusammenführen?';
$txt['merge_no_poll'] = 'Keine Umfrage';
$txt['merge_why'] = 'Bitte geben Sie eine kurze Beschreibung an, warum diese Themen zusammengefasst werden.';
$txt['merged_subject'] = '[Zusammengefasst] %1$s';
// argument(s): $txt['movetopic_auto_topic']
$txt['mergetopic_default'] = 'Dieses Thema wurde zusammengefasst zu %2$s.';

$txt['response_prefix'] = 'Aw: ';
$txt['current_icon'] = 'Aktuelles Symbol';
$txt['message_icon'] = 'Beitragssymbol';

$txt['smileys_current'] = 'Aktuelle Smileysammlung';
$txt['smileys_none'] = 'Keine Smileys';
$txt['smileys_forum_board_default'] = 'Forum/Board-Standard';

$txt['search_results'] = 'Suchergebnisse';
$txt['search_no_results'] = 'Keine Übereinstimmungen gefunden';

$txt['total_time_logged_days'] = ' Tage, ';
$txt['total_time_logged_hours'] = ' Stunden und ';
$txt['total_time_logged_minutes'] = ' Minuten';
$txt['total_time_logged_d'] = 'T ';
$txt['total_time_logged_h'] = 'S ';
$txt['total_time_logged_m'] = 'M';

$txt['approve_members_waiting'] = 'Mitgliedergenehmigungen';

$txt['activate_code'] = 'Ihr Aktivierungscode ist';

$txt['find_members'] = 'Suche Mitglieder';
$txt['find_username'] = 'Name, Benutzername oder E-Mail-Adresse';
$txt['find_buddies'] = 'Nur Freunde anzeigen?';
$txt['find_wildcards'] = 'Wildcards erlauben: *,?';
$txt['find_no_results'] = 'Kein Ergebnis gefunden';
$txt['find_results'] = 'Ergebnisse';
$txt['find_close'] = 'Schließen';

$txt['unread_since_visit'] = 'Ungelesene Beiträge seit Ihrem letzten Besuch anzeigen.';
$txt['show_unread_replies'] = 'Neue Antworten zu Ihren Beiträgen anzeigen.';

$txt['change_color'] = 'Farbe ändern';

$txt['quickmod_delete_selected'] = 'Ausgewählte entfernen';
$txt['quickmod_split_selected'] = 'Ausgewählte aufteilen';

$txt['show_personal_messages_heading'] = 'Neue Nachrichten';
$txt['show_personal_messages'] = 'Sie haben <strong>%1$s</strong> ungelesene persönliche Mitteilungen in Ihrem Posteingang.<br><br><a href="%2$s">Zum Posteingang</a>';

$txt['help_popup'] = 'Alles zu kompliziert? Lassen Sie es mich erklären:';

$txt['previous_next_back'] = 'Vorheriges Thema';
$txt['previous_next_forward'] = 'Nächstes Thema';

$txt['mark_unread'] = 'Als ungelesen markieren';

$txt['ssi_not_direct'] = 'Bitte greifen Sie nicht direkt mit der URL auf SSI.php zu. Benutzen Sie stattdessen den Pfad (%1$s) oder fügen Sie "?ssi_function=irgendwas" zur URL hinzu.';
$txt['ssi_session_broken'] = 'SSI.php konnte die Sitzung nicht laden! Das kann zu Problemen mit dem Ausloggen und anderen Funktionen führen – bitte überprüfen Sie, ob SSI.php in Ihren Skripts vor jeglichem(!) anderen Code aufgerufen wird!';

// Escape any single quotes in here twice.. 'it\'s' -> 'it\\\'s'.
$txt['preview_title'] = 'Vorschau des Beitrags';
$txt['preview_fetch'] = 'Lade Vorschau…';
$txt['preview_new'] = 'Neue Nachricht';
$txt['pm_error_while_submitting'] = 'Folgende Fehler sind beim Senden dieser persönlichen Mitteilung aufgetreten:';
$txt['error_while_submitting'] = 'Der Beitrag verursachte die folgenden Fehler, die behoben werden müssen:';
$txt['error_old_topic'] = 'Achtung: In diesem Thema wurde seit %1$d Tagen nichts mehr geschrieben.<br>Wenn Sie nicht absolut sicher sind, dass Sie hier antworten möchten, starten Sie ein neues Thema.';

$txt['split_selected_posts'] = 'Ausgewählte Beiträge';
$txt['split_selected_posts_desc'] = 'Die unten stehenden Beiträge werden nach der Aufteilung zusammen ein neues Thema bilden.';
$txt['split_reset_selection'] = 'Auswahl löschen';

$txt['modify_cancel'] = 'Abbrechen';
$txt['modify_cancel_all'] = 'Alle abbrechen';
$txt['mark_read_short'] = 'Als gelesen markieren';

$txt['alerts'] = 'Alarme';

$txt['pm_short'] = 'Meine Mitteilungen';
$txt['pm_menu_read'] = 'Meine Mitteilungen lesen';
$txt['pm_menu_send'] = 'Eine Mitteilung senden';

$txt['unapproved_posts'] = 'Nicht genehmigte Beiträge (Themen: %1$s, Beiträge: %2$d)';

$txt['ajax_in_progress'] = 'Lade…';

$txt['mod_reports_waiting'] = 'Gemeldete Beiträge';

$txt['view_unread_category'] = 'Ungelesene Beiträge';
$txt['new_posts_in_category'] = 'Klicken Sie hier, um die neuen Beiträge in „%1$s“ zu sehen';
$txt['verification'] = 'Verifizierung';
$txt['visual_verification_hidden'] = 'Bitte lassen Sie dieses Feld leer';
$txt['visual_verification_description'] = 'Geben Sie die Buchstaben aus dem Bild ein';
$txt['visual_verification_sound'] = 'Buchstaben anhören';
$txt['visual_verification_request_new'] = 'Neues Bild laden';

// Sub menu labels
$txt['summary'] = 'Zusammenfassung';
$txt['account'] = 'Kontoeinstellungen';
$txt['theme'] = 'Aussehen und Layout';
$txt['forumprofile'] = 'Forenprofil';
$txt['activate_changed_email_title'] = 'E-Mail-Adresse geändert';
$txt['activate_changed_email_desc'] = 'Sie haben Ihre E-Mail-Adresse geändert. Um sie zu verifizieren, erhalten Sie eine E-Mail. Klicken Sie den Link in der E-Mail an, um Ihr Benutzerkonto zu reaktivieren.';
$txt['modSettings_title'] = 'Features und Optionen';
$txt['package'] = 'Paketverwaltung';
$txt['errorlog'] = 'Fehlerprotokoll';
$txt['edit_permissions'] = 'Berechtigungen';
$txt['mc_unapproved_attachments'] = 'Nicht genehmigte Anhänge';
$txt['mc_unapproved_poststopics'] = 'Nicht genehmigte Themen und Beiträge';
$txt['mc_reported_posts'] = 'Gemeldete Beiträge';
$txt['mc_reported_members'] = 'Gemeldete Mitgliedsprofile';
$txt['modlog_view'] = 'Moderationsprotokoll';
$txt['calendar_menu'] = 'Kalender anzeigen';

// @todo Send email strings - should move?
$txt['send_email'] = 'E-Mail senden';

$txt['ignoring_user'] = 'Sie ignorieren diesen Benutzer.';
$txt['show_ignore_user_post'] = 'Beitrag anzeigen.';

$txt['spider'] = 'Bot';
$txt['spiders'] = 'Bots';

$txt['downloads'] = 'Downloads';
$txt['filesize'] = 'Dateigröße';

// Restore topic
$txt['restore_topic'] = 'Thema wiederherstellen';
$txt['restore_message'] = 'Wiederherstellen';
$txt['quick_mod_restore'] = 'Ausgewählte wiederherstellen';

// Editor prompt.
$txt['prompt_text_email'] = 'Bitte geben sie die E-Mail-Adresse ein.';
$txt['prompt_text_ftp'] = 'Bitte geben sie die FTP-Adresse ein.';
$txt['prompt_text_url'] = 'Bitte geben sie die zu verlinkende URL ein.';
$txt['prompt_text_img'] = 'Geben Sie den Bildort ein';

// Escape any single quotes in here twice.. 'it\'s' -> 'it\\\'s'.
$txt['autosuggest_delete_item'] = 'Objekt löschen';

// Debug related - when $db_show_debug is true.
$txt['debug_templates'] = 'Vorlagen: ';
$txt['debug_subtemplates'] = 'Untervorlagen: ';
$txt['debug_language_files'] = 'Sprachdateien: ';
$txt['debug_stylesheets'] = 'Stylesheets: ';
$txt['debug_files_included'] = 'inkludierte Dateien:';
$txt['debug_memory_use'] = 'Speicherverbrauch: ';
$txt['debug_kb'] = 'KB.';
$txt['debug_show'] = 'zeigen';
$txt['debug_cache_hits'] = 'Cache-Hits:';
$txt['debug_cache_misses'] = 'Cache-Misses: ';
$txt['debug_cache_seconds_bytes'] = '%1$ss – %2$s bytes';
$txt['debug_cache_seconds_bytes_total'] = '%1$ss für %2$s Bytes';
$txt['debug_queries_used'] = 'Abfragen verwendet: %1$d';
$txt['debug_queries_used_and_warnings'] = 'Abfragen verwendet: %1$d, %2$d Warnungen.';
$txt['debug_query_in_line'] = 'in <em>%1$s</em> Zeile <em>%2$s</em>,';
$txt['debug_query_which_took'] = 'das %1$s Sekunden dauerte.';
$txt['debug_query_which_took_at'] = 'das %1$s Sekunden dauerte, nach %2$s in der Anfrage.';
$txt['debug_show_queries'] = '[Zeige Abfragen]';
$txt['debug_hide_queries'] = '[Verstecke Abfragen]';
$txt['debug_tokens'] = 'Token: ';
$txt['debug_browser'] = 'Browser-ID: ';
$txt['debug_hooks'] = 'Aufgerufene Hooks: ';
$txt['debug_instances'] = 'Instanzen erstellt: ';
$txt['are_sure_mark_read'] = 'Sind Sie sicher, dass Sie diese Nachrichten als gelesen markieren möchten?';

// Inline attachments messages.
$txt['attachments_not_enable'] = 'Dateianhänge sind deaktiviert';
$txt['attachments_no_data_loaded'] = 'Ungültige Dateianhangs-ID.';
$txt['attachments_not_allowed_to_see'] = 'Sie dürfen diesen Dateianhang nicht ansehen.';
$txt['attachments_no_msg_associated'] = 'Mit diesem Dateianhang ist keine Nachricht verknüpft.';
$txt['attachments_unapproved'] = 'Anhang wartet auf Genehmigung.';

// Accessibility
$txt['hide_category'] = 'Kategorie ausblenden';
$txt['show_category'] = 'Kategorie zeigen';
$txt['hide_infocenter'] = 'Infozentrum verstecken';
$txt['show_infocenter'] = 'Infozentrum anzeigen';

// Notification post control
$txt['notify_topic_0'] = 'Keine Benachrichtigungen';
$txt['notify_topic_1'] = 'Keine Alarme oder E-Mails';
$txt['notify_topic_2'] = 'Alarme empfangen';
$txt['notify_topic_3'] = 'E-Mails und Alarme empfangen';
$txt['notify_topic_0_desc'] = 'Sie werden keinerlei E-Mails oder Alarme für dieses Thema erhalten und es wird nicht in Ihren ungelesenen Antworten und Themen zu sehen sein. Sie werden aber @-Erwähnungen (Mentions) für dieses Thema erhalten.';
$txt['notify_topic_1_desc'] = 'Sie werden keinerlei E-Mails oder Alarme, sondern nur @-Erwähnungen (Mentions) von anderen Mitgliedern erhalten.';
$txt['notify_topic_2_desc'] = 'Sie werden Alarme für dieses Thema erhalten.';
$txt['notify_topic_3_desc'] = 'Sie werden sowohl Alarme als auch E-Mails für dieses Thema erhalten.';
$txt['notify_board_1'] = 'Keine Alarme oder E-Mails';
$txt['notify_board_2'] = 'Alarme empfangen';
$txt['notify_board_3'] = 'E-Mails und Alarme empfangen';
$txt['notify_board_1_desc'] = 'Sie werden keinerlei E-Mails oder Alarme für neue Themen erhalten';
$txt['notify_board_2_desc'] = 'Sie werden Alarme für dieses Board erhalten.';
$txt['notify_board_3_desc'] = 'Sie werden sowohl Alarme als auch E-Mails für dieses Board erhalten.';

$txt['notify_board_prompt'] = 'Möchten Sie eine Benachrichtigungs-E-Mail, wenn jemand ein neues Thema in diesem Board schreibt?';
$txt['notify_board_subscribed'] = '%1$s hat sich für Benachrichtigungen über neue Themen für dieses Board angemeldet.';
$txt['notify_board_unsubscribed'] = '%1$s hat sich von Benachrichtigungen über neue Themen für dieses Board abgemeldet.';

$txt['notify_topic_prompt'] = 'Möchten Sie eine Benachrichtigung per E-Mail, wenn eine Antwort zu diesem Thema geschrieben wird?';
$txt['notify_topic_subscribed'] = '%1$s hat sich für Benachrichtigungen über neue Antworten für dieses Thema angemeldet.';
$txt['notify_topic_unsubscribed'] = '%1$s hat sich von Benachrichtigungen über neue Antworten für dieses Thema abgemeldet.';

$txt['notify_announcements_prompt'] = 'Forums-Newsletter, -Ankündigungen und wichtige Benachrichtigungen per E-Mail empfangen?';
$txt['notify_announcements_subscribed'] = '%1$s wurde für Forums-Newsletter, Ankündigungen und wichtige Benachrichtigungen angemeldet.';
$txt['notify_announcements_unsubscribed'] = '%1$s wurde von Forums-Newslettern, Ankündigungen und wichtigen Benachrichtigungen abgemeldet.';

$txt['unsubscribe_announcements_plain'] = 'Um Forums-Newsletter, Ankündigungen und wichtige Benachrichtigungen abzubestellen, folgen Sie diesem Link: %1$s';
$txt['unsubscribe_announcements_html'] = '<span style="font-size:small">Forums-Newsletter, Ankündigungen und wichtige Benachrichtigungen <a href="%1$s">abbestellen</a>.</span>';
$txt['unsubscribe_announcements_manual'] = 'Um Forums-Newsletter, Ankündigungen und wichtige Benachrichtigungen abzubestellen, kontaktieren Sie uns unter %1$s mit Ihrer Anfrage.';

// Mobile Actions
$txt['mobile_action'] = 'Benutzer-Aktionen';
$txt['mobile_moderation'] = 'Moderation';
$txt['mobile_user_menu'] = 'Hauptmenü';
$txt['mobile_generic_menu'] = '%1$s-Menü';

// Formats for lists in a sentence (e.g. "Alice, Bob, and Charlie")
// Examples:
// 	$txt['sentence_list_format'][2] specifies a format for a list with two items
// 	$txt['sentence_list_format']['n'] specifies the default format
// Notes on placeholders:
// 	{1} = first item in the list, {2} = second item, etc.
// 	{-1} = last item in the list, {-2} = second last item, etc.
// 	{series} = concatenated string of the rest of the items in the list
$txt['sentence_list_format'][1] = '{1}';
$txt['sentence_list_format'][2] = '{1} und {-1}';
$txt['sentence_list_format'][3] = '{series} und {-1}';
$txt['sentence_list_format'][4] = '{series} und {-1}';
$txt['sentence_list_format'][5] = '{series} und {-1}';
$txt['sentence_list_format']['n'] = '{series} und {-1}';
// Separators used to build lists in a sentence
$txt['sentence_list_separator'] = ', ';
$txt['sentence_list_separator_alt'] = '; ';

?>