<?php
// Version: 2.1.5; Help

global $helptxt, $scripturl;

$txt['close_window'] = 'Закрыть окно';

$helptxt['manage_boards'] = '
	<strong>Редактирование разделов</strong><br>
	В этом меню можно создавать/перемещать/удалять категории и разделы, содержащиеся в них.
	К примеру, если у вас большой сайт, предоставляющий информацию о «Спорте», «Машинах» и «Музыке»,
	то почти наверняка <em>Категориями</em> верхнего уровня будут категории именно с подобными названиями.
	В каждой из этих категорий можно создать «подкатегории» или «разделы». Это простая иерархия, со следующей структурой:<br>
	<ul class="normallist">
		<li>
			<strong>Спорт</strong>
			&nbsp;- «Категория»
			<ul class="normallist">
				<li>
					<strong>Бейсбол</strong>
					&nbsp;- Раздел внутри категории «Спорт»
					<ul class="normallist">
						<li>
							<strong>Статистика</strong>
							&nbsp;- Подраздел раздела «Бейсбол»
						</li>
					</ul>
				</li>
				<li><strong>Футбол</strong>
				&nbsp;- Раздел внутри категории «Спорт»</li>
			</ul>
		</li>
	</ul>
	Категории позволяют разделить форум на основные темы («Автомобили», «Спорт») и «Разделы»,
	в каждом из которых пользователи могут оставлять сообщения на соответствующую тематику.
	Иерархическая структура позволяет людям быстрее найти то, что их интересует.
	Это намного упростит пользователям поиск нужной информации — они смогут сразу перейти в нужный раздел и искать там.<br>
	Как отмечалось выше, Раздел является ключевой темой, содержащей в себе другие по одной и той же тематике. Например, для
	обсуждения «Пинто» нужно всего лишь зайти в категорию «Автомобили» и перейти в раздел «Пинто».<br>
	Функции, доступные на этой странице, позволяют создавать новые разделы внутри каждой категории, изменять их, менять порядок, а также полностью удалять.';

$helptxt['edit_news'] = '
	<ul class="normallist">
		<li>
			<strong>Новости</strong><br>
			В этой секции можно настроить текст новостей, отображаемых на главной странице форума.
			Добавьте желаемый пункт (например, «Не пропустите собрание во вторник!») и сохраните изменения. Новости будут отображаться в случайном порядке, по одной за раз.
		</li>
		<li>
			<strong>Рассылки</strong><br>
			В этой секции можно отправлять специальные сообщения пользователям форума, через личные сообщения или по электронной почте. Для начала отметьте группы, которым хотите разослать сообщения. Кроме того, можно указать дополнительных адресатов. Затем введите текст сообщения и выберите тип рассылки: с помощью ЛС или же посредством электронной почты.
		</li>
		<li>
			<strong>Настройки</strong><br>
			В этой секции содержится несколько настроек, относящихся к новостям и рассылкам, включая выбор групп, которые могут редактировать новости форума или отправлять информационные сообщения по почте. Доступны также параметр для включения/отключения новостной ленты форума и параметр для управления длиной сообщений в RSS-ленте.
		</li>
	</ul>';

$helptxt['view_members'] = '
	<ul class="normallist">
		<li>
			<strong>Просмотр всех пользователей</strong><br>
			Просмотр всех пользователей форума. Вам доступен список имен пользователей со ссылками. Можно нажать
			на любое из имен, чтобы просмотреть профили пользователей (домашняя страница, возраст,&nbsp;и&nbsp;т.&nbsp;д.), а также изменить их.
			Вы имеете полный контроль над пользователями, включая возможность их удаления с форума.<br><br>
		</li>
		<li>
			<strong>Ожидание подтверждения</strong><br>
			Эта секция доступна только при включении подтверждения администратором новых регистраций. Любой, кто регистрируется на вашем
			форуме, станет полноценным пользователем, но только после того как его кандидатура будет одобрена администратором.
			Этот раздел показывает список всех тех пользователей, которые ожидают одобрения, вместе с их электронными и IP-адресами.
			Вы в любой момент можете разрешить или отклонить (удалить) любого пользователя в списке, отметив галочкой поле напротив пользователя и
			выбрав нужное действие из выпадающего меню в нижней части экрана. При отклонении (удалении) пользователя его можно уведомить об этом.<br><br>
		</li>
		<li>
			<strong>Ожидание активации</strong><br>
			Эта секция доступна только при включении режима активации учётных записей.
			Здесь отображается список всех пользователей, которые пока не активировали свой аккаунт.
			В этом разделе можно разрешить, отклонить или напомнить пользователям о необходимости завершить процесс регистрации.
			Кроме того, можно уведомить пользователя о совершенных вами действиях.<br><br>
		</li>
	</ul>';

$helptxt['ban_members'] = '<strong>Бан пользователей</strong><br>
	SMF предоставляет возможность «банить» конкретных пользователей, чтобы не допускать к общению на форуме тех, кто нарушил правила. Можно выбрать тех пользователей, которых не хочется видеть на форуме.	Вам, как администратору, при просмотре доступны IP-адреса всех пользователей. В списке ниже нужно просто указать нужный IP и сохранить его, после чего пользователи, использующие этот адрес, больше не смогут оставлять с него сообщения.<br>
	Кроме того, можно забанить пользователей по их электронным адресам.';

$helptxt['featuresettings'] = '<strong>Свойства и параметры</strong><br>
	Здесь можно изменить некоторые настройки форума, в соответствии со своими предпочтениями.';

$helptxt['modsettings'] = '<strong>Изменение настроек модификаций</strong><br>
	В этой секции содержатся настройки, добавленные установленными модификациями.';

$helptxt['time_format'] = '<strong>Формат времени</strong><br>
	Вы обладаете большими возможностями по изменению отображаемого формата времени.
	Преобразования производятся с помощью функции <a href="https://www.php.net/manual/ru/function.strftime.php" target="_blank">strftime</a> и описываются ниже.<br>
	<br>
	Доступные переменные: <br>
	<span class="smalltext">
	&nbsp;&nbsp;%a — краткое название дня недели<br>
	&nbsp;&nbsp;%A — полное названия дня недели<br>
	&nbsp;&nbsp;%b — краткое название месяца<br>
	&nbsp;&nbsp;%B — полное название месяца<br>
	&nbsp;&nbsp;%d — день в месяце (01 to 31) <br>
	&nbsp;&nbsp;%D<strong>*</strong> — то же, что и %m/%d/%y <br>
	&nbsp;&nbsp;%e<strong>*</strong> — день в месяце (от 1 до 31) <br>
	&nbsp;&nbsp;%H — час в 24-часовом формате (от 00 до 23) <br>
	&nbsp;&nbsp;%I — час в 12-часовом формате (от 01 до 12) <br>
	&nbsp;&nbsp;%m — месяц как номер (от 01 до 12) <br>
	&nbsp;&nbsp;%M — минута как номер <br>
	&nbsp;&nbsp;%p — «am» или «pm» в соответствии со временем<br>
	&nbsp;&nbsp;%R<strong>*</strong> — время в 24-х часовом представлении <br>
	&nbsp;&nbsp;%S — секунды в цифровом формате <br>
	&nbsp;&nbsp;%T<strong>*</strong> — текущее время, то же что %H:%M:%S <br>
	&nbsp;&nbsp;%y — 2 цифры года (от 00 до 99) <br>
	&nbsp;&nbsp;%Y — 4 цифры года<br>
	&nbsp;&nbsp;%% — дословно знак «%» <br>
	<br>
	<em>* Не работает на Windows-серверах.</em></span>';

$helptxt['live_news'] = '<strong>Последние новости</strong><br>
	В этом блоке отображаются последние новости с <a href="https://www.simplemachines.org/" target="_blank" rel="noopener">www.simplemachines.org</a>.
	Просматривайте их время от времени для получения информации об обновлениях, новых релизах, и важной информации от Simple Machines.';

$helptxt['registrations'] = '<strong>Управление регистрацией</strong><br>
	Этот раздел содержит все функции, которые могут быть необходимыми для управления новыми регистрациями на форуме. Содержит до четырех
	разделов, которые видны в зависимости от настроек форума. Среди них:<br><br>
	<ul class="normallist">
		<li>
			<strong>Регистрация нового пользователя</strong><br>
			Здесь можно зарегистрировать нового пользователя. Это может быть полезно на тех форумах, где регистрация закрыта
			для новых пользователей, или в случаях, когда администратор хочет создать тестовую учётную запись.
			Если выбрана опция «требовать активацию учётной записи», пользователю будет отправлено электронное сообщение со ссылкой для активации, по которой он должен будет перейти, прежде чем сможет использовать учётную запись.
			Также можно использовать отправку нового пароля на заданные электронные адреса.<br><br>
		</li>
		<li>
			<strong>Регистрационное соглашение</strong><br>
			Позволяет задать текст для регистрационного соглашения, отображаемого при регистрации на форуме.
			Вы можете отредактировать стандартное соглашение, которое поставляется с SMF.<br><br>
		</li>
		<li>
			<strong>Зарезервированные имена</strong><br>
			Используя этот интерфейс, можно указать слова или имена, которые нельзя будет использовать в именах пользователей.<br><br>
		</li>
		<li>
			<strong>Настройки</strong><br>
			Этот раздел будет виден только при наличии прав администрирования. Здесь можно выбрать метод регистрации,
			используемый на форуме, а также другие настройки, относящиеся к регистрации.
		</li>
	</ul>';

$helptxt['modlog'] = '<strong>Журнал модерации</strong><br>
	Этот раздел позволяет модераторам отслеживать все действия по модерированию, которые сделали модераторы форума.
	Чтобы быть уверенным, что модераторы не удалят ссылки на совершенные ими действия, установлен запрет на удаление этих данных в течение 24-х часов после предпринятого действия.';
$helptxt['adminlog'] = '<strong>Журнал администрирования</strong><br>
	Этот раздел позволяет администраторам отслеживать некоторые административные действия произведенные на форуме.
	Чтобы быть уверенным, что администраторы не смогут сразу удалить упоминания о своих действиях, записи не могут быть удалены в течение 24 часов со времени произведенного действия.';
$helptxt['userlog'] = '<strong>Журнал редактирования профилей</strong><br>
	Этот раздел позволяет администраторам просматривать изменения, сделанные пользователями в своих профилях.';
$helptxt['warning_enable'] = '<strong>Система предупреждений пользователей</strong><br>
	Эта функция позволяет администраторам и модераторам выносить пользователям предупреждения различного уровня.
	От этого уровня будут зависеть права пользователей на те или иные действия.
	Уровни предупреждений можно настроить в профиле пользователя.';
$helptxt['warning_watch'] = 'Этот параметр определяет процентный уровень предупреждения, при достижении которого пользователь автоматически попадает в список «наблюдаемых». Все «наблюдаемые» пользователи отображаются в центре модерации.';
$helptxt['warning_moderate'] = 'Любой пользователь с подобным статусом будет вынужден ждать модерации своих сообщений, прежде чем они появятся на форуме. Это переопределит любые локальные права разделов, так или иначе связанные с модерацией сообщений.';
$helptxt['warning_mute'] = 'Любой пользователь с подобным статусом не сможет ничего написать на форуме, так как лишается прав на постинг.';
$helptxt['user_limit'] = 'Эта опция ограничивает количество баллов, которые модератор может добавить/удалить конкретному пользователю в течение 24 часов.
Используется для ограничения действий модератора за небольшой промежуток времени.
Отключается установкой нулевого значения. Примечание: не влияет на пользователей с правами администраторов.';

$helptxt['error_log'] = '<strong>Журнал ошибок</strong><br>
	Здесь отображается каждая ошибка, с которой столкнулись пользователи при использовании форума. Ошибки сортируются по дате, можно выбрать сортировку, нажав на чёрной стрелке напротив каждой даты.	Кроме того, можно отфильтровать ошибки, нажав на изображении рядом с каждой ошибкой. Это позволяет фильтровать ошибки, к примеру, по пользователям.	Когда фильтр включен, будут отображены только те результаты, которые соответствуют данному фильтру.';
$helptxt['theme_settings'] = '<strong>Настройки тем оформления</strong><br>
	Этот раздел позволяет изменять настройки, относящиеся к теме оформления. Эти настройки включают такие параметры, как директория тем и URL-адреса, а также параметры, влияющие на отображение темы на вашем форуме. Большинство тем будут иметь различные параметры, настраиваемые пользователем, позволяющие адаптировать тему в соответствии с индивидуальными предпочтениями.';
$helptxt['smileys'] = '<strong>Смайлики и иконки</strong><br>
	Здесь можно добавлять, удалять смайлики, или наборы смайликов. Заметьте, что если смайлик один в наборе, то он появляется во всех наборах — иначе он может смутить ваших пользователей, использующих разные наборы.<br><br>

	Вы также можете отредактировать иконки сообщений, если это разрешено на странице настроек.';
$helptxt['calendar'] = '<strong>Управление календарем</strong><br>
	Здесь можно изменить текущие настройки календаря, добавить или удалить праздники.';
$helptxt['cal_export'] = 'Экспорт в текстовый файл в формате iCal для импорта в другие программы';
$helptxt['cal_highlight_events'] = 'Этот параметр позволяет выделить события в мини-календарях и/или главном календаре.';
$helptxt['cal_highlight_holidays'] = 'Этот параметр позволяет выделить праздники в мини-календарях и/или главном календаре.';
$helptxt['cal_highlight_birthdays'] = 'Этот параметр позволяет выделить дни рождения в мини-календарях и/или главном календаре.';
$helptxt['cal_disable_prev_next'] = 'Если этот параметр включен, блок с тремя месяцами в левой части страницы будет отключен.';
$helptxt['cal_display_type'] = 'Этот параметр позволяет изменить тип отображения календаря.<br><br><strong>Удобный:</strong> делает ячейки календаря большими.<br><strong>Компактный:</strong> делает ячейки календаря маленькими.';
$helptxt['cal_week_links'] = 'Если этот параметр включен, ссылки будут добавляться рядом с каждой неделей в календаре.';
$helptxt['cal_prev_next_links'] = 'Если этот параметр включен, ссылки на предыдущий месяц и следующий месяц будут добавляться в начало каждого месяца для удобства навигации.';
// argument(s): $txt['months_short'][1], $txt['months_titles'][1]
$helptxt['cal_short_months'] = 'Если этот параметр включен, имена месяцев в календаре будут сокращены.<br><br><strong>Включено:</strong> %1$s 1<br><strong>Выключено:</strong> %2$s 1';
// argument(s): $txt['days_short'][1], $txt['days'][1]
$helptxt['cal_short_days'] = 'Если этот параметр включен, имена дней в календаре будут сокращены.<br><br><strong>Включено:</strong> %1$s<br><strong>Выключено:</strong> %2$s';

$helptxt['serversettings'] = '<strong>Настройки сервера</strong><br>
	Здесь можно изменять основные настройки форума. Этот раздел включает в себя настройки базы данных и URL-адресов, а также настройки отсылки сообщений и кэширование.
	Прежде чем изменять данные настройки, хорошенько подумайте, потому как неправильная настройка может привести форум в нерабочее состояние.';
$helptxt['manage_files'] = '
	<ul class="normallist">
		<li>
			<strong>Просмотр файлов</strong><br>
			Просмотр всех вложений, аватаров и миниатюр, сохраненных SMF.<br><br>
		</li><li>
			<strong>Свойства вложений</strong><br>
			Конфигурация директорий для хранения вложений, а также установка ограничений на типы вложений.<br><br>
		</li><li>
			<strong>Свойства аватаров</strong><br>
			Конфигурация директорий для хранения аватаров, а также управление изменением размеров аватаров.<br><br>
		</li><li>
			<strong>Обслуживание файлов</strong><br>
			Проверка и исправление любых ошибок в директории вложений, а также удаление выбранных вложений.<br><br>
		</li>
	</ul>';

$helptxt['topicSummaryPosts'] = 'Это позволяет устанавливать число предыдущих сообщений, отображаемых под краткой сводкой темы в окне ответа.';
$helptxt['enableAllMessages'] = 'Установите здесь <em>максимальное</em> число сообщений в теме, которые будут отображаться по ссылке «Все».';
$helptxt['allow_guestAccess'] = 'Убрав здесь галочку, можно запретить гостям делать что-либо, кроме базовых функций: вход, регистрация, напоминание пароля и пр. Это не то же самое, что запрет доступа гостям к форуму.';
$helptxt['userLanguage'] = 'Включение этого параметра позволит пользователям выбирать, какой языковой файл они будут использовать. Это не повлияет на выбор по умолчанию.';
$helptxt['trackStats'] = 'Статистика:<br>Это разрешит пользователям видеть последние сообщения и наиболее популярные темы на форуме.
		Также это показывает некоторую статистику, такую как наибольшее количество пользователей онлайн, новые пользователи и новые темы.<hr>
		Просмотры страницы:<br>Добавляет на странице статистики колонку, в которой отображается количество просмотров страниц вашего форума.';
$helptxt['titlesEnable'] = 'Включение надписи над аватаром, позволит пользователям с соответствующими правами создавать специальные названия для себя.
Это будет отображаться под именем.<br><em>Например:</em><br>Я есть Грут<br>Я крут!';
$helptxt['onlineEnable'] = 'Отображение картинки с текущим статусом пользователя.';
$helptxt['todayMod'] = 'Отображение слов «Сегодня» или «Вчера» вместо полной даты.<br><br>
		<strong>Примеры:</strong><br><br>
		<ul class="normallist">
			<li>
			<strong>Запретить</strong><br>
			3 октября 2009 в 00:59:18</li>
			<li><strong>Только «Сегодня»</strong><br>
			Сегодня в 00:59:18</li>
			<li><strong>«Сегодня» и «Вчера»</strong><br>
			Вчера в 21:36:55</li>
		</ul>';
$helptxt['disableCustomPerPage'] = 'Отметьте эту опцию, чтобы запретить пользователям индивидуальную настройку количества выводимых сообщений и тем на одной странице.';
$helptxt['enablePreviousNext'] = 'Отображение ссылок на следующую и предыдущую темы.';
$helptxt['pollMode'] = 'Это определяет, включены голосования или нет. Если голосования отключены, все существующие голосования будут скрыты из списка тем. Можно установить отображение обычных тем без голосований, выбрав вариант «Показывать существующие голосования как темы».<br><br>Для выбора тех, кто может создавать, просматривать и участвовать в голосованиях, можно настроить соответствующие права доступа (если голосования не работают, вспомните это).';
$helptxt['enableCompressedOutput'] = 'Эта установка будет сжимать страницы для снижения загрузки канала, но для этого необходима установленная библиотека zlib.';
$helptxt['httponlyCookies'] = 'Куки не будут доступны для языков типа JavaScript. Эта настройка может помочь уменьшить кражу персональных данных с помощью XSS-атак. А также привести к проблемам с другими скриптами, используемыми на сайте.';
$helptxt['samesiteCookies'] = 'Атрибут SameSite позволяет установить, требуется ли вашему сайту получать куки при запросах с разных доменов.<br><br>
	<ul class="normallist">
		<li>Strict — самое строгое значение атрибута. К файлам куки с таким параметром можно получить доступ только при посещении домена, с которого они были изначально установлены.</li>
		<li>Lax — это значение позволяет всем типам сайта, которые принадлежат к одному и тому же домену, получить доступ к куки. В отличие от None, где куки отправляются всегда по умолчанию, это значение, как и Strict, отправляется только по запросу определенного сайта.</li>
		<li>None — это значение позволяет отслеживать пользователей на разных сайтах. Файлы куки с этим параметром будут работать так же, как было до появления атрибута SameSite. При этом для установки этого значения атрибута необходимо не просто указать None, но и выбрать тип — Secure, который гарантирует, что запрос передается по безопасному соединению. В случае, если пользователь не станет указывать Secure, запрос будет отклонен браузером.</li>
	</ul><br><br>Более подробную информацию можно найти на сайте <a href="https://developer.mozilla.org/docs/Web/HTTP/Headers/Set-Cookie/SameSite">MDN</a>';
$helptxt['databaseSession_enable'] = 'Эта опция делает возможным использование базы данных для хранения сессий — это лучше для серверов со сбалансированной нагрузкой, устраняет все ошибки с таймаутами и может сделать работу вашего форума быстрее.';
$helptxt['databaseSession_loose'] = 'Включение уменьшит загрузку канала, используемую форумом, и сделает так, что при клике назад страница не будет перезагружаться — недостаток этого в том что (новые) иконки не обновятся, так же как и другие вещи.';
$helptxt['databaseSession_lifetime'] = 'Продолжительность сессии (в секундах) после последней активности. Рекомендованное значение — более 2400.';
$helptxt['tfa_mode'] = 'Вы можете добавить второй уровень безопасности на свой форум, включив <a href="https://ru.wikipedia.org/wiki/Многофакторная_аутентификация#%D0%94%D0%B2%D1%83%D1%85%D1%84%D0%B0%D0%BA%D1%82%D0%BE%D1%80%D0%BD%D0%B0%D1%8F_%D0%B0%D1%83%D1%82%D0%B5%D0%BD%D1%82%D0%B8%D1%84%D0%B8%D0%BA%D0%B0%D1%86%D0%B8%D1%8F">двухфакторную аутентификацию</a>. Она заставляет пользователей вводить генерируемый программой код подтверждения после обычной авторизации. Вам нужно настроить двухфакторную авторизацию себе, прежде чем предлагать другим пользователям переходить на нее!';
$helptxt['cache_enable'] = 'SMF использует различные варианты кэширования. Чем более высокий уровень кэширования используется, тем больше времени используется процессором для извлечения кэшированной информации. Если кэширование доступно, попробуйте для начала 1 уровень.';
$helptxt['cache_memcached'] = 'При использовании memcached необходимо предоставить настройки сервера. Можно указать несколько серверов, через запятую, как в примере ниже:<br><br>«server1,server2,server3:port,server4»<br><br>Обратите внимание: если не указать порт, SMF будет использовать порт 11211. Если хост содержит слэш, порт будет установлен на 0. SMF попытается выполнить грубую/случайную балансировку нагрузки на указанных серверах.';
$helptxt['cache_cachedir'] = 'Этот параметр используется только при файловом кэшировании. Он указывает путь к каталогу кэша. Рекомендуется указать директорию /tmp/, хотя работать будет и с любым другим каталогом.';
$helptxt['cache_sqlite_cachedir'] = 'Этот параметр используется только при кэшировании в базу данных SQLite. Он указывает путь к каталогу кэша. Рекомендуется указать директорию /tmp/, хотя работать будет и с любым другим каталогом.';
$helptxt['enableErrorLogging'] = 'Запись любых ошибок, таких как попытка авторизации, чтобы в дальнейшем разобраться, что именно происходило неправильно.';
$helptxt['enableErrorQueryLogging'] = 'В журнал ошибок будет включен полный текст запроса, отправленного к базе данных. Регистрация ошибок должна быть включена.<br><br><strong>Примечание:  Это повлияет на возможность фильтрации в журналах по сообщениям об ошибках.</strong>';
$helptxt['disallow_sendBody'] = 'Эта опция убирает возможность получать текст ответов и сообщений в письмах уведомлений.<br><br>Часто пользователи могут отвечать на письма уведомлений, что в большинстве случаев означает то, что этот ответ получает веб-мастер.';
$helptxt['enable_ajax_alerts'] = 'Этот параметр позволяет пользователям получать AJAX-уведомления. Это означает, что пользователям не придется обновлять страницу для получения новых уведомлений.<br><strong>ПРИМЕЧАНИЕ:</strong> Этот параметр может привести к серьезной нагрузке на сервере с большим количеством пользователей онлайн.';
$helptxt['alerts_auto_purge'] = 'После того как уведомление было прочитано, оно вряд ли понадобится снова. По соображениям производительности рекомендуется автоматически удалять их через некоторое время.';
$helptxt['jquery_source'] = 'Это определит источник, используемый для загрузки библиотеки jQuery. <em>Google CDN, jQuery CDN</em> и <em>Microsoft CDN</em> — библиотека jQuery будет загружаться с соответствующей сети CDN. <em>Локальный источник</em> — загрузка из директории форума. <em>Свой путь к библиотеке jQuery</em> — позволяет указать произвольный URL-адрес библиотеки (например, на серверах Яндекса).';
$helptxt['compactTopicPagesEnable'] = 'Эта опция задает количество отображаемых номеров страниц.<br><em>Пример: </em>
		&quot;3&quot; показывается как: 1 ... 4 [5] 6 ... 9 <br>
		&quot;5&quot; показывается как: 1 ... 3 4 [5] 6 7 ... 9';
$helptxt['timeLoadPageEnable'] = 'Отображение в нижней части форума времени в секундах, которое понадобилось для генерации конкретной страницы.';
$helptxt['removeNestedQuotes'] = 'При включении этой опции из сообщений будут удаляться вложенные цитаты (вместо них останутся ссылки).';
$helptxt['max_image_width'] = 'Это позволяет задать максимальную ширину для размещаемых картинок. На изображения с меньшей шириной это не повлияет. Это также определяет, как будут отображаться прикрепленные изображения при нажатии по миниатюре. Действует только при отключении параметра «Изменять размер изображений при отображении под сообщениями».';
$helptxt['mail_type'] = 'Эта опция позволяет выбрать установки PHP по умолчанию, или задать свои настройки SMTP. PHP не поддерживает SMTP-аутентификацию, так что, если это нужно, выберите SMTP. Но помните, что SMTP может работать медленнее, и некоторые сервера не будут принимать имя пользователя и пароль.<br><br>Вам не придется заполнять настройки SMTP, если установлены настройки PHP по умолчанию.<br>Для использования шифрования указывайте сервер SMTP так: ssl://адрес_сервера.';
$helptxt['attachment_manager_settings'] = 'Вложения — это файлы, которые пользователи могут загружать на форум и прикреплять к своим сообщениям (для последующего просмотра/скачивания другими пользователями).';
$helptxt['attachmentCheckExtensions'] = 'Для некоторых сообществ иногда требуется ограничить загрузку определенных типов файлов.';
// References setting attachmentCheckExtensions
$helptxt['attachmentExtensions'] = 'Если опция «проверять расширения вложений» активна, можно будет добавлять к сообщениям вложения только указанных форматов.';
$helptxt['attachmentUploadDir'] = 'Путь к папке вложений на сервере<br>(пример: /home/sites/yoursite/www/forum/attachments)';
$helptxt['attachmentDirSizeLimit'] = 'Выберите размер папки вложений, включая размер всех файлов внутри нее.';
$helptxt['attachmentPostLimit'] = 'Выберите максимальный размер файла (в КБ) для всех вложений в сообщении. Если он ниже лимита для каждого вложения, то это будет предельным значением.';
$helptxt['attachmentSizeLimit'] = 'Выберите максимальный размер файла для каждого отдельного вложения.';
$helptxt['attachmentNumPerPostLimit'] = 'Выберите количество вложений, которое пользователь может использовать в одном сообщении.';
$helptxt['attachmentShowImages'] = 'Если загруженный файл является изображением, он будет отображаться под сообщением.';
$helptxt['attachmentThumbnails'] = 'Если выбрана вышеуказанная настройка, это сохранит отдельное (меньшее) вложение для миниатюры, чтобы уменьшить пропускную способность.';
$helptxt['attachmentThumbWidth'] = 'Используется только с параметром «Изменять размер изображений при отображении под сообщениями». Это максимальная ширина для изменения размера вложений. Они будут изменены пропорционально.';
$helptxt['attachmentThumbHeight'] = 'Используется только с параметром «Изменять размер изображений при отображении под сообщениями». Это максимальная высота для изменения размера вложений. Они будут изменены пропорционально.';
$helptxt['attachmentDirFileLimit'] = 'Максимальное количество файлов в директории';
$helptxt['attachmentEnable'] = 'Этот параметр позволяет настроить способ создания вложений.<br><br>
	<ul class="normallist">
		<li>
			<strong>Отключить все вложения</strong><br>
			Все вложения отключены. Существующие вложения не удаляются, но скрыты от просмотра (их не видят даже администраторы). Новые вложения также не могут быть сделаны, независимо от разрешений.<br><br>
		</li>
		<li>
			<strong>Включить все вложения</strong><br>
			Обычное состояние: пользователи работают с вложениями в соответствии с выставленными правами доступа.<br><br>
		</li>
		<li>
			<strong>Отключить новые вложения</strong><br>
			Существующие вложения по-прежнему доступны, но новые вложения не могут быть добавлены, независимо от разрешения.
		</li>
	</ul>';
$helptxt['attachment_image_paranoid'] = 'При выборе этой опции будет включена очень строгая проверка вложенных изображений. Предупреждение! Эту проверку могут не пройти и нормальные изображения. Поэтому настоятельно рекомендуется использовать данную опцию только совместно с обработкой изображений, чтобы в случае необходимости могла произойти повторная выборка изображений, не прошедших проверку безопасности. После прохождения проверки такие изображения будут подчищены и загружены. В противном случае, если обработка изображений не включена, любые вложения, провалившие проверку безопасности, будут отклонены.';
$helptxt['attachment_image_reencode'] = 'При выборе этой опции будет производиться попытка перекодирования загружаемых вложений, для обеспечения более высокой безопасности. Обратите внимание: после перекодирования все анимированные изображения станут статичными.<br>Данная функция работает только при наличии установленного GD-модуля на сервере. ';
$helptxt['attachment_thumb_memory'] = 'Чем больше исходное изображение (размер & ширина x высота), тем выше требования к памяти сервера для успешного создания миниатюр.<br>Проверяя этот параметр, система оценит необходимый объем памяти и запросит его. В случае успеха будет произведена попытка создать миниатюру.<br>Это приведет к меньшему количеству ошибок, но может привести и к созданию меньшего количества миниатюр. Если этот флажок не установлен, система всегда будет пытаться создать миниатюру (с фиксированным объемом памяти). Это может привести к большему количеству ошибок.';
$helptxt['attachmentRecodeLineEndings'] = 'Скрипт обработает символы конца строки в соответствии с настройками сервера.';
$helptxt['automanage_attachments'] = 'По умолчанию SMF помещает новые вложения в одну папку. Для большинства сайтов это не проблема, но по мере роста сайта может быть полезно иметь несколько папок для хранения вложений.<br><br>Этот параметр позволяет указать, следует ли управлять этими папками самостоятельно (например, создание второй папки и перемещение в нее по готовности) или поручить эти операции движку, на основе критериев (например, когда текущий каталог достигает заданного размера), или разбивка папок по годам или даже месяцам на очень загруженных сайтах.';
$helptxt['dont_show_attach_under_post'] = 'Если включено, вложения в сообщении не будут отображаться и подлежат удалению.';
$helptxt['use_subdirectories_for_attachments'] = 'Создать новые директории.';
$helptxt['max_image_height'] = 'Как и в случае с максимальной шириной, этот параметр указывает максимальную высоту размещенного изображения. Высота может автоматически меняться для каждого изображения, пропорционально к ширине.';
$helptxt['avatar_paranoid'] = 'При выборе этой опции будет включена очень строгая проверка аватаров. Предупреждение! Эту проверку могут не пройти и нормальные изображения. Поэтому настоятельно рекомендуется использовать данную опцию только совместно с обработкой аватаров, чтобы в случае необходимости могла произойти повторная выборка изображений, не прошедших проверку безопасности. После прохождения проверки такие изображения будут подчищены и загружены. В противном случае, если обработка аватаров не включена, любые аватары, провалившие проверку безопасности, будут отклонены.';
$helptxt['avatar_reencode'] = 'При выборе этой опции будет производиться попытка перекодирования загружаемых аватаров, для обеспечения более высокой безопасности. Обратите внимание: после перекодирования все анимированные изображения станут статичными.<br>Данная функция работает только при наличии установленного GD-модуля на сервере.';
$helptxt['cal_enabled'] = 'Календарь может быть использован для отображения дней рождений или важных событий, происходящих в вашем сообществе.';
$helptxt['cal_link_postevent'] = 'Это разрешит пользователям добавлять события в выбранный день';
$helptxt['cal_maxdays_advance'] = 'Если установлено значение 7, будут отображены события следующей недели';
$helptxt['cal_allow_unlinkedevents'] = 'Разрешить пользователям размещать события без необходимости создания ссылки на них на форуме';
$helptxt['cal_min_year'] = 'Выберите «первый» год в списке календаря';
$helptxt['cal_max_year'] = 'Выберите «последний» год в списке календаря';
$helptxt['cal_maxevent_span'] = 'Выберите максимальное количество дней, которое может занимать событие';
$helptxt['localCookies'] = 'SMF использует куки-файлы, чтобы хранить информацию об учётной записи на компьютере клиента.
	Эти файлы могут храниться глобально (myserver.com) или локально (myserver.com/путь_к_форуму).<br>
	Отметьте эту опцию, если испытываете проблемы с пользователями, которых автоматически выкидывает с форума.<hr>
	Хранящиеся глобально куки менее безопасны при использовании на общедоступном веб-сервере.<hr>
	Локальные куки не работают за пределами папки форума, поэтому, если ваш форум находится, к примеру, по адресу www.myserver.com/forum, страницы типа www.myserver.com/index.php не смогут получить доступ к информации учётной записи.
	Глобальное хранение особенно рекомендуется при использовании SSI.php.';
$helptxt['enableBBC'] = 'Включение этой опции позволит пользователям использовать специальные форумные теги (в квадратных скобках) для вставки изображений, форматирования текста и многого другого.';
$helptxt['legacy_bbc'] = 'Указанные теги устарели и не могут использоваться в новых сообщениях. Однако, если их включить здесь, они будут распознаны в существующих сообщениях.<br><br>Включение устаревших тегов полезно, только если ваш форум был обновлен с предыдущей версии SMF.<br><br>Кроме того, даже если они включены, некоторые устаревшие теги не будут отображаться так же, как раньше. Например, код [flash] будет лишь отображать ссылку на Flash-контент, вместо встраивания этого контента в сообщение.';
$helptxt['default_timezone'] = 'Это часовой пояс по умолчанию, используемый для отображения времени по всему форуму.';
$helptxt['timezone_priority_countries'] = 'Этот параметр позволяет переместить часовые пояса для определенной страны или стран в начало списка выбираемых часовых поясов, отображаемого при настройке профилей пользователей, создании событий в календаре&nbsp;и&nbsp;т.&nbsp;д.<br><br>Например, если многие пользователи вашего форума живут в Новой Зеландии или Фиджи, вы можете ввести "NZ, FJ", чтобы облегчить им выбор наиболее подходящих часовых поясов.<br><br>Вы можете найти полный список кодов стран ISO, выполнив поиск в Интернете по фразе "<a href="https://www.google.com/search?q=iso+3166-1+alpha-2" target="_blank" rel="noopener">ISO 3166-1 alpha-2</a>".';
$helptxt['spamWaitTime'] = 'Здесь можно указать время, которое необходимо подождать для отправки следующего сообщения. Это может предотвратить спам, флуд или оффтопик на вашем форуме.';

$helptxt['enablePostHTML'] = 'Это позволит использовать HTML-теги в сообщениях пользователей:
	<ul class="normallist" style="margin-bottom: 0;">
		<li>&lt;b&gt;, &lt;u&gt;, &lt;i&gt;, &lt;s&gt;, &lt;em&gt;, &lt;strong&gt;, &lt;ins&gt;, &lt;del&gt;</li>
		<li>&lt;a href=&quot;&quot;&gt;</li>
		<li>&lt;img src=&quot;&quot; alt=&quot;&quot; /&gt;</li>
		<li>&lt;br&gt;, &lt;hr&gt;</li>
		<li>&lt;pre&gt;, &lt;blockquote&gt;</li>
	</ul>';

$helptxt['themes_manage'] = 'Здесь можно установить новые темы и выбрать, какие темы будут доступны для выбора пользователям, тему по умолчанию, которую будут использовать новые пользователи и гости, а также другие настройки выбора тем.';
$helptxt['theme_install'] = 'Здесь можно установить новую тему оформления. Вы можете установить её из уже существующей директории на сервере, загрузить с сайта, либо скопировать уже существующую тему и внести в её код нужные изменения.<br><br>Архив с темой или директория должны содержать файл <tt>theme_info.xml</tt>.';
$helptxt['xmlnews_enable'] = 'Позволить пользователям ссылаться на <a href="%s?action=.xml;sa=news" target="_blank" rel="noopener">Последние новости.</a>
	Рекомендуется ограничить размер сообщений/новостей, для правильного отображения RSS-новостей в разных клиентах.';
$helptxt['xmlnews_attachments'] = 'Позволяет встраивать ссылки на вложения в ваши XML/RSS ленты. Включите этот параметр, если хотите использовать свой форум в качестве платформы для подкастинга, трансляции или аналогичной платформы для распространения контента.
	<br><br>
	Разрешение «Просмотр вложений» влияет на этот параметр. Пользователи и гости будут видеть вложения в ленте, только если они также могут видеть вложения на странице сообщения. Имейте в виду, что большинство читателей каналов получат доступ к вашим каналам в качестве гостя.
	<br><br>
	Некоторые форматы каналов допускают только одно вложение для каждой записи. Если к сообщению добавлено несколько вложений, SMF включит в ленту самое большое из них.';
$helptxt['globalCookies'] = 'Использование кросс-доменных куки.<br>
	Например, если ваш сайт расположен по адресу https://www.example.com/, а форум на поддомене https://forum.example.com/, то, используя эту функцию, пользователи могут заходить на ваш сайт, используя кросс-доменные куки форума. Не применяйте эту функцию, если используются какие-то другие домены (например, hacker.example.com), которые не принадлежат вам.<br><br>
	Не работает, если включено локальное хранение куки.';
$helptxt['globalCookiesDomain'] = 'При использовании независимых (глобальных) куки, вы можете указать, какой домен должен использоваться для них. Разумеется, нужно указывать свой основной домен — например, если форум находится по адресу <em>forum.example.com</em>, в качестве основного домена необходимо указать <em>www.example.com</em>. Приставку <em>http://</em> или <em>https://</em> указывать не нужно.';
$helptxt['secureCookies'] = 'Включение этой опции отметит все созданные для пользователей куки-файлы как безопасные. Используйте эту функцию только при наличии HTTPS-протокола на вашем сервере!';
$helptxt['securityDisable'] = '<em>Отключение</em> дополнительной проверки пароля при входе в панель администрирования. Не рекомендуется!';
$helptxt['securityDisable_why'] = 'Укажите ваш текущий пароль (тот, что используется для входа на форум).<br><br>Необходимость его ввода обусловлена тем, что изменяются некоторые важные настройки и что изменяете их именно <strong>вы</strong>, а не кто либо другой.';
$helptxt['securityDisable_moderate'] = '<em>Отключает</em> дополнительную проверку пароля для страницы модерации. Этот параметр включен по умолчанию.';
$helptxt['securityDisable_moderate_why'] = 'Укажите ваш текущий пароль (тот, что используется для входа на форум).<br><br>Дополнительное подтверждение помогает убедиться, что вы уверены в своих действиях, собираясь модерировать что-либо, а также что это именно <strong>вы</strong>, а не кто-то другой.';
$helptxt['allow_cors'] = 'Cross Origin Resource Sharing или CORS — это политика, позволяющая современным браузерам доверять ресурсам, которые запрашиваются в разных доменах. Если этот параметр включен, то будет предпринята попытка разрешить политику CORS для скриптов, получающих доступ к ресурсам форума из разных доменов. Если включены независимые от поддомена файлы куки (глобальные), предпринимаются попытки определить правильный домен. Предоставление дополнительных доменов CORS с разделенным запятыми списком доменов позволяет создавать дополнительные домены. Формат должен быть {SCHEMA}://{DOMAIN}. Если в домене указан подстановочный знак (*), то предпринимаются попытки разрешить этот подстановочный знак. Если в качестве единственного дополнительного домена указан подстановочный знак (*), то все домены разрешены, что может представлять угрозу безопасности вашего форума и не должно использоваться, за исключением крайних случаев. Дополнительные заголовки могут быть предоставлены в виде списка, разделенного запятыми, и будут разрешены во время запросов, содержащих эти заголовки, а подстановочный знак (*) разрешен.';
$helptxt['frame_security'] = 'Современные браузеры понимают заголовок безопасности, предоставляемый серверами под названием X-Frame-Options. Устанавливая эту опцию, вы указываете поведение вашего сайта внутри набора фреймов или фрейма (iframe). Вариант «Разрешить все» не будет отправлять какие-либо заголовки и является наиболее небезопасным, однако позволяет большую свободу. Вариант «Блокировать все» предотвратит все фреймы полностью и является наиболее строгим и безопасным. Вариант «Разрешить со своего домена» позволит вашему домену выдавать любые фреймы и обеспечивает золотую середину для двух предыдущих вариантов.';
$helptxt['proxy_ip_header'] = 'Это заголовок сервера, которому ваш форум будет доверять для хранения IP-адресов реальных пользователей. Изменение этого параметра может привести к неожиданным результатам IP-проверок участников. Перед изменением этих настроек обратитесь к администратору сервера, поставщику CDN или прокси-администратору. Большинство провайдеров понимают и используют заголовок HTTP_X_FORWARDED_FOR. Необходимо заполнить список серверов, отправляющих обратные заголовки прокси для обеспечения безопасности, чтобы эти заголовки поступали только из допустимых источников.';
$helptxt['email_members'] = 'В этом сообщении можно использовать несколько «переменных»:<br>
	{$board_url} - URL-адрес форума.<br>
	{$current_time} - Текущее время.<br>
	{$member.email} - Электронная почта текущего пользователя.<br>
	{$member.link} - Ссылка на профиль текущего пользователя.<br>
	{$member.id} - Идентификатор текущего пользователя.<br>
	{$member.name} - Имя текущего пользователя.<br>
	{$latest_member.link} - Ссылка на профиль последнего зарегистрировавшегося пользователя.<br>
	{$latest_member.id} - Идентификатор последнего зарегистрировавшегося пользователя.<br>
	{$latest_member.name} - Имя последнего зарегистрировавшегося пользователя.';

$helptxt['failed_login_threshold'] = 'Установите количество неудачных попыток входа, после чего произойдет перенаправление на восстановление пароля.';
$helptxt['loginHistoryDays'] = 'Количество дней для хранения истории входа в систему при отслеживании профиля пользователя. Значение по умолчанию — 30 дней.';
$helptxt['oldTopicDays'] = 'Если эта функция включена, форум оповестит пользователя о том, что тема уже устарела и предложит начать новую тему, если он будет пытаться ответить в нее.';
$helptxt['edit_wait_time'] = 'Количество секунд, в течение которых пользователь сможет отредактировать только что отправленное им сообщение, в котором не будет написано, что сообщение отредактировано.';
$helptxt['edit_disable_time'] = 'Количество минут, в течение которых пользователь сможет отредактировать свое сообщение. 0 — отключить. <br><br><em>Примечание: Если у пользователя есть право редактировать любые сообщения, это ограничение на него не распространяется.</em>';
$helptxt['preview_characters'] = 'Этот параметр задает количество доступных символов для предварительного просмотра первой и последней темы сообщения.';
$helptxt['quote_expand'] = 'Эта опция позволяет обрезать большие цитаты и разворачивать их до полного размера. Параметр регулирует минимальную высоту, которую должна иметь цитата после обрезания. Цитаты, имеющие меньший объём текста, затронуты не будут.';
$helptxt['posts_require_captcha'] = 'Эта функция заставит пользователей вводить проверочный код при публикации каждого сообщения. Ввод кода обязателен для всех пользователей с количеством сообщений меньше заданного — это должно помочь в борьбе с рассылкой возможного спама.';
$helptxt['disable_wysiwyg'] = 'Эта опция отключает для всех пользователей возможность использовать редактор WYSIWYG при создании сообщений.';
$helptxt['lastActive'] = 'Количество минут, в течение которых пользователь будет считаться находящимся онлайн. По умолчанию — 15.';

$helptxt['customoptions'] = 'В этом разделе определены параметры, которые пользователь может выбирать из выпадающего списка. Есть несколько ключевых моментов, на которые стоит обратить внимание:
	<ul class="normallist">
		<li><strong>Параметр по умолчанию:</strong> Этот параметр будет выбран изначально.</li>
		<li><strong>Удаление параметров:</strong> Для удаления любого параметра просто очистите его текстовое поле.</li>
		<li><strong>Изменение порядка параметров:</strong> Можно изменить порядок параметров, перемещая текст между блоками. Но помните — необходимо убедиться, что в результате данной операции текст <strong>не</strong> изменился.</li>
	</ul>';

$helptxt['autoFixDatabase'] = 'Эта функция автоматически исправит ошибки в таблицах базы данных. После завершения работы функции вы получите письмо с уведомлением.';
// argument(s): scripturl
$helptxt['pgFulltextSearch'] = 'Этот параметр определяет язык, используемый для полнотекстового поиска PostgreSQL. Выберите язык, который наиболее точно соответствует языку, фактически используемому на форуме. Если язык вашего форума отсутствует в списке, или если ваш форум многоязычный, выберите вариант «простой».<br>
Этот параметр не зависит от основных языковых параметров SMF и не связан с установленным языком SMF.<br>
При изменении этого параметра необходимо <a href="%1$s?action=admin;area=managesearch;sa=method" target="_blank" rel="noopener">перестроить полнотекстовый индекс</a>.<br>
Если нужного языка нет в списке, попросите администратора установить поддержку языка PostgreSQL для этого языка.';

$helptxt['enableParticipation'] = 'Если в теме содержатся сообщения пользователя, просматривающего раздел, то внутри иконок слева от соответствующей темы появится специальный значок (смайлик — в стандартном наборе).';

$helptxt['db_persist'] = 'Оставлять соединение активным для улучшения производительности форума. Если не используете выделенный сервер, с этой функцией могут возникнуть проблемы.<br>
Если эта функция недоступна, вам возможно нужно задействовать параметры mysqli.allow_persistent или pgsql.allow_persistent в файле php.ini.';
$helptxt['ssi_db_user'] = 'Необязательный параметр: использование разных имени пользователя (для базы данных) и пароля при работе с SSI.php.';

// argument(s): either $helptxt['queryless_urls_supported'] or $helptxt['queryless_urls_unsupported'], depending on whether the server uses a supported webserver
$helptxt['queryless_urls'] = 'Эта опция меняет формат URL-адреса на укороченный, после чего адреса выглядят примерно так: index.php/topic,1.0.html. Такие ссылки могут неверно обрабатываться некоторыми системами, поэтому не рекомендуются к использованию.<br><br>%1$s';
// is conditionally used as part of $helptxt['queryless_urls']
$helptxt['queryless_urls_supported'] = 'Эта функция работает на вашем сервере.';
// is conditionally used as part of $helptxt['queryless_urls']
$helptxt['queryless_urls_unsupported'] = 'Эта функция НЕ работает на вашем сервере.';
$helptxt['minimize_files'] = 'Эта опция минимизирует все CSS и JS файлы, используемые форумом, сокращая количество запросов к серверу и время загрузки страниц для пользователей.<br><br>Обычно эту опцию следует оставить включенной. Единственным случаем, когда вы, возможно, захотите отключить её — при редактировании каких-либо CSS или JS файлов (например, при редактировании шаблона или при разработке модификации).';
$helptxt['boardindex_max_depth'] = 'Эта опция контролирует максимальный уровень вложенности разделов, учитываемый SMF при подсчёте новых сообщений. Также это влияет на то, какие разделы включены, когда активна опция «Добавлять количество сообщений в подразделах к статистике родительского раздела».<br><br>Например, если задано значение «1», то на индексной странице вложенный раздел будет отмечен как «новый» только в том случае, если он содержит новое сообщение. Если задано значение «2», то подраздел будет отмечен как «новый», если есть новое сообщение в этом подразделе или в под-подразделе. Если задано значение «10», подраздел будет отмечен как новый, если есть новое сообщение в этом подразделе или в одном из вложенных в него разделов (до 10 уровня вложенности).<br><br>Для экономии ресурсов сервера на больших форумах не задавайте слишком высокое значение для данного параметра.';
$helptxt['countChildPosts'] = 'Включение этой функции означает, что сообщения, расположенные в подразделах родительского раздела, будут учитываться в общей статистике форума.';
$helptxt['allow_ignore_boards'] = 'Включение этой функции позволит пользователям выбирать разделы, которые они хотели бы игнорировать.';
$helptxt['deny_boards_access'] = 'Включение этой функции позволит запретить доступ к определенным разделам на основе прав доступа.';

// argument(s): scripturl
$helptxt['who_enabled'] = 'Эта опция позволяет включать страницу «<a href="%1$s?action=who" target="_blank" rel="noopener">Кто онлайн</a>», на которой отображается текущий онлайн и кто чем занят на форуме.';

$helptxt['recycle_enable'] = '«Восстановление» удаленных тем и сообщений из специального раздела.';

$helptxt['enableReportPM'] = 'Эта опция позволяет пользователям делать рапорт о личных сообщениях администрации форума.';
$helptxt['max_pm_recipients'] = 'Эта опция позволяет установить максимальное количество получателей при отсылке личных сообщений пользователем форума. Это может использоваться как предотвращение использования системы личных сообщений для рассылки спама. Обратите внимание: пользователи, которым разрешено делать объявления, не подвергаются этому ограничению. Установите 0 для отмены ограничений.';
$helptxt['pm_posts_verification'] = 'Эта опция заставит пользователей вводить код, отображаемый на изображении, каждый раз при отправке личного сообщения. Пользователи, имеющие определенное количество сообщений, не будут вводить код — это должно помочь в борьбе с автоматическими рассылками спама.';
$helptxt['pm_posts_per_hour'] = 'Это ограничит количество личных сообщений, отсылаемых в течение одного часа. Это не затрагивает администраторов и модераторов.';

$helptxt['default_personal_text'] = 'Текст по умолчанию, который будет отображаться под аватарами пользователей.';

$helptxt['registration_method'] = 'Эта опция определяет метод регистрации на вашем форуме. Доступны следующие методы:<br><br>
	<ul class="normallist">
		<li>
			<strong>Регистрация запрещена</strong><br>
				Означает, что никто не может регистрироваться на форуме.<br>
		</li><li>
			<strong>Мгновенная регистрация</strong><br>
				Означает, что, сразу после регистрации, новые пользователи могут входить на форум и оставлять сообщения.<br>
		</li><li>
			<strong>Активация пользователя</strong><br>
				Означает, что пользователь должен активировать свою учётную запись, перейдя по ссылке, присланной по электронной почте.<br>
		</li><li>
			<strong>Одобрение администратором</strong><br>
				Означает, что администратор форума должен одобрить учётную запись, прежде чем пользователь будет иметь доступ к основным функциям форума.
		</li>
	</ul>';

$helptxt['send_validation_onChange'] = 'Эта функция означает то, что после смены пользователем его электронного адреса на новый адрес отправляется письмо, с помощью которого пользователь должен реактивировать свою учётную запись.';
$helptxt['approveAccountDeletion'] = 'Если этот параметр включен, любой запрос пользователя на удаление собственной учётной записи должен быть одобрен администратором.';

$helptxt['send_welcomeEmail'] = 'При включении этой функции пользователи, прошедшие регистрацию, будут получать пригласительное письмо с форума.';
$helptxt['password_strength'] = 'Эта функция определяет политику паролей пользователей.
	Доступны следующие варианты:
	<ul class="normallist">
		<li><strong>Низкое:</strong> Пароль должен содержать как минимум 4 символа.</li>
		<li><strong>Среднее:</strong> Пароль должен содержать как минимум 8 символов и не может совпадать с именем или адресом электронной почты.</li>
		<li><strong>Высокое:</strong> Пароль должен содержать символы верхнего и нижнего регистров и как минимум из одного числа.</li>
	</ul>';
$helptxt['enable_password_conversion'] = 'При включении этого параметра SMF попытается обнаружить пароли, сохраненные в других форматах, и преобразовать их в формат, используемый SMF. Обычно это используется для форумов, преобразованных в формат SMF, но может иметь и другие применения. Отключение этого параметра предотвращает вход пользователей в систему с использованием пароля после преобразования, и им потребуется сбросить пароль.';

$helptxt['coppaAge'] = 'Значение, указанное в этом поле, определяет минимальный возраст новых пользователей, чтобы они могли сразу получить доступ к форуму.
	При регистрации им будет предложено подтвердить, достигли ли они этого возраста, и если нет, то их заявка будет либо отклонена, либо приостановлена до разрешения родителей — в зависимости от выбранного типа ограничения.
	Если для этого параметра выбрано значение 0, то все остальные настройки возрастных ограничений игнорируются.';
$helptxt['coppaType'] = 'Если на форуме стоит учет возраста и возраст пользователя меньше чем определено в настройках регистрации, существуют два дальнейших действия, а именно:
	<ul class="normallist">
		<li>
			<strong>Отменить регистрацию</strong><br>
				Дальнейшая регистрация пользователя невозможна.<br>
		</li><li>
			<strong>Запросить подтверждение у родителей/опекуна</strong><br>
				Будет отправлено письмо родителям/опекунам пользователя.
		</li>
	</ul>';
$helptxt['coppaPost'] = 'Введите в это поле адрес электроной почты, куда родители/опекуны смогут отправить подтверждение о разрешении на регистрацию.';

$helptxt['allow_hideOnline'] = 'Эта функция позволяет пользователям скрывать свой онлайн-статус на форуме от всех, кроме администраторов.';
$helptxt['meta_keywords'] = 'Эти слова выводятся в теге meta keywords и служат подсказкой для поисковых систем, объясняя им, чему именно посвящен ваш форум и что на нем можно найти. Можно указать довольно большой список слов, разделяя их запятыми (и не используя HTML).';

$helptxt['latest_themes'] = 'Здесь отображаются последние и самые популярные шаблоны оформления с сайта <a href="https://www.simplemachines.org/" target="_blank" rel="noopener">www.simplemachines.org</a>. Если темы не отображаются, форум не может подключиться к серверу <a href="https://www.simplemachines.org/" target="_blank" rel="noopener">www.simplemachines.org</a>.';

$helptxt['secret_why_blank'] = 'В целях безопасности ваш пароль и ответ на секретный вопрос хранятся в зашифрованном виде.';
$helptxt['moderator_why_missing'] = 'Так как модераторы назначаются в конкретные разделы, вы можете назначить их с помощью <a href="%1$s?action=admin;area=manageboards" target="_blank" rel="noopener">интерфейса управления разделами</a>.';

$helptxt['permissions'] = 'Права доступа ограничивают или разрешают пользователям или группе пользователей пользоваться определенными функциями на форуме.';
$helptxt['permissions_board'] = 'Если для раздела выбран режим «Глобальный», это означает, что в нем не определены какие-либо собственные права доступа. «Локальный» раздел, напротив, использует собственные права доступа, которые отличаются от глобальных прав. Это позволяет создавать разделы с индивидуальными правами, отличающимися от прав остальных разделов.';
$helptxt['permissions_quickgroups'] = 'Эта функция позволяет использовать уже предустановленные наборы прав. Например, «стандартный», «ограниченный» — запрещающий, «модератор» — с правами модератора, «технический» — с правами на профилактику.';
$helptxt['permissions_deny'] = 'Эта функция позволяет использовать запрещающие права для пользователей. Можно добавить группу с запрещающими правами для отдельных (избранных) пользователей.<br><br>Используйте данную функцию осторожно.';
$helptxt['permissions_postgroups'] = 'Эта функция позволяет выставить определенные права для групп пользователей, основанных на количестве сообщений.';
$helptxt['membergroup_guests'] = 'В группу «Гости» входят пользователи, не зарегистрированные или не авторизовавшиеся на форуме.';
$helptxt['membergroup_regular_members'] = 'Обычные пользователи это все пользователи, которые вошли на форум, но не входят ни в одну из определенных групп пользователей.';
$helptxt['membergroup_administrator'] = 'Администратор имеет доступ к любой функции форума. Изменить права доступа администратору нельзя.';
$helptxt['membergroup_moderator'] = 'Группа «Модератор» — специальная группа пользователей, наделенных особыми правами. Чаще всего модератор отвечает за соблюдение пользователями правил сайта. Точный перечень полномочий и обязанностей модератора на каждом сайте свой, но чаще всего полномочия, присвоенные этой группе, применяются к модераторам только <em>в тех разделах, которые они модерируют</em>. За пределами этих разделов модераторы являются такими же пользователями, как и все остальные.';
$helptxt['membergroups'] = 'Существует два вида групп пользователей:
	<ul class="normallist">
		<li><strong>Постоянная группа:</strong> В постоянную группу пользователи автоматически не заносятся. Для того чтобы поместить пользователя в такую группу, администратор форума должен установить необходимую группу в профиле пользователя.</li>
		<li><strong>Группа, основанная на количестве сообщений:</strong> В отличии от постоянной группы, группа, основанная на количестве сообщений, не может быть присвоена администратором пользователю. Пользователи автоматически переходят из группы в группу, набирая необходимое количество сообщений.</li>
	</ul>';

$helptxt['calendar_how_edit'] = 'Вы можете редактировать события, путем нажатия на красную звездочку (*).';

$helptxt['maintenance_backup'] = 'Здесь можно создать резервную копию вашей базы данных.<br><br>Рекомендуется периодически выполнять это действие.';
$helptxt['maintenance_rot'] = 'Здесь можно <strong>окончательно</strong> и <strong>бесповоротно</strong> удалить старые темы. Рекомендуется сначала сделать резервную копию базы данных, а затем удалять старые темы.<br><br>Используйте осторожно.';
$helptxt['maintenance_members'] = 'Здесь можно <strong>окончательно</strong> и <strong>бесповоротно</strong> удалить учётные записи пользователей форума. <strong>Категорически</strong> рекомендуется сначала сделать резервную копию базы данных, чтобы быть уверенными что не удалите чего-то лишнего.<br><br>Используйте осторожно.';

$helptxt['avatar_server_stored'] = 'Здесь можно позволить пользователям выбирать аватары из хранящихся на сервере. По умолчанию они сохраняются в директории «avatars».<br> Подсказка: если вы создадите поддиректории в этой директории, получатся «категории» аватаров.';
$helptxt['avatar_external'] = 'Если данная опция включена, пользователи смогут указывать прямые URL-адреса на аватары, которые хотят использовать. Однако помните, что слишком большие аватары могут разрушить шаблон вашего форума, приведя к искажению его внешнего вида.';
$helptxt['avatar_download_external'] = 'Если этот параметр включен, внешние аватары будут загружаться с URL-адресов, указанных пользователями. В случае успеха аватары будут рассматриваться как загруженные аватары.';
$helptxt['avatar_action_too_large'] = 'Этот параметр позволяет отклонять слишком большие изображения (с других сайтов) или указывать браузеру пользователя изменять их размер, или загружать их на сервер.<br><br>Если пользователи помещают очень большие изображения в качестве аватаров и изменяют размер в браузере, это может привести к очень медленной загрузке этих аватаров для других пользователей - так как размер файла на самом деле не изменяется, файл лишь отображается в уменьшенном виде. Например, цифровая фотография будет загружена полностью, а затем изменена только при отображении - то есть для пользователей просмотр такой фотографии может забрать всю пропускную способность сети.<br><br>С другой стороны, загрузка этих файлов приведет к использованию пропускной способности и пространства сервера, но вы также гарантируете, что изображения будут меньше, поэтому для пользователей это должно быть быстрее. (Примечание: для загрузки и изменения размеров файлов требуется библиотека GD или ImageMagick с помощью расширений Imagick или MagickWand)';
$helptxt['avatar_upload'] = 'Эта опция напоминает параметр «Внешние аватары», за тем исключением, что аватары будут загружаться на сервер и уменьшаться согласно выставленным вами настройкам.<br><br>Слишком большое количество аватаров приведет к заметному увеличению занятого пространства, так что используйте эту опцию осторожно.';
$helptxt['avatar_download_png'] = 'Формат PNG, как правило, занимает больше места, но изображения выглядят качественней. Если функция выключена, будет использоваться формат JPEG (Размер файлов меньше, но и качество ниже).';

$helptxt['disableHostnameLookup'] = 'Это отключит запрос имени хоста пользователя. На некоторых серверах эта функция работает медленно. Не забывайте, что функция Бана может стать менее эффективной, так как вы могли поставить Бан именно на имя хоста.';

$helptxt['smiley_sameall'] = 'Если вы установите флажок «То же изображение для всех наборов», то же самое изображение будет добавлено ко всем вашим наборам смайликов. Если вы снимете этот флажок, то для каждого установленного набора смайликов можно будет загрузить другое изображение. Обратите внимание, что для каждого набора смайликов необходимо будет предоставить изображение.';

$helptxt['search_weight_frequency'] = 'Здесь можно установить релевантность поиска.<br><br>При выборе опции «Релевантность поиска по количеству сообщений в теме» определяется процент отсеивания сообщений, максимум из которых будут составлять темы, в которых имеется максимальное количество ответов, содержащих искомое слово или фразу.';
$helptxt['search_weight_age'] = 'При выборе варианта «Релевантность поиска по возрасту последних сообщений» вы определяете процент отсеивания сообщений, первыми из которых будут составлять темы, с последними по времени сообщениями, в которых имеется искомое слово или фраза.';
$helptxt['search_weight_length'] = 'При выборе варианта «Релевантность поиска по величине темы» определяется процент отсеивания сообщений, первыми из которых будут составлять темы, с максимальным количеством сообщений, в которых имеется искомое слово или фраза.';
$helptxt['search_weight_subject'] = 'При выборе варианта «Релевантность поиска по названию темы сообщений» определяется процент отсеивания сообщений, первыми из которых будут составлять темы, в названии которых будет содержаться искомое слово или фраза.';
$helptxt['search_weight_first_message'] = 'При выборе варианта «Релевантность поиска по содержащимся первым сообщениям» определяется процент отсеивания тем, в первых сообщениях которых будет содержаться искомое слово или фраза.';
$helptxt['search_weight_sticky'] = 'Параметры релевантности используются для определения релевантности результатов поиска. Измените параметры релевантности, чтобы результаты поиска соответствовали важным вещам для вашего форума. К примеру, на новостном форуме более релевантны свежие темы («возраст последнего сообщения»). Все параметры относительно друг друга должны быть целыми положительными числами.<br><br>Этот параметр отслеживает закрепленные темы и увеличивает их общий балл релевантности.';
$helptxt['search'] = 'Здесь производится настройка всех параметров функции поиска.';
$helptxt['search_why_use_index'] = 'Индексирование может намного улучшить работу поиска на вашем форуме. Когда число сообщений увеличивается, поиск без индексирования занимает больше времени и увеличивает нагрузку на базу данных. Если ваш форум содержит более пятидесяти тысяч сообщений, можно создать индексирование, чтобы уменьшить нагрузку на форум.<br><br>Обратите внимание: индексирование может занимать некоторое место. Полнотекстовое индексирование построено на встроенном индексе MySQL и PostgreSQL. Оно относительно компактно (приблизительно тот же размер, что и у таблицы с сообщениями), но большинство слов не индексируются, и большинство запросов обрабатываются очень медленно. Выборочное индексирование зачастую занимает больше места (в зависимости от ваших настроек может доходить до 3-х кратного размера таблицы с сообщениями), но это намного быстрее, чем полнотекстовое, и намного стабильнее.';

$helptxt['see_admin_ip'] = 'IP-адреса показываются администраторам и модераторам. Помните, что IP периодически меняются.<br><br>Пользователи могут видеть собственные IP-адреса.';
$helptxt['see_member_ip'] = 'Ваш IP-адрес будет виден только вам и модераторам.  Помните, что IP периодически меняется.<br><br>Вы не можете видеть IP-адреса других пользователей, а они не могут видеть ваш.';
$helptxt['whytwoip'] = 'SMF использует различные методы для обнаружения IP-адресов пользователей. Как правило, оба метода приводят к отображению одного и того же адреса, однако в некоторых случаях может обнаружиться даже несколько адресов. В этом случае SMF регистрирует два самых последних адреса и в дальнейшем их можно использовать для отслеживания и бана определенных пользователей.';

$helptxt['ban_cannot_post'] = '«Нельзя оставлять сообщения» означает, что пользователь может только просматривать форум и не может оставлять в темах свои ответы или создавать новые темы.';

$helptxt['posts_and_topics'] = '
	<ul class="normallist">
		<li>
			<strong>Настройки сообщений</strong><br>
			Изменение некоторых настроек, касающихся отправки сообщений. Здесь можно включить проверку орфографии.
		</li><li>
			<strong>Нецензурные слова</strong>
			Для очистки форума от нецензурных выражений можно использовать эту функцию. Выбранные слова будут заменены на указанные вами.
		</li><li>
			<strong>Настройки тем</strong>
			Изменение настроек тем. Количество отображаемых тем на странице, включение или выключение закрепленных тем, количество сообщений для определения темы как популярной или очень популярной&nbsp;и&nbsp;т.&nbsp;д.
		</li><li>
			<strong>Черновики</strong>
			Изменение настроек черновиков, создаваемых при публикации сообщений.
		</li>
	</ul>';

$helptxt['spider_mode'] = 'Устанавливает уровень отслеживания.<br>
	Стандартный - Регистрирует минимальную активность поисковых ботов.<br>
	Высокий - Предоставляет более точную статистику.<br>
	Очень высокий - Такой же, как «Высокий», но регистрирует данные о каждой посещенной странице.';

$helptxt['spider_group'] = 'При выборе группы для поисковых ботов, когда гость определяется в качестве бота, ему будут автоматически присвоены определенные «запреты» этой группы, в добавление к обычным правам для гостей. Вы можете использовать это для ограничения поисковых ботов при их посещении вашего форума. Можно, например, создать новую группу под названием «Паучки», задать для нее ряд запрещающих параметров (просмотр профилей&nbsp;и&nbsp;т.&nbsp;п.) и выбрать её здесь.<br>Примечание: механизм обнаружения поисковых ботов не совершенен и не всегда срабатывает, особенно для тех поисковых систем, которые пока не добавлены.';
$helptxt['show_spider_online'] = 'С помощью этого параметра можно выбрать, кому будут видны поисковые боты (их имена, количество) в списке «Сейчас на форуме». Доступные варианты:
	<ul class="normallist">
		<li>
			<strong>Ни для кого</strong><br>
			Поисковые боты будут отображаться в виде обычных гостей.
		</li><li>
			<strong>Показывать количество ботов</strong><br>
			На главной странице будет отображено текущее количество находящихся на форуме ботов.
		</li><li>
			<strong>Показывать детали о ботах</strong><br>
			Имя каждого бота будет доступно для просмотра любому пользователю, на главной странице и на странице «Кто онлайн».
		</li><li>
			<strong>Показывать всю инфу, но только админам</strong><br>
			Как указано выше, только администраторы могут видеть статус поисковых ботов — всем остальным пользователям боты будут представляться в виде гостей.
		</li>
	</ul>';

$helptxt['birthday_email'] = 'Выберите шаблон поздравительного сообщения с днём рождения, который будет использоваться при отправке поздравлений пользователям. Ниже будут отображены тема сообщения и его текст.<br><strong>Примечание:</strong> Выбор того или иного варианта данного параметра не включает автоматическую рассылку поздравлений. Для этого необходимо зайти в <a href="%1$s?action=admin;area=scheduledtasks;%3$s=%2$s" target="_blank" rel="noopener">Диспетчер задач</a> и убедиться, что задание «Отправка поздравлений» включено.';
$helptxt['pm_bcc'] = 'При отправке личного сообщения можно добавить скрытого адресата, который не будет виден остальным адресатам сообщения.';

$helptxt['move_topics_maintenance'] = 'Это позволит переместить все сообщения из одного раздела в другой.';
$helptxt['maintain_reattribute_posts'] = 'Вы можете использовать данную функцию для присвоения сообщений гостей определенным зарегистрированным пользователям форума. Это полезно, если, к примеру, какой-нибудь пользователь сначала удалил свою учётную запись, а потом пожалел о содеянном и попросил вернуть ему все его старые сообщения.';
$helptxt['chmod_flags'] = 'Вы можете вручную установить нужные права доступа для выделенных файлов. Для этого введите CHMOD значение (в виде трехзначного числа). Примечание: на Windows-системах это не будет иметь никакого эффекта.';

$helptxt['postmod'] = 'В этой секции модераторы (с достаточным набором прав) могут одобрять любые сообщения и темы перед их публикацией на форуме.';

$helptxt['field_show_enclosed'] = 'Помещает форму для ввода текста пользователем между некоторым текстом или HTML. Это добавляет больше свободы при вводе сообщений, изображений или любых других встраиваемых объектов. Например:<br><br>
		&lt;a href="https://example.com/{INPUT}"&gt;&lt;img src="{DEFAULT_IMAGES_URL}/icon.gif" alt="{INPUT}" /&gt;&lt;/a&gt;<br><br>
		Можно использовать следующие переменные:<br>
		<ul class="normallist">
			<li>{INPUT} — Данные, вводимые пользователем.</li>
			<li>{SCRIPTURL} — Веб-адрес форума.</li>
			<li>{IMAGES_URL} — URL-адрес папки изображений текущего шаблона.</li>
			<li>{DEFAULT_IMAGES_URL} — URL-адрес папки изображений шаблона по умолчанию.</li>
			<li>{KEY} — Уникальный цифровой идентификатор, используемый для идентификации поля с несколькими параметрами.</li>
		</ul>';

$helptxt['custom_mask'] = 'Маска ввода важна для безопасности вашего форума. Проверка при вводе пользователями данных может помочь предотвращению использования этих данных неожиданным для вас образом. В маске используются простые регулярные выражения.<br><br>
	Разделители, отмечающие начало и конец выражения, обязательны! В примерах ниже они отмечаются знаком тильды (~).<br><br>
	<div class="smalltext" style="margin: 0 2em">
		&quot;[A-Za-z]+&quot; — Соответствие всем символам алфавита в верхнем и нижнем регистрах.<br>
		&quot;[0-9]+&quot; — Соответствие всем числовым символам.<br>
		&quot;[A-Za-z0-9]{7}&quot; — Соответствие всем символам алфавита в верхнем и нижнем регистрах, а также семизначным числовым значениям.<br>
		&quot;[^0-9]?&quot; — Запрет любого соответствия числовым значениям.<br>
		&quot;^([A-Fa-f0-9]{3}|[A-Fa-f0-9]{6})$&quot; — Разрешать только 3 или 6-символьные шестнадцатеричные коды.<br>
	</div><br><br>
	Кроме того, могут быть определены специальные метасимволы ?+*^$ и {xx}.
	<div class="smalltext" style="margin: 0 2em">
		? — Одно соответствие предыдущему выражению.<br>
		+ — Одно или более соответствий предыдущему выражению.<br>
		* — Ни одного соответствия предыдущему выражению.<br>
		{xx} — Точное число из предыдущего выражения.<br>
		{xx,} — Точное число или больше из предыдущего выражения.<br>
		{,xx} — Точное число или меньше из предыдущего выражения.<br>
		{xx,yy} — Точное соответствие между двумя числами из предыдущего выражения.<br>
		^ — Начало строки.<br>
		$ — Конец строки.<br>
		\\ — Escapes the next character.<br>
	</div><br><br>
	Дополнительную информацию по данному вопросу можно найти в интернете.';

$helptxt['topic_move_any'] = 'Если этот флажок установлен, пользователям будет разрешено перемещать темы в любой доступный раздел. В противном случае они смогут перемещать их только в разделы, где они могут публиковать новые темы.';

$helptxt['alert_pm_new'] = 'Уведомления о новых личных сообщениях не отображаются на панели оповещений, но отображаются в списке «Мои сообщения».';
$helptxt['alert_event_new'] = 'При добавлении нового события в календаре будет отправлено предупреждение или электронное письмо по запросу. Тем не менее, если это событие уже опубликовано и добавлена соответствующая тема, вы не получите предупреждение, если подписаны на данный раздел — уведомления раздела будут в приоритете.';

$helptxt['force_ssl'] = '<strong>Проверьте работоспособность SSL и HTTPS на вашем сервере, прежде чем включать эту опцию, иначе форум может стать недоступным.</strong> Задействуйте режим обслуживания, если не можете получить доступ к форуму после активации данной опции.';
$helptxt['image_proxy_enabled'] = 'Требуется для встраивания внешних изображений при полном SSL.';
$helptxt['image_proxy_secret'] = 'Храните это в секрете, защищает изображения вашего форума от использования на других сайтах. Измените его, чтобы сделать текущие изображения с горячими ссылками бесполезными.';
$helptxt['image_proxy_maxsize'] = 'Максимальный размер изображения, кэшируемого прокси-сервером изображений: большие изображения не будут кэшироваться. Кэшированные изображения хранятся в папке кэша SMF, поэтому убедитесь в наличии свободного места на сервере.';

$helptxt['enable_sm_stats'] = 'Если эта опция включена, Simple Machines будет ежемесячно посещать ваш форум для сбора базовой статистики. Это поможет нам оптимизировать программное обеспечение. Для получения подробной информации, пожалуйста, посетите нашу <a href="https://www.simplemachines.org/about/stats.php" target="_blank" rel="noopener">информационную страницу</a>.';

$helptxt['field_reg_require'] = 'Если это поле требуется при регистрации, оно также будет необходимо при изменении профиля.';

$helptxt['translatable_fields'] = 'Если вы хотите обеспечить многоязычную поддержку пользовательских полей, можно использовать переводимые токены как в полях имени, так и в полях описания.<br><br>
Всё, что заключено в фигурные скобки <span class="monospace">{}</span>, будет рассматриваться как токен и будет сопоставлено со строкой $txt, например, <span class="monospace">{gender}</span> будет заменено значением переменной $txt[\'gender\']<br><br>
<strong>Важно</strong>: соответствующую строку $txt нужно будет добавить для <strong>ВСЕХ</strong> установленных языков. Для этого перейдите на страницу <a href="%1$s?action=admin;area=languages;sa=edit;%3$s=%2$s" class="bbc_link" target="_blank" rel="noopener">Изменить языки</a> и выполните следующие шаги для каждого установленного языка:
<ol class="bbc_list" style="list-style-type: decimal">
	<li>Нажать кнопку "Правка" рядом с названием языка.</li>
	<li>В раскрывающемся списке "Выберите переменную для изменения" указать "Modifications".</li>
	<li>Прокрутить страницу вниз и нажать кнопку "Добавить другой пункт".</li>
	<li>Добавить новую строку, в соответствии с подсказками.</li>
</ol>';

// argument(s): $boarddir, $boardurl
$helptxt['cron_is_real_cron'] = 'По умолчанию SMF добавляет на каждую страницу небольшой скрипт, который побуждает браузер пользователя запускать файл cron.php в фоновом режиме. Такой подход позволяет SMF выполнять запланированные задачи на регулярной основе, не требуя от администратора дополнительных настроек сервера. Однако некоторые администраторы могут предпочесть настроить свои серверы для непосредственного выполнения cron.php на регулярной основе. В этом случае выполнение встроенного скрипта лучше отключить.<br><br><strong>Примечание:</strong> Настройка сервера для выполнения запланированных задач таким образом не может быть выполнена из SMF. Для этого необходимо использовать программное обеспечение сервера. Стандартные инструменты для этой цели включают в себя: <code>cron</code> (для серверов Linux), <code>schtasks.exe</code> (для серверов Windows) и <code>launchd</code> (для серверов macOS). Большинство хостеров предоставляют специальный интерфейс в панели управления, для доступа клиентов к таким инструментам.<br><br>Путь и URL-адрес к вашему cron.php:<br>Путь: %1$s/cron.php<br>URL: %2$s/cron.php';

$helptxt['languages_txt'] = 'Эти языковые записи используются в SMF для определения локализованных версий текста для разных языков.<br><br>Если вы видите значение типа <code>&#37;1$s</code> в записи, то это заглушка, которую SMF заменяет реальным значением во время выполнения скрипта. Не забудьте сохранить такие заглушки в вашем тексте.';
$helptxt['languages_helptxt'] = 'Эти языковые записи используются для показа плавающих окон с различной справочной информацией.';
$helptxt['languages_editortxt'] = 'Эти языковые записи используются для элементов пользовательского интерфейса в редакторе сообщений.';
$helptxt['languages_tztxt'] = 'Эти языковые записи используются для построения описаний часовых поясов.<br><br>Например, строка <code>Europe_Western</code> может быть объединена со строкой <code>daylight_saving_time_false</code> для получения «Западноевропейского стандартного времени».<br><br>Примечание: Если описание для данного часового пояса не задано, SMF создаст его, используя список местоположений в пределах этого часового пояса.';
$helptxt['languages_txt_for_timezones'] = 'Эти языковые записи позволяют вам сделать следующее:<br><ol class="bbc_list" style="list-style-type: decimal;"><li>Изменить имена, отображаемые для отдельных местоположений, в любом месте, где они могут использоваться в контексте, связанном с часовыми поясами. Например, можно отображать «Qaanaaq» вместо «Thule» для расположения «America/Thule».</li><li>Изменить названия, отображаемые для разных стран. Это можно сделать, отредактировав соответствующие строки <code>iso3166[]</code>.</li></ol>';
$helptxt['languages_txt_for_email_templates'] = 'Эти языковые записи используются для создания сообщений электронной почты, которые SMF отправляет пользователям.';
$helptxt['languages_native_name'] = 'Название языка, используемое в его собственных языковых файлах.';
$helptxt['languages_character_set'] = 'Кодировка символов, используемая для этого языка. Начиная с SMF 2.1 это всегда должна быть «UTF-8».';
$helptxt['languages_locale'] = 'Код локали используется для определения различных соглашений о форматировании и т. д.<br><br>Код локали обычно принимает форму двухсимвольного кода языка, за которым необязательно следует подчеркивание и двухсимвольный код страны. Например, <code>en</code> будет определять универсальный английский, в то время как <code>en_AU</code> — австралийский английский.';
$helptxt['languages_rtl'] = 'Введите "1" здесь, если этот язык читается справа налево (например, иврит или арабский).  Оставьте значение "0" для языков слева направо.';
$helptxt['languages_dictionary'] = 'Это определяет основной словарь языка, который будет использоваться проверкой орфографии <a href="https://php.net/function.pspell-new" target="_blank" rel="noopener">pSpell</a> (если эта библиотека установлена).';
$helptxt['languages_recaptcha'] = 'Код языка, используемый для виджета проверки reCAPTCHA.<br><br>Смотрите <a href="https://developers.google.com/recaptcha/docs/language" target="_blank" class="bbc_link" rel="noopener">список поддерживаемых языков</a> в документации Google.';
// The GDPR page of the EU exists in several languages; change the language code at the end of the url
$helptxt['requireAgreement'] = 'Этот параметр рекомендуется включить, чтобы соответствовать правилам <a href="https://ec.europa.eu/info/law/law-topic/data-protection/eu-data-protection-rules_en" target="_blank" rel="noopener" class="bbc_link">GDPR</a>.';
// The GDPR page of the EU exists in several languages; change the language code at the end of the url
$helptxt['requirePolicyAgreement'] = 'Этот параметр рекомендуется включить, чтобы соответствовать правилам <a href="https://ec.europa.eu/info/law/law-topic/data-protection/eu-data-protection-rules_en" target="_blank" rel="noopener" class="bbc_link">GDPR</a>.';
$helptxt['gravatar'] = 'Граватары — глобально распознаваемые аватары. Создайте учётную запись на сайте <a href="https://www.gravatar.com" target="_blank" rel="noopener">https://www.gravatar.com</a>, чтобы указать свое изображение для аватара. Этот аватар будет доступен на всех сайтах, поддерживающих граватары. При отсутствии учётной записи будет использоваться изображение по умолчанию.';

?>