/*
SITEPAD
http://sitepad.com/
(c) SitePad Team
*/

// Lets start
pagelayer_add_action('pagelayer_setup_history', function(){
	
	// Show the top bar
	pagelayer.$$(".pagelayer-iframe-top-bar").show();
	pagelayer.$$(".pagelayer-iframe-holder").addClass("pagelayer-iframe-holder-with-bar");
	
	// Move the bottom bar to the top bar
	var bottom = pagelayer.$$(".pagelayer-bottombar-holder").detach();
	bottom.appendTo(pagelayer.$$(".sitepad-top-bar-right"));
	pagelayer.$$(".pagelayer-bottombar-row").remove();
	pagelayer.$$(".pagelayer-mode-buttons-wrapper").addClass("sitepad-screen-mode-fix");
	
	// Add the publish button
	pagelayer.$$(".pagelayer-bottombar-rightbuttons").prepend('<button data-tlite="Publish Changes" class="sitepad-publish-button pagelayer-primary-btn btn">Publish</button>');
	
	sitepad_show_publish_button(pagelayer_post.post_status);
	
	// Show or hide publish button
	pagelayer_add_action('pagelayer_save_success', function(e, status){
		sitepad_show_publish_button(status);
		if(!pagelayer_empty(pagelayer_active.el) && pagelayer_active.el.tag == 'pl_post_props'){
			pagelayer.$$('.pagelayer-settings').click();
		}
	});
	
	// On click publish site
	pagelayer.$$(".sitepad-publish-button").click(function(){
		pagelayer.post_status = 'publish';
		pagelayer.$$('.pagelayer-update-button').click();
	});
	
	pagelayer.$$(".pagelayer-group-name-wordpress h5").html(sitepad_brand_sm+' Widgets');
  
	// Append the form to the body
	sitepad_add_seo_form();
	
});

function sitepad_show_publish_button(status){
	
	if(status == 'draft'){
		pagelayer.$$(".sitepad-publish-button").show();
	}else{
		pagelayer.$$(".sitepad-publish-button").hide();
	}
	
}

function sitepad_take_screenshot(){
	
	jQuery(".pagelayer-add-widget-area").attr("data-html2canvas-ignore", 1);
	
	html2canvas(document.body, {height: jQuery(window).outerWidth()}).then(function(canvas){
		var img = canvas.toDataURL("image/jpeg");
		jQuery.ajax({
			type: "POST",
			url: sitepad_ajax_url+'&action=sitepad_save_screenshot&postID='+pagelayer_postID,
			data: { 
				image : img,
				sitepad_nonce: sitepad_ajax_nonce,
				post_name: pagelayer_post['post_name'],
			},
			success: function(response, status, xhr){
				//alert(response);
			},
			error: function(errorThrown){
				console.log(errorThrown);
			}
		});
	});
}

// Take screenshot on save
pagelayer_add_action('pagelayer_save', function(){
	// Only for pages
	if(pagelayer_post.post_type != 'page'){
		return;
	}
	sitepad_take_screenshot();	
});

// Hide the top bar
pagelayer_add_action('pagelayer-leftbar-toggle', function(){
	
	var show = true;
	
	// Is the leftbar toggle itself there ?
	if(pagelayer.$$('.pagelayer-leftbar-toggle').is(":visible")){
		show = pagelayer.$$('.pagelayer-topbar-holder').is(":visible");
	}
	
	if(show){
		pagelayer.$$('.pagelayer-iframe-top-bar').show();
	}else{
		pagelayer.$$('.pagelayer-iframe-top-bar').hide();
	}
});

function sitepad_selectPage(selectObject){
	change_page = selectObject.value; 	
	window.parent.location.href = change_page;
}

// Add SEO form
function sitepad_add_seo_form(){
	
	var seoModal = pagelayer.$$('#sitepad-seo-option-div');
	
	// Save meta data
	seoModal.find('.meta-tags-submit').click(function(){
		var form_data = seoModal.find("#sitepad_meta_form").serialize();
		
		jQuery.ajax({
			url: pagelayer_ajax_url+'&action=sitepad_save_meta_tags&postID='+pagelayer_postID+'&sitepad_nonce='+sitepad_ajax_nonce,
			type: "POST",
			data: form_data,
			success: function(data){ 
				var obj = jQuery.parseJSON(data);
				if(obj['error']){
					alert(obj['error']);
				}else{
					alert("Meta Tags Successfully Updated!");
				}			
			},
			error: function(data, errorThrown){
				alert(errorThrown);
			},
		});
	});
	
	// Close SEO form Modal
	seoModal.find('.meta-tags-close').click(function(){
		seoModal.hide();
	});
	
	// Clear SEO form Modal
	seoModal.find('.meta-tags-clear').click(function(){
		var form_data = seoModal.find("#sitepad_meta_form").serialize();
		//jQuery("#div_loader").show();
		
		jQuery.ajax({
			url: pagelayer_ajax_url+'&action=sitepad_clear_meta_tags&postID='+pagelayer_postID+'&sitepad_nonce='+sitepad_ajax_nonce,
			type: "POST",
			data: form_data,
			success: function(data){ 
				var obj = jQuery.parseJSON(data);
				if(obj['error']){
					alert(obj['error']);
				}else{
            
          seoModal.find('input, textarea').val('');
          alert("Meta Tags Cleared Successfully!");
				}			
			},
			error: function(data, errorThrown){
				alert(errorThrown);
			},
		});
	});
	
	// Open SEO form Modal
	pagelayer.$$('.sitepad-seo-option').click(function(){
		seoModal.show();
	});
}
