import { LabelControl } from './label';
import { useState, useRef, useEffect } from '@wordpress/element';
import { ColorPicker } from '@wordpress/components';

export const AccessControl = (props) => {
	const { children } = props;

	const [isAccessVisible, setIsAccessVisible] = useState(false);
	const accessRef = useRef(null);

	useEffect(() => {
		const handleDocumentClick = (e) => {

			// Access Modal Handler
			if (
				accessRef.current &&
				!accessRef.current.contains(e.target)
			) {
				setIsAccessVisible(false);
			}
		};

		document.addEventListener('click', handleDocumentClick);
		return () => {
			document.removeEventListener('click', handleDocumentClick);
		};
	}, []);
	
	const openCaret = isAccessVisible ? 'pli-caret-open': '';
	
	return (
		<div className="components-base-control pagelayer-base-control">
			<LabelControl {...props} />
			<div className="pagelayer-elp-access-div" ref={accessRef}>
				<span
					className="pagelayer-elp-access"
					onClick={() => setIsAccessVisible(!isAccessVisible)}
				>
					<i className={`pli pli-caret-right ${openCaret}`}></i>
				</span>
				{isAccessVisible &&
					<div className="pagelayer-elp-access-holder">
						{ children }
					</div>
				}
			</div>
		</div>
	)
}