<?php
/**
 * This file contains the following configurations:
 *
 * * MySQL settings
 * * Secret keys
 * * Database table prefix
 * * ABSPATH
 */

if(empty($sitepad)){
	die('NO SITEPAD CONFIG');
}

$sitepad['domain'] = 'sitepad.local';// Internal Domain
$sitepad['uploads_domain'] = 'sitepad.uploads';
$sitepad['internal_url'] = 'http://'.$sitepad['domain'];
$sitepad['internal_upload_url'] = 'http://'.$sitepad['uploads_domain'];
$sitepad['serving_upload_url'] = $sitepad['serving_url'].'/sitepad-data/uploads';
$sitepad['data_path'] = $sitepad['path'].'/sitepad-data';
$sitepad['upload_path'] = $sitepad['path'].'/sitepad-data/uploads';
$sitepad['upload_url'] = $sitepad['url'].'/sitepad-data/uploads/';
$sitepad['screenshots_path'] = $sitepad['upload_path'].'/screenshots';
$sitepad['export_path'] = $sitepad['.sitepad'].'/export';
$sitepad['download_path'] = $sitepad['.sitepad'].'/download';
$sitepad['logs_path'] = $sitepad['.sitepad'].'/logs';
$sitepad['api_url'] = 'https://api.sitepad.com';
$sitepad['charset'] = empty($sitepad['charset']) ? 'utf8mb4' : $sitepad['charset'];
$sitepad['collate'] = empty($sitepad['collate']) ? 'utf8mb4_unicode_ci' : $sitepad['collate'];

//print_r($sitepad);

// ** MySQL settings - You can get this info from your web host ** //
/** The name of the database for WordPress */
define( 'DB_NAME', $sitepad['db_name'] );

/** MySQL database username */
define( 'DB_USER', $sitepad['db_user'] );

/** MySQL database password */
define( 'DB_PASSWORD', $sitepad['db_pass'] );

/** MySQL hostname */
define( 'DB_HOST', $sitepad['db_host'] );

/** Database Charset to use in creating database tables. */
define( 'DB_CHARSET', $sitepad['charset'] );

/** The Database Collate type. Don't change this if in doubt. */
define( 'DB_COLLATE', $sitepad['collate'] );

/**#@+
 * Authentication Unique Keys and Salts.
 *
 * Change these to different unique phrases!
 * You can change these at any point in time to invalidate all existing cookies. This will force all users to have to log in again.
 */
define( 'AUTH_KEY', $sitepad['AUTH_KEY'] );
define( 'SECURE_AUTH_KEY', $sitepad['SECURE_AUTH_KEY'] );
define( 'LOGGED_IN_KEY', $sitepad['LOGGED_IN_KEY'] );
define( 'NONCE_KEY', $sitepad['NONCE_KEY'] );
define( 'AUTH_SALT', $sitepad['AUTH_SALT'] );
define( 'SECURE_AUTH_SALT', $sitepad['SECURE_AUTH_SALT'] );
define( 'LOGGED_IN_SALT', $sitepad['LOGGED_IN_SALT'] );
define( 'NONCE_SALT', $sitepad['NONCE_SALT'] );

/**#@-*/

/**
 * SitePad Database Table prefix.
 *
 * You can have multiple installations in one database if you give each
 * a unique prefix. Only numbers, letters, and underscores please!
 */
$table_prefix = $sitepad['db_table_prefix'];

/**
 * For developers: debugging mode.
 *
 * Change this to true to enable the display of notices during development.
 * It is strongly recommended that plugin and theme developers use WP_DEBUG
 * in their development environments.
 */
define( 'WP_DEBUG', false );

define('WP_CONTENT_FOLDERNAME', 'site-data');
define('WP_CONTENT_DIR', $sitepad['data_path']);
define('WP_CONTENT_URL', $sitepad['url'].'/sitepad-data');
define('WP_TEMP_DIR', $sitepad['data_path']);
define('WP_PLUGIN_DIR', $sitepad['data_path'].'/plugins');
define('WP_PLUGIN_URL', $sitepad['url'].'/sitepad-data/plugins');
define('SP_PLUGIN_DIR', $sitepad['editor_path'].'/site-data/plugins');
define('SP_PLUGIN_URL', $sitepad['url'].'/site-data/plugins');
define('WP_LANG_DIR', $sitepad['editor_path'].'/site-data/languages');

/* That's all, stop editing! Happy publishing. */

/* Enable advanced cache */
if( ! defined('WP_CACHE') && file_exists(WP_CONTENT_DIR . '/enable-advanced-cache.php') ){
	define('WP_CACHE', true);
}

/** Absolute path to the WordPress directory. */
if ( ! defined( 'ABSPATH' ) ) {
	define( 'ABSPATH', dirname( __FILE__ ) . '/' );
}

