<?php
namespace Automattic\Kkart\Blocks\StoreApi\Routes;

use Automattic\Kkart\Blocks\StoreApi\Utilities\CartController;

/**
 * CartApplyCoupon class.
 *
 * @internal This API is used internally by Blocks--it is still in flux and may be subject to revisions.
 */
class CartApplyCoupon extends AbstractCartRoute {
	/**
	 * Get the path of this REST route.
	 *
	 * @return string
	 */
	public function get_path() {
		return '/cart/apply-coupon';
	}

	/**
	 * Get method arguments for this REST route.
	 *
	 * @return array An array of endpoints.
	 */
	public function get_args() {
		return [
			[
				'methods'             => \WP_REST_Server::CREATABLE,
				'callback'            => [ $this, 'get_response' ],
				'permission_callback' => '__return_true',
				'args'                => [
					'code' => [
						'description' => __( 'Unique identifier for the coupon within the cart.', 'kkart' ),
						'type'        => 'string',
					],
				],
			],
			'schema' => [ $this->schema, 'get_public_item_schema' ],
		];
	}

	/**
	 * Handle the request and return a valid response for this endpoint.
	 *
	 * @throws RouteException On error.
	 * @param \WP_REST_Request $request Request object.
	 * @return \WP_REST_Response
	 */
	protected function get_route_post_response( \WP_REST_Request $request ) {
		if ( ! kkart_coupons_enabled() ) {
			throw new RouteException( 'kkart_rest_cart_coupon_disabled', __( 'Coupons are disabled.', 'kkart' ), 404 );
		}

		$controller  = new CartController();
		$cart        = $controller->get_cart_instance();
		$coupon_code = kkart_format_coupon_code( wp_unslash( $request['code'] ) );

		try {
			$controller->apply_coupon( $coupon_code );
		} catch ( \KKART_REST_Exception $e ) {
			throw new RouteException( $e->getErrorCode(), $e->getMessage(), $e->getCode() );
		}

		return rest_ensure_response( $this->schema->get_item_response( $cart ) );
	}
}
