/**
 * External dependencies
 */
import { withRestApiHydration } from '@kkart/block-hocs';
import { renderFrontend } from '@kkart/base-utils';

/**
 * Internal dependencies
 */
import Block from './block.js';

const getProps = ( el ) => {
	return {
		attributes: {
			displayStyle: el.dataset.displayStyle,
			heading: el.dataset.heading,
			headingLevel: el.dataset.headingLevel || 3,
		},
	};
};

renderFrontend( {
	selector: '.wp-block-kkart-active-filters',
	Block: withRestApiHydration( Block ),
	getProps,
} );
