<?php
/**
 * Twenty Sixteen support.
 *
 * @since   3.3.0
 * @package Kkart\Classes
 */

defined( 'ABSPATH' ) || exit;

/**
 * KKART_Twenty_Sixteen class.
 */
class KKART_Twenty_Sixteen {

	/**
	 * Theme init.
	 */
	public static function init() {
		// Remove default wrappers.
		remove_action( 'kkart_before_main_content', 'kkart_output_content_wrapper' );
		remove_action( 'kkart_after_main_content', 'kkart_output_content_wrapper_end' );

		// Add custom wrappers.
		add_action( 'kkart_before_main_content', array( __CLASS__, 'output_content_wrapper' ) );
		add_action( 'kkart_after_main_content', array( __CLASS__, 'output_content_wrapper_end' ) );

		// Declare theme support for features.
		add_theme_support( 'kkart-product-gallery-zoom' );
		add_theme_support( 'kkart-product-gallery-lightbox' );
		add_theme_support( 'kkart-product-gallery-slider' );
		add_theme_support(
			'kkart',
			array(
				'thumbnail_image_width' => 250,
				'single_image_width'    => 400,
			)
		);
	}

	/**
	 * Open wrappers.
	 */
	public static function output_content_wrapper() {
		echo '<div id="primary" class="content-area twentysixteen"><main id="main" class="site-main" role="main">';
	}

	/**
	 * Close wrappers.
	 */
	public static function output_content_wrapper_end() {
		echo '</main></div>';
	}
}

KKART_Twenty_Sixteen::init();
