<?php

// SitePad
if(empty($sitepad)){
	die('HACKING ATTEMPT');
}

if(version_compare(PHP_VERSION, '5.5.0', '<=')){
	die('You need PHP version 5.5.0 to run this software !');
}

//print_r($sitepad);die();

define('SITEPAD', 1);

// Set the error reporting
error_reporting(0);

// For debug we all
if(!empty($_GET['debug'])){
	error_reporting(E_ALL);
}

function sitepad_server_cleanpath($path){
	$path = str_replace('\\\\', '/', $path);
	$path = str_replace('\\', '/', $path);
	$path = str_replace('//', '/', $path);
	return rtrim($path, '/');
}

$sitepad['editor_path'] = empty($sitepad['editor_path']) ? $sitepad['sitepad_plugin_path'].'/editor' : $sitepad['editor_path'];
$sitepad['relativeurl'] = empty($sitepad['relativeurl']) ? '/' : $sitepad['relativeurl'];
$server['url'] = explode($sitepad['relativeurl'], $_SERVER['REQUEST_URI'], 2);
$server['url'] = '/'.ltrim($server['url'][1], '/');
$server['parsed'] = parse_url($server['url']);
$server['this_dir'] = sitepad_server_cleanpath($sitepad['editor_path']);
$server['realpath_sitepad'] = sitepad_server_cleanpath(realpath($server['this_dir']));
$server['file'] = sitepad_server_cleanpath($server['this_dir'].'/'.$server['parsed']['path']);
$server['file_ext'] = pathinfo($server['file'], PATHINFO_EXTENSION);

// Directory with index.php
if(is_dir($server['file']) && file_exists($server['file'].'/index.php')){
	$server['file'] = $server['file'].'/index.php';
	$server['parsed']['path'] = sitepad_server_cleanpath($server['parsed']['path'].'/index.php');
	$server['file_ext'] = pathinfo($server['file'], PATHINFO_EXTENSION);
}

//print_r($server);die();

// We dont allow double dots
if(preg_match('/\.\./', $server['file'])){
	die('HACKING ATTEMPT BY DOUBLE DOTS');
}

// IF FILE is outside this folder
$server['realpath'] = sitepad_server_cleanpath(realpath($server['file']));
if(file_exists($server['file']) && !preg_match('/^'.preg_quote($server['realpath_sitepad'], '/').'/is', $server['realpath'])){
	//print_r($server);
	die('REALPATH mismatch');
}

//print_r($server);die();

// Handle access thru different URL
$sitepad['parsed_url'] = parse_url($sitepad['url']);
if(!empty($_SERVER['HTTP_HOST']) && $sitepad['parsed_url']['host'] != $_SERVER['HTTP_HOST']){
	$sitepad['orig_url'] = $sitepad['url'];
	$sitepad['url'] = str_replace($sitepad['parsed_url']['host'], $_SERVER['HTTP_HOST'], $sitepad['url']);
	$sitepad['serving_url'] = preg_replace('/http(s?):\/\//is', '', $sitepad['url']);
	define('WP_SITEURL', $sitepad['url']);
	define('WP_HOME', $sitepad['url']);
}

// Is it cron
if(!empty($argv[1]) && preg_match('/cron/is', $argv[1])){
	include_once($sitepad['editor_path'].'/cron.php');
	exit(0);	
}

// PHP File
if($server['file_ext'] == 'php' && !is_dir($server['file']) && file_exists($server['file'])){
	$_SERVER['SCRIPT_FILENAME'] = $server['file'];
	$_SERVER['SCRIPT_NAME'] = $server['parsed']['path'];
	$_SERVER['PHP_SELF'] = $_SERVER['SCRIPT_NAME'];
	//print_r($server);die();
	include_once($server['file']);
	exit(0);
}

// We are zipping if possible
if(function_exists('ob_gzhandler') && !ini_get('zlib.output_compression')){
	ob_start('ob_gzhandler');
}

// Static files
if(file_exists($server['file'])){

	// Static file
	include_once($sitepad['editor_path'].'/site-inc/mime.php');

	if(!empty($server['file_ext']) && !empty($server['mime_types'][$server['file_ext']])){
		header('Content-type: '.$server['mime_types'][$server['file_ext']]);
	}

	// Set a zero Mtime
	$filetime = filemtime($server['file']);
	
	// Cache Control
	header("Cache-Control: must-revalidate");

	// Checking if the client is validating his cache and if it is current.
	if (isset($_SERVER['HTTP_IF_MODIFIED_SINCE']) && (@strtotime($_SERVER['HTTP_IF_MODIFIED_SINCE']) >= $filetime)) {
		
		// Client's cache IS current, so we just respond '304 Not Modified'.
		header('Last-Modified: '.gmdate('D, d M Y H:i:s', $filetime).' GMT', true, 304);
		
		return;
		
	}else{
		
		// Image not cached or cache outdated, we respond '200 OK' and output the image.
		header('Last-Modified: '.gmdate('D, d M Y H:i:s', $filetime).' GMT', true, 200);
		
	}

	readfile($server['file']);
	
	exit(0);

}

// Permalinks
include_once($sitepad['editor_path'].'/index.php');