<?php
// Master SiT! Language File - English (GB)

$languagestring = 'English (GB)';
$i18ncharset = 'UTF-8';

# List of letters of the alphabet for this language
# in standard alphabetical order (upper case, where applicable)
$i18nAlphabet = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';

// list of strings (*ALPHABETICAL ORDER BY (KEY) VARIABLE NAME* - ABCDEFGHIJKLMNOPQRSTUVWXYZ 0123456789)

$str0MeansUnlimited = '0 Means Unlimited';
$str1Day = '1 day';
$str1Minute = '1 minute';
$str1Month = '1 month';
$str1Hour = '1 hour';
$str1IncidentsLoggedViaPortal = '1 Incident Logged via the Portal';
$str1Second = '1 second';
# e.g 1st day of month
$str1st = '1st';
$str1Year = '1 year';
# e.g 3rd day of month
$str3rd = '3rd';

# e.g. About this site, i.e. more information
$strAbout = 'About';
# e.g. About John Smith
$strAboutPerson = 'About %s';
$strAboutXMinutesAgo = 'About %d minutes ago';
$strAboveMustBeCompletedToAllowDeductions = 'Above must be completed to allow deductions';
$strAbsentSick = 'Absent Sick';
$strAcceptingIncidents = 'Accepting Incidents';
$strAccountManager = 'Account Manager';
$strActual = 'Actual';
$strAcknowledge = 'Acknowledge';
# e.g. Accepting incidents
$strAccepting = 'Accepting';
$strAccessDetails = 'Access Details';
$strAction = 'Action';
$strActions = 'Actions';
$strActionNeeded = 'Action Needed';
$strActionPlan = 'Action Plan';
$strActionPlanBy = 'Action plan by %s';
$strActionPlanHasBeenMade = 'An action plan has been made';
$strActionTaken = 'Action Taken';
$strActive = 'Active';
$strActiveContracts = 'Active Contracts';
$strActiveUnassigned = 'Active (Unassigned)';
$strActivities = 'Activities';
$strActivitiesForX = 'Activities for %s';
$strActivity = 'Activity';
$strActivityAdded = 'Activity Added';
$strActivityBilling = 'Activity Billing';
$strActivityBillingInfo = 'Only closed activities are shown for billing.';
$strActivityCompleted = 'Activity completed: %s, total duration was: %s minutes';
$strActivityContainsNoNotes = 'Activity contains no notes';
$strActivityForIncidentX = 'Activity for Incident %s';
$strActivityList = 'Activity List';
$strActivityMarkedCompleteSuccessfully = 'Activity Marked Complete Successfully';
$strActivityStarted = 'Activity started: %s';
# i.e. Create, New
$strAdd = 'Add';
$strAddAction = 'Add Action';
$strAddActionToXTrigger = 'Add Action to \'%s\' trigger';
$strAddContact = 'Add Contact';
$strAddContract = 'Add Contract';
$strAddContractConfirm = 'Are you sure you want to add this contact?';
$strAdded = 'Added';
$strAddEmailConfirm = 'Are you sure you want to add this email type?';
$strAddEmailTemplate = 'Add Email Template';
$strAddFeedbackForm = 'Add Feedback Form';
$strAddFeedbackQuestion = 'Add Feedback Question';
$strAddIncident = 'Add Incident';
$strAdditional = 'Additional';
$strAdditionalInfo = 'Additional Information';
$strAddKBArticle = 'Add Knowledge Base Article';
$strAddLink = 'Add Link';
$strAddNew = 'Add New';
$strAddNewSiteContact = 'Add New Site Contact';
$strAddNewSupportedContact = 'Add new supported contact';
$strAddNote = 'Add Note';
$strAddProduct = 'Add Product';
$strAddProductInformation = 'Add Product Information';
$strAddProductQuestion = 'Add Product Questions';
$strAddReseller = 'Add Reseller';
$strAddress = 'Address';
$strAddress1 = 'Address1';
$strAddress2 = 'Address2';
$strAddRole = 'Add Role';
$strAddRSSAtomFeed = 'Add RSS/Atom feed';
$strAddService = 'Add Service';
$strAddServiceLevel = 'Add Service Level';
$strAddsIncidentBasedOnEmail = 'Add an incident based on the contents of an email';
# i.e. Physical site
$strAddSite = 'Add Site';
$strAddSiteFailed = 'Addition of site failed';
# i.e. Addition of site failed
$strAddXfailed = 'Addition of %s Failed';
$strAddSiteSupportIncident = 'Add Site Support Incident';
$strAddSkill = 'Add Skill';
$strAddTask = 'Add Task';
$strAddTemplate = 'Add Template';
$strAdditionFail = 'Addition Failed';
$strADuplicateAlreadyExists = 'A duplicate entry already exists';
$strAddUser = 'Add User';
$strAddVendor = 'Add Vendor';
$strAdjust = 'Adjust';
$strAdjustActivityDuration = 'Adjust Activity Duration';
$strAdmin = 'Admin';
$strAdminContact = 'Admin Contact';
$strAdminContactForContracts = 'You are an Admin Contact for the following contracts. You can choose who is able to see those incidents in the portal.';
$strAdministratorsOnly = 'Administrators Only';
$strAdminOnly = 'Admin only';
$strAdvanced = 'Advanced';
$strAfternoon = 'Afternoon';
$strAfterXSurveys = 'after %s surveys';
$strAge = 'Age';
# e.g. 4 hours ago
$strAgo = '%s ago';
$strAListOfAvailableTriggers = 'A list of available triggers and the actions that are set when triggers occur';
$strAll = 'All';
$strAllActivities = 'All Activities';
$strAllClosed = 'All Closed';
$strAllContacts = 'All Contacts';
$strAllDay = 'all day';
$strAllIncidents = 'All Incidents';
$strAllOnline = 'All Online';
$strAllOpen = 'All Open';
$strAllTasks = 'All Tasks';
$strAllowIncidentReopen = 'Allow Incident Reopening';
$strAllSiteContactsSupported = 'All of this sites\' contacts are supported';
# i.e. Sorted by alphabet
$strAlphabetically = 'Alphabetically';
$strAlternative = 'Alternative';
$strAmount = 'Amount';
$strAmountToEditBy = 'Amount to edit by +ve/-ve';
# i.e. before noon
$strAM = 'am';
$strAnswer = 'Answer';
# e.g. SiT is an application
$strApplication = 'Application';
$strApprovalStatusUnknown = 'Approval Status Unknown';
$strApprove = 'Approve';
$strApproveAll = 'Approve All';
$strApproveTimesheets = 'Approve Timesheets';
$strApproved = 'Approved';
$strApproveFree = 'Approve Free';
$strApprovedFree = 'Approved Free';
$strApproveHolidays = 'Approve Holidays';
# Short for April
$strAprAbbr = 'Apr';
# Month number 4: April
$strApril = 'April';
$strArchivedApproved = 'Archived. Approved';
$strArchivedApprovedFree = 'Archived. Approved \'Free\'';
$strArchiveDaysBookedPriorToX = 'Archive days booked prior to %s';
$strArchivedDenied = 'Archived. Denied';
$strArchivedNotRequested = 'Archived. Not Requested';
$strArchivedRequested = 'Archive. Requested';
$strArticlesPublishedRecently = 'Articles Published Recently';
$strArticlesPublishedToday = 'Articles Published Today';
# Which area of the product does the problem occur in?
$strArea = 'Area';
$strAreYouSureAdd = 'Are you sure you want to add this?';
$strAreYouSureDelete = 'This item will be permanently deleted.  Are you sure you want to continue?';
$strAreYouSureDeleteMaintenceContract = 'This will remove the ability to log incidents for this contact regarding the product which this contract is for. Are you sure you want to delete this maintenance support contact?';
$strAreYouSureMakeTheseChanges = 'Are you sure you want to make these changes?';
$strAreYouSureSendEmail = 'Are you sure you want to send this email?';
$strAreYouSureUpdateLastBilled = 'Are you sure you wish to update the last billed time?';
$strARecordAlreadyExistsWithTheSameName = 'A record already exists with the same name';
$strArticle = 'Article';
$strAssign = 'Assign';
$strAssignedAsFollows = 'Assigned as follows:';
$strAssignTemporarily = 'Assign Temporarily';
$strAssignTemporarilyTo = 'Assign Temporarily To';
$strAssignTo = 'Assign To';
$strAssignToBackup = 'Assign to Backup';
$strAssignToOther = 'Assign to Other';
$strAssociateContactWithContract = 'Associate this contact with an existing contract';
$strAtLunch = 'At Lunch';
$strAttachFile = 'Attach File';
$strAttachment = 'Attachment';
$strAttachments = 'Attachments';
$strAttachedIsBillableIncidentsForAbovePeriod ='Attached is the billable incidents for the above period';
# Short for August
$strAugAbbr = 'Aug';
# Month number 8: August
$strAugust = 'August';
$strAuthor = 'Author';
$strAuthors = 'Authors';
$strAutoReassignmentsThatCouldntBeMade = 'Automatic reassignments that could not be made because users were set to \'not accepting\'';
$strAvailableBalance = 'Available Balance';
# Average Assigned per month
$strAvgAssignedMonth =  'Average Assigned (Month)';
# Average Closed per month
$strAvgClosedMonth =  'Average Closed (Month)';
# Average Escalated per month
$strAvgEscalatedMonth =  'Average Escalated (Month)';
$strAverageIncidentDuration = 'Average Incident Duration';
$strAvoidDupes = 'Please help avoid duplicates by checking that the record you are adding does not already exist';
$strAwaitingApproval = 'Awaiting Approval';
$strAwaitingClosure = 'Awaiting Closure';
$strAwaitingClosureVar =  'Whether the incident is being closed now, or being marked for closure';
$strAwaitingColleagueResponse = 'Awaiting Colleague Response';
$strAwaitingCustomerAction = 'Awaiting Customer Action';
$strAwaitingSupportResponse = 'Awaiting Support Response';
$strAwaitingYourResponse = 'Awaiting Your Response';

$strBackToList = 'Back To List';
$strBackToLoginPage = 'Back to login page';
$strBackToSites = 'Back to sites';
$strBackOneYear = 'Back One Year';
$strBalance = 'Balance';
$strBCC = 'BCC';
$strBeforeDeleteContact = 'Before you can delete you must select another contact to receive any incidents and/or contracts.';
# noun, a bill to pay money
$strBill = 'Bill';
$strBillableIncidentApproved = 'Billable Incident Approved';
$strBillableIncidentApprovedDesc = 'Occurs when an billable incident is approved';
$strBillableIncidents = 'Billable Incidents';
$strBillableIncidentsForPeriodXtoX = 'Billable incidents for period %s to %s';
$strBillableIncidentsReport = 'Billable Incidents Report';
$strBilling = 'Billing';
$strBillingCustomerPeriod = 'Customer Period';
$strBillingEngineerPeriod = 'Engineer Period';
$strBillingSummary = 'Billing Summary';
# verb, to book a holiday
$strBook = 'Book';
$strBookHoliday = 'Book Holiday';
$strBoth = 'Both';
$strBrowse = 'Browse';
$strBrowseContacts = 'Browse contacts';
$strBrowseContracts = 'Browse contracts';
$strBrowseContractsBySite = 'Browse Contracts by Site';
$strBrowseFeedback = 'Browse feedback';
$strBrowseFeedbackForms = 'Browse Feedback Forms';
$strBrowseJournal = 'Browse Journal';
$strBrowseKB = 'Browse Knowledge Base';
$strBrowseSites = 'Browse sites';
$strBulkModify = 'Bulk Modify';
# e.g. by Fred
$strby = 'by';
$strByContact = 'By Contact';
$strByEngineer = 'By Engineer';
$strByEscalation = 'By Escalation';
$strByGroup = 'By Group';
$strByMaintenance = 'By Maintenance';
# e.g. Ordered By Product
$strByProduct = 'By Product';
$strByReseller = 'By Reseller';
$strBySkill = 'By Skill';
$strBySite = 'By Site';
$strBytes = 'Bytes';
$strByDate = 'By Date';
$strBySLA = 'By SLA';
$strByVendor = 'By Vendor';
# e.g. By: Joe Bloggs
$strByX = 'By: %s';

$strCalendar = 'Calendar';
# verb: Calculate, plural noun: Units
$strCalculateUnits = 'Calculate Units';
# incident status: e.g. Made a phone call and left a message
$strCalledAndLeftMessage = 'Called And Left Message';
$strCallFromCustomer = 'Phone call from customer';
$strCallToCustomer = 'Phone call to customer';
$strCallMustBeAssignedBeforeClosure = 'Call must be assigned before closure';
# Data Protection message, happy to receive phone calls
$strCallsOK = 'Calls OK';
$strCancel = 'Cancel';
$strCannotDeleteSkill = 'Sorry, this skill cannot be deleted because it has been associated with one or more incidents';
$strCannotResetThisPassword = 'You cannot reset this users password';
$strCannotResetPasswordInDemoMode = 'You cannot reset passwords while in DEMO MODE';
$strCannotWriteFile = 'Can\'t write to %s, you\'ll have to save the file manually.';
$strCategory = 'Category';
$strCause = 'Cause';
$strCC = 'CC';
$strChange = 'Change';
$strCannotEditUserAndRole = 'You cannot edit users and roles at the same time';
$strChangeExternalDetailsOnAllOpenForSelected = 'This will change the external engineer details for all open incidents for the external engineer you select.';
$strChangeStateFailed = 'Change state failed';
$strChangePassword = 'Change Password';
$strChangeTemporaryOwner = 'Change temporary owner';
$strChangeOwner = 'Change owner';
$strChangingContact = 'Changing the contact or skill will not reassign this incident to another contract';
$strCharsToKeepWhenTranslating = 'When translating, please do not translate anything that looks like the following: [b] {word} %s. These are placeholders, leave them in the appropriate place in your translated string';
# Chased to mean followed-up for information
$strChased = 'Chased';
$strCheckEnteredData = 'Please Check Entered Data';
$strCheckLDAPDetails = 'Check LDAP details';
$strCheckUserGroupMembership = 'check user group membership';
$strCheckWhoHasPermission = 'Check who has this permission';
$strCheckingDetails = 'Checking Details';
$strChooseLanguage = 'Please choose your language';
$strCity = 'City';
$strClearFilter = 'Clear filter';
$strClickOnDayToSelect = 'Click on day to select';
$strClickTitleHeaders = 'Click title headers to enable the sections';
# e.g. close an incident
$strClose = 'Close';
# e.g. incident is closed
$strClosed = 'Closed';
$strClosedAfterX = 'Closed after %s';
$strClosedBeforeX = 'Closed before %s';
$strClosedBy = 'Closed by';
$strClosedbyX = 'Closed by %s';
$strClosedOnX = 'Closed on %s';
$strCloseImmediately = 'Close Immediately';
$strCloseWindow = 'Close Window';
# i.e. the status at the time of closure
$strClosingStatus = 'Closing Status';
$strClosingThanks = 'Closing Thanks';
$strClosureRequested = 'Closure Requested';
$strClosureRequestForIncident = 'Closure request for Incident';
$strCode = 'Code';
$strCollapseData = 'Collapse Data';
$strConfiguration = 'Configuration';
$strConfigure = 'Configure';
$strConfirmNewPassword = 'Confirm New Password';
# noun, he is a contact
$strContact = 'Contact';
$strContactAddedSuccessfully = 'Contact Added Successfully';
$strContactID = 'Contact\'s ID';
$strContinue = 'Continue';
$strContactDetails = 'Contact Details';
$strContactRecordExists = 'A contact record already exists with that Surname and Email address';
$strContactResetPassword = 'Contact Reset Password';
$strContactNotes = 'Contact Notes:';
$strContacts = 'Contacts';
$strContactsForename = 'Contact\'s forename';
$strContactsPassword = 'Contact\'s plain text password (only available on account creation)';
$strContactsPhone = 'Contact\'s phone number';
$strContactsName = 'Contact\'s name';
$strContactsUsername = 'Contact\'s portal username';
$strContactHasBillableContract = 'Contact has a billable contract';
# e.g. 5 contacts
$strContactsMulti = '%d Contacts';
# i.e. legal agreement
$strContract = 'Contract';
$strContractAreYouSure = 'This incident will be logged against the customers CONTRACT. Are you sure you want to continue?';
$strContractDetails = 'Contract Details';
$strContractID = 'Contract ID';
$strContractProduct = 'The product associated with a contract';
$strContractNum = 'Contract %d';
$strContracts = 'Contracts';
$strContractsExpiredXdaysAgo = 'Contracts that expired up to %s days ago';
$strContractsExpiringWithinXdays = 'Contracts expiring within %s days';
$strContractsSLA = 'The service level of the contract';
$strControlPanel = 'Control Panel';
$strComplete = 'Complete';
$strCompleted = 'Completed';
$strCompletion = 'Completion';
$strCommentsSentWithRequest = 'The following comments were sent with the request';
$strComponentMustBePlacedInDashboardDir = 'Please note the component must has been placed in the dashboard directory and named %s';
$strCopyFrom = 'Copy From';
$strCreateANotice = 'Create a notice based on %s';
$strCreateANoticeWhen = 'Create a notice based on %s, when %s';
$strCreateANoticeForWhen = 'Create a notice based on %s for %s, when %s';
$strCreatedBy = 'Created by';
$strCreateNewForm = 'Create New Form';
$strCredit = 'Credit';
# e.g. Amount paid into an account
$strCreditAmount = 'Credit Amount';
# e.g. film credits
$strCredits = 'Credits';
$strCreateANotice = 'Create a notice based on %s';
$strCriteria = 'Criteria';
$strCritical = 'Critical';
$strCriticalPriority = 'Critical Priority';
# e.g. John Acme of ACME Widgets Co.
$strContactofSite = '%s of %s';
$strCompassionateLeave = 'Maternity/Paternity/Compassionate Leave';
$strCount = 'Count';
$strCountContractsByProduct = 'Count contracts by product';
# Region / State
$strCounty = 'County';
$strCountry = 'Country';
$strCourtesyTitle = 'Courtesy Title';
$strCreate = 'Create';
$strCSVfile = 'CSV (Comma Seperated) file';
$strCSVFileFormatAsFollows = 'CSV File format is as follows';
$strCurrentDate = 'Current Date';
$strCurrentLanguage = 'The current user\'s login language selection';
$strCurrentLanguageDiffers = 'Current Language Differs';
$strCurrentOwner = 'Current Owner';
$strCurrentUserEmailAddress = 'Email address of current user';
$strCurrentUsersSignature = 'Current Users Signature';
$strCurrentlyOpen = 'Currently Open';
$strCurrentlyNoOpenEscalatedIncidentsToModify = 'There are currently no escalated incidents to modify';
$strCustomer = 'Customer';
$strCustomerFeedback = 'Customer Feedback';
$strCustomerFeedbackReportSiteMsg = 'This report shows customer responses and a percentage figure indicating the overall positivity of customers toward incidents logged by the user(s) shown';
$strCustomerExport = 'Customer Export';
$strCustomerImpact = 'Customer Impact';
$strCustomerImpactCustomerText = 'How many users are affected by this issue? Is this an issue of downtime or a minor niggle? Does the issue prevent people from working?';
$strCustomerProductsMaintDesc = 'This report is a list of sites that you selected and the products they have (or have had) maintenance for';
$strCustomerReference = 'Customer Ref';
$strCustomerReferenceDate = 'Customer Ref Date';
$strCustomerReminded = 'Customer has been reminded';
$strCustomerRemindedByPhone = 'Customer has been reminded by phone';
$strCustomerReminderUpdate = 'Was this a customer reminder?';
$strCustomerRequestedClosure = 'Customer Requested Incident Closure';
$strCustomers = 'Customers';
# Visible for customers
$strCustomerVisible = 'Customer visible';

$strDailyRate = 'Daily Rate';
# i.e. place for widgets
$strDashboard = 'Dashboard';
$strDashboardComponentDoesntExist = 'Dashboard component %s doesn\'t exist';
$strDataProtection = 'Data Protection';
# i.e. 25th December
$strDate = 'Date';
$strDateAndTime = 'Date and Time';
$strDatesAre = 'Dates are';
$strDatesAwaitingApproval = 'Dates awaiting approval';
$strDatesNotRequested = 'Dates Not Requested';
$strDatesNotYetApproved = 'Dates not yet approved';
$strDay = 'Day';
$strDayOfMonth = 'day %s of each month';
$strDayOfYear = 'day %s of each year';
$strDays = 'Days';
$strDayView = 'Day View';
$strdaysother = 'days other leave';
$strdayssick = 'days sick leave';
$strdaystraining = 'days training';
$strdaysworkingaway = 'days working away';
$strDebit = 'Debit';
# Short for December
$strDecAbbr = 'Dec';
# Month number 12: December
$strDecember = 'December';
$strDecline = 'Decline';
$strDeclined = 'Declined';
$strDefault = 'Default';
$strDefaultNewEntitlement = 'Default new Entitlement';
$strDefaultSubstitute = 'Default Substitute';
$strDefineSubstituteEngineer = 'Define Substitute Engineer';
$strDefineSubstituteEngineersFor = 'Define Substitute Engineers For %s';
$strDelete = 'Delete';
$strDeleteContact = 'Delete Contact';
$strDeleteSite = 'Delete Site';
$strDeleteAllSpam = 'Delete all mail from spam queue';
$strDeleted = 'Deleted';
$strDeleteTask = 'Delete Task';
$strDenied = 'Denied';
$strDepartment = 'Department';
$strDescendingDateOrder = 'Descending date order';
$strDescription = 'Description';
$strDestinationService = 'Destination Service';
$strDetails = 'Details';
$strDetailsAndLog = 'Details and Log';
$strDetailsSend = 'Details sent';
$strDidYouPasteFullURL = 'Did you paste the full URL you received in the email?';
$strDidYourBrowserBlockPopupWindow = 'Did your browser block the popup windows?';
$strDifference = 'Difference';
$strDisassociateSkillWithProduct = 'Disassociate skill with a product';
$strDisable = 'Disable';
# i.e. not available
$strDisabled = 'Disabled';
$strDisclaimer = 'Disclaimer';
# i.e. make it go away
$strDismiss = 'Dismiss';
$strDismissAll = 'Dismiss All';
# i.e. show
$strDisplay = 'Display';
$strDisplaying = 'Displaying';
$strDisplayingXcontactMatchingY = 'Displaying %s contact(s) matching %s';
$strDisplayPreferences = 'Display Preferences';
$strDistribution = 'Distribution';
$strDocumentIDX = 'Document ID %s %s';
$strDoesNOTApply = 'Does NOT apply';
$strDoesThisUpdateMeetSLA = 'Does this update meet an SLA target?';
$strDoNothing = 'Do Nothing';
$strDraftChoose = 'Multiple drafts exist please select one';
$strDraftDelete = 'Delete Draft';
$strDraftEdit = 'Edit Draft';
$strDraftsEmailExist = 'Drafts Emails Exist';
$strDraftsExist = 'Drafts Exist';
$strDraftsUpdateExist = 'Drafts Updates Exist';
$strDraftLastSaved = 'Draft last saved';
$strDueDate = 'Due Date';
$strDueNow = 'Due Now';
# the noun; 'a duplicate'
$strDuplicate = 'Duplicate';
$strDurability = 'Durability';
$strDuration = 'Duration';
# When the passed duration is not the same as the entry in the database
$strDurationMismatch = 'Duration mismatch';
$strDurationUpdated = 'Duration updated';

$strEarliestExpiry = 'Earliest Expiry:';
# verb, i.e. to change
$strEdit = 'Edit';
$strEditContact = 'Edit Contact';
$strEditContract = 'Edit Contract';
$strEditFeedbackQuestion = 'Edit Feedback Question';
$strEditFTPdetailsUpload = 'Edit FTP File Details and Publish';
$strEditGlobalSignature = 'Edit Global Signature';
$strEdited = 'Edited';
$strEditedBy = 'Edited by %s';
$strEditBalance = 'Edit Balance';
$strEditEmail = 'Edit email';
$strEditEscalationPath = 'Edit Escalation Path';
$strEditEscalationPathFailed = 'Edit Escalation Path Failed';
$strEditHolidays = 'Edit Holidays';
$strEditHolidayEntitlement = 'Edit Holiday Entitlement';
$strEditKBArticle = 'Edit Knowledge Base Article';
$strEditProduct = 'Edit Product';
$strEditProfile = 'Edit Profile';
$strEditProfileFor = 'Edit User Profile for %s';
$strEditRole = 'Edit Role';
$strEditRSSAtomFeed = 'Edit RSS/Atom feed';
$strEditService = 'Edit Service';
$strEditServiceLevel = 'Edit Service Level';
$strEditSite = 'Edit Site';
$strEditSiteType = 'Edit Site Type';
$strEditSkill = 'Edit Skill';
$strEditTask = 'Edit Task';
$strEditTemplate = 'Edit Template';
$strEditUserSkills = 'Edit User Skills';
$strEditVendor = 'Edit Vendor';
$strEditWatchedIncidents = 'Edit Watched Incidents';
# Punctuation mark 'Ellipsis' to indcate an unfinished phrase or sentence. (dot dot dot "..." in English)
$strEllipsis = '&hellip;';
$strEmail = 'Email';
$strEmailAddress = 'Email Address';
# Do you want to send an email with login details to the contact?
$strEmailContactLoginDetails = 'Send an email to contact with login details?';
$strEmailDetails = 'Email details';
# eg novell.com
$strEmailDomain = 'Email Domain';
$strEmailFromCustomer = 'Email from customer';
$strEmailMustBeUnique = 'Email must be unique';
$strEmailOK = 'Email OK';
$strEmailReceivedAbbrev = 'Email Rx';
$strEmailreceivedby = 'Email received by %s';
$strEmailsentby = 'Email sent by %s';
$strEmailSendFeedbackDesc = 'Sends a request to the incident owner to complete a feedback form.';
$strEmailSent = 'Email Sent';
$strEmailSettings = 'Email Settings';
$strEmailSignature = 'Email Signature';
$strEmailTemplate = 'Email Template';
$strEmailToCustomer = 'Email to customer';
$strEmailTransmittedAbbrev = 'Email Tx';
$strEmailIncidentClosureDesc = 'Notifies contact that the incident has been marked for closure and will be closed shortly';
$strEmailIncidentLoggedContactDesc = 'Acknowledge the contact\'s contact and notify them of the new incident number';
$strEmailIncidentOutOfSlaDesc = 'Notifies when an incident has gone out of SLA';
$strEmailIncidentOutOfReviewWDesc = 'Notify when an incident\'s review is due';
$strEmailIncidentCreatedUserDesc = 'Notifies a user that an incident has been logged';
$strEmailIncidentReassignedUserNotifyDesc = 'Notifies user when call is assigned to them';
$strEmailIncidentRequestClosedDesc = 'Notifies a user when an incident has been requested as closed';
$strEmailIncidentNearingSlaDesc = 'Notify when an incident nears its SLA target';
$strEmailContactResetPasswordDesc = 'Sent to a contact to reset their password';
$strEmailUserResetPasswordDesc = 'Notifies when a user resets their email';
$strEmailNewContactDetailsDesc = 'Notifies when a new contact is created';
$strEmailIncidentReviewDueDesc = 'Email sent when a review is due for an incident';
$strEmailKbArticleCreatedDesc = 'Notifies a user when a new knowledge base article is created';
$strEmailHeldEmailReceivedDesc = 'Notifies of a new held email';
$strEmailHeldEmailMinsDesc = 'Notifies when there\'s been an email in the holding queue for X minutes';
$strEmailUserChangedStatusDesc = 'Notifies that an engineer has changed their status';
$strEmailSitUpgradedDesc = 'Notifies of system upgrade';
$strEmailContactCreatedDesc = 'Notifies of a new contact';
$strEmailIncidentClosedContactDesc = 'Notifies the contact that their incident is closed';
$strEmailIncidentClosedUserDesc = 'Notifies an engineer when an incident is closed';
$strEmailContractAddedDesc = 'Notifies of when an new contract is added';
$strEmailUserCreatedDesc = 'Notifies when a new system user is added';
$strEmailSiteCreatedDesc = 'Notifies when a new site is added';
$strEmailExternalIncidentClosureDesc = 'Notifies an external engineer of an incident being closed';
$strEmailHolidaysRequestedDesc = 'Notifies a user that they need to approve holidays';
$strEmailServiceLevelDesc = 'Notifies the site\'s salesperson when the value drops below a certain limit';
$strEmailIncidentUpdatedCustomerDesc = 'Sent to a customer when an engineer updated an incident';
$strEmailSupportEmailDesc = 'Used by default when you send an email from an incident';
$strEmailTaskDueDesc = 'Sends an email of a due task.';
$strEnabled = 'Enabled';
$strEndDate = 'End Date';
$strEndOfLife = 'End of Life';
$strEngineer = 'Engineer';
$strEngineers = 'Engineers';
$strEngineerMonthlyActivityTotals = 'Engineer Monthly Activity Totals';
$strEngineersStatisticsForXMonths = 'Engineer Statistics for %s months';
$strEngineerUtilisation = 'Engineer Utilisation';
$strEnglish = 'English';
$strEnterCredentials = 'Enter your credentials to login to %s';
$strEnterDetailsAboutIncidentToBeStoredInLog = 'Enter some details about the incident to be stored in the incident log for future use.';
$strEnterNumericValue = 'You must enter a numeric value';
$strEnterNumberOfDays = 'You must enter a number of days';
$strEnterTheIncidentID = 'Enter the Incident ID';
$strEnterTheCallID = 'Enter the incident number';
$strEntitlement = 'Entitlement';
#computer environment
$strEnvironment = 'Environment';
# Acronym for end of life
$strEOL = 'EOL';
$strError = 'Error';
$strErrorAssigningUpdate = 'Error assigning that incident update. This could be because no incident exists with that ID or the incident has been closed.';
$strErrorNoEmptyForm = 'Error, could not locate empty form to store results.';
$strErrorRequiredQuestionsNotCompleted = 'Error: you did not complete all required questions, please check your answers and try again.';
$strErrorSendingEmail = 'Error sending email';
$strErrorUploading = 'Error uploading';
$strEscalated = 'Escalated';
$strEscalatedIncidents = 'Escalated Incidents';
$strEscalation = 'Escalation';
$strEscalationPaths = 'Escalation Paths';
$strEvent = 'Event';
$strEverybodysTasks = 'Everybody\'s Tasks';
$strExceeded = 'Exceeded';
$strExclude = 'Exclude';
$strExcludeSitesWith = 'Exclude sites with';
$strExpire = 'Expire';
$strExpired = 'Expired';
$strExpiryDate = 'Expiry Date';
$strExpiryDateCannotBeInThePast = 'Expiry Date Cannot be in the past';
$strExternalEmail = 'External Email';
$strExternalEngineer = 'External Engineers';
$strExternalEngineerEmail = 'External Engineers Email';
$strExternalEngineersFirstName = 'External Engineers First Name';
$strExternalEngineersName = 'External Engineers Name';
$strExternalEscalation = 'External Escalation';
$strExternalEngineerCallDistribution = 'External Engineer Call Distribution';
$strExternalID = 'External ID';
$strExternalInfo = 'External Information';
$strExternalInfoAddedBy = 'External Information added by %s';

$strFailed = 'Failed';
$strFailedOnPass2 = 'failed on pass 2';
$strFailedtoApproveTransactID = 'Failed to approve transaction ID';
$strFailedToFindDateIncidentClosed = 'Failed to find date incident closed';
$strFatalError = 'Fatal Error';
$strFax = 'Fax';
$strFeatures = 'Features';
# Short for February
$strFebAbbr = 'Feb';
# Month number 2: February
$strFebruary = 'February';
$strFeedback = 'Feedback';
$strFeedbackAfterX = 'Feedback after %s';
$strFeedbackBeforeX = 'Feedback before %s';
$strFeedbackBetweenXandY = 'Feedback between %s and %s';
$strFeedbackForm = 'Feedback Form';
$strFeedbackForms = 'Feedback Forms';
$strFeedbackReport = 'Feedback Report';
$strFeedbackFormsRequested = 'There are %s feedback forms that have been returned already';
$strFeedbackFormsWaiting = 'There are %s feedback forms that have not been returned yet';
$strFeedbackRequested = 'Feedback Requested but not yet received for form';
$strFeedbackURL = 'Feedback URL';
# e.g. rss feeds
$strFeeds = 'Feeds';
$strFeedIcon = 'Feed Icon';
$strFewMinutesAgo = 'A few minutes ago';
# e.g. spreadsheet field
$strField = 'Field';
$strField1 = 'Field 1';
$strField2 = 'Field 2';
$strField3 = 'Field 3';
$strField4 = 'Field 4';
$strField5 = 'Field 5';
$strField6 = 'Field 6';
$strField7 = 'Field 7';
$strField8 = 'Field 8';
$strField9 = 'Field 9';
$strField10 = 'Field 10';
$strField11 = 'Field 11';
$strField12 = 'Field 12';
$strFieldMustNotBeBlank = 'The form field %s must not be left blank';
# e.g. form fields
$strFields = 'Fields';
$strFileManagement = 'File Management';
$strFilename = 'Filename';
$strFile = 'File';
# e.g. computer files
$strFiles = 'Files';
$strFileDate = 'File Date';
$strFileSavedAs = 'File saved as: %s';
$strFileUploaded = 'File uploaded';
$strFileVersion = 'File Version';
# e.g. File filename.txt (Text file 100 bytes) uploaded OK
$strFileXUploadedOK = 'File %s (%s %d bytes) uploaded OK';
$strFilter = 'Filter';
$strFilterActiveOnlyShowingIncidentsForX = 'Filter active: only displaying incidents for %s';
$strFinalUpdate = 'Final Update';
$strFinalSolutionby = 'Final Solution by %s';
$strFindContact = 'Find Contact';
$strFirstCustomerVisibleUpdate = 'The first customer visible update in the incident log';
$strFollowingSpecialIdentifiers = 'The following special identifiers can be used in these fields:';
$strFollowThisLink = 'follow this link';
#e.g. for a person
$strFor = 'for';
$strForce = 'Force';
$strForceTo = 'Force To';
$strForenames = 'Forenames';
$strForFurtherAssistance = 'For further assistance please contact %s';
$strForgottenDetails = 'Forgotten your details?';
$strForIncident = 'For Incident';
$strForThePeriodXToY = 'For the period %s to %s';
$strForgottenPasswordDetails = 'Forgotten Password Details';
$strForm = 'Form';
$strFormInvalidExpired = 'The form was invalid. This is probably because the form expired before you submitted it, please try again.';
$strForRefundsThisShouldBeNegative = 'For refunds this should be negative';
$strForwardOneYear = 'Forward One Year';
$strForXDaysHoursMinutes = 'For <em>x</em> days, hours, minutes';
$strFoundNoUsersToReport = 'Found No Users To Report On';
$strFreeOfCharge = 'Free of Charge';
$strFrequency = 'Frequency';
# Short for 'Friday'
$strFri = 'Fri';
$strFriday = 'Friday';
# Two character (Maximum) abbreviation for 'Friday'
$strFridayAbbr = 'Fr';
# e.g. from x to y
$strFrom = 'From';
$strFromXResults = 'from %s results';
# FTP - File Transfer Protocol
$strFTP = 'FTP';
$strFTPFailedCreatingDirectoryX = 'FTP Failed creating directory %s';
$strFTPFileDetails = 'FTP File Details';
$strFTPFileXUploaded = 'FTP file %s uploaded';
$strFTPFilesDB = 'FTP Files DB';
$strFTPPublish = 'FTP Publish';
$strFullDay = 'Full Day';
$strFullDetails = 'Full Details';
$strFullNameCurrentUser = 'Full name of current user';

$strGBytes = 'GBytes';
$strGeneral = 'General';
$strGetHelpOnline = 'Get Help Online';
$strGlobalSignature = 'Global Signature';
$strGlobalSignatureDescription = 'A signature to insert at the bottom of outgoing emails.  It\'s recommended that you begin this signature with two dashes, a space and a line feed.';
$strGlobalSignatureRemember = 'Remember that any changes here will be effective immediately and outgoing emails will carry the new signature.';
$strGo = 'Go';
$strGracePeriod = 'Grace Period';
$strGrandTotal = 'Grand Total';
$strGroup = 'Group';
$strGroupMembersAway = 'Group Members Away';
$strGroupMembership = 'Group Membership';

$strHandled = 'Handled';
# Incident 3 has been automatically moved to John's Action Needed queue, three %s variables in this: incident number, queue name, users name
$strHasBeenAutoMovedToX = '%s has been automatically moved to %s\'s %s queue';
# Incident 3 has been moved to John's Action Needed queue, three %s variables in this: incident number, queue name, users name
$strHasBeenMovedToX = '%s has been moved to %s\'s %s queue';
$strHAVESkills = 'HAVE Skills';
$strHeldEmailsNum = '%d Held Emails';
$strHelp = 'Help';
$strHelpAbout = 'About';
# A single character (e.g. question mark) used as a Help link,
$strHelpChar = '?';
$strHelpContents = 'Help Contents';
$strHelpToTranslate = 'This page is to help translators translate SiT!';
$strHide = 'Hide';
$strHideInPortal = 'Hide from portal';
$strHidingIncidentsOlderThan = 'Hiding incidents older than %s days';
$strHigh = 'High';
$strHigherPriority = 'Higher Priority';
$strHighPriority = 'High Priority';
$strHoldingQueue = 'Holding Queue';
$strHoldingQueueMinutes = 'Number of minutes the email has been in the holding queue';
$strHoliday = 'Holiday';
$strHolidayAfternoon = 'Make this afternoon only';
$strHolidayAfternoonOnly = 'Holiday this afternoon only';
$strHolidayAfternoonOnlyConfirm = 'Are you sure you want to make this afternoon only?';
$strHolidayApproverEmail = 'Email address of the holiday approver';
$strHolidayCancelConfirm = 'Are you sure you want to cancel this?';
$strHolidayCancel = 'Cancel this holiday';
$strHolidayFullDayConfirm = 'Are you sure you want to make this for the full day?';
$strHolidayFullDay = 'Make this for the full Day';
$strHolidayList = 'Holiday List';
$strHolidayMorningOnly = 'Make this morning only';
$strHolidayMorningOnlyConfirm = 'Are you sure you want to make this morning only?';
$strHolidays = 'Holidays';
$strHolidayEntitlement = 'Holiday Entitlement';
$strHolidayPlanner = 'Holiday Planner';
$strHolidayRequested = 'Holiday Requested';
$strHolidayRequests = 'Holiday Requests';
$strHolidayType = 'Holiday Type';
$strHolidayUsage = 'Holiday Usage';
$strHomeURL = 'Home URL';
$strHours = 'Hours';

# i.e. short for identification; unique number
$strID = 'ID';
$strIfYourBrowserNotReload = 'If your browser does not reload the page within a few seconds';
$strIfYouShouldHaveAccess = 'If you feel that you should have access to this particular feature, please ask an administrator to grant you access';
$strImportant = 'Important';
$strInactive = 'Inactive';
$strInbound = 'Inbound';
$strInboundEmailIsDisabled = 'Inbound email is disabled in your SiT configuration';
$strInbox = 'Inbox';
$strIncident = 'Incident';
$strIncidentActivitiesIntro = 'This page is to keep track of activities relating to an incident where time spent dealing with the incident needs to be known';
$strIncidentAdded = 'Incident Added';
$strIncidentAssigned = 'Incident Assigned';
$strIncidentAssignmentWasForcedUserNotAccept = 'Incident assignment was forced because the user was not accepting';
$strIncidentsBySiteReportDesc = 'This report is a list of %s incidents for all sites that you selected';
$strIncidentCCList = 'Extra email addresses to CC regarding incidents';
$strIncidentClosed = 'Incident Closed';
$strIncidentCreated = 'Incident Created';
$strIncidentEmail = 'Incident Email';
$strIncidentEscalatedReportDesc = 'This report is a list of %s incidents for your selections of which %s where escalated';
$strIncidentID = 'Incident ID';
$strIncidentIsOpen = 'The incident is open and awaiting action';
$strIncidentLogOrder = 'Incident Log Order';
$strIncidentLoggedEngineer = 'An incident has now been added as incident number %s and logged to your account, you should now assign an engineer who is to deal with the incident';
$strIncidentMonitor = 'Incident Monitor';
$strIncidentNearingSLA = 'Incident Nearing SLA target time';
$strIncidentNoContract = 'This incident is not logged under contract';
$strIncidentNum = 'Incident %d';
$strIncidentNumOrSearchTerm = 'Incident # or search term';
# Abbreviation of incidents per owner
$strIncidentPerOwnerAbbrev = 'inc per owner';
$strIncidentPool = 'Incident Pool';
$strIncidentRate = 'Incident Rate';
$strIncidentPriority = 'Incident Priority';
$strIncidentRefresh = 'Incident Refresh';
$strIncidentResolved = 'The incident has been resolved or reprioritised.\nThe issue should now be brought to a close or a new problem definition created within the service level';
$strIncidentReviewDue = 'Incident Review Due';
$strIncidentTypeWasBlank = 'Incident type was blank';
$strIncidentUpdatedExternally = 'Incident Updated Externally';
$strIncidentUpdatedExternallyDesc = 'Occurs when an incident is updated by someone external';
$strIncidentUpdatedInternally = 'Incident Updated Internally';
$strIncidentUpdatedInternallyDesc = 'Occurs when an incident is updated by someone internal';
$strIncidents = 'Incidents';
$strIncidentsAvailable = 'Incidents Available';
$strIncidentsByEngineer = 'Incidents By Engineer';
$strIncidentsBySite = 'Incidents By Site';
$strIncidentsBySkill = 'Incidents By Skill';
$strIncidentsByVendor = 'Incidents By Vendor';
$strIncidentsClosedToday = '%s Incidents Closed Today';
$strIncidentsContactEmail = 'Email address of incident contact';
$strIncidentsDailySummary = 'Incidents Daily Summary';
$strIncidentsForEngineer = 'Incidents for %s (Engineer)';
$strIncidentsinQueue = 'Incidents in Queue';
$strIncidentsList = 'Incidents List';
$strIncidentsLoggedOpenClosed = 'Incidents Logged (Open/Closed)';
$strIncidentsLoggedToday = '%s Incidents Logged Today';
$strIncidentsMulti = '%s Incidents';
$strIncidentsOpenedEachDay = 'This report shows how many incidents were opened each day. Hover your mouse over each bar to see the daily figures.';
$strIncidentsRequiringReminderByPhone = 'Incidents requiring a reminder by phone';
# e.g. Incidents opened on 2007-12-03
$strIncidentsVerbOnDate = 'Incidents %s on %s';
# e.g. Incidents opened between 2007-12-03 and 2007-12-04
$strIncidentsVerbBetweenDates = 'Incidents %s between %s and %s';
$strIncidentOwnerID = 'Incident owner\'s ID';
$strIncidentOwnersFullName = 'Full name of the person who owns the incident';
$strIncidentOwnersEmail = 'Email address of the incident owner';
$strIncidentsUsed = 'Incidents Used';
$strIncidentTitle = 'Incident Title';
$strIncidentUpdatesPerPage = 'Incident Updates per page';
$strIncidentXIsClosed = 'Incident %s is closed';
$strInclude = 'Include';
$strIncoming = 'Incoming';
$strIncomingEmail = 'Incoming Email';
$strIncomingEmailSpam = 'Incoming email that is suspected to be spam';
$strIncomingEmailText = 'Incoming email that could not be handled automatically';
$strInfo = 'Info';
$strInformationSent = 'Information Sent';
$strInformationSentRegardingSettingPassword = 'We have sent instructions for setting a new password to the email address provided.';
$strInformX = 'Inform %s';
$strInitialResponse = 'Initial Response';
# e.g. An abbreviated version of 'Initial Response'
$strInitialResponseAbv = 'IR';
$strInitialResponseBy = 'Initial Response by %s';
$strInitialResponseHasBeenMade = 'The Initial Response has been made';
$strInMeeting = 'In Meeting';
$strInMinutes = 'in minutes';
$strInOffice = 'In Office';
$strInOrderToDelete = 'In order to delete this record you must select another to receive the related objects';
$strInstall = 'Install';
$strInstallDashboardComponents = 'Install new dashboard component';
$strInterfaceStyle = 'Interface Style (Theme)';
$strInternalEngineer = 'Internal Engineer';
$strInternalEscalation = 'Internal Escalation';
$strInternalUseNotDisplayed = 'For Internal Use, not displayed';
$strInterval = 'Interval';
$strIntroduction = 'Introduction';
$strInvalidCredentials = 'Invalid username/password combination';
$strInvalidDetails = 'Invalid Details';
$strInvalidEmailAddress = 'Invalid email address';
$strInvalidParameter = 'Invalid parameter';
$strInvalidUserID = 'Invalid user id';
$strInvalidUsername = 'Invalid username, please try another';
$strInventory = 'Inventory';
$strInventoryDesc = 'The inventory is a catalogue of site objects such as workstations, software, remote access etc., that belong to sites';
$strInventoryItems = 'Inventory Items';
$strIgnore = 'Ignore';
$strIgnoreThisAndDelete ='Ignore this reassignment and delete this notice';

# short for January
$strJanAbbr = 'Jan';
# Month number 1: January
$strJanuary = 'January';
$strJobTitle = 'Job Title';
$strJournal = 'Journal';
# Short for July
$strJulAbbr = 'Jul';
# Month number 7: July
$strJuly = 'July';
$strJumpTo = 'Jump to';
$strJumpToEntryLog = 'Jump to the entry log here';
$strJumpToIncident = 'Jump to Incident';
# Short for June
$strJunAbbr = 'Jun';
# Month number 6: June
$strJune = 'June';
# i.e. A moment ago
$strJustNow = 'Just Now';

# Abbreviation for Knowledge base
$strKBabbr = 'KB';
$strKBytes = 'KBytes';
$strKBID = 'ID of the knowledge base article';
$strKeepCurrentLanguage = 'Keep current language';
#e.g. graph legend
$strKey = 'Key';
$strKeywords = 'Keywords';
$strKnowledgeBase = 'Knowledge Base';
$strKnowledgeBaseArticle = 'Knowledge Base Article';
$strKnowledgeBaseArticleCreated = 'Knowledge Base Article Created';
$strKnowledgeBaseArticles = 'Knowledge Base Articles';

$strLanguage = 'Language';
$strLatestExpiry = 'Latest Expiry:';
# Last date a bill was generated
$strLastBilled = 'Last Billed';
$strLastModifiedBy = 'Last modified by';
$strLastMonth = 'Last month';
# Last time an action was executed
$strLastRan = 'Last Ran';
$strLastUpdated = 'Last Updated';
# The previous week to this one
$strLastWeek = 'Last week';
# The previous year to this one
$strLastYear = 'Last year';
# LDAP - Lightweight Directory Access Protocol
$strLDAP = 'LDAP';
$strLDAPTestSucessful = 'LDAP Connection Sucessful';
$strLDAPTestFailed = 'LDAP Connection Failed';
$strLeaveBlankForNewSection = 'When this question starts a new section enter information here and it will be shown above the question or leave this blank for no new section';
$strLength = 'Length';
$strLicense = 'Licence';
$strLicenseAndCopyright = 'Licence &amp; Copyright Information';
$strLicenseType = 'Licence Type';
$strLicenseQuantity = 'Licence Quantity';
$strLifetime = 'Lifetime';
$strLink = 'Link';
$strLinkedSkills = 'Linked Skills';
$strLinkedToNumProducts = 'Linked to # Products';
$strLinkProducts = 'Link Products';
$strLinkText = 'Link Text';
$strLinks = 'Links';
$strLimit = 'Limit';
$strLimitTo = 'Limit to';
$strList = 'List';
$strListsAllTheCustomersProducts = 'Lists all the customers products regardless of selections made above';
$strListOfHolidays = 'A list of holidays being requested';
$strListProducts = 'List Products';
$strListShowsContacts = 'This list shows contacts that matched your search, if site-support is available you can add incidents for the site';
$strListShowsContracts = 'This list shows contracts, i.e. supported contacts and the products they are supported for. Click on the appropriate \'%s\' link to begin adding the incident';
$strListSkills = 'List Skills';
$strLinkSkillToX = 'Link skill to %s';
$strLoading = 'Loading';
# Parameters defining location, language and regional preferences
$strLocale = 'Locale';
$strLocation = 'Location';
$strLock = 'Lock';
$strLocked = 'Locked';
$strLockedByX = 'Locked by %s';
$strLoggedExternally = 'Logged externally';
$strLogged = 'Logged';
# E.g. Logged in as: admin, currently On Holiday and Not Accepting calls
$strLoggedInAsXAndCurrentlyXAndX = 'Logged in as: %s, currently %s and %s';
$strLoggedUnder = 'This incident is logged under contract %d';
# Title for sign in page
$strLogIn = 'Log In';
# Label on sign in button
$strLogin = 'Login';
# Label on sign out button
$strLogout = 'Logout';
$strLogTriggerInJournal = 'Log the trigger in the system journal';
$strLow = 'Low';
$strLowPriority = 'Low Priority';

$strMaintenance = 'Maintenance';
$strMakeVisibleInPortal = 'Make visible in portal';
$strMap = 'Map';
$strManageDashboardComponents = 'Manage Dashboard Components';
$strManageEmailTemplates = 'Manage Email Templates';
$strManageFTPFiles = 'Manage FTP Files';
$strManageUsers = 'Manage Users';
$strManageYourDashboard = 'Manage your Dashboard';
$strMandatoryMarked = 'Mandatory fields are marked %s';
$strManyThanks = 'Many thanks to everybody that has offered comments, ideas, suggestions, bug reports and helped with testing or has contributed code. In particular thanks go to: (in random order)';
# Short for March
$strMarAbbr = 'Mar';
# Month number 3: March
$strMarch = 'March';
$strMarkComplete = 'Mark Complete';
$strMarkedComplete = 'Marked Complete';
$strMarkedforclosure = 'Marked for closure';
$strMarkedforclosureby = 'Marked for closure by %s';
$strMarketingMailshot = 'Marketing Mailshot';
$strMarketingMailshotDesc = 'This report is a list of details for all customers that currently (or previously) have contracts for the products you selected but none of the products excluded';
$strMarkForClosure = 'Mark for Closure';
$strMaxCarryOverXDays = 'Max Carry-over %s days';
$strMaxInputVars = 'PHP Error: set \'max_input_vars {miv}\' or more in php.ini';
$strMaxResults = 'A maximum of %d results are displayed, your search might have returned more.';
# Short for the month of May (these happen to be the same in english)
$strMayAbbr = 'May';
# Month number 5: May
$strMay = 'May';
$strMaxVersion = 'Maximum Version';
$strMBytes = 'MBytes';
$strMedium = 'Medium';
$strMediumPriority = 'Medium Priority';
$strMenu = 'Menu';
$strMessage = 'Message';
# As in "The target was met"
$strMet = 'Met';
$strMidnight = 'Midnight';
$strMine = 'Mine';
$strMinutes = 'minutes';
$strMinVersion = 'Minimum Version';
$strMobile = 'Mobile';
# Short for 'mobile'
$strMob = 'Mob';
# Short for 'Monday'
$strMon = 'Mon';
$strMonday = 'Monday';
# Two character (Maximum) abbreviation for 'Monday'
$strMondayAbbr = 'Mo';
$strMonth = 'Month';
$strMonthly = 'Monthly';
$strMonthlyActivityTotals = 'Monthly Activity Totals';
$strMonthBreakdown = 'Month Breakdown';
$strMonthView = 'Month View';
$strMore = 'More...';
$strMoreContactsThanContractSupports = 'There are more contacts linked than this contract should support';
$strMorning = 'Morning';
$strMoveUpdate = 'Move Update';
$strMovedFromXtoXbyX = 'Moved from %s -&gt; %s by %s';
$strMultipleActivitiesRunning = 'Multiple Activities Running';
$strMultipleOptions = 'Multiple Options';
$strMustCompleteActivitiesBeforeClosure = 'You must complete all activities for the incident before closure.';
$strMyDashboard = 'My Dashboard';
$strMyDetails = 'My Details';
$strMyHolidays = 'My Holidays';
$strMyIncidents = 'My Incidents';
$strMyNotifications = 'My Notifications';
$strMyProfile = 'My Profile';
$strMySkills = 'My Skills';
$strMySubstitutes = 'My Substitutes';
$strMyTriggers = 'My Triggers';

$strName = 'Name';
$strNamedContacts = 'Named Contacts';
#English suffix for second - 2nd
$strnd = 'nd';
$strNeedsSubstitueEngineers = '%s need substitute engineers to be defined';
$strNegative = 'Negative';
$strNever = 'Never';
$strNewContact = 'New Contact';
$strNewContract = 'New Contract';
$strNewDuration = 'New Duration';
$strNewEmail = 'New Email (none of the above)';
$strNewEntitlement = 'New Entitlement';
$strNewEscalationPath = 'New Escalation Path';
$strNewHeldEmail = 'New Held Email';
$strNewestAtBottom = 'Newest at the bottom';
$strNewestAtTop = 'Newest at the top';
$strNewIncidentStatus = 'New Incident Status';
$strNewKBArticle = 'New Article';
$strNewNoteByX = 'New Note by %s';
$strNewPassword = 'New Password';
$strNewProduct = 'New Product';
$strNewReseller = 'New Reseller';
$strNewPriority = 'New Priority';
$strNewService = 'New Service';
$strNewSite = 'New Site';
$strNewSiteType = 'New Site Type';
$strNewSkill = 'New Skill';
$strNewStatus = 'New Status';
$strNewTemplate = 'New Email Template';
$strNewUser = 'New User';
$strNext = 'Next';
$strNextAction = 'Next Action';
# Next time a scheduled task is scheduled to run
$strNextRun = 'Next Run';
$strNextSLATarget = 'The next SLA target';
$strNextUpdate = 'Next Update';
# No being the opposite of Yes
$strNo = 'No';
$strNobody = 'Nobody';
$strNoAnswerGiven = 'No Answer Given';
$strNoActionSpecified = 'No action specified';
$strNoBillableIncidents = 'No Billable Incidents';
$strNoFiles = 'No Files';
$strNoneAvailable = 'None Available';
$strNonTerminatedContractsExpiredXdaysAgo = 'Non-Terminated Contracts that expired up to %s days ago';
$strNoCalls = 'No Calls';
$strNoChangesToMake = 'No changes to make';
$strNoContactsForSite = 'There are no contacts associated with this site';
$strNoContractsForSite = 'There are no contracts associated with this site';
$strNoContractsFound = 'No Contracts Found';
$strNoDashletsInstalled = 'There are no dashlets installed, please ask your administrator to install some';
$strNoDurationOnActivity = 'No duration on activity';
$strNoEmail = 'No Email';
$strNoEmailSet = 'You have no email address set, you must set one now';
$strNoFeedbackFound = 'No Feedback Found';
$strNoFeedbackFormsDefined = 'No Feedback Forms Defined';
$strNoFeedBackFormToCompleteHere = 'There is no feedback form waiting to be completed at this address, this could be because you have already provided feedback.  Please check that the URL you entered is correct.';
$strNoFeedsCurrentlyPresent = 'No feeds currently present';
$strNoHolidayEntitlement = 'No holiday entitlement remaining for this year';
$strNoIncidents = 'No Incidents';
$strNoIncidentsBeingWatchOfType = 'No watches set up for this type';
$strNoLicense = 'No Licence';
$strNoLongerRelevant = 'No Longer Relevant';
$strNoMatchingTaskFound = 'No Matching Task Found';
$strNoNameAssociated = 'No Name Associated';
$strNoSLA = 'No SLA';
$strNone = 'None';
$strNoNewDashboardComponentsToInstall = 'No new dashboard components available';
$strNoMatchingTask = 'No Matching Task Found';
$strNoMatchingProduct = 'No Matching Product';
$strNoOpenIncidents = 'No Open Incidents';
$strNoOrphandedContacts = 'No orphanded contacts';
$strNotificationEmail = 'Notification Email';
$strNotifications = 'Notifications';
$strNotificationsMovedToTriggersPage = 'Notifications have been moved to the Triggers page';
$strNotifyContact = 'Notify Contact';
$strNotifyContactEmail = 'The notify contact email of a contact (if set)';
$strNotifyContactOnClose = 'Whether the user requested to send a closing email (true or false)';
$strNotifyExternalEngineerOnClose = 'Whether the user requested to send a closing email to the external engineer (true or false)';
$strNotEscalated = 'Not Escalated';
$strNoServiceWithIDXFound = 'No service with ID %s found';
$strNoPermission = 'You do not have permission to view this page';
$strNoPost = 'No Post';
$strNoProductInfo = 'No Product Info';
$strNoProductsForThisVendor = 'No products for this vendor';
$strNoPublicTasks = 'No Public Tasks';
$strNoRecords = 'No Records';
$strNoReseller = 'No Reseller';
$strNoResponseFound = 'No Response Found';
$strNoResults = 'No Results';
$strNoResultsFor = 'No results for %s';
$strNoRoleSpecified = 'No role specified';
$strNoSchemaAvailableToUpgrade = 'No schema available to upgrade';
$strNOSkills = 'NO Skills';
$strNoSkillsDefined = 'NO Skills defined';
$strNoSkillsLinkedToProduct = 'No skills linked to product';
$strNoSubstitute = 'No substitute engineer set';
$strNoSubstitutes = 'No substitute engineers set';
$strNoTransactionsMatchYourSearch = 'No transactions match your search';
$strNoTransactionsFoundWithID = 'No transaction found with ID';
$strNoUpgradesForDashboardComponent = 'No upgrades for %s dashboard component';
$strNoTasks = 'No Tasks';
$strNotAccepting = 'Not Accepting';
$strNotAcceptingIncidents = '<strong>Not accepting</strong> incidents';
# Short for not applicable
$strNotApplicableAbbrev = 'N/A';
$strNotApproved = 'Not Approved';
$strNotCompleted = 'Not Completed';
$strNoticeTemplate = 'Notice Template';
$strNote = 'Note';
$strNoteAddedBy = 'Note added by %s';
$strNoteInsertExternalID = 'Note: insert \'%externalid%\' for automatic incident number insertion';
$strNotes = 'Notes';
$strNothingToDisplay = 'Nothing to Display';
$strNothingToLink = 'Nothing to link';
$strNotice = 'Notice';
$strNoticeIncidentAssignedDesc = 'Notifies of an incident assigned to an engineer';
$strNoticeIncidentAssigned = '{incidentpriority} priority incident {incidentid} - {incidenttitle} logged by {contactname} of {sitename} has been assigned to {incidentowner}';
$strNoticeIncidentClosedDesc = 'Notifies of an incident closure';
$strNoticeIncidentClosed = '{incidentid} - {incidenttitle} has been closed by {userrealname}';
$strNoticeIncidentCreatedDesc = 'Notifies of an incident created';
$strNoticeIncidentCreated = '{incidentpriority} priority incident {incidentid} - {incidenttitle} logged by {contactname} of {sitename}';
$strNoticeIncidentNearingSLADesc = 'Notifies of a nearing Incident SLA';
$strNoticeIncidentNearingSLA = '{incidentowner}\'s incident {incidentid} - {incidenttitle}: {nextsla} due';
$strNoticeIncidentReviewDueDesc = 'Notifies of a nearing Incident review';
$strNoticeIncidentReviewDue = '{incidentowner}\'s incident {incidentid} - {incidenttitle} is due for review';
$strNoticeIncidentRequestClosedDesc = 'Notifies a user when an incident has been requested as closed';
$strNoticeIncidentRequestClosed ='{incidentid} has been requested as closed';
$strNoInicdentsToApprove = 'No Incidents to approve';
$strNoticeKBCreatedDesc = 'Notifies of a new KB article';
$strNoticeKBCreated = 'KB Article {kbname} has been created by {userrealname}';
$strNoticeLanguageDiffersDesc = 'Notifies a user that they\'re using a different language to their profile';
$strNoticeLanguageDiffers = 'Your current language ({currentlang}) is different from your profile language ({profilelang})';
$strNoticeMinsHeldEmailDesc = 'Notifies that an email has been in the holding queue for X minutes';
$strNoticeMinsHeldEmail = 'There has been an email in the holding queue for {holdingmins} minutes';
$strNoticeNewContactDesc = 'Notifies of a new contact added';
$strNoticeNewContact = '{contactname} has been added as a contact to {sitename} by {userrealname}';
$strNoticeNewHeldEmailDesc = 'Notifies of a new email in the holding queue';
$strNoticeNewHeldEmail = 'There is a new email in the holding queue';
$strNoticeNewContractDesc = 'Notifies of a new contract';
$strNoticeNewContract = '{contractproduct} contract has been added to {sitename} by {userrealname}';
$strNoticeNewSite = 'New site {sitename} has been added by {userrealname}';
$strNoticeNewSiteDesc = 'Notifies when a new site has been added';
$strNoticeNewUserDesc = 'Notifies of a new system user';
$strNoticeNewUser = '{userrealname} has been added as a new user to {applicationshortname}';
$strNotices = 'Notices';
$strNoticeSitUpgradedDesc = 'Notifies of a system upgrade';
$strNoticeSitUpgraded ='{applicationshortname} has been upgraded to {applicationversion}';
$strNoticeTaskDue = 'Task {taskid} - {taskname} is now due';
$strNoticeTaskDueDesc = 'Notifies of a due task.';
$strNoticeSchedulerTaskFailed = 'Scheduler task {schedulertask} failed';
$strNoticeSchedulerTaskFailedDesc = 'Notifies of a scheduler task failing';
$strNoticeUserChangedStatusDesc = 'Notifies of an user\'s status change';
$strNoticeUserChangedStatus = '{userrealname} has changed their status to {userstatus} and {useraccepting} incidents';
$strNoticesBlurb = 'This page allows you to post a new global notice. BB code is allowed.';
$strNotifications = 'Notifications';
$strNotInOffice = 'Not In Office';
$strNotRequested = 'Not Requested';
$strNotSet = 'Not Set';
$strNotSettingArea = '<strong>NOTE</strong>: Not setting one may slow down processing your incident';
$strNotUpdated = 'Not Updated';
$strNoUpgradesForDashboardComponent = 'No upgrades for %s dashboard component';
# Short for November
$strNovAbbr = 'Nov';
$strNoVendorsDefined = 'No Vendors Defined';
# Month number 11: November
$strNovember = 'November';
$strNow = 'Now';
$strNumContactsAssignedToSite = 'There are %s contacts assigned to this site';
$strNumContractsAssignedToSite = 'There are %s contracts assigned to this site';
$strNumOfIncidents = 'There are %s incidents in this list';
$strNumOfIncidentsLoggedByX = 'Number of incidents logged by %s';
$strNumOfCalls = '# of calls';
$strNumOpenIncidents = '%s open';

$strOccurance = 'Occurance';
# Short for October
$strOctAbbr = 'Oct';
# Month number 10: October
$strOctober = 'October';
$strOffset = 'Offset';
$strOK = 'OK';
$strOldPassword = 'Old Password';
$strOnHoliday = 'On Holiday';
$strOffline = 'Offline';
$strOneOfTheSignaturesWillBeInserted = 'One of the signatures below will be chosen at random and inserted at the bottom of outgoing emails. It\'s recommended that you begin this signature with two dashes, a space and a line feed';
$strOneTimeBillingEditor = 'One time billing editor';
$strOnline = 'Online';
$strOnlyShowsClosedCalls = 'Only shows closed calls';
$strOnlyShowNewerThan = 'Only show newer than %d days old';
$strOnlyShowSitesWithActiveContracts = 'Only show sites with active contracts';
$strOnTrainingCourse = 'On Training Course';
# e.g. on 16 July at 8:00am
$strOnxAtY = 'On %s at %s';
$strOpen = 'Open';
$strOpened = 'Opened';
$strOpenActivities = 'Open Activities';
$strOpenedby = 'Opened by %s';
$strOpenedbyXonY = 'Opened by %s on %s';
$strOpenedViaThePortalByX = 'Opened via the portal by %s';
$strOpenForX = 'Open for %s';
$strOperation = 'Operation';
$strOptions = 'Options';
$strOptionsOnePerLine = 'Options (one per line)';
$strOriginalMessageReceivedAt = 'Original message received at: %s';
$strOrphanedSites = 'Orphaned Sites';
$strOther = 'Other';
$strOtherIncidents = 'Other Incidents';
$strOtherLeave = 'Other Leave';
$strOutbound = 'Outbound';
$strOutput = 'Output';
$strOwnedBy = 'owned by';
$strOwner = 'Owner';
$strOwners = 'Owners';
$strOwnerXAcctingAgain = 'Owner %s accepting again';
$strOwnerXAndNotAccepting = 'Owner %s &amp; not accepting';
$strOverview = 'Overview';
$strOverXHoursAgo = 'Over %x hours ago';

$strParameters = 'Parameters';
$strPassword = 'Password';
$strPasswordHasBeenReset = 'Your password has been reset, you can now login using the new details.';
$strPasswordReset = 'Password reset';
$strPasswordResetURL = 'Hashed URL for password reset';
$strPasswordsDoNotMatch = 'Passwords do not match';
$strPastXDays = 'Past %s days';
$strPastXMonths = 'Past %s months';
# e.g. File system directory paths
$strPaths = 'Paths';
$strPercentageEscalated = 'Percentage Escalated';
$strPeriod = 'Period';
$strPeriodStarted = 'Period Started';
$strPendingReassignments = 'Pending Re-Assignments';
$strPermission = 'Permission';
$strPermissionDenied = 'Permission Denied';
$strPermissionDeniedForX = 'Permission denied for %s';
$strPermissions = 'Permissions';
$strPermissionsInhereitedCannotBeChanged = 'Permissions that are inherited from the users role can not be changed.';
$strPerIncident = 'Per Incident';
$strPerUnit = 'Per Unit';
$strPerUser = 'Per User';
$strPreferred = 'Preferred';
$strPreReleaseNotice = 'You are using a pre-release version of SiT - %s, Pre-release versions are for you to test, provide feedback and to help with further development and should never be used in a live production environment';
$strPreviousIncidentOwner = 'Previous Incident Owner';
$strPreviousUpdate = 'Previous Update';
$strPreviousXDays = 'Previous %s days';
$strPreviousXMonths = 'Previous %s months';
$strProblemSettingPassiveFTPMode = 'Problem setting passive FTP mode';
$strProductX = 'Product: %s';
$strProductInformation = 'product information';
$strProfileLanguage = 'The language the user has set in their profile';
$strPhonecallmadeby = 'Phonecall made by %s';
$strPhonecalltakenby = 'Phonecall taken by %s';
$strPlaceIncidentInWaitingQueue = 'Place incident in the waiting queue?';
$strPleaseCheckData = 'Please check the data you entered';
$strPleaseConfirmUsername = 'Please confirm your username';
$strPleaseWaitRedirect = 'Please wait while you are redirected';
$strPlugins = 'Plugins';
$strPopularity = 'Popularity';
$strPortal = 'Portal';
$strPortalIncidentRequestClosed = 'Portal incident requested closed';
$strPositive = 'Positive';
$strPositivity = 'Positivity';
$strPossibleNewIncident = 'Possible new incident';
# Postal code
$strPostcode = 'Postcode';
$strPostNewNotice = 'Post New Notice';
$strPostOK = 'Post OK';
$strPostpone = 'Postpone';
# pm = After noon
$strPM = 'pm';
$strPrevious = 'Previous';
$strPriority = 'Priority';
$strPrivacy = 'Privacy';
$strPrivate = 'Private';
$strProblemDefinition = 'Problem Definition';
$strProblemDefinitionby = 'Problem definition by %s';
$strProblemDescription = 'Problem Description';
$strProblemDescriptionCustomerText = 'As much information as possible about the problem, enough for an engineer to begin researching the issue without having to contact you.';
$strProblemHasBeenDefined = 'The problem has been defined';

$strProblemReproduction = 'Problem Reproduction';
$strProblemReproductionCustomerText = 'Does the problem exist with more than one machine? What steps will an engineer need to take to reproduce this issue?';
$strProduct = 'Product';
$strProductOnly = 'Product Only';
$strProductQuestions = 'Product Questions';
$strProducts = 'Products';
$strPublic = 'Public';
$strPublicHoliday = 'Public Holiday';
$strPublicSharedComputerIncreasedSecurity = 'Public/Shared Computer (Increased Security)';
$strPublish = 'Publish';
$strPublished = 'Published';
$strPublishedToday = 'Published Today';
$strPublishedOnX = 'Published on %s';

$strQualifications = 'Qualifications';
$strQueryByExample = 'Query By Example';
$strQuestion = 'Question';
$strQuestions = 'Questions';
$strQuestionText = 'Question Text';
$strQuestionRequired = 'Questions marked with this symbol are required and must be answered before continuing';
$strQuestionXNeedsAnsweringBeforeContinuing = 'Question %s requires an answer before continuing.';
$strQueue = 'Queue';

$strRandomTip = 'Random Tip';
$strRating = 'Rating';
#English suffix for third - 3rd
$strrd = 'rd';
$strRealName = 'Real Name';
$strReassign = 'Reassign';
$strReassignIncident = 'Reassign Incident';
$strReason = 'Reason';
$strReassignTo = 'Reassign to';
$strReassignedToBy = 'Reassigned to %s by %s';
$strReassignText = 'Explain in detail why you are reassigning this incident and include instructions to the new owner as to what action should be taken next.  Please be as detailed as possible and include full descriptions of any work you have performed.';
$strReceivedByEmail = 'This information was received in the email.  It is not editable.';
$strRecent = 'Recent';
$strRecentIncidents = 'Recent Incidents';
$strReducedPrioritySLA = 'Reduced from %s according to SLA';
$strReferences = 'References';
$strRefresh = 'Refresh';
#Abbreviation for Reference ID
$strRefID = 'Ref ID';
$strRegister = 'Register';
$strRelated = 'Related';
$strRelatedContracts = 'Related Contracts';
$strRelatedIncidents = 'Related Incidents';
$strRelatingToIncident = 'Relating to incident';
$strRelations = 'Relations';
$strRelationship = 'Relationship';
$strRelationshipRemoved = 'Relationship Removed';
$strReleaseNotes = 'Release Notes';
$strReleaseNotesFor = 'Release Notes For %s';
$strRemaining = '%s Remaining';
$strRemainingBalance = 'Remaining Balance';
$strRememberToSave = 'Remember to save any changes you have made';
$strRemind = 'Remind';
$strRemindByPhone = 'Remind customer by phone';
$strRemindCustomer = 'Remind customer';
$strReminded = 'Reminded';
$strRemove = 'Remove';
$strRemoveASupportedContact = 'Remove a Supported Contact';
$strRemoveLinkContractAndSupportContact = 'Remove the link between a contract and a support contact';
$strRemoveLinkContractAndSupportContactText = 'This will mean that the contact will not be able to log any further support incidents for the related product';
$strRemoveTemporaryOwner = 'Remove Temporary Owner';
$strRemoveThisPermanently = 'Remove this permanently';
$strReopen = 'Reopen';
$strReopenIncident = 'Reopen Incident';
$strReopenIncidentAndAddUpdate = 'Reopen incident and add update?';
$strReopenedby = 'Reopened by %s';
$strRepeat = 'Repeat';
$strReply = 'Reply';
$strReplyTo = 'Reply To';
$strReportBug = 'Report a Bug';
$strReportedBug = 'Reported Bug';
$strReportIncidentsBySiteDesc = 'Total Number of incidents logged: %s, Logged externally: %s (%s%%)';
$strReportListsIncidentsLoggedThatEachSiteLoggedOverPastXMonths = 'This report lists the incidents that each site has logged over the past %s months';
$strReports = 'Reports';
$strRequested = 'Requested';
$strRequestClosure = 'Request Closure';
$strRequestNoUsersToApprovePermissions = 'There are no users that can approve your request, only users with appropiate permissions can approve holiday requests and you cannot approve your own requests.';
$strRequestNoHolidaysAwaitingYourApproval = 'There are currently no holidays waiting for your approval';
$strRequestNotSent = 'Request not sent';
$strRequestSendComments = 'Send comments with your request: (or leave blank)';
$strRequestSent = 'Request Sent';
$strRequestSentToX = 'Request sent to %s';
$strRequired = 'Required';
$strRequiredDataMissing = 'Required data missing';
$strResearchedby = 'Researched by %s';
$strResearching = 'Researching';
$strResearchNeeded = 'Research Needed';
$strResearchNotes = 'Research Notes';
$strReserved = 'Reserved';
$strReset = 'Reset';
$strResetHolidayEntitlementCarryOverNDaysOfUnusedHoliday = 'Reset holiday entitlement and carry-over up to <em>n</em> days of unused holiday';
$strResetPassword = 'Reset Password';
$strResolutionReprioritisation = 'Resolution/Reprioritisation';
$strResolvedby = 'Resolved by %s';
$strReseller = 'Reseller';
$strResponsesToFeedbackForm = 'Responses to Feedback Form';
$strResponsesToAllFeedbackForms = 'Responses to All Feedback Forms';
$strRestricted = 'Restricted';
$strResult = 'Result';
$strResults = 'Results';
$strResultsNum = '%d Results';
$strReturnAfterSaving = 'Return to this page after saving';
$strReturnToOriginalOwner = 'Return to original owner';
$strReturnToPreviousPage = 'Return to previous page';
$strReturnToProductList = 'Return to product list';
$strReturnWithoutSaving = 'Return without saving';
# Show
$strReveal = 'Reveal';
$strReverseLinks = 'Reverse Links';
$strReview = 'Review';
$strReviewby = 'Review %s by %s';
$strReviewDueAgo = 'Review Due %s ago!';
$strReviewDueNow = 'Review Due Now!';
$strReviewHeldUpdates = 'Review Held Updates';
$strReviewIn = 'Review in %s';
$strRevoke = 'Revoke';
$strRole = 'Role';
$strRolePermissions = 'Role Permissions';
# eg. Role Permission: 3 - Edit existing site details
$strRolePermissionsXY = 'Role Permission: %s - %s';
$strRSSAtomURL = 'RSS/Atom Feed URL';
$strRules = 'Rules';
$strRulesNotDefinable = 'Rules are not definable for this trigger action';
$strRunReport = 'Run Report';

$strSalesperson = 'Salesperson';
$strSalespersonSite = 'The site\'s salesperson';
$strSalespersonAssignedToContactsSiteEmail = 'The email address of the salesperson attached to the contacts site';
# short for 'Saturday'
$strSat = 'Sat';
$strSaturday = 'Saturday';
# Two character (Maximum) abbreviation for 'Saturday'
$strSaturdayAbbr = 'Sa';
$strSave = 'Save';
$strSaveAsCSV = 'Save as CSV';
$strSaveDashbaordLayout = 'Save Dashboard Layout';
$strSaveDraft = 'Save Draft';
$strSaveTheMainFormFirst = 'Save the main form before adding questions';
$strSavePublish = 'Save and Publish';
$strScheduledTask = 'Name of the scheduler task';
$strScheduler = 'Scheduler';
$strSchedulerActionFailed = 'Scheduler Action Failed';
# Database structure version
$strSchemaVersion = 'Schema Version';
$strScore = 'Score';
$strScores = 'Scores';
$strScreen = 'Screen';
$strSearch = 'Search';
$strSearchAgain = 'Search Again';
$strSearchInDomain = 'Searching for "%s" in %s&hellip;';
$strSearchInDomainNotAvailableYet = 'Searching in this domain not available yet';
$strSearchTooShort = 'The search term you used is too short, it must be 3 or more characters';
$strSearchYielded = 'Search yielded';
$strSeconds = 'Seconds';
$strSectionText = 'Section Text';
$strSeeHere = 'See here';
$strSeeOlderVersions = 'See Older Versions';
$strSelect = 'Select';
$strSelectAction = 'Select action';
$strSelectAFieldForTemplates = 'Select a field that supports template variables, then click a variable to insert it';
$strSelectDays = 'Select Days';
$strSelectionXmustNotBeEmpty = 'Selection %s Must Not Be Empty';
$strSelectKBSections = 'Select the sections you\'d like to include in the article by checking the boxes beside each heading, you can add further sections later.  You don\'t need to include all sections, just use the ones that are relevant.';
$strSelectNoneAssumesAll = 'Select none assumes all';
$strSelectSkillsApplyToArticle = 'Select the skills that apply to this article';
$strSelectYourSkills = 'Select your skills. Having skills means that you are available to receive incidents with those skills.';
$strSelf = 'Self';
$strSendAnEmail = 'Send an email based on a %s template';
$strSendEmail = 'Send Email';
$strSendEmailExplainingIncidentClosure = 'Send an email to the customer explaining that the incident has been (or will be) closed.';
$strSendEmailExternalIncidentClosure = 'Send an email to %s asking for the external incident to be closed.';
$strSendOpeningEmail = 'Send opening email';
$strSendOpeningEmailDesc = 'Send opening email to incident contact?';
$strSendPassword = 'Send Password';
$strSendRequest = 'Send Request';
$strSendReminderRequest = 'Send Reminder Request';
$strSendRequestsTo = 'Send the request(s) to';
$strSentInformation = 'Sent Information';
$strSendTranslation = 'Save the text below as %s and place in the %s directory to use it. Send it to %s for it to be included with future SiT! releases for the benefit of other users.';
# Short for September
$strSepAbbr = 'Sep';
# Month number 9: September
$strSeptember = 'September';
$strService = 'Service';
$strServiceBalance = 'Service Balance';
$strServiceBalanceInfo = 'The amount of remaining service balance as a number e.g. "0.34"';
$strServiceBalanceString = 'The amount of remaining service as a percentage e.g. "34%"';
$strServiceHistory = 'Service History';
$strServiceID = 'Service ID';
$strServiceLevel = 'Service Level';
$strServiceLevelPreventsReopen = 'The service level of this incident prevents it being reopened';
$strServiceLevels = 'Service Levels';
$strServicePacksApplied = 'Service Packs Applied';
$strServicePeriod = 'Service Period';
$strSession = 'Session';
$strSessionExpired = 'Your session has expired or you have not yet logged in';
$strSetPassword = 'Set Password';
$strSetPermissions = 'Set Permissions';
$strSetPermissionsForRoleX = 'Set permissions for role: %s';
$strSetPermissionsForUserX = 'Set permissions for user: %s';
$strSetPublicHolidays = 'Set Public Holidays';
$strSetRolePermissions = 'Set role permissions';
$strSettings = 'Settings';
$strSetYourStatus = 'Set your Status';
$strShowActiveOnly = 'Show Active Only';
$strShowAll = 'Show All';
$strShowApproved = 'Show Approved';
$strShowClosedIncidents = 'Show closed incidents';
$strShowEmoticons = 'Show Emoticons';
$strShowEverybodys = 'Show Everybody\'s';
$strShowExpiredAsZero = 'Show Expired As Zero';
$strShowExpiredContracts = 'Show Expired Contracts';
$strShowingAllArticles = 'Showing all articles';
$strShowingAllClosedIncidents = 'Showing all closed incidents';
$strShowingXtoXofX = 'Showing %s to %s of %s';
$strShowingXofX = 'Showing %s of %s';
$strShowingOnlyRelevantArticles = 'Showing only relevant articles';
$strShowFreeOfCharge = 'Show Free of Charge';
$strShowFreeOfChargeAsZero = 'Show Free of Charge as Zero';
$strShowIncidentDetails = 'Show Incident details';
$strShowMine = 'Show Mine';
$strShowOnlyRelevant = 'Show only relevant';
$strShowOpenIncidents = 'Show open incidents';
$strShowOrphandedContacts = 'Show orphaned contacts (no site)';
$strShowPaged = 'Show Paged';
$strShowPositivityGraph = 'This graph shows different levels of positivity of the contacts shown above';
$strShowProducts = 'Show Products';
$strShowRenewals = 'Show Renewals';
$strShowSitesThatHaveLoggedNoIncidents = 'Show sites that have logged no incidents';
$strShowSitesWhichHaveLoggedLessThanCalls = 'Show sites which have logged less than X calls';
$strShowSiteTotals = 'Show Site Totals';
$strShowTotals = 'Show Totals';
$strSicknessOnlyBookedNowOrPast = 'Sickness, can only be booked for today or days that have passed';
$strSimpleHTMLallowed = 'Simple HTML allowed';
$strSinceX = 'since %s';
$strSingleIncident = '%s Incident';
$strSite = 'Site';
$strSiteAreYouSure = 'This incident will be logged against the customers SITE and NOT against a contract, you will be prompted to choose a service level. Are you sure you want to continue?';
# Break down the report by site
$strSiteBreakDown = 'Site Breakdown';
$strSiteContracts = 'Site Contracts';
$strSiteEdited = 'Site Edited';
$strSiteHasBillableContract = 'Site has billable contract';
$strSiteIncidents = 'Site Incidents';
$strSiteName = 'Site Name';
$strSiteNotes = 'Site Notes:';
$strSiteNotListed = 'Site not listed?';
$strSiteProducts = 'Site Products';
$strSiteProductsMatrix = 'Site Products Matrix';
$strSites = 'Sites';
$strSiteSupport = 'Site Support';
$strSiteType = 'Site Type';
$strSiteTypes = 'Site Types';
$strSiteXEdited = 'Site %s edited';
$strSitUpgraded = 'SiT! Upgraded';
$strSitUpgradedTo = '%s has been upgraded to %s';
$strSitUpgradedLink = 'What\'s new?';
$strSize = 'Size';
$strSkill = 'Skill';
$strSkills = 'Skills';
$strSkillAssignedToIncident = 'Skill assigned to an incident';
$strSkillsFor = 'Skills For %s';
$strSkillsMatrix = 'Skills Matrix';
$strSkillsSupportedUnderContract = 'Skills supported under this contract';
# abbr. for Service Level Agreement
$strSLA = 'SLA';
$strSLAApproaching = 'SLA approaching';
$strSLAby = 'SLA: %s by %s';
$strSLADue = 'SLA due';
$strSLAXDueNow = '%s due now';
#E.g. Initial Response in 3 hours
$strSLAInX = '%s in %s';
#E.g. Initial Response 3 hours late
$strSLAXLate = '%s %s late';
$strSLAMissed = 'SLA missed';
$strSLAPerformance = 'SLA Performance';
$strSLATarget = 'SLA Target';
# Simple Object Access Protocol
$strSOAP = 'SOAP';
$strSoftware = 'Software';
$strSoftwareVersion = 'Software Version';
$strSolution = 'Solution';
$strSolvedProblem = 'Solved Problem';
$strSomeOfTheseIdentifiers = 'Some of these identifiers might not be available once you add a trigger';
$strSorryNoPermissionToAreas = 'Sorry, you do not have permission to the following areas';
$strSorryNoRecordsMatchingX = 'Sorry, unable to find any records matching %s';
$strSorryNoSearchResults = 'Sorry, your search wielded no results';
$strSorryProductCantBeDeleted = 'Sorry, the product can\'t be deleted, check if there are skills or contracts linked to it.';
$strSorryUnableToFindAnyContactsMatchingX = 'Sorry, unable to find any contacts matching <em>%s</em>';
$strSort = 'Sort';
$strSortAscending = 'Sort Ascending';
$strSortDescending = 'Sort Decending';
$strSortResults = 'Sort Results';
$strSource = 'Source';
$strSourceFailCannotBeFoundX = 'Source file cannot be found %s';
$strSpamEmail = 'Spam Email';
$strSpecifyAddress = 'Specify an address for this contact that is different to the site';
#English suffix for first - 1st
$strst = 'st';
$strStartDate = 'Start Date';
$strStartNewActivity = 'Start New Activity';
$strStatsFromDayStatistics = 'Statistics from %s';
$strStatisticsOnly = 'Statistics Only';
$strStatisticsWarningReassign = 'The statistics are approximation only. They don\'t take into consideration incidents reassigned';
$strStatus = 'Status';
$strStatusSummary = 'Status Summary';
# i.e. permanent
$strSticky = 'Sticky';
$strStopActivity = 'Stop Activity';
$strStoreInLog = 'Store details in the Incident Log';
$strSubject = 'Subject';
$strSubstitute = 'Substitute';
$strSubstitutes = 'Substitutes';
$strSuccess = 'Success';
$strSuccessfully = 'Successfully';
$strSuccessfullyUpdated = 'Successfully Updated';
$strSummary = 'Summary';
$strSummaryOfProblem = 'A concise but full summary of the problem(s) that were encountered.';
$strSummaryOfProblemAndResolution = 'You should provide a summary of the problem and information about how it was resolved.';
# Short for 'Sunday'
$strSun = 'Sun';
$strSunday = 'Sunday';
# Two character (Maximum) abbreviation for 'Sunday'
$strSundayAbbr = 'Su';
$strSupport = 'Support';
$strSupportEmailAddress = 'Support Email Address';
$strSupportEmailDesc = 'Free text support email';
$strSupportExpired = 'Support Expired';
$strSupportManagersEmailAddress = 'Technical Support managers email address';
$strSupportedContacts = 'Supported Contacts';
$strSupportedContactsbySite = 'Supported Contacts by Site';
$strSurname = 'Surname';
$strSwitchUser = 'Switch User';
$strSymptoms = 'Symptoms';
$strSystem = 'System';
$strSystemActions = 'System Actions';
$strSystemPath = 'System base path';
$strSystemUrl = 'System URL';

$strTable = 'Table';
$strTag = 'Tag';
$strTagCloud = 'Tag Cloud';
$strTags = 'Tags';
$strTagsMulti = '%d Tags';
$strtaken = 'taken';
$strtakennextperiod = 'taken in next period';
$strTarget = 'Target';
$strTask = 'Task';
$strTaskDue = 'Task Due';
$strTaskDueDesc = 'Occurs when a task reaches its due date';
$strTaskMarkedCompleteByX = 'Task marked 100%% complete by %s';
$strTasks = 'Tasks';
$strTaskList = 'Task List';
$strTaskPrivateError = 'Sorry, you cannot view this task as it has been marked private and you are not the owner';
$srtrTaskStarted = 'Task started';
$strTBytes = 'TBytes';
$strTechnicalSupportAdmin = 'Technical Support Admin';
# Abbreviation for 'Telephone'
$strTel = 'Tel';
$strTelephone = 'Telephone';
# Abbreviated 'Temporary';
$strTemp = 'Temp';
$strTemplate = 'Template';
$strTemplates = 'Templates';
$strTemplatesShouldNotBeginWith = 'Templates should not begin with any text that looks like an email header.  (e.g. <code>\'Name: \'</code>)';
$strTemplateType = 'Template Type';
$strTemplateVariables = 'Template Variables';
$strTemporarilyAssignedto = 'Temporarily assigned to %s by %s';
$strTemporaryOwner = 'Temporary Owner';
$strTerminated = 'Terminated';
$strTerminatedContractsExpiredXdaysAgo  = 'Terminated Contracts that expired up to %s days ago';
# As in 'Click to test triggers'
$strTestTriggers = 'Test Triggers';
$strText = 'Text';
#English suffix for most numbers - 5th, 6th, 7th
$strth = 'th';
$strThankYou = 'Thank You';
$strThankYouCompleteForm = 'Thank you for taking the time to complete this form.';
$strTheFollowingVariables = 'The following variables may be used:';
$strThereAreXcontractsAssignedToThisPerson = 'There are %s contracts assigned to this contact';
$strThereAreXIncidentsAssignedToThisContact = 'There are %s incidents assigned to this contact';
$strThereAreXIncidentsInThisList = 'There are %s incidents in this list';
$strThereWasAProblemSendingYourRequest = 'There was a problem sending your request';
$strTheInfoInThisArticle = 'The information in this article applies to';
# These files arrived by 'email'
$strTheseFilesArrivedBy ='These files arrived by';
# Theme as in Interface Style
$strTheme = 'Theme';
$strTheMoreInformation = 'The more information you can provide, the better';
$strThisListShowsCustomers = 'This list shows customers that matched your search, if site-support is available you can add incidents for the site.';
$strThisMonth = 'This month';
$strThisReportShowsIncidentsClosedInThisPeriod = 'This report shows incidents closed in the period';
$strThisReportShowsContactForSelectedSites   = 'This report is a list of (%s) contact details for all sites that you selected';
$strThisWeek = 'This week';
$strThisYear = 'This year';
# Short for 'Thursday'
$strThu = 'Thu';
$strThursday = 'Thursday';
# Two character (Maximum) abbreviation for 'Thursday'
$strThursdayAbbr = 'Th';
$strTime = 'Time';
$strTimed = 'Timed';
$strTimesheet = 'Timesheet';
$strTimesheets = 'Timesheets';
$strTimeToNextAction = 'Time To Next Action';
$strTitle = 'Title';
$strTo = 'To';
$strToChangeBrackets = '(to change)';
$strToChangeContract = 'To change the contract close this incident and create a new one';
$strToChangePassword = 'To change your password, first enter your existing password and then type your new password twice to confirm it';
$strToday = 'Today';
$strTodaysDate = 'Today\'s Date';
$strTodaysStats = 'Today\'s Statistics';
$strToIncidentID = 'To Incident ID';
$strTotal = 'Total';
# Totals capitalised
$strTOTALS = 'TOTALS';
$strTotalBillableUnits = 'Total Billable Units';
$strTotalCredit = 'Total Credit';
$strTotalDebit = 'Total Debit';
$strTotalMinutes = 'Total Minutes';
$strTotalOpen = 'Total Open';
$strTotalUnits = 'Total Units';
$strTrackURL = 'Track URL';
$strTraining = 'Training';
$strTransactionApproved = 'Transaction approved';
$strTransactions = 'Transactions';
$strTransactionXnotAwaitingApproval = 'Transaction %s is not awaiting approval';
$strTransfer = 'Transfer';
# An example of transfering amounts between services
$strTransferExamplePositiveService = 'Select the service which has a negative balance and transfer the amount from here, e.g. Service A is -100 to resolve this transfer 100 from here.';
$strTransferExampleNegativeService = 'Select a service which has a positive balance and transfer the amount from here, e.g. Service A is 100 to resolve this transfer -100 from here.';
$strTranslate = 'Translate';
$strTranslateTheString = 'Translate the english string on the left to your requested language on the right';
$strTranslation = 'Translation';
$strTrigger = 'Trigger';
$strTriggerActions = 'Trigger Actions';
$strTriggerContactResetPasswordDesc = 'Occurs when a contact wants their password resetting';
$strTriggerFooter = 'You are being sent this email by the Triggers system. To stop these emails, please change your settings or talk to your administrator';
$strTriggerHolidayRequestedDesc = 'Occurs when a user requests a holiday';
$strTriggerIncidentClosedDesc ='Occurs when an incident is closed';
$strTriggerIncidentNearingSLADesc = 'Occurs when an incidents nears an SLA';
$strTriggerIncidentReviewDueDesc = 'Occurs when an incident is due a review';
$strTriggerKBArticleCreatedDesc = 'Occurs when a new Knowledgebase article is created';
$strTriggerLanguageDiffersDesc = 'Occurs when your current language setting is different to your profile setting';
$strTriggerNewContactDesc = 'Occurs when a new contact is added';
$strTriggerNewContractDesc = 'Occurs when a new contract is added';
$strTriggerNewHeldEmailDesc = 'Occurs when there is a new email in the holding queue';
$strTriggerNewHeldEmailMinsDesc = 'Occurs when there is a new email in the holding queue for X minutes';
$strTriggerNewIncidentAssignedDesc = 'Occurs when a new incident is assigned to a user';
$strTriggerNewIncidentCreatedDesc = 'Occurs when a new incident has been created';
$strTriggerNewSiteDesc = 'Occurs when a new site is added';
$strTriggerNewUserDesc ='Occurs when a new user is added';
$strTriggerPortalIncidentRequestClosedDesc = 'Occurs when an incident is requested to be closed';
$strTriggerSchedulerTaskFailedDesc = 'Occurs when a scheduled action fails';
$strTriggerSitUpgradedDesc = 'Occurs when the system is upgraded';
$strTriggerUserChangedStatusDesc = 'Occurs when one of your watched engineer changes status';
$strTriggerUserResetPasswordDesc = 'Occurs when a user wants their password resetting';
$strTriggers = 'Triggers';
$strTriggersFooter = 'The footer at the end of an email which explains where it has come from';
$strTriggerUserEmail = 'Email address to send an user trigger email to (if not the current user)';
# Short for 'Tuesday'
$strTue = 'Tue';
$strTuesday = 'Tuesday';
# Two character (Maximum) abbreviation for 'Tuesday'
$strTuesdayAbbr = 'Tu';
$strType = 'Type';

$strURLTitle = 'URL Title';
$strUpgrade = 'Upgrade';
$strUpdate = 'Update';
$strUpdateFailed = 'Update Failed';
$strUpdated = 'Updated';
$strUpdatedAutomaticallyBy = 'Updated automatically by %s';
$strUpdatedby = 'Updated by %s';
$strUpdatedFromTask = 'Updated From Task';
$strUpdatedXbyX = 'Updated %s by %s';
$strUpdateIncident = 'Update Incident';
$strUpdateIncidentFailed = 'Incident Update failed';
$strUpdateIncidentXsBalance = 'Update incident [%s]\'s balance';
$strUpdateNewUpdate = 'New update (none of the above)';
$strUpdatePerUserAbbrev = 'upd per user';
$strUpdateRolePermissionsFailed = 'Update of role permissions failed on pass 1';
$strUpdates = 'Updates';
$strUpdatedFromActivity = 'Updated from Activity by %s';
$strUpdateUserPermission = 'Update of user permission';
$strUpdatedViaThePortalBy = 'Updated via the portal by %s %s';
$strUpdateSuccessful = 'Update Successful';
$strUploadFailed = 'Upload failed!';
$strUpdateType = 'Update Type';
$strUploadedBy = 'Uploaded by %s';
$strUploadedXtoYAsZ = 'Updated %s to %s as %s';
$strUnableToChangeServiceAsUsed = 'Unable to change amounts or rates as the service has been used';
$strUnapprovable = 'Unapprovable';
$strUnapprovableBilledIncidentsDesc = 'Some incidents are unapprovable this could be due to: No service present, No active service for the period, overdrafts are disabled and no service with credit has been found';
$strUnassigned = 'Unassigned';
$strUnassignedIncidents = 'Unassigned Incidents';
$strUnitRate = 'Unit Rate';
$strUnits = 'Units';
$strUnitsUsedLastXdays = 'Units used in last %d days';
$strUnitsRemaingSingleTime = 'Units remaing at 1x';
$strUnknown = 'Unknown';
$strUnknownServiceLevel = 'Unknown service level';
$strUnlimited = 'Unlimited';
$strUnlink = 'Unlink';
$strUnlock = 'Unlock';
$strUnlockThisToBeModifiedByOther = 'Unlock this update so it can be modified by someone else';
$strUnsolved = 'Unsolved';
$strUnsupported = 'Unsupported';
$strUntilSpecificDateAndTime = 'Until specific date and time';
$strUntilX = 'Until %s';
$strUntitled = 'Untitled';
$strUsed = 'Used';
$strUsedNofN = 'Used %s of %s';
$strUsedNofNDaysEntitlement = 'Used %s of %s days entitlement';
$strUser = 'User';
$strUserGroups = 'User Groups';
$strUsername = 'Username';
$strUsernameNotUnique = 'Username must be unique';
$strUsers = 'Users';
$strUserChangedStatus = 'User Changed Status';
$strUserPermissionsEdited = 'User Permissions Edited';
$strUserXPermissionsEdited = 'User %s Permissions Edited';
# User Permission 3 - Edit existing site details
$strUserPermissionXY = 'User Permission: %s - %s';
$strUserResetPassword = 'User Reset Password';
$strUserSettings = 'User Settings';
$strUsersHolidays = '%s\'s Holidays';
$strUserStatus = 'Status of the user';
$strUserStillAway = 'Your current status is not set to In Office, you can change it at the bottom of the front page';
$strUserIncidents = '%s\'s Incidents';
$strUsersNoGroup = 'Users with no group';
$strUsersBoldSkills = 'Users shows in bold typeface are known to have relevant skills';
$strUseThisInFuture = 'Use this in future';
# Offset from Coordinated Universal Time / Temps Universel Coordonné
$strUTCOffset = 'UTC Offset (Timezone)';

$strValid = 'Valid';
$strValue = 'Value';
$strVariable = 'Variable';
$strVendor = 'Vendor';
$strVendorName = 'Vendor Name';
$strVersion = 'Version';
$strView = 'View';
$strViewAndLockHeldEmail = 'View and lock this held e-mail';
$strViewActivity = 'View Activity';
$strViewArticle = 'View Article';
$strViewContact = 'View Contact';
$strViewContract = 'View Contract';
$strViewHoldingQueue = 'View Holding Queue';
$strViewIncident = 'View Incident';
$strViewResponse = 'View Response';
$strViewSite = 'View Site';
$strViewTask = 'View Task';
$strViewTasks = 'View Tasks';
$strViewUsers = 'View Users';
$strViewingAllIncidents = 'Viewing All Incidents';
$strVisibleToCustomer = 'Visible To Customer';
$strVisibility = 'Visibility';

$strWaiting = 'Waiting';
$strWaitingForCustomer = 'Waiting for customer';
$strWaitingForSupport = 'Waiting for support';
$strWaitingHeldEmail = 'Waiting Held Email';
$strWarning = 'Warning';
$strWatchAddFailed = 'Failed to add watch incident';
$strWatchAddSet = 'Add new set of watched incidents';
$strWatchDeleteFailed = 'Delete watch failed';
$strWatchIncidents = 'Watch Incidents';
$strWatchIncidentsAdded = 'Watch Incidents added';
$strWatchIncidentsRemovalSucceded = 'Watch incidents removal succeded';
$strWebupdate = 'Web update';
$strWebupdateBy = 'Web update by %s';
# Short for 'Wednesday'
$strWed = 'Wed';
$strWednesday = 'Wednesday';
# Two character (Maximum) abbreviation for 'Wednesday'
$strWednesdayAbbr = 'We';
$strWeek = 'Week';
$strWelcome = 'Welcome';
$strWeekView = 'Week View';
$strWhatsNew = 'What\'s New?';
$strWhosAwayToday = 'Who\'s Away Today?';
$strWordList = 'Word List';
$strWorkaround = 'Workaround';
$strWorkAroundsAttempted = 'Workarounds Attempted';
$strWorkAroundsAttemptedCustomerText = 'What have you done to try and solve the issue? What config changes were made? What patches/service packs were installed?';
$strWorkingAway = 'Working Away';
$strWorkingFromHome = 'Working From Home';
$strWorkStatus = 'Work Status';
$strWebsite = 'Website';
$strWithheld = 'Withheld';
$strXDays = '%s days';
$strXIncidentsLoggedViaPortal = '%s Incidents Logged via the Portal';
$strXIncidentsLeft = '%s Incidents Left';
$strXHasAction = '%s Has Action';
$strXHour = '%s hour';
$strXHours = '%s hours';
# e.g. '5 minutes late'
$strXLate = '%s late';
$strXMinutes = '%s minutes';
$strXMonths = '%s months';
# e.g. '5 days old'
$strXold = '%s old';
# e.g. 'Fred of ACME Inc'. i.e. 'Name' of 'Site'
$strXofX = '%s of %s';
# e.g. '5 Records'
$strXRecords = '%s Records';
# e.g. John's Activities
$strXsActivities = '%s\'s Activities';
$strXSeconds = '%s seconds';
# e.g. John's Tasks
$strXsTasks = '%s\'s Tasks';
$strXWorkingDay = '%s working day';
$strXWorkingDays = '%s working days';
$strXYears = '%s years';

$strYear = 'Year';
$strYearly = 'Yearly';
$strYearView = 'Year View';
$strYes = 'Yes';
$strYesterday = 'Yesterday';
# Second person, singular
$strYou = 'You';
$strYouShouldNowDefineSubstituteEngineers = 'You should now define a substitute engineer for each skill';
$strYouACurrentlyNotAccepting = 'You are currently not accepting incidents. You can change this at the bottom of the main page.';
$strYouMustEnterIncidentTitle = 'You must enter an incident title.';
$strYouMustEnterYourNewPasswordTwice = 'You must enter your new password twice';
$strYouMustSelectAcontact = 'You must select a contact.';
$strYouMustSelectAmaintenanceContract = 'You must select a maintenance contract';
$strYouMustSelectAserviceLevel = 'You must select a service level';
$strYouMustSelectAsupportContact = 'You must select a support contact';
$strYourClosedIncidents = 'Your closed incidents';
$strYourCurrentIncidents = 'Your current incidents';
$strYourCurrentOpenIncidents = 'Your current open incidents';
$strYourCurrentLanguage = 'The current language differs from the one stored in your profile';
$strYourDetails = 'Your Details';
$strYourSitesClosedIncidents = 'Your site\'s other closed incidents';
$strYourSitesIncidents = 'Your site\'s other incidents';
$strYouHaveAction = 'You have action';
$strYourSupportEntitlement = 'Your support entitlement';

$strZeroRemaining = 'Zero remaining';
?>