
SET SQL_MODE="NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `soft_sit367p2`
--

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]billingmatrix`
--

CREATE TABLE `[[dbprefix]]billingmatrix` (
  `id` int(11) NOT NULL,
  `hour` smallint(6) NOT NULL,
  `mon` float NOT NULL,
  `tue` float NOT NULL,
  `wed` float NOT NULL,
  `thu` float NOT NULL,
  `fri` float NOT NULL,
  `sat` float NOT NULL,
  `sun` float NOT NULL,
  `holiday` float NOT NULL,
  PRIMARY KEY (`id`,`hour`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]billingmatrix`
--

INSERT INTO `[[dbprefix]]billingmatrix` VALUES
(1, 0, 2, 2, 2, 2, 2, 2, 2, 2),
(1, 1, 2, 2, 2, 2, 2, 2, 2, 2),
(1, 2, 2, 2, 2, 2, 2, 2, 2, 2),
(1, 6, 2, 2, 2, 2, 2, 2, 2, 2),
(1, 3, 2, 2, 2, 2, 2, 2, 2, 2),
(1, 4, 2, 2, 2, 2, 2, 2, 2, 2),
(1, 5, 2, 2, 2, 2, 2, 2, 2, 2),
(1, 7, 2, 2, 2, 2, 2, 2, 2, 2),
(1, 8, 1, 1, 1, 1, 1, 1.5, 2, 2),
(1, 9, 1, 1, 1, 1, 1, 1.5, 2, 2),
(1, 10, 1, 1, 1, 1, 1, 1.5, 2, 2),
(1, 11, 1, 1, 1, 1, 1, 1.5, 2, 2),
(1, 12, 1, 1, 1, 1, 1, 1.5, 2, 2),
(1, 13, 1, 1, 1, 1, 1, 1.5, 2, 2),
(1, 14, 1, 1, 1, 1, 1, 1.5, 2, 2),
(1, 15, 1, 1, 1, 1, 1, 1.5, 2, 2),
(1, 16, 1, 1, 1, 1, 1, 1.5, 2, 2),
(1, 17, 1, 1, 1, 1, 1, 1.5, 2, 2),
(1, 18, 1.5, 1.5, 1.5, 1.5, 1.5, 2, 2, 2),
(1, 19, 1.5, 1.5, 1.5, 1.5, 1.5, 2, 2, 2),
(1, 20, 1.5, 1.5, 1.5, 1.5, 1.5, 2, 2, 2),
(1, 21, 1.5, 1.5, 1.5, 1.5, 1.5, 2, 2, 2),
(1, 22, 2, 2, 2, 2, 2, 2, 2, 2),
(1, 23, 2, 2, 2, 2, 2, 2, 2, 2);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]billing_periods`
--

CREATE TABLE `[[dbprefix]]billing_periods` (
  `servicelevelid` int(5) NOT NULL,
  `engineerperiod` int(11) NOT NULL COMMENT 'In minutes',
  `customerperiod` int(11) NOT NULL COMMENT 'In minutes',
  `priority` int(4) NOT NULL,
  `tag` varchar(10) NOT NULL,
  `created` datetime DEFAULT NULL,
  `createdby` smallint(6) DEFAULT NULL,
  `modified` datetime DEFAULT NULL,
  `modifiedby` smallint(6) DEFAULT NULL,
  `limit` float NOT NULL DEFAULT '0',
  PRIMARY KEY (`servicelevelid`,`priority`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]closingstatus`
--

CREATE TABLE `[[dbprefix]]closingstatus` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=11 ;

--
-- Dumping data for table `[[dbprefix]]closingstatus`
--

INSERT INTO `[[dbprefix]]closingstatus` VALUES
(1, 'strSentInformation'),
(2, 'strSolvedProblem'),
(3, 'strReportedBug'),
(4, 'strActionTaken'),
(5, 'strDuplicate'),
(6, 'strNoLongerRelevant'),
(7, 'strUnsupported'),
(8, 'strSupportExpired'),
(9, 'strUnsolved'),
(10, 'strEscalated');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]config`
--

CREATE TABLE `[[dbprefix]]config` (
  `config` varchar(255) NOT NULL,
  `value` text,
  PRIMARY KEY (`config`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='SiT configuration';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]contacts`
--

CREATE TABLE `[[dbprefix]]contacts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `notify_contactid` int(11) NOT NULL DEFAULT '0',
  `username` varchar(50) DEFAULT NULL,
  `password` varchar(50) DEFAULT NULL,
  `forenames` varchar(100) NOT NULL DEFAULT '',
  `surname` varchar(100) NOT NULL DEFAULT '',
  `jobtitle` varchar(255) NOT NULL DEFAULT '',
  `courtesytitle` varchar(50) NOT NULL DEFAULT '',
  `siteid` int(11) NOT NULL DEFAULT '0',
  `email` varchar(100) DEFAULT NULL,
  `phone` varchar(50) DEFAULT NULL,
  `mobile` varchar(50) NOT NULL DEFAULT '',
  `fax` varchar(50) DEFAULT NULL,
  `department` varchar(255) DEFAULT NULL,
  `address1` varchar(255) DEFAULT NULL,
  `address2` varchar(255) NOT NULL DEFAULT '',
  `city` varchar(255) NOT NULL DEFAULT '',
  `county` varchar(255) NOT NULL DEFAULT '',
  `country` varchar(255) NOT NULL DEFAULT '',
  `postcode` varchar(255) NOT NULL DEFAULT '',
  `dataprotection_email` enum('No','Yes') DEFAULT 'No',
  `dataprotection_phone` enum('No','Yes') DEFAULT 'No',
  `dataprotection_address` enum('No','Yes') DEFAULT 'No',
  `timestamp_added` int(11) DEFAULT NULL,
  `timestamp_modified` int(11) DEFAULT NULL,
  `notes` blob NOT NULL,
  `active` enum('true','false') NOT NULL DEFAULT 'true',
  `created` datetime DEFAULT NULL,
  `createdby` smallint(6) DEFAULT NULL,
  `modified` datetime DEFAULT NULL,
  `modifiedby` smallint(6) DEFAULT NULL,
  `contact_source` varchar(32) NOT NULL DEFAULT 'sit',
  PRIMARY KEY (`id`),
  KEY `siteid` (`siteid`),
  KEY `username` (`username`),
  KEY `forenames` (`forenames`),
  KEY `surname` (`surname`),
  KEY `notify_contactid` (`notify_contactid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]dashboard`
--

CREATE TABLE `[[dbprefix]]dashboard` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL DEFAULT '',
  `version` mediumint(9) NOT NULL DEFAULT '1',
  `enabled` enum('true','false') NOT NULL DEFAULT 'false',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=5 ;

--
-- Dumping data for table `[[dbprefix]]dashboard`
--

INSERT INTO `[[dbprefix]]dashboard` VALUES
(1, 'random_tip', 1, 'true'),
(2, 'statistics', 1, 'true'),
(3, 'tasks', 1, 'true'),
(4, 'user_incidents', 1, 'true');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]drafts`
--

CREATE TABLE `[[dbprefix]]drafts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `userid` smallint(6) NOT NULL,
  `incidentid` int(11) NOT NULL,
  `type` enum('update','email') NOT NULL,
  `content` text NOT NULL,
  `meta` text NOT NULL,
  `lastupdate` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]emailsig`
--

CREATE TABLE `[[dbprefix]]emailsig` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `signature` text NOT NULL,
  `created` datetime DEFAULT NULL,
  `createdby` int(11) DEFAULT NULL,
  `modified` datetime DEFAULT NULL,
  `modifiedby` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='Global Email Signature' AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]emailsig`
--

INSERT INTO `[[dbprefix]]emailsig` VALUES
(1, '--\r\n... Powered by Open Source Software: Support Incident Tracker (SiT!) is available free from http://sitracker.org/', NULL, NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]emailtemplates`
--

CREATE TABLE `[[dbprefix]]emailtemplates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `type` enum('usertemplate','system','contact','site','incident','kb','user') NOT NULL DEFAULT 'user' COMMENT 'usertemplate is personal template owned by a user, user is a template relating to a user',
  `description` text NOT NULL,
  `tofield` varchar(100) DEFAULT NULL,
  `fromfield` varchar(100) DEFAULT NULL,
  `replytofield` varchar(100) DEFAULT NULL,
  `ccfield` varchar(100) DEFAULT NULL,
  `bccfield` varchar(100) DEFAULT NULL,
  `subjectfield` varchar(255) DEFAULT NULL,
  `body` text,
  `customervisibility` enum('show','hide') NOT NULL DEFAULT 'show',
  `storeinlog` enum('No','Yes') NOT NULL DEFAULT 'Yes',
  `created` datetime DEFAULT NULL,
  `createdby` smallint(6) DEFAULT NULL,
  `modified` datetime DEFAULT NULL,
  `modifiedby` smallint(6) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=31 ;

--
-- Dumping data for table `[[dbprefix]]emailtemplates`
--

INSERT INTO `[[dbprefix]]emailtemplates` VALUES
(1, 'Support Email', 'incident', 'strSupportEmailDesc', '{contactemail}', '{supportemail}', '{supportemail}', '', '{triggeruseremail}', '[{incidentid}] - {incidenttitle}', 'Hi {contactfirstname},\r\n\r\n{signature}\r\n{globalsignature}', 'show', 'Yes', NULL, NULL, NULL, NULL),
(2, 'EMAIL_INCIDENT_CLOSURE', 'system', 'strEmailIncidentClosureDesc', '{contactemail}', '{supportemail}', '{supportemail}', '', '{triggeruseremail}', 'Closure Notification: [{incidentid}] - {incidenttitle}', '{contactfirstname},\r\n\r\nIncident {incidentid} has been marked for closure. If you still have outstanding issues relating to this incident then please reply with details, otherwise it will be closed in the next seven days.\r\n\r\n{signature}\r\n{globalsignature}', 'show', 'Yes', NULL, NULL, NULL, NULL),
(3, 'EMAIL_INCIDENT_LOGGED_CONTACT', 'system', 'strEmailIncidentLoggedContactDesc', '{contactemail}', '{supportemail}', '{supportemail}', '', '{triggeruseremail}', '[{incidentid}] - {incidenttitle}', 'Thank you for contacting us. The incident {incidentid} has been generated and your details stored in our tracking system. \r\n\r\nYou will be receiving a response from one of our product specialists as soon as possible. When referring to this incident please remember to quote incident {incidentid} in all communications. \r\n\r\nFor all email communications please title your email as [{incidentid}] - {incidenttitle}\r\n\r\n{globalsignature}\r\n', 'hide', 'No', NULL, NULL, NULL, NULL),
(4, 'EMAIL_INCIDENT_OUT_OF_SLA', 'user', 'strEmailIncidentOutOfSlaDesc', '{supportmanager}', '{supportemail}', '{supportemail}', '{triggeruseremail}', '', '{applicationshortname}: Incident {incidentid} now outside SLA', 'This is an automatic notification that this incident has gone outside its SLA.  The SLA target nextsla expired {nextslatime} minutes ago.\r\n\r\nIncident: [{incidentid}] - {incidenttitle}\r\nOwner: {incidentowner}\r\nPriority: {incidentpriority}\r\nExternal Id: {incidentexternalid}\r\nExternal Engineer: {incidentexternalengineer}\r\nSite: {sitename}\r\nContact: {contactname}\r\n\r\nRegards\r\n{applicationname}\r\n\r\n\r\n---\r\n{todaysdate} - {applicationshortname} {applicationversion}\r\n{globalsignature}\r\n{triggersfooter}', 'hide', 'No', NULL, NULL, NULL, NULL),
(5, 'EMAIL_INCIDENT_OUT_OF_REVIEW', 'user', 'strEmailIncidentOutOfReviewWDesc', '{supportmanager}', '{supportemail}', '{supportemail}', '{triggeruseremail}', '', '{applicationshortname} Review: Incident {incidentid} due for review soon', 'This is an automatic notification that this incident [{incidentid}] will soon be due for review.\r\n\r\nIncident: [{incidentid}] - {incidenttitle}\r\nEngineer: {incidentowner}\r\nPriority: {incidentpriority}\r\nExternal Id: {incidentexternalid}\r\nExternal Engineer: {incidentexternalengineer}\r\nSite: {sitename}\r\nContact: {contactname}\r\n\r\nRegards\r\n{applicationname}\r\n\r\n-- \r\n{todaysdate} - {applicationshortname} {applicationversion}\r\n{globalsignature}\r\n{triggersfooter}', 'hide', 'No', NULL, NULL, NULL, NULL),
(6, 'EMAIL_INCIDENT_CREATED_USER', 'user', 'strEmailIncidentCreatedUserDesc', '{triggeruseremail}', '{supportemail}', '{supportemail}', '', '', '[{incidentid}] - {incidenttitle}', 'Hi,\r\n\r\nIncident [{incidentid}] {incidenttitle} has been logged.\r\n\r\nThe details of this incident are:\r\n\r\nPriority: {incidentpriority}\r\nContact: {contactname}\r\nSite: {sitename}\r\n\r\n\r\nRegards\r\n{applicationname}\r\n\r\n-- \r\n{todaysdate} - {applicationshortname} {applicationversion}\r\n{globalsignature}\r\n{triggersfooter}', 'hide', 'No', NULL, NULL, NULL, NULL),
(7, 'EMAIL_INCIDENT_REASSIGNED_USER_NOTIFY', 'user', 'strEmailIncidentReassignedUserNotifyDesc', '{triggeruseremail}', '{supportemail}', '{supportemail}', '', '', '{incidentpriority} priority call ([{incidentid}] - {incidenttitle}) has been reassigned to you', 'Hi,\r\n\r\nIncident [{incidentid}] entitled {incidenttitle} has been reassigned to you.\r\n\r\nThe details of this incident are:\r\n\r\nPriority: {incidentpriority}\r\nContact: {contactname}\r\nSite: {sitename}\r\n\r\n\r\nRegards\r\n{applicationname}\r\n\r\n-- \r\n{todaysdate} - {applicationshortname} {applicationversion}\r\n{globalsignature}\r\n{triggersfooter}', 'hide', 'No', NULL, NULL, NULL, NULL),
(8, 'EMAIL_INCIDENT_NEARING_SLA', 'user', 'strEmailIncidentNearingSlaDesc', '{supportmanageremail}', '{supportemail}', '{supportemail}', '{triggeruseremail}', '', '{applicationshortname} SLA: Incident {incidentid} about to breach SLA', 'This is an automatic notification that this incident is about to breach its SLA.  The SLA target {nextsla} will expire in {nextslatime} minutes.\r\n\r\nIncident: [{incidentid}] - {incidenttitle}\r\nOwner: {incidentowner}\r\nPriority: {incidentpriority}\r\nExternal Id: {incidentexternalid}\r\nExternal Engineer: {incidentexternalengineer}\r\nSite: {sitename}\r\nContact: {contactname}\r\n\r\nRegards\r\n{applicationname}\r\n\r\n-- \r\n{todaysdate} - {applicationshortname} {applicationversion}\r\n{globalsignature}\r\n{triggersfooter}', 'hide', 'No', NULL, NULL, NULL, NULL),
(9, 'EMAIL_CONTACT_RESET_PASSWORD', 'system', 'strEmailContactResetPasswordDesc', '{contactemail}', '{supportemail}', '{supportemail}', '', '', '{applicationshortname} - password reset', 'Hi {contactfirstname},\r\n\r\nThis is a email to reset your contact portal password for {applicationname}. If you did not request this, please ignore this email.\r\n\r\nTo complete your password reset please visit the following url:\r\n\r\n{passwordreseturl}\r\n\r\n\r\n{globalsignature}', 'hide', 'No', NULL, NULL, NULL, NULL),
(10, 'EMAIL_USER_RESET_PASSWORD', 'system', 'strEmailUserResetPasswordDesc', '{useremail}', '{supportemail}', '{supportemail}', '', '', '{applicationshortname} - password reset', 'Hi,\r\n\r\nThis is a email to reset your user account password for {applicationname}. If you did not request this, please ignore this email.\r\n\r\nTo complete your password reset please visit the following url:\r\n\r\n{passwordreseturl}\r\n\r\nRegards\r\n{applicationname}\r\n\r\n-- \r\n{todaysdate} - {applicationshortname} {applicationversion}\r\n{globalsignature}\r\n{triggersfooter}', 'hide', 'No', NULL, NULL, NULL, NULL),
(11, 'EMAIL_NEW_CONTACT_DETAILS', 'system', 'strEmailNewContactDetailsDesc', '{contactemail}', '{supportemail}', '', '', '', '{applicationshortname} - portal details', 'Hello {contactfirstname},\r\nYou have just been added as a contact on {applicationname} ({applicationurl}).\r\n\r\nThese details allow you to the login to the portal, where you can create, update and close your incidents, as well as view your sites'' incidents.\r\n\r\nYour details are as follows:\r\n\r\nusername: {contactusername}\r\npassword: {prepassword}\r\nPlease note, this password cannot be recovered, only reset. You may change it in the portal.\r\n\r\n{globalsignature}', 'hide', 'No', NULL, NULL, NULL, NULL),
(12, 'EMAIL_INCIDENT_REVIEW_DUE', 'system', 'strEmailIncidentReviewDueDesc', '{supportmanageremail}', '{supportemail}', '{supportemail}', NULL, NULL, '{applicationshortname}: review due', 'Hi,\r\n\r\nThe review for incident {incidentid} - {incidenttitle} is now due for review.\r\n\r\nYou can view the incident at {applicationurl}incident_details.php?id={incidentid}\r\n\r\nRegards\r\n{applicationname}\r\n\r\n-- \r\n{todaysdate} - {applicationshortname} {applicationversion}\r\n{globalsignature}\r\n{triggersfooter}', 'hide', 'No', NULL, NULL, NULL, NULL),
(13, 'EMAIL_KB_ARTICLE_CREATED', 'user', 'strEmailKbArticleCreatedDesc', '{triggeruseremail}', '{supportemail}', '{supportemail}', NULL, NULL, '{applicationshortname}: {kbid} KB article created', 'Hi,\r\n\r\nKB article {kbprefix}{kbid} - {kbtitle} has been created by {userrealname}. You can view it at {applicationurl}kb_article.php?id={kbid} : \r\n\r\nRegards\r\n{applicationname}\r\n\r\n-- \r\n{todaysdate} - {applicationshortname} {applicationversion}\r\n{globalsignature}\r\n{triggersfooter}', 'hide', 'No', NULL, NULL, NULL, NULL),
(14, 'EMAIL_HELD_EMAIL_RECEIVED', 'user', 'strEmailHeldEmailReceivedDesc', '{triggeruseremail}', '{supportemail}', '{supportemail}', NULL, NULL, 'New held email', 'Hi,\r\n\r\nThere''s a new email in the holding queue. You can view it at: {applicationurl}holding_queue.php\r\n\r\n\r\nRegards\r\n{applicationname}\r\n\r\n-- \r\n{todaysdate} - {applicationshortname} {applicationversion}\r\n{globalsignature}\r\n{triggersfooter}', 'hide', 'No', NULL, NULL, NULL, NULL),
(15, 'EMAIL_HELD_EMAIL_MINS', 'user', 'strEmailHeldEmailMinsDesc', '{triggeruseremail}', '{supportemail}', '{supportemail}', NULL, NULL, 'New held email', 'Hi,\r\n\r\nThere''s been an email in the holding queue for {holdingemailmins}. You can view it at {applicationurl}holding_queue.php\r\n\r\nRegards\r\n{applicationname}\r\n\r\n-- \r\n{todaysdate} - {applicationshortname} {applicationversion}\r\n{globalsignature}\r\n{triggersfooter}', 'hide', 'No', NULL, NULL, NULL, NULL),
(16, 'EMAIL_USER_CHANGED_STATUS', 'user', 'strEmailUserChangedStatusDesc', '{triggeruseremail}', '{supportemail}', '{supportemail}', NULL, NULL, '{watcheduserrealname} has changed status', 'Hi,\r\n\r\n{userrealname} has set their status to {userstatus} and is {useraccepting} incidents.\r\n\r\nRegards\r\n{applicationname}\r\n\r\n-- \r\n{todaysdate} - {applicationshortname} {applicationversion}\r\n{globalsignature}\r\n{triggersfooter}', 'hide', 'No', NULL, NULL, NULL, NULL),
(17, 'EMAIL_SIT_UPGRADED', 'user', 'strEmailSitUpgradedDesc', '{triggeruseremail}', '{supportemail}', '{supportemail}', NULL, NULL, '{applicationshortname} upgraded', 'Hi,\r\n\r\n{applicationshortname} has been upgraded to {applicationversion}. You can view the changelog at {applicationurl}releasenotes.php?v={applicationversion}\r\n\r\n\r\nRegards\r\n{applicationname}\r\n\r\n-- \r\n{todaysdate} - {applicationshortname} {applicationversion}\r\n{globalsignature}\r\n{triggersfooter}', 'hide', 'No', NULL, NULL, NULL, NULL),
(18, 'EMAIL_CONTACT_CREATED', 'system', 'strEmailContactCreatedDesc', '{triggeruseremail}', '{supportemail}', '{supportemail}', NULL, NULL, 'New contact added', 'Hi,\r\n\r\n{contactname} has been added as a contact to {sitename} by {userealname}.\r\n\r\nRegards\r\n{applicationname}\r\n\r\n-- \r\n{todaysdate} - {applicationshortname} {applicationversion}\r\n{globalsignature}\r\n{triggersfooter}', 'hide', 'No', NULL, NULL, NULL, NULL),
(19, 'EMAIL_INCIDENT_CLOSED_CONTACT', 'system', 'strEmailIncidentClosedContactDesc', '{contactemail}', '{supportemail}', '{supportemail}', NULL, NULL, '[{incidentid}] - {incidenttitle} - Closed', 'Hi {contactfirstname},\r\n\r\nIncident {incidentid} has now been closed. \r\n\r\n\r\n{globalsignature}', 'show', 'Yes', NULL, NULL, NULL, NULL),
(20, 'EMAIL_INCIDENT_CLOSED_USER', 'user', 'strEmailIncidentClosedUserDesc', '{triggeruseremail}', '{supportemail}', '{supportemail}', NULL, NULL, '[{incidentid}] - {incidenttitle} - Closed', 'Hi,\r\n\r\nIncident {incidentid} has now been closed.\r\n\r\n\r\nRegards\r\n{applicationname}\r\n\r\n-- \r\n{todaysdate} - {applicationshortname} {applicationversion}\r\n{globalsignature}\r\n{triggersfooter}', 'show', 'Yes', NULL, NULL, NULL, NULL),
(21, 'EMAIL_CONTRACT_ADDED', 'user', 'strEmailContractAddedDesc', '{triggeruseremail}', '{supportemail}', '{supportemail}', NULL, NULL, 'New contract added to {sitename}', 'Hi,\r\n\r\nA new {contractproduct} contract ID{contractid} has been added to {sitename} by {userealname}. You can view it at {applicationurl}contract_details.php?id={contractid}\r\nRegards\r\n{applicationname}\r\n\r\n-- \r\n{todaysdate} - {applicationshortname} {applicationversion}\r\n{globalsignature}\r\n{triggersfooter}', 'hide', 'No', NULL, NULL, NULL, NULL),
(22, 'EMAIL_USER_CREATED', 'user', 'strEmailUserCreatedDesc', '{triggeruseremail}', '{supportemail}', '{supportemail}', NULL, NULL, 'New user {userrealname} added', 'Hi,\r\n\r\n{userrealname} has just been added as a new user to the {usergroup} group.\r\n\r\n\r\nRegards\r\n{applicationname}\r\n\r\n-- \r\n{todaysdate} - {applicationshortname} {applicationversion}\r\n{globalsignature}\r\n{triggersfooter}', 'hide', 'No', NULL, NULL, NULL, NULL),
(23, 'EMAIL_SITE_CREATED', 'user', 'strEmailSiteCreatedDesc', '{triggeruseremail}', '{supportemail}', '{supportemail}', NULL, NULL, 'New site {sitename} added', 'Hi,\r\n\r\n{sitename} has just been added by {userrealname}. The admin contact is {admincontact}.\r\n\r\nRegards\r\n{applicationname}\r\n\r\n-- \r\n{todaysdate} - {applicationshortname} {applicationversion}\r\n{globalsignature}\r\n{triggersfooter}', 'hide', 'No', NULL, NULL, NULL, NULL),
(24, 'EMAIL_EXTERNAL_INCIDENT_CLOSURE', 'system', 'strEmailExternalIncidentClosureDesc', '{incidentexternalemail}', '{supportemail}', '{supportemail}', NULL, NULL, 'Service Request #{incidentexternalid}  - {incidenttitle} CLOSED - [{incidentid}]', 'Hi {incidentexternalengineerfirstname},\r\n\r\nThis is an automatic email generated from {applicationname}, our call tracking system.\r\n\r\nIncident {incidentexternalid} has been closed.\r\n\r\nMany thanks for your help.\r\n\r\n{signature}\r\n{globalsignature}', 'show', 'Yes', NULL, NULL, NULL, NULL),
(25, 'EMAIL_HOLIDAYS_REQUESTED', 'system', 'strEmailHolidaysRequestedDesc', '{approvaluseremail}', '{supportemail}', '{supportemail}', NULL, NULL, '{applicationshortname}: Holiday approval request', 'Hi,\r\n\r\n{userrealname} has requested that you approve the following holidays:\r\n\r\n{listofholidays}\r\n\r\nPlease point your browser to {applicationurl}holiday_request.php?user={userid}&mode=approval to approve or decline these requests.\r\nRegards\r\n{applicationname}\r\n\r\n-- \r\n{todaysdate} - {applicationshortname} {applicationversion}\r\n{globalsignature}\r\n{triggersfooter}', 'hide', 'No', NULL, NULL, NULL, NULL),
(26, 'EMAIL_SERVICE_LEVEL', 'system', 'strEmailServiceLevelDesc', '{salespersonemail}', '{supportemail}', '{supportemail}', NULL, NULL, '{sitename}''s service credit low', 'Hi, {sitename}''s total service credit is now standing at {serviceremainingstring}.\r\n\r\nRegards\r\n{applicationname}\r\n\r\n-- \r\n{todaysdate} - {applicationshortname} {applicationversion}\r\n{globalsignature}\r\n{triggersfooter}', 'show', 'No', NULL, NULL, NULL, NULL),
(27, 'EMAIL_INCIDENT_UPDATED_CUSTOMER', 'system', 'strEmailIncidentUpdatedCustomerDesc', '{contactemail}', '{supportemail}', '{supportemail}', '', '', '{applicationshortname} [{incidentid}] - {incidenttitle} updated', 'Hi {contactfirstname},\r\n\r\nYour incident [{incidentid}] - {incidentid} has been updated, please log into the portal to view the update and respond.\r\n \r\nDO NOT respond to this e-mail directly, use the portal for your responses.\r\n\r\nLog into the portal at: {applicationurl}, where you can also reset your details if you do not know them.\r\n\r\nRegards,\r\n{signature}\r\n\r\n{globalsignature}', 'hide', 'No', NULL, NULL, NULL, NULL),
(28, 'EMAIL_SEND_FEEDBACK', 'system', 'strEmailSendFeedbackDesc', '{contactemail}', '{supportemail}', '{supportemail}', '', '', '{applicationshortname} [{incidentid}] - {incidenttitle}: feedback requested', 'Hi {contactfirstname},\r\n\r\nWe would very much value your feedback relating to Incident #{incidentid} - {incidenttitle}.\r\n \r\nDO NOT respond to this e-mail directly, use the portal for your responses.\r\n\r\nPlease visit the following URL to complete our short questionnaire.\r\n\r\n{feedbackurl}\r\n\r\nRegards,\r\n{signature}\r\n\r\n{globalsignature}', 'hide', 'No', NULL, NULL, NULL, NULL),
(29, 'EMAIL_TASK_DUE', 'user', 'strEmailTaskDueDesc', '{triggeruseremail}', '{supportemail}', '{supportemail}', NULL, NULL, 'Task ID {taskid} - {taskname} is due', 'Hi,\r\n\r\nThe task {taskname} with ID {taskid} is due\r\n\r\nRegards\r\n{applicationname}\r\n\r\n-- \r\n{todaysdate} - {applicationshortname} {applicationversion}\r\n{globalsignature}\r\n{triggersfooter}', 'hide', 'No', NULL, NULL, NULL, NULL),
(30, 'EMAIL_REQUEST_CLOSURE', 'user', 'strEmailIncidentRequestClosedDesc', '{triggeruseremail}', '{supportemail}', '{supportemail}', NULL, NULL, '{incidentid} - {incidenttitle} - Request Closure', 'Hi,\r\n\r\nIncident {incidentid} has been requested to be closed. \r\n\r\n\r\n{globalsignature}', 'show', 'Yes', NULL, NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]escalationpaths`
--

CREATE TABLE `[[dbprefix]]escalationpaths` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `track_url` varchar(255) DEFAULT NULL,
  `home_url` varchar(255) NOT NULL DEFAULT '',
  `url_title` varchar(255) DEFAULT NULL,
  `email_domain` varchar(255) DEFAULT NULL,
  `createdby` int(11) DEFAULT NULL,
  `modified` datetime DEFAULT NULL,
  `modifiedby` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]feedbackforms`
--

CREATE TABLE `[[dbprefix]]feedbackforms` (
  `id` int(5) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `introduction` text NOT NULL,
  `thanks` text NOT NULL,
  `description` text NOT NULL,
  `multi` enum('yes','no') NOT NULL DEFAULT 'no',
  `created` datetime DEFAULT NULL,
  `createdby` smallint(6) DEFAULT NULL,
  `modified` datetime DEFAULT NULL,
  `modifiedby` smallint(6) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `multi` (`multi`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]feedbackquestions`
--

CREATE TABLE `[[dbprefix]]feedbackquestions` (
  `id` int(5) NOT NULL AUTO_INCREMENT,
  `formid` int(5) NOT NULL DEFAULT '0',
  `question` varchar(255) NOT NULL DEFAULT '',
  `questiontext` text NOT NULL,
  `sectiontext` text NOT NULL,
  `taborder` int(5) NOT NULL DEFAULT '0',
  `type` varchar(255) NOT NULL DEFAULT 'text',
  `required` enum('true','false') NOT NULL DEFAULT 'false',
  `options` text NOT NULL,
  `created` datetime DEFAULT NULL,
  `createdby` smallint(6) DEFAULT NULL,
  `modified` datetime DEFAULT NULL,
  `modifiedby` smallint(6) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `taborder` (`taborder`),
  KEY `type` (`type`),
  KEY `formid` (`formid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]feedbackreport`
--

CREATE TABLE `[[dbprefix]]feedbackreport` (
  `id` int(5) NOT NULL DEFAULT '0',
  `formid` int(5) NOT NULL DEFAULT '0',
  `respondent` int(11) NOT NULL DEFAULT '0',
  `responseref` varchar(255) NOT NULL DEFAULT '',
  `email` varchar(255) NOT NULL DEFAULT '',
  `completed` enum('yes','no') NOT NULL DEFAULT 'no',
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `incidentid` int(5) NOT NULL DEFAULT '0',
  `contactid` int(5) NOT NULL DEFAULT '0',
  `createdby` smallint(6) DEFAULT NULL,
  `modified` datetime DEFAULT NULL,
  `modifiedby` smallint(6) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `responseref` (`responseref`),
  KEY `formid` (`formid`),
  KEY `respondant` (`respondent`),
  KEY `completed` (`completed`),
  KEY `incidentid` (`incidentid`),
  KEY `contactid` (`contactid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]feedbackrespondents`
--

CREATE TABLE `[[dbprefix]]feedbackrespondents` (
  `id` int(5) NOT NULL AUTO_INCREMENT,
  `formid` int(5) NOT NULL DEFAULT '0',
  `contactid` int(11) NOT NULL DEFAULT '0',
  `incidentid` int(11) NOT NULL DEFAULT '0',
  `email` varchar(255) NOT NULL DEFAULT '',
  `completed` enum('yes','no') NOT NULL DEFAULT 'no',
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `responseref` (`incidentid`),
  KEY `formid` (`formid`),
  KEY `contactid` (`contactid`),
  KEY `completed` (`completed`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]feedbackresults`
--

CREATE TABLE `[[dbprefix]]feedbackresults` (
  `id` int(5) NOT NULL AUTO_INCREMENT,
  `respondentid` int(5) NOT NULL DEFAULT '0',
  `questionid` int(5) NOT NULL DEFAULT '0',
  `result` varchar(255) NOT NULL DEFAULT '',
  `resulttext` text,
  `created` datetime DEFAULT NULL,
  `createdby` smallint(6) DEFAULT NULL,
  `modified` datetime DEFAULT NULL,
  `modifiedby` smallint(6) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `questionid` (`questionid`),
  KEY `respondentid` (`respondentid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]files`
--

CREATE TABLE `[[dbprefix]]files` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category` enum('public','private','protected','ftp') NOT NULL DEFAULT 'public',
  `filename` varchar(255) DEFAULT '',
  `size` bigint(11) NOT NULL DEFAULT '0',
  `userid` int(11) NOT NULL DEFAULT '0',
  `usertype` enum('user','contact') NOT NULL DEFAULT 'user',
  `shortdescription` varchar(255) DEFAULT '',
  `longdescription` text,
  `webcategory` varchar(255) DEFAULT '',
  `path` varchar(255) DEFAULT '',
  `downloads` int(11) NOT NULL DEFAULT '0',
  `filedate` datetime NOT NULL,
  `expiry` datetime DEFAULT NULL,
  `fileversion` varchar(50) DEFAULT '',
  `published` enum('yes','no') NOT NULL DEFAULT 'no',
  `created` datetime DEFAULT NULL,
  `createdby` smallint(6) DEFAULT NULL,
  `modified` datetime DEFAULT NULL,
  `modifiedby` smallint(6) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `userid` (`userid`),
  KEY `category` (`category`),
  KEY `filename` (`filename`),
  KEY `published` (`published`),
  KEY `webcategory` (`webcategory`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]groups`
--

CREATE TABLE `[[dbprefix]]groups` (
  `id` int(5) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `imageurl` varchar(255) NOT NULL DEFAULT '',
  `created` datetime DEFAULT NULL,
  `createdby` smallint(6) DEFAULT NULL,
  `modified` datetime DEFAULT NULL,
  `modifiedby` smallint(6) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='List of user groups' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]holidays`
--

CREATE TABLE `[[dbprefix]]holidays` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `userid` smallint(6) NOT NULL DEFAULT '0',
  `type` int(11) NOT NULL DEFAULT '1',
  `length` enum('am','pm','day') NOT NULL DEFAULT 'day',
  `approved` tinyint(1) NOT NULL DEFAULT '0',
  `approvedby` smallint(6) NOT NULL DEFAULT '0',
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `userid` (`userid`),
  KEY `type` (`type`),
  KEY `approved` (`approved`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]incidentpools`
--

CREATE TABLE `[[dbprefix]]incidentpools` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `maintenanceid` int(11) NOT NULL DEFAULT '0',
  `siteid` int(11) NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `incidentsremaining` int(5) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `maintenanceid` (`maintenanceid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]incidentproductinfo`
--

CREATE TABLE `[[dbprefix]]incidentproductinfo` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `incidentid` int(11) DEFAULT NULL,
  `productinfoid` int(11) DEFAULT NULL,
  `information` text,
  `created` datetime DEFAULT NULL,
  `createdby` smallint(6) DEFAULT NULL,
  `modified` datetime DEFAULT NULL,
  `modifiedby` smallint(6) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]incidents`
--

CREATE TABLE `[[dbprefix]]incidents` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `escalationpath` int(11) DEFAULT NULL,
  `externalid` varchar(50) DEFAULT NULL,
  `externalengineer` varchar(80) NOT NULL DEFAULT '',
  `externalemail` varchar(255) NOT NULL DEFAULT '',
  `ccemail` varchar(255) DEFAULT NULL,
  `title` varchar(150) DEFAULT NULL,
  `owner` smallint(6) DEFAULT NULL,
  `towner` smallint(6) NOT NULL DEFAULT '0',
  `contact` int(11) DEFAULT '0',
  `priority` tinyint(4) DEFAULT NULL,
  `servicelevel` varchar(10) DEFAULT NULL,
  `status` tinyint(4) DEFAULT NULL,
  `type` enum('Support','Sales','Other','Free') DEFAULT 'Support',
  `maintenanceid` int(11) NOT NULL DEFAULT '0',
  `product` int(11) DEFAULT NULL,
  `softwareid` int(5) NOT NULL DEFAULT '0',
  `productversion` varchar(50) DEFAULT NULL,
  `productservicepacks` varchar(100) DEFAULT NULL,
  `opened` int(11) DEFAULT NULL,
  `lastupdated` int(11) DEFAULT NULL,
  `timeofnextaction` int(11) DEFAULT '0',
  `closed` int(11) DEFAULT '0',
  `closingstatus` tinyint(4) DEFAULT NULL,
  `slaemail` tinyint(1) NOT NULL DEFAULT '0',
  `slanotice` tinyint(1) NOT NULL DEFAULT '0',
  `locked` tinyint(4) NOT NULL DEFAULT '0',
  `locktime` int(11) NOT NULL DEFAULT '0',
  `created` datetime DEFAULT NULL,
  `createdby` smallint(6) DEFAULT NULL,
  `modified` datetime DEFAULT NULL,
  `modifiedby` smallint(6) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `type` (`type`),
  KEY `owner` (`owner`),
  KEY `status` (`status`),
  KEY `priority` (`priority`),
  KEY `timeofnextaction` (`timeofnextaction`),
  KEY `maintenanceid` (`maintenanceid`),
  KEY `softwareid` (`softwareid`),
  KEY `contact` (`contact`),
  KEY `title` (`title`),
  KEY `opened` (`opened`),
  KEY `closed` (`closed`),
  KEY `servicelevel` (`servicelevel`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]incidentstatus`
--

CREATE TABLE `[[dbprefix]]incidentstatus` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT NULL,
  `ext_name` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=11 ;

--
-- Dumping data for table `[[dbprefix]]incidentstatus`
--

INSERT INTO `[[dbprefix]]incidentstatus` VALUES
(1, 'strActive', 'strActive'),
(2, 'strClosed', 'strClosed'),
(3, 'strResearchNeeded', 'strResearching'),
(4, 'strCalledAndLeftMessage', 'strCalledAndLeftMessage'),
(5, 'strAwaitingColleagueResponse', 'strInternalEscalation'),
(6, 'strAwaitingSupportResponse', 'strExternalEscalation'),
(7, 'strAwaitingClosure', 'strAwaitingClosure'),
(8, 'strAwaitingCustomerAction', 'strAwaitingYourResponse'),
(9, 'strUnsupported', 'strUnsupported'),
(10, 'strActiveUnassigned', 'strActive');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]interfacestyles`
--

CREATE TABLE `[[dbprefix]]interfacestyles` (
  `id` int(5) NOT NULL,
  `name` varchar(50) NOT NULL DEFAULT '',
  `cssurl` varchar(255) NOT NULL DEFAULT '',
  `iconset` varchar(255) NOT NULL DEFAULT 'sit',
  `headerhtml` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]interfacestyles`
--

INSERT INTO `[[dbprefix]]interfacestyles` VALUES
(1, 'Light Blue', 'sit1.css', 'sit', ''),
(2, 'Grey', 'sit2.css', 'sit', ''),
(3, 'Green', 'sit3.css', 'sit', ''),
(4, 'Silver Blue', 'sit4.css', 'sit', ''),
(5, 'Classic', 'sit5.css', 'sit', ''),
(6, 'Orange', 'sit_ph2.css', 'sit', ''),
(7, 'Yellow and Blue', 'sit7.css', 'sit', ''),
(8, 'Neoteric', 'sit8.css', 'oxygen', ''),
(9, 'Toms Linux Style', 'sit9.css', 'sit', ''),
(10, 'Cool Blue', 'sit_ph.css', 'sit', ''),
(11, 'Just Light', 'sit10.css', 'sit', ''),
(12, 'Ex Pea', 'sit11.css', 'sit', ''),
(13, 'GUI Colours', 'sit12.css', 'sit', ''),
(14, 'Flashy', 'sit14/sit14.css', 'sit', ''),
(15, 'Richard', 'sit15.css', 'sit', ''),
(16, 'Cake', 'sit_cake.css', 'sit', '');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]inventory`
--

CREATE TABLE `[[dbprefix]]inventory` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `identifier` varchar(255) DEFAULT NULL,
  `name` varchar(255) NOT NULL,
  `siteid` int(11) NOT NULL,
  `contactid` int(11) NOT NULL,
  `address` varchar(255) NOT NULL,
  `url` varchar(255) DEFAULT NULL,
  `username` varchar(255) NOT NULL,
  `password` varchar(255) NOT NULL,
  `type` varchar(255) NOT NULL,
  `notes` text,
  `createdby` smallint(6) NOT NULL,
  `created` datetime NOT NULL,
  `modified` datetime NOT NULL,
  `modifiedby` smallint(6) NOT NULL,
  `active` tinyint(1) NOT NULL DEFAULT '1',
  `privacy` enum('none','adminonly','private') NOT NULL DEFAULT 'none',
  PRIMARY KEY (`id`),
  KEY `siteid` (`siteid`,`contactid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]journal`
--

CREATE TABLE `[[dbprefix]]journal` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `userid` smallint(6) NOT NULL DEFAULT '0',
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `event` varchar(40) NOT NULL DEFAULT '',
  `bodytext` text NOT NULL,
  `journaltype` int(11) NOT NULL DEFAULT '0',
  `refid` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `refid` (`refid`),
  KEY `userid` (`userid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]kbarticles`
--

CREATE TABLE `[[dbprefix]]kbarticles` (
  `docid` int(5) NOT NULL AUTO_INCREMENT,
  `doctype` int(5) NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT '',
  `distribution` enum('public','private','restricted') NOT NULL DEFAULT 'public' COMMENT 'public appears in the portal, private is info never to be released to the public,\n  restricted is info that is sensitive but could be mentioned if asked, for example',
  `published` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `author` varchar(255) NOT NULL DEFAULT '',
  `reviewed` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `reviewer` smallint(6) NOT NULL DEFAULT '0',
  `keywords` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`docid`),
  KEY `distribution` (`distribution`),
  KEY `title` (`title`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='Knowledge base articles' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]kbcontent`
--

CREATE TABLE `[[dbprefix]]kbcontent` (
  `docid` int(5) NOT NULL DEFAULT '0',
  `id` int(7) NOT NULL AUTO_INCREMENT,
  `ownerid` smallint(6) NOT NULL DEFAULT '0',
  `headerstyle` char(2) NOT NULL DEFAULT 'h1',
  `header` varchar(255) NOT NULL DEFAULT '',
  `contenttype` int(5) NOT NULL DEFAULT '1',
  `content` mediumtext NOT NULL,
  `distribution` enum('public','private','restricted') NOT NULL DEFAULT 'private',
  PRIMARY KEY (`id`),
  KEY `distribution` (`distribution`),
  KEY `ownerid` (`ownerid`),
  KEY `docid` (`docid`),
  FULLTEXT KEY `c_index` (`content`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]kbsoftware`
--

CREATE TABLE `[[dbprefix]]kbsoftware` (
  `docid` int(5) NOT NULL DEFAULT '0',
  `softwareid` int(5) NOT NULL DEFAULT '0',
  PRIMARY KEY (`docid`,`softwareid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='Links kb articles with software';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]licencetypes`
--

CREATE TABLE `[[dbprefix]]licencetypes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=6 ;

--
-- Dumping data for table `[[dbprefix]]licencetypes`
--

INSERT INTO `[[dbprefix]]licencetypes` VALUES
(1, 'Per User'),
(2, 'Per Workstation'),
(3, 'Per Server'),
(4, 'Site'),
(5, 'Evaluation');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]links`
--

CREATE TABLE `[[dbprefix]]links` (
  `linktype` int(11) NOT NULL DEFAULT '0',
  `origcolref` int(11) NOT NULL DEFAULT '0',
  `linkcolref` int(11) NOT NULL DEFAULT '0',
  `direction` enum('left','right','bi') NOT NULL DEFAULT 'left',
  `userid` smallint(6) NOT NULL DEFAULT '0',
  PRIMARY KEY (`linktype`,`origcolref`,`linkcolref`),
  KEY `userid` (`userid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]linktypes`
--

CREATE TABLE `[[dbprefix]]linktypes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `lrname` varchar(255) NOT NULL DEFAULT '',
  `rlname` varchar(255) NOT NULL DEFAULT '',
  `origtab` varchar(255) NOT NULL DEFAULT '',
  `origcol` varchar(255) NOT NULL DEFAULT '',
  `linktab` varchar(255) NOT NULL DEFAULT '',
  `linkcol` varchar(255) NOT NULL DEFAULT 'id',
  `selectionsql` varchar(255) NOT NULL DEFAULT '',
  `filtersql` varchar(255) NOT NULL DEFAULT '',
  `viewurl` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `origtab` (`origtab`),
  KEY `linktab` (`linktab`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=7 ;

--
-- Dumping data for table `[[dbprefix]]linktypes`
--

INSERT INTO `[[dbprefix]]linktypes` VALUES
(1, 'Task', 'Subtask', 'Parent Task', 'tasks', 'id', 'tasks', 'id', 'name', '', 'view_task.php?id=%id%'),
(2, 'Contact', 'Contact', 'Contact Task', 'tasks', 'id', 'contacts', 'id', 'CONCAT(forenames, " ", surname)', '', 'contact_details.php?id=%id%'),
(3, 'Site', 'Site', 'Site Task', 'tasks', 'id', 'sites', 'id', 'name', '', 'site_details.php?id=%id%'),
(4, 'Incident', 'Incident', 'Task', 'incidents', 'id', 'tasks', 'id', 'title', '', 'incident_details.php?id=%id%'),
(5, 'Attachments', 'Update', 'File', 'updates', 'id', 'files', 'id', 'filename', '', 'incident_details.php?updateid=%id%&tab=files'),
(6, 'Incident', 'Transaction', 'Incidents', 'transactions', 'transactionid', 'incidents', 'id', '', '', '');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]maintenance`
--

CREATE TABLE `[[dbprefix]]maintenance` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `site` int(11) DEFAULT NULL,
  `product` int(11) DEFAULT NULL,
  `reseller` int(11) DEFAULT NULL,
  `expirydate` int(11) DEFAULT NULL,
  `licence_quantity` int(11) DEFAULT NULL,
  `licence_type` int(11) DEFAULT NULL,
  `incident_quantity` int(5) NOT NULL DEFAULT '0',
  `incidents_used` int(5) NOT NULL DEFAULT '0',
  `notes` text,
  `admincontact` int(11) DEFAULT NULL,
  `productonly` enum('yes','no') NOT NULL DEFAULT 'no',
  `term` enum('no','yes') DEFAULT 'no',
  `servicelevelid` int(11) NOT NULL DEFAULT '1',
  `incidentpoolid` int(11) NOT NULL DEFAULT '0',
  `supportedcontacts` int(255) NOT NULL DEFAULT '0',
  `allcontactssupported` enum('no','yes') NOT NULL DEFAULT 'no',
  `var_incident_visible_contacts` enum('yes','no') NOT NULL DEFAULT 'no',
  `var_incident_visible_all` enum('yes','no') NOT NULL DEFAULT 'no',
  PRIMARY KEY (`id`),
  KEY `site` (`site`),
  KEY `productonly` (`productonly`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]notes`
--

CREATE TABLE `[[dbprefix]]notes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `userid` smallint(6) NOT NULL DEFAULT '0',
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `bodytext` text NOT NULL,
  `link` int(11) NOT NULL DEFAULT '0',
  `refid` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `refid` (`refid`),
  KEY `userid` (`userid`),
  KEY `link` (`link`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]notices`
--

CREATE TABLE `[[dbprefix]]notices` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `userid` smallint(6) NOT NULL,
  `template` varchar(255) DEFAULT NULL,
  `type` tinyint(4) NOT NULL,
  `text` tinytext NOT NULL,
  `linktext` varchar(50) DEFAULT NULL,
  `link` varchar(100) NOT NULL,
  `referenceid` int(11) DEFAULT NULL,
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `durability` enum('sticky','session') NOT NULL DEFAULT 'sticky',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]noticetemplates`
--

CREATE TABLE `[[dbprefix]]noticetemplates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `type` tinyint(4) NOT NULL,
  `description` varchar(255) NOT NULL,
  `text` tinytext NOT NULL,
  `linktext` varchar(50) DEFAULT NULL,
  `link` varchar(100) DEFAULT NULL,
  `durability` enum('sticky','session') NOT NULL DEFAULT 'sticky',
  `refid` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=19 ;

--
-- Dumping data for table `[[dbprefix]]noticetemplates`
--

INSERT INTO `[[dbprefix]]noticetemplates` VALUES
(1, 'NOTICE_INCIDENT_CREATED', 3, 'strNoticeIncidentCreatedDesc', 'strNoticeIncidentCreated', 'strViewIncident', 'javascript:incident_details_window({incidentid})', 'sticky', '{incidentid}'),
(2, 'NOTICE_INCIDENT_ASSIGNED', 3, 'strNoticeIncidentAssignedDesc', 'strNoticeIncidentAssigned', 'strViewIncident', 'javascript:incident_details_window({incidentid})', 'sticky', '{incidentid}'),
(3, 'NOTICE_INCIDENT_NEARING_SLA', 3, 'strNoticeIncidentNearingSLADesc', 'strNoticeIncidentNearingSLA', 'strViewIncident', 'javascript:incident_details_window({incidentid})', 'sticky', '{incidentid}'),
(4, 'NOTICE_LANGUAGE_DIFFERS', 3, 'strNoticeLanguageDiffersDesc', 'strNoticeLanguageDiffers', 'strKeepCurrentLanguage', '{applicationurl}user_profile_edit.php?mode=savesessionlang', 'session', '{currentlang}'),
(5, 'NOTICE_NEW_CONTACT', 3, 'strNoticeNewContactDesc', 'strNoticeNewContact', 'strViewContact', '{applicationurl}contact_details.php?id={contactid}', 'sticky', '{contactid}'),
(6, 'NOTICE_INCIDENT_REVIEW_DUE', 3, 'strNoticeIncidentReviewDueDesc', 'strNoticeIncidentReviewDue', 'strViewIncident', 'javascript:incident_details_window({incidentid})', 'sticky', '{incidentid}'),
(7, 'NOTICE_KB_CREATED', 3, 'strNoticeKBCreatedDesc', 'strNoticeKBCreated', 'strViewArticle', '{applicationurl}kb_view_article.php?id={kbid}', 'sticky', '{kbid}'),
(8, 'NOTICE_NEW_HELD_EMAIL', 3, 'strNoticeNewHeldEmailDesc', 'strNoticeNewHeldEmail', 'strViewHoldingQueue', '{applicationurl}holding_queue.php', 'sticky', '{holdingemailid}'),
(9, 'NOTICE_MINS_HELD_EMAIL', 3, 'strNoticeMinsHeldEmailDesc', 'strNoticeMinsHeldEmail', 'strViewHoldingQueue', '{applicationurl}holding_queue.php', 'sticky', '{holdingemailid}'),
(10, 'NOTICE_SIT_UPGRADED', 3, 'strNoticeSitUpgradedDesc', 'strNoticeSitUpgraded', 'strWhatsNew', '{applicationurl}releasenotes.php?v={applicationversion}', 'sticky', '{applicationversion}'),
(11, 'NOTICE_USER_CHANGED_STATUS', 3, 'strNoticeUserChangedStatusDesc', 'strNoticeUserChangedStatus', NULL, '', 'sticky', '{userid}'),
(12, 'NOTICE_NEW_USER', 3, 'strNoticeNewUserDesc', 'strNoticeNewUser', NULL, NULL, 'sticky', '{userid}'),
(13, 'NOTICE_INCIDENT_CLOSED', 3, 'strNoticeIncidentClosedDesc', 'strNoticeIncidentClosed', NULL, NULL, 'sticky', '{incidentid}'),
(14, 'NOTICE_NEW_CONTRACT', 3, 'strNoticeNewContractDesc', 'strNoticeNewContract', 'strViewContract', '{applicationurl}contract_details.php?id={contractid}', 'sticky', '{contractid}'),
(15, 'NOTICE_NEW_SITE', 3, 'strNoticeNewSiteDesc', 'strNoticeNewSite', 'strViewSite', '{applicationurl}site_details.php?id={siteid}', 'sticky', '{siteid}'),
(16, 'NOTICE_TASK_DUE', 3, 'strNoticeTaskDueDesc', 'strNoticeTaskDue', 'strViewTask', '{applicationurl}view_task.php?id={taskid}', 'sticky', '{taskid}'),
(17, 'NOTICE_SCHEDULER_TASK_FAILED', 3, 'strNoticeSchedulerTaskFailedDesc', 'strNoticeSchedulerTaskFailed', '', '', 'sticky', ''),
(18, 'NOTICE_REQUEST_CLOSURE', 3, 'strNoticeIncidentRequestClosedDesc', 'strNoticeIncidentRequestClosed', NULL, NULL, 'sticky', '{userid}');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]permissioncategories`
--

CREATE TABLE `[[dbprefix]]permissioncategories` (
  `id` int(5) NOT NULL AUTO_INCREMENT,
  `category` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=12 ;

--
-- Dumping data for table `[[dbprefix]]permissioncategories`
--

INSERT INTO `[[dbprefix]]permissioncategories` VALUES
(1, 'strSupport'),
(2, 'strCustomers'),
(3, 'strContracts'),
(4, 'strTasks'),
(5, 'strKBabbr'),
(6, 'strPortal'),
(7, 'strConfiguration'),
(8, 'strBilling'),
(9, 'strReports'),
(10, 'strHolidays'),
(11, 'strOther');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]permissions`
--

CREATE TABLE `[[dbprefix]]permissions` (
  `id` int(5) NOT NULL AUTO_INCREMENT,
  `categoryid` int(5) NOT NULL,
  `name` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `categoryid` (`categoryid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=82 ;

--
-- Dumping data for table `[[dbprefix]]permissions`
--

INSERT INTO `[[dbprefix]]permissions` VALUES
(1, 2, 'Add new contacts'),
(2, 2, 'Add new sites'),
(3, 2, 'Edit existing site details'),
(4, 7, 'Edit your profile'),
(5, 1, 'Add Incidents'),
(6, 1, 'View Incidents'),
(7, 1, 'Edit Incidents'),
(8, 1, 'Update Incidents'),
(9, 7, 'Edit User Permissions'),
(10, 2, 'Edit contacts'),
(11, 2, 'View Sites'),
(12, 2, 'View Contacts'),
(13, 1, 'Reassign Incidents'),
(14, 11, 'View Users'),
(15, 3, 'Add Supported Products'),
(16, 7, 'Add Templates'),
(17, 7, 'Edit Templates'),
(18, 1, 'Close Incidents'),
(19, 3, 'View Maintenance Contracts'),
(20, 7, 'Add Users'),
(21, 3, 'Edit Maintenance Contracts'),
(22, 7, 'Administrate'),
(23, 7, 'Edit User'),
(24, 3, 'Add Product'),
(25, 3, 'Add Product Information'),
(26, 11, 'Get Help'),
(27, 10, 'View Your Calendar'),
(28, 3, 'View Products and Software'),
(29, 3, 'Edit Products'),
(30, 3, 'View Supported Products'),
(32, 3, 'Edit Supported Products'),
(33, 11, 'Send Emails'),
(34, 1, 'Reopen Incidents'),
(35, 11, 'Set your status'),
(36, 2, 'Set contact flags'),
(37, 9, 'Run Reports'),
(38, 1, 'View Sales Incidents'),
(39, 3, 'Add Maintenance Contract'),
(40, 1, 'Reassign Incident when user not accepting'),
(41, 11, 'View Status'),
(42, 1, 'Review/Delete Incident updates'),
(43, 7, 'Edit Global Signature'),
(44, 11, 'Publish files to FTP site'),
(45, 11, 'View Mailing List Subscriptions'),
(46, 11, 'Edit Mailing List Subscriptions'),
(47, 11, 'Administrate Mailing Lists'),
(48, 7, 'Add Feedback Forms'),
(49, 7, 'Edit Feedback Forms'),
(50, 10, 'Approve Holidays'),
(51, 1, 'View Feedback'),
(52, 1, 'View Hidden Updates'),
(53, 7, 'Edit Service Levels'),
(54, 5, 'View KB Articles'),
(55, 2, 'Delete Sites/Contacts'),
(56, 3, 'Add Software'),
(57, 7, 'Disable User Accounts'),
(58, 7, 'Edit your Software Skills'),
(59, 7, 'Manage users software skills'),
(60, 11, 'Perform Searches'),
(61, 1, 'View Incident Details'),
(62, 1, 'View Incident Attachments'),
(63, 3, 'Add Reseller'),
(64, 7, 'Manage Escalation Paths'),
(65, 3, 'Delete Products'),
(66, 7, 'Install Dashboard Components'),
(67, 9, 'Run Management Reports'),
(68, 10, 'Manage Holidays'),
(69, 4, 'View your Tasks'),
(70, 4, 'Create/Edit your Tasks'),
(71, 7, 'Manage your Triggers'),
(72, 7, 'Manage System Triggers'),
(73, 8, 'Approve Billable Incidents'),
(74, 8, 'Set duration without activity (for billable incidents)'),
(75, 8, 'Set negative time for duration on incidents (for billable incidents - refunds)'),
(76, 8, 'View Transactions'),
(77, 8, 'View Billing Information'),
(78, 11, 'Post System Notices'),
(79, 8, 'Edit Service Balances'),
(80, 8, 'Edit Service Details'),
(81, 8, 'Adjust durations on activities');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]priority`
--

CREATE TABLE `[[dbprefix]]priority` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='Used in incidents.php' AUTO_INCREMENT=5 ;

--
-- Dumping data for table `[[dbprefix]]priority`
--

INSERT INTO `[[dbprefix]]priority` VALUES
(1, 'Low'),
(2, 'Medium'),
(3, 'High'),
(4, 'Critical');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]productinfo`
--

CREATE TABLE `[[dbprefix]]productinfo` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `productid` int(11) DEFAULT NULL,
  `information` text,
  `moreinformation` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]products`
--

CREATE TABLE `[[dbprefix]]products` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `vendorid` int(5) NOT NULL DEFAULT '0',
  `name` varchar(50) DEFAULT NULL,
  `description` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `vendorid` (`vendorid`),
  KEY `name` (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='Current List of Products' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]relatedincidents`
--

CREATE TABLE `[[dbprefix]]relatedincidents` (
  `id` int(5) NOT NULL AUTO_INCREMENT,
  `incidentid` int(5) NOT NULL,
  `relation` enum('child','sibling') NOT NULL DEFAULT 'child',
  `relatedid` int(5) NOT NULL,
  `owner` smallint(6) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `incidentid` (`incidentid`,`relatedid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]resellers`
--

CREATE TABLE `[[dbprefix]]resellers` (
  `id` tinyint(4) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]resellers`
--

INSERT INTO `[[dbprefix]]resellers` VALUES
(1, 'Us (No Reseller)');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]rolepermissions`
--

CREATE TABLE `[[dbprefix]]rolepermissions` (
  `roleid` tinyint(4) NOT NULL DEFAULT '0',
  `permissionid` int(5) NOT NULL DEFAULT '0',
  `granted` enum('true','false') NOT NULL DEFAULT 'false',
  PRIMARY KEY (`roleid`,`permissionid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]rolepermissions`
--

INSERT INTO `[[dbprefix]]rolepermissions` VALUES
(1, 1, 'true'),
(1, 2, 'true'),
(1, 3, 'true'),
(1, 4, 'true'),
(1, 5, 'true'),
(1, 6, 'true'),
(1, 7, 'true'),
(1, 8, 'true'),
(1, 9, 'true'),
(1, 10, 'true'),
(1, 11, 'true'),
(1, 12, 'true'),
(1, 13, 'true'),
(1, 14, 'true'),
(1, 15, 'true'),
(1, 16, 'true'),
(1, 17, 'true'),
(1, 18, 'true'),
(1, 19, 'true'),
(1, 20, 'true'),
(1, 21, 'true'),
(1, 22, 'true'),
(1, 23, 'true'),
(1, 24, 'true'),
(1, 25, 'true'),
(1, 26, 'true'),
(1, 27, 'true'),
(1, 28, 'true'),
(1, 29, 'true'),
(1, 30, 'true'),
(1, 32, 'true'),
(1, 33, 'true'),
(1, 34, 'true'),
(1, 35, 'true'),
(1, 36, 'true'),
(1, 37, 'true'),
(1, 38, 'true'),
(1, 39, 'true'),
(1, 40, 'true'),
(1, 41, 'true'),
(1, 42, 'true'),
(1, 43, 'true'),
(1, 44, 'true'),
(1, 45, 'true'),
(1, 46, 'true'),
(1, 47, 'true'),
(1, 48, 'true'),
(1, 49, 'true'),
(1, 50, 'true'),
(1, 51, 'true'),
(1, 52, 'true'),
(1, 53, 'true'),
(1, 54, 'true'),
(1, 55, 'true'),
(1, 56, 'true'),
(1, 57, 'true'),
(1, 58, 'true'),
(1, 59, 'true'),
(1, 60, 'true'),
(1, 61, 'true'),
(1, 62, 'true'),
(1, 63, 'true'),
(1, 64, 'true'),
(1, 65, 'true'),
(1, 66, 'true'),
(1, 67, 'true'),
(1, 68, 'true'),
(1, 69, 'true'),
(1, 70, 'true'),
(1, 71, 'true'),
(1, 72, 'true'),
(1, 73, 'true'),
(1, 74, 'true'),
(1, 75, 'true'),
(1, 76, 'true'),
(1, 77, 'true'),
(1, 78, 'true'),
(1, 79, 'true'),
(1, 80, 'true'),
(1, 81, 'true'),
(2, 1, 'true'),
(2, 2, 'true'),
(2, 3, 'true'),
(2, 4, 'true'),
(2, 5, 'true'),
(2, 6, 'true'),
(2, 7, 'true'),
(2, 8, 'true'),
(2, 10, 'true'),
(2, 11, 'true'),
(2, 12, 'true'),
(2, 13, 'true'),
(2, 14, 'true'),
(2, 15, 'true'),
(2, 16, 'true'),
(2, 17, 'true'),
(2, 18, 'true'),
(2, 19, 'true'),
(2, 21, 'true'),
(2, 24, 'true'),
(2, 25, 'true'),
(2, 26, 'true'),
(2, 27, 'true'),
(2, 28, 'true'),
(2, 29, 'true'),
(2, 30, 'true'),
(2, 32, 'true'),
(2, 33, 'true'),
(2, 34, 'true'),
(2, 35, 'true'),
(2, 36, 'true'),
(2, 37, 'true'),
(2, 38, 'true'),
(2, 39, 'true'),
(2, 40, 'true'),
(2, 41, 'true'),
(2, 42, 'true'),
(2, 43, 'true'),
(2, 44, 'true'),
(2, 45, 'true'),
(2, 46, 'true'),
(2, 47, 'true'),
(2, 48, 'true'),
(2, 49, 'true'),
(2, 50, 'true'),
(2, 51, 'true'),
(2, 52, 'true'),
(2, 53, 'true'),
(2, 54, 'true'),
(2, 55, 'true'),
(2, 56, 'true'),
(2, 58, 'true'),
(2, 59, 'true'),
(2, 60, 'true'),
(2, 61, 'true'),
(2, 62, 'true'),
(2, 67, 'true'),
(2, 69, 'true'),
(2, 70, 'true'),
(2, 71, 'true'),
(2, 73, 'true'),
(2, 76, 'true'),
(2, 77, 'true'),
(3, 1, 'true'),
(3, 2, 'true'),
(3, 3, 'true'),
(3, 4, 'true'),
(3, 5, 'true'),
(3, 6, 'true'),
(3, 7, 'true'),
(3, 8, 'true'),
(3, 10, 'true'),
(3, 11, 'true'),
(3, 12, 'true'),
(3, 13, 'true'),
(3, 14, 'true'),
(3, 18, 'true'),
(3, 19, 'true'),
(3, 26, 'true'),
(3, 27, 'true'),
(3, 28, 'true'),
(3, 30, 'true'),
(3, 33, 'true'),
(3, 34, 'true'),
(3, 35, 'true'),
(3, 36, 'true'),
(3, 37, 'true'),
(3, 38, 'true'),
(3, 41, 'true'),
(3, 44, 'true'),
(3, 52, 'true'),
(3, 54, 'true'),
(3, 58, 'true'),
(3, 60, 'true'),
(3, 61, 'true'),
(3, 62, 'true'),
(3, 69, 'true'),
(3, 70, 'true'),
(3, 71, 'true');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]roles`
--

CREATE TABLE `[[dbprefix]]roles` (
  `id` int(5) NOT NULL AUTO_INCREMENT,
  `rolename` varchar(255) NOT NULL,
  `description` text,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=4 ;

--
-- Dumping data for table `[[dbprefix]]roles`
--

INSERT INTO `[[dbprefix]]roles` VALUES
(1, 'Administrator', NULL),
(2, 'Manager', NULL),
(3, 'User', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]scheduler`
--

CREATE TABLE `[[dbprefix]]scheduler` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `action` varchar(50) NOT NULL,
  `params` varchar(255) NOT NULL,
  `paramslabel` varchar(255) DEFAULT NULL,
  `description` tinytext NOT NULL,
  `status` enum('enabled','disabled') NOT NULL DEFAULT 'enabled',
  `start` datetime NOT NULL,
  `end` datetime NOT NULL,
  `type` enum('interval','date') NOT NULL DEFAULT 'interval',
  `interval` int(11) NOT NULL,
  `date_type` enum('month','year') NOT NULL COMMENT 'For type date the type',
  `date_offset` int(11) NOT NULL DEFAULT '0' COMMENT 'off set into the period',
  `date_time` time DEFAULT NULL COMMENT 'Time to perform action',
  `laststarted` datetime DEFAULT NULL,
  `lastran` datetime DEFAULT NULL,
  `success` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `job` (`action`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=11 ;

--
-- Dumping data for table `[[dbprefix]]scheduler`
--

INSERT INTO `[[dbprefix]]scheduler` VALUES
(1, 'CloseIncidents', '554400', 'closure_delay', 'Close incidents that have been marked for closure for longer than the <var>closure_delay</var> parameter (which is in seconds)', 'enabled', '2008-01-01 00:00:00', '0000-00-00 00:00:00', 'interval', 60, 'month', 0, NULL, NULL, '0000-00-00 00:00:00', 1),
(2, 'SetUserStatus', '', NULL, '(EXPERIMENTAL) This will set users status                         based on data from their holiday calendar.                        e.g. Out of Office/Away sick.', 'enabled', '2008-01-01 00:00:00', '0000-00-00 00:00:00', 'interval', 60, 'month', 0, NULL, NULL, '0000-00-00 00:00:00', 1),
(3, 'PurgeJournal', '', NULL, 'Delete old journal entries according to the config setting <var>$CONFIG[''journal_purge_after'']</var>', 'enabled', '2008-01-01 00:00:00', '0000-00-00 00:00:00', 'interval', 300, 'month', 0, NULL, NULL, '0000-00-00 00:00:00', 1),
(4, 'TimeCalc', '', NULL, 'Calculate SLA Target Times and trigger                        OUT_OF_SLA and OUT_OF_REVIEW system email templates where appropriate.', 'enabled', '2008-01-01 00:00:00', '0000-00-00 00:00:00', 'interval', 60, 'month', 0, NULL, NULL, '0000-00-00 00:00:00', 1),
(5, 'ChaseCustomers', '', NULL, 'Chase customers', 'disabled', '2008-01-01 00:00:00', '0000-00-00 00:00:00', 'interval', 3600, 'month', 0, NULL, NULL, '0000-00-00 00:00:00', 1),
(6, 'CheckWaitingEmail', '', NULL, 'Checks the holding queue for emails and fires the TRIGGER_WAITING_HELD_EMAIL trigger when it finds some.', 'enabled', '2008-01-01 00:00:00', '0000-00-00 00:00:00', 'interval', 60, 'month', 0, NULL, NULL, '0000-00-00 00:00:00', 1),
(7, 'PurgeExpiredFTPItems', '', NULL, 'purges files which have expired from the FTP site when run.', 'enabled', '2008-01-01 00:00:00', '0000-00-00 00:00:00', 'interval', 216000, 'month', 0, NULL, NULL, '0000-00-00 00:00:00', 1),
(8, 'CheckIncomingMail', '', NULL, 'Check incoming support mailbox.', 'enabled', '2008-01-01 00:00:00', '0000-00-00 00:00:00', 'interval', 60, 'month', 0, NULL, NULL, '0000-00-00 00:00:00', 1),
(9, 'CheckTasksDue', '', NULL, 'Checks for due tasks.', 'enabled', '2008-01-01 00:00:00', '0000-00-00 00:00:00', 'interval', 3600, 'month', 0, NULL, NULL, '0000-00-00 00:00:00', 1),
(10, 'ldapSync', '', NULL, 'Sync users and customers from LDAP', 'enabled', '2008-01-01 00:00:00', '0000-00-00 00:00:00', 'interval', 60, 'month', 0, '00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]service`
--

CREATE TABLE `[[dbprefix]]service` (
  `serviceid` int(11) NOT NULL AUTO_INCREMENT,
  `contractid` int(11) NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `lastbilled` datetime NOT NULL,
  `creditamount` float NOT NULL DEFAULT '0',
  `balance` float NOT NULL DEFAULT '0',
  `unitrate` float NOT NULL DEFAULT '0',
  `incidentrate` float NOT NULL DEFAULT '0',
  `dailyrate` float NOT NULL DEFAULT '0',
  `billingmatrix` int(11) NOT NULL DEFAULT '1',
  `priority` smallint(6) NOT NULL DEFAULT '0',
  `cust_ref` varchar(255) DEFAULT NULL,
  `cust_ref_date` date DEFAULT NULL,
  `title` varchar(255) DEFAULT NULL,
  `notes` text NOT NULL,
  `foc` enum('yes','no') NOT NULL DEFAULT 'no' COMMENT 'Free of charge (customer not charged)',
  PRIMARY KEY (`serviceid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]servicelevels`
--

CREATE TABLE `[[dbprefix]]servicelevels` (
  `id` int(5) NOT NULL DEFAULT '0',
  `tag` varchar(10) NOT NULL DEFAULT '',
  `priority` int(5) NOT NULL DEFAULT '0',
  `initial_response_mins` int(11) NOT NULL DEFAULT '0',
  `prob_determ_mins` int(11) NOT NULL DEFAULT '0',
  `action_plan_mins` int(11) NOT NULL DEFAULT '0',
  `resolution_days` float(5,2) NOT NULL DEFAULT '0.00',
  `contact_days` int(11) NOT NULL DEFAULT '0',
  `review_days` int(11) NOT NULL DEFAULT '365',
  `timed` enum('yes','no') NOT NULL DEFAULT 'no',
  `allow_reopen` enum('yes','no') NOT NULL DEFAULT 'yes' COMMENT 'Allow incidents to be reopened?',
  PRIMARY KEY (`tag`,`priority`),
  KEY `id` (`id`),
  KEY `review_days` (`review_days`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]servicelevels`
--

INSERT INTO `[[dbprefix]]servicelevels` VALUES
(0, 'standard', 1, 320, 380, 960, 14.00, 28, 90, 'no', 'yes'),
(0, 'standard', 2, 240, 320, 960, 10.00, 20, 90, 'no', 'yes'),
(0, 'standard', 3, 120, 180, 480, 7.00, 14, 90, 'no', 'yes'),
(0, 'standard', 4, 60, 120, 240, 3.00, 6, 90, 'no', 'yes');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]set_tags`
--

CREATE TABLE `[[dbprefix]]set_tags` (
  `id` int(11) NOT NULL,
  `type` mediumint(9) NOT NULL,
  `tagid` int(11) NOT NULL,
  PRIMARY KEY (`id`,`type`,`tagid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]sitecontacts`
--

CREATE TABLE `[[dbprefix]]sitecontacts` (
  `siteid` int(11) NOT NULL DEFAULT '0',
  `contactid` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`siteid`,`contactid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]sites`
--

CREATE TABLE `[[dbprefix]]sites` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `department` varchar(255) NOT NULL DEFAULT '',
  `address1` varchar(255) NOT NULL DEFAULT '',
  `address2` varchar(255) NOT NULL DEFAULT '',
  `city` varchar(255) NOT NULL DEFAULT '',
  `county` varchar(255) NOT NULL DEFAULT '',
  `country` varchar(255) NOT NULL DEFAULT '',
  `postcode` varchar(255) NOT NULL DEFAULT '',
  `telephone` varchar(255) NOT NULL DEFAULT '',
  `fax` varchar(255) NOT NULL DEFAULT '',
  `email` varchar(255) NOT NULL DEFAULT '',
  `websiteurl` varchar(255) DEFAULT NULL,
  `notes` blob NOT NULL,
  `typeid` int(5) NOT NULL DEFAULT '1',
  `freesupport` int(5) NOT NULL DEFAULT '0',
  `licenserx` int(5) NOT NULL DEFAULT '0',
  `ftnpassword` varchar(40) NOT NULL DEFAULT '',
  `owner` smallint(6) NOT NULL DEFAULT '0',
  `active` enum('true','false') NOT NULL DEFAULT 'true',
  PRIMARY KEY (`id`),
  KEY `typeid` (`typeid`),
  KEY `owner` (`owner`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]sitetypes`
--

CREATE TABLE `[[dbprefix]]sitetypes` (
  `typeid` int(5) NOT NULL AUTO_INCREMENT,
  `typename` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`typeid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=4 ;

--
-- Dumping data for table `[[dbprefix]]sitetypes`
--

INSERT INTO `[[dbprefix]]sitetypes` VALUES
(1, 'Unclassified'),
(2, 'Commercial'),
(3, 'Academic');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]software`
--

CREATE TABLE `[[dbprefix]]software` (
  `id` int(5) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `vendorid` int(5) NOT NULL DEFAULT '0',
  `software` int(5) NOT NULL DEFAULT '0',
  `lifetime_start` date DEFAULT NULL,
  `lifetime_end` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='Individual software products as they are supported' AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]software`
--

INSERT INTO `[[dbprefix]]software` VALUES
(1, 'Example Software', 0, 0, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]softwareproducts`
--

CREATE TABLE `[[dbprefix]]softwareproducts` (
  `productid` int(5) NOT NULL DEFAULT '0',
  `softwareid` int(5) NOT NULL DEFAULT '0',
  PRIMARY KEY (`productid`,`softwareid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='Table to link products with software';

--
-- Dumping data for table `[[dbprefix]]softwareproducts`
--

INSERT INTO `[[dbprefix]]softwareproducts` VALUES
(1, 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]supportcontacts`
--

CREATE TABLE `[[dbprefix]]supportcontacts` (
  `maintenanceid` int(11) NOT NULL DEFAULT '0',
  `contactid` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`maintenanceid`,`contactid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]supportcontacts`
--

INSERT INTO `[[dbprefix]]supportcontacts` VALUES
(1, 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]system`
--

CREATE TABLE `[[dbprefix]]system` (
  `id` int(1) NOT NULL DEFAULT '0',
  `version` float(3,2) NOT NULL DEFAULT '0.00',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]system`
--

INSERT INTO `[[dbprefix]]system` VALUES
(0, 3.67);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tags`
--

CREATE TABLE `[[dbprefix]]tags` (
  `tagid` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`tagid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tasks`
--

CREATE TABLE `[[dbprefix]]tasks` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `description` text NOT NULL,
  `priority` tinyint(4) DEFAULT NULL,
  `owner` smallint(6) NOT NULL DEFAULT '0',
  `duedate` datetime DEFAULT NULL,
  `startdate` datetime DEFAULT NULL,
  `enddate` datetime DEFAULT NULL,
  `completion` tinyint(4) DEFAULT NULL,
  `value` float(6,2) DEFAULT NULL,
  `distribution` enum('public','private','incident','event') NOT NULL DEFAULT 'public',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `lastupdated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `owner` (`owner`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tempassigns`
--

CREATE TABLE `[[dbprefix]]tempassigns` (
  `incidentid` int(5) NOT NULL DEFAULT '0',
  `originalowner` smallint(6) NOT NULL DEFAULT '0',
  `userstatus` tinyint(4) NOT NULL DEFAULT '1',
  `assigned` enum('yes','no') NOT NULL DEFAULT 'no',
  PRIMARY KEY (`incidentid`,`originalowner`),
  KEY `assigned` (`assigned`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tempincoming`
--

CREATE TABLE `[[dbprefix]]tempincoming` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `updateid` int(11) NOT NULL DEFAULT '0',
  `path` varchar(255) NOT NULL DEFAULT '',
  `incidentid` int(11) NOT NULL DEFAULT '0',
  `from` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `emailfrom` varchar(255) DEFAULT NULL,
  `locked` smallint(6) DEFAULT NULL,
  `lockeduntil` datetime DEFAULT NULL,
  `reason` varchar(255) DEFAULT NULL,
  `reason_user` int(11) NOT NULL,
  `reason_time` datetime NOT NULL,
  `reason_id` tinyint(1) DEFAULT '1',
  `incident_id` int(11) DEFAULT NULL,
  `contactid` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `updateid` (`updateid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='Temporary store for incoming attachment paths' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]transactions`
--

CREATE TABLE `[[dbprefix]]transactions` (
  `transactionid` int(11) NOT NULL AUTO_INCREMENT,
  `serviceid` int(11) NOT NULL,
  `totalunits` int(11) NOT NULL,
  `totalbillableunits` int(11) NOT NULL,
  `totalrefunds` int(11) NOT NULL,
  `amount` float NOT NULL,
  `description` varchar(255) NOT NULL,
  `userid` smallint(6) NOT NULL,
  `dateupdated` datetime NOT NULL,
  `transactionstatus` smallint(6) NOT NULL DEFAULT '5',
  PRIMARY KEY (`transactionid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]triggers`
--

CREATE TABLE `[[dbprefix]]triggers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `triggerid` varchar(50) NOT NULL,
  `userid` smallint(6) NOT NULL,
  `action` enum('ACTION_NONE','ACTION_EMAIL','ACTION_NOTICE','ACTION_JOURNAL','ACTION_CREATE_INCIDENT') NOT NULL DEFAULT 'ACTION_NONE',
  `template` varchar(255) DEFAULT NULL,
  `parameters` varchar(255) DEFAULT NULL,
  `checks` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `triggerid` (`triggerid`),
  KEY `userid` (`userid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=37 ;

--
-- Dumping data for table `[[dbprefix]]triggers`
--

INSERT INTO `[[dbprefix]]triggers` VALUES
(1, 'TRIGGER_INCIDENT_CREATED', 0, 'ACTION_JOURNAL', '0', '', ''),
(2, 'TRIGGER_INCIDENT_CREATED', 0, 'ACTION_EMAIL', 'EMAIL_INCIDENT_LOGGED_CONTACT', '', '{sendemail} == 1'),
(3, 'TRIGGER_INCIDENT_ASSIGNED', 0, 'ACTION_JOURNAL', '0', '', ''),
(4, 'TRIGGER_INCIDENT_NEARING_SLA', 0, 'ACTION_JOURNAL', '0', '', ''),
(5, 'TRIGGER_INCIDENT_REVIEW_DUE', 0, 'ACTION_JOURNAL', '0', '', ''),
(6, 'TRIGGER_KB_CREATED', 0, 'ACTION_JOURNAL', '0', '', ''),
(7, 'TRIGGER_NEW_HELD_EMAIL', 0, 'ACTION_JOURNAL', '0', '', ''),
(8, 'TRIGGER_WAITING_HELD_EMAIL', 0, 'ACTION_JOURNAL', '0', '', ''),
(9, 'TRIGGER_USER_CHANGED_STATUS', 0, 'ACTION_JOURNAL', '0', '', ''),
(10, 'TRIGGER_SIT_UPGRADED', 0, 'ACTION_JOURNAL', '0', '', ''),
(11, 'TRIGGER_LANGUAGE_DIFFERS', 0, 'ACTION_JOURNAL', '0', '', ''),
(12, 'TRIGGER_CONTACT_RESET_PASSWORD', 0, 'ACTION_JOURNAL', '0', '', ''),
(13, 'TRIGGER_USER_RESET_PASSWORD', 0, 'ACTION_JOURNAL', '0', '', ''),
(14, 'TRIGGER_NEW_CONTACT', 0, 'ACTION_JOURNAL', '0', '', ''),
(15, 'TRIGGER_INCIDENT_CLOSED', 0, 'ACTION_JOURNAL', '0', '', ''),
(16, 'TRIGGER_INCIDENT_CLOSED', 0, 'ACTION_EMAIL', 'EMAIL_INCIDENT_CLOSED_CONTACT', '', '( {notifycontact} == 1 ) AND ( {awaitingclosure} == 0 )'),
(17, 'TRIGGER_CONTACT_ADDED', 0, 'ACTION_JOURNAL', '0', '', ''),
(18, 'TRIGGER_CONTACT_ADDED', 0, 'ACTION_EMAIL', 'EMAIL_NEW_CONTACT_DETAILS', '', ''),
(19, 'TRIGGER_NEW_CONTRACT', 0, 'ACTION_JOURNAL', '0', '', ''),
(20, 'TRIGGER_NEW_USER', 0, 'ACTION_JOURNAL', '0', '', ''),
(21, 'TRIGGER_NEW_SITE', 0, 'ACTION_JOURNAL', '0', '', ''),
(22, 'TRIGGER_HOLIDAY_REQUESTED', 0, 'ACTION_JOURNAL', '0', '', ''),
(23, 'TRIGGER_INCIDENT_ASSIGNED', 1, 'ACTION_NOTICE', 'NOTICE_INCIDENT_ASSIGNED', '', '{userid} == 1'),
(24, 'TRIGGER_SIT_UPGRADED', 1, 'ACTION_NOTICE', 'NOTICE_SIT_UPGRADED', '', ''),
(25, 'TRIGGER_INCIDENT_CLOSED', 1, 'ACTION_NOTICE', 'NOTICE_INCIDENT_CLOSED', '', '{userid} != 1'),
(26, 'TRIGGER_INCIDENT_NEARING_SLA', 1, 'ACTION_NOTICE', 'NOTICE_INCIDENT_NEARING_SLA', '', '{ownerid} == 1 OR {townerid} == 1'),
(27, 'TRIGGER_LANGUAGE_DIFFERS', 1, 'ACTION_NOTICE', 'NOTICE_LANGUAGE_DIFFERS', '', ''),
(28, 'TRIGGER_NEW_CONTACT', 0, 'ACTION_EMAIL', 'EMAIL_NEW_CONTACT_DETAILS', '', '{emaildetails} == 1'),
(29, 'TRIGGER_USER_RESET_PASSWORD', 0, 'ACTION_EMAIL', 'EMAIL_USER_RESET_PASSWORD', '', ''),
(30, 'TRIGGER_CONTACT_RESET_PASSWORD', 0, 'ACTION_EMAIL', 'EMAIL_CONTACT_RESET_PASSWORD', '', ''),
(31, 'TRIGGER_HOLIDAY_REQUESTED', 0, 'ACTION_EMAIL', 'EMAIL_HOLIDAYS_REQUESTED', '', ''),
(32, 'TRIGGER_INCIDENT_CLOSED', 0, 'ACTION_EMAIL', 'EMAIL_INCIDENT_CLOSURE', '', '( {notifycontact} == 1 ) AND ( {awaitingclosure} == 1 )'),
(33, 'TRIGGER_INCIDENT_CLOSED', 0, 'ACTION_EMAIL', 'EMAIL_EXTERNAL_INCIDENT_CLOSURE', '', '{notifyexternal} == 1'),
(34, 'TRIGGER_SERVICE_LIMIT', 0, 'ACTION_EMAIL', 'EMAIL_SERVICE_LEVEL', '', '{serviceremaining} <= 0.2'),
(35, 'TRIGGER_SCHEDULER_TASK_FAILED', 1, 'ACTION_NOTICE', 'NOTICE_SCHEDULER_TASK_FAILED', '', '{schedulertask} == ''CheckIncomingMail'''),
(36, 'TRIGGER_INCIDENT_CLOSED', 0, 'ACTION_EMAIL', 'EMAIL_SEND_FEEDBACK', '', '{sendfeedback} == 1');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]updates`
--

CREATE TABLE `[[dbprefix]]updates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `incidentid` int(11) DEFAULT NULL,
  `userid` smallint(6) DEFAULT NULL,
  `type` enum('default','editing','opening','email','reassigning','closing','reopening','auto','phonecallout','phonecallin','research','webupdate','emailout','emailin','externalinfo','probdef','solution','actionplan','slamet','reviewmet','tempassigning','auto_chase_email','auto_chase_phone','auto_chase_manager','auto_chased_phone','auto_chased_manager','auto_chase_managers_manager','customerclosurerequest','fromtask') DEFAULT 'default',
  `currentowner` tinyint(4) NOT NULL DEFAULT '0',
  `currentstatus` smallint(6) NOT NULL DEFAULT '0',
  `bodytext` text,
  `timestamp` int(11) DEFAULT NULL,
  `nextaction` varchar(50) NOT NULL DEFAULT '',
  `customervisibility` enum('show','hide','unset') DEFAULT 'unset',
  `sla` enum('opened','initialresponse','probdef','actionplan','solution','closed') DEFAULT NULL,
  `duration` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `currentowner` (`currentowner`,`currentstatus`),
  KEY `incidentid` (`incidentid`),
  KEY `timestamp` (`timestamp`),
  KEY `type` (`type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]usergroups`
--

CREATE TABLE `[[dbprefix]]usergroups` (
  `userid` smallint(6) NOT NULL DEFAULT '0',
  `groupid` int(5) NOT NULL DEFAULT '0',
  PRIMARY KEY (`userid`,`groupid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='Links users with groups';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]userpermissions`
--

CREATE TABLE `[[dbprefix]]userpermissions` (
  `userid` smallint(6) NOT NULL DEFAULT '0',
  `permissionid` int(5) NOT NULL DEFAULT '0',
  `granted` enum('true','false') NOT NULL DEFAULT 'false',
  PRIMARY KEY (`userid`,`permissionid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]userpermissions`
--

INSERT INTO `[[dbprefix]]userpermissions` VALUES
(1, 1, 'true'),
(1, 2, 'true'),
(1, 3, 'true'),
(1, 4, 'true'),
(1, 5, 'true'),
(1, 6, 'true'),
(1, 7, 'true'),
(1, 8, 'true'),
(1, 9, 'true'),
(1, 10, 'true'),
(1, 11, 'true'),
(1, 12, 'true'),
(1, 13, 'true'),
(1, 14, 'true'),
(1, 15, 'true'),
(1, 16, 'true'),
(1, 17, 'true'),
(1, 18, 'true'),
(1, 19, 'true'),
(1, 20, 'true'),
(1, 21, 'true'),
(1, 22, 'true'),
(1, 23, 'true'),
(1, 24, 'true'),
(1, 25, 'true'),
(1, 26, 'true'),
(1, 27, 'true'),
(1, 28, 'true'),
(1, 29, 'true'),
(1, 30, 'true'),
(1, 31, 'true'),
(1, 32, 'true'),
(1, 33, 'true'),
(1, 34, 'true'),
(1, 35, 'true'),
(1, 36, 'true'),
(1, 37, 'true'),
(1, 38, 'true'),
(1, 39, 'true'),
(1, 40, 'true'),
(1, 41, 'true'),
(1, 42, 'true'),
(1, 43, 'true'),
(1, 44, 'true'),
(1, 45, 'true'),
(1, 46, 'true'),
(1, 47, 'true'),
(1, 48, 'true'),
(1, 49, 'true'),
(1, 50, 'true'),
(1, 51, 'true'),
(1, 52, 'true'),
(1, 53, 'true'),
(1, 54, 'true'),
(1, 55, 'true'),
(1, 56, 'true'),
(1, 57, 'true'),
(1, 58, 'true'),
(1, 59, 'true'),
(1, 60, 'true'),
(1, 61, 'true'),
(1, 62, 'true'),
(1, 63, 'true'),
(1, 64, 'true'),
(1, 65, 'true'),
(1, 66, 'true'),
(1, 67, 'true'),
(1, 68, 'true'),
(1, 69, 'true'),
(1, 70, 'true'),
(1, 71, 'true'),
(1, 72, 'true'),
(1, 73, 'true'),
(1, 74, 'true'),
(1, 75, 'true'),
(1, 76, 'true'),
(1, 77, 'true');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]users`
--

CREATE TABLE `[[dbprefix]]users` (
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `username` varchar(50) DEFAULT NULL,
  `password` varchar(50) DEFAULT NULL,
  `realname` varchar(50) DEFAULT NULL,
  `roleid` int(5) NOT NULL DEFAULT '3',
  `groupid` int(5) DEFAULT NULL,
  `title` varchar(50) DEFAULT NULL,
  `signature` text,
  `email` varchar(50) DEFAULT NULL,
  `icq` varchar(15) NOT NULL DEFAULT '',
  `aim` varchar(25) NOT NULL DEFAULT '',
  `msn` varchar(70) NOT NULL DEFAULT '',
  `phone` varchar(50) DEFAULT NULL,
  `mobile` varchar(50) NOT NULL DEFAULT '',
  `fax` varchar(50) DEFAULT NULL,
  `status` tinyint(4) DEFAULT NULL,
  `message` varchar(150) DEFAULT NULL,
  `accepting` enum('No','Yes') DEFAULT 'Yes',
  `user_startdate` date DEFAULT NULL,
  `var_incident_refresh` int(11) DEFAULT '60',
  `var_update_order` enum('desc','asc') DEFAULT 'desc',
  `var_num_updates_view` int(11) NOT NULL DEFAULT '15',
  `var_style` int(11) DEFAULT '1',
  `var_hideautoupdates` enum('true','false') NOT NULL DEFAULT 'false',
  `var_hideheader` enum('true','false') NOT NULL DEFAULT 'false',
  `var_monitor` enum('true','false') NOT NULL DEFAULT 'true',
  `var_i18n` varchar(5) NOT NULL DEFAULT 'en-GB',
  `var_utc_offset` int(11) NOT NULL DEFAULT '0' COMMENT 'Offset from UTC (timezone)',
  `var_emoticons` enum('true','false') NOT NULL DEFAULT 'false',
  `listadmin` tinytext,
  `holiday_entitlement` float NOT NULL DEFAULT '0',
  `holiday_resetdate` date DEFAULT NULL,
  `qualifications` tinytext,
  `dashboard` varchar(255) NOT NULL DEFAULT '0-3,1-1,1-2,2-4',
  `lastseen` datetime NOT NULL,
  `user_source` varchar(32) NOT NULL DEFAULT 'sit',
  PRIMARY KEY (`id`),
  KEY `username` (`username`),
  KEY `accepting` (`accepting`),
  KEY `status` (`status`),
  KEY `groupid` (`groupid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]users`
--

INSERT INTO `[[dbprefix]]users` VALUES
(1, 'admin', '[[admin_pass]]', 'Administrator', 1, NULL, 'Administrator', 'Regards,\r\n\r\nSiT Administrator', '[[admin_email]]', '', '', '', NULL, '', NULL, 1, NULL, 'Yes', NULL, 60, 'desc', 15, 8, 'false', 'false', 'true', 'en-GB', 0, 'false', NULL, 0, NULL, NULL, '0-3,1-1,1-2,2-4', '[[regtime]]', 'sit');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]usersoftware`
--

CREATE TABLE `[[dbprefix]]usersoftware` (
  `userid` smallint(6) NOT NULL DEFAULT '0',
  `softwareid` int(5) NOT NULL DEFAULT '0',
  `backupid` smallint(6) NOT NULL DEFAULT '0',
  PRIMARY KEY (`userid`,`softwareid`),
  KEY `backupid` (`backupid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='Defines which software users have expertise with';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]userstatus`
--

CREATE TABLE `[[dbprefix]]userstatus` (
  `id` int(11) NOT NULL,
  `name` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]userstatus`
--

INSERT INTO `[[dbprefix]]userstatus` VALUES
(0, 'strAccountDisabled'),
(1, 'strInOffice'),
(2, 'strNotInOffice'),
(3, 'strInMeeting'),
(4, 'strAtLunch'),
(5, 'strOnHoliday'),
(6, 'strWorkingFromHome'),
(7, 'strOnTrainingCourse'),
(8, 'strAbsentSick'),
(9, 'strWorkingAway');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]vendors`
--

CREATE TABLE `[[dbprefix]]vendors` (
  `id` int(5) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]vendors`
--

INSERT INTO `[[dbprefix]]vendors` VALUES
(1, 'Default');

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
