"""cpapi2 functions"""
from typing import Union
from ._base import CpAPIBase


class Cpapi2(CpAPIBase):
    """cpapi2 functions"""

    __module__ = 'cpapis'

    def __init__(self):
        if self._can_exec('/usr/bin/cpapi2'):
            super().__init__('/usr/bin/cpapi2')
        else:
            super().__init__('/usr/local/cpanel/bin/cpapi2')

    def __call__(
        self,
        module: str,
        user: Union[str, None] = None,
        args: Union[dict, None] = None,
        timeout: Union[float, None] = None,
    ):
        """Query cpapi2

        Args:
            module: the cpapi2 module to use in format x::y
            user: ``--user`` arg to use
            args: key-vals to send to cpapi2
            timeout: timeout for the cpapi2 command in secs
        """
        return self._exec(
            module_args=module.split('::'),
            user=user,
            args=args,
            timeout=timeout,
        )
