#!/opt/imh-python/bin/python3
"""removeacct wrapper for T2C"""
import argparse
import sys
import rads

sys.path.insert(0, '/opt/support/lib')
from arg_types import cpuser_safe_arg
from run_cmd import cpuwatch_execv


def parse_args():
    """Parse commandline arguments"""
    parser = argparse.ArgumentParser(
        description=(
            "Wrapper around CPanel removeacct. Do not use this unless you have "
            "a valid backup of the account, as it is irreversible. Improper "
            "use may result in loss of access and disciplinary action."
        )
    )
    parser.add_argument('user', help='Account to destroy', type=cpuser_safe_arg)
    args = parser.parse_args()
    return args.user


def main():
    """main: parse args, determine size, prompt, and run removeacct"""
    user = parse_args()
    msg = (
        'WARNING: This cannot be undone. Please confirm that you have a'
        ' valid backup of this account. Misuse of this tool can lead to '
        'downgrading of access and disciplinary action.'
    )
    if not rads.prompt_y_n(rads.color.red(msg)):
        sys.exit("Exiting on user input")
    cpuwatch_execv(["/usr/local/cpanel/scripts/removeacct", user])


if __name__ == '__main__':
    main()
