/*****************************************************************
 ricoLocale_en.js - a component of Rico 2.0
 English localization strings
 If you would like to include translations for another language, 
 please send them to dowdybrown@yahoo.com
******************************************************************/
RicoTranslate.langCode='en';

// used in ricoLiveGrid.js

RicoTranslate.addPhraseId('bookmarkExact',"Listing records $1 - $2 of $3");
RicoTranslate.addPhraseId('bookmarkAbout',"Listing records $1 - $2 of more than $3");
RicoTranslate.addPhraseId('bookmarkNoRec',"No records");
RicoTranslate.addPhraseId('bookmarkNoMatch',"No matching records");
RicoTranslate.addPhraseId('bookmarkLoading',"Loading...");
RicoTranslate.addPhraseId('sorting',"Sorting...");
RicoTranslate.addPhraseId('exportStatus',"Exporting row $1");
RicoTranslate.addPhraseId('filterAll',"(all)");
RicoTranslate.addPhraseId('filterBlank',"(blank)");
RicoTranslate.addPhraseId('filterEmpty',"(empty)");
RicoTranslate.addPhraseId('filterNotEmpty',"(not empty)");
RicoTranslate.addPhraseId('filterLike',"like: $1");
RicoTranslate.addPhraseId('filterNot',"not: $1");
RicoTranslate.addPhraseId('requestError',"The request for data returned an error:\n$1");
RicoTranslate.addPhraseId('keywordPrompt',"Enter keyword to search for (use * as a wildcard):");

// used in ricoLiveGridMenu.js

RicoTranslate.addPhraseId('gridmenuSortBy',"Sort by: $1");
RicoTranslate.addPhraseId('gridmenuSortAsc',"Ascending");
RicoTranslate.addPhraseId('gridmenuSortDesc',"Descending");
RicoTranslate.addPhraseId('gridmenuFilterBy',"Filter by: $1");
RicoTranslate.addPhraseId('gridmenuRefresh',"Refresh");
RicoTranslate.addPhraseId('gridmenuChgKeyword',"Change keyword...");
RicoTranslate.addPhraseId('gridmenuExcludeAlso',"Exclude this value also");
RicoTranslate.addPhraseId('gridmenuInclude',"Include only this value");
RicoTranslate.addPhraseId('gridmenuGreaterThan',"Greater than or equal to this value");
RicoTranslate.addPhraseId('gridmenuLessThan',"Less than or equal to this value");
RicoTranslate.addPhraseId('gridmenuContains',"Contains keyword...");
RicoTranslate.addPhraseId('gridmenuExclude',"Exclude this value");
RicoTranslate.addPhraseId('gridmenuRemoveFilter',"Remove filter");
RicoTranslate.addPhraseId('gridmenuRemoveAll',"Remove all filters");

RicoTranslate.addPhraseId('gridmenuExport',"Print/Export");
RicoTranslate.addPhraseId('gridmenuExportVis2Web',"Visible rows to web page");
RicoTranslate.addPhraseId('gridmenuExportAll2Web',"All rows to web page");
RicoTranslate.addPhraseId('gridmenuExportVis2SS',"Visible rows to spreadsheet");
RicoTranslate.addPhraseId('gridmenuExportAll2SS',"All rows to spreadsheet");

RicoTranslate.addPhraseId('gridmenuHideShow',"Hide/Show");
RicoTranslate.addPhraseId('gridmenuChooseCols',"Choose columns...");
RicoTranslate.addPhraseId('gridmenuHide',"Hide: $1");
RicoTranslate.addPhraseId('gridmenuShow',"Show: $1");
RicoTranslate.addPhraseId('gridmenuShowAll',"Show All");

// used in ricoLiveGridAjax.js

RicoTranslate.addPhraseId('sessionExpireMinutes',"minutes before your session expires");
RicoTranslate.addPhraseId('sessionExpired',"EXPIRED");
RicoTranslate.addPhraseId('requestTimedOut',"Request for data timed out!");
RicoTranslate.addPhraseId('waitForData',"Waiting for data...");
RicoTranslate.addPhraseId('httpError',"Received HTTP error: $1");
RicoTranslate.addPhraseId('invalidResponse',"Server returned an invalid response");

// used in ricoLiveGridCommon.js

RicoTranslate.addPhraseId('gridChooseCols',"Choose columns");
RicoTranslate.addPhraseId('exportComplete',"Exporting complete");
RicoTranslate.addPhraseId('exportInProgress',"Export in progress...");
RicoTranslate.addPhraseId('disableBlocker',"You need to disable your browser's pop-up blocker before exporting.");
RicoTranslate.addPhraseId('showFilterRow',"Show filter row");  // img alt text
RicoTranslate.addPhraseId('hideFilterRow',"Hide filter row");  // img alt text

// used in ricoLiveGridForms.js

RicoTranslate.addPhraseId('selectNone',"(none)");
RicoTranslate.addPhraseId('selectNewVal',"(new value)");
RicoTranslate.addPhraseId('record',"record");
RicoTranslate.addPhraseId('thisRecord',"this $1");
RicoTranslate.addPhraseId('confirmDelete',"Are you sure you want to delete $1?");
RicoTranslate.addPhraseId('deleting',"Deleting...");
RicoTranslate.addPhraseId('formPleaseEnter',"Please enter a value for $1");
RicoTranslate.addPhraseId('formInvalidFmt',"Invalid format for $1");
RicoTranslate.addPhraseId('formOutOfRange',"Value is out of range for $1");
RicoTranslate.addPhraseId('formNewValue',"new value:");
RicoTranslate.addPhraseId('saving',"Saving...");
RicoTranslate.addPhraseId('clear',"clear");
RicoTranslate.addPhraseId('close',"Close");
RicoTranslate.addPhraseId('saveRecord',"Save $1");
RicoTranslate.addPhraseId('cancel',"Cancel");
RicoTranslate.addPhraseId('editRecord',"Edit this $1");
RicoTranslate.addPhraseId('deleteRecord',"Delete this $1");
RicoTranslate.addPhraseId('cloneRecord',"Clone this $1");
RicoTranslate.addPhraseId('addRecord',"Add new $1");
RicoTranslate.addPhraseId('addedSuccessfully',"$1 added successfully");
RicoTranslate.addPhraseId('deletedSuccessfully',"$1 deleted successfully");
RicoTranslate.addPhraseId('updatedSuccessfully',"$1 updated successfully");

// used in ricoTree.js

RicoTranslate.addPhraseId('treeSave',"Save Selection");
RicoTranslate.addPhraseId('treeClear',"Clear All");

// used in ricoCalendar.js

RicoTranslate.addPhraseId('calToday',"Today is $1 $2 $3");  // $1=day, $2=monthabbr, $3=year, $4=month number
RicoTranslate.addPhraseId('calWeekHdg',"Wk");
RicoTranslate.addPhraseId('calYearRange',"Year ($1-$2)");
RicoTranslate.addPhraseId('calInvalidYear',"Invalid year");

// Date & number formats

RicoTranslate.thouSep=","
RicoTranslate.decPoint="."
RicoTranslate.dateFmt="mm/dd/yyyy"

RicoTranslate.monthNames=['January','February','March','April','May','June','July','August','September','October','November','December']
RicoTranslate.dayNames=['Sunday','Monday','Tuesday','Wednesday','Thursday','Friday','Saturday']

Rico.includeLoaded('translations/ricoLocale_en.js');
Rico.acceptLanguage(navigator.language || navigator.userLanguage);   // overlay user's language preference
