﻿/*****************************************************************
 ricoLocale_ja.js - a component of Rico 2.0
 Localization strings for Japanese
 Initial translator: Nobuhito Takeuchi
 If you have better translations, or would like to include
 translations for another language, please send them to dowdybrown@yahoo.com
******************************************************************/
RicoTranslate.langCode='ja';

// used in ricoLiveGrid.js

RicoTranslate.addPhraseId('bookmarkExact',"リストのレコードは $3 件中 $1 - $2 件目です");
RicoTranslate.addPhraseId('bookmarkAbout',"リストのレコードは少なくとも $3 件中 $1 - $2 件目です");
RicoTranslate.addPhraseId('bookmarkNoRec',"レコードがありません");
RicoTranslate.addPhraseId('bookmarkNoMatch',"一致するレコードがありません");
RicoTranslate.addPhraseId('bookmarkLoading',"ロード中です...");
RicoTranslate.addPhraseId('sorting',"並べ替え中です...");
RicoTranslate.addPhraseId('exportStatus',"$1 行目をエクスポート中です");
RicoTranslate.addPhraseId('filterAll',"(すべて)");
RicoTranslate.addPhraseId('filterBlank',"(空白)");
RicoTranslate.addPhraseId('filterEmpty',"(空の)");
RicoTranslate.addPhraseId('filterNotEmpty',"(空では無い)");
RicoTranslate.addPhraseId('filterLike',"$1 を含む");
RicoTranslate.addPhraseId('filterNot',"$1 を含まない");
RicoTranslate.addPhraseId('requestError',"そのリクエストはエラーを返しました:\n$1");
RicoTranslate.addPhraseId('keywordPrompt',"検索するキーワードを入力して下さい ( * はワイルドカードとして利用されます):");

// used in ricoLiveGridMenu.js

RicoTranslate.addPhraseId('gridmenuSortBy',"$1 を並べ替え");
RicoTranslate.addPhraseId('gridmenuSortAsc',"昇順");
RicoTranslate.addPhraseId('gridmenuSortDesc',"降順");
RicoTranslate.addPhraseId('gridmenuFilterBy',"$1 をフィルタ");
RicoTranslate.addPhraseId('gridmenuRefresh',"再描画");
RicoTranslate.addPhraseId('gridmenuChgKeyword',"キーワードの変更...");
RicoTranslate.addPhraseId('gridmenuExcludeAlso',"この値も含まない");
RicoTranslate.addPhraseId('gridmenuInclude',"この値のみを含む");
RicoTranslate.addPhraseId('gridmenuGreaterThan',"この値以上");
RicoTranslate.addPhraseId('gridmenuLessThan',"この値以下");
RicoTranslate.addPhraseId('gridmenuContains',"このキーワードを含む...");
RicoTranslate.addPhraseId('gridmenuExclude',"この値を含まない");
RicoTranslate.addPhraseId('gridmenuRemoveFilter',"フィルタを取り除く");
RicoTranslate.addPhraseId('gridmenuRemoveAll',"すべてのフィルタを取り除く");

RicoTranslate.addPhraseId('gridmenuExport',"インポート/エクスポート");
RicoTranslate.addPhraseId('gridmenuExportVis2Web',"表示されている行をウェブページへ");
RicoTranslate.addPhraseId('gridmenuExportAll2Web',"すべての行をウェブページへ");
RicoTranslate.addPhraseId('gridmenuExportVis2SS',"表示されている行をスプレッドシートへ");
RicoTranslate.addPhraseId('gridmenuExportAll2SS',"すべての行をスプレッドシートへ");

RicoTranslate.addPhraseId('gridmenuHideShow',"非表示/表示");
RicoTranslate.addPhraseId('gridmenuChooseCols',"列を選択...");
RicoTranslate.addPhraseId('gridmenuHide',"$1 を非表示");
RicoTranslate.addPhraseId('gridmenuShow',"$1 を表示");
RicoTranslate.addPhraseId('gridmenuShowAll',"すべて表示");

// used in ricoLiveGridAjax.js

RicoTranslate.addPhraseId('sessionExpireMinutes',"セッションが終了するまでの分数");
RicoTranslate.addPhraseId('sessionExpired',"終了");
RicoTranslate.addPhraseId('requestTimedOut',"データのリクエストが終了しました");
RicoTranslate.addPhraseId('waitForData',"データを待っています...");
RicoTranslate.addPhraseId('httpError',"HTTP エラーを受け取りました: $1");
RicoTranslate.addPhraseId('invalidResponse',"サーバは無効なレスポンスを返しました");

// used in ricoLiveGridCommon.js

RicoTranslate.addPhraseId('gridChooseCols',"列を選択して下さい");
RicoTranslate.addPhraseId('exportComplete',"エクスポートが完了しました");
RicoTranslate.addPhraseId('exportInProgress',"エクスポートの実行中です...");

// used in ricoLiveGridForms.js

RicoTranslate.addPhraseId('selectNone',"(無し)");
RicoTranslate.addPhraseId('selectNewVal',"(新しい値)");
RicoTranslate.addPhraseId('record',"レコード");
RicoTranslate.addPhraseId('thisRecord',"この $1");
RicoTranslate.addPhraseId('confirmDelete',"$1 を本当に削除してよろしいですか?");
RicoTranslate.addPhraseId('deleting',"削除しています...");
RicoTranslate.addPhraseId('formPleaseEnter',"$1 を入力して下さい");
RicoTranslate.addPhraseId('formInvalidFmt',"$1 は無効なフォーマットです");
RicoTranslate.addPhraseId('formOutOfRange',"$1 は範囲外です");
RicoTranslate.addPhraseId('formNewValue',"新しい値:");
RicoTranslate.addPhraseId('saving',"保存しています...");
RicoTranslate.addPhraseId('clear',"消去");
RicoTranslate.addPhraseId('close',"閉じる");
RicoTranslate.addPhraseId('saveRecord',"$1 の保存");
RicoTranslate.addPhraseId('cancel',"キャンセル");
RicoTranslate.addPhraseId('editRecord',"$1 を編集します");
RicoTranslate.addPhraseId('deleteRecord',"$1 を削除します");
RicoTranslate.addPhraseId('cloneRecord',"$1 の複製を作成します");
RicoTranslate.addPhraseId('addRecord',"$1 を追加します");
RicoTranslate.addPhraseId('addedSuccessfully',"$1 の追加に成功しました");
RicoTranslate.addPhraseId('deletedSuccessfully',"$1 の削除に成功しました");
RicoTranslate.addPhraseId('updatedSuccessfully',"$1 の更新に成功しました");

// used in ricoTree.js

RicoTranslate.addPhraseId('treeSave',"選択項目を保存");
RicoTranslate.addPhraseId('treeClear',"すべて消去");

// used in ricoCalendar.js

RicoTranslate.addPhraseId('calToday',"今日は $3 年 $4 月 $1 日です");
RicoTranslate.addPhraseId('calWeekHdg',"曜日");
RicoTranslate.addPhraseId('calYearRange',"$1 年 - $2 年"); 
RicoTranslate.addPhraseId('calInvalidYear',"無効な年です");

// Date & number formats

RicoTranslate.thouSep=","
RicoTranslate.decPoint="."
RicoTranslate.dateFmt="yyyy年mm月dd日"

RicoTranslate.monthNames=['１月', '２月', '３月', '４月', '５月', '６月', '７月', '８月', '９月', '１０月', '１１月', '１２月']
RicoTranslate.dayNames=['日曜','月曜','火曜','水曜','木曜','金曜','土曜']

RicoTranslate.monthAbbr=function(monthIdx) {
  return this.monthNames[monthIdx];
}

Rico.includeLoaded('ricoLocale_ja.js');
