<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">
<html>
<head>
<title>Rico LiveGrid-Weather Example</title>

<?php
require "chklang.php";
?>

<script src="../../src/min.rico.js" type="text/javascript"></script>
<link href="../../src/css/min.rico.css" type="text/css" rel="stylesheet" />
<link href="../../src/css/greenHdg.css" type="text/css" rel="stylesheet" />
<link href="../client/css/demo.css" type="text/css" rel="stylesheet" />

<script type='text/javascript'>
<?php
setLang();
?>

var weatherGrid, weatherBuffer;

Rico.onLoad( function() {
  Rico.TableColumn.TEMP = {type:'number', decPlaces:0, ClassName:'alignright', suffix:'&deg;C', width:50};
  var opts = {  
    frozenColumns : 1,
    columnSpecs   : [{width:120},{width:70},{width:70},{width:100},
                     'TEMP','TEMP','TEMP',
                     {width:150},{width:200},{width:60}]
  };
  var flag=$('flag').getElementsByTagName('IMG')[0];
  if (flag) {
    if (flag.src.match(/\/([A-Z]+)-flag.gif/)) {
      var country=RegExp.$1;
      //alert(country);
    }
  }
  weatherBuffer=new Rico.Buffer.AjaxXML('yahooWeather.php', {requestParameters:['c='+country], acceptAttr:['style']});
  weatherGrid=new Rico.LiveGrid ('weathergrid', weatherBuffer, opts);
  weatherGrid.menu=new Rico.GridMenu();
});
</script>

<style type="text/css">
div.ricoLG_cell { white-space: nowrap; }
</style>
</head>

<body>

<table border='0' cellpadding='0' cellspacing='5' style='clear:both'><tr valign='top'>
<td id='flag'>
<script language="Javascript" src="http://map.geoup.com/geoup?template=flag"></script>
</td>
<td id='explanation'>The flag at left is generated by <a href='http://www.geobytes.com/'>geobytes.com</a> based on your IP address.
<a href='yahooWeather.php'>yahooWeather.php</a> is used as a proxy to gather data from <a href='http://weather.yahoo.com/'>Yahoo Weather</a>.
The weather data is delivered to the client via AJAX. 
During the AJAX request, any cities in the list that match the flag are highlighted in yellow 
and any freezing temperatures are colored blue.
Note that these styles are passed back in the AJAX response 
and incorporated into the grid dynamically (activated by the buffer's acceptAttr option).
</td></tr></table>

<p class="ricoBookmark"><span id="weathergrid_bookmark">&nbsp;</span></p>
<table id="weathergrid" class="ricoLiveGrid" cellspacing="0" cellpadding="0">
  <tr>
	  <th>City</th>
	  <th>Sunrise</th>
	  <th>Sunset</th>
	  <th>Currently</th>
	  <th>Temp</th>
	  <th>Low</th>
	  <th>High</th>
	  <th>Forecast</th>
	  <th>As of</th>
	  <th>Source</th>
  </tr>
</table>

<!--
<textarea id='weathergrid_debugmsgs' rows='5' cols='100' style='font-size:x-small;'></textarea>
-->
</body>
</html>
