﻿/*****************************************************************
 ricoLocale_zh.js - a component of Rico 2.0
 Localization strings for Simplified Chinese
 Initial translator: Xinjun Liu
 If you have better translations, or would like to include
 translations for another language, please send them to dowdybrown@yahoo.com
******************************************************************/
RicoTranslate.langCode='zh';

// used in ricoLiveGrid.js

RicoTranslate.addPhraseId('bookmarkExact',"第 $1 - $2 条记录(总计$3条)");
RicoTranslate.addPhraseId('bookmarkAbout',"第 $1 - $2 条记录(总数超过$3条)");
RicoTranslate.addPhraseId('bookmarkNoRec',"未发现记录");
RicoTranslate.addPhraseId('bookmarkNoMatch',"未找到匹配的记录");
RicoTranslate.addPhraseId('bookmarkLoading',"正在加载...");
RicoTranslate.addPhraseId('sorting',"正在排序...");
RicoTranslate.addPhraseId('exportStatus',"导出第 $1 行");
RicoTranslate.addPhraseId('filterAll',"(所有)");
RicoTranslate.addPhraseId('filterBlank',"(空白)");
RicoTranslate.addPhraseId('filterEmpty',"(空值)");
RicoTranslate.addPhraseId('filterNotEmpty',"(非空)");
RicoTranslate.addPhraseId('filterLike',"类似于: $1");
RicoTranslate.addPhraseId('filterNot',"非: $1");
RicoTranslate.addPhraseId('requestError',"该请求返回一个错误:\n$1");
RicoTranslate.addPhraseId('keywordPrompt',"请输入搜索词(可使用通配符*):");

// used in ricoLiveGridMenu.js

RicoTranslate.addPhraseId('gridmenuSortBy',"排序 依据:$1");
RicoTranslate.addPhraseId('gridmenuSortAsc',"升序");
RicoTranslate.addPhraseId('gridmenuSortDesc',"降序");
RicoTranslate.addPhraseId('gridmenuFilterBy',"过滤 依据:     $1");
RicoTranslate.addPhraseId('gridmenuRefresh',"刷新");
RicoTranslate.addPhraseId('gridmenuChgKeyword',"更改搜索词...");
RicoTranslate.addPhraseId('gridmenuExcludeAlso',"不包括此值");
RicoTranslate.addPhraseId('gridmenuInclude',"只包括此值");
RicoTranslate.addPhraseId('gridmenuGreaterThan',"大于或等于此值");
RicoTranslate.addPhraseId('gridmenuLessThan',"小于或等于此值");
RicoTranslate.addPhraseId('gridmenuContains',"包含关键字...");
RicoTranslate.addPhraseId('gridmenuExclude',"不包括此值");
RicoTranslate.addPhraseId('gridmenuRemoveFilter',"移除过滤器");
RicoTranslate.addPhraseId('gridmenuRemoveAll',"移除所有过滤器");

RicoTranslate.addPhraseId('gridmenuExport',"打印/输出");
RicoTranslate.addPhraseId('gridmenuExportVis2Web',"输出可见行至网页");
RicoTranslate.addPhraseId('gridmenuExportAll2Web',"输出所有行至网页");
RicoTranslate.addPhraseId('gridmenuExportVis2SS',"输出可见行至表格");
RicoTranslate.addPhraseId('gridmenuExportAll2SS',"输出所有行至表格");

RicoTranslate.addPhraseId('gridmenuHideShow',"隐藏/显示");
RicoTranslate.addPhraseId('gridmenuChooseCols',"选择以下列...");
RicoTranslate.addPhraseId('gridmenuHide',"隐藏: $1");
RicoTranslate.addPhraseId('gridmenuShow',"显示: $1");
RicoTranslate.addPhraseId('gridmenuShowAll',"显示所有");

// used in ricoLiveGridAjax.js

RicoTranslate.addPhraseId('sessionExpireMinutes',"分钟后您的会话将过期");
RicoTranslate.addPhraseId('sessionExpired',"已过期");
RicoTranslate.addPhraseId('requestTimedOut',"数据传输超时!");
RicoTranslate.addPhraseId('waitForData',"正在加载数据...");
RicoTranslate.addPhraseId('httpError',"接收到HTTP错误: $1");
RicoTranslate.addPhraseId('invalidResponse',"服务器返回一个无效的响应");

// used in ricoLiveGridCommon.js

RicoTranslate.addPhraseId('gridChooseCols',"选择以下列...");
RicoTranslate.addPhraseId('exportComplete',"输出完成！");
RicoTranslate.addPhraseId('exportInProgress',"正在输出...");
RicoTranslate.addPhraseId('showFilterRow',"显示被过滤的行");  // img alt text
RicoTranslate.addPhraseId('hideFilterRow',"隐藏被过滤的行");  // img alt text

// used in ricoLiveGridForms.js

RicoTranslate.addPhraseId('selectNone',"(无)");
RicoTranslate.addPhraseId('selectNewVal',"(新值)");
RicoTranslate.addPhraseId('record',"记录");
RicoTranslate.addPhraseId('thisRecord',"该 $1");
RicoTranslate.addPhraseId('confirmDelete',"您确定要删除 $1 吗?");
RicoTranslate.addPhraseId('deleting',"正在删除...");
RicoTranslate.addPhraseId('formPleaseEnter',"请输入 $1 的值");
RicoTranslate.addPhraseId('formInvalidFmt',"不符合 $1 的格式");
RicoTranslate.addPhraseId('formOutOfRange',"值超出 $1 的范围");
RicoTranslate.addPhraseId('formNewValue',"新值:");
RicoTranslate.addPhraseId('saving',"正在保存...");
RicoTranslate.addPhraseId('clear',"清除");
RicoTranslate.addPhraseId('close',"关闭");
RicoTranslate.addPhraseId('saveRecord',"保存");
RicoTranslate.addPhraseId('cancel',"撤销");
RicoTranslate.addPhraseId('editRecord',"编辑"); //$1 ommited
RicoTranslate.addPhraseId('deleteRecord',"删除"); //$1 ommited
RicoTranslate.addPhraseId('cloneRecord',"克隆");//$1 ommited
RicoTranslate.addPhraseId('addRecord',"添加");   //$1 ommited
RicoTranslate.addPhraseId('addedSuccessfully',"$1 添加成功");
RicoTranslate.addPhraseId('deletedSuccessfully',"$1 删除成功");
RicoTranslate.addPhraseId('updatedSuccessfully',"$1 更新成功");

// used in ricoTree.js

RicoTranslate.addPhraseId('treeSave',"保存选择");
RicoTranslate.addPhraseId('treeClear',"全部清除");

// used in ricoCalendar.js

RicoTranslate.addPhraseId('calToday',"今天是 $3 年 $4 月 $1 日");  // $1=day, $2=monthabbr, $3=year, $4=month number
RicoTranslate.addPhraseId('calWeekHdg',"星期");
RicoTranslate.addPhraseId('calYearRange',"$1年 - $2年");
RicoTranslate.addPhraseId('calInvalidYear',"无效的年份");

// Date & number formats

RicoTranslate.thouSep=","
RicoTranslate.decPoint="."
RicoTranslate.dateFmt="yyyy年mm月dd日"

RicoTranslate.monthNames=['1月','2月', '3月', '4月', '5月','6月', '7月','8月','9月','10月','11月','12月']
RicoTranslate.dayNames=['星期日','星期一','星期二','星期三','星期四','星期五','星期六']

RicoTranslate.monthAbbr=function(monthIdx) {
  return this.monthNames[monthIdx];
}

Rico.includeLoaded('ricoLocale_zh.js');

