<?php
namespace Redaxscript\Navigation;

use Redaxscript\Language;
use Redaxscript\Registry;
use function array_replace_recursive;

/**
 * abstract class to create a navigation class
 *
 * @since 3.3.0
 *
 * @package Redaxscript
 * @category Navigation
 * @author Henry Ruhs
 */

abstract class NavigationAbstract implements NavigationInterface
{
	/**
	 * options of the navigation
	 *
	 * @var array
	 */

	protected array $_optionArray =
	[
		'className' =>
		[
			'list' => 'rs-list-navigation',
			'active' => 'rs-item-active'
		]
	];

	/**
	 * constructor of the class
	 *
	 * @since 3.3.0
	 *
	 * @param Registry $_registry instance of the registry class
	 * @param Language $_language instance of the language class
	 */

	public function __construct(protected Registry $_registry, protected Language $_language)
	{
	}

	/**
	 * init the class
	 *
	 * @since 3.3.0
	 *
	 * @param array $optionArray options of the navigation
	 *
	 * @return self
	 */

	public function init(array $optionArray = []) : self
	{
		$this->_optionArray = array_replace_recursive($this->_optionArray, $optionArray);
		return $this;
	}

	/**
	 * stringify the navigation
	 *
	 * @since 3.3.0
	 *
	 * @return string
	 */

	public function __toString() : string
	{
		return $this->render();
	}
}
