<?php
namespace Redaxscript\Console;

use Redaxscript\Config;
use Redaxscript\Language;
use Redaxscript\Registry;
use Redaxscript\Request;
use Redaxscript\Validator;
use function php_sapi_name;

/**
 * abstract class to handle the command line interface
 *
 * @since 3.0.0
 *
 * @package Redaxscript
 * @category Console
 * @author Henry Ruhs
 */

abstract class ConsoleAbstract
{
	/**
	 * array of command namespaces
	 *
	 * @var array
	 */

	protected array $_namespaceArray;

	/**
	 * constructor of the class
	 *
	 * @since 4.5.0
	 *
	 * @param Registry $_registry instance of the registry class
	 * @param Request $_request instance of the request class
	 * @param Language $_language instance of the language class
	 * @param Config $_config instance of the config class
	 */

	public function __construct(protected Registry $_registry, protected Request $_request, protected Language $_language, protected Config $_config)
	{
		$accessValidator = new Validator\Access();

		if (php_sapi_name() === 'cli')
		{
			$this->_namespaceArray =
			[
				'backup' => 'Redaxscript\Console\Command\Backup',
				'cache' => 'Redaxscript\Console\Command\Cache',
				'config' => 'Redaxscript\Console\Command\Config',
				'help' => 'Redaxscript\Console\Command\Help',
				'install' => 'Redaxscript\Console\Command\Install',
				'migrate' => 'Redaxscript\Console\Command\Migrate',
				'restore' => 'Redaxscript\Console\Command\Restore',
				'setting' => 'Redaxscript\Console\Command\Setting',
				'status' => 'Redaxscript\Console\Command\Status',
				'uninstall' => 'Redaxscript\Console\Command\Uninstall'
			];
		}
		else if($this->_request->getServer('REMOTE_ADDR') === '127.0.0.1' || $accessValidator->validate('1', $this->_registry->get('myGroups')))
		{
			$this->_namespaceArray =
			[
				'auth' => 'Redaxscript\Console\Command\Auth',
				'backup' => 'Redaxscript\Console\Command\Backup',
				'cache' => 'Redaxscript\Console\Command\Cache',
				'config' => 'Redaxscript\Console\Command\Config',
				'help' => 'Redaxscript\Console\Command\Help',
				'install' => 'Redaxscript\Console\Command\Install',
				'migrate' => 'Redaxscript\Console\Command\Migrate',
				'restore' => 'Redaxscript\Console\Command\Restore',
				'setting' => 'Redaxscript\Console\Command\Setting',
				'status' => 'Redaxscript\Console\Command\Status',
				'uninstall' => 'Redaxscript\Console\Command\Uninstall'
			];
		}
		else
		{
			$this->_namespaceArray =
			[
				'auth' => 'Redaxscript\Console\Command\Auth',
				'help' => 'Redaxscript\Console\Command\Help',
				'status' => 'Redaxscript\Console\Command\Status'
			];
		}
	}
}
