<?php
namespace Redaxscript\Bootstrap;

use Redaxscript\Registry;
use Redaxscript\Request;

/**
 * abstract class to create a bootstrap class
 *
 * @since 3.1.0
 *
 * @package Redaxscript
 * @category Bootstrap
 * @author Henry Ruhs
 *
 * @method protected autorun()
 */

abstract class BootstrapAbstract implements BootstrapInterface
{
	/**
	 * constructor of the class
	 *
	 * @since 3.1.0
	 *
	 * @param Registry $_registry instance of the registry class
	 * @param Request $_request instance of the request class
	 */

	public function __construct(protected Registry $_registry, protected Request $_request)
	{
		$this->autorun();
	}
}
