
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `reader356`
--

-- --------------------------------------------------------

--
-- Table structure for table `authors`
--

CREATE TABLE `authors` (
  `auh_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `auh_title` varchar(255) NOT NULL,
  `auh_datecreated` datetime NOT NULL,
  PRIMARY KEY (`auh_id`),
  UNIQUE KEY `auh_title` (`auh_title`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `categories`
--

CREATE TABLE `categories` (
  `cat_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `itm_id` bigint(20) unsigned NOT NULL,
  `cat_title` varchar(255) NOT NULL,
  `cat_datecreated` datetime NOT NULL,
  PRIMARY KEY (`cat_id`),
  KEY `itm_id` (`itm_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `connections`
--

CREATE TABLE `connections` (
  `cnt_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `mbr_id` bigint(20) unsigned NOT NULL,
  `token_connection` char(40) DEFAULT NULL,
  `cnt_ip` varchar(255) DEFAULT NULL,
  `cnt_agent` varchar(255) NOT NULL,
  `cnt_datecreated` datetime NOT NULL,
  PRIMARY KEY (`cnt_id`),
  UNIQUE KEY `token_connection` (`token_connection`),
  KEY `mbr_id` (`mbr_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `connections`
--


-- --------------------------------------------------------

--
-- Table structure for table `crawler`
--

CREATE TABLE `crawler` (
  `crr_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `crr_time` double unsigned NOT NULL,
  `crr_memory` int(10) unsigned DEFAULT NULL,
  `crr_feeds` int(10) unsigned NOT NULL,
  `crr_errors` int(10) unsigned DEFAULT NULL,
  `crr_datecreated` datetime NOT NULL,
  PRIMARY KEY (`crr_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `elasticsearch_items`
--

CREATE TABLE `elasticsearch_items` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `itm_id` bigint(20) unsigned NOT NULL,
  `datecreated` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `itm_id` (`itm_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `enclosures`
--

CREATE TABLE `enclosures` (
  `enr_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `itm_id` bigint(20) unsigned NOT NULL,
  `enr_link` varchar(255) NOT NULL,
  `enr_type` varchar(255) NOT NULL,
  `enr_length` int(10) unsigned DEFAULT NULL,
  `enr_width` int(10) unsigned DEFAULT NULL,
  `enr_height` int(10) unsigned DEFAULT NULL,
  `enr_datecreated` datetime NOT NULL,
  PRIMARY KEY (`enr_id`),
  KEY `itm_id` (`itm_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `favorites`
--

CREATE TABLE `favorites` (
  `fav_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `mbr_id` bigint(20) unsigned NOT NULL,
  `itm_id` bigint(20) unsigned NOT NULL,
  `fav_datecreated` datetime NOT NULL,
  PRIMARY KEY (`fav_id`),
  KEY `mbr_id` (`mbr_id`),
  KEY `itm_id` (`itm_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `feeds`
--

CREATE TABLE `feeds` (
  `fed_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `fed_title` varchar(255) DEFAULT NULL,
  `fed_url` varchar(255) DEFAULT NULL,
  `fed_link` varchar(255) NOT NULL,
  `fed_host` varchar(255) DEFAULT NULL,
  `fed_type` enum('rss','atom') DEFAULT NULL,
  `fed_image` varchar(255) DEFAULT NULL,
  `fed_description` text,
  `fed_direction` char(3) DEFAULT NULL,
  `fed_lasterror` varchar(255) DEFAULT NULL,
  `fed_lastcrawl` datetime DEFAULT NULL,
  `fed_nextcrawl` datetime DEFAULT NULL,
  `fed_datecreated` datetime NOT NULL,
  PRIMARY KEY (`fed_id`),
  KEY `fed_link` (`fed_link`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `folders`
--

CREATE TABLE `folders` (
  `flr_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `mbr_id` bigint(20) unsigned NOT NULL,
  `flr_title` varchar(255) NOT NULL,
  `flr_direction` char(3) DEFAULT NULL,
  `flr_datecreated` datetime NOT NULL,
  PRIMARY KEY (`flr_id`),
  KEY `mbr_id` (`mbr_id`),
  KEY `flr_title` (`flr_title`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `followers`
--

CREATE TABLE `followers` (
  `fws_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `mbr_id` bigint(20) unsigned NOT NULL,
  `fws_following` bigint(20) unsigned NOT NULL,
  `fws_datecreated` datetime NOT NULL,
  PRIMARY KEY (`fws_id`),
  KEY `mbr_id` (`mbr_id`),
  KEY `fws_following` (`fws_following`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `history`
--

CREATE TABLE `history` (
  `hst_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `mbr_id` bigint(20) unsigned NOT NULL,
  `itm_id` bigint(20) unsigned NOT NULL,
  `hst_real` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `hst_datecreated` datetime NOT NULL,
  PRIMARY KEY (`hst_id`),
  KEY `mbr_id` (`mbr_id`),
  KEY `itm_id` (`itm_id`),
  KEY `hst_real` (`hst_real`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `items`
--

CREATE TABLE `items` (
  `itm_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `fed_id` bigint(20) unsigned NOT NULL,
  `auh_id` bigint(20) unsigned DEFAULT NULL,
  `itm_title` varchar(255) NOT NULL,
  `itm_link` varchar(255) NOT NULL,
  `itm_author` varchar(255) DEFAULT NULL,
  `itm_content` longtext,
  `itm_latitude` double DEFAULT NULL,
  `itm_longitude` double DEFAULT NULL,
  `itm_date` datetime NOT NULL,
  `itm_deleted` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `itm_datecreated` datetime NOT NULL,
  PRIMARY KEY (`itm_id`),
  KEY `fed_id` (`fed_id`),
  KEY `auh_id` (`auh_id`),
  KEY `itm_link` (`itm_link`),
  KEY `itm_date` (`itm_date`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `members`
--

CREATE TABLE `members` (
  `mbr_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `mbr_email` varchar(255) NOT NULL,
  `mbr_password` char(40) NOT NULL,
  `mbr_nickname` varchar(255) DEFAULT NULL,
  `mbr_auth_ldap` tinyint(1) NOT NULL DEFAULT '0',
  `mbr_gravatar` varchar(255) DEFAULT NULL,
  `mbr_description` text,
  `mbr_administrator` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `token_password` char(40) DEFAULT NULL,
  `token_share` char(40) DEFAULT NULL,
  `token_msapplication` char(40) DEFAULT NULL,
  `mbr_datecreated` datetime NOT NULL,
  PRIMARY KEY (`mbr_id`),
  UNIQUE KEY `mbr_email` (`mbr_email`),
  UNIQUE KEY `token_password` (`token_password`),
  UNIQUE KEY `mbr_nickname` (`mbr_nickname`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `members`
--

INSERT INTO `members` VALUES
(1, '[[admin_email]]', '[[admin_pass]]', NULL, 0, NULL, NULL, 1, NULL, '[[token_share]]', '[[token_msapplication]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `settings`
--

CREATE TABLE `settings` (
  `stg_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `stg_code` varchar(255) NOT NULL,
  `stg_type` varchar(255) NOT NULL,
  `stg_value` varchar(255) DEFAULT NULL,
  `stg_note` varchar(255) DEFAULT NULL,
  `stg_is_global` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `stg_is_member` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `stg_is_subscription` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `stg_datecreated` datetime NOT NULL,
  PRIMARY KEY (`stg_id`),
  UNIQUE KEY `stg_code` (`stg_code`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=55 ;

--
-- Dumping data for table `settings`
--

INSERT INTO `settings` VALUES
(1, 'wallabag/enabled', 'boolean', '0', NULL, 1, 0, 0, '[[regtime]]'),
(2, 'wallabag/url', 'string', 'http://localhost/wallabag', 'URL to installation, without trailing slash', 1, 0, 0, '[[regtime]]'),
(3, 'shaarli/enabled', 'boolean', '0', NULL, 1, 0, 0, '[[regtime]]'),
(4, 'shaarli/url', 'string', 'http://localhost/shaarli', 'URL to installation, without trailing slash', 1, 0, 0, '[[regtime]]'),
(5, 'proxy/enabled', 'boolean', '0', NULL, 1, 0, 0, '[[regtime]]'),
(6, 'proxy/http_only', 'boolean', '0', NULL, 1, 0, 0, '[[regtime]]'),
(7, 'folders', 'boolean', '1', NULL, 1, 0, 0, '[[regtime]]'),
(8, 'gravatar', 'boolean', '1', NULL, 1, 0, 0, '[[regtime]]'),
(9, 'gravatar_default', 'string', 'identicon', 'identicon, mm, monsterid, retro, wavatar', 1, 1, 0, '[[regtime]]'),
(10, 'gravatar_rating', 'string', 'pg', 'g, pg, r, x', 1, 1, 0, '[[regtime]]'),
(11, 'gravatar_size', 'integer', '70', NULL, 1, 0, 0, '[[regtime]]'),
(12, 'menu_geolocation_items', 'boolean', '1', NULL, 1, 1, 0, '[[regtime]]'),
(13, 'menu_audio_items', 'boolean', '1', NULL, 1, 1, 0, '[[regtime]]'),
(14, 'menu_video_items', 'boolean', '1', NULL, 1, 1, 0, '[[regtime]]'),
(15, 'readability_parser_key', 'string', NULL, NULL, 1, 1, 0, '[[regtime]]'),
(16, 'sender_email', 'email', 'mailer@readerself.com', NULL, 1, 0, 0, '[[regtime]]'),
(17, 'sender_name', 'string', 'Reader Self', NULL, 1, 0, 0, '[[regtime]]'),
(18, 'shared_items', 'boolean', '1', NULL, 1, 1, 0, '[[regtime]]'),
(19, 'share_external_email', 'boolean', '1', NULL, 1, 1, 0, '[[regtime]]'),
(20, 'social_buttons', 'boolean', '1', NULL, 1, 1, 0, '[[regtime]]'),
(21, 'starred_items', 'boolean', '1', NULL, 1, 1, 0, '[[regtime]]'),
(22, 'tags', 'boolean', '1', NULL, 1, 1, 0, '[[regtime]]'),
(23, 'share_external', 'boolean', '1', NULL, 1, 1, 0, '[[regtime]]'),
(24, 'title', 'string', 'Reader Self', NULL, 1, 0, 0, '[[regtime]]'),
(25, 'members_list', 'boolean', '0', NULL, 1, 0, 0, '[[regtime]]'),
(26, 'register_multi', 'boolean', '0', NULL, 1, 0, 0, '[[regtime]]'),
(27, 'refresh_by_cron', 'boolean', '1', NULL, 1, 0, 0, '[[regtime]]'),
(28, 'menu_authors', 'boolean', '1', NULL, 1, 1, 0, '[[regtime]]'),
(29, 'elasticsearch/enabled', 'boolean', '0', NULL, 1, 0, 0, '[[regtime]]'),
(30, 'elasticsearch/index', 'string', 'readerself', NULL, 1, 0, 0, '[[regtime]]'),
(31, 'elasticsearch/url', 'string', 'http://127.0.0.1:9200', NULL, 1, 0, 0, '[[regtime]]'),
(32, 'facebook/enabled', 'boolean', '0', NULL, 1, 0, 0, '[[regtime]]'),
(33, 'facebook/id', 'string', NULL, NULL, 1, 0, 0, '[[regtime]]'),
(34, 'facebook/secret', 'string', NULL, NULL, 1, 0, 0, '[[regtime]]'),
(35, 'material-design/colors/meta/theme', 'varchar', '#009688', NULL, 1, 0, 0, '[[regtime]]'),
(36, 'material-design/colors/text/card-title-highlight', 'varchar', 'white', NULL, 1, 0, 0, '[[regtime]]'),
(37, 'material-design/colors/text/card-title', 'varchar', 'grey-700', NULL, 1, 0, 0, '[[regtime]]'),
(38, 'material-design/colors/text/card-actions', 'varchar', 'grey-700', NULL, 1, 0, 0, '[[regtime]]'),
(39, 'material-design/colors/text/link', 'varchar', 'pink', NULL, 1, 0, 0, '[[regtime]]'),
(40, 'material-design/colors/text/content', 'varchar', 'black', NULL, 1, 0, 0, '[[regtime]]'),
(41, 'material-design/colors/background/layout', 'varchar', 'grey-100', NULL, 1, 0, 0, '[[regtime]]'),
(42, 'material-design/colors/background/header', 'varchar', 'teal', NULL, 1, 0, 0, '[[regtime]]'),
(43, 'material-design/colors/background/button', 'varchar', 'pink', NULL, 1, 0, 0, '[[regtime]]'),
(44, 'material-design/colors/text/button', 'varchar', 'white', NULL, 1, 0, 0, '[[regtime]]'),
(45, 'material-design/colors/background/card', 'varchar', 'white', NULL, 1, 0, 0, '[[regtime]]'),
(46, 'material-design/colors/background/menu', 'varchar', 'white', NULL, 1, 0, 0, '[[regtime]]'),
(47, 'material-design/colors/background/card-title-highlight', 'varchar', 'teal', NULL, 1, 0, 0, '[[regtime]]'),
(48, 'evernote/enabled', 'boolean', '0', NULL, 1, 0, 0, '[[regtime]]'),
(49, 'evernote/sandbox', 'boolean', '0', NULL, 1, 0, 0, '[[regtime]]'),
(50, 'evernote/consumer_key', 'string', NULL, NULL, 1, 0, 0, '[[regtime]]'),
(51, 'evernote/consumer_secret', 'string', NULL, NULL, 1, 0, 0, '[[regtime]]'),
(52, 'instagram/enabled', 'boolean', '0', NULL, 1, 0, 0, '[[regtime]]'),
(53, 'instagram/client_id', 'string', NULL, NULL, 1, 0, 0, '[[regtime]]'),
(54, 'instagram/client_secret', 'string', NULL, NULL, 1, 0, 0, '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `share`
--

CREATE TABLE `share` (
  `shr_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `mbr_id` bigint(20) unsigned NOT NULL,
  `itm_id` bigint(20) unsigned NOT NULL,
  `shr_datecreated` datetime NOT NULL,
  PRIMARY KEY (`shr_id`),
  KEY `mbr_id` (`mbr_id`),
  KEY `itm_id` (`itm_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `subscriptions`
--

CREATE TABLE `subscriptions` (
  `sub_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `mbr_id` bigint(20) unsigned NOT NULL,
  `fed_id` bigint(20) unsigned NOT NULL,
  `flr_id` bigint(20) unsigned DEFAULT NULL,
  `sub_title` varchar(255) DEFAULT NULL,
  `sub_priority` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `sub_direction` char(3) DEFAULT NULL,
  `sub_datecreated` datetime NOT NULL,
  PRIMARY KEY (`sub_id`),
  KEY `mbr_id` (`mbr_id`),
  KEY `fed_id` (`fed_id`),
  KEY `flr_id` (`flr_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tags`
--

CREATE TABLE `tags` (
  `tag_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `tag_title` varchar(255) NOT NULL,
  `tag_datecreated` datetime NOT NULL,
  PRIMARY KEY (`tag_id`),
  UNIQUE KEY `tag_title` (`tag_title`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tags_items`
--

CREATE TABLE `tags_items` (
  `tag_itm_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `tag_id` bigint(20) unsigned NOT NULL,
  `itm_id` bigint(20) unsigned NOT NULL,
  `tag_itm_datecreated` datetime NOT NULL,
  PRIMARY KEY (`tag_itm_id`),
  KEY `tag_id` (`tag_id`),
  KEY `itm_id` (`itm_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tokens`
--

CREATE TABLE `tokens` (
  `tok_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `mbr_id` bigint(20) unsigned NOT NULL,
  `tok_type` varchar(255) NOT NULL,
  `tok_value` varchar(255) NOT NULL,
  `tok_sandbox` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `tok_datecreated` datetime NOT NULL,
  PRIMARY KEY (`tok_id`),
  KEY `mbr_id` (`mbr_id`),
  KEY `tok_type` (`tok_type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
