<?php

$type = "auto";
$version = 3;
$milestone = 4;
$release = 6;

// sidewide constants
if (!defined("RAZOR_BASE_PATH"))
{
	$type = "manual";

	define("RAZOR_BASE_PATH", str_replace("storage/tmp/package/system_upgrade_post_install.php", "", $_SERVER["SCRIPT_FILENAME"]));
	$port = ($_SERVER["SERVER_PORT"] == "80" ? "" : ":{$_SERVER["SERVER_PORT"]}");
	define("RAZOR_BASE_URL", "http://".$_SERVER["SERVER_NAME"].$port.str_replace("storage/tmp/package/system_upgrade_post_install.php", "", $_SERVER["SCRIPT_NAME"]));
	define("RAZOR_USERS_IP", $_SERVER["REMOTE_ADDR"]);
	define("RAZOR_USERS_UAGENT", $_SERVER["HTTP_USER_AGENT"]);

	// includes
	include_once(RAZOR_BASE_PATH.'library/php/razor/razor_file_tools.php');
	include_once(RAZOR_BASE_PATH.'library/php/razor/razor_error_handler.php');
	if (is_file(RAZOR_BASE_PATH."library/php/razor/razor_db.php")) include_once(RAZOR_BASE_PATH."library/php/razor/razor_db.php");

	// Load error handler
	$error = new RazorErrorHandler();
	set_error_handler(array($error, 'handle_error'));
	set_exception_handler(array($error, 'handle_error'));
}

////////////////////////////
// Check sqlite available //
////////////////////////////

try
{
	////////////////////
	// Data Migration //
	////////////////////

	if (!is_file(RAZOR_BASE_PATH.'storage/database/razorcms.sqlite'))
	{
		// create old razorDB object for migrating data
		$old_db = new RazorDB();

		$db_tables = array();
		$blog_tables = array();

		// grab all razor db files
		$handle = opendir(RAZOR_BASE_PATH.'storage/database');
		while (false !== ($entry = readdir($handle))) {
			// skip anything not needed
			if ($entry == '..' || $entry == '.' || substr($entry, 0, 1) == '~' || substr($entry, -6) != 'db.php' || $entry == 'site.db.php') continue;

			// grab table data
			$db_table = array();
			$file_handle = fopen(RAZOR_BASE_PATH."storage/database/{$entry}", 'r');
			$c = 0;
		    while (($line = fgets($file_handle)) !== false && $c < 7)
		    {
		    	// incrememnt and skip anything we don't want
		    	$c++;
		    	if ($c < 6) continue;

		    	// pull table data
		    	if ($c == 6)
		    	{
		    		$temp = explode(':', trim(substr($line, 2)));
		    		$db_table['name'] = $temp[1];
		    	}
		    	if ($c == 7) $db_table['columns'] = explode('|', trim(substr($line, 11)));
		    }
		    fclose($file_handle);

		    // add data to system db or extension db if blog extension
		    if ($entry == 'extension_razorcms_blog.db.php' || $entry == 'extension_razorcms_blog_item.db.php')
		    {
				$db_table['name'] = ($db_table['name'] == 'extension_razorcms_blogs' ? 'extension_razorcms_blog' : $db_table['name']);
		    	$blog_tables[$db_table['name']] = $db_table;
		    }
		    else $db_tables[$db_table['name']] = $db_table;

		}
		closedir($handle);

		// create dbs
		$db = new PDO('sqlite:'.RAZOR_BASE_PATH.'storage/database/razorcms.sqlite');

		// migrate database structure to sqlite
		foreach ($db_tables as $table)
		{
			// create query
			$query = "CREATE TABLE IF NOT EXISTS {$table['name']} (id INTEGER PRIMARY KEY";
			foreach ($table['columns'] as $column)
			{
				// grab data and skip id
				$col_data = explode(':', $column);
				if ($col_data[1] == 'id') continue;

				// add col, bools and ints as integer, string as text
				$query.= ", {$col_data[1]}".($col_data[2] == 'string' ? ' TEXT' : ' INTEGER').(!$col_data[3] ? ' NOT NULL' : ' NULL');
			}
			$query.= ')';

			// prepare and execute
			$q = $db->prepare($query);
			$q->execute();
		}

		// migrate data to sqlite database
		foreach ($db_tables as $name => $table)
		{
			// build up the col names
			$col_names = '';
			foreach ($db_tables[$name]['columns'] as $col_name)
			{
				$col_names_temp = explode(':', $col_name);
				$col_names.= $col_names_temp[1].',';
			}
			$col_names = substr($col_names, 0, -1);

			// read all entries for each razor db table and add to sqlite db

			// connect, grab data and disconnect
			$old_db->connect($name);
			$result = $old_db->get_rows(array('column' => 'id', 'not' => true, 'value' => null));
			$old_db->disconnect();

			// add results to sqlite
			if ($result['count'] > 0)
			{
				foreach ($result['result'] as $row)
				{
				   	// build query
				   	$query = "INSERT INTO {$name} ({$col_names}) VALUES ";
					$query.= "(";
					foreach ($row as $row_name => $row_value) $query.= ":param_{$row_name},";
					$query = substr($query, 0, -1).')';

					// prepare and bind
					$q = $db->prepare($query);
					foreach ($row as $row_name => $row_value)
					{
						$row_value = (is_bool($row_value) ? (int) $row_value : $row_value);
						$q->bindValue("param_{$row_name}", $row_value);
					}

					// execute
					$q->execute();
				}
			}
		}

		// blog data found
		if (!empty($blog_tables))
		{
			$blog_db = new PDO('sqlite:'.RAZOR_BASE_PATH.'storage/database/social_razorcms_blog.sqlite');

			// migrate database structure to sqlite
			foreach ($blog_tables as $table)
			{
				$table_name = str_replace('extension_razorcms_', '', $table['name']);

				// create query
				$query = "CREATE TABLE IF NOT EXISTS {$table_name} (id INTEGER PRIMARY KEY";
				foreach ($table['columns'] as $column)
				{
					// grab data and skip id
					$col_data = explode(':', $column);
					if ($col_data[1] == 'id') continue;

					// add col, bools and ints as integer, string as text
					$query.= ", {$col_data[1]}".($col_data[2] == 'string' ? ' TEXT' : ' INTEGER').(!$col_data[3] ? ' NOT NULL' : ' NULL');
				}
				$query.= ')';

				// prepare and execute
				$q = $blog_db->prepare($query);
				$q->execute();
			}

			// migrate data to sqlite database
			foreach ($blog_tables as $name => $table)
			{
				// build up the col names
				$col_names = '';
				foreach ($blog_tables[$name]['columns'] as $col_name)
				{
					$col_names_temp = explode(':', $col_name);
					$col_names.= $col_names_temp[1].',';
				}
				$col_names = substr($col_names, 0, -1);

				// read all entries for each razor db table and add to sqlite db

				// connect, grab data and disconnect
				$old_db->connect($name);
				$result = $old_db->get_rows(array('column' => 'id', 'not' => true, 'value' => null));
				$old_db->disconnect();

				$table_name = str_replace('extension_razorcms_', '', $table['name']);

				// add results to sqlite
				if ($result['count'] > 0)
				{
					foreach ($result['result'] as $row)
					{
					   	// build query
					   	$query = "INSERT INTO {$table_name} ({$col_names}) VALUES ";
						$query.= "(";
						foreach ($row as $row_name => $row_value) $query.= ":param_{$row_name},";
						$query = substr($query, 0, -1).')';

						// prepare and bind
						$q = $blog_db->prepare($query);
						foreach ($row as $row_name => $row_value)
						{
							$row_value = (is_bool($row_value) ? (int) $row_value : $row_value);
							$q->bindValue("param_{$row_name}", $row_value);
						}

						// execute
						$q->execute();
					}
				}
			}
		}

		// clean up razor db files
		$handle = opendir(RAZOR_BASE_PATH.'storage/database');
		while (false !== ($filename = readdir($handle))) {
			// skip anything not needed
			if ($filename == '..' || $filename == '.' || substr($filename, -6) == 'sqlite') continue;

			// remove file
			unlink(RAZOR_BASE_PATH."storage/database/{$filename}");
		}
		closedir($handle);

		/////////////////////////////
		// Up Issue blog extension //
		/////////////////////////////

		if (is_dir(RAZOR_BASE_PATH.'extension/social/razorcms/blog'))
		{
			// set paths
			$tmp_path = RAZOR_BASE_PATH."storage/tmp";
			$tmp_package_path = RAZOR_BASE_PATH.'storage/tmp/package';
			$ext_path = RAZOR_BASE_PATH."extension";

			// check if folders exist
			if (!is_dir($tmp_path)) mkdir($tmp_path);
			if (!is_dir($tmp_package_path)) mkdir($tmp_package_path);
			if (!is_dir($ext_path)) mkdir($ext_path);

			// includes
			include_once(RAZOR_BASE_PATH."library/php/razor/razor_zip.php");

			// need to download and update newest version of blog
			$category = 'social';
			$handle = 'razorcms';
			$name = 'blog';

			// fetch details
			$package_url = "http://archive.razorcms.co.uk/extension/social/razorcms/blog/blog.zip";
			$headers = @get_headers($package_url);

			if(strpos($headers[0], "404") === false)
			{
				$ctx = stream_context_create(array(
					'http' => array(
						'timeout' => 60
						)
					)
				);

				// copy package to temp location
				$package_contents = @file_get_contents($package_url, false, $ctx);
				if (!empty($package_contents))
				{
					if (!RazorFileTools::write_file_contents("{$tmp_package_path}/{$name}.zip", $package_contents)) throw new Exception("Could not write upgrade file to storage/tmp/package.");
				}

				// extract to file system
				if (!is_file("{$tmp_package_path}/{$name}.zip")) throw new exception("Extension file not found.");

				// open extension package
				$zip = new RazorZip;
				$zip->open("{$tmp_package_path}/{$name}.zip");

				// extract
				$zip->extractTo(RAZOR_BASE_PATH);
				$zip->close();
			}
		}

		// End of blog up issue

		// up to v 3.4.2

		///////////////////////////
		// Update system version //
		///////////////////////////

		$db = new PDO('sqlite:'.RAZOR_BASE_PATH.'storage/database/razorcms.sqlite');

		// update to v 3.4.3
		$query = "UPDATE system SET version = {$version}, milestone = {$milestone}, release = {$release} WHERE id = 1";
		$dbh = $db->prepare($query);
		$dbh->execute();
	}
	else
	{
		// upgrade without migration i.e. 3.4.3 and up

		///////////////////////////
		// Update system version //
		///////////////////////////

		if ($type == 'auto') $this->razor_db->edit_data('system', array('version' => $version, 'milestone' => $milestone, 'release' => $release), array('id' => 1));
		else
		{
			define('RAZOR_PDO', 'sqlite:'.RAZOR_BASE_PATH.'storage/database/razorcms.sqlite');
			include_once(RAZOR_BASE_PATH."library/php/razor/razor_pdo.php");
			$razor_db = new RazorPDO();
			$razor_db->edit_data('system', array('version' => $version, 'milestone' => $milestone, 'release' => $release), array('id' => 1));
		}
	}

	// End of data migration

	if ($type == "manual")
	{
		echo "Your system upgrade is complete<br>";
		echo "Please delete all browser cache and reload your site";
		unlink(__FILE__);
	}

}
catch (Exception $e)
{
	// sqlite not available, revert upgrade from backup
	// revert install using backup

	// open backup dir and get latestbackup file
	$backup_dir = RazorFileTools::read_dir_contents(RAZOR_BASE_PATH.'storage/tmp/backup', 'files');
	$latest_backup = null;
	foreach ($backup_dir as $backup_file)
	{
		// get timestamp from backup file and latest backup
		$lb_ts_parts = explode('_', substr($latest_backup, 0, -4));
		$lb_ts = (empty($latest_backup) ? 0 : (int) end($lb_ts_parts));
		$bf_ts_parts = explode('_', substr($backup_file, 0, -4));
		$bf_ts = (int) end($bf_ts_parts);

		if ($bf_ts > $lb_ts) $latest_backup = $backup_file;
	}

	if (empty($latest_backup))
	{
		$this->response("Error upgrading, sqlite PDO not available, restore failed", "json", 409);
		exit();
	}

	$zip = new RazorZip;
	$zip->open(RAZOR_BASE_PATH."storage/tmp/backup/{$latest_backup}");
	$zip->extractTo(RAZOR_BASE_PATH);
	$zip->close();

	// remove tmp files
	RazorFileTools::delete_directory(RAZOR_BASE_PATH."storage/tmp/backup");

	$this->response("Error upgrading, sqlite PDO not available, restored system to previous version", "json", 409);
	exit();
}
