<?php
/**
*qdPM
*
* NOTICE OF LICENSE
*
* This source file is subject to the Open Software License (OSL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/osl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@qdPM.net so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade qdPM to newer
* versions in the future. If you wish to customize qdPM for your
* needs please refer to http://www.qdPM.net for more information.
*
* @copyright  Copyright (c) 2009  Sergey Kharchishin and Kym Romanets (http://www.qdpm.net)
* @license    http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
*/
?>
<?php
// Connection Component Binding
Doctrine_Manager::getInstance()->bindComponent('Projects', 'doctrine');

/**
 * BaseProjects
 * 
 * This class has been auto-generated by the Doctrine ORM Framework
 * 
 * @property integer $id
 * @property integer $projects_status_id
 * @property integer $projects_types_id
 * @property integer $created_by
 * @property string $name
 * @property string $description
 * @property string $team
 * @property timestamp $created_at
 * @property string $order_tasks_by
 * @property ProjectsStatus $ProjectsStatus
 * @property ProjectsTypes $ProjectsTypes
 * @property Users $Users
 * @property Doctrine_Collection $Discussions
 * @property Doctrine_Collection $ProjectsComments
 * @property Doctrine_Collection $ProjectsPhases
 * @property Doctrine_Collection $Tasks
 * @property Doctrine_Collection $TasksGroups
 * @property Doctrine_Collection $Tickets
 * @property Doctrine_Collection $Versions
 * 
 * @method integer             getId()                 Returns the current record's "id" value
 * @method integer             getProjectsStatusId()   Returns the current record's "projects_status_id" value
 * @method integer             getProjectsTypesId()    Returns the current record's "projects_types_id" value
 * @method integer             getCreatedBy()          Returns the current record's "created_by" value
 * @method string              getName()               Returns the current record's "name" value
 * @method string              getDescription()        Returns the current record's "description" value
 * @method string              getTeam()               Returns the current record's "team" value
 * @method timestamp           getCreatedAt()          Returns the current record's "created_at" value
 * @method string              getOrderTasksBy()       Returns the current record's "order_tasks_by" value
 * @method ProjectsStatus      getProjectsStatus()     Returns the current record's "ProjectsStatus" value
 * @method ProjectsTypes       getProjectsTypes()      Returns the current record's "ProjectsTypes" value
 * @method Users               getUsers()              Returns the current record's "Users" value
 * @method Doctrine_Collection getDiscussions()        Returns the current record's "Discussions" collection
 * @method Doctrine_Collection getProjectsComments()   Returns the current record's "ProjectsComments" collection
 * @method Doctrine_Collection getProjectsPhases()     Returns the current record's "ProjectsPhases" collection
 * @method Doctrine_Collection getTasks()              Returns the current record's "Tasks" collection
 * @method Doctrine_Collection getTasksGroups()        Returns the current record's "TasksGroups" collection
 * @method Doctrine_Collection getTickets()            Returns the current record's "Tickets" collection
 * @method Doctrine_Collection getVersions()           Returns the current record's "Versions" collection
 * @method Projects            setId()                 Sets the current record's "id" value
 * @method Projects            setProjectsStatusId()   Sets the current record's "projects_status_id" value
 * @method Projects            setProjectsTypesId()    Sets the current record's "projects_types_id" value
 * @method Projects            setCreatedBy()          Sets the current record's "created_by" value
 * @method Projects            setName()               Sets the current record's "name" value
 * @method Projects            setDescription()        Sets the current record's "description" value
 * @method Projects            setTeam()               Sets the current record's "team" value
 * @method Projects            setCreatedAt()          Sets the current record's "created_at" value
 * @method Projects            setOrderTasksBy()       Sets the current record's "order_tasks_by" value
 * @method Projects            setProjectsStatus()     Sets the current record's "ProjectsStatus" value
 * @method Projects            setProjectsTypes()      Sets the current record's "ProjectsTypes" value
 * @method Projects            setUsers()              Sets the current record's "Users" value
 * @method Projects            setDiscussions()        Sets the current record's "Discussions" collection
 * @method Projects            setProjectsComments()   Sets the current record's "ProjectsComments" collection
 * @method Projects            setProjectsPhases()     Sets the current record's "ProjectsPhases" collection
 * @method Projects            setTasks()              Sets the current record's "Tasks" collection
 * @method Projects            setTasksGroups()        Sets the current record's "TasksGroups" collection
 * @method Projects            setTickets()            Sets the current record's "Tickets" collection
 * @method Projects            setVersions()           Sets the current record's "Versions" collection
 * 
 * @package    sf_sandbox
 * @subpackage model
 * @author     Your name here
 * @version    SVN: $Id: Builder.php 7490 2010-03-29 19:53:27Z jwage $
 */
abstract class BaseProjects extends sfDoctrineRecord
{
    public function setTableDefinition()
    {
        $this->setTableName('projects');
        $this->hasColumn('id', 'integer', 4, array(
             'type' => 'integer',
             'fixed' => 0,
             'unsigned' => false,
             'primary' => true,
             'autoincrement' => true,
             'length' => 4,
             ));
        $this->hasColumn('projects_status_id', 'integer', 4, array(
             'type' => 'integer',
             'fixed' => 0,
             'unsigned' => false,
             'primary' => false,
             'notnull' => false,
             'autoincrement' => false,
             'length' => 4,
             ));
        $this->hasColumn('projects_types_id', 'integer', 4, array(
             'type' => 'integer',
             'fixed' => 0,
             'unsigned' => false,
             'primary' => false,
             'notnull' => false,
             'autoincrement' => false,
             'length' => 4,
             ));
        $this->hasColumn('created_by', 'integer', 4, array(
             'type' => 'integer',
             'fixed' => 0,
             'unsigned' => false,
             'primary' => false,
             'notnull' => false,
             'autoincrement' => false,
             'length' => 4,
             ));
        $this->hasColumn('name', 'string', 255, array(
             'type' => 'string',
             'fixed' => 0,
             'unsigned' => false,
             'primary' => false,
             'default' => '',
             'notnull' => true,
             'autoincrement' => false,
             'length' => 255,
             ));
        $this->hasColumn('description', 'string', null, array(
             'type' => 'string',
             'fixed' => 0,
             'unsigned' => false,
             'primary' => false,
             'notnull' => false,
             'autoincrement' => false,
             'length' => '',
             ));
        $this->hasColumn('team', 'string', null, array(
             'type' => 'string',
             'fixed' => 0,
             'unsigned' => false,
             'primary' => false,
             'notnull' => false,
             'autoincrement' => false,
             'length' => '',
             ));
        $this->hasColumn('created_at', 'timestamp', 25, array(
             'type' => 'timestamp',
             'fixed' => 0,
             'unsigned' => false,
             'primary' => false,
             'notnull' => false,
             'autoincrement' => false,
             'length' => 25,
             ));
        $this->hasColumn('order_tasks_by', 'string', 64, array(
             'type' => 'string',
             'fixed' => 0,
             'unsigned' => false,
             'primary' => false,
             'notnull' => false,
             'autoincrement' => false,
             'length' => 64,
             ));
    }

    public function setUp()
    {
        parent::setUp();
        $this->hasOne('ProjectsStatus', array(
             'local' => 'projects_status_id',
             'foreign' => 'id'));

        $this->hasOne('ProjectsTypes', array(
             'local' => 'projects_types_id',
             'foreign' => 'id'));

        $this->hasOne('Users', array(
             'local' => 'created_by',
             'foreign' => 'id'));

        $this->hasMany('Discussions', array(
             'local' => 'id',
             'foreign' => 'projects_id'));

        $this->hasMany('ProjectsComments', array(
             'local' => 'id',
             'foreign' => 'projects_id'));

        $this->hasMany('ProjectsPhases', array(
             'local' => 'id',
             'foreign' => 'projects_id'));

        $this->hasMany('Tasks', array(
             'local' => 'id',
             'foreign' => 'projects_id'));

        $this->hasMany('TasksGroups', array(
             'local' => 'id',
             'foreign' => 'projects_id'));

        $this->hasMany('Tickets', array(
             'local' => 'id',
             'foreign' => 'projects_id'));

        $this->hasMany('Versions', array(
             'local' => 'id',
             'foreign' => 'projects_id'));
    }
}
