<?php
/**
*qdPM
*
* NOTICE OF LICENSE
*
* This source file is subject to the Open Software License (OSL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/osl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@qdPM.net so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade qdPM to newer
* versions in the future. If you wish to customize qdPM for your
* needs please refer to http://www.qdPM.net for more information.
*
* @copyright  Copyright (c) 2009  Sergey Kharchishin and Kym Romanets (http://www.qdpm.net)
* @license    http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
*/
?>
<?php

/**
 * Projects
 * 
 * This class has been auto-generated by the Doctrine ORM Framework
 * 
 * @package    sf_sandbox
 * @subpackage model
 * @author     Your name here
 * @version    SVN: $Id: Builder.php 7490 2010-03-29 19:53:27Z jwage $
 */
class Projects extends BaseProjects
{
  public static function getTeamUsersByAccess($project_id, $access)
  {    
    $list = array();
    if($project = Doctrine_Core::getTable('Projects')->find($project_id))
    {
      foreach(explode(',',$project->getTeam()) as $users_id)
      {
        
        if($user = Doctrine_Core::getTable('Users')->find($users_id))
        {
          switch($access)
          {
            case 'tasks':
                if((int)$user->getUsersGroups()->getAllowManageTasks()>0)
                {
                  $list[] = $users_id;
                }
              break;
            case 'tickets':
                if((int)$user->getUsersGroups()->getAllowManageTickets()>0)
                {
                  $list[] = $users_id;
                }
              break;
            case 'discussions':
                if((int)$user->getUsersGroups()->getAllowManageDiscussions()>0)
                {
                  $list[] = $users_id;
                }
              break;
          }
          
        }
      }
    }
    
    return $list;
  }
  
  
  public static function getChoices($model,$sf_user)
  {
    $q = Doctrine_Core::getTable('Projects')->createQuery('p')
          
          ->leftJoin('p.ProjectsStatus ps')
          ->leftJoin('p.ProjectsTypes pt')          
          ->leftJoin('p.Users')
          ;
          
    if(Users::hasAccess('view_own','projects',$sf_user))
    {       
      $q->addWhere("find_in_set('" . $sf_user->getAttribute('id') . "',p.team) or p.created_by='" . $sf_user->getAttribute('id') . "'");
    }
            
    $choices = array(''=>'');
    foreach($q->orderBy('p.name')->fetchArray() as $p)
    {
      $choices[$p['id']] = $p['name'];
    }
    
    return $choices;
  }
  
  
  public static function hasViewOwnAccess($sf_user,$project)
  {
    if(Users::hasAccess('view_own','projects',$sf_user))
    {      
      if(!in_array($sf_user->getAttribute('id'),explode(',',$project->getTeam())) and $project->getCreatedBy()!=$sf_user->getAttribute('id'))
      {
        return false;
      }
      else
      {
        return true;
      }
    }
    else
    {
      return true;
    }
  }
  
  public static function checkViewOwnAccess($c,$sf_user,$project)
  {
    if(Users::hasAccess('view_own','projects',$sf_user))
    {      
      if(!in_array($sf_user->getAttribute('id'),explode(',',$project->getTeam())) and $project->getCreatedBy()!=$sf_user->getAttribute('id'))
      {
        $c->redirect('accessForbidden/index');
      }
    }
  }
  
  public static function sendNotification($c,$projects,$send_to,$sf_user)
  {
    foreach($send_to as $type=>$users)
    {
      switch($type)
      {
        case 'status': $subject = t::__('Project Status Updated');
          break;
        default: $subject = t::__('New Project');
          break;
      }
      
      $to = array();
      foreach($users as $v)
      {
        if($u = Doctrine_Core::getTable('Users')->find($v))
        {
          $to[$u->getEmail()]=$u->getName();
        }
      }
    
            
      $user = $sf_user->getAttribute('user');
      $from[$user->getEmail()] = $user->getName();
      $to[$projects->getUsers()->getEmail()] = $projects->getUsers()->getName();
      $to[$user->getEmail()] = $user->getName();
      
      if(sfConfig::get('app_send_email_to_owner')=='off')
      {
        unset($to[$user->getEmail()]);             
      }
    
       
      $subject .= ': ' . $projects->getName() . ($projects->getProjectsStatusId()>0 ? ' [' . $projects->getProjectsStatus()->getName() . ']':'');
      $body  = $c->getComponent('projects','emailBody',array('projects'=>$projects));
                                   
      Users::sendEmail($from,$to,$subject,$body,$sf_user);
    }                
  }
    
  public static function addFiltersToQuery($q,$filters)
  {
    $count_e = 0;
    
    foreach($filters as $table=>$fstr)
    {
      $ids = explode(',',$fstr);
      
      switch($table)
      {        
        case 'ProjectsStatus':
            $q->whereIn('p.projects_status_id',$ids);
          break;
        case 'ProjectsTypes':
            $q->whereIn('p.projects_types_id',$ids);
          break;       
        case 'Users':
            $filter_sql_array = array();
            foreach($ids as $id)
            {
              $filter_sql_array[] = 'find_in_set(' . $id . ',p.team)';
            }
            
            $q->addWhere(implode(' or ',$filter_sql_array));
          break;
      }
      
    }
          
    return $q;  
  }
  

  

  
  public static function getDefaultFilter($sf_user,$report_type = 'filter')
  {    
    $f = array();
    
    if(($v = app::getDefaultValueByTable('ProjectsStatus'))>0)
    {
      $f['ProjectsStatus'] = $v;
    }
    
    return $f;    
  }
  
  public static function  getListingOrderByType($q,$type)
  {
   switch($type)
   {
     case 'date_added':           $q->orderBy('p.created_at desc');
       break;
     case 'date_last_commented':  $q->orderBy('p.last_comment_date desc');
       break;
     case 'name':                 $q->orderBy('LTRIM(p.name)');
       break;     
     case 'status':               $q->orderBy('ps.sort_order,LTRIM(ps.name), LTRIM(p.name)');
       break;
     case 'type':                 $q->orderBy('pt.sort_order,LTRIM(pt.name), LTRIM(p.name)');
       break;     
     default:                     $q->orderBy('ps.sort_order,LTRIM(ps.name), LTRIM(p.name)');
      break;            
   }           
   
   return $q;
  }      
}
