<?php
/**
*qdPM
*
* NOTICE OF LICENSE
*
* This source file is subject to the Open Software License (OSL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/osl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@qdPM.net so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade qdPM to newer
* versions in the future. If you wish to customize qdPM for your
* needs please refer to http://www.qdPM.net for more information.
*
* @copyright  Copyright (c) 2009  Sergey Kharchishin and Kym Romanets (http://www.qdpm.net)
* @license    http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
*/
?>
<?php
// Connection Component Binding
Doctrine_Manager::getInstance()->bindComponent('Users', 'doctrine');

/**
 * BaseUsers
 * 
 * This class has been auto-generated by the Doctrine ORM Framework
 * 
 * @property integer $id
 * @property integer $users_group_id
 * @property string $name
 * @property string $photo
 * @property string $email
 * @property string $culture
 * @property string $password
 * @property integer $active
 * @property string $skin
 * @property UsersGroups $UsersGroups
 * @property Doctrine_Collection $Departments
 * @property Doctrine_Collection $Discussions
 * @property Doctrine_Collection $DiscussionsComments
 * @property Doctrine_Collection $DiscussionsReports
 * @property Doctrine_Collection $Events
 * @property Doctrine_Collection $Projects
 * @property Doctrine_Collection $ProjectsComments
 * @property Doctrine_Collection $ProjectsReports
 * @property Doctrine_Collection $Tasks
 * @property Doctrine_Collection $TasksComments
 * @property Doctrine_Collection $Tickets
 * @property Doctrine_Collection $TicketsComments
 * @property Doctrine_Collection $TicketsReports
 * @property Doctrine_Collection $UserReports
 * 
 * @method integer             getId()                  Returns the current record's "id" value
 * @method integer             getUsersGroupId()        Returns the current record's "users_group_id" value
 * @method string              getName()                Returns the current record's "name" value
 * @method string              getPhoto()               Returns the current record's "photo" value
 * @method string              getEmail()               Returns the current record's "email" value
 * @method string              getCulture()             Returns the current record's "culture" value
 * @method string              getPassword()            Returns the current record's "password" value
 * @method integer             getActive()              Returns the current record's "active" value
 * @method string              getSkin()                Returns the current record's "skin" value
 * @method UsersGroups         getUsersGroups()         Returns the current record's "UsersGroups" value
 * @method Doctrine_Collection getDepartments()         Returns the current record's "Departments" collection
 * @method Doctrine_Collection getDiscussions()         Returns the current record's "Discussions" collection
 * @method Doctrine_Collection getDiscussionsComments() Returns the current record's "DiscussionsComments" collection
 * @method Doctrine_Collection getDiscussionsReports()  Returns the current record's "DiscussionsReports" collection
 * @method Doctrine_Collection getEvents()              Returns the current record's "Events" collection
 * @method Doctrine_Collection getProjects()            Returns the current record's "Projects" collection
 * @method Doctrine_Collection getProjectsComments()    Returns the current record's "ProjectsComments" collection
 * @method Doctrine_Collection getProjectsReports()     Returns the current record's "ProjectsReports" collection
 * @method Doctrine_Collection getTasks()               Returns the current record's "Tasks" collection
 * @method Doctrine_Collection getTasksComments()       Returns the current record's "TasksComments" collection
 * @method Doctrine_Collection getTickets()             Returns the current record's "Tickets" collection
 * @method Doctrine_Collection getTicketsComments()     Returns the current record's "TicketsComments" collection
 * @method Doctrine_Collection getTicketsReports()      Returns the current record's "TicketsReports" collection
 * @method Doctrine_Collection getUserReports()         Returns the current record's "UserReports" collection
 * @method Users               setId()                  Sets the current record's "id" value
 * @method Users               setUsersGroupId()        Sets the current record's "users_group_id" value
 * @method Users               setName()                Sets the current record's "name" value
 * @method Users               setPhoto()               Sets the current record's "photo" value
 * @method Users               setEmail()               Sets the current record's "email" value
 * @method Users               setCulture()             Sets the current record's "culture" value
 * @method Users               setPassword()            Sets the current record's "password" value
 * @method Users               setActive()              Sets the current record's "active" value
 * @method Users               setSkin()                Sets the current record's "skin" value
 * @method Users               setUsersGroups()         Sets the current record's "UsersGroups" value
 * @method Users               setDepartments()         Sets the current record's "Departments" collection
 * @method Users               setDiscussions()         Sets the current record's "Discussions" collection
 * @method Users               setDiscussionsComments() Sets the current record's "DiscussionsComments" collection
 * @method Users               setDiscussionsReports()  Sets the current record's "DiscussionsReports" collection
 * @method Users               setEvents()              Sets the current record's "Events" collection
 * @method Users               setProjects()            Sets the current record's "Projects" collection
 * @method Users               setProjectsComments()    Sets the current record's "ProjectsComments" collection
 * @method Users               setProjectsReports()     Sets the current record's "ProjectsReports" collection
 * @method Users               setTasks()               Sets the current record's "Tasks" collection
 * @method Users               setTasksComments()       Sets the current record's "TasksComments" collection
 * @method Users               setTickets()             Sets the current record's "Tickets" collection
 * @method Users               setTicketsComments()     Sets the current record's "TicketsComments" collection
 * @method Users               setTicketsReports()      Sets the current record's "TicketsReports" collection
 * @method Users               setUserReports()         Sets the current record's "UserReports" collection
 * 
 * @package    sf_sandbox
 * @subpackage model
 * @author     Your name here
 * @version    SVN: $Id: Builder.php 7490 2010-03-29 19:53:27Z jwage $
 */
abstract class BaseUsers extends sfDoctrineRecord
{
    public function setTableDefinition()
    {
        $this->setTableName('users');
        $this->hasColumn('id', 'integer', 4, array(
             'type' => 'integer',
             'fixed' => 0,
             'unsigned' => false,
             'primary' => true,
             'autoincrement' => true,
             'length' => 4,
             ));
        $this->hasColumn('users_group_id', 'integer', 4, array(
             'type' => 'integer',
             'fixed' => 0,
             'unsigned' => false,
             'primary' => false,
             'notnull' => false,
             'autoincrement' => false,
             'length' => 4,
             ));
        $this->hasColumn('name', 'string', 255, array(
             'type' => 'string',
             'fixed' => 0,
             'unsigned' => false,
             'primary' => false,
             'default' => '',
             'notnull' => true,
             'autoincrement' => false,
             'length' => 255,
             ));
        $this->hasColumn('photo', 'string', 64, array(
             'type' => 'string',
             'fixed' => 0,
             'unsigned' => false,
             'primary' => false,
             'notnull' => false,
             'autoincrement' => false,
             'length' => 64,
             ));
        $this->hasColumn('email', 'string', 255, array(
             'type' => 'string',
             'fixed' => 0,
             'unsigned' => false,
             'primary' => false,
             'default' => '',
             'notnull' => true,
             'autoincrement' => false,
             'length' => 255,
             ));
        $this->hasColumn('culture', 'string', 5, array(
             'type' => 'string',
             'fixed' => 0,
             'unsigned' => false,
             'primary' => false,
             'notnull' => false,
             'autoincrement' => false,
             'length' => 5,
             ));
        $this->hasColumn('password', 'string', 64, array(
             'type' => 'string',
             'fixed' => 0,
             'unsigned' => false,
             'primary' => false,
             'default' => '',
             'notnull' => true,
             'autoincrement' => false,
             'length' => 64,
             ));
        $this->hasColumn('active', 'integer', 1, array(
             'type' => 'integer',
             'fixed' => 0,
             'unsigned' => false,
             'primary' => false,
             'notnull' => false,
             'autoincrement' => false,
             'length' => 1,
             ));
        $this->hasColumn('skin', 'string', 64, array(
             'type' => 'string',
             'fixed' => 0,
             'unsigned' => false,
             'primary' => false,
             'notnull' => false,
             'autoincrement' => false,
             'length' => 64,
             ));
    }

    public function setUp()
    {
        parent::setUp();
        $this->hasOne('UsersGroups', array(
             'local' => 'users_group_id',
             'foreign' => 'id'));

        $this->hasMany('Departments', array(
             'local' => 'id',
             'foreign' => 'users_id'));

        $this->hasMany('Discussions', array(
             'local' => 'id',
             'foreign' => 'users_id'));

        $this->hasMany('DiscussionsComments', array(
             'local' => 'id',
             'foreign' => 'users_id'));

        $this->hasMany('DiscussionsReports', array(
             'local' => 'id',
             'foreign' => 'users_id'));

        $this->hasMany('Events', array(
             'local' => 'id',
             'foreign' => 'users_id'));

        $this->hasMany('Projects', array(
             'local' => 'id',
             'foreign' => 'created_by'));

        $this->hasMany('ProjectsComments', array(
             'local' => 'id',
             'foreign' => 'created_by'));

        $this->hasMany('ProjectsReports', array(
             'local' => 'id',
             'foreign' => 'users_id'));

        $this->hasMany('Tasks', array(
             'local' => 'id',
             'foreign' => 'created_by'));

        $this->hasMany('TasksComments', array(
             'local' => 'id',
             'foreign' => 'created_by'));

        $this->hasMany('Tickets', array(
             'local' => 'id',
             'foreign' => 'users_id'));

        $this->hasMany('TicketsComments', array(
             'local' => 'id',
             'foreign' => 'users_id'));

        $this->hasMany('TicketsReports', array(
             'local' => 'id',
             'foreign' => 'users_id'));

        $this->hasMany('UserReports', array(
             'local' => 'id',
             'foreign' => 'users_id'));
    }
}
