<?php
/**
*qdPM
*
* NOTICE OF LICENSE
*
* This source file is subject to the Open Software License (OSL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/osl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@qdPM.net so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade qdPM to newer
* versions in the future. If you wish to customize qdPM for your
* needs please refer to http://www.qdPM.net for more information.
*
* @copyright  Copyright (c) 2009  Sergey Kharchishin and Kym Romanets (http://www.qdpm.net)
* @license    http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
*/
?>
<?php
// Connection Component Binding
Doctrine_Manager::getInstance()->bindComponent('Tickets', 'doctrine');

/**
 * BaseTickets
 * 
 * This class has been auto-generated by the Doctrine ORM Framework
 * 
 * @property integer $id
 * @property integer $departments_id
 * @property integer $tickets_types_id
 * @property integer $tickets_status_id
 * @property string $name
 * @property string $description
 * @property integer $users_id
 * @property integer $projects_id
 * @property timestamp $created_at
 * @property TicketsStatus $TicketsStatus
 * @property TicketsTypes $TicketsTypes
 * @property Users $Users
 * @property Projects $Projects
 * @property Departments $Departments
 * @property Doctrine_Collection $Tasks
 * @property Doctrine_Collection $TicketsComments
 * 
 * @method integer             getId()                Returns the current record's "id" value
 * @method integer             getDepartmentsId()     Returns the current record's "departments_id" value
 * @method integer             getTicketsTypesId()    Returns the current record's "tickets_types_id" value
 * @method integer             getTicketsStatusId()   Returns the current record's "tickets_status_id" value
 * @method string              getName()              Returns the current record's "name" value
 * @method string              getDescription()       Returns the current record's "description" value
 * @method integer             getUsersId()           Returns the current record's "users_id" value
 * @method integer             getProjectsId()        Returns the current record's "projects_id" value
 * @method timestamp           getCreatedAt()         Returns the current record's "created_at" value
 * @method TicketsStatus       getTicketsStatus()     Returns the current record's "TicketsStatus" value
 * @method TicketsTypes        getTicketsTypes()      Returns the current record's "TicketsTypes" value
 * @method Users               getUsers()             Returns the current record's "Users" value
 * @method Projects            getProjects()          Returns the current record's "Projects" value
 * @method Departments         getDepartments()       Returns the current record's "Departments" value
 * @method Doctrine_Collection getTasks()             Returns the current record's "Tasks" collection
 * @method Doctrine_Collection getTicketsComments()   Returns the current record's "TicketsComments" collection
 * @method Tickets             setId()                Sets the current record's "id" value
 * @method Tickets             setDepartmentsId()     Sets the current record's "departments_id" value
 * @method Tickets             setTicketsTypesId()    Sets the current record's "tickets_types_id" value
 * @method Tickets             setTicketsStatusId()   Sets the current record's "tickets_status_id" value
 * @method Tickets             setName()              Sets the current record's "name" value
 * @method Tickets             setDescription()       Sets the current record's "description" value
 * @method Tickets             setUsersId()           Sets the current record's "users_id" value
 * @method Tickets             setProjectsId()        Sets the current record's "projects_id" value
 * @method Tickets             setCreatedAt()         Sets the current record's "created_at" value
 * @method Tickets             setTicketsStatus()     Sets the current record's "TicketsStatus" value
 * @method Tickets             setTicketsTypes()      Sets the current record's "TicketsTypes" value
 * @method Tickets             setUsers()             Sets the current record's "Users" value
 * @method Tickets             setProjects()          Sets the current record's "Projects" value
 * @method Tickets             setDepartments()       Sets the current record's "Departments" value
 * @method Tickets             setTasks()             Sets the current record's "Tasks" collection
 * @method Tickets             setTicketsComments()   Sets the current record's "TicketsComments" collection
 * 
 * @package    sf_sandbox
 * @subpackage model
 * @author     Your name here
 * @version    SVN: $Id: Builder.php 7490 2010-03-29 19:53:27Z jwage $
 */
abstract class BaseTickets extends sfDoctrineRecord
{
    public function setTableDefinition()
    {
        $this->setTableName('tickets');
        $this->hasColumn('id', 'integer', 4, array(
             'type' => 'integer',
             'fixed' => 0,
             'unsigned' => false,
             'primary' => true,
             'autoincrement' => true,
             'length' => 4,
             ));
        $this->hasColumn('departments_id', 'integer', 4, array(
             'type' => 'integer',
             'fixed' => 0,
             'unsigned' => false,
             'primary' => false,
             'notnull' => false,
             'autoincrement' => false,
             'length' => 4,
             ));
        $this->hasColumn('tickets_types_id', 'integer', 4, array(
             'type' => 'integer',
             'fixed' => 0,
             'unsigned' => false,
             'primary' => false,
             'notnull' => false,
             'autoincrement' => false,
             'length' => 4,
             ));
        $this->hasColumn('tickets_status_id', 'integer', 4, array(
             'type' => 'integer',
             'fixed' => 0,
             'unsigned' => false,
             'primary' => false,
             'notnull' => false,
             'autoincrement' => false,
             'length' => 4,
             ));
        $this->hasColumn('name', 'string', 255, array(
             'type' => 'string',
             'fixed' => 0,
             'unsigned' => false,
             'primary' => false,
             'default' => '',
             'notnull' => true,
             'autoincrement' => false,
             'length' => 255,
             ));
        $this->hasColumn('description', 'string', null, array(
             'type' => 'string',
             'fixed' => 0,
             'unsigned' => false,
             'primary' => false,
             'notnull' => false,
             'autoincrement' => false,
             'length' => '',
             ));
        $this->hasColumn('users_id', 'integer', 4, array(
             'type' => 'integer',
             'fixed' => 0,
             'unsigned' => false,
             'primary' => false,
             'default' => '0',
             'notnull' => true,
             'autoincrement' => false,
             'length' => 4,
             ));
        $this->hasColumn('projects_id', 'integer', 4, array(
             'type' => 'integer',
             'fixed' => 0,
             'unsigned' => false,
             'primary' => false,
             'default' => '0',
             'notnull' => true,
             'autoincrement' => false,
             'length' => 4,
             ));
        $this->hasColumn('created_at', 'timestamp', 25, array(
             'type' => 'timestamp',
             'fixed' => 0,
             'unsigned' => false,
             'primary' => false,
             'notnull' => false,
             'autoincrement' => false,
             'length' => 25,
             ));
    }

    public function setUp()
    {
        parent::setUp();
        $this->hasOne('TicketsStatus', array(
             'local' => 'tickets_status_id',
             'foreign' => 'id'));

        $this->hasOne('TicketsTypes', array(
             'local' => 'tickets_types_id',
             'foreign' => 'id'));

        $this->hasOne('Users', array(
             'local' => 'users_id',
             'foreign' => 'id'));

        $this->hasOne('Projects', array(
             'local' => 'projects_id',
             'foreign' => 'id'));

        $this->hasOne('Departments', array(
             'local' => 'departments_id',
             'foreign' => 'id'));

        $this->hasMany('Tasks', array(
             'local' => 'id',
             'foreign' => 'tickets_id'));

        $this->hasMany('TicketsComments', array(
             'local' => 'id',
             'foreign' => 'tickets_id'));
    }
}
